package containerservice

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AgentPoolMode enumerates the values for agent pool mode.
type AgentPoolMode string

const (
	// AgentPoolModeSystem System agent pools are primarily for hosting critical system pods such as CoreDNS
	// and metrics-server. System agent pools osType must be Linux. System agent pools VM SKU must have at
	// least 2vCPUs and 4GB of memory.
	AgentPoolModeSystem AgentPoolMode = "System"
	// AgentPoolModeUser User agent pools are primarily for hosting your application pods.
	AgentPoolModeUser AgentPoolMode = "User"
)

// PossibleAgentPoolModeValues returns an array of possible values for the AgentPoolMode const type.
func PossibleAgentPoolModeValues() []AgentPoolMode {
	return []AgentPoolMode{AgentPoolModeSystem, AgentPoolModeUser}
}

// AgentPoolType enumerates the values for agent pool type.
type AgentPoolType string

const (
	// AgentPoolTypeAvailabilitySet Use of this is strongly discouraged.
	AgentPoolTypeAvailabilitySet AgentPoolType = "AvailabilitySet"
	// AgentPoolTypeVirtualMachineScaleSets Create an Agent Pool backed by a Virtual Machine Scale Set.
	AgentPoolTypeVirtualMachineScaleSets AgentPoolType = "VirtualMachineScaleSets"
)

// PossibleAgentPoolTypeValues returns an array of possible values for the AgentPoolType const type.
func PossibleAgentPoolTypeValues() []AgentPoolType {
	return []AgentPoolType{AgentPoolTypeAvailabilitySet, AgentPoolTypeVirtualMachineScaleSets}
}

// Code enumerates the values for code.
type Code string

const (
	// CodeRunning The cluster is running.
	CodeRunning Code = "Running"
	// CodeStopped The cluster is stopped.
	CodeStopped Code = "Stopped"
)

// PossibleCodeValues returns an array of possible values for the Code const type.
func PossibleCodeValues() []Code {
	return []Code{CodeRunning, CodeStopped}
}

// ConnectionStatus enumerates the values for connection status.
type ConnectionStatus string

const (
	// ConnectionStatusApproved ...
	ConnectionStatusApproved ConnectionStatus = "Approved"
	// ConnectionStatusDisconnected ...
	ConnectionStatusDisconnected ConnectionStatus = "Disconnected"
	// ConnectionStatusPending ...
	ConnectionStatusPending ConnectionStatus = "Pending"
	// ConnectionStatusRejected ...
	ConnectionStatusRejected ConnectionStatus = "Rejected"
)

// PossibleConnectionStatusValues returns an array of possible values for the ConnectionStatus const type.
func PossibleConnectionStatusValues() []ConnectionStatus {
	return []ConnectionStatus{ConnectionStatusApproved, ConnectionStatusDisconnected, ConnectionStatusPending, ConnectionStatusRejected}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// Expander enumerates the values for expander.
type Expander string

const (
	// ExpanderLeastWaste Selects the node group that will have the least idle CPU (if tied, unused memory)
	// after scale-up. This is useful when you have different classes of nodes, for example, high CPU or high
	// memory nodes, and only want to expand those when there are pending pods that need a lot of those
	// resources.
	ExpanderLeastWaste Expander = "least-waste"
	// ExpanderMostPods Selects the node group that would be able to schedule the most pods when scaling up.
	// This is useful when you are using nodeSelector to make sure certain pods land on certain nodes. Note
	// that this won't cause the autoscaler to select bigger nodes vs. smaller, as it can add multiple smaller
	// nodes at once.
	ExpanderMostPods Expander = "most-pods"
	// ExpanderPriority Selects the node group that has the highest priority assigned by the user. It's
	// configuration is described in more details
	// [here](https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/expander/priority/readme.md).
	ExpanderPriority Expander = "priority"
	// ExpanderRandom Used when you don't have a particular need for the node groups to scale differently.
	ExpanderRandom Expander = "random"
)

// PossibleExpanderValues returns an array of possible values for the Expander const type.
func PossibleExpanderValues() []Expander {
	return []Expander{ExpanderLeastWaste, ExpanderMostPods, ExpanderPriority, ExpanderRandom}
}

// ExtendedLocationTypes enumerates the values for extended location types.
type ExtendedLocationTypes string

const (
	// ExtendedLocationTypesEdgeZone ...
	ExtendedLocationTypesEdgeZone ExtendedLocationTypes = "EdgeZone"
)

// PossibleExtendedLocationTypesValues returns an array of possible values for the ExtendedLocationTypes const type.
func PossibleExtendedLocationTypesValues() []ExtendedLocationTypes {
	return []ExtendedLocationTypes{ExtendedLocationTypesEdgeZone}
}

// Format enumerates the values for format.
type Format string

const (
	// FormatAzure Return azure auth-provider kubeconfig. This format is deprecated in 1.22 and will be fully
	// removed in 1.25.
	FormatAzure Format = "azure"
	// FormatExec Return exec format kubeconfig. This format requires kubelogin binary in the path.
	FormatExec Format = "exec"
)

// PossibleFormatValues returns an array of possible values for the Format const type.
func PossibleFormatValues() []Format {
	return []Format{FormatAzure, FormatExec}
}

// GPUInstanceProfile enumerates the values for gpu instance profile.
type GPUInstanceProfile string

const (
	// GPUInstanceProfileMIG1g ...
	GPUInstanceProfileMIG1g GPUInstanceProfile = "MIG1g"
	// GPUInstanceProfileMIG2g ...
	GPUInstanceProfileMIG2g GPUInstanceProfile = "MIG2g"
	// GPUInstanceProfileMIG3g ...
	GPUInstanceProfileMIG3g GPUInstanceProfile = "MIG3g"
	// GPUInstanceProfileMIG4g ...
	GPUInstanceProfileMIG4g GPUInstanceProfile = "MIG4g"
	// GPUInstanceProfileMIG7g ...
	GPUInstanceProfileMIG7g GPUInstanceProfile = "MIG7g"
)

// PossibleGPUInstanceProfileValues returns an array of possible values for the GPUInstanceProfile const type.
func PossibleGPUInstanceProfileValues() []GPUInstanceProfile {
	return []GPUInstanceProfile{GPUInstanceProfileMIG1g, GPUInstanceProfileMIG2g, GPUInstanceProfileMIG3g, GPUInstanceProfileMIG4g, GPUInstanceProfileMIG7g}
}

// IPFamily enumerates the values for ip family.
type IPFamily string

const (
	// IPFamilyIPv4 ...
	IPFamilyIPv4 IPFamily = "IPv4"
	// IPFamilyIPv6 ...
	IPFamilyIPv6 IPFamily = "IPv6"
)

// PossibleIPFamilyValues returns an array of possible values for the IPFamily const type.
func PossibleIPFamilyValues() []IPFamily {
	return []IPFamily{IPFamilyIPv4, IPFamilyIPv6}
}

// KubeletDiskType enumerates the values for kubelet disk type.
type KubeletDiskType string

const (
	// KubeletDiskTypeOS Kubelet will use the OS disk for its data.
	KubeletDiskTypeOS KubeletDiskType = "OS"
	// KubeletDiskTypeTemporary Kubelet will use the temporary disk for its data.
	KubeletDiskTypeTemporary KubeletDiskType = "Temporary"
)

// PossibleKubeletDiskTypeValues returns an array of possible values for the KubeletDiskType const type.
func PossibleKubeletDiskTypeValues() []KubeletDiskType {
	return []KubeletDiskType{KubeletDiskTypeOS, KubeletDiskTypeTemporary}
}

// LicenseType enumerates the values for license type.
type LicenseType string

const (
	// LicenseTypeNone No additional licensing is applied.
	LicenseTypeNone LicenseType = "None"
	// LicenseTypeWindowsServer Enables Azure Hybrid User Benefits for Windows VMs.
	LicenseTypeWindowsServer LicenseType = "Windows_Server"
)

// PossibleLicenseTypeValues returns an array of possible values for the LicenseType const type.
func PossibleLicenseTypeValues() []LicenseType {
	return []LicenseType{LicenseTypeNone, LicenseTypeWindowsServer}
}

// LoadBalancerSku enumerates the values for load balancer sku.
type LoadBalancerSku string

const (
	// LoadBalancerSkuBasic Use a basic Load Balancer with limited functionality.
	LoadBalancerSkuBasic LoadBalancerSku = "basic"
	// LoadBalancerSkuStandard Use a a standard Load Balancer. This is the recommended Load Balancer SKU. For
	// more information about on working with the load balancer in the managed cluster, see the [standard Load
	// Balancer](https://docs.microsoft.com/azure/aks/load-balancer-standard) article.
	LoadBalancerSkuStandard LoadBalancerSku = "standard"
)

// PossibleLoadBalancerSkuValues returns an array of possible values for the LoadBalancerSku const type.
func PossibleLoadBalancerSkuValues() []LoadBalancerSku {
	return []LoadBalancerSku{LoadBalancerSkuBasic, LoadBalancerSkuStandard}
}

// ManagedClusterPodIdentityProvisioningState enumerates the values for managed cluster pod identity
// provisioning state.
type ManagedClusterPodIdentityProvisioningState string

const (
	// ManagedClusterPodIdentityProvisioningStateAssigned ...
	ManagedClusterPodIdentityProvisioningStateAssigned ManagedClusterPodIdentityProvisioningState = "Assigned"
	// ManagedClusterPodIdentityProvisioningStateDeleting ...
	ManagedClusterPodIdentityProvisioningStateDeleting ManagedClusterPodIdentityProvisioningState = "Deleting"
	// ManagedClusterPodIdentityProvisioningStateFailed ...
	ManagedClusterPodIdentityProvisioningStateFailed ManagedClusterPodIdentityProvisioningState = "Failed"
	// ManagedClusterPodIdentityProvisioningStateUpdating ...
	ManagedClusterPodIdentityProvisioningStateUpdating ManagedClusterPodIdentityProvisioningState = "Updating"
)

// PossibleManagedClusterPodIdentityProvisioningStateValues returns an array of possible values for the ManagedClusterPodIdentityProvisioningState const type.
func PossibleManagedClusterPodIdentityProvisioningStateValues() []ManagedClusterPodIdentityProvisioningState {
	return []ManagedClusterPodIdentityProvisioningState{ManagedClusterPodIdentityProvisioningStateAssigned, ManagedClusterPodIdentityProvisioningStateDeleting, ManagedClusterPodIdentityProvisioningStateFailed, ManagedClusterPodIdentityProvisioningStateUpdating}
}

// ManagedClusterSKUName enumerates the values for managed cluster sku name.
type ManagedClusterSKUName string

const (
	// ManagedClusterSKUNameBasic ...
	ManagedClusterSKUNameBasic ManagedClusterSKUName = "Basic"
)

// PossibleManagedClusterSKUNameValues returns an array of possible values for the ManagedClusterSKUName const type.
func PossibleManagedClusterSKUNameValues() []ManagedClusterSKUName {
	return []ManagedClusterSKUName{ManagedClusterSKUNameBasic}
}

// ManagedClusterSKUTier enumerates the values for managed cluster sku tier.
type ManagedClusterSKUTier string

const (
	// ManagedClusterSKUTierFree No guaranteed SLA, no additional charges. Free tier clusters have an SLO of
	// 99.5%.
	ManagedClusterSKUTierFree ManagedClusterSKUTier = "Free"
	// ManagedClusterSKUTierPaid Guarantees 99.95% availability of the Kubernetes API server endpoint for
	// clusters that use Availability Zones and 99.9% of availability for clusters that don't use Availability
	// Zones.
	ManagedClusterSKUTierPaid ManagedClusterSKUTier = "Paid"
)

// PossibleManagedClusterSKUTierValues returns an array of possible values for the ManagedClusterSKUTier const type.
func PossibleManagedClusterSKUTierValues() []ManagedClusterSKUTier {
	return []ManagedClusterSKUTier{ManagedClusterSKUTierFree, ManagedClusterSKUTierPaid}
}

// NetworkMode enumerates the values for network mode.
type NetworkMode string

const (
	// NetworkModeBridge This is no longer supported
	NetworkModeBridge NetworkMode = "bridge"
	// NetworkModeTransparent No bridge is created. Intra-VM Pod to Pod communication is through IP routes
	// created by Azure CNI. See [Transparent Mode](https://docs.microsoft.com/azure/aks/faq#transparent-mode)
	// for more information.
	NetworkModeTransparent NetworkMode = "transparent"
)

// PossibleNetworkModeValues returns an array of possible values for the NetworkMode const type.
func PossibleNetworkModeValues() []NetworkMode {
	return []NetworkMode{NetworkModeBridge, NetworkModeTransparent}
}

// NetworkPlugin enumerates the values for network plugin.
type NetworkPlugin string

const (
	// NetworkPluginAzure Use the Azure CNI network plugin. See [Azure CNI (advanced)
	// networking](https://docs.microsoft.com/azure/aks/concepts-network#azure-cni-advanced-networking) for
	// more information.
	NetworkPluginAzure NetworkPlugin = "azure"
	// NetworkPluginKubenet Use the Kubenet network plugin. See [Kubenet (basic)
	// networking](https://docs.microsoft.com/azure/aks/concepts-network#kubenet-basic-networking) for more
	// information.
	NetworkPluginKubenet NetworkPlugin = "kubenet"
	// NetworkPluginNone Do not use a network plugin. A custom CNI will need to be installed after cluster
	// creation for networking functionality.
	NetworkPluginNone NetworkPlugin = "none"
)

// PossibleNetworkPluginValues returns an array of possible values for the NetworkPlugin const type.
func PossibleNetworkPluginValues() []NetworkPlugin {
	return []NetworkPlugin{NetworkPluginAzure, NetworkPluginKubenet, NetworkPluginNone}
}

// NetworkPolicy enumerates the values for network policy.
type NetworkPolicy string

const (
	// NetworkPolicyAzure Use Azure network policies. See [differences between Azure and Calico
	// policies](https://docs.microsoft.com/azure/aks/use-network-policies#differences-between-azure-and-calico-policies-and-their-capabilities)
	// for more information.
	NetworkPolicyAzure NetworkPolicy = "azure"
	// NetworkPolicyCalico Use Calico network policies. See [differences between Azure and Calico
	// policies](https://docs.microsoft.com/azure/aks/use-network-policies#differences-between-azure-and-calico-policies-and-their-capabilities)
	// for more information.
	NetworkPolicyCalico NetworkPolicy = "calico"
)

// PossibleNetworkPolicyValues returns an array of possible values for the NetworkPolicy const type.
func PossibleNetworkPolicyValues() []NetworkPolicy {
	return []NetworkPolicy{NetworkPolicyAzure, NetworkPolicyCalico}
}

// OSDiskType enumerates the values for os disk type.
type OSDiskType string

const (
	// OSDiskTypeEphemeral Ephemeral OS disks are stored only on the host machine, just like a temporary disk.
	// This provides lower read/write latency, along with faster node scaling and cluster upgrades.
	OSDiskTypeEphemeral OSDiskType = "Ephemeral"
	// OSDiskTypeManaged Azure replicates the operating system disk for a virtual machine to Azure storage to
	// avoid data loss should the VM need to be relocated to another host. Since containers aren't designed to
	// have local state persisted, this behavior offers limited value while providing some drawbacks, including
	// slower node provisioning and higher read/write latency.
	OSDiskTypeManaged OSDiskType = "Managed"
)

// PossibleOSDiskTypeValues returns an array of possible values for the OSDiskType const type.
func PossibleOSDiskTypeValues() []OSDiskType {
	return []OSDiskType{OSDiskTypeEphemeral, OSDiskTypeManaged}
}

// OSSKU enumerates the values for ossku.
type OSSKU string

const (
	// OSSKUCBLMariner ...
	OSSKUCBLMariner OSSKU = "CBLMariner"
	// OSSKUUbuntu ...
	OSSKUUbuntu OSSKU = "Ubuntu"
)

// PossibleOSSKUValues returns an array of possible values for the OSSKU const type.
func PossibleOSSKUValues() []OSSKU {
	return []OSSKU{OSSKUCBLMariner, OSSKUUbuntu}
}

// OSType enumerates the values for os type.
type OSType string

const (
	// OSTypeLinux Use Linux.
	OSTypeLinux OSType = "Linux"
	// OSTypeWindows Use Windows.
	OSTypeWindows OSType = "Windows"
)

// PossibleOSTypeValues returns an array of possible values for the OSType const type.
func PossibleOSTypeValues() []OSType {
	return []OSType{OSTypeLinux, OSTypeWindows}
}

// OutboundType enumerates the values for outbound type.
type OutboundType string

const (
	// OutboundTypeLoadBalancer The load balancer is used for egress through an AKS assigned public IP. This
	// supports Kubernetes services of type 'loadBalancer'. For more information see [outbound type
	// loadbalancer](https://docs.microsoft.com/azure/aks/egress-outboundtype#outbound-type-of-loadbalancer).
	OutboundTypeLoadBalancer OutboundType = "loadBalancer"
	// OutboundTypeManagedNATGateway The AKS-managed NAT gateway is used for egress.
	OutboundTypeManagedNATGateway OutboundType = "managedNATGateway"
	// OutboundTypeUserAssignedNATGateway The user-assigned NAT gateway associated to the cluster subnet is
	// used for egress. This is an advanced scenario and requires proper network configuration.
	OutboundTypeUserAssignedNATGateway OutboundType = "userAssignedNATGateway"
	// OutboundTypeUserDefinedRouting Egress paths must be defined by the user. This is an advanced scenario
	// and requires proper network configuration. For more information see [outbound type
	// userDefinedRouting](https://docs.microsoft.com/azure/aks/egress-outboundtype#outbound-type-of-userdefinedrouting).
	OutboundTypeUserDefinedRouting OutboundType = "userDefinedRouting"
)

// PossibleOutboundTypeValues returns an array of possible values for the OutboundType const type.
func PossibleOutboundTypeValues() []OutboundType {
	return []OutboundType{OutboundTypeLoadBalancer, OutboundTypeManagedNATGateway, OutboundTypeUserAssignedNATGateway, OutboundTypeUserDefinedRouting}
}

// PrivateEndpointConnectionProvisioningState enumerates the values for private endpoint connection
// provisioning state.
type PrivateEndpointConnectionProvisioningState string

const (
	// PrivateEndpointConnectionProvisioningStateCreating ...
	PrivateEndpointConnectionProvisioningStateCreating PrivateEndpointConnectionProvisioningState = "Creating"
	// PrivateEndpointConnectionProvisioningStateDeleting ...
	PrivateEndpointConnectionProvisioningStateDeleting PrivateEndpointConnectionProvisioningState = "Deleting"
	// PrivateEndpointConnectionProvisioningStateFailed ...
	PrivateEndpointConnectionProvisioningStateFailed PrivateEndpointConnectionProvisioningState = "Failed"
	// PrivateEndpointConnectionProvisioningStateSucceeded ...
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = "Succeeded"
)

// PossiblePrivateEndpointConnectionProvisioningStateValues returns an array of possible values for the PrivateEndpointConnectionProvisioningState const type.
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return []PrivateEndpointConnectionProvisioningState{PrivateEndpointConnectionProvisioningStateCreating, PrivateEndpointConnectionProvisioningStateDeleting, PrivateEndpointConnectionProvisioningStateFailed, PrivateEndpointConnectionProvisioningStateSucceeded}
}

// PublicNetworkAccess enumerates the values for public network access.
type PublicNetworkAccess string

const (
	// PublicNetworkAccessDisabled ...
	PublicNetworkAccessDisabled PublicNetworkAccess = "Disabled"
	// PublicNetworkAccessEnabled ...
	PublicNetworkAccessEnabled PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns an array of possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{PublicNetworkAccessDisabled, PublicNetworkAccessEnabled}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone Do not use a managed identity for the Managed Cluster, service principal will
	// be used instead.
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned Use an implicitly created system assigned managed identity to manage
	// cluster resources. Master components in the control plane such as kube-controller-manager will use the
	// system assigned managed identity to manipulate Azure resources.
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
	// ResourceIdentityTypeUserAssigned Use a user-specified identity to manage cluster resources. Master
	// components in the control plane such as kube-controller-manager will use the specified user assigned
	// managed identity to manipulate Azure resources.
	ResourceIdentityTypeUserAssigned ResourceIdentityType = "UserAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned, ResourceIdentityTypeUserAssigned}
}

// ScaleDownMode enumerates the values for scale down mode.
type ScaleDownMode string

const (
	// ScaleDownModeDeallocate Attempt to start deallocated instances (if they exist) during scale up and
	// deallocate instances during scale down.
	ScaleDownModeDeallocate ScaleDownMode = "Deallocate"
	// ScaleDownModeDelete Create new instances during scale up and remove instances during scale down.
	ScaleDownModeDelete ScaleDownMode = "Delete"
)

// PossibleScaleDownModeValues returns an array of possible values for the ScaleDownMode const type.
func PossibleScaleDownModeValues() []ScaleDownMode {
	return []ScaleDownMode{ScaleDownModeDeallocate, ScaleDownModeDelete}
}

// ScaleSetEvictionPolicy enumerates the values for scale set eviction policy.
type ScaleSetEvictionPolicy string

const (
	// ScaleSetEvictionPolicyDeallocate Nodes in the underlying Scale Set of the node pool are set to the
	// stopped-deallocated state upon eviction. Nodes in the stopped-deallocated state count against your
	// compute quota and can cause issues with cluster scaling or upgrading.
	ScaleSetEvictionPolicyDeallocate ScaleSetEvictionPolicy = "Deallocate"
	// ScaleSetEvictionPolicyDelete Nodes in the underlying Scale Set of the node pool are deleted when they're
	// evicted.
	ScaleSetEvictionPolicyDelete ScaleSetEvictionPolicy = "Delete"
)

// PossibleScaleSetEvictionPolicyValues returns an array of possible values for the ScaleSetEvictionPolicy const type.
func PossibleScaleSetEvictionPolicyValues() []ScaleSetEvictionPolicy {
	return []ScaleSetEvictionPolicy{ScaleSetEvictionPolicyDeallocate, ScaleSetEvictionPolicyDelete}
}

// ScaleSetPriority enumerates the values for scale set priority.
type ScaleSetPriority string

const (
	// ScaleSetPriorityRegular Regular VMs will be used.
	ScaleSetPriorityRegular ScaleSetPriority = "Regular"
	// ScaleSetPrioritySpot Spot priority VMs will be used. There is no SLA for spot nodes. See [spot on
	// AKS](https://docs.microsoft.com/azure/aks/spot-node-pool) for more information.
	ScaleSetPrioritySpot ScaleSetPriority = "Spot"
)

// PossibleScaleSetPriorityValues returns an array of possible values for the ScaleSetPriority const type.
func PossibleScaleSetPriorityValues() []ScaleSetPriority {
	return []ScaleSetPriority{ScaleSetPriorityRegular, ScaleSetPrioritySpot}
}

// SnapshotType enumerates the values for snapshot type.
type SnapshotType string

const (
	// SnapshotTypeManagedCluster The snapshot is a snapshot of a managed cluster.
	SnapshotTypeManagedCluster SnapshotType = "ManagedCluster"
	// SnapshotTypeNodePool The snapshot is a snapshot of a node pool.
	SnapshotTypeNodePool SnapshotType = "NodePool"
)

// PossibleSnapshotTypeValues returns an array of possible values for the SnapshotType const type.
func PossibleSnapshotTypeValues() []SnapshotType {
	return []SnapshotType{SnapshotTypeManagedCluster, SnapshotTypeNodePool}
}

// StorageProfileTypes enumerates the values for storage profile types.
type StorageProfileTypes string

const (
	// StorageProfileTypesManagedDisks ...
	StorageProfileTypesManagedDisks StorageProfileTypes = "ManagedDisks"
	// StorageProfileTypesStorageAccount ...
	StorageProfileTypesStorageAccount StorageProfileTypes = "StorageAccount"
)

// PossibleStorageProfileTypesValues returns an array of possible values for the StorageProfileTypes const type.
func PossibleStorageProfileTypesValues() []StorageProfileTypes {
	return []StorageProfileTypes{StorageProfileTypesManagedDisks, StorageProfileTypesStorageAccount}
}

// UpgradeChannel enumerates the values for upgrade channel.
type UpgradeChannel string

const (
	// UpgradeChannelNodeImage Automatically upgrade the node image to the latest version available. Microsoft
	// provides patches and new images for image nodes frequently (usually weekly), but your running nodes
	// won't get the new images unless you do a node image upgrade. Turning on the node-image channel will
	// automatically update your node images whenever a new version is available.
	UpgradeChannelNodeImage UpgradeChannel = "node-image"
	// UpgradeChannelNone Disables auto-upgrades and keeps the cluster at its current version of Kubernetes.
	UpgradeChannelNone UpgradeChannel = "none"
	// UpgradeChannelPatch Automatically upgrade the cluster to the latest supported patch version when it
	// becomes available while keeping the minor version the same. For example, if a cluster is running version
	// 1.17.7 and versions 1.17.9, 1.18.4, 1.18.6, and 1.19.1 are available, your cluster is upgraded to
	// 1.17.9.
	UpgradeChannelPatch UpgradeChannel = "patch"
	// UpgradeChannelRapid Automatically upgrade the cluster to the latest supported patch release on the
	// latest supported minor version. In cases where the cluster is at a version of Kubernetes that is at an
	// N-2 minor version where N is the latest supported minor version, the cluster first upgrades to the
	// latest supported patch version on N-1 minor version. For example, if a cluster is running version 1.17.7
	// and versions 1.17.9, 1.18.4, 1.18.6, and 1.19.1 are available, your cluster first is upgraded to 1.18.6,
	// then is upgraded to 1.19.1.
	UpgradeChannelRapid UpgradeChannel = "rapid"
	// UpgradeChannelStable Automatically upgrade the cluster to the latest supported patch release on minor
	// version N-1, where N is the latest supported minor version. For example, if a cluster is running version
	// 1.17.7 and versions 1.17.9, 1.18.4, 1.18.6, and 1.19.1 are available, your cluster is upgraded to
	// 1.18.6.
	UpgradeChannelStable UpgradeChannel = "stable"
)

// PossibleUpgradeChannelValues returns an array of possible values for the UpgradeChannel const type.
func PossibleUpgradeChannelValues() []UpgradeChannel {
	return []UpgradeChannel{UpgradeChannelNodeImage, UpgradeChannelNone, UpgradeChannelPatch, UpgradeChannelRapid, UpgradeChannelStable}
}

// VMSizeTypes enumerates the values for vm size types.
type VMSizeTypes string

const (
	// VMSizeTypesStandardA1 ...
	VMSizeTypesStandardA1 VMSizeTypes = "Standard_A1"
	// VMSizeTypesStandardA10 ...
	VMSizeTypesStandardA10 VMSizeTypes = "Standard_A10"
	// VMSizeTypesStandardA11 ...
	VMSizeTypesStandardA11 VMSizeTypes = "Standard_A11"
	// VMSizeTypesStandardA1V2 ...
	VMSizeTypesStandardA1V2 VMSizeTypes = "Standard_A1_v2"
	// VMSizeTypesStandardA2 ...
	VMSizeTypesStandardA2 VMSizeTypes = "Standard_A2"
	// VMSizeTypesStandardA2mV2 ...
	VMSizeTypesStandardA2mV2 VMSizeTypes = "Standard_A2m_v2"
	// VMSizeTypesStandardA2V2 ...
	VMSizeTypesStandardA2V2 VMSizeTypes = "Standard_A2_v2"
	// VMSizeTypesStandardA3 ...
	VMSizeTypesStandardA3 VMSizeTypes = "Standard_A3"
	// VMSizeTypesStandardA4 ...
	VMSizeTypesStandardA4 VMSizeTypes = "Standard_A4"
	// VMSizeTypesStandardA4mV2 ...
	VMSizeTypesStandardA4mV2 VMSizeTypes = "Standard_A4m_v2"
	// VMSizeTypesStandardA4V2 ...
	VMSizeTypesStandardA4V2 VMSizeTypes = "Standard_A4_v2"
	// VMSizeTypesStandardA5 ...
	VMSizeTypesStandardA5 VMSizeTypes = "Standard_A5"
	// VMSizeTypesStandardA6 ...
	VMSizeTypesStandardA6 VMSizeTypes = "Standard_A6"
	// VMSizeTypesStandardA7 ...
	VMSizeTypesStandardA7 VMSizeTypes = "Standard_A7"
	// VMSizeTypesStandardA8 ...
	VMSizeTypesStandardA8 VMSizeTypes = "Standard_A8"
	// VMSizeTypesStandardA8mV2 ...
	VMSizeTypesStandardA8mV2 VMSizeTypes = "Standard_A8m_v2"
	// VMSizeTypesStandardA8V2 ...
	VMSizeTypesStandardA8V2 VMSizeTypes = "Standard_A8_v2"
	// VMSizeTypesStandardA9 ...
	VMSizeTypesStandardA9 VMSizeTypes = "Standard_A9"
	// VMSizeTypesStandardB2ms ...
	VMSizeTypesStandardB2ms VMSizeTypes = "Standard_B2ms"
	// VMSizeTypesStandardB2s ...
	VMSizeTypesStandardB2s VMSizeTypes = "Standard_B2s"
	// VMSizeTypesStandardB4ms ...
	VMSizeTypesStandardB4ms VMSizeTypes = "Standard_B4ms"
	// VMSizeTypesStandardB8ms ...
	VMSizeTypesStandardB8ms VMSizeTypes = "Standard_B8ms"
	// VMSizeTypesStandardD1 ...
	VMSizeTypesStandardD1 VMSizeTypes = "Standard_D1"
	// VMSizeTypesStandardD11 ...
	VMSizeTypesStandardD11 VMSizeTypes = "Standard_D11"
	// VMSizeTypesStandardD11V2 ...
	VMSizeTypesStandardD11V2 VMSizeTypes = "Standard_D11_v2"
	// VMSizeTypesStandardD11V2Promo ...
	VMSizeTypesStandardD11V2Promo VMSizeTypes = "Standard_D11_v2_Promo"
	// VMSizeTypesStandardD12 ...
	VMSizeTypesStandardD12 VMSizeTypes = "Standard_D12"
	// VMSizeTypesStandardD12V2 ...
	VMSizeTypesStandardD12V2 VMSizeTypes = "Standard_D12_v2"
	// VMSizeTypesStandardD12V2Promo ...
	VMSizeTypesStandardD12V2Promo VMSizeTypes = "Standard_D12_v2_Promo"
	// VMSizeTypesStandardD13 ...
	VMSizeTypesStandardD13 VMSizeTypes = "Standard_D13"
	// VMSizeTypesStandardD13V2 ...
	VMSizeTypesStandardD13V2 VMSizeTypes = "Standard_D13_v2"
	// VMSizeTypesStandardD13V2Promo ...
	VMSizeTypesStandardD13V2Promo VMSizeTypes = "Standard_D13_v2_Promo"
	// VMSizeTypesStandardD14 ...
	VMSizeTypesStandardD14 VMSizeTypes = "Standard_D14"
	// VMSizeTypesStandardD14V2 ...
	VMSizeTypesStandardD14V2 VMSizeTypes = "Standard_D14_v2"
	// VMSizeTypesStandardD14V2Promo ...
	VMSizeTypesStandardD14V2Promo VMSizeTypes = "Standard_D14_v2_Promo"
	// VMSizeTypesStandardD15V2 ...
	VMSizeTypesStandardD15V2 VMSizeTypes = "Standard_D15_v2"
	// VMSizeTypesStandardD16sV3 ...
	VMSizeTypesStandardD16sV3 VMSizeTypes = "Standard_D16s_v3"
	// VMSizeTypesStandardD16V3 ...
	VMSizeTypesStandardD16V3 VMSizeTypes = "Standard_D16_v3"
	// VMSizeTypesStandardD1V2 ...
	VMSizeTypesStandardD1V2 VMSizeTypes = "Standard_D1_v2"
	// VMSizeTypesStandardD2 ...
	VMSizeTypesStandardD2 VMSizeTypes = "Standard_D2"
	// VMSizeTypesStandardD2sV3 ...
	VMSizeTypesStandardD2sV3 VMSizeTypes = "Standard_D2s_v3"
	// VMSizeTypesStandardD2V2 ...
	VMSizeTypesStandardD2V2 VMSizeTypes = "Standard_D2_v2"
	// VMSizeTypesStandardD2V2Promo ...
	VMSizeTypesStandardD2V2Promo VMSizeTypes = "Standard_D2_v2_Promo"
	// VMSizeTypesStandardD2V3 ...
	VMSizeTypesStandardD2V3 VMSizeTypes = "Standard_D2_v3"
	// VMSizeTypesStandardD3 ...
	VMSizeTypesStandardD3 VMSizeTypes = "Standard_D3"
	// VMSizeTypesStandardD32sV3 ...
	VMSizeTypesStandardD32sV3 VMSizeTypes = "Standard_D32s_v3"
	// VMSizeTypesStandardD32V3 ...
	VMSizeTypesStandardD32V3 VMSizeTypes = "Standard_D32_v3"
	// VMSizeTypesStandardD3V2 ...
	VMSizeTypesStandardD3V2 VMSizeTypes = "Standard_D3_v2"
	// VMSizeTypesStandardD3V2Promo ...
	VMSizeTypesStandardD3V2Promo VMSizeTypes = "Standard_D3_v2_Promo"
	// VMSizeTypesStandardD4 ...
	VMSizeTypesStandardD4 VMSizeTypes = "Standard_D4"
	// VMSizeTypesStandardD4sV3 ...
	VMSizeTypesStandardD4sV3 VMSizeTypes = "Standard_D4s_v3"
	// VMSizeTypesStandardD4V2 ...
	VMSizeTypesStandardD4V2 VMSizeTypes = "Standard_D4_v2"
	// VMSizeTypesStandardD4V2Promo ...
	VMSizeTypesStandardD4V2Promo VMSizeTypes = "Standard_D4_v2_Promo"
	// VMSizeTypesStandardD4V3 ...
	VMSizeTypesStandardD4V3 VMSizeTypes = "Standard_D4_v3"
	// VMSizeTypesStandardD5V2 ...
	VMSizeTypesStandardD5V2 VMSizeTypes = "Standard_D5_v2"
	// VMSizeTypesStandardD5V2Promo ...
	VMSizeTypesStandardD5V2Promo VMSizeTypes = "Standard_D5_v2_Promo"
	// VMSizeTypesStandardD64sV3 ...
	VMSizeTypesStandardD64sV3 VMSizeTypes = "Standard_D64s_v3"
	// VMSizeTypesStandardD64V3 ...
	VMSizeTypesStandardD64V3 VMSizeTypes = "Standard_D64_v3"
	// VMSizeTypesStandardD8sV3 ...
	VMSizeTypesStandardD8sV3 VMSizeTypes = "Standard_D8s_v3"
	// VMSizeTypesStandardD8V3 ...
	VMSizeTypesStandardD8V3 VMSizeTypes = "Standard_D8_v3"
	// VMSizeTypesStandardDS1 ...
	VMSizeTypesStandardDS1 VMSizeTypes = "Standard_DS1"
	// VMSizeTypesStandardDS11 ...
	VMSizeTypesStandardDS11 VMSizeTypes = "Standard_DS11"
	// VMSizeTypesStandardDS11V2 ...
	VMSizeTypesStandardDS11V2 VMSizeTypes = "Standard_DS11_v2"
	// VMSizeTypesStandardDS11V2Promo ...
	VMSizeTypesStandardDS11V2Promo VMSizeTypes = "Standard_DS11_v2_Promo"
	// VMSizeTypesStandardDS12 ...
	VMSizeTypesStandardDS12 VMSizeTypes = "Standard_DS12"
	// VMSizeTypesStandardDS12V2 ...
	VMSizeTypesStandardDS12V2 VMSizeTypes = "Standard_DS12_v2"
	// VMSizeTypesStandardDS12V2Promo ...
	VMSizeTypesStandardDS12V2Promo VMSizeTypes = "Standard_DS12_v2_Promo"
	// VMSizeTypesStandardDS13 ...
	VMSizeTypesStandardDS13 VMSizeTypes = "Standard_DS13"
	// VMSizeTypesStandardDS132V2 ...
	VMSizeTypesStandardDS132V2 VMSizeTypes = "Standard_DS13-2_v2"
	// VMSizeTypesStandardDS134V2 ...
	VMSizeTypesStandardDS134V2 VMSizeTypes = "Standard_DS13-4_v2"
	// VMSizeTypesStandardDS13V2 ...
	VMSizeTypesStandardDS13V2 VMSizeTypes = "Standard_DS13_v2"
	// VMSizeTypesStandardDS13V2Promo ...
	VMSizeTypesStandardDS13V2Promo VMSizeTypes = "Standard_DS13_v2_Promo"
	// VMSizeTypesStandardDS14 ...
	VMSizeTypesStandardDS14 VMSizeTypes = "Standard_DS14"
	// VMSizeTypesStandardDS144V2 ...
	VMSizeTypesStandardDS144V2 VMSizeTypes = "Standard_DS14-4_v2"
	// VMSizeTypesStandardDS148V2 ...
	VMSizeTypesStandardDS148V2 VMSizeTypes = "Standard_DS14-8_v2"
	// VMSizeTypesStandardDS14V2 ...
	VMSizeTypesStandardDS14V2 VMSizeTypes = "Standard_DS14_v2"
	// VMSizeTypesStandardDS14V2Promo ...
	VMSizeTypesStandardDS14V2Promo VMSizeTypes = "Standard_DS14_v2_Promo"
	// VMSizeTypesStandardDS15V2 ...
	VMSizeTypesStandardDS15V2 VMSizeTypes = "Standard_DS15_v2"
	// VMSizeTypesStandardDS1V2 ...
	VMSizeTypesStandardDS1V2 VMSizeTypes = "Standard_DS1_v2"
	// VMSizeTypesStandardDS2 ...
	VMSizeTypesStandardDS2 VMSizeTypes = "Standard_DS2"
	// VMSizeTypesStandardDS2V2 ...
	VMSizeTypesStandardDS2V2 VMSizeTypes = "Standard_DS2_v2"
	// VMSizeTypesStandardDS2V2Promo ...
	VMSizeTypesStandardDS2V2Promo VMSizeTypes = "Standard_DS2_v2_Promo"
	// VMSizeTypesStandardDS3 ...
	VMSizeTypesStandardDS3 VMSizeTypes = "Standard_DS3"
	// VMSizeTypesStandardDS3V2 ...
	VMSizeTypesStandardDS3V2 VMSizeTypes = "Standard_DS3_v2"
	// VMSizeTypesStandardDS3V2Promo ...
	VMSizeTypesStandardDS3V2Promo VMSizeTypes = "Standard_DS3_v2_Promo"
	// VMSizeTypesStandardDS4 ...
	VMSizeTypesStandardDS4 VMSizeTypes = "Standard_DS4"
	// VMSizeTypesStandardDS4V2 ...
	VMSizeTypesStandardDS4V2 VMSizeTypes = "Standard_DS4_v2"
	// VMSizeTypesStandardDS4V2Promo ...
	VMSizeTypesStandardDS4V2Promo VMSizeTypes = "Standard_DS4_v2_Promo"
	// VMSizeTypesStandardDS5V2 ...
	VMSizeTypesStandardDS5V2 VMSizeTypes = "Standard_DS5_v2"
	// VMSizeTypesStandardDS5V2Promo ...
	VMSizeTypesStandardDS5V2Promo VMSizeTypes = "Standard_DS5_v2_Promo"
	// VMSizeTypesStandardE16sV3 ...
	VMSizeTypesStandardE16sV3 VMSizeTypes = "Standard_E16s_v3"
	// VMSizeTypesStandardE16V3 ...
	VMSizeTypesStandardE16V3 VMSizeTypes = "Standard_E16_v3"
	// VMSizeTypesStandardE2sV3 ...
	VMSizeTypesStandardE2sV3 VMSizeTypes = "Standard_E2s_v3"
	// VMSizeTypesStandardE2V3 ...
	VMSizeTypesStandardE2V3 VMSizeTypes = "Standard_E2_v3"
	// VMSizeTypesStandardE3216sV3 ...
	VMSizeTypesStandardE3216sV3 VMSizeTypes = "Standard_E32-16s_v3"
	// VMSizeTypesStandardE328sV3 ...
	VMSizeTypesStandardE328sV3 VMSizeTypes = "Standard_E32-8s_v3"
	// VMSizeTypesStandardE32sV3 ...
	VMSizeTypesStandardE32sV3 VMSizeTypes = "Standard_E32s_v3"
	// VMSizeTypesStandardE32V3 ...
	VMSizeTypesStandardE32V3 VMSizeTypes = "Standard_E32_v3"
	// VMSizeTypesStandardE4sV3 ...
	VMSizeTypesStandardE4sV3 VMSizeTypes = "Standard_E4s_v3"
	// VMSizeTypesStandardE4V3 ...
	VMSizeTypesStandardE4V3 VMSizeTypes = "Standard_E4_v3"
	// VMSizeTypesStandardE6416sV3 ...
	VMSizeTypesStandardE6416sV3 VMSizeTypes = "Standard_E64-16s_v3"
	// VMSizeTypesStandardE6432sV3 ...
	VMSizeTypesStandardE6432sV3 VMSizeTypes = "Standard_E64-32s_v3"
	// VMSizeTypesStandardE64sV3 ...
	VMSizeTypesStandardE64sV3 VMSizeTypes = "Standard_E64s_v3"
	// VMSizeTypesStandardE64V3 ...
	VMSizeTypesStandardE64V3 VMSizeTypes = "Standard_E64_v3"
	// VMSizeTypesStandardE8sV3 ...
	VMSizeTypesStandardE8sV3 VMSizeTypes = "Standard_E8s_v3"
	// VMSizeTypesStandardE8V3 ...
	VMSizeTypesStandardE8V3 VMSizeTypes = "Standard_E8_v3"
	// VMSizeTypesStandardF1 ...
	VMSizeTypesStandardF1 VMSizeTypes = "Standard_F1"
	// VMSizeTypesStandardF16 ...
	VMSizeTypesStandardF16 VMSizeTypes = "Standard_F16"
	// VMSizeTypesStandardF16s ...
	VMSizeTypesStandardF16s VMSizeTypes = "Standard_F16s"
	// VMSizeTypesStandardF16sV2 ...
	VMSizeTypesStandardF16sV2 VMSizeTypes = "Standard_F16s_v2"
	// VMSizeTypesStandardF1s ...
	VMSizeTypesStandardF1s VMSizeTypes = "Standard_F1s"
	// VMSizeTypesStandardF2 ...
	VMSizeTypesStandardF2 VMSizeTypes = "Standard_F2"
	// VMSizeTypesStandardF2s ...
	VMSizeTypesStandardF2s VMSizeTypes = "Standard_F2s"
	// VMSizeTypesStandardF2sV2 ...
	VMSizeTypesStandardF2sV2 VMSizeTypes = "Standard_F2s_v2"
	// VMSizeTypesStandardF32sV2 ...
	VMSizeTypesStandardF32sV2 VMSizeTypes = "Standard_F32s_v2"
	// VMSizeTypesStandardF4 ...
	VMSizeTypesStandardF4 VMSizeTypes = "Standard_F4"
	// VMSizeTypesStandardF4s ...
	VMSizeTypesStandardF4s VMSizeTypes = "Standard_F4s"
	// VMSizeTypesStandardF4sV2 ...
	VMSizeTypesStandardF4sV2 VMSizeTypes = "Standard_F4s_v2"
	// VMSizeTypesStandardF64sV2 ...
	VMSizeTypesStandardF64sV2 VMSizeTypes = "Standard_F64s_v2"
	// VMSizeTypesStandardF72sV2 ...
	VMSizeTypesStandardF72sV2 VMSizeTypes = "Standard_F72s_v2"
	// VMSizeTypesStandardF8 ...
	VMSizeTypesStandardF8 VMSizeTypes = "Standard_F8"
	// VMSizeTypesStandardF8s ...
	VMSizeTypesStandardF8s VMSizeTypes = "Standard_F8s"
	// VMSizeTypesStandardF8sV2 ...
	VMSizeTypesStandardF8sV2 VMSizeTypes = "Standard_F8s_v2"
	// VMSizeTypesStandardG1 ...
	VMSizeTypesStandardG1 VMSizeTypes = "Standard_G1"
	// VMSizeTypesStandardG2 ...
	VMSizeTypesStandardG2 VMSizeTypes = "Standard_G2"
	// VMSizeTypesStandardG3 ...
	VMSizeTypesStandardG3 VMSizeTypes = "Standard_G3"
	// VMSizeTypesStandardG4 ...
	VMSizeTypesStandardG4 VMSizeTypes = "Standard_G4"
	// VMSizeTypesStandardG5 ...
	VMSizeTypesStandardG5 VMSizeTypes = "Standard_G5"
	// VMSizeTypesStandardGS1 ...
	VMSizeTypesStandardGS1 VMSizeTypes = "Standard_GS1"
	// VMSizeTypesStandardGS2 ...
	VMSizeTypesStandardGS2 VMSizeTypes = "Standard_GS2"
	// VMSizeTypesStandardGS3 ...
	VMSizeTypesStandardGS3 VMSizeTypes = "Standard_GS3"
	// VMSizeTypesStandardGS4 ...
	VMSizeTypesStandardGS4 VMSizeTypes = "Standard_GS4"
	// VMSizeTypesStandardGS44 ...
	VMSizeTypesStandardGS44 VMSizeTypes = "Standard_GS4-4"
	// VMSizeTypesStandardGS48 ...
	VMSizeTypesStandardGS48 VMSizeTypes = "Standard_GS4-8"
	// VMSizeTypesStandardGS5 ...
	VMSizeTypesStandardGS5 VMSizeTypes = "Standard_GS5"
	// VMSizeTypesStandardGS516 ...
	VMSizeTypesStandardGS516 VMSizeTypes = "Standard_GS5-16"
	// VMSizeTypesStandardGS58 ...
	VMSizeTypesStandardGS58 VMSizeTypes = "Standard_GS5-8"
	// VMSizeTypesStandardH16 ...
	VMSizeTypesStandardH16 VMSizeTypes = "Standard_H16"
	// VMSizeTypesStandardH16m ...
	VMSizeTypesStandardH16m VMSizeTypes = "Standard_H16m"
	// VMSizeTypesStandardH16mr ...
	VMSizeTypesStandardH16mr VMSizeTypes = "Standard_H16mr"
	// VMSizeTypesStandardH16r ...
	VMSizeTypesStandardH16r VMSizeTypes = "Standard_H16r"
	// VMSizeTypesStandardH8 ...
	VMSizeTypesStandardH8 VMSizeTypes = "Standard_H8"
	// VMSizeTypesStandardH8m ...
	VMSizeTypesStandardH8m VMSizeTypes = "Standard_H8m"
	// VMSizeTypesStandardL16s ...
	VMSizeTypesStandardL16s VMSizeTypes = "Standard_L16s"
	// VMSizeTypesStandardL32s ...
	VMSizeTypesStandardL32s VMSizeTypes = "Standard_L32s"
	// VMSizeTypesStandardL4s ...
	VMSizeTypesStandardL4s VMSizeTypes = "Standard_L4s"
	// VMSizeTypesStandardL8s ...
	VMSizeTypesStandardL8s VMSizeTypes = "Standard_L8s"
	// VMSizeTypesStandardM12832ms ...
	VMSizeTypesStandardM12832ms VMSizeTypes = "Standard_M128-32ms"
	// VMSizeTypesStandardM12864ms ...
	VMSizeTypesStandardM12864ms VMSizeTypes = "Standard_M128-64ms"
	// VMSizeTypesStandardM128ms ...
	VMSizeTypesStandardM128ms VMSizeTypes = "Standard_M128ms"
	// VMSizeTypesStandardM128s ...
	VMSizeTypesStandardM128s VMSizeTypes = "Standard_M128s"
	// VMSizeTypesStandardM6416ms ...
	VMSizeTypesStandardM6416ms VMSizeTypes = "Standard_M64-16ms"
	// VMSizeTypesStandardM6432ms ...
	VMSizeTypesStandardM6432ms VMSizeTypes = "Standard_M64-32ms"
	// VMSizeTypesStandardM64ms ...
	VMSizeTypesStandardM64ms VMSizeTypes = "Standard_M64ms"
	// VMSizeTypesStandardM64s ...
	VMSizeTypesStandardM64s VMSizeTypes = "Standard_M64s"
	// VMSizeTypesStandardNC12 ...
	VMSizeTypesStandardNC12 VMSizeTypes = "Standard_NC12"
	// VMSizeTypesStandardNC12sV2 ...
	VMSizeTypesStandardNC12sV2 VMSizeTypes = "Standard_NC12s_v2"
	// VMSizeTypesStandardNC12sV3 ...
	VMSizeTypesStandardNC12sV3 VMSizeTypes = "Standard_NC12s_v3"
	// VMSizeTypesStandardNC24 ...
	VMSizeTypesStandardNC24 VMSizeTypes = "Standard_NC24"
	// VMSizeTypesStandardNC24r ...
	VMSizeTypesStandardNC24r VMSizeTypes = "Standard_NC24r"
	// VMSizeTypesStandardNC24rsV2 ...
	VMSizeTypesStandardNC24rsV2 VMSizeTypes = "Standard_NC24rs_v2"
	// VMSizeTypesStandardNC24rsV3 ...
	VMSizeTypesStandardNC24rsV3 VMSizeTypes = "Standard_NC24rs_v3"
	// VMSizeTypesStandardNC24sV2 ...
	VMSizeTypesStandardNC24sV2 VMSizeTypes = "Standard_NC24s_v2"
	// VMSizeTypesStandardNC24sV3 ...
	VMSizeTypesStandardNC24sV3 VMSizeTypes = "Standard_NC24s_v3"
	// VMSizeTypesStandardNC6 ...
	VMSizeTypesStandardNC6 VMSizeTypes = "Standard_NC6"
	// VMSizeTypesStandardNC6sV2 ...
	VMSizeTypesStandardNC6sV2 VMSizeTypes = "Standard_NC6s_v2"
	// VMSizeTypesStandardNC6sV3 ...
	VMSizeTypesStandardNC6sV3 VMSizeTypes = "Standard_NC6s_v3"
	// VMSizeTypesStandardND12s ...
	VMSizeTypesStandardND12s VMSizeTypes = "Standard_ND12s"
	// VMSizeTypesStandardND24rs ...
	VMSizeTypesStandardND24rs VMSizeTypes = "Standard_ND24rs"
	// VMSizeTypesStandardND24s ...
	VMSizeTypesStandardND24s VMSizeTypes = "Standard_ND24s"
	// VMSizeTypesStandardND6s ...
	VMSizeTypesStandardND6s VMSizeTypes = "Standard_ND6s"
	// VMSizeTypesStandardNV12 ...
	VMSizeTypesStandardNV12 VMSizeTypes = "Standard_NV12"
	// VMSizeTypesStandardNV24 ...
	VMSizeTypesStandardNV24 VMSizeTypes = "Standard_NV24"
	// VMSizeTypesStandardNV6 ...
	VMSizeTypesStandardNV6 VMSizeTypes = "Standard_NV6"
)

// PossibleVMSizeTypesValues returns an array of possible values for the VMSizeTypes const type.
func PossibleVMSizeTypesValues() []VMSizeTypes {
	return []VMSizeTypes{VMSizeTypesStandardA1, VMSizeTypesStandardA10, VMSizeTypesStandardA11, VMSizeTypesStandardA1V2, VMSizeTypesStandardA2, VMSizeTypesStandardA2mV2, VMSizeTypesStandardA2V2, VMSizeTypesStandardA3, VMSizeTypesStandardA4, VMSizeTypesStandardA4mV2, VMSizeTypesStandardA4V2, VMSizeTypesStandardA5, VMSizeTypesStandardA6, VMSizeTypesStandardA7, VMSizeTypesStandardA8, VMSizeTypesStandardA8mV2, VMSizeTypesStandardA8V2, VMSizeTypesStandardA9, VMSizeTypesStandardB2ms, VMSizeTypesStandardB2s, VMSizeTypesStandardB4ms, VMSizeTypesStandardB8ms, VMSizeTypesStandardD1, VMSizeTypesStandardD11, VMSizeTypesStandardD11V2, VMSizeTypesStandardD11V2Promo, VMSizeTypesStandardD12, VMSizeTypesStandardD12V2, VMSizeTypesStandardD12V2Promo, VMSizeTypesStandardD13, VMSizeTypesStandardD13V2, VMSizeTypesStandardD13V2Promo, VMSizeTypesStandardD14, VMSizeTypesStandardD14V2, VMSizeTypesStandardD14V2Promo, VMSizeTypesStandardD15V2, VMSizeTypesStandardD16sV3, VMSizeTypesStandardD16V3, VMSizeTypesStandardD1V2, VMSizeTypesStandardD2, VMSizeTypesStandardD2sV3, VMSizeTypesStandardD2V2, VMSizeTypesStandardD2V2Promo, VMSizeTypesStandardD2V3, VMSizeTypesStandardD3, VMSizeTypesStandardD32sV3, VMSizeTypesStandardD32V3, VMSizeTypesStandardD3V2, VMSizeTypesStandardD3V2Promo, VMSizeTypesStandardD4, VMSizeTypesStandardD4sV3, VMSizeTypesStandardD4V2, VMSizeTypesStandardD4V2Promo, VMSizeTypesStandardD4V3, VMSizeTypesStandardD5V2, VMSizeTypesStandardD5V2Promo, VMSizeTypesStandardD64sV3, VMSizeTypesStandardD64V3, VMSizeTypesStandardD8sV3, VMSizeTypesStandardD8V3, VMSizeTypesStandardDS1, VMSizeTypesStandardDS11, VMSizeTypesStandardDS11V2, VMSizeTypesStandardDS11V2Promo, VMSizeTypesStandardDS12, VMSizeTypesStandardDS12V2, VMSizeTypesStandardDS12V2Promo, VMSizeTypesStandardDS13, VMSizeTypesStandardDS132V2, VMSizeTypesStandardDS134V2, VMSizeTypesStandardDS13V2, VMSizeTypesStandardDS13V2Promo, VMSizeTypesStandardDS14, VMSizeTypesStandardDS144V2, VMSizeTypesStandardDS148V2, VMSizeTypesStandardDS14V2, VMSizeTypesStandardDS14V2Promo, VMSizeTypesStandardDS15V2, VMSizeTypesStandardDS1V2, VMSizeTypesStandardDS2, VMSizeTypesStandardDS2V2, VMSizeTypesStandardDS2V2Promo, VMSizeTypesStandardDS3, VMSizeTypesStandardDS3V2, VMSizeTypesStandardDS3V2Promo, VMSizeTypesStandardDS4, VMSizeTypesStandardDS4V2, VMSizeTypesStandardDS4V2Promo, VMSizeTypesStandardDS5V2, VMSizeTypesStandardDS5V2Promo, VMSizeTypesStandardE16sV3, VMSizeTypesStandardE16V3, VMSizeTypesStandardE2sV3, VMSizeTypesStandardE2V3, VMSizeTypesStandardE3216sV3, VMSizeTypesStandardE328sV3, VMSizeTypesStandardE32sV3, VMSizeTypesStandardE32V3, VMSizeTypesStandardE4sV3, VMSizeTypesStandardE4V3, VMSizeTypesStandardE6416sV3, VMSizeTypesStandardE6432sV3, VMSizeTypesStandardE64sV3, VMSizeTypesStandardE64V3, VMSizeTypesStandardE8sV3, VMSizeTypesStandardE8V3, VMSizeTypesStandardF1, VMSizeTypesStandardF16, VMSizeTypesStandardF16s, VMSizeTypesStandardF16sV2, VMSizeTypesStandardF1s, VMSizeTypesStandardF2, VMSizeTypesStandardF2s, VMSizeTypesStandardF2sV2, VMSizeTypesStandardF32sV2, VMSizeTypesStandardF4, VMSizeTypesStandardF4s, VMSizeTypesStandardF4sV2, VMSizeTypesStandardF64sV2, VMSizeTypesStandardF72sV2, VMSizeTypesStandardF8, VMSizeTypesStandardF8s, VMSizeTypesStandardF8sV2, VMSizeTypesStandardG1, VMSizeTypesStandardG2, VMSizeTypesStandardG3, VMSizeTypesStandardG4, VMSizeTypesStandardG5, VMSizeTypesStandardGS1, VMSizeTypesStandardGS2, VMSizeTypesStandardGS3, VMSizeTypesStandardGS4, VMSizeTypesStandardGS44, VMSizeTypesStandardGS48, VMSizeTypesStandardGS5, VMSizeTypesStandardGS516, VMSizeTypesStandardGS58, VMSizeTypesStandardH16, VMSizeTypesStandardH16m, VMSizeTypesStandardH16mr, VMSizeTypesStandardH16r, VMSizeTypesStandardH8, VMSizeTypesStandardH8m, VMSizeTypesStandardL16s, VMSizeTypesStandardL32s, VMSizeTypesStandardL4s, VMSizeTypesStandardL8s, VMSizeTypesStandardM12832ms, VMSizeTypesStandardM12864ms, VMSizeTypesStandardM128ms, VMSizeTypesStandardM128s, VMSizeTypesStandardM6416ms, VMSizeTypesStandardM6432ms, VMSizeTypesStandardM64ms, VMSizeTypesStandardM64s, VMSizeTypesStandardNC12, VMSizeTypesStandardNC12sV2, VMSizeTypesStandardNC12sV3, VMSizeTypesStandardNC24, VMSizeTypesStandardNC24r, VMSizeTypesStandardNC24rsV2, VMSizeTypesStandardNC24rsV3, VMSizeTypesStandardNC24sV2, VMSizeTypesStandardNC24sV3, VMSizeTypesStandardNC6, VMSizeTypesStandardNC6sV2, VMSizeTypesStandardNC6sV3, VMSizeTypesStandardND12s, VMSizeTypesStandardND24rs, VMSizeTypesStandardND24s, VMSizeTypesStandardND6s, VMSizeTypesStandardNV12, VMSizeTypesStandardNV24, VMSizeTypesStandardNV6}
}

// WeekDay enumerates the values for week day.
type WeekDay string

const (
	// WeekDayFriday ...
	WeekDayFriday WeekDay = "Friday"
	// WeekDayMonday ...
	WeekDayMonday WeekDay = "Monday"
	// WeekDaySaturday ...
	WeekDaySaturday WeekDay = "Saturday"
	// WeekDaySunday ...
	WeekDaySunday WeekDay = "Sunday"
	// WeekDayThursday ...
	WeekDayThursday WeekDay = "Thursday"
	// WeekDayTuesday ...
	WeekDayTuesday WeekDay = "Tuesday"
	// WeekDayWednesday ...
	WeekDayWednesday WeekDay = "Wednesday"
)

// PossibleWeekDayValues returns an array of possible values for the WeekDay const type.
func PossibleWeekDayValues() []WeekDay {
	return []WeekDay{WeekDayFriday, WeekDayMonday, WeekDaySaturday, WeekDaySunday, WeekDayThursday, WeekDayTuesday, WeekDayWednesday}
}

// WorkloadRuntime enumerates the values for workload runtime.
type WorkloadRuntime string

const (
	// WorkloadRuntimeOCIContainer Nodes will use Kubelet to run standard OCI container workloads.
	WorkloadRuntimeOCIContainer WorkloadRuntime = "OCIContainer"
	// WorkloadRuntimeWasmWasi Nodes will use Krustlet to run WASM workloads using the WASI provider (Preview).
	WorkloadRuntimeWasmWasi WorkloadRuntime = "WasmWasi"
)

// PossibleWorkloadRuntimeValues returns an array of possible values for the WorkloadRuntime const type.
func PossibleWorkloadRuntimeValues() []WorkloadRuntime {
	return []WorkloadRuntime{WorkloadRuntimeOCIContainer, WorkloadRuntimeWasmWasi}
}
