package synapse

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ActualState enumerates the values for actual state.
type ActualState string

const (
	// ActualStateDisabled ...
	ActualStateDisabled ActualState = "Disabled"
	// ActualStateDisabling ...
	ActualStateDisabling ActualState = "Disabling"
	// ActualStateEnabled ...
	ActualStateEnabled ActualState = "Enabled"
	// ActualStateEnabling ...
	ActualStateEnabling ActualState = "Enabling"
	// ActualStateUnknown ...
	ActualStateUnknown ActualState = "Unknown"
)

// PossibleActualStateValues returns an array of possible values for the ActualState const type.
func PossibleActualStateValues() []ActualState {
	return []ActualState{ActualStateDisabled, ActualStateDisabling, ActualStateEnabled, ActualStateEnabling, ActualStateUnknown}
}

// AuthenticationState enumerates the values for authentication state.
type AuthenticationState string

const (
	// AuthenticationStateConsistent ...
	AuthenticationStateConsistent AuthenticationState = "Consistent"
	// AuthenticationStateInConsistent ...
	AuthenticationStateInConsistent AuthenticationState = "InConsistent"
	// AuthenticationStateUpdating ...
	AuthenticationStateUpdating AuthenticationState = "Updating"
)

// PossibleAuthenticationStateValues returns an array of possible values for the AuthenticationState const type.
func PossibleAuthenticationStateValues() []AuthenticationState {
	return []AuthenticationState{AuthenticationStateConsistent, AuthenticationStateInConsistent, AuthenticationStateUpdating}
}

// AuthorizationType enumerates the values for authorization type.
type AuthorizationType string

const (
	// AuthorizationTypeKey ...
	AuthorizationTypeKey AuthorizationType = "Key"
	// AuthorizationTypeLinkedIntegrationRuntimeType ...
	AuthorizationTypeLinkedIntegrationRuntimeType AuthorizationType = "LinkedIntegrationRuntimeType"
	// AuthorizationTypeRBAC ...
	AuthorizationTypeRBAC AuthorizationType = "RBAC"
)

// PossibleAuthorizationTypeValues returns an array of possible values for the AuthorizationType const type.
func PossibleAuthorizationTypeValues() []AuthorizationType {
	return []AuthorizationType{AuthorizationTypeKey, AuthorizationTypeLinkedIntegrationRuntimeType, AuthorizationTypeRBAC}
}

// BlobAuditingPolicyState enumerates the values for blob auditing policy state.
type BlobAuditingPolicyState string

const (
	// BlobAuditingPolicyStateDisabled ...
	BlobAuditingPolicyStateDisabled BlobAuditingPolicyState = "Disabled"
	// BlobAuditingPolicyStateEnabled ...
	BlobAuditingPolicyStateEnabled BlobAuditingPolicyState = "Enabled"
)

// PossibleBlobAuditingPolicyStateValues returns an array of possible values for the BlobAuditingPolicyState const type.
func PossibleBlobAuditingPolicyStateValues() []BlobAuditingPolicyState {
	return []BlobAuditingPolicyState{BlobAuditingPolicyStateDisabled, BlobAuditingPolicyStateEnabled}
}

// ColumnDataType enumerates the values for column data type.
type ColumnDataType string

const (
	// ColumnDataTypeBigint ...
	ColumnDataTypeBigint ColumnDataType = "bigint"
	// ColumnDataTypeBinary ...
	ColumnDataTypeBinary ColumnDataType = "binary"
	// ColumnDataTypeBit ...
	ColumnDataTypeBit ColumnDataType = "bit"
	// ColumnDataTypeChar ...
	ColumnDataTypeChar ColumnDataType = "char"
	// ColumnDataTypeDate ...
	ColumnDataTypeDate ColumnDataType = "date"
	// ColumnDataTypeDatetime ...
	ColumnDataTypeDatetime ColumnDataType = "datetime"
	// ColumnDataTypeDatetime2 ...
	ColumnDataTypeDatetime2 ColumnDataType = "datetime2"
	// ColumnDataTypeDatetimeoffset ...
	ColumnDataTypeDatetimeoffset ColumnDataType = "datetimeoffset"
	// ColumnDataTypeDecimal ...
	ColumnDataTypeDecimal ColumnDataType = "decimal"
	// ColumnDataTypeFloat ...
	ColumnDataTypeFloat ColumnDataType = "float"
	// ColumnDataTypeGeography ...
	ColumnDataTypeGeography ColumnDataType = "geography"
	// ColumnDataTypeGeometry ...
	ColumnDataTypeGeometry ColumnDataType = "geometry"
	// ColumnDataTypeHierarchyid ...
	ColumnDataTypeHierarchyid ColumnDataType = "hierarchyid"
	// ColumnDataTypeImage ...
	ColumnDataTypeImage ColumnDataType = "image"
	// ColumnDataTypeInt ...
	ColumnDataTypeInt ColumnDataType = "int"
	// ColumnDataTypeMoney ...
	ColumnDataTypeMoney ColumnDataType = "money"
	// ColumnDataTypeNchar ...
	ColumnDataTypeNchar ColumnDataType = "nchar"
	// ColumnDataTypeNtext ...
	ColumnDataTypeNtext ColumnDataType = "ntext"
	// ColumnDataTypeNumeric ...
	ColumnDataTypeNumeric ColumnDataType = "numeric"
	// ColumnDataTypeNvarchar ...
	ColumnDataTypeNvarchar ColumnDataType = "nvarchar"
	// ColumnDataTypeReal ...
	ColumnDataTypeReal ColumnDataType = "real"
	// ColumnDataTypeSmalldatetime ...
	ColumnDataTypeSmalldatetime ColumnDataType = "smalldatetime"
	// ColumnDataTypeSmallint ...
	ColumnDataTypeSmallint ColumnDataType = "smallint"
	// ColumnDataTypeSmallmoney ...
	ColumnDataTypeSmallmoney ColumnDataType = "smallmoney"
	// ColumnDataTypeSQLVariant ...
	ColumnDataTypeSQLVariant ColumnDataType = "sql_variant"
	// ColumnDataTypeSysname ...
	ColumnDataTypeSysname ColumnDataType = "sysname"
	// ColumnDataTypeText ...
	ColumnDataTypeText ColumnDataType = "text"
	// ColumnDataTypeTime ...
	ColumnDataTypeTime ColumnDataType = "time"
	// ColumnDataTypeTimestamp ...
	ColumnDataTypeTimestamp ColumnDataType = "timestamp"
	// ColumnDataTypeTinyint ...
	ColumnDataTypeTinyint ColumnDataType = "tinyint"
	// ColumnDataTypeUniqueidentifier ...
	ColumnDataTypeUniqueidentifier ColumnDataType = "uniqueidentifier"
	// ColumnDataTypeVarbinary ...
	ColumnDataTypeVarbinary ColumnDataType = "varbinary"
	// ColumnDataTypeVarchar ...
	ColumnDataTypeVarchar ColumnDataType = "varchar"
	// ColumnDataTypeXML ...
	ColumnDataTypeXML ColumnDataType = "xml"
)

// PossibleColumnDataTypeValues returns an array of possible values for the ColumnDataType const type.
func PossibleColumnDataTypeValues() []ColumnDataType {
	return []ColumnDataType{ColumnDataTypeBigint, ColumnDataTypeBinary, ColumnDataTypeBit, ColumnDataTypeChar, ColumnDataTypeDate, ColumnDataTypeDatetime, ColumnDataTypeDatetime2, ColumnDataTypeDatetimeoffset, ColumnDataTypeDecimal, ColumnDataTypeFloat, ColumnDataTypeGeography, ColumnDataTypeGeometry, ColumnDataTypeHierarchyid, ColumnDataTypeImage, ColumnDataTypeInt, ColumnDataTypeMoney, ColumnDataTypeNchar, ColumnDataTypeNtext, ColumnDataTypeNumeric, ColumnDataTypeNvarchar, ColumnDataTypeReal, ColumnDataTypeSmalldatetime, ColumnDataTypeSmallint, ColumnDataTypeSmallmoney, ColumnDataTypeSQLVariant, ColumnDataTypeSysname, ColumnDataTypeText, ColumnDataTypeTime, ColumnDataTypeTimestamp, ColumnDataTypeTinyint, ColumnDataTypeUniqueidentifier, ColumnDataTypeVarbinary, ColumnDataTypeVarchar, ColumnDataTypeXML}
}

// ConfigurationType enumerates the values for configuration type.
type ConfigurationType string

const (
	// ConfigurationTypeArtifact ...
	ConfigurationTypeArtifact ConfigurationType = "Artifact"
	// ConfigurationTypeFile ...
	ConfigurationTypeFile ConfigurationType = "File"
)

// PossibleConfigurationTypeValues returns an array of possible values for the ConfigurationType const type.
func PossibleConfigurationTypeValues() []ConfigurationType {
	return []ConfigurationType{ConfigurationTypeArtifact, ConfigurationTypeFile}
}

// DataFlowComputeType enumerates the values for data flow compute type.
type DataFlowComputeType string

const (
	// DataFlowComputeTypeComputeOptimized ...
	DataFlowComputeTypeComputeOptimized DataFlowComputeType = "ComputeOptimized"
	// DataFlowComputeTypeGeneral ...
	DataFlowComputeTypeGeneral DataFlowComputeType = "General"
	// DataFlowComputeTypeMemoryOptimized ...
	DataFlowComputeTypeMemoryOptimized DataFlowComputeType = "MemoryOptimized"
)

// PossibleDataFlowComputeTypeValues returns an array of possible values for the DataFlowComputeType const type.
func PossibleDataFlowComputeTypeValues() []DataFlowComputeType {
	return []DataFlowComputeType{DataFlowComputeTypeComputeOptimized, DataFlowComputeTypeGeneral, DataFlowComputeTypeMemoryOptimized}
}

// DataMaskingFunction enumerates the values for data masking function.
type DataMaskingFunction string

const (
	// DataMaskingFunctionCCN ...
	DataMaskingFunctionCCN DataMaskingFunction = "CCN"
	// DataMaskingFunctionDefault ...
	DataMaskingFunctionDefault DataMaskingFunction = "Default"
	// DataMaskingFunctionEmail ...
	DataMaskingFunctionEmail DataMaskingFunction = "Email"
	// DataMaskingFunctionNumber ...
	DataMaskingFunctionNumber DataMaskingFunction = "Number"
	// DataMaskingFunctionSSN ...
	DataMaskingFunctionSSN DataMaskingFunction = "SSN"
	// DataMaskingFunctionText ...
	DataMaskingFunctionText DataMaskingFunction = "Text"
)

// PossibleDataMaskingFunctionValues returns an array of possible values for the DataMaskingFunction const type.
func PossibleDataMaskingFunctionValues() []DataMaskingFunction {
	return []DataMaskingFunction{DataMaskingFunctionCCN, DataMaskingFunctionDefault, DataMaskingFunctionEmail, DataMaskingFunctionNumber, DataMaskingFunctionSSN, DataMaskingFunctionText}
}

// DataMaskingRuleState enumerates the values for data masking rule state.
type DataMaskingRuleState string

const (
	// DataMaskingRuleStateDisabled ...
	DataMaskingRuleStateDisabled DataMaskingRuleState = "Disabled"
	// DataMaskingRuleStateEnabled ...
	DataMaskingRuleStateEnabled DataMaskingRuleState = "Enabled"
)

// PossibleDataMaskingRuleStateValues returns an array of possible values for the DataMaskingRuleState const type.
func PossibleDataMaskingRuleStateValues() []DataMaskingRuleState {
	return []DataMaskingRuleState{DataMaskingRuleStateDisabled, DataMaskingRuleStateEnabled}
}

// DataMaskingState enumerates the values for data masking state.
type DataMaskingState string

const (
	// DataMaskingStateDisabled ...
	DataMaskingStateDisabled DataMaskingState = "Disabled"
	// DataMaskingStateEnabled ...
	DataMaskingStateEnabled DataMaskingState = "Enabled"
)

// PossibleDataMaskingStateValues returns an array of possible values for the DataMaskingState const type.
func PossibleDataMaskingStateValues() []DataMaskingState {
	return []DataMaskingState{DataMaskingStateDisabled, DataMaskingStateEnabled}
}

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// DayOfWeekFriday ...
	DayOfWeekFriday DayOfWeek = "Friday"
	// DayOfWeekMonday ...
	DayOfWeekMonday DayOfWeek = "Monday"
	// DayOfWeekSaturday ...
	DayOfWeekSaturday DayOfWeek = "Saturday"
	// DayOfWeekSunday ...
	DayOfWeekSunday DayOfWeek = "Sunday"
	// DayOfWeekThursday ...
	DayOfWeekThursday DayOfWeek = "Thursday"
	// DayOfWeekTuesday ...
	DayOfWeekTuesday DayOfWeek = "Tuesday"
	// DayOfWeekWednesday ...
	DayOfWeekWednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{DayOfWeekFriday, DayOfWeekMonday, DayOfWeekSaturday, DayOfWeekSunday, DayOfWeekThursday, DayOfWeekTuesday, DayOfWeekWednesday}
}

// DesiredState enumerates the values for desired state.
type DesiredState string

const (
	// DesiredStateDisabled ...
	DesiredStateDisabled DesiredState = "Disabled"
	// DesiredStateEnabled ...
	DesiredStateEnabled DesiredState = "Enabled"
)

// PossibleDesiredStateValues returns an array of possible values for the DesiredState const type.
func PossibleDesiredStateValues() []DesiredState {
	return []DesiredState{DesiredStateDisabled, DesiredStateEnabled}
}

// GeoBackupPolicyState enumerates the values for geo backup policy state.
type GeoBackupPolicyState string

const (
	// GeoBackupPolicyStateDisabled ...
	GeoBackupPolicyStateDisabled GeoBackupPolicyState = "Disabled"
	// GeoBackupPolicyStateEnabled ...
	GeoBackupPolicyStateEnabled GeoBackupPolicyState = "Enabled"
)

// PossibleGeoBackupPolicyStateValues returns an array of possible values for the GeoBackupPolicyState const type.
func PossibleGeoBackupPolicyStateValues() []GeoBackupPolicyState {
	return []GeoBackupPolicyState{GeoBackupPolicyStateDisabled, GeoBackupPolicyStateEnabled}
}

// IntegrationRuntimeAuthKeyName enumerates the values for integration runtime auth key name.
type IntegrationRuntimeAuthKeyName string

const (
	// IntegrationRuntimeAuthKeyNameAuthKey1 ...
	IntegrationRuntimeAuthKeyNameAuthKey1 IntegrationRuntimeAuthKeyName = "authKey1"
	// IntegrationRuntimeAuthKeyNameAuthKey2 ...
	IntegrationRuntimeAuthKeyNameAuthKey2 IntegrationRuntimeAuthKeyName = "authKey2"
)

// PossibleIntegrationRuntimeAuthKeyNameValues returns an array of possible values for the IntegrationRuntimeAuthKeyName const type.
func PossibleIntegrationRuntimeAuthKeyNameValues() []IntegrationRuntimeAuthKeyName {
	return []IntegrationRuntimeAuthKeyName{IntegrationRuntimeAuthKeyNameAuthKey1, IntegrationRuntimeAuthKeyNameAuthKey2}
}

// IntegrationRuntimeAutoUpdate enumerates the values for integration runtime auto update.
type IntegrationRuntimeAutoUpdate string

const (
	// IntegrationRuntimeAutoUpdateOff ...
	IntegrationRuntimeAutoUpdateOff IntegrationRuntimeAutoUpdate = "Off"
	// IntegrationRuntimeAutoUpdateOn ...
	IntegrationRuntimeAutoUpdateOn IntegrationRuntimeAutoUpdate = "On"
)

// PossibleIntegrationRuntimeAutoUpdateValues returns an array of possible values for the IntegrationRuntimeAutoUpdate const type.
func PossibleIntegrationRuntimeAutoUpdateValues() []IntegrationRuntimeAutoUpdate {
	return []IntegrationRuntimeAutoUpdate{IntegrationRuntimeAutoUpdateOff, IntegrationRuntimeAutoUpdateOn}
}

// IntegrationRuntimeEdition enumerates the values for integration runtime edition.
type IntegrationRuntimeEdition string

const (
	// IntegrationRuntimeEditionEnterprise ...
	IntegrationRuntimeEditionEnterprise IntegrationRuntimeEdition = "Enterprise"
	// IntegrationRuntimeEditionStandard ...
	IntegrationRuntimeEditionStandard IntegrationRuntimeEdition = "Standard"
)

// PossibleIntegrationRuntimeEditionValues returns an array of possible values for the IntegrationRuntimeEdition const type.
func PossibleIntegrationRuntimeEditionValues() []IntegrationRuntimeEdition {
	return []IntegrationRuntimeEdition{IntegrationRuntimeEditionEnterprise, IntegrationRuntimeEditionStandard}
}

// IntegrationRuntimeEntityReferenceType enumerates the values for integration runtime entity reference type.
type IntegrationRuntimeEntityReferenceType string

const (
	// IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference ...
	IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference IntegrationRuntimeEntityReferenceType = "IntegrationRuntimeReference"
	// IntegrationRuntimeEntityReferenceTypeLinkedServiceReference ...
	IntegrationRuntimeEntityReferenceTypeLinkedServiceReference IntegrationRuntimeEntityReferenceType = "LinkedServiceReference"
)

// PossibleIntegrationRuntimeEntityReferenceTypeValues returns an array of possible values for the IntegrationRuntimeEntityReferenceType const type.
func PossibleIntegrationRuntimeEntityReferenceTypeValues() []IntegrationRuntimeEntityReferenceType {
	return []IntegrationRuntimeEntityReferenceType{IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference, IntegrationRuntimeEntityReferenceTypeLinkedServiceReference}
}

// IntegrationRuntimeInternalChannelEncryptionMode enumerates the values for integration runtime internal
// channel encryption mode.
type IntegrationRuntimeInternalChannelEncryptionMode string

const (
	// IntegrationRuntimeInternalChannelEncryptionModeNotEncrypted ...
	IntegrationRuntimeInternalChannelEncryptionModeNotEncrypted IntegrationRuntimeInternalChannelEncryptionMode = "NotEncrypted"
	// IntegrationRuntimeInternalChannelEncryptionModeNotSet ...
	IntegrationRuntimeInternalChannelEncryptionModeNotSet IntegrationRuntimeInternalChannelEncryptionMode = "NotSet"
	// IntegrationRuntimeInternalChannelEncryptionModeSslEncrypted ...
	IntegrationRuntimeInternalChannelEncryptionModeSslEncrypted IntegrationRuntimeInternalChannelEncryptionMode = "SslEncrypted"
)

// PossibleIntegrationRuntimeInternalChannelEncryptionModeValues returns an array of possible values for the IntegrationRuntimeInternalChannelEncryptionMode const type.
func PossibleIntegrationRuntimeInternalChannelEncryptionModeValues() []IntegrationRuntimeInternalChannelEncryptionMode {
	return []IntegrationRuntimeInternalChannelEncryptionMode{IntegrationRuntimeInternalChannelEncryptionModeNotEncrypted, IntegrationRuntimeInternalChannelEncryptionModeNotSet, IntegrationRuntimeInternalChannelEncryptionModeSslEncrypted}
}

// IntegrationRuntimeLicenseType enumerates the values for integration runtime license type.
type IntegrationRuntimeLicenseType string

const (
	// IntegrationRuntimeLicenseTypeBasePrice ...
	IntegrationRuntimeLicenseTypeBasePrice IntegrationRuntimeLicenseType = "BasePrice"
	// IntegrationRuntimeLicenseTypeLicenseIncluded ...
	IntegrationRuntimeLicenseTypeLicenseIncluded IntegrationRuntimeLicenseType = "LicenseIncluded"
)

// PossibleIntegrationRuntimeLicenseTypeValues returns an array of possible values for the IntegrationRuntimeLicenseType const type.
func PossibleIntegrationRuntimeLicenseTypeValues() []IntegrationRuntimeLicenseType {
	return []IntegrationRuntimeLicenseType{IntegrationRuntimeLicenseTypeBasePrice, IntegrationRuntimeLicenseTypeLicenseIncluded}
}

// IntegrationRuntimeSsisCatalogPricingTier enumerates the values for integration runtime ssis catalog pricing
// tier.
type IntegrationRuntimeSsisCatalogPricingTier string

const (
	// IntegrationRuntimeSsisCatalogPricingTierBasic ...
	IntegrationRuntimeSsisCatalogPricingTierBasic IntegrationRuntimeSsisCatalogPricingTier = "Basic"
	// IntegrationRuntimeSsisCatalogPricingTierPremium ...
	IntegrationRuntimeSsisCatalogPricingTierPremium IntegrationRuntimeSsisCatalogPricingTier = "Premium"
	// IntegrationRuntimeSsisCatalogPricingTierPremiumRS ...
	IntegrationRuntimeSsisCatalogPricingTierPremiumRS IntegrationRuntimeSsisCatalogPricingTier = "PremiumRS"
	// IntegrationRuntimeSsisCatalogPricingTierStandard ...
	IntegrationRuntimeSsisCatalogPricingTierStandard IntegrationRuntimeSsisCatalogPricingTier = "Standard"
)

// PossibleIntegrationRuntimeSsisCatalogPricingTierValues returns an array of possible values for the IntegrationRuntimeSsisCatalogPricingTier const type.
func PossibleIntegrationRuntimeSsisCatalogPricingTierValues() []IntegrationRuntimeSsisCatalogPricingTier {
	return []IntegrationRuntimeSsisCatalogPricingTier{IntegrationRuntimeSsisCatalogPricingTierBasic, IntegrationRuntimeSsisCatalogPricingTierPremium, IntegrationRuntimeSsisCatalogPricingTierPremiumRS, IntegrationRuntimeSsisCatalogPricingTierStandard}
}

// IntegrationRuntimeState enumerates the values for integration runtime state.
type IntegrationRuntimeState string

const (
	// IntegrationRuntimeStateAccessDenied ...
	IntegrationRuntimeStateAccessDenied IntegrationRuntimeState = "AccessDenied"
	// IntegrationRuntimeStateInitial ...
	IntegrationRuntimeStateInitial IntegrationRuntimeState = "Initial"
	// IntegrationRuntimeStateLimited ...
	IntegrationRuntimeStateLimited IntegrationRuntimeState = "Limited"
	// IntegrationRuntimeStateNeedRegistration ...
	IntegrationRuntimeStateNeedRegistration IntegrationRuntimeState = "NeedRegistration"
	// IntegrationRuntimeStateOffline ...
	IntegrationRuntimeStateOffline IntegrationRuntimeState = "Offline"
	// IntegrationRuntimeStateOnline ...
	IntegrationRuntimeStateOnline IntegrationRuntimeState = "Online"
	// IntegrationRuntimeStateStarted ...
	IntegrationRuntimeStateStarted IntegrationRuntimeState = "Started"
	// IntegrationRuntimeStateStarting ...
	IntegrationRuntimeStateStarting IntegrationRuntimeState = "Starting"
	// IntegrationRuntimeStateStopped ...
	IntegrationRuntimeStateStopped IntegrationRuntimeState = "Stopped"
	// IntegrationRuntimeStateStopping ...
	IntegrationRuntimeStateStopping IntegrationRuntimeState = "Stopping"
)

// PossibleIntegrationRuntimeStateValues returns an array of possible values for the IntegrationRuntimeState const type.
func PossibleIntegrationRuntimeStateValues() []IntegrationRuntimeState {
	return []IntegrationRuntimeState{IntegrationRuntimeStateAccessDenied, IntegrationRuntimeStateInitial, IntegrationRuntimeStateLimited, IntegrationRuntimeStateNeedRegistration, IntegrationRuntimeStateOffline, IntegrationRuntimeStateOnline, IntegrationRuntimeStateStarted, IntegrationRuntimeStateStarting, IntegrationRuntimeStateStopped, IntegrationRuntimeStateStopping}
}

// IntegrationRuntimeType enumerates the values for integration runtime type.
type IntegrationRuntimeType string

const (
	// IntegrationRuntimeTypeManaged ...
	IntegrationRuntimeTypeManaged IntegrationRuntimeType = "Managed"
	// IntegrationRuntimeTypeSelfHosted ...
	IntegrationRuntimeTypeSelfHosted IntegrationRuntimeType = "SelfHosted"
)

// PossibleIntegrationRuntimeTypeValues returns an array of possible values for the IntegrationRuntimeType const type.
func PossibleIntegrationRuntimeTypeValues() []IntegrationRuntimeType {
	return []IntegrationRuntimeType{IntegrationRuntimeTypeManaged, IntegrationRuntimeTypeSelfHosted}
}

// IntegrationRuntimeUpdateResult enumerates the values for integration runtime update result.
type IntegrationRuntimeUpdateResult string

const (
	// IntegrationRuntimeUpdateResultFail ...
	IntegrationRuntimeUpdateResultFail IntegrationRuntimeUpdateResult = "Fail"
	// IntegrationRuntimeUpdateResultNone ...
	IntegrationRuntimeUpdateResultNone IntegrationRuntimeUpdateResult = "None"
	// IntegrationRuntimeUpdateResultSucceed ...
	IntegrationRuntimeUpdateResultSucceed IntegrationRuntimeUpdateResult = "Succeed"
)

// PossibleIntegrationRuntimeUpdateResultValues returns an array of possible values for the IntegrationRuntimeUpdateResult const type.
func PossibleIntegrationRuntimeUpdateResultValues() []IntegrationRuntimeUpdateResult {
	return []IntegrationRuntimeUpdateResult{IntegrationRuntimeUpdateResultFail, IntegrationRuntimeUpdateResultNone, IntegrationRuntimeUpdateResultSucceed}
}

// ManagedIntegrationRuntimeNodeStatus enumerates the values for managed integration runtime node status.
type ManagedIntegrationRuntimeNodeStatus string

const (
	// ManagedIntegrationRuntimeNodeStatusAvailable ...
	ManagedIntegrationRuntimeNodeStatusAvailable ManagedIntegrationRuntimeNodeStatus = "Available"
	// ManagedIntegrationRuntimeNodeStatusRecycling ...
	ManagedIntegrationRuntimeNodeStatusRecycling ManagedIntegrationRuntimeNodeStatus = "Recycling"
	// ManagedIntegrationRuntimeNodeStatusStarting ...
	ManagedIntegrationRuntimeNodeStatusStarting ManagedIntegrationRuntimeNodeStatus = "Starting"
	// ManagedIntegrationRuntimeNodeStatusUnavailable ...
	ManagedIntegrationRuntimeNodeStatusUnavailable ManagedIntegrationRuntimeNodeStatus = "Unavailable"
)

// PossibleManagedIntegrationRuntimeNodeStatusValues returns an array of possible values for the ManagedIntegrationRuntimeNodeStatus const type.
func PossibleManagedIntegrationRuntimeNodeStatusValues() []ManagedIntegrationRuntimeNodeStatus {
	return []ManagedIntegrationRuntimeNodeStatus{ManagedIntegrationRuntimeNodeStatusAvailable, ManagedIntegrationRuntimeNodeStatusRecycling, ManagedIntegrationRuntimeNodeStatusStarting, ManagedIntegrationRuntimeNodeStatusUnavailable}
}

// ManagementOperationState enumerates the values for management operation state.
type ManagementOperationState string

const (
	// ManagementOperationStateCancelInProgress ...
	ManagementOperationStateCancelInProgress ManagementOperationState = "CancelInProgress"
	// ManagementOperationStateCancelled ...
	ManagementOperationStateCancelled ManagementOperationState = "Cancelled"
	// ManagementOperationStateFailed ...
	ManagementOperationStateFailed ManagementOperationState = "Failed"
	// ManagementOperationStateInProgress ...
	ManagementOperationStateInProgress ManagementOperationState = "InProgress"
	// ManagementOperationStatePending ...
	ManagementOperationStatePending ManagementOperationState = "Pending"
	// ManagementOperationStateSucceeded ...
	ManagementOperationStateSucceeded ManagementOperationState = "Succeeded"
)

// PossibleManagementOperationStateValues returns an array of possible values for the ManagementOperationState const type.
func PossibleManagementOperationStateValues() []ManagementOperationState {
	return []ManagementOperationState{ManagementOperationStateCancelInProgress, ManagementOperationStateCancelled, ManagementOperationStateFailed, ManagementOperationStateInProgress, ManagementOperationStatePending, ManagementOperationStateSucceeded}
}

// NodeSize enumerates the values for node size.
type NodeSize string

const (
	// NodeSizeLarge ...
	NodeSizeLarge NodeSize = "Large"
	// NodeSizeMedium ...
	NodeSizeMedium NodeSize = "Medium"
	// NodeSizeNone ...
	NodeSizeNone NodeSize = "None"
	// NodeSizeSmall ...
	NodeSizeSmall NodeSize = "Small"
	// NodeSizeXLarge ...
	NodeSizeXLarge NodeSize = "XLarge"
	// NodeSizeXXLarge ...
	NodeSizeXXLarge NodeSize = "XXLarge"
	// NodeSizeXXXLarge ...
	NodeSizeXXXLarge NodeSize = "XXXLarge"
)

// PossibleNodeSizeValues returns an array of possible values for the NodeSize const type.
func PossibleNodeSizeValues() []NodeSize {
	return []NodeSize{NodeSizeLarge, NodeSizeMedium, NodeSizeNone, NodeSizeSmall, NodeSizeXLarge, NodeSizeXXLarge, NodeSizeXXXLarge}
}

// NodeSizeFamily enumerates the values for node size family.
type NodeSizeFamily string

const (
	// NodeSizeFamilyHardwareAcceleratedFPGA ...
	NodeSizeFamilyHardwareAcceleratedFPGA NodeSizeFamily = "HardwareAcceleratedFPGA"
	// NodeSizeFamilyHardwareAcceleratedGPU ...
	NodeSizeFamilyHardwareAcceleratedGPU NodeSizeFamily = "HardwareAcceleratedGPU"
	// NodeSizeFamilyMemoryOptimized ...
	NodeSizeFamilyMemoryOptimized NodeSizeFamily = "MemoryOptimized"
	// NodeSizeFamilyNone ...
	NodeSizeFamilyNone NodeSizeFamily = "None"
)

// PossibleNodeSizeFamilyValues returns an array of possible values for the NodeSizeFamily const type.
func PossibleNodeSizeFamilyValues() []NodeSizeFamily {
	return []NodeSizeFamily{NodeSizeFamilyHardwareAcceleratedFPGA, NodeSizeFamilyHardwareAcceleratedGPU, NodeSizeFamilyMemoryOptimized, NodeSizeFamilyNone}
}

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// OperationStatusCanceled ...
	OperationStatusCanceled OperationStatus = "Canceled"
	// OperationStatusFailed ...
	OperationStatusFailed OperationStatus = "Failed"
	// OperationStatusInProgress ...
	OperationStatusInProgress OperationStatus = "InProgress"
	// OperationStatusSucceeded ...
	OperationStatusSucceeded OperationStatus = "Succeeded"
)

// PossibleOperationStatusValues returns an array of possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{OperationStatusCanceled, OperationStatusFailed, OperationStatusInProgress, OperationStatusSucceeded}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateDeleteError ...
	ProvisioningStateDeleteError ProvisioningState = "DeleteError"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateProvisioning ...
	ProvisioningStateProvisioning ProvisioningState = "Provisioning"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateDeleteError, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateProvisioning, ProvisioningStateSucceeded}
}

// QueryAggregationFunction enumerates the values for query aggregation function.
type QueryAggregationFunction string

const (
	// QueryAggregationFunctionAvg ...
	QueryAggregationFunctionAvg QueryAggregationFunction = "avg"
	// QueryAggregationFunctionMax ...
	QueryAggregationFunctionMax QueryAggregationFunction = "max"
	// QueryAggregationFunctionMin ...
	QueryAggregationFunctionMin QueryAggregationFunction = "min"
	// QueryAggregationFunctionSum ...
	QueryAggregationFunctionSum QueryAggregationFunction = "sum"
)

// PossibleQueryAggregationFunctionValues returns an array of possible values for the QueryAggregationFunction const type.
func PossibleQueryAggregationFunctionValues() []QueryAggregationFunction {
	return []QueryAggregationFunction{QueryAggregationFunctionAvg, QueryAggregationFunctionMax, QueryAggregationFunctionMin, QueryAggregationFunctionSum}
}

// QueryExecutionType enumerates the values for query execution type.
type QueryExecutionType string

const (
	// QueryExecutionTypeAborted ...
	QueryExecutionTypeAborted QueryExecutionType = "aborted"
	// QueryExecutionTypeAny ...
	QueryExecutionTypeAny QueryExecutionType = "any"
	// QueryExecutionTypeException ...
	QueryExecutionTypeException QueryExecutionType = "exception"
	// QueryExecutionTypeIrregular ...
	QueryExecutionTypeIrregular QueryExecutionType = "irregular"
	// QueryExecutionTypeRegular ...
	QueryExecutionTypeRegular QueryExecutionType = "regular"
)

// PossibleQueryExecutionTypeValues returns an array of possible values for the QueryExecutionType const type.
func PossibleQueryExecutionTypeValues() []QueryExecutionType {
	return []QueryExecutionType{QueryExecutionTypeAborted, QueryExecutionTypeAny, QueryExecutionTypeException, QueryExecutionTypeIrregular, QueryExecutionTypeRegular}
}

// QueryMetricUnit enumerates the values for query metric unit.
type QueryMetricUnit string

const (
	// QueryMetricUnitKB ...
	QueryMetricUnitKB QueryMetricUnit = "KB"
	// QueryMetricUnitMicroseconds ...
	QueryMetricUnitMicroseconds QueryMetricUnit = "microseconds"
	// QueryMetricUnitPercentage ...
	QueryMetricUnitPercentage QueryMetricUnit = "percentage"
)

// PossibleQueryMetricUnitValues returns an array of possible values for the QueryMetricUnit const type.
func PossibleQueryMetricUnitValues() []QueryMetricUnit {
	return []QueryMetricUnit{QueryMetricUnitKB, QueryMetricUnitMicroseconds, QueryMetricUnitPercentage}
}

// QueryObservedMetricType enumerates the values for query observed metric type.
type QueryObservedMetricType string

const (
	// QueryObservedMetricTypeCPU ...
	QueryObservedMetricTypeCPU QueryObservedMetricType = "cpu"
	// QueryObservedMetricTypeDuration ...
	QueryObservedMetricTypeDuration QueryObservedMetricType = "duration"
	// QueryObservedMetricTypeExecutionCount ...
	QueryObservedMetricTypeExecutionCount QueryObservedMetricType = "executionCount"
	// QueryObservedMetricTypeIo ...
	QueryObservedMetricTypeIo QueryObservedMetricType = "io"
	// QueryObservedMetricTypeLogio ...
	QueryObservedMetricTypeLogio QueryObservedMetricType = "logio"
)

// PossibleQueryObservedMetricTypeValues returns an array of possible values for the QueryObservedMetricType const type.
func PossibleQueryObservedMetricTypeValues() []QueryObservedMetricType {
	return []QueryObservedMetricType{QueryObservedMetricTypeCPU, QueryObservedMetricTypeDuration, QueryObservedMetricTypeExecutionCount, QueryObservedMetricTypeIo, QueryObservedMetricTypeLogio}
}

// RecommendedSensitivityLabelUpdateKind enumerates the values for recommended sensitivity label update kind.
type RecommendedSensitivityLabelUpdateKind string

const (
	// RecommendedSensitivityLabelUpdateKindDisable ...
	RecommendedSensitivityLabelUpdateKindDisable RecommendedSensitivityLabelUpdateKind = "disable"
	// RecommendedSensitivityLabelUpdateKindEnable ...
	RecommendedSensitivityLabelUpdateKindEnable RecommendedSensitivityLabelUpdateKind = "enable"
)

// PossibleRecommendedSensitivityLabelUpdateKindValues returns an array of possible values for the RecommendedSensitivityLabelUpdateKind const type.
func PossibleRecommendedSensitivityLabelUpdateKindValues() []RecommendedSensitivityLabelUpdateKind {
	return []RecommendedSensitivityLabelUpdateKind{RecommendedSensitivityLabelUpdateKindDisable, RecommendedSensitivityLabelUpdateKindEnable}
}

// ReplicationRole enumerates the values for replication role.
type ReplicationRole string

const (
	// ReplicationRoleCopy ...
	ReplicationRoleCopy ReplicationRole = "Copy"
	// ReplicationRoleNonReadableSecondary ...
	ReplicationRoleNonReadableSecondary ReplicationRole = "NonReadableSecondary"
	// ReplicationRolePrimary ...
	ReplicationRolePrimary ReplicationRole = "Primary"
	// ReplicationRoleSecondary ...
	ReplicationRoleSecondary ReplicationRole = "Secondary"
	// ReplicationRoleSource ...
	ReplicationRoleSource ReplicationRole = "Source"
)

// PossibleReplicationRoleValues returns an array of possible values for the ReplicationRole const type.
func PossibleReplicationRoleValues() []ReplicationRole {
	return []ReplicationRole{ReplicationRoleCopy, ReplicationRoleNonReadableSecondary, ReplicationRolePrimary, ReplicationRoleSecondary, ReplicationRoleSource}
}

// ReplicationState enumerates the values for replication state.
type ReplicationState string

const (
	// ReplicationStateCATCHUP ...
	ReplicationStateCATCHUP ReplicationState = "CATCH_UP"
	// ReplicationStatePENDING ...
	ReplicationStatePENDING ReplicationState = "PENDING"
	// ReplicationStateSEEDING ...
	ReplicationStateSEEDING ReplicationState = "SEEDING"
	// ReplicationStateSUSPENDED ...
	ReplicationStateSUSPENDED ReplicationState = "SUSPENDED"
)

// PossibleReplicationStateValues returns an array of possible values for the ReplicationState const type.
func PossibleReplicationStateValues() []ReplicationState {
	return []ReplicationState{ReplicationStateCATCHUP, ReplicationStatePENDING, ReplicationStateSEEDING, ReplicationStateSUSPENDED}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone ...
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
	// ResourceIdentityTypeSystemAssignedUserAssigned ...
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = "SystemAssigned,UserAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned, ResourceIdentityTypeSystemAssignedUserAssigned}
}

// RestorePointType enumerates the values for restore point type.
type RestorePointType string

const (
	// RestorePointTypeCONTINUOUS ...
	RestorePointTypeCONTINUOUS RestorePointType = "CONTINUOUS"
	// RestorePointTypeDISCRETE ...
	RestorePointTypeDISCRETE RestorePointType = "DISCRETE"
)

// PossibleRestorePointTypeValues returns an array of possible values for the RestorePointType const type.
func PossibleRestorePointTypeValues() []RestorePointType {
	return []RestorePointType{RestorePointTypeCONTINUOUS, RestorePointTypeDISCRETE}
}

// SecurityAlertPolicyState enumerates the values for security alert policy state.
type SecurityAlertPolicyState string

const (
	// SecurityAlertPolicyStateDisabled ...
	SecurityAlertPolicyStateDisabled SecurityAlertPolicyState = "Disabled"
	// SecurityAlertPolicyStateEnabled ...
	SecurityAlertPolicyStateEnabled SecurityAlertPolicyState = "Enabled"
	// SecurityAlertPolicyStateNew ...
	SecurityAlertPolicyStateNew SecurityAlertPolicyState = "New"
)

// PossibleSecurityAlertPolicyStateValues returns an array of possible values for the SecurityAlertPolicyState const type.
func PossibleSecurityAlertPolicyStateValues() []SecurityAlertPolicyState {
	return []SecurityAlertPolicyState{SecurityAlertPolicyStateDisabled, SecurityAlertPolicyStateEnabled, SecurityAlertPolicyStateNew}
}

// SelfHostedIntegrationRuntimeNodeStatus enumerates the values for self hosted integration runtime node
// status.
type SelfHostedIntegrationRuntimeNodeStatus string

const (
	// SelfHostedIntegrationRuntimeNodeStatusInitializeFailed ...
	SelfHostedIntegrationRuntimeNodeStatusInitializeFailed SelfHostedIntegrationRuntimeNodeStatus = "InitializeFailed"
	// SelfHostedIntegrationRuntimeNodeStatusInitializing ...
	SelfHostedIntegrationRuntimeNodeStatusInitializing SelfHostedIntegrationRuntimeNodeStatus = "Initializing"
	// SelfHostedIntegrationRuntimeNodeStatusLimited ...
	SelfHostedIntegrationRuntimeNodeStatusLimited SelfHostedIntegrationRuntimeNodeStatus = "Limited"
	// SelfHostedIntegrationRuntimeNodeStatusNeedRegistration ...
	SelfHostedIntegrationRuntimeNodeStatusNeedRegistration SelfHostedIntegrationRuntimeNodeStatus = "NeedRegistration"
	// SelfHostedIntegrationRuntimeNodeStatusOffline ...
	SelfHostedIntegrationRuntimeNodeStatusOffline SelfHostedIntegrationRuntimeNodeStatus = "Offline"
	// SelfHostedIntegrationRuntimeNodeStatusOnline ...
	SelfHostedIntegrationRuntimeNodeStatusOnline SelfHostedIntegrationRuntimeNodeStatus = "Online"
	// SelfHostedIntegrationRuntimeNodeStatusUpgrading ...
	SelfHostedIntegrationRuntimeNodeStatusUpgrading SelfHostedIntegrationRuntimeNodeStatus = "Upgrading"
)

// PossibleSelfHostedIntegrationRuntimeNodeStatusValues returns an array of possible values for the SelfHostedIntegrationRuntimeNodeStatus const type.
func PossibleSelfHostedIntegrationRuntimeNodeStatusValues() []SelfHostedIntegrationRuntimeNodeStatus {
	return []SelfHostedIntegrationRuntimeNodeStatus{SelfHostedIntegrationRuntimeNodeStatusInitializeFailed, SelfHostedIntegrationRuntimeNodeStatusInitializing, SelfHostedIntegrationRuntimeNodeStatusLimited, SelfHostedIntegrationRuntimeNodeStatusNeedRegistration, SelfHostedIntegrationRuntimeNodeStatusOffline, SelfHostedIntegrationRuntimeNodeStatusOnline, SelfHostedIntegrationRuntimeNodeStatusUpgrading}
}

// SensitivityLabelRank enumerates the values for sensitivity label rank.
type SensitivityLabelRank string

const (
	// SensitivityLabelRankCritical ...
	SensitivityLabelRankCritical SensitivityLabelRank = "Critical"
	// SensitivityLabelRankHigh ...
	SensitivityLabelRankHigh SensitivityLabelRank = "High"
	// SensitivityLabelRankLow ...
	SensitivityLabelRankLow SensitivityLabelRank = "Low"
	// SensitivityLabelRankMedium ...
	SensitivityLabelRankMedium SensitivityLabelRank = "Medium"
	// SensitivityLabelRankNone ...
	SensitivityLabelRankNone SensitivityLabelRank = "None"
)

// PossibleSensitivityLabelRankValues returns an array of possible values for the SensitivityLabelRank const type.
func PossibleSensitivityLabelRankValues() []SensitivityLabelRank {
	return []SensitivityLabelRank{SensitivityLabelRankCritical, SensitivityLabelRankHigh, SensitivityLabelRankLow, SensitivityLabelRankMedium, SensitivityLabelRankNone}
}

// SensitivityLabelSource enumerates the values for sensitivity label source.
type SensitivityLabelSource string

const (
	// SensitivityLabelSourceCurrent ...
	SensitivityLabelSourceCurrent SensitivityLabelSource = "current"
	// SensitivityLabelSourceRecommended ...
	SensitivityLabelSourceRecommended SensitivityLabelSource = "recommended"
)

// PossibleSensitivityLabelSourceValues returns an array of possible values for the SensitivityLabelSource const type.
func PossibleSensitivityLabelSourceValues() []SensitivityLabelSource {
	return []SensitivityLabelSource{SensitivityLabelSourceCurrent, SensitivityLabelSourceRecommended}
}

// SensitivityLabelUpdateKind enumerates the values for sensitivity label update kind.
type SensitivityLabelUpdateKind string

const (
	// SensitivityLabelUpdateKindRemove ...
	SensitivityLabelUpdateKindRemove SensitivityLabelUpdateKind = "remove"
	// SensitivityLabelUpdateKindSet ...
	SensitivityLabelUpdateKindSet SensitivityLabelUpdateKind = "set"
)

// PossibleSensitivityLabelUpdateKindValues returns an array of possible values for the SensitivityLabelUpdateKind const type.
func PossibleSensitivityLabelUpdateKindValues() []SensitivityLabelUpdateKind {
	return []SensitivityLabelUpdateKind{SensitivityLabelUpdateKindRemove, SensitivityLabelUpdateKindSet}
}

// ServerKeyType enumerates the values for server key type.
type ServerKeyType string

const (
	// ServerKeyTypeAzureKeyVault ...
	ServerKeyTypeAzureKeyVault ServerKeyType = "AzureKeyVault"
	// ServerKeyTypeServiceManaged ...
	ServerKeyTypeServiceManaged ServerKeyType = "ServiceManaged"
)

// PossibleServerKeyTypeValues returns an array of possible values for the ServerKeyType const type.
func PossibleServerKeyTypeValues() []ServerKeyType {
	return []ServerKeyType{ServerKeyTypeAzureKeyVault, ServerKeyTypeServiceManaged}
}

// SsisObjectMetadataType enumerates the values for ssis object metadata type.
type SsisObjectMetadataType string

const (
	// SsisObjectMetadataTypeEnvironment ...
	SsisObjectMetadataTypeEnvironment SsisObjectMetadataType = "Environment"
	// SsisObjectMetadataTypeFolder ...
	SsisObjectMetadataTypeFolder SsisObjectMetadataType = "Folder"
	// SsisObjectMetadataTypePackage ...
	SsisObjectMetadataTypePackage SsisObjectMetadataType = "Package"
	// SsisObjectMetadataTypeProject ...
	SsisObjectMetadataTypeProject SsisObjectMetadataType = "Project"
)

// PossibleSsisObjectMetadataTypeValues returns an array of possible values for the SsisObjectMetadataType const type.
func PossibleSsisObjectMetadataTypeValues() []SsisObjectMetadataType {
	return []SsisObjectMetadataType{SsisObjectMetadataTypeEnvironment, SsisObjectMetadataTypeFolder, SsisObjectMetadataTypePackage, SsisObjectMetadataTypeProject}
}

// StorageAccountType enumerates the values for storage account type.
type StorageAccountType string

const (
	// StorageAccountTypeGRS ...
	StorageAccountTypeGRS StorageAccountType = "GRS"
	// StorageAccountTypeLRS ...
	StorageAccountTypeLRS StorageAccountType = "LRS"
	// StorageAccountTypeZRS ...
	StorageAccountTypeZRS StorageAccountType = "ZRS"
)

// PossibleStorageAccountTypeValues returns an array of possible values for the StorageAccountType const type.
func PossibleStorageAccountTypeValues() []StorageAccountType {
	return []StorageAccountType{StorageAccountTypeGRS, StorageAccountTypeLRS, StorageAccountTypeZRS}
}

// TransparentDataEncryptionStatus enumerates the values for transparent data encryption status.
type TransparentDataEncryptionStatus string

const (
	// TransparentDataEncryptionStatusDisabled ...
	TransparentDataEncryptionStatusDisabled TransparentDataEncryptionStatus = "Disabled"
	// TransparentDataEncryptionStatusEnabled ...
	TransparentDataEncryptionStatusEnabled TransparentDataEncryptionStatus = "Enabled"
)

// PossibleTransparentDataEncryptionStatusValues returns an array of possible values for the TransparentDataEncryptionStatus const type.
func PossibleTransparentDataEncryptionStatusValues() []TransparentDataEncryptionStatus {
	return []TransparentDataEncryptionStatus{TransparentDataEncryptionStatusDisabled, TransparentDataEncryptionStatusEnabled}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeIntegrationRuntime ...
	TypeIntegrationRuntime Type = "IntegrationRuntime"
	// TypeManaged ...
	TypeManaged Type = "Managed"
	// TypeSelfHosted ...
	TypeSelfHosted Type = "SelfHosted"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeIntegrationRuntime, TypeManaged, TypeSelfHosted}
}

// TypeBasicCustomSetupBase enumerates the values for type basic custom setup base.
type TypeBasicCustomSetupBase string

const (
	// TypeBasicCustomSetupBaseTypeCmdkeySetup ...
	TypeBasicCustomSetupBaseTypeCmdkeySetup TypeBasicCustomSetupBase = "CmdkeySetup"
	// TypeBasicCustomSetupBaseTypeComponentSetup ...
	TypeBasicCustomSetupBaseTypeComponentSetup TypeBasicCustomSetupBase = "ComponentSetup"
	// TypeBasicCustomSetupBaseTypeCustomSetupBase ...
	TypeBasicCustomSetupBaseTypeCustomSetupBase TypeBasicCustomSetupBase = "CustomSetupBase"
	// TypeBasicCustomSetupBaseTypeEnvironmentVariableSetup ...
	TypeBasicCustomSetupBaseTypeEnvironmentVariableSetup TypeBasicCustomSetupBase = "EnvironmentVariableSetup"
)

// PossibleTypeBasicCustomSetupBaseValues returns an array of possible values for the TypeBasicCustomSetupBase const type.
func PossibleTypeBasicCustomSetupBaseValues() []TypeBasicCustomSetupBase {
	return []TypeBasicCustomSetupBase{TypeBasicCustomSetupBaseTypeCmdkeySetup, TypeBasicCustomSetupBaseTypeComponentSetup, TypeBasicCustomSetupBaseTypeCustomSetupBase, TypeBasicCustomSetupBaseTypeEnvironmentVariableSetup}
}

// TypeBasicIntegrationRuntimeStatus enumerates the values for type basic integration runtime status.
type TypeBasicIntegrationRuntimeStatus string

const (
	// TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus ...
	TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus TypeBasicIntegrationRuntimeStatus = "IntegrationRuntimeStatus"
	// TypeBasicIntegrationRuntimeStatusTypeManaged ...
	TypeBasicIntegrationRuntimeStatusTypeManaged TypeBasicIntegrationRuntimeStatus = "Managed"
	// TypeBasicIntegrationRuntimeStatusTypeSelfHosted ...
	TypeBasicIntegrationRuntimeStatusTypeSelfHosted TypeBasicIntegrationRuntimeStatus = "SelfHosted"
)

// PossibleTypeBasicIntegrationRuntimeStatusValues returns an array of possible values for the TypeBasicIntegrationRuntimeStatus const type.
func PossibleTypeBasicIntegrationRuntimeStatusValues() []TypeBasicIntegrationRuntimeStatus {
	return []TypeBasicIntegrationRuntimeStatus{TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus, TypeBasicIntegrationRuntimeStatusTypeManaged, TypeBasicIntegrationRuntimeStatusTypeSelfHosted}
}

// TypeBasicSecretBase enumerates the values for type basic secret base.
type TypeBasicSecretBase string

const (
	// TypeBasicSecretBaseTypeSecretBase ...
	TypeBasicSecretBaseTypeSecretBase TypeBasicSecretBase = "SecretBase"
	// TypeBasicSecretBaseTypeSecureString ...
	TypeBasicSecretBaseTypeSecureString TypeBasicSecretBase = "SecureString"
)

// PossibleTypeBasicSecretBaseValues returns an array of possible values for the TypeBasicSecretBase const type.
func PossibleTypeBasicSecretBaseValues() []TypeBasicSecretBase {
	return []TypeBasicSecretBase{TypeBasicSecretBaseTypeSecretBase, TypeBasicSecretBaseTypeSecureString}
}

// TypeBasicSsisObjectMetadata enumerates the values for type basic ssis object metadata.
type TypeBasicSsisObjectMetadata string

const (
	// TypeBasicSsisObjectMetadataTypeEnvironment ...
	TypeBasicSsisObjectMetadataTypeEnvironment TypeBasicSsisObjectMetadata = "Environment"
	// TypeBasicSsisObjectMetadataTypeFolder ...
	TypeBasicSsisObjectMetadataTypeFolder TypeBasicSsisObjectMetadata = "Folder"
	// TypeBasicSsisObjectMetadataTypePackage ...
	TypeBasicSsisObjectMetadataTypePackage TypeBasicSsisObjectMetadata = "Package"
	// TypeBasicSsisObjectMetadataTypeProject ...
	TypeBasicSsisObjectMetadataTypeProject TypeBasicSsisObjectMetadata = "Project"
	// TypeBasicSsisObjectMetadataTypeSsisObjectMetadata ...
	TypeBasicSsisObjectMetadataTypeSsisObjectMetadata TypeBasicSsisObjectMetadata = "SsisObjectMetadata"
)

// PossibleTypeBasicSsisObjectMetadataValues returns an array of possible values for the TypeBasicSsisObjectMetadata const type.
func PossibleTypeBasicSsisObjectMetadataValues() []TypeBasicSsisObjectMetadata {
	return []TypeBasicSsisObjectMetadata{TypeBasicSsisObjectMetadataTypeEnvironment, TypeBasicSsisObjectMetadataTypeFolder, TypeBasicSsisObjectMetadataTypePackage, TypeBasicSsisObjectMetadataTypeProject, TypeBasicSsisObjectMetadataTypeSsisObjectMetadata}
}

// VulnerabilityAssessmentPolicyBaselineName enumerates the values for vulnerability assessment policy baseline
// name.
type VulnerabilityAssessmentPolicyBaselineName string

const (
	// VulnerabilityAssessmentPolicyBaselineNameDefault ...
	VulnerabilityAssessmentPolicyBaselineNameDefault VulnerabilityAssessmentPolicyBaselineName = "default"
	// VulnerabilityAssessmentPolicyBaselineNameMaster ...
	VulnerabilityAssessmentPolicyBaselineNameMaster VulnerabilityAssessmentPolicyBaselineName = "master"
)

// PossibleVulnerabilityAssessmentPolicyBaselineNameValues returns an array of possible values for the VulnerabilityAssessmentPolicyBaselineName const type.
func PossibleVulnerabilityAssessmentPolicyBaselineNameValues() []VulnerabilityAssessmentPolicyBaselineName {
	return []VulnerabilityAssessmentPolicyBaselineName{VulnerabilityAssessmentPolicyBaselineNameDefault, VulnerabilityAssessmentPolicyBaselineNameMaster}
}

// VulnerabilityAssessmentScanState enumerates the values for vulnerability assessment scan state.
type VulnerabilityAssessmentScanState string

const (
	// VulnerabilityAssessmentScanStateFailed ...
	VulnerabilityAssessmentScanStateFailed VulnerabilityAssessmentScanState = "Failed"
	// VulnerabilityAssessmentScanStateFailedToRun ...
	VulnerabilityAssessmentScanStateFailedToRun VulnerabilityAssessmentScanState = "FailedToRun"
	// VulnerabilityAssessmentScanStateInProgress ...
	VulnerabilityAssessmentScanStateInProgress VulnerabilityAssessmentScanState = "InProgress"
	// VulnerabilityAssessmentScanStatePassed ...
	VulnerabilityAssessmentScanStatePassed VulnerabilityAssessmentScanState = "Passed"
)

// PossibleVulnerabilityAssessmentScanStateValues returns an array of possible values for the VulnerabilityAssessmentScanState const type.
func PossibleVulnerabilityAssessmentScanStateValues() []VulnerabilityAssessmentScanState {
	return []VulnerabilityAssessmentScanState{VulnerabilityAssessmentScanStateFailed, VulnerabilityAssessmentScanStateFailedToRun, VulnerabilityAssessmentScanStateInProgress, VulnerabilityAssessmentScanStatePassed}
}

// VulnerabilityAssessmentScanTriggerType enumerates the values for vulnerability assessment scan trigger type.
type VulnerabilityAssessmentScanTriggerType string

const (
	// VulnerabilityAssessmentScanTriggerTypeOnDemand ...
	VulnerabilityAssessmentScanTriggerTypeOnDemand VulnerabilityAssessmentScanTriggerType = "OnDemand"
	// VulnerabilityAssessmentScanTriggerTypeRecurring ...
	VulnerabilityAssessmentScanTriggerTypeRecurring VulnerabilityAssessmentScanTriggerType = "Recurring"
)

// PossibleVulnerabilityAssessmentScanTriggerTypeValues returns an array of possible values for the VulnerabilityAssessmentScanTriggerType const type.
func PossibleVulnerabilityAssessmentScanTriggerTypeValues() []VulnerabilityAssessmentScanTriggerType {
	return []VulnerabilityAssessmentScanTriggerType{VulnerabilityAssessmentScanTriggerTypeOnDemand, VulnerabilityAssessmentScanTriggerTypeRecurring}
}

// WorkspacePublicNetworkAccess enumerates the values for workspace public network access.
type WorkspacePublicNetworkAccess string

const (
	// WorkspacePublicNetworkAccessDisabled ...
	WorkspacePublicNetworkAccessDisabled WorkspacePublicNetworkAccess = "Disabled"
	// WorkspacePublicNetworkAccessEnabled ...
	WorkspacePublicNetworkAccessEnabled WorkspacePublicNetworkAccess = "Enabled"
)

// PossibleWorkspacePublicNetworkAccessValues returns an array of possible values for the WorkspacePublicNetworkAccess const type.
func PossibleWorkspacePublicNetworkAccessValues() []WorkspacePublicNetworkAccess {
	return []WorkspacePublicNetworkAccess{WorkspacePublicNetworkAccessDisabled, WorkspacePublicNetworkAccessEnabled}
}
