#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 4165
#define LARGE_STATE_COUNT 405
#define SYMBOL_COUNT 182
#define ALIAS_COUNT 0
#define TOKEN_COUNT 116
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 20
#define MAX_ALIAS_SEQUENCE_LENGTH 14
#define PRODUCTION_ID_COUNT 177

enum ts_symbol_identifiers {
  sym__ws = 1,
  sym_comment = 2,
  anon_sym_POUND_ = 3,
  anon_sym_POUND = 4,
  aux_sym__form_token1 = 5,
  anon_sym_DOT = 6,
  aux_sym_num_lit_token1 = 7,
  aux_sym_num_lit_token2 = 8,
  anon_sym_COLON = 9,
  anon_sym_COLON_COLON = 10,
  anon_sym_DQUOTE = 11,
  aux_sym_str_lit_token1 = 12,
  aux_sym_str_lit_token2 = 13,
  anon_sym_TILDE = 14,
  aux_sym_char_lit_token1 = 15,
  sym_nil_lit = 16,
  aux_sym_sym_lit_token1 = 17,
  anon_sym_CARET = 18,
  anon_sym_POUND_CARET = 19,
  anon_sym_LPAREN = 20,
  anon_sym_RPAREN = 21,
  anon_sym_LBRACE = 22,
  anon_sym_RBRACE = 23,
  anon_sym_POUND0A = 24,
  anon_sym_POUND0a = 25,
  anon_sym_POUND_QMARK = 26,
  anon_sym_POUND_QMARK_AT = 27,
  anon_sym_POUND_SQUOTE = 28,
  anon_sym_SQUOTE = 29,
  anon_sym_BQUOTE = 30,
  anon_sym_COMMA_AT = 31,
  anon_sym_COMMA = 32,
  sym_block_comment = 33,
  sym_fancy_literal = 34,
  aux_sym__format_token_token1 = 35,
  anon_sym_v = 36,
  anon_sym_V = 37,
  anon_sym_AT = 38,
  anon_sym_AT_COLON = 39,
  anon_sym_COLON_AT = 40,
  anon_sym_PERCENT = 41,
  anon_sym_AMP = 42,
  anon_sym_PIPE = 43,
  aux_sym_format_directive_type_token1 = 44,
  aux_sym_format_directive_type_token2 = 45,
  anon_sym_LF = 46,
  anon_sym_CR = 47,
  aux_sym_format_directive_type_token3 = 48,
  aux_sym_format_directive_type_token4 = 49,
  aux_sym_format_directive_type_token5 = 50,
  aux_sym_format_directive_type_token6 = 51,
  anon_sym__ = 52,
  aux_sym_format_directive_type_token7 = 53,
  aux_sym_format_directive_type_token8 = 54,
  aux_sym_format_directive_type_token9 = 55,
  aux_sym_format_directive_type_token10 = 56,
  anon_sym_SEMI = 57,
  anon_sym_STAR = 58,
  anon_sym_SLASH = 59,
  anon_sym_QMARK = 60,
  anon_sym_Newline = 61,
  aux_sym_format_directive_type_token11 = 62,
  anon_sym_cl = 63,
  anon_sym_in = 64,
  anon_sym_across = 65,
  anon_sym_being = 66,
  anon_sym_using = 67,
  aux_sym_for_clause_word_token1 = 68,
  anon_sym_below = 69,
  anon_sym_above = 70,
  anon_sym_from = 71,
  anon_sym_to = 72,
  anon_sym_upto = 73,
  anon_sym_upfrom = 74,
  anon_sym_downto = 75,
  anon_sym_downfrom = 76,
  anon_sym_on = 77,
  anon_sym_by = 78,
  anon_sym_then = 79,
  anon_sym_EQ = 80,
  aux_sym_accumulation_verb_token1 = 81,
  anon_sym_for = 82,
  anon_sym_and = 83,
  anon_sym_as = 84,
  anon_sym_with = 85,
  anon_sym_do = 86,
  anon_sym_while = 87,
  anon_sym_until = 88,
  anon_sym_repeat = 89,
  anon_sym_when = 90,
  anon_sym_if = 91,
  anon_sym_unless = 92,
  anon_sym_always = 93,
  anon_sym_thereis = 94,
  anon_sym_never = 95,
  anon_sym_else = 96,
  anon_sym_into = 97,
  anon_sym_finally = 98,
  anon_sym_return = 99,
  anon_sym_initially = 100,
  anon_sym_loop = 101,
  anon_sym_defun = 102,
  anon_sym_defmacro = 103,
  anon_sym_defgeneric = 104,
  anon_sym_defmethod = 105,
  anon_sym_lambda = 106,
  anon_sym_POUNDP = 107,
  anon_sym_POUNDp = 108,
  aux_sym_path_lit_token1 = 109,
  aux_sym__sym_lit_without_slash_token1 = 110,
  sym_self_referential_reader_macro = 111,
  anon_sym_POUND_PLUS = 112,
  anon_sym_POUND_DASH = 113,
  anon_sym_POUNDC = 114,
  anon_sym_POUNDc = 115,
  sym_source = 116,
  sym__gap = 117,
  sym_dis_expr = 118,
  sym__form = 119,
  sym_num_lit = 120,
  sym_kwd_lit = 121,
  sym_str_lit = 122,
  sym_char_lit = 123,
  sym_sym_lit = 124,
  sym__metadata_lit = 125,
  sym_meta_lit = 126,
  sym_old_meta_lit = 127,
  sym_list_lit = 128,
  sym__bare_list_lit = 129,
  sym_map_lit = 130,
  sym__bare_map_lit = 131,
  sym_vec_lit = 132,
  sym_set_lit = 133,
  sym__bare_set_lit = 134,
  sym_read_cond_lit = 135,
  sym_splicing_read_cond_lit = 136,
  sym_var_quoting_lit = 137,
  sym_quoting_lit = 138,
  sym_syn_quoting_lit = 139,
  sym_unquote_splicing_lit = 140,
  sym_unquoting_lit = 141,
  sym_defun = 142,
  sym__format_token = 143,
  sym_format_prefix_parameters = 144,
  sym_format_modifiers = 145,
  sym_format_directive_type = 146,
  sym_format_specifier = 147,
  sym_for_clause_word = 148,
  sym__for_part = 149,
  sym_accumulation_verb = 150,
  sym_for_clause = 151,
  sym_with_clause = 152,
  sym_do_clause = 153,
  sym_while_clause = 154,
  sym_repeat_clause = 155,
  sym_condition_clause = 156,
  sym_accumulation_clause = 157,
  sym_termination_clause = 158,
  sym_loop_clause = 159,
  sym_loop_macro = 160,
  sym_defun_keyword = 161,
  sym_defun_header = 162,
  sym_array_dimension = 163,
  sym_path_lit = 164,
  sym_package_lit = 165,
  sym__package_lit_without_slash = 166,
  sym__sym_lit_without_slash = 167,
  sym_kwd_symbol = 168,
  sym_include_reader_macro = 169,
  sym_complex_num_lit = 170,
  aux_sym_source_repeat1 = 171,
  aux_sym_dis_expr_repeat1 = 172,
  aux_sym_str_lit_repeat1 = 173,
  aux_sym_list_lit_repeat1 = 174,
  aux_sym__bare_list_lit_repeat1 = 175,
  aux_sym_read_cond_lit_repeat1 = 176,
  aux_sym_format_modifiers_repeat1 = 177,
  aux_sym_for_clause_repeat1 = 178,
  aux_sym_do_clause_repeat1 = 179,
  aux_sym_loop_macro_repeat1 = 180,
  aux_sym__sym_lit_without_slash_repeat1 = 181,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__ws] = "_ws",
  [sym_comment] = "comment",
  [anon_sym_POUND_] = "#_",
  [anon_sym_POUND] = "#",
  [aux_sym__form_token1] = "_form_token1",
  [anon_sym_DOT] = ".",
  [aux_sym_num_lit_token1] = "num_lit_token1",
  [aux_sym_num_lit_token2] = "num_lit_token2",
  [anon_sym_COLON] = ":",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_str_lit_token1] = "str_lit_token1",
  [aux_sym_str_lit_token2] = "str_lit_token2",
  [anon_sym_TILDE] = "~",
  [aux_sym_char_lit_token1] = "char_lit_token1",
  [sym_nil_lit] = "nil_lit",
  [aux_sym_sym_lit_token1] = "sym_lit_token1",
  [anon_sym_CARET] = "^",
  [anon_sym_POUND_CARET] = "#^",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_POUND0A] = "#0A",
  [anon_sym_POUND0a] = "#0a",
  [anon_sym_POUND_QMARK] = "#\?",
  [anon_sym_POUND_QMARK_AT] = "#\?@",
  [anon_sym_POUND_SQUOTE] = "#'",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_COMMA_AT] = ",@",
  [anon_sym_COMMA] = ",",
  [sym_block_comment] = "block_comment",
  [sym_fancy_literal] = "fancy_literal",
  [aux_sym__format_token_token1] = "char_lit",
  [anon_sym_v] = "v",
  [anon_sym_V] = "V",
  [anon_sym_AT] = "@",
  [anon_sym_AT_COLON] = "@:",
  [anon_sym_COLON_AT] = ":@",
  [anon_sym_PERCENT] = "%",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE] = "|",
  [aux_sym_format_directive_type_token1] = "format_directive_type_token1",
  [aux_sym_format_directive_type_token2] = "format_directive_type_token2",
  [anon_sym_LF] = "\n",
  [anon_sym_CR] = "\r",
  [aux_sym_format_directive_type_token3] = "format_directive_type_token3",
  [aux_sym_format_directive_type_token4] = "format_directive_type_token4",
  [aux_sym_format_directive_type_token5] = "format_directive_type_token5",
  [aux_sym_format_directive_type_token6] = "format_directive_type_token6",
  [anon_sym__] = "_",
  [aux_sym_format_directive_type_token7] = "format_directive_type_token7",
  [aux_sym_format_directive_type_token8] = "format_directive_type_token8",
  [aux_sym_format_directive_type_token9] = "format_directive_type_token9",
  [aux_sym_format_directive_type_token10] = "format_directive_type_token10",
  [anon_sym_SEMI] = ";",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_QMARK] = "\?",
  [anon_sym_Newline] = "Newline",
  [aux_sym_format_directive_type_token11] = "format_directive_type_token11",
  [anon_sym_cl] = "cl",
  [anon_sym_in] = "in",
  [anon_sym_across] = "across",
  [anon_sym_being] = "being",
  [anon_sym_using] = "using",
  [aux_sym_for_clause_word_token1] = "for_clause_word_token1",
  [anon_sym_below] = "below",
  [anon_sym_above] = "above",
  [anon_sym_from] = "from",
  [anon_sym_to] = "to",
  [anon_sym_upto] = "upto",
  [anon_sym_upfrom] = "upfrom",
  [anon_sym_downto] = "downto",
  [anon_sym_downfrom] = "downfrom",
  [anon_sym_on] = "on",
  [anon_sym_by] = "by",
  [anon_sym_then] = "then",
  [anon_sym_EQ] = "=",
  [aux_sym_accumulation_verb_token1] = "accumulation_verb_token1",
  [anon_sym_for] = "for",
  [anon_sym_and] = "and",
  [anon_sym_as] = "as",
  [anon_sym_with] = "with",
  [anon_sym_do] = "do",
  [anon_sym_while] = "while",
  [anon_sym_until] = "until",
  [anon_sym_repeat] = "repeat",
  [anon_sym_when] = "when",
  [anon_sym_if] = "if",
  [anon_sym_unless] = "unless",
  [anon_sym_always] = "always",
  [anon_sym_thereis] = "thereis",
  [anon_sym_never] = "never",
  [anon_sym_else] = "else",
  [anon_sym_into] = "into",
  [anon_sym_finally] = "finally",
  [anon_sym_return] = "return",
  [anon_sym_initially] = "initially",
  [anon_sym_loop] = "loop",
  [anon_sym_defun] = "defun",
  [anon_sym_defmacro] = "defmacro",
  [anon_sym_defgeneric] = "defgeneric",
  [anon_sym_defmethod] = "defmethod",
  [anon_sym_lambda] = "defun_keyword",
  [anon_sym_POUNDP] = "#P",
  [anon_sym_POUNDp] = "#p",
  [aux_sym_path_lit_token1] = "str_lit",
  [aux_sym__sym_lit_without_slash_token1] = "_sym_lit_without_slash_token1",
  [sym_self_referential_reader_macro] = "self_referential_reader_macro",
  [anon_sym_POUND_PLUS] = "#+",
  [anon_sym_POUND_DASH] = "#-",
  [anon_sym_POUNDC] = "#C",
  [anon_sym_POUNDc] = "#c",
  [sym_source] = "source",
  [sym__gap] = "_gap",
  [sym_dis_expr] = "dis_expr",
  [sym__form] = "_form",
  [sym_num_lit] = "num_lit",
  [sym_kwd_lit] = "kwd_lit",
  [sym_str_lit] = "str_lit",
  [sym_char_lit] = "char_lit",
  [sym_sym_lit] = "sym_lit",
  [sym__metadata_lit] = "_metadata_lit",
  [sym_meta_lit] = "meta_lit",
  [sym_old_meta_lit] = "old_meta_lit",
  [sym_list_lit] = "list_lit",
  [sym__bare_list_lit] = "_bare_list_lit",
  [sym_map_lit] = "map_lit",
  [sym__bare_map_lit] = "_bare_map_lit",
  [sym_vec_lit] = "vec_lit",
  [sym_set_lit] = "set_lit",
  [sym__bare_set_lit] = "_bare_set_lit",
  [sym_read_cond_lit] = "read_cond_lit",
  [sym_splicing_read_cond_lit] = "splicing_read_cond_lit",
  [sym_var_quoting_lit] = "var_quoting_lit",
  [sym_quoting_lit] = "quoting_lit",
  [sym_syn_quoting_lit] = "syn_quoting_lit",
  [sym_unquote_splicing_lit] = "unquote_splicing_lit",
  [sym_unquoting_lit] = "unquoting_lit",
  [sym_defun] = "defun",
  [sym__format_token] = "_format_token",
  [sym_format_prefix_parameters] = "format_prefix_parameters",
  [sym_format_modifiers] = "format_modifiers",
  [sym_format_directive_type] = "format_directive_type",
  [sym_format_specifier] = "format_specifier",
  [sym_for_clause_word] = "for_clause_word",
  [sym__for_part] = "_for_part",
  [sym_accumulation_verb] = "accumulation_verb",
  [sym_for_clause] = "for_clause",
  [sym_with_clause] = "with_clause",
  [sym_do_clause] = "do_clause",
  [sym_while_clause] = "while_clause",
  [sym_repeat_clause] = "repeat_clause",
  [sym_condition_clause] = "condition_clause",
  [sym_accumulation_clause] = "accumulation_clause",
  [sym_termination_clause] = "termination_clause",
  [sym_loop_clause] = "loop_clause",
  [sym_loop_macro] = "loop_macro",
  [sym_defun_keyword] = "defun_keyword",
  [sym_defun_header] = "defun_header",
  [sym_array_dimension] = "array_dimension",
  [sym_path_lit] = "path_lit",
  [sym_package_lit] = "package_lit",
  [sym__package_lit_without_slash] = "package_lit",
  [sym__sym_lit_without_slash] = "_sym_lit_without_slash",
  [sym_kwd_symbol] = "kwd_symbol",
  [sym_include_reader_macro] = "include_reader_macro",
  [sym_complex_num_lit] = "complex_num_lit",
  [aux_sym_source_repeat1] = "source_repeat1",
  [aux_sym_dis_expr_repeat1] = "dis_expr_repeat1",
  [aux_sym_str_lit_repeat1] = "str_lit_repeat1",
  [aux_sym_list_lit_repeat1] = "list_lit_repeat1",
  [aux_sym__bare_list_lit_repeat1] = "_bare_list_lit_repeat1",
  [aux_sym_read_cond_lit_repeat1] = "read_cond_lit_repeat1",
  [aux_sym_format_modifiers_repeat1] = "format_modifiers_repeat1",
  [aux_sym_for_clause_repeat1] = "for_clause_repeat1",
  [aux_sym_do_clause_repeat1] = "do_clause_repeat1",
  [aux_sym_loop_macro_repeat1] = "loop_macro_repeat1",
  [aux_sym__sym_lit_without_slash_repeat1] = "_sym_lit_without_slash_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__ws] = sym__ws,
  [sym_comment] = sym_comment,
  [anon_sym_POUND_] = anon_sym_POUND_,
  [anon_sym_POUND] = anon_sym_POUND,
  [aux_sym__form_token1] = aux_sym__form_token1,
  [anon_sym_DOT] = anon_sym_DOT,
  [aux_sym_num_lit_token1] = aux_sym_num_lit_token1,
  [aux_sym_num_lit_token2] = aux_sym_num_lit_token2,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_str_lit_token1] = aux_sym_str_lit_token1,
  [aux_sym_str_lit_token2] = aux_sym_str_lit_token2,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [aux_sym_char_lit_token1] = aux_sym_char_lit_token1,
  [sym_nil_lit] = sym_nil_lit,
  [aux_sym_sym_lit_token1] = aux_sym_sym_lit_token1,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_POUND_CARET] = anon_sym_POUND_CARET,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_POUND0A] = anon_sym_POUND0A,
  [anon_sym_POUND0a] = anon_sym_POUND0a,
  [anon_sym_POUND_QMARK] = anon_sym_POUND_QMARK,
  [anon_sym_POUND_QMARK_AT] = anon_sym_POUND_QMARK_AT,
  [anon_sym_POUND_SQUOTE] = anon_sym_POUND_SQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_COMMA_AT] = anon_sym_COMMA_AT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [sym_block_comment] = sym_block_comment,
  [sym_fancy_literal] = sym_fancy_literal,
  [aux_sym__format_token_token1] = sym_char_lit,
  [anon_sym_v] = anon_sym_v,
  [anon_sym_V] = anon_sym_V,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_AT_COLON] = anon_sym_AT_COLON,
  [anon_sym_COLON_AT] = anon_sym_COLON_AT,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [aux_sym_format_directive_type_token1] = aux_sym_format_directive_type_token1,
  [aux_sym_format_directive_type_token2] = aux_sym_format_directive_type_token2,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_CR] = anon_sym_CR,
  [aux_sym_format_directive_type_token3] = aux_sym_format_directive_type_token3,
  [aux_sym_format_directive_type_token4] = aux_sym_format_directive_type_token4,
  [aux_sym_format_directive_type_token5] = aux_sym_format_directive_type_token5,
  [aux_sym_format_directive_type_token6] = aux_sym_format_directive_type_token6,
  [anon_sym__] = anon_sym__,
  [aux_sym_format_directive_type_token7] = aux_sym_format_directive_type_token7,
  [aux_sym_format_directive_type_token8] = aux_sym_format_directive_type_token8,
  [aux_sym_format_directive_type_token9] = aux_sym_format_directive_type_token9,
  [aux_sym_format_directive_type_token10] = aux_sym_format_directive_type_token10,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_Newline] = anon_sym_Newline,
  [aux_sym_format_directive_type_token11] = aux_sym_format_directive_type_token11,
  [anon_sym_cl] = anon_sym_cl,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_across] = anon_sym_across,
  [anon_sym_being] = anon_sym_being,
  [anon_sym_using] = anon_sym_using,
  [aux_sym_for_clause_word_token1] = aux_sym_for_clause_word_token1,
  [anon_sym_below] = anon_sym_below,
  [anon_sym_above] = anon_sym_above,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_to] = anon_sym_to,
  [anon_sym_upto] = anon_sym_upto,
  [anon_sym_upfrom] = anon_sym_upfrom,
  [anon_sym_downto] = anon_sym_downto,
  [anon_sym_downfrom] = anon_sym_downfrom,
  [anon_sym_on] = anon_sym_on,
  [anon_sym_by] = anon_sym_by,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_EQ] = anon_sym_EQ,
  [aux_sym_accumulation_verb_token1] = aux_sym_accumulation_verb_token1,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_until] = anon_sym_until,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_when] = anon_sym_when,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_unless] = anon_sym_unless,
  [anon_sym_always] = anon_sym_always,
  [anon_sym_thereis] = anon_sym_thereis,
  [anon_sym_never] = anon_sym_never,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_into] = anon_sym_into,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_initially] = anon_sym_initially,
  [anon_sym_loop] = anon_sym_loop,
  [anon_sym_defun] = anon_sym_defun,
  [anon_sym_defmacro] = anon_sym_defmacro,
  [anon_sym_defgeneric] = anon_sym_defgeneric,
  [anon_sym_defmethod] = anon_sym_defmethod,
  [anon_sym_lambda] = sym_defun_keyword,
  [anon_sym_POUNDP] = anon_sym_POUNDP,
  [anon_sym_POUNDp] = anon_sym_POUNDp,
  [aux_sym_path_lit_token1] = sym_str_lit,
  [aux_sym__sym_lit_without_slash_token1] = aux_sym__sym_lit_without_slash_token1,
  [sym_self_referential_reader_macro] = sym_self_referential_reader_macro,
  [anon_sym_POUND_PLUS] = anon_sym_POUND_PLUS,
  [anon_sym_POUND_DASH] = anon_sym_POUND_DASH,
  [anon_sym_POUNDC] = anon_sym_POUNDC,
  [anon_sym_POUNDc] = anon_sym_POUNDc,
  [sym_source] = sym_source,
  [sym__gap] = sym__gap,
  [sym_dis_expr] = sym_dis_expr,
  [sym__form] = sym__form,
  [sym_num_lit] = sym_num_lit,
  [sym_kwd_lit] = sym_kwd_lit,
  [sym_str_lit] = sym_str_lit,
  [sym_char_lit] = sym_char_lit,
  [sym_sym_lit] = sym_sym_lit,
  [sym__metadata_lit] = sym__metadata_lit,
  [sym_meta_lit] = sym_meta_lit,
  [sym_old_meta_lit] = sym_old_meta_lit,
  [sym_list_lit] = sym_list_lit,
  [sym__bare_list_lit] = sym__bare_list_lit,
  [sym_map_lit] = sym_map_lit,
  [sym__bare_map_lit] = sym__bare_map_lit,
  [sym_vec_lit] = sym_vec_lit,
  [sym_set_lit] = sym_set_lit,
  [sym__bare_set_lit] = sym__bare_set_lit,
  [sym_read_cond_lit] = sym_read_cond_lit,
  [sym_splicing_read_cond_lit] = sym_splicing_read_cond_lit,
  [sym_var_quoting_lit] = sym_var_quoting_lit,
  [sym_quoting_lit] = sym_quoting_lit,
  [sym_syn_quoting_lit] = sym_syn_quoting_lit,
  [sym_unquote_splicing_lit] = sym_unquote_splicing_lit,
  [sym_unquoting_lit] = sym_unquoting_lit,
  [sym_defun] = sym_defun,
  [sym__format_token] = sym__format_token,
  [sym_format_prefix_parameters] = sym_format_prefix_parameters,
  [sym_format_modifiers] = sym_format_modifiers,
  [sym_format_directive_type] = sym_format_directive_type,
  [sym_format_specifier] = sym_format_specifier,
  [sym_for_clause_word] = sym_for_clause_word,
  [sym__for_part] = sym__for_part,
  [sym_accumulation_verb] = sym_accumulation_verb,
  [sym_for_clause] = sym_for_clause,
  [sym_with_clause] = sym_with_clause,
  [sym_do_clause] = sym_do_clause,
  [sym_while_clause] = sym_while_clause,
  [sym_repeat_clause] = sym_repeat_clause,
  [sym_condition_clause] = sym_condition_clause,
  [sym_accumulation_clause] = sym_accumulation_clause,
  [sym_termination_clause] = sym_termination_clause,
  [sym_loop_clause] = sym_loop_clause,
  [sym_loop_macro] = sym_loop_macro,
  [sym_defun_keyword] = sym_defun_keyword,
  [sym_defun_header] = sym_defun_header,
  [sym_array_dimension] = sym_array_dimension,
  [sym_path_lit] = sym_path_lit,
  [sym_package_lit] = sym_package_lit,
  [sym__package_lit_without_slash] = sym_package_lit,
  [sym__sym_lit_without_slash] = sym__sym_lit_without_slash,
  [sym_kwd_symbol] = sym_kwd_symbol,
  [sym_include_reader_macro] = sym_include_reader_macro,
  [sym_complex_num_lit] = sym_complex_num_lit,
  [aux_sym_source_repeat1] = aux_sym_source_repeat1,
  [aux_sym_dis_expr_repeat1] = aux_sym_dis_expr_repeat1,
  [aux_sym_str_lit_repeat1] = aux_sym_str_lit_repeat1,
  [aux_sym_list_lit_repeat1] = aux_sym_list_lit_repeat1,
  [aux_sym__bare_list_lit_repeat1] = aux_sym__bare_list_lit_repeat1,
  [aux_sym_read_cond_lit_repeat1] = aux_sym_read_cond_lit_repeat1,
  [aux_sym_format_modifiers_repeat1] = aux_sym_format_modifiers_repeat1,
  [aux_sym_for_clause_repeat1] = aux_sym_for_clause_repeat1,
  [aux_sym_do_clause_repeat1] = aux_sym_do_clause_repeat1,
  [aux_sym_loop_macro_repeat1] = aux_sym_loop_macro_repeat1,
  [aux_sym__sym_lit_without_slash_repeat1] = aux_sym__sym_lit_without_slash_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__ws] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__form_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_num_lit_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_num_lit_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_str_lit_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_str_lit_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_char_lit_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_nil_lit] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_sym_lit_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND0A] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND0a] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_QMARK_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_fancy_literal] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__format_token_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_v] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_V] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_format_directive_type_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_directive_type_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_format_directive_type_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_directive_type_token4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_directive_type_token5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_directive_type_token6] = {
    .visible = false,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_format_directive_type_token7] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_directive_type_token8] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_directive_type_token9] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_directive_type_token10] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Newline] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_format_directive_type_token11] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_cl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_across] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_being] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_for_clause_word_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_below] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_above] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_to] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_upto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_upfrom] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_downto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_downfrom] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_on] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_by] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_accumulation_verb_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_until] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_when] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unless] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_always] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_thereis] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_never] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_into] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_initially] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_loop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defun] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defmacro] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defgeneric] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defmethod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUNDP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDp] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_path_lit_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__sym_lit_without_slash_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_self_referential_reader_macro] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDC] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDc] = {
    .visible = true,
    .named = false,
  },
  [sym_source] = {
    .visible = true,
    .named = true,
  },
  [sym__gap] = {
    .visible = false,
    .named = true,
  },
  [sym_dis_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__form] = {
    .visible = false,
    .named = true,
  },
  [sym_num_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_kwd_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_str_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_char_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_sym_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__metadata_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_meta_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_old_meta_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_list_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__bare_list_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_map_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__bare_map_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_vec_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_set_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__bare_set_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_read_cond_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_splicing_read_cond_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_var_quoting_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_quoting_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_syn_quoting_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_unquote_splicing_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_unquoting_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_defun] = {
    .visible = true,
    .named = true,
  },
  [sym__format_token] = {
    .visible = false,
    .named = true,
  },
  [sym_format_prefix_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_format_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_format_directive_type] = {
    .visible = true,
    .named = true,
  },
  [sym_format_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_for_clause_word] = {
    .visible = true,
    .named = true,
  },
  [sym__for_part] = {
    .visible = false,
    .named = true,
  },
  [sym_accumulation_verb] = {
    .visible = true,
    .named = true,
  },
  [sym_for_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_do_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_while_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_condition_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_accumulation_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_termination_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_loop_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_loop_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_defun_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_defun_header] = {
    .visible = true,
    .named = true,
  },
  [sym_array_dimension] = {
    .visible = true,
    .named = true,
  },
  [sym_path_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_package_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__package_lit_without_slash] = {
    .visible = true,
    .named = true,
  },
  [sym__sym_lit_without_slash] = {
    .visible = false,
    .named = true,
  },
  [sym_kwd_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_include_reader_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_complex_num_lit] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dis_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_str_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__bare_list_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_read_cond_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_do_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_loop_macro_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__sym_lit_without_slash_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_close = 1,
  field_condition = 2,
  field_function_name = 3,
  field_imaginary = 4,
  field_keyword = 5,
  field_lambda_list = 6,
  field_marker = 7,
  field_meta = 8,
  field_numberOfArgs = 9,
  field_old_meta = 10,
  field_open = 11,
  field_package = 12,
  field_real = 13,
  field_repetitions = 14,
  field_specifier = 15,
  field_symbol = 16,
  field_target = 17,
  field_type = 18,
  field_value = 19,
  field_variable = 20,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_close] = "close",
  [field_condition] = "condition",
  [field_function_name] = "function_name",
  [field_imaginary] = "imaginary",
  [field_keyword] = "keyword",
  [field_lambda_list] = "lambda_list",
  [field_marker] = "marker",
  [field_meta] = "meta",
  [field_numberOfArgs] = "numberOfArgs",
  [field_old_meta] = "old_meta",
  [field_open] = "open",
  [field_package] = "package",
  [field_real] = "real",
  [field_repetitions] = "repetitions",
  [field_specifier] = "specifier",
  [field_symbol] = "symbol",
  [field_target] = "target",
  [field_type] = "type",
  [field_value] = "value",
  [field_variable] = "variable",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 3},
  [6] = {.index = 8, .length = 4},
  [7] = {.index = 12, .length = 3},
  [8] = {.index = 15, .length = 1},
  [9] = {.index = 15, .length = 1},
  [10] = {.index = 16, .length = 2},
  [11] = {.index = 18, .length = 2},
  [12] = {.index = 20, .length = 2},
  [13] = {.index = 22, .length = 4},
  [14] = {.index = 26, .length = 2},
  [15] = {.index = 28, .length = 5},
  [16] = {.index = 33, .length = 6},
  [17] = {.index = 39, .length = 4},
  [18] = {.index = 43, .length = 3},
  [19] = {.index = 46, .length = 1},
  [20] = {.index = 15, .length = 1},
  [21] = {.index = 47, .length = 3},
  [23] = {.index = 50, .length = 2},
  [24] = {.index = 52, .length = 2},
  [25] = {.index = 54, .length = 2},
  [26] = {.index = 56, .length = 1},
  [27] = {.index = 57, .length = 4},
  [28] = {.index = 61, .length = 4},
  [29] = {.index = 65, .length = 4},
  [30] = {.index = 69, .length = 2},
  [31] = {.index = 71, .length = 5},
  [32] = {.index = 76, .length = 6},
  [33] = {.index = 82, .length = 5},
  [34] = {.index = 46, .length = 1},
  [35] = {.index = 87, .length = 5},
  [37] = {.index = 92, .length = 1},
  [38] = {.index = 93, .length = 1},
  [39] = {.index = 94, .length = 1},
  [40] = {.index = 95, .length = 2},
  [41] = {.index = 97, .length = 2},
  [42] = {.index = 99, .length = 4},
  [43] = {.index = 103, .length = 4},
  [44] = {.index = 107, .length = 5},
  [45] = {.index = 112, .length = 5},
  [46] = {.index = 117, .length = 6},
  [47] = {.index = 123, .length = 5},
  [48] = {.index = 128, .length = 7},
  [49] = {.index = 135, .length = 2},
  [50] = {.index = 137, .length = 2},
  [51] = {.index = 139, .length = 1},
  [52] = {.index = 140, .length = 3},
  [53] = {.index = 143, .length = 2},
  [54] = {.index = 145, .length = 3},
  [55] = {.index = 148, .length = 4},
  [56] = {.index = 152, .length = 5},
  [57] = {.index = 157, .length = 4},
  [58] = {.index = 161, .length = 4},
  [59] = {.index = 165, .length = 5},
  [60] = {.index = 170, .length = 3},
  [61] = {.index = 173, .length = 7},
  [62] = {.index = 180, .length = 7},
  [63] = {.index = 187, .length = 2},
  [64] = {.index = 189, .length = 3},
  [65] = {.index = 192, .length = 2},
  [66] = {.index = 194, .length = 3},
  [67] = {.index = 197, .length = 1},
  [68] = {.index = 198, .length = 5},
  [69] = {.index = 203, .length = 2},
  [70] = {.index = 205, .length = 4},
  [71] = {.index = 209, .length = 3},
  [72] = {.index = 212, .length = 4},
  [73] = {.index = 216, .length = 5},
  [74] = {.index = 221, .length = 6},
  [75] = {.index = 227, .length = 5},
  [76] = {.index = 232, .length = 4},
  [77] = {.index = 236, .length = 3},
  [78] = {.index = 239, .length = 3},
  [79] = {.index = 242, .length = 7},
  [80] = {.index = 249, .length = 5},
  [81] = {.index = 254, .length = 5},
  [82] = {.index = 259, .length = 3},
  [83] = {.index = 262, .length = 2},
  [84] = {.index = 264, .length = 4},
  [85] = {.index = 268, .length = 3},
  [86] = {.index = 271, .length = 2},
  [87] = {.index = 273, .length = 3},
  [88] = {.index = 276, .length = 1},
  [89] = {.index = 277, .length = 6},
  [90] = {.index = 283, .length = 2},
  [91] = {.index = 285, .length = 4},
  [92] = {.index = 289, .length = 4},
  [93] = {.index = 293, .length = 2},
  [94] = {.index = 295, .length = 6},
  [95] = {.index = 301, .length = 5},
  [96] = {.index = 306, .length = 6},
  [97] = {.index = 312, .length = 3},
  [98] = {.index = 315, .length = 3},
  [99] = {.index = 318, .length = 5},
  [100] = {.index = 323, .length = 5},
  [101] = {.index = 328, .length = 6},
  [102] = {.index = 334, .length = 5},
  [103] = {.index = 339, .length = 2},
  [104] = {.index = 341, .length = 4},
  [105] = {.index = 345, .length = 4},
  [106] = {.index = 349, .length = 2},
  [107] = {.index = 351, .length = 4},
  [108] = {.index = 355, .length = 3},
  [109] = {.index = 358, .length = 3},
  [110] = {.index = 361, .length = 2},
  [111] = {.index = 363, .length = 3},
  [112] = {.index = 366, .length = 2},
  [113] = {.index = 368, .length = 4},
  [114] = {.index = 372, .length = 4},
  [115] = {.index = 376, .length = 6},
  [116] = {.index = 382, .length = 3},
  [117] = {.index = 385, .length = 5},
  [118] = {.index = 390, .length = 5},
  [119] = {.index = 395, .length = 6},
  [120] = {.index = 401, .length = 2},
  [121] = {.index = 403, .length = 4},
  [122] = {.index = 407, .length = 4},
  [123] = {.index = 411, .length = 2},
  [124] = {.index = 413, .length = 4},
  [125] = {.index = 417, .length = 4},
  [126] = {.index = 421, .length = 5},
  [127] = {.index = 426, .length = 2},
  [128] = {.index = 428, .length = 4},
  [129] = {.index = 432, .length = 3},
  [130] = {.index = 435, .length = 2},
  [131] = {.index = 437, .length = 4},
  [132] = {.index = 441, .length = 4},
  [133] = {.index = 445, .length = 5},
  [134] = {.index = 450, .length = 2},
  [135] = {.index = 452, .length = 4},
  [136] = {.index = 456, .length = 4},
  [137] = {.index = 460, .length = 2},
  [138] = {.index = 462, .length = 4},
  [139] = {.index = 466, .length = 4},
  [140] = {.index = 470, .length = 6},
  [141] = {.index = 476, .length = 2},
  [142] = {.index = 478, .length = 4},
  [143] = {.index = 482, .length = 4},
  [144] = {.index = 486, .length = 4},
  [145] = {.index = 490, .length = 2},
  [146] = {.index = 492, .length = 4},
  [147] = {.index = 496, .length = 4},
  [148] = {.index = 500, .length = 2},
  [149] = {.index = 502, .length = 4},
  [150] = {.index = 506, .length = 2},
  [151] = {.index = 508, .length = 4},
  [152] = {.index = 512, .length = 4},
  [153] = {.index = 516, .length = 2},
  [154] = {.index = 518, .length = 4},
  [155] = {.index = 522, .length = 4},
  [156] = {.index = 526, .length = 4},
  [157] = {.index = 530, .length = 4},
  [158] = {.index = 534, .length = 4},
  [159] = {.index = 538, .length = 4},
  [160] = {.index = 542, .length = 4},
  [161] = {.index = 546, .length = 2},
  [162] = {.index = 548, .length = 4},
  [163] = {.index = 552, .length = 2},
  [164] = {.index = 554, .length = 4},
  [165] = {.index = 558, .length = 4},
  [166] = {.index = 562, .length = 4},
  [167] = {.index = 566, .length = 4},
  [168] = {.index = 570, .length = 4},
  [169] = {.index = 574, .length = 4},
  [170] = {.index = 578, .length = 4},
  [171] = {.index = 582, .length = 2},
  [172] = {.index = 584, .length = 4},
  [173] = {.index = 588, .length = 4},
  [174] = {.index = 592, .length = 4},
  [175] = {.index = 596, .length = 4},
  [176] = {.index = 600, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_open, 0, .inherited = true},
  [1] =
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
  [3] =
    {field_meta, 0},
  [4] =
    {field_old_meta, 0},
  [5] =
    {field_close, 0, .inherited = true},
    {field_open, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [8] =
    {field_close, 0, .inherited = true},
    {field_marker, 0, .inherited = true},
    {field_open, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [12] =
    {field_marker, 0},
    {field_open, 1, .inherited = true},
    {field_value, 1},
  [15] =
    {field_open, 0},
  [16] =
    {field_marker, 0},
    {field_value, 1},
  [18] =
    {field_close, 1},
    {field_open, 0},
  [20] =
    {field_open, 0, .inherited = true},
    {field_value, 0},
  [22] =
    {field_close, 1, .inherited = true},
    {field_marker, 0},
    {field_open, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [26] =
    {field_open, 0, .inherited = true},
    {field_open, 1, .inherited = true},
  [28] =
    {field_close, 1, .inherited = true},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [33] =
    {field_close, 1, .inherited = true},
    {field_marker, 1, .inherited = true},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [39] =
    {field_meta, 0, .inherited = true},
    {field_meta, 1, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_old_meta, 1, .inherited = true},
  [43] =
    {field_marker, 0},
    {field_open, 2, .inherited = true},
    {field_value, 2},
  [46] =
    {field_open, 1},
  [47] =
    {field_close, 2},
    {field_marker, 0},
    {field_open, 1},
  [50] =
    {field_marker, 0},
    {field_value, 2},
  [52] =
    {field_close, 2},
    {field_open, 0},
  [54] =
    {field_keyword, 0},
    {field_lambda_list, 1},
  [56] =
    {field_keyword, 0},
  [57] =
    {field_close, 2},
    {field_open, 0},
    {field_open, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [61] =
    {field_open, 0, .inherited = true},
    {field_open, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [65] =
    {field_close, 2, .inherited = true},
    {field_marker, 0},
    {field_open, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [69] =
    {field_package, 0},
    {field_symbol, 2},
  [71] =
    {field_condition, 1},
    {field_marker, 0},
    {field_open, 1, .inherited = true},
    {field_open, 2, .inherited = true},
    {field_target, 2},
  [76] =
    {field_close, 2, .inherited = true},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [82] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 2, .inherited = true},
    {field_value, 2},
  [87] =
    {field_close, 3},
    {field_marker, 0},
    {field_open, 1},
    {field_open, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [92] =
    {field_repetitions, 0},
  [93] =
    {field_numberOfArgs, 0},
  [94] =
    {field_open, 1, .inherited = true},
  [95] =
    {field_close, 3},
    {field_open, 0},
  [97] =
    {field_keyword, 0},
    {field_lambda_list, 2},
  [99] =
    {field_function_name, 1},
    {field_keyword, 0},
    {field_lambda_list, 2},
    {field_open, 1, .inherited = true},
  [103] =
    {field_close, 3},
    {field_open, 0},
    {field_open, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [107] =
    {field_condition, 1},
    {field_marker, 0},
    {field_open, 1, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_target, 3},
  [112] =
    {field_condition, 2},
    {field_marker, 0},
    {field_open, 2, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_target, 3},
  [117] =
    {field_close, 3, .inherited = true},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [123] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_value, 3},
  [128] =
    {field_condition, 2},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 2, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_target, 3},
  [135] =
    {field_package, 1, .inherited = true},
    {field_symbol, 1, .inherited = true},
  [137] =
    {field_close, 4},
    {field_open, 0},
  [139] =
    {field_open, 2, .inherited = true},
  [140] =
    {field_open, 1, .inherited = true},
    {field_open, 2, .inherited = true},
    {field_variable, 1},
  [143] =
    {field_open, 1, .inherited = true},
    {field_open, 2, .inherited = true},
  [145] =
    {field_open, 1, .inherited = true},
    {field_open, 2, .inherited = true},
    {field_type, 2},
  [148] =
    {field_close, 4},
    {field_open, 0},
    {field_open, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [152] =
    {field_function_name, 1},
    {field_keyword, 0},
    {field_lambda_list, 3},
    {field_open, 1, .inherited = true},
    {field_specifier, 2},
  [157] =
    {field_function_name, 1},
    {field_keyword, 0},
    {field_lambda_list, 3},
    {field_open, 1, .inherited = true},
  [161] =
    {field_function_name, 2},
    {field_keyword, 0},
    {field_lambda_list, 3},
    {field_open, 2, .inherited = true},
  [165] =
    {field_condition, 2},
    {field_marker, 0},
    {field_open, 2, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_target, 4},
  [170] =
    {field_imaginary, 3},
    {field_marker, 0},
    {field_real, 2},
  [173] =
    {field_condition, 2},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 2, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_target, 4},
  [180] =
    {field_condition, 3},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_target, 4},
  [187] =
    {field_close, 5},
    {field_open, 0},
  [189] =
    {field_open, 2, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_variable, 2},
  [192] =
    {field_open, 2, .inherited = true},
    {field_open, 3, .inherited = true},
  [194] =
    {field_open, 2, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_type, 3},
  [197] =
    {field_open, 3, .inherited = true},
  [198] =
    {field_open, 1, .inherited = true},
    {field_open, 2, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_type, 2},
    {field_variable, 1},
  [203] =
    {field_open, 1, .inherited = true},
    {field_open, 3, .inherited = true},
  [205] =
    {field_open, 1, .inherited = true},
    {field_open, 2, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_type, 2},
  [209] =
    {field_open, 1, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_type, 3},
  [212] =
    {field_close, 5},
    {field_open, 0},
    {field_open, 4, .inherited = true},
    {field_value, 4, .inherited = true},
  [216] =
    {field_function_name, 1},
    {field_keyword, 0},
    {field_lambda_list, 4},
    {field_open, 1, .inherited = true},
    {field_specifier, 2},
  [221] =
    {field_function_name, 1},
    {field_keyword, 0},
    {field_lambda_list, 4},
    {field_open, 1, .inherited = true},
    {field_specifier, 2},
    {field_specifier, 3},
  [227] =
    {field_function_name, 2},
    {field_keyword, 0},
    {field_lambda_list, 4},
    {field_open, 2, .inherited = true},
    {field_specifier, 3},
  [232] =
    {field_function_name, 2},
    {field_keyword, 0},
    {field_lambda_list, 4},
    {field_open, 2, .inherited = true},
  [236] =
    {field_imaginary, 4},
    {field_marker, 0},
    {field_real, 2},
  [239] =
    {field_imaginary, 4},
    {field_marker, 0},
    {field_real, 3},
  [242] =
    {field_condition, 3},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_target, 5},
  [249] =
    {field_imaginary, 4},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_real, 3},
  [254] =
    {field_open, 2, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_type, 3},
    {field_variable, 2},
  [259] =
    {field_open, 3, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_variable, 3},
  [262] =
    {field_open, 2, .inherited = true},
    {field_open, 4, .inherited = true},
  [264] =
    {field_open, 2, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_type, 3},
  [268] =
    {field_open, 2, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_type, 4},
  [271] =
    {field_open, 3, .inherited = true},
    {field_open, 4, .inherited = true},
  [273] =
    {field_open, 3, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_type, 4},
  [276] =
    {field_open, 4, .inherited = true},
  [277] =
    {field_open, 1, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_type, 2},
    {field_type, 3},
    {field_variable, 1},
  [283] =
    {field_open, 1, .inherited = true},
    {field_open, 4, .inherited = true},
  [285] =
    {field_open, 1, .inherited = true},
    {field_open, 2, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_type, 2},
  [289] =
    {field_open, 1, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_type, 3},
  [293] =
    {field_close, 6},
    {field_open, 0},
  [295] =
    {field_function_name, 1},
    {field_keyword, 0},
    {field_lambda_list, 5},
    {field_open, 1, .inherited = true},
    {field_specifier, 2},
    {field_specifier, 3},
  [301] =
    {field_function_name, 2},
    {field_keyword, 0},
    {field_lambda_list, 5},
    {field_open, 2, .inherited = true},
    {field_specifier, 3},
  [306] =
    {field_function_name, 2},
    {field_keyword, 0},
    {field_lambda_list, 5},
    {field_open, 2, .inherited = true},
    {field_specifier, 3},
    {field_specifier, 4},
  [312] =
    {field_imaginary, 5},
    {field_marker, 0},
    {field_real, 3},
  [315] =
    {field_imaginary, 5},
    {field_marker, 0},
    {field_real, 4},
  [318] =
    {field_imaginary, 5},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_real, 3},
  [323] =
    {field_imaginary, 5},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_real, 4},
  [328] =
    {field_open, 2, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_type, 3},
    {field_type, 4},
    {field_variable, 2},
  [334] =
    {field_open, 3, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_type, 4},
    {field_variable, 3},
  [339] =
    {field_open, 2, .inherited = true},
    {field_open, 5, .inherited = true},
  [341] =
    {field_open, 2, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_type, 3},
  [345] =
    {field_open, 2, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_type, 4},
  [349] =
    {field_open, 3, .inherited = true},
    {field_open, 5, .inherited = true},
  [351] =
    {field_open, 3, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_type, 4},
  [355] =
    {field_open, 3, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_type, 5},
  [358] =
    {field_open, 4, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_variable, 4},
  [361] =
    {field_open, 4, .inherited = true},
    {field_open, 5, .inherited = true},
  [363] =
    {field_open, 4, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_type, 5},
  [366] =
    {field_open, 1, .inherited = true},
    {field_open, 5, .inherited = true},
  [368] =
    {field_open, 1, .inherited = true},
    {field_open, 2, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_type, 2},
  [372] =
    {field_open, 1, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_type, 3},
  [376] =
    {field_function_name, 2},
    {field_keyword, 0},
    {field_lambda_list, 6},
    {field_open, 2, .inherited = true},
    {field_specifier, 3},
    {field_specifier, 4},
  [382] =
    {field_imaginary, 6},
    {field_marker, 0},
    {field_real, 4},
  [385] =
    {field_imaginary, 6},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_real, 4},
  [390] =
    {field_imaginary, 6},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_real, 5},
  [395] =
    {field_open, 3, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_open, 6, .inherited = true},
    {field_type, 4},
    {field_type, 5},
    {field_variable, 3},
  [401] =
    {field_open, 2, .inherited = true},
    {field_open, 6, .inherited = true},
  [403] =
    {field_open, 2, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_open, 6, .inherited = true},
    {field_type, 3},
  [407] =
    {field_open, 2, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_open, 6, .inherited = true},
    {field_type, 4},
  [411] =
    {field_open, 3, .inherited = true},
    {field_open, 6, .inherited = true},
  [413] =
    {field_open, 3, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_open, 6, .inherited = true},
    {field_type, 4},
  [417] =
    {field_open, 3, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_open, 6, .inherited = true},
    {field_type, 5},
  [421] =
    {field_open, 4, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_open, 6, .inherited = true},
    {field_type, 5},
    {field_variable, 4},
  [426] =
    {field_open, 4, .inherited = true},
    {field_open, 6, .inherited = true},
  [428] =
    {field_open, 4, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_open, 6, .inherited = true},
    {field_type, 5},
  [432] =
    {field_open, 4, .inherited = true},
    {field_open, 6, .inherited = true},
    {field_type, 6},
  [435] =
    {field_open, 1, .inherited = true},
    {field_open, 6, .inherited = true},
  [437] =
    {field_open, 1, .inherited = true},
    {field_open, 2, .inherited = true},
    {field_open, 6, .inherited = true},
    {field_type, 2},
  [441] =
    {field_open, 1, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_open, 6, .inherited = true},
    {field_type, 3},
  [445] =
    {field_imaginary, 7},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_real, 5},
  [450] =
    {field_open, 2, .inherited = true},
    {field_open, 7, .inherited = true},
  [452] =
    {field_open, 2, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_open, 7, .inherited = true},
    {field_type, 3},
  [456] =
    {field_open, 2, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_open, 7, .inherited = true},
    {field_type, 4},
  [460] =
    {field_open, 3, .inherited = true},
    {field_open, 7, .inherited = true},
  [462] =
    {field_open, 3, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_open, 7, .inherited = true},
    {field_type, 4},
  [466] =
    {field_open, 3, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_open, 7, .inherited = true},
    {field_type, 5},
  [470] =
    {field_open, 4, .inherited = true},
    {field_open, 6, .inherited = true},
    {field_open, 7, .inherited = true},
    {field_type, 5},
    {field_type, 6},
    {field_variable, 4},
  [476] =
    {field_open, 4, .inherited = true},
    {field_open, 7, .inherited = true},
  [478] =
    {field_open, 4, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_open, 7, .inherited = true},
    {field_type, 5},
  [482] =
    {field_open, 4, .inherited = true},
    {field_open, 6, .inherited = true},
    {field_open, 7, .inherited = true},
    {field_type, 6},
  [486] =
    {field_open, 1, .inherited = true},
    {field_open, 2, .inherited = true},
    {field_open, 7, .inherited = true},
    {field_type, 2},
  [490] =
    {field_open, 1, .inherited = true},
    {field_open, 7, .inherited = true},
  [492] =
    {field_open, 1, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_open, 7, .inherited = true},
    {field_type, 3},
  [496] =
    {field_open, 2, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_open, 8, .inherited = true},
    {field_type, 3},
  [500] =
    {field_open, 2, .inherited = true},
    {field_open, 8, .inherited = true},
  [502] =
    {field_open, 2, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_open, 8, .inherited = true},
    {field_type, 4},
  [506] =
    {field_open, 3, .inherited = true},
    {field_open, 8, .inherited = true},
  [508] =
    {field_open, 3, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_open, 8, .inherited = true},
    {field_type, 4},
  [512] =
    {field_open, 3, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_open, 8, .inherited = true},
    {field_type, 5},
  [516] =
    {field_open, 4, .inherited = true},
    {field_open, 8, .inherited = true},
  [518] =
    {field_open, 4, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_open, 8, .inherited = true},
    {field_type, 5},
  [522] =
    {field_open, 4, .inherited = true},
    {field_open, 6, .inherited = true},
    {field_open, 8, .inherited = true},
    {field_type, 6},
  [526] =
    {field_open, 1, .inherited = true},
    {field_open, 2, .inherited = true},
    {field_open, 8, .inherited = true},
    {field_type, 2},
  [530] =
    {field_open, 1, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_open, 8, .inherited = true},
    {field_type, 3},
  [534] =
    {field_open, 2, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_open, 9, .inherited = true},
    {field_type, 3},
  [538] =
    {field_open, 2, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_open, 9, .inherited = true},
    {field_type, 4},
  [542] =
    {field_open, 3, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_open, 9, .inherited = true},
    {field_type, 4},
  [546] =
    {field_open, 3, .inherited = true},
    {field_open, 9, .inherited = true},
  [548] =
    {field_open, 3, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_open, 9, .inherited = true},
    {field_type, 5},
  [552] =
    {field_open, 4, .inherited = true},
    {field_open, 9, .inherited = true},
  [554] =
    {field_open, 4, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_open, 9, .inherited = true},
    {field_type, 5},
  [558] =
    {field_open, 4, .inherited = true},
    {field_open, 6, .inherited = true},
    {field_open, 9, .inherited = true},
    {field_type, 6},
  [562] =
    {field_open, 1, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_open, 9, .inherited = true},
    {field_type, 3},
  [566] =
    {field_open, 2, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_open, 10, .inherited = true},
    {field_type, 4},
  [570] =
    {field_open, 3, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_open, 10, .inherited = true},
    {field_type, 4},
  [574] =
    {field_open, 3, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_open, 10, .inherited = true},
    {field_type, 5},
  [578] =
    {field_open, 4, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_open, 10, .inherited = true},
    {field_type, 5},
  [582] =
    {field_open, 4, .inherited = true},
    {field_open, 10, .inherited = true},
  [584] =
    {field_open, 4, .inherited = true},
    {field_open, 6, .inherited = true},
    {field_open, 10, .inherited = true},
    {field_type, 6},
  [588] =
    {field_open, 3, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_open, 11, .inherited = true},
    {field_type, 5},
  [592] =
    {field_open, 4, .inherited = true},
    {field_open, 5, .inherited = true},
    {field_open, 11, .inherited = true},
    {field_type, 5},
  [596] =
    {field_open, 4, .inherited = true},
    {field_open, 6, .inherited = true},
    {field_open, 11, .inherited = true},
    {field_type, 6},
  [600] =
    {field_open, 4, .inherited = true},
    {field_open, 6, .inherited = true},
    {field_open, 12, .inherited = true},
    {field_type, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [8] = {
    [0] = sym_vec_lit,
    [1] = sym_vec_lit,
  },
  [19] = {
    [1] = sym_vec_lit,
    [2] = sym_vec_lit,
  },
  [20] = {
    [0] = sym_vec_lit,
    [1] = sym_vec_lit,
    [2] = sym_vec_lit,
  },
  [22] = {
    [0] = sym_num_lit,
  },
  [34] = {
    [1] = sym_vec_lit,
    [2] = sym_vec_lit,
    [3] = sym_vec_lit,
  },
  [36] = {
    [0] = sym_sym_lit,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_list_lit, 2,
    sym_list_lit,
    sym_vec_lit,
  aux_sym__sym_lit_without_slash_repeat1, 2,
    aux_sym__sym_lit_without_slash_repeat1,
    sym_sym_lit,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 279,
  [281] = 279,
  [282] = 279,
  [283] = 279,
  [284] = 279,
  [285] = 279,
  [286] = 279,
  [287] = 279,
  [288] = 279,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 290,
  [302] = 302,
  [303] = 303,
  [304] = 298,
  [305] = 299,
  [306] = 306,
  [307] = 291,
  [308] = 293,
  [309] = 294,
  [310] = 292,
  [311] = 306,
  [312] = 300,
  [313] = 290,
  [314] = 302,
  [315] = 303,
  [316] = 298,
  [317] = 299,
  [318] = 306,
  [319] = 291,
  [320] = 293,
  [321] = 294,
  [322] = 292,
  [323] = 323,
  [324] = 300,
  [325] = 290,
  [326] = 302,
  [327] = 303,
  [328] = 298,
  [329] = 299,
  [330] = 306,
  [331] = 291,
  [332] = 293,
  [333] = 294,
  [334] = 292,
  [335] = 300,
  [336] = 300,
  [337] = 290,
  [338] = 302,
  [339] = 303,
  [340] = 298,
  [341] = 299,
  [342] = 306,
  [343] = 291,
  [344] = 293,
  [345] = 294,
  [346] = 292,
  [347] = 347,
  [348] = 300,
  [349] = 290,
  [350] = 303,
  [351] = 303,
  [352] = 298,
  [353] = 299,
  [354] = 306,
  [355] = 291,
  [356] = 293,
  [357] = 294,
  [358] = 292,
  [359] = 359,
  [360] = 300,
  [361] = 290,
  [362] = 302,
  [363] = 303,
  [364] = 298,
  [365] = 299,
  [366] = 306,
  [367] = 291,
  [368] = 293,
  [369] = 294,
  [370] = 292,
  [371] = 290,
  [372] = 300,
  [373] = 292,
  [374] = 302,
  [375] = 303,
  [376] = 298,
  [377] = 299,
  [378] = 306,
  [379] = 291,
  [380] = 293,
  [381] = 294,
  [382] = 292,
  [383] = 302,
  [384] = 300,
  [385] = 290,
  [386] = 302,
  [387] = 303,
  [388] = 298,
  [389] = 299,
  [390] = 306,
  [391] = 291,
  [392] = 293,
  [393] = 294,
  [394] = 292,
  [395] = 395,
  [396] = 290,
  [397] = 302,
  [398] = 298,
  [399] = 299,
  [400] = 306,
  [401] = 291,
  [402] = 293,
  [403] = 294,
  [404] = 302,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 424,
  [443] = 441,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 422,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 406,
  [456] = 412,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 428,
  [470] = 429,
  [471] = 424,
  [472] = 441,
  [473] = 444,
  [474] = 445,
  [475] = 446,
  [476] = 422,
  [477] = 448,
  [478] = 449,
  [479] = 450,
  [480] = 451,
  [481] = 452,
  [482] = 453,
  [483] = 454,
  [484] = 406,
  [485] = 412,
  [486] = 457,
  [487] = 458,
  [488] = 459,
  [489] = 460,
  [490] = 461,
  [491] = 462,
  [492] = 463,
  [493] = 464,
  [494] = 494,
  [495] = 466,
  [496] = 467,
  [497] = 468,
  [498] = 428,
  [499] = 429,
  [500] = 424,
  [501] = 441,
  [502] = 444,
  [503] = 445,
  [504] = 446,
  [505] = 422,
  [506] = 448,
  [507] = 449,
  [508] = 450,
  [509] = 451,
  [510] = 452,
  [511] = 453,
  [512] = 454,
  [513] = 406,
  [514] = 412,
  [515] = 457,
  [516] = 458,
  [517] = 459,
  [518] = 460,
  [519] = 461,
  [520] = 462,
  [521] = 463,
  [522] = 464,
  [523] = 494,
  [524] = 466,
  [525] = 467,
  [526] = 468,
  [527] = 428,
  [528] = 429,
  [529] = 424,
  [530] = 441,
  [531] = 444,
  [532] = 445,
  [533] = 446,
  [534] = 422,
  [535] = 448,
  [536] = 449,
  [537] = 450,
  [538] = 451,
  [539] = 452,
  [540] = 453,
  [541] = 454,
  [542] = 406,
  [543] = 412,
  [544] = 457,
  [545] = 458,
  [546] = 459,
  [547] = 460,
  [548] = 461,
  [549] = 462,
  [550] = 463,
  [551] = 464,
  [552] = 494,
  [553] = 466,
  [554] = 467,
  [555] = 468,
  [556] = 428,
  [557] = 429,
  [558] = 424,
  [559] = 441,
  [560] = 444,
  [561] = 445,
  [562] = 446,
  [563] = 422,
  [564] = 448,
  [565] = 449,
  [566] = 450,
  [567] = 451,
  [568] = 452,
  [569] = 453,
  [570] = 454,
  [571] = 406,
  [572] = 412,
  [573] = 457,
  [574] = 458,
  [575] = 459,
  [576] = 460,
  [577] = 461,
  [578] = 462,
  [579] = 463,
  [580] = 464,
  [581] = 494,
  [582] = 466,
  [583] = 467,
  [584] = 468,
  [585] = 428,
  [586] = 429,
  [587] = 424,
  [588] = 441,
  [589] = 444,
  [590] = 445,
  [591] = 446,
  [592] = 422,
  [593] = 448,
  [594] = 449,
  [595] = 450,
  [596] = 451,
  [597] = 452,
  [598] = 453,
  [599] = 454,
  [600] = 406,
  [601] = 412,
  [602] = 457,
  [603] = 458,
  [604] = 459,
  [605] = 460,
  [606] = 461,
  [607] = 462,
  [608] = 463,
  [609] = 464,
  [610] = 494,
  [611] = 466,
  [612] = 467,
  [613] = 468,
  [614] = 428,
  [615] = 429,
  [616] = 424,
  [617] = 441,
  [618] = 444,
  [619] = 445,
  [620] = 446,
  [621] = 422,
  [622] = 448,
  [623] = 449,
  [624] = 450,
  [625] = 451,
  [626] = 452,
  [627] = 453,
  [628] = 454,
  [629] = 406,
  [630] = 412,
  [631] = 457,
  [632] = 458,
  [633] = 459,
  [634] = 460,
  [635] = 461,
  [636] = 462,
  [637] = 463,
  [638] = 464,
  [639] = 494,
  [640] = 466,
  [641] = 467,
  [642] = 468,
  [643] = 428,
  [644] = 429,
  [645] = 424,
  [646] = 441,
  [647] = 444,
  [648] = 445,
  [649] = 446,
  [650] = 422,
  [651] = 448,
  [652] = 449,
  [653] = 450,
  [654] = 451,
  [655] = 452,
  [656] = 453,
  [657] = 454,
  [658] = 406,
  [659] = 412,
  [660] = 457,
  [661] = 458,
  [662] = 459,
  [663] = 460,
  [664] = 461,
  [665] = 462,
  [666] = 463,
  [667] = 464,
  [668] = 494,
  [669] = 466,
  [670] = 467,
  [671] = 468,
  [672] = 428,
  [673] = 429,
  [674] = 424,
  [675] = 441,
  [676] = 444,
  [677] = 445,
  [678] = 446,
  [679] = 422,
  [680] = 448,
  [681] = 449,
  [682] = 450,
  [683] = 451,
  [684] = 452,
  [685] = 453,
  [686] = 454,
  [687] = 406,
  [688] = 412,
  [689] = 457,
  [690] = 458,
  [691] = 459,
  [692] = 460,
  [693] = 461,
  [694] = 462,
  [695] = 463,
  [696] = 464,
  [697] = 494,
  [698] = 466,
  [699] = 467,
  [700] = 468,
  [701] = 428,
  [702] = 429,
  [703] = 424,
  [704] = 441,
  [705] = 444,
  [706] = 445,
  [707] = 446,
  [708] = 422,
  [709] = 448,
  [710] = 449,
  [711] = 450,
  [712] = 451,
  [713] = 452,
  [714] = 453,
  [715] = 454,
  [716] = 406,
  [717] = 412,
  [718] = 457,
  [719] = 458,
  [720] = 459,
  [721] = 460,
  [722] = 461,
  [723] = 462,
  [724] = 463,
  [725] = 464,
  [726] = 494,
  [727] = 466,
  [728] = 467,
  [729] = 468,
  [730] = 428,
  [731] = 429,
  [732] = 424,
  [733] = 441,
  [734] = 444,
  [735] = 445,
  [736] = 446,
  [737] = 422,
  [738] = 448,
  [739] = 449,
  [740] = 450,
  [741] = 451,
  [742] = 452,
  [743] = 453,
  [744] = 454,
  [745] = 406,
  [746] = 412,
  [747] = 457,
  [748] = 458,
  [749] = 459,
  [750] = 460,
  [751] = 461,
  [752] = 462,
  [753] = 463,
  [754] = 464,
  [755] = 494,
  [756] = 466,
  [757] = 467,
  [758] = 468,
  [759] = 428,
  [760] = 429,
  [761] = 424,
  [762] = 441,
  [763] = 444,
  [764] = 445,
  [765] = 446,
  [766] = 422,
  [767] = 448,
  [768] = 449,
  [769] = 450,
  [770] = 451,
  [771] = 452,
  [772] = 453,
  [773] = 454,
  [774] = 406,
  [775] = 412,
  [776] = 457,
  [777] = 458,
  [778] = 459,
  [779] = 460,
  [780] = 461,
  [781] = 462,
  [782] = 463,
  [783] = 464,
  [784] = 494,
  [785] = 466,
  [786] = 467,
  [787] = 468,
  [788] = 428,
  [789] = 429,
  [790] = 424,
  [791] = 441,
  [792] = 444,
  [793] = 445,
  [794] = 446,
  [795] = 448,
  [796] = 449,
  [797] = 450,
  [798] = 451,
  [799] = 452,
  [800] = 453,
  [801] = 454,
  [802] = 406,
  [803] = 412,
  [804] = 457,
  [805] = 458,
  [806] = 459,
  [807] = 460,
  [808] = 461,
  [809] = 462,
  [810] = 463,
  [811] = 464,
  [812] = 494,
  [813] = 466,
  [814] = 467,
  [815] = 468,
  [816] = 428,
  [817] = 429,
  [818] = 465,
  [819] = 819,
  [820] = 420,
  [821] = 821,
  [822] = 822,
  [823] = 413,
  [824] = 414,
  [825] = 457,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 465,
  [834] = 834,
  [835] = 420,
  [836] = 822,
  [837] = 413,
  [838] = 414,
  [839] = 458,
  [840] = 829,
  [841] = 830,
  [842] = 459,
  [843] = 460,
  [844] = 461,
  [845] = 462,
  [846] = 465,
  [847] = 420,
  [848] = 829,
  [849] = 463,
  [850] = 822,
  [851] = 413,
  [852] = 414,
  [853] = 830,
  [854] = 829,
  [855] = 830,
  [856] = 856,
  [857] = 857,
  [858] = 858,
  [859] = 465,
  [860] = 860,
  [861] = 420,
  [862] = 862,
  [863] = 822,
  [864] = 413,
  [865] = 414,
  [866] = 866,
  [867] = 867,
  [868] = 829,
  [869] = 830,
  [870] = 444,
  [871] = 871,
  [872] = 872,
  [873] = 465,
  [874] = 874,
  [875] = 420,
  [876] = 876,
  [877] = 877,
  [878] = 822,
  [879] = 413,
  [880] = 414,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 445,
  [885] = 829,
  [886] = 830,
  [887] = 887,
  [888] = 448,
  [889] = 449,
  [890] = 465,
  [891] = 891,
  [892] = 420,
  [893] = 822,
  [894] = 413,
  [895] = 414,
  [896] = 896,
  [897] = 450,
  [898] = 898,
  [899] = 829,
  [900] = 830,
  [901] = 901,
  [902] = 465,
  [903] = 420,
  [904] = 904,
  [905] = 905,
  [906] = 822,
  [907] = 413,
  [908] = 414,
  [909] = 909,
  [910] = 910,
  [911] = 829,
  [912] = 830,
  [913] = 451,
  [914] = 452,
  [915] = 453,
  [916] = 464,
  [917] = 465,
  [918] = 494,
  [919] = 420,
  [920] = 466,
  [921] = 467,
  [922] = 822,
  [923] = 413,
  [924] = 414,
  [925] = 468,
  [926] = 926,
  [927] = 927,
  [928] = 829,
  [929] = 830,
  [930] = 930,
  [931] = 931,
  [932] = 932,
  [933] = 933,
  [934] = 465,
  [935] = 935,
  [936] = 420,
  [937] = 822,
  [938] = 413,
  [939] = 414,
  [940] = 822,
  [941] = 941,
  [942] = 829,
  [943] = 830,
  [944] = 446,
  [945] = 454,
  [946] = 946,
  [947] = 947,
  [948] = 465,
  [949] = 420,
  [950] = 822,
  [951] = 413,
  [952] = 414,
  [953] = 829,
  [954] = 830,
  [955] = 465,
  [956] = 420,
  [957] = 822,
  [958] = 413,
  [959] = 414,
  [960] = 829,
  [961] = 830,
  [962] = 465,
  [963] = 420,
  [964] = 822,
  [965] = 413,
  [966] = 414,
  [967] = 829,
  [968] = 830,
  [969] = 420,
  [970] = 822,
  [971] = 413,
  [972] = 414,
  [973] = 829,
  [974] = 830,
  [975] = 494,
  [976] = 976,
  [977] = 976,
  [978] = 976,
  [979] = 976,
  [980] = 976,
  [981] = 976,
  [982] = 976,
  [983] = 976,
  [984] = 976,
  [985] = 976,
  [986] = 976,
  [987] = 976,
  [988] = 976,
  [989] = 976,
  [990] = 990,
  [991] = 991,
  [992] = 992,
  [993] = 993,
  [994] = 990,
  [995] = 995,
  [996] = 996,
  [997] = 997,
  [998] = 998,
  [999] = 999,
  [1000] = 1000,
  [1001] = 1001,
  [1002] = 1002,
  [1003] = 1003,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 1007,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 996,
  [1017] = 1017,
  [1018] = 1018,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 1021,
  [1022] = 1022,
  [1023] = 1023,
  [1024] = 1024,
  [1025] = 1025,
  [1026] = 1026,
  [1027] = 1027,
  [1028] = 1028,
  [1029] = 1029,
  [1030] = 1030,
  [1031] = 1031,
  [1032] = 1032,
  [1033] = 1033,
  [1034] = 1034,
  [1035] = 1035,
  [1036] = 1036,
  [1037] = 1037,
  [1038] = 1038,
  [1039] = 1039,
  [1040] = 1040,
  [1041] = 1041,
  [1042] = 1042,
  [1043] = 1043,
  [1044] = 1044,
  [1045] = 1045,
  [1046] = 1046,
  [1047] = 1047,
  [1048] = 1048,
  [1049] = 1049,
  [1050] = 1050,
  [1051] = 1051,
  [1052] = 1052,
  [1053] = 1053,
  [1054] = 1054,
  [1055] = 1055,
  [1056] = 1056,
  [1057] = 1057,
  [1058] = 1058,
  [1059] = 1059,
  [1060] = 1060,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 1066,
  [1067] = 1067,
  [1068] = 1068,
  [1069] = 1069,
  [1070] = 1070,
  [1071] = 1071,
  [1072] = 1072,
  [1073] = 1073,
  [1074] = 1074,
  [1075] = 1075,
  [1076] = 1076,
  [1077] = 1077,
  [1078] = 1078,
  [1079] = 1079,
  [1080] = 1080,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 1083,
  [1084] = 1084,
  [1085] = 1085,
  [1086] = 1086,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 1089,
  [1090] = 1090,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 1096,
  [1097] = 1097,
  [1098] = 1098,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 1116,
  [1117] = 1117,
  [1118] = 1118,
  [1119] = 1119,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 1122,
  [1123] = 1123,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1126,
  [1127] = 1127,
  [1128] = 1128,
  [1129] = 1129,
  [1130] = 1130,
  [1131] = 1131,
  [1132] = 1066,
  [1133] = 1025,
  [1134] = 990,
  [1135] = 1086,
  [1136] = 1101,
  [1137] = 1109,
  [1138] = 1117,
  [1139] = 1124,
  [1140] = 998,
  [1141] = 999,
  [1142] = 1000,
  [1143] = 1001,
  [1144] = 1002,
  [1145] = 1003,
  [1146] = 1006,
  [1147] = 1007,
  [1148] = 1008,
  [1149] = 1010,
  [1150] = 1011,
  [1151] = 1012,
  [1152] = 1013,
  [1153] = 1015,
  [1154] = 1017,
  [1155] = 1018,
  [1156] = 1020,
  [1157] = 1021,
  [1158] = 1022,
  [1159] = 1023,
  [1160] = 1024,
  [1161] = 1027,
  [1162] = 1028,
  [1163] = 1030,
  [1164] = 1031,
  [1165] = 1033,
  [1166] = 1034,
  [1167] = 1035,
  [1168] = 1036,
  [1169] = 1037,
  [1170] = 1038,
  [1171] = 1039,
  [1172] = 1040,
  [1173] = 1041,
  [1174] = 1042,
  [1175] = 1043,
  [1176] = 1044,
  [1177] = 1045,
  [1178] = 1047,
  [1179] = 1048,
  [1180] = 1051,
  [1181] = 1053,
  [1182] = 1054,
  [1183] = 1055,
  [1184] = 1056,
  [1185] = 1058,
  [1186] = 997,
  [1187] = 1060,
  [1188] = 1061,
  [1189] = 1029,
  [1190] = 1063,
  [1191] = 1064,
  [1192] = 1065,
  [1193] = 1050,
  [1194] = 1067,
  [1195] = 1068,
  [1196] = 1131,
  [1197] = 1071,
  [1198] = 1072,
  [1199] = 1074,
  [1200] = 1075,
  [1201] = 1076,
  [1202] = 1077,
  [1203] = 1078,
  [1204] = 1079,
  [1205] = 1080,
  [1206] = 1081,
  [1207] = 1082,
  [1208] = 1084,
  [1209] = 1085,
  [1210] = 1087,
  [1211] = 1088,
  [1212] = 1089,
  [1213] = 1090,
  [1214] = 1091,
  [1215] = 1092,
  [1216] = 1093,
  [1217] = 1094,
  [1218] = 1095,
  [1219] = 1096,
  [1220] = 1097,
  [1221] = 1098,
  [1222] = 1099,
  [1223] = 1100,
  [1224] = 1102,
  [1225] = 1103,
  [1226] = 1104,
  [1227] = 1105,
  [1228] = 1106,
  [1229] = 1107,
  [1230] = 1108,
  [1231] = 1110,
  [1232] = 1111,
  [1233] = 1112,
  [1234] = 1113,
  [1235] = 1114,
  [1236] = 1115,
  [1237] = 1116,
  [1238] = 1118,
  [1239] = 1119,
  [1240] = 1120,
  [1241] = 1121,
  [1242] = 1122,
  [1243] = 1123,
  [1244] = 1125,
  [1245] = 1126,
  [1246] = 1127,
  [1247] = 1128,
  [1248] = 1129,
  [1249] = 1130,
  [1250] = 1046,
  [1251] = 1059,
  [1252] = 1069,
  [1253] = 1057,
  [1254] = 1062,
  [1255] = 1255,
  [1256] = 1256,
  [1257] = 1257,
  [1258] = 1258,
  [1259] = 1259,
  [1260] = 1260,
  [1261] = 1261,
  [1262] = 1262,
  [1263] = 1263,
  [1264] = 1264,
  [1265] = 1265,
  [1266] = 1266,
  [1267] = 1267,
  [1268] = 1268,
  [1269] = 1269,
  [1270] = 1270,
  [1271] = 1271,
  [1272] = 1272,
  [1273] = 1273,
  [1274] = 1274,
  [1275] = 1275,
  [1276] = 1276,
  [1277] = 1277,
  [1278] = 1278,
  [1279] = 1279,
  [1280] = 1280,
  [1281] = 1281,
  [1282] = 1282,
  [1283] = 996,
  [1284] = 1284,
  [1285] = 1285,
  [1286] = 1050,
  [1287] = 1086,
  [1288] = 1101,
  [1289] = 1109,
  [1290] = 1117,
  [1291] = 1124,
  [1292] = 1292,
  [1293] = 998,
  [1294] = 999,
  [1295] = 1000,
  [1296] = 1001,
  [1297] = 1002,
  [1298] = 1003,
  [1299] = 1006,
  [1300] = 1007,
  [1301] = 1008,
  [1302] = 1010,
  [1303] = 1011,
  [1304] = 1012,
  [1305] = 1013,
  [1306] = 1015,
  [1307] = 1017,
  [1308] = 1018,
  [1309] = 1020,
  [1310] = 1021,
  [1311] = 1022,
  [1312] = 1023,
  [1313] = 1024,
  [1314] = 1027,
  [1315] = 1028,
  [1316] = 1030,
  [1317] = 1031,
  [1318] = 1033,
  [1319] = 1034,
  [1320] = 1035,
  [1321] = 1036,
  [1322] = 1037,
  [1323] = 1038,
  [1324] = 1039,
  [1325] = 1040,
  [1326] = 1041,
  [1327] = 1042,
  [1328] = 1043,
  [1329] = 1044,
  [1330] = 1045,
  [1331] = 1047,
  [1332] = 1048,
  [1333] = 1051,
  [1334] = 1053,
  [1335] = 1054,
  [1336] = 1055,
  [1337] = 1056,
  [1338] = 1058,
  [1339] = 997,
  [1340] = 1060,
  [1341] = 1061,
  [1342] = 1062,
  [1343] = 1063,
  [1344] = 1064,
  [1345] = 1065,
  [1346] = 1066,
  [1347] = 1067,
  [1348] = 1068,
  [1349] = 1131,
  [1350] = 1071,
  [1351] = 1351,
  [1352] = 1072,
  [1353] = 1074,
  [1354] = 1075,
  [1355] = 1076,
  [1356] = 1077,
  [1357] = 1078,
  [1358] = 1079,
  [1359] = 1080,
  [1360] = 1081,
  [1361] = 1082,
  [1362] = 1084,
  [1363] = 1085,
  [1364] = 1087,
  [1365] = 1088,
  [1366] = 1089,
  [1367] = 1090,
  [1368] = 1091,
  [1369] = 1092,
  [1370] = 1093,
  [1371] = 1094,
  [1372] = 1095,
  [1373] = 1096,
  [1374] = 1097,
  [1375] = 1098,
  [1376] = 1099,
  [1377] = 1100,
  [1378] = 1102,
  [1379] = 1103,
  [1380] = 1104,
  [1381] = 1105,
  [1382] = 1106,
  [1383] = 1107,
  [1384] = 1108,
  [1385] = 1110,
  [1386] = 1111,
  [1387] = 1112,
  [1388] = 1113,
  [1389] = 1114,
  [1390] = 1115,
  [1391] = 1116,
  [1392] = 1118,
  [1393] = 1119,
  [1394] = 1120,
  [1395] = 1395,
  [1396] = 1122,
  [1397] = 1123,
  [1398] = 1125,
  [1399] = 1126,
  [1400] = 1127,
  [1401] = 1128,
  [1402] = 1402,
  [1403] = 1402,
  [1404] = 1129,
  [1405] = 1130,
  [1406] = 1046,
  [1407] = 1059,
  [1408] = 1069,
  [1409] = 1292,
  [1410] = 1351,
  [1411] = 1057,
  [1412] = 1025,
  [1413] = 1029,
  [1414] = 1414,
  [1415] = 1415,
  [1416] = 1285,
  [1417] = 1395,
  [1418] = 1402,
  [1419] = 1292,
  [1420] = 1351,
  [1421] = 1414,
  [1422] = 1415,
  [1423] = 1284,
  [1424] = 1285,
  [1425] = 1395,
  [1426] = 1402,
  [1427] = 1292,
  [1428] = 1351,
  [1429] = 1414,
  [1430] = 1414,
  [1431] = 1415,
  [1432] = 1285,
  [1433] = 1284,
  [1434] = 1285,
  [1435] = 1395,
  [1436] = 1395,
  [1437] = 1402,
  [1438] = 1292,
  [1439] = 1351,
  [1440] = 1414,
  [1441] = 1415,
  [1442] = 1284,
  [1443] = 1285,
  [1444] = 1395,
  [1445] = 1402,
  [1446] = 1292,
  [1447] = 1351,
  [1448] = 1414,
  [1449] = 1415,
  [1450] = 1284,
  [1451] = 1285,
  [1452] = 1395,
  [1453] = 1402,
  [1454] = 1292,
  [1455] = 1351,
  [1456] = 1414,
  [1457] = 1415,
  [1458] = 1284,
  [1459] = 1285,
  [1460] = 1395,
  [1461] = 1402,
  [1462] = 1292,
  [1463] = 1351,
  [1464] = 1464,
  [1465] = 1415,
  [1466] = 1414,
  [1467] = 1415,
  [1468] = 1284,
  [1469] = 1285,
  [1470] = 1395,
  [1471] = 1402,
  [1472] = 1292,
  [1473] = 1351,
  [1474] = 1284,
  [1475] = 1414,
  [1476] = 1415,
  [1477] = 1284,
  [1478] = 1285,
  [1479] = 1395,
  [1480] = 1402,
  [1481] = 1292,
  [1482] = 1351,
  [1483] = 1414,
  [1484] = 1415,
  [1485] = 1284,
  [1486] = 1121,
  [1487] = 1050,
  [1488] = 1000,
  [1489] = 996,
  [1490] = 1086,
  [1491] = 1101,
  [1492] = 1091,
  [1493] = 1126,
  [1494] = 1127,
  [1495] = 1128,
  [1496] = 1033,
  [1497] = 1037,
  [1498] = 1129,
  [1499] = 1130,
  [1500] = 1500,
  [1501] = 1047,
  [1502] = 1046,
  [1503] = 1059,
  [1504] = 1109,
  [1505] = 1069,
  [1506] = 1057,
  [1507] = 1117,
  [1508] = 998,
  [1509] = 1025,
  [1510] = 1058,
  [1511] = 1029,
  [1512] = 999,
  [1513] = 1064,
  [1514] = 1001,
  [1515] = 1002,
  [1516] = 1008,
  [1517] = 1010,
  [1518] = 1012,
  [1519] = 1013,
  [1520] = 1120,
  [1521] = 1015,
  [1522] = 1017,
  [1523] = 1018,
  [1524] = 1020,
  [1525] = 1021,
  [1526] = 1121,
  [1527] = 1022,
  [1528] = 1023,
  [1529] = 1027,
  [1530] = 1028,
  [1531] = 1030,
  [1532] = 1031,
  [1533] = 1034,
  [1534] = 1003,
  [1535] = 1035,
  [1536] = 1036,
  [1537] = 1038,
  [1538] = 1039,
  [1539] = 1040,
  [1540] = 1006,
  [1541] = 1041,
  [1542] = 1542,
  [1543] = 1042,
  [1544] = 1544,
  [1545] = 1043,
  [1546] = 1044,
  [1547] = 1045,
  [1548] = 1048,
  [1549] = 1051,
  [1550] = 1119,
  [1551] = 1053,
  [1552] = 1054,
  [1553] = 1007,
  [1554] = 1011,
  [1555] = 1555,
  [1556] = 1055,
  [1557] = 1056,
  [1558] = 997,
  [1559] = 1060,
  [1560] = 1061,
  [1561] = 1062,
  [1562] = 1122,
  [1563] = 1065,
  [1564] = 1066,
  [1565] = 1067,
  [1566] = 1566,
  [1567] = 1068,
  [1568] = 1131,
  [1569] = 1071,
  [1570] = 1123,
  [1571] = 1072,
  [1572] = 1074,
  [1573] = 1075,
  [1574] = 1125,
  [1575] = 1076,
  [1576] = 1077,
  [1577] = 1078,
  [1578] = 1079,
  [1579] = 1080,
  [1580] = 1081,
  [1581] = 1082,
  [1582] = 1084,
  [1583] = 1085,
  [1584] = 1087,
  [1585] = 1088,
  [1586] = 1089,
  [1587] = 1090,
  [1588] = 1092,
  [1589] = 1093,
  [1590] = 1094,
  [1591] = 1095,
  [1592] = 1096,
  [1593] = 1097,
  [1594] = 1098,
  [1595] = 1099,
  [1596] = 1100,
  [1597] = 1102,
  [1598] = 1103,
  [1599] = 1104,
  [1600] = 1105,
  [1601] = 1106,
  [1602] = 1107,
  [1603] = 1108,
  [1604] = 1110,
  [1605] = 1111,
  [1606] = 1112,
  [1607] = 1113,
  [1608] = 1114,
  [1609] = 1115,
  [1610] = 1116,
  [1611] = 1118,
  [1612] = 1063,
  [1613] = 1613,
  [1614] = 1613,
  [1615] = 1613,
  [1616] = 1613,
  [1617] = 1613,
  [1618] = 1613,
  [1619] = 1613,
  [1620] = 1613,
  [1621] = 1613,
  [1622] = 1613,
  [1623] = 996,
  [1624] = 1031,
  [1625] = 1065,
  [1626] = 1085,
  [1627] = 1066,
  [1628] = 1067,
  [1629] = 1030,
  [1630] = 1043,
  [1631] = 1057,
  [1632] = 1037,
  [1633] = 1072,
  [1634] = 1044,
  [1635] = 1126,
  [1636] = 1087,
  [1637] = 1038,
  [1638] = 1003,
  [1639] = 1006,
  [1640] = 1055,
  [1641] = 1127,
  [1642] = 1076,
  [1643] = 1095,
  [1644] = 1105,
  [1645] = 1007,
  [1646] = 1039,
  [1647] = 1068,
  [1648] = 1045,
  [1649] = 1033,
  [1650] = 1008,
  [1651] = 1034,
  [1652] = 1025,
  [1653] = 1010,
  [1654] = 1096,
  [1655] = 1056,
  [1656] = 1097,
  [1657] = 1011,
  [1658] = 1098,
  [1659] = 1128,
  [1660] = 1112,
  [1661] = 1131,
  [1662] = 1110,
  [1663] = 1099,
  [1664] = 1058,
  [1665] = 997,
  [1666] = 1071,
  [1667] = 1111,
  [1668] = 1029,
  [1669] = 1040,
  [1670] = 1041,
  [1671] = 1060,
  [1672] = 1114,
  [1673] = 1048,
  [1674] = 1061,
  [1675] = 1012,
  [1676] = 1100,
  [1677] = 1079,
  [1678] = 1050,
  [1679] = 1051,
  [1680] = 1109,
  [1681] = 1102,
  [1682] = 1104,
  [1683] = 1115,
  [1684] = 1018,
  [1685] = 1080,
  [1686] = 1116,
  [1687] = 1117,
  [1688] = 1013,
  [1689] = 1077,
  [1690] = 1015,
  [1691] = 1075,
  [1692] = 1020,
  [1693] = 1124,
  [1694] = 1022,
  [1695] = 1118,
  [1696] = 1047,
  [1697] = 1074,
  [1698] = 1086,
  [1699] = 998,
  [1700] = 1122,
  [1701] = 1053,
  [1702] = 1078,
  [1703] = 1017,
  [1704] = 1129,
  [1705] = 999,
  [1706] = 1119,
  [1707] = 1120,
  [1708] = 1107,
  [1709] = 1121,
  [1710] = 1000,
  [1711] = 1001,
  [1712] = 1002,
  [1713] = 1081,
  [1714] = 1130,
  [1715] = 1103,
  [1716] = 1023,
  [1717] = 1108,
  [1718] = 1088,
  [1719] = 1089,
  [1720] = 1082,
  [1721] = 1046,
  [1722] = 1042,
  [1723] = 1024,
  [1724] = 1090,
  [1725] = 1054,
  [1726] = 1021,
  [1727] = 1027,
  [1728] = 1062,
  [1729] = 1059,
  [1730] = 1063,
  [1731] = 1091,
  [1732] = 1035,
  [1733] = 1092,
  [1734] = 1101,
  [1735] = 1028,
  [1736] = 1093,
  [1737] = 1094,
  [1738] = 1123,
  [1739] = 1036,
  [1740] = 1125,
  [1741] = 1064,
  [1742] = 1113,
  [1743] = 1084,
  [1744] = 1069,
  [1745] = 1106,
  [1746] = 1746,
  [1747] = 1747,
  [1748] = 1747,
  [1749] = 1746,
  [1750] = 1747,
  [1751] = 1747,
  [1752] = 1746,
  [1753] = 1746,
  [1754] = 1746,
  [1755] = 1746,
  [1756] = 1746,
  [1757] = 1746,
  [1758] = 1747,
  [1759] = 1747,
  [1760] = 1747,
  [1761] = 1747,
  [1762] = 1746,
  [1763] = 1747,
  [1764] = 1746,
  [1765] = 1747,
  [1766] = 1766,
  [1767] = 1050,
  [1768] = 1015,
  [1769] = 1017,
  [1770] = 1018,
  [1771] = 1101,
  [1772] = 1094,
  [1773] = 1095,
  [1774] = 1096,
  [1775] = 1097,
  [1776] = 1098,
  [1777] = 1099,
  [1778] = 1100,
  [1779] = 1102,
  [1780] = 1103,
  [1781] = 1104,
  [1782] = 1105,
  [1783] = 1106,
  [1784] = 1107,
  [1785] = 1020,
  [1786] = 1021,
  [1787] = 1012,
  [1788] = 997,
  [1789] = 1060,
  [1790] = 1109,
  [1791] = 1061,
  [1792] = 1062,
  [1793] = 1063,
  [1794] = 1064,
  [1795] = 1065,
  [1796] = 1066,
  [1797] = 1067,
  [1798] = 1068,
  [1799] = 1131,
  [1800] = 1071,
  [1801] = 1117,
  [1802] = 1072,
  [1803] = 1124,
  [1804] = 1108,
  [1805] = 1110,
  [1806] = 1111,
  [1807] = 1112,
  [1808] = 1113,
  [1809] = 1114,
  [1810] = 1115,
  [1811] = 1116,
  [1812] = 1118,
  [1813] = 1119,
  [1814] = 1120,
  [1815] = 1121,
  [1816] = 1122,
  [1817] = 1123,
  [1818] = 1125,
  [1819] = 1022,
  [1820] = 1023,
  [1821] = 1024,
  [1822] = 1027,
  [1823] = 1028,
  [1824] = 1030,
  [1825] = 1031,
  [1826] = 1033,
  [1827] = 998,
  [1828] = 1074,
  [1829] = 1075,
  [1830] = 1126,
  [1831] = 1127,
  [1832] = 1128,
  [1833] = 1129,
  [1834] = 1130,
  [1835] = 1046,
  [1836] = 1059,
  [1837] = 1069,
  [1838] = 1057,
  [1839] = 1076,
  [1840] = 1077,
  [1841] = 1078,
  [1842] = 1079,
  [1843] = 1080,
  [1844] = 1081,
  [1845] = 1082,
  [1846] = 1034,
  [1847] = 1084,
  [1848] = 999,
  [1849] = 1000,
  [1850] = 1001,
  [1851] = 1002,
  [1852] = 1003,
  [1853] = 1025,
  [1854] = 1029,
  [1855] = 1006,
  [1856] = 1007,
  [1857] = 996,
  [1858] = 1035,
  [1859] = 1036,
  [1860] = 1037,
  [1861] = 1038,
  [1862] = 1039,
  [1863] = 1040,
  [1864] = 1041,
  [1865] = 1042,
  [1866] = 1043,
  [1867] = 1044,
  [1868] = 1045,
  [1869] = 1047,
  [1870] = 1048,
  [1871] = 1085,
  [1872] = 1087,
  [1873] = 1088,
  [1874] = 1089,
  [1875] = 1090,
  [1876] = 1091,
  [1877] = 1092,
  [1878] = 1093,
  [1879] = 1051,
  [1880] = 1008,
  [1881] = 1053,
  [1882] = 1054,
  [1883] = 1055,
  [1884] = 1056,
  [1885] = 1058,
  [1886] = 1086,
  [1887] = 1010,
  [1888] = 1011,
  [1889] = 1013,
  [1890] = 1017,
  [1891] = 1001,
  [1892] = 1002,
  [1893] = 1010,
  [1894] = 1012,
  [1895] = 1013,
  [1896] = 1015,
  [1897] = 998,
  [1898] = 1021,
  [1899] = 1022,
  [1900] = 1023,
  [1901] = 1027,
  [1902] = 1028,
  [1903] = 1030,
  [1904] = 1031,
  [1905] = 1038,
  [1906] = 1039,
  [1907] = 1040,
  [1908] = 1041,
  [1909] = 1044,
  [1910] = 1045,
  [1911] = 1048,
  [1912] = 1051,
  [1913] = 1053,
  [1914] = 1055,
  [1915] = 1056,
  [1916] = 1062,
  [1917] = 1063,
  [1918] = 1065,
  [1919] = 1066,
  [1920] = 1067,
  [1921] = 1131,
  [1922] = 1071,
  [1923] = 1077,
  [1924] = 1078,
  [1925] = 1079,
  [1926] = 1080,
  [1927] = 1081,
  [1928] = 1082,
  [1929] = 1087,
  [1930] = 1088,
  [1931] = 1089,
  [1932] = 1090,
  [1933] = 1091,
  [1934] = 1092,
  [1935] = 1093,
  [1936] = 1095,
  [1937] = 1096,
  [1938] = 1097,
  [1939] = 1098,
  [1940] = 1099,
  [1941] = 1100,
  [1942] = 1102,
  [1943] = 1103,
  [1944] = 1104,
  [1945] = 1105,
  [1946] = 1106,
  [1947] = 1107,
  [1948] = 1108,
  [1949] = 1110,
  [1950] = 1111,
  [1951] = 1112,
  [1952] = 1113,
  [1953] = 1114,
  [1954] = 1115,
  [1955] = 1116,
  [1956] = 1118,
  [1957] = 1119,
  [1958] = 1120,
  [1959] = 1121,
  [1960] = 1122,
  [1961] = 1123,
  [1962] = 1125,
  [1963] = 1126,
  [1964] = 1127,
  [1965] = 1128,
  [1966] = 1129,
  [1967] = 1130,
  [1968] = 1046,
  [1969] = 1059,
  [1970] = 1069,
  [1971] = 1057,
  [1972] = 1025,
  [1973] = 1029,
  [1974] = 990,
  [1975] = 1109,
  [1976] = 1117,
  [1977] = 999,
  [1978] = 1978,
  [1979] = 1979,
  [1980] = 1980,
  [1981] = 1981,
  [1982] = 1982,
  [1983] = 1983,
  [1984] = 1984,
  [1985] = 1985,
  [1986] = 1986,
  [1987] = 1987,
  [1988] = 1988,
  [1989] = 1989,
  [1990] = 1990,
  [1991] = 1991,
  [1992] = 1992,
  [1993] = 1993,
  [1994] = 1994,
  [1995] = 1995,
  [1996] = 1996,
  [1997] = 1997,
  [1998] = 1998,
  [1999] = 1999,
  [2000] = 2000,
  [2001] = 2001,
  [2002] = 2002,
  [2003] = 2003,
  [2004] = 2004,
  [2005] = 2005,
  [2006] = 2006,
  [2007] = 2007,
  [2008] = 2008,
  [2009] = 2009,
  [2010] = 2010,
  [2011] = 2011,
  [2012] = 2012,
  [2013] = 2013,
  [2014] = 2014,
  [2015] = 2015,
  [2016] = 2016,
  [2017] = 2017,
  [2018] = 2018,
  [2019] = 2019,
  [2020] = 2020,
  [2021] = 2021,
  [2022] = 2022,
  [2023] = 2023,
  [2024] = 2024,
  [2025] = 2019,
  [2026] = 2019,
  [2027] = 2019,
  [2028] = 2019,
  [2029] = 2019,
  [2030] = 2019,
  [2031] = 2019,
  [2032] = 2019,
  [2033] = 2019,
  [2034] = 2034,
  [2035] = 2035,
  [2036] = 2036,
  [2037] = 2037,
  [2038] = 2038,
  [2039] = 2039,
  [2040] = 2040,
  [2041] = 2041,
  [2042] = 2042,
  [2043] = 2043,
  [2044] = 2044,
  [2045] = 2045,
  [2046] = 2046,
  [2047] = 2047,
  [2048] = 2048,
  [2049] = 2049,
  [2050] = 1000,
  [2051] = 2051,
  [2052] = 2052,
  [2053] = 2053,
  [2054] = 2054,
  [2055] = 2055,
  [2056] = 2056,
  [2057] = 2057,
  [2058] = 2058,
  [2059] = 2059,
  [2060] = 2060,
  [2061] = 2061,
  [2062] = 2062,
  [2063] = 2063,
  [2064] = 2064,
  [2065] = 2065,
  [2066] = 2066,
  [2067] = 2067,
  [2068] = 1072,
  [2069] = 2069,
  [2070] = 2070,
  [2071] = 2071,
  [2072] = 2072,
  [2073] = 2073,
  [2074] = 2074,
  [2075] = 2075,
  [2076] = 1074,
  [2077] = 2077,
  [2078] = 2078,
  [2079] = 2079,
  [2080] = 2080,
  [2081] = 2081,
  [2082] = 2082,
  [2083] = 2083,
  [2084] = 2084,
  [2085] = 2085,
  [2086] = 1075,
  [2087] = 2087,
  [2088] = 2088,
  [2089] = 2089,
  [2090] = 2090,
  [2091] = 2091,
  [2092] = 2092,
  [2093] = 2093,
  [2094] = 2094,
  [2095] = 1050,
  [2096] = 2096,
  [2097] = 2097,
  [2098] = 1076,
  [2099] = 1084,
  [2100] = 1085,
  [2101] = 2101,
  [2102] = 1094,
  [2103] = 1008,
  [2104] = 2104,
  [2105] = 2105,
  [2106] = 1086,
  [2107] = 2107,
  [2108] = 1018,
  [2109] = 2109,
  [2110] = 2110,
  [2111] = 2111,
  [2112] = 1101,
  [2113] = 2113,
  [2114] = 2114,
  [2115] = 2115,
  [2116] = 1020,
  [2117] = 2117,
  [2118] = 2118,
  [2119] = 1124,
  [2120] = 2120,
  [2121] = 2121,
  [2122] = 2122,
  [2123] = 1024,
  [2124] = 2124,
  [2125] = 2125,
  [2126] = 2126,
  [2127] = 2127,
  [2128] = 2128,
  [2129] = 2129,
  [2130] = 2130,
  [2131] = 2131,
  [2132] = 2132,
  [2133] = 2133,
  [2134] = 1034,
  [2135] = 2135,
  [2136] = 2136,
  [2137] = 2137,
  [2138] = 2138,
  [2139] = 2139,
  [2140] = 2140,
  [2141] = 2141,
  [2142] = 2142,
  [2143] = 2143,
  [2144] = 1035,
  [2145] = 1036,
  [2146] = 2146,
  [2147] = 2147,
  [2148] = 2148,
  [2149] = 1042,
  [2150] = 2150,
  [2151] = 1043,
  [2152] = 2152,
  [2153] = 2153,
  [2154] = 2154,
  [2155] = 2155,
  [2156] = 2156,
  [2157] = 2157,
  [2158] = 2158,
  [2159] = 2159,
  [2160] = 2160,
  [2161] = 2161,
  [2162] = 2162,
  [2163] = 2163,
  [2164] = 2164,
  [2165] = 2165,
  [2166] = 2166,
  [2167] = 2167,
  [2168] = 2168,
  [2169] = 2169,
  [2170] = 2170,
  [2171] = 2171,
  [2172] = 2172,
  [2173] = 2173,
  [2174] = 2174,
  [2175] = 2175,
  [2176] = 2176,
  [2177] = 1054,
  [2178] = 2178,
  [2179] = 2179,
  [2180] = 2180,
  [2181] = 2181,
  [2182] = 2182,
  [2183] = 2183,
  [2184] = 2184,
  [2185] = 2185,
  [2186] = 2186,
  [2187] = 2187,
  [2188] = 2188,
  [2189] = 2189,
  [2190] = 2190,
  [2191] = 2191,
  [2192] = 2192,
  [2193] = 2193,
  [2194] = 2194,
  [2195] = 2195,
  [2196] = 2196,
  [2197] = 2197,
  [2198] = 2198,
  [2199] = 2199,
  [2200] = 2200,
  [2201] = 2201,
  [2202] = 2202,
  [2203] = 2203,
  [2204] = 2204,
  [2205] = 2205,
  [2206] = 2206,
  [2207] = 2207,
  [2208] = 2208,
  [2209] = 2209,
  [2210] = 2210,
  [2211] = 2211,
  [2212] = 2212,
  [2213] = 2213,
  [2214] = 2214,
  [2215] = 2215,
  [2216] = 2216,
  [2217] = 2217,
  [2218] = 2218,
  [2219] = 2219,
  [2220] = 2220,
  [2221] = 2221,
  [2222] = 2222,
  [2223] = 2223,
  [2224] = 2224,
  [2225] = 2225,
  [2226] = 2226,
  [2227] = 2227,
  [2228] = 2228,
  [2229] = 2229,
  [2230] = 2230,
  [2231] = 2231,
  [2232] = 2232,
  [2233] = 2233,
  [2234] = 2234,
  [2235] = 2235,
  [2236] = 2236,
  [2237] = 2237,
  [2238] = 2238,
  [2239] = 2239,
  [2240] = 2240,
  [2241] = 2241,
  [2242] = 2242,
  [2243] = 2243,
  [2244] = 2244,
  [2245] = 2245,
  [2246] = 2246,
  [2247] = 2247,
  [2248] = 2248,
  [2249] = 2249,
  [2250] = 2250,
  [2251] = 2251,
  [2252] = 2252,
  [2253] = 2253,
  [2254] = 2254,
  [2255] = 2255,
  [2256] = 2256,
  [2257] = 2257,
  [2258] = 2258,
  [2259] = 2259,
  [2260] = 2260,
  [2261] = 2261,
  [2262] = 2262,
  [2263] = 2263,
  [2264] = 2264,
  [2265] = 2265,
  [2266] = 2266,
  [2267] = 2267,
  [2268] = 2268,
  [2269] = 2269,
  [2270] = 2270,
  [2271] = 2271,
  [2272] = 2272,
  [2273] = 2273,
  [2274] = 2274,
  [2275] = 2275,
  [2276] = 2276,
  [2277] = 2277,
  [2278] = 2278,
  [2279] = 2279,
  [2280] = 2280,
  [2281] = 2281,
  [2282] = 2282,
  [2283] = 2283,
  [2284] = 2284,
  [2285] = 2285,
  [2286] = 2286,
  [2287] = 2287,
  [2288] = 2288,
  [2289] = 2289,
  [2290] = 2290,
  [2291] = 2291,
  [2292] = 2292,
  [2293] = 2293,
  [2294] = 2294,
  [2295] = 2295,
  [2296] = 2296,
  [2297] = 2297,
  [2298] = 2298,
  [2299] = 2299,
  [2300] = 2300,
  [2301] = 2301,
  [2302] = 2302,
  [2303] = 2303,
  [2304] = 2304,
  [2305] = 2305,
  [2306] = 2306,
  [2307] = 2307,
  [2308] = 2308,
  [2309] = 2309,
  [2310] = 997,
  [2311] = 2311,
  [2312] = 2312,
  [2313] = 2313,
  [2314] = 2314,
  [2315] = 2315,
  [2316] = 2316,
  [2317] = 2317,
  [2318] = 2318,
  [2319] = 2319,
  [2320] = 2320,
  [2321] = 2321,
  [2322] = 2322,
  [2323] = 2323,
  [2324] = 2324,
  [2325] = 2325,
  [2326] = 2326,
  [2327] = 2327,
  [2328] = 2328,
  [2329] = 2329,
  [2330] = 2330,
  [2331] = 2331,
  [2332] = 2332,
  [2333] = 2333,
  [2334] = 2334,
  [2335] = 2335,
  [2336] = 2336,
  [2337] = 2337,
  [2338] = 2338,
  [2339] = 2339,
  [2340] = 2340,
  [2341] = 2341,
  [2342] = 2342,
  [2343] = 1060,
  [2344] = 2344,
  [2345] = 2345,
  [2346] = 2346,
  [2347] = 2347,
  [2348] = 2348,
  [2349] = 2349,
  [2350] = 2350,
  [2351] = 2351,
  [2352] = 2352,
  [2353] = 2353,
  [2354] = 2354,
  [2355] = 2355,
  [2356] = 2356,
  [2357] = 2357,
  [2358] = 2358,
  [2359] = 2359,
  [2360] = 2360,
  [2361] = 2361,
  [2362] = 2362,
  [2363] = 2363,
  [2364] = 2364,
  [2365] = 2365,
  [2366] = 2366,
  [2367] = 2367,
  [2368] = 2368,
  [2369] = 2369,
  [2370] = 2370,
  [2371] = 2371,
  [2372] = 2372,
  [2373] = 2373,
  [2374] = 2374,
  [2375] = 2375,
  [2376] = 1061,
  [2377] = 2377,
  [2378] = 2378,
  [2379] = 2379,
  [2380] = 2380,
  [2381] = 2381,
  [2382] = 2382,
  [2383] = 2383,
  [2384] = 2384,
  [2385] = 2385,
  [2386] = 2386,
  [2387] = 2387,
  [2388] = 2388,
  [2389] = 2389,
  [2390] = 2390,
  [2391] = 2391,
  [2392] = 2392,
  [2393] = 2393,
  [2394] = 2394,
  [2395] = 2395,
  [2396] = 2396,
  [2397] = 2397,
  [2398] = 2398,
  [2399] = 2399,
  [2400] = 2400,
  [2401] = 2401,
  [2402] = 2402,
  [2403] = 2403,
  [2404] = 2404,
  [2405] = 2405,
  [2406] = 2406,
  [2407] = 2407,
  [2408] = 2408,
  [2409] = 2409,
  [2410] = 2410,
  [2411] = 2411,
  [2412] = 2412,
  [2413] = 2413,
  [2414] = 2414,
  [2415] = 2415,
  [2416] = 2416,
  [2417] = 2417,
  [2418] = 2418,
  [2419] = 2419,
  [2420] = 2420,
  [2421] = 2421,
  [2422] = 2422,
  [2423] = 2423,
  [2424] = 2424,
  [2425] = 2425,
  [2426] = 2426,
  [2427] = 2427,
  [2428] = 2428,
  [2429] = 2429,
  [2430] = 2430,
  [2431] = 2431,
  [2432] = 2432,
  [2433] = 2433,
  [2434] = 2434,
  [2435] = 2435,
  [2436] = 2436,
  [2437] = 2437,
  [2438] = 2438,
  [2439] = 2439,
  [2440] = 2440,
  [2441] = 2441,
  [2442] = 2442,
  [2443] = 2443,
  [2444] = 2444,
  [2445] = 2445,
  [2446] = 2446,
  [2447] = 2447,
  [2448] = 2448,
  [2449] = 2449,
  [2450] = 2450,
  [2451] = 2451,
  [2452] = 2452,
  [2453] = 2453,
  [2454] = 2454,
  [2455] = 2455,
  [2456] = 2456,
  [2457] = 2457,
  [2458] = 2458,
  [2459] = 2459,
  [2460] = 2460,
  [2461] = 2461,
  [2462] = 2462,
  [2463] = 2463,
  [2464] = 2464,
  [2465] = 2465,
  [2466] = 2466,
  [2467] = 2467,
  [2468] = 2468,
  [2469] = 2469,
  [2470] = 2470,
  [2471] = 2471,
  [2472] = 2472,
  [2473] = 2473,
  [2474] = 2474,
  [2475] = 2475,
  [2476] = 2476,
  [2477] = 2477,
  [2478] = 2478,
  [2479] = 2479,
  [2480] = 2480,
  [2481] = 2481,
  [2482] = 2482,
  [2483] = 2483,
  [2484] = 2484,
  [2485] = 2485,
  [2486] = 2486,
  [2487] = 2487,
  [2488] = 2488,
  [2489] = 2489,
  [2490] = 2490,
  [2491] = 1068,
  [2492] = 2492,
  [2493] = 2493,
  [2494] = 2494,
  [2495] = 2495,
  [2496] = 2496,
  [2497] = 2497,
  [2498] = 2498,
  [2499] = 2499,
  [2500] = 2500,
  [2501] = 2501,
  [2502] = 2502,
  [2503] = 2503,
  [2504] = 2504,
  [2505] = 2505,
  [2506] = 2506,
  [2507] = 2507,
  [2508] = 2508,
  [2509] = 2509,
  [2510] = 2510,
  [2511] = 2511,
  [2512] = 2512,
  [2513] = 2513,
  [2514] = 2514,
  [2515] = 2515,
  [2516] = 2516,
  [2517] = 2517,
  [2518] = 2518,
  [2519] = 2519,
  [2520] = 2520,
  [2521] = 2521,
  [2522] = 2522,
  [2523] = 2523,
  [2524] = 2524,
  [2525] = 2525,
  [2526] = 2526,
  [2527] = 2527,
  [2528] = 2528,
  [2529] = 2529,
  [2530] = 2530,
  [2531] = 2531,
  [2532] = 2532,
  [2533] = 2533,
  [2534] = 2534,
  [2535] = 2535,
  [2536] = 2536,
  [2537] = 2537,
  [2538] = 990,
  [2539] = 2539,
  [2540] = 2540,
  [2541] = 2541,
  [2542] = 2542,
  [2543] = 2543,
  [2544] = 2544,
  [2545] = 2545,
  [2546] = 2546,
  [2547] = 2547,
  [2548] = 2548,
  [2549] = 2549,
  [2550] = 2550,
  [2551] = 2551,
  [2552] = 1104,
  [2553] = 1121,
  [2554] = 1122,
  [2555] = 1123,
  [2556] = 1125,
  [2557] = 1126,
  [2558] = 1127,
  [2559] = 1128,
  [2560] = 1129,
  [2561] = 1130,
  [2562] = 1046,
  [2563] = 1059,
  [2564] = 1069,
  [2565] = 1057,
  [2566] = 1025,
  [2567] = 1003,
  [2568] = 1006,
  [2569] = 1007,
  [2570] = 1029,
  [2571] = 1011,
  [2572] = 1021,
  [2573] = 1022,
  [2574] = 1023,
  [2575] = 1027,
  [2576] = 1033,
  [2577] = 1037,
  [2578] = 1028,
  [2579] = 1030,
  [2580] = 1047,
  [2581] = 1031,
  [2582] = 1058,
  [2583] = 1064,
  [2584] = 1109,
  [2585] = 1038,
  [2586] = 1039,
  [2587] = 1040,
  [2588] = 1041,
  [2589] = 1117,
  [2590] = 1044,
  [2591] = 1045,
  [2592] = 1048,
  [2593] = 1051,
  [2594] = 996,
  [2595] = 998,
  [2596] = 1053,
  [2597] = 999,
  [2598] = 1001,
  [2599] = 1055,
  [2600] = 1056,
  [2601] = 1002,
  [2602] = 1062,
  [2603] = 1063,
  [2604] = 1118,
  [2605] = 1066,
  [2606] = 1067,
  [2607] = 1131,
  [2608] = 1119,
  [2609] = 1071,
  [2610] = 1010,
  [2611] = 1012,
  [2612] = 1013,
  [2613] = 1015,
  [2614] = 1077,
  [2615] = 1078,
  [2616] = 1079,
  [2617] = 1080,
  [2618] = 1081,
  [2619] = 1082,
  [2620] = 1017,
  [2621] = 1087,
  [2622] = 1088,
  [2623] = 1089,
  [2624] = 1090,
  [2625] = 1091,
  [2626] = 1092,
  [2627] = 1093,
  [2628] = 1095,
  [2629] = 1096,
  [2630] = 1097,
  [2631] = 1098,
  [2632] = 1099,
  [2633] = 1100,
  [2634] = 1102,
  [2635] = 1103,
  [2636] = 1120,
  [2637] = 1105,
  [2638] = 1106,
  [2639] = 1107,
  [2640] = 1108,
  [2641] = 1110,
  [2642] = 1111,
  [2643] = 1112,
  [2644] = 1113,
  [2645] = 1114,
  [2646] = 1115,
  [2647] = 1116,
  [2648] = 1065,
  [2649] = 2649,
  [2650] = 2650,
  [2651] = 2651,
  [2652] = 2652,
  [2653] = 2653,
  [2654] = 2654,
  [2655] = 2655,
  [2656] = 2656,
  [2657] = 2657,
  [2658] = 2658,
  [2659] = 2659,
  [2660] = 2660,
  [2661] = 2661,
  [2662] = 2662,
  [2663] = 2663,
  [2664] = 2664,
  [2665] = 2665,
  [2666] = 2666,
  [2667] = 2667,
  [2668] = 2668,
  [2669] = 2669,
  [2670] = 2670,
  [2671] = 2671,
  [2672] = 2672,
  [2673] = 2673,
  [2674] = 2674,
  [2675] = 2675,
  [2676] = 2676,
  [2677] = 2677,
  [2678] = 2678,
  [2679] = 2679,
  [2680] = 2680,
  [2681] = 2681,
  [2682] = 2682,
  [2683] = 2683,
  [2684] = 2684,
  [2685] = 2685,
  [2686] = 2686,
  [2687] = 2687,
  [2688] = 2688,
  [2689] = 2689,
  [2690] = 2690,
  [2691] = 2691,
  [2692] = 2692,
  [2693] = 2693,
  [2694] = 2694,
  [2695] = 2695,
  [2696] = 2696,
  [2697] = 2697,
  [2698] = 2698,
  [2699] = 2699,
  [2700] = 2700,
  [2701] = 2701,
  [2702] = 2702,
  [2703] = 2703,
  [2704] = 2704,
  [2705] = 2705,
  [2706] = 2706,
  [2707] = 2707,
  [2708] = 2708,
  [2709] = 2709,
  [2710] = 2710,
  [2711] = 2711,
  [2712] = 2712,
  [2713] = 2713,
  [2714] = 2714,
  [2715] = 2715,
  [2716] = 2716,
  [2717] = 2717,
  [2718] = 2718,
  [2719] = 2719,
  [2720] = 2720,
  [2721] = 2721,
  [2722] = 2722,
  [2723] = 2723,
  [2724] = 2724,
  [2725] = 2725,
  [2726] = 2726,
  [2727] = 2727,
  [2728] = 2728,
  [2729] = 2729,
  [2730] = 2730,
  [2731] = 2731,
  [2732] = 2732,
  [2733] = 2733,
  [2734] = 2734,
  [2735] = 2735,
  [2736] = 2736,
  [2737] = 2737,
  [2738] = 2738,
  [2739] = 2739,
  [2740] = 2740,
  [2741] = 2741,
  [2742] = 2742,
  [2743] = 2743,
  [2744] = 2744,
  [2745] = 2745,
  [2746] = 2746,
  [2747] = 990,
  [2748] = 2748,
  [2749] = 2749,
  [2750] = 2750,
  [2751] = 2750,
  [2752] = 2752,
  [2753] = 2753,
  [2754] = 2754,
  [2755] = 2755,
  [2756] = 2756,
  [2757] = 2757,
  [2758] = 2758,
  [2759] = 2753,
  [2760] = 2757,
  [2761] = 2755,
  [2762] = 2762,
  [2763] = 996,
  [2764] = 1086,
  [2765] = 1000,
  [2766] = 1101,
  [2767] = 1050,
  [2768] = 1042,
  [2769] = 1054,
  [2770] = 1072,
  [2771] = 1074,
  [2772] = 1037,
  [2773] = 1075,
  [2774] = 1011,
  [2775] = 1008,
  [2776] = 1076,
  [2777] = 1043,
  [2778] = 1058,
  [2779] = 997,
  [2780] = 1018,
  [2781] = 1020,
  [2782] = 1003,
  [2783] = 1060,
  [2784] = 1061,
  [2785] = 1035,
  [2786] = 1006,
  [2787] = 1064,
  [2788] = 1036,
  [2789] = 1047,
  [2790] = 1124,
  [2791] = 1034,
  [2792] = 1084,
  [2793] = 1085,
  [2794] = 1068,
  [2795] = 1024,
  [2796] = 1094,
  [2797] = 1007,
  [2798] = 1033,
  [2799] = 2799,
  [2800] = 1074,
  [2801] = 1075,
  [2802] = 1076,
  [2803] = 2799,
  [2804] = 2799,
  [2805] = 1084,
  [2806] = 1085,
  [2807] = 1094,
  [2808] = 2799,
  [2809] = 997,
  [2810] = 2799,
  [2811] = 1064,
  [2812] = 2799,
  [2813] = 1008,
  [2814] = 2799,
  [2815] = 1024,
  [2816] = 1033,
  [2817] = 2799,
  [2818] = 2799,
  [2819] = 1058,
  [2820] = 1018,
  [2821] = 1034,
  [2822] = 1035,
  [2823] = 1011,
  [2824] = 2799,
  [2825] = 1050,
  [2826] = 1036,
  [2827] = 1037,
  [2828] = 1042,
  [2829] = 1043,
  [2830] = 2799,
  [2831] = 1020,
  [2832] = 2799,
  [2833] = 1060,
  [2834] = 2799,
  [2835] = 1047,
  [2836] = 1061,
  [2837] = 1054,
  [2838] = 1124,
  [2839] = 1072,
  [2840] = 2799,
  [2841] = 1003,
  [2842] = 2799,
  [2843] = 1006,
  [2844] = 1007,
  [2845] = 1068,
  [2846] = 2846,
  [2847] = 2847,
  [2848] = 2848,
  [2849] = 2849,
  [2850] = 2850,
  [2851] = 2851,
  [2852] = 2852,
  [2853] = 2853,
  [2854] = 2854,
  [2855] = 2855,
  [2856] = 2856,
  [2857] = 2857,
  [2858] = 2858,
  [2859] = 2859,
  [2860] = 2860,
  [2861] = 2861,
  [2862] = 2862,
  [2863] = 2863,
  [2864] = 2864,
  [2865] = 2865,
  [2866] = 2866,
  [2867] = 2867,
  [2868] = 990,
  [2869] = 2869,
  [2870] = 2870,
  [2871] = 2871,
  [2872] = 2872,
  [2873] = 1000,
  [2874] = 1086,
  [2875] = 1101,
  [2876] = 996,
  [2877] = 2877,
  [2878] = 2878,
  [2879] = 2879,
  [2880] = 2880,
  [2881] = 2881,
  [2882] = 2882,
  [2883] = 2883,
  [2884] = 2884,
  [2885] = 2885,
  [2886] = 2886,
  [2887] = 2887,
  [2888] = 2888,
  [2889] = 2888,
  [2890] = 2888,
  [2891] = 2888,
  [2892] = 2888,
  [2893] = 2888,
  [2894] = 2888,
  [2895] = 2888,
  [2896] = 2888,
  [2897] = 2888,
  [2898] = 2888,
  [2899] = 2888,
  [2900] = 990,
  [2901] = 990,
  [2902] = 996,
  [2903] = 2903,
  [2904] = 1001,
  [2905] = 2850,
  [2906] = 2853,
  [2907] = 1015,
  [2908] = 1077,
  [2909] = 1078,
  [2910] = 1079,
  [2911] = 1080,
  [2912] = 1038,
  [2913] = 1081,
  [2914] = 1082,
  [2915] = 1087,
  [2916] = 1088,
  [2917] = 1089,
  [2918] = 1090,
  [2919] = 1091,
  [2920] = 1092,
  [2921] = 1093,
  [2922] = 1039,
  [2923] = 1095,
  [2924] = 1096,
  [2925] = 1097,
  [2926] = 1098,
  [2927] = 1099,
  [2928] = 1100,
  [2929] = 1102,
  [2930] = 1103,
  [2931] = 1104,
  [2932] = 1105,
  [2933] = 1106,
  [2934] = 1107,
  [2935] = 1108,
  [2936] = 1110,
  [2937] = 1111,
  [2938] = 1112,
  [2939] = 2939,
  [2940] = 1040,
  [2941] = 1113,
  [2942] = 1114,
  [2943] = 1115,
  [2944] = 1116,
  [2945] = 1118,
  [2946] = 1119,
  [2947] = 1120,
  [2948] = 1121,
  [2949] = 1122,
  [2950] = 1123,
  [2951] = 1125,
  [2952] = 1071,
  [2953] = 1127,
  [2954] = 1128,
  [2955] = 1129,
  [2956] = 1130,
  [2957] = 1046,
  [2958] = 1059,
  [2959] = 1069,
  [2960] = 1057,
  [2961] = 1025,
  [2962] = 1029,
  [2963] = 1041,
  [2964] = 1017,
  [2965] = 1044,
  [2966] = 1045,
  [2967] = 1010,
  [2968] = 2968,
  [2969] = 1048,
  [2970] = 1051,
  [2971] = 1053,
  [2972] = 1022,
  [2973] = 2973,
  [2974] = 1023,
  [2975] = 1012,
  [2976] = 1013,
  [2977] = 1027,
  [2978] = 1055,
  [2979] = 1056,
  [2980] = 1028,
  [2981] = 990,
  [2982] = 1030,
  [2983] = 2871,
  [2984] = 2860,
  [2985] = 1109,
  [2986] = 1117,
  [2987] = 1062,
  [2988] = 998,
  [2989] = 1063,
  [2990] = 1065,
  [2991] = 999,
  [2992] = 1066,
  [2993] = 1067,
  [2994] = 1031,
  [2995] = 1002,
  [2996] = 1131,
  [2997] = 1021,
  [2998] = 1126,
  [2999] = 996,
  [3000] = 3000,
  [3001] = 3001,
  [3002] = 3002,
  [3003] = 3003,
  [3004] = 2878,
  [3005] = 3001,
  [3006] = 3003,
  [3007] = 3000,
  [3008] = 3000,
  [3009] = 3002,
  [3010] = 3002,
  [3011] = 3003,
  [3012] = 3001,
  [3013] = 3002,
  [3014] = 3000,
  [3015] = 3002,
  [3016] = 3003,
  [3017] = 3000,
  [3018] = 3001,
  [3019] = 3003,
  [3020] = 3001,
  [3021] = 3001,
  [3022] = 3000,
  [3023] = 3002,
  [3024] = 3000,
  [3025] = 3003,
  [3026] = 3002,
  [3027] = 3000,
  [3028] = 3000,
  [3029] = 3003,
  [3030] = 3001,
  [3031] = 3000,
  [3032] = 3002,
  [3033] = 3002,
  [3034] = 3000,
  [3035] = 3003,
  [3036] = 3001,
  [3037] = 3002,
  [3038] = 3003,
  [3039] = 1086,
  [3040] = 1101,
  [3041] = 3000,
  [3042] = 3001,
  [3043] = 3002,
  [3044] = 3000,
  [3045] = 3003,
  [3046] = 3003,
  [3047] = 1000,
  [3048] = 3002,
  [3049] = 3003,
  [3050] = 3001,
  [3051] = 3001,
  [3052] = 3001,
  [3053] = 1043,
  [3054] = 1061,
  [3055] = 3055,
  [3056] = 1035,
  [3057] = 1008,
  [3058] = 3058,
  [3059] = 1011,
  [3060] = 3058,
  [3061] = 3058,
  [3062] = 1072,
  [3063] = 1033,
  [3064] = 3058,
  [3065] = 3058,
  [3066] = 1034,
  [3067] = 1094,
  [3068] = 3068,
  [3069] = 1058,
  [3070] = 1018,
  [3071] = 3058,
  [3072] = 1074,
  [3073] = 1003,
  [3074] = 1006,
  [3075] = 1042,
  [3076] = 1060,
  [3077] = 997,
  [3078] = 1086,
  [3079] = 3058,
  [3080] = 1050,
  [3081] = 1007,
  [3082] = 1124,
  [3083] = 1075,
  [3084] = 990,
  [3085] = 1068,
  [3086] = 1036,
  [3087] = 1047,
  [3088] = 990,
  [3089] = 1085,
  [3090] = 1020,
  [3091] = 1084,
  [3092] = 1024,
  [3093] = 3058,
  [3094] = 1101,
  [3095] = 1000,
  [3096] = 1037,
  [3097] = 3058,
  [3098] = 1076,
  [3099] = 3058,
  [3100] = 3058,
  [3101] = 1064,
  [3102] = 1054,
  [3103] = 3058,
  [3104] = 3104,
  [3105] = 3105,
  [3106] = 3106,
  [3107] = 3104,
  [3108] = 3108,
  [3109] = 3109,
  [3110] = 3110,
  [3111] = 3111,
  [3112] = 3112,
  [3113] = 3113,
  [3114] = 3114,
  [3115] = 3115,
  [3116] = 3116,
  [3117] = 3117,
  [3118] = 996,
  [3119] = 3119,
  [3120] = 3120,
  [3121] = 3121,
  [3122] = 3122,
  [3123] = 3123,
  [3124] = 3124,
  [3125] = 3125,
  [3126] = 3126,
  [3127] = 3127,
  [3128] = 3128,
  [3129] = 3129,
  [3130] = 3130,
  [3131] = 3131,
  [3132] = 3132,
  [3133] = 3133,
  [3134] = 996,
  [3135] = 3135,
  [3136] = 3136,
  [3137] = 3137,
  [3138] = 3138,
  [3139] = 3108,
  [3140] = 3140,
  [3141] = 3141,
  [3142] = 3142,
  [3143] = 3143,
  [3144] = 3144,
  [3145] = 3114,
  [3146] = 3120,
  [3147] = 3121,
  [3148] = 3137,
  [3149] = 3144,
  [3150] = 3125,
  [3151] = 3126,
  [3152] = 3108,
  [3153] = 3140,
  [3154] = 3142,
  [3155] = 3109,
  [3156] = 3110,
  [3157] = 3111,
  [3158] = 3127,
  [3159] = 3128,
  [3160] = 3129,
  [3161] = 3130,
  [3162] = 3131,
  [3163] = 3132,
  [3164] = 3133,
  [3165] = 3123,
  [3166] = 3117,
  [3167] = 3114,
  [3168] = 3120,
  [3169] = 3121,
  [3170] = 3137,
  [3171] = 3144,
  [3172] = 3125,
  [3173] = 3126,
  [3174] = 3108,
  [3175] = 3140,
  [3176] = 3142,
  [3177] = 3109,
  [3178] = 3110,
  [3179] = 3111,
  [3180] = 3127,
  [3181] = 3128,
  [3182] = 3129,
  [3183] = 3130,
  [3184] = 3131,
  [3185] = 3132,
  [3186] = 3133,
  [3187] = 3123,
  [3188] = 3117,
  [3189] = 3114,
  [3190] = 3120,
  [3191] = 3121,
  [3192] = 3137,
  [3193] = 3144,
  [3194] = 3125,
  [3195] = 3126,
  [3196] = 3108,
  [3197] = 3140,
  [3198] = 3142,
  [3199] = 3109,
  [3200] = 3110,
  [3201] = 3111,
  [3202] = 3127,
  [3203] = 3128,
  [3204] = 3129,
  [3205] = 3130,
  [3206] = 3131,
  [3207] = 3132,
  [3208] = 3133,
  [3209] = 3123,
  [3210] = 3117,
  [3211] = 3211,
  [3212] = 3114,
  [3213] = 3120,
  [3214] = 3121,
  [3215] = 3137,
  [3216] = 3144,
  [3217] = 3125,
  [3218] = 3126,
  [3219] = 3140,
  [3220] = 3142,
  [3221] = 3109,
  [3222] = 3110,
  [3223] = 3111,
  [3224] = 3127,
  [3225] = 3128,
  [3226] = 3129,
  [3227] = 3130,
  [3228] = 3131,
  [3229] = 3132,
  [3230] = 3133,
  [3231] = 3123,
  [3232] = 3117,
  [3233] = 3114,
  [3234] = 3120,
  [3235] = 3121,
  [3236] = 3137,
  [3237] = 3144,
  [3238] = 3125,
  [3239] = 3126,
  [3240] = 3108,
  [3241] = 3140,
  [3242] = 3142,
  [3243] = 3109,
  [3244] = 3110,
  [3245] = 3111,
  [3246] = 3127,
  [3247] = 3128,
  [3248] = 3129,
  [3249] = 3130,
  [3250] = 3131,
  [3251] = 3132,
  [3252] = 3133,
  [3253] = 3123,
  [3254] = 3117,
  [3255] = 3114,
  [3256] = 3120,
  [3257] = 3121,
  [3258] = 3137,
  [3259] = 3144,
  [3260] = 3125,
  [3261] = 3126,
  [3262] = 3108,
  [3263] = 3140,
  [3264] = 3142,
  [3265] = 3109,
  [3266] = 3110,
  [3267] = 3111,
  [3268] = 3127,
  [3269] = 3128,
  [3270] = 3129,
  [3271] = 3130,
  [3272] = 3131,
  [3273] = 3132,
  [3274] = 3133,
  [3275] = 3123,
  [3276] = 3117,
  [3277] = 3114,
  [3278] = 3120,
  [3279] = 3121,
  [3280] = 3211,
  [3281] = 3144,
  [3282] = 3125,
  [3283] = 3126,
  [3284] = 3108,
  [3285] = 3140,
  [3286] = 3142,
  [3287] = 3109,
  [3288] = 3110,
  [3289] = 3111,
  [3290] = 3127,
  [3291] = 3128,
  [3292] = 3129,
  [3293] = 3130,
  [3294] = 3131,
  [3295] = 3132,
  [3296] = 3133,
  [3297] = 3123,
  [3298] = 3117,
  [3299] = 3114,
  [3300] = 3120,
  [3301] = 3121,
  [3302] = 3137,
  [3303] = 3144,
  [3304] = 3125,
  [3305] = 3126,
  [3306] = 3108,
  [3307] = 3140,
  [3308] = 3142,
  [3309] = 3109,
  [3310] = 3110,
  [3311] = 3111,
  [3312] = 3127,
  [3313] = 3128,
  [3314] = 3129,
  [3315] = 3130,
  [3316] = 3131,
  [3317] = 3132,
  [3318] = 3133,
  [3319] = 3123,
  [3320] = 3117,
  [3321] = 3124,
  [3322] = 3115,
  [3323] = 3119,
  [3324] = 3135,
  [3325] = 3136,
  [3326] = 3122,
  [3327] = 3138,
  [3328] = 3141,
  [3329] = 3113,
  [3330] = 3116,
  [3331] = 3143,
  [3332] = 3112,
  [3333] = 3124,
  [3334] = 3115,
  [3335] = 3119,
  [3336] = 3135,
  [3337] = 3136,
  [3338] = 3122,
  [3339] = 3138,
  [3340] = 3141,
  [3341] = 3113,
  [3342] = 3116,
  [3343] = 3143,
  [3344] = 3112,
  [3345] = 3124,
  [3346] = 3115,
  [3347] = 3119,
  [3348] = 3135,
  [3349] = 3136,
  [3350] = 3122,
  [3351] = 3138,
  [3352] = 3141,
  [3353] = 3113,
  [3354] = 3116,
  [3355] = 3143,
  [3356] = 3112,
  [3357] = 3124,
  [3358] = 3115,
  [3359] = 3119,
  [3360] = 3135,
  [3361] = 3136,
  [3362] = 3122,
  [3363] = 3138,
  [3364] = 3141,
  [3365] = 3113,
  [3366] = 3116,
  [3367] = 3143,
  [3368] = 3112,
  [3369] = 3124,
  [3370] = 3115,
  [3371] = 3119,
  [3372] = 3135,
  [3373] = 3136,
  [3374] = 3122,
  [3375] = 3138,
  [3376] = 3141,
  [3377] = 3113,
  [3378] = 3116,
  [3379] = 3143,
  [3380] = 3112,
  [3381] = 3124,
  [3382] = 3115,
  [3383] = 3119,
  [3384] = 3135,
  [3385] = 3136,
  [3386] = 3122,
  [3387] = 3138,
  [3388] = 3141,
  [3389] = 3113,
  [3390] = 3116,
  [3391] = 3143,
  [3392] = 3112,
  [3393] = 3124,
  [3394] = 3115,
  [3395] = 3119,
  [3396] = 3135,
  [3397] = 3136,
  [3398] = 3122,
  [3399] = 3138,
  [3400] = 3141,
  [3401] = 3113,
  [3402] = 3116,
  [3403] = 3143,
  [3404] = 3112,
  [3405] = 3124,
  [3406] = 3115,
  [3407] = 3119,
  [3408] = 3135,
  [3409] = 3136,
  [3410] = 3122,
  [3411] = 3138,
  [3412] = 3141,
  [3413] = 3113,
  [3414] = 3116,
  [3415] = 3143,
  [3416] = 3112,
  [3417] = 3211,
  [3418] = 3211,
  [3419] = 3211,
  [3420] = 3211,
  [3421] = 3211,
  [3422] = 3211,
  [3423] = 3211,
  [3424] = 3137,
  [3425] = 3425,
  [3426] = 3426,
  [3427] = 3427,
  [3428] = 3428,
  [3429] = 3429,
  [3430] = 3430,
  [3431] = 3431,
  [3432] = 3432,
  [3433] = 3433,
  [3434] = 3434,
  [3435] = 3433,
  [3436] = 3428,
  [3437] = 3430,
  [3438] = 3431,
  [3439] = 3428,
  [3440] = 3430,
  [3441] = 3431,
  [3442] = 3442,
  [3443] = 3425,
  [3444] = 3442,
  [3445] = 3445,
  [3446] = 3446,
  [3447] = 3447,
  [3448] = 3448,
  [3449] = 3449,
  [3450] = 3450,
  [3451] = 3451,
  [3452] = 3452,
  [3453] = 3453,
  [3454] = 3454,
  [3455] = 3455,
  [3456] = 3456,
  [3457] = 3457,
  [3458] = 3458,
  [3459] = 3429,
  [3460] = 3460,
  [3461] = 3461,
  [3462] = 3462,
  [3463] = 3463,
  [3464] = 3464,
  [3465] = 3465,
  [3466] = 3466,
  [3467] = 3467,
  [3468] = 3468,
  [3469] = 3469,
  [3470] = 3470,
  [3471] = 3471,
  [3472] = 3472,
  [3473] = 3473,
  [3474] = 3474,
  [3475] = 3460,
  [3476] = 3476,
  [3477] = 3434,
  [3478] = 3478,
  [3479] = 3479,
  [3480] = 3426,
  [3481] = 3481,
  [3482] = 3482,
  [3483] = 3425,
  [3484] = 3445,
  [3485] = 3446,
  [3486] = 3447,
  [3487] = 3448,
  [3488] = 3449,
  [3489] = 3450,
  [3490] = 3451,
  [3491] = 3452,
  [3492] = 3453,
  [3493] = 3454,
  [3494] = 3455,
  [3495] = 3456,
  [3496] = 3457,
  [3497] = 3458,
  [3498] = 3429,
  [3499] = 3499,
  [3500] = 3461,
  [3501] = 3462,
  [3502] = 3463,
  [3503] = 3464,
  [3504] = 3465,
  [3505] = 3466,
  [3506] = 3467,
  [3507] = 3468,
  [3508] = 3469,
  [3509] = 3470,
  [3510] = 3471,
  [3511] = 3472,
  [3512] = 3473,
  [3513] = 3474,
  [3514] = 3460,
  [3515] = 3433,
  [3516] = 3448,
  [3517] = 3476,
  [3518] = 3428,
  [3519] = 3430,
  [3520] = 3431,
  [3521] = 3442,
  [3522] = 3425,
  [3523] = 3434,
  [3524] = 3445,
  [3525] = 3446,
  [3526] = 3447,
  [3527] = 3448,
  [3528] = 3449,
  [3529] = 3450,
  [3530] = 3451,
  [3531] = 3452,
  [3532] = 3453,
  [3533] = 3454,
  [3534] = 3455,
  [3535] = 3456,
  [3536] = 3457,
  [3537] = 3458,
  [3538] = 3429,
  [3539] = 3499,
  [3540] = 3461,
  [3541] = 3462,
  [3542] = 3463,
  [3543] = 3464,
  [3544] = 3465,
  [3545] = 3466,
  [3546] = 3467,
  [3547] = 3468,
  [3548] = 3469,
  [3549] = 3470,
  [3550] = 3471,
  [3551] = 3472,
  [3552] = 3473,
  [3553] = 3474,
  [3554] = 3460,
  [3555] = 3476,
  [3556] = 3434,
  [3557] = 3478,
  [3558] = 3479,
  [3559] = 3426,
  [3560] = 3481,
  [3561] = 3482,
  [3562] = 3478,
  [3563] = 3479,
  [3564] = 3426,
  [3565] = 3449,
  [3566] = 3450,
  [3567] = 3481,
  [3568] = 3482,
  [3569] = 3467,
  [3570] = 3451,
  [3571] = 3452,
  [3572] = 3478,
  [3573] = 3453,
  [3574] = 3454,
  [3575] = 3468,
  [3576] = 3455,
  [3577] = 3456,
  [3578] = 3479,
  [3579] = 3433,
  [3580] = 3428,
  [3581] = 3430,
  [3582] = 3431,
  [3583] = 3442,
  [3584] = 3474,
  [3585] = 3445,
  [3586] = 3446,
  [3587] = 3447,
  [3588] = 3448,
  [3589] = 3449,
  [3590] = 3450,
  [3591] = 3451,
  [3592] = 3452,
  [3593] = 3453,
  [3594] = 3454,
  [3595] = 3455,
  [3596] = 3456,
  [3597] = 3457,
  [3598] = 3458,
  [3599] = 3429,
  [3600] = 3499,
  [3601] = 3461,
  [3602] = 3462,
  [3603] = 3463,
  [3604] = 3464,
  [3605] = 3465,
  [3606] = 3466,
  [3607] = 3467,
  [3608] = 3468,
  [3609] = 3469,
  [3610] = 3470,
  [3611] = 3471,
  [3612] = 3472,
  [3613] = 3473,
  [3614] = 3474,
  [3615] = 3460,
  [3616] = 3476,
  [3617] = 3434,
  [3618] = 3478,
  [3619] = 3479,
  [3620] = 3426,
  [3621] = 3481,
  [3622] = 3482,
  [3623] = 3499,
  [3624] = 3426,
  [3625] = 3466,
  [3626] = 3626,
  [3627] = 3469,
  [3628] = 3471,
  [3629] = 3629,
  [3630] = 3442,
  [3631] = 3481,
  [3632] = 3433,
  [3633] = 3425,
  [3634] = 3428,
  [3635] = 3430,
  [3636] = 3431,
  [3637] = 3442,
  [3638] = 3425,
  [3639] = 3445,
  [3640] = 3446,
  [3641] = 3447,
  [3642] = 3448,
  [3643] = 3449,
  [3644] = 3450,
  [3645] = 3451,
  [3646] = 3452,
  [3647] = 3453,
  [3648] = 3454,
  [3649] = 3455,
  [3650] = 3456,
  [3651] = 3651,
  [3652] = 3482,
  [3653] = 3651,
  [3654] = 3433,
  [3655] = 3457,
  [3656] = 3458,
  [3657] = 3429,
  [3658] = 3651,
  [3659] = 3428,
  [3660] = 3430,
  [3661] = 3431,
  [3662] = 3442,
  [3663] = 3425,
  [3664] = 3445,
  [3665] = 3446,
  [3666] = 3447,
  [3667] = 3448,
  [3668] = 3449,
  [3669] = 3450,
  [3670] = 3451,
  [3671] = 3452,
  [3672] = 3453,
  [3673] = 3454,
  [3674] = 3455,
  [3675] = 3456,
  [3676] = 3457,
  [3677] = 3458,
  [3678] = 3429,
  [3679] = 3499,
  [3680] = 3499,
  [3681] = 3461,
  [3682] = 3651,
  [3683] = 3461,
  [3684] = 3462,
  [3685] = 3463,
  [3686] = 3464,
  [3687] = 3465,
  [3688] = 3466,
  [3689] = 3467,
  [3690] = 3468,
  [3691] = 3469,
  [3692] = 3470,
  [3693] = 3471,
  [3694] = 3472,
  [3695] = 3473,
  [3696] = 3474,
  [3697] = 3460,
  [3698] = 3476,
  [3699] = 3434,
  [3700] = 3478,
  [3701] = 3479,
  [3702] = 3426,
  [3703] = 3481,
  [3704] = 3482,
  [3705] = 3651,
  [3706] = 3462,
  [3707] = 3461,
  [3708] = 3462,
  [3709] = 3470,
  [3710] = 3463,
  [3711] = 3463,
  [3712] = 3651,
  [3713] = 3713,
  [3714] = 3481,
  [3715] = 3715,
  [3716] = 3433,
  [3717] = 3482,
  [3718] = 3651,
  [3719] = 3476,
  [3720] = 3433,
  [3721] = 3428,
  [3722] = 3430,
  [3723] = 3431,
  [3724] = 3442,
  [3725] = 3425,
  [3726] = 3445,
  [3727] = 3446,
  [3728] = 3447,
  [3729] = 3448,
  [3730] = 3449,
  [3731] = 3450,
  [3732] = 3451,
  [3733] = 3452,
  [3734] = 3453,
  [3735] = 3464,
  [3736] = 3651,
  [3737] = 3454,
  [3738] = 3455,
  [3739] = 3456,
  [3740] = 3457,
  [3741] = 3458,
  [3742] = 3429,
  [3743] = 3499,
  [3744] = 3461,
  [3745] = 3462,
  [3746] = 3463,
  [3747] = 3464,
  [3748] = 3465,
  [3749] = 3466,
  [3750] = 3467,
  [3751] = 3468,
  [3752] = 3469,
  [3753] = 3470,
  [3754] = 3471,
  [3755] = 3472,
  [3756] = 3473,
  [3757] = 3474,
  [3758] = 3460,
  [3759] = 3651,
  [3760] = 3476,
  [3761] = 3434,
  [3762] = 3478,
  [3763] = 3479,
  [3764] = 3426,
  [3765] = 3481,
  [3766] = 3482,
  [3767] = 3472,
  [3768] = 3651,
  [3769] = 3465,
  [3770] = 3464,
  [3771] = 3473,
  [3772] = 3465,
  [3773] = 3474,
  [3774] = 3466,
  [3775] = 3467,
  [3776] = 3460,
  [3777] = 3476,
  [3778] = 3445,
  [3779] = 3433,
  [3780] = 3457,
  [3781] = 3468,
  [3782] = 3428,
  [3783] = 3430,
  [3784] = 3431,
  [3785] = 3442,
  [3786] = 3425,
  [3787] = 3445,
  [3788] = 3446,
  [3789] = 3447,
  [3790] = 3448,
  [3791] = 3449,
  [3792] = 3450,
  [3793] = 3469,
  [3794] = 3451,
  [3795] = 3452,
  [3796] = 3453,
  [3797] = 3454,
  [3798] = 3455,
  [3799] = 3456,
  [3800] = 3457,
  [3801] = 3458,
  [3802] = 3429,
  [3803] = 3499,
  [3804] = 3461,
  [3805] = 3462,
  [3806] = 3470,
  [3807] = 3463,
  [3808] = 3464,
  [3809] = 3465,
  [3810] = 3466,
  [3811] = 3467,
  [3812] = 3468,
  [3813] = 3469,
  [3814] = 3470,
  [3815] = 3471,
  [3816] = 3472,
  [3817] = 3473,
  [3818] = 3474,
  [3819] = 3471,
  [3820] = 3460,
  [3821] = 3476,
  [3822] = 3434,
  [3823] = 3478,
  [3824] = 3479,
  [3825] = 3426,
  [3826] = 3481,
  [3827] = 3482,
  [3828] = 3472,
  [3829] = 3434,
  [3830] = 3446,
  [3831] = 3478,
  [3832] = 3473,
  [3833] = 3713,
  [3834] = 3432,
  [3835] = 3715,
  [3836] = 3427,
  [3837] = 3626,
  [3838] = 3629,
  [3839] = 3713,
  [3840] = 3432,
  [3841] = 3715,
  [3842] = 3427,
  [3843] = 3626,
  [3844] = 3629,
  [3845] = 3713,
  [3846] = 3432,
  [3847] = 3715,
  [3848] = 3427,
  [3849] = 3626,
  [3850] = 3629,
  [3851] = 3713,
  [3852] = 3432,
  [3853] = 3715,
  [3854] = 3427,
  [3855] = 3626,
  [3856] = 3629,
  [3857] = 3713,
  [3858] = 3432,
  [3859] = 3715,
  [3860] = 3427,
  [3861] = 3626,
  [3862] = 3629,
  [3863] = 3713,
  [3864] = 3432,
  [3865] = 3715,
  [3866] = 3427,
  [3867] = 3626,
  [3868] = 3629,
  [3869] = 3713,
  [3870] = 3432,
  [3871] = 3715,
  [3872] = 3427,
  [3873] = 3626,
  [3874] = 3629,
  [3875] = 3713,
  [3876] = 3432,
  [3877] = 3715,
  [3878] = 3427,
  [3879] = 3626,
  [3880] = 3629,
  [3881] = 3458,
  [3882] = 3447,
  [3883] = 3479,
  [3884] = 3499,
  [3885] = 3885,
  [3886] = 3886,
  [3887] = 3887,
  [3888] = 3888,
  [3889] = 3889,
  [3890] = 3890,
  [3891] = 3891,
  [3892] = 3892,
  [3893] = 3885,
  [3894] = 3891,
  [3895] = 3895,
  [3896] = 3895,
  [3897] = 3887,
  [3898] = 3891,
  [3899] = 3887,
  [3900] = 3890,
  [3901] = 3892,
  [3902] = 3889,
  [3903] = 3886,
  [3904] = 3889,
  [3905] = 3905,
  [3906] = 3885,
  [3907] = 3895,
  [3908] = 3886,
  [3909] = 3889,
  [3910] = 3891,
  [3911] = 3892,
  [3912] = 3891,
  [3913] = 3895,
  [3914] = 3887,
  [3915] = 3895,
  [3916] = 3887,
  [3917] = 3917,
  [3918] = 3892,
  [3919] = 3885,
  [3920] = 3886,
  [3921] = 3889,
  [3922] = 3890,
  [3923] = 3892,
  [3924] = 3905,
  [3925] = 3887,
  [3926] = 3890,
  [3927] = 3905,
  [3928] = 3885,
  [3929] = 3887,
  [3930] = 3885,
  [3931] = 3888,
  [3932] = 3905,
  [3933] = 3886,
  [3934] = 3889,
  [3935] = 3891,
  [3936] = 3892,
  [3937] = 3885,
  [3938] = 3890,
  [3939] = 3905,
  [3940] = 3889,
  [3941] = 3895,
  [3942] = 3887,
  [3943] = 3890,
  [3944] = 3905,
  [3945] = 3888,
  [3946] = 3888,
  [3947] = 3895,
  [3948] = 3887,
  [3949] = 3891,
  [3950] = 3892,
  [3951] = 3895,
  [3952] = 3887,
  [3953] = 3890,
  [3954] = 3895,
  [3955] = 3905,
  [3956] = 3885,
  [3957] = 3887,
  [3958] = 3888,
  [3959] = 3892,
  [3960] = 3888,
  [3961] = 3886,
  [3962] = 3889,
  [3963] = 3963,
  [3964] = 3886,
  [3965] = 3890,
  [3966] = 3905,
  [3967] = 3885,
  [3968] = 3891,
  [3969] = 3892,
  [3970] = 3886,
  [3971] = 3889,
  [3972] = 3891,
  [3973] = 3892,
  [3974] = 3889,
  [3975] = 3895,
  [3976] = 3891,
  [3977] = 3892,
  [3978] = 3890,
  [3979] = 3905,
  [3980] = 3885,
  [3981] = 3905,
  [3982] = 3888,
  [3983] = 3888,
  [3984] = 3888,
  [3985] = 3887,
  [3986] = 3886,
  [3987] = 3889,
  [3988] = 3891,
  [3989] = 3892,
  [3990] = 3890,
  [3991] = 3905,
  [3992] = 3885,
  [3993] = 3895,
  [3994] = 3888,
  [3995] = 3886,
  [3996] = 3886,
  [3997] = 3889,
  [3998] = 3885,
  [3999] = 3999,
  [4000] = 4000,
  [4001] = 3999,
  [4002] = 4002,
  [4003] = 3999,
  [4004] = 3999,
  [4005] = 3999,
  [4006] = 3999,
  [4007] = 3999,
  [4008] = 3999,
  [4009] = 4009,
  [4010] = 3999,
  [4011] = 3999,
  [4012] = 4012,
  [4013] = 4013,
  [4014] = 4014,
  [4015] = 4015,
  [4016] = 4016,
  [4017] = 4017,
  [4018] = 4018,
  [4019] = 4019,
  [4020] = 4020,
  [4021] = 4021,
  [4022] = 4022,
  [4023] = 4023,
  [4024] = 4024,
  [4025] = 4025,
  [4026] = 4026,
  [4027] = 4027,
  [4028] = 4028,
  [4029] = 4029,
  [4030] = 4030,
  [4031] = 4031,
  [4032] = 4032,
  [4033] = 4033,
  [4034] = 4034,
  [4035] = 4035,
  [4036] = 4036,
  [4037] = 4037,
  [4038] = 4038,
  [4039] = 4039,
  [4040] = 4040,
  [4041] = 4041,
  [4042] = 4042,
  [4043] = 4043,
  [4044] = 4044,
  [4045] = 4045,
  [4046] = 4046,
  [4047] = 4047,
  [4048] = 4048,
  [4049] = 4049,
  [4050] = 4050,
  [4051] = 4051,
  [4052] = 4052,
  [4053] = 4053,
  [4054] = 4054,
  [4055] = 4055,
  [4056] = 4056,
  [4057] = 4057,
  [4058] = 4058,
  [4059] = 4059,
  [4060] = 4060,
  [4061] = 4061,
  [4062] = 4062,
  [4063] = 4063,
  [4064] = 4064,
  [4065] = 4065,
  [4066] = 4066,
  [4067] = 4067,
  [4068] = 4068,
  [4069] = 4069,
  [4070] = 4070,
  [4071] = 4071,
  [4072] = 4072,
  [4073] = 4073,
  [4074] = 4074,
  [4075] = 4075,
  [4076] = 4076,
  [4077] = 4077,
  [4078] = 4078,
  [4079] = 4079,
  [4080] = 4080,
  [4081] = 4081,
  [4082] = 4082,
  [4083] = 4083,
  [4084] = 4084,
  [4085] = 4085,
  [4086] = 4086,
  [4087] = 4087,
  [4088] = 4088,
  [4089] = 4089,
  [4090] = 4090,
  [4091] = 4091,
  [4092] = 4092,
  [4093] = 4093,
  [4094] = 4094,
  [4095] = 4095,
  [4096] = 4096,
  [4097] = 4097,
  [4098] = 4097,
  [4099] = 4097,
  [4100] = 4100,
  [4101] = 4100,
  [4102] = 4097,
  [4103] = 4097,
  [4104] = 4100,
  [4105] = 4100,
  [4106] = 4100,
  [4107] = 4097,
  [4108] = 4100,
  [4109] = 4100,
  [4110] = 4097,
  [4111] = 4097,
  [4112] = 4112,
  [4113] = 4100,
  [4114] = 4100,
  [4115] = 4100,
  [4116] = 4097,
  [4117] = 4097,
  [4118] = 4100,
  [4119] = 4119,
  [4120] = 4120,
  [4121] = 4121,
  [4122] = 4122,
  [4123] = 4121,
  [4124] = 4121,
  [4125] = 4119,
  [4126] = 4121,
  [4127] = 4121,
  [4128] = 4121,
  [4129] = 4129,
  [4130] = 4120,
  [4131] = 4120,
  [4132] = 4132,
  [4133] = 4133,
  [4134] = 4121,
  [4135] = 4135,
  [4136] = 4136,
  [4137] = 4119,
  [4138] = 4138,
  [4139] = 4119,
  [4140] = 4140,
  [4141] = 4121,
  [4142] = 4119,
  [4143] = 4143,
  [4144] = 4144,
  [4145] = 4120,
  [4146] = 4146,
  [4147] = 4119,
  [4148] = 4148,
  [4149] = 4120,
  [4150] = 4121,
  [4151] = 4119,
  [4152] = 4152,
  [4153] = 4119,
  [4154] = 4154,
  [4155] = 4120,
  [4156] = 4156,
  [4157] = 4157,
  [4158] = 4158,
  [4159] = 4159,
  [4160] = 4121,
  [4161] = 4120,
  [4162] = 4119,
  [4163] = 4120,
  [4164] = 4120,
};

static TSCharacterRange aux_sym_sym_lit_token1_character_set_1[] = {
  {0, 0x08}, {0x0e, 0x1b}, {'!', '!'}, {'$', '&'}, {'*', '+'}, {'-', '9'}, {'<', 'Z'}, {'_', '_'},
  {'a', 'z'}, {'|', '|'}, {'~', 0x167f}, {0x1681, 0x1fff}, {0x2007, 0x2007}, {0x200b, 0x2027}, {0x202a, 0x205e}, {0x2060, 0x2fff},
  {0x3001, 0x10ffff},
};

static TSCharacterRange aux_sym_sym_lit_token1_character_set_2[] = {
  {0, 0x08}, {0x0e, 0x1b}, {'!', '!'}, {'#', '\''}, {'*', '+'}, {'-', '9'}, {'<', 'Z'}, {'_', '_'},
  {'a', 'z'}, {'|', '|'}, {'~', 0x167f}, {0x1681, 0x1fff}, {0x2007, 0x2007}, {0x200b, 0x2027}, {0x202a, 0x205e}, {0x2060, 0x2fff},
  {0x3001, 0x10ffff},
};

static TSCharacterRange aux_sym_format_directive_type_token11_character_set_1[] = {
  {'$', '$'}, {'B', 'B'}, {'D', 'G'}, {'O', 'O'}, {'R', 'T'}, {'X', 'X'}, {'b', 'b'}, {'d', 'g'},
  {'o', 'o'}, {'r', 't'}, {'x', 'x'},
};

static TSCharacterRange aux_sym__sym_lit_without_slash_token1_character_set_1[] = {
  {0, 0x08}, {0x0e, 0x1b}, {'!', '!'}, {'$', '&'}, {'*', '+'}, {'-', '.'}, {'0', '9'}, {'<', 'Z'},
  {'_', '_'}, {'a', 'z'}, {'|', '|'}, {'~', 0x167f}, {0x1681, 0x1fff}, {0x2007, 0x2007}, {0x200b, 0x2027}, {0x202a, 0x205e},
  {0x2060, 0x2fff}, {0x3001, 0x10ffff},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(249);
      ADVANCE_MAP(
        '\n', 305,
        '\r', 305,
        '"', 299,
        '#', 301,
        '%', 305,
        '&', 305,
        '\'', 305,
        '(', 305,
        ')', 305,
        '*', 305,
        ',', 305,
        '.', 305,
        '/', 305,
        ':', 305,
        ';', 305,
        '=', 305,
        '?', 305,
        '@', 305,
        'V', 305,
        '\\', 497,
        '^', 305,
        '_', 305,
        '`', 305,
        'v', 305,
        '{', 305,
        '|', 305,
        '}', 305,
        '~', 307,
        '<', 305,
        '>', 305,
        'A', 305,
        'a', 305,
        'C', 305,
        'c', 305,
        'I', 305,
        'i', 305,
        'L', 305,
        'l', 305,
        'P', 305,
        'p', 305,
        'W', 305,
        'w', 305,
        '[', 305,
        ']', 305,
        'D', 305,
        'F', 305,
        'S', 305,
        'd', 305,
        'f', 305,
        's', 305,
        '$', 305,
        'B', 305,
        'E', 305,
        'G', 305,
        'O', 305,
        'R', 305,
        'T', 305,
        'X', 305,
        'b', 305,
        'e', 305,
        'g', 305,
        'o', 305,
        'r', 305,
        't', 305,
        'x', 305,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(305);
      if (lookahead != 0) ADVANCE(305);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '\n', 509,
        '\r', 510,
        '"', 299,
        '#', 258,
        '%', 504,
        '&', 505,
        '\'', 490,
        '*', 521,
        ',', 493,
        '/', 522,
        ':', 297,
        ';', 520,
        '?', 523,
        '@', 501,
        'N', 78,
        'V', 500,
        '^', 508,
        '_', 515,
        'v', 499,
        '|', 506,
        '~', 307,
        '+', 26,
        '-', 26,
        '<', 519,
        '>', 519,
        'A', 514,
        'a', 514,
        'C', 507,
        'c', 507,
        'I', 512,
        'i', 512,
        'P', 511,
        'p', 511,
        'W', 513,
        'w', 513,
        '[', 518,
        ']', 518,
        '{', 517,
        '}', 517,
        '(', 516,
        ')', 516,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(265);
      if (set_contains(aux_sym_format_directive_type_token11_character_set_1, 11, lookahead)) ADVANCE(525);
      END_STATE();
    case 2:
      if (lookahead == ' ') ADVANCE(104);
      END_STATE();
    case 3:
      if (lookahead == ' ') ADVANCE(110);
      END_STATE();
    case 4:
      if (lookahead == ' ') ADVANCE(110);
      if (lookahead == 's') ADVANCE(3);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(252);
      if (lookahead == '?') ADVANCE(486);
      if (lookahead == '^') ADVANCE(479);
      if (lookahead == '_') ADVANCE(253);
      if (lookahead == '|') ADVANCE(229);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 252,
        'C', 622,
        '^', 479,
        '_', 253,
        'c', 623,
        '|', 229,
        'B', 232,
        'b', 232,
        'O', 233,
        'o', 233,
        'X', 234,
        'x', 234,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(238);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(252);
      if (lookahead == '^') ADVANCE(479);
      if (lookahead == '_') ADVANCE(253);
      if (lookahead == '|') ADVANCE(229);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '!', 252,
        '^', 479,
        '_', 253,
        '|', 229,
        'B', 232,
        'b', 232,
        'O', 233,
        'o', 233,
        'X', 234,
        'x', 234,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(238);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '"', 299,
        '#', 254,
        '\'', 490,
        '(', 480,
        ')', 481,
        ',', 494,
        '.', 261,
        ':', 296,
        ';', 252,
        '=', 561,
        '^', 478,
        '`', 491,
        'a', 377,
        'c', 374,
        'd', 412,
        'e', 378,
        'f', 364,
        'i', 349,
        'm', 312,
        'n', 323,
        'r', 332,
        's', 453,
        't', 359,
        'u', 395,
        'w', 357,
        '|', 465,
        '+', 311,
        '-', 311,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(250);
      if (lookahead != 0 &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(477);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '"', 299,
        '#', 254,
        '\'', 490,
        '(', 480,
        ')', 481,
        ',', 494,
        '.', 261,
        ':', 296,
        ';', 252,
        '=', 561,
        '^', 478,
        '`', 491,
        'a', 377,
        'c', 374,
        'd', 285,
        'e', 378,
        'f', 282,
        'i', 349,
        'm', 312,
        'n', 323,
        'r', 332,
        's', 292,
        't', 359,
        'u', 395,
        'w', 357,
        '|', 465,
        '+', 311,
        '-', 311,
        'D', 294,
        'F', 294,
        'L', 294,
        'S', 294,
        'l', 294,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(250);
      if (lookahead != 0 &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(477);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '"', 299,
        '#', 254,
        '\'', 490,
        '(', 480,
        ')', 481,
        ',', 494,
        '.', 261,
        ':', 296,
        ';', 252,
        '^', 478,
        '`', 491,
        'a', 377,
        'c', 374,
        'd', 412,
        'e', 378,
        'f', 364,
        'i', 349,
        'm', 312,
        'n', 323,
        'r', 332,
        's', 453,
        't', 359,
        'u', 395,
        'w', 357,
        '|', 465,
        '+', 311,
        '-', 311,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(250);
      if (lookahead != 0 &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(477);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '"', 299,
        '#', 254,
        '\'', 490,
        '(', 480,
        ')', 481,
        ',', 494,
        '.', 261,
        ':', 296,
        ';', 252,
        '^', 478,
        '`', 491,
        'a', 377,
        'c', 374,
        'd', 285,
        'e', 378,
        'f', 282,
        'i', 349,
        'm', 312,
        'n', 323,
        'r', 332,
        's', 292,
        't', 359,
        'u', 395,
        'w', 357,
        '|', 465,
        '+', 311,
        '-', 311,
        'D', 294,
        'F', 294,
        'L', 294,
        'S', 294,
        'l', 294,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(250);
      if (lookahead != 0 &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(477);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '"', 299,
        '#', 254,
        '\'', 490,
        '(', 480,
        ')', 481,
        ',', 494,
        '.', 261,
        ':', 296,
        ';', 252,
        '^', 478,
        '`', 491,
        'c', 375,
        'd', 281,
        'l', 280,
        'n', 363,
        '|', 465,
        '+', 311,
        '-', 311,
        'D', 294,
        'F', 294,
        'L', 294,
        'S', 294,
        'f', 294,
        's', 294,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(250);
      if (lookahead != 0 &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(477);
      END_STATE();
    case 14:
      ADVANCE_MAP(
        '"', 299,
        '#', 254,
        '\'', 490,
        '(', 480,
        ')', 481,
        ',', 494,
        '.', 261,
        ':', 296,
        ';', 252,
        '^', 478,
        '`', 491,
        'c', 375,
        'd', 337,
        'l', 318,
        'n', 363,
        '|', 465,
        '+', 311,
        '-', 311,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(250);
      if (lookahead != 0 &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(477);
      END_STATE();
    case 15:
      ADVANCE_MAP(
        '"', 299,
        '#', 254,
        '\'', 490,
        '(', 480,
        ',', 494,
        '.', 261,
        ':', 296,
        ';', 252,
        '=', 561,
        '^', 478,
        '`', 491,
        'a', 321,
        'b', 335,
        'c', 375,
        'd', 288,
        'f', 291,
        'i', 400,
        'n', 363,
        'o', 401,
        't', 361,
        'u', 427,
        '|', 465,
        '+', 311,
        '-', 311,
        'D', 294,
        'F', 294,
        'L', 294,
        'S', 294,
        'l', 294,
        's', 294,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(250);
      if (lookahead != 0 &&
          (lookahead < '\'' || ')' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(477);
      END_STATE();
    case 16:
      ADVANCE_MAP(
        '"', 299,
        '#', 254,
        '\'', 490,
        '(', 480,
        ',', 494,
        '.', 261,
        ':', 296,
        ';', 252,
        '=', 561,
        '^', 478,
        '`', 491,
        'a', 321,
        'b', 335,
        'c', 375,
        'd', 416,
        'f', 433,
        'i', 400,
        'n', 363,
        'o', 401,
        't', 361,
        'u', 427,
        '|', 465,
        '+', 311,
        '-', 311,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(250);
      if (lookahead != 0 &&
          (lookahead < '\'' || ')' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(477);
      END_STATE();
    case 17:
      ADVANCE_MAP(
        '"', 299,
        '#', 256,
        '\'', 490,
        '(', 480,
        ',', 494,
        '.', 261,
        ':', 296,
        '\\', 239,
        '^', 478,
        '`', 491,
        'c', 375,
        'n', 363,
        '{', 482,
        '|', 465,
        '+', 311,
        '-', 311,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(263);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 18:
      ADVANCE_MAP(
        '"', 299,
        '#', 255,
        '\'', 490,
        '(', 480,
        ',', 39,
        ':', 296,
        ';', 252,
        '^', 478,
        '{', 482,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(250);
      if (lookahead != 0 &&
          (lookahead < '\'' || ')' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          lookahead != '}') ADVANCE(477);
      END_STATE();
    case 19:
      ADVANCE_MAP(
        '"', 299,
        '#', 5,
        '(', 480,
        ',', 493,
        ':', 296,
        ';', 252,
        '^', 478,
        '{', 482,
        'D', 294,
        'F', 294,
        'L', 294,
        'S', 294,
        'd', 294,
        'f', 294,
        'l', 294,
        's', 294,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(250);
      if (lookahead != 0 &&
          (lookahead < '\'' || ')' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          lookahead != '}') ADVANCE(477);
      END_STATE();
    case 20:
      ADVANCE_MAP(
        '"', 299,
        '#', 5,
        '(', 480,
        ',', 493,
        ':', 296,
        ';', 252,
        '^', 478,
        '{', 482,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(250);
      if (lookahead != 0 &&
          (lookahead < '\'' || ')' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          lookahead != '}') ADVANCE(477);
      END_STATE();
    case 21:
      if (lookahead == '"') ADVANCE(299);
      if (lookahead == '#') ADVANCE(303);
      if (lookahead == '\\') ADVANCE(246);
      if (lookahead == '~') ADVANCE(307);
      if (lookahead != 0) ADVANCE(305);
      END_STATE();
    case 22:
      ADVANCE_MAP(
        '"', 23,
        '#', 7,
        '(', 480,
        ')', 481,
        ',', 493,
        '/', 522,
        ':', 296,
        ';', 252,
        '=', 560,
        '\\', 239,
        '^', 478,
        'a', 52,
        'b', 67,
        'c', 126,
        'd', 286,
        'e', 136,
        'f', 284,
        'i', 90,
        'm', 44,
        'n', 57,
        'o', 146,
        'r', 68,
        's', 293,
        't', 105,
        'u', 148,
        'w', 102,
        '{', 482,
        'D', 279,
        'F', 279,
        'L', 279,
        'S', 279,
        'l', 279,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(236);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(250);
      END_STATE();
    case 23:
      if (lookahead == '"') ADVANCE(616);
      if (lookahead == '\\') ADVANCE(245);
      if (lookahead != 0) ADVANCE(23);
      END_STATE();
    case 24:
      if (lookahead == '#') ADVANCE(495);
      if (lookahead != 0) ADVANCE(229);
      END_STATE();
    case 25:
      ADVANCE_MAP(
        '#', 6,
        '(', 480,
        ')', 481,
        ',', 493,
        ':', 296,
        ';', 252,
        '^', 478,
        'a', 124,
        'c', 126,
        'd', 287,
        'e', 136,
        'f', 283,
        'i', 91,
        'm', 44,
        'n', 57,
        'r', 68,
        's', 293,
        't', 107,
        'u', 147,
        'w', 102,
        '+', 26,
        '-', 26,
        'D', 279,
        'F', 279,
        'L', 279,
        'S', 279,
        'l', 279,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(265);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(250);
      END_STATE();
    case 26:
      if (lookahead == '#') ADVANCE(237);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(265);
      END_STATE();
    case 27:
      ADVANCE_MAP(
        '#', 255,
        '\'', 490,
        '(', 480,
        ')', 481,
        ',', 39,
        ';', 252,
        '^', 478,
        '{', 482,
        'D', 279,
        'F', 279,
        'L', 279,
        'S', 279,
        'd', 279,
        'f', 279,
        'l', 279,
        's', 279,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(250);
      END_STATE();
    case 28:
      ADVANCE_MAP(
        '#', 255,
        '\'', 490,
        '(', 480,
        ',', 39,
        ':', 296,
        ';', 252,
        '=', 560,
        '^', 478,
        'a', 51,
        'b', 67,
        'c', 125,
        'd', 289,
        'f', 290,
        'i', 154,
        'o', 146,
        't', 108,
        'u', 182,
        '{', 482,
        'D', 279,
        'F', 279,
        'L', 279,
        'S', 279,
        'l', 279,
        's', 279,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(250);
      END_STATE();
    case 29:
      ADVANCE_MAP(
        '#', 257,
        '\'', 490,
        '(', 480,
        ',', 39,
        '=', 561,
        '^', 478,
        'a', 321,
        'b', 335,
        'd', 416,
        'f', 433,
        'i', 400,
        'o', 401,
        't', 361,
        'u', 427,
        '{', 482,
      );
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 30:
      ADVANCE_MAP(
        '#', 8,
        '(', 480,
        ',', 493,
        ':', 295,
        ';', 252,
        '^', 478,
        'c', 125,
        'i', 163,
        '+', 26,
        '-', 26,
        'D', 279,
        'F', 279,
        'L', 279,
        'S', 279,
        'd', 279,
        'f', 279,
        'l', 279,
        's', 279,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(265);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(250);
      END_STATE();
    case 31:
      if (lookahead == '#') ADVANCE(228);
      if (lookahead == '/') ADVANCE(522);
      if (lookahead == ':') ADVANCE(296);
      if ((!eof && set_contains(aux_sym__sym_lit_without_slash_token1_character_set_1, 18, lookahead))) ADVANCE(617);
      END_STATE();
    case 32:
      if (lookahead == '#') ADVANCE(228);
      if (lookahead == '=') ADVANCE(561);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_1, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 33:
      if (lookahead == '#') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(618);
      if ((!eof && set_contains(aux_sym__sym_lit_without_slash_token1_character_set_1, 18, lookahead))) ADVANCE(617);
      END_STATE();
    case 34:
      if (lookahead == '#') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(337);
      if (lookahead == 'l') ADVANCE(424);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_1, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 35:
      if (lookahead == '#') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(76);
      if (lookahead == 'l') ADVANCE(180);
      END_STATE();
    case 36:
      if (lookahead == '#') ADVANCE(498);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(497);
      END_STATE();
    case 37:
      if (lookahead == '-') ADVANCE(121);
      END_STATE();
    case 38:
      if (lookahead == '-') ADVANCE(200);
      END_STATE();
    case 39:
      if (lookahead == '@') ADVANCE(492);
      END_STATE();
    case 40:
      if (lookahead == 'A') ADVANCE(484);
      if (lookahead == 'a') ADVANCE(485);
      if (lookahead == '#' ||
          lookahead == '=') ADVANCE(619);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      END_STATE();
    case 41:
      if (lookahead == 'a') ADVANCE(55);
      END_STATE();
    case 42:
      if (lookahead == 'a') ADVANCE(201);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(123);
      END_STATE();
    case 44:
      if (lookahead == 'a') ADVANCE(221);
      if (lookahead == 'i') ADVANCE(158);
      END_STATE();
    case 45:
      if (lookahead == 'a') ADVANCE(226);
      END_STATE();
    case 46:
      if (lookahead == 'a') ADVANCE(58);
      if (lookahead == 'e') ADVANCE(211);
      END_STATE();
    case 47:
      if (lookahead == 'a') ADVANCE(207);
      END_STATE();
    case 48:
      if (lookahead == 'a') ADVANCE(131);
      END_STATE();
    case 49:
      if (lookahead == 'a') ADVANCE(132);
      END_STATE();
    case 50:
      if (lookahead == 'b') ADVANCE(171);
      END_STATE();
    case 51:
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'c') ADVANCE(189);
      END_STATE();
    case 52:
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'c') ADVANCE(189);
      if (lookahead == 'l') ADVANCE(218);
      if (lookahead == 'n') ADVANCE(59);
      if (lookahead == 'p') ADVANCE(184);
      if (lookahead == 's') ADVANCE(569);
      END_STATE();
    case 53:
      if (lookahead == 'c') ADVANCE(563);
      END_STATE();
    case 54:
      if (lookahead == 'c') ADVANCE(609);
      END_STATE();
    case 55:
      if (lookahead == 'c') ADVANCE(100);
      END_STATE();
    case 56:
      if (lookahead == 'c') ADVANCE(206);
      END_STATE();
    case 57:
      if (lookahead == 'c') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 58:
      if (lookahead == 'c') ADVANCE(195);
      END_STATE();
    case 59:
      if (lookahead == 'd') ADVANCE(567);
      END_STATE();
    case 60:
      if (lookahead == 'd') ADVANCE(563);
      END_STATE();
    case 61:
      if (lookahead == 'd') ADVANCE(611);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(41);
      if (lookahead == 't') ADVANCE(99);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(2);
      END_STATE();
    case 64:
      if (lookahead == 'e') ADVANCE(144);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(222);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(4);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(114);
      if (lookahead == 'y') ADVANCE(556);
      END_STATE();
    case 68:
      if (lookahead == 'e') ADVANCE(185);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 70:
      if (lookahead == 'e') ADVANCE(594);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(540);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(576);
      END_STATE();
    case 73:
      if (lookahead == 'e') ADVANCE(562);
      if (lookahead == 'i') ADVANCE(160);
      END_STATE();
    case 74:
      if (lookahead == 'e') ADVANCE(524);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(202);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(56);
      END_STATE();
    case 78:
      if (lookahead == 'e') ADVANCE(220);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(187);
      END_STATE();
    case 80:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(190);
      END_STATE();
    case 82:
      if (lookahead == 'e') ADVANCE(116);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(152);
      if (lookahead == 'i') ADVANCE(134);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(157);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(150);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(194);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(204);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(165);
      END_STATE();
    case 89:
      if (lookahead == 'f') ADVANCE(537);
      END_STATE();
    case 90:
      if (lookahead == 'f') ADVANCE(584);
      if (lookahead == 'n') ADVANCE(529);
      END_STATE();
    case 91:
      if (lookahead == 'f') ADVANCE(584);
      if (lookahead == 'n') ADVANCE(111);
      END_STATE();
    case 92:
      if (lookahead == 'f') ADVANCE(98);
      END_STATE();
    case 93:
      if (lookahead == 'f') ADVANCE(191);
      if (lookahead == 't') ADVANCE(167);
      END_STATE();
    case 94:
      if (lookahead == 'f') ADVANCE(192);
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 95:
      if (lookahead == 'g') ADVANCE(533);
      END_STATE();
    case 96:
      if (lookahead == 'g') ADVANCE(535);
      END_STATE();
    case 97:
      if (lookahead == 'g') ADVANCE(562);
      END_STATE();
    case 98:
      if (lookahead == 'g') ADVANCE(88);
      if (lookahead == 'm') ADVANCE(46);
      if (lookahead == 'u') ADVANCE(155);
      END_STATE();
    case 99:
      if (lookahead == 'h') ADVANCE(63);
      END_STATE();
    case 100:
      if (lookahead == 'h') ADVANCE(2);
      END_STATE();
    case 101:
      if (lookahead == 'h') ADVANCE(37);
      END_STATE();
    case 102:
      if (lookahead == 'h') ADVANCE(83);
      if (lookahead == 'i') ADVANCE(209);
      END_STATE();
    case 103:
      if (lookahead == 'h') ADVANCE(571);
      END_STATE();
    case 104:
      if (lookahead == 'h') ADVANCE(42);
      if (lookahead == 'p') ADVANCE(188);
      END_STATE();
    case 105:
      if (lookahead == 'h') ADVANCE(69);
      if (lookahead == 'o') ADVANCE(544);
      END_STATE();
    case 106:
      if (lookahead == 'h') ADVANCE(175);
      END_STATE();
    case 107:
      if (lookahead == 'h') ADVANCE(86);
      END_STATE();
    case 108:
      if (lookahead == 'h') ADVANCE(85);
      if (lookahead == 'o') ADVANCE(544);
      END_STATE();
    case 109:
      if (lookahead == 'i') ADVANCE(227);
      END_STATE();
    case 110:
      if (lookahead == 'i') ADVANCE(145);
      if (lookahead == 'o') ADVANCE(89);
      END_STATE();
    case 111:
      if (lookahead == 'i') ADVANCE(210);
      if (lookahead == 't') ADVANCE(169);
      END_STATE();
    case 112:
      if (lookahead == 'i') ADVANCE(143);
      END_STATE();
    case 113:
      if (lookahead == 'i') ADVANCE(54);
      END_STATE();
    case 114:
      if (lookahead == 'i') ADVANCE(149);
      if (lookahead == 'l') ADVANCE(172);
      END_STATE();
    case 115:
      if (lookahead == 'i') ADVANCE(127);
      END_STATE();
    case 116:
      if (lookahead == 'i') ADVANCE(199);
      END_STATE();
    case 117:
      if (lookahead == 'i') ADVANCE(159);
      END_STATE();
    case 118:
      if (lookahead == 'i') ADVANCE(160);
      END_STATE();
    case 119:
      if (lookahead == 'i') ADVANCE(164);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(49);
      END_STATE();
    case 121:
      if (lookahead == 'k') ADVANCE(65);
      if (lookahead == 'v') ADVANCE(43);
      END_STATE();
    case 122:
      if (lookahead == 'l') ADVANCE(4);
      END_STATE();
    case 123:
      if (lookahead == 'l') ADVANCE(213);
      END_STATE();
    case 124:
      if (lookahead == 'l') ADVANCE(218);
      if (lookahead == 'n') ADVANCE(59);
      if (lookahead == 'p') ADVANCE(184);
      if (lookahead == 's') ADVANCE(569);
      END_STATE();
    case 125:
      if (lookahead == 'l') ADVANCE(526);
      END_STATE();
    case 126:
      if (lookahead == 'l') ADVANCE(526);
      if (lookahead == 'o') ADVANCE(129);
      END_STATE();
    case 127:
      if (lookahead == 'l') ADVANCE(578);
      END_STATE();
    case 128:
      if (lookahead == 'l') ADVANCE(224);
      END_STATE();
    case 129:
      if (lookahead == 'l') ADVANCE(133);
      if (lookahead == 'u') ADVANCE(161);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(225);
      END_STATE();
    case 131:
      if (lookahead == 'l') ADVANCE(128);
      END_STATE();
    case 132:
      if (lookahead == 'l') ADVANCE(130);
      END_STATE();
    case 133:
      if (lookahead == 'l') ADVANCE(77);
      END_STATE();
    case 134:
      if (lookahead == 'l') ADVANCE(72);
      END_STATE();
    case 135:
      if (lookahead == 'l') ADVANCE(87);
      if (lookahead == 't') ADVANCE(115);
      END_STATE();
    case 136:
      if (lookahead == 'l') ADVANCE(205);
      END_STATE();
    case 137:
      if (lookahead == 'l') ADVANCE(119);
      END_STATE();
    case 138:
      if (lookahead == 'm') ADVANCE(50);
      END_STATE();
    case 139:
      if (lookahead == 'm') ADVANCE(564);
      END_STATE();
    case 140:
      if (lookahead == 'm') ADVANCE(542);
      END_STATE();
    case 141:
      if (lookahead == 'm') ADVANCE(548);
      END_STATE();
    case 142:
      if (lookahead == 'm') ADVANCE(552);
      END_STATE();
    case 143:
      if (lookahead == 'm') ADVANCE(109);
      END_STATE();
    case 144:
      if (lookahead == 'n') ADVANCE(208);
      END_STATE();
    case 145:
      if (lookahead == 'n') ADVANCE(537);
      END_STATE();
    case 146:
      if (lookahead == 'n') ADVANCE(554);
      END_STATE();
    case 147:
      if (lookahead == 'n') ADVANCE(135);
      END_STATE();
    case 148:
      if (lookahead == 'n') ADVANCE(135);
      if (lookahead == 'p') ADVANCE(93);
      if (lookahead == 's') ADVANCE(117);
      END_STATE();
    case 149:
      if (lookahead == 'n') ADVANCE(95);
      END_STATE();
    case 150:
      if (lookahead == 'n') ADVANCE(558);
      END_STATE();
    case 151:
      if (lookahead == 'n') ADVANCE(558);
      if (lookahead == 'r') ADVANCE(82);
      END_STATE();
    case 152:
      if (lookahead == 'n') ADVANCE(582);
      END_STATE();
    case 153:
      if (lookahead == 'n') ADVANCE(599);
      END_STATE();
    case 154:
      if (lookahead == 'n') ADVANCE(528);
      END_STATE();
    case 155:
      if (lookahead == 'n') ADVANCE(605);
      END_STATE();
    case 156:
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 157:
      if (lookahead == 'n') ADVANCE(60);
      END_STATE();
    case 158:
      if (lookahead == 'n') ADVANCE(112);
      END_STATE();
    case 159:
      if (lookahead == 'n') ADVANCE(96);
      END_STATE();
    case 160:
      if (lookahead == 'n') ADVANCE(97);
      END_STATE();
    case 161:
      if (lookahead == 'n') ADVANCE(206);
      END_STATE();
    case 162:
      if (lookahead == 'n') ADVANCE(48);
      END_STATE();
    case 163:
      if (lookahead == 'n') ADVANCE(212);
      END_STATE();
    case 164:
      if (lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 165:
      if (lookahead == 'n') ADVANCE(81);
      END_STATE();
    case 166:
      if (lookahead == 'n') ADVANCE(94);
      END_STATE();
    case 167:
      if (lookahead == 'o') ADVANCE(546);
      END_STATE();
    case 168:
      if (lookahead == 'o') ADVANCE(550);
      END_STATE();
    case 169:
      if (lookahead == 'o') ADVANCE(596);
      END_STATE();
    case 170:
      if (lookahead == 'o') ADVANCE(607);
      END_STATE();
    case 171:
      if (lookahead == 'o') ADVANCE(122);
      END_STATE();
    case 172:
      if (lookahead == 'o') ADVANCE(217);
      END_STATE();
    case 173:
      if (lookahead == 'o') ADVANCE(183);
      END_STATE();
    case 174:
      if (lookahead == 'o') ADVANCE(140);
      END_STATE();
    case 175:
      if (lookahead == 'o') ADVANCE(61);
      END_STATE();
    case 176:
      if (lookahead == 'o') ADVANCE(203);
      END_STATE();
    case 177:
      if (lookahead == 'o') ADVANCE(141);
      END_STATE();
    case 178:
      if (lookahead == 'o') ADVANCE(142);
      END_STATE();
    case 179:
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 180:
      if (lookahead == 'o') ADVANCE(173);
      END_STATE();
    case 181:
      if (lookahead == 'o') ADVANCE(216);
      END_STATE();
    case 182:
      if (lookahead == 'p') ADVANCE(93);
      if (lookahead == 's') ADVANCE(117);
      END_STATE();
    case 183:
      if (lookahead == 'p') ADVANCE(603);
      END_STATE();
    case 184:
      if (lookahead == 'p') ADVANCE(84);
      END_STATE();
    case 185:
      if (lookahead == 'p') ADVANCE(80);
      if (lookahead == 't') ADVANCE(214);
      END_STATE();
    case 186:
      if (lookahead == 'r') ADVANCE(565);
      END_STATE();
    case 187:
      if (lookahead == 'r') ADVANCE(592);
      END_STATE();
    case 188:
      if (lookahead == 'r') ADVANCE(75);
      END_STATE();
    case 189:
      if (lookahead == 'r') ADVANCE(176);
      END_STATE();
    case 190:
      if (lookahead == 'r') ADVANCE(113);
      END_STATE();
    case 191:
      if (lookahead == 'r') ADVANCE(177);
      END_STATE();
    case 192:
      if (lookahead == 'r') ADVANCE(178);
      END_STATE();
    case 193:
      if (lookahead == 'r') ADVANCE(153);
      END_STATE();
    case 194:
      if (lookahead == 'r') ADVANCE(82);
      END_STATE();
    case 195:
      if (lookahead == 'r') ADVANCE(170);
      END_STATE();
    case 196:
      if (lookahead == 's') ADVANCE(531);
      END_STATE();
    case 197:
      if (lookahead == 's') ADVANCE(588);
      END_STATE();
    case 198:
      if (lookahead == 's') ADVANCE(586);
      END_STATE();
    case 199:
      if (lookahead == 's') ADVANCE(590);
      END_STATE();
    case 200:
      if (lookahead == 's') ADVANCE(223);
      END_STATE();
    case 201:
      if (lookahead == 's') ADVANCE(101);
      END_STATE();
    case 202:
      if (lookahead == 's') ADVANCE(64);
      END_STATE();
    case 203:
      if (lookahead == 's') ADVANCE(196);
      END_STATE();
    case 204:
      if (lookahead == 's') ADVANCE(198);
      END_STATE();
    case 205:
      if (lookahead == 's') ADVANCE(70);
      END_STATE();
    case 206:
      if (lookahead == 't') ADVANCE(563);
      END_STATE();
    case 207:
      if (lookahead == 't') ADVANCE(580);
      END_STATE();
    case 208:
      if (lookahead == 't') ADVANCE(38);
      END_STATE();
    case 209:
      if (lookahead == 't') ADVANCE(103);
      END_STATE();
    case 210:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 211:
      if (lookahead == 't') ADVANCE(106);
      END_STATE();
    case 212:
      if (lookahead == 't') ADVANCE(169);
      END_STATE();
    case 213:
      if (lookahead == 'u') ADVANCE(66);
      END_STATE();
    case 214:
      if (lookahead == 'u') ADVANCE(193);
      END_STATE();
    case 215:
      if (lookahead == 'v') ADVANCE(79);
      END_STATE();
    case 216:
      if (lookahead == 'v') ADVANCE(71);
      END_STATE();
    case 217:
      if (lookahead == 'w') ADVANCE(538);
      END_STATE();
    case 218:
      if (lookahead == 'w') ADVANCE(45);
      END_STATE();
    case 219:
      if (lookahead == 'w') ADVANCE(166);
      END_STATE();
    case 220:
      if (lookahead == 'w') ADVANCE(137);
      END_STATE();
    case 221:
      if (lookahead == 'x') ADVANCE(112);
      END_STATE();
    case 222:
      if (lookahead == 'y') ADVANCE(4);
      END_STATE();
    case 223:
      if (lookahead == 'y') ADVANCE(138);
      END_STATE();
    case 224:
      if (lookahead == 'y') ADVANCE(597);
      END_STATE();
    case 225:
      if (lookahead == 'y') ADVANCE(601);
      END_STATE();
    case 226:
      if (lookahead == 'y') ADVANCE(197);
      END_STATE();
    case 227:
      if (lookahead == 'z') ADVANCE(73);
      END_STATE();
    case 228:
      if (lookahead == '|') ADVANCE(229);
      END_STATE();
    case 229:
      if (lookahead == '|') ADVANCE(24);
      if (lookahead != 0) ADVANCE(229);
      END_STATE();
    case 230:
      if (lookahead == '|') ADVANCE(496);
      if (lookahead != 0) ADVANCE(230);
      END_STATE();
    case 231:
      if (lookahead == '#' ||
          lookahead == '=') ADVANCE(619);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      END_STATE();
    case 232:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(240);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(266);
      END_STATE();
    case 233:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(241);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(268);
      END_STATE();
    case 234:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(243);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(274);
      END_STATE();
    case 235:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(242);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(273);
      END_STATE();
    case 236:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(259);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(236);
      END_STATE();
    case 237:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(232);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(233);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(234);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(238);
      END_STATE();
    case 238:
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(238);
      END_STATE();
    case 239:
      if (lookahead == '(' ||
          lookahead == ')') ADVANCE(308);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\f' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(309);
      END_STATE();
    case 240:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(266);
      END_STATE();
    case 241:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(268);
      END_STATE();
    case 242:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(273);
      END_STATE();
    case 243:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(274);
      END_STATE();
    case 244:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(276);
      END_STATE();
    case 245:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(23);
      END_STATE();
    case 246:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(306);
      END_STATE();
    case 247:
      if (eof) ADVANCE(249);
      ADVANCE_MAP(
        '"', 299,
        '#', 254,
        '\'', 490,
        '(', 480,
        ')', 481,
        ',', 494,
        '.', 261,
        ':', 296,
        ';', 252,
        '^', 478,
        '`', 491,
        'c', 375,
        'n', 363,
        '{', 482,
        '|', 465,
        '}', 483,
        '+', 311,
        '-', 311,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(250);
      if (lookahead != 0 &&
          (lookahead < '[' || '^' < lookahead)) ADVANCE(477);
      END_STATE();
    case 248:
      if (eof) ADVANCE(249);
      ADVANCE_MAP(
        '"', 299,
        '#', 254,
        '\'', 490,
        '(', 480,
        ')', 481,
        ',', 494,
        '.', 261,
        ':', 296,
        ';', 252,
        '^', 478,
        '`', 491,
        'c', 375,
        'n', 363,
        '|', 465,
        '}', 483,
        '+', 311,
        '-', 311,
        'D', 294,
        'F', 294,
        'L', 294,
        'S', 294,
        'd', 294,
        'f', 294,
        'l', 294,
        's', 294,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(250);
      if (lookahead != 0 &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(477);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym__ws);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(250);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(251);
      if (lookahead != 0) ADVANCE(252);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_POUND_);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_POUND);
      ADVANCE_MAP(
        '!', 252,
        '\'', 489,
        '+', 620,
        '-', 621,
        '0', 40,
        '?', 487,
        'C', 622,
        'P', 614,
        '^', 479,
        '_', 253,
        'c', 623,
        'p', 615,
        '|', 229,
        'B', 232,
        'b', 232,
        'O', 233,
        'o', 233,
        'X', 234,
        'x', 234,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(231);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_POUND);
      ADVANCE_MAP(
        '!', 252,
        '\'', 489,
        '+', 620,
        '-', 621,
        '?', 487,
        'C', 622,
        '^', 479,
        '_', 253,
        'c', 623,
        '|', 229,
      );
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_POUND);
      ADVANCE_MAP(
        '\'', 489,
        '+', 620,
        '-', 621,
        '0', 40,
        '?', 487,
        'C', 622,
        'P', 614,
        '^', 479,
        'c', 623,
        'p', 615,
        '|', 229,
        'B', 232,
        'b', 232,
        'O', 233,
        'o', 233,
        'X', 234,
        'x', 234,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(231);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_POUND);
      ADVANCE_MAP(
        '\'', 489,
        '+', 620,
        '-', 621,
        '?', 487,
        'C', 622,
        '^', 479,
        'c', 623,
        '|', 229,
      );
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '|') ADVANCE(229);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(232);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(233);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(234);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(238);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(aux_sym__form_token1);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(aux_sym__form_token1);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_DOT);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(aux_sym_num_lit_token1);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(aux_sym_num_lit_token1);
      if (lookahead == '.') ADVANCE(270);
      if (lookahead == '/') ADVANCE(474);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(260);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(278);
      if (('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'L' ||
          lookahead == 'S' ||
          ('d' <= lookahead && lookahead <= 'f') ||
          lookahead == 'l' ||
          lookahead == 's') ADVANCE(466);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(263);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(aux_sym_num_lit_token1);
      if (lookahead == '.') ADVANCE(270);
      if (lookahead == '/') ADVANCE(474);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(278);
      if (('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'L' ||
          lookahead == 'S' ||
          ('d' <= lookahead && lookahead <= 'f') ||
          lookahead == 'l' ||
          lookahead == 's') ADVANCE(466);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(aux_sym_num_lit_token1);
      if (lookahead == '.') ADVANCE(271);
      if (lookahead == '/') ADVANCE(242);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(262);
      if (('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'L' ||
          lookahead == 'S' ||
          ('d' <= lookahead && lookahead <= 'f') ||
          lookahead == 'l' ||
          lookahead == 's') ADVANCE(235);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(265);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(aux_sym_num_lit_token1);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(266);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(aux_sym_num_lit_token1);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(267);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(aux_sym_num_lit_token1);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(268);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(aux_sym_num_lit_token1);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(269);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(aux_sym_num_lit_token1);
      if (('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'L' ||
          lookahead == 'S' ||
          ('d' <= lookahead && lookahead <= 'f') ||
          lookahead == 'l' ||
          lookahead == 's') ADVANCE(466);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(270);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(aux_sym_num_lit_token1);
      if (('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'L' ||
          lookahead == 'S' ||
          ('d' <= lookahead && lookahead <= 'f') ||
          lookahead == 'l' ||
          lookahead == 's') ADVANCE(235);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(271);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(aux_sym_num_lit_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(aux_sym_num_lit_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(273);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(aux_sym_num_lit_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(274);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(aux_sym_num_lit_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(275);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(aux_sym_num_lit_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(276);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(aux_sym_num_lit_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(277);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(aux_sym_num_lit_token1);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(aux_sym_num_lit_token2);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(aux_sym_num_lit_token2);
      if (lookahead == 'a') ADVANCE(391);
      if (lookahead == 'o') ADVANCE(417);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(aux_sym_num_lit_token2);
      if (lookahead == 'e') ADVANCE(350);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(aux_sym_num_lit_token2);
      if (lookahead == 'i') ADVANCE(405);
      if (lookahead == 'o') ADVANCE(431);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(aux_sym_num_lit_token2);
      if (lookahead == 'i') ADVANCE(162);
      if (lookahead == 'o') ADVANCE(186);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(aux_sym_num_lit_token2);
      if (lookahead == 'i') ADVANCE(162);
      if (lookahead == 'o') ADVANCE(186);
      if (lookahead == 'r') ADVANCE(174);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(aux_sym_num_lit_token2);
      if (lookahead == 'o') ADVANCE(575);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(aux_sym_num_lit_token2);
      if (lookahead == 'o') ADVANCE(574);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(aux_sym_num_lit_token2);
      if (lookahead == 'o') ADVANCE(573);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(aux_sym_num_lit_token2);
      if (lookahead == 'o') ADVANCE(459);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(aux_sym_num_lit_token2);
      if (lookahead == 'o') ADVANCE(219);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(aux_sym_num_lit_token2);
      if (lookahead == 'r') ADVANCE(174);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(aux_sym_num_lit_token2);
      if (lookahead == 'r') ADVANCE(419);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(aux_sym_num_lit_token2);
      if (lookahead == 'u') ADVANCE(392);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(aux_sym_num_lit_token2);
      if (lookahead == 'u') ADVANCE(139);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(aux_sym_num_lit_token2);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(298);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '@') ADVANCE(503);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(aux_sym_str_lit_token1);
      if (lookahead == '#') ADVANCE(305);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          lookahead != '\\' &&
          lookahead != '~') ADVANCE(304);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(aux_sym_str_lit_token1);
      ADVANCE_MAP(
        '?', 302,
        'C', 305,
        'P', 305,
        '^', 305,
        '_', 305,
        'c', 305,
        'p', 305,
        '|', 304,
      );
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '~') ADVANCE(305);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(aux_sym_str_lit_token1);
      if (lookahead == '@') ADVANCE(305);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '~') ADVANCE(305);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(aux_sym_str_lit_token1);
      if (lookahead == '|') ADVANCE(304);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '~') ADVANCE(305);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(aux_sym_str_lit_token1);
      if (lookahead == '|') ADVANCE(300);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '~') ADVANCE(304);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(aux_sym_str_lit_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '~') ADVANCE(305);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(aux_sym_str_lit_token2);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(aux_sym_char_lit_token1);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(aux_sym_char_lit_token1);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\f' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(309);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_nil_lit);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == '#') ADVANCE(470);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(264);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'a') ADVANCE(460);
      if (lookahead == 'i') ADVANCE(407);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'a') ADVANCE(463);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'a') ADVANCE(613);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'a') ADVANCE(448);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'a') ADVANCE(326);
      if (lookahead == 'e') ADVANCE(450);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'a') ADVANCE(384);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'a') ADVANCE(391);
      if (lookahead == 'o') ADVANCE(417);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'a') ADVANCE(386);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'b') ADVANCE(329);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'b') ADVANCE(425);
      if (lookahead == 'c') ADVANCE(434);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'c') ADVANCE(610);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'c') ADVANCE(422);
      if (lookahead == 'e') ADVANCE(456);
      if (lookahead == 'i') ADVANCE(376);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'c') ADVANCE(369);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'c') ADVANCE(452);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'c') ADVANCE(440);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'd') ADVANCE(568);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'd') ADVANCE(612);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'd') ADVANCE(314);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'd') ADVANCE(369);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'e') ADVANCE(477);
      if (lookahead == 'i') ADVANCE(399);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'e') ADVANCE(430);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'e') ADVANCE(595);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'e') ADVANCE(577);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'e') ADVANCE(370);
      if (lookahead == 'y') ADVANCE(557);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'e') ADVANCE(541);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'e') ADVANCE(350);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'e') ADVANCE(446);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'e') ADVANCE(436);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'e') ADVANCE(325);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'e') ADVANCE(432);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'e') ADVANCE(315);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'e') ADVANCE(397);
      if (lookahead == 'i') ADVANCE(387);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'e') ADVANCE(367);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'e') ADVANCE(404);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'e') ADVANCE(435);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'e') ADVANCE(402);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'e') ADVANCE(411);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'f') ADVANCE(585);
      if (lookahead == 'n') ADVANCE(365);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'f') ADVANCE(356);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'f') ADVANCE(438);
      if (lookahead == 't') ADVANCE(413);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'f') ADVANCE(439);
      if (lookahead == 't') ADVANCE(414);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'g') ADVANCE(477);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'g') ADVANCE(534);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'g') ADVANCE(536);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'g') ADVANCE(348);
      if (lookahead == 'm') ADVANCE(316);
      if (lookahead == 'u') ADVANCE(403);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'h') ADVANCE(343);
      if (lookahead == 'i') ADVANCE(449);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'h') ADVANCE(572);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'h') ADVANCE(339);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'h') ADVANCE(420);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'h') ADVANCE(347);
      if (lookahead == 'o') ADVANCE(545);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'i') ADVANCE(464);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'i') ADVANCE(376);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'i') ADVANCE(405);
      if (lookahead == 'o') ADVANCE(431);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'i') ADVANCE(451);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'i') ADVANCE(322);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'i') ADVANCE(443);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'i') ADVANCE(379);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'i') ADVANCE(399);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'i') ADVANCE(406);
      if (lookahead == 'l') ADVANCE(418);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'i') ADVANCE(408);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'i') ADVANCE(394);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'i') ADVANCE(319);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'l') ADVANCE(527);
      if (lookahead == 'o') ADVANCE(382);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'l') ADVANCE(527);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'l') ADVANCE(310);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'l') ADVANCE(457);
      if (lookahead == 'n') ADVANCE(327);
      if (lookahead == 'p') ADVANCE(429);
      if (lookahead == 's') ADVANCE(570);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'l') ADVANCE(445);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'l') ADVANCE(579);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'l') ADVANCE(461);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'l') ADVANCE(462);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'l') ADVANCE(385);
      if (lookahead == 'u') ADVANCE(410);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'l') ADVANCE(338);
      if (lookahead == 't') ADVANCE(368);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'l') ADVANCE(380);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'l') ADVANCE(340);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'l') ADVANCE(381);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'l') ADVANCE(334);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'm') ADVANCE(543);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'm') ADVANCE(549);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'm') ADVANCE(553);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'm') ADVANCE(320);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'm') ADVANCE(393);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'm') ADVANCE(369);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'm') ADVANCE(362);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'n') ADVANCE(383);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'n') ADVANCE(324);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'n') ADVANCE(583);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'n') ADVANCE(600);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'n') ADVANCE(353);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'n') ADVANCE(530);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'n') ADVANCE(555);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'n') ADVANCE(559);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'n') ADVANCE(606);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'n') ADVANCE(330);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'n') ADVANCE(317);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'n') ADVANCE(354);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'n') ADVANCE(372);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'n') ADVANCE(355);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'n') ADVANCE(352);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'n') ADVANCE(452);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'n') ADVANCE(346);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'o') ADVANCE(575);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'o') ADVANCE(547);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'o') ADVANCE(551);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'o') ADVANCE(608);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'o') ADVANCE(459);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'o') ADVANCE(428);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'o') ADVANCE(458);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'o') ADVANCE(388);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'o') ADVANCE(328);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'o') ADVANCE(389);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'o') ADVANCE(396);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'o') ADVANCE(390);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'o') ADVANCE(417);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'o') ADVANCE(455);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'o') ADVANCE(447);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'p') ADVANCE(351);
      if (lookahead == 's') ADVANCE(371);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'p') ADVANCE(604);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'p') ADVANCE(345);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'p') ADVANCE(342);
      if (lookahead == 't') ADVANCE(454);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'r') ADVANCE(566);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'r') ADVANCE(593);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'r') ADVANCE(419);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'r') ADVANCE(426);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'r') ADVANCE(366);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'r') ADVANCE(344);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'r') ADVANCE(398);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'r') ADVANCE(421);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'r') ADVANCE(423);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'r') ADVANCE(415);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 's') ADVANCE(589);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 's') ADVANCE(587);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 's') ADVANCE(591);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 's') ADVANCE(532);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 's') ADVANCE(333);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 's') ADVANCE(442);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 's') ADVANCE(444);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 't') ADVANCE(581);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 't') ADVANCE(358);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 't') ADVANCE(360);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 't') ADVANCE(373);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 't') ADVANCE(369);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'u') ADVANCE(392);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'u') ADVANCE(437);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'v') ADVANCE(336);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'v') ADVANCE(341);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'w') ADVANCE(313);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'w') ADVANCE(539);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'w') ADVANCE(409);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'x') ADVANCE(372);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'y') ADVANCE(598);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'y') ADVANCE(602);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'y') ADVANCE(441);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'z') ADVANCE(331);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == '|') ADVANCE(477);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          (0x1c <= lookahead && lookahead <= ' ') ||
          lookahead == '"' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ',' ||
          lookahead == ':' ||
          lookahead == ';' ||
          ('[' <= lookahead && lookahead <= '^') ||
          lookahead == '`' ||
          ('{' <= lookahead && lookahead <= '}') ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x2006) ||
          (0x2008 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(230);
      if (lookahead != 0) ADVANCE(465);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(474);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(472);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(267);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(473);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(269);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(275);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(467);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(468);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(469);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(471);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(476);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(471);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(267);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(269);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(275);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(277);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(anon_sym_POUND_CARET);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(anon_sym_POUND0A);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(anon_sym_POUND0a);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(anon_sym_POUND_QMARK);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(anon_sym_POUND_QMARK);
      if (lookahead == '@') ADVANCE(488);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(anon_sym_POUND_QMARK_AT);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(anon_sym_POUND_SQUOTE);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(anon_sym_COMMA_AT);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(anon_sym_COMMA);
      if (lookahead == '@') ADVANCE(492);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(sym_block_comment);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(sym_fancy_literal);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(aux_sym__format_token_token1);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(aux_sym__format_token_token1);
      if (lookahead == '|') ADVANCE(229);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(anon_sym_v);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(anon_sym_V);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == ':') ADVANCE(502);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(anon_sym_AT_COLON);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(anon_sym_COLON_AT);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(aux_sym_format_directive_type_token1);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(aux_sym_format_directive_type_token2);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(anon_sym_LF);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(anon_sym_CR);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(aux_sym_format_directive_type_token3);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(aux_sym_format_directive_type_token4);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(aux_sym_format_directive_type_token5);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(aux_sym_format_directive_type_token6);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(aux_sym_format_directive_type_token7);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(aux_sym_format_directive_type_token8);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(aux_sym_format_directive_type_token9);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(aux_sym_format_directive_type_token10);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(anon_sym_Newline);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(aux_sym_format_directive_type_token11);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(anon_sym_cl);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(anon_sym_cl);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'i') ADVANCE(210);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(anon_sym_in);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(anon_sym_across);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(anon_sym_across);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(anon_sym_being);
      if (lookahead == ' ') ADVANCE(62);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(anon_sym_being);
      if (lookahead == ' ') ADVANCE(62);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(anon_sym_using);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(aux_sym_for_clause_word_token1);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(anon_sym_below);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(anon_sym_below);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(anon_sym_above);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(anon_sym_above);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(anon_sym_from);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(anon_sym_to);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(anon_sym_to);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(anon_sym_upto);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(anon_sym_upto);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(anon_sym_upfrom);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(anon_sym_upfrom);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(anon_sym_downto);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(anon_sym_downto);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(anon_sym_downfrom);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(anon_sym_downfrom);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(anon_sym_on);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(anon_sym_on);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(anon_sym_by);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(anon_sym_by);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(anon_sym_then);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(anon_sym_EQ);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(aux_sym_accumulation_verb_token1);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(aux_sym_accumulation_verb_token1);
      if (lookahead == 'i') ADVANCE(160);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(aux_sym_accumulation_verb_token1);
      if (lookahead == 'm') ADVANCE(118);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(anon_sym_for);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(anon_sym_and);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(anon_sym_as);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(anon_sym_with);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'w') ADVANCE(166);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(anon_sym_do);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(anon_sym_while);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(anon_sym_until);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(anon_sym_until);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(anon_sym_repeat);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(anon_sym_repeat);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(anon_sym_when);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(anon_sym_when);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(anon_sym_if);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(anon_sym_unless);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(anon_sym_unless);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(anon_sym_always);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(anon_sym_always);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(anon_sym_thereis);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(anon_sym_thereis);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(anon_sym_never);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(anon_sym_never);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(anon_sym_else);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(anon_sym_into);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(anon_sym_finally);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(anon_sym_return);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(anon_sym_initially);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(anon_sym_initially);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(anon_sym_loop);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(anon_sym_loop);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(anon_sym_defun);
      END_STATE();
    case 606:
      ACCEPT_TOKEN(anon_sym_defun);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 607:
      ACCEPT_TOKEN(anon_sym_defmacro);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(anon_sym_defmacro);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(anon_sym_defgeneric);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(anon_sym_defgeneric);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(anon_sym_defmethod);
      END_STATE();
    case 612:
      ACCEPT_TOKEN(anon_sym_defmethod);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(anon_sym_lambda);
      if ((!eof && set_contains(aux_sym_sym_lit_token1_character_set_2, 17, lookahead))) ADVANCE(477);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(anon_sym_POUNDP);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(anon_sym_POUNDp);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(aux_sym_path_lit_token1);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(aux_sym__sym_lit_without_slash_token1);
      END_STATE();
    case 618:
      ACCEPT_TOKEN(aux_sym__sym_lit_without_slash_token1);
      if (lookahead == 'l') ADVANCE(526);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(sym_self_referential_reader_macro);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(anon_sym_POUND_PLUS);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(anon_sym_POUND_DASH);
      END_STATE();
    case 622:
      ACCEPT_TOKEN(anon_sym_POUNDC);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(anon_sym_POUNDc);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 247},
  [2] = {.lex_state = 9},
  [3] = {.lex_state = 11},
  [4] = {.lex_state = 11},
  [5] = {.lex_state = 9},
  [6] = {.lex_state = 9},
  [7] = {.lex_state = 9},
  [8] = {.lex_state = 11},
  [9] = {.lex_state = 9},
  [10] = {.lex_state = 9},
  [11] = {.lex_state = 9},
  [12] = {.lex_state = 9},
  [13] = {.lex_state = 11},
  [14] = {.lex_state = 9},
  [15] = {.lex_state = 9},
  [16] = {.lex_state = 9},
  [17] = {.lex_state = 9},
  [18] = {.lex_state = 9},
  [19] = {.lex_state = 9},
  [20] = {.lex_state = 9},
  [21] = {.lex_state = 9},
  [22] = {.lex_state = 9},
  [23] = {.lex_state = 9},
  [24] = {.lex_state = 9},
  [25] = {.lex_state = 9},
  [26] = {.lex_state = 9},
  [27] = {.lex_state = 9},
  [28] = {.lex_state = 9},
  [29] = {.lex_state = 9},
  [30] = {.lex_state = 9},
  [31] = {.lex_state = 9},
  [32] = {.lex_state = 9},
  [33] = {.lex_state = 9},
  [34] = {.lex_state = 9},
  [35] = {.lex_state = 9},
  [36] = {.lex_state = 9},
  [37] = {.lex_state = 9},
  [38] = {.lex_state = 9},
  [39] = {.lex_state = 9},
  [40] = {.lex_state = 9},
  [41] = {.lex_state = 9},
  [42] = {.lex_state = 11},
  [43] = {.lex_state = 11},
  [44] = {.lex_state = 11},
  [45] = {.lex_state = 11},
  [46] = {.lex_state = 11},
  [47] = {.lex_state = 11},
  [48] = {.lex_state = 16},
  [49] = {.lex_state = 11},
  [50] = {.lex_state = 16},
  [51] = {.lex_state = 16},
  [52] = {.lex_state = 11},
  [53] = {.lex_state = 16},
  [54] = {.lex_state = 11},
  [55] = {.lex_state = 11},
  [56] = {.lex_state = 11},
  [57] = {.lex_state = 11},
  [58] = {.lex_state = 11},
  [59] = {.lex_state = 11},
  [60] = {.lex_state = 11},
  [61] = {.lex_state = 11},
  [62] = {.lex_state = 11},
  [63] = {.lex_state = 11},
  [64] = {.lex_state = 11},
  [65] = {.lex_state = 11},
  [66] = {.lex_state = 11},
  [67] = {.lex_state = 16},
  [68] = {.lex_state = 11},
  [69] = {.lex_state = 11},
  [70] = {.lex_state = 11},
  [71] = {.lex_state = 11},
  [72] = {.lex_state = 11},
  [73] = {.lex_state = 11},
  [74] = {.lex_state = 11},
  [75] = {.lex_state = 11},
  [76] = {.lex_state = 11},
  [77] = {.lex_state = 11},
  [78] = {.lex_state = 16},
  [79] = {.lex_state = 11},
  [80] = {.lex_state = 11},
  [81] = {.lex_state = 11},
  [82] = {.lex_state = 16},
  [83] = {.lex_state = 11},
  [84] = {.lex_state = 16},
  [85] = {.lex_state = 11},
  [86] = {.lex_state = 11},
  [87] = {.lex_state = 11},
  [88] = {.lex_state = 11},
  [89] = {.lex_state = 11},
  [90] = {.lex_state = 11},
  [91] = {.lex_state = 11},
  [92] = {.lex_state = 11},
  [93] = {.lex_state = 11},
  [94] = {.lex_state = 11},
  [95] = {.lex_state = 11},
  [96] = {.lex_state = 11},
  [97] = {.lex_state = 11},
  [98] = {.lex_state = 11},
  [99] = {.lex_state = 11},
  [100] = {.lex_state = 11},
  [101] = {.lex_state = 11},
  [102] = {.lex_state = 11},
  [103] = {.lex_state = 11},
  [104] = {.lex_state = 11},
  [105] = {.lex_state = 11},
  [106] = {.lex_state = 11},
  [107] = {.lex_state = 11},
  [108] = {.lex_state = 11},
  [109] = {.lex_state = 11},
  [110] = {.lex_state = 11},
  [111] = {.lex_state = 11},
  [112] = {.lex_state = 11},
  [113] = {.lex_state = 11},
  [114] = {.lex_state = 11},
  [115] = {.lex_state = 11},
  [116] = {.lex_state = 11},
  [117] = {.lex_state = 11},
  [118] = {.lex_state = 11},
  [119] = {.lex_state = 11},
  [120] = {.lex_state = 11},
  [121] = {.lex_state = 11},
  [122] = {.lex_state = 11},
  [123] = {.lex_state = 11},
  [124] = {.lex_state = 11},
  [125] = {.lex_state = 11},
  [126] = {.lex_state = 11},
  [127] = {.lex_state = 11},
  [128] = {.lex_state = 11},
  [129] = {.lex_state = 16},
  [130] = {.lex_state = 11},
  [131] = {.lex_state = 11},
  [132] = {.lex_state = 11},
  [133] = {.lex_state = 11},
  [134] = {.lex_state = 11},
  [135] = {.lex_state = 11},
  [136] = {.lex_state = 11},
  [137] = {.lex_state = 11},
  [138] = {.lex_state = 11},
  [139] = {.lex_state = 11},
  [140] = {.lex_state = 11},
  [141] = {.lex_state = 11},
  [142] = {.lex_state = 11},
  [143] = {.lex_state = 11},
  [144] = {.lex_state = 11},
  [145] = {.lex_state = 11},
  [146] = {.lex_state = 11},
  [147] = {.lex_state = 11},
  [148] = {.lex_state = 11},
  [149] = {.lex_state = 11},
  [150] = {.lex_state = 11},
  [151] = {.lex_state = 11},
  [152] = {.lex_state = 11},
  [153] = {.lex_state = 11},
  [154] = {.lex_state = 11},
  [155] = {.lex_state = 11},
  [156] = {.lex_state = 11},
  [157] = {.lex_state = 11},
  [158] = {.lex_state = 11},
  [159] = {.lex_state = 11},
  [160] = {.lex_state = 11},
  [161] = {.lex_state = 11},
  [162] = {.lex_state = 11},
  [163] = {.lex_state = 11},
  [164] = {.lex_state = 11},
  [165] = {.lex_state = 11},
  [166] = {.lex_state = 11},
  [167] = {.lex_state = 11},
  [168] = {.lex_state = 11},
  [169] = {.lex_state = 11},
  [170] = {.lex_state = 11},
  [171] = {.lex_state = 11},
  [172] = {.lex_state = 11},
  [173] = {.lex_state = 11},
  [174] = {.lex_state = 11},
  [175] = {.lex_state = 11},
  [176] = {.lex_state = 11},
  [177] = {.lex_state = 11},
  [178] = {.lex_state = 11},
  [179] = {.lex_state = 11},
  [180] = {.lex_state = 11},
  [181] = {.lex_state = 11},
  [182] = {.lex_state = 11},
  [183] = {.lex_state = 11},
  [184] = {.lex_state = 11},
  [185] = {.lex_state = 11},
  [186] = {.lex_state = 11},
  [187] = {.lex_state = 11},
  [188] = {.lex_state = 11},
  [189] = {.lex_state = 11},
  [190] = {.lex_state = 11},
  [191] = {.lex_state = 11},
  [192] = {.lex_state = 11},
  [193] = {.lex_state = 11},
  [194] = {.lex_state = 11},
  [195] = {.lex_state = 11},
  [196] = {.lex_state = 11},
  [197] = {.lex_state = 11},
  [198] = {.lex_state = 11},
  [199] = {.lex_state = 11},
  [200] = {.lex_state = 11},
  [201] = {.lex_state = 11},
  [202] = {.lex_state = 11},
  [203] = {.lex_state = 11},
  [204] = {.lex_state = 11},
  [205] = {.lex_state = 11},
  [206] = {.lex_state = 11},
  [207] = {.lex_state = 11},
  [208] = {.lex_state = 11},
  [209] = {.lex_state = 11},
  [210] = {.lex_state = 11},
  [211] = {.lex_state = 11},
  [212] = {.lex_state = 11},
  [213] = {.lex_state = 11},
  [214] = {.lex_state = 11},
  [215] = {.lex_state = 11},
  [216] = {.lex_state = 11},
  [217] = {.lex_state = 11},
  [218] = {.lex_state = 11},
  [219] = {.lex_state = 11},
  [220] = {.lex_state = 11},
  [221] = {.lex_state = 11},
  [222] = {.lex_state = 11},
  [223] = {.lex_state = 11},
  [224] = {.lex_state = 11},
  [225] = {.lex_state = 11},
  [226] = {.lex_state = 11},
  [227] = {.lex_state = 11},
  [228] = {.lex_state = 11},
  [229] = {.lex_state = 11},
  [230] = {.lex_state = 11},
  [231] = {.lex_state = 11},
  [232] = {.lex_state = 11},
  [233] = {.lex_state = 11},
  [234] = {.lex_state = 11},
  [235] = {.lex_state = 11},
  [236] = {.lex_state = 11},
  [237] = {.lex_state = 11},
  [238] = {.lex_state = 11},
  [239] = {.lex_state = 11},
  [240] = {.lex_state = 11},
  [241] = {.lex_state = 11},
  [242] = {.lex_state = 11},
  [243] = {.lex_state = 11},
  [244] = {.lex_state = 11},
  [245] = {.lex_state = 11},
  [246] = {.lex_state = 11},
  [247] = {.lex_state = 11},
  [248] = {.lex_state = 11},
  [249] = {.lex_state = 11},
  [250] = {.lex_state = 11},
  [251] = {.lex_state = 11},
  [252] = {.lex_state = 11},
  [253] = {.lex_state = 11},
  [254] = {.lex_state = 11},
  [255] = {.lex_state = 11},
  [256] = {.lex_state = 11},
  [257] = {.lex_state = 11},
  [258] = {.lex_state = 11},
  [259] = {.lex_state = 11},
  [260] = {.lex_state = 11},
  [261] = {.lex_state = 11},
  [262] = {.lex_state = 11},
  [263] = {.lex_state = 11},
  [264] = {.lex_state = 11},
  [265] = {.lex_state = 11},
  [266] = {.lex_state = 11},
  [267] = {.lex_state = 11},
  [268] = {.lex_state = 11},
  [269] = {.lex_state = 11},
  [270] = {.lex_state = 16},
  [271] = {.lex_state = 16},
  [272] = {.lex_state = 16},
  [273] = {.lex_state = 16},
  [274] = {.lex_state = 16},
  [275] = {.lex_state = 16},
  [276] = {.lex_state = 16},
  [277] = {.lex_state = 16},
  [278] = {.lex_state = 16},
  [279] = {.lex_state = 14},
  [280] = {.lex_state = 14},
  [281] = {.lex_state = 14},
  [282] = {.lex_state = 14},
  [283] = {.lex_state = 14},
  [284] = {.lex_state = 14},
  [285] = {.lex_state = 14},
  [286] = {.lex_state = 14},
  [287] = {.lex_state = 14},
  [288] = {.lex_state = 14},
  [289] = {.lex_state = 247},
  [290] = {.lex_state = 247},
  [291] = {.lex_state = 247},
  [292] = {.lex_state = 247},
  [293] = {.lex_state = 247},
  [294] = {.lex_state = 247},
  [295] = {.lex_state = 247},
  [296] = {.lex_state = 247},
  [297] = {.lex_state = 247},
  [298] = {.lex_state = 247},
  [299] = {.lex_state = 247},
  [300] = {.lex_state = 247},
  [301] = {.lex_state = 247},
  [302] = {.lex_state = 247},
  [303] = {.lex_state = 247},
  [304] = {.lex_state = 247},
  [305] = {.lex_state = 247},
  [306] = {.lex_state = 247},
  [307] = {.lex_state = 247},
  [308] = {.lex_state = 247},
  [309] = {.lex_state = 247},
  [310] = {.lex_state = 247},
  [311] = {.lex_state = 247},
  [312] = {.lex_state = 247},
  [313] = {.lex_state = 247},
  [314] = {.lex_state = 247},
  [315] = {.lex_state = 247},
  [316] = {.lex_state = 247},
  [317] = {.lex_state = 247},
  [318] = {.lex_state = 247},
  [319] = {.lex_state = 247},
  [320] = {.lex_state = 247},
  [321] = {.lex_state = 247},
  [322] = {.lex_state = 247},
  [323] = {.lex_state = 247},
  [324] = {.lex_state = 247},
  [325] = {.lex_state = 247},
  [326] = {.lex_state = 247},
  [327] = {.lex_state = 247},
  [328] = {.lex_state = 247},
  [329] = {.lex_state = 247},
  [330] = {.lex_state = 247},
  [331] = {.lex_state = 247},
  [332] = {.lex_state = 247},
  [333] = {.lex_state = 247},
  [334] = {.lex_state = 247},
  [335] = {.lex_state = 247},
  [336] = {.lex_state = 247},
  [337] = {.lex_state = 247},
  [338] = {.lex_state = 247},
  [339] = {.lex_state = 247},
  [340] = {.lex_state = 247},
  [341] = {.lex_state = 247},
  [342] = {.lex_state = 247},
  [343] = {.lex_state = 247},
  [344] = {.lex_state = 247},
  [345] = {.lex_state = 247},
  [346] = {.lex_state = 247},
  [347] = {.lex_state = 247},
  [348] = {.lex_state = 247},
  [349] = {.lex_state = 247},
  [350] = {.lex_state = 247},
  [351] = {.lex_state = 247},
  [352] = {.lex_state = 247},
  [353] = {.lex_state = 247},
  [354] = {.lex_state = 247},
  [355] = {.lex_state = 247},
  [356] = {.lex_state = 247},
  [357] = {.lex_state = 247},
  [358] = {.lex_state = 247},
  [359] = {.lex_state = 247},
  [360] = {.lex_state = 247},
  [361] = {.lex_state = 247},
  [362] = {.lex_state = 247},
  [363] = {.lex_state = 247},
  [364] = {.lex_state = 247},
  [365] = {.lex_state = 247},
  [366] = {.lex_state = 247},
  [367] = {.lex_state = 247},
  [368] = {.lex_state = 247},
  [369] = {.lex_state = 247},
  [370] = {.lex_state = 247},
  [371] = {.lex_state = 247},
  [372] = {.lex_state = 247},
  [373] = {.lex_state = 247},
  [374] = {.lex_state = 247},
  [375] = {.lex_state = 247},
  [376] = {.lex_state = 247},
  [377] = {.lex_state = 247},
  [378] = {.lex_state = 247},
  [379] = {.lex_state = 247},
  [380] = {.lex_state = 247},
  [381] = {.lex_state = 247},
  [382] = {.lex_state = 247},
  [383] = {.lex_state = 247},
  [384] = {.lex_state = 247},
  [385] = {.lex_state = 247},
  [386] = {.lex_state = 247},
  [387] = {.lex_state = 247},
  [388] = {.lex_state = 247},
  [389] = {.lex_state = 247},
  [390] = {.lex_state = 247},
  [391] = {.lex_state = 247},
  [392] = {.lex_state = 247},
  [393] = {.lex_state = 247},
  [394] = {.lex_state = 247},
  [395] = {.lex_state = 247},
  [396] = {.lex_state = 247},
  [397] = {.lex_state = 247},
  [398] = {.lex_state = 247},
  [399] = {.lex_state = 247},
  [400] = {.lex_state = 247},
  [401] = {.lex_state = 247},
  [402] = {.lex_state = 247},
  [403] = {.lex_state = 247},
  [404] = {.lex_state = 247},
  [405] = {.lex_state = 247},
  [406] = {.lex_state = 247},
  [407] = {.lex_state = 247},
  [408] = {.lex_state = 247},
  [409] = {.lex_state = 247},
  [410] = {.lex_state = 247},
  [411] = {.lex_state = 247},
  [412] = {.lex_state = 247},
  [413] = {.lex_state = 247},
  [414] = {.lex_state = 247},
  [415] = {.lex_state = 247},
  [416] = {.lex_state = 247},
  [417] = {.lex_state = 247},
  [418] = {.lex_state = 247},
  [419] = {.lex_state = 247},
  [420] = {.lex_state = 247},
  [421] = {.lex_state = 247},
  [422] = {.lex_state = 247},
  [423] = {.lex_state = 247},
  [424] = {.lex_state = 247},
  [425] = {.lex_state = 247},
  [426] = {.lex_state = 247},
  [427] = {.lex_state = 247},
  [428] = {.lex_state = 247},
  [429] = {.lex_state = 247},
  [430] = {.lex_state = 247},
  [431] = {.lex_state = 247},
  [432] = {.lex_state = 247},
  [433] = {.lex_state = 247},
  [434] = {.lex_state = 247},
  [435] = {.lex_state = 247},
  [436] = {.lex_state = 247},
  [437] = {.lex_state = 247},
  [438] = {.lex_state = 247},
  [439] = {.lex_state = 247},
  [440] = {.lex_state = 247},
  [441] = {.lex_state = 247},
  [442] = {.lex_state = 247},
  [443] = {.lex_state = 247},
  [444] = {.lex_state = 247},
  [445] = {.lex_state = 247},
  [446] = {.lex_state = 247},
  [447] = {.lex_state = 247},
  [448] = {.lex_state = 247},
  [449] = {.lex_state = 247},
  [450] = {.lex_state = 247},
  [451] = {.lex_state = 247},
  [452] = {.lex_state = 247},
  [453] = {.lex_state = 247},
  [454] = {.lex_state = 247},
  [455] = {.lex_state = 247},
  [456] = {.lex_state = 247},
  [457] = {.lex_state = 247},
  [458] = {.lex_state = 247},
  [459] = {.lex_state = 247},
  [460] = {.lex_state = 247},
  [461] = {.lex_state = 247},
  [462] = {.lex_state = 247},
  [463] = {.lex_state = 247},
  [464] = {.lex_state = 247},
  [465] = {.lex_state = 247},
  [466] = {.lex_state = 247},
  [467] = {.lex_state = 247},
  [468] = {.lex_state = 247},
  [469] = {.lex_state = 247},
  [470] = {.lex_state = 247},
  [471] = {.lex_state = 247},
  [472] = {.lex_state = 247},
  [473] = {.lex_state = 247},
  [474] = {.lex_state = 247},
  [475] = {.lex_state = 247},
  [476] = {.lex_state = 247},
  [477] = {.lex_state = 247},
  [478] = {.lex_state = 247},
  [479] = {.lex_state = 247},
  [480] = {.lex_state = 247},
  [481] = {.lex_state = 247},
  [482] = {.lex_state = 247},
  [483] = {.lex_state = 247},
  [484] = {.lex_state = 247},
  [485] = {.lex_state = 247},
  [486] = {.lex_state = 247},
  [487] = {.lex_state = 247},
  [488] = {.lex_state = 247},
  [489] = {.lex_state = 247},
  [490] = {.lex_state = 247},
  [491] = {.lex_state = 247},
  [492] = {.lex_state = 247},
  [493] = {.lex_state = 247},
  [494] = {.lex_state = 247},
  [495] = {.lex_state = 247},
  [496] = {.lex_state = 247},
  [497] = {.lex_state = 247},
  [498] = {.lex_state = 247},
  [499] = {.lex_state = 247},
  [500] = {.lex_state = 247},
  [501] = {.lex_state = 247},
  [502] = {.lex_state = 247},
  [503] = {.lex_state = 247},
  [504] = {.lex_state = 247},
  [505] = {.lex_state = 247},
  [506] = {.lex_state = 247},
  [507] = {.lex_state = 247},
  [508] = {.lex_state = 247},
  [509] = {.lex_state = 247},
  [510] = {.lex_state = 247},
  [511] = {.lex_state = 247},
  [512] = {.lex_state = 247},
  [513] = {.lex_state = 247},
  [514] = {.lex_state = 247},
  [515] = {.lex_state = 247},
  [516] = {.lex_state = 247},
  [517] = {.lex_state = 247},
  [518] = {.lex_state = 247},
  [519] = {.lex_state = 247},
  [520] = {.lex_state = 247},
  [521] = {.lex_state = 247},
  [522] = {.lex_state = 247},
  [523] = {.lex_state = 247},
  [524] = {.lex_state = 247},
  [525] = {.lex_state = 247},
  [526] = {.lex_state = 247},
  [527] = {.lex_state = 247},
  [528] = {.lex_state = 247},
  [529] = {.lex_state = 247},
  [530] = {.lex_state = 247},
  [531] = {.lex_state = 247},
  [532] = {.lex_state = 247},
  [533] = {.lex_state = 247},
  [534] = {.lex_state = 247},
  [535] = {.lex_state = 247},
  [536] = {.lex_state = 247},
  [537] = {.lex_state = 247},
  [538] = {.lex_state = 247},
  [539] = {.lex_state = 247},
  [540] = {.lex_state = 247},
  [541] = {.lex_state = 247},
  [542] = {.lex_state = 247},
  [543] = {.lex_state = 247},
  [544] = {.lex_state = 247},
  [545] = {.lex_state = 247},
  [546] = {.lex_state = 247},
  [547] = {.lex_state = 247},
  [548] = {.lex_state = 247},
  [549] = {.lex_state = 247},
  [550] = {.lex_state = 247},
  [551] = {.lex_state = 247},
  [552] = {.lex_state = 247},
  [553] = {.lex_state = 247},
  [554] = {.lex_state = 247},
  [555] = {.lex_state = 247},
  [556] = {.lex_state = 247},
  [557] = {.lex_state = 247},
  [558] = {.lex_state = 247},
  [559] = {.lex_state = 247},
  [560] = {.lex_state = 247},
  [561] = {.lex_state = 247},
  [562] = {.lex_state = 247},
  [563] = {.lex_state = 247},
  [564] = {.lex_state = 247},
  [565] = {.lex_state = 247},
  [566] = {.lex_state = 247},
  [567] = {.lex_state = 247},
  [568] = {.lex_state = 247},
  [569] = {.lex_state = 247},
  [570] = {.lex_state = 247},
  [571] = {.lex_state = 247},
  [572] = {.lex_state = 247},
  [573] = {.lex_state = 247},
  [574] = {.lex_state = 247},
  [575] = {.lex_state = 247},
  [576] = {.lex_state = 247},
  [577] = {.lex_state = 247},
  [578] = {.lex_state = 247},
  [579] = {.lex_state = 247},
  [580] = {.lex_state = 247},
  [581] = {.lex_state = 247},
  [582] = {.lex_state = 247},
  [583] = {.lex_state = 247},
  [584] = {.lex_state = 247},
  [585] = {.lex_state = 247},
  [586] = {.lex_state = 247},
  [587] = {.lex_state = 247},
  [588] = {.lex_state = 247},
  [589] = {.lex_state = 247},
  [590] = {.lex_state = 247},
  [591] = {.lex_state = 247},
  [592] = {.lex_state = 247},
  [593] = {.lex_state = 247},
  [594] = {.lex_state = 247},
  [595] = {.lex_state = 247},
  [596] = {.lex_state = 247},
  [597] = {.lex_state = 247},
  [598] = {.lex_state = 247},
  [599] = {.lex_state = 247},
  [600] = {.lex_state = 247},
  [601] = {.lex_state = 247},
  [602] = {.lex_state = 247},
  [603] = {.lex_state = 247},
  [604] = {.lex_state = 247},
  [605] = {.lex_state = 247},
  [606] = {.lex_state = 247},
  [607] = {.lex_state = 247},
  [608] = {.lex_state = 247},
  [609] = {.lex_state = 247},
  [610] = {.lex_state = 247},
  [611] = {.lex_state = 247},
  [612] = {.lex_state = 247},
  [613] = {.lex_state = 247},
  [614] = {.lex_state = 247},
  [615] = {.lex_state = 247},
  [616] = {.lex_state = 247},
  [617] = {.lex_state = 247},
  [618] = {.lex_state = 247},
  [619] = {.lex_state = 247},
  [620] = {.lex_state = 247},
  [621] = {.lex_state = 247},
  [622] = {.lex_state = 247},
  [623] = {.lex_state = 247},
  [624] = {.lex_state = 247},
  [625] = {.lex_state = 247},
  [626] = {.lex_state = 247},
  [627] = {.lex_state = 247},
  [628] = {.lex_state = 247},
  [629] = {.lex_state = 247},
  [630] = {.lex_state = 247},
  [631] = {.lex_state = 247},
  [632] = {.lex_state = 247},
  [633] = {.lex_state = 247},
  [634] = {.lex_state = 247},
  [635] = {.lex_state = 247},
  [636] = {.lex_state = 247},
  [637] = {.lex_state = 247},
  [638] = {.lex_state = 247},
  [639] = {.lex_state = 247},
  [640] = {.lex_state = 247},
  [641] = {.lex_state = 247},
  [642] = {.lex_state = 247},
  [643] = {.lex_state = 247},
  [644] = {.lex_state = 247},
  [645] = {.lex_state = 247},
  [646] = {.lex_state = 247},
  [647] = {.lex_state = 247},
  [648] = {.lex_state = 247},
  [649] = {.lex_state = 247},
  [650] = {.lex_state = 247},
  [651] = {.lex_state = 247},
  [652] = {.lex_state = 247},
  [653] = {.lex_state = 247},
  [654] = {.lex_state = 247},
  [655] = {.lex_state = 247},
  [656] = {.lex_state = 247},
  [657] = {.lex_state = 247},
  [658] = {.lex_state = 247},
  [659] = {.lex_state = 247},
  [660] = {.lex_state = 247},
  [661] = {.lex_state = 247},
  [662] = {.lex_state = 247},
  [663] = {.lex_state = 247},
  [664] = {.lex_state = 247},
  [665] = {.lex_state = 247},
  [666] = {.lex_state = 247},
  [667] = {.lex_state = 247},
  [668] = {.lex_state = 247},
  [669] = {.lex_state = 247},
  [670] = {.lex_state = 247},
  [671] = {.lex_state = 247},
  [672] = {.lex_state = 247},
  [673] = {.lex_state = 247},
  [674] = {.lex_state = 247},
  [675] = {.lex_state = 247},
  [676] = {.lex_state = 247},
  [677] = {.lex_state = 247},
  [678] = {.lex_state = 247},
  [679] = {.lex_state = 247},
  [680] = {.lex_state = 247},
  [681] = {.lex_state = 247},
  [682] = {.lex_state = 247},
  [683] = {.lex_state = 247},
  [684] = {.lex_state = 247},
  [685] = {.lex_state = 247},
  [686] = {.lex_state = 247},
  [687] = {.lex_state = 247},
  [688] = {.lex_state = 247},
  [689] = {.lex_state = 247},
  [690] = {.lex_state = 247},
  [691] = {.lex_state = 247},
  [692] = {.lex_state = 247},
  [693] = {.lex_state = 247},
  [694] = {.lex_state = 247},
  [695] = {.lex_state = 247},
  [696] = {.lex_state = 247},
  [697] = {.lex_state = 247},
  [698] = {.lex_state = 247},
  [699] = {.lex_state = 247},
  [700] = {.lex_state = 247},
  [701] = {.lex_state = 247},
  [702] = {.lex_state = 247},
  [703] = {.lex_state = 247},
  [704] = {.lex_state = 247},
  [705] = {.lex_state = 247},
  [706] = {.lex_state = 247},
  [707] = {.lex_state = 247},
  [708] = {.lex_state = 247},
  [709] = {.lex_state = 247},
  [710] = {.lex_state = 247},
  [711] = {.lex_state = 247},
  [712] = {.lex_state = 247},
  [713] = {.lex_state = 247},
  [714] = {.lex_state = 247},
  [715] = {.lex_state = 247},
  [716] = {.lex_state = 247},
  [717] = {.lex_state = 247},
  [718] = {.lex_state = 247},
  [719] = {.lex_state = 247},
  [720] = {.lex_state = 247},
  [721] = {.lex_state = 247},
  [722] = {.lex_state = 247},
  [723] = {.lex_state = 247},
  [724] = {.lex_state = 247},
  [725] = {.lex_state = 247},
  [726] = {.lex_state = 247},
  [727] = {.lex_state = 247},
  [728] = {.lex_state = 247},
  [729] = {.lex_state = 247},
  [730] = {.lex_state = 247},
  [731] = {.lex_state = 247},
  [732] = {.lex_state = 247},
  [733] = {.lex_state = 247},
  [734] = {.lex_state = 247},
  [735] = {.lex_state = 247},
  [736] = {.lex_state = 247},
  [737] = {.lex_state = 247},
  [738] = {.lex_state = 247},
  [739] = {.lex_state = 247},
  [740] = {.lex_state = 247},
  [741] = {.lex_state = 247},
  [742] = {.lex_state = 247},
  [743] = {.lex_state = 247},
  [744] = {.lex_state = 247},
  [745] = {.lex_state = 247},
  [746] = {.lex_state = 247},
  [747] = {.lex_state = 247},
  [748] = {.lex_state = 247},
  [749] = {.lex_state = 247},
  [750] = {.lex_state = 247},
  [751] = {.lex_state = 247},
  [752] = {.lex_state = 247},
  [753] = {.lex_state = 247},
  [754] = {.lex_state = 247},
  [755] = {.lex_state = 247},
  [756] = {.lex_state = 247},
  [757] = {.lex_state = 247},
  [758] = {.lex_state = 247},
  [759] = {.lex_state = 247},
  [760] = {.lex_state = 247},
  [761] = {.lex_state = 247},
  [762] = {.lex_state = 247},
  [763] = {.lex_state = 247},
  [764] = {.lex_state = 247},
  [765] = {.lex_state = 247},
  [766] = {.lex_state = 247},
  [767] = {.lex_state = 247},
  [768] = {.lex_state = 247},
  [769] = {.lex_state = 247},
  [770] = {.lex_state = 247},
  [771] = {.lex_state = 247},
  [772] = {.lex_state = 247},
  [773] = {.lex_state = 247},
  [774] = {.lex_state = 247},
  [775] = {.lex_state = 247},
  [776] = {.lex_state = 247},
  [777] = {.lex_state = 247},
  [778] = {.lex_state = 247},
  [779] = {.lex_state = 247},
  [780] = {.lex_state = 247},
  [781] = {.lex_state = 247},
  [782] = {.lex_state = 247},
  [783] = {.lex_state = 247},
  [784] = {.lex_state = 247},
  [785] = {.lex_state = 247},
  [786] = {.lex_state = 247},
  [787] = {.lex_state = 247},
  [788] = {.lex_state = 247},
  [789] = {.lex_state = 247},
  [790] = {.lex_state = 247},
  [791] = {.lex_state = 247},
  [792] = {.lex_state = 247},
  [793] = {.lex_state = 247},
  [794] = {.lex_state = 247},
  [795] = {.lex_state = 247},
  [796] = {.lex_state = 247},
  [797] = {.lex_state = 247},
  [798] = {.lex_state = 247},
  [799] = {.lex_state = 247},
  [800] = {.lex_state = 247},
  [801] = {.lex_state = 247},
  [802] = {.lex_state = 247},
  [803] = {.lex_state = 247},
  [804] = {.lex_state = 247},
  [805] = {.lex_state = 247},
  [806] = {.lex_state = 247},
  [807] = {.lex_state = 247},
  [808] = {.lex_state = 247},
  [809] = {.lex_state = 247},
  [810] = {.lex_state = 247},
  [811] = {.lex_state = 247},
  [812] = {.lex_state = 247},
  [813] = {.lex_state = 247},
  [814] = {.lex_state = 247},
  [815] = {.lex_state = 247},
  [816] = {.lex_state = 247},
  [817] = {.lex_state = 247},
  [818] = {.lex_state = 247},
  [819] = {.lex_state = 247},
  [820] = {.lex_state = 247},
  [821] = {.lex_state = 247},
  [822] = {.lex_state = 247},
  [823] = {.lex_state = 247},
  [824] = {.lex_state = 247},
  [825] = {.lex_state = 247},
  [826] = {.lex_state = 247},
  [827] = {.lex_state = 247},
  [828] = {.lex_state = 247},
  [829] = {.lex_state = 247},
  [830] = {.lex_state = 247},
  [831] = {.lex_state = 247},
  [832] = {.lex_state = 247},
  [833] = {.lex_state = 247},
  [834] = {.lex_state = 247},
  [835] = {.lex_state = 247},
  [836] = {.lex_state = 247},
  [837] = {.lex_state = 247},
  [838] = {.lex_state = 247},
  [839] = {.lex_state = 247},
  [840] = {.lex_state = 247},
  [841] = {.lex_state = 247},
  [842] = {.lex_state = 247},
  [843] = {.lex_state = 247},
  [844] = {.lex_state = 247},
  [845] = {.lex_state = 247},
  [846] = {.lex_state = 247},
  [847] = {.lex_state = 247},
  [848] = {.lex_state = 247},
  [849] = {.lex_state = 247},
  [850] = {.lex_state = 247},
  [851] = {.lex_state = 247},
  [852] = {.lex_state = 247},
  [853] = {.lex_state = 247},
  [854] = {.lex_state = 247},
  [855] = {.lex_state = 247},
  [856] = {.lex_state = 247},
  [857] = {.lex_state = 247},
  [858] = {.lex_state = 247},
  [859] = {.lex_state = 247},
  [860] = {.lex_state = 247},
  [861] = {.lex_state = 247},
  [862] = {.lex_state = 247},
  [863] = {.lex_state = 247},
  [864] = {.lex_state = 247},
  [865] = {.lex_state = 247},
  [866] = {.lex_state = 247},
  [867] = {.lex_state = 247},
  [868] = {.lex_state = 247},
  [869] = {.lex_state = 247},
  [870] = {.lex_state = 247},
  [871] = {.lex_state = 247},
  [872] = {.lex_state = 247},
  [873] = {.lex_state = 247},
  [874] = {.lex_state = 247},
  [875] = {.lex_state = 247},
  [876] = {.lex_state = 247},
  [877] = {.lex_state = 247},
  [878] = {.lex_state = 247},
  [879] = {.lex_state = 247},
  [880] = {.lex_state = 247},
  [881] = {.lex_state = 247},
  [882] = {.lex_state = 247},
  [883] = {.lex_state = 247},
  [884] = {.lex_state = 247},
  [885] = {.lex_state = 247},
  [886] = {.lex_state = 247},
  [887] = {.lex_state = 247},
  [888] = {.lex_state = 247},
  [889] = {.lex_state = 247},
  [890] = {.lex_state = 247},
  [891] = {.lex_state = 247},
  [892] = {.lex_state = 247},
  [893] = {.lex_state = 247},
  [894] = {.lex_state = 247},
  [895] = {.lex_state = 247},
  [896] = {.lex_state = 247},
  [897] = {.lex_state = 247},
  [898] = {.lex_state = 247},
  [899] = {.lex_state = 247},
  [900] = {.lex_state = 247},
  [901] = {.lex_state = 247},
  [902] = {.lex_state = 247},
  [903] = {.lex_state = 247},
  [904] = {.lex_state = 247},
  [905] = {.lex_state = 247},
  [906] = {.lex_state = 247},
  [907] = {.lex_state = 247},
  [908] = {.lex_state = 247},
  [909] = {.lex_state = 247},
  [910] = {.lex_state = 247},
  [911] = {.lex_state = 247},
  [912] = {.lex_state = 247},
  [913] = {.lex_state = 247},
  [914] = {.lex_state = 247},
  [915] = {.lex_state = 247},
  [916] = {.lex_state = 247},
  [917] = {.lex_state = 247},
  [918] = {.lex_state = 247},
  [919] = {.lex_state = 247},
  [920] = {.lex_state = 247},
  [921] = {.lex_state = 247},
  [922] = {.lex_state = 247},
  [923] = {.lex_state = 247},
  [924] = {.lex_state = 247},
  [925] = {.lex_state = 247},
  [926] = {.lex_state = 247},
  [927] = {.lex_state = 247},
  [928] = {.lex_state = 247},
  [929] = {.lex_state = 247},
  [930] = {.lex_state = 247},
  [931] = {.lex_state = 247},
  [932] = {.lex_state = 247},
  [933] = {.lex_state = 247},
  [934] = {.lex_state = 247},
  [935] = {.lex_state = 247},
  [936] = {.lex_state = 247},
  [937] = {.lex_state = 247},
  [938] = {.lex_state = 247},
  [939] = {.lex_state = 247},
  [940] = {.lex_state = 247},
  [941] = {.lex_state = 247},
  [942] = {.lex_state = 247},
  [943] = {.lex_state = 247},
  [944] = {.lex_state = 247},
  [945] = {.lex_state = 247},
  [946] = {.lex_state = 247},
  [947] = {.lex_state = 247},
  [948] = {.lex_state = 247},
  [949] = {.lex_state = 247},
  [950] = {.lex_state = 247},
  [951] = {.lex_state = 247},
  [952] = {.lex_state = 247},
  [953] = {.lex_state = 247},
  [954] = {.lex_state = 247},
  [955] = {.lex_state = 247},
  [956] = {.lex_state = 247},
  [957] = {.lex_state = 247},
  [958] = {.lex_state = 247},
  [959] = {.lex_state = 247},
  [960] = {.lex_state = 247},
  [961] = {.lex_state = 247},
  [962] = {.lex_state = 247},
  [963] = {.lex_state = 247},
  [964] = {.lex_state = 247},
  [965] = {.lex_state = 247},
  [966] = {.lex_state = 247},
  [967] = {.lex_state = 247},
  [968] = {.lex_state = 247},
  [969] = {.lex_state = 247},
  [970] = {.lex_state = 247},
  [971] = {.lex_state = 247},
  [972] = {.lex_state = 247},
  [973] = {.lex_state = 247},
  [974] = {.lex_state = 247},
  [975] = {.lex_state = 247},
  [976] = {.lex_state = 17},
  [977] = {.lex_state = 17},
  [978] = {.lex_state = 17},
  [979] = {.lex_state = 17},
  [980] = {.lex_state = 17},
  [981] = {.lex_state = 17},
  [982] = {.lex_state = 17},
  [983] = {.lex_state = 17},
  [984] = {.lex_state = 17},
  [985] = {.lex_state = 17},
  [986] = {.lex_state = 17},
  [987] = {.lex_state = 17},
  [988] = {.lex_state = 17},
  [989] = {.lex_state = 17},
  [990] = {.lex_state = 9},
  [991] = {.lex_state = 11},
  [992] = {.lex_state = 11},
  [993] = {.lex_state = 11},
  [994] = {.lex_state = 11},
  [995] = {.lex_state = 11},
  [996] = {.lex_state = 10},
  [997] = {.lex_state = 9},
  [998] = {.lex_state = 9},
  [999] = {.lex_state = 9},
  [1000] = {.lex_state = 9},
  [1001] = {.lex_state = 9},
  [1002] = {.lex_state = 9},
  [1003] = {.lex_state = 9},
  [1004] = {.lex_state = 9},
  [1005] = {.lex_state = 9},
  [1006] = {.lex_state = 9},
  [1007] = {.lex_state = 9},
  [1008] = {.lex_state = 9},
  [1009] = {.lex_state = 9},
  [1010] = {.lex_state = 9},
  [1011] = {.lex_state = 9},
  [1012] = {.lex_state = 9},
  [1013] = {.lex_state = 9},
  [1014] = {.lex_state = 9},
  [1015] = {.lex_state = 9},
  [1016] = {.lex_state = 12},
  [1017] = {.lex_state = 9},
  [1018] = {.lex_state = 9},
  [1019] = {.lex_state = 9},
  [1020] = {.lex_state = 9},
  [1021] = {.lex_state = 9},
  [1022] = {.lex_state = 9},
  [1023] = {.lex_state = 9},
  [1024] = {.lex_state = 9},
  [1025] = {.lex_state = 9},
  [1026] = {.lex_state = 9},
  [1027] = {.lex_state = 9},
  [1028] = {.lex_state = 9},
  [1029] = {.lex_state = 9},
  [1030] = {.lex_state = 9},
  [1031] = {.lex_state = 9},
  [1032] = {.lex_state = 9},
  [1033] = {.lex_state = 9},
  [1034] = {.lex_state = 9},
  [1035] = {.lex_state = 9},
  [1036] = {.lex_state = 9},
  [1037] = {.lex_state = 9},
  [1038] = {.lex_state = 9},
  [1039] = {.lex_state = 9},
  [1040] = {.lex_state = 9},
  [1041] = {.lex_state = 9},
  [1042] = {.lex_state = 9},
  [1043] = {.lex_state = 9},
  [1044] = {.lex_state = 9},
  [1045] = {.lex_state = 9},
  [1046] = {.lex_state = 9},
  [1047] = {.lex_state = 9},
  [1048] = {.lex_state = 9},
  [1049] = {.lex_state = 9},
  [1050] = {.lex_state = 9},
  [1051] = {.lex_state = 9},
  [1052] = {.lex_state = 9},
  [1053] = {.lex_state = 9},
  [1054] = {.lex_state = 9},
  [1055] = {.lex_state = 9},
  [1056] = {.lex_state = 9},
  [1057] = {.lex_state = 9},
  [1058] = {.lex_state = 9},
  [1059] = {.lex_state = 9},
  [1060] = {.lex_state = 9},
  [1061] = {.lex_state = 9},
  [1062] = {.lex_state = 9},
  [1063] = {.lex_state = 9},
  [1064] = {.lex_state = 9},
  [1065] = {.lex_state = 9},
  [1066] = {.lex_state = 9},
  [1067] = {.lex_state = 9},
  [1068] = {.lex_state = 9},
  [1069] = {.lex_state = 9},
  [1070] = {.lex_state = 9},
  [1071] = {.lex_state = 9},
  [1072] = {.lex_state = 9},
  [1073] = {.lex_state = 9},
  [1074] = {.lex_state = 9},
  [1075] = {.lex_state = 9},
  [1076] = {.lex_state = 9},
  [1077] = {.lex_state = 9},
  [1078] = {.lex_state = 9},
  [1079] = {.lex_state = 9},
  [1080] = {.lex_state = 9},
  [1081] = {.lex_state = 9},
  [1082] = {.lex_state = 9},
  [1083] = {.lex_state = 9},
  [1084] = {.lex_state = 9},
  [1085] = {.lex_state = 9},
  [1086] = {.lex_state = 9},
  [1087] = {.lex_state = 9},
  [1088] = {.lex_state = 9},
  [1089] = {.lex_state = 9},
  [1090] = {.lex_state = 9},
  [1091] = {.lex_state = 9},
  [1092] = {.lex_state = 9},
  [1093] = {.lex_state = 9},
  [1094] = {.lex_state = 9},
  [1095] = {.lex_state = 9},
  [1096] = {.lex_state = 9},
  [1097] = {.lex_state = 9},
  [1098] = {.lex_state = 9},
  [1099] = {.lex_state = 9},
  [1100] = {.lex_state = 9},
  [1101] = {.lex_state = 9},
  [1102] = {.lex_state = 9},
  [1103] = {.lex_state = 9},
  [1104] = {.lex_state = 9},
  [1105] = {.lex_state = 9},
  [1106] = {.lex_state = 9},
  [1107] = {.lex_state = 9},
  [1108] = {.lex_state = 9},
  [1109] = {.lex_state = 9},
  [1110] = {.lex_state = 9},
  [1111] = {.lex_state = 9},
  [1112] = {.lex_state = 9},
  [1113] = {.lex_state = 9},
  [1114] = {.lex_state = 9},
  [1115] = {.lex_state = 9},
  [1116] = {.lex_state = 9},
  [1117] = {.lex_state = 9},
  [1118] = {.lex_state = 9},
  [1119] = {.lex_state = 9},
  [1120] = {.lex_state = 9},
  [1121] = {.lex_state = 9},
  [1122] = {.lex_state = 9},
  [1123] = {.lex_state = 9},
  [1124] = {.lex_state = 9},
  [1125] = {.lex_state = 9},
  [1126] = {.lex_state = 9},
  [1127] = {.lex_state = 9},
  [1128] = {.lex_state = 9},
  [1129] = {.lex_state = 9},
  [1130] = {.lex_state = 9},
  [1131] = {.lex_state = 9},
  [1132] = {.lex_state = 11},
  [1133] = {.lex_state = 11},
  [1134] = {.lex_state = 16},
  [1135] = {.lex_state = 11},
  [1136] = {.lex_state = 11},
  [1137] = {.lex_state = 11},
  [1138] = {.lex_state = 11},
  [1139] = {.lex_state = 11},
  [1140] = {.lex_state = 11},
  [1141] = {.lex_state = 11},
  [1142] = {.lex_state = 11},
  [1143] = {.lex_state = 11},
  [1144] = {.lex_state = 11},
  [1145] = {.lex_state = 11},
  [1146] = {.lex_state = 11},
  [1147] = {.lex_state = 11},
  [1148] = {.lex_state = 11},
  [1149] = {.lex_state = 11},
  [1150] = {.lex_state = 11},
  [1151] = {.lex_state = 11},
  [1152] = {.lex_state = 11},
  [1153] = {.lex_state = 11},
  [1154] = {.lex_state = 11},
  [1155] = {.lex_state = 11},
  [1156] = {.lex_state = 11},
  [1157] = {.lex_state = 11},
  [1158] = {.lex_state = 11},
  [1159] = {.lex_state = 11},
  [1160] = {.lex_state = 11},
  [1161] = {.lex_state = 11},
  [1162] = {.lex_state = 11},
  [1163] = {.lex_state = 11},
  [1164] = {.lex_state = 11},
  [1165] = {.lex_state = 11},
  [1166] = {.lex_state = 11},
  [1167] = {.lex_state = 11},
  [1168] = {.lex_state = 11},
  [1169] = {.lex_state = 11},
  [1170] = {.lex_state = 11},
  [1171] = {.lex_state = 11},
  [1172] = {.lex_state = 11},
  [1173] = {.lex_state = 11},
  [1174] = {.lex_state = 11},
  [1175] = {.lex_state = 11},
  [1176] = {.lex_state = 11},
  [1177] = {.lex_state = 11},
  [1178] = {.lex_state = 11},
  [1179] = {.lex_state = 11},
  [1180] = {.lex_state = 11},
  [1181] = {.lex_state = 11},
  [1182] = {.lex_state = 11},
  [1183] = {.lex_state = 11},
  [1184] = {.lex_state = 11},
  [1185] = {.lex_state = 11},
  [1186] = {.lex_state = 11},
  [1187] = {.lex_state = 11},
  [1188] = {.lex_state = 11},
  [1189] = {.lex_state = 11},
  [1190] = {.lex_state = 11},
  [1191] = {.lex_state = 11},
  [1192] = {.lex_state = 11},
  [1193] = {.lex_state = 11},
  [1194] = {.lex_state = 11},
  [1195] = {.lex_state = 11},
  [1196] = {.lex_state = 11},
  [1197] = {.lex_state = 11},
  [1198] = {.lex_state = 11},
  [1199] = {.lex_state = 11},
  [1200] = {.lex_state = 11},
  [1201] = {.lex_state = 11},
  [1202] = {.lex_state = 11},
  [1203] = {.lex_state = 11},
  [1204] = {.lex_state = 11},
  [1205] = {.lex_state = 11},
  [1206] = {.lex_state = 11},
  [1207] = {.lex_state = 11},
  [1208] = {.lex_state = 11},
  [1209] = {.lex_state = 11},
  [1210] = {.lex_state = 11},
  [1211] = {.lex_state = 11},
  [1212] = {.lex_state = 11},
  [1213] = {.lex_state = 11},
  [1214] = {.lex_state = 11},
  [1215] = {.lex_state = 11},
  [1216] = {.lex_state = 11},
  [1217] = {.lex_state = 11},
  [1218] = {.lex_state = 11},
  [1219] = {.lex_state = 11},
  [1220] = {.lex_state = 11},
  [1221] = {.lex_state = 11},
  [1222] = {.lex_state = 11},
  [1223] = {.lex_state = 11},
  [1224] = {.lex_state = 11},
  [1225] = {.lex_state = 11},
  [1226] = {.lex_state = 11},
  [1227] = {.lex_state = 11},
  [1228] = {.lex_state = 11},
  [1229] = {.lex_state = 11},
  [1230] = {.lex_state = 11},
  [1231] = {.lex_state = 11},
  [1232] = {.lex_state = 11},
  [1233] = {.lex_state = 11},
  [1234] = {.lex_state = 11},
  [1235] = {.lex_state = 11},
  [1236] = {.lex_state = 11},
  [1237] = {.lex_state = 11},
  [1238] = {.lex_state = 11},
  [1239] = {.lex_state = 11},
  [1240] = {.lex_state = 11},
  [1241] = {.lex_state = 11},
  [1242] = {.lex_state = 11},
  [1243] = {.lex_state = 11},
  [1244] = {.lex_state = 11},
  [1245] = {.lex_state = 11},
  [1246] = {.lex_state = 11},
  [1247] = {.lex_state = 11},
  [1248] = {.lex_state = 11},
  [1249] = {.lex_state = 11},
  [1250] = {.lex_state = 11},
  [1251] = {.lex_state = 11},
  [1252] = {.lex_state = 11},
  [1253] = {.lex_state = 11},
  [1254] = {.lex_state = 11},
  [1255] = {.lex_state = 22},
  [1256] = {.lex_state = 22},
  [1257] = {.lex_state = 22},
  [1258] = {.lex_state = 22},
  [1259] = {.lex_state = 22},
  [1260] = {.lex_state = 22},
  [1261] = {.lex_state = 22},
  [1262] = {.lex_state = 22},
  [1263] = {.lex_state = 22},
  [1264] = {.lex_state = 22},
  [1265] = {.lex_state = 22},
  [1266] = {.lex_state = 22},
  [1267] = {.lex_state = 22},
  [1268] = {.lex_state = 22},
  [1269] = {.lex_state = 22},
  [1270] = {.lex_state = 22},
  [1271] = {.lex_state = 22},
  [1272] = {.lex_state = 22},
  [1273] = {.lex_state = 22},
  [1274] = {.lex_state = 22},
  [1275] = {.lex_state = 22},
  [1276] = {.lex_state = 22},
  [1277] = {.lex_state = 22},
  [1278] = {.lex_state = 22},
  [1279] = {.lex_state = 22},
  [1280] = {.lex_state = 22},
  [1281] = {.lex_state = 22},
  [1282] = {.lex_state = 22},
  [1283] = {.lex_state = 15},
  [1284] = {.lex_state = 25},
  [1285] = {.lex_state = 25},
  [1286] = {.lex_state = 16},
  [1287] = {.lex_state = 16},
  [1288] = {.lex_state = 16},
  [1289] = {.lex_state = 16},
  [1290] = {.lex_state = 16},
  [1291] = {.lex_state = 16},
  [1292] = {.lex_state = 25},
  [1293] = {.lex_state = 16},
  [1294] = {.lex_state = 16},
  [1295] = {.lex_state = 16},
  [1296] = {.lex_state = 16},
  [1297] = {.lex_state = 16},
  [1298] = {.lex_state = 16},
  [1299] = {.lex_state = 16},
  [1300] = {.lex_state = 16},
  [1301] = {.lex_state = 16},
  [1302] = {.lex_state = 16},
  [1303] = {.lex_state = 16},
  [1304] = {.lex_state = 16},
  [1305] = {.lex_state = 16},
  [1306] = {.lex_state = 16},
  [1307] = {.lex_state = 16},
  [1308] = {.lex_state = 16},
  [1309] = {.lex_state = 16},
  [1310] = {.lex_state = 16},
  [1311] = {.lex_state = 16},
  [1312] = {.lex_state = 16},
  [1313] = {.lex_state = 16},
  [1314] = {.lex_state = 16},
  [1315] = {.lex_state = 16},
  [1316] = {.lex_state = 16},
  [1317] = {.lex_state = 16},
  [1318] = {.lex_state = 16},
  [1319] = {.lex_state = 16},
  [1320] = {.lex_state = 16},
  [1321] = {.lex_state = 16},
  [1322] = {.lex_state = 16},
  [1323] = {.lex_state = 16},
  [1324] = {.lex_state = 16},
  [1325] = {.lex_state = 16},
  [1326] = {.lex_state = 16},
  [1327] = {.lex_state = 16},
  [1328] = {.lex_state = 16},
  [1329] = {.lex_state = 16},
  [1330] = {.lex_state = 16},
  [1331] = {.lex_state = 16},
  [1332] = {.lex_state = 16},
  [1333] = {.lex_state = 16},
  [1334] = {.lex_state = 16},
  [1335] = {.lex_state = 16},
  [1336] = {.lex_state = 16},
  [1337] = {.lex_state = 16},
  [1338] = {.lex_state = 16},
  [1339] = {.lex_state = 16},
  [1340] = {.lex_state = 16},
  [1341] = {.lex_state = 16},
  [1342] = {.lex_state = 16},
  [1343] = {.lex_state = 16},
  [1344] = {.lex_state = 16},
  [1345] = {.lex_state = 16},
  [1346] = {.lex_state = 16},
  [1347] = {.lex_state = 16},
  [1348] = {.lex_state = 16},
  [1349] = {.lex_state = 16},
  [1350] = {.lex_state = 16},
  [1351] = {.lex_state = 25},
  [1352] = {.lex_state = 16},
  [1353] = {.lex_state = 16},
  [1354] = {.lex_state = 16},
  [1355] = {.lex_state = 16},
  [1356] = {.lex_state = 16},
  [1357] = {.lex_state = 16},
  [1358] = {.lex_state = 16},
  [1359] = {.lex_state = 16},
  [1360] = {.lex_state = 16},
  [1361] = {.lex_state = 16},
  [1362] = {.lex_state = 16},
  [1363] = {.lex_state = 16},
  [1364] = {.lex_state = 16},
  [1365] = {.lex_state = 16},
  [1366] = {.lex_state = 16},
  [1367] = {.lex_state = 16},
  [1368] = {.lex_state = 16},
  [1369] = {.lex_state = 16},
  [1370] = {.lex_state = 16},
  [1371] = {.lex_state = 16},
  [1372] = {.lex_state = 16},
  [1373] = {.lex_state = 16},
  [1374] = {.lex_state = 16},
  [1375] = {.lex_state = 16},
  [1376] = {.lex_state = 16},
  [1377] = {.lex_state = 16},
  [1378] = {.lex_state = 16},
  [1379] = {.lex_state = 16},
  [1380] = {.lex_state = 16},
  [1381] = {.lex_state = 16},
  [1382] = {.lex_state = 16},
  [1383] = {.lex_state = 16},
  [1384] = {.lex_state = 16},
  [1385] = {.lex_state = 16},
  [1386] = {.lex_state = 16},
  [1387] = {.lex_state = 16},
  [1388] = {.lex_state = 16},
  [1389] = {.lex_state = 16},
  [1390] = {.lex_state = 16},
  [1391] = {.lex_state = 16},
  [1392] = {.lex_state = 16},
  [1393] = {.lex_state = 16},
  [1394] = {.lex_state = 16},
  [1395] = {.lex_state = 25},
  [1396] = {.lex_state = 16},
  [1397] = {.lex_state = 16},
  [1398] = {.lex_state = 16},
  [1399] = {.lex_state = 16},
  [1400] = {.lex_state = 16},
  [1401] = {.lex_state = 16},
  [1402] = {.lex_state = 25},
  [1403] = {.lex_state = 25},
  [1404] = {.lex_state = 16},
  [1405] = {.lex_state = 16},
  [1406] = {.lex_state = 16},
  [1407] = {.lex_state = 16},
  [1408] = {.lex_state = 16},
  [1409] = {.lex_state = 25},
  [1410] = {.lex_state = 25},
  [1411] = {.lex_state = 16},
  [1412] = {.lex_state = 16},
  [1413] = {.lex_state = 16},
  [1414] = {.lex_state = 25},
  [1415] = {.lex_state = 25},
  [1416] = {.lex_state = 25},
  [1417] = {.lex_state = 25},
  [1418] = {.lex_state = 25},
  [1419] = {.lex_state = 25},
  [1420] = {.lex_state = 25},
  [1421] = {.lex_state = 25},
  [1422] = {.lex_state = 25},
  [1423] = {.lex_state = 25},
  [1424] = {.lex_state = 25},
  [1425] = {.lex_state = 25},
  [1426] = {.lex_state = 25},
  [1427] = {.lex_state = 25},
  [1428] = {.lex_state = 25},
  [1429] = {.lex_state = 25},
  [1430] = {.lex_state = 25},
  [1431] = {.lex_state = 25},
  [1432] = {.lex_state = 25},
  [1433] = {.lex_state = 25},
  [1434] = {.lex_state = 25},
  [1435] = {.lex_state = 25},
  [1436] = {.lex_state = 25},
  [1437] = {.lex_state = 25},
  [1438] = {.lex_state = 25},
  [1439] = {.lex_state = 25},
  [1440] = {.lex_state = 25},
  [1441] = {.lex_state = 25},
  [1442] = {.lex_state = 25},
  [1443] = {.lex_state = 25},
  [1444] = {.lex_state = 25},
  [1445] = {.lex_state = 25},
  [1446] = {.lex_state = 25},
  [1447] = {.lex_state = 25},
  [1448] = {.lex_state = 25},
  [1449] = {.lex_state = 25},
  [1450] = {.lex_state = 25},
  [1451] = {.lex_state = 25},
  [1452] = {.lex_state = 25},
  [1453] = {.lex_state = 25},
  [1454] = {.lex_state = 25},
  [1455] = {.lex_state = 25},
  [1456] = {.lex_state = 25},
  [1457] = {.lex_state = 25},
  [1458] = {.lex_state = 25},
  [1459] = {.lex_state = 25},
  [1460] = {.lex_state = 25},
  [1461] = {.lex_state = 25},
  [1462] = {.lex_state = 25},
  [1463] = {.lex_state = 25},
  [1464] = {.lex_state = 25},
  [1465] = {.lex_state = 25},
  [1466] = {.lex_state = 25},
  [1467] = {.lex_state = 25},
  [1468] = {.lex_state = 25},
  [1469] = {.lex_state = 25},
  [1470] = {.lex_state = 25},
  [1471] = {.lex_state = 25},
  [1472] = {.lex_state = 25},
  [1473] = {.lex_state = 25},
  [1474] = {.lex_state = 25},
  [1475] = {.lex_state = 25},
  [1476] = {.lex_state = 25},
  [1477] = {.lex_state = 25},
  [1478] = {.lex_state = 25},
  [1479] = {.lex_state = 25},
  [1480] = {.lex_state = 25},
  [1481] = {.lex_state = 25},
  [1482] = {.lex_state = 25},
  [1483] = {.lex_state = 25},
  [1484] = {.lex_state = 25},
  [1485] = {.lex_state = 25},
  [1486] = {.lex_state = 16},
  [1487] = {.lex_state = 22},
  [1488] = {.lex_state = 22},
  [1489] = {.lex_state = 22},
  [1490] = {.lex_state = 22},
  [1491] = {.lex_state = 22},
  [1492] = {.lex_state = 22},
  [1493] = {.lex_state = 22},
  [1494] = {.lex_state = 22},
  [1495] = {.lex_state = 22},
  [1496] = {.lex_state = 22},
  [1497] = {.lex_state = 22},
  [1498] = {.lex_state = 22},
  [1499] = {.lex_state = 22},
  [1500] = {.lex_state = 22},
  [1501] = {.lex_state = 22},
  [1502] = {.lex_state = 22},
  [1503] = {.lex_state = 22},
  [1504] = {.lex_state = 22},
  [1505] = {.lex_state = 22},
  [1506] = {.lex_state = 22},
  [1507] = {.lex_state = 22},
  [1508] = {.lex_state = 22},
  [1509] = {.lex_state = 22},
  [1510] = {.lex_state = 22},
  [1511] = {.lex_state = 22},
  [1512] = {.lex_state = 22},
  [1513] = {.lex_state = 22},
  [1514] = {.lex_state = 22},
  [1515] = {.lex_state = 22},
  [1516] = {.lex_state = 22},
  [1517] = {.lex_state = 22},
  [1518] = {.lex_state = 22},
  [1519] = {.lex_state = 22},
  [1520] = {.lex_state = 22},
  [1521] = {.lex_state = 22},
  [1522] = {.lex_state = 22},
  [1523] = {.lex_state = 22},
  [1524] = {.lex_state = 22},
  [1525] = {.lex_state = 22},
  [1526] = {.lex_state = 22},
  [1527] = {.lex_state = 22},
  [1528] = {.lex_state = 22},
  [1529] = {.lex_state = 22},
  [1530] = {.lex_state = 22},
  [1531] = {.lex_state = 22},
  [1532] = {.lex_state = 22},
  [1533] = {.lex_state = 22},
  [1534] = {.lex_state = 22},
  [1535] = {.lex_state = 22},
  [1536] = {.lex_state = 22},
  [1537] = {.lex_state = 22},
  [1538] = {.lex_state = 22},
  [1539] = {.lex_state = 22},
  [1540] = {.lex_state = 22},
  [1541] = {.lex_state = 22},
  [1542] = {.lex_state = 22},
  [1543] = {.lex_state = 22},
  [1544] = {.lex_state = 22},
  [1545] = {.lex_state = 22},
  [1546] = {.lex_state = 22},
  [1547] = {.lex_state = 22},
  [1548] = {.lex_state = 22},
  [1549] = {.lex_state = 22},
  [1550] = {.lex_state = 22},
  [1551] = {.lex_state = 22},
  [1552] = {.lex_state = 22},
  [1553] = {.lex_state = 22},
  [1554] = {.lex_state = 22},
  [1555] = {.lex_state = 22},
  [1556] = {.lex_state = 22},
  [1557] = {.lex_state = 22},
  [1558] = {.lex_state = 22},
  [1559] = {.lex_state = 22},
  [1560] = {.lex_state = 22},
  [1561] = {.lex_state = 22},
  [1562] = {.lex_state = 22},
  [1563] = {.lex_state = 22},
  [1564] = {.lex_state = 22},
  [1565] = {.lex_state = 22},
  [1566] = {.lex_state = 22},
  [1567] = {.lex_state = 22},
  [1568] = {.lex_state = 22},
  [1569] = {.lex_state = 22},
  [1570] = {.lex_state = 22},
  [1571] = {.lex_state = 22},
  [1572] = {.lex_state = 22},
  [1573] = {.lex_state = 22},
  [1574] = {.lex_state = 22},
  [1575] = {.lex_state = 22},
  [1576] = {.lex_state = 22},
  [1577] = {.lex_state = 22},
  [1578] = {.lex_state = 22},
  [1579] = {.lex_state = 22},
  [1580] = {.lex_state = 22},
  [1581] = {.lex_state = 22},
  [1582] = {.lex_state = 22},
  [1583] = {.lex_state = 22},
  [1584] = {.lex_state = 22},
  [1585] = {.lex_state = 22},
  [1586] = {.lex_state = 22},
  [1587] = {.lex_state = 22},
  [1588] = {.lex_state = 22},
  [1589] = {.lex_state = 22},
  [1590] = {.lex_state = 22},
  [1591] = {.lex_state = 22},
  [1592] = {.lex_state = 22},
  [1593] = {.lex_state = 22},
  [1594] = {.lex_state = 22},
  [1595] = {.lex_state = 22},
  [1596] = {.lex_state = 22},
  [1597] = {.lex_state = 22},
  [1598] = {.lex_state = 22},
  [1599] = {.lex_state = 22},
  [1600] = {.lex_state = 22},
  [1601] = {.lex_state = 22},
  [1602] = {.lex_state = 22},
  [1603] = {.lex_state = 22},
  [1604] = {.lex_state = 22},
  [1605] = {.lex_state = 22},
  [1606] = {.lex_state = 22},
  [1607] = {.lex_state = 22},
  [1608] = {.lex_state = 22},
  [1609] = {.lex_state = 22},
  [1610] = {.lex_state = 22},
  [1611] = {.lex_state = 22},
  [1612] = {.lex_state = 22},
  [1613] = {.lex_state = 14},
  [1614] = {.lex_state = 14},
  [1615] = {.lex_state = 14},
  [1616] = {.lex_state = 14},
  [1617] = {.lex_state = 14},
  [1618] = {.lex_state = 14},
  [1619] = {.lex_state = 14},
  [1620] = {.lex_state = 14},
  [1621] = {.lex_state = 14},
  [1622] = {.lex_state = 14},
  [1623] = {.lex_state = 13},
  [1624] = {.lex_state = 14},
  [1625] = {.lex_state = 14},
  [1626] = {.lex_state = 14},
  [1627] = {.lex_state = 14},
  [1628] = {.lex_state = 14},
  [1629] = {.lex_state = 14},
  [1630] = {.lex_state = 14},
  [1631] = {.lex_state = 14},
  [1632] = {.lex_state = 14},
  [1633] = {.lex_state = 14},
  [1634] = {.lex_state = 14},
  [1635] = {.lex_state = 14},
  [1636] = {.lex_state = 14},
  [1637] = {.lex_state = 14},
  [1638] = {.lex_state = 14},
  [1639] = {.lex_state = 14},
  [1640] = {.lex_state = 14},
  [1641] = {.lex_state = 14},
  [1642] = {.lex_state = 14},
  [1643] = {.lex_state = 14},
  [1644] = {.lex_state = 14},
  [1645] = {.lex_state = 14},
  [1646] = {.lex_state = 14},
  [1647] = {.lex_state = 14},
  [1648] = {.lex_state = 14},
  [1649] = {.lex_state = 14},
  [1650] = {.lex_state = 14},
  [1651] = {.lex_state = 14},
  [1652] = {.lex_state = 14},
  [1653] = {.lex_state = 14},
  [1654] = {.lex_state = 14},
  [1655] = {.lex_state = 14},
  [1656] = {.lex_state = 14},
  [1657] = {.lex_state = 14},
  [1658] = {.lex_state = 14},
  [1659] = {.lex_state = 14},
  [1660] = {.lex_state = 14},
  [1661] = {.lex_state = 14},
  [1662] = {.lex_state = 14},
  [1663] = {.lex_state = 14},
  [1664] = {.lex_state = 14},
  [1665] = {.lex_state = 14},
  [1666] = {.lex_state = 14},
  [1667] = {.lex_state = 14},
  [1668] = {.lex_state = 14},
  [1669] = {.lex_state = 14},
  [1670] = {.lex_state = 14},
  [1671] = {.lex_state = 14},
  [1672] = {.lex_state = 14},
  [1673] = {.lex_state = 14},
  [1674] = {.lex_state = 14},
  [1675] = {.lex_state = 14},
  [1676] = {.lex_state = 14},
  [1677] = {.lex_state = 14},
  [1678] = {.lex_state = 14},
  [1679] = {.lex_state = 14},
  [1680] = {.lex_state = 14},
  [1681] = {.lex_state = 14},
  [1682] = {.lex_state = 14},
  [1683] = {.lex_state = 14},
  [1684] = {.lex_state = 14},
  [1685] = {.lex_state = 14},
  [1686] = {.lex_state = 14},
  [1687] = {.lex_state = 14},
  [1688] = {.lex_state = 14},
  [1689] = {.lex_state = 14},
  [1690] = {.lex_state = 14},
  [1691] = {.lex_state = 14},
  [1692] = {.lex_state = 14},
  [1693] = {.lex_state = 14},
  [1694] = {.lex_state = 14},
  [1695] = {.lex_state = 14},
  [1696] = {.lex_state = 14},
  [1697] = {.lex_state = 14},
  [1698] = {.lex_state = 14},
  [1699] = {.lex_state = 14},
  [1700] = {.lex_state = 14},
  [1701] = {.lex_state = 14},
  [1702] = {.lex_state = 14},
  [1703] = {.lex_state = 14},
  [1704] = {.lex_state = 14},
  [1705] = {.lex_state = 14},
  [1706] = {.lex_state = 14},
  [1707] = {.lex_state = 14},
  [1708] = {.lex_state = 14},
  [1709] = {.lex_state = 14},
  [1710] = {.lex_state = 14},
  [1711] = {.lex_state = 14},
  [1712] = {.lex_state = 14},
  [1713] = {.lex_state = 14},
  [1714] = {.lex_state = 14},
  [1715] = {.lex_state = 14},
  [1716] = {.lex_state = 14},
  [1717] = {.lex_state = 14},
  [1718] = {.lex_state = 14},
  [1719] = {.lex_state = 14},
  [1720] = {.lex_state = 14},
  [1721] = {.lex_state = 14},
  [1722] = {.lex_state = 14},
  [1723] = {.lex_state = 14},
  [1724] = {.lex_state = 14},
  [1725] = {.lex_state = 14},
  [1726] = {.lex_state = 14},
  [1727] = {.lex_state = 14},
  [1728] = {.lex_state = 14},
  [1729] = {.lex_state = 14},
  [1730] = {.lex_state = 14},
  [1731] = {.lex_state = 14},
  [1732] = {.lex_state = 14},
  [1733] = {.lex_state = 14},
  [1734] = {.lex_state = 14},
  [1735] = {.lex_state = 14},
  [1736] = {.lex_state = 14},
  [1737] = {.lex_state = 14},
  [1738] = {.lex_state = 14},
  [1739] = {.lex_state = 14},
  [1740] = {.lex_state = 14},
  [1741] = {.lex_state = 14},
  [1742] = {.lex_state = 14},
  [1743] = {.lex_state = 14},
  [1744] = {.lex_state = 14},
  [1745] = {.lex_state = 14},
  [1746] = {.lex_state = 1},
  [1747] = {.lex_state = 1},
  [1748] = {.lex_state = 1},
  [1749] = {.lex_state = 1},
  [1750] = {.lex_state = 1},
  [1751] = {.lex_state = 1},
  [1752] = {.lex_state = 1},
  [1753] = {.lex_state = 1},
  [1754] = {.lex_state = 1},
  [1755] = {.lex_state = 1},
  [1756] = {.lex_state = 1},
  [1757] = {.lex_state = 1},
  [1758] = {.lex_state = 1},
  [1759] = {.lex_state = 1},
  [1760] = {.lex_state = 1},
  [1761] = {.lex_state = 1},
  [1762] = {.lex_state = 1},
  [1763] = {.lex_state = 1},
  [1764] = {.lex_state = 1},
  [1765] = {.lex_state = 1},
  [1766] = {.lex_state = 1},
  [1767] = {.lex_state = 247},
  [1768] = {.lex_state = 247},
  [1769] = {.lex_state = 247},
  [1770] = {.lex_state = 247},
  [1771] = {.lex_state = 247},
  [1772] = {.lex_state = 247},
  [1773] = {.lex_state = 247},
  [1774] = {.lex_state = 247},
  [1775] = {.lex_state = 247},
  [1776] = {.lex_state = 247},
  [1777] = {.lex_state = 247},
  [1778] = {.lex_state = 247},
  [1779] = {.lex_state = 247},
  [1780] = {.lex_state = 247},
  [1781] = {.lex_state = 247},
  [1782] = {.lex_state = 247},
  [1783] = {.lex_state = 247},
  [1784] = {.lex_state = 247},
  [1785] = {.lex_state = 247},
  [1786] = {.lex_state = 247},
  [1787] = {.lex_state = 247},
  [1788] = {.lex_state = 247},
  [1789] = {.lex_state = 247},
  [1790] = {.lex_state = 247},
  [1791] = {.lex_state = 247},
  [1792] = {.lex_state = 247},
  [1793] = {.lex_state = 247},
  [1794] = {.lex_state = 247},
  [1795] = {.lex_state = 247},
  [1796] = {.lex_state = 247},
  [1797] = {.lex_state = 247},
  [1798] = {.lex_state = 247},
  [1799] = {.lex_state = 247},
  [1800] = {.lex_state = 247},
  [1801] = {.lex_state = 247},
  [1802] = {.lex_state = 247},
  [1803] = {.lex_state = 247},
  [1804] = {.lex_state = 247},
  [1805] = {.lex_state = 247},
  [1806] = {.lex_state = 247},
  [1807] = {.lex_state = 247},
  [1808] = {.lex_state = 247},
  [1809] = {.lex_state = 247},
  [1810] = {.lex_state = 247},
  [1811] = {.lex_state = 247},
  [1812] = {.lex_state = 247},
  [1813] = {.lex_state = 247},
  [1814] = {.lex_state = 247},
  [1815] = {.lex_state = 247},
  [1816] = {.lex_state = 247},
  [1817] = {.lex_state = 247},
  [1818] = {.lex_state = 247},
  [1819] = {.lex_state = 247},
  [1820] = {.lex_state = 247},
  [1821] = {.lex_state = 247},
  [1822] = {.lex_state = 247},
  [1823] = {.lex_state = 247},
  [1824] = {.lex_state = 247},
  [1825] = {.lex_state = 247},
  [1826] = {.lex_state = 247},
  [1827] = {.lex_state = 247},
  [1828] = {.lex_state = 247},
  [1829] = {.lex_state = 247},
  [1830] = {.lex_state = 247},
  [1831] = {.lex_state = 247},
  [1832] = {.lex_state = 247},
  [1833] = {.lex_state = 247},
  [1834] = {.lex_state = 247},
  [1835] = {.lex_state = 247},
  [1836] = {.lex_state = 247},
  [1837] = {.lex_state = 247},
  [1838] = {.lex_state = 247},
  [1839] = {.lex_state = 247},
  [1840] = {.lex_state = 247},
  [1841] = {.lex_state = 247},
  [1842] = {.lex_state = 247},
  [1843] = {.lex_state = 247},
  [1844] = {.lex_state = 247},
  [1845] = {.lex_state = 247},
  [1846] = {.lex_state = 247},
  [1847] = {.lex_state = 247},
  [1848] = {.lex_state = 247},
  [1849] = {.lex_state = 247},
  [1850] = {.lex_state = 247},
  [1851] = {.lex_state = 247},
  [1852] = {.lex_state = 247},
  [1853] = {.lex_state = 247},
  [1854] = {.lex_state = 247},
  [1855] = {.lex_state = 247},
  [1856] = {.lex_state = 247},
  [1857] = {.lex_state = 248},
  [1858] = {.lex_state = 247},
  [1859] = {.lex_state = 247},
  [1860] = {.lex_state = 247},
  [1861] = {.lex_state = 247},
  [1862] = {.lex_state = 247},
  [1863] = {.lex_state = 247},
  [1864] = {.lex_state = 247},
  [1865] = {.lex_state = 247},
  [1866] = {.lex_state = 247},
  [1867] = {.lex_state = 247},
  [1868] = {.lex_state = 247},
  [1869] = {.lex_state = 247},
  [1870] = {.lex_state = 247},
  [1871] = {.lex_state = 247},
  [1872] = {.lex_state = 247},
  [1873] = {.lex_state = 247},
  [1874] = {.lex_state = 247},
  [1875] = {.lex_state = 247},
  [1876] = {.lex_state = 247},
  [1877] = {.lex_state = 247},
  [1878] = {.lex_state = 247},
  [1879] = {.lex_state = 247},
  [1880] = {.lex_state = 247},
  [1881] = {.lex_state = 247},
  [1882] = {.lex_state = 247},
  [1883] = {.lex_state = 247},
  [1884] = {.lex_state = 247},
  [1885] = {.lex_state = 247},
  [1886] = {.lex_state = 247},
  [1887] = {.lex_state = 247},
  [1888] = {.lex_state = 247},
  [1889] = {.lex_state = 247},
  [1890] = {.lex_state = 28},
  [1891] = {.lex_state = 28},
  [1892] = {.lex_state = 28},
  [1893] = {.lex_state = 28},
  [1894] = {.lex_state = 28},
  [1895] = {.lex_state = 28},
  [1896] = {.lex_state = 28},
  [1897] = {.lex_state = 28},
  [1898] = {.lex_state = 28},
  [1899] = {.lex_state = 28},
  [1900] = {.lex_state = 28},
  [1901] = {.lex_state = 28},
  [1902] = {.lex_state = 28},
  [1903] = {.lex_state = 28},
  [1904] = {.lex_state = 28},
  [1905] = {.lex_state = 28},
  [1906] = {.lex_state = 28},
  [1907] = {.lex_state = 28},
  [1908] = {.lex_state = 28},
  [1909] = {.lex_state = 28},
  [1910] = {.lex_state = 28},
  [1911] = {.lex_state = 28},
  [1912] = {.lex_state = 28},
  [1913] = {.lex_state = 28},
  [1914] = {.lex_state = 28},
  [1915] = {.lex_state = 28},
  [1916] = {.lex_state = 28},
  [1917] = {.lex_state = 28},
  [1918] = {.lex_state = 28},
  [1919] = {.lex_state = 28},
  [1920] = {.lex_state = 28},
  [1921] = {.lex_state = 28},
  [1922] = {.lex_state = 28},
  [1923] = {.lex_state = 28},
  [1924] = {.lex_state = 28},
  [1925] = {.lex_state = 28},
  [1926] = {.lex_state = 28},
  [1927] = {.lex_state = 28},
  [1928] = {.lex_state = 28},
  [1929] = {.lex_state = 28},
  [1930] = {.lex_state = 28},
  [1931] = {.lex_state = 28},
  [1932] = {.lex_state = 28},
  [1933] = {.lex_state = 28},
  [1934] = {.lex_state = 28},
  [1935] = {.lex_state = 28},
  [1936] = {.lex_state = 28},
  [1937] = {.lex_state = 28},
  [1938] = {.lex_state = 28},
  [1939] = {.lex_state = 28},
  [1940] = {.lex_state = 28},
  [1941] = {.lex_state = 28},
  [1942] = {.lex_state = 28},
  [1943] = {.lex_state = 28},
  [1944] = {.lex_state = 28},
  [1945] = {.lex_state = 28},
  [1946] = {.lex_state = 28},
  [1947] = {.lex_state = 28},
  [1948] = {.lex_state = 28},
  [1949] = {.lex_state = 28},
  [1950] = {.lex_state = 28},
  [1951] = {.lex_state = 28},
  [1952] = {.lex_state = 28},
  [1953] = {.lex_state = 28},
  [1954] = {.lex_state = 28},
  [1955] = {.lex_state = 28},
  [1956] = {.lex_state = 28},
  [1957] = {.lex_state = 28},
  [1958] = {.lex_state = 28},
  [1959] = {.lex_state = 28},
  [1960] = {.lex_state = 28},
  [1961] = {.lex_state = 28},
  [1962] = {.lex_state = 28},
  [1963] = {.lex_state = 28},
  [1964] = {.lex_state = 28},
  [1965] = {.lex_state = 28},
  [1966] = {.lex_state = 28},
  [1967] = {.lex_state = 28},
  [1968] = {.lex_state = 28},
  [1969] = {.lex_state = 28},
  [1970] = {.lex_state = 28},
  [1971] = {.lex_state = 28},
  [1972] = {.lex_state = 28},
  [1973] = {.lex_state = 28},
  [1974] = {.lex_state = 247},
  [1975] = {.lex_state = 28},
  [1976] = {.lex_state = 28},
  [1977] = {.lex_state = 28},
  [1978] = {.lex_state = 247},
  [1979] = {.lex_state = 247},
  [1980] = {.lex_state = 247},
  [1981] = {.lex_state = 247},
  [1982] = {.lex_state = 247},
  [1983] = {.lex_state = 247},
  [1984] = {.lex_state = 247},
  [1985] = {.lex_state = 247},
  [1986] = {.lex_state = 247},
  [1987] = {.lex_state = 247},
  [1988] = {.lex_state = 247},
  [1989] = {.lex_state = 247},
  [1990] = {.lex_state = 247},
  [1991] = {.lex_state = 247},
  [1992] = {.lex_state = 247},
  [1993] = {.lex_state = 247},
  [1994] = {.lex_state = 247},
  [1995] = {.lex_state = 247},
  [1996] = {.lex_state = 247},
  [1997] = {.lex_state = 247},
  [1998] = {.lex_state = 247},
  [1999] = {.lex_state = 247},
  [2000] = {.lex_state = 247},
  [2001] = {.lex_state = 247},
  [2002] = {.lex_state = 247},
  [2003] = {.lex_state = 247},
  [2004] = {.lex_state = 247},
  [2005] = {.lex_state = 247},
  [2006] = {.lex_state = 247},
  [2007] = {.lex_state = 247},
  [2008] = {.lex_state = 247},
  [2009] = {.lex_state = 247},
  [2010] = {.lex_state = 247},
  [2011] = {.lex_state = 247},
  [2012] = {.lex_state = 247},
  [2013] = {.lex_state = 247},
  [2014] = {.lex_state = 247},
  [2015] = {.lex_state = 247},
  [2016] = {.lex_state = 247},
  [2017] = {.lex_state = 247},
  [2018] = {.lex_state = 247},
  [2019] = {.lex_state = 247},
  [2020] = {.lex_state = 247},
  [2021] = {.lex_state = 247},
  [2022] = {.lex_state = 247},
  [2023] = {.lex_state = 247},
  [2024] = {.lex_state = 1},
  [2025] = {.lex_state = 247},
  [2026] = {.lex_state = 247},
  [2027] = {.lex_state = 247},
  [2028] = {.lex_state = 247},
  [2029] = {.lex_state = 247},
  [2030] = {.lex_state = 247},
  [2031] = {.lex_state = 247},
  [2032] = {.lex_state = 247},
  [2033] = {.lex_state = 247},
  [2034] = {.lex_state = 247},
  [2035] = {.lex_state = 25},
  [2036] = {.lex_state = 25},
  [2037] = {.lex_state = 247},
  [2038] = {.lex_state = 247},
  [2039] = {.lex_state = 247},
  [2040] = {.lex_state = 247},
  [2041] = {.lex_state = 247},
  [2042] = {.lex_state = 247},
  [2043] = {.lex_state = 247},
  [2044] = {.lex_state = 247},
  [2045] = {.lex_state = 25},
  [2046] = {.lex_state = 25},
  [2047] = {.lex_state = 25},
  [2048] = {.lex_state = 25},
  [2049] = {.lex_state = 25},
  [2050] = {.lex_state = 25},
  [2051] = {.lex_state = 25},
  [2052] = {.lex_state = 25},
  [2053] = {.lex_state = 25},
  [2054] = {.lex_state = 25},
  [2055] = {.lex_state = 25},
  [2056] = {.lex_state = 25},
  [2057] = {.lex_state = 25},
  [2058] = {.lex_state = 25},
  [2059] = {.lex_state = 25},
  [2060] = {.lex_state = 25},
  [2061] = {.lex_state = 25},
  [2062] = {.lex_state = 25},
  [2063] = {.lex_state = 25},
  [2064] = {.lex_state = 25},
  [2065] = {.lex_state = 25},
  [2066] = {.lex_state = 25},
  [2067] = {.lex_state = 25},
  [2068] = {.lex_state = 25},
  [2069] = {.lex_state = 25},
  [2070] = {.lex_state = 25},
  [2071] = {.lex_state = 25},
  [2072] = {.lex_state = 25},
  [2073] = {.lex_state = 25},
  [2074] = {.lex_state = 25},
  [2075] = {.lex_state = 25},
  [2076] = {.lex_state = 25},
  [2077] = {.lex_state = 25},
  [2078] = {.lex_state = 25},
  [2079] = {.lex_state = 25},
  [2080] = {.lex_state = 25},
  [2081] = {.lex_state = 25},
  [2082] = {.lex_state = 25},
  [2083] = {.lex_state = 25},
  [2084] = {.lex_state = 25},
  [2085] = {.lex_state = 25},
  [2086] = {.lex_state = 25},
  [2087] = {.lex_state = 25},
  [2088] = {.lex_state = 25},
  [2089] = {.lex_state = 25},
  [2090] = {.lex_state = 25},
  [2091] = {.lex_state = 25},
  [2092] = {.lex_state = 25},
  [2093] = {.lex_state = 25},
  [2094] = {.lex_state = 25},
  [2095] = {.lex_state = 25},
  [2096] = {.lex_state = 25},
  [2097] = {.lex_state = 25},
  [2098] = {.lex_state = 25},
  [2099] = {.lex_state = 25},
  [2100] = {.lex_state = 25},
  [2101] = {.lex_state = 25},
  [2102] = {.lex_state = 25},
  [2103] = {.lex_state = 25},
  [2104] = {.lex_state = 25},
  [2105] = {.lex_state = 25},
  [2106] = {.lex_state = 25},
  [2107] = {.lex_state = 25},
  [2108] = {.lex_state = 25},
  [2109] = {.lex_state = 25},
  [2110] = {.lex_state = 25},
  [2111] = {.lex_state = 25},
  [2112] = {.lex_state = 25},
  [2113] = {.lex_state = 25},
  [2114] = {.lex_state = 25},
  [2115] = {.lex_state = 25},
  [2116] = {.lex_state = 25},
  [2117] = {.lex_state = 25},
  [2118] = {.lex_state = 25},
  [2119] = {.lex_state = 25},
  [2120] = {.lex_state = 25},
  [2121] = {.lex_state = 25},
  [2122] = {.lex_state = 25},
  [2123] = {.lex_state = 25},
  [2124] = {.lex_state = 25},
  [2125] = {.lex_state = 25},
  [2126] = {.lex_state = 25},
  [2127] = {.lex_state = 25},
  [2128] = {.lex_state = 25},
  [2129] = {.lex_state = 25},
  [2130] = {.lex_state = 25},
  [2131] = {.lex_state = 25},
  [2132] = {.lex_state = 25},
  [2133] = {.lex_state = 25},
  [2134] = {.lex_state = 25},
  [2135] = {.lex_state = 25},
  [2136] = {.lex_state = 25},
  [2137] = {.lex_state = 25},
  [2138] = {.lex_state = 25},
  [2139] = {.lex_state = 25},
  [2140] = {.lex_state = 25},
  [2141] = {.lex_state = 25},
  [2142] = {.lex_state = 25},
  [2143] = {.lex_state = 25},
  [2144] = {.lex_state = 25},
  [2145] = {.lex_state = 25},
  [2146] = {.lex_state = 25},
  [2147] = {.lex_state = 25},
  [2148] = {.lex_state = 25},
  [2149] = {.lex_state = 25},
  [2150] = {.lex_state = 25},
  [2151] = {.lex_state = 25},
  [2152] = {.lex_state = 25},
  [2153] = {.lex_state = 25},
  [2154] = {.lex_state = 25},
  [2155] = {.lex_state = 25},
  [2156] = {.lex_state = 25},
  [2157] = {.lex_state = 25},
  [2158] = {.lex_state = 25},
  [2159] = {.lex_state = 25},
  [2160] = {.lex_state = 25},
  [2161] = {.lex_state = 25},
  [2162] = {.lex_state = 25},
  [2163] = {.lex_state = 25},
  [2164] = {.lex_state = 25},
  [2165] = {.lex_state = 25},
  [2166] = {.lex_state = 25},
  [2167] = {.lex_state = 25},
  [2168] = {.lex_state = 25},
  [2169] = {.lex_state = 25},
  [2170] = {.lex_state = 25},
  [2171] = {.lex_state = 25},
  [2172] = {.lex_state = 25},
  [2173] = {.lex_state = 25},
  [2174] = {.lex_state = 25},
  [2175] = {.lex_state = 25},
  [2176] = {.lex_state = 25},
  [2177] = {.lex_state = 25},
  [2178] = {.lex_state = 25},
  [2179] = {.lex_state = 25},
  [2180] = {.lex_state = 25},
  [2181] = {.lex_state = 25},
  [2182] = {.lex_state = 25},
  [2183] = {.lex_state = 25},
  [2184] = {.lex_state = 25},
  [2185] = {.lex_state = 25},
  [2186] = {.lex_state = 25},
  [2187] = {.lex_state = 25},
  [2188] = {.lex_state = 25},
  [2189] = {.lex_state = 25},
  [2190] = {.lex_state = 25},
  [2191] = {.lex_state = 25},
  [2192] = {.lex_state = 25},
  [2193] = {.lex_state = 25},
  [2194] = {.lex_state = 25},
  [2195] = {.lex_state = 25},
  [2196] = {.lex_state = 25},
  [2197] = {.lex_state = 25},
  [2198] = {.lex_state = 25},
  [2199] = {.lex_state = 25},
  [2200] = {.lex_state = 25},
  [2201] = {.lex_state = 25},
  [2202] = {.lex_state = 25},
  [2203] = {.lex_state = 25},
  [2204] = {.lex_state = 25},
  [2205] = {.lex_state = 25},
  [2206] = {.lex_state = 25},
  [2207] = {.lex_state = 25},
  [2208] = {.lex_state = 25},
  [2209] = {.lex_state = 25},
  [2210] = {.lex_state = 25},
  [2211] = {.lex_state = 25},
  [2212] = {.lex_state = 25},
  [2213] = {.lex_state = 25},
  [2214] = {.lex_state = 25},
  [2215] = {.lex_state = 25},
  [2216] = {.lex_state = 25},
  [2217] = {.lex_state = 25},
  [2218] = {.lex_state = 25},
  [2219] = {.lex_state = 25},
  [2220] = {.lex_state = 25},
  [2221] = {.lex_state = 25},
  [2222] = {.lex_state = 25},
  [2223] = {.lex_state = 25},
  [2224] = {.lex_state = 25},
  [2225] = {.lex_state = 25},
  [2226] = {.lex_state = 25},
  [2227] = {.lex_state = 25},
  [2228] = {.lex_state = 25},
  [2229] = {.lex_state = 25},
  [2230] = {.lex_state = 25},
  [2231] = {.lex_state = 25},
  [2232] = {.lex_state = 25},
  [2233] = {.lex_state = 25},
  [2234] = {.lex_state = 25},
  [2235] = {.lex_state = 25},
  [2236] = {.lex_state = 25},
  [2237] = {.lex_state = 25},
  [2238] = {.lex_state = 25},
  [2239] = {.lex_state = 25},
  [2240] = {.lex_state = 25},
  [2241] = {.lex_state = 25},
  [2242] = {.lex_state = 25},
  [2243] = {.lex_state = 25},
  [2244] = {.lex_state = 25},
  [2245] = {.lex_state = 25},
  [2246] = {.lex_state = 25},
  [2247] = {.lex_state = 25},
  [2248] = {.lex_state = 25},
  [2249] = {.lex_state = 25},
  [2250] = {.lex_state = 25},
  [2251] = {.lex_state = 25},
  [2252] = {.lex_state = 25},
  [2253] = {.lex_state = 25},
  [2254] = {.lex_state = 25},
  [2255] = {.lex_state = 25},
  [2256] = {.lex_state = 25},
  [2257] = {.lex_state = 25},
  [2258] = {.lex_state = 25},
  [2259] = {.lex_state = 25},
  [2260] = {.lex_state = 25},
  [2261] = {.lex_state = 25},
  [2262] = {.lex_state = 25},
  [2263] = {.lex_state = 25},
  [2264] = {.lex_state = 25},
  [2265] = {.lex_state = 25},
  [2266] = {.lex_state = 25},
  [2267] = {.lex_state = 25},
  [2268] = {.lex_state = 25},
  [2269] = {.lex_state = 25},
  [2270] = {.lex_state = 25},
  [2271] = {.lex_state = 25},
  [2272] = {.lex_state = 25},
  [2273] = {.lex_state = 25},
  [2274] = {.lex_state = 25},
  [2275] = {.lex_state = 25},
  [2276] = {.lex_state = 25},
  [2277] = {.lex_state = 25},
  [2278] = {.lex_state = 25},
  [2279] = {.lex_state = 25},
  [2280] = {.lex_state = 25},
  [2281] = {.lex_state = 25},
  [2282] = {.lex_state = 25},
  [2283] = {.lex_state = 25},
  [2284] = {.lex_state = 25},
  [2285] = {.lex_state = 25},
  [2286] = {.lex_state = 25},
  [2287] = {.lex_state = 25},
  [2288] = {.lex_state = 25},
  [2289] = {.lex_state = 25},
  [2290] = {.lex_state = 25},
  [2291] = {.lex_state = 25},
  [2292] = {.lex_state = 25},
  [2293] = {.lex_state = 25},
  [2294] = {.lex_state = 25},
  [2295] = {.lex_state = 25},
  [2296] = {.lex_state = 25},
  [2297] = {.lex_state = 25},
  [2298] = {.lex_state = 25},
  [2299] = {.lex_state = 25},
  [2300] = {.lex_state = 25},
  [2301] = {.lex_state = 25},
  [2302] = {.lex_state = 25},
  [2303] = {.lex_state = 25},
  [2304] = {.lex_state = 25},
  [2305] = {.lex_state = 25},
  [2306] = {.lex_state = 25},
  [2307] = {.lex_state = 25},
  [2308] = {.lex_state = 25},
  [2309] = {.lex_state = 25},
  [2310] = {.lex_state = 25},
  [2311] = {.lex_state = 25},
  [2312] = {.lex_state = 25},
  [2313] = {.lex_state = 25},
  [2314] = {.lex_state = 25},
  [2315] = {.lex_state = 25},
  [2316] = {.lex_state = 25},
  [2317] = {.lex_state = 25},
  [2318] = {.lex_state = 25},
  [2319] = {.lex_state = 25},
  [2320] = {.lex_state = 25},
  [2321] = {.lex_state = 25},
  [2322] = {.lex_state = 25},
  [2323] = {.lex_state = 25},
  [2324] = {.lex_state = 25},
  [2325] = {.lex_state = 25},
  [2326] = {.lex_state = 25},
  [2327] = {.lex_state = 25},
  [2328] = {.lex_state = 25},
  [2329] = {.lex_state = 25},
  [2330] = {.lex_state = 25},
  [2331] = {.lex_state = 25},
  [2332] = {.lex_state = 25},
  [2333] = {.lex_state = 25},
  [2334] = {.lex_state = 25},
  [2335] = {.lex_state = 25},
  [2336] = {.lex_state = 25},
  [2337] = {.lex_state = 25},
  [2338] = {.lex_state = 25},
  [2339] = {.lex_state = 25},
  [2340] = {.lex_state = 25},
  [2341] = {.lex_state = 25},
  [2342] = {.lex_state = 25},
  [2343] = {.lex_state = 25},
  [2344] = {.lex_state = 25},
  [2345] = {.lex_state = 25},
  [2346] = {.lex_state = 25},
  [2347] = {.lex_state = 25},
  [2348] = {.lex_state = 25},
  [2349] = {.lex_state = 25},
  [2350] = {.lex_state = 25},
  [2351] = {.lex_state = 25},
  [2352] = {.lex_state = 25},
  [2353] = {.lex_state = 25},
  [2354] = {.lex_state = 25},
  [2355] = {.lex_state = 25},
  [2356] = {.lex_state = 25},
  [2357] = {.lex_state = 25},
  [2358] = {.lex_state = 25},
  [2359] = {.lex_state = 25},
  [2360] = {.lex_state = 25},
  [2361] = {.lex_state = 25},
  [2362] = {.lex_state = 25},
  [2363] = {.lex_state = 25},
  [2364] = {.lex_state = 25},
  [2365] = {.lex_state = 25},
  [2366] = {.lex_state = 25},
  [2367] = {.lex_state = 25},
  [2368] = {.lex_state = 25},
  [2369] = {.lex_state = 25},
  [2370] = {.lex_state = 25},
  [2371] = {.lex_state = 25},
  [2372] = {.lex_state = 25},
  [2373] = {.lex_state = 25},
  [2374] = {.lex_state = 25},
  [2375] = {.lex_state = 25},
  [2376] = {.lex_state = 25},
  [2377] = {.lex_state = 25},
  [2378] = {.lex_state = 25},
  [2379] = {.lex_state = 25},
  [2380] = {.lex_state = 25},
  [2381] = {.lex_state = 25},
  [2382] = {.lex_state = 25},
  [2383] = {.lex_state = 25},
  [2384] = {.lex_state = 25},
  [2385] = {.lex_state = 25},
  [2386] = {.lex_state = 25},
  [2387] = {.lex_state = 25},
  [2388] = {.lex_state = 25},
  [2389] = {.lex_state = 25},
  [2390] = {.lex_state = 25},
  [2391] = {.lex_state = 25},
  [2392] = {.lex_state = 25},
  [2393] = {.lex_state = 25},
  [2394] = {.lex_state = 25},
  [2395] = {.lex_state = 25},
  [2396] = {.lex_state = 25},
  [2397] = {.lex_state = 25},
  [2398] = {.lex_state = 25},
  [2399] = {.lex_state = 25},
  [2400] = {.lex_state = 25},
  [2401] = {.lex_state = 25},
  [2402] = {.lex_state = 25},
  [2403] = {.lex_state = 25},
  [2404] = {.lex_state = 25},
  [2405] = {.lex_state = 25},
  [2406] = {.lex_state = 25},
  [2407] = {.lex_state = 25},
  [2408] = {.lex_state = 25},
  [2409] = {.lex_state = 25},
  [2410] = {.lex_state = 25},
  [2411] = {.lex_state = 25},
  [2412] = {.lex_state = 25},
  [2413] = {.lex_state = 25},
  [2414] = {.lex_state = 25},
  [2415] = {.lex_state = 25},
  [2416] = {.lex_state = 25},
  [2417] = {.lex_state = 25},
  [2418] = {.lex_state = 25},
  [2419] = {.lex_state = 25},
  [2420] = {.lex_state = 25},
  [2421] = {.lex_state = 25},
  [2422] = {.lex_state = 25},
  [2423] = {.lex_state = 25},
  [2424] = {.lex_state = 25},
  [2425] = {.lex_state = 25},
  [2426] = {.lex_state = 25},
  [2427] = {.lex_state = 25},
  [2428] = {.lex_state = 25},
  [2429] = {.lex_state = 25},
  [2430] = {.lex_state = 25},
  [2431] = {.lex_state = 25},
  [2432] = {.lex_state = 25},
  [2433] = {.lex_state = 25},
  [2434] = {.lex_state = 25},
  [2435] = {.lex_state = 25},
  [2436] = {.lex_state = 25},
  [2437] = {.lex_state = 25},
  [2438] = {.lex_state = 25},
  [2439] = {.lex_state = 25},
  [2440] = {.lex_state = 25},
  [2441] = {.lex_state = 25},
  [2442] = {.lex_state = 25},
  [2443] = {.lex_state = 25},
  [2444] = {.lex_state = 25},
  [2445] = {.lex_state = 25},
  [2446] = {.lex_state = 25},
  [2447] = {.lex_state = 25},
  [2448] = {.lex_state = 25},
  [2449] = {.lex_state = 25},
  [2450] = {.lex_state = 25},
  [2451] = {.lex_state = 25},
  [2452] = {.lex_state = 25},
  [2453] = {.lex_state = 25},
  [2454] = {.lex_state = 25},
  [2455] = {.lex_state = 25},
  [2456] = {.lex_state = 25},
  [2457] = {.lex_state = 25},
  [2458] = {.lex_state = 25},
  [2459] = {.lex_state = 25},
  [2460] = {.lex_state = 25},
  [2461] = {.lex_state = 25},
  [2462] = {.lex_state = 25},
  [2463] = {.lex_state = 25},
  [2464] = {.lex_state = 25},
  [2465] = {.lex_state = 25},
  [2466] = {.lex_state = 25},
  [2467] = {.lex_state = 25},
  [2468] = {.lex_state = 25},
  [2469] = {.lex_state = 25},
  [2470] = {.lex_state = 25},
  [2471] = {.lex_state = 25},
  [2472] = {.lex_state = 25},
  [2473] = {.lex_state = 25},
  [2474] = {.lex_state = 25},
  [2475] = {.lex_state = 25},
  [2476] = {.lex_state = 25},
  [2477] = {.lex_state = 25},
  [2478] = {.lex_state = 25},
  [2479] = {.lex_state = 25},
  [2480] = {.lex_state = 25},
  [2481] = {.lex_state = 25},
  [2482] = {.lex_state = 25},
  [2483] = {.lex_state = 25},
  [2484] = {.lex_state = 25},
  [2485] = {.lex_state = 25},
  [2486] = {.lex_state = 25},
  [2487] = {.lex_state = 25},
  [2488] = {.lex_state = 25},
  [2489] = {.lex_state = 25},
  [2490] = {.lex_state = 25},
  [2491] = {.lex_state = 25},
  [2492] = {.lex_state = 25},
  [2493] = {.lex_state = 25},
  [2494] = {.lex_state = 25},
  [2495] = {.lex_state = 25},
  [2496] = {.lex_state = 25},
  [2497] = {.lex_state = 25},
  [2498] = {.lex_state = 25},
  [2499] = {.lex_state = 25},
  [2500] = {.lex_state = 25},
  [2501] = {.lex_state = 25},
  [2502] = {.lex_state = 25},
  [2503] = {.lex_state = 25},
  [2504] = {.lex_state = 25},
  [2505] = {.lex_state = 25},
  [2506] = {.lex_state = 25},
  [2507] = {.lex_state = 25},
  [2508] = {.lex_state = 25},
  [2509] = {.lex_state = 25},
  [2510] = {.lex_state = 25},
  [2511] = {.lex_state = 25},
  [2512] = {.lex_state = 25},
  [2513] = {.lex_state = 25},
  [2514] = {.lex_state = 25},
  [2515] = {.lex_state = 25},
  [2516] = {.lex_state = 25},
  [2517] = {.lex_state = 25},
  [2518] = {.lex_state = 25},
  [2519] = {.lex_state = 25},
  [2520] = {.lex_state = 25},
  [2521] = {.lex_state = 25},
  [2522] = {.lex_state = 25},
  [2523] = {.lex_state = 25},
  [2524] = {.lex_state = 25},
  [2525] = {.lex_state = 25},
  [2526] = {.lex_state = 25},
  [2527] = {.lex_state = 25},
  [2528] = {.lex_state = 25},
  [2529] = {.lex_state = 25},
  [2530] = {.lex_state = 25},
  [2531] = {.lex_state = 25},
  [2532] = {.lex_state = 25},
  [2533] = {.lex_state = 25},
  [2534] = {.lex_state = 25},
  [2535] = {.lex_state = 25},
  [2536] = {.lex_state = 25},
  [2537] = {.lex_state = 25},
  [2538] = {.lex_state = 25},
  [2539] = {.lex_state = 25},
  [2540] = {.lex_state = 25},
  [2541] = {.lex_state = 25},
  [2542] = {.lex_state = 25},
  [2543] = {.lex_state = 25},
  [2544] = {.lex_state = 25},
  [2545] = {.lex_state = 25},
  [2546] = {.lex_state = 25},
  [2547] = {.lex_state = 25},
  [2548] = {.lex_state = 25},
  [2549] = {.lex_state = 25},
  [2550] = {.lex_state = 25},
  [2551] = {.lex_state = 25},
  [2552] = {.lex_state = 25},
  [2553] = {.lex_state = 25},
  [2554] = {.lex_state = 25},
  [2555] = {.lex_state = 25},
  [2556] = {.lex_state = 25},
  [2557] = {.lex_state = 25},
  [2558] = {.lex_state = 25},
  [2559] = {.lex_state = 25},
  [2560] = {.lex_state = 25},
  [2561] = {.lex_state = 25},
  [2562] = {.lex_state = 25},
  [2563] = {.lex_state = 25},
  [2564] = {.lex_state = 25},
  [2565] = {.lex_state = 25},
  [2566] = {.lex_state = 25},
  [2567] = {.lex_state = 25},
  [2568] = {.lex_state = 25},
  [2569] = {.lex_state = 25},
  [2570] = {.lex_state = 25},
  [2571] = {.lex_state = 25},
  [2572] = {.lex_state = 25},
  [2573] = {.lex_state = 25},
  [2574] = {.lex_state = 25},
  [2575] = {.lex_state = 25},
  [2576] = {.lex_state = 25},
  [2577] = {.lex_state = 25},
  [2578] = {.lex_state = 25},
  [2579] = {.lex_state = 25},
  [2580] = {.lex_state = 25},
  [2581] = {.lex_state = 25},
  [2582] = {.lex_state = 25},
  [2583] = {.lex_state = 25},
  [2584] = {.lex_state = 25},
  [2585] = {.lex_state = 25},
  [2586] = {.lex_state = 25},
  [2587] = {.lex_state = 25},
  [2588] = {.lex_state = 25},
  [2589] = {.lex_state = 25},
  [2590] = {.lex_state = 25},
  [2591] = {.lex_state = 25},
  [2592] = {.lex_state = 25},
  [2593] = {.lex_state = 25},
  [2594] = {.lex_state = 25},
  [2595] = {.lex_state = 25},
  [2596] = {.lex_state = 25},
  [2597] = {.lex_state = 25},
  [2598] = {.lex_state = 25},
  [2599] = {.lex_state = 25},
  [2600] = {.lex_state = 25},
  [2601] = {.lex_state = 25},
  [2602] = {.lex_state = 25},
  [2603] = {.lex_state = 25},
  [2604] = {.lex_state = 25},
  [2605] = {.lex_state = 25},
  [2606] = {.lex_state = 25},
  [2607] = {.lex_state = 25},
  [2608] = {.lex_state = 25},
  [2609] = {.lex_state = 25},
  [2610] = {.lex_state = 25},
  [2611] = {.lex_state = 25},
  [2612] = {.lex_state = 25},
  [2613] = {.lex_state = 25},
  [2614] = {.lex_state = 25},
  [2615] = {.lex_state = 25},
  [2616] = {.lex_state = 25},
  [2617] = {.lex_state = 25},
  [2618] = {.lex_state = 25},
  [2619] = {.lex_state = 25},
  [2620] = {.lex_state = 25},
  [2621] = {.lex_state = 25},
  [2622] = {.lex_state = 25},
  [2623] = {.lex_state = 25},
  [2624] = {.lex_state = 25},
  [2625] = {.lex_state = 25},
  [2626] = {.lex_state = 25},
  [2627] = {.lex_state = 25},
  [2628] = {.lex_state = 25},
  [2629] = {.lex_state = 25},
  [2630] = {.lex_state = 25},
  [2631] = {.lex_state = 25},
  [2632] = {.lex_state = 25},
  [2633] = {.lex_state = 25},
  [2634] = {.lex_state = 25},
  [2635] = {.lex_state = 25},
  [2636] = {.lex_state = 25},
  [2637] = {.lex_state = 25},
  [2638] = {.lex_state = 25},
  [2639] = {.lex_state = 25},
  [2640] = {.lex_state = 25},
  [2641] = {.lex_state = 25},
  [2642] = {.lex_state = 25},
  [2643] = {.lex_state = 25},
  [2644] = {.lex_state = 25},
  [2645] = {.lex_state = 25},
  [2646] = {.lex_state = 25},
  [2647] = {.lex_state = 25},
  [2648] = {.lex_state = 25},
  [2649] = {.lex_state = 25},
  [2650] = {.lex_state = 25},
  [2651] = {.lex_state = 25},
  [2652] = {.lex_state = 25},
  [2653] = {.lex_state = 25},
  [2654] = {.lex_state = 25},
  [2655] = {.lex_state = 25},
  [2656] = {.lex_state = 25},
  [2657] = {.lex_state = 25},
  [2658] = {.lex_state = 25},
  [2659] = {.lex_state = 25},
  [2660] = {.lex_state = 25},
  [2661] = {.lex_state = 25},
  [2662] = {.lex_state = 25},
  [2663] = {.lex_state = 25},
  [2664] = {.lex_state = 25},
  [2665] = {.lex_state = 25},
  [2666] = {.lex_state = 25},
  [2667] = {.lex_state = 25},
  [2668] = {.lex_state = 25},
  [2669] = {.lex_state = 1},
  [2670] = {.lex_state = 25},
  [2671] = {.lex_state = 25},
  [2672] = {.lex_state = 25},
  [2673] = {.lex_state = 25},
  [2674] = {.lex_state = 25},
  [2675] = {.lex_state = 28},
  [2676] = {.lex_state = 25},
  [2677] = {.lex_state = 25},
  [2678] = {.lex_state = 25},
  [2679] = {.lex_state = 25},
  [2680] = {.lex_state = 25},
  [2681] = {.lex_state = 25},
  [2682] = {.lex_state = 28},
  [2683] = {.lex_state = 28},
  [2684] = {.lex_state = 25},
  [2685] = {.lex_state = 25},
  [2686] = {.lex_state = 25},
  [2687] = {.lex_state = 25},
  [2688] = {.lex_state = 25},
  [2689] = {.lex_state = 25},
  [2690] = {.lex_state = 25},
  [2691] = {.lex_state = 25},
  [2692] = {.lex_state = 25},
  [2693] = {.lex_state = 28},
  [2694] = {.lex_state = 25},
  [2695] = {.lex_state = 25},
  [2696] = {.lex_state = 25},
  [2697] = {.lex_state = 25},
  [2698] = {.lex_state = 25},
  [2699] = {.lex_state = 25},
  [2700] = {.lex_state = 25},
  [2701] = {.lex_state = 28},
  [2702] = {.lex_state = 25},
  [2703] = {.lex_state = 25},
  [2704] = {.lex_state = 1},
  [2705] = {.lex_state = 25},
  [2706] = {.lex_state = 25},
  [2707] = {.lex_state = 25},
  [2708] = {.lex_state = 25},
  [2709] = {.lex_state = 25},
  [2710] = {.lex_state = 25},
  [2711] = {.lex_state = 25},
  [2712] = {.lex_state = 25},
  [2713] = {.lex_state = 25},
  [2714] = {.lex_state = 28},
  [2715] = {.lex_state = 28},
  [2716] = {.lex_state = 25},
  [2717] = {.lex_state = 25},
  [2718] = {.lex_state = 28},
  [2719] = {.lex_state = 28},
  [2720] = {.lex_state = 25},
  [2721] = {.lex_state = 28},
  [2722] = {.lex_state = 28},
  [2723] = {.lex_state = 28},
  [2724] = {.lex_state = 28},
  [2725] = {.lex_state = 25},
  [2726] = {.lex_state = 25},
  [2727] = {.lex_state = 25},
  [2728] = {.lex_state = 25},
  [2729] = {.lex_state = 1},
  [2730] = {.lex_state = 28},
  [2731] = {.lex_state = 25},
  [2732] = {.lex_state = 25},
  [2733] = {.lex_state = 25},
  [2734] = {.lex_state = 28},
  [2735] = {.lex_state = 28},
  [2736] = {.lex_state = 25},
  [2737] = {.lex_state = 25},
  [2738] = {.lex_state = 25},
  [2739] = {.lex_state = 28},
  [2740] = {.lex_state = 25},
  [2741] = {.lex_state = 25},
  [2742] = {.lex_state = 25},
  [2743] = {.lex_state = 28},
  [2744] = {.lex_state = 25},
  [2745] = {.lex_state = 25},
  [2746] = {.lex_state = 28},
  [2747] = {.lex_state = 28},
  [2748] = {.lex_state = 1},
  [2749] = {.lex_state = 1},
  [2750] = {.lex_state = 20},
  [2751] = {.lex_state = 20},
  [2752] = {.lex_state = 20},
  [2753] = {.lex_state = 20},
  [2754] = {.lex_state = 20},
  [2755] = {.lex_state = 20},
  [2756] = {.lex_state = 20},
  [2757] = {.lex_state = 20},
  [2758] = {.lex_state = 20},
  [2759] = {.lex_state = 20},
  [2760] = {.lex_state = 20},
  [2761] = {.lex_state = 20},
  [2762] = {.lex_state = 28},
  [2763] = {.lex_state = 28},
  [2764] = {.lex_state = 28},
  [2765] = {.lex_state = 28},
  [2766] = {.lex_state = 28},
  [2767] = {.lex_state = 28},
  [2768] = {.lex_state = 28},
  [2769] = {.lex_state = 28},
  [2770] = {.lex_state = 28},
  [2771] = {.lex_state = 28},
  [2772] = {.lex_state = 28},
  [2773] = {.lex_state = 28},
  [2774] = {.lex_state = 28},
  [2775] = {.lex_state = 28},
  [2776] = {.lex_state = 28},
  [2777] = {.lex_state = 28},
  [2778] = {.lex_state = 28},
  [2779] = {.lex_state = 28},
  [2780] = {.lex_state = 28},
  [2781] = {.lex_state = 28},
  [2782] = {.lex_state = 28},
  [2783] = {.lex_state = 28},
  [2784] = {.lex_state = 28},
  [2785] = {.lex_state = 28},
  [2786] = {.lex_state = 28},
  [2787] = {.lex_state = 28},
  [2788] = {.lex_state = 28},
  [2789] = {.lex_state = 28},
  [2790] = {.lex_state = 28},
  [2791] = {.lex_state = 28},
  [2792] = {.lex_state = 28},
  [2793] = {.lex_state = 28},
  [2794] = {.lex_state = 28},
  [2795] = {.lex_state = 28},
  [2796] = {.lex_state = 28},
  [2797] = {.lex_state = 28},
  [2798] = {.lex_state = 28},
  [2799] = {.lex_state = 29},
  [2800] = {.lex_state = 18},
  [2801] = {.lex_state = 18},
  [2802] = {.lex_state = 18},
  [2803] = {.lex_state = 29},
  [2804] = {.lex_state = 29},
  [2805] = {.lex_state = 18},
  [2806] = {.lex_state = 18},
  [2807] = {.lex_state = 18},
  [2808] = {.lex_state = 29},
  [2809] = {.lex_state = 18},
  [2810] = {.lex_state = 29},
  [2811] = {.lex_state = 18},
  [2812] = {.lex_state = 29},
  [2813] = {.lex_state = 18},
  [2814] = {.lex_state = 29},
  [2815] = {.lex_state = 18},
  [2816] = {.lex_state = 18},
  [2817] = {.lex_state = 29},
  [2818] = {.lex_state = 29},
  [2819] = {.lex_state = 18},
  [2820] = {.lex_state = 18},
  [2821] = {.lex_state = 18},
  [2822] = {.lex_state = 18},
  [2823] = {.lex_state = 18},
  [2824] = {.lex_state = 29},
  [2825] = {.lex_state = 18},
  [2826] = {.lex_state = 18},
  [2827] = {.lex_state = 18},
  [2828] = {.lex_state = 18},
  [2829] = {.lex_state = 18},
  [2830] = {.lex_state = 29},
  [2831] = {.lex_state = 18},
  [2832] = {.lex_state = 29},
  [2833] = {.lex_state = 18},
  [2834] = {.lex_state = 29},
  [2835] = {.lex_state = 18},
  [2836] = {.lex_state = 18},
  [2837] = {.lex_state = 18},
  [2838] = {.lex_state = 18},
  [2839] = {.lex_state = 18},
  [2840] = {.lex_state = 29},
  [2841] = {.lex_state = 18},
  [2842] = {.lex_state = 29},
  [2843] = {.lex_state = 18},
  [2844] = {.lex_state = 18},
  [2845] = {.lex_state = 18},
  [2846] = {.lex_state = 22},
  [2847] = {.lex_state = 25},
  [2848] = {.lex_state = 22},
  [2849] = {.lex_state = 22},
  [2850] = {.lex_state = 28},
  [2851] = {.lex_state = 22},
  [2852] = {.lex_state = 22},
  [2853] = {.lex_state = 28},
  [2854] = {.lex_state = 22},
  [2855] = {.lex_state = 22},
  [2856] = {.lex_state = 22},
  [2857] = {.lex_state = 22},
  [2858] = {.lex_state = 22},
  [2859] = {.lex_state = 22},
  [2860] = {.lex_state = 28},
  [2861] = {.lex_state = 22},
  [2862] = {.lex_state = 22},
  [2863] = {.lex_state = 22},
  [2864] = {.lex_state = 22},
  [2865] = {.lex_state = 22},
  [2866] = {.lex_state = 29},
  [2867] = {.lex_state = 29},
  [2868] = {.lex_state = 28},
  [2869] = {.lex_state = 22},
  [2870] = {.lex_state = 22},
  [2871] = {.lex_state = 28},
  [2872] = {.lex_state = 25},
  [2873] = {.lex_state = 28},
  [2874] = {.lex_state = 28},
  [2875] = {.lex_state = 28},
  [2876] = {.lex_state = 27},
  [2877] = {.lex_state = 28},
  [2878] = {.lex_state = 29},
  [2879] = {.lex_state = 28},
  [2880] = {.lex_state = 28},
  [2881] = {.lex_state = 28},
  [2882] = {.lex_state = 28},
  [2883] = {.lex_state = 28},
  [2884] = {.lex_state = 28},
  [2885] = {.lex_state = 28},
  [2886] = {.lex_state = 28},
  [2887] = {.lex_state = 28},
  [2888] = {.lex_state = 22},
  [2889] = {.lex_state = 22},
  [2890] = {.lex_state = 22},
  [2891] = {.lex_state = 22},
  [2892] = {.lex_state = 22},
  [2893] = {.lex_state = 22},
  [2894] = {.lex_state = 22},
  [2895] = {.lex_state = 22},
  [2896] = {.lex_state = 22},
  [2897] = {.lex_state = 22},
  [2898] = {.lex_state = 22},
  [2899] = {.lex_state = 22},
  [2900] = {.lex_state = 247},
  [2901] = {.lex_state = 20},
  [2902] = {.lex_state = 19},
  [2903] = {.lex_state = 29},
  [2904] = {.lex_state = 20},
  [2905] = {.lex_state = 247},
  [2906] = {.lex_state = 247},
  [2907] = {.lex_state = 20},
  [2908] = {.lex_state = 20},
  [2909] = {.lex_state = 20},
  [2910] = {.lex_state = 20},
  [2911] = {.lex_state = 20},
  [2912] = {.lex_state = 20},
  [2913] = {.lex_state = 20},
  [2914] = {.lex_state = 20},
  [2915] = {.lex_state = 20},
  [2916] = {.lex_state = 20},
  [2917] = {.lex_state = 20},
  [2918] = {.lex_state = 20},
  [2919] = {.lex_state = 20},
  [2920] = {.lex_state = 20},
  [2921] = {.lex_state = 20},
  [2922] = {.lex_state = 20},
  [2923] = {.lex_state = 20},
  [2924] = {.lex_state = 20},
  [2925] = {.lex_state = 20},
  [2926] = {.lex_state = 20},
  [2927] = {.lex_state = 20},
  [2928] = {.lex_state = 20},
  [2929] = {.lex_state = 20},
  [2930] = {.lex_state = 20},
  [2931] = {.lex_state = 20},
  [2932] = {.lex_state = 20},
  [2933] = {.lex_state = 20},
  [2934] = {.lex_state = 20},
  [2935] = {.lex_state = 20},
  [2936] = {.lex_state = 20},
  [2937] = {.lex_state = 20},
  [2938] = {.lex_state = 20},
  [2939] = {.lex_state = 1},
  [2940] = {.lex_state = 20},
  [2941] = {.lex_state = 20},
  [2942] = {.lex_state = 20},
  [2943] = {.lex_state = 20},
  [2944] = {.lex_state = 20},
  [2945] = {.lex_state = 20},
  [2946] = {.lex_state = 20},
  [2947] = {.lex_state = 20},
  [2948] = {.lex_state = 20},
  [2949] = {.lex_state = 20},
  [2950] = {.lex_state = 20},
  [2951] = {.lex_state = 20},
  [2952] = {.lex_state = 20},
  [2953] = {.lex_state = 20},
  [2954] = {.lex_state = 20},
  [2955] = {.lex_state = 20},
  [2956] = {.lex_state = 20},
  [2957] = {.lex_state = 20},
  [2958] = {.lex_state = 20},
  [2959] = {.lex_state = 20},
  [2960] = {.lex_state = 20},
  [2961] = {.lex_state = 20},
  [2962] = {.lex_state = 20},
  [2963] = {.lex_state = 20},
  [2964] = {.lex_state = 20},
  [2965] = {.lex_state = 20},
  [2966] = {.lex_state = 20},
  [2967] = {.lex_state = 20},
  [2968] = {.lex_state = 1},
  [2969] = {.lex_state = 20},
  [2970] = {.lex_state = 20},
  [2971] = {.lex_state = 20},
  [2972] = {.lex_state = 20},
  [2973] = {.lex_state = 1},
  [2974] = {.lex_state = 20},
  [2975] = {.lex_state = 20},
  [2976] = {.lex_state = 20},
  [2977] = {.lex_state = 20},
  [2978] = {.lex_state = 20},
  [2979] = {.lex_state = 20},
  [2980] = {.lex_state = 20},
  [2981] = {.lex_state = 20},
  [2982] = {.lex_state = 20},
  [2983] = {.lex_state = 247},
  [2984] = {.lex_state = 247},
  [2985] = {.lex_state = 20},
  [2986] = {.lex_state = 20},
  [2987] = {.lex_state = 20},
  [2988] = {.lex_state = 20},
  [2989] = {.lex_state = 20},
  [2990] = {.lex_state = 20},
  [2991] = {.lex_state = 20},
  [2992] = {.lex_state = 20},
  [2993] = {.lex_state = 20},
  [2994] = {.lex_state = 20},
  [2995] = {.lex_state = 20},
  [2996] = {.lex_state = 20},
  [2997] = {.lex_state = 20},
  [2998] = {.lex_state = 20},
  [2999] = {.lex_state = 27},
  [3000] = {.lex_state = 25},
  [3001] = {.lex_state = 247},
  [3002] = {.lex_state = 247},
  [3003] = {.lex_state = 247},
  [3004] = {.lex_state = 247},
  [3005] = {.lex_state = 247},
  [3006] = {.lex_state = 247},
  [3007] = {.lex_state = 25},
  [3008] = {.lex_state = 25},
  [3009] = {.lex_state = 247},
  [3010] = {.lex_state = 247},
  [3011] = {.lex_state = 247},
  [3012] = {.lex_state = 247},
  [3013] = {.lex_state = 247},
  [3014] = {.lex_state = 25},
  [3015] = {.lex_state = 247},
  [3016] = {.lex_state = 247},
  [3017] = {.lex_state = 25},
  [3018] = {.lex_state = 247},
  [3019] = {.lex_state = 247},
  [3020] = {.lex_state = 247},
  [3021] = {.lex_state = 247},
  [3022] = {.lex_state = 25},
  [3023] = {.lex_state = 247},
  [3024] = {.lex_state = 25},
  [3025] = {.lex_state = 247},
  [3026] = {.lex_state = 247},
  [3027] = {.lex_state = 25},
  [3028] = {.lex_state = 25},
  [3029] = {.lex_state = 247},
  [3030] = {.lex_state = 247},
  [3031] = {.lex_state = 25},
  [3032] = {.lex_state = 247},
  [3033] = {.lex_state = 247},
  [3034] = {.lex_state = 25},
  [3035] = {.lex_state = 247},
  [3036] = {.lex_state = 247},
  [3037] = {.lex_state = 247},
  [3038] = {.lex_state = 247},
  [3039] = {.lex_state = 20},
  [3040] = {.lex_state = 20},
  [3041] = {.lex_state = 25},
  [3042] = {.lex_state = 247},
  [3043] = {.lex_state = 247},
  [3044] = {.lex_state = 25},
  [3045] = {.lex_state = 247},
  [3046] = {.lex_state = 247},
  [3047] = {.lex_state = 20},
  [3048] = {.lex_state = 247},
  [3049] = {.lex_state = 247},
  [3050] = {.lex_state = 247},
  [3051] = {.lex_state = 247},
  [3052] = {.lex_state = 247},
  [3053] = {.lex_state = 20},
  [3054] = {.lex_state = 20},
  [3055] = {.lex_state = 1},
  [3056] = {.lex_state = 20},
  [3057] = {.lex_state = 20},
  [3058] = {.lex_state = 247},
  [3059] = {.lex_state = 20},
  [3060] = {.lex_state = 247},
  [3061] = {.lex_state = 247},
  [3062] = {.lex_state = 20},
  [3063] = {.lex_state = 20},
  [3064] = {.lex_state = 247},
  [3065] = {.lex_state = 247},
  [3066] = {.lex_state = 20},
  [3067] = {.lex_state = 20},
  [3068] = {.lex_state = 1},
  [3069] = {.lex_state = 20},
  [3070] = {.lex_state = 20},
  [3071] = {.lex_state = 247},
  [3072] = {.lex_state = 20},
  [3073] = {.lex_state = 20},
  [3074] = {.lex_state = 20},
  [3075] = {.lex_state = 20},
  [3076] = {.lex_state = 20},
  [3077] = {.lex_state = 20},
  [3078] = {.lex_state = 20},
  [3079] = {.lex_state = 247},
  [3080] = {.lex_state = 20},
  [3081] = {.lex_state = 20},
  [3082] = {.lex_state = 20},
  [3083] = {.lex_state = 20},
  [3084] = {.lex_state = 22},
  [3085] = {.lex_state = 20},
  [3086] = {.lex_state = 20},
  [3087] = {.lex_state = 20},
  [3088] = {.lex_state = 25},
  [3089] = {.lex_state = 20},
  [3090] = {.lex_state = 20},
  [3091] = {.lex_state = 20},
  [3092] = {.lex_state = 20},
  [3093] = {.lex_state = 247},
  [3094] = {.lex_state = 20},
  [3095] = {.lex_state = 20},
  [3096] = {.lex_state = 20},
  [3097] = {.lex_state = 247},
  [3098] = {.lex_state = 20},
  [3099] = {.lex_state = 247},
  [3100] = {.lex_state = 247},
  [3101] = {.lex_state = 20},
  [3102] = {.lex_state = 20},
  [3103] = {.lex_state = 247},
  [3104] = {.lex_state = 247},
  [3105] = {.lex_state = 25},
  [3106] = {.lex_state = 25},
  [3107] = {.lex_state = 247},
  [3108] = {.lex_state = 25},
  [3109] = {.lex_state = 25},
  [3110] = {.lex_state = 25},
  [3111] = {.lex_state = 25},
  [3112] = {.lex_state = 25},
  [3113] = {.lex_state = 25},
  [3114] = {.lex_state = 25},
  [3115] = {.lex_state = 25},
  [3116] = {.lex_state = 25},
  [3117] = {.lex_state = 25},
  [3118] = {.lex_state = 30},
  [3119] = {.lex_state = 25},
  [3120] = {.lex_state = 25},
  [3121] = {.lex_state = 25},
  [3122] = {.lex_state = 25},
  [3123] = {.lex_state = 25},
  [3124] = {.lex_state = 25},
  [3125] = {.lex_state = 25},
  [3126] = {.lex_state = 25},
  [3127] = {.lex_state = 25},
  [3128] = {.lex_state = 25},
  [3129] = {.lex_state = 25},
  [3130] = {.lex_state = 25},
  [3131] = {.lex_state = 25},
  [3132] = {.lex_state = 25},
  [3133] = {.lex_state = 25},
  [3134] = {.lex_state = 30},
  [3135] = {.lex_state = 25},
  [3136] = {.lex_state = 25},
  [3137] = {.lex_state = 25},
  [3138] = {.lex_state = 25},
  [3139] = {.lex_state = 25},
  [3140] = {.lex_state = 25},
  [3141] = {.lex_state = 25},
  [3142] = {.lex_state = 25},
  [3143] = {.lex_state = 25},
  [3144] = {.lex_state = 25},
  [3145] = {.lex_state = 25},
  [3146] = {.lex_state = 25},
  [3147] = {.lex_state = 25},
  [3148] = {.lex_state = 25},
  [3149] = {.lex_state = 25},
  [3150] = {.lex_state = 25},
  [3151] = {.lex_state = 25},
  [3152] = {.lex_state = 25},
  [3153] = {.lex_state = 25},
  [3154] = {.lex_state = 25},
  [3155] = {.lex_state = 25},
  [3156] = {.lex_state = 25},
  [3157] = {.lex_state = 25},
  [3158] = {.lex_state = 25},
  [3159] = {.lex_state = 25},
  [3160] = {.lex_state = 25},
  [3161] = {.lex_state = 25},
  [3162] = {.lex_state = 25},
  [3163] = {.lex_state = 25},
  [3164] = {.lex_state = 25},
  [3165] = {.lex_state = 25},
  [3166] = {.lex_state = 25},
  [3167] = {.lex_state = 25},
  [3168] = {.lex_state = 25},
  [3169] = {.lex_state = 25},
  [3170] = {.lex_state = 25},
  [3171] = {.lex_state = 25},
  [3172] = {.lex_state = 25},
  [3173] = {.lex_state = 25},
  [3174] = {.lex_state = 25},
  [3175] = {.lex_state = 25},
  [3176] = {.lex_state = 25},
  [3177] = {.lex_state = 25},
  [3178] = {.lex_state = 25},
  [3179] = {.lex_state = 25},
  [3180] = {.lex_state = 25},
  [3181] = {.lex_state = 25},
  [3182] = {.lex_state = 25},
  [3183] = {.lex_state = 25},
  [3184] = {.lex_state = 25},
  [3185] = {.lex_state = 25},
  [3186] = {.lex_state = 25},
  [3187] = {.lex_state = 25},
  [3188] = {.lex_state = 25},
  [3189] = {.lex_state = 25},
  [3190] = {.lex_state = 25},
  [3191] = {.lex_state = 25},
  [3192] = {.lex_state = 25},
  [3193] = {.lex_state = 25},
  [3194] = {.lex_state = 25},
  [3195] = {.lex_state = 25},
  [3196] = {.lex_state = 25},
  [3197] = {.lex_state = 25},
  [3198] = {.lex_state = 25},
  [3199] = {.lex_state = 25},
  [3200] = {.lex_state = 25},
  [3201] = {.lex_state = 25},
  [3202] = {.lex_state = 25},
  [3203] = {.lex_state = 25},
  [3204] = {.lex_state = 25},
  [3205] = {.lex_state = 25},
  [3206] = {.lex_state = 25},
  [3207] = {.lex_state = 25},
  [3208] = {.lex_state = 25},
  [3209] = {.lex_state = 25},
  [3210] = {.lex_state = 25},
  [3211] = {.lex_state = 247},
  [3212] = {.lex_state = 25},
  [3213] = {.lex_state = 25},
  [3214] = {.lex_state = 25},
  [3215] = {.lex_state = 25},
  [3216] = {.lex_state = 25},
  [3217] = {.lex_state = 25},
  [3218] = {.lex_state = 25},
  [3219] = {.lex_state = 25},
  [3220] = {.lex_state = 25},
  [3221] = {.lex_state = 25},
  [3222] = {.lex_state = 25},
  [3223] = {.lex_state = 25},
  [3224] = {.lex_state = 25},
  [3225] = {.lex_state = 25},
  [3226] = {.lex_state = 25},
  [3227] = {.lex_state = 25},
  [3228] = {.lex_state = 25},
  [3229] = {.lex_state = 25},
  [3230] = {.lex_state = 25},
  [3231] = {.lex_state = 25},
  [3232] = {.lex_state = 25},
  [3233] = {.lex_state = 25},
  [3234] = {.lex_state = 25},
  [3235] = {.lex_state = 25},
  [3236] = {.lex_state = 25},
  [3237] = {.lex_state = 25},
  [3238] = {.lex_state = 25},
  [3239] = {.lex_state = 25},
  [3240] = {.lex_state = 25},
  [3241] = {.lex_state = 25},
  [3242] = {.lex_state = 25},
  [3243] = {.lex_state = 25},
  [3244] = {.lex_state = 25},
  [3245] = {.lex_state = 25},
  [3246] = {.lex_state = 25},
  [3247] = {.lex_state = 25},
  [3248] = {.lex_state = 25},
  [3249] = {.lex_state = 25},
  [3250] = {.lex_state = 25},
  [3251] = {.lex_state = 25},
  [3252] = {.lex_state = 25},
  [3253] = {.lex_state = 25},
  [3254] = {.lex_state = 25},
  [3255] = {.lex_state = 25},
  [3256] = {.lex_state = 25},
  [3257] = {.lex_state = 25},
  [3258] = {.lex_state = 25},
  [3259] = {.lex_state = 25},
  [3260] = {.lex_state = 25},
  [3261] = {.lex_state = 25},
  [3262] = {.lex_state = 25},
  [3263] = {.lex_state = 25},
  [3264] = {.lex_state = 25},
  [3265] = {.lex_state = 25},
  [3266] = {.lex_state = 25},
  [3267] = {.lex_state = 25},
  [3268] = {.lex_state = 25},
  [3269] = {.lex_state = 25},
  [3270] = {.lex_state = 25},
  [3271] = {.lex_state = 25},
  [3272] = {.lex_state = 25},
  [3273] = {.lex_state = 25},
  [3274] = {.lex_state = 25},
  [3275] = {.lex_state = 25},
  [3276] = {.lex_state = 25},
  [3277] = {.lex_state = 25},
  [3278] = {.lex_state = 25},
  [3279] = {.lex_state = 25},
  [3280] = {.lex_state = 247},
  [3281] = {.lex_state = 25},
  [3282] = {.lex_state = 25},
  [3283] = {.lex_state = 25},
  [3284] = {.lex_state = 25},
  [3285] = {.lex_state = 25},
  [3286] = {.lex_state = 25},
  [3287] = {.lex_state = 25},
  [3288] = {.lex_state = 25},
  [3289] = {.lex_state = 25},
  [3290] = {.lex_state = 25},
  [3291] = {.lex_state = 25},
  [3292] = {.lex_state = 25},
  [3293] = {.lex_state = 25},
  [3294] = {.lex_state = 25},
  [3295] = {.lex_state = 25},
  [3296] = {.lex_state = 25},
  [3297] = {.lex_state = 25},
  [3298] = {.lex_state = 25},
  [3299] = {.lex_state = 25},
  [3300] = {.lex_state = 25},
  [3301] = {.lex_state = 25},
  [3302] = {.lex_state = 25},
  [3303] = {.lex_state = 25},
  [3304] = {.lex_state = 25},
  [3305] = {.lex_state = 25},
  [3306] = {.lex_state = 25},
  [3307] = {.lex_state = 25},
  [3308] = {.lex_state = 25},
  [3309] = {.lex_state = 25},
  [3310] = {.lex_state = 25},
  [3311] = {.lex_state = 25},
  [3312] = {.lex_state = 25},
  [3313] = {.lex_state = 25},
  [3314] = {.lex_state = 25},
  [3315] = {.lex_state = 25},
  [3316] = {.lex_state = 25},
  [3317] = {.lex_state = 25},
  [3318] = {.lex_state = 25},
  [3319] = {.lex_state = 25},
  [3320] = {.lex_state = 25},
  [3321] = {.lex_state = 25},
  [3322] = {.lex_state = 25},
  [3323] = {.lex_state = 25},
  [3324] = {.lex_state = 25},
  [3325] = {.lex_state = 25},
  [3326] = {.lex_state = 25},
  [3327] = {.lex_state = 25},
  [3328] = {.lex_state = 25},
  [3329] = {.lex_state = 25},
  [3330] = {.lex_state = 25},
  [3331] = {.lex_state = 25},
  [3332] = {.lex_state = 25},
  [3333] = {.lex_state = 25},
  [3334] = {.lex_state = 25},
  [3335] = {.lex_state = 25},
  [3336] = {.lex_state = 25},
  [3337] = {.lex_state = 25},
  [3338] = {.lex_state = 25},
  [3339] = {.lex_state = 25},
  [3340] = {.lex_state = 25},
  [3341] = {.lex_state = 25},
  [3342] = {.lex_state = 25},
  [3343] = {.lex_state = 25},
  [3344] = {.lex_state = 25},
  [3345] = {.lex_state = 25},
  [3346] = {.lex_state = 25},
  [3347] = {.lex_state = 25},
  [3348] = {.lex_state = 25},
  [3349] = {.lex_state = 25},
  [3350] = {.lex_state = 25},
  [3351] = {.lex_state = 25},
  [3352] = {.lex_state = 25},
  [3353] = {.lex_state = 25},
  [3354] = {.lex_state = 25},
  [3355] = {.lex_state = 25},
  [3356] = {.lex_state = 25},
  [3357] = {.lex_state = 25},
  [3358] = {.lex_state = 25},
  [3359] = {.lex_state = 25},
  [3360] = {.lex_state = 25},
  [3361] = {.lex_state = 25},
  [3362] = {.lex_state = 25},
  [3363] = {.lex_state = 25},
  [3364] = {.lex_state = 25},
  [3365] = {.lex_state = 25},
  [3366] = {.lex_state = 25},
  [3367] = {.lex_state = 25},
  [3368] = {.lex_state = 25},
  [3369] = {.lex_state = 25},
  [3370] = {.lex_state = 25},
  [3371] = {.lex_state = 25},
  [3372] = {.lex_state = 25},
  [3373] = {.lex_state = 25},
  [3374] = {.lex_state = 25},
  [3375] = {.lex_state = 25},
  [3376] = {.lex_state = 25},
  [3377] = {.lex_state = 25},
  [3378] = {.lex_state = 25},
  [3379] = {.lex_state = 25},
  [3380] = {.lex_state = 25},
  [3381] = {.lex_state = 25},
  [3382] = {.lex_state = 25},
  [3383] = {.lex_state = 25},
  [3384] = {.lex_state = 25},
  [3385] = {.lex_state = 25},
  [3386] = {.lex_state = 25},
  [3387] = {.lex_state = 25},
  [3388] = {.lex_state = 25},
  [3389] = {.lex_state = 25},
  [3390] = {.lex_state = 25},
  [3391] = {.lex_state = 25},
  [3392] = {.lex_state = 25},
  [3393] = {.lex_state = 25},
  [3394] = {.lex_state = 25},
  [3395] = {.lex_state = 25},
  [3396] = {.lex_state = 25},
  [3397] = {.lex_state = 25},
  [3398] = {.lex_state = 25},
  [3399] = {.lex_state = 25},
  [3400] = {.lex_state = 25},
  [3401] = {.lex_state = 25},
  [3402] = {.lex_state = 25},
  [3403] = {.lex_state = 25},
  [3404] = {.lex_state = 25},
  [3405] = {.lex_state = 25},
  [3406] = {.lex_state = 25},
  [3407] = {.lex_state = 25},
  [3408] = {.lex_state = 25},
  [3409] = {.lex_state = 25},
  [3410] = {.lex_state = 25},
  [3411] = {.lex_state = 25},
  [3412] = {.lex_state = 25},
  [3413] = {.lex_state = 25},
  [3414] = {.lex_state = 25},
  [3415] = {.lex_state = 25},
  [3416] = {.lex_state = 25},
  [3417] = {.lex_state = 247},
  [3418] = {.lex_state = 247},
  [3419] = {.lex_state = 247},
  [3420] = {.lex_state = 247},
  [3421] = {.lex_state = 247},
  [3422] = {.lex_state = 247},
  [3423] = {.lex_state = 247},
  [3424] = {.lex_state = 25},
  [3425] = {.lex_state = 247},
  [3426] = {.lex_state = 247},
  [3427] = {.lex_state = 247},
  [3428] = {.lex_state = 247},
  [3429] = {.lex_state = 247},
  [3430] = {.lex_state = 247},
  [3431] = {.lex_state = 247},
  [3432] = {.lex_state = 247},
  [3433] = {.lex_state = 247},
  [3434] = {.lex_state = 247},
  [3435] = {.lex_state = 247},
  [3436] = {.lex_state = 247},
  [3437] = {.lex_state = 247},
  [3438] = {.lex_state = 247},
  [3439] = {.lex_state = 247},
  [3440] = {.lex_state = 247},
  [3441] = {.lex_state = 247},
  [3442] = {.lex_state = 247},
  [3443] = {.lex_state = 247},
  [3444] = {.lex_state = 247},
  [3445] = {.lex_state = 247},
  [3446] = {.lex_state = 247},
  [3447] = {.lex_state = 247},
  [3448] = {.lex_state = 247},
  [3449] = {.lex_state = 247},
  [3450] = {.lex_state = 247},
  [3451] = {.lex_state = 247},
  [3452] = {.lex_state = 247},
  [3453] = {.lex_state = 247},
  [3454] = {.lex_state = 247},
  [3455] = {.lex_state = 247},
  [3456] = {.lex_state = 247},
  [3457] = {.lex_state = 247},
  [3458] = {.lex_state = 247},
  [3459] = {.lex_state = 247},
  [3460] = {.lex_state = 247},
  [3461] = {.lex_state = 247},
  [3462] = {.lex_state = 247},
  [3463] = {.lex_state = 247},
  [3464] = {.lex_state = 247},
  [3465] = {.lex_state = 247},
  [3466] = {.lex_state = 247},
  [3467] = {.lex_state = 247},
  [3468] = {.lex_state = 247},
  [3469] = {.lex_state = 247},
  [3470] = {.lex_state = 247},
  [3471] = {.lex_state = 247},
  [3472] = {.lex_state = 247},
  [3473] = {.lex_state = 247},
  [3474] = {.lex_state = 247},
  [3475] = {.lex_state = 247},
  [3476] = {.lex_state = 247},
  [3477] = {.lex_state = 247},
  [3478] = {.lex_state = 247},
  [3479] = {.lex_state = 247},
  [3480] = {.lex_state = 247},
  [3481] = {.lex_state = 247},
  [3482] = {.lex_state = 247},
  [3483] = {.lex_state = 247},
  [3484] = {.lex_state = 247},
  [3485] = {.lex_state = 247},
  [3486] = {.lex_state = 247},
  [3487] = {.lex_state = 247},
  [3488] = {.lex_state = 247},
  [3489] = {.lex_state = 247},
  [3490] = {.lex_state = 247},
  [3491] = {.lex_state = 247},
  [3492] = {.lex_state = 247},
  [3493] = {.lex_state = 247},
  [3494] = {.lex_state = 247},
  [3495] = {.lex_state = 247},
  [3496] = {.lex_state = 247},
  [3497] = {.lex_state = 247},
  [3498] = {.lex_state = 247},
  [3499] = {.lex_state = 247},
  [3500] = {.lex_state = 247},
  [3501] = {.lex_state = 247},
  [3502] = {.lex_state = 247},
  [3503] = {.lex_state = 247},
  [3504] = {.lex_state = 247},
  [3505] = {.lex_state = 247},
  [3506] = {.lex_state = 247},
  [3507] = {.lex_state = 247},
  [3508] = {.lex_state = 247},
  [3509] = {.lex_state = 247},
  [3510] = {.lex_state = 247},
  [3511] = {.lex_state = 247},
  [3512] = {.lex_state = 247},
  [3513] = {.lex_state = 247},
  [3514] = {.lex_state = 247},
  [3515] = {.lex_state = 247},
  [3516] = {.lex_state = 247},
  [3517] = {.lex_state = 247},
  [3518] = {.lex_state = 247},
  [3519] = {.lex_state = 247},
  [3520] = {.lex_state = 247},
  [3521] = {.lex_state = 247},
  [3522] = {.lex_state = 247},
  [3523] = {.lex_state = 247},
  [3524] = {.lex_state = 247},
  [3525] = {.lex_state = 247},
  [3526] = {.lex_state = 247},
  [3527] = {.lex_state = 247},
  [3528] = {.lex_state = 247},
  [3529] = {.lex_state = 247},
  [3530] = {.lex_state = 247},
  [3531] = {.lex_state = 247},
  [3532] = {.lex_state = 247},
  [3533] = {.lex_state = 247},
  [3534] = {.lex_state = 247},
  [3535] = {.lex_state = 247},
  [3536] = {.lex_state = 247},
  [3537] = {.lex_state = 247},
  [3538] = {.lex_state = 247},
  [3539] = {.lex_state = 247},
  [3540] = {.lex_state = 247},
  [3541] = {.lex_state = 247},
  [3542] = {.lex_state = 247},
  [3543] = {.lex_state = 247},
  [3544] = {.lex_state = 247},
  [3545] = {.lex_state = 247},
  [3546] = {.lex_state = 247},
  [3547] = {.lex_state = 247},
  [3548] = {.lex_state = 247},
  [3549] = {.lex_state = 247},
  [3550] = {.lex_state = 247},
  [3551] = {.lex_state = 247},
  [3552] = {.lex_state = 247},
  [3553] = {.lex_state = 247},
  [3554] = {.lex_state = 247},
  [3555] = {.lex_state = 247},
  [3556] = {.lex_state = 247},
  [3557] = {.lex_state = 247},
  [3558] = {.lex_state = 247},
  [3559] = {.lex_state = 247},
  [3560] = {.lex_state = 247},
  [3561] = {.lex_state = 247},
  [3562] = {.lex_state = 247},
  [3563] = {.lex_state = 247},
  [3564] = {.lex_state = 247},
  [3565] = {.lex_state = 247},
  [3566] = {.lex_state = 247},
  [3567] = {.lex_state = 247},
  [3568] = {.lex_state = 247},
  [3569] = {.lex_state = 247},
  [3570] = {.lex_state = 247},
  [3571] = {.lex_state = 247},
  [3572] = {.lex_state = 247},
  [3573] = {.lex_state = 247},
  [3574] = {.lex_state = 247},
  [3575] = {.lex_state = 247},
  [3576] = {.lex_state = 247},
  [3577] = {.lex_state = 247},
  [3578] = {.lex_state = 247},
  [3579] = {.lex_state = 247},
  [3580] = {.lex_state = 247},
  [3581] = {.lex_state = 247},
  [3582] = {.lex_state = 247},
  [3583] = {.lex_state = 247},
  [3584] = {.lex_state = 247},
  [3585] = {.lex_state = 247},
  [3586] = {.lex_state = 247},
  [3587] = {.lex_state = 247},
  [3588] = {.lex_state = 247},
  [3589] = {.lex_state = 247},
  [3590] = {.lex_state = 247},
  [3591] = {.lex_state = 247},
  [3592] = {.lex_state = 247},
  [3593] = {.lex_state = 247},
  [3594] = {.lex_state = 247},
  [3595] = {.lex_state = 247},
  [3596] = {.lex_state = 247},
  [3597] = {.lex_state = 247},
  [3598] = {.lex_state = 247},
  [3599] = {.lex_state = 247},
  [3600] = {.lex_state = 247},
  [3601] = {.lex_state = 247},
  [3602] = {.lex_state = 247},
  [3603] = {.lex_state = 247},
  [3604] = {.lex_state = 247},
  [3605] = {.lex_state = 247},
  [3606] = {.lex_state = 247},
  [3607] = {.lex_state = 247},
  [3608] = {.lex_state = 247},
  [3609] = {.lex_state = 247},
  [3610] = {.lex_state = 247},
  [3611] = {.lex_state = 247},
  [3612] = {.lex_state = 247},
  [3613] = {.lex_state = 247},
  [3614] = {.lex_state = 247},
  [3615] = {.lex_state = 247},
  [3616] = {.lex_state = 247},
  [3617] = {.lex_state = 247},
  [3618] = {.lex_state = 247},
  [3619] = {.lex_state = 247},
  [3620] = {.lex_state = 247},
  [3621] = {.lex_state = 247},
  [3622] = {.lex_state = 247},
  [3623] = {.lex_state = 247},
  [3624] = {.lex_state = 247},
  [3625] = {.lex_state = 247},
  [3626] = {.lex_state = 247},
  [3627] = {.lex_state = 247},
  [3628] = {.lex_state = 247},
  [3629] = {.lex_state = 247},
  [3630] = {.lex_state = 247},
  [3631] = {.lex_state = 247},
  [3632] = {.lex_state = 247},
  [3633] = {.lex_state = 247},
  [3634] = {.lex_state = 247},
  [3635] = {.lex_state = 247},
  [3636] = {.lex_state = 247},
  [3637] = {.lex_state = 247},
  [3638] = {.lex_state = 247},
  [3639] = {.lex_state = 247},
  [3640] = {.lex_state = 247},
  [3641] = {.lex_state = 247},
  [3642] = {.lex_state = 247},
  [3643] = {.lex_state = 247},
  [3644] = {.lex_state = 247},
  [3645] = {.lex_state = 247},
  [3646] = {.lex_state = 247},
  [3647] = {.lex_state = 247},
  [3648] = {.lex_state = 247},
  [3649] = {.lex_state = 247},
  [3650] = {.lex_state = 247},
  [3651] = {.lex_state = 34},
  [3652] = {.lex_state = 247},
  [3653] = {.lex_state = 34},
  [3654] = {.lex_state = 247},
  [3655] = {.lex_state = 247},
  [3656] = {.lex_state = 247},
  [3657] = {.lex_state = 247},
  [3658] = {.lex_state = 34},
  [3659] = {.lex_state = 247},
  [3660] = {.lex_state = 247},
  [3661] = {.lex_state = 247},
  [3662] = {.lex_state = 247},
  [3663] = {.lex_state = 247},
  [3664] = {.lex_state = 247},
  [3665] = {.lex_state = 247},
  [3666] = {.lex_state = 247},
  [3667] = {.lex_state = 247},
  [3668] = {.lex_state = 247},
  [3669] = {.lex_state = 247},
  [3670] = {.lex_state = 247},
  [3671] = {.lex_state = 247},
  [3672] = {.lex_state = 247},
  [3673] = {.lex_state = 247},
  [3674] = {.lex_state = 247},
  [3675] = {.lex_state = 247},
  [3676] = {.lex_state = 247},
  [3677] = {.lex_state = 247},
  [3678] = {.lex_state = 247},
  [3679] = {.lex_state = 247},
  [3680] = {.lex_state = 247},
  [3681] = {.lex_state = 247},
  [3682] = {.lex_state = 34},
  [3683] = {.lex_state = 247},
  [3684] = {.lex_state = 247},
  [3685] = {.lex_state = 247},
  [3686] = {.lex_state = 247},
  [3687] = {.lex_state = 247},
  [3688] = {.lex_state = 247},
  [3689] = {.lex_state = 247},
  [3690] = {.lex_state = 247},
  [3691] = {.lex_state = 247},
  [3692] = {.lex_state = 247},
  [3693] = {.lex_state = 247},
  [3694] = {.lex_state = 247},
  [3695] = {.lex_state = 247},
  [3696] = {.lex_state = 247},
  [3697] = {.lex_state = 247},
  [3698] = {.lex_state = 247},
  [3699] = {.lex_state = 247},
  [3700] = {.lex_state = 247},
  [3701] = {.lex_state = 247},
  [3702] = {.lex_state = 247},
  [3703] = {.lex_state = 247},
  [3704] = {.lex_state = 247},
  [3705] = {.lex_state = 34},
  [3706] = {.lex_state = 247},
  [3707] = {.lex_state = 247},
  [3708] = {.lex_state = 247},
  [3709] = {.lex_state = 247},
  [3710] = {.lex_state = 247},
  [3711] = {.lex_state = 247},
  [3712] = {.lex_state = 34},
  [3713] = {.lex_state = 247},
  [3714] = {.lex_state = 247},
  [3715] = {.lex_state = 247},
  [3716] = {.lex_state = 247},
  [3717] = {.lex_state = 247},
  [3718] = {.lex_state = 34},
  [3719] = {.lex_state = 247},
  [3720] = {.lex_state = 247},
  [3721] = {.lex_state = 247},
  [3722] = {.lex_state = 247},
  [3723] = {.lex_state = 247},
  [3724] = {.lex_state = 247},
  [3725] = {.lex_state = 247},
  [3726] = {.lex_state = 247},
  [3727] = {.lex_state = 247},
  [3728] = {.lex_state = 247},
  [3729] = {.lex_state = 247},
  [3730] = {.lex_state = 247},
  [3731] = {.lex_state = 247},
  [3732] = {.lex_state = 247},
  [3733] = {.lex_state = 247},
  [3734] = {.lex_state = 247},
  [3735] = {.lex_state = 247},
  [3736] = {.lex_state = 34},
  [3737] = {.lex_state = 247},
  [3738] = {.lex_state = 247},
  [3739] = {.lex_state = 247},
  [3740] = {.lex_state = 247},
  [3741] = {.lex_state = 247},
  [3742] = {.lex_state = 247},
  [3743] = {.lex_state = 247},
  [3744] = {.lex_state = 247},
  [3745] = {.lex_state = 247},
  [3746] = {.lex_state = 247},
  [3747] = {.lex_state = 247},
  [3748] = {.lex_state = 247},
  [3749] = {.lex_state = 247},
  [3750] = {.lex_state = 247},
  [3751] = {.lex_state = 247},
  [3752] = {.lex_state = 247},
  [3753] = {.lex_state = 247},
  [3754] = {.lex_state = 247},
  [3755] = {.lex_state = 247},
  [3756] = {.lex_state = 247},
  [3757] = {.lex_state = 247},
  [3758] = {.lex_state = 247},
  [3759] = {.lex_state = 34},
  [3760] = {.lex_state = 247},
  [3761] = {.lex_state = 247},
  [3762] = {.lex_state = 247},
  [3763] = {.lex_state = 247},
  [3764] = {.lex_state = 247},
  [3765] = {.lex_state = 247},
  [3766] = {.lex_state = 247},
  [3767] = {.lex_state = 247},
  [3768] = {.lex_state = 34},
  [3769] = {.lex_state = 247},
  [3770] = {.lex_state = 247},
  [3771] = {.lex_state = 247},
  [3772] = {.lex_state = 247},
  [3773] = {.lex_state = 247},
  [3774] = {.lex_state = 247},
  [3775] = {.lex_state = 247},
  [3776] = {.lex_state = 247},
  [3777] = {.lex_state = 247},
  [3778] = {.lex_state = 247},
  [3779] = {.lex_state = 247},
  [3780] = {.lex_state = 247},
  [3781] = {.lex_state = 247},
  [3782] = {.lex_state = 247},
  [3783] = {.lex_state = 247},
  [3784] = {.lex_state = 247},
  [3785] = {.lex_state = 247},
  [3786] = {.lex_state = 247},
  [3787] = {.lex_state = 247},
  [3788] = {.lex_state = 247},
  [3789] = {.lex_state = 247},
  [3790] = {.lex_state = 247},
  [3791] = {.lex_state = 247},
  [3792] = {.lex_state = 247},
  [3793] = {.lex_state = 247},
  [3794] = {.lex_state = 247},
  [3795] = {.lex_state = 247},
  [3796] = {.lex_state = 247},
  [3797] = {.lex_state = 247},
  [3798] = {.lex_state = 247},
  [3799] = {.lex_state = 247},
  [3800] = {.lex_state = 247},
  [3801] = {.lex_state = 247},
  [3802] = {.lex_state = 247},
  [3803] = {.lex_state = 247},
  [3804] = {.lex_state = 247},
  [3805] = {.lex_state = 247},
  [3806] = {.lex_state = 247},
  [3807] = {.lex_state = 247},
  [3808] = {.lex_state = 247},
  [3809] = {.lex_state = 247},
  [3810] = {.lex_state = 247},
  [3811] = {.lex_state = 247},
  [3812] = {.lex_state = 247},
  [3813] = {.lex_state = 247},
  [3814] = {.lex_state = 247},
  [3815] = {.lex_state = 247},
  [3816] = {.lex_state = 247},
  [3817] = {.lex_state = 247},
  [3818] = {.lex_state = 247},
  [3819] = {.lex_state = 247},
  [3820] = {.lex_state = 247},
  [3821] = {.lex_state = 247},
  [3822] = {.lex_state = 247},
  [3823] = {.lex_state = 247},
  [3824] = {.lex_state = 247},
  [3825] = {.lex_state = 247},
  [3826] = {.lex_state = 247},
  [3827] = {.lex_state = 247},
  [3828] = {.lex_state = 247},
  [3829] = {.lex_state = 247},
  [3830] = {.lex_state = 247},
  [3831] = {.lex_state = 247},
  [3832] = {.lex_state = 247},
  [3833] = {.lex_state = 247},
  [3834] = {.lex_state = 247},
  [3835] = {.lex_state = 247},
  [3836] = {.lex_state = 247},
  [3837] = {.lex_state = 247},
  [3838] = {.lex_state = 247},
  [3839] = {.lex_state = 247},
  [3840] = {.lex_state = 247},
  [3841] = {.lex_state = 247},
  [3842] = {.lex_state = 247},
  [3843] = {.lex_state = 247},
  [3844] = {.lex_state = 247},
  [3845] = {.lex_state = 247},
  [3846] = {.lex_state = 247},
  [3847] = {.lex_state = 247},
  [3848] = {.lex_state = 247},
  [3849] = {.lex_state = 247},
  [3850] = {.lex_state = 247},
  [3851] = {.lex_state = 247},
  [3852] = {.lex_state = 247},
  [3853] = {.lex_state = 247},
  [3854] = {.lex_state = 247},
  [3855] = {.lex_state = 247},
  [3856] = {.lex_state = 247},
  [3857] = {.lex_state = 247},
  [3858] = {.lex_state = 247},
  [3859] = {.lex_state = 247},
  [3860] = {.lex_state = 247},
  [3861] = {.lex_state = 247},
  [3862] = {.lex_state = 247},
  [3863] = {.lex_state = 247},
  [3864] = {.lex_state = 247},
  [3865] = {.lex_state = 247},
  [3866] = {.lex_state = 247},
  [3867] = {.lex_state = 247},
  [3868] = {.lex_state = 247},
  [3869] = {.lex_state = 247},
  [3870] = {.lex_state = 247},
  [3871] = {.lex_state = 247},
  [3872] = {.lex_state = 247},
  [3873] = {.lex_state = 247},
  [3874] = {.lex_state = 247},
  [3875] = {.lex_state = 247},
  [3876] = {.lex_state = 247},
  [3877] = {.lex_state = 247},
  [3878] = {.lex_state = 247},
  [3879] = {.lex_state = 247},
  [3880] = {.lex_state = 247},
  [3881] = {.lex_state = 247},
  [3882] = {.lex_state = 247},
  [3883] = {.lex_state = 247},
  [3884] = {.lex_state = 247},
  [3885] = {.lex_state = 247},
  [3886] = {.lex_state = 247},
  [3887] = {.lex_state = 247},
  [3888] = {.lex_state = 21},
  [3889] = {.lex_state = 247},
  [3890] = {.lex_state = 21},
  [3891] = {.lex_state = 247},
  [3892] = {.lex_state = 247},
  [3893] = {.lex_state = 247},
  [3894] = {.lex_state = 247},
  [3895] = {.lex_state = 247},
  [3896] = {.lex_state = 247},
  [3897] = {.lex_state = 247},
  [3898] = {.lex_state = 247},
  [3899] = {.lex_state = 247},
  [3900] = {.lex_state = 21},
  [3901] = {.lex_state = 247},
  [3902] = {.lex_state = 247},
  [3903] = {.lex_state = 247},
  [3904] = {.lex_state = 247},
  [3905] = {.lex_state = 247},
  [3906] = {.lex_state = 247},
  [3907] = {.lex_state = 247},
  [3908] = {.lex_state = 247},
  [3909] = {.lex_state = 247},
  [3910] = {.lex_state = 247},
  [3911] = {.lex_state = 247},
  [3912] = {.lex_state = 247},
  [3913] = {.lex_state = 247},
  [3914] = {.lex_state = 247},
  [3915] = {.lex_state = 247},
  [3916] = {.lex_state = 247},
  [3917] = {.lex_state = 1},
  [3918] = {.lex_state = 247},
  [3919] = {.lex_state = 247},
  [3920] = {.lex_state = 247},
  [3921] = {.lex_state = 247},
  [3922] = {.lex_state = 21},
  [3923] = {.lex_state = 247},
  [3924] = {.lex_state = 247},
  [3925] = {.lex_state = 247},
  [3926] = {.lex_state = 21},
  [3927] = {.lex_state = 247},
  [3928] = {.lex_state = 247},
  [3929] = {.lex_state = 247},
  [3930] = {.lex_state = 247},
  [3931] = {.lex_state = 21},
  [3932] = {.lex_state = 247},
  [3933] = {.lex_state = 247},
  [3934] = {.lex_state = 247},
  [3935] = {.lex_state = 247},
  [3936] = {.lex_state = 247},
  [3937] = {.lex_state = 247},
  [3938] = {.lex_state = 21},
  [3939] = {.lex_state = 247},
  [3940] = {.lex_state = 247},
  [3941] = {.lex_state = 247},
  [3942] = {.lex_state = 247},
  [3943] = {.lex_state = 21},
  [3944] = {.lex_state = 247},
  [3945] = {.lex_state = 21},
  [3946] = {.lex_state = 21},
  [3947] = {.lex_state = 247},
  [3948] = {.lex_state = 247},
  [3949] = {.lex_state = 247},
  [3950] = {.lex_state = 247},
  [3951] = {.lex_state = 247},
  [3952] = {.lex_state = 247},
  [3953] = {.lex_state = 21},
  [3954] = {.lex_state = 247},
  [3955] = {.lex_state = 247},
  [3956] = {.lex_state = 247},
  [3957] = {.lex_state = 247},
  [3958] = {.lex_state = 21},
  [3959] = {.lex_state = 247},
  [3960] = {.lex_state = 21},
  [3961] = {.lex_state = 247},
  [3962] = {.lex_state = 247},
  [3963] = {.lex_state = 21},
  [3964] = {.lex_state = 247},
  [3965] = {.lex_state = 21},
  [3966] = {.lex_state = 247},
  [3967] = {.lex_state = 247},
  [3968] = {.lex_state = 247},
  [3969] = {.lex_state = 247},
  [3970] = {.lex_state = 247},
  [3971] = {.lex_state = 247},
  [3972] = {.lex_state = 247},
  [3973] = {.lex_state = 247},
  [3974] = {.lex_state = 247},
  [3975] = {.lex_state = 247},
  [3976] = {.lex_state = 247},
  [3977] = {.lex_state = 247},
  [3978] = {.lex_state = 21},
  [3979] = {.lex_state = 247},
  [3980] = {.lex_state = 247},
  [3981] = {.lex_state = 247},
  [3982] = {.lex_state = 21},
  [3983] = {.lex_state = 21},
  [3984] = {.lex_state = 21},
  [3985] = {.lex_state = 247},
  [3986] = {.lex_state = 247},
  [3987] = {.lex_state = 247},
  [3988] = {.lex_state = 247},
  [3989] = {.lex_state = 247},
  [3990] = {.lex_state = 21},
  [3991] = {.lex_state = 247},
  [3992] = {.lex_state = 247},
  [3993] = {.lex_state = 247},
  [3994] = {.lex_state = 21},
  [3995] = {.lex_state = 247},
  [3996] = {.lex_state = 247},
  [3997] = {.lex_state = 247},
  [3998] = {.lex_state = 247},
  [3999] = {.lex_state = 35},
  [4000] = {.lex_state = 31},
  [4001] = {.lex_state = 35},
  [4002] = {.lex_state = 33},
  [4003] = {.lex_state = 35},
  [4004] = {.lex_state = 35},
  [4005] = {.lex_state = 35},
  [4006] = {.lex_state = 35},
  [4007] = {.lex_state = 35},
  [4008] = {.lex_state = 35},
  [4009] = {.lex_state = 31},
  [4010] = {.lex_state = 35},
  [4011] = {.lex_state = 35},
  [4012] = {.lex_state = 31},
  [4013] = {.lex_state = 21},
  [4014] = {.lex_state = 21},
  [4015] = {.lex_state = 21},
  [4016] = {.lex_state = 21},
  [4017] = {.lex_state = 21},
  [4018] = {.lex_state = 21},
  [4019] = {.lex_state = 21},
  [4020] = {.lex_state = 21},
  [4021] = {.lex_state = 21},
  [4022] = {.lex_state = 32},
  [4023] = {.lex_state = 32},
  [4024] = {.lex_state = 32},
  [4025] = {.lex_state = 32},
  [4026] = {.lex_state = 32},
  [4027] = {.lex_state = 32},
  [4028] = {.lex_state = 32},
  [4029] = {.lex_state = 32},
  [4030] = {.lex_state = 32},
  [4031] = {.lex_state = 32},
  [4032] = {.lex_state = 32},
  [4033] = {.lex_state = 32},
  [4034] = {.lex_state = 32},
  [4035] = {.lex_state = 32},
  [4036] = {.lex_state = 32},
  [4037] = {.lex_state = 32},
  [4038] = {.lex_state = 32},
  [4039] = {.lex_state = 32},
  [4040] = {.lex_state = 32},
  [4041] = {.lex_state = 32},
  [4042] = {.lex_state = 32},
  [4043] = {.lex_state = 22},
  [4044] = {.lex_state = 32},
  [4045] = {.lex_state = 32},
  [4046] = {.lex_state = 32},
  [4047] = {.lex_state = 32},
  [4048] = {.lex_state = 32},
  [4049] = {.lex_state = 32},
  [4050] = {.lex_state = 32},
  [4051] = {.lex_state = 32},
  [4052] = {.lex_state = 32},
  [4053] = {.lex_state = 32},
  [4054] = {.lex_state = 32},
  [4055] = {.lex_state = 32},
  [4056] = {.lex_state = 32},
  [4057] = {.lex_state = 32},
  [4058] = {.lex_state = 32},
  [4059] = {.lex_state = 32},
  [4060] = {.lex_state = 32},
  [4061] = {.lex_state = 32},
  [4062] = {.lex_state = 32},
  [4063] = {.lex_state = 32},
  [4064] = {.lex_state = 247},
  [4065] = {.lex_state = 32},
  [4066] = {.lex_state = 32},
  [4067] = {.lex_state = 32},
  [4068] = {.lex_state = 32},
  [4069] = {.lex_state = 32},
  [4070] = {.lex_state = 32},
  [4071] = {.lex_state = 32},
  [4072] = {.lex_state = 32},
  [4073] = {.lex_state = 32},
  [4074] = {.lex_state = 32},
  [4075] = {.lex_state = 32},
  [4076] = {.lex_state = 32},
  [4077] = {.lex_state = 32},
  [4078] = {.lex_state = 32},
  [4079] = {.lex_state = 32},
  [4080] = {.lex_state = 32},
  [4081] = {.lex_state = 32},
  [4082] = {.lex_state = 32},
  [4083] = {.lex_state = 32},
  [4084] = {.lex_state = 32},
  [4085] = {.lex_state = 32},
  [4086] = {.lex_state = 32},
  [4087] = {.lex_state = 32},
  [4088] = {.lex_state = 32},
  [4089] = {.lex_state = 32},
  [4090] = {.lex_state = 32},
  [4091] = {.lex_state = 32},
  [4092] = {.lex_state = 32},
  [4093] = {.lex_state = 31},
  [4094] = {.lex_state = 32},
  [4095] = {.lex_state = 32},
  [4096] = {.lex_state = 32},
  [4097] = {.lex_state = 20},
  [4098] = {.lex_state = 20},
  [4099] = {.lex_state = 20},
  [4100] = {.lex_state = 20},
  [4101] = {.lex_state = 20},
  [4102] = {.lex_state = 20},
  [4103] = {.lex_state = 20},
  [4104] = {.lex_state = 20},
  [4105] = {.lex_state = 20},
  [4106] = {.lex_state = 20},
  [4107] = {.lex_state = 20},
  [4108] = {.lex_state = 20},
  [4109] = {.lex_state = 20},
  [4110] = {.lex_state = 20},
  [4111] = {.lex_state = 20},
  [4112] = {.lex_state = 247},
  [4113] = {.lex_state = 20},
  [4114] = {.lex_state = 20},
  [4115] = {.lex_state = 20},
  [4116] = {.lex_state = 20},
  [4117] = {.lex_state = 20},
  [4118] = {.lex_state = 20},
  [4119] = {.lex_state = 22},
  [4120] = {.lex_state = 247},
  [4121] = {.lex_state = 247},
  [4122] = {.lex_state = 25},
  [4123] = {.lex_state = 247},
  [4124] = {.lex_state = 247},
  [4125] = {.lex_state = 22},
  [4126] = {.lex_state = 247},
  [4127] = {.lex_state = 247},
  [4128] = {.lex_state = 247},
  [4129] = {.lex_state = 247},
  [4130] = {.lex_state = 247},
  [4131] = {.lex_state = 247},
  [4132] = {.lex_state = 247},
  [4133] = {.lex_state = 247},
  [4134] = {.lex_state = 247},
  [4135] = {.lex_state = 36},
  [4136] = {.lex_state = 25},
  [4137] = {.lex_state = 22},
  [4138] = {.lex_state = 25},
  [4139] = {.lex_state = 22},
  [4140] = {.lex_state = 247},
  [4141] = {.lex_state = 247},
  [4142] = {.lex_state = 22},
  [4143] = {.lex_state = 25},
  [4144] = {.lex_state = 247},
  [4145] = {.lex_state = 247},
  [4146] = {.lex_state = 25},
  [4147] = {.lex_state = 22},
  [4148] = {.lex_state = 25},
  [4149] = {.lex_state = 247},
  [4150] = {.lex_state = 247},
  [4151] = {.lex_state = 22},
  [4152] = {.lex_state = 25},
  [4153] = {.lex_state = 22},
  [4154] = {.lex_state = 247},
  [4155] = {.lex_state = 247},
  [4156] = {.lex_state = 247},
  [4157] = {.lex_state = 22},
  [4158] = {.lex_state = 25},
  [4159] = {.lex_state = 22},
  [4160] = {.lex_state = 247},
  [4161] = {.lex_state = 247},
  [4162] = {.lex_state = 22},
  [4163] = {.lex_state = 247},
  [4164] = {.lex_state = 247},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_POUND_] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [aux_sym_num_lit_token2] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [aux_sym_str_lit_token1] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_POUND_CARET] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_POUND_QMARK] = ACTIONS(1),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [sym_block_comment] = ACTIONS(3),
    [aux_sym__format_token_token1] = ACTIONS(1),
    [anon_sym_v] = ACTIONS(1),
    [anon_sym_V] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [aux_sym_format_directive_type_token1] = ACTIONS(1),
    [aux_sym_format_directive_type_token2] = ACTIONS(1),
    [anon_sym_LF] = ACTIONS(1),
    [anon_sym_CR] = ACTIONS(1),
    [aux_sym_format_directive_type_token3] = ACTIONS(1),
    [aux_sym_format_directive_type_token4] = ACTIONS(1),
    [aux_sym_format_directive_type_token5] = ACTIONS(1),
    [aux_sym_format_directive_type_token6] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [aux_sym_format_directive_type_token7] = ACTIONS(1),
    [aux_sym_format_directive_type_token8] = ACTIONS(1),
    [aux_sym_format_directive_type_token9] = ACTIONS(1),
    [aux_sym_format_directive_type_token10] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [aux_sym_format_directive_type_token11] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_POUNDP] = ACTIONS(1),
    [anon_sym_POUNDp] = ACTIONS(1),
    [aux_sym__sym_lit_without_slash_token1] = ACTIONS(1),
    [anon_sym_POUNDC] = ACTIONS(1),
    [anon_sym_POUNDc] = ACTIONS(1),
  },
  [1] = {
    [sym_source] = STATE(4129),
    [sym__gap] = STATE(296),
    [sym_dis_expr] = STATE(296),
    [sym__form] = STATE(2013),
    [sym_num_lit] = STATE(2013),
    [sym_kwd_lit] = STATE(2013),
    [sym_str_lit] = STATE(2013),
    [sym_char_lit] = STATE(2013),
    [sym_sym_lit] = STATE(1771),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2013),
    [sym__bare_list_lit] = STATE(1790),
    [sym_vec_lit] = STATE(2013),
    [sym_set_lit] = STATE(2013),
    [sym__bare_set_lit] = STATE(1801),
    [sym_read_cond_lit] = STATE(2013),
    [sym_splicing_read_cond_lit] = STATE(2013),
    [sym_var_quoting_lit] = STATE(2013),
    [sym_quoting_lit] = STATE(2013),
    [sym_syn_quoting_lit] = STATE(2013),
    [sym_unquote_splicing_lit] = STATE(2013),
    [sym_unquoting_lit] = STATE(2013),
    [sym_defun] = STATE(1790),
    [sym_loop_macro] = STATE(1790),
    [sym_path_lit] = STATE(2013),
    [sym_package_lit] = STATE(2013),
    [sym_include_reader_macro] = STATE(2013),
    [sym_complex_num_lit] = STATE(2013),
    [aux_sym_source_repeat1] = STATE(296),
    [aux_sym_list_lit_repeat1] = STATE(2817),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym__ws] = ACTIONS(7),
    [sym_comment] = ACTIONS(7),
    [anon_sym_POUND_] = ACTIONS(9),
    [anon_sym_POUND] = ACTIONS(11),
    [anon_sym_DOT] = ACTIONS(13),
    [aux_sym_num_lit_token1] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(17),
    [anon_sym_COLON_COLON] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(21),
    [sym_nil_lit] = ACTIONS(13),
    [aux_sym_sym_lit_token1] = ACTIONS(23),
    [anon_sym_CARET] = ACTIONS(25),
    [anon_sym_POUND_CARET] = ACTIONS(27),
    [anon_sym_LPAREN] = ACTIONS(29),
    [anon_sym_POUND0A] = ACTIONS(31),
    [anon_sym_POUND0a] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_COMMA_AT] = ACTIONS(43),
    [anon_sym_COMMA] = ACTIONS(45),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(13),
    [anon_sym_cl] = ACTIONS(49),
    [anon_sym_POUNDP] = ACTIONS(51),
    [anon_sym_POUNDp] = ACTIONS(51),
    [sym_self_referential_reader_macro] = ACTIONS(53),
    [anon_sym_POUND_PLUS] = ACTIONS(55),
    [anon_sym_POUND_DASH] = ACTIONS(55),
    [anon_sym_POUNDC] = ACTIONS(57),
    [anon_sym_POUNDc] = ACTIONS(57),
  },
  [2] = {
    [sym__gap] = STATE(990),
    [sym_dis_expr] = STATE(990),
    [sym__form] = STATE(39),
    [sym_num_lit] = STATE(39),
    [sym_kwd_lit] = STATE(39),
    [sym_str_lit] = STATE(39),
    [sym_char_lit] = STATE(39),
    [sym_sym_lit] = STATE(1101),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(39),
    [sym__bare_list_lit] = STATE(1109),
    [sym_vec_lit] = STATE(39),
    [sym_set_lit] = STATE(39),
    [sym__bare_set_lit] = STATE(1117),
    [sym_read_cond_lit] = STATE(39),
    [sym_splicing_read_cond_lit] = STATE(39),
    [sym_var_quoting_lit] = STATE(39),
    [sym_quoting_lit] = STATE(39),
    [sym_syn_quoting_lit] = STATE(39),
    [sym_unquote_splicing_lit] = STATE(39),
    [sym_unquoting_lit] = STATE(39),
    [sym_defun] = STATE(1109),
    [sym_loop_macro] = STATE(1109),
    [sym_path_lit] = STATE(39),
    [sym_package_lit] = STATE(39),
    [sym_include_reader_macro] = STATE(39),
    [sym_complex_num_lit] = STATE(39),
    [aux_sym_dis_expr_repeat1] = STATE(990),
    [aux_sym_list_lit_repeat1] = STATE(2812),
    [sym__ws] = ACTIONS(59),
    [sym_comment] = ACTIONS(59),
    [anon_sym_POUND_] = ACTIONS(62),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(67),
    [aux_sym_num_lit_token1] = ACTIONS(69),
    [anon_sym_COLON] = ACTIONS(71),
    [anon_sym_COLON_COLON] = ACTIONS(74),
    [anon_sym_DQUOTE] = ACTIONS(76),
    [sym_nil_lit] = ACTIONS(67),
    [aux_sym_sym_lit_token1] = ACTIONS(78),
    [anon_sym_CARET] = ACTIONS(80),
    [anon_sym_POUND_CARET] = ACTIONS(83),
    [anon_sym_LPAREN] = ACTIONS(86),
    [anon_sym_RPAREN] = ACTIONS(89),
    [anon_sym_POUND0A] = ACTIONS(91),
    [anon_sym_POUND0a] = ACTIONS(91),
    [anon_sym_POUND_QMARK] = ACTIONS(93),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(95),
    [anon_sym_POUND_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_BQUOTE] = ACTIONS(101),
    [anon_sym_COMMA_AT] = ACTIONS(103),
    [anon_sym_COMMA] = ACTIONS(105),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(67),
    [anon_sym_cl] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(110),
    [aux_sym_accumulation_verb_token1] = ACTIONS(112),
    [anon_sym_for] = ACTIONS(112),
    [anon_sym_and] = ACTIONS(112),
    [anon_sym_as] = ACTIONS(112),
    [anon_sym_with] = ACTIONS(112),
    [anon_sym_do] = ACTIONS(112),
    [anon_sym_while] = ACTIONS(112),
    [anon_sym_until] = ACTIONS(112),
    [anon_sym_repeat] = ACTIONS(112),
    [anon_sym_when] = ACTIONS(112),
    [anon_sym_if] = ACTIONS(112),
    [anon_sym_unless] = ACTIONS(112),
    [anon_sym_always] = ACTIONS(112),
    [anon_sym_thereis] = ACTIONS(112),
    [anon_sym_never] = ACTIONS(112),
    [anon_sym_else] = ACTIONS(112),
    [anon_sym_finally] = ACTIONS(112),
    [anon_sym_return] = ACTIONS(112),
    [anon_sym_initially] = ACTIONS(112),
    [anon_sym_POUNDP] = ACTIONS(114),
    [anon_sym_POUNDp] = ACTIONS(114),
    [sym_self_referential_reader_macro] = ACTIONS(116),
    [anon_sym_POUND_PLUS] = ACTIONS(118),
    [anon_sym_POUND_DASH] = ACTIONS(118),
    [anon_sym_POUNDC] = ACTIONS(120),
    [anon_sym_POUNDc] = ACTIONS(120),
  },
  [3] = {
    [sym__gap] = STATE(896),
    [sym_dis_expr] = STATE(896),
    [sym__form] = STATE(995),
    [sym_num_lit] = STATE(995),
    [sym_kwd_lit] = STATE(995),
    [sym_str_lit] = STATE(995),
    [sym_char_lit] = STATE(995),
    [sym_sym_lit] = STATE(1136),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(995),
    [sym__bare_list_lit] = STATE(1137),
    [sym_vec_lit] = STATE(995),
    [sym_set_lit] = STATE(995),
    [sym__bare_set_lit] = STATE(1138),
    [sym_read_cond_lit] = STATE(995),
    [sym_splicing_read_cond_lit] = STATE(995),
    [sym_var_quoting_lit] = STATE(995),
    [sym_quoting_lit] = STATE(995),
    [sym_syn_quoting_lit] = STATE(995),
    [sym_unquote_splicing_lit] = STATE(995),
    [sym_unquoting_lit] = STATE(995),
    [sym_defun] = STATE(1137),
    [sym_loop_macro] = STATE(1137),
    [sym_path_lit] = STATE(995),
    [sym_package_lit] = STATE(995),
    [sym_include_reader_macro] = STATE(995),
    [sym_complex_num_lit] = STATE(995),
    [aux_sym_dis_expr_repeat1] = STATE(896),
    [aux_sym_list_lit_repeat1] = STATE(2804),
    [aux_sym_do_clause_repeat1] = STATE(8),
    [sym__ws] = ACTIONS(122),
    [sym_comment] = ACTIONS(122),
    [anon_sym_POUND_] = ACTIONS(122),
    [anon_sym_POUND] = ACTIONS(124),
    [anon_sym_DOT] = ACTIONS(126),
    [aux_sym_num_lit_token1] = ACTIONS(128),
    [anon_sym_COLON] = ACTIONS(130),
    [anon_sym_COLON_COLON] = ACTIONS(132),
    [anon_sym_DQUOTE] = ACTIONS(134),
    [sym_nil_lit] = ACTIONS(126),
    [aux_sym_sym_lit_token1] = ACTIONS(136),
    [anon_sym_CARET] = ACTIONS(122),
    [anon_sym_POUND_CARET] = ACTIONS(122),
    [anon_sym_LPAREN] = ACTIONS(122),
    [anon_sym_RPAREN] = ACTIONS(122),
    [anon_sym_POUND0A] = ACTIONS(138),
    [anon_sym_POUND0a] = ACTIONS(138),
    [anon_sym_POUND_QMARK] = ACTIONS(140),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(142),
    [anon_sym_POUND_SQUOTE] = ACTIONS(144),
    [anon_sym_SQUOTE] = ACTIONS(146),
    [anon_sym_BQUOTE] = ACTIONS(148),
    [anon_sym_COMMA_AT] = ACTIONS(150),
    [anon_sym_COMMA] = ACTIONS(152),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(126),
    [anon_sym_cl] = ACTIONS(130),
    [aux_sym_accumulation_verb_token1] = ACTIONS(130),
    [anon_sym_for] = ACTIONS(130),
    [anon_sym_and] = ACTIONS(130),
    [anon_sym_as] = ACTIONS(130),
    [anon_sym_with] = ACTIONS(130),
    [anon_sym_do] = ACTIONS(130),
    [anon_sym_while] = ACTIONS(130),
    [anon_sym_until] = ACTIONS(130),
    [anon_sym_repeat] = ACTIONS(130),
    [anon_sym_when] = ACTIONS(130),
    [anon_sym_if] = ACTIONS(130),
    [anon_sym_unless] = ACTIONS(130),
    [anon_sym_always] = ACTIONS(130),
    [anon_sym_thereis] = ACTIONS(130),
    [anon_sym_never] = ACTIONS(130),
    [anon_sym_else] = ACTIONS(130),
    [anon_sym_finally] = ACTIONS(130),
    [anon_sym_return] = ACTIONS(130),
    [anon_sym_initially] = ACTIONS(130),
    [anon_sym_POUNDP] = ACTIONS(154),
    [anon_sym_POUNDp] = ACTIONS(154),
    [sym_self_referential_reader_macro] = ACTIONS(156),
    [anon_sym_POUND_PLUS] = ACTIONS(158),
    [anon_sym_POUND_DASH] = ACTIONS(158),
    [anon_sym_POUNDC] = ACTIONS(160),
    [anon_sym_POUNDc] = ACTIONS(160),
  },
  [4] = {
    [sym__gap] = STATE(896),
    [sym_dis_expr] = STATE(896),
    [sym__form] = STATE(995),
    [sym_num_lit] = STATE(995),
    [sym_kwd_lit] = STATE(995),
    [sym_str_lit] = STATE(995),
    [sym_char_lit] = STATE(995),
    [sym_sym_lit] = STATE(1136),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(995),
    [sym__bare_list_lit] = STATE(1137),
    [sym_vec_lit] = STATE(995),
    [sym_set_lit] = STATE(995),
    [sym__bare_set_lit] = STATE(1138),
    [sym_read_cond_lit] = STATE(995),
    [sym_splicing_read_cond_lit] = STATE(995),
    [sym_var_quoting_lit] = STATE(995),
    [sym_quoting_lit] = STATE(995),
    [sym_syn_quoting_lit] = STATE(995),
    [sym_unquote_splicing_lit] = STATE(995),
    [sym_unquoting_lit] = STATE(995),
    [sym_defun] = STATE(1137),
    [sym_loop_macro] = STATE(1137),
    [sym_path_lit] = STATE(995),
    [sym_package_lit] = STATE(995),
    [sym_include_reader_macro] = STATE(995),
    [sym_complex_num_lit] = STATE(995),
    [aux_sym_dis_expr_repeat1] = STATE(896),
    [aux_sym_list_lit_repeat1] = STATE(2804),
    [aux_sym_do_clause_repeat1] = STATE(8),
    [sym__ws] = ACTIONS(162),
    [sym_comment] = ACTIONS(162),
    [anon_sym_POUND_] = ACTIONS(162),
    [anon_sym_POUND] = ACTIONS(124),
    [anon_sym_DOT] = ACTIONS(126),
    [aux_sym_num_lit_token1] = ACTIONS(128),
    [anon_sym_COLON] = ACTIONS(164),
    [anon_sym_COLON_COLON] = ACTIONS(132),
    [anon_sym_DQUOTE] = ACTIONS(134),
    [sym_nil_lit] = ACTIONS(126),
    [aux_sym_sym_lit_token1] = ACTIONS(136),
    [anon_sym_CARET] = ACTIONS(162),
    [anon_sym_POUND_CARET] = ACTIONS(162),
    [anon_sym_LPAREN] = ACTIONS(162),
    [anon_sym_RPAREN] = ACTIONS(162),
    [anon_sym_POUND0A] = ACTIONS(138),
    [anon_sym_POUND0a] = ACTIONS(138),
    [anon_sym_POUND_QMARK] = ACTIONS(140),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(142),
    [anon_sym_POUND_SQUOTE] = ACTIONS(144),
    [anon_sym_SQUOTE] = ACTIONS(146),
    [anon_sym_BQUOTE] = ACTIONS(148),
    [anon_sym_COMMA_AT] = ACTIONS(150),
    [anon_sym_COMMA] = ACTIONS(152),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(126),
    [anon_sym_cl] = ACTIONS(164),
    [aux_sym_accumulation_verb_token1] = ACTIONS(164),
    [anon_sym_for] = ACTIONS(164),
    [anon_sym_and] = ACTIONS(164),
    [anon_sym_as] = ACTIONS(164),
    [anon_sym_with] = ACTIONS(164),
    [anon_sym_do] = ACTIONS(164),
    [anon_sym_while] = ACTIONS(164),
    [anon_sym_until] = ACTIONS(164),
    [anon_sym_repeat] = ACTIONS(164),
    [anon_sym_when] = ACTIONS(164),
    [anon_sym_if] = ACTIONS(164),
    [anon_sym_unless] = ACTIONS(164),
    [anon_sym_always] = ACTIONS(164),
    [anon_sym_thereis] = ACTIONS(164),
    [anon_sym_never] = ACTIONS(164),
    [anon_sym_else] = ACTIONS(164),
    [anon_sym_finally] = ACTIONS(164),
    [anon_sym_return] = ACTIONS(164),
    [anon_sym_initially] = ACTIONS(164),
    [anon_sym_POUNDP] = ACTIONS(154),
    [anon_sym_POUNDp] = ACTIONS(154),
    [sym_self_referential_reader_macro] = ACTIONS(156),
    [anon_sym_POUND_PLUS] = ACTIONS(158),
    [anon_sym_POUND_DASH] = ACTIONS(158),
    [anon_sym_POUNDC] = ACTIONS(160),
    [anon_sym_POUNDc] = ACTIONS(160),
  },
  [5] = {
    [sym__gap] = STATE(14),
    [sym_dis_expr] = STATE(14),
    [sym__form] = STATE(2342),
    [sym_num_lit] = STATE(2342),
    [sym_kwd_lit] = STATE(2342),
    [sym_str_lit] = STATE(2342),
    [sym_char_lit] = STATE(2342),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2342),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2342),
    [sym_set_lit] = STATE(2342),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2342),
    [sym_splicing_read_cond_lit] = STATE(2342),
    [sym_var_quoting_lit] = STATE(2342),
    [sym_quoting_lit] = STATE(2342),
    [sym_syn_quoting_lit] = STATE(2342),
    [sym_unquote_splicing_lit] = STATE(2342),
    [sym_unquoting_lit] = STATE(2342),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2342),
    [sym_package_lit] = STATE(2342),
    [sym_include_reader_macro] = STATE(2342),
    [sym_complex_num_lit] = STATE(2342),
    [aux_sym_dis_expr_repeat1] = STATE(14),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(166),
    [sym_comment] = ACTIONS(166),
    [anon_sym_POUND_] = ACTIONS(170),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(176),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(180),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(176),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(190),
    [anon_sym_POUND_CARET] = ACTIONS(194),
    [anon_sym_LPAREN] = ACTIONS(198),
    [anon_sym_RPAREN] = ACTIONS(202),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(176),
    [anon_sym_cl] = ACTIONS(221),
    [anon_sym_EQ] = ACTIONS(225),
    [aux_sym_accumulation_verb_token1] = ACTIONS(227),
    [anon_sym_for] = ACTIONS(227),
    [anon_sym_and] = ACTIONS(227),
    [anon_sym_as] = ACTIONS(227),
    [anon_sym_with] = ACTIONS(227),
    [anon_sym_do] = ACTIONS(227),
    [anon_sym_while] = ACTIONS(227),
    [anon_sym_until] = ACTIONS(227),
    [anon_sym_repeat] = ACTIONS(227),
    [anon_sym_when] = ACTIONS(227),
    [anon_sym_if] = ACTIONS(227),
    [anon_sym_unless] = ACTIONS(227),
    [anon_sym_always] = ACTIONS(227),
    [anon_sym_thereis] = ACTIONS(227),
    [anon_sym_never] = ACTIONS(227),
    [anon_sym_else] = ACTIONS(227),
    [anon_sym_finally] = ACTIONS(227),
    [anon_sym_return] = ACTIONS(227),
    [anon_sym_initially] = ACTIONS(227),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(232),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [6] = {
    [sym__gap] = STATE(990),
    [sym_dis_expr] = STATE(990),
    [sym__form] = STATE(15),
    [sym_num_lit] = STATE(15),
    [sym_kwd_lit] = STATE(15),
    [sym_str_lit] = STATE(15),
    [sym_char_lit] = STATE(15),
    [sym_sym_lit] = STATE(1101),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(15),
    [sym__bare_list_lit] = STATE(1109),
    [sym_vec_lit] = STATE(15),
    [sym_set_lit] = STATE(15),
    [sym__bare_set_lit] = STATE(1117),
    [sym_read_cond_lit] = STATE(15),
    [sym_splicing_read_cond_lit] = STATE(15),
    [sym_var_quoting_lit] = STATE(15),
    [sym_quoting_lit] = STATE(15),
    [sym_syn_quoting_lit] = STATE(15),
    [sym_unquote_splicing_lit] = STATE(15),
    [sym_unquoting_lit] = STATE(15),
    [sym_defun] = STATE(1109),
    [sym_loop_macro] = STATE(1109),
    [sym_path_lit] = STATE(15),
    [sym_package_lit] = STATE(15),
    [sym_include_reader_macro] = STATE(15),
    [sym_complex_num_lit] = STATE(15),
    [aux_sym_dis_expr_repeat1] = STATE(990),
    [aux_sym_list_lit_repeat1] = STATE(2812),
    [sym__ws] = ACTIONS(238),
    [sym_comment] = ACTIONS(238),
    [anon_sym_POUND_] = ACTIONS(241),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(244),
    [aux_sym_num_lit_token1] = ACTIONS(69),
    [anon_sym_COLON] = ACTIONS(246),
    [anon_sym_COLON_COLON] = ACTIONS(74),
    [anon_sym_DQUOTE] = ACTIONS(76),
    [sym_nil_lit] = ACTIONS(244),
    [aux_sym_sym_lit_token1] = ACTIONS(78),
    [anon_sym_CARET] = ACTIONS(249),
    [anon_sym_POUND_CARET] = ACTIONS(252),
    [anon_sym_LPAREN] = ACTIONS(255),
    [anon_sym_RPAREN] = ACTIONS(258),
    [anon_sym_POUND0A] = ACTIONS(91),
    [anon_sym_POUND0a] = ACTIONS(91),
    [anon_sym_POUND_QMARK] = ACTIONS(93),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(95),
    [anon_sym_POUND_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_BQUOTE] = ACTIONS(101),
    [anon_sym_COMMA_AT] = ACTIONS(103),
    [anon_sym_COMMA] = ACTIONS(105),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(244),
    [anon_sym_cl] = ACTIONS(260),
    [anon_sym_EQ] = ACTIONS(263),
    [aux_sym_accumulation_verb_token1] = ACTIONS(265),
    [anon_sym_for] = ACTIONS(265),
    [anon_sym_and] = ACTIONS(265),
    [anon_sym_as] = ACTIONS(265),
    [anon_sym_with] = ACTIONS(265),
    [anon_sym_do] = ACTIONS(265),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_until] = ACTIONS(265),
    [anon_sym_repeat] = ACTIONS(265),
    [anon_sym_when] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(265),
    [anon_sym_unless] = ACTIONS(265),
    [anon_sym_always] = ACTIONS(265),
    [anon_sym_thereis] = ACTIONS(265),
    [anon_sym_never] = ACTIONS(265),
    [anon_sym_else] = ACTIONS(265),
    [anon_sym_finally] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(265),
    [anon_sym_initially] = ACTIONS(265),
    [anon_sym_POUNDP] = ACTIONS(114),
    [anon_sym_POUNDp] = ACTIONS(114),
    [sym_self_referential_reader_macro] = ACTIONS(267),
    [anon_sym_POUND_PLUS] = ACTIONS(118),
    [anon_sym_POUND_DASH] = ACTIONS(118),
    [anon_sym_POUNDC] = ACTIONS(120),
    [anon_sym_POUNDc] = ACTIONS(120),
  },
  [7] = {
    [sym__gap] = STATE(17),
    [sym_dis_expr] = STATE(17),
    [sym__form] = STATE(16),
    [sym_num_lit] = STATE(16),
    [sym_kwd_lit] = STATE(16),
    [sym_str_lit] = STATE(16),
    [sym_char_lit] = STATE(16),
    [sym_sym_lit] = STATE(1101),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(16),
    [sym__bare_list_lit] = STATE(1109),
    [sym_vec_lit] = STATE(16),
    [sym_set_lit] = STATE(16),
    [sym__bare_set_lit] = STATE(1117),
    [sym_read_cond_lit] = STATE(16),
    [sym_splicing_read_cond_lit] = STATE(16),
    [sym_var_quoting_lit] = STATE(16),
    [sym_quoting_lit] = STATE(16),
    [sym_syn_quoting_lit] = STATE(16),
    [sym_unquote_splicing_lit] = STATE(16),
    [sym_unquoting_lit] = STATE(16),
    [sym_defun] = STATE(1109),
    [sym_loop_macro] = STATE(1109),
    [sym_path_lit] = STATE(16),
    [sym_package_lit] = STATE(16),
    [sym_include_reader_macro] = STATE(16),
    [sym_complex_num_lit] = STATE(16),
    [aux_sym_dis_expr_repeat1] = STATE(17),
    [aux_sym_list_lit_repeat1] = STATE(2812),
    [sym__ws] = ACTIONS(269),
    [sym_comment] = ACTIONS(269),
    [anon_sym_POUND_] = ACTIONS(272),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(275),
    [aux_sym_num_lit_token1] = ACTIONS(69),
    [anon_sym_COLON] = ACTIONS(277),
    [anon_sym_COLON_COLON] = ACTIONS(74),
    [anon_sym_DQUOTE] = ACTIONS(76),
    [sym_nil_lit] = ACTIONS(275),
    [aux_sym_sym_lit_token1] = ACTIONS(78),
    [anon_sym_CARET] = ACTIONS(280),
    [anon_sym_POUND_CARET] = ACTIONS(283),
    [anon_sym_LPAREN] = ACTIONS(286),
    [anon_sym_RPAREN] = ACTIONS(289),
    [anon_sym_POUND0A] = ACTIONS(91),
    [anon_sym_POUND0a] = ACTIONS(91),
    [anon_sym_POUND_QMARK] = ACTIONS(93),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(95),
    [anon_sym_POUND_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_BQUOTE] = ACTIONS(101),
    [anon_sym_COMMA_AT] = ACTIONS(103),
    [anon_sym_COMMA] = ACTIONS(105),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(275),
    [anon_sym_cl] = ACTIONS(291),
    [anon_sym_EQ] = ACTIONS(294),
    [aux_sym_accumulation_verb_token1] = ACTIONS(296),
    [anon_sym_for] = ACTIONS(296),
    [anon_sym_and] = ACTIONS(296),
    [anon_sym_as] = ACTIONS(296),
    [anon_sym_with] = ACTIONS(296),
    [anon_sym_do] = ACTIONS(296),
    [anon_sym_while] = ACTIONS(296),
    [anon_sym_until] = ACTIONS(296),
    [anon_sym_repeat] = ACTIONS(296),
    [anon_sym_when] = ACTIONS(296),
    [anon_sym_if] = ACTIONS(296),
    [anon_sym_unless] = ACTIONS(296),
    [anon_sym_always] = ACTIONS(296),
    [anon_sym_thereis] = ACTIONS(296),
    [anon_sym_never] = ACTIONS(296),
    [anon_sym_else] = ACTIONS(296),
    [anon_sym_finally] = ACTIONS(296),
    [anon_sym_return] = ACTIONS(296),
    [anon_sym_initially] = ACTIONS(296),
    [anon_sym_POUNDP] = ACTIONS(114),
    [anon_sym_POUNDp] = ACTIONS(114),
    [sym_self_referential_reader_macro] = ACTIONS(298),
    [anon_sym_POUND_PLUS] = ACTIONS(118),
    [anon_sym_POUND_DASH] = ACTIONS(118),
    [anon_sym_POUNDC] = ACTIONS(120),
    [anon_sym_POUNDc] = ACTIONS(120),
  },
  [8] = {
    [sym__gap] = STATE(896),
    [sym_dis_expr] = STATE(896),
    [sym__form] = STATE(995),
    [sym_num_lit] = STATE(995),
    [sym_kwd_lit] = STATE(995),
    [sym_str_lit] = STATE(995),
    [sym_char_lit] = STATE(995),
    [sym_sym_lit] = STATE(1136),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(995),
    [sym__bare_list_lit] = STATE(1137),
    [sym_vec_lit] = STATE(995),
    [sym_set_lit] = STATE(995),
    [sym__bare_set_lit] = STATE(1138),
    [sym_read_cond_lit] = STATE(995),
    [sym_splicing_read_cond_lit] = STATE(995),
    [sym_var_quoting_lit] = STATE(995),
    [sym_quoting_lit] = STATE(995),
    [sym_syn_quoting_lit] = STATE(995),
    [sym_unquote_splicing_lit] = STATE(995),
    [sym_unquoting_lit] = STATE(995),
    [sym_defun] = STATE(1137),
    [sym_loop_macro] = STATE(1137),
    [sym_path_lit] = STATE(995),
    [sym_package_lit] = STATE(995),
    [sym_include_reader_macro] = STATE(995),
    [sym_complex_num_lit] = STATE(995),
    [aux_sym_dis_expr_repeat1] = STATE(896),
    [aux_sym_list_lit_repeat1] = STATE(2804),
    [aux_sym_do_clause_repeat1] = STATE(8),
    [sym__ws] = ACTIONS(300),
    [sym_comment] = ACTIONS(300),
    [anon_sym_POUND_] = ACTIONS(303),
    [anon_sym_POUND] = ACTIONS(306),
    [anon_sym_DOT] = ACTIONS(309),
    [aux_sym_num_lit_token1] = ACTIONS(312),
    [anon_sym_COLON] = ACTIONS(315),
    [anon_sym_COLON_COLON] = ACTIONS(318),
    [anon_sym_DQUOTE] = ACTIONS(321),
    [sym_nil_lit] = ACTIONS(309),
    [aux_sym_sym_lit_token1] = ACTIONS(324),
    [anon_sym_CARET] = ACTIONS(327),
    [anon_sym_POUND_CARET] = ACTIONS(330),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(336),
    [anon_sym_POUND0A] = ACTIONS(338),
    [anon_sym_POUND0a] = ACTIONS(338),
    [anon_sym_POUND_QMARK] = ACTIONS(341),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(344),
    [anon_sym_POUND_SQUOTE] = ACTIONS(347),
    [anon_sym_SQUOTE] = ACTIONS(350),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [anon_sym_COMMA_AT] = ACTIONS(356),
    [anon_sym_COMMA] = ACTIONS(359),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(309),
    [anon_sym_cl] = ACTIONS(362),
    [aux_sym_accumulation_verb_token1] = ACTIONS(365),
    [anon_sym_for] = ACTIONS(365),
    [anon_sym_and] = ACTIONS(365),
    [anon_sym_as] = ACTIONS(365),
    [anon_sym_with] = ACTIONS(365),
    [anon_sym_do] = ACTIONS(365),
    [anon_sym_while] = ACTIONS(365),
    [anon_sym_until] = ACTIONS(365),
    [anon_sym_repeat] = ACTIONS(365),
    [anon_sym_when] = ACTIONS(365),
    [anon_sym_if] = ACTIONS(365),
    [anon_sym_unless] = ACTIONS(365),
    [anon_sym_always] = ACTIONS(365),
    [anon_sym_thereis] = ACTIONS(365),
    [anon_sym_never] = ACTIONS(365),
    [anon_sym_else] = ACTIONS(365),
    [anon_sym_finally] = ACTIONS(365),
    [anon_sym_return] = ACTIONS(365),
    [anon_sym_initially] = ACTIONS(365),
    [anon_sym_POUNDP] = ACTIONS(367),
    [anon_sym_POUNDp] = ACTIONS(367),
    [sym_self_referential_reader_macro] = ACTIONS(370),
    [anon_sym_POUND_PLUS] = ACTIONS(373),
    [anon_sym_POUND_DASH] = ACTIONS(373),
    [anon_sym_POUNDC] = ACTIONS(376),
    [anon_sym_POUNDc] = ACTIONS(376),
  },
  [9] = {
    [sym__gap] = STATE(41),
    [sym_dis_expr] = STATE(41),
    [sym__form] = STATE(2520),
    [sym_num_lit] = STATE(2520),
    [sym_kwd_lit] = STATE(2520),
    [sym_str_lit] = STATE(2520),
    [sym_char_lit] = STATE(2520),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2520),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2520),
    [sym_set_lit] = STATE(2520),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2520),
    [sym_splicing_read_cond_lit] = STATE(2520),
    [sym_var_quoting_lit] = STATE(2520),
    [sym_quoting_lit] = STATE(2520),
    [sym_syn_quoting_lit] = STATE(2520),
    [sym_unquote_splicing_lit] = STATE(2520),
    [sym_unquoting_lit] = STATE(2520),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2520),
    [sym_package_lit] = STATE(2520),
    [sym_include_reader_macro] = STATE(2520),
    [sym_complex_num_lit] = STATE(2520),
    [aux_sym_dis_expr_repeat1] = STATE(41),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(379),
    [sym_comment] = ACTIONS(379),
    [anon_sym_POUND_] = ACTIONS(383),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(387),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(389),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(387),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(393),
    [anon_sym_POUND_CARET] = ACTIONS(397),
    [anon_sym_LPAREN] = ACTIONS(401),
    [anon_sym_RPAREN] = ACTIONS(405),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(387),
    [anon_sym_cl] = ACTIONS(408),
    [anon_sym_EQ] = ACTIONS(412),
    [aux_sym_accumulation_verb_token1] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(414),
    [anon_sym_and] = ACTIONS(414),
    [anon_sym_as] = ACTIONS(414),
    [anon_sym_with] = ACTIONS(414),
    [anon_sym_do] = ACTIONS(414),
    [anon_sym_while] = ACTIONS(414),
    [anon_sym_until] = ACTIONS(414),
    [anon_sym_repeat] = ACTIONS(414),
    [anon_sym_when] = ACTIONS(414),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_unless] = ACTIONS(414),
    [anon_sym_always] = ACTIONS(414),
    [anon_sym_thereis] = ACTIONS(414),
    [anon_sym_never] = ACTIONS(414),
    [anon_sym_else] = ACTIONS(414),
    [anon_sym_finally] = ACTIONS(414),
    [anon_sym_return] = ACTIONS(414),
    [anon_sym_initially] = ACTIONS(414),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(417),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [10] = {
    [sym__gap] = STATE(990),
    [sym_dis_expr] = STATE(990),
    [sym__form] = STATE(19),
    [sym_num_lit] = STATE(19),
    [sym_kwd_lit] = STATE(19),
    [sym_str_lit] = STATE(19),
    [sym_char_lit] = STATE(19),
    [sym_sym_lit] = STATE(1101),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(19),
    [sym__bare_list_lit] = STATE(1109),
    [sym_vec_lit] = STATE(19),
    [sym_set_lit] = STATE(19),
    [sym__bare_set_lit] = STATE(1117),
    [sym_read_cond_lit] = STATE(19),
    [sym_splicing_read_cond_lit] = STATE(19),
    [sym_var_quoting_lit] = STATE(19),
    [sym_quoting_lit] = STATE(19),
    [sym_syn_quoting_lit] = STATE(19),
    [sym_unquote_splicing_lit] = STATE(19),
    [sym_unquoting_lit] = STATE(19),
    [sym_defun] = STATE(1109),
    [sym_loop_macro] = STATE(1109),
    [sym_path_lit] = STATE(19),
    [sym_package_lit] = STATE(19),
    [sym_include_reader_macro] = STATE(19),
    [sym_complex_num_lit] = STATE(19),
    [aux_sym_dis_expr_repeat1] = STATE(990),
    [aux_sym_list_lit_repeat1] = STATE(2812),
    [sym__ws] = ACTIONS(419),
    [sym_comment] = ACTIONS(419),
    [anon_sym_POUND_] = ACTIONS(422),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(425),
    [aux_sym_num_lit_token1] = ACTIONS(69),
    [anon_sym_COLON] = ACTIONS(427),
    [anon_sym_COLON_COLON] = ACTIONS(74),
    [anon_sym_DQUOTE] = ACTIONS(76),
    [sym_nil_lit] = ACTIONS(425),
    [aux_sym_sym_lit_token1] = ACTIONS(78),
    [anon_sym_CARET] = ACTIONS(430),
    [anon_sym_POUND_CARET] = ACTIONS(433),
    [anon_sym_LPAREN] = ACTIONS(436),
    [anon_sym_RPAREN] = ACTIONS(439),
    [anon_sym_POUND0A] = ACTIONS(91),
    [anon_sym_POUND0a] = ACTIONS(91),
    [anon_sym_POUND_QMARK] = ACTIONS(93),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(95),
    [anon_sym_POUND_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_BQUOTE] = ACTIONS(101),
    [anon_sym_COMMA_AT] = ACTIONS(103),
    [anon_sym_COMMA] = ACTIONS(105),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(425),
    [anon_sym_cl] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(444),
    [aux_sym_accumulation_verb_token1] = ACTIONS(446),
    [anon_sym_for] = ACTIONS(446),
    [anon_sym_and] = ACTIONS(446),
    [anon_sym_as] = ACTIONS(446),
    [anon_sym_with] = ACTIONS(446),
    [anon_sym_do] = ACTIONS(446),
    [anon_sym_while] = ACTIONS(446),
    [anon_sym_until] = ACTIONS(446),
    [anon_sym_repeat] = ACTIONS(446),
    [anon_sym_when] = ACTIONS(446),
    [anon_sym_if] = ACTIONS(446),
    [anon_sym_unless] = ACTIONS(446),
    [anon_sym_always] = ACTIONS(446),
    [anon_sym_thereis] = ACTIONS(446),
    [anon_sym_never] = ACTIONS(446),
    [anon_sym_else] = ACTIONS(446),
    [anon_sym_finally] = ACTIONS(446),
    [anon_sym_return] = ACTIONS(446),
    [anon_sym_initially] = ACTIONS(446),
    [anon_sym_POUNDP] = ACTIONS(114),
    [anon_sym_POUNDp] = ACTIONS(114),
    [sym_self_referential_reader_macro] = ACTIONS(448),
    [anon_sym_POUND_PLUS] = ACTIONS(118),
    [anon_sym_POUND_DASH] = ACTIONS(118),
    [anon_sym_POUNDC] = ACTIONS(120),
    [anon_sym_POUNDc] = ACTIONS(120),
  },
  [11] = {
    [sym__gap] = STATE(21),
    [sym_dis_expr] = STATE(21),
    [sym__form] = STATE(20),
    [sym_num_lit] = STATE(20),
    [sym_kwd_lit] = STATE(20),
    [sym_str_lit] = STATE(20),
    [sym_char_lit] = STATE(20),
    [sym_sym_lit] = STATE(1101),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(20),
    [sym__bare_list_lit] = STATE(1109),
    [sym_vec_lit] = STATE(20),
    [sym_set_lit] = STATE(20),
    [sym__bare_set_lit] = STATE(1117),
    [sym_read_cond_lit] = STATE(20),
    [sym_splicing_read_cond_lit] = STATE(20),
    [sym_var_quoting_lit] = STATE(20),
    [sym_quoting_lit] = STATE(20),
    [sym_syn_quoting_lit] = STATE(20),
    [sym_unquote_splicing_lit] = STATE(20),
    [sym_unquoting_lit] = STATE(20),
    [sym_defun] = STATE(1109),
    [sym_loop_macro] = STATE(1109),
    [sym_path_lit] = STATE(20),
    [sym_package_lit] = STATE(20),
    [sym_include_reader_macro] = STATE(20),
    [sym_complex_num_lit] = STATE(20),
    [aux_sym_dis_expr_repeat1] = STATE(21),
    [aux_sym_list_lit_repeat1] = STATE(2812),
    [sym__ws] = ACTIONS(450),
    [sym_comment] = ACTIONS(450),
    [anon_sym_POUND_] = ACTIONS(453),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(456),
    [aux_sym_num_lit_token1] = ACTIONS(69),
    [anon_sym_COLON] = ACTIONS(458),
    [anon_sym_COLON_COLON] = ACTIONS(74),
    [anon_sym_DQUOTE] = ACTIONS(76),
    [sym_nil_lit] = ACTIONS(456),
    [aux_sym_sym_lit_token1] = ACTIONS(78),
    [anon_sym_CARET] = ACTIONS(461),
    [anon_sym_POUND_CARET] = ACTIONS(464),
    [anon_sym_LPAREN] = ACTIONS(467),
    [anon_sym_RPAREN] = ACTIONS(470),
    [anon_sym_POUND0A] = ACTIONS(91),
    [anon_sym_POUND0a] = ACTIONS(91),
    [anon_sym_POUND_QMARK] = ACTIONS(93),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(95),
    [anon_sym_POUND_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_BQUOTE] = ACTIONS(101),
    [anon_sym_COMMA_AT] = ACTIONS(103),
    [anon_sym_COMMA] = ACTIONS(105),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(456),
    [anon_sym_cl] = ACTIONS(472),
    [anon_sym_EQ] = ACTIONS(475),
    [aux_sym_accumulation_verb_token1] = ACTIONS(477),
    [anon_sym_for] = ACTIONS(477),
    [anon_sym_and] = ACTIONS(477),
    [anon_sym_as] = ACTIONS(477),
    [anon_sym_with] = ACTIONS(477),
    [anon_sym_do] = ACTIONS(477),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_until] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(477),
    [anon_sym_when] = ACTIONS(477),
    [anon_sym_if] = ACTIONS(477),
    [anon_sym_unless] = ACTIONS(477),
    [anon_sym_always] = ACTIONS(477),
    [anon_sym_thereis] = ACTIONS(477),
    [anon_sym_never] = ACTIONS(477),
    [anon_sym_else] = ACTIONS(477),
    [anon_sym_finally] = ACTIONS(477),
    [anon_sym_return] = ACTIONS(477),
    [anon_sym_initially] = ACTIONS(477),
    [anon_sym_POUNDP] = ACTIONS(114),
    [anon_sym_POUNDp] = ACTIONS(114),
    [sym_self_referential_reader_macro] = ACTIONS(479),
    [anon_sym_POUND_PLUS] = ACTIONS(118),
    [anon_sym_POUND_DASH] = ACTIONS(118),
    [anon_sym_POUNDC] = ACTIONS(120),
    [anon_sym_POUNDc] = ACTIONS(120),
  },
  [12] = {
    [sym__gap] = STATE(23),
    [sym_dis_expr] = STATE(23),
    [sym__form] = STATE(22),
    [sym_num_lit] = STATE(22),
    [sym_kwd_lit] = STATE(22),
    [sym_str_lit] = STATE(22),
    [sym_char_lit] = STATE(22),
    [sym_sym_lit] = STATE(1101),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(22),
    [sym__bare_list_lit] = STATE(1109),
    [sym_vec_lit] = STATE(22),
    [sym_set_lit] = STATE(22),
    [sym__bare_set_lit] = STATE(1117),
    [sym_read_cond_lit] = STATE(22),
    [sym_splicing_read_cond_lit] = STATE(22),
    [sym_var_quoting_lit] = STATE(22),
    [sym_quoting_lit] = STATE(22),
    [sym_syn_quoting_lit] = STATE(22),
    [sym_unquote_splicing_lit] = STATE(22),
    [sym_unquoting_lit] = STATE(22),
    [sym_defun] = STATE(1109),
    [sym_loop_macro] = STATE(1109),
    [sym_path_lit] = STATE(22),
    [sym_package_lit] = STATE(22),
    [sym_include_reader_macro] = STATE(22),
    [sym_complex_num_lit] = STATE(22),
    [aux_sym_dis_expr_repeat1] = STATE(23),
    [aux_sym_list_lit_repeat1] = STATE(2812),
    [sym__ws] = ACTIONS(481),
    [sym_comment] = ACTIONS(481),
    [anon_sym_POUND_] = ACTIONS(453),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(484),
    [aux_sym_num_lit_token1] = ACTIONS(69),
    [anon_sym_COLON] = ACTIONS(486),
    [anon_sym_COLON_COLON] = ACTIONS(74),
    [anon_sym_DQUOTE] = ACTIONS(76),
    [sym_nil_lit] = ACTIONS(484),
    [aux_sym_sym_lit_token1] = ACTIONS(78),
    [anon_sym_CARET] = ACTIONS(461),
    [anon_sym_POUND_CARET] = ACTIONS(464),
    [anon_sym_LPAREN] = ACTIONS(467),
    [anon_sym_RPAREN] = ACTIONS(470),
    [anon_sym_POUND0A] = ACTIONS(91),
    [anon_sym_POUND0a] = ACTIONS(91),
    [anon_sym_POUND_QMARK] = ACTIONS(93),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(95),
    [anon_sym_POUND_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_BQUOTE] = ACTIONS(101),
    [anon_sym_COMMA_AT] = ACTIONS(103),
    [anon_sym_COMMA] = ACTIONS(105),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(484),
    [anon_sym_cl] = ACTIONS(489),
    [anon_sym_EQ] = ACTIONS(492),
    [aux_sym_accumulation_verb_token1] = ACTIONS(477),
    [anon_sym_for] = ACTIONS(477),
    [anon_sym_and] = ACTIONS(477),
    [anon_sym_as] = ACTIONS(477),
    [anon_sym_with] = ACTIONS(477),
    [anon_sym_do] = ACTIONS(477),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_until] = ACTIONS(477),
    [anon_sym_repeat] = ACTIONS(477),
    [anon_sym_when] = ACTIONS(477),
    [anon_sym_if] = ACTIONS(477),
    [anon_sym_unless] = ACTIONS(477),
    [anon_sym_always] = ACTIONS(477),
    [anon_sym_thereis] = ACTIONS(477),
    [anon_sym_never] = ACTIONS(477),
    [anon_sym_else] = ACTIONS(477),
    [anon_sym_finally] = ACTIONS(477),
    [anon_sym_return] = ACTIONS(477),
    [anon_sym_initially] = ACTIONS(477),
    [anon_sym_POUNDP] = ACTIONS(114),
    [anon_sym_POUNDp] = ACTIONS(114),
    [sym_self_referential_reader_macro] = ACTIONS(494),
    [anon_sym_POUND_PLUS] = ACTIONS(118),
    [anon_sym_POUND_DASH] = ACTIONS(118),
    [anon_sym_POUNDC] = ACTIONS(120),
    [anon_sym_POUNDc] = ACTIONS(120),
  },
  [13] = {
    [sym__gap] = STATE(896),
    [sym_dis_expr] = STATE(896),
    [sym__form] = STATE(995),
    [sym_num_lit] = STATE(995),
    [sym_kwd_lit] = STATE(995),
    [sym_str_lit] = STATE(995),
    [sym_char_lit] = STATE(995),
    [sym_sym_lit] = STATE(1136),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(995),
    [sym__bare_list_lit] = STATE(1137),
    [sym_vec_lit] = STATE(995),
    [sym_set_lit] = STATE(995),
    [sym__bare_set_lit] = STATE(1138),
    [sym_read_cond_lit] = STATE(995),
    [sym_splicing_read_cond_lit] = STATE(995),
    [sym_var_quoting_lit] = STATE(995),
    [sym_quoting_lit] = STATE(995),
    [sym_syn_quoting_lit] = STATE(995),
    [sym_unquote_splicing_lit] = STATE(995),
    [sym_unquoting_lit] = STATE(995),
    [sym_defun] = STATE(1137),
    [sym_loop_macro] = STATE(1137),
    [sym_path_lit] = STATE(995),
    [sym_package_lit] = STATE(995),
    [sym_include_reader_macro] = STATE(995),
    [sym_complex_num_lit] = STATE(995),
    [aux_sym_dis_expr_repeat1] = STATE(896),
    [aux_sym_list_lit_repeat1] = STATE(2804),
    [aux_sym_do_clause_repeat1] = STATE(8),
    [sym__ws] = ACTIONS(496),
    [sym_comment] = ACTIONS(496),
    [anon_sym_POUND_] = ACTIONS(496),
    [anon_sym_POUND] = ACTIONS(124),
    [anon_sym_DOT] = ACTIONS(126),
    [aux_sym_num_lit_token1] = ACTIONS(128),
    [anon_sym_COLON] = ACTIONS(498),
    [anon_sym_COLON_COLON] = ACTIONS(132),
    [anon_sym_DQUOTE] = ACTIONS(134),
    [sym_nil_lit] = ACTIONS(126),
    [aux_sym_sym_lit_token1] = ACTIONS(136),
    [anon_sym_CARET] = ACTIONS(496),
    [anon_sym_POUND_CARET] = ACTIONS(496),
    [anon_sym_LPAREN] = ACTIONS(496),
    [anon_sym_RPAREN] = ACTIONS(496),
    [anon_sym_POUND0A] = ACTIONS(138),
    [anon_sym_POUND0a] = ACTIONS(138),
    [anon_sym_POUND_QMARK] = ACTIONS(140),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(142),
    [anon_sym_POUND_SQUOTE] = ACTIONS(144),
    [anon_sym_SQUOTE] = ACTIONS(146),
    [anon_sym_BQUOTE] = ACTIONS(148),
    [anon_sym_COMMA_AT] = ACTIONS(150),
    [anon_sym_COMMA] = ACTIONS(152),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(126),
    [anon_sym_cl] = ACTIONS(498),
    [aux_sym_accumulation_verb_token1] = ACTIONS(498),
    [anon_sym_for] = ACTIONS(498),
    [anon_sym_and] = ACTIONS(498),
    [anon_sym_as] = ACTIONS(498),
    [anon_sym_with] = ACTIONS(498),
    [anon_sym_do] = ACTIONS(498),
    [anon_sym_while] = ACTIONS(498),
    [anon_sym_until] = ACTIONS(498),
    [anon_sym_repeat] = ACTIONS(498),
    [anon_sym_when] = ACTIONS(498),
    [anon_sym_if] = ACTIONS(498),
    [anon_sym_unless] = ACTIONS(498),
    [anon_sym_always] = ACTIONS(498),
    [anon_sym_thereis] = ACTIONS(498),
    [anon_sym_never] = ACTIONS(498),
    [anon_sym_else] = ACTIONS(498),
    [anon_sym_finally] = ACTIONS(498),
    [anon_sym_return] = ACTIONS(498),
    [anon_sym_initially] = ACTIONS(498),
    [anon_sym_POUNDP] = ACTIONS(154),
    [anon_sym_POUNDp] = ACTIONS(154),
    [sym_self_referential_reader_macro] = ACTIONS(156),
    [anon_sym_POUND_PLUS] = ACTIONS(158),
    [anon_sym_POUND_DASH] = ACTIONS(158),
    [anon_sym_POUNDC] = ACTIONS(160),
    [anon_sym_POUNDc] = ACTIONS(160),
  },
  [14] = {
    [sym__gap] = STATE(990),
    [sym_dis_expr] = STATE(990),
    [sym__form] = STATE(2534),
    [sym_num_lit] = STATE(2534),
    [sym_kwd_lit] = STATE(2534),
    [sym_str_lit] = STATE(2534),
    [sym_char_lit] = STATE(2534),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2534),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2534),
    [sym_set_lit] = STATE(2534),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2534),
    [sym_splicing_read_cond_lit] = STATE(2534),
    [sym_var_quoting_lit] = STATE(2534),
    [sym_quoting_lit] = STATE(2534),
    [sym_syn_quoting_lit] = STATE(2534),
    [sym_unquote_splicing_lit] = STATE(2534),
    [sym_unquoting_lit] = STATE(2534),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2534),
    [sym_package_lit] = STATE(2534),
    [sym_include_reader_macro] = STATE(2534),
    [sym_complex_num_lit] = STATE(2534),
    [aux_sym_dis_expr_repeat1] = STATE(990),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(500),
    [sym_comment] = ACTIONS(500),
    [anon_sym_POUND_] = ACTIONS(504),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(508),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(510),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(508),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(514),
    [anon_sym_POUND_CARET] = ACTIONS(518),
    [anon_sym_LPAREN] = ACTIONS(522),
    [anon_sym_RPAREN] = ACTIONS(526),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(508),
    [anon_sym_cl] = ACTIONS(529),
    [anon_sym_EQ] = ACTIONS(533),
    [aux_sym_accumulation_verb_token1] = ACTIONS(535),
    [anon_sym_for] = ACTIONS(535),
    [anon_sym_and] = ACTIONS(535),
    [anon_sym_as] = ACTIONS(535),
    [anon_sym_with] = ACTIONS(535),
    [anon_sym_do] = ACTIONS(535),
    [anon_sym_while] = ACTIONS(535),
    [anon_sym_until] = ACTIONS(535),
    [anon_sym_repeat] = ACTIONS(535),
    [anon_sym_when] = ACTIONS(535),
    [anon_sym_if] = ACTIONS(535),
    [anon_sym_unless] = ACTIONS(535),
    [anon_sym_always] = ACTIONS(535),
    [anon_sym_thereis] = ACTIONS(535),
    [anon_sym_never] = ACTIONS(535),
    [anon_sym_else] = ACTIONS(535),
    [anon_sym_finally] = ACTIONS(535),
    [anon_sym_return] = ACTIONS(535),
    [anon_sym_initially] = ACTIONS(535),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(538),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [15] = {
    [sym__gap] = STATE(25),
    [sym_dis_expr] = STATE(25),
    [sym__form] = STATE(2539),
    [sym_num_lit] = STATE(2539),
    [sym_kwd_lit] = STATE(2539),
    [sym_str_lit] = STATE(2539),
    [sym_char_lit] = STATE(2539),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2539),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2539),
    [sym_set_lit] = STATE(2539),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2539),
    [sym_splicing_read_cond_lit] = STATE(2539),
    [sym_var_quoting_lit] = STATE(2539),
    [sym_quoting_lit] = STATE(2539),
    [sym_syn_quoting_lit] = STATE(2539),
    [sym_unquote_splicing_lit] = STATE(2539),
    [sym_unquoting_lit] = STATE(2539),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2539),
    [sym_package_lit] = STATE(2539),
    [sym_include_reader_macro] = STATE(2539),
    [sym_complex_num_lit] = STATE(2539),
    [aux_sym_dis_expr_repeat1] = STATE(25),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(540),
    [sym_comment] = ACTIONS(540),
    [anon_sym_POUND_] = ACTIONS(544),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(548),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(550),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(548),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(554),
    [anon_sym_POUND_CARET] = ACTIONS(558),
    [anon_sym_LPAREN] = ACTIONS(562),
    [anon_sym_RPAREN] = ACTIONS(566),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(548),
    [anon_sym_cl] = ACTIONS(569),
    [anon_sym_EQ] = ACTIONS(573),
    [aux_sym_accumulation_verb_token1] = ACTIONS(575),
    [anon_sym_for] = ACTIONS(575),
    [anon_sym_and] = ACTIONS(575),
    [anon_sym_as] = ACTIONS(575),
    [anon_sym_with] = ACTIONS(575),
    [anon_sym_do] = ACTIONS(575),
    [anon_sym_while] = ACTIONS(575),
    [anon_sym_until] = ACTIONS(575),
    [anon_sym_repeat] = ACTIONS(575),
    [anon_sym_when] = ACTIONS(575),
    [anon_sym_if] = ACTIONS(575),
    [anon_sym_unless] = ACTIONS(575),
    [anon_sym_always] = ACTIONS(575),
    [anon_sym_thereis] = ACTIONS(575),
    [anon_sym_never] = ACTIONS(575),
    [anon_sym_else] = ACTIONS(575),
    [anon_sym_finally] = ACTIONS(575),
    [anon_sym_return] = ACTIONS(575),
    [anon_sym_initially] = ACTIONS(575),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(578),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [16] = {
    [sym__gap] = STATE(26),
    [sym_dis_expr] = STATE(26),
    [sym__form] = STATE(2247),
    [sym_num_lit] = STATE(2247),
    [sym_kwd_lit] = STATE(2247),
    [sym_str_lit] = STATE(2247),
    [sym_char_lit] = STATE(2247),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2247),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2247),
    [sym_set_lit] = STATE(2247),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2247),
    [sym_splicing_read_cond_lit] = STATE(2247),
    [sym_var_quoting_lit] = STATE(2247),
    [sym_quoting_lit] = STATE(2247),
    [sym_syn_quoting_lit] = STATE(2247),
    [sym_unquote_splicing_lit] = STATE(2247),
    [sym_unquoting_lit] = STATE(2247),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2247),
    [sym_package_lit] = STATE(2247),
    [sym_include_reader_macro] = STATE(2247),
    [sym_complex_num_lit] = STATE(2247),
    [aux_sym_dis_expr_repeat1] = STATE(26),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(580),
    [sym_comment] = ACTIONS(580),
    [anon_sym_POUND_] = ACTIONS(383),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(584),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(586),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(584),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(393),
    [anon_sym_POUND_CARET] = ACTIONS(397),
    [anon_sym_LPAREN] = ACTIONS(401),
    [anon_sym_RPAREN] = ACTIONS(405),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(584),
    [anon_sym_cl] = ACTIONS(590),
    [anon_sym_EQ] = ACTIONS(594),
    [aux_sym_accumulation_verb_token1] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(414),
    [anon_sym_and] = ACTIONS(414),
    [anon_sym_as] = ACTIONS(414),
    [anon_sym_with] = ACTIONS(414),
    [anon_sym_do] = ACTIONS(414),
    [anon_sym_while] = ACTIONS(414),
    [anon_sym_until] = ACTIONS(414),
    [anon_sym_repeat] = ACTIONS(414),
    [anon_sym_when] = ACTIONS(414),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_unless] = ACTIONS(414),
    [anon_sym_always] = ACTIONS(414),
    [anon_sym_thereis] = ACTIONS(414),
    [anon_sym_never] = ACTIONS(414),
    [anon_sym_else] = ACTIONS(414),
    [anon_sym_finally] = ACTIONS(414),
    [anon_sym_return] = ACTIONS(414),
    [anon_sym_initially] = ACTIONS(414),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(596),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [17] = {
    [sym__gap] = STATE(990),
    [sym_dis_expr] = STATE(990),
    [sym__form] = STATE(27),
    [sym_num_lit] = STATE(27),
    [sym_kwd_lit] = STATE(27),
    [sym_str_lit] = STATE(27),
    [sym_char_lit] = STATE(27),
    [sym_sym_lit] = STATE(1101),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(27),
    [sym__bare_list_lit] = STATE(1109),
    [sym_vec_lit] = STATE(27),
    [sym_set_lit] = STATE(27),
    [sym__bare_set_lit] = STATE(1117),
    [sym_read_cond_lit] = STATE(27),
    [sym_splicing_read_cond_lit] = STATE(27),
    [sym_var_quoting_lit] = STATE(27),
    [sym_quoting_lit] = STATE(27),
    [sym_syn_quoting_lit] = STATE(27),
    [sym_unquote_splicing_lit] = STATE(27),
    [sym_unquoting_lit] = STATE(27),
    [sym_defun] = STATE(1109),
    [sym_loop_macro] = STATE(1109),
    [sym_path_lit] = STATE(27),
    [sym_package_lit] = STATE(27),
    [sym_include_reader_macro] = STATE(27),
    [sym_complex_num_lit] = STATE(27),
    [aux_sym_dis_expr_repeat1] = STATE(990),
    [aux_sym_list_lit_repeat1] = STATE(2812),
    [sym__ws] = ACTIONS(419),
    [sym_comment] = ACTIONS(419),
    [anon_sym_POUND_] = ACTIONS(422),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(598),
    [aux_sym_num_lit_token1] = ACTIONS(69),
    [anon_sym_COLON] = ACTIONS(600),
    [anon_sym_COLON_COLON] = ACTIONS(74),
    [anon_sym_DQUOTE] = ACTIONS(76),
    [sym_nil_lit] = ACTIONS(598),
    [aux_sym_sym_lit_token1] = ACTIONS(78),
    [anon_sym_CARET] = ACTIONS(430),
    [anon_sym_POUND_CARET] = ACTIONS(433),
    [anon_sym_LPAREN] = ACTIONS(436),
    [anon_sym_RPAREN] = ACTIONS(439),
    [anon_sym_POUND0A] = ACTIONS(91),
    [anon_sym_POUND0a] = ACTIONS(91),
    [anon_sym_POUND_QMARK] = ACTIONS(93),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(95),
    [anon_sym_POUND_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_BQUOTE] = ACTIONS(101),
    [anon_sym_COMMA_AT] = ACTIONS(103),
    [anon_sym_COMMA] = ACTIONS(105),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(598),
    [anon_sym_cl] = ACTIONS(603),
    [anon_sym_EQ] = ACTIONS(606),
    [aux_sym_accumulation_verb_token1] = ACTIONS(446),
    [anon_sym_for] = ACTIONS(446),
    [anon_sym_and] = ACTIONS(446),
    [anon_sym_as] = ACTIONS(446),
    [anon_sym_with] = ACTIONS(446),
    [anon_sym_do] = ACTIONS(446),
    [anon_sym_while] = ACTIONS(446),
    [anon_sym_until] = ACTIONS(446),
    [anon_sym_repeat] = ACTIONS(446),
    [anon_sym_when] = ACTIONS(446),
    [anon_sym_if] = ACTIONS(446),
    [anon_sym_unless] = ACTIONS(446),
    [anon_sym_always] = ACTIONS(446),
    [anon_sym_thereis] = ACTIONS(446),
    [anon_sym_never] = ACTIONS(446),
    [anon_sym_else] = ACTIONS(446),
    [anon_sym_finally] = ACTIONS(446),
    [anon_sym_return] = ACTIONS(446),
    [anon_sym_initially] = ACTIONS(446),
    [anon_sym_POUNDP] = ACTIONS(114),
    [anon_sym_POUNDp] = ACTIONS(114),
    [sym_self_referential_reader_macro] = ACTIONS(608),
    [anon_sym_POUND_PLUS] = ACTIONS(118),
    [anon_sym_POUND_DASH] = ACTIONS(118),
    [anon_sym_POUNDC] = ACTIONS(120),
    [anon_sym_POUNDc] = ACTIONS(120),
  },
  [18] = {
    [sym__gap] = STATE(6),
    [sym_dis_expr] = STATE(6),
    [sym__form] = STATE(5),
    [sym_num_lit] = STATE(5),
    [sym_kwd_lit] = STATE(5),
    [sym_str_lit] = STATE(5),
    [sym_char_lit] = STATE(5),
    [sym_sym_lit] = STATE(1101),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(5),
    [sym__bare_list_lit] = STATE(1109),
    [sym_vec_lit] = STATE(5),
    [sym_set_lit] = STATE(5),
    [sym__bare_set_lit] = STATE(1117),
    [sym_read_cond_lit] = STATE(5),
    [sym_splicing_read_cond_lit] = STATE(5),
    [sym_var_quoting_lit] = STATE(5),
    [sym_quoting_lit] = STATE(5),
    [sym_syn_quoting_lit] = STATE(5),
    [sym_unquote_splicing_lit] = STATE(5),
    [sym_unquoting_lit] = STATE(5),
    [sym_defun] = STATE(1109),
    [sym_loop_macro] = STATE(1109),
    [sym_path_lit] = STATE(5),
    [sym_package_lit] = STATE(5),
    [sym_include_reader_macro] = STATE(5),
    [sym_complex_num_lit] = STATE(5),
    [aux_sym_dis_expr_repeat1] = STATE(6),
    [aux_sym_list_lit_repeat1] = STATE(2812),
    [sym__ws] = ACTIONS(610),
    [sym_comment] = ACTIONS(610),
    [anon_sym_POUND_] = ACTIONS(613),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(616),
    [aux_sym_num_lit_token1] = ACTIONS(69),
    [anon_sym_COLON] = ACTIONS(618),
    [anon_sym_COLON_COLON] = ACTIONS(74),
    [anon_sym_DQUOTE] = ACTIONS(76),
    [sym_nil_lit] = ACTIONS(616),
    [aux_sym_sym_lit_token1] = ACTIONS(78),
    [anon_sym_CARET] = ACTIONS(621),
    [anon_sym_POUND_CARET] = ACTIONS(624),
    [anon_sym_LPAREN] = ACTIONS(627),
    [anon_sym_RPAREN] = ACTIONS(630),
    [anon_sym_POUND0A] = ACTIONS(91),
    [anon_sym_POUND0a] = ACTIONS(91),
    [anon_sym_POUND_QMARK] = ACTIONS(93),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(95),
    [anon_sym_POUND_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_BQUOTE] = ACTIONS(101),
    [anon_sym_COMMA_AT] = ACTIONS(103),
    [anon_sym_COMMA] = ACTIONS(105),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(616),
    [anon_sym_cl] = ACTIONS(632),
    [anon_sym_EQ] = ACTIONS(635),
    [aux_sym_accumulation_verb_token1] = ACTIONS(637),
    [anon_sym_for] = ACTIONS(637),
    [anon_sym_and] = ACTIONS(637),
    [anon_sym_as] = ACTIONS(637),
    [anon_sym_with] = ACTIONS(637),
    [anon_sym_do] = ACTIONS(637),
    [anon_sym_while] = ACTIONS(637),
    [anon_sym_until] = ACTIONS(637),
    [anon_sym_repeat] = ACTIONS(637),
    [anon_sym_when] = ACTIONS(637),
    [anon_sym_if] = ACTIONS(637),
    [anon_sym_unless] = ACTIONS(637),
    [anon_sym_always] = ACTIONS(637),
    [anon_sym_thereis] = ACTIONS(637),
    [anon_sym_never] = ACTIONS(637),
    [anon_sym_else] = ACTIONS(637),
    [anon_sym_finally] = ACTIONS(637),
    [anon_sym_return] = ACTIONS(637),
    [anon_sym_initially] = ACTIONS(637),
    [anon_sym_POUNDP] = ACTIONS(114),
    [anon_sym_POUNDp] = ACTIONS(114),
    [sym_self_referential_reader_macro] = ACTIONS(639),
    [anon_sym_POUND_PLUS] = ACTIONS(118),
    [anon_sym_POUND_DASH] = ACTIONS(118),
    [anon_sym_POUNDC] = ACTIONS(120),
    [anon_sym_POUNDc] = ACTIONS(120),
  },
  [19] = {
    [sym__gap] = STATE(28),
    [sym_dis_expr] = STATE(28),
    [sym__form] = STATE(2107),
    [sym_num_lit] = STATE(2107),
    [sym_kwd_lit] = STATE(2107),
    [sym_str_lit] = STATE(2107),
    [sym_char_lit] = STATE(2107),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2107),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2107),
    [sym_set_lit] = STATE(2107),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2107),
    [sym_splicing_read_cond_lit] = STATE(2107),
    [sym_var_quoting_lit] = STATE(2107),
    [sym_quoting_lit] = STATE(2107),
    [sym_syn_quoting_lit] = STATE(2107),
    [sym_unquote_splicing_lit] = STATE(2107),
    [sym_unquoting_lit] = STATE(2107),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2107),
    [sym_package_lit] = STATE(2107),
    [sym_include_reader_macro] = STATE(2107),
    [sym_complex_num_lit] = STATE(2107),
    [aux_sym_dis_expr_repeat1] = STATE(28),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(641),
    [sym_comment] = ACTIONS(641),
    [anon_sym_POUND_] = ACTIONS(645),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(649),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(651),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(649),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(655),
    [anon_sym_POUND_CARET] = ACTIONS(659),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_RPAREN] = ACTIONS(667),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(649),
    [anon_sym_cl] = ACTIONS(670),
    [anon_sym_EQ] = ACTIONS(674),
    [aux_sym_accumulation_verb_token1] = ACTIONS(676),
    [anon_sym_for] = ACTIONS(676),
    [anon_sym_and] = ACTIONS(676),
    [anon_sym_as] = ACTIONS(676),
    [anon_sym_with] = ACTIONS(676),
    [anon_sym_do] = ACTIONS(676),
    [anon_sym_while] = ACTIONS(676),
    [anon_sym_until] = ACTIONS(676),
    [anon_sym_repeat] = ACTIONS(676),
    [anon_sym_when] = ACTIONS(676),
    [anon_sym_if] = ACTIONS(676),
    [anon_sym_unless] = ACTIONS(676),
    [anon_sym_always] = ACTIONS(676),
    [anon_sym_thereis] = ACTIONS(676),
    [anon_sym_never] = ACTIONS(676),
    [anon_sym_else] = ACTIONS(676),
    [anon_sym_finally] = ACTIONS(676),
    [anon_sym_return] = ACTIONS(676),
    [anon_sym_initially] = ACTIONS(676),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(679),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [20] = {
    [sym__gap] = STATE(29),
    [sym_dis_expr] = STATE(29),
    [sym__form] = STATE(2115),
    [sym_num_lit] = STATE(2115),
    [sym_kwd_lit] = STATE(2115),
    [sym_str_lit] = STATE(2115),
    [sym_char_lit] = STATE(2115),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2115),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2115),
    [sym_set_lit] = STATE(2115),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2115),
    [sym_splicing_read_cond_lit] = STATE(2115),
    [sym_var_quoting_lit] = STATE(2115),
    [sym_quoting_lit] = STATE(2115),
    [sym_syn_quoting_lit] = STATE(2115),
    [sym_unquote_splicing_lit] = STATE(2115),
    [sym_unquoting_lit] = STATE(2115),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2115),
    [sym_package_lit] = STATE(2115),
    [sym_include_reader_macro] = STATE(2115),
    [sym_complex_num_lit] = STATE(2115),
    [aux_sym_dis_expr_repeat1] = STATE(29),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(681),
    [sym_comment] = ACTIONS(681),
    [anon_sym_POUND_] = ACTIONS(685),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(689),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(691),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(689),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(695),
    [anon_sym_POUND_CARET] = ACTIONS(699),
    [anon_sym_LPAREN] = ACTIONS(703),
    [anon_sym_RPAREN] = ACTIONS(707),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(689),
    [anon_sym_cl] = ACTIONS(710),
    [anon_sym_EQ] = ACTIONS(714),
    [aux_sym_accumulation_verb_token1] = ACTIONS(716),
    [anon_sym_for] = ACTIONS(716),
    [anon_sym_and] = ACTIONS(716),
    [anon_sym_as] = ACTIONS(716),
    [anon_sym_with] = ACTIONS(716),
    [anon_sym_do] = ACTIONS(716),
    [anon_sym_while] = ACTIONS(716),
    [anon_sym_until] = ACTIONS(716),
    [anon_sym_repeat] = ACTIONS(716),
    [anon_sym_when] = ACTIONS(716),
    [anon_sym_if] = ACTIONS(716),
    [anon_sym_unless] = ACTIONS(716),
    [anon_sym_always] = ACTIONS(716),
    [anon_sym_thereis] = ACTIONS(716),
    [anon_sym_never] = ACTIONS(716),
    [anon_sym_else] = ACTIONS(716),
    [anon_sym_finally] = ACTIONS(716),
    [anon_sym_return] = ACTIONS(716),
    [anon_sym_initially] = ACTIONS(716),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(719),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [21] = {
    [sym__gap] = STATE(990),
    [sym_dis_expr] = STATE(990),
    [sym__form] = STATE(30),
    [sym_num_lit] = STATE(30),
    [sym_kwd_lit] = STATE(30),
    [sym_str_lit] = STATE(30),
    [sym_char_lit] = STATE(30),
    [sym_sym_lit] = STATE(1101),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(30),
    [sym__bare_list_lit] = STATE(1109),
    [sym_vec_lit] = STATE(30),
    [sym_set_lit] = STATE(30),
    [sym__bare_set_lit] = STATE(1117),
    [sym_read_cond_lit] = STATE(30),
    [sym_splicing_read_cond_lit] = STATE(30),
    [sym_var_quoting_lit] = STATE(30),
    [sym_quoting_lit] = STATE(30),
    [sym_syn_quoting_lit] = STATE(30),
    [sym_unquote_splicing_lit] = STATE(30),
    [sym_unquoting_lit] = STATE(30),
    [sym_defun] = STATE(1109),
    [sym_loop_macro] = STATE(1109),
    [sym_path_lit] = STATE(30),
    [sym_package_lit] = STATE(30),
    [sym_include_reader_macro] = STATE(30),
    [sym_complex_num_lit] = STATE(30),
    [aux_sym_dis_expr_repeat1] = STATE(990),
    [aux_sym_list_lit_repeat1] = STATE(2812),
    [sym__ws] = ACTIONS(721),
    [sym_comment] = ACTIONS(721),
    [anon_sym_POUND_] = ACTIONS(724),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(727),
    [aux_sym_num_lit_token1] = ACTIONS(69),
    [anon_sym_COLON] = ACTIONS(729),
    [anon_sym_COLON_COLON] = ACTIONS(74),
    [anon_sym_DQUOTE] = ACTIONS(76),
    [sym_nil_lit] = ACTIONS(727),
    [aux_sym_sym_lit_token1] = ACTIONS(78),
    [anon_sym_CARET] = ACTIONS(732),
    [anon_sym_POUND_CARET] = ACTIONS(735),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(741),
    [anon_sym_POUND0A] = ACTIONS(91),
    [anon_sym_POUND0a] = ACTIONS(91),
    [anon_sym_POUND_QMARK] = ACTIONS(93),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(95),
    [anon_sym_POUND_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_BQUOTE] = ACTIONS(101),
    [anon_sym_COMMA_AT] = ACTIONS(103),
    [anon_sym_COMMA] = ACTIONS(105),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(727),
    [anon_sym_cl] = ACTIONS(743),
    [anon_sym_EQ] = ACTIONS(746),
    [aux_sym_accumulation_verb_token1] = ACTIONS(748),
    [anon_sym_for] = ACTIONS(748),
    [anon_sym_and] = ACTIONS(748),
    [anon_sym_as] = ACTIONS(748),
    [anon_sym_with] = ACTIONS(748),
    [anon_sym_do] = ACTIONS(748),
    [anon_sym_while] = ACTIONS(748),
    [anon_sym_until] = ACTIONS(748),
    [anon_sym_repeat] = ACTIONS(748),
    [anon_sym_when] = ACTIONS(748),
    [anon_sym_if] = ACTIONS(748),
    [anon_sym_unless] = ACTIONS(748),
    [anon_sym_always] = ACTIONS(748),
    [anon_sym_thereis] = ACTIONS(748),
    [anon_sym_never] = ACTIONS(748),
    [anon_sym_else] = ACTIONS(748),
    [anon_sym_finally] = ACTIONS(748),
    [anon_sym_return] = ACTIONS(748),
    [anon_sym_initially] = ACTIONS(748),
    [anon_sym_POUNDP] = ACTIONS(114),
    [anon_sym_POUNDp] = ACTIONS(114),
    [sym_self_referential_reader_macro] = ACTIONS(750),
    [anon_sym_POUND_PLUS] = ACTIONS(118),
    [anon_sym_POUND_DASH] = ACTIONS(118),
    [anon_sym_POUNDC] = ACTIONS(120),
    [anon_sym_POUNDc] = ACTIONS(120),
  },
  [22] = {
    [sym__gap] = STATE(31),
    [sym_dis_expr] = STATE(31),
    [sym__form] = STATE(2139),
    [sym_num_lit] = STATE(2139),
    [sym_kwd_lit] = STATE(2139),
    [sym_str_lit] = STATE(2139),
    [sym_char_lit] = STATE(2139),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2139),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2139),
    [sym_set_lit] = STATE(2139),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2139),
    [sym_splicing_read_cond_lit] = STATE(2139),
    [sym_var_quoting_lit] = STATE(2139),
    [sym_quoting_lit] = STATE(2139),
    [sym_syn_quoting_lit] = STATE(2139),
    [sym_unquote_splicing_lit] = STATE(2139),
    [sym_unquoting_lit] = STATE(2139),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2139),
    [sym_package_lit] = STATE(2139),
    [sym_include_reader_macro] = STATE(2139),
    [sym_complex_num_lit] = STATE(2139),
    [aux_sym_dis_expr_repeat1] = STATE(31),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(752),
    [sym_comment] = ACTIONS(752),
    [anon_sym_POUND_] = ACTIONS(685),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(756),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(758),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(756),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(695),
    [anon_sym_POUND_CARET] = ACTIONS(699),
    [anon_sym_LPAREN] = ACTIONS(703),
    [anon_sym_RPAREN] = ACTIONS(707),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(756),
    [anon_sym_cl] = ACTIONS(762),
    [anon_sym_EQ] = ACTIONS(766),
    [aux_sym_accumulation_verb_token1] = ACTIONS(716),
    [anon_sym_for] = ACTIONS(716),
    [anon_sym_and] = ACTIONS(716),
    [anon_sym_as] = ACTIONS(716),
    [anon_sym_with] = ACTIONS(716),
    [anon_sym_do] = ACTIONS(716),
    [anon_sym_while] = ACTIONS(716),
    [anon_sym_until] = ACTIONS(716),
    [anon_sym_repeat] = ACTIONS(716),
    [anon_sym_when] = ACTIONS(716),
    [anon_sym_if] = ACTIONS(716),
    [anon_sym_unless] = ACTIONS(716),
    [anon_sym_always] = ACTIONS(716),
    [anon_sym_thereis] = ACTIONS(716),
    [anon_sym_never] = ACTIONS(716),
    [anon_sym_else] = ACTIONS(716),
    [anon_sym_finally] = ACTIONS(716),
    [anon_sym_return] = ACTIONS(716),
    [anon_sym_initially] = ACTIONS(716),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(768),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [23] = {
    [sym__gap] = STATE(990),
    [sym_dis_expr] = STATE(990),
    [sym__form] = STATE(32),
    [sym_num_lit] = STATE(32),
    [sym_kwd_lit] = STATE(32),
    [sym_str_lit] = STATE(32),
    [sym_char_lit] = STATE(32),
    [sym_sym_lit] = STATE(1101),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(32),
    [sym__bare_list_lit] = STATE(1109),
    [sym_vec_lit] = STATE(32),
    [sym_set_lit] = STATE(32),
    [sym__bare_set_lit] = STATE(1117),
    [sym_read_cond_lit] = STATE(32),
    [sym_splicing_read_cond_lit] = STATE(32),
    [sym_var_quoting_lit] = STATE(32),
    [sym_quoting_lit] = STATE(32),
    [sym_syn_quoting_lit] = STATE(32),
    [sym_unquote_splicing_lit] = STATE(32),
    [sym_unquoting_lit] = STATE(32),
    [sym_defun] = STATE(1109),
    [sym_loop_macro] = STATE(1109),
    [sym_path_lit] = STATE(32),
    [sym_package_lit] = STATE(32),
    [sym_include_reader_macro] = STATE(32),
    [sym_complex_num_lit] = STATE(32),
    [aux_sym_dis_expr_repeat1] = STATE(990),
    [aux_sym_list_lit_repeat1] = STATE(2812),
    [sym__ws] = ACTIONS(721),
    [sym_comment] = ACTIONS(721),
    [anon_sym_POUND_] = ACTIONS(724),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(770),
    [aux_sym_num_lit_token1] = ACTIONS(69),
    [anon_sym_COLON] = ACTIONS(772),
    [anon_sym_COLON_COLON] = ACTIONS(74),
    [anon_sym_DQUOTE] = ACTIONS(76),
    [sym_nil_lit] = ACTIONS(770),
    [aux_sym_sym_lit_token1] = ACTIONS(78),
    [anon_sym_CARET] = ACTIONS(732),
    [anon_sym_POUND_CARET] = ACTIONS(735),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_RPAREN] = ACTIONS(741),
    [anon_sym_POUND0A] = ACTIONS(91),
    [anon_sym_POUND0a] = ACTIONS(91),
    [anon_sym_POUND_QMARK] = ACTIONS(93),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(95),
    [anon_sym_POUND_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_BQUOTE] = ACTIONS(101),
    [anon_sym_COMMA_AT] = ACTIONS(103),
    [anon_sym_COMMA] = ACTIONS(105),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(770),
    [anon_sym_cl] = ACTIONS(775),
    [anon_sym_EQ] = ACTIONS(778),
    [aux_sym_accumulation_verb_token1] = ACTIONS(748),
    [anon_sym_for] = ACTIONS(748),
    [anon_sym_and] = ACTIONS(748),
    [anon_sym_as] = ACTIONS(748),
    [anon_sym_with] = ACTIONS(748),
    [anon_sym_do] = ACTIONS(748),
    [anon_sym_while] = ACTIONS(748),
    [anon_sym_until] = ACTIONS(748),
    [anon_sym_repeat] = ACTIONS(748),
    [anon_sym_when] = ACTIONS(748),
    [anon_sym_if] = ACTIONS(748),
    [anon_sym_unless] = ACTIONS(748),
    [anon_sym_always] = ACTIONS(748),
    [anon_sym_thereis] = ACTIONS(748),
    [anon_sym_never] = ACTIONS(748),
    [anon_sym_else] = ACTIONS(748),
    [anon_sym_finally] = ACTIONS(748),
    [anon_sym_return] = ACTIONS(748),
    [anon_sym_initially] = ACTIONS(748),
    [anon_sym_POUNDP] = ACTIONS(114),
    [anon_sym_POUNDp] = ACTIONS(114),
    [sym_self_referential_reader_macro] = ACTIONS(780),
    [anon_sym_POUND_PLUS] = ACTIONS(118),
    [anon_sym_POUND_DASH] = ACTIONS(118),
    [anon_sym_POUNDC] = ACTIONS(120),
    [anon_sym_POUNDc] = ACTIONS(120),
  },
  [24] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(33),
    [sym_num_lit] = STATE(33),
    [sym_kwd_lit] = STATE(33),
    [sym_str_lit] = STATE(33),
    [sym_char_lit] = STATE(33),
    [sym_sym_lit] = STATE(1101),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(33),
    [sym__bare_list_lit] = STATE(1109),
    [sym_vec_lit] = STATE(33),
    [sym_set_lit] = STATE(33),
    [sym__bare_set_lit] = STATE(1117),
    [sym_read_cond_lit] = STATE(33),
    [sym_splicing_read_cond_lit] = STATE(33),
    [sym_var_quoting_lit] = STATE(33),
    [sym_quoting_lit] = STATE(33),
    [sym_syn_quoting_lit] = STATE(33),
    [sym_unquote_splicing_lit] = STATE(33),
    [sym_unquoting_lit] = STATE(33),
    [sym_defun] = STATE(1109),
    [sym_loop_macro] = STATE(1109),
    [sym_path_lit] = STATE(33),
    [sym_package_lit] = STATE(33),
    [sym_include_reader_macro] = STATE(33),
    [sym_complex_num_lit] = STATE(33),
    [aux_sym_dis_expr_repeat1] = STATE(2),
    [aux_sym_list_lit_repeat1] = STATE(2812),
    [sym__ws] = ACTIONS(782),
    [sym_comment] = ACTIONS(782),
    [anon_sym_POUND_] = ACTIONS(785),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(788),
    [aux_sym_num_lit_token1] = ACTIONS(69),
    [anon_sym_COLON] = ACTIONS(790),
    [anon_sym_COLON_COLON] = ACTIONS(74),
    [anon_sym_DQUOTE] = ACTIONS(76),
    [sym_nil_lit] = ACTIONS(788),
    [aux_sym_sym_lit_token1] = ACTIONS(78),
    [anon_sym_CARET] = ACTIONS(793),
    [anon_sym_POUND_CARET] = ACTIONS(796),
    [anon_sym_LPAREN] = ACTIONS(799),
    [anon_sym_RPAREN] = ACTIONS(802),
    [anon_sym_POUND0A] = ACTIONS(91),
    [anon_sym_POUND0a] = ACTIONS(91),
    [anon_sym_POUND_QMARK] = ACTIONS(93),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(95),
    [anon_sym_POUND_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_BQUOTE] = ACTIONS(101),
    [anon_sym_COMMA_AT] = ACTIONS(103),
    [anon_sym_COMMA] = ACTIONS(105),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(788),
    [anon_sym_cl] = ACTIONS(804),
    [anon_sym_EQ] = ACTIONS(807),
    [aux_sym_accumulation_verb_token1] = ACTIONS(809),
    [anon_sym_for] = ACTIONS(809),
    [anon_sym_and] = ACTIONS(809),
    [anon_sym_as] = ACTIONS(809),
    [anon_sym_with] = ACTIONS(809),
    [anon_sym_do] = ACTIONS(809),
    [anon_sym_while] = ACTIONS(809),
    [anon_sym_until] = ACTIONS(809),
    [anon_sym_repeat] = ACTIONS(809),
    [anon_sym_when] = ACTIONS(809),
    [anon_sym_if] = ACTIONS(809),
    [anon_sym_unless] = ACTIONS(809),
    [anon_sym_always] = ACTIONS(809),
    [anon_sym_thereis] = ACTIONS(809),
    [anon_sym_never] = ACTIONS(809),
    [anon_sym_else] = ACTIONS(809),
    [anon_sym_finally] = ACTIONS(809),
    [anon_sym_return] = ACTIONS(809),
    [anon_sym_initially] = ACTIONS(809),
    [anon_sym_POUNDP] = ACTIONS(114),
    [anon_sym_POUNDp] = ACTIONS(114),
    [sym_self_referential_reader_macro] = ACTIONS(811),
    [anon_sym_POUND_PLUS] = ACTIONS(118),
    [anon_sym_POUND_DASH] = ACTIONS(118),
    [anon_sym_POUNDC] = ACTIONS(120),
    [anon_sym_POUNDc] = ACTIONS(120),
  },
  [25] = {
    [sym__gap] = STATE(990),
    [sym_dis_expr] = STATE(990),
    [sym__form] = STATE(2506),
    [sym_num_lit] = STATE(2506),
    [sym_kwd_lit] = STATE(2506),
    [sym_str_lit] = STATE(2506),
    [sym_char_lit] = STATE(2506),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2506),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2506),
    [sym_set_lit] = STATE(2506),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2506),
    [sym_splicing_read_cond_lit] = STATE(2506),
    [sym_var_quoting_lit] = STATE(2506),
    [sym_quoting_lit] = STATE(2506),
    [sym_syn_quoting_lit] = STATE(2506),
    [sym_unquote_splicing_lit] = STATE(2506),
    [sym_unquoting_lit] = STATE(2506),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2506),
    [sym_package_lit] = STATE(2506),
    [sym_include_reader_macro] = STATE(2506),
    [sym_complex_num_lit] = STATE(2506),
    [aux_sym_dis_expr_repeat1] = STATE(990),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(813),
    [sym_comment] = ACTIONS(813),
    [anon_sym_POUND_] = ACTIONS(817),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(821),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(823),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(821),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(827),
    [anon_sym_POUND_CARET] = ACTIONS(831),
    [anon_sym_LPAREN] = ACTIONS(835),
    [anon_sym_RPAREN] = ACTIONS(839),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(821),
    [anon_sym_cl] = ACTIONS(842),
    [anon_sym_EQ] = ACTIONS(846),
    [aux_sym_accumulation_verb_token1] = ACTIONS(848),
    [anon_sym_for] = ACTIONS(848),
    [anon_sym_and] = ACTIONS(848),
    [anon_sym_as] = ACTIONS(848),
    [anon_sym_with] = ACTIONS(848),
    [anon_sym_do] = ACTIONS(848),
    [anon_sym_while] = ACTIONS(848),
    [anon_sym_until] = ACTIONS(848),
    [anon_sym_repeat] = ACTIONS(848),
    [anon_sym_when] = ACTIONS(848),
    [anon_sym_if] = ACTIONS(848),
    [anon_sym_unless] = ACTIONS(848),
    [anon_sym_always] = ACTIONS(848),
    [anon_sym_thereis] = ACTIONS(848),
    [anon_sym_never] = ACTIONS(848),
    [anon_sym_else] = ACTIONS(848),
    [anon_sym_finally] = ACTIONS(848),
    [anon_sym_return] = ACTIONS(848),
    [anon_sym_initially] = ACTIONS(848),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(851),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [26] = {
    [sym__gap] = STATE(990),
    [sym_dis_expr] = STATE(990),
    [sym__form] = STATE(2544),
    [sym_num_lit] = STATE(2544),
    [sym_kwd_lit] = STATE(2544),
    [sym_str_lit] = STATE(2544),
    [sym_char_lit] = STATE(2544),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2544),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2544),
    [sym_set_lit] = STATE(2544),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2544),
    [sym_splicing_read_cond_lit] = STATE(2544),
    [sym_var_quoting_lit] = STATE(2544),
    [sym_quoting_lit] = STATE(2544),
    [sym_syn_quoting_lit] = STATE(2544),
    [sym_unquote_splicing_lit] = STATE(2544),
    [sym_unquoting_lit] = STATE(2544),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2544),
    [sym_package_lit] = STATE(2544),
    [sym_include_reader_macro] = STATE(2544),
    [sym_complex_num_lit] = STATE(2544),
    [aux_sym_dis_expr_repeat1] = STATE(990),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(853),
    [sym_comment] = ACTIONS(853),
    [anon_sym_POUND_] = ACTIONS(857),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(861),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(863),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(861),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(867),
    [anon_sym_POUND_CARET] = ACTIONS(871),
    [anon_sym_LPAREN] = ACTIONS(875),
    [anon_sym_RPAREN] = ACTIONS(879),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(861),
    [anon_sym_cl] = ACTIONS(882),
    [anon_sym_EQ] = ACTIONS(886),
    [aux_sym_accumulation_verb_token1] = ACTIONS(888),
    [anon_sym_for] = ACTIONS(888),
    [anon_sym_and] = ACTIONS(888),
    [anon_sym_as] = ACTIONS(888),
    [anon_sym_with] = ACTIONS(888),
    [anon_sym_do] = ACTIONS(888),
    [anon_sym_while] = ACTIONS(888),
    [anon_sym_until] = ACTIONS(888),
    [anon_sym_repeat] = ACTIONS(888),
    [anon_sym_when] = ACTIONS(888),
    [anon_sym_if] = ACTIONS(888),
    [anon_sym_unless] = ACTIONS(888),
    [anon_sym_always] = ACTIONS(888),
    [anon_sym_thereis] = ACTIONS(888),
    [anon_sym_never] = ACTIONS(888),
    [anon_sym_else] = ACTIONS(888),
    [anon_sym_finally] = ACTIONS(888),
    [anon_sym_return] = ACTIONS(888),
    [anon_sym_initially] = ACTIONS(888),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(891),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [27] = {
    [sym__gap] = STATE(35),
    [sym_dis_expr] = STATE(35),
    [sym__form] = STATE(2046),
    [sym_num_lit] = STATE(2046),
    [sym_kwd_lit] = STATE(2046),
    [sym_str_lit] = STATE(2046),
    [sym_char_lit] = STATE(2046),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2046),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2046),
    [sym_set_lit] = STATE(2046),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2046),
    [sym_splicing_read_cond_lit] = STATE(2046),
    [sym_var_quoting_lit] = STATE(2046),
    [sym_quoting_lit] = STATE(2046),
    [sym_syn_quoting_lit] = STATE(2046),
    [sym_unquote_splicing_lit] = STATE(2046),
    [sym_unquoting_lit] = STATE(2046),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2046),
    [sym_package_lit] = STATE(2046),
    [sym_include_reader_macro] = STATE(2046),
    [sym_complex_num_lit] = STATE(2046),
    [aux_sym_dis_expr_repeat1] = STATE(35),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(893),
    [sym_comment] = ACTIONS(893),
    [anon_sym_POUND_] = ACTIONS(645),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(897),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(899),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(897),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(655),
    [anon_sym_POUND_CARET] = ACTIONS(659),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_RPAREN] = ACTIONS(667),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(897),
    [anon_sym_cl] = ACTIONS(903),
    [anon_sym_EQ] = ACTIONS(907),
    [aux_sym_accumulation_verb_token1] = ACTIONS(676),
    [anon_sym_for] = ACTIONS(676),
    [anon_sym_and] = ACTIONS(676),
    [anon_sym_as] = ACTIONS(676),
    [anon_sym_with] = ACTIONS(676),
    [anon_sym_do] = ACTIONS(676),
    [anon_sym_while] = ACTIONS(676),
    [anon_sym_until] = ACTIONS(676),
    [anon_sym_repeat] = ACTIONS(676),
    [anon_sym_when] = ACTIONS(676),
    [anon_sym_if] = ACTIONS(676),
    [anon_sym_unless] = ACTIONS(676),
    [anon_sym_always] = ACTIONS(676),
    [anon_sym_thereis] = ACTIONS(676),
    [anon_sym_never] = ACTIONS(676),
    [anon_sym_else] = ACTIONS(676),
    [anon_sym_finally] = ACTIONS(676),
    [anon_sym_return] = ACTIONS(676),
    [anon_sym_initially] = ACTIONS(676),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(909),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [28] = {
    [sym__gap] = STATE(990),
    [sym_dis_expr] = STATE(990),
    [sym__form] = STATE(2142),
    [sym_num_lit] = STATE(2142),
    [sym_kwd_lit] = STATE(2142),
    [sym_str_lit] = STATE(2142),
    [sym_char_lit] = STATE(2142),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2142),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2142),
    [sym_set_lit] = STATE(2142),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2142),
    [sym_splicing_read_cond_lit] = STATE(2142),
    [sym_var_quoting_lit] = STATE(2142),
    [sym_quoting_lit] = STATE(2142),
    [sym_syn_quoting_lit] = STATE(2142),
    [sym_unquote_splicing_lit] = STATE(2142),
    [sym_unquoting_lit] = STATE(2142),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2142),
    [sym_package_lit] = STATE(2142),
    [sym_include_reader_macro] = STATE(2142),
    [sym_complex_num_lit] = STATE(2142),
    [aux_sym_dis_expr_repeat1] = STATE(990),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(911),
    [sym_comment] = ACTIONS(911),
    [anon_sym_POUND_] = ACTIONS(915),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(919),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(921),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(919),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(925),
    [anon_sym_POUND_CARET] = ACTIONS(929),
    [anon_sym_LPAREN] = ACTIONS(933),
    [anon_sym_RPAREN] = ACTIONS(937),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(919),
    [anon_sym_cl] = ACTIONS(940),
    [anon_sym_EQ] = ACTIONS(944),
    [aux_sym_accumulation_verb_token1] = ACTIONS(946),
    [anon_sym_for] = ACTIONS(946),
    [anon_sym_and] = ACTIONS(946),
    [anon_sym_as] = ACTIONS(946),
    [anon_sym_with] = ACTIONS(946),
    [anon_sym_do] = ACTIONS(946),
    [anon_sym_while] = ACTIONS(946),
    [anon_sym_until] = ACTIONS(946),
    [anon_sym_repeat] = ACTIONS(946),
    [anon_sym_when] = ACTIONS(946),
    [anon_sym_if] = ACTIONS(946),
    [anon_sym_unless] = ACTIONS(946),
    [anon_sym_always] = ACTIONS(946),
    [anon_sym_thereis] = ACTIONS(946),
    [anon_sym_never] = ACTIONS(946),
    [anon_sym_else] = ACTIONS(946),
    [anon_sym_finally] = ACTIONS(946),
    [anon_sym_return] = ACTIONS(946),
    [anon_sym_initially] = ACTIONS(946),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(949),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [29] = {
    [sym__gap] = STATE(990),
    [sym_dis_expr] = STATE(990),
    [sym__form] = STATE(2152),
    [sym_num_lit] = STATE(2152),
    [sym_kwd_lit] = STATE(2152),
    [sym_str_lit] = STATE(2152),
    [sym_char_lit] = STATE(2152),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2152),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2152),
    [sym_set_lit] = STATE(2152),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2152),
    [sym_splicing_read_cond_lit] = STATE(2152),
    [sym_var_quoting_lit] = STATE(2152),
    [sym_quoting_lit] = STATE(2152),
    [sym_syn_quoting_lit] = STATE(2152),
    [sym_unquote_splicing_lit] = STATE(2152),
    [sym_unquoting_lit] = STATE(2152),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2152),
    [sym_package_lit] = STATE(2152),
    [sym_include_reader_macro] = STATE(2152),
    [sym_complex_num_lit] = STATE(2152),
    [aux_sym_dis_expr_repeat1] = STATE(990),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(951),
    [sym_comment] = ACTIONS(951),
    [anon_sym_POUND_] = ACTIONS(955),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(959),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(961),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(959),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(965),
    [anon_sym_POUND_CARET] = ACTIONS(969),
    [anon_sym_LPAREN] = ACTIONS(973),
    [anon_sym_RPAREN] = ACTIONS(977),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(959),
    [anon_sym_cl] = ACTIONS(980),
    [anon_sym_EQ] = ACTIONS(984),
    [aux_sym_accumulation_verb_token1] = ACTIONS(986),
    [anon_sym_for] = ACTIONS(986),
    [anon_sym_and] = ACTIONS(986),
    [anon_sym_as] = ACTIONS(986),
    [anon_sym_with] = ACTIONS(986),
    [anon_sym_do] = ACTIONS(986),
    [anon_sym_while] = ACTIONS(986),
    [anon_sym_until] = ACTIONS(986),
    [anon_sym_repeat] = ACTIONS(986),
    [anon_sym_when] = ACTIONS(986),
    [anon_sym_if] = ACTIONS(986),
    [anon_sym_unless] = ACTIONS(986),
    [anon_sym_always] = ACTIONS(986),
    [anon_sym_thereis] = ACTIONS(986),
    [anon_sym_never] = ACTIONS(986),
    [anon_sym_else] = ACTIONS(986),
    [anon_sym_finally] = ACTIONS(986),
    [anon_sym_return] = ACTIONS(986),
    [anon_sym_initially] = ACTIONS(986),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(989),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [30] = {
    [sym__gap] = STATE(36),
    [sym_dis_expr] = STATE(36),
    [sym__form] = STATE(2155),
    [sym_num_lit] = STATE(2155),
    [sym_kwd_lit] = STATE(2155),
    [sym_str_lit] = STATE(2155),
    [sym_char_lit] = STATE(2155),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2155),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2155),
    [sym_set_lit] = STATE(2155),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2155),
    [sym_splicing_read_cond_lit] = STATE(2155),
    [sym_var_quoting_lit] = STATE(2155),
    [sym_quoting_lit] = STATE(2155),
    [sym_syn_quoting_lit] = STATE(2155),
    [sym_unquote_splicing_lit] = STATE(2155),
    [sym_unquoting_lit] = STATE(2155),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2155),
    [sym_package_lit] = STATE(2155),
    [sym_include_reader_macro] = STATE(2155),
    [sym_complex_num_lit] = STATE(2155),
    [aux_sym_dis_expr_repeat1] = STATE(36),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(991),
    [sym_comment] = ACTIONS(991),
    [anon_sym_POUND_] = ACTIONS(995),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(999),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1001),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(999),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1005),
    [anon_sym_POUND_CARET] = ACTIONS(1009),
    [anon_sym_LPAREN] = ACTIONS(1013),
    [anon_sym_RPAREN] = ACTIONS(1017),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(999),
    [anon_sym_cl] = ACTIONS(1020),
    [anon_sym_EQ] = ACTIONS(1024),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1026),
    [anon_sym_for] = ACTIONS(1026),
    [anon_sym_and] = ACTIONS(1026),
    [anon_sym_as] = ACTIONS(1026),
    [anon_sym_with] = ACTIONS(1026),
    [anon_sym_do] = ACTIONS(1026),
    [anon_sym_while] = ACTIONS(1026),
    [anon_sym_until] = ACTIONS(1026),
    [anon_sym_repeat] = ACTIONS(1026),
    [anon_sym_when] = ACTIONS(1026),
    [anon_sym_if] = ACTIONS(1026),
    [anon_sym_unless] = ACTIONS(1026),
    [anon_sym_always] = ACTIONS(1026),
    [anon_sym_thereis] = ACTIONS(1026),
    [anon_sym_never] = ACTIONS(1026),
    [anon_sym_else] = ACTIONS(1026),
    [anon_sym_finally] = ACTIONS(1026),
    [anon_sym_return] = ACTIONS(1026),
    [anon_sym_initially] = ACTIONS(1026),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1029),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [31] = {
    [sym__gap] = STATE(990),
    [sym_dis_expr] = STATE(990),
    [sym__form] = STATE(2163),
    [sym_num_lit] = STATE(2163),
    [sym_kwd_lit] = STATE(2163),
    [sym_str_lit] = STATE(2163),
    [sym_char_lit] = STATE(2163),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2163),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2163),
    [sym_set_lit] = STATE(2163),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2163),
    [sym_splicing_read_cond_lit] = STATE(2163),
    [sym_var_quoting_lit] = STATE(2163),
    [sym_quoting_lit] = STATE(2163),
    [sym_syn_quoting_lit] = STATE(2163),
    [sym_unquote_splicing_lit] = STATE(2163),
    [sym_unquoting_lit] = STATE(2163),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2163),
    [sym_package_lit] = STATE(2163),
    [sym_include_reader_macro] = STATE(2163),
    [sym_complex_num_lit] = STATE(2163),
    [aux_sym_dis_expr_repeat1] = STATE(990),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(951),
    [sym_comment] = ACTIONS(951),
    [anon_sym_POUND_] = ACTIONS(955),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1031),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1033),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1031),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(965),
    [anon_sym_POUND_CARET] = ACTIONS(969),
    [anon_sym_LPAREN] = ACTIONS(973),
    [anon_sym_RPAREN] = ACTIONS(977),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1031),
    [anon_sym_cl] = ACTIONS(1037),
    [anon_sym_EQ] = ACTIONS(1041),
    [aux_sym_accumulation_verb_token1] = ACTIONS(986),
    [anon_sym_for] = ACTIONS(986),
    [anon_sym_and] = ACTIONS(986),
    [anon_sym_as] = ACTIONS(986),
    [anon_sym_with] = ACTIONS(986),
    [anon_sym_do] = ACTIONS(986),
    [anon_sym_while] = ACTIONS(986),
    [anon_sym_until] = ACTIONS(986),
    [anon_sym_repeat] = ACTIONS(986),
    [anon_sym_when] = ACTIONS(986),
    [anon_sym_if] = ACTIONS(986),
    [anon_sym_unless] = ACTIONS(986),
    [anon_sym_always] = ACTIONS(986),
    [anon_sym_thereis] = ACTIONS(986),
    [anon_sym_never] = ACTIONS(986),
    [anon_sym_else] = ACTIONS(986),
    [anon_sym_finally] = ACTIONS(986),
    [anon_sym_return] = ACTIONS(986),
    [anon_sym_initially] = ACTIONS(986),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1043),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [32] = {
    [sym__gap] = STATE(37),
    [sym_dis_expr] = STATE(37),
    [sym__form] = STATE(2165),
    [sym_num_lit] = STATE(2165),
    [sym_kwd_lit] = STATE(2165),
    [sym_str_lit] = STATE(2165),
    [sym_char_lit] = STATE(2165),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2165),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2165),
    [sym_set_lit] = STATE(2165),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2165),
    [sym_splicing_read_cond_lit] = STATE(2165),
    [sym_var_quoting_lit] = STATE(2165),
    [sym_quoting_lit] = STATE(2165),
    [sym_syn_quoting_lit] = STATE(2165),
    [sym_unquote_splicing_lit] = STATE(2165),
    [sym_unquoting_lit] = STATE(2165),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2165),
    [sym_package_lit] = STATE(2165),
    [sym_include_reader_macro] = STATE(2165),
    [sym_complex_num_lit] = STATE(2165),
    [aux_sym_dis_expr_repeat1] = STATE(37),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1045),
    [sym_comment] = ACTIONS(1045),
    [anon_sym_POUND_] = ACTIONS(995),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1049),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1051),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1049),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1005),
    [anon_sym_POUND_CARET] = ACTIONS(1009),
    [anon_sym_LPAREN] = ACTIONS(1013),
    [anon_sym_RPAREN] = ACTIONS(1017),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1049),
    [anon_sym_cl] = ACTIONS(1055),
    [anon_sym_EQ] = ACTIONS(1059),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1026),
    [anon_sym_for] = ACTIONS(1026),
    [anon_sym_and] = ACTIONS(1026),
    [anon_sym_as] = ACTIONS(1026),
    [anon_sym_with] = ACTIONS(1026),
    [anon_sym_do] = ACTIONS(1026),
    [anon_sym_while] = ACTIONS(1026),
    [anon_sym_until] = ACTIONS(1026),
    [anon_sym_repeat] = ACTIONS(1026),
    [anon_sym_when] = ACTIONS(1026),
    [anon_sym_if] = ACTIONS(1026),
    [anon_sym_unless] = ACTIONS(1026),
    [anon_sym_always] = ACTIONS(1026),
    [anon_sym_thereis] = ACTIONS(1026),
    [anon_sym_never] = ACTIONS(1026),
    [anon_sym_else] = ACTIONS(1026),
    [anon_sym_finally] = ACTIONS(1026),
    [anon_sym_return] = ACTIONS(1026),
    [anon_sym_initially] = ACTIONS(1026),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1061),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [33] = {
    [sym__gap] = STATE(38),
    [sym_dis_expr] = STATE(38),
    [sym__form] = STATE(2168),
    [sym_num_lit] = STATE(2168),
    [sym_kwd_lit] = STATE(2168),
    [sym_str_lit] = STATE(2168),
    [sym_char_lit] = STATE(2168),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2168),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2168),
    [sym_set_lit] = STATE(2168),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2168),
    [sym_splicing_read_cond_lit] = STATE(2168),
    [sym_var_quoting_lit] = STATE(2168),
    [sym_quoting_lit] = STATE(2168),
    [sym_syn_quoting_lit] = STATE(2168),
    [sym_unquote_splicing_lit] = STATE(2168),
    [sym_unquoting_lit] = STATE(2168),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2168),
    [sym_package_lit] = STATE(2168),
    [sym_include_reader_macro] = STATE(2168),
    [sym_complex_num_lit] = STATE(2168),
    [aux_sym_dis_expr_repeat1] = STATE(38),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1063),
    [sym_comment] = ACTIONS(1063),
    [anon_sym_POUND_] = ACTIONS(1067),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1071),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1073),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1071),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1077),
    [anon_sym_POUND_CARET] = ACTIONS(1081),
    [anon_sym_LPAREN] = ACTIONS(1085),
    [anon_sym_RPAREN] = ACTIONS(1089),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1071),
    [anon_sym_cl] = ACTIONS(1092),
    [anon_sym_EQ] = ACTIONS(1096),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1098),
    [anon_sym_for] = ACTIONS(1098),
    [anon_sym_and] = ACTIONS(1098),
    [anon_sym_as] = ACTIONS(1098),
    [anon_sym_with] = ACTIONS(1098),
    [anon_sym_do] = ACTIONS(1098),
    [anon_sym_while] = ACTIONS(1098),
    [anon_sym_until] = ACTIONS(1098),
    [anon_sym_repeat] = ACTIONS(1098),
    [anon_sym_when] = ACTIONS(1098),
    [anon_sym_if] = ACTIONS(1098),
    [anon_sym_unless] = ACTIONS(1098),
    [anon_sym_always] = ACTIONS(1098),
    [anon_sym_thereis] = ACTIONS(1098),
    [anon_sym_never] = ACTIONS(1098),
    [anon_sym_else] = ACTIONS(1098),
    [anon_sym_finally] = ACTIONS(1098),
    [anon_sym_return] = ACTIONS(1098),
    [anon_sym_initially] = ACTIONS(1098),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1101),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [34] = {
    [sym__gap] = STATE(10),
    [sym_dis_expr] = STATE(10),
    [sym__form] = STATE(9),
    [sym_num_lit] = STATE(9),
    [sym_kwd_lit] = STATE(9),
    [sym_str_lit] = STATE(9),
    [sym_char_lit] = STATE(9),
    [sym_sym_lit] = STATE(1101),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(9),
    [sym__bare_list_lit] = STATE(1109),
    [sym_vec_lit] = STATE(9),
    [sym_set_lit] = STATE(9),
    [sym__bare_set_lit] = STATE(1117),
    [sym_read_cond_lit] = STATE(9),
    [sym_splicing_read_cond_lit] = STATE(9),
    [sym_var_quoting_lit] = STATE(9),
    [sym_quoting_lit] = STATE(9),
    [sym_syn_quoting_lit] = STATE(9),
    [sym_unquote_splicing_lit] = STATE(9),
    [sym_unquoting_lit] = STATE(9),
    [sym_defun] = STATE(1109),
    [sym_loop_macro] = STATE(1109),
    [sym_path_lit] = STATE(9),
    [sym_package_lit] = STATE(9),
    [sym_include_reader_macro] = STATE(9),
    [sym_complex_num_lit] = STATE(9),
    [aux_sym_dis_expr_repeat1] = STATE(10),
    [aux_sym_list_lit_repeat1] = STATE(2812),
    [sym__ws] = ACTIONS(1103),
    [sym_comment] = ACTIONS(1103),
    [anon_sym_POUND_] = ACTIONS(272),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_DOT] = ACTIONS(1106),
    [aux_sym_num_lit_token1] = ACTIONS(69),
    [anon_sym_COLON] = ACTIONS(1108),
    [anon_sym_COLON_COLON] = ACTIONS(74),
    [anon_sym_DQUOTE] = ACTIONS(76),
    [sym_nil_lit] = ACTIONS(1106),
    [aux_sym_sym_lit_token1] = ACTIONS(78),
    [anon_sym_CARET] = ACTIONS(280),
    [anon_sym_POUND_CARET] = ACTIONS(283),
    [anon_sym_LPAREN] = ACTIONS(286),
    [anon_sym_RPAREN] = ACTIONS(289),
    [anon_sym_POUND0A] = ACTIONS(91),
    [anon_sym_POUND0a] = ACTIONS(91),
    [anon_sym_POUND_QMARK] = ACTIONS(93),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(95),
    [anon_sym_POUND_SQUOTE] = ACTIONS(97),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_BQUOTE] = ACTIONS(101),
    [anon_sym_COMMA_AT] = ACTIONS(103),
    [anon_sym_COMMA] = ACTIONS(105),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1106),
    [anon_sym_cl] = ACTIONS(1111),
    [anon_sym_EQ] = ACTIONS(1114),
    [aux_sym_accumulation_verb_token1] = ACTIONS(296),
    [anon_sym_for] = ACTIONS(296),
    [anon_sym_and] = ACTIONS(296),
    [anon_sym_as] = ACTIONS(296),
    [anon_sym_with] = ACTIONS(296),
    [anon_sym_do] = ACTIONS(296),
    [anon_sym_while] = ACTIONS(296),
    [anon_sym_until] = ACTIONS(296),
    [anon_sym_repeat] = ACTIONS(296),
    [anon_sym_when] = ACTIONS(296),
    [anon_sym_if] = ACTIONS(296),
    [anon_sym_unless] = ACTIONS(296),
    [anon_sym_always] = ACTIONS(296),
    [anon_sym_thereis] = ACTIONS(296),
    [anon_sym_never] = ACTIONS(296),
    [anon_sym_else] = ACTIONS(296),
    [anon_sym_finally] = ACTIONS(296),
    [anon_sym_return] = ACTIONS(296),
    [anon_sym_initially] = ACTIONS(296),
    [anon_sym_POUNDP] = ACTIONS(114),
    [anon_sym_POUNDp] = ACTIONS(114),
    [sym_self_referential_reader_macro] = ACTIONS(1116),
    [anon_sym_POUND_PLUS] = ACTIONS(118),
    [anon_sym_POUND_DASH] = ACTIONS(118),
    [anon_sym_POUNDC] = ACTIONS(120),
    [anon_sym_POUNDc] = ACTIONS(120),
  },
  [35] = {
    [sym__gap] = STATE(990),
    [sym_dis_expr] = STATE(990),
    [sym__form] = STATE(2276),
    [sym_num_lit] = STATE(2276),
    [sym_kwd_lit] = STATE(2276),
    [sym_str_lit] = STATE(2276),
    [sym_char_lit] = STATE(2276),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2276),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2276),
    [sym_set_lit] = STATE(2276),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2276),
    [sym_splicing_read_cond_lit] = STATE(2276),
    [sym_var_quoting_lit] = STATE(2276),
    [sym_quoting_lit] = STATE(2276),
    [sym_syn_quoting_lit] = STATE(2276),
    [sym_unquote_splicing_lit] = STATE(2276),
    [sym_unquoting_lit] = STATE(2276),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2276),
    [sym_package_lit] = STATE(2276),
    [sym_include_reader_macro] = STATE(2276),
    [sym_complex_num_lit] = STATE(2276),
    [aux_sym_dis_expr_repeat1] = STATE(990),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(911),
    [sym_comment] = ACTIONS(911),
    [anon_sym_POUND_] = ACTIONS(915),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1118),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1120),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1118),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(925),
    [anon_sym_POUND_CARET] = ACTIONS(929),
    [anon_sym_LPAREN] = ACTIONS(933),
    [anon_sym_RPAREN] = ACTIONS(937),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1118),
    [anon_sym_cl] = ACTIONS(1124),
    [anon_sym_EQ] = ACTIONS(1128),
    [aux_sym_accumulation_verb_token1] = ACTIONS(946),
    [anon_sym_for] = ACTIONS(946),
    [anon_sym_and] = ACTIONS(946),
    [anon_sym_as] = ACTIONS(946),
    [anon_sym_with] = ACTIONS(946),
    [anon_sym_do] = ACTIONS(946),
    [anon_sym_while] = ACTIONS(946),
    [anon_sym_until] = ACTIONS(946),
    [anon_sym_repeat] = ACTIONS(946),
    [anon_sym_when] = ACTIONS(946),
    [anon_sym_if] = ACTIONS(946),
    [anon_sym_unless] = ACTIONS(946),
    [anon_sym_always] = ACTIONS(946),
    [anon_sym_thereis] = ACTIONS(946),
    [anon_sym_never] = ACTIONS(946),
    [anon_sym_else] = ACTIONS(946),
    [anon_sym_finally] = ACTIONS(946),
    [anon_sym_return] = ACTIONS(946),
    [anon_sym_initially] = ACTIONS(946),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1130),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [36] = {
    [sym__gap] = STATE(990),
    [sym_dis_expr] = STATE(990),
    [sym__form] = STATE(2545),
    [sym_num_lit] = STATE(2545),
    [sym_kwd_lit] = STATE(2545),
    [sym_str_lit] = STATE(2545),
    [sym_char_lit] = STATE(2545),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2545),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2545),
    [sym_set_lit] = STATE(2545),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2545),
    [sym_splicing_read_cond_lit] = STATE(2545),
    [sym_var_quoting_lit] = STATE(2545),
    [sym_quoting_lit] = STATE(2545),
    [sym_syn_quoting_lit] = STATE(2545),
    [sym_unquote_splicing_lit] = STATE(2545),
    [sym_unquoting_lit] = STATE(2545),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2545),
    [sym_package_lit] = STATE(2545),
    [sym_include_reader_macro] = STATE(2545),
    [sym_complex_num_lit] = STATE(2545),
    [aux_sym_dis_expr_repeat1] = STATE(990),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1132),
    [sym_comment] = ACTIONS(1132),
    [anon_sym_POUND_] = ACTIONS(1136),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1140),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1142),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1140),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1146),
    [anon_sym_POUND_CARET] = ACTIONS(1150),
    [anon_sym_LPAREN] = ACTIONS(1154),
    [anon_sym_RPAREN] = ACTIONS(1158),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1140),
    [anon_sym_cl] = ACTIONS(1161),
    [anon_sym_EQ] = ACTIONS(1165),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1167),
    [anon_sym_for] = ACTIONS(1167),
    [anon_sym_and] = ACTIONS(1167),
    [anon_sym_as] = ACTIONS(1167),
    [anon_sym_with] = ACTIONS(1167),
    [anon_sym_do] = ACTIONS(1167),
    [anon_sym_while] = ACTIONS(1167),
    [anon_sym_until] = ACTIONS(1167),
    [anon_sym_repeat] = ACTIONS(1167),
    [anon_sym_when] = ACTIONS(1167),
    [anon_sym_if] = ACTIONS(1167),
    [anon_sym_unless] = ACTIONS(1167),
    [anon_sym_always] = ACTIONS(1167),
    [anon_sym_thereis] = ACTIONS(1167),
    [anon_sym_never] = ACTIONS(1167),
    [anon_sym_else] = ACTIONS(1167),
    [anon_sym_finally] = ACTIONS(1167),
    [anon_sym_return] = ACTIONS(1167),
    [anon_sym_initially] = ACTIONS(1167),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1170),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [37] = {
    [sym__gap] = STATE(990),
    [sym_dis_expr] = STATE(990),
    [sym__form] = STATE(2058),
    [sym_num_lit] = STATE(2058),
    [sym_kwd_lit] = STATE(2058),
    [sym_str_lit] = STATE(2058),
    [sym_char_lit] = STATE(2058),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2058),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2058),
    [sym_set_lit] = STATE(2058),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2058),
    [sym_splicing_read_cond_lit] = STATE(2058),
    [sym_var_quoting_lit] = STATE(2058),
    [sym_quoting_lit] = STATE(2058),
    [sym_syn_quoting_lit] = STATE(2058),
    [sym_unquote_splicing_lit] = STATE(2058),
    [sym_unquoting_lit] = STATE(2058),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2058),
    [sym_package_lit] = STATE(2058),
    [sym_include_reader_macro] = STATE(2058),
    [sym_complex_num_lit] = STATE(2058),
    [aux_sym_dis_expr_repeat1] = STATE(990),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1132),
    [sym_comment] = ACTIONS(1132),
    [anon_sym_POUND_] = ACTIONS(1136),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1172),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1174),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1172),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1146),
    [anon_sym_POUND_CARET] = ACTIONS(1150),
    [anon_sym_LPAREN] = ACTIONS(1154),
    [anon_sym_RPAREN] = ACTIONS(1158),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1172),
    [anon_sym_cl] = ACTIONS(1178),
    [anon_sym_EQ] = ACTIONS(1182),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1167),
    [anon_sym_for] = ACTIONS(1167),
    [anon_sym_and] = ACTIONS(1167),
    [anon_sym_as] = ACTIONS(1167),
    [anon_sym_with] = ACTIONS(1167),
    [anon_sym_do] = ACTIONS(1167),
    [anon_sym_while] = ACTIONS(1167),
    [anon_sym_until] = ACTIONS(1167),
    [anon_sym_repeat] = ACTIONS(1167),
    [anon_sym_when] = ACTIONS(1167),
    [anon_sym_if] = ACTIONS(1167),
    [anon_sym_unless] = ACTIONS(1167),
    [anon_sym_always] = ACTIONS(1167),
    [anon_sym_thereis] = ACTIONS(1167),
    [anon_sym_never] = ACTIONS(1167),
    [anon_sym_else] = ACTIONS(1167),
    [anon_sym_finally] = ACTIONS(1167),
    [anon_sym_return] = ACTIONS(1167),
    [anon_sym_initially] = ACTIONS(1167),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1184),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [38] = {
    [sym__gap] = STATE(990),
    [sym_dis_expr] = STATE(990),
    [sym__form] = STATE(2064),
    [sym_num_lit] = STATE(2064),
    [sym_kwd_lit] = STATE(2064),
    [sym_str_lit] = STATE(2064),
    [sym_char_lit] = STATE(2064),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2064),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2064),
    [sym_set_lit] = STATE(2064),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2064),
    [sym_splicing_read_cond_lit] = STATE(2064),
    [sym_var_quoting_lit] = STATE(2064),
    [sym_quoting_lit] = STATE(2064),
    [sym_syn_quoting_lit] = STATE(2064),
    [sym_unquote_splicing_lit] = STATE(2064),
    [sym_unquoting_lit] = STATE(2064),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2064),
    [sym_package_lit] = STATE(2064),
    [sym_include_reader_macro] = STATE(2064),
    [sym_complex_num_lit] = STATE(2064),
    [aux_sym_dis_expr_repeat1] = STATE(990),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1186),
    [sym_comment] = ACTIONS(1186),
    [anon_sym_POUND_] = ACTIONS(1190),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1194),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1196),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1194),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1200),
    [anon_sym_POUND_CARET] = ACTIONS(1204),
    [anon_sym_LPAREN] = ACTIONS(1208),
    [anon_sym_RPAREN] = ACTIONS(1212),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1194),
    [anon_sym_cl] = ACTIONS(1215),
    [anon_sym_EQ] = ACTIONS(1219),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1221),
    [anon_sym_for] = ACTIONS(1221),
    [anon_sym_and] = ACTIONS(1221),
    [anon_sym_as] = ACTIONS(1221),
    [anon_sym_with] = ACTIONS(1221),
    [anon_sym_do] = ACTIONS(1221),
    [anon_sym_while] = ACTIONS(1221),
    [anon_sym_until] = ACTIONS(1221),
    [anon_sym_repeat] = ACTIONS(1221),
    [anon_sym_when] = ACTIONS(1221),
    [anon_sym_if] = ACTIONS(1221),
    [anon_sym_unless] = ACTIONS(1221),
    [anon_sym_always] = ACTIONS(1221),
    [anon_sym_thereis] = ACTIONS(1221),
    [anon_sym_never] = ACTIONS(1221),
    [anon_sym_else] = ACTIONS(1221),
    [anon_sym_finally] = ACTIONS(1221),
    [anon_sym_return] = ACTIONS(1221),
    [anon_sym_initially] = ACTIONS(1221),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1224),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [39] = {
    [sym__gap] = STATE(40),
    [sym_dis_expr] = STATE(40),
    [sym__form] = STATE(2067),
    [sym_num_lit] = STATE(2067),
    [sym_kwd_lit] = STATE(2067),
    [sym_str_lit] = STATE(2067),
    [sym_char_lit] = STATE(2067),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2067),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2067),
    [sym_set_lit] = STATE(2067),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2067),
    [sym_splicing_read_cond_lit] = STATE(2067),
    [sym_var_quoting_lit] = STATE(2067),
    [sym_quoting_lit] = STATE(2067),
    [sym_syn_quoting_lit] = STATE(2067),
    [sym_unquote_splicing_lit] = STATE(2067),
    [sym_unquoting_lit] = STATE(2067),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2067),
    [sym_package_lit] = STATE(2067),
    [sym_include_reader_macro] = STATE(2067),
    [sym_complex_num_lit] = STATE(2067),
    [aux_sym_dis_expr_repeat1] = STATE(40),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1226),
    [sym_comment] = ACTIONS(1226),
    [anon_sym_POUND_] = ACTIONS(1230),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1234),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1236),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1234),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1240),
    [anon_sym_POUND_CARET] = ACTIONS(1244),
    [anon_sym_LPAREN] = ACTIONS(1248),
    [anon_sym_RPAREN] = ACTIONS(1252),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1234),
    [anon_sym_cl] = ACTIONS(1255),
    [anon_sym_EQ] = ACTIONS(1259),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1261),
    [anon_sym_for] = ACTIONS(1261),
    [anon_sym_and] = ACTIONS(1261),
    [anon_sym_as] = ACTIONS(1261),
    [anon_sym_with] = ACTIONS(1261),
    [anon_sym_do] = ACTIONS(1261),
    [anon_sym_while] = ACTIONS(1261),
    [anon_sym_until] = ACTIONS(1261),
    [anon_sym_repeat] = ACTIONS(1261),
    [anon_sym_when] = ACTIONS(1261),
    [anon_sym_if] = ACTIONS(1261),
    [anon_sym_unless] = ACTIONS(1261),
    [anon_sym_always] = ACTIONS(1261),
    [anon_sym_thereis] = ACTIONS(1261),
    [anon_sym_never] = ACTIONS(1261),
    [anon_sym_else] = ACTIONS(1261),
    [anon_sym_finally] = ACTIONS(1261),
    [anon_sym_return] = ACTIONS(1261),
    [anon_sym_initially] = ACTIONS(1261),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1264),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [40] = {
    [sym__gap] = STATE(990),
    [sym_dis_expr] = STATE(990),
    [sym__form] = STATE(2280),
    [sym_num_lit] = STATE(2280),
    [sym_kwd_lit] = STATE(2280),
    [sym_str_lit] = STATE(2280),
    [sym_char_lit] = STATE(2280),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2280),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2280),
    [sym_set_lit] = STATE(2280),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2280),
    [sym_splicing_read_cond_lit] = STATE(2280),
    [sym_var_quoting_lit] = STATE(2280),
    [sym_quoting_lit] = STATE(2280),
    [sym_syn_quoting_lit] = STATE(2280),
    [sym_unquote_splicing_lit] = STATE(2280),
    [sym_unquoting_lit] = STATE(2280),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2280),
    [sym_package_lit] = STATE(2280),
    [sym_include_reader_macro] = STATE(2280),
    [sym_complex_num_lit] = STATE(2280),
    [aux_sym_dis_expr_repeat1] = STATE(990),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1266),
    [sym_comment] = ACTIONS(1266),
    [anon_sym_POUND_] = ACTIONS(1270),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1274),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1276),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1274),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1280),
    [anon_sym_POUND_CARET] = ACTIONS(1284),
    [anon_sym_LPAREN] = ACTIONS(1288),
    [anon_sym_RPAREN] = ACTIONS(1292),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1274),
    [anon_sym_cl] = ACTIONS(1295),
    [anon_sym_EQ] = ACTIONS(1299),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1301),
    [anon_sym_for] = ACTIONS(1301),
    [anon_sym_and] = ACTIONS(1301),
    [anon_sym_as] = ACTIONS(1301),
    [anon_sym_with] = ACTIONS(1301),
    [anon_sym_do] = ACTIONS(1301),
    [anon_sym_while] = ACTIONS(1301),
    [anon_sym_until] = ACTIONS(1301),
    [anon_sym_repeat] = ACTIONS(1301),
    [anon_sym_when] = ACTIONS(1301),
    [anon_sym_if] = ACTIONS(1301),
    [anon_sym_unless] = ACTIONS(1301),
    [anon_sym_always] = ACTIONS(1301),
    [anon_sym_thereis] = ACTIONS(1301),
    [anon_sym_never] = ACTIONS(1301),
    [anon_sym_else] = ACTIONS(1301),
    [anon_sym_finally] = ACTIONS(1301),
    [anon_sym_return] = ACTIONS(1301),
    [anon_sym_initially] = ACTIONS(1301),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1304),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [41] = {
    [sym__gap] = STATE(990),
    [sym_dis_expr] = STATE(990),
    [sym__form] = STATE(2104),
    [sym_num_lit] = STATE(2104),
    [sym_kwd_lit] = STATE(2104),
    [sym_str_lit] = STATE(2104),
    [sym_char_lit] = STATE(2104),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2104),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2104),
    [sym_set_lit] = STATE(2104),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2104),
    [sym_splicing_read_cond_lit] = STATE(2104),
    [sym_var_quoting_lit] = STATE(2104),
    [sym_quoting_lit] = STATE(2104),
    [sym_syn_quoting_lit] = STATE(2104),
    [sym_unquote_splicing_lit] = STATE(2104),
    [sym_unquoting_lit] = STATE(2104),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2104),
    [sym_package_lit] = STATE(2104),
    [sym_include_reader_macro] = STATE(2104),
    [sym_complex_num_lit] = STATE(2104),
    [aux_sym_dis_expr_repeat1] = STATE(990),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(853),
    [sym_comment] = ACTIONS(853),
    [anon_sym_POUND_] = ACTIONS(857),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1306),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1308),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1306),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(867),
    [anon_sym_POUND_CARET] = ACTIONS(871),
    [anon_sym_LPAREN] = ACTIONS(875),
    [anon_sym_RPAREN] = ACTIONS(879),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1306),
    [anon_sym_cl] = ACTIONS(1312),
    [anon_sym_EQ] = ACTIONS(1316),
    [aux_sym_accumulation_verb_token1] = ACTIONS(888),
    [anon_sym_for] = ACTIONS(888),
    [anon_sym_and] = ACTIONS(888),
    [anon_sym_as] = ACTIONS(888),
    [anon_sym_with] = ACTIONS(888),
    [anon_sym_do] = ACTIONS(888),
    [anon_sym_while] = ACTIONS(888),
    [anon_sym_until] = ACTIONS(888),
    [anon_sym_repeat] = ACTIONS(888),
    [anon_sym_when] = ACTIONS(888),
    [anon_sym_if] = ACTIONS(888),
    [anon_sym_unless] = ACTIONS(888),
    [anon_sym_always] = ACTIONS(888),
    [anon_sym_thereis] = ACTIONS(888),
    [anon_sym_never] = ACTIONS(888),
    [anon_sym_else] = ACTIONS(888),
    [anon_sym_finally] = ACTIONS(888),
    [anon_sym_return] = ACTIONS(888),
    [anon_sym_initially] = ACTIONS(888),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1318),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [42] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2444),
    [sym_num_lit] = STATE(2444),
    [sym_kwd_lit] = STATE(2444),
    [sym_str_lit] = STATE(2444),
    [sym_char_lit] = STATE(2444),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2444),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2444),
    [sym_set_lit] = STATE(2444),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2444),
    [sym_splicing_read_cond_lit] = STATE(2444),
    [sym_var_quoting_lit] = STATE(2444),
    [sym_quoting_lit] = STATE(2444),
    [sym_syn_quoting_lit] = STATE(2444),
    [sym_unquote_splicing_lit] = STATE(2444),
    [sym_unquoting_lit] = STATE(2444),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2444),
    [sym_package_lit] = STATE(2444),
    [sym_include_reader_macro] = STATE(2444),
    [sym_complex_num_lit] = STATE(2444),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1320),
    [sym_comment] = ACTIONS(1320),
    [anon_sym_POUND_] = ACTIONS(1323),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1326),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1328),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1326),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1331),
    [anon_sym_POUND_CARET] = ACTIONS(1334),
    [anon_sym_LPAREN] = ACTIONS(1337),
    [anon_sym_RPAREN] = ACTIONS(1340),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1326),
    [anon_sym_cl] = ACTIONS(1342),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1345),
    [anon_sym_for] = ACTIONS(1345),
    [anon_sym_and] = ACTIONS(1345),
    [anon_sym_as] = ACTIONS(1345),
    [anon_sym_with] = ACTIONS(1345),
    [anon_sym_do] = ACTIONS(1345),
    [anon_sym_while] = ACTIONS(1345),
    [anon_sym_until] = ACTIONS(1345),
    [anon_sym_repeat] = ACTIONS(1345),
    [anon_sym_when] = ACTIONS(1345),
    [anon_sym_if] = ACTIONS(1345),
    [anon_sym_unless] = ACTIONS(1345),
    [anon_sym_always] = ACTIONS(1345),
    [anon_sym_thereis] = ACTIONS(1345),
    [anon_sym_never] = ACTIONS(1345),
    [anon_sym_else] = ACTIONS(1345),
    [anon_sym_finally] = ACTIONS(1345),
    [anon_sym_return] = ACTIONS(1345),
    [anon_sym_initially] = ACTIONS(1345),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1347),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [43] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2489),
    [sym_num_lit] = STATE(2489),
    [sym_kwd_lit] = STATE(2489),
    [sym_str_lit] = STATE(2489),
    [sym_char_lit] = STATE(2489),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2489),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2489),
    [sym_set_lit] = STATE(2489),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2489),
    [sym_splicing_read_cond_lit] = STATE(2489),
    [sym_var_quoting_lit] = STATE(2489),
    [sym_quoting_lit] = STATE(2489),
    [sym_syn_quoting_lit] = STATE(2489),
    [sym_unquote_splicing_lit] = STATE(2489),
    [sym_unquoting_lit] = STATE(2489),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2489),
    [sym_package_lit] = STATE(2489),
    [sym_include_reader_macro] = STATE(2489),
    [sym_complex_num_lit] = STATE(2489),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1349),
    [sym_comment] = ACTIONS(1349),
    [anon_sym_POUND_] = ACTIONS(1352),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1355),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1357),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1355),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1360),
    [anon_sym_POUND_CARET] = ACTIONS(1363),
    [anon_sym_LPAREN] = ACTIONS(1366),
    [anon_sym_RPAREN] = ACTIONS(1369),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1355),
    [anon_sym_cl] = ACTIONS(1371),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1374),
    [anon_sym_for] = ACTIONS(1374),
    [anon_sym_and] = ACTIONS(1374),
    [anon_sym_as] = ACTIONS(1374),
    [anon_sym_with] = ACTIONS(1374),
    [anon_sym_do] = ACTIONS(1374),
    [anon_sym_while] = ACTIONS(1374),
    [anon_sym_until] = ACTIONS(1374),
    [anon_sym_repeat] = ACTIONS(1374),
    [anon_sym_when] = ACTIONS(1374),
    [anon_sym_if] = ACTIONS(1374),
    [anon_sym_unless] = ACTIONS(1374),
    [anon_sym_always] = ACTIONS(1374),
    [anon_sym_thereis] = ACTIONS(1374),
    [anon_sym_never] = ACTIONS(1374),
    [anon_sym_else] = ACTIONS(1374),
    [anon_sym_finally] = ACTIONS(1374),
    [anon_sym_return] = ACTIONS(1374),
    [anon_sym_initially] = ACTIONS(1374),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1376),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [44] = {
    [sym__gap] = STATE(70),
    [sym_dis_expr] = STATE(70),
    [sym__form] = STATE(2154),
    [sym_num_lit] = STATE(2154),
    [sym_kwd_lit] = STATE(2154),
    [sym_str_lit] = STATE(2154),
    [sym_char_lit] = STATE(2154),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2154),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2154),
    [sym_set_lit] = STATE(2154),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2154),
    [sym_splicing_read_cond_lit] = STATE(2154),
    [sym_var_quoting_lit] = STATE(2154),
    [sym_quoting_lit] = STATE(2154),
    [sym_syn_quoting_lit] = STATE(2154),
    [sym_unquote_splicing_lit] = STATE(2154),
    [sym_unquoting_lit] = STATE(2154),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2154),
    [sym_package_lit] = STATE(2154),
    [sym_include_reader_macro] = STATE(2154),
    [sym_complex_num_lit] = STATE(2154),
    [aux_sym_dis_expr_repeat1] = STATE(70),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1378),
    [sym_comment] = ACTIONS(1378),
    [anon_sym_POUND_] = ACTIONS(1381),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1384),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1386),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1384),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1389),
    [anon_sym_POUND_CARET] = ACTIONS(1392),
    [anon_sym_LPAREN] = ACTIONS(1395),
    [anon_sym_RPAREN] = ACTIONS(1398),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1384),
    [anon_sym_cl] = ACTIONS(1400),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1403),
    [anon_sym_for] = ACTIONS(1403),
    [anon_sym_and] = ACTIONS(1403),
    [anon_sym_as] = ACTIONS(1403),
    [anon_sym_with] = ACTIONS(1403),
    [anon_sym_do] = ACTIONS(1403),
    [anon_sym_while] = ACTIONS(1403),
    [anon_sym_until] = ACTIONS(1403),
    [anon_sym_repeat] = ACTIONS(1403),
    [anon_sym_when] = ACTIONS(1403),
    [anon_sym_if] = ACTIONS(1403),
    [anon_sym_unless] = ACTIONS(1403),
    [anon_sym_always] = ACTIONS(1403),
    [anon_sym_thereis] = ACTIONS(1403),
    [anon_sym_never] = ACTIONS(1403),
    [anon_sym_else] = ACTIONS(1403),
    [anon_sym_finally] = ACTIONS(1403),
    [anon_sym_return] = ACTIONS(1403),
    [anon_sym_initially] = ACTIONS(1403),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1405),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [45] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2255),
    [sym_num_lit] = STATE(2255),
    [sym_kwd_lit] = STATE(2255),
    [sym_str_lit] = STATE(2255),
    [sym_char_lit] = STATE(2255),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2255),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2255),
    [sym_set_lit] = STATE(2255),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2255),
    [sym_splicing_read_cond_lit] = STATE(2255),
    [sym_var_quoting_lit] = STATE(2255),
    [sym_quoting_lit] = STATE(2255),
    [sym_syn_quoting_lit] = STATE(2255),
    [sym_unquote_splicing_lit] = STATE(2255),
    [sym_unquoting_lit] = STATE(2255),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2255),
    [sym_package_lit] = STATE(2255),
    [sym_include_reader_macro] = STATE(2255),
    [sym_complex_num_lit] = STATE(2255),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1407),
    [sym_comment] = ACTIONS(1407),
    [anon_sym_POUND_] = ACTIONS(1381),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1410),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1386),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1410),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1389),
    [anon_sym_POUND_CARET] = ACTIONS(1392),
    [anon_sym_LPAREN] = ACTIONS(1395),
    [anon_sym_RPAREN] = ACTIONS(1398),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1410),
    [anon_sym_cl] = ACTIONS(1400),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1403),
    [anon_sym_for] = ACTIONS(1403),
    [anon_sym_and] = ACTIONS(1403),
    [anon_sym_as] = ACTIONS(1403),
    [anon_sym_with] = ACTIONS(1403),
    [anon_sym_do] = ACTIONS(1403),
    [anon_sym_while] = ACTIONS(1403),
    [anon_sym_until] = ACTIONS(1403),
    [anon_sym_repeat] = ACTIONS(1403),
    [anon_sym_when] = ACTIONS(1403),
    [anon_sym_if] = ACTIONS(1403),
    [anon_sym_unless] = ACTIONS(1403),
    [anon_sym_always] = ACTIONS(1403),
    [anon_sym_thereis] = ACTIONS(1403),
    [anon_sym_never] = ACTIONS(1403),
    [anon_sym_else] = ACTIONS(1403),
    [anon_sym_finally] = ACTIONS(1403),
    [anon_sym_return] = ACTIONS(1403),
    [anon_sym_initially] = ACTIONS(1403),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1412),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [46] = {
    [sym__gap] = STATE(73),
    [sym_dis_expr] = STATE(73),
    [sym__form] = STATE(2047),
    [sym_num_lit] = STATE(2047),
    [sym_kwd_lit] = STATE(2047),
    [sym_str_lit] = STATE(2047),
    [sym_char_lit] = STATE(2047),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2047),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2047),
    [sym_set_lit] = STATE(2047),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2047),
    [sym_splicing_read_cond_lit] = STATE(2047),
    [sym_var_quoting_lit] = STATE(2047),
    [sym_quoting_lit] = STATE(2047),
    [sym_syn_quoting_lit] = STATE(2047),
    [sym_unquote_splicing_lit] = STATE(2047),
    [sym_unquoting_lit] = STATE(2047),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2047),
    [sym_package_lit] = STATE(2047),
    [sym_include_reader_macro] = STATE(2047),
    [sym_complex_num_lit] = STATE(2047),
    [aux_sym_dis_expr_repeat1] = STATE(73),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1414),
    [sym_comment] = ACTIONS(1414),
    [anon_sym_POUND_] = ACTIONS(1417),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1420),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1422),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1420),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1425),
    [anon_sym_POUND_CARET] = ACTIONS(1428),
    [anon_sym_LPAREN] = ACTIONS(1431),
    [anon_sym_RPAREN] = ACTIONS(1434),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1420),
    [anon_sym_cl] = ACTIONS(1436),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1439),
    [anon_sym_for] = ACTIONS(1439),
    [anon_sym_and] = ACTIONS(1439),
    [anon_sym_as] = ACTIONS(1439),
    [anon_sym_with] = ACTIONS(1439),
    [anon_sym_do] = ACTIONS(1439),
    [anon_sym_while] = ACTIONS(1439),
    [anon_sym_until] = ACTIONS(1439),
    [anon_sym_repeat] = ACTIONS(1439),
    [anon_sym_when] = ACTIONS(1439),
    [anon_sym_if] = ACTIONS(1439),
    [anon_sym_unless] = ACTIONS(1439),
    [anon_sym_always] = ACTIONS(1439),
    [anon_sym_thereis] = ACTIONS(1439),
    [anon_sym_never] = ACTIONS(1439),
    [anon_sym_else] = ACTIONS(1439),
    [anon_sym_finally] = ACTIONS(1439),
    [anon_sym_return] = ACTIONS(1439),
    [anon_sym_initially] = ACTIONS(1439),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1441),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [47] = {
    [sym__gap] = STATE(76),
    [sym_dis_expr] = STATE(76),
    [sym__form] = STATE(2105),
    [sym_num_lit] = STATE(2105),
    [sym_kwd_lit] = STATE(2105),
    [sym_str_lit] = STATE(2105),
    [sym_char_lit] = STATE(2105),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2105),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2105),
    [sym_set_lit] = STATE(2105),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2105),
    [sym_splicing_read_cond_lit] = STATE(2105),
    [sym_var_quoting_lit] = STATE(2105),
    [sym_quoting_lit] = STATE(2105),
    [sym_syn_quoting_lit] = STATE(2105),
    [sym_unquote_splicing_lit] = STATE(2105),
    [sym_unquoting_lit] = STATE(2105),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2105),
    [sym_package_lit] = STATE(2105),
    [sym_include_reader_macro] = STATE(2105),
    [sym_complex_num_lit] = STATE(2105),
    [aux_sym_dis_expr_repeat1] = STATE(76),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1443),
    [sym_comment] = ACTIONS(1443),
    [anon_sym_POUND_] = ACTIONS(1381),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1446),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1386),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1446),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1389),
    [anon_sym_POUND_CARET] = ACTIONS(1392),
    [anon_sym_LPAREN] = ACTIONS(1395),
    [anon_sym_RPAREN] = ACTIONS(1398),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1446),
    [anon_sym_cl] = ACTIONS(1400),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1403),
    [anon_sym_for] = ACTIONS(1403),
    [anon_sym_and] = ACTIONS(1403),
    [anon_sym_as] = ACTIONS(1403),
    [anon_sym_with] = ACTIONS(1403),
    [anon_sym_do] = ACTIONS(1403),
    [anon_sym_while] = ACTIONS(1403),
    [anon_sym_until] = ACTIONS(1403),
    [anon_sym_repeat] = ACTIONS(1403),
    [anon_sym_when] = ACTIONS(1403),
    [anon_sym_if] = ACTIONS(1403),
    [anon_sym_unless] = ACTIONS(1403),
    [anon_sym_always] = ACTIONS(1403),
    [anon_sym_thereis] = ACTIONS(1403),
    [anon_sym_never] = ACTIONS(1403),
    [anon_sym_else] = ACTIONS(1403),
    [anon_sym_finally] = ACTIONS(1403),
    [anon_sym_return] = ACTIONS(1403),
    [anon_sym_initially] = ACTIONS(1403),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1448),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [48] = {
    [sym__gap] = STATE(276),
    [sym_dis_expr] = STATE(276),
    [sym__form] = STATE(2735),
    [sym_num_lit] = STATE(2735),
    [sym_kwd_lit] = STATE(2735),
    [sym_str_lit] = STATE(2735),
    [sym_char_lit] = STATE(2735),
    [sym_sym_lit] = STATE(2766),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2735),
    [sym__bare_list_lit] = STATE(1975),
    [sym_vec_lit] = STATE(2735),
    [sym_set_lit] = STATE(2735),
    [sym__bare_set_lit] = STATE(1976),
    [sym_read_cond_lit] = STATE(2735),
    [sym_splicing_read_cond_lit] = STATE(2735),
    [sym_var_quoting_lit] = STATE(2735),
    [sym_quoting_lit] = STATE(2735),
    [sym_syn_quoting_lit] = STATE(2735),
    [sym_unquote_splicing_lit] = STATE(2735),
    [sym_unquoting_lit] = STATE(2735),
    [sym_defun] = STATE(1975),
    [sym_for_clause_word] = STATE(419),
    [sym__for_part] = STATE(1555),
    [sym_loop_macro] = STATE(1975),
    [sym_path_lit] = STATE(2735),
    [sym_package_lit] = STATE(2735),
    [sym_include_reader_macro] = STATE(2735),
    [sym_complex_num_lit] = STATE(2735),
    [aux_sym_dis_expr_repeat1] = STATE(276),
    [aux_sym_list_lit_repeat1] = STATE(2830),
    [aux_sym_for_clause_repeat1] = STATE(1261),
    [sym__ws] = ACTIONS(1450),
    [sym_comment] = ACTIONS(1450),
    [anon_sym_POUND_] = ACTIONS(1452),
    [anon_sym_POUND] = ACTIONS(1454),
    [anon_sym_DOT] = ACTIONS(1456),
    [aux_sym_num_lit_token1] = ACTIONS(1458),
    [anon_sym_COLON] = ACTIONS(1460),
    [anon_sym_COLON_COLON] = ACTIONS(1462),
    [anon_sym_DQUOTE] = ACTIONS(1464),
    [sym_nil_lit] = ACTIONS(1456),
    [aux_sym_sym_lit_token1] = ACTIONS(1466),
    [anon_sym_CARET] = ACTIONS(25),
    [anon_sym_POUND_CARET] = ACTIONS(27),
    [anon_sym_LPAREN] = ACTIONS(1468),
    [anon_sym_POUND0A] = ACTIONS(1470),
    [anon_sym_POUND0a] = ACTIONS(1470),
    [anon_sym_POUND_QMARK] = ACTIONS(1472),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(1474),
    [anon_sym_POUND_SQUOTE] = ACTIONS(1476),
    [anon_sym_SQUOTE] = ACTIONS(1478),
    [anon_sym_BQUOTE] = ACTIONS(1480),
    [anon_sym_COMMA_AT] = ACTIONS(1482),
    [anon_sym_COMMA] = ACTIONS(1484),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1456),
    [anon_sym_cl] = ACTIONS(1486),
    [anon_sym_in] = ACTIONS(1488),
    [anon_sym_across] = ACTIONS(1488),
    [anon_sym_being] = ACTIONS(1488),
    [anon_sym_using] = ACTIONS(1488),
    [aux_sym_for_clause_word_token1] = ACTIONS(1490),
    [anon_sym_below] = ACTIONS(1488),
    [anon_sym_above] = ACTIONS(1488),
    [anon_sym_from] = ACTIONS(1488),
    [anon_sym_to] = ACTIONS(1488),
    [anon_sym_upto] = ACTIONS(1488),
    [anon_sym_upfrom] = ACTIONS(1488),
    [anon_sym_downto] = ACTIONS(1488),
    [anon_sym_downfrom] = ACTIONS(1488),
    [anon_sym_on] = ACTIONS(1488),
    [anon_sym_by] = ACTIONS(1488),
    [anon_sym_then] = ACTIONS(1488),
    [anon_sym_EQ] = ACTIONS(1488),
    [anon_sym_POUNDP] = ACTIONS(1492),
    [anon_sym_POUNDp] = ACTIONS(1492),
    [sym_self_referential_reader_macro] = ACTIONS(1494),
    [anon_sym_POUND_PLUS] = ACTIONS(1496),
    [anon_sym_POUND_DASH] = ACTIONS(1496),
    [anon_sym_POUNDC] = ACTIONS(1498),
    [anon_sym_POUNDc] = ACTIONS(1498),
  },
  [49] = {
    [sym__gap] = STATE(80),
    [sym_dis_expr] = STATE(80),
    [sym__form] = STATE(2110),
    [sym_num_lit] = STATE(2110),
    [sym_kwd_lit] = STATE(2110),
    [sym_str_lit] = STATE(2110),
    [sym_char_lit] = STATE(2110),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2110),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2110),
    [sym_set_lit] = STATE(2110),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2110),
    [sym_splicing_read_cond_lit] = STATE(2110),
    [sym_var_quoting_lit] = STATE(2110),
    [sym_quoting_lit] = STATE(2110),
    [sym_syn_quoting_lit] = STATE(2110),
    [sym_unquote_splicing_lit] = STATE(2110),
    [sym_unquoting_lit] = STATE(2110),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2110),
    [sym_package_lit] = STATE(2110),
    [sym_include_reader_macro] = STATE(2110),
    [sym_complex_num_lit] = STATE(2110),
    [aux_sym_dis_expr_repeat1] = STATE(80),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1500),
    [sym_comment] = ACTIONS(1500),
    [anon_sym_POUND_] = ACTIONS(1503),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1506),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1508),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1506),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(732),
    [anon_sym_POUND_CARET] = ACTIONS(735),
    [anon_sym_LPAREN] = ACTIONS(1511),
    [anon_sym_RPAREN] = ACTIONS(741),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1506),
    [anon_sym_cl] = ACTIONS(1514),
    [aux_sym_accumulation_verb_token1] = ACTIONS(748),
    [anon_sym_for] = ACTIONS(748),
    [anon_sym_and] = ACTIONS(748),
    [anon_sym_as] = ACTIONS(748),
    [anon_sym_with] = ACTIONS(748),
    [anon_sym_do] = ACTIONS(748),
    [anon_sym_while] = ACTIONS(748),
    [anon_sym_until] = ACTIONS(748),
    [anon_sym_repeat] = ACTIONS(748),
    [anon_sym_when] = ACTIONS(748),
    [anon_sym_if] = ACTIONS(748),
    [anon_sym_unless] = ACTIONS(748),
    [anon_sym_always] = ACTIONS(748),
    [anon_sym_thereis] = ACTIONS(748),
    [anon_sym_never] = ACTIONS(748),
    [anon_sym_else] = ACTIONS(748),
    [anon_sym_finally] = ACTIONS(748),
    [anon_sym_return] = ACTIONS(748),
    [anon_sym_initially] = ACTIONS(748),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1517),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [50] = {
    [sym__gap] = STATE(271),
    [sym_dis_expr] = STATE(271),
    [sym__form] = STATE(2683),
    [sym_num_lit] = STATE(2683),
    [sym_kwd_lit] = STATE(2683),
    [sym_str_lit] = STATE(2683),
    [sym_char_lit] = STATE(2683),
    [sym_sym_lit] = STATE(2766),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2683),
    [sym__bare_list_lit] = STATE(1975),
    [sym_vec_lit] = STATE(2683),
    [sym_set_lit] = STATE(2683),
    [sym__bare_set_lit] = STATE(1976),
    [sym_read_cond_lit] = STATE(2683),
    [sym_splicing_read_cond_lit] = STATE(2683),
    [sym_var_quoting_lit] = STATE(2683),
    [sym_quoting_lit] = STATE(2683),
    [sym_syn_quoting_lit] = STATE(2683),
    [sym_unquote_splicing_lit] = STATE(2683),
    [sym_unquoting_lit] = STATE(2683),
    [sym_defun] = STATE(1975),
    [sym_for_clause_word] = STATE(419),
    [sym__for_part] = STATE(1555),
    [sym_loop_macro] = STATE(1975),
    [sym_path_lit] = STATE(2683),
    [sym_package_lit] = STATE(2683),
    [sym_include_reader_macro] = STATE(2683),
    [sym_complex_num_lit] = STATE(2683),
    [aux_sym_dis_expr_repeat1] = STATE(271),
    [aux_sym_list_lit_repeat1] = STATE(2830),
    [aux_sym_for_clause_repeat1] = STATE(1255),
    [sym__ws] = ACTIONS(1519),
    [sym_comment] = ACTIONS(1519),
    [anon_sym_POUND_] = ACTIONS(1452),
    [anon_sym_POUND] = ACTIONS(1454),
    [anon_sym_DOT] = ACTIONS(1521),
    [aux_sym_num_lit_token1] = ACTIONS(1458),
    [anon_sym_COLON] = ACTIONS(1460),
    [anon_sym_COLON_COLON] = ACTIONS(1462),
    [anon_sym_DQUOTE] = ACTIONS(1464),
    [sym_nil_lit] = ACTIONS(1521),
    [aux_sym_sym_lit_token1] = ACTIONS(1466),
    [anon_sym_CARET] = ACTIONS(25),
    [anon_sym_POUND_CARET] = ACTIONS(27),
    [anon_sym_LPAREN] = ACTIONS(1468),
    [anon_sym_POUND0A] = ACTIONS(1470),
    [anon_sym_POUND0a] = ACTIONS(1470),
    [anon_sym_POUND_QMARK] = ACTIONS(1472),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(1474),
    [anon_sym_POUND_SQUOTE] = ACTIONS(1476),
    [anon_sym_SQUOTE] = ACTIONS(1478),
    [anon_sym_BQUOTE] = ACTIONS(1480),
    [anon_sym_COMMA_AT] = ACTIONS(1482),
    [anon_sym_COMMA] = ACTIONS(1484),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1521),
    [anon_sym_cl] = ACTIONS(1486),
    [anon_sym_in] = ACTIONS(1488),
    [anon_sym_across] = ACTIONS(1488),
    [anon_sym_being] = ACTIONS(1488),
    [anon_sym_using] = ACTIONS(1488),
    [aux_sym_for_clause_word_token1] = ACTIONS(1490),
    [anon_sym_below] = ACTIONS(1488),
    [anon_sym_above] = ACTIONS(1488),
    [anon_sym_from] = ACTIONS(1488),
    [anon_sym_to] = ACTIONS(1488),
    [anon_sym_upto] = ACTIONS(1488),
    [anon_sym_upfrom] = ACTIONS(1488),
    [anon_sym_downto] = ACTIONS(1488),
    [anon_sym_downfrom] = ACTIONS(1488),
    [anon_sym_on] = ACTIONS(1488),
    [anon_sym_by] = ACTIONS(1488),
    [anon_sym_then] = ACTIONS(1488),
    [anon_sym_EQ] = ACTIONS(1488),
    [anon_sym_POUNDP] = ACTIONS(1492),
    [anon_sym_POUNDp] = ACTIONS(1492),
    [sym_self_referential_reader_macro] = ACTIONS(1523),
    [anon_sym_POUND_PLUS] = ACTIONS(1496),
    [anon_sym_POUND_DASH] = ACTIONS(1496),
    [anon_sym_POUNDC] = ACTIONS(1498),
    [anon_sym_POUNDc] = ACTIONS(1498),
  },
  [51] = {
    [sym__gap] = STATE(274),
    [sym_dis_expr] = STATE(274),
    [sym__form] = STATE(2693),
    [sym_num_lit] = STATE(2693),
    [sym_kwd_lit] = STATE(2693),
    [sym_str_lit] = STATE(2693),
    [sym_char_lit] = STATE(2693),
    [sym_sym_lit] = STATE(2766),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2693),
    [sym__bare_list_lit] = STATE(1975),
    [sym_vec_lit] = STATE(2693),
    [sym_set_lit] = STATE(2693),
    [sym__bare_set_lit] = STATE(1976),
    [sym_read_cond_lit] = STATE(2693),
    [sym_splicing_read_cond_lit] = STATE(2693),
    [sym_var_quoting_lit] = STATE(2693),
    [sym_quoting_lit] = STATE(2693),
    [sym_syn_quoting_lit] = STATE(2693),
    [sym_unquote_splicing_lit] = STATE(2693),
    [sym_unquoting_lit] = STATE(2693),
    [sym_defun] = STATE(1975),
    [sym_for_clause_word] = STATE(419),
    [sym__for_part] = STATE(1555),
    [sym_loop_macro] = STATE(1975),
    [sym_path_lit] = STATE(2693),
    [sym_package_lit] = STATE(2693),
    [sym_include_reader_macro] = STATE(2693),
    [sym_complex_num_lit] = STATE(2693),
    [aux_sym_dis_expr_repeat1] = STATE(274),
    [aux_sym_list_lit_repeat1] = STATE(2830),
    [aux_sym_for_clause_repeat1] = STATE(1275),
    [sym__ws] = ACTIONS(1525),
    [sym_comment] = ACTIONS(1525),
    [anon_sym_POUND_] = ACTIONS(1452),
    [anon_sym_POUND] = ACTIONS(1454),
    [anon_sym_DOT] = ACTIONS(1527),
    [aux_sym_num_lit_token1] = ACTIONS(1458),
    [anon_sym_COLON] = ACTIONS(1460),
    [anon_sym_COLON_COLON] = ACTIONS(1462),
    [anon_sym_DQUOTE] = ACTIONS(1464),
    [sym_nil_lit] = ACTIONS(1527),
    [aux_sym_sym_lit_token1] = ACTIONS(1466),
    [anon_sym_CARET] = ACTIONS(25),
    [anon_sym_POUND_CARET] = ACTIONS(27),
    [anon_sym_LPAREN] = ACTIONS(1468),
    [anon_sym_POUND0A] = ACTIONS(1470),
    [anon_sym_POUND0a] = ACTIONS(1470),
    [anon_sym_POUND_QMARK] = ACTIONS(1472),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(1474),
    [anon_sym_POUND_SQUOTE] = ACTIONS(1476),
    [anon_sym_SQUOTE] = ACTIONS(1478),
    [anon_sym_BQUOTE] = ACTIONS(1480),
    [anon_sym_COMMA_AT] = ACTIONS(1482),
    [anon_sym_COMMA] = ACTIONS(1484),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1527),
    [anon_sym_cl] = ACTIONS(1486),
    [anon_sym_in] = ACTIONS(1488),
    [anon_sym_across] = ACTIONS(1488),
    [anon_sym_being] = ACTIONS(1488),
    [anon_sym_using] = ACTIONS(1488),
    [aux_sym_for_clause_word_token1] = ACTIONS(1490),
    [anon_sym_below] = ACTIONS(1488),
    [anon_sym_above] = ACTIONS(1488),
    [anon_sym_from] = ACTIONS(1488),
    [anon_sym_to] = ACTIONS(1488),
    [anon_sym_upto] = ACTIONS(1488),
    [anon_sym_upfrom] = ACTIONS(1488),
    [anon_sym_downto] = ACTIONS(1488),
    [anon_sym_downfrom] = ACTIONS(1488),
    [anon_sym_on] = ACTIONS(1488),
    [anon_sym_by] = ACTIONS(1488),
    [anon_sym_then] = ACTIONS(1488),
    [anon_sym_EQ] = ACTIONS(1488),
    [anon_sym_POUNDP] = ACTIONS(1492),
    [anon_sym_POUNDp] = ACTIONS(1492),
    [sym_self_referential_reader_macro] = ACTIONS(1529),
    [anon_sym_POUND_PLUS] = ACTIONS(1496),
    [anon_sym_POUND_DASH] = ACTIONS(1496),
    [anon_sym_POUNDC] = ACTIONS(1498),
    [anon_sym_POUNDc] = ACTIONS(1498),
  },
  [52] = {
    [sym__gap] = STATE(86),
    [sym_dis_expr] = STATE(86),
    [sym__form] = STATE(2126),
    [sym_num_lit] = STATE(2126),
    [sym_kwd_lit] = STATE(2126),
    [sym_str_lit] = STATE(2126),
    [sym_char_lit] = STATE(2126),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2126),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2126),
    [sym_set_lit] = STATE(2126),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2126),
    [sym_splicing_read_cond_lit] = STATE(2126),
    [sym_var_quoting_lit] = STATE(2126),
    [sym_quoting_lit] = STATE(2126),
    [sym_syn_quoting_lit] = STATE(2126),
    [sym_unquote_splicing_lit] = STATE(2126),
    [sym_unquoting_lit] = STATE(2126),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2126),
    [sym_package_lit] = STATE(2126),
    [sym_include_reader_macro] = STATE(2126),
    [sym_complex_num_lit] = STATE(2126),
    [aux_sym_dis_expr_repeat1] = STATE(86),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1531),
    [sym_comment] = ACTIONS(1531),
    [anon_sym_POUND_] = ACTIONS(1503),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1534),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1508),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1534),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(732),
    [anon_sym_POUND_CARET] = ACTIONS(735),
    [anon_sym_LPAREN] = ACTIONS(1511),
    [anon_sym_RPAREN] = ACTIONS(741),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1534),
    [anon_sym_cl] = ACTIONS(1514),
    [aux_sym_accumulation_verb_token1] = ACTIONS(748),
    [anon_sym_for] = ACTIONS(748),
    [anon_sym_and] = ACTIONS(748),
    [anon_sym_as] = ACTIONS(748),
    [anon_sym_with] = ACTIONS(748),
    [anon_sym_do] = ACTIONS(748),
    [anon_sym_while] = ACTIONS(748),
    [anon_sym_until] = ACTIONS(748),
    [anon_sym_repeat] = ACTIONS(748),
    [anon_sym_when] = ACTIONS(748),
    [anon_sym_if] = ACTIONS(748),
    [anon_sym_unless] = ACTIONS(748),
    [anon_sym_always] = ACTIONS(748),
    [anon_sym_thereis] = ACTIONS(748),
    [anon_sym_never] = ACTIONS(748),
    [anon_sym_else] = ACTIONS(748),
    [anon_sym_finally] = ACTIONS(748),
    [anon_sym_return] = ACTIONS(748),
    [anon_sym_initially] = ACTIONS(748),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1536),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [53] = {
    [sym__gap] = STATE(270),
    [sym_dis_expr] = STATE(270),
    [sym__form] = STATE(2715),
    [sym_num_lit] = STATE(2715),
    [sym_kwd_lit] = STATE(2715),
    [sym_str_lit] = STATE(2715),
    [sym_char_lit] = STATE(2715),
    [sym_sym_lit] = STATE(2766),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2715),
    [sym__bare_list_lit] = STATE(1975),
    [sym_vec_lit] = STATE(2715),
    [sym_set_lit] = STATE(2715),
    [sym__bare_set_lit] = STATE(1976),
    [sym_read_cond_lit] = STATE(2715),
    [sym_splicing_read_cond_lit] = STATE(2715),
    [sym_var_quoting_lit] = STATE(2715),
    [sym_quoting_lit] = STATE(2715),
    [sym_syn_quoting_lit] = STATE(2715),
    [sym_unquote_splicing_lit] = STATE(2715),
    [sym_unquoting_lit] = STATE(2715),
    [sym_defun] = STATE(1975),
    [sym_for_clause_word] = STATE(419),
    [sym__for_part] = STATE(1555),
    [sym_loop_macro] = STATE(1975),
    [sym_path_lit] = STATE(2715),
    [sym_package_lit] = STATE(2715),
    [sym_include_reader_macro] = STATE(2715),
    [sym_complex_num_lit] = STATE(2715),
    [aux_sym_dis_expr_repeat1] = STATE(270),
    [aux_sym_list_lit_repeat1] = STATE(2830),
    [aux_sym_for_clause_repeat1] = STATE(1278),
    [sym__ws] = ACTIONS(1538),
    [sym_comment] = ACTIONS(1538),
    [anon_sym_POUND_] = ACTIONS(1452),
    [anon_sym_POUND] = ACTIONS(1454),
    [anon_sym_DOT] = ACTIONS(1540),
    [aux_sym_num_lit_token1] = ACTIONS(1458),
    [anon_sym_COLON] = ACTIONS(1460),
    [anon_sym_COLON_COLON] = ACTIONS(1462),
    [anon_sym_DQUOTE] = ACTIONS(1464),
    [sym_nil_lit] = ACTIONS(1540),
    [aux_sym_sym_lit_token1] = ACTIONS(1466),
    [anon_sym_CARET] = ACTIONS(25),
    [anon_sym_POUND_CARET] = ACTIONS(27),
    [anon_sym_LPAREN] = ACTIONS(1468),
    [anon_sym_POUND0A] = ACTIONS(1470),
    [anon_sym_POUND0a] = ACTIONS(1470),
    [anon_sym_POUND_QMARK] = ACTIONS(1472),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(1474),
    [anon_sym_POUND_SQUOTE] = ACTIONS(1476),
    [anon_sym_SQUOTE] = ACTIONS(1478),
    [anon_sym_BQUOTE] = ACTIONS(1480),
    [anon_sym_COMMA_AT] = ACTIONS(1482),
    [anon_sym_COMMA] = ACTIONS(1484),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1540),
    [anon_sym_cl] = ACTIONS(1486),
    [anon_sym_in] = ACTIONS(1488),
    [anon_sym_across] = ACTIONS(1488),
    [anon_sym_being] = ACTIONS(1488),
    [anon_sym_using] = ACTIONS(1488),
    [aux_sym_for_clause_word_token1] = ACTIONS(1490),
    [anon_sym_below] = ACTIONS(1488),
    [anon_sym_above] = ACTIONS(1488),
    [anon_sym_from] = ACTIONS(1488),
    [anon_sym_to] = ACTIONS(1488),
    [anon_sym_upto] = ACTIONS(1488),
    [anon_sym_upfrom] = ACTIONS(1488),
    [anon_sym_downto] = ACTIONS(1488),
    [anon_sym_downfrom] = ACTIONS(1488),
    [anon_sym_on] = ACTIONS(1488),
    [anon_sym_by] = ACTIONS(1488),
    [anon_sym_then] = ACTIONS(1488),
    [anon_sym_EQ] = ACTIONS(1488),
    [anon_sym_POUNDP] = ACTIONS(1492),
    [anon_sym_POUNDp] = ACTIONS(1492),
    [sym_self_referential_reader_macro] = ACTIONS(1542),
    [anon_sym_POUND_PLUS] = ACTIONS(1496),
    [anon_sym_POUND_DASH] = ACTIONS(1496),
    [anon_sym_POUNDC] = ACTIONS(1498),
    [anon_sym_POUNDc] = ACTIONS(1498),
  },
  [54] = {
    [sym__gap] = STATE(45),
    [sym_dis_expr] = STATE(45),
    [sym__form] = STATE(2518),
    [sym_num_lit] = STATE(2518),
    [sym_kwd_lit] = STATE(2518),
    [sym_str_lit] = STATE(2518),
    [sym_char_lit] = STATE(2518),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2518),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2518),
    [sym_set_lit] = STATE(2518),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2518),
    [sym_splicing_read_cond_lit] = STATE(2518),
    [sym_var_quoting_lit] = STATE(2518),
    [sym_quoting_lit] = STATE(2518),
    [sym_syn_quoting_lit] = STATE(2518),
    [sym_unquote_splicing_lit] = STATE(2518),
    [sym_unquoting_lit] = STATE(2518),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2518),
    [sym_package_lit] = STATE(2518),
    [sym_include_reader_macro] = STATE(2518),
    [sym_complex_num_lit] = STATE(2518),
    [aux_sym_dis_expr_repeat1] = STATE(45),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1544),
    [sym_comment] = ACTIONS(1544),
    [anon_sym_POUND_] = ACTIONS(1547),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1550),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1552),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1550),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(430),
    [anon_sym_POUND_CARET] = ACTIONS(433),
    [anon_sym_LPAREN] = ACTIONS(1555),
    [anon_sym_RPAREN] = ACTIONS(439),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1550),
    [anon_sym_cl] = ACTIONS(1558),
    [aux_sym_accumulation_verb_token1] = ACTIONS(446),
    [anon_sym_for] = ACTIONS(446),
    [anon_sym_and] = ACTIONS(446),
    [anon_sym_as] = ACTIONS(446),
    [anon_sym_with] = ACTIONS(446),
    [anon_sym_do] = ACTIONS(446),
    [anon_sym_while] = ACTIONS(446),
    [anon_sym_until] = ACTIONS(446),
    [anon_sym_repeat] = ACTIONS(446),
    [anon_sym_when] = ACTIONS(446),
    [anon_sym_if] = ACTIONS(446),
    [anon_sym_unless] = ACTIONS(446),
    [anon_sym_always] = ACTIONS(446),
    [anon_sym_thereis] = ACTIONS(446),
    [anon_sym_never] = ACTIONS(446),
    [anon_sym_else] = ACTIONS(446),
    [anon_sym_finally] = ACTIONS(446),
    [anon_sym_return] = ACTIONS(446),
    [anon_sym_initially] = ACTIONS(446),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1561),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [55] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2161),
    [sym_num_lit] = STATE(2161),
    [sym_kwd_lit] = STATE(2161),
    [sym_str_lit] = STATE(2161),
    [sym_char_lit] = STATE(2161),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2161),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2161),
    [sym_set_lit] = STATE(2161),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2161),
    [sym_splicing_read_cond_lit] = STATE(2161),
    [sym_var_quoting_lit] = STATE(2161),
    [sym_quoting_lit] = STATE(2161),
    [sym_syn_quoting_lit] = STATE(2161),
    [sym_unquote_splicing_lit] = STATE(2161),
    [sym_unquoting_lit] = STATE(2161),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2161),
    [sym_package_lit] = STATE(2161),
    [sym_include_reader_macro] = STATE(2161),
    [sym_complex_num_lit] = STATE(2161),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1563),
    [sym_comment] = ACTIONS(1563),
    [anon_sym_POUND_] = ACTIONS(1566),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1569),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1571),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1569),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1574),
    [anon_sym_POUND_CARET] = ACTIONS(1577),
    [anon_sym_LPAREN] = ACTIONS(1580),
    [anon_sym_RPAREN] = ACTIONS(1583),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1569),
    [anon_sym_cl] = ACTIONS(1585),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1588),
    [anon_sym_for] = ACTIONS(1588),
    [anon_sym_and] = ACTIONS(1588),
    [anon_sym_as] = ACTIONS(1588),
    [anon_sym_with] = ACTIONS(1588),
    [anon_sym_do] = ACTIONS(1588),
    [anon_sym_while] = ACTIONS(1588),
    [anon_sym_until] = ACTIONS(1588),
    [anon_sym_repeat] = ACTIONS(1588),
    [anon_sym_when] = ACTIONS(1588),
    [anon_sym_if] = ACTIONS(1588),
    [anon_sym_unless] = ACTIONS(1588),
    [anon_sym_always] = ACTIONS(1588),
    [anon_sym_thereis] = ACTIONS(1588),
    [anon_sym_never] = ACTIONS(1588),
    [anon_sym_else] = ACTIONS(1588),
    [anon_sym_finally] = ACTIONS(1588),
    [anon_sym_return] = ACTIONS(1588),
    [anon_sym_initially] = ACTIONS(1588),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1590),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [56] = {
    [sym__gap] = STATE(92),
    [sym_dis_expr] = STATE(92),
    [sym__form] = STATE(2166),
    [sym_num_lit] = STATE(2166),
    [sym_kwd_lit] = STATE(2166),
    [sym_str_lit] = STATE(2166),
    [sym_char_lit] = STATE(2166),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2166),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2166),
    [sym_set_lit] = STATE(2166),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2166),
    [sym_splicing_read_cond_lit] = STATE(2166),
    [sym_var_quoting_lit] = STATE(2166),
    [sym_quoting_lit] = STATE(2166),
    [sym_syn_quoting_lit] = STATE(2166),
    [sym_unquote_splicing_lit] = STATE(2166),
    [sym_unquoting_lit] = STATE(2166),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2166),
    [sym_package_lit] = STATE(2166),
    [sym_include_reader_macro] = STATE(2166),
    [sym_complex_num_lit] = STATE(2166),
    [aux_sym_dis_expr_repeat1] = STATE(92),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1592),
    [sym_comment] = ACTIONS(1592),
    [anon_sym_POUND_] = ACTIONS(1566),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1595),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1571),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1595),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1574),
    [anon_sym_POUND_CARET] = ACTIONS(1577),
    [anon_sym_LPAREN] = ACTIONS(1580),
    [anon_sym_RPAREN] = ACTIONS(1583),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1595),
    [anon_sym_cl] = ACTIONS(1585),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1588),
    [anon_sym_for] = ACTIONS(1588),
    [anon_sym_and] = ACTIONS(1588),
    [anon_sym_as] = ACTIONS(1588),
    [anon_sym_with] = ACTIONS(1588),
    [anon_sym_do] = ACTIONS(1588),
    [anon_sym_while] = ACTIONS(1588),
    [anon_sym_until] = ACTIONS(1588),
    [anon_sym_repeat] = ACTIONS(1588),
    [anon_sym_when] = ACTIONS(1588),
    [anon_sym_if] = ACTIONS(1588),
    [anon_sym_unless] = ACTIONS(1588),
    [anon_sym_always] = ACTIONS(1588),
    [anon_sym_thereis] = ACTIONS(1588),
    [anon_sym_never] = ACTIONS(1588),
    [anon_sym_else] = ACTIONS(1588),
    [anon_sym_finally] = ACTIONS(1588),
    [anon_sym_return] = ACTIONS(1588),
    [anon_sym_initially] = ACTIONS(1588),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1597),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [57] = {
    [sym__gap] = STATE(93),
    [sym_dis_expr] = STATE(93),
    [sym__form] = STATE(2200),
    [sym_num_lit] = STATE(2200),
    [sym_kwd_lit] = STATE(2200),
    [sym_str_lit] = STATE(2200),
    [sym_char_lit] = STATE(2200),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2200),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2200),
    [sym_set_lit] = STATE(2200),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2200),
    [sym_splicing_read_cond_lit] = STATE(2200),
    [sym_var_quoting_lit] = STATE(2200),
    [sym_quoting_lit] = STATE(2200),
    [sym_syn_quoting_lit] = STATE(2200),
    [sym_unquote_splicing_lit] = STATE(2200),
    [sym_unquoting_lit] = STATE(2200),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2200),
    [sym_package_lit] = STATE(2200),
    [sym_include_reader_macro] = STATE(2200),
    [sym_complex_num_lit] = STATE(2200),
    [aux_sym_dis_expr_repeat1] = STATE(93),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1599),
    [sym_comment] = ACTIONS(1599),
    [anon_sym_POUND_] = ACTIONS(1602),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1605),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1607),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1605),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1610),
    [anon_sym_POUND_CARET] = ACTIONS(1613),
    [anon_sym_LPAREN] = ACTIONS(1616),
    [anon_sym_RPAREN] = ACTIONS(1619),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1605),
    [anon_sym_cl] = ACTIONS(1621),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1624),
    [anon_sym_for] = ACTIONS(1624),
    [anon_sym_and] = ACTIONS(1624),
    [anon_sym_as] = ACTIONS(1624),
    [anon_sym_with] = ACTIONS(1624),
    [anon_sym_do] = ACTIONS(1624),
    [anon_sym_while] = ACTIONS(1624),
    [anon_sym_until] = ACTIONS(1624),
    [anon_sym_repeat] = ACTIONS(1624),
    [anon_sym_when] = ACTIONS(1624),
    [anon_sym_if] = ACTIONS(1624),
    [anon_sym_unless] = ACTIONS(1624),
    [anon_sym_always] = ACTIONS(1624),
    [anon_sym_thereis] = ACTIONS(1624),
    [anon_sym_never] = ACTIONS(1624),
    [anon_sym_else] = ACTIONS(1624),
    [anon_sym_finally] = ACTIONS(1624),
    [anon_sym_return] = ACTIONS(1624),
    [anon_sym_initially] = ACTIONS(1624),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1626),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [58] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2279),
    [sym_num_lit] = STATE(2279),
    [sym_kwd_lit] = STATE(2279),
    [sym_str_lit] = STATE(2279),
    [sym_char_lit] = STATE(2279),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2279),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2279),
    [sym_set_lit] = STATE(2279),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2279),
    [sym_splicing_read_cond_lit] = STATE(2279),
    [sym_var_quoting_lit] = STATE(2279),
    [sym_quoting_lit] = STATE(2279),
    [sym_syn_quoting_lit] = STATE(2279),
    [sym_unquote_splicing_lit] = STATE(2279),
    [sym_unquoting_lit] = STATE(2279),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2279),
    [sym_package_lit] = STATE(2279),
    [sym_include_reader_macro] = STATE(2279),
    [sym_complex_num_lit] = STATE(2279),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1628),
    [sym_comment] = ACTIONS(1628),
    [anon_sym_POUND_] = ACTIONS(1602),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1631),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1607),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1631),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1610),
    [anon_sym_POUND_CARET] = ACTIONS(1613),
    [anon_sym_LPAREN] = ACTIONS(1616),
    [anon_sym_RPAREN] = ACTIONS(1619),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1631),
    [anon_sym_cl] = ACTIONS(1621),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1624),
    [anon_sym_for] = ACTIONS(1624),
    [anon_sym_and] = ACTIONS(1624),
    [anon_sym_as] = ACTIONS(1624),
    [anon_sym_with] = ACTIONS(1624),
    [anon_sym_do] = ACTIONS(1624),
    [anon_sym_while] = ACTIONS(1624),
    [anon_sym_until] = ACTIONS(1624),
    [anon_sym_repeat] = ACTIONS(1624),
    [anon_sym_when] = ACTIONS(1624),
    [anon_sym_if] = ACTIONS(1624),
    [anon_sym_unless] = ACTIONS(1624),
    [anon_sym_always] = ACTIONS(1624),
    [anon_sym_thereis] = ACTIONS(1624),
    [anon_sym_never] = ACTIONS(1624),
    [anon_sym_else] = ACTIONS(1624),
    [anon_sym_finally] = ACTIONS(1624),
    [anon_sym_return] = ACTIONS(1624),
    [anon_sym_initially] = ACTIONS(1624),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1633),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [59] = {
    [sym__gap] = STATE(96),
    [sym_dis_expr] = STATE(96),
    [sym__form] = STATE(2339),
    [sym_num_lit] = STATE(2339),
    [sym_kwd_lit] = STATE(2339),
    [sym_str_lit] = STATE(2339),
    [sym_char_lit] = STATE(2339),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2339),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2339),
    [sym_set_lit] = STATE(2339),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2339),
    [sym_splicing_read_cond_lit] = STATE(2339),
    [sym_var_quoting_lit] = STATE(2339),
    [sym_quoting_lit] = STATE(2339),
    [sym_syn_quoting_lit] = STATE(2339),
    [sym_unquote_splicing_lit] = STATE(2339),
    [sym_unquoting_lit] = STATE(2339),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2339),
    [sym_package_lit] = STATE(2339),
    [sym_include_reader_macro] = STATE(2339),
    [sym_complex_num_lit] = STATE(2339),
    [aux_sym_dis_expr_repeat1] = STATE(96),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1635),
    [sym_comment] = ACTIONS(1635),
    [anon_sym_POUND_] = ACTIONS(1602),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1638),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1607),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1638),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1610),
    [anon_sym_POUND_CARET] = ACTIONS(1613),
    [anon_sym_LPAREN] = ACTIONS(1616),
    [anon_sym_RPAREN] = ACTIONS(1619),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1638),
    [anon_sym_cl] = ACTIONS(1621),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1624),
    [anon_sym_for] = ACTIONS(1624),
    [anon_sym_and] = ACTIONS(1624),
    [anon_sym_as] = ACTIONS(1624),
    [anon_sym_with] = ACTIONS(1624),
    [anon_sym_do] = ACTIONS(1624),
    [anon_sym_while] = ACTIONS(1624),
    [anon_sym_until] = ACTIONS(1624),
    [anon_sym_repeat] = ACTIONS(1624),
    [anon_sym_when] = ACTIONS(1624),
    [anon_sym_if] = ACTIONS(1624),
    [anon_sym_unless] = ACTIONS(1624),
    [anon_sym_always] = ACTIONS(1624),
    [anon_sym_thereis] = ACTIONS(1624),
    [anon_sym_never] = ACTIONS(1624),
    [anon_sym_else] = ACTIONS(1624),
    [anon_sym_finally] = ACTIONS(1624),
    [anon_sym_return] = ACTIONS(1624),
    [anon_sym_initially] = ACTIONS(1624),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1640),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [60] = {
    [sym__gap] = STATE(97),
    [sym_dis_expr] = STATE(97),
    [sym__form] = STATE(2363),
    [sym_num_lit] = STATE(2363),
    [sym_kwd_lit] = STATE(2363),
    [sym_str_lit] = STATE(2363),
    [sym_char_lit] = STATE(2363),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2363),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2363),
    [sym_set_lit] = STATE(2363),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2363),
    [sym_splicing_read_cond_lit] = STATE(2363),
    [sym_var_quoting_lit] = STATE(2363),
    [sym_quoting_lit] = STATE(2363),
    [sym_syn_quoting_lit] = STATE(2363),
    [sym_unquote_splicing_lit] = STATE(2363),
    [sym_unquoting_lit] = STATE(2363),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2363),
    [sym_package_lit] = STATE(2363),
    [sym_include_reader_macro] = STATE(2363),
    [sym_complex_num_lit] = STATE(2363),
    [aux_sym_dis_expr_repeat1] = STATE(97),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1642),
    [sym_comment] = ACTIONS(1642),
    [anon_sym_POUND_] = ACTIONS(1566),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1645),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1571),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1645),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1574),
    [anon_sym_POUND_CARET] = ACTIONS(1577),
    [anon_sym_LPAREN] = ACTIONS(1580),
    [anon_sym_RPAREN] = ACTIONS(1583),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1645),
    [anon_sym_cl] = ACTIONS(1585),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1588),
    [anon_sym_for] = ACTIONS(1588),
    [anon_sym_and] = ACTIONS(1588),
    [anon_sym_as] = ACTIONS(1588),
    [anon_sym_with] = ACTIONS(1588),
    [anon_sym_do] = ACTIONS(1588),
    [anon_sym_while] = ACTIONS(1588),
    [anon_sym_until] = ACTIONS(1588),
    [anon_sym_repeat] = ACTIONS(1588),
    [anon_sym_when] = ACTIONS(1588),
    [anon_sym_if] = ACTIONS(1588),
    [anon_sym_unless] = ACTIONS(1588),
    [anon_sym_always] = ACTIONS(1588),
    [anon_sym_thereis] = ACTIONS(1588),
    [anon_sym_never] = ACTIONS(1588),
    [anon_sym_else] = ACTIONS(1588),
    [anon_sym_finally] = ACTIONS(1588),
    [anon_sym_return] = ACTIONS(1588),
    [anon_sym_initially] = ACTIONS(1588),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1647),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [61] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2375),
    [sym_num_lit] = STATE(2375),
    [sym_kwd_lit] = STATE(2375),
    [sym_str_lit] = STATE(2375),
    [sym_char_lit] = STATE(2375),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2375),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2375),
    [sym_set_lit] = STATE(2375),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2375),
    [sym_splicing_read_cond_lit] = STATE(2375),
    [sym_var_quoting_lit] = STATE(2375),
    [sym_quoting_lit] = STATE(2375),
    [sym_syn_quoting_lit] = STATE(2375),
    [sym_unquote_splicing_lit] = STATE(2375),
    [sym_unquoting_lit] = STATE(2375),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2375),
    [sym_package_lit] = STATE(2375),
    [sym_include_reader_macro] = STATE(2375),
    [sym_complex_num_lit] = STATE(2375),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1563),
    [sym_comment] = ACTIONS(1563),
    [anon_sym_POUND_] = ACTIONS(1566),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1649),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1571),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1649),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1574),
    [anon_sym_POUND_CARET] = ACTIONS(1577),
    [anon_sym_LPAREN] = ACTIONS(1580),
    [anon_sym_RPAREN] = ACTIONS(1583),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1649),
    [anon_sym_cl] = ACTIONS(1585),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1588),
    [anon_sym_for] = ACTIONS(1588),
    [anon_sym_and] = ACTIONS(1588),
    [anon_sym_as] = ACTIONS(1588),
    [anon_sym_with] = ACTIONS(1588),
    [anon_sym_do] = ACTIONS(1588),
    [anon_sym_while] = ACTIONS(1588),
    [anon_sym_until] = ACTIONS(1588),
    [anon_sym_repeat] = ACTIONS(1588),
    [anon_sym_when] = ACTIONS(1588),
    [anon_sym_if] = ACTIONS(1588),
    [anon_sym_unless] = ACTIONS(1588),
    [anon_sym_always] = ACTIONS(1588),
    [anon_sym_thereis] = ACTIONS(1588),
    [anon_sym_never] = ACTIONS(1588),
    [anon_sym_else] = ACTIONS(1588),
    [anon_sym_finally] = ACTIONS(1588),
    [anon_sym_return] = ACTIONS(1588),
    [anon_sym_initially] = ACTIONS(1588),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1651),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [62] = {
    [sym__gap] = STATE(100),
    [sym_dis_expr] = STATE(100),
    [sym__form] = STATE(2448),
    [sym_num_lit] = STATE(2448),
    [sym_kwd_lit] = STATE(2448),
    [sym_str_lit] = STATE(2448),
    [sym_char_lit] = STATE(2448),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2448),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2448),
    [sym_set_lit] = STATE(2448),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2448),
    [sym_splicing_read_cond_lit] = STATE(2448),
    [sym_var_quoting_lit] = STATE(2448),
    [sym_quoting_lit] = STATE(2448),
    [sym_syn_quoting_lit] = STATE(2448),
    [sym_unquote_splicing_lit] = STATE(2448),
    [sym_unquoting_lit] = STATE(2448),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2448),
    [sym_package_lit] = STATE(2448),
    [sym_include_reader_macro] = STATE(2448),
    [sym_complex_num_lit] = STATE(2448),
    [aux_sym_dis_expr_repeat1] = STATE(100),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1653),
    [sym_comment] = ACTIONS(1653),
    [anon_sym_POUND_] = ACTIONS(1656),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1659),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1661),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1659),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1664),
    [anon_sym_POUND_CARET] = ACTIONS(1667),
    [anon_sym_LPAREN] = ACTIONS(1670),
    [anon_sym_RPAREN] = ACTIONS(1673),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1659),
    [anon_sym_cl] = ACTIONS(1675),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1678),
    [anon_sym_for] = ACTIONS(1678),
    [anon_sym_and] = ACTIONS(1678),
    [anon_sym_as] = ACTIONS(1678),
    [anon_sym_with] = ACTIONS(1678),
    [anon_sym_do] = ACTIONS(1678),
    [anon_sym_while] = ACTIONS(1678),
    [anon_sym_until] = ACTIONS(1678),
    [anon_sym_repeat] = ACTIONS(1678),
    [anon_sym_when] = ACTIONS(1678),
    [anon_sym_if] = ACTIONS(1678),
    [anon_sym_unless] = ACTIONS(1678),
    [anon_sym_always] = ACTIONS(1678),
    [anon_sym_thereis] = ACTIONS(1678),
    [anon_sym_never] = ACTIONS(1678),
    [anon_sym_else] = ACTIONS(1678),
    [anon_sym_finally] = ACTIONS(1678),
    [anon_sym_return] = ACTIONS(1678),
    [anon_sym_initially] = ACTIONS(1678),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1680),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [63] = {
    [sym__gap] = STATE(941),
    [sym_dis_expr] = STATE(941),
    [sym__form] = STATE(50),
    [sym_num_lit] = STATE(50),
    [sym_kwd_lit] = STATE(50),
    [sym_str_lit] = STATE(50),
    [sym_char_lit] = STATE(50),
    [sym_sym_lit] = STATE(1288),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(50),
    [sym__bare_list_lit] = STATE(1289),
    [sym_vec_lit] = STATE(50),
    [sym_set_lit] = STATE(50),
    [sym__bare_set_lit] = STATE(1290),
    [sym_read_cond_lit] = STATE(50),
    [sym_splicing_read_cond_lit] = STATE(50),
    [sym_var_quoting_lit] = STATE(50),
    [sym_quoting_lit] = STATE(50),
    [sym_syn_quoting_lit] = STATE(50),
    [sym_unquote_splicing_lit] = STATE(50),
    [sym_unquoting_lit] = STATE(50),
    [sym_defun] = STATE(1289),
    [sym_loop_macro] = STATE(1289),
    [sym_path_lit] = STATE(50),
    [sym_package_lit] = STATE(50),
    [sym_include_reader_macro] = STATE(50),
    [sym_complex_num_lit] = STATE(50),
    [aux_sym_dis_expr_repeat1] = STATE(941),
    [aux_sym_list_lit_repeat1] = STATE(2808),
    [sym__ws] = ACTIONS(1682),
    [sym_comment] = ACTIONS(1682),
    [anon_sym_POUND_] = ACTIONS(1685),
    [anon_sym_POUND] = ACTIONS(1688),
    [anon_sym_DOT] = ACTIONS(1690),
    [aux_sym_num_lit_token1] = ACTIONS(1692),
    [anon_sym_COLON] = ACTIONS(1694),
    [anon_sym_COLON_COLON] = ACTIONS(1697),
    [anon_sym_DQUOTE] = ACTIONS(1699),
    [sym_nil_lit] = ACTIONS(1690),
    [aux_sym_sym_lit_token1] = ACTIONS(1701),
    [anon_sym_CARET] = ACTIONS(1703),
    [anon_sym_POUND_CARET] = ACTIONS(1706),
    [anon_sym_LPAREN] = ACTIONS(1709),
    [anon_sym_RPAREN] = ACTIONS(1712),
    [anon_sym_POUND0A] = ACTIONS(1714),
    [anon_sym_POUND0a] = ACTIONS(1714),
    [anon_sym_POUND_QMARK] = ACTIONS(1716),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(1718),
    [anon_sym_POUND_SQUOTE] = ACTIONS(1720),
    [anon_sym_SQUOTE] = ACTIONS(1722),
    [anon_sym_BQUOTE] = ACTIONS(1724),
    [anon_sym_COMMA_AT] = ACTIONS(1726),
    [anon_sym_COMMA] = ACTIONS(1728),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1690),
    [anon_sym_cl] = ACTIONS(1730),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1733),
    [anon_sym_for] = ACTIONS(1733),
    [anon_sym_and] = ACTIONS(1733),
    [anon_sym_as] = ACTIONS(1733),
    [anon_sym_with] = ACTIONS(1733),
    [anon_sym_do] = ACTIONS(1733),
    [anon_sym_while] = ACTIONS(1733),
    [anon_sym_until] = ACTIONS(1733),
    [anon_sym_repeat] = ACTIONS(1733),
    [anon_sym_when] = ACTIONS(1733),
    [anon_sym_if] = ACTIONS(1733),
    [anon_sym_unless] = ACTIONS(1733),
    [anon_sym_always] = ACTIONS(1733),
    [anon_sym_thereis] = ACTIONS(1733),
    [anon_sym_never] = ACTIONS(1733),
    [anon_sym_else] = ACTIONS(1733),
    [anon_sym_finally] = ACTIONS(1733),
    [anon_sym_return] = ACTIONS(1733),
    [anon_sym_initially] = ACTIONS(1733),
    [anon_sym_POUNDP] = ACTIONS(1735),
    [anon_sym_POUNDp] = ACTIONS(1735),
    [sym_self_referential_reader_macro] = ACTIONS(1737),
    [anon_sym_POUND_PLUS] = ACTIONS(1739),
    [anon_sym_POUND_DASH] = ACTIONS(1739),
    [anon_sym_POUNDC] = ACTIONS(1741),
    [anon_sym_POUNDc] = ACTIONS(1741),
  },
  [64] = {
    [sym__gap] = STATE(102),
    [sym_dis_expr] = STATE(102),
    [sym__form] = STATE(2511),
    [sym_num_lit] = STATE(2511),
    [sym_kwd_lit] = STATE(2511),
    [sym_str_lit] = STATE(2511),
    [sym_char_lit] = STATE(2511),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2511),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2511),
    [sym_set_lit] = STATE(2511),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2511),
    [sym_splicing_read_cond_lit] = STATE(2511),
    [sym_var_quoting_lit] = STATE(2511),
    [sym_quoting_lit] = STATE(2511),
    [sym_syn_quoting_lit] = STATE(2511),
    [sym_unquote_splicing_lit] = STATE(2511),
    [sym_unquoting_lit] = STATE(2511),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2511),
    [sym_package_lit] = STATE(2511),
    [sym_include_reader_macro] = STATE(2511),
    [sym_complex_num_lit] = STATE(2511),
    [aux_sym_dis_expr_repeat1] = STATE(102),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1743),
    [sym_comment] = ACTIONS(1743),
    [anon_sym_POUND_] = ACTIONS(1381),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1746),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1386),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1746),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1389),
    [anon_sym_POUND_CARET] = ACTIONS(1392),
    [anon_sym_LPAREN] = ACTIONS(1395),
    [anon_sym_RPAREN] = ACTIONS(1398),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1746),
    [anon_sym_cl] = ACTIONS(1400),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1403),
    [anon_sym_for] = ACTIONS(1403),
    [anon_sym_and] = ACTIONS(1403),
    [anon_sym_as] = ACTIONS(1403),
    [anon_sym_with] = ACTIONS(1403),
    [anon_sym_do] = ACTIONS(1403),
    [anon_sym_while] = ACTIONS(1403),
    [anon_sym_until] = ACTIONS(1403),
    [anon_sym_repeat] = ACTIONS(1403),
    [anon_sym_when] = ACTIONS(1403),
    [anon_sym_if] = ACTIONS(1403),
    [anon_sym_unless] = ACTIONS(1403),
    [anon_sym_always] = ACTIONS(1403),
    [anon_sym_thereis] = ACTIONS(1403),
    [anon_sym_never] = ACTIONS(1403),
    [anon_sym_else] = ACTIONS(1403),
    [anon_sym_finally] = ACTIONS(1403),
    [anon_sym_return] = ACTIONS(1403),
    [anon_sym_initially] = ACTIONS(1403),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1748),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [65] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2522),
    [sym_num_lit] = STATE(2522),
    [sym_kwd_lit] = STATE(2522),
    [sym_str_lit] = STATE(2522),
    [sym_char_lit] = STATE(2522),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2522),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2522),
    [sym_set_lit] = STATE(2522),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2522),
    [sym_splicing_read_cond_lit] = STATE(2522),
    [sym_var_quoting_lit] = STATE(2522),
    [sym_quoting_lit] = STATE(2522),
    [sym_syn_quoting_lit] = STATE(2522),
    [sym_unquote_splicing_lit] = STATE(2522),
    [sym_unquoting_lit] = STATE(2522),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2522),
    [sym_package_lit] = STATE(2522),
    [sym_include_reader_macro] = STATE(2522),
    [sym_complex_num_lit] = STATE(2522),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1407),
    [sym_comment] = ACTIONS(1407),
    [anon_sym_POUND_] = ACTIONS(1381),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1750),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1386),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1750),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1389),
    [anon_sym_POUND_CARET] = ACTIONS(1392),
    [anon_sym_LPAREN] = ACTIONS(1395),
    [anon_sym_RPAREN] = ACTIONS(1398),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1750),
    [anon_sym_cl] = ACTIONS(1400),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1403),
    [anon_sym_for] = ACTIONS(1403),
    [anon_sym_and] = ACTIONS(1403),
    [anon_sym_as] = ACTIONS(1403),
    [anon_sym_with] = ACTIONS(1403),
    [anon_sym_do] = ACTIONS(1403),
    [anon_sym_while] = ACTIONS(1403),
    [anon_sym_until] = ACTIONS(1403),
    [anon_sym_repeat] = ACTIONS(1403),
    [anon_sym_when] = ACTIONS(1403),
    [anon_sym_if] = ACTIONS(1403),
    [anon_sym_unless] = ACTIONS(1403),
    [anon_sym_always] = ACTIONS(1403),
    [anon_sym_thereis] = ACTIONS(1403),
    [anon_sym_never] = ACTIONS(1403),
    [anon_sym_else] = ACTIONS(1403),
    [anon_sym_finally] = ACTIONS(1403),
    [anon_sym_return] = ACTIONS(1403),
    [anon_sym_initially] = ACTIONS(1403),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1752),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [66] = {
    [sym__gap] = STATE(105),
    [sym_dis_expr] = STATE(105),
    [sym__form] = STATE(2523),
    [sym_num_lit] = STATE(2523),
    [sym_kwd_lit] = STATE(2523),
    [sym_str_lit] = STATE(2523),
    [sym_char_lit] = STATE(2523),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2523),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2523),
    [sym_set_lit] = STATE(2523),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2523),
    [sym_splicing_read_cond_lit] = STATE(2523),
    [sym_var_quoting_lit] = STATE(2523),
    [sym_quoting_lit] = STATE(2523),
    [sym_syn_quoting_lit] = STATE(2523),
    [sym_unquote_splicing_lit] = STATE(2523),
    [sym_unquoting_lit] = STATE(2523),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2523),
    [sym_package_lit] = STATE(2523),
    [sym_include_reader_macro] = STATE(2523),
    [sym_complex_num_lit] = STATE(2523),
    [aux_sym_dis_expr_repeat1] = STATE(105),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1754),
    [sym_comment] = ACTIONS(1754),
    [anon_sym_POUND_] = ACTIONS(1417),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1757),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1422),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1757),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1425),
    [anon_sym_POUND_CARET] = ACTIONS(1428),
    [anon_sym_LPAREN] = ACTIONS(1431),
    [anon_sym_RPAREN] = ACTIONS(1434),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1757),
    [anon_sym_cl] = ACTIONS(1436),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1439),
    [anon_sym_for] = ACTIONS(1439),
    [anon_sym_and] = ACTIONS(1439),
    [anon_sym_as] = ACTIONS(1439),
    [anon_sym_with] = ACTIONS(1439),
    [anon_sym_do] = ACTIONS(1439),
    [anon_sym_while] = ACTIONS(1439),
    [anon_sym_until] = ACTIONS(1439),
    [anon_sym_repeat] = ACTIONS(1439),
    [anon_sym_when] = ACTIONS(1439),
    [anon_sym_if] = ACTIONS(1439),
    [anon_sym_unless] = ACTIONS(1439),
    [anon_sym_always] = ACTIONS(1439),
    [anon_sym_thereis] = ACTIONS(1439),
    [anon_sym_never] = ACTIONS(1439),
    [anon_sym_else] = ACTIONS(1439),
    [anon_sym_finally] = ACTIONS(1439),
    [anon_sym_return] = ACTIONS(1439),
    [anon_sym_initially] = ACTIONS(1439),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1759),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [67] = {
    [sym__gap] = STATE(278),
    [sym_dis_expr] = STATE(278),
    [sym__form] = STATE(2719),
    [sym_num_lit] = STATE(2719),
    [sym_kwd_lit] = STATE(2719),
    [sym_str_lit] = STATE(2719),
    [sym_char_lit] = STATE(2719),
    [sym_sym_lit] = STATE(2766),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2719),
    [sym__bare_list_lit] = STATE(1975),
    [sym_vec_lit] = STATE(2719),
    [sym_set_lit] = STATE(2719),
    [sym__bare_set_lit] = STATE(1976),
    [sym_read_cond_lit] = STATE(2719),
    [sym_splicing_read_cond_lit] = STATE(2719),
    [sym_var_quoting_lit] = STATE(2719),
    [sym_quoting_lit] = STATE(2719),
    [sym_syn_quoting_lit] = STATE(2719),
    [sym_unquote_splicing_lit] = STATE(2719),
    [sym_unquoting_lit] = STATE(2719),
    [sym_defun] = STATE(1975),
    [sym_for_clause_word] = STATE(419),
    [sym__for_part] = STATE(1555),
    [sym_loop_macro] = STATE(1975),
    [sym_path_lit] = STATE(2719),
    [sym_package_lit] = STATE(2719),
    [sym_include_reader_macro] = STATE(2719),
    [sym_complex_num_lit] = STATE(2719),
    [aux_sym_dis_expr_repeat1] = STATE(278),
    [aux_sym_list_lit_repeat1] = STATE(2830),
    [aux_sym_for_clause_repeat1] = STATE(1273),
    [sym__ws] = ACTIONS(1761),
    [sym_comment] = ACTIONS(1761),
    [anon_sym_POUND_] = ACTIONS(1452),
    [anon_sym_POUND] = ACTIONS(1454),
    [anon_sym_DOT] = ACTIONS(1763),
    [aux_sym_num_lit_token1] = ACTIONS(1458),
    [anon_sym_COLON] = ACTIONS(1460),
    [anon_sym_COLON_COLON] = ACTIONS(1462),
    [anon_sym_DQUOTE] = ACTIONS(1464),
    [sym_nil_lit] = ACTIONS(1763),
    [aux_sym_sym_lit_token1] = ACTIONS(1466),
    [anon_sym_CARET] = ACTIONS(25),
    [anon_sym_POUND_CARET] = ACTIONS(27),
    [anon_sym_LPAREN] = ACTIONS(1468),
    [anon_sym_POUND0A] = ACTIONS(1470),
    [anon_sym_POUND0a] = ACTIONS(1470),
    [anon_sym_POUND_QMARK] = ACTIONS(1472),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(1474),
    [anon_sym_POUND_SQUOTE] = ACTIONS(1476),
    [anon_sym_SQUOTE] = ACTIONS(1478),
    [anon_sym_BQUOTE] = ACTIONS(1480),
    [anon_sym_COMMA_AT] = ACTIONS(1482),
    [anon_sym_COMMA] = ACTIONS(1484),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1763),
    [anon_sym_cl] = ACTIONS(1486),
    [anon_sym_in] = ACTIONS(1488),
    [anon_sym_across] = ACTIONS(1488),
    [anon_sym_being] = ACTIONS(1488),
    [anon_sym_using] = ACTIONS(1488),
    [aux_sym_for_clause_word_token1] = ACTIONS(1490),
    [anon_sym_below] = ACTIONS(1488),
    [anon_sym_above] = ACTIONS(1488),
    [anon_sym_from] = ACTIONS(1488),
    [anon_sym_to] = ACTIONS(1488),
    [anon_sym_upto] = ACTIONS(1488),
    [anon_sym_upfrom] = ACTIONS(1488),
    [anon_sym_downto] = ACTIONS(1488),
    [anon_sym_downfrom] = ACTIONS(1488),
    [anon_sym_on] = ACTIONS(1488),
    [anon_sym_by] = ACTIONS(1488),
    [anon_sym_then] = ACTIONS(1488),
    [anon_sym_EQ] = ACTIONS(1488),
    [anon_sym_POUNDP] = ACTIONS(1492),
    [anon_sym_POUNDp] = ACTIONS(1492),
    [sym_self_referential_reader_macro] = ACTIONS(1765),
    [anon_sym_POUND_PLUS] = ACTIONS(1496),
    [anon_sym_POUND_DASH] = ACTIONS(1496),
    [anon_sym_POUNDC] = ACTIONS(1498),
    [anon_sym_POUNDc] = ACTIONS(1498),
  },
  [68] = {
    [sym__gap] = STATE(108),
    [sym_dis_expr] = STATE(108),
    [sym__form] = STATE(2546),
    [sym_num_lit] = STATE(2546),
    [sym_kwd_lit] = STATE(2546),
    [sym_str_lit] = STATE(2546),
    [sym_char_lit] = STATE(2546),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2546),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2546),
    [sym_set_lit] = STATE(2546),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2546),
    [sym_splicing_read_cond_lit] = STATE(2546),
    [sym_var_quoting_lit] = STATE(2546),
    [sym_quoting_lit] = STATE(2546),
    [sym_syn_quoting_lit] = STATE(2546),
    [sym_unquote_splicing_lit] = STATE(2546),
    [sym_unquoting_lit] = STATE(2546),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2546),
    [sym_package_lit] = STATE(2546),
    [sym_include_reader_macro] = STATE(2546),
    [sym_complex_num_lit] = STATE(2546),
    [aux_sym_dis_expr_repeat1] = STATE(108),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1767),
    [sym_comment] = ACTIONS(1767),
    [anon_sym_POUND_] = ACTIONS(1381),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1770),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1386),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1770),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1389),
    [anon_sym_POUND_CARET] = ACTIONS(1392),
    [anon_sym_LPAREN] = ACTIONS(1395),
    [anon_sym_RPAREN] = ACTIONS(1398),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1770),
    [anon_sym_cl] = ACTIONS(1400),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1403),
    [anon_sym_for] = ACTIONS(1403),
    [anon_sym_and] = ACTIONS(1403),
    [anon_sym_as] = ACTIONS(1403),
    [anon_sym_with] = ACTIONS(1403),
    [anon_sym_do] = ACTIONS(1403),
    [anon_sym_while] = ACTIONS(1403),
    [anon_sym_until] = ACTIONS(1403),
    [anon_sym_repeat] = ACTIONS(1403),
    [anon_sym_when] = ACTIONS(1403),
    [anon_sym_if] = ACTIONS(1403),
    [anon_sym_unless] = ACTIONS(1403),
    [anon_sym_always] = ACTIONS(1403),
    [anon_sym_thereis] = ACTIONS(1403),
    [anon_sym_never] = ACTIONS(1403),
    [anon_sym_else] = ACTIONS(1403),
    [anon_sym_finally] = ACTIONS(1403),
    [anon_sym_return] = ACTIONS(1403),
    [anon_sym_initially] = ACTIONS(1403),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1772),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [69] = {
    [sym__gap] = STATE(819),
    [sym_dis_expr] = STATE(819),
    [sym__form] = STATE(82),
    [sym_num_lit] = STATE(82),
    [sym_kwd_lit] = STATE(82),
    [sym_str_lit] = STATE(82),
    [sym_char_lit] = STATE(82),
    [sym_sym_lit] = STATE(1288),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(82),
    [sym__bare_list_lit] = STATE(1289),
    [sym_vec_lit] = STATE(82),
    [sym_set_lit] = STATE(82),
    [sym__bare_set_lit] = STATE(1290),
    [sym_read_cond_lit] = STATE(82),
    [sym_splicing_read_cond_lit] = STATE(82),
    [sym_var_quoting_lit] = STATE(82),
    [sym_quoting_lit] = STATE(82),
    [sym_syn_quoting_lit] = STATE(82),
    [sym_unquote_splicing_lit] = STATE(82),
    [sym_unquoting_lit] = STATE(82),
    [sym_defun] = STATE(1289),
    [sym_loop_macro] = STATE(1289),
    [sym_path_lit] = STATE(82),
    [sym_package_lit] = STATE(82),
    [sym_include_reader_macro] = STATE(82),
    [sym_complex_num_lit] = STATE(82),
    [aux_sym_dis_expr_repeat1] = STATE(819),
    [aux_sym_list_lit_repeat1] = STATE(2808),
    [sym__ws] = ACTIONS(1774),
    [sym_comment] = ACTIONS(1774),
    [anon_sym_POUND_] = ACTIONS(1777),
    [anon_sym_POUND] = ACTIONS(1688),
    [anon_sym_DOT] = ACTIONS(1780),
    [aux_sym_num_lit_token1] = ACTIONS(1692),
    [anon_sym_COLON] = ACTIONS(1782),
    [anon_sym_COLON_COLON] = ACTIONS(1697),
    [anon_sym_DQUOTE] = ACTIONS(1699),
    [sym_nil_lit] = ACTIONS(1780),
    [aux_sym_sym_lit_token1] = ACTIONS(1701),
    [anon_sym_CARET] = ACTIONS(1785),
    [anon_sym_POUND_CARET] = ACTIONS(1788),
    [anon_sym_LPAREN] = ACTIONS(1791),
    [anon_sym_RPAREN] = ACTIONS(1794),
    [anon_sym_POUND0A] = ACTIONS(1714),
    [anon_sym_POUND0a] = ACTIONS(1714),
    [anon_sym_POUND_QMARK] = ACTIONS(1716),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(1718),
    [anon_sym_POUND_SQUOTE] = ACTIONS(1720),
    [anon_sym_SQUOTE] = ACTIONS(1722),
    [anon_sym_BQUOTE] = ACTIONS(1724),
    [anon_sym_COMMA_AT] = ACTIONS(1726),
    [anon_sym_COMMA] = ACTIONS(1728),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1780),
    [anon_sym_cl] = ACTIONS(1796),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1799),
    [anon_sym_for] = ACTIONS(1799),
    [anon_sym_and] = ACTIONS(1799),
    [anon_sym_as] = ACTIONS(1799),
    [anon_sym_with] = ACTIONS(1799),
    [anon_sym_do] = ACTIONS(1799),
    [anon_sym_while] = ACTIONS(1799),
    [anon_sym_until] = ACTIONS(1799),
    [anon_sym_repeat] = ACTIONS(1799),
    [anon_sym_when] = ACTIONS(1799),
    [anon_sym_if] = ACTIONS(1799),
    [anon_sym_unless] = ACTIONS(1799),
    [anon_sym_always] = ACTIONS(1799),
    [anon_sym_thereis] = ACTIONS(1799),
    [anon_sym_never] = ACTIONS(1799),
    [anon_sym_else] = ACTIONS(1799),
    [anon_sym_finally] = ACTIONS(1799),
    [anon_sym_return] = ACTIONS(1799),
    [anon_sym_initially] = ACTIONS(1799),
    [anon_sym_POUNDP] = ACTIONS(1735),
    [anon_sym_POUNDp] = ACTIONS(1735),
    [sym_self_referential_reader_macro] = ACTIONS(1801),
    [anon_sym_POUND_PLUS] = ACTIONS(1739),
    [anon_sym_POUND_DASH] = ACTIONS(1739),
    [anon_sym_POUNDC] = ACTIONS(1741),
    [anon_sym_POUNDc] = ACTIONS(1741),
  },
  [70] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2121),
    [sym_num_lit] = STATE(2121),
    [sym_kwd_lit] = STATE(2121),
    [sym_str_lit] = STATE(2121),
    [sym_char_lit] = STATE(2121),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2121),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2121),
    [sym_set_lit] = STATE(2121),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2121),
    [sym_splicing_read_cond_lit] = STATE(2121),
    [sym_var_quoting_lit] = STATE(2121),
    [sym_quoting_lit] = STATE(2121),
    [sym_syn_quoting_lit] = STATE(2121),
    [sym_unquote_splicing_lit] = STATE(2121),
    [sym_unquoting_lit] = STATE(2121),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2121),
    [sym_package_lit] = STATE(2121),
    [sym_include_reader_macro] = STATE(2121),
    [sym_complex_num_lit] = STATE(2121),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1803),
    [sym_comment] = ACTIONS(1803),
    [anon_sym_POUND_] = ACTIONS(1806),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1809),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1811),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1809),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1814),
    [anon_sym_POUND_CARET] = ACTIONS(1817),
    [anon_sym_LPAREN] = ACTIONS(1820),
    [anon_sym_RPAREN] = ACTIONS(1823),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1809),
    [anon_sym_cl] = ACTIONS(1825),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1828),
    [anon_sym_for] = ACTIONS(1828),
    [anon_sym_and] = ACTIONS(1828),
    [anon_sym_as] = ACTIONS(1828),
    [anon_sym_with] = ACTIONS(1828),
    [anon_sym_do] = ACTIONS(1828),
    [anon_sym_while] = ACTIONS(1828),
    [anon_sym_until] = ACTIONS(1828),
    [anon_sym_repeat] = ACTIONS(1828),
    [anon_sym_when] = ACTIONS(1828),
    [anon_sym_if] = ACTIONS(1828),
    [anon_sym_unless] = ACTIONS(1828),
    [anon_sym_always] = ACTIONS(1828),
    [anon_sym_thereis] = ACTIONS(1828),
    [anon_sym_never] = ACTIONS(1828),
    [anon_sym_else] = ACTIONS(1828),
    [anon_sym_finally] = ACTIONS(1828),
    [anon_sym_return] = ACTIONS(1828),
    [anon_sym_initially] = ACTIONS(1828),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1830),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [71] = {
    [sym__gap] = STATE(111),
    [sym_dis_expr] = STATE(111),
    [sym__form] = STATE(2122),
    [sym_num_lit] = STATE(2122),
    [sym_kwd_lit] = STATE(2122),
    [sym_str_lit] = STATE(2122),
    [sym_char_lit] = STATE(2122),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2122),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2122),
    [sym_set_lit] = STATE(2122),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2122),
    [sym_splicing_read_cond_lit] = STATE(2122),
    [sym_var_quoting_lit] = STATE(2122),
    [sym_quoting_lit] = STATE(2122),
    [sym_syn_quoting_lit] = STATE(2122),
    [sym_unquote_splicing_lit] = STATE(2122),
    [sym_unquoting_lit] = STATE(2122),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2122),
    [sym_package_lit] = STATE(2122),
    [sym_include_reader_macro] = STATE(2122),
    [sym_complex_num_lit] = STATE(2122),
    [aux_sym_dis_expr_repeat1] = STATE(111),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1832),
    [sym_comment] = ACTIONS(1832),
    [anon_sym_POUND_] = ACTIONS(1806),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1835),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1811),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1835),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1814),
    [anon_sym_POUND_CARET] = ACTIONS(1817),
    [anon_sym_LPAREN] = ACTIONS(1820),
    [anon_sym_RPAREN] = ACTIONS(1823),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1835),
    [anon_sym_cl] = ACTIONS(1825),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1828),
    [anon_sym_for] = ACTIONS(1828),
    [anon_sym_and] = ACTIONS(1828),
    [anon_sym_as] = ACTIONS(1828),
    [anon_sym_with] = ACTIONS(1828),
    [anon_sym_do] = ACTIONS(1828),
    [anon_sym_while] = ACTIONS(1828),
    [anon_sym_until] = ACTIONS(1828),
    [anon_sym_repeat] = ACTIONS(1828),
    [anon_sym_when] = ACTIONS(1828),
    [anon_sym_if] = ACTIONS(1828),
    [anon_sym_unless] = ACTIONS(1828),
    [anon_sym_always] = ACTIONS(1828),
    [anon_sym_thereis] = ACTIONS(1828),
    [anon_sym_never] = ACTIONS(1828),
    [anon_sym_else] = ACTIONS(1828),
    [anon_sym_finally] = ACTIONS(1828),
    [anon_sym_return] = ACTIONS(1828),
    [anon_sym_initially] = ACTIONS(1828),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1837),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [72] = {
    [sym__gap] = STATE(112),
    [sym_dis_expr] = STATE(112),
    [sym__form] = STATE(2125),
    [sym_num_lit] = STATE(2125),
    [sym_kwd_lit] = STATE(2125),
    [sym_str_lit] = STATE(2125),
    [sym_char_lit] = STATE(2125),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2125),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2125),
    [sym_set_lit] = STATE(2125),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2125),
    [sym_splicing_read_cond_lit] = STATE(2125),
    [sym_var_quoting_lit] = STATE(2125),
    [sym_quoting_lit] = STATE(2125),
    [sym_syn_quoting_lit] = STATE(2125),
    [sym_unquote_splicing_lit] = STATE(2125),
    [sym_unquoting_lit] = STATE(2125),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2125),
    [sym_package_lit] = STATE(2125),
    [sym_include_reader_macro] = STATE(2125),
    [sym_complex_num_lit] = STATE(2125),
    [aux_sym_dis_expr_repeat1] = STATE(112),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1839),
    [sym_comment] = ACTIONS(1839),
    [anon_sym_POUND_] = ACTIONS(1842),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1845),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1847),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1845),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1850),
    [anon_sym_POUND_CARET] = ACTIONS(1853),
    [anon_sym_LPAREN] = ACTIONS(1856),
    [anon_sym_RPAREN] = ACTIONS(1859),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1845),
    [anon_sym_cl] = ACTIONS(1861),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1864),
    [anon_sym_for] = ACTIONS(1864),
    [anon_sym_and] = ACTIONS(1864),
    [anon_sym_as] = ACTIONS(1864),
    [anon_sym_with] = ACTIONS(1864),
    [anon_sym_do] = ACTIONS(1864),
    [anon_sym_while] = ACTIONS(1864),
    [anon_sym_until] = ACTIONS(1864),
    [anon_sym_repeat] = ACTIONS(1864),
    [anon_sym_when] = ACTIONS(1864),
    [anon_sym_if] = ACTIONS(1864),
    [anon_sym_unless] = ACTIONS(1864),
    [anon_sym_always] = ACTIONS(1864),
    [anon_sym_thereis] = ACTIONS(1864),
    [anon_sym_never] = ACTIONS(1864),
    [anon_sym_else] = ACTIONS(1864),
    [anon_sym_finally] = ACTIONS(1864),
    [anon_sym_return] = ACTIONS(1864),
    [anon_sym_initially] = ACTIONS(1864),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1866),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [73] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2128),
    [sym_num_lit] = STATE(2128),
    [sym_kwd_lit] = STATE(2128),
    [sym_str_lit] = STATE(2128),
    [sym_char_lit] = STATE(2128),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2128),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2128),
    [sym_set_lit] = STATE(2128),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2128),
    [sym_splicing_read_cond_lit] = STATE(2128),
    [sym_var_quoting_lit] = STATE(2128),
    [sym_quoting_lit] = STATE(2128),
    [sym_syn_quoting_lit] = STATE(2128),
    [sym_unquote_splicing_lit] = STATE(2128),
    [sym_unquoting_lit] = STATE(2128),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2128),
    [sym_package_lit] = STATE(2128),
    [sym_include_reader_macro] = STATE(2128),
    [sym_complex_num_lit] = STATE(2128),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1868),
    [sym_comment] = ACTIONS(1868),
    [anon_sym_POUND_] = ACTIONS(1842),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1871),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1847),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1871),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1850),
    [anon_sym_POUND_CARET] = ACTIONS(1853),
    [anon_sym_LPAREN] = ACTIONS(1856),
    [anon_sym_RPAREN] = ACTIONS(1859),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1871),
    [anon_sym_cl] = ACTIONS(1861),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1864),
    [anon_sym_for] = ACTIONS(1864),
    [anon_sym_and] = ACTIONS(1864),
    [anon_sym_as] = ACTIONS(1864),
    [anon_sym_with] = ACTIONS(1864),
    [anon_sym_do] = ACTIONS(1864),
    [anon_sym_while] = ACTIONS(1864),
    [anon_sym_until] = ACTIONS(1864),
    [anon_sym_repeat] = ACTIONS(1864),
    [anon_sym_when] = ACTIONS(1864),
    [anon_sym_if] = ACTIONS(1864),
    [anon_sym_unless] = ACTIONS(1864),
    [anon_sym_always] = ACTIONS(1864),
    [anon_sym_thereis] = ACTIONS(1864),
    [anon_sym_never] = ACTIONS(1864),
    [anon_sym_else] = ACTIONS(1864),
    [anon_sym_finally] = ACTIONS(1864),
    [anon_sym_return] = ACTIONS(1864),
    [anon_sym_initially] = ACTIONS(1864),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1873),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [74] = {
    [sym__gap] = STATE(115),
    [sym_dis_expr] = STATE(115),
    [sym__form] = STATE(2129),
    [sym_num_lit] = STATE(2129),
    [sym_kwd_lit] = STATE(2129),
    [sym_str_lit] = STATE(2129),
    [sym_char_lit] = STATE(2129),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2129),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2129),
    [sym_set_lit] = STATE(2129),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2129),
    [sym_splicing_read_cond_lit] = STATE(2129),
    [sym_var_quoting_lit] = STATE(2129),
    [sym_quoting_lit] = STATE(2129),
    [sym_syn_quoting_lit] = STATE(2129),
    [sym_unquote_splicing_lit] = STATE(2129),
    [sym_unquoting_lit] = STATE(2129),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2129),
    [sym_package_lit] = STATE(2129),
    [sym_include_reader_macro] = STATE(2129),
    [sym_complex_num_lit] = STATE(2129),
    [aux_sym_dis_expr_repeat1] = STATE(115),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1875),
    [sym_comment] = ACTIONS(1875),
    [anon_sym_POUND_] = ACTIONS(1842),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1878),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1847),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1878),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1850),
    [anon_sym_POUND_CARET] = ACTIONS(1853),
    [anon_sym_LPAREN] = ACTIONS(1856),
    [anon_sym_RPAREN] = ACTIONS(1859),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1878),
    [anon_sym_cl] = ACTIONS(1861),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1864),
    [anon_sym_for] = ACTIONS(1864),
    [anon_sym_and] = ACTIONS(1864),
    [anon_sym_as] = ACTIONS(1864),
    [anon_sym_with] = ACTIONS(1864),
    [anon_sym_do] = ACTIONS(1864),
    [anon_sym_while] = ACTIONS(1864),
    [anon_sym_until] = ACTIONS(1864),
    [anon_sym_repeat] = ACTIONS(1864),
    [anon_sym_when] = ACTIONS(1864),
    [anon_sym_if] = ACTIONS(1864),
    [anon_sym_unless] = ACTIONS(1864),
    [anon_sym_always] = ACTIONS(1864),
    [anon_sym_thereis] = ACTIONS(1864),
    [anon_sym_never] = ACTIONS(1864),
    [anon_sym_else] = ACTIONS(1864),
    [anon_sym_finally] = ACTIONS(1864),
    [anon_sym_return] = ACTIONS(1864),
    [anon_sym_initially] = ACTIONS(1864),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1880),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [75] = {
    [sym__gap] = STATE(116),
    [sym_dis_expr] = STATE(116),
    [sym__form] = STATE(2131),
    [sym_num_lit] = STATE(2131),
    [sym_kwd_lit] = STATE(2131),
    [sym_str_lit] = STATE(2131),
    [sym_char_lit] = STATE(2131),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2131),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2131),
    [sym_set_lit] = STATE(2131),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2131),
    [sym_splicing_read_cond_lit] = STATE(2131),
    [sym_var_quoting_lit] = STATE(2131),
    [sym_quoting_lit] = STATE(2131),
    [sym_syn_quoting_lit] = STATE(2131),
    [sym_unquote_splicing_lit] = STATE(2131),
    [sym_unquoting_lit] = STATE(2131),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2131),
    [sym_package_lit] = STATE(2131),
    [sym_include_reader_macro] = STATE(2131),
    [sym_complex_num_lit] = STATE(2131),
    [aux_sym_dis_expr_repeat1] = STATE(116),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1882),
    [sym_comment] = ACTIONS(1882),
    [anon_sym_POUND_] = ACTIONS(1806),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1885),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1811),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1885),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1814),
    [anon_sym_POUND_CARET] = ACTIONS(1817),
    [anon_sym_LPAREN] = ACTIONS(1820),
    [anon_sym_RPAREN] = ACTIONS(1823),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1885),
    [anon_sym_cl] = ACTIONS(1825),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1828),
    [anon_sym_for] = ACTIONS(1828),
    [anon_sym_and] = ACTIONS(1828),
    [anon_sym_as] = ACTIONS(1828),
    [anon_sym_with] = ACTIONS(1828),
    [anon_sym_do] = ACTIONS(1828),
    [anon_sym_while] = ACTIONS(1828),
    [anon_sym_until] = ACTIONS(1828),
    [anon_sym_repeat] = ACTIONS(1828),
    [anon_sym_when] = ACTIONS(1828),
    [anon_sym_if] = ACTIONS(1828),
    [anon_sym_unless] = ACTIONS(1828),
    [anon_sym_always] = ACTIONS(1828),
    [anon_sym_thereis] = ACTIONS(1828),
    [anon_sym_never] = ACTIONS(1828),
    [anon_sym_else] = ACTIONS(1828),
    [anon_sym_finally] = ACTIONS(1828),
    [anon_sym_return] = ACTIONS(1828),
    [anon_sym_initially] = ACTIONS(1828),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1887),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [76] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2136),
    [sym_num_lit] = STATE(2136),
    [sym_kwd_lit] = STATE(2136),
    [sym_str_lit] = STATE(2136),
    [sym_char_lit] = STATE(2136),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2136),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2136),
    [sym_set_lit] = STATE(2136),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2136),
    [sym_splicing_read_cond_lit] = STATE(2136),
    [sym_var_quoting_lit] = STATE(2136),
    [sym_quoting_lit] = STATE(2136),
    [sym_syn_quoting_lit] = STATE(2136),
    [sym_unquote_splicing_lit] = STATE(2136),
    [sym_unquoting_lit] = STATE(2136),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2136),
    [sym_package_lit] = STATE(2136),
    [sym_include_reader_macro] = STATE(2136),
    [sym_complex_num_lit] = STATE(2136),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1803),
    [sym_comment] = ACTIONS(1803),
    [anon_sym_POUND_] = ACTIONS(1806),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1889),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1811),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1889),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1814),
    [anon_sym_POUND_CARET] = ACTIONS(1817),
    [anon_sym_LPAREN] = ACTIONS(1820),
    [anon_sym_RPAREN] = ACTIONS(1823),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1889),
    [anon_sym_cl] = ACTIONS(1825),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1828),
    [anon_sym_for] = ACTIONS(1828),
    [anon_sym_and] = ACTIONS(1828),
    [anon_sym_as] = ACTIONS(1828),
    [anon_sym_with] = ACTIONS(1828),
    [anon_sym_do] = ACTIONS(1828),
    [anon_sym_while] = ACTIONS(1828),
    [anon_sym_until] = ACTIONS(1828),
    [anon_sym_repeat] = ACTIONS(1828),
    [anon_sym_when] = ACTIONS(1828),
    [anon_sym_if] = ACTIONS(1828),
    [anon_sym_unless] = ACTIONS(1828),
    [anon_sym_always] = ACTIONS(1828),
    [anon_sym_thereis] = ACTIONS(1828),
    [anon_sym_never] = ACTIONS(1828),
    [anon_sym_else] = ACTIONS(1828),
    [anon_sym_finally] = ACTIONS(1828),
    [anon_sym_return] = ACTIONS(1828),
    [anon_sym_initially] = ACTIONS(1828),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1891),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [77] = {
    [sym__gap] = STATE(119),
    [sym_dis_expr] = STATE(119),
    [sym__form] = STATE(2140),
    [sym_num_lit] = STATE(2140),
    [sym_kwd_lit] = STATE(2140),
    [sym_str_lit] = STATE(2140),
    [sym_char_lit] = STATE(2140),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2140),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2140),
    [sym_set_lit] = STATE(2140),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2140),
    [sym_splicing_read_cond_lit] = STATE(2140),
    [sym_var_quoting_lit] = STATE(2140),
    [sym_quoting_lit] = STATE(2140),
    [sym_syn_quoting_lit] = STATE(2140),
    [sym_unquote_splicing_lit] = STATE(2140),
    [sym_unquoting_lit] = STATE(2140),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2140),
    [sym_package_lit] = STATE(2140),
    [sym_include_reader_macro] = STATE(2140),
    [sym_complex_num_lit] = STATE(2140),
    [aux_sym_dis_expr_repeat1] = STATE(119),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1893),
    [sym_comment] = ACTIONS(1893),
    [anon_sym_POUND_] = ACTIONS(1896),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1899),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1901),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1899),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1904),
    [anon_sym_POUND_CARET] = ACTIONS(1907),
    [anon_sym_LPAREN] = ACTIONS(1910),
    [anon_sym_RPAREN] = ACTIONS(1913),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1899),
    [anon_sym_cl] = ACTIONS(1915),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1918),
    [anon_sym_for] = ACTIONS(1918),
    [anon_sym_and] = ACTIONS(1918),
    [anon_sym_as] = ACTIONS(1918),
    [anon_sym_with] = ACTIONS(1918),
    [anon_sym_do] = ACTIONS(1918),
    [anon_sym_while] = ACTIONS(1918),
    [anon_sym_until] = ACTIONS(1918),
    [anon_sym_repeat] = ACTIONS(1918),
    [anon_sym_when] = ACTIONS(1918),
    [anon_sym_if] = ACTIONS(1918),
    [anon_sym_unless] = ACTIONS(1918),
    [anon_sym_always] = ACTIONS(1918),
    [anon_sym_thereis] = ACTIONS(1918),
    [anon_sym_never] = ACTIONS(1918),
    [anon_sym_else] = ACTIONS(1918),
    [anon_sym_finally] = ACTIONS(1918),
    [anon_sym_return] = ACTIONS(1918),
    [anon_sym_initially] = ACTIONS(1918),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1920),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [78] = {
    [sym__gap] = STATE(273),
    [sym_dis_expr] = STATE(273),
    [sym__form] = STATE(2723),
    [sym_num_lit] = STATE(2723),
    [sym_kwd_lit] = STATE(2723),
    [sym_str_lit] = STATE(2723),
    [sym_char_lit] = STATE(2723),
    [sym_sym_lit] = STATE(2766),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2723),
    [sym__bare_list_lit] = STATE(1975),
    [sym_vec_lit] = STATE(2723),
    [sym_set_lit] = STATE(2723),
    [sym__bare_set_lit] = STATE(1976),
    [sym_read_cond_lit] = STATE(2723),
    [sym_splicing_read_cond_lit] = STATE(2723),
    [sym_var_quoting_lit] = STATE(2723),
    [sym_quoting_lit] = STATE(2723),
    [sym_syn_quoting_lit] = STATE(2723),
    [sym_unquote_splicing_lit] = STATE(2723),
    [sym_unquoting_lit] = STATE(2723),
    [sym_defun] = STATE(1975),
    [sym_for_clause_word] = STATE(419),
    [sym__for_part] = STATE(1555),
    [sym_loop_macro] = STATE(1975),
    [sym_path_lit] = STATE(2723),
    [sym_package_lit] = STATE(2723),
    [sym_include_reader_macro] = STATE(2723),
    [sym_complex_num_lit] = STATE(2723),
    [aux_sym_dis_expr_repeat1] = STATE(273),
    [aux_sym_list_lit_repeat1] = STATE(2830),
    [aux_sym_for_clause_repeat1] = STATE(1282),
    [sym__ws] = ACTIONS(1922),
    [sym_comment] = ACTIONS(1922),
    [anon_sym_POUND_] = ACTIONS(1452),
    [anon_sym_POUND] = ACTIONS(1454),
    [anon_sym_DOT] = ACTIONS(1924),
    [aux_sym_num_lit_token1] = ACTIONS(1458),
    [anon_sym_COLON] = ACTIONS(1460),
    [anon_sym_COLON_COLON] = ACTIONS(1462),
    [anon_sym_DQUOTE] = ACTIONS(1464),
    [sym_nil_lit] = ACTIONS(1924),
    [aux_sym_sym_lit_token1] = ACTIONS(1466),
    [anon_sym_CARET] = ACTIONS(25),
    [anon_sym_POUND_CARET] = ACTIONS(27),
    [anon_sym_LPAREN] = ACTIONS(1468),
    [anon_sym_POUND0A] = ACTIONS(1470),
    [anon_sym_POUND0a] = ACTIONS(1470),
    [anon_sym_POUND_QMARK] = ACTIONS(1472),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(1474),
    [anon_sym_POUND_SQUOTE] = ACTIONS(1476),
    [anon_sym_SQUOTE] = ACTIONS(1478),
    [anon_sym_BQUOTE] = ACTIONS(1480),
    [anon_sym_COMMA_AT] = ACTIONS(1482),
    [anon_sym_COMMA] = ACTIONS(1484),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1924),
    [anon_sym_cl] = ACTIONS(1486),
    [anon_sym_in] = ACTIONS(1488),
    [anon_sym_across] = ACTIONS(1488),
    [anon_sym_being] = ACTIONS(1488),
    [anon_sym_using] = ACTIONS(1488),
    [aux_sym_for_clause_word_token1] = ACTIONS(1490),
    [anon_sym_below] = ACTIONS(1488),
    [anon_sym_above] = ACTIONS(1488),
    [anon_sym_from] = ACTIONS(1488),
    [anon_sym_to] = ACTIONS(1488),
    [anon_sym_upto] = ACTIONS(1488),
    [anon_sym_upfrom] = ACTIONS(1488),
    [anon_sym_downto] = ACTIONS(1488),
    [anon_sym_downfrom] = ACTIONS(1488),
    [anon_sym_on] = ACTIONS(1488),
    [anon_sym_by] = ACTIONS(1488),
    [anon_sym_then] = ACTIONS(1488),
    [anon_sym_EQ] = ACTIONS(1488),
    [anon_sym_POUNDP] = ACTIONS(1492),
    [anon_sym_POUNDp] = ACTIONS(1492),
    [sym_self_referential_reader_macro] = ACTIONS(1926),
    [anon_sym_POUND_PLUS] = ACTIONS(1496),
    [anon_sym_POUND_DASH] = ACTIONS(1496),
    [anon_sym_POUNDC] = ACTIONS(1498),
    [anon_sym_POUNDc] = ACTIONS(1498),
  },
  [79] = {
    [sym__gap] = STATE(121),
    [sym_dis_expr] = STATE(121),
    [sym__form] = STATE(2143),
    [sym_num_lit] = STATE(2143),
    [sym_kwd_lit] = STATE(2143),
    [sym_str_lit] = STATE(2143),
    [sym_char_lit] = STATE(2143),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2143),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2143),
    [sym_set_lit] = STATE(2143),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2143),
    [sym_splicing_read_cond_lit] = STATE(2143),
    [sym_var_quoting_lit] = STATE(2143),
    [sym_quoting_lit] = STATE(2143),
    [sym_syn_quoting_lit] = STATE(2143),
    [sym_unquote_splicing_lit] = STATE(2143),
    [sym_unquoting_lit] = STATE(2143),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2143),
    [sym_package_lit] = STATE(2143),
    [sym_include_reader_macro] = STATE(2143),
    [sym_complex_num_lit] = STATE(2143),
    [aux_sym_dis_expr_repeat1] = STATE(121),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1928),
    [sym_comment] = ACTIONS(1928),
    [anon_sym_POUND_] = ACTIONS(1931),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1934),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1936),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1934),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1939),
    [anon_sym_POUND_CARET] = ACTIONS(1942),
    [anon_sym_LPAREN] = ACTIONS(1945),
    [anon_sym_RPAREN] = ACTIONS(1948),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1934),
    [anon_sym_cl] = ACTIONS(1950),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1953),
    [anon_sym_for] = ACTIONS(1953),
    [anon_sym_and] = ACTIONS(1953),
    [anon_sym_as] = ACTIONS(1953),
    [anon_sym_with] = ACTIONS(1953),
    [anon_sym_do] = ACTIONS(1953),
    [anon_sym_while] = ACTIONS(1953),
    [anon_sym_until] = ACTIONS(1953),
    [anon_sym_repeat] = ACTIONS(1953),
    [anon_sym_when] = ACTIONS(1953),
    [anon_sym_if] = ACTIONS(1953),
    [anon_sym_unless] = ACTIONS(1953),
    [anon_sym_always] = ACTIONS(1953),
    [anon_sym_thereis] = ACTIONS(1953),
    [anon_sym_never] = ACTIONS(1953),
    [anon_sym_else] = ACTIONS(1953),
    [anon_sym_finally] = ACTIONS(1953),
    [anon_sym_return] = ACTIONS(1953),
    [anon_sym_initially] = ACTIONS(1953),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1955),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [80] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2147),
    [sym_num_lit] = STATE(2147),
    [sym_kwd_lit] = STATE(2147),
    [sym_str_lit] = STATE(2147),
    [sym_char_lit] = STATE(2147),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2147),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2147),
    [sym_set_lit] = STATE(2147),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2147),
    [sym_splicing_read_cond_lit] = STATE(2147),
    [sym_var_quoting_lit] = STATE(2147),
    [sym_quoting_lit] = STATE(2147),
    [sym_syn_quoting_lit] = STATE(2147),
    [sym_unquote_splicing_lit] = STATE(2147),
    [sym_unquoting_lit] = STATE(2147),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2147),
    [sym_package_lit] = STATE(2147),
    [sym_include_reader_macro] = STATE(2147),
    [sym_complex_num_lit] = STATE(2147),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1957),
    [sym_comment] = ACTIONS(1957),
    [anon_sym_POUND_] = ACTIONS(1931),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1960),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1936),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1960),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1939),
    [anon_sym_POUND_CARET] = ACTIONS(1942),
    [anon_sym_LPAREN] = ACTIONS(1945),
    [anon_sym_RPAREN] = ACTIONS(1948),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1960),
    [anon_sym_cl] = ACTIONS(1950),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1953),
    [anon_sym_for] = ACTIONS(1953),
    [anon_sym_and] = ACTIONS(1953),
    [anon_sym_as] = ACTIONS(1953),
    [anon_sym_with] = ACTIONS(1953),
    [anon_sym_do] = ACTIONS(1953),
    [anon_sym_while] = ACTIONS(1953),
    [anon_sym_until] = ACTIONS(1953),
    [anon_sym_repeat] = ACTIONS(1953),
    [anon_sym_when] = ACTIONS(1953),
    [anon_sym_if] = ACTIONS(1953),
    [anon_sym_unless] = ACTIONS(1953),
    [anon_sym_always] = ACTIONS(1953),
    [anon_sym_thereis] = ACTIONS(1953),
    [anon_sym_never] = ACTIONS(1953),
    [anon_sym_else] = ACTIONS(1953),
    [anon_sym_finally] = ACTIONS(1953),
    [anon_sym_return] = ACTIONS(1953),
    [anon_sym_initially] = ACTIONS(1953),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1962),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [81] = {
    [sym__gap] = STATE(124),
    [sym_dis_expr] = STATE(124),
    [sym__form] = STATE(2148),
    [sym_num_lit] = STATE(2148),
    [sym_kwd_lit] = STATE(2148),
    [sym_str_lit] = STATE(2148),
    [sym_char_lit] = STATE(2148),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2148),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2148),
    [sym_set_lit] = STATE(2148),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2148),
    [sym_splicing_read_cond_lit] = STATE(2148),
    [sym_var_quoting_lit] = STATE(2148),
    [sym_quoting_lit] = STATE(2148),
    [sym_syn_quoting_lit] = STATE(2148),
    [sym_unquote_splicing_lit] = STATE(2148),
    [sym_unquoting_lit] = STATE(2148),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2148),
    [sym_package_lit] = STATE(2148),
    [sym_include_reader_macro] = STATE(2148),
    [sym_complex_num_lit] = STATE(2148),
    [aux_sym_dis_expr_repeat1] = STATE(124),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1964),
    [sym_comment] = ACTIONS(1964),
    [anon_sym_POUND_] = ACTIONS(1967),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(1970),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1972),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(1970),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1975),
    [anon_sym_POUND_CARET] = ACTIONS(1978),
    [anon_sym_LPAREN] = ACTIONS(1981),
    [anon_sym_RPAREN] = ACTIONS(1984),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1970),
    [anon_sym_cl] = ACTIONS(1986),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1989),
    [anon_sym_for] = ACTIONS(1989),
    [anon_sym_and] = ACTIONS(1989),
    [anon_sym_as] = ACTIONS(1989),
    [anon_sym_with] = ACTIONS(1989),
    [anon_sym_do] = ACTIONS(1989),
    [anon_sym_while] = ACTIONS(1989),
    [anon_sym_until] = ACTIONS(1989),
    [anon_sym_repeat] = ACTIONS(1989),
    [anon_sym_when] = ACTIONS(1989),
    [anon_sym_if] = ACTIONS(1989),
    [anon_sym_unless] = ACTIONS(1989),
    [anon_sym_always] = ACTIONS(1989),
    [anon_sym_thereis] = ACTIONS(1989),
    [anon_sym_never] = ACTIONS(1989),
    [anon_sym_else] = ACTIONS(1989),
    [anon_sym_finally] = ACTIONS(1989),
    [anon_sym_return] = ACTIONS(1989),
    [anon_sym_initially] = ACTIONS(1989),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(1991),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [82] = {
    [sym__gap] = STATE(275),
    [sym_dis_expr] = STATE(275),
    [sym__form] = STATE(2724),
    [sym_num_lit] = STATE(2724),
    [sym_kwd_lit] = STATE(2724),
    [sym_str_lit] = STATE(2724),
    [sym_char_lit] = STATE(2724),
    [sym_sym_lit] = STATE(2766),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2724),
    [sym__bare_list_lit] = STATE(1975),
    [sym_vec_lit] = STATE(2724),
    [sym_set_lit] = STATE(2724),
    [sym__bare_set_lit] = STATE(1976),
    [sym_read_cond_lit] = STATE(2724),
    [sym_splicing_read_cond_lit] = STATE(2724),
    [sym_var_quoting_lit] = STATE(2724),
    [sym_quoting_lit] = STATE(2724),
    [sym_syn_quoting_lit] = STATE(2724),
    [sym_unquote_splicing_lit] = STATE(2724),
    [sym_unquoting_lit] = STATE(2724),
    [sym_defun] = STATE(1975),
    [sym_for_clause_word] = STATE(419),
    [sym__for_part] = STATE(1555),
    [sym_loop_macro] = STATE(1975),
    [sym_path_lit] = STATE(2724),
    [sym_package_lit] = STATE(2724),
    [sym_include_reader_macro] = STATE(2724),
    [sym_complex_num_lit] = STATE(2724),
    [aux_sym_dis_expr_repeat1] = STATE(275),
    [aux_sym_list_lit_repeat1] = STATE(2830),
    [aux_sym_for_clause_repeat1] = STATE(1257),
    [sym__ws] = ACTIONS(1993),
    [sym_comment] = ACTIONS(1993),
    [anon_sym_POUND_] = ACTIONS(1452),
    [anon_sym_POUND] = ACTIONS(1454),
    [anon_sym_DOT] = ACTIONS(1995),
    [aux_sym_num_lit_token1] = ACTIONS(1458),
    [anon_sym_COLON] = ACTIONS(1460),
    [anon_sym_COLON_COLON] = ACTIONS(1462),
    [anon_sym_DQUOTE] = ACTIONS(1464),
    [sym_nil_lit] = ACTIONS(1995),
    [aux_sym_sym_lit_token1] = ACTIONS(1466),
    [anon_sym_CARET] = ACTIONS(25),
    [anon_sym_POUND_CARET] = ACTIONS(27),
    [anon_sym_LPAREN] = ACTIONS(1468),
    [anon_sym_POUND0A] = ACTIONS(1470),
    [anon_sym_POUND0a] = ACTIONS(1470),
    [anon_sym_POUND_QMARK] = ACTIONS(1472),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(1474),
    [anon_sym_POUND_SQUOTE] = ACTIONS(1476),
    [anon_sym_SQUOTE] = ACTIONS(1478),
    [anon_sym_BQUOTE] = ACTIONS(1480),
    [anon_sym_COMMA_AT] = ACTIONS(1482),
    [anon_sym_COMMA] = ACTIONS(1484),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(1995),
    [anon_sym_cl] = ACTIONS(1486),
    [anon_sym_in] = ACTIONS(1488),
    [anon_sym_across] = ACTIONS(1488),
    [anon_sym_being] = ACTIONS(1488),
    [anon_sym_using] = ACTIONS(1488),
    [aux_sym_for_clause_word_token1] = ACTIONS(1490),
    [anon_sym_below] = ACTIONS(1488),
    [anon_sym_above] = ACTIONS(1488),
    [anon_sym_from] = ACTIONS(1488),
    [anon_sym_to] = ACTIONS(1488),
    [anon_sym_upto] = ACTIONS(1488),
    [anon_sym_upfrom] = ACTIONS(1488),
    [anon_sym_downto] = ACTIONS(1488),
    [anon_sym_downfrom] = ACTIONS(1488),
    [anon_sym_on] = ACTIONS(1488),
    [anon_sym_by] = ACTIONS(1488),
    [anon_sym_then] = ACTIONS(1488),
    [anon_sym_EQ] = ACTIONS(1488),
    [anon_sym_POUNDP] = ACTIONS(1492),
    [anon_sym_POUNDp] = ACTIONS(1492),
    [sym_self_referential_reader_macro] = ACTIONS(1997),
    [anon_sym_POUND_PLUS] = ACTIONS(1496),
    [anon_sym_POUND_DASH] = ACTIONS(1496),
    [anon_sym_POUNDC] = ACTIONS(1498),
    [anon_sym_POUNDc] = ACTIONS(1498),
  },
  [83] = {
    [sym__gap] = STATE(127),
    [sym_dis_expr] = STATE(127),
    [sym__form] = STATE(2153),
    [sym_num_lit] = STATE(2153),
    [sym_kwd_lit] = STATE(2153),
    [sym_str_lit] = STATE(2153),
    [sym_char_lit] = STATE(2153),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2153),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2153),
    [sym_set_lit] = STATE(2153),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2153),
    [sym_splicing_read_cond_lit] = STATE(2153),
    [sym_var_quoting_lit] = STATE(2153),
    [sym_quoting_lit] = STATE(2153),
    [sym_syn_quoting_lit] = STATE(2153),
    [sym_unquote_splicing_lit] = STATE(2153),
    [sym_unquoting_lit] = STATE(2153),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2153),
    [sym_package_lit] = STATE(2153),
    [sym_include_reader_macro] = STATE(2153),
    [sym_complex_num_lit] = STATE(2153),
    [aux_sym_dis_expr_repeat1] = STATE(127),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1999),
    [sym_comment] = ACTIONS(1999),
    [anon_sym_POUND_] = ACTIONS(1931),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2002),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1936),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2002),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1939),
    [anon_sym_POUND_CARET] = ACTIONS(1942),
    [anon_sym_LPAREN] = ACTIONS(1945),
    [anon_sym_RPAREN] = ACTIONS(1948),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2002),
    [anon_sym_cl] = ACTIONS(1950),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1953),
    [anon_sym_for] = ACTIONS(1953),
    [anon_sym_and] = ACTIONS(1953),
    [anon_sym_as] = ACTIONS(1953),
    [anon_sym_with] = ACTIONS(1953),
    [anon_sym_do] = ACTIONS(1953),
    [anon_sym_while] = ACTIONS(1953),
    [anon_sym_until] = ACTIONS(1953),
    [anon_sym_repeat] = ACTIONS(1953),
    [anon_sym_when] = ACTIONS(1953),
    [anon_sym_if] = ACTIONS(1953),
    [anon_sym_unless] = ACTIONS(1953),
    [anon_sym_always] = ACTIONS(1953),
    [anon_sym_thereis] = ACTIONS(1953),
    [anon_sym_never] = ACTIONS(1953),
    [anon_sym_else] = ACTIONS(1953),
    [anon_sym_finally] = ACTIONS(1953),
    [anon_sym_return] = ACTIONS(1953),
    [anon_sym_initially] = ACTIONS(1953),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2004),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [84] = {
    [sym__gap] = STATE(277),
    [sym_dis_expr] = STATE(277),
    [sym__form] = STATE(2675),
    [sym_num_lit] = STATE(2675),
    [sym_kwd_lit] = STATE(2675),
    [sym_str_lit] = STATE(2675),
    [sym_char_lit] = STATE(2675),
    [sym_sym_lit] = STATE(2766),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2675),
    [sym__bare_list_lit] = STATE(1975),
    [sym_vec_lit] = STATE(2675),
    [sym_set_lit] = STATE(2675),
    [sym__bare_set_lit] = STATE(1976),
    [sym_read_cond_lit] = STATE(2675),
    [sym_splicing_read_cond_lit] = STATE(2675),
    [sym_var_quoting_lit] = STATE(2675),
    [sym_quoting_lit] = STATE(2675),
    [sym_syn_quoting_lit] = STATE(2675),
    [sym_unquote_splicing_lit] = STATE(2675),
    [sym_unquoting_lit] = STATE(2675),
    [sym_defun] = STATE(1975),
    [sym_for_clause_word] = STATE(419),
    [sym__for_part] = STATE(1555),
    [sym_loop_macro] = STATE(1975),
    [sym_path_lit] = STATE(2675),
    [sym_package_lit] = STATE(2675),
    [sym_include_reader_macro] = STATE(2675),
    [sym_complex_num_lit] = STATE(2675),
    [aux_sym_dis_expr_repeat1] = STATE(277),
    [aux_sym_list_lit_repeat1] = STATE(2830),
    [aux_sym_for_clause_repeat1] = STATE(1271),
    [sym__ws] = ACTIONS(2006),
    [sym_comment] = ACTIONS(2006),
    [anon_sym_POUND_] = ACTIONS(1452),
    [anon_sym_POUND] = ACTIONS(1454),
    [anon_sym_DOT] = ACTIONS(2008),
    [aux_sym_num_lit_token1] = ACTIONS(1458),
    [anon_sym_COLON] = ACTIONS(1460),
    [anon_sym_COLON_COLON] = ACTIONS(1462),
    [anon_sym_DQUOTE] = ACTIONS(1464),
    [sym_nil_lit] = ACTIONS(2008),
    [aux_sym_sym_lit_token1] = ACTIONS(1466),
    [anon_sym_CARET] = ACTIONS(25),
    [anon_sym_POUND_CARET] = ACTIONS(27),
    [anon_sym_LPAREN] = ACTIONS(1468),
    [anon_sym_POUND0A] = ACTIONS(1470),
    [anon_sym_POUND0a] = ACTIONS(1470),
    [anon_sym_POUND_QMARK] = ACTIONS(1472),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(1474),
    [anon_sym_POUND_SQUOTE] = ACTIONS(1476),
    [anon_sym_SQUOTE] = ACTIONS(1478),
    [anon_sym_BQUOTE] = ACTIONS(1480),
    [anon_sym_COMMA_AT] = ACTIONS(1482),
    [anon_sym_COMMA] = ACTIONS(1484),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2008),
    [anon_sym_cl] = ACTIONS(1486),
    [anon_sym_in] = ACTIONS(1488),
    [anon_sym_across] = ACTIONS(1488),
    [anon_sym_being] = ACTIONS(1488),
    [anon_sym_using] = ACTIONS(1488),
    [aux_sym_for_clause_word_token1] = ACTIONS(1490),
    [anon_sym_below] = ACTIONS(1488),
    [anon_sym_above] = ACTIONS(1488),
    [anon_sym_from] = ACTIONS(1488),
    [anon_sym_to] = ACTIONS(1488),
    [anon_sym_upto] = ACTIONS(1488),
    [anon_sym_upfrom] = ACTIONS(1488),
    [anon_sym_downto] = ACTIONS(1488),
    [anon_sym_downfrom] = ACTIONS(1488),
    [anon_sym_on] = ACTIONS(1488),
    [anon_sym_by] = ACTIONS(1488),
    [anon_sym_then] = ACTIONS(1488),
    [anon_sym_EQ] = ACTIONS(1488),
    [anon_sym_POUNDP] = ACTIONS(1492),
    [anon_sym_POUNDp] = ACTIONS(1492),
    [sym_self_referential_reader_macro] = ACTIONS(2010),
    [anon_sym_POUND_PLUS] = ACTIONS(1496),
    [anon_sym_POUND_DASH] = ACTIONS(1496),
    [anon_sym_POUNDC] = ACTIONS(1498),
    [anon_sym_POUNDc] = ACTIONS(1498),
  },
  [85] = {
    [sym__gap] = STATE(130),
    [sym_dis_expr] = STATE(130),
    [sym__form] = STATE(2156),
    [sym_num_lit] = STATE(2156),
    [sym_kwd_lit] = STATE(2156),
    [sym_str_lit] = STATE(2156),
    [sym_char_lit] = STATE(2156),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2156),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2156),
    [sym_set_lit] = STATE(2156),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2156),
    [sym_splicing_read_cond_lit] = STATE(2156),
    [sym_var_quoting_lit] = STATE(2156),
    [sym_quoting_lit] = STATE(2156),
    [sym_syn_quoting_lit] = STATE(2156),
    [sym_unquote_splicing_lit] = STATE(2156),
    [sym_unquoting_lit] = STATE(2156),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2156),
    [sym_package_lit] = STATE(2156),
    [sym_include_reader_macro] = STATE(2156),
    [sym_complex_num_lit] = STATE(2156),
    [aux_sym_dis_expr_repeat1] = STATE(130),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2012),
    [sym_comment] = ACTIONS(2012),
    [anon_sym_POUND_] = ACTIONS(1931),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2015),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1936),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2015),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1939),
    [anon_sym_POUND_CARET] = ACTIONS(1942),
    [anon_sym_LPAREN] = ACTIONS(1945),
    [anon_sym_RPAREN] = ACTIONS(1948),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2015),
    [anon_sym_cl] = ACTIONS(1950),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1953),
    [anon_sym_for] = ACTIONS(1953),
    [anon_sym_and] = ACTIONS(1953),
    [anon_sym_as] = ACTIONS(1953),
    [anon_sym_with] = ACTIONS(1953),
    [anon_sym_do] = ACTIONS(1953),
    [anon_sym_while] = ACTIONS(1953),
    [anon_sym_until] = ACTIONS(1953),
    [anon_sym_repeat] = ACTIONS(1953),
    [anon_sym_when] = ACTIONS(1953),
    [anon_sym_if] = ACTIONS(1953),
    [anon_sym_unless] = ACTIONS(1953),
    [anon_sym_always] = ACTIONS(1953),
    [anon_sym_thereis] = ACTIONS(1953),
    [anon_sym_never] = ACTIONS(1953),
    [anon_sym_else] = ACTIONS(1953),
    [anon_sym_finally] = ACTIONS(1953),
    [anon_sym_return] = ACTIONS(1953),
    [anon_sym_initially] = ACTIONS(1953),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2017),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [86] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2159),
    [sym_num_lit] = STATE(2159),
    [sym_kwd_lit] = STATE(2159),
    [sym_str_lit] = STATE(2159),
    [sym_char_lit] = STATE(2159),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2159),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2159),
    [sym_set_lit] = STATE(2159),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2159),
    [sym_splicing_read_cond_lit] = STATE(2159),
    [sym_var_quoting_lit] = STATE(2159),
    [sym_quoting_lit] = STATE(2159),
    [sym_syn_quoting_lit] = STATE(2159),
    [sym_unquote_splicing_lit] = STATE(2159),
    [sym_unquoting_lit] = STATE(2159),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2159),
    [sym_package_lit] = STATE(2159),
    [sym_include_reader_macro] = STATE(2159),
    [sym_complex_num_lit] = STATE(2159),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1957),
    [sym_comment] = ACTIONS(1957),
    [anon_sym_POUND_] = ACTIONS(1931),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2019),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1936),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2019),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1939),
    [anon_sym_POUND_CARET] = ACTIONS(1942),
    [anon_sym_LPAREN] = ACTIONS(1945),
    [anon_sym_RPAREN] = ACTIONS(1948),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2019),
    [anon_sym_cl] = ACTIONS(1950),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1953),
    [anon_sym_for] = ACTIONS(1953),
    [anon_sym_and] = ACTIONS(1953),
    [anon_sym_as] = ACTIONS(1953),
    [anon_sym_with] = ACTIONS(1953),
    [anon_sym_do] = ACTIONS(1953),
    [anon_sym_while] = ACTIONS(1953),
    [anon_sym_until] = ACTIONS(1953),
    [anon_sym_repeat] = ACTIONS(1953),
    [anon_sym_when] = ACTIONS(1953),
    [anon_sym_if] = ACTIONS(1953),
    [anon_sym_unless] = ACTIONS(1953),
    [anon_sym_always] = ACTIONS(1953),
    [anon_sym_thereis] = ACTIONS(1953),
    [anon_sym_never] = ACTIONS(1953),
    [anon_sym_else] = ACTIONS(1953),
    [anon_sym_finally] = ACTIONS(1953),
    [anon_sym_return] = ACTIONS(1953),
    [anon_sym_initially] = ACTIONS(1953),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2021),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [87] = {
    [sym__gap] = STATE(133),
    [sym_dis_expr] = STATE(133),
    [sym__form] = STATE(2160),
    [sym_num_lit] = STATE(2160),
    [sym_kwd_lit] = STATE(2160),
    [sym_str_lit] = STATE(2160),
    [sym_char_lit] = STATE(2160),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2160),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2160),
    [sym_set_lit] = STATE(2160),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2160),
    [sym_splicing_read_cond_lit] = STATE(2160),
    [sym_var_quoting_lit] = STATE(2160),
    [sym_quoting_lit] = STATE(2160),
    [sym_syn_quoting_lit] = STATE(2160),
    [sym_unquote_splicing_lit] = STATE(2160),
    [sym_unquoting_lit] = STATE(2160),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2160),
    [sym_package_lit] = STATE(2160),
    [sym_include_reader_macro] = STATE(2160),
    [sym_complex_num_lit] = STATE(2160),
    [aux_sym_dis_expr_repeat1] = STATE(133),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2023),
    [sym_comment] = ACTIONS(2023),
    [anon_sym_POUND_] = ACTIONS(1967),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2026),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1972),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2026),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1975),
    [anon_sym_POUND_CARET] = ACTIONS(1978),
    [anon_sym_LPAREN] = ACTIONS(1981),
    [anon_sym_RPAREN] = ACTIONS(1984),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2026),
    [anon_sym_cl] = ACTIONS(1986),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1989),
    [anon_sym_for] = ACTIONS(1989),
    [anon_sym_and] = ACTIONS(1989),
    [anon_sym_as] = ACTIONS(1989),
    [anon_sym_with] = ACTIONS(1989),
    [anon_sym_do] = ACTIONS(1989),
    [anon_sym_while] = ACTIONS(1989),
    [anon_sym_until] = ACTIONS(1989),
    [anon_sym_repeat] = ACTIONS(1989),
    [anon_sym_when] = ACTIONS(1989),
    [anon_sym_if] = ACTIONS(1989),
    [anon_sym_unless] = ACTIONS(1989),
    [anon_sym_always] = ACTIONS(1989),
    [anon_sym_thereis] = ACTIONS(1989),
    [anon_sym_never] = ACTIONS(1989),
    [anon_sym_else] = ACTIONS(1989),
    [anon_sym_finally] = ACTIONS(1989),
    [anon_sym_return] = ACTIONS(1989),
    [anon_sym_initially] = ACTIONS(1989),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2028),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [88] = {
    [sym__gap] = STATE(136),
    [sym_dis_expr] = STATE(136),
    [sym__form] = STATE(2164),
    [sym_num_lit] = STATE(2164),
    [sym_kwd_lit] = STATE(2164),
    [sym_str_lit] = STATE(2164),
    [sym_char_lit] = STATE(2164),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2164),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2164),
    [sym_set_lit] = STATE(2164),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2164),
    [sym_splicing_read_cond_lit] = STATE(2164),
    [sym_var_quoting_lit] = STATE(2164),
    [sym_quoting_lit] = STATE(2164),
    [sym_syn_quoting_lit] = STATE(2164),
    [sym_unquote_splicing_lit] = STATE(2164),
    [sym_unquoting_lit] = STATE(2164),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2164),
    [sym_package_lit] = STATE(2164),
    [sym_include_reader_macro] = STATE(2164),
    [sym_complex_num_lit] = STATE(2164),
    [aux_sym_dis_expr_repeat1] = STATE(136),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2030),
    [sym_comment] = ACTIONS(2030),
    [anon_sym_POUND_] = ACTIONS(1931),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2033),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1936),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2033),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1939),
    [anon_sym_POUND_CARET] = ACTIONS(1942),
    [anon_sym_LPAREN] = ACTIONS(1945),
    [anon_sym_RPAREN] = ACTIONS(1948),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2033),
    [anon_sym_cl] = ACTIONS(1950),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1953),
    [anon_sym_for] = ACTIONS(1953),
    [anon_sym_and] = ACTIONS(1953),
    [anon_sym_as] = ACTIONS(1953),
    [anon_sym_with] = ACTIONS(1953),
    [anon_sym_do] = ACTIONS(1953),
    [anon_sym_while] = ACTIONS(1953),
    [anon_sym_until] = ACTIONS(1953),
    [anon_sym_repeat] = ACTIONS(1953),
    [anon_sym_when] = ACTIONS(1953),
    [anon_sym_if] = ACTIONS(1953),
    [anon_sym_unless] = ACTIONS(1953),
    [anon_sym_always] = ACTIONS(1953),
    [anon_sym_thereis] = ACTIONS(1953),
    [anon_sym_never] = ACTIONS(1953),
    [anon_sym_else] = ACTIONS(1953),
    [anon_sym_finally] = ACTIONS(1953),
    [anon_sym_return] = ACTIONS(1953),
    [anon_sym_initially] = ACTIONS(1953),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2035),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [89] = {
    [sym__gap] = STATE(140),
    [sym_dis_expr] = STATE(140),
    [sym__form] = STATE(2167),
    [sym_num_lit] = STATE(2167),
    [sym_kwd_lit] = STATE(2167),
    [sym_str_lit] = STATE(2167),
    [sym_char_lit] = STATE(2167),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2167),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2167),
    [sym_set_lit] = STATE(2167),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2167),
    [sym_splicing_read_cond_lit] = STATE(2167),
    [sym_var_quoting_lit] = STATE(2167),
    [sym_quoting_lit] = STATE(2167),
    [sym_syn_quoting_lit] = STATE(2167),
    [sym_unquote_splicing_lit] = STATE(2167),
    [sym_unquoting_lit] = STATE(2167),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2167),
    [sym_package_lit] = STATE(2167),
    [sym_include_reader_macro] = STATE(2167),
    [sym_complex_num_lit] = STATE(2167),
    [aux_sym_dis_expr_repeat1] = STATE(140),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2037),
    [sym_comment] = ACTIONS(2037),
    [anon_sym_POUND_] = ACTIONS(2040),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2043),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2045),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2043),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(80),
    [anon_sym_POUND_CARET] = ACTIONS(83),
    [anon_sym_LPAREN] = ACTIONS(2048),
    [anon_sym_RPAREN] = ACTIONS(89),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2043),
    [anon_sym_cl] = ACTIONS(2051),
    [aux_sym_accumulation_verb_token1] = ACTIONS(112),
    [anon_sym_for] = ACTIONS(112),
    [anon_sym_and] = ACTIONS(112),
    [anon_sym_as] = ACTIONS(112),
    [anon_sym_with] = ACTIONS(112),
    [anon_sym_do] = ACTIONS(112),
    [anon_sym_while] = ACTIONS(112),
    [anon_sym_until] = ACTIONS(112),
    [anon_sym_repeat] = ACTIONS(112),
    [anon_sym_when] = ACTIONS(112),
    [anon_sym_if] = ACTIONS(112),
    [anon_sym_unless] = ACTIONS(112),
    [anon_sym_always] = ACTIONS(112),
    [anon_sym_thereis] = ACTIONS(112),
    [anon_sym_never] = ACTIONS(112),
    [anon_sym_else] = ACTIONS(112),
    [anon_sym_finally] = ACTIONS(112),
    [anon_sym_return] = ACTIONS(112),
    [anon_sym_initially] = ACTIONS(112),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2054),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [90] = {
    [sym__gap] = STATE(55),
    [sym_dis_expr] = STATE(55),
    [sym__form] = STATE(2526),
    [sym_num_lit] = STATE(2526),
    [sym_kwd_lit] = STATE(2526),
    [sym_str_lit] = STATE(2526),
    [sym_char_lit] = STATE(2526),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2526),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2526),
    [sym_set_lit] = STATE(2526),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2526),
    [sym_splicing_read_cond_lit] = STATE(2526),
    [sym_var_quoting_lit] = STATE(2526),
    [sym_quoting_lit] = STATE(2526),
    [sym_syn_quoting_lit] = STATE(2526),
    [sym_unquote_splicing_lit] = STATE(2526),
    [sym_unquoting_lit] = STATE(2526),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2526),
    [sym_package_lit] = STATE(2526),
    [sym_include_reader_macro] = STATE(2526),
    [sym_complex_num_lit] = STATE(2526),
    [aux_sym_dis_expr_repeat1] = STATE(55),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2056),
    [sym_comment] = ACTIONS(2056),
    [anon_sym_POUND_] = ACTIONS(2059),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2062),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2064),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2062),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2067),
    [anon_sym_POUND_CARET] = ACTIONS(2070),
    [anon_sym_LPAREN] = ACTIONS(2073),
    [anon_sym_RPAREN] = ACTIONS(2076),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2062),
    [anon_sym_cl] = ACTIONS(2078),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2081),
    [anon_sym_for] = ACTIONS(2081),
    [anon_sym_and] = ACTIONS(2081),
    [anon_sym_as] = ACTIONS(2081),
    [anon_sym_with] = ACTIONS(2081),
    [anon_sym_do] = ACTIONS(2081),
    [anon_sym_while] = ACTIONS(2081),
    [anon_sym_until] = ACTIONS(2081),
    [anon_sym_repeat] = ACTIONS(2081),
    [anon_sym_when] = ACTIONS(2081),
    [anon_sym_if] = ACTIONS(2081),
    [anon_sym_unless] = ACTIONS(2081),
    [anon_sym_always] = ACTIONS(2081),
    [anon_sym_thereis] = ACTIONS(2081),
    [anon_sym_never] = ACTIONS(2081),
    [anon_sym_else] = ACTIONS(2081),
    [anon_sym_finally] = ACTIONS(2081),
    [anon_sym_return] = ACTIONS(2081),
    [anon_sym_initially] = ACTIONS(2081),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2083),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [91] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2530),
    [sym_num_lit] = STATE(2530),
    [sym_kwd_lit] = STATE(2530),
    [sym_str_lit] = STATE(2530),
    [sym_char_lit] = STATE(2530),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2530),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2530),
    [sym_set_lit] = STATE(2530),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2530),
    [sym_splicing_read_cond_lit] = STATE(2530),
    [sym_var_quoting_lit] = STATE(2530),
    [sym_quoting_lit] = STATE(2530),
    [sym_syn_quoting_lit] = STATE(2530),
    [sym_unquote_splicing_lit] = STATE(2530),
    [sym_unquoting_lit] = STATE(2530),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2530),
    [sym_package_lit] = STATE(2530),
    [sym_include_reader_macro] = STATE(2530),
    [sym_complex_num_lit] = STATE(2530),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2085),
    [sym_comment] = ACTIONS(2085),
    [anon_sym_POUND_] = ACTIONS(2059),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2088),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2064),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2088),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2067),
    [anon_sym_POUND_CARET] = ACTIONS(2070),
    [anon_sym_LPAREN] = ACTIONS(2073),
    [anon_sym_RPAREN] = ACTIONS(2076),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2088),
    [anon_sym_cl] = ACTIONS(2078),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2081),
    [anon_sym_for] = ACTIONS(2081),
    [anon_sym_and] = ACTIONS(2081),
    [anon_sym_as] = ACTIONS(2081),
    [anon_sym_with] = ACTIONS(2081),
    [anon_sym_do] = ACTIONS(2081),
    [anon_sym_while] = ACTIONS(2081),
    [anon_sym_until] = ACTIONS(2081),
    [anon_sym_repeat] = ACTIONS(2081),
    [anon_sym_when] = ACTIONS(2081),
    [anon_sym_if] = ACTIONS(2081),
    [anon_sym_unless] = ACTIONS(2081),
    [anon_sym_always] = ACTIONS(2081),
    [anon_sym_thereis] = ACTIONS(2081),
    [anon_sym_never] = ACTIONS(2081),
    [anon_sym_else] = ACTIONS(2081),
    [anon_sym_finally] = ACTIONS(2081),
    [anon_sym_return] = ACTIONS(2081),
    [anon_sym_initially] = ACTIONS(2081),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2090),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [92] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2171),
    [sym_num_lit] = STATE(2171),
    [sym_kwd_lit] = STATE(2171),
    [sym_str_lit] = STATE(2171),
    [sym_char_lit] = STATE(2171),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2171),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2171),
    [sym_set_lit] = STATE(2171),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2171),
    [sym_splicing_read_cond_lit] = STATE(2171),
    [sym_var_quoting_lit] = STATE(2171),
    [sym_quoting_lit] = STATE(2171),
    [sym_syn_quoting_lit] = STATE(2171),
    [sym_unquote_splicing_lit] = STATE(2171),
    [sym_unquoting_lit] = STATE(2171),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2171),
    [sym_package_lit] = STATE(2171),
    [sym_include_reader_macro] = STATE(2171),
    [sym_complex_num_lit] = STATE(2171),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2092),
    [sym_comment] = ACTIONS(2092),
    [anon_sym_POUND_] = ACTIONS(2095),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2098),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2100),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2098),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2103),
    [anon_sym_POUND_CARET] = ACTIONS(2106),
    [anon_sym_LPAREN] = ACTIONS(2109),
    [anon_sym_RPAREN] = ACTIONS(2112),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2098),
    [anon_sym_cl] = ACTIONS(2114),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2117),
    [anon_sym_for] = ACTIONS(2117),
    [anon_sym_and] = ACTIONS(2117),
    [anon_sym_as] = ACTIONS(2117),
    [anon_sym_with] = ACTIONS(2117),
    [anon_sym_do] = ACTIONS(2117),
    [anon_sym_while] = ACTIONS(2117),
    [anon_sym_until] = ACTIONS(2117),
    [anon_sym_repeat] = ACTIONS(2117),
    [anon_sym_when] = ACTIONS(2117),
    [anon_sym_if] = ACTIONS(2117),
    [anon_sym_unless] = ACTIONS(2117),
    [anon_sym_always] = ACTIONS(2117),
    [anon_sym_thereis] = ACTIONS(2117),
    [anon_sym_never] = ACTIONS(2117),
    [anon_sym_else] = ACTIONS(2117),
    [anon_sym_finally] = ACTIONS(2117),
    [anon_sym_return] = ACTIONS(2117),
    [anon_sym_initially] = ACTIONS(2117),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2119),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [93] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2173),
    [sym_num_lit] = STATE(2173),
    [sym_kwd_lit] = STATE(2173),
    [sym_str_lit] = STATE(2173),
    [sym_char_lit] = STATE(2173),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2173),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2173),
    [sym_set_lit] = STATE(2173),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2173),
    [sym_splicing_read_cond_lit] = STATE(2173),
    [sym_var_quoting_lit] = STATE(2173),
    [sym_quoting_lit] = STATE(2173),
    [sym_syn_quoting_lit] = STATE(2173),
    [sym_unquote_splicing_lit] = STATE(2173),
    [sym_unquoting_lit] = STATE(2173),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2173),
    [sym_package_lit] = STATE(2173),
    [sym_include_reader_macro] = STATE(2173),
    [sym_complex_num_lit] = STATE(2173),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2121),
    [sym_comment] = ACTIONS(2121),
    [anon_sym_POUND_] = ACTIONS(2124),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2127),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2129),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2127),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2132),
    [anon_sym_POUND_CARET] = ACTIONS(2135),
    [anon_sym_LPAREN] = ACTIONS(2138),
    [anon_sym_RPAREN] = ACTIONS(2141),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2127),
    [anon_sym_cl] = ACTIONS(2143),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2146),
    [anon_sym_for] = ACTIONS(2146),
    [anon_sym_and] = ACTIONS(2146),
    [anon_sym_as] = ACTIONS(2146),
    [anon_sym_with] = ACTIONS(2146),
    [anon_sym_do] = ACTIONS(2146),
    [anon_sym_while] = ACTIONS(2146),
    [anon_sym_until] = ACTIONS(2146),
    [anon_sym_repeat] = ACTIONS(2146),
    [anon_sym_when] = ACTIONS(2146),
    [anon_sym_if] = ACTIONS(2146),
    [anon_sym_unless] = ACTIONS(2146),
    [anon_sym_always] = ACTIONS(2146),
    [anon_sym_thereis] = ACTIONS(2146),
    [anon_sym_never] = ACTIONS(2146),
    [anon_sym_else] = ACTIONS(2146),
    [anon_sym_finally] = ACTIONS(2146),
    [anon_sym_return] = ACTIONS(2146),
    [anon_sym_initially] = ACTIONS(2146),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2148),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [94] = {
    [sym__gap] = STATE(144),
    [sym_dis_expr] = STATE(144),
    [sym__form] = STATE(2174),
    [sym_num_lit] = STATE(2174),
    [sym_kwd_lit] = STATE(2174),
    [sym_str_lit] = STATE(2174),
    [sym_char_lit] = STATE(2174),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2174),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2174),
    [sym_set_lit] = STATE(2174),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2174),
    [sym_splicing_read_cond_lit] = STATE(2174),
    [sym_var_quoting_lit] = STATE(2174),
    [sym_quoting_lit] = STATE(2174),
    [sym_syn_quoting_lit] = STATE(2174),
    [sym_unquote_splicing_lit] = STATE(2174),
    [sym_unquoting_lit] = STATE(2174),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2174),
    [sym_package_lit] = STATE(2174),
    [sym_include_reader_macro] = STATE(2174),
    [sym_complex_num_lit] = STATE(2174),
    [aux_sym_dis_expr_repeat1] = STATE(144),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2150),
    [sym_comment] = ACTIONS(2150),
    [anon_sym_POUND_] = ACTIONS(2124),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2153),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2129),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2153),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2132),
    [anon_sym_POUND_CARET] = ACTIONS(2135),
    [anon_sym_LPAREN] = ACTIONS(2138),
    [anon_sym_RPAREN] = ACTIONS(2141),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2153),
    [anon_sym_cl] = ACTIONS(2143),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2146),
    [anon_sym_for] = ACTIONS(2146),
    [anon_sym_and] = ACTIONS(2146),
    [anon_sym_as] = ACTIONS(2146),
    [anon_sym_with] = ACTIONS(2146),
    [anon_sym_do] = ACTIONS(2146),
    [anon_sym_while] = ACTIONS(2146),
    [anon_sym_until] = ACTIONS(2146),
    [anon_sym_repeat] = ACTIONS(2146),
    [anon_sym_when] = ACTIONS(2146),
    [anon_sym_if] = ACTIONS(2146),
    [anon_sym_unless] = ACTIONS(2146),
    [anon_sym_always] = ACTIONS(2146),
    [anon_sym_thereis] = ACTIONS(2146),
    [anon_sym_never] = ACTIONS(2146),
    [anon_sym_else] = ACTIONS(2146),
    [anon_sym_finally] = ACTIONS(2146),
    [anon_sym_return] = ACTIONS(2146),
    [anon_sym_initially] = ACTIONS(2146),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2155),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [95] = {
    [sym__gap] = STATE(145),
    [sym_dis_expr] = STATE(145),
    [sym__form] = STATE(2176),
    [sym_num_lit] = STATE(2176),
    [sym_kwd_lit] = STATE(2176),
    [sym_str_lit] = STATE(2176),
    [sym_char_lit] = STATE(2176),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2176),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2176),
    [sym_set_lit] = STATE(2176),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2176),
    [sym_splicing_read_cond_lit] = STATE(2176),
    [sym_var_quoting_lit] = STATE(2176),
    [sym_quoting_lit] = STATE(2176),
    [sym_syn_quoting_lit] = STATE(2176),
    [sym_unquote_splicing_lit] = STATE(2176),
    [sym_unquoting_lit] = STATE(2176),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2176),
    [sym_package_lit] = STATE(2176),
    [sym_include_reader_macro] = STATE(2176),
    [sym_complex_num_lit] = STATE(2176),
    [aux_sym_dis_expr_repeat1] = STATE(145),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2157),
    [sym_comment] = ACTIONS(2157),
    [anon_sym_POUND_] = ACTIONS(2124),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2160),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2129),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2160),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2132),
    [anon_sym_POUND_CARET] = ACTIONS(2135),
    [anon_sym_LPAREN] = ACTIONS(2138),
    [anon_sym_RPAREN] = ACTIONS(2141),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2160),
    [anon_sym_cl] = ACTIONS(2143),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2146),
    [anon_sym_for] = ACTIONS(2146),
    [anon_sym_and] = ACTIONS(2146),
    [anon_sym_as] = ACTIONS(2146),
    [anon_sym_with] = ACTIONS(2146),
    [anon_sym_do] = ACTIONS(2146),
    [anon_sym_while] = ACTIONS(2146),
    [anon_sym_until] = ACTIONS(2146),
    [anon_sym_repeat] = ACTIONS(2146),
    [anon_sym_when] = ACTIONS(2146),
    [anon_sym_if] = ACTIONS(2146),
    [anon_sym_unless] = ACTIONS(2146),
    [anon_sym_always] = ACTIONS(2146),
    [anon_sym_thereis] = ACTIONS(2146),
    [anon_sym_never] = ACTIONS(2146),
    [anon_sym_else] = ACTIONS(2146),
    [anon_sym_finally] = ACTIONS(2146),
    [anon_sym_return] = ACTIONS(2146),
    [anon_sym_initially] = ACTIONS(2146),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2162),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [96] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2179),
    [sym_num_lit] = STATE(2179),
    [sym_kwd_lit] = STATE(2179),
    [sym_str_lit] = STATE(2179),
    [sym_char_lit] = STATE(2179),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2179),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2179),
    [sym_set_lit] = STATE(2179),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2179),
    [sym_splicing_read_cond_lit] = STATE(2179),
    [sym_var_quoting_lit] = STATE(2179),
    [sym_quoting_lit] = STATE(2179),
    [sym_syn_quoting_lit] = STATE(2179),
    [sym_unquote_splicing_lit] = STATE(2179),
    [sym_unquoting_lit] = STATE(2179),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2179),
    [sym_package_lit] = STATE(2179),
    [sym_include_reader_macro] = STATE(2179),
    [sym_complex_num_lit] = STATE(2179),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2121),
    [sym_comment] = ACTIONS(2121),
    [anon_sym_POUND_] = ACTIONS(2124),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2164),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2129),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2164),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2132),
    [anon_sym_POUND_CARET] = ACTIONS(2135),
    [anon_sym_LPAREN] = ACTIONS(2138),
    [anon_sym_RPAREN] = ACTIONS(2141),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2164),
    [anon_sym_cl] = ACTIONS(2143),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2146),
    [anon_sym_for] = ACTIONS(2146),
    [anon_sym_and] = ACTIONS(2146),
    [anon_sym_as] = ACTIONS(2146),
    [anon_sym_with] = ACTIONS(2146),
    [anon_sym_do] = ACTIONS(2146),
    [anon_sym_while] = ACTIONS(2146),
    [anon_sym_until] = ACTIONS(2146),
    [anon_sym_repeat] = ACTIONS(2146),
    [anon_sym_when] = ACTIONS(2146),
    [anon_sym_if] = ACTIONS(2146),
    [anon_sym_unless] = ACTIONS(2146),
    [anon_sym_always] = ACTIONS(2146),
    [anon_sym_thereis] = ACTIONS(2146),
    [anon_sym_never] = ACTIONS(2146),
    [anon_sym_else] = ACTIONS(2146),
    [anon_sym_finally] = ACTIONS(2146),
    [anon_sym_return] = ACTIONS(2146),
    [anon_sym_initially] = ACTIONS(2146),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2166),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [97] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2181),
    [sym_num_lit] = STATE(2181),
    [sym_kwd_lit] = STATE(2181),
    [sym_str_lit] = STATE(2181),
    [sym_char_lit] = STATE(2181),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2181),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2181),
    [sym_set_lit] = STATE(2181),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2181),
    [sym_splicing_read_cond_lit] = STATE(2181),
    [sym_var_quoting_lit] = STATE(2181),
    [sym_quoting_lit] = STATE(2181),
    [sym_syn_quoting_lit] = STATE(2181),
    [sym_unquote_splicing_lit] = STATE(2181),
    [sym_unquoting_lit] = STATE(2181),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2181),
    [sym_package_lit] = STATE(2181),
    [sym_include_reader_macro] = STATE(2181),
    [sym_complex_num_lit] = STATE(2181),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2092),
    [sym_comment] = ACTIONS(2092),
    [anon_sym_POUND_] = ACTIONS(2095),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2168),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2100),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2168),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2103),
    [anon_sym_POUND_CARET] = ACTIONS(2106),
    [anon_sym_LPAREN] = ACTIONS(2109),
    [anon_sym_RPAREN] = ACTIONS(2112),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2168),
    [anon_sym_cl] = ACTIONS(2114),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2117),
    [anon_sym_for] = ACTIONS(2117),
    [anon_sym_and] = ACTIONS(2117),
    [anon_sym_as] = ACTIONS(2117),
    [anon_sym_with] = ACTIONS(2117),
    [anon_sym_do] = ACTIONS(2117),
    [anon_sym_while] = ACTIONS(2117),
    [anon_sym_until] = ACTIONS(2117),
    [anon_sym_repeat] = ACTIONS(2117),
    [anon_sym_when] = ACTIONS(2117),
    [anon_sym_if] = ACTIONS(2117),
    [anon_sym_unless] = ACTIONS(2117),
    [anon_sym_always] = ACTIONS(2117),
    [anon_sym_thereis] = ACTIONS(2117),
    [anon_sym_never] = ACTIONS(2117),
    [anon_sym_else] = ACTIONS(2117),
    [anon_sym_finally] = ACTIONS(2117),
    [anon_sym_return] = ACTIONS(2117),
    [anon_sym_initially] = ACTIONS(2117),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2170),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [98] = {
    [sym__gap] = STATE(147),
    [sym_dis_expr] = STATE(147),
    [sym__form] = STATE(2182),
    [sym_num_lit] = STATE(2182),
    [sym_kwd_lit] = STATE(2182),
    [sym_str_lit] = STATE(2182),
    [sym_char_lit] = STATE(2182),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2182),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2182),
    [sym_set_lit] = STATE(2182),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2182),
    [sym_splicing_read_cond_lit] = STATE(2182),
    [sym_var_quoting_lit] = STATE(2182),
    [sym_quoting_lit] = STATE(2182),
    [sym_syn_quoting_lit] = STATE(2182),
    [sym_unquote_splicing_lit] = STATE(2182),
    [sym_unquoting_lit] = STATE(2182),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2182),
    [sym_package_lit] = STATE(2182),
    [sym_include_reader_macro] = STATE(2182),
    [sym_complex_num_lit] = STATE(2182),
    [aux_sym_dis_expr_repeat1] = STATE(147),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2172),
    [sym_comment] = ACTIONS(2172),
    [anon_sym_POUND_] = ACTIONS(2095),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2175),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2100),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2175),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2103),
    [anon_sym_POUND_CARET] = ACTIONS(2106),
    [anon_sym_LPAREN] = ACTIONS(2109),
    [anon_sym_RPAREN] = ACTIONS(2112),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2175),
    [anon_sym_cl] = ACTIONS(2114),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2117),
    [anon_sym_for] = ACTIONS(2117),
    [anon_sym_and] = ACTIONS(2117),
    [anon_sym_as] = ACTIONS(2117),
    [anon_sym_with] = ACTIONS(2117),
    [anon_sym_do] = ACTIONS(2117),
    [anon_sym_while] = ACTIONS(2117),
    [anon_sym_until] = ACTIONS(2117),
    [anon_sym_repeat] = ACTIONS(2117),
    [anon_sym_when] = ACTIONS(2117),
    [anon_sym_if] = ACTIONS(2117),
    [anon_sym_unless] = ACTIONS(2117),
    [anon_sym_always] = ACTIONS(2117),
    [anon_sym_thereis] = ACTIONS(2117),
    [anon_sym_never] = ACTIONS(2117),
    [anon_sym_else] = ACTIONS(2117),
    [anon_sym_finally] = ACTIONS(2117),
    [anon_sym_return] = ACTIONS(2117),
    [anon_sym_initially] = ACTIONS(2117),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2177),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [99] = {
    [sym__gap] = STATE(148),
    [sym_dis_expr] = STATE(148),
    [sym__form] = STATE(2184),
    [sym_num_lit] = STATE(2184),
    [sym_kwd_lit] = STATE(2184),
    [sym_str_lit] = STATE(2184),
    [sym_char_lit] = STATE(2184),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2184),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2184),
    [sym_set_lit] = STATE(2184),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2184),
    [sym_splicing_read_cond_lit] = STATE(2184),
    [sym_var_quoting_lit] = STATE(2184),
    [sym_quoting_lit] = STATE(2184),
    [sym_syn_quoting_lit] = STATE(2184),
    [sym_unquote_splicing_lit] = STATE(2184),
    [sym_unquoting_lit] = STATE(2184),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2184),
    [sym_package_lit] = STATE(2184),
    [sym_include_reader_macro] = STATE(2184),
    [sym_complex_num_lit] = STATE(2184),
    [aux_sym_dis_expr_repeat1] = STATE(148),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2179),
    [sym_comment] = ACTIONS(2179),
    [anon_sym_POUND_] = ACTIONS(2182),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2185),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2187),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2185),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2190),
    [anon_sym_POUND_CARET] = ACTIONS(2193),
    [anon_sym_LPAREN] = ACTIONS(2196),
    [anon_sym_RPAREN] = ACTIONS(2199),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2185),
    [anon_sym_cl] = ACTIONS(2201),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2204),
    [anon_sym_for] = ACTIONS(2204),
    [anon_sym_and] = ACTIONS(2204),
    [anon_sym_as] = ACTIONS(2204),
    [anon_sym_with] = ACTIONS(2204),
    [anon_sym_do] = ACTIONS(2204),
    [anon_sym_while] = ACTIONS(2204),
    [anon_sym_until] = ACTIONS(2204),
    [anon_sym_repeat] = ACTIONS(2204),
    [anon_sym_when] = ACTIONS(2204),
    [anon_sym_if] = ACTIONS(2204),
    [anon_sym_unless] = ACTIONS(2204),
    [anon_sym_always] = ACTIONS(2204),
    [anon_sym_thereis] = ACTIONS(2204),
    [anon_sym_never] = ACTIONS(2204),
    [anon_sym_else] = ACTIONS(2204),
    [anon_sym_finally] = ACTIONS(2204),
    [anon_sym_return] = ACTIONS(2204),
    [anon_sym_initially] = ACTIONS(2204),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2206),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [100] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2186),
    [sym_num_lit] = STATE(2186),
    [sym_kwd_lit] = STATE(2186),
    [sym_str_lit] = STATE(2186),
    [sym_char_lit] = STATE(2186),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2186),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2186),
    [sym_set_lit] = STATE(2186),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2186),
    [sym_splicing_read_cond_lit] = STATE(2186),
    [sym_var_quoting_lit] = STATE(2186),
    [sym_quoting_lit] = STATE(2186),
    [sym_syn_quoting_lit] = STATE(2186),
    [sym_unquote_splicing_lit] = STATE(2186),
    [sym_unquoting_lit] = STATE(2186),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2186),
    [sym_package_lit] = STATE(2186),
    [sym_include_reader_macro] = STATE(2186),
    [sym_complex_num_lit] = STATE(2186),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2208),
    [sym_comment] = ACTIONS(2208),
    [anon_sym_POUND_] = ACTIONS(2182),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2211),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2187),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2211),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2190),
    [anon_sym_POUND_CARET] = ACTIONS(2193),
    [anon_sym_LPAREN] = ACTIONS(2196),
    [anon_sym_RPAREN] = ACTIONS(2199),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2211),
    [anon_sym_cl] = ACTIONS(2201),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2204),
    [anon_sym_for] = ACTIONS(2204),
    [anon_sym_and] = ACTIONS(2204),
    [anon_sym_as] = ACTIONS(2204),
    [anon_sym_with] = ACTIONS(2204),
    [anon_sym_do] = ACTIONS(2204),
    [anon_sym_while] = ACTIONS(2204),
    [anon_sym_until] = ACTIONS(2204),
    [anon_sym_repeat] = ACTIONS(2204),
    [anon_sym_when] = ACTIONS(2204),
    [anon_sym_if] = ACTIONS(2204),
    [anon_sym_unless] = ACTIONS(2204),
    [anon_sym_always] = ACTIONS(2204),
    [anon_sym_thereis] = ACTIONS(2204),
    [anon_sym_never] = ACTIONS(2204),
    [anon_sym_else] = ACTIONS(2204),
    [anon_sym_finally] = ACTIONS(2204),
    [anon_sym_return] = ACTIONS(2204),
    [anon_sym_initially] = ACTIONS(2204),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2213),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [101] = {
    [sym__gap] = STATE(151),
    [sym_dis_expr] = STATE(151),
    [sym__form] = STATE(2187),
    [sym_num_lit] = STATE(2187),
    [sym_kwd_lit] = STATE(2187),
    [sym_str_lit] = STATE(2187),
    [sym_char_lit] = STATE(2187),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2187),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2187),
    [sym_set_lit] = STATE(2187),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2187),
    [sym_splicing_read_cond_lit] = STATE(2187),
    [sym_var_quoting_lit] = STATE(2187),
    [sym_quoting_lit] = STATE(2187),
    [sym_syn_quoting_lit] = STATE(2187),
    [sym_unquote_splicing_lit] = STATE(2187),
    [sym_unquoting_lit] = STATE(2187),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2187),
    [sym_package_lit] = STATE(2187),
    [sym_include_reader_macro] = STATE(2187),
    [sym_complex_num_lit] = STATE(2187),
    [aux_sym_dis_expr_repeat1] = STATE(151),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2215),
    [sym_comment] = ACTIONS(2215),
    [anon_sym_POUND_] = ACTIONS(2182),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2218),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2187),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2218),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2190),
    [anon_sym_POUND_CARET] = ACTIONS(2193),
    [anon_sym_LPAREN] = ACTIONS(2196),
    [anon_sym_RPAREN] = ACTIONS(2199),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2218),
    [anon_sym_cl] = ACTIONS(2201),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2204),
    [anon_sym_for] = ACTIONS(2204),
    [anon_sym_and] = ACTIONS(2204),
    [anon_sym_as] = ACTIONS(2204),
    [anon_sym_with] = ACTIONS(2204),
    [anon_sym_do] = ACTIONS(2204),
    [anon_sym_while] = ACTIONS(2204),
    [anon_sym_until] = ACTIONS(2204),
    [anon_sym_repeat] = ACTIONS(2204),
    [anon_sym_when] = ACTIONS(2204),
    [anon_sym_if] = ACTIONS(2204),
    [anon_sym_unless] = ACTIONS(2204),
    [anon_sym_always] = ACTIONS(2204),
    [anon_sym_thereis] = ACTIONS(2204),
    [anon_sym_never] = ACTIONS(2204),
    [anon_sym_else] = ACTIONS(2204),
    [anon_sym_finally] = ACTIONS(2204),
    [anon_sym_return] = ACTIONS(2204),
    [anon_sym_initially] = ACTIONS(2204),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2220),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [102] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2190),
    [sym_num_lit] = STATE(2190),
    [sym_kwd_lit] = STATE(2190),
    [sym_str_lit] = STATE(2190),
    [sym_char_lit] = STATE(2190),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2190),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2190),
    [sym_set_lit] = STATE(2190),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2190),
    [sym_splicing_read_cond_lit] = STATE(2190),
    [sym_var_quoting_lit] = STATE(2190),
    [sym_quoting_lit] = STATE(2190),
    [sym_syn_quoting_lit] = STATE(2190),
    [sym_unquote_splicing_lit] = STATE(2190),
    [sym_unquoting_lit] = STATE(2190),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2190),
    [sym_package_lit] = STATE(2190),
    [sym_include_reader_macro] = STATE(2190),
    [sym_complex_num_lit] = STATE(2190),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1803),
    [sym_comment] = ACTIONS(1803),
    [anon_sym_POUND_] = ACTIONS(1806),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2222),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1811),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2222),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1814),
    [anon_sym_POUND_CARET] = ACTIONS(1817),
    [anon_sym_LPAREN] = ACTIONS(1820),
    [anon_sym_RPAREN] = ACTIONS(1823),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2222),
    [anon_sym_cl] = ACTIONS(1825),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1828),
    [anon_sym_for] = ACTIONS(1828),
    [anon_sym_and] = ACTIONS(1828),
    [anon_sym_as] = ACTIONS(1828),
    [anon_sym_with] = ACTIONS(1828),
    [anon_sym_do] = ACTIONS(1828),
    [anon_sym_while] = ACTIONS(1828),
    [anon_sym_until] = ACTIONS(1828),
    [anon_sym_repeat] = ACTIONS(1828),
    [anon_sym_when] = ACTIONS(1828),
    [anon_sym_if] = ACTIONS(1828),
    [anon_sym_unless] = ACTIONS(1828),
    [anon_sym_always] = ACTIONS(1828),
    [anon_sym_thereis] = ACTIONS(1828),
    [anon_sym_never] = ACTIONS(1828),
    [anon_sym_else] = ACTIONS(1828),
    [anon_sym_finally] = ACTIONS(1828),
    [anon_sym_return] = ACTIONS(1828),
    [anon_sym_initially] = ACTIONS(1828),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2224),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [103] = {
    [sym__gap] = STATE(152),
    [sym_dis_expr] = STATE(152),
    [sym__form] = STATE(2191),
    [sym_num_lit] = STATE(2191),
    [sym_kwd_lit] = STATE(2191),
    [sym_str_lit] = STATE(2191),
    [sym_char_lit] = STATE(2191),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2191),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2191),
    [sym_set_lit] = STATE(2191),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2191),
    [sym_splicing_read_cond_lit] = STATE(2191),
    [sym_var_quoting_lit] = STATE(2191),
    [sym_quoting_lit] = STATE(2191),
    [sym_syn_quoting_lit] = STATE(2191),
    [sym_unquote_splicing_lit] = STATE(2191),
    [sym_unquoting_lit] = STATE(2191),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2191),
    [sym_package_lit] = STATE(2191),
    [sym_include_reader_macro] = STATE(2191),
    [sym_complex_num_lit] = STATE(2191),
    [aux_sym_dis_expr_repeat1] = STATE(152),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2226),
    [sym_comment] = ACTIONS(2226),
    [anon_sym_POUND_] = ACTIONS(1806),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2229),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1811),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2229),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1814),
    [anon_sym_POUND_CARET] = ACTIONS(1817),
    [anon_sym_LPAREN] = ACTIONS(1820),
    [anon_sym_RPAREN] = ACTIONS(1823),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2229),
    [anon_sym_cl] = ACTIONS(1825),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1828),
    [anon_sym_for] = ACTIONS(1828),
    [anon_sym_and] = ACTIONS(1828),
    [anon_sym_as] = ACTIONS(1828),
    [anon_sym_with] = ACTIONS(1828),
    [anon_sym_do] = ACTIONS(1828),
    [anon_sym_while] = ACTIONS(1828),
    [anon_sym_until] = ACTIONS(1828),
    [anon_sym_repeat] = ACTIONS(1828),
    [anon_sym_when] = ACTIONS(1828),
    [anon_sym_if] = ACTIONS(1828),
    [anon_sym_unless] = ACTIONS(1828),
    [anon_sym_always] = ACTIONS(1828),
    [anon_sym_thereis] = ACTIONS(1828),
    [anon_sym_never] = ACTIONS(1828),
    [anon_sym_else] = ACTIONS(1828),
    [anon_sym_finally] = ACTIONS(1828),
    [anon_sym_return] = ACTIONS(1828),
    [anon_sym_initially] = ACTIONS(1828),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2231),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [104] = {
    [sym__gap] = STATE(153),
    [sym_dis_expr] = STATE(153),
    [sym__form] = STATE(2193),
    [sym_num_lit] = STATE(2193),
    [sym_kwd_lit] = STATE(2193),
    [sym_str_lit] = STATE(2193),
    [sym_char_lit] = STATE(2193),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2193),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2193),
    [sym_set_lit] = STATE(2193),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2193),
    [sym_splicing_read_cond_lit] = STATE(2193),
    [sym_var_quoting_lit] = STATE(2193),
    [sym_quoting_lit] = STATE(2193),
    [sym_syn_quoting_lit] = STATE(2193),
    [sym_unquote_splicing_lit] = STATE(2193),
    [sym_unquoting_lit] = STATE(2193),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2193),
    [sym_package_lit] = STATE(2193),
    [sym_include_reader_macro] = STATE(2193),
    [sym_complex_num_lit] = STATE(2193),
    [aux_sym_dis_expr_repeat1] = STATE(153),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2233),
    [sym_comment] = ACTIONS(2233),
    [anon_sym_POUND_] = ACTIONS(1842),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2236),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1847),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2236),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1850),
    [anon_sym_POUND_CARET] = ACTIONS(1853),
    [anon_sym_LPAREN] = ACTIONS(1856),
    [anon_sym_RPAREN] = ACTIONS(1859),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2236),
    [anon_sym_cl] = ACTIONS(1861),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1864),
    [anon_sym_for] = ACTIONS(1864),
    [anon_sym_and] = ACTIONS(1864),
    [anon_sym_as] = ACTIONS(1864),
    [anon_sym_with] = ACTIONS(1864),
    [anon_sym_do] = ACTIONS(1864),
    [anon_sym_while] = ACTIONS(1864),
    [anon_sym_until] = ACTIONS(1864),
    [anon_sym_repeat] = ACTIONS(1864),
    [anon_sym_when] = ACTIONS(1864),
    [anon_sym_if] = ACTIONS(1864),
    [anon_sym_unless] = ACTIONS(1864),
    [anon_sym_always] = ACTIONS(1864),
    [anon_sym_thereis] = ACTIONS(1864),
    [anon_sym_never] = ACTIONS(1864),
    [anon_sym_else] = ACTIONS(1864),
    [anon_sym_finally] = ACTIONS(1864),
    [anon_sym_return] = ACTIONS(1864),
    [anon_sym_initially] = ACTIONS(1864),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2238),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [105] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2195),
    [sym_num_lit] = STATE(2195),
    [sym_kwd_lit] = STATE(2195),
    [sym_str_lit] = STATE(2195),
    [sym_char_lit] = STATE(2195),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2195),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2195),
    [sym_set_lit] = STATE(2195),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2195),
    [sym_splicing_read_cond_lit] = STATE(2195),
    [sym_var_quoting_lit] = STATE(2195),
    [sym_quoting_lit] = STATE(2195),
    [sym_syn_quoting_lit] = STATE(2195),
    [sym_unquote_splicing_lit] = STATE(2195),
    [sym_unquoting_lit] = STATE(2195),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2195),
    [sym_package_lit] = STATE(2195),
    [sym_include_reader_macro] = STATE(2195),
    [sym_complex_num_lit] = STATE(2195),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1868),
    [sym_comment] = ACTIONS(1868),
    [anon_sym_POUND_] = ACTIONS(1842),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2240),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1847),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2240),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1850),
    [anon_sym_POUND_CARET] = ACTIONS(1853),
    [anon_sym_LPAREN] = ACTIONS(1856),
    [anon_sym_RPAREN] = ACTIONS(1859),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2240),
    [anon_sym_cl] = ACTIONS(1861),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1864),
    [anon_sym_for] = ACTIONS(1864),
    [anon_sym_and] = ACTIONS(1864),
    [anon_sym_as] = ACTIONS(1864),
    [anon_sym_with] = ACTIONS(1864),
    [anon_sym_do] = ACTIONS(1864),
    [anon_sym_while] = ACTIONS(1864),
    [anon_sym_until] = ACTIONS(1864),
    [anon_sym_repeat] = ACTIONS(1864),
    [anon_sym_when] = ACTIONS(1864),
    [anon_sym_if] = ACTIONS(1864),
    [anon_sym_unless] = ACTIONS(1864),
    [anon_sym_always] = ACTIONS(1864),
    [anon_sym_thereis] = ACTIONS(1864),
    [anon_sym_never] = ACTIONS(1864),
    [anon_sym_else] = ACTIONS(1864),
    [anon_sym_finally] = ACTIONS(1864),
    [anon_sym_return] = ACTIONS(1864),
    [anon_sym_initially] = ACTIONS(1864),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2242),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [106] = {
    [sym__gap] = STATE(156),
    [sym_dis_expr] = STATE(156),
    [sym__form] = STATE(2197),
    [sym_num_lit] = STATE(2197),
    [sym_kwd_lit] = STATE(2197),
    [sym_str_lit] = STATE(2197),
    [sym_char_lit] = STATE(2197),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2197),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2197),
    [sym_set_lit] = STATE(2197),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2197),
    [sym_splicing_read_cond_lit] = STATE(2197),
    [sym_var_quoting_lit] = STATE(2197),
    [sym_quoting_lit] = STATE(2197),
    [sym_syn_quoting_lit] = STATE(2197),
    [sym_unquote_splicing_lit] = STATE(2197),
    [sym_unquoting_lit] = STATE(2197),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2197),
    [sym_package_lit] = STATE(2197),
    [sym_include_reader_macro] = STATE(2197),
    [sym_complex_num_lit] = STATE(2197),
    [aux_sym_dis_expr_repeat1] = STATE(156),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2244),
    [sym_comment] = ACTIONS(2244),
    [anon_sym_POUND_] = ACTIONS(1842),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2247),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1847),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2247),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1850),
    [anon_sym_POUND_CARET] = ACTIONS(1853),
    [anon_sym_LPAREN] = ACTIONS(1856),
    [anon_sym_RPAREN] = ACTIONS(1859),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2247),
    [anon_sym_cl] = ACTIONS(1861),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1864),
    [anon_sym_for] = ACTIONS(1864),
    [anon_sym_and] = ACTIONS(1864),
    [anon_sym_as] = ACTIONS(1864),
    [anon_sym_with] = ACTIONS(1864),
    [anon_sym_do] = ACTIONS(1864),
    [anon_sym_while] = ACTIONS(1864),
    [anon_sym_until] = ACTIONS(1864),
    [anon_sym_repeat] = ACTIONS(1864),
    [anon_sym_when] = ACTIONS(1864),
    [anon_sym_if] = ACTIONS(1864),
    [anon_sym_unless] = ACTIONS(1864),
    [anon_sym_always] = ACTIONS(1864),
    [anon_sym_thereis] = ACTIONS(1864),
    [anon_sym_never] = ACTIONS(1864),
    [anon_sym_else] = ACTIONS(1864),
    [anon_sym_finally] = ACTIONS(1864),
    [anon_sym_return] = ACTIONS(1864),
    [anon_sym_initially] = ACTIONS(1864),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2249),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [107] = {
    [sym__gap] = STATE(157),
    [sym_dis_expr] = STATE(157),
    [sym__form] = STATE(2199),
    [sym_num_lit] = STATE(2199),
    [sym_kwd_lit] = STATE(2199),
    [sym_str_lit] = STATE(2199),
    [sym_char_lit] = STATE(2199),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2199),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2199),
    [sym_set_lit] = STATE(2199),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2199),
    [sym_splicing_read_cond_lit] = STATE(2199),
    [sym_var_quoting_lit] = STATE(2199),
    [sym_quoting_lit] = STATE(2199),
    [sym_syn_quoting_lit] = STATE(2199),
    [sym_unquote_splicing_lit] = STATE(2199),
    [sym_unquoting_lit] = STATE(2199),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2199),
    [sym_package_lit] = STATE(2199),
    [sym_include_reader_macro] = STATE(2199),
    [sym_complex_num_lit] = STATE(2199),
    [aux_sym_dis_expr_repeat1] = STATE(157),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2251),
    [sym_comment] = ACTIONS(2251),
    [anon_sym_POUND_] = ACTIONS(1806),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2254),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1811),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2254),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1814),
    [anon_sym_POUND_CARET] = ACTIONS(1817),
    [anon_sym_LPAREN] = ACTIONS(1820),
    [anon_sym_RPAREN] = ACTIONS(1823),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2254),
    [anon_sym_cl] = ACTIONS(1825),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1828),
    [anon_sym_for] = ACTIONS(1828),
    [anon_sym_and] = ACTIONS(1828),
    [anon_sym_as] = ACTIONS(1828),
    [anon_sym_with] = ACTIONS(1828),
    [anon_sym_do] = ACTIONS(1828),
    [anon_sym_while] = ACTIONS(1828),
    [anon_sym_until] = ACTIONS(1828),
    [anon_sym_repeat] = ACTIONS(1828),
    [anon_sym_when] = ACTIONS(1828),
    [anon_sym_if] = ACTIONS(1828),
    [anon_sym_unless] = ACTIONS(1828),
    [anon_sym_always] = ACTIONS(1828),
    [anon_sym_thereis] = ACTIONS(1828),
    [anon_sym_never] = ACTIONS(1828),
    [anon_sym_else] = ACTIONS(1828),
    [anon_sym_finally] = ACTIONS(1828),
    [anon_sym_return] = ACTIONS(1828),
    [anon_sym_initially] = ACTIONS(1828),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2256),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [108] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2218),
    [sym_num_lit] = STATE(2218),
    [sym_kwd_lit] = STATE(2218),
    [sym_str_lit] = STATE(2218),
    [sym_char_lit] = STATE(2218),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2218),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2218),
    [sym_set_lit] = STATE(2218),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2218),
    [sym_splicing_read_cond_lit] = STATE(2218),
    [sym_var_quoting_lit] = STATE(2218),
    [sym_quoting_lit] = STATE(2218),
    [sym_syn_quoting_lit] = STATE(2218),
    [sym_unquote_splicing_lit] = STATE(2218),
    [sym_unquoting_lit] = STATE(2218),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2218),
    [sym_package_lit] = STATE(2218),
    [sym_include_reader_macro] = STATE(2218),
    [sym_complex_num_lit] = STATE(2218),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(1803),
    [sym_comment] = ACTIONS(1803),
    [anon_sym_POUND_] = ACTIONS(1806),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2258),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1811),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2258),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1814),
    [anon_sym_POUND_CARET] = ACTIONS(1817),
    [anon_sym_LPAREN] = ACTIONS(1820),
    [anon_sym_RPAREN] = ACTIONS(1823),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2258),
    [anon_sym_cl] = ACTIONS(1825),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1828),
    [anon_sym_for] = ACTIONS(1828),
    [anon_sym_and] = ACTIONS(1828),
    [anon_sym_as] = ACTIONS(1828),
    [anon_sym_with] = ACTIONS(1828),
    [anon_sym_do] = ACTIONS(1828),
    [anon_sym_while] = ACTIONS(1828),
    [anon_sym_until] = ACTIONS(1828),
    [anon_sym_repeat] = ACTIONS(1828),
    [anon_sym_when] = ACTIONS(1828),
    [anon_sym_if] = ACTIONS(1828),
    [anon_sym_unless] = ACTIONS(1828),
    [anon_sym_always] = ACTIONS(1828),
    [anon_sym_thereis] = ACTIONS(1828),
    [anon_sym_never] = ACTIONS(1828),
    [anon_sym_else] = ACTIONS(1828),
    [anon_sym_finally] = ACTIONS(1828),
    [anon_sym_return] = ACTIONS(1828),
    [anon_sym_initially] = ACTIONS(1828),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2260),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [109] = {
    [sym__gap] = STATE(160),
    [sym_dis_expr] = STATE(160),
    [sym__form] = STATE(2230),
    [sym_num_lit] = STATE(2230),
    [sym_kwd_lit] = STATE(2230),
    [sym_str_lit] = STATE(2230),
    [sym_char_lit] = STATE(2230),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2230),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2230),
    [sym_set_lit] = STATE(2230),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2230),
    [sym_splicing_read_cond_lit] = STATE(2230),
    [sym_var_quoting_lit] = STATE(2230),
    [sym_quoting_lit] = STATE(2230),
    [sym_syn_quoting_lit] = STATE(2230),
    [sym_unquote_splicing_lit] = STATE(2230),
    [sym_unquoting_lit] = STATE(2230),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2230),
    [sym_package_lit] = STATE(2230),
    [sym_include_reader_macro] = STATE(2230),
    [sym_complex_num_lit] = STATE(2230),
    [aux_sym_dis_expr_repeat1] = STATE(160),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2262),
    [sym_comment] = ACTIONS(2262),
    [anon_sym_POUND_] = ACTIONS(1896),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2265),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1901),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2265),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(1904),
    [anon_sym_POUND_CARET] = ACTIONS(1907),
    [anon_sym_LPAREN] = ACTIONS(1910),
    [anon_sym_RPAREN] = ACTIONS(1913),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2265),
    [anon_sym_cl] = ACTIONS(1915),
    [aux_sym_accumulation_verb_token1] = ACTIONS(1918),
    [anon_sym_for] = ACTIONS(1918),
    [anon_sym_and] = ACTIONS(1918),
    [anon_sym_as] = ACTIONS(1918),
    [anon_sym_with] = ACTIONS(1918),
    [anon_sym_do] = ACTIONS(1918),
    [anon_sym_while] = ACTIONS(1918),
    [anon_sym_until] = ACTIONS(1918),
    [anon_sym_repeat] = ACTIONS(1918),
    [anon_sym_when] = ACTIONS(1918),
    [anon_sym_if] = ACTIONS(1918),
    [anon_sym_unless] = ACTIONS(1918),
    [anon_sym_always] = ACTIONS(1918),
    [anon_sym_thereis] = ACTIONS(1918),
    [anon_sym_never] = ACTIONS(1918),
    [anon_sym_else] = ACTIONS(1918),
    [anon_sym_finally] = ACTIONS(1918),
    [anon_sym_return] = ACTIONS(1918),
    [anon_sym_initially] = ACTIONS(1918),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2267),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [110] = {
    [sym__gap] = STATE(58),
    [sym_dis_expr] = STATE(58),
    [sym__form] = STATE(2531),
    [sym_num_lit] = STATE(2531),
    [sym_kwd_lit] = STATE(2531),
    [sym_str_lit] = STATE(2531),
    [sym_char_lit] = STATE(2531),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2531),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2531),
    [sym_set_lit] = STATE(2531),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2531),
    [sym_splicing_read_cond_lit] = STATE(2531),
    [sym_var_quoting_lit] = STATE(2531),
    [sym_quoting_lit] = STATE(2531),
    [sym_syn_quoting_lit] = STATE(2531),
    [sym_unquote_splicing_lit] = STATE(2531),
    [sym_unquoting_lit] = STATE(2531),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2531),
    [sym_package_lit] = STATE(2531),
    [sym_include_reader_macro] = STATE(2531),
    [sym_complex_num_lit] = STATE(2531),
    [aux_sym_dis_expr_repeat1] = STATE(58),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2269),
    [sym_comment] = ACTIONS(2269),
    [anon_sym_POUND_] = ACTIONS(2272),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2275),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2277),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2275),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2280),
    [anon_sym_POUND_CARET] = ACTIONS(2283),
    [anon_sym_LPAREN] = ACTIONS(2286),
    [anon_sym_RPAREN] = ACTIONS(2289),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2275),
    [anon_sym_cl] = ACTIONS(2291),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2294),
    [anon_sym_for] = ACTIONS(2294),
    [anon_sym_and] = ACTIONS(2294),
    [anon_sym_as] = ACTIONS(2294),
    [anon_sym_with] = ACTIONS(2294),
    [anon_sym_do] = ACTIONS(2294),
    [anon_sym_while] = ACTIONS(2294),
    [anon_sym_until] = ACTIONS(2294),
    [anon_sym_repeat] = ACTIONS(2294),
    [anon_sym_when] = ACTIONS(2294),
    [anon_sym_if] = ACTIONS(2294),
    [anon_sym_unless] = ACTIONS(2294),
    [anon_sym_always] = ACTIONS(2294),
    [anon_sym_thereis] = ACTIONS(2294),
    [anon_sym_never] = ACTIONS(2294),
    [anon_sym_else] = ACTIONS(2294),
    [anon_sym_finally] = ACTIONS(2294),
    [anon_sym_return] = ACTIONS(2294),
    [anon_sym_initially] = ACTIONS(2294),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2296),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [111] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2494),
    [sym_num_lit] = STATE(2494),
    [sym_kwd_lit] = STATE(2494),
    [sym_str_lit] = STATE(2494),
    [sym_char_lit] = STATE(2494),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2494),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2494),
    [sym_set_lit] = STATE(2494),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2494),
    [sym_splicing_read_cond_lit] = STATE(2494),
    [sym_var_quoting_lit] = STATE(2494),
    [sym_quoting_lit] = STATE(2494),
    [sym_syn_quoting_lit] = STATE(2494),
    [sym_unquote_splicing_lit] = STATE(2494),
    [sym_unquoting_lit] = STATE(2494),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2494),
    [sym_package_lit] = STATE(2494),
    [sym_include_reader_macro] = STATE(2494),
    [sym_complex_num_lit] = STATE(2494),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2298),
    [sym_comment] = ACTIONS(2298),
    [anon_sym_POUND_] = ACTIONS(2301),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2304),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2306),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2304),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2309),
    [anon_sym_POUND_CARET] = ACTIONS(2312),
    [anon_sym_LPAREN] = ACTIONS(2315),
    [anon_sym_RPAREN] = ACTIONS(2318),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2304),
    [anon_sym_cl] = ACTIONS(2320),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2323),
    [anon_sym_for] = ACTIONS(2323),
    [anon_sym_and] = ACTIONS(2323),
    [anon_sym_as] = ACTIONS(2323),
    [anon_sym_with] = ACTIONS(2323),
    [anon_sym_do] = ACTIONS(2323),
    [anon_sym_while] = ACTIONS(2323),
    [anon_sym_until] = ACTIONS(2323),
    [anon_sym_repeat] = ACTIONS(2323),
    [anon_sym_when] = ACTIONS(2323),
    [anon_sym_if] = ACTIONS(2323),
    [anon_sym_unless] = ACTIONS(2323),
    [anon_sym_always] = ACTIONS(2323),
    [anon_sym_thereis] = ACTIONS(2323),
    [anon_sym_never] = ACTIONS(2323),
    [anon_sym_else] = ACTIONS(2323),
    [anon_sym_finally] = ACTIONS(2323),
    [anon_sym_return] = ACTIONS(2323),
    [anon_sym_initially] = ACTIONS(2323),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2325),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [112] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2496),
    [sym_num_lit] = STATE(2496),
    [sym_kwd_lit] = STATE(2496),
    [sym_str_lit] = STATE(2496),
    [sym_char_lit] = STATE(2496),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2496),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2496),
    [sym_set_lit] = STATE(2496),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2496),
    [sym_splicing_read_cond_lit] = STATE(2496),
    [sym_var_quoting_lit] = STATE(2496),
    [sym_quoting_lit] = STATE(2496),
    [sym_syn_quoting_lit] = STATE(2496),
    [sym_unquote_splicing_lit] = STATE(2496),
    [sym_unquoting_lit] = STATE(2496),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2496),
    [sym_package_lit] = STATE(2496),
    [sym_include_reader_macro] = STATE(2496),
    [sym_complex_num_lit] = STATE(2496),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2327),
    [sym_comment] = ACTIONS(2327),
    [anon_sym_POUND_] = ACTIONS(2330),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2333),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2335),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2333),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2338),
    [anon_sym_POUND_CARET] = ACTIONS(2341),
    [anon_sym_LPAREN] = ACTIONS(2344),
    [anon_sym_RPAREN] = ACTIONS(2347),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2333),
    [anon_sym_cl] = ACTIONS(2349),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2352),
    [anon_sym_for] = ACTIONS(2352),
    [anon_sym_and] = ACTIONS(2352),
    [anon_sym_as] = ACTIONS(2352),
    [anon_sym_with] = ACTIONS(2352),
    [anon_sym_do] = ACTIONS(2352),
    [anon_sym_while] = ACTIONS(2352),
    [anon_sym_until] = ACTIONS(2352),
    [anon_sym_repeat] = ACTIONS(2352),
    [anon_sym_when] = ACTIONS(2352),
    [anon_sym_if] = ACTIONS(2352),
    [anon_sym_unless] = ACTIONS(2352),
    [anon_sym_always] = ACTIONS(2352),
    [anon_sym_thereis] = ACTIONS(2352),
    [anon_sym_never] = ACTIONS(2352),
    [anon_sym_else] = ACTIONS(2352),
    [anon_sym_finally] = ACTIONS(2352),
    [anon_sym_return] = ACTIONS(2352),
    [anon_sym_initially] = ACTIONS(2352),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2354),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [113] = {
    [sym__gap] = STATE(162),
    [sym_dis_expr] = STATE(162),
    [sym__form] = STATE(2497),
    [sym_num_lit] = STATE(2497),
    [sym_kwd_lit] = STATE(2497),
    [sym_str_lit] = STATE(2497),
    [sym_char_lit] = STATE(2497),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2497),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2497),
    [sym_set_lit] = STATE(2497),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2497),
    [sym_splicing_read_cond_lit] = STATE(2497),
    [sym_var_quoting_lit] = STATE(2497),
    [sym_quoting_lit] = STATE(2497),
    [sym_syn_quoting_lit] = STATE(2497),
    [sym_unquote_splicing_lit] = STATE(2497),
    [sym_unquoting_lit] = STATE(2497),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2497),
    [sym_package_lit] = STATE(2497),
    [sym_include_reader_macro] = STATE(2497),
    [sym_complex_num_lit] = STATE(2497),
    [aux_sym_dis_expr_repeat1] = STATE(162),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2356),
    [sym_comment] = ACTIONS(2356),
    [anon_sym_POUND_] = ACTIONS(2330),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2359),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2335),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2359),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2338),
    [anon_sym_POUND_CARET] = ACTIONS(2341),
    [anon_sym_LPAREN] = ACTIONS(2344),
    [anon_sym_RPAREN] = ACTIONS(2347),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2359),
    [anon_sym_cl] = ACTIONS(2349),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2352),
    [anon_sym_for] = ACTIONS(2352),
    [anon_sym_and] = ACTIONS(2352),
    [anon_sym_as] = ACTIONS(2352),
    [anon_sym_with] = ACTIONS(2352),
    [anon_sym_do] = ACTIONS(2352),
    [anon_sym_while] = ACTIONS(2352),
    [anon_sym_until] = ACTIONS(2352),
    [anon_sym_repeat] = ACTIONS(2352),
    [anon_sym_when] = ACTIONS(2352),
    [anon_sym_if] = ACTIONS(2352),
    [anon_sym_unless] = ACTIONS(2352),
    [anon_sym_always] = ACTIONS(2352),
    [anon_sym_thereis] = ACTIONS(2352),
    [anon_sym_never] = ACTIONS(2352),
    [anon_sym_else] = ACTIONS(2352),
    [anon_sym_finally] = ACTIONS(2352),
    [anon_sym_return] = ACTIONS(2352),
    [anon_sym_initially] = ACTIONS(2352),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2361),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [114] = {
    [sym__gap] = STATE(163),
    [sym_dis_expr] = STATE(163),
    [sym__form] = STATE(2499),
    [sym_num_lit] = STATE(2499),
    [sym_kwd_lit] = STATE(2499),
    [sym_str_lit] = STATE(2499),
    [sym_char_lit] = STATE(2499),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2499),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2499),
    [sym_set_lit] = STATE(2499),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2499),
    [sym_splicing_read_cond_lit] = STATE(2499),
    [sym_var_quoting_lit] = STATE(2499),
    [sym_quoting_lit] = STATE(2499),
    [sym_syn_quoting_lit] = STATE(2499),
    [sym_unquote_splicing_lit] = STATE(2499),
    [sym_unquoting_lit] = STATE(2499),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2499),
    [sym_package_lit] = STATE(2499),
    [sym_include_reader_macro] = STATE(2499),
    [sym_complex_num_lit] = STATE(2499),
    [aux_sym_dis_expr_repeat1] = STATE(163),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2363),
    [sym_comment] = ACTIONS(2363),
    [anon_sym_POUND_] = ACTIONS(2330),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2366),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2335),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2366),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2338),
    [anon_sym_POUND_CARET] = ACTIONS(2341),
    [anon_sym_LPAREN] = ACTIONS(2344),
    [anon_sym_RPAREN] = ACTIONS(2347),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2366),
    [anon_sym_cl] = ACTIONS(2349),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2352),
    [anon_sym_for] = ACTIONS(2352),
    [anon_sym_and] = ACTIONS(2352),
    [anon_sym_as] = ACTIONS(2352),
    [anon_sym_with] = ACTIONS(2352),
    [anon_sym_do] = ACTIONS(2352),
    [anon_sym_while] = ACTIONS(2352),
    [anon_sym_until] = ACTIONS(2352),
    [anon_sym_repeat] = ACTIONS(2352),
    [anon_sym_when] = ACTIONS(2352),
    [anon_sym_if] = ACTIONS(2352),
    [anon_sym_unless] = ACTIONS(2352),
    [anon_sym_always] = ACTIONS(2352),
    [anon_sym_thereis] = ACTIONS(2352),
    [anon_sym_never] = ACTIONS(2352),
    [anon_sym_else] = ACTIONS(2352),
    [anon_sym_finally] = ACTIONS(2352),
    [anon_sym_return] = ACTIONS(2352),
    [anon_sym_initially] = ACTIONS(2352),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2368),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [115] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2502),
    [sym_num_lit] = STATE(2502),
    [sym_kwd_lit] = STATE(2502),
    [sym_str_lit] = STATE(2502),
    [sym_char_lit] = STATE(2502),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2502),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2502),
    [sym_set_lit] = STATE(2502),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2502),
    [sym_splicing_read_cond_lit] = STATE(2502),
    [sym_var_quoting_lit] = STATE(2502),
    [sym_quoting_lit] = STATE(2502),
    [sym_syn_quoting_lit] = STATE(2502),
    [sym_unquote_splicing_lit] = STATE(2502),
    [sym_unquoting_lit] = STATE(2502),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2502),
    [sym_package_lit] = STATE(2502),
    [sym_include_reader_macro] = STATE(2502),
    [sym_complex_num_lit] = STATE(2502),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2327),
    [sym_comment] = ACTIONS(2327),
    [anon_sym_POUND_] = ACTIONS(2330),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2370),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2335),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2370),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2338),
    [anon_sym_POUND_CARET] = ACTIONS(2341),
    [anon_sym_LPAREN] = ACTIONS(2344),
    [anon_sym_RPAREN] = ACTIONS(2347),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2370),
    [anon_sym_cl] = ACTIONS(2349),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2352),
    [anon_sym_for] = ACTIONS(2352),
    [anon_sym_and] = ACTIONS(2352),
    [anon_sym_as] = ACTIONS(2352),
    [anon_sym_with] = ACTIONS(2352),
    [anon_sym_do] = ACTIONS(2352),
    [anon_sym_while] = ACTIONS(2352),
    [anon_sym_until] = ACTIONS(2352),
    [anon_sym_repeat] = ACTIONS(2352),
    [anon_sym_when] = ACTIONS(2352),
    [anon_sym_if] = ACTIONS(2352),
    [anon_sym_unless] = ACTIONS(2352),
    [anon_sym_always] = ACTIONS(2352),
    [anon_sym_thereis] = ACTIONS(2352),
    [anon_sym_never] = ACTIONS(2352),
    [anon_sym_else] = ACTIONS(2352),
    [anon_sym_finally] = ACTIONS(2352),
    [anon_sym_return] = ACTIONS(2352),
    [anon_sym_initially] = ACTIONS(2352),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2372),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [116] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2504),
    [sym_num_lit] = STATE(2504),
    [sym_kwd_lit] = STATE(2504),
    [sym_str_lit] = STATE(2504),
    [sym_char_lit] = STATE(2504),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2504),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2504),
    [sym_set_lit] = STATE(2504),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2504),
    [sym_splicing_read_cond_lit] = STATE(2504),
    [sym_var_quoting_lit] = STATE(2504),
    [sym_quoting_lit] = STATE(2504),
    [sym_syn_quoting_lit] = STATE(2504),
    [sym_unquote_splicing_lit] = STATE(2504),
    [sym_unquoting_lit] = STATE(2504),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2504),
    [sym_package_lit] = STATE(2504),
    [sym_include_reader_macro] = STATE(2504),
    [sym_complex_num_lit] = STATE(2504),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2298),
    [sym_comment] = ACTIONS(2298),
    [anon_sym_POUND_] = ACTIONS(2301),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2374),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2306),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2374),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2309),
    [anon_sym_POUND_CARET] = ACTIONS(2312),
    [anon_sym_LPAREN] = ACTIONS(2315),
    [anon_sym_RPAREN] = ACTIONS(2318),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2374),
    [anon_sym_cl] = ACTIONS(2320),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2323),
    [anon_sym_for] = ACTIONS(2323),
    [anon_sym_and] = ACTIONS(2323),
    [anon_sym_as] = ACTIONS(2323),
    [anon_sym_with] = ACTIONS(2323),
    [anon_sym_do] = ACTIONS(2323),
    [anon_sym_while] = ACTIONS(2323),
    [anon_sym_until] = ACTIONS(2323),
    [anon_sym_repeat] = ACTIONS(2323),
    [anon_sym_when] = ACTIONS(2323),
    [anon_sym_if] = ACTIONS(2323),
    [anon_sym_unless] = ACTIONS(2323),
    [anon_sym_always] = ACTIONS(2323),
    [anon_sym_thereis] = ACTIONS(2323),
    [anon_sym_never] = ACTIONS(2323),
    [anon_sym_else] = ACTIONS(2323),
    [anon_sym_finally] = ACTIONS(2323),
    [anon_sym_return] = ACTIONS(2323),
    [anon_sym_initially] = ACTIONS(2323),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2376),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [117] = {
    [sym__gap] = STATE(269),
    [sym_dis_expr] = STATE(269),
    [sym__form] = STATE(2505),
    [sym_num_lit] = STATE(2505),
    [sym_kwd_lit] = STATE(2505),
    [sym_str_lit] = STATE(2505),
    [sym_char_lit] = STATE(2505),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2505),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2505),
    [sym_set_lit] = STATE(2505),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2505),
    [sym_splicing_read_cond_lit] = STATE(2505),
    [sym_var_quoting_lit] = STATE(2505),
    [sym_quoting_lit] = STATE(2505),
    [sym_syn_quoting_lit] = STATE(2505),
    [sym_unquote_splicing_lit] = STATE(2505),
    [sym_unquoting_lit] = STATE(2505),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2505),
    [sym_package_lit] = STATE(2505),
    [sym_include_reader_macro] = STATE(2505),
    [sym_complex_num_lit] = STATE(2505),
    [aux_sym_dis_expr_repeat1] = STATE(269),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2378),
    [sym_comment] = ACTIONS(2378),
    [anon_sym_POUND_] = ACTIONS(2301),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2381),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2306),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2381),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2309),
    [anon_sym_POUND_CARET] = ACTIONS(2312),
    [anon_sym_LPAREN] = ACTIONS(2315),
    [anon_sym_RPAREN] = ACTIONS(2318),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2381),
    [anon_sym_cl] = ACTIONS(2320),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2323),
    [anon_sym_for] = ACTIONS(2323),
    [anon_sym_and] = ACTIONS(2323),
    [anon_sym_as] = ACTIONS(2323),
    [anon_sym_with] = ACTIONS(2323),
    [anon_sym_do] = ACTIONS(2323),
    [anon_sym_while] = ACTIONS(2323),
    [anon_sym_until] = ACTIONS(2323),
    [anon_sym_repeat] = ACTIONS(2323),
    [anon_sym_when] = ACTIONS(2323),
    [anon_sym_if] = ACTIONS(2323),
    [anon_sym_unless] = ACTIONS(2323),
    [anon_sym_always] = ACTIONS(2323),
    [anon_sym_thereis] = ACTIONS(2323),
    [anon_sym_never] = ACTIONS(2323),
    [anon_sym_else] = ACTIONS(2323),
    [anon_sym_finally] = ACTIONS(2323),
    [anon_sym_return] = ACTIONS(2323),
    [anon_sym_initially] = ACTIONS(2323),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2383),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [118] = {
    [sym__gap] = STATE(165),
    [sym_dis_expr] = STATE(165),
    [sym__form] = STATE(2508),
    [sym_num_lit] = STATE(2508),
    [sym_kwd_lit] = STATE(2508),
    [sym_str_lit] = STATE(2508),
    [sym_char_lit] = STATE(2508),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2508),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2508),
    [sym_set_lit] = STATE(2508),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2508),
    [sym_splicing_read_cond_lit] = STATE(2508),
    [sym_var_quoting_lit] = STATE(2508),
    [sym_quoting_lit] = STATE(2508),
    [sym_syn_quoting_lit] = STATE(2508),
    [sym_unquote_splicing_lit] = STATE(2508),
    [sym_unquoting_lit] = STATE(2508),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2508),
    [sym_package_lit] = STATE(2508),
    [sym_include_reader_macro] = STATE(2508),
    [sym_complex_num_lit] = STATE(2508),
    [aux_sym_dis_expr_repeat1] = STATE(165),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2385),
    [sym_comment] = ACTIONS(2385),
    [anon_sym_POUND_] = ACTIONS(2388),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2391),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2393),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2391),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2396),
    [anon_sym_POUND_CARET] = ACTIONS(2399),
    [anon_sym_LPAREN] = ACTIONS(2402),
    [anon_sym_RPAREN] = ACTIONS(2405),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2391),
    [anon_sym_cl] = ACTIONS(2407),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2410),
    [anon_sym_for] = ACTIONS(2410),
    [anon_sym_and] = ACTIONS(2410),
    [anon_sym_as] = ACTIONS(2410),
    [anon_sym_with] = ACTIONS(2410),
    [anon_sym_do] = ACTIONS(2410),
    [anon_sym_while] = ACTIONS(2410),
    [anon_sym_until] = ACTIONS(2410),
    [anon_sym_repeat] = ACTIONS(2410),
    [anon_sym_when] = ACTIONS(2410),
    [anon_sym_if] = ACTIONS(2410),
    [anon_sym_unless] = ACTIONS(2410),
    [anon_sym_always] = ACTIONS(2410),
    [anon_sym_thereis] = ACTIONS(2410),
    [anon_sym_never] = ACTIONS(2410),
    [anon_sym_else] = ACTIONS(2410),
    [anon_sym_finally] = ACTIONS(2410),
    [anon_sym_return] = ACTIONS(2410),
    [anon_sym_initially] = ACTIONS(2410),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2412),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [119] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2510),
    [sym_num_lit] = STATE(2510),
    [sym_kwd_lit] = STATE(2510),
    [sym_str_lit] = STATE(2510),
    [sym_char_lit] = STATE(2510),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2510),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2510),
    [sym_set_lit] = STATE(2510),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2510),
    [sym_splicing_read_cond_lit] = STATE(2510),
    [sym_var_quoting_lit] = STATE(2510),
    [sym_quoting_lit] = STATE(2510),
    [sym_syn_quoting_lit] = STATE(2510),
    [sym_unquote_splicing_lit] = STATE(2510),
    [sym_unquoting_lit] = STATE(2510),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2510),
    [sym_package_lit] = STATE(2510),
    [sym_include_reader_macro] = STATE(2510),
    [sym_complex_num_lit] = STATE(2510),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2414),
    [sym_comment] = ACTIONS(2414),
    [anon_sym_POUND_] = ACTIONS(2388),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2417),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2393),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2417),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2396),
    [anon_sym_POUND_CARET] = ACTIONS(2399),
    [anon_sym_LPAREN] = ACTIONS(2402),
    [anon_sym_RPAREN] = ACTIONS(2405),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2417),
    [anon_sym_cl] = ACTIONS(2407),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2410),
    [anon_sym_for] = ACTIONS(2410),
    [anon_sym_and] = ACTIONS(2410),
    [anon_sym_as] = ACTIONS(2410),
    [anon_sym_with] = ACTIONS(2410),
    [anon_sym_do] = ACTIONS(2410),
    [anon_sym_while] = ACTIONS(2410),
    [anon_sym_until] = ACTIONS(2410),
    [anon_sym_repeat] = ACTIONS(2410),
    [anon_sym_when] = ACTIONS(2410),
    [anon_sym_if] = ACTIONS(2410),
    [anon_sym_unless] = ACTIONS(2410),
    [anon_sym_always] = ACTIONS(2410),
    [anon_sym_thereis] = ACTIONS(2410),
    [anon_sym_never] = ACTIONS(2410),
    [anon_sym_else] = ACTIONS(2410),
    [anon_sym_finally] = ACTIONS(2410),
    [anon_sym_return] = ACTIONS(2410),
    [anon_sym_initially] = ACTIONS(2410),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2419),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [120] = {
    [sym__gap] = STATE(168),
    [sym_dis_expr] = STATE(168),
    [sym__form] = STATE(2512),
    [sym_num_lit] = STATE(2512),
    [sym_kwd_lit] = STATE(2512),
    [sym_str_lit] = STATE(2512),
    [sym_char_lit] = STATE(2512),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2512),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2512),
    [sym_set_lit] = STATE(2512),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2512),
    [sym_splicing_read_cond_lit] = STATE(2512),
    [sym_var_quoting_lit] = STATE(2512),
    [sym_quoting_lit] = STATE(2512),
    [sym_syn_quoting_lit] = STATE(2512),
    [sym_unquote_splicing_lit] = STATE(2512),
    [sym_unquoting_lit] = STATE(2512),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2512),
    [sym_package_lit] = STATE(2512),
    [sym_include_reader_macro] = STATE(2512),
    [sym_complex_num_lit] = STATE(2512),
    [aux_sym_dis_expr_repeat1] = STATE(168),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2421),
    [sym_comment] = ACTIONS(2421),
    [anon_sym_POUND_] = ACTIONS(2388),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2424),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2393),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2424),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2396),
    [anon_sym_POUND_CARET] = ACTIONS(2399),
    [anon_sym_LPAREN] = ACTIONS(2402),
    [anon_sym_RPAREN] = ACTIONS(2405),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2424),
    [anon_sym_cl] = ACTIONS(2407),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2410),
    [anon_sym_for] = ACTIONS(2410),
    [anon_sym_and] = ACTIONS(2410),
    [anon_sym_as] = ACTIONS(2410),
    [anon_sym_with] = ACTIONS(2410),
    [anon_sym_do] = ACTIONS(2410),
    [anon_sym_while] = ACTIONS(2410),
    [anon_sym_until] = ACTIONS(2410),
    [anon_sym_repeat] = ACTIONS(2410),
    [anon_sym_when] = ACTIONS(2410),
    [anon_sym_if] = ACTIONS(2410),
    [anon_sym_unless] = ACTIONS(2410),
    [anon_sym_always] = ACTIONS(2410),
    [anon_sym_thereis] = ACTIONS(2410),
    [anon_sym_never] = ACTIONS(2410),
    [anon_sym_else] = ACTIONS(2410),
    [anon_sym_finally] = ACTIONS(2410),
    [anon_sym_return] = ACTIONS(2410),
    [anon_sym_initially] = ACTIONS(2410),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2426),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [121] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2516),
    [sym_num_lit] = STATE(2516),
    [sym_kwd_lit] = STATE(2516),
    [sym_str_lit] = STATE(2516),
    [sym_char_lit] = STATE(2516),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2516),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2516),
    [sym_set_lit] = STATE(2516),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2516),
    [sym_splicing_read_cond_lit] = STATE(2516),
    [sym_var_quoting_lit] = STATE(2516),
    [sym_quoting_lit] = STATE(2516),
    [sym_syn_quoting_lit] = STATE(2516),
    [sym_unquote_splicing_lit] = STATE(2516),
    [sym_unquoting_lit] = STATE(2516),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2516),
    [sym_package_lit] = STATE(2516),
    [sym_include_reader_macro] = STATE(2516),
    [sym_complex_num_lit] = STATE(2516),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2428),
    [sym_comment] = ACTIONS(2428),
    [anon_sym_POUND_] = ACTIONS(2431),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2434),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2436),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2434),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2439),
    [anon_sym_POUND_CARET] = ACTIONS(2442),
    [anon_sym_LPAREN] = ACTIONS(2445),
    [anon_sym_RPAREN] = ACTIONS(2448),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2434),
    [anon_sym_cl] = ACTIONS(2450),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2453),
    [anon_sym_for] = ACTIONS(2453),
    [anon_sym_and] = ACTIONS(2453),
    [anon_sym_as] = ACTIONS(2453),
    [anon_sym_with] = ACTIONS(2453),
    [anon_sym_do] = ACTIONS(2453),
    [anon_sym_while] = ACTIONS(2453),
    [anon_sym_until] = ACTIONS(2453),
    [anon_sym_repeat] = ACTIONS(2453),
    [anon_sym_when] = ACTIONS(2453),
    [anon_sym_if] = ACTIONS(2453),
    [anon_sym_unless] = ACTIONS(2453),
    [anon_sym_always] = ACTIONS(2453),
    [anon_sym_thereis] = ACTIONS(2453),
    [anon_sym_never] = ACTIONS(2453),
    [anon_sym_else] = ACTIONS(2453),
    [anon_sym_finally] = ACTIONS(2453),
    [anon_sym_return] = ACTIONS(2453),
    [anon_sym_initially] = ACTIONS(2453),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2455),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [122] = {
    [sym__gap] = STATE(169),
    [sym_dis_expr] = STATE(169),
    [sym__form] = STATE(2517),
    [sym_num_lit] = STATE(2517),
    [sym_kwd_lit] = STATE(2517),
    [sym_str_lit] = STATE(2517),
    [sym_char_lit] = STATE(2517),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2517),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2517),
    [sym_set_lit] = STATE(2517),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2517),
    [sym_splicing_read_cond_lit] = STATE(2517),
    [sym_var_quoting_lit] = STATE(2517),
    [sym_quoting_lit] = STATE(2517),
    [sym_syn_quoting_lit] = STATE(2517),
    [sym_unquote_splicing_lit] = STATE(2517),
    [sym_unquoting_lit] = STATE(2517),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2517),
    [sym_package_lit] = STATE(2517),
    [sym_include_reader_macro] = STATE(2517),
    [sym_complex_num_lit] = STATE(2517),
    [aux_sym_dis_expr_repeat1] = STATE(169),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2457),
    [sym_comment] = ACTIONS(2457),
    [anon_sym_POUND_] = ACTIONS(2431),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2460),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2436),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2460),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2439),
    [anon_sym_POUND_CARET] = ACTIONS(2442),
    [anon_sym_LPAREN] = ACTIONS(2445),
    [anon_sym_RPAREN] = ACTIONS(2448),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2460),
    [anon_sym_cl] = ACTIONS(2450),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2453),
    [anon_sym_for] = ACTIONS(2453),
    [anon_sym_and] = ACTIONS(2453),
    [anon_sym_as] = ACTIONS(2453),
    [anon_sym_with] = ACTIONS(2453),
    [anon_sym_do] = ACTIONS(2453),
    [anon_sym_while] = ACTIONS(2453),
    [anon_sym_until] = ACTIONS(2453),
    [anon_sym_repeat] = ACTIONS(2453),
    [anon_sym_when] = ACTIONS(2453),
    [anon_sym_if] = ACTIONS(2453),
    [anon_sym_unless] = ACTIONS(2453),
    [anon_sym_always] = ACTIONS(2453),
    [anon_sym_thereis] = ACTIONS(2453),
    [anon_sym_never] = ACTIONS(2453),
    [anon_sym_else] = ACTIONS(2453),
    [anon_sym_finally] = ACTIONS(2453),
    [anon_sym_return] = ACTIONS(2453),
    [anon_sym_initially] = ACTIONS(2453),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2462),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [123] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(2521),
    [sym_num_lit] = STATE(2521),
    [sym_kwd_lit] = STATE(2521),
    [sym_str_lit] = STATE(2521),
    [sym_char_lit] = STATE(2521),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2521),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2521),
    [sym_set_lit] = STATE(2521),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2521),
    [sym_splicing_read_cond_lit] = STATE(2521),
    [sym_var_quoting_lit] = STATE(2521),
    [sym_quoting_lit] = STATE(2521),
    [sym_syn_quoting_lit] = STATE(2521),
    [sym_unquote_splicing_lit] = STATE(2521),
    [sym_unquoting_lit] = STATE(2521),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2521),
    [sym_package_lit] = STATE(2521),
    [sym_include_reader_macro] = STATE(2521),
    [sym_complex_num_lit] = STATE(2521),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2464),
    [sym_comment] = ACTIONS(2464),
    [anon_sym_POUND_] = ACTIONS(2467),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2470),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2472),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2470),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2475),
    [anon_sym_POUND_CARET] = ACTIONS(2478),
    [anon_sym_LPAREN] = ACTIONS(2481),
    [anon_sym_RPAREN] = ACTIONS(2484),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2470),
    [anon_sym_cl] = ACTIONS(2486),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2489),
    [anon_sym_for] = ACTIONS(2489),
    [anon_sym_and] = ACTIONS(2489),
    [anon_sym_as] = ACTIONS(2489),
    [anon_sym_with] = ACTIONS(2489),
    [anon_sym_do] = ACTIONS(2489),
    [anon_sym_while] = ACTIONS(2489),
    [anon_sym_until] = ACTIONS(2489),
    [anon_sym_repeat] = ACTIONS(2489),
    [anon_sym_when] = ACTIONS(2489),
    [anon_sym_if] = ACTIONS(2489),
    [anon_sym_unless] = ACTIONS(2489),
    [anon_sym_always] = ACTIONS(2489),
    [anon_sym_thereis] = ACTIONS(2489),
    [anon_sym_never] = ACTIONS(2489),
    [anon_sym_else] = ACTIONS(2489),
    [anon_sym_finally] = ACTIONS(2489),
    [anon_sym_return] = ACTIONS(2489),
    [anon_sym_initially] = ACTIONS(2489),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2491),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [124] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2525),
    [sym_num_lit] = STATE(2525),
    [sym_kwd_lit] = STATE(2525),
    [sym_str_lit] = STATE(2525),
    [sym_char_lit] = STATE(2525),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2525),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2525),
    [sym_set_lit] = STATE(2525),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2525),
    [sym_splicing_read_cond_lit] = STATE(2525),
    [sym_var_quoting_lit] = STATE(2525),
    [sym_quoting_lit] = STATE(2525),
    [sym_syn_quoting_lit] = STATE(2525),
    [sym_unquote_splicing_lit] = STATE(2525),
    [sym_unquoting_lit] = STATE(2525),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2525),
    [sym_package_lit] = STATE(2525),
    [sym_include_reader_macro] = STATE(2525),
    [sym_complex_num_lit] = STATE(2525),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2493),
    [sym_comment] = ACTIONS(2493),
    [anon_sym_POUND_] = ACTIONS(2467),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2496),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2472),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2496),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2475),
    [anon_sym_POUND_CARET] = ACTIONS(2478),
    [anon_sym_LPAREN] = ACTIONS(2481),
    [anon_sym_RPAREN] = ACTIONS(2484),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2496),
    [anon_sym_cl] = ACTIONS(2486),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2489),
    [anon_sym_for] = ACTIONS(2489),
    [anon_sym_and] = ACTIONS(2489),
    [anon_sym_as] = ACTIONS(2489),
    [anon_sym_with] = ACTIONS(2489),
    [anon_sym_do] = ACTIONS(2489),
    [anon_sym_while] = ACTIONS(2489),
    [anon_sym_until] = ACTIONS(2489),
    [anon_sym_repeat] = ACTIONS(2489),
    [anon_sym_when] = ACTIONS(2489),
    [anon_sym_if] = ACTIONS(2489),
    [anon_sym_unless] = ACTIONS(2489),
    [anon_sym_always] = ACTIONS(2489),
    [anon_sym_thereis] = ACTIONS(2489),
    [anon_sym_never] = ACTIONS(2489),
    [anon_sym_else] = ACTIONS(2489),
    [anon_sym_finally] = ACTIONS(2489),
    [anon_sym_return] = ACTIONS(2489),
    [anon_sym_initially] = ACTIONS(2489),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2498),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [125] = {
    [sym__gap] = STATE(173),
    [sym_dis_expr] = STATE(173),
    [sym__form] = STATE(2528),
    [sym_num_lit] = STATE(2528),
    [sym_kwd_lit] = STATE(2528),
    [sym_str_lit] = STATE(2528),
    [sym_char_lit] = STATE(2528),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2528),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2528),
    [sym_set_lit] = STATE(2528),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2528),
    [sym_splicing_read_cond_lit] = STATE(2528),
    [sym_var_quoting_lit] = STATE(2528),
    [sym_quoting_lit] = STATE(2528),
    [sym_syn_quoting_lit] = STATE(2528),
    [sym_unquote_splicing_lit] = STATE(2528),
    [sym_unquoting_lit] = STATE(2528),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2528),
    [sym_package_lit] = STATE(2528),
    [sym_include_reader_macro] = STATE(2528),
    [sym_complex_num_lit] = STATE(2528),
    [aux_sym_dis_expr_repeat1] = STATE(173),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2500),
    [sym_comment] = ACTIONS(2500),
    [anon_sym_POUND_] = ACTIONS(2467),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2503),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2472),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2503),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2475),
    [anon_sym_POUND_CARET] = ACTIONS(2478),
    [anon_sym_LPAREN] = ACTIONS(2481),
    [anon_sym_RPAREN] = ACTIONS(2484),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2503),
    [anon_sym_cl] = ACTIONS(2486),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2489),
    [anon_sym_for] = ACTIONS(2489),
    [anon_sym_and] = ACTIONS(2489),
    [anon_sym_as] = ACTIONS(2489),
    [anon_sym_with] = ACTIONS(2489),
    [anon_sym_do] = ACTIONS(2489),
    [anon_sym_while] = ACTIONS(2489),
    [anon_sym_until] = ACTIONS(2489),
    [anon_sym_repeat] = ACTIONS(2489),
    [anon_sym_when] = ACTIONS(2489),
    [anon_sym_if] = ACTIONS(2489),
    [anon_sym_unless] = ACTIONS(2489),
    [anon_sym_always] = ACTIONS(2489),
    [anon_sym_thereis] = ACTIONS(2489),
    [anon_sym_never] = ACTIONS(2489),
    [anon_sym_else] = ACTIONS(2489),
    [anon_sym_finally] = ACTIONS(2489),
    [anon_sym_return] = ACTIONS(2489),
    [anon_sym_initially] = ACTIONS(2489),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2505),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [126] = {
    [sym__gap] = STATE(174),
    [sym_dis_expr] = STATE(174),
    [sym__form] = STATE(2535),
    [sym_num_lit] = STATE(2535),
    [sym_kwd_lit] = STATE(2535),
    [sym_str_lit] = STATE(2535),
    [sym_char_lit] = STATE(2535),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2535),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2535),
    [sym_set_lit] = STATE(2535),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2535),
    [sym_splicing_read_cond_lit] = STATE(2535),
    [sym_var_quoting_lit] = STATE(2535),
    [sym_quoting_lit] = STATE(2535),
    [sym_syn_quoting_lit] = STATE(2535),
    [sym_unquote_splicing_lit] = STATE(2535),
    [sym_unquoting_lit] = STATE(2535),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2535),
    [sym_package_lit] = STATE(2535),
    [sym_include_reader_macro] = STATE(2535),
    [sym_complex_num_lit] = STATE(2535),
    [aux_sym_dis_expr_repeat1] = STATE(174),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2507),
    [sym_comment] = ACTIONS(2507),
    [anon_sym_POUND_] = ACTIONS(2431),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2510),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2436),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2510),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2439),
    [anon_sym_POUND_CARET] = ACTIONS(2442),
    [anon_sym_LPAREN] = ACTIONS(2445),
    [anon_sym_RPAREN] = ACTIONS(2448),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2510),
    [anon_sym_cl] = ACTIONS(2450),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2453),
    [anon_sym_for] = ACTIONS(2453),
    [anon_sym_and] = ACTIONS(2453),
    [anon_sym_as] = ACTIONS(2453),
    [anon_sym_with] = ACTIONS(2453),
    [anon_sym_do] = ACTIONS(2453),
    [anon_sym_while] = ACTIONS(2453),
    [anon_sym_until] = ACTIONS(2453),
    [anon_sym_repeat] = ACTIONS(2453),
    [anon_sym_when] = ACTIONS(2453),
    [anon_sym_if] = ACTIONS(2453),
    [anon_sym_unless] = ACTIONS(2453),
    [anon_sym_always] = ACTIONS(2453),
    [anon_sym_thereis] = ACTIONS(2453),
    [anon_sym_never] = ACTIONS(2453),
    [anon_sym_else] = ACTIONS(2453),
    [anon_sym_finally] = ACTIONS(2453),
    [anon_sym_return] = ACTIONS(2453),
    [anon_sym_initially] = ACTIONS(2453),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2512),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [127] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2540),
    [sym_num_lit] = STATE(2540),
    [sym_kwd_lit] = STATE(2540),
    [sym_str_lit] = STATE(2540),
    [sym_char_lit] = STATE(2540),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2540),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2540),
    [sym_set_lit] = STATE(2540),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2540),
    [sym_splicing_read_cond_lit] = STATE(2540),
    [sym_var_quoting_lit] = STATE(2540),
    [sym_quoting_lit] = STATE(2540),
    [sym_syn_quoting_lit] = STATE(2540),
    [sym_unquote_splicing_lit] = STATE(2540),
    [sym_unquoting_lit] = STATE(2540),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2540),
    [sym_package_lit] = STATE(2540),
    [sym_include_reader_macro] = STATE(2540),
    [sym_complex_num_lit] = STATE(2540),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2428),
    [sym_comment] = ACTIONS(2428),
    [anon_sym_POUND_] = ACTIONS(2431),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2514),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2436),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2514),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2439),
    [anon_sym_POUND_CARET] = ACTIONS(2442),
    [anon_sym_LPAREN] = ACTIONS(2445),
    [anon_sym_RPAREN] = ACTIONS(2448),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2514),
    [anon_sym_cl] = ACTIONS(2450),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2453),
    [anon_sym_for] = ACTIONS(2453),
    [anon_sym_and] = ACTIONS(2453),
    [anon_sym_as] = ACTIONS(2453),
    [anon_sym_with] = ACTIONS(2453),
    [anon_sym_do] = ACTIONS(2453),
    [anon_sym_while] = ACTIONS(2453),
    [anon_sym_until] = ACTIONS(2453),
    [anon_sym_repeat] = ACTIONS(2453),
    [anon_sym_when] = ACTIONS(2453),
    [anon_sym_if] = ACTIONS(2453),
    [anon_sym_unless] = ACTIONS(2453),
    [anon_sym_always] = ACTIONS(2453),
    [anon_sym_thereis] = ACTIONS(2453),
    [anon_sym_never] = ACTIONS(2453),
    [anon_sym_else] = ACTIONS(2453),
    [anon_sym_finally] = ACTIONS(2453),
    [anon_sym_return] = ACTIONS(2453),
    [anon_sym_initially] = ACTIONS(2453),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2516),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [128] = {
    [sym__gap] = STATE(177),
    [sym_dis_expr] = STATE(177),
    [sym__form] = STATE(2542),
    [sym_num_lit] = STATE(2542),
    [sym_kwd_lit] = STATE(2542),
    [sym_str_lit] = STATE(2542),
    [sym_char_lit] = STATE(2542),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2542),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2542),
    [sym_set_lit] = STATE(2542),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2542),
    [sym_splicing_read_cond_lit] = STATE(2542),
    [sym_var_quoting_lit] = STATE(2542),
    [sym_quoting_lit] = STATE(2542),
    [sym_syn_quoting_lit] = STATE(2542),
    [sym_unquote_splicing_lit] = STATE(2542),
    [sym_unquoting_lit] = STATE(2542),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2542),
    [sym_package_lit] = STATE(2542),
    [sym_include_reader_macro] = STATE(2542),
    [sym_complex_num_lit] = STATE(2542),
    [aux_sym_dis_expr_repeat1] = STATE(177),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2518),
    [sym_comment] = ACTIONS(2518),
    [anon_sym_POUND_] = ACTIONS(2521),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2524),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2526),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2524),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2529),
    [anon_sym_POUND_CARET] = ACTIONS(2532),
    [anon_sym_LPAREN] = ACTIONS(2535),
    [anon_sym_RPAREN] = ACTIONS(2538),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2524),
    [anon_sym_cl] = ACTIONS(2540),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2543),
    [anon_sym_for] = ACTIONS(2543),
    [anon_sym_and] = ACTIONS(2543),
    [anon_sym_as] = ACTIONS(2543),
    [anon_sym_with] = ACTIONS(2543),
    [anon_sym_do] = ACTIONS(2543),
    [anon_sym_while] = ACTIONS(2543),
    [anon_sym_until] = ACTIONS(2543),
    [anon_sym_repeat] = ACTIONS(2543),
    [anon_sym_when] = ACTIONS(2543),
    [anon_sym_if] = ACTIONS(2543),
    [anon_sym_unless] = ACTIONS(2543),
    [anon_sym_always] = ACTIONS(2543),
    [anon_sym_thereis] = ACTIONS(2543),
    [anon_sym_never] = ACTIONS(2543),
    [anon_sym_else] = ACTIONS(2543),
    [anon_sym_finally] = ACTIONS(2543),
    [anon_sym_return] = ACTIONS(2543),
    [anon_sym_initially] = ACTIONS(2543),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2545),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [129] = {
    [sym__gap] = STATE(272),
    [sym_dis_expr] = STATE(272),
    [sym__form] = STATE(2743),
    [sym_num_lit] = STATE(2743),
    [sym_kwd_lit] = STATE(2743),
    [sym_str_lit] = STATE(2743),
    [sym_char_lit] = STATE(2743),
    [sym_sym_lit] = STATE(2766),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2743),
    [sym__bare_list_lit] = STATE(1975),
    [sym_vec_lit] = STATE(2743),
    [sym_set_lit] = STATE(2743),
    [sym__bare_set_lit] = STATE(1976),
    [sym_read_cond_lit] = STATE(2743),
    [sym_splicing_read_cond_lit] = STATE(2743),
    [sym_var_quoting_lit] = STATE(2743),
    [sym_quoting_lit] = STATE(2743),
    [sym_syn_quoting_lit] = STATE(2743),
    [sym_unquote_splicing_lit] = STATE(2743),
    [sym_unquoting_lit] = STATE(2743),
    [sym_defun] = STATE(1975),
    [sym_for_clause_word] = STATE(419),
    [sym__for_part] = STATE(1555),
    [sym_loop_macro] = STATE(1975),
    [sym_path_lit] = STATE(2743),
    [sym_package_lit] = STATE(2743),
    [sym_include_reader_macro] = STATE(2743),
    [sym_complex_num_lit] = STATE(2743),
    [aux_sym_dis_expr_repeat1] = STATE(272),
    [aux_sym_list_lit_repeat1] = STATE(2830),
    [aux_sym_for_clause_repeat1] = STATE(1265),
    [sym__ws] = ACTIONS(2547),
    [sym_comment] = ACTIONS(2547),
    [anon_sym_POUND_] = ACTIONS(1452),
    [anon_sym_POUND] = ACTIONS(1454),
    [anon_sym_DOT] = ACTIONS(2549),
    [aux_sym_num_lit_token1] = ACTIONS(1458),
    [anon_sym_COLON] = ACTIONS(1460),
    [anon_sym_COLON_COLON] = ACTIONS(1462),
    [anon_sym_DQUOTE] = ACTIONS(1464),
    [sym_nil_lit] = ACTIONS(2549),
    [aux_sym_sym_lit_token1] = ACTIONS(1466),
    [anon_sym_CARET] = ACTIONS(25),
    [anon_sym_POUND_CARET] = ACTIONS(27),
    [anon_sym_LPAREN] = ACTIONS(1468),
    [anon_sym_POUND0A] = ACTIONS(1470),
    [anon_sym_POUND0a] = ACTIONS(1470),
    [anon_sym_POUND_QMARK] = ACTIONS(1472),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(1474),
    [anon_sym_POUND_SQUOTE] = ACTIONS(1476),
    [anon_sym_SQUOTE] = ACTIONS(1478),
    [anon_sym_BQUOTE] = ACTIONS(1480),
    [anon_sym_COMMA_AT] = ACTIONS(1482),
    [anon_sym_COMMA] = ACTIONS(1484),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2549),
    [anon_sym_cl] = ACTIONS(1486),
    [anon_sym_in] = ACTIONS(1488),
    [anon_sym_across] = ACTIONS(1488),
    [anon_sym_being] = ACTIONS(1488),
    [anon_sym_using] = ACTIONS(1488),
    [aux_sym_for_clause_word_token1] = ACTIONS(1490),
    [anon_sym_below] = ACTIONS(1488),
    [anon_sym_above] = ACTIONS(1488),
    [anon_sym_from] = ACTIONS(1488),
    [anon_sym_to] = ACTIONS(1488),
    [anon_sym_upto] = ACTIONS(1488),
    [anon_sym_upfrom] = ACTIONS(1488),
    [anon_sym_downto] = ACTIONS(1488),
    [anon_sym_downfrom] = ACTIONS(1488),
    [anon_sym_on] = ACTIONS(1488),
    [anon_sym_by] = ACTIONS(1488),
    [anon_sym_then] = ACTIONS(1488),
    [anon_sym_EQ] = ACTIONS(1488),
    [anon_sym_POUNDP] = ACTIONS(1492),
    [anon_sym_POUNDp] = ACTIONS(1492),
    [sym_self_referential_reader_macro] = ACTIONS(2551),
    [anon_sym_POUND_PLUS] = ACTIONS(1496),
    [anon_sym_POUND_DASH] = ACTIONS(1496),
    [anon_sym_POUNDC] = ACTIONS(1498),
    [anon_sym_POUNDc] = ACTIONS(1498),
  },
  [130] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2548),
    [sym_num_lit] = STATE(2548),
    [sym_kwd_lit] = STATE(2548),
    [sym_str_lit] = STATE(2548),
    [sym_char_lit] = STATE(2548),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2548),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2548),
    [sym_set_lit] = STATE(2548),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2548),
    [sym_splicing_read_cond_lit] = STATE(2548),
    [sym_var_quoting_lit] = STATE(2548),
    [sym_quoting_lit] = STATE(2548),
    [sym_syn_quoting_lit] = STATE(2548),
    [sym_unquote_splicing_lit] = STATE(2548),
    [sym_unquoting_lit] = STATE(2548),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2548),
    [sym_package_lit] = STATE(2548),
    [sym_include_reader_macro] = STATE(2548),
    [sym_complex_num_lit] = STATE(2548),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2428),
    [sym_comment] = ACTIONS(2428),
    [anon_sym_POUND_] = ACTIONS(2431),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2553),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2436),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2553),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2439),
    [anon_sym_POUND_CARET] = ACTIONS(2442),
    [anon_sym_LPAREN] = ACTIONS(2445),
    [anon_sym_RPAREN] = ACTIONS(2448),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2553),
    [anon_sym_cl] = ACTIONS(2450),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2453),
    [anon_sym_for] = ACTIONS(2453),
    [anon_sym_and] = ACTIONS(2453),
    [anon_sym_as] = ACTIONS(2453),
    [anon_sym_with] = ACTIONS(2453),
    [anon_sym_do] = ACTIONS(2453),
    [anon_sym_while] = ACTIONS(2453),
    [anon_sym_until] = ACTIONS(2453),
    [anon_sym_repeat] = ACTIONS(2453),
    [anon_sym_when] = ACTIONS(2453),
    [anon_sym_if] = ACTIONS(2453),
    [anon_sym_unless] = ACTIONS(2453),
    [anon_sym_always] = ACTIONS(2453),
    [anon_sym_thereis] = ACTIONS(2453),
    [anon_sym_never] = ACTIONS(2453),
    [anon_sym_else] = ACTIONS(2453),
    [anon_sym_finally] = ACTIONS(2453),
    [anon_sym_return] = ACTIONS(2453),
    [anon_sym_initially] = ACTIONS(2453),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2555),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [131] = {
    [sym__gap] = STATE(179),
    [sym_dis_expr] = STATE(179),
    [sym__form] = STATE(2549),
    [sym_num_lit] = STATE(2549),
    [sym_kwd_lit] = STATE(2549),
    [sym_str_lit] = STATE(2549),
    [sym_char_lit] = STATE(2549),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2549),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2549),
    [sym_set_lit] = STATE(2549),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2549),
    [sym_splicing_read_cond_lit] = STATE(2549),
    [sym_var_quoting_lit] = STATE(2549),
    [sym_quoting_lit] = STATE(2549),
    [sym_syn_quoting_lit] = STATE(2549),
    [sym_unquote_splicing_lit] = STATE(2549),
    [sym_unquoting_lit] = STATE(2549),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2549),
    [sym_package_lit] = STATE(2549),
    [sym_include_reader_macro] = STATE(2549),
    [sym_complex_num_lit] = STATE(2549),
    [aux_sym_dis_expr_repeat1] = STATE(179),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2557),
    [sym_comment] = ACTIONS(2557),
    [anon_sym_POUND_] = ACTIONS(2431),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2560),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2436),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2560),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2439),
    [anon_sym_POUND_CARET] = ACTIONS(2442),
    [anon_sym_LPAREN] = ACTIONS(2445),
    [anon_sym_RPAREN] = ACTIONS(2448),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2560),
    [anon_sym_cl] = ACTIONS(2450),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2453),
    [anon_sym_for] = ACTIONS(2453),
    [anon_sym_and] = ACTIONS(2453),
    [anon_sym_as] = ACTIONS(2453),
    [anon_sym_with] = ACTIONS(2453),
    [anon_sym_do] = ACTIONS(2453),
    [anon_sym_while] = ACTIONS(2453),
    [anon_sym_until] = ACTIONS(2453),
    [anon_sym_repeat] = ACTIONS(2453),
    [anon_sym_when] = ACTIONS(2453),
    [anon_sym_if] = ACTIONS(2453),
    [anon_sym_unless] = ACTIONS(2453),
    [anon_sym_always] = ACTIONS(2453),
    [anon_sym_thereis] = ACTIONS(2453),
    [anon_sym_never] = ACTIONS(2453),
    [anon_sym_else] = ACTIONS(2453),
    [anon_sym_finally] = ACTIONS(2453),
    [anon_sym_return] = ACTIONS(2453),
    [anon_sym_initially] = ACTIONS(2453),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2562),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [132] = {
    [sym__gap] = STATE(180),
    [sym_dis_expr] = STATE(180),
    [sym__form] = STATE(2325),
    [sym_num_lit] = STATE(2325),
    [sym_kwd_lit] = STATE(2325),
    [sym_str_lit] = STATE(2325),
    [sym_char_lit] = STATE(2325),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2325),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2325),
    [sym_set_lit] = STATE(2325),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2325),
    [sym_splicing_read_cond_lit] = STATE(2325),
    [sym_var_quoting_lit] = STATE(2325),
    [sym_quoting_lit] = STATE(2325),
    [sym_syn_quoting_lit] = STATE(2325),
    [sym_unquote_splicing_lit] = STATE(2325),
    [sym_unquoting_lit] = STATE(2325),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2325),
    [sym_package_lit] = STATE(2325),
    [sym_include_reader_macro] = STATE(2325),
    [sym_complex_num_lit] = STATE(2325),
    [aux_sym_dis_expr_repeat1] = STATE(180),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2564),
    [sym_comment] = ACTIONS(2564),
    [anon_sym_POUND_] = ACTIONS(2467),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2567),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2472),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2567),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2475),
    [anon_sym_POUND_CARET] = ACTIONS(2478),
    [anon_sym_LPAREN] = ACTIONS(2481),
    [anon_sym_RPAREN] = ACTIONS(2484),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2567),
    [anon_sym_cl] = ACTIONS(2486),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2489),
    [anon_sym_for] = ACTIONS(2489),
    [anon_sym_and] = ACTIONS(2489),
    [anon_sym_as] = ACTIONS(2489),
    [anon_sym_with] = ACTIONS(2489),
    [anon_sym_do] = ACTIONS(2489),
    [anon_sym_while] = ACTIONS(2489),
    [anon_sym_until] = ACTIONS(2489),
    [anon_sym_repeat] = ACTIONS(2489),
    [anon_sym_when] = ACTIONS(2489),
    [anon_sym_if] = ACTIONS(2489),
    [anon_sym_unless] = ACTIONS(2489),
    [anon_sym_always] = ACTIONS(2489),
    [anon_sym_thereis] = ACTIONS(2489),
    [anon_sym_never] = ACTIONS(2489),
    [anon_sym_else] = ACTIONS(2489),
    [anon_sym_finally] = ACTIONS(2489),
    [anon_sym_return] = ACTIONS(2489),
    [anon_sym_initially] = ACTIONS(2489),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2569),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [133] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2049),
    [sym_num_lit] = STATE(2049),
    [sym_kwd_lit] = STATE(2049),
    [sym_str_lit] = STATE(2049),
    [sym_char_lit] = STATE(2049),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2049),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2049),
    [sym_set_lit] = STATE(2049),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2049),
    [sym_splicing_read_cond_lit] = STATE(2049),
    [sym_var_quoting_lit] = STATE(2049),
    [sym_quoting_lit] = STATE(2049),
    [sym_syn_quoting_lit] = STATE(2049),
    [sym_unquote_splicing_lit] = STATE(2049),
    [sym_unquoting_lit] = STATE(2049),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2049),
    [sym_package_lit] = STATE(2049),
    [sym_include_reader_macro] = STATE(2049),
    [sym_complex_num_lit] = STATE(2049),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2493),
    [sym_comment] = ACTIONS(2493),
    [anon_sym_POUND_] = ACTIONS(2467),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2571),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2472),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2571),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2475),
    [anon_sym_POUND_CARET] = ACTIONS(2478),
    [anon_sym_LPAREN] = ACTIONS(2481),
    [anon_sym_RPAREN] = ACTIONS(2484),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2571),
    [anon_sym_cl] = ACTIONS(2486),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2489),
    [anon_sym_for] = ACTIONS(2489),
    [anon_sym_and] = ACTIONS(2489),
    [anon_sym_as] = ACTIONS(2489),
    [anon_sym_with] = ACTIONS(2489),
    [anon_sym_do] = ACTIONS(2489),
    [anon_sym_while] = ACTIONS(2489),
    [anon_sym_until] = ACTIONS(2489),
    [anon_sym_repeat] = ACTIONS(2489),
    [anon_sym_when] = ACTIONS(2489),
    [anon_sym_if] = ACTIONS(2489),
    [anon_sym_unless] = ACTIONS(2489),
    [anon_sym_always] = ACTIONS(2489),
    [anon_sym_thereis] = ACTIONS(2489),
    [anon_sym_never] = ACTIONS(2489),
    [anon_sym_else] = ACTIONS(2489),
    [anon_sym_finally] = ACTIONS(2489),
    [anon_sym_return] = ACTIONS(2489),
    [anon_sym_initially] = ACTIONS(2489),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2573),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [134] = {
    [sym__gap] = STATE(183),
    [sym_dis_expr] = STATE(183),
    [sym__form] = STATE(2051),
    [sym_num_lit] = STATE(2051),
    [sym_kwd_lit] = STATE(2051),
    [sym_str_lit] = STATE(2051),
    [sym_char_lit] = STATE(2051),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2051),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2051),
    [sym_set_lit] = STATE(2051),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2051),
    [sym_splicing_read_cond_lit] = STATE(2051),
    [sym_var_quoting_lit] = STATE(2051),
    [sym_quoting_lit] = STATE(2051),
    [sym_syn_quoting_lit] = STATE(2051),
    [sym_unquote_splicing_lit] = STATE(2051),
    [sym_unquoting_lit] = STATE(2051),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2051),
    [sym_package_lit] = STATE(2051),
    [sym_include_reader_macro] = STATE(2051),
    [sym_complex_num_lit] = STATE(2051),
    [aux_sym_dis_expr_repeat1] = STATE(183),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2575),
    [sym_comment] = ACTIONS(2575),
    [anon_sym_POUND_] = ACTIONS(2467),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2578),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2472),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2578),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2475),
    [anon_sym_POUND_CARET] = ACTIONS(2478),
    [anon_sym_LPAREN] = ACTIONS(2481),
    [anon_sym_RPAREN] = ACTIONS(2484),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2578),
    [anon_sym_cl] = ACTIONS(2486),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2489),
    [anon_sym_for] = ACTIONS(2489),
    [anon_sym_and] = ACTIONS(2489),
    [anon_sym_as] = ACTIONS(2489),
    [anon_sym_with] = ACTIONS(2489),
    [anon_sym_do] = ACTIONS(2489),
    [anon_sym_while] = ACTIONS(2489),
    [anon_sym_until] = ACTIONS(2489),
    [anon_sym_repeat] = ACTIONS(2489),
    [anon_sym_when] = ACTIONS(2489),
    [anon_sym_if] = ACTIONS(2489),
    [anon_sym_unless] = ACTIONS(2489),
    [anon_sym_always] = ACTIONS(2489),
    [anon_sym_thereis] = ACTIONS(2489),
    [anon_sym_never] = ACTIONS(2489),
    [anon_sym_else] = ACTIONS(2489),
    [anon_sym_finally] = ACTIONS(2489),
    [anon_sym_return] = ACTIONS(2489),
    [anon_sym_initially] = ACTIONS(2489),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2580),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [135] = {
    [sym__gap] = STATE(184),
    [sym_dis_expr] = STATE(184),
    [sym__form] = STATE(2053),
    [sym_num_lit] = STATE(2053),
    [sym_kwd_lit] = STATE(2053),
    [sym_str_lit] = STATE(2053),
    [sym_char_lit] = STATE(2053),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2053),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2053),
    [sym_set_lit] = STATE(2053),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2053),
    [sym_splicing_read_cond_lit] = STATE(2053),
    [sym_var_quoting_lit] = STATE(2053),
    [sym_quoting_lit] = STATE(2053),
    [sym_syn_quoting_lit] = STATE(2053),
    [sym_unquote_splicing_lit] = STATE(2053),
    [sym_unquoting_lit] = STATE(2053),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2053),
    [sym_package_lit] = STATE(2053),
    [sym_include_reader_macro] = STATE(2053),
    [sym_complex_num_lit] = STATE(2053),
    [aux_sym_dis_expr_repeat1] = STATE(184),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2582),
    [sym_comment] = ACTIONS(2582),
    [anon_sym_POUND_] = ACTIONS(2431),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2585),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2436),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2585),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2439),
    [anon_sym_POUND_CARET] = ACTIONS(2442),
    [anon_sym_LPAREN] = ACTIONS(2445),
    [anon_sym_RPAREN] = ACTIONS(2448),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2585),
    [anon_sym_cl] = ACTIONS(2450),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2453),
    [anon_sym_for] = ACTIONS(2453),
    [anon_sym_and] = ACTIONS(2453),
    [anon_sym_as] = ACTIONS(2453),
    [anon_sym_with] = ACTIONS(2453),
    [anon_sym_do] = ACTIONS(2453),
    [anon_sym_while] = ACTIONS(2453),
    [anon_sym_until] = ACTIONS(2453),
    [anon_sym_repeat] = ACTIONS(2453),
    [anon_sym_when] = ACTIONS(2453),
    [anon_sym_if] = ACTIONS(2453),
    [anon_sym_unless] = ACTIONS(2453),
    [anon_sym_always] = ACTIONS(2453),
    [anon_sym_thereis] = ACTIONS(2453),
    [anon_sym_never] = ACTIONS(2453),
    [anon_sym_else] = ACTIONS(2453),
    [anon_sym_finally] = ACTIONS(2453),
    [anon_sym_return] = ACTIONS(2453),
    [anon_sym_initially] = ACTIONS(2453),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2587),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [136] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2055),
    [sym_num_lit] = STATE(2055),
    [sym_kwd_lit] = STATE(2055),
    [sym_str_lit] = STATE(2055),
    [sym_char_lit] = STATE(2055),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2055),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2055),
    [sym_set_lit] = STATE(2055),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2055),
    [sym_splicing_read_cond_lit] = STATE(2055),
    [sym_var_quoting_lit] = STATE(2055),
    [sym_quoting_lit] = STATE(2055),
    [sym_syn_quoting_lit] = STATE(2055),
    [sym_unquote_splicing_lit] = STATE(2055),
    [sym_unquoting_lit] = STATE(2055),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2055),
    [sym_package_lit] = STATE(2055),
    [sym_include_reader_macro] = STATE(2055),
    [sym_complex_num_lit] = STATE(2055),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2428),
    [sym_comment] = ACTIONS(2428),
    [anon_sym_POUND_] = ACTIONS(2431),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2589),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2436),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2589),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2439),
    [anon_sym_POUND_CARET] = ACTIONS(2442),
    [anon_sym_LPAREN] = ACTIONS(2445),
    [anon_sym_RPAREN] = ACTIONS(2448),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2589),
    [anon_sym_cl] = ACTIONS(2450),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2453),
    [anon_sym_for] = ACTIONS(2453),
    [anon_sym_and] = ACTIONS(2453),
    [anon_sym_as] = ACTIONS(2453),
    [anon_sym_with] = ACTIONS(2453),
    [anon_sym_do] = ACTIONS(2453),
    [anon_sym_while] = ACTIONS(2453),
    [anon_sym_until] = ACTIONS(2453),
    [anon_sym_repeat] = ACTIONS(2453),
    [anon_sym_when] = ACTIONS(2453),
    [anon_sym_if] = ACTIONS(2453),
    [anon_sym_unless] = ACTIONS(2453),
    [anon_sym_always] = ACTIONS(2453),
    [anon_sym_thereis] = ACTIONS(2453),
    [anon_sym_never] = ACTIONS(2453),
    [anon_sym_else] = ACTIONS(2453),
    [anon_sym_finally] = ACTIONS(2453),
    [anon_sym_return] = ACTIONS(2453),
    [anon_sym_initially] = ACTIONS(2453),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2591),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [137] = {
    [sym__gap] = STATE(187),
    [sym_dis_expr] = STATE(187),
    [sym__form] = STATE(2056),
    [sym_num_lit] = STATE(2056),
    [sym_kwd_lit] = STATE(2056),
    [sym_str_lit] = STATE(2056),
    [sym_char_lit] = STATE(2056),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2056),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2056),
    [sym_set_lit] = STATE(2056),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2056),
    [sym_splicing_read_cond_lit] = STATE(2056),
    [sym_var_quoting_lit] = STATE(2056),
    [sym_quoting_lit] = STATE(2056),
    [sym_syn_quoting_lit] = STATE(2056),
    [sym_unquote_splicing_lit] = STATE(2056),
    [sym_unquoting_lit] = STATE(2056),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2056),
    [sym_package_lit] = STATE(2056),
    [sym_include_reader_macro] = STATE(2056),
    [sym_complex_num_lit] = STATE(2056),
    [aux_sym_dis_expr_repeat1] = STATE(187),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2593),
    [sym_comment] = ACTIONS(2593),
    [anon_sym_POUND_] = ACTIONS(2521),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2596),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2526),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2596),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2529),
    [anon_sym_POUND_CARET] = ACTIONS(2532),
    [anon_sym_LPAREN] = ACTIONS(2535),
    [anon_sym_RPAREN] = ACTIONS(2538),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2596),
    [anon_sym_cl] = ACTIONS(2540),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2543),
    [anon_sym_for] = ACTIONS(2543),
    [anon_sym_and] = ACTIONS(2543),
    [anon_sym_as] = ACTIONS(2543),
    [anon_sym_with] = ACTIONS(2543),
    [anon_sym_do] = ACTIONS(2543),
    [anon_sym_while] = ACTIONS(2543),
    [anon_sym_until] = ACTIONS(2543),
    [anon_sym_repeat] = ACTIONS(2543),
    [anon_sym_when] = ACTIONS(2543),
    [anon_sym_if] = ACTIONS(2543),
    [anon_sym_unless] = ACTIONS(2543),
    [anon_sym_always] = ACTIONS(2543),
    [anon_sym_thereis] = ACTIONS(2543),
    [anon_sym_never] = ACTIONS(2543),
    [anon_sym_else] = ACTIONS(2543),
    [anon_sym_finally] = ACTIONS(2543),
    [anon_sym_return] = ACTIONS(2543),
    [anon_sym_initially] = ACTIONS(2543),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2598),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [138] = {
    [sym__gap] = STATE(61),
    [sym_dis_expr] = STATE(61),
    [sym__form] = STATE(2536),
    [sym_num_lit] = STATE(2536),
    [sym_kwd_lit] = STATE(2536),
    [sym_str_lit] = STATE(2536),
    [sym_char_lit] = STATE(2536),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2536),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2536),
    [sym_set_lit] = STATE(2536),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2536),
    [sym_splicing_read_cond_lit] = STATE(2536),
    [sym_var_quoting_lit] = STATE(2536),
    [sym_quoting_lit] = STATE(2536),
    [sym_syn_quoting_lit] = STATE(2536),
    [sym_unquote_splicing_lit] = STATE(2536),
    [sym_unquoting_lit] = STATE(2536),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2536),
    [sym_package_lit] = STATE(2536),
    [sym_include_reader_macro] = STATE(2536),
    [sym_complex_num_lit] = STATE(2536),
    [aux_sym_dis_expr_repeat1] = STATE(61),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2600),
    [sym_comment] = ACTIONS(2600),
    [anon_sym_POUND_] = ACTIONS(2059),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2603),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2064),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2603),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2067),
    [anon_sym_POUND_CARET] = ACTIONS(2070),
    [anon_sym_LPAREN] = ACTIONS(2073),
    [anon_sym_RPAREN] = ACTIONS(2076),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2603),
    [anon_sym_cl] = ACTIONS(2078),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2081),
    [anon_sym_for] = ACTIONS(2081),
    [anon_sym_and] = ACTIONS(2081),
    [anon_sym_as] = ACTIONS(2081),
    [anon_sym_with] = ACTIONS(2081),
    [anon_sym_do] = ACTIONS(2081),
    [anon_sym_while] = ACTIONS(2081),
    [anon_sym_until] = ACTIONS(2081),
    [anon_sym_repeat] = ACTIONS(2081),
    [anon_sym_when] = ACTIONS(2081),
    [anon_sym_if] = ACTIONS(2081),
    [anon_sym_unless] = ACTIONS(2081),
    [anon_sym_always] = ACTIONS(2081),
    [anon_sym_thereis] = ACTIONS(2081),
    [anon_sym_never] = ACTIONS(2081),
    [anon_sym_else] = ACTIONS(2081),
    [anon_sym_finally] = ACTIONS(2081),
    [anon_sym_return] = ACTIONS(2081),
    [anon_sym_initially] = ACTIONS(2081),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2605),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [139] = {
    [sym__gap] = STATE(189),
    [sym_dis_expr] = STATE(189),
    [sym__form] = STATE(2059),
    [sym_num_lit] = STATE(2059),
    [sym_kwd_lit] = STATE(2059),
    [sym_str_lit] = STATE(2059),
    [sym_char_lit] = STATE(2059),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2059),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2059),
    [sym_set_lit] = STATE(2059),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2059),
    [sym_splicing_read_cond_lit] = STATE(2059),
    [sym_var_quoting_lit] = STATE(2059),
    [sym_quoting_lit] = STATE(2059),
    [sym_syn_quoting_lit] = STATE(2059),
    [sym_unquote_splicing_lit] = STATE(2059),
    [sym_unquoting_lit] = STATE(2059),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2059),
    [sym_package_lit] = STATE(2059),
    [sym_include_reader_macro] = STATE(2059),
    [sym_complex_num_lit] = STATE(2059),
    [aux_sym_dis_expr_repeat1] = STATE(189),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2607),
    [sym_comment] = ACTIONS(2607),
    [anon_sym_POUND_] = ACTIONS(2610),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2613),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2615),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2613),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2618),
    [anon_sym_POUND_CARET] = ACTIONS(2621),
    [anon_sym_LPAREN] = ACTIONS(2624),
    [anon_sym_RPAREN] = ACTIONS(2627),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2613),
    [anon_sym_cl] = ACTIONS(2629),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2632),
    [anon_sym_for] = ACTIONS(2632),
    [anon_sym_and] = ACTIONS(2632),
    [anon_sym_as] = ACTIONS(2632),
    [anon_sym_with] = ACTIONS(2632),
    [anon_sym_do] = ACTIONS(2632),
    [anon_sym_while] = ACTIONS(2632),
    [anon_sym_until] = ACTIONS(2632),
    [anon_sym_repeat] = ACTIONS(2632),
    [anon_sym_when] = ACTIONS(2632),
    [anon_sym_if] = ACTIONS(2632),
    [anon_sym_unless] = ACTIONS(2632),
    [anon_sym_always] = ACTIONS(2632),
    [anon_sym_thereis] = ACTIONS(2632),
    [anon_sym_never] = ACTIONS(2632),
    [anon_sym_else] = ACTIONS(2632),
    [anon_sym_finally] = ACTIONS(2632),
    [anon_sym_return] = ACTIONS(2632),
    [anon_sym_initially] = ACTIONS(2632),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2634),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [140] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2061),
    [sym_num_lit] = STATE(2061),
    [sym_kwd_lit] = STATE(2061),
    [sym_str_lit] = STATE(2061),
    [sym_char_lit] = STATE(2061),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2061),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2061),
    [sym_set_lit] = STATE(2061),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2061),
    [sym_splicing_read_cond_lit] = STATE(2061),
    [sym_var_quoting_lit] = STATE(2061),
    [sym_quoting_lit] = STATE(2061),
    [sym_syn_quoting_lit] = STATE(2061),
    [sym_unquote_splicing_lit] = STATE(2061),
    [sym_unquoting_lit] = STATE(2061),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2061),
    [sym_package_lit] = STATE(2061),
    [sym_include_reader_macro] = STATE(2061),
    [sym_complex_num_lit] = STATE(2061),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2636),
    [sym_comment] = ACTIONS(2636),
    [anon_sym_POUND_] = ACTIONS(2610),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2639),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2615),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2639),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2618),
    [anon_sym_POUND_CARET] = ACTIONS(2621),
    [anon_sym_LPAREN] = ACTIONS(2624),
    [anon_sym_RPAREN] = ACTIONS(2627),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2639),
    [anon_sym_cl] = ACTIONS(2629),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2632),
    [anon_sym_for] = ACTIONS(2632),
    [anon_sym_and] = ACTIONS(2632),
    [anon_sym_as] = ACTIONS(2632),
    [anon_sym_with] = ACTIONS(2632),
    [anon_sym_do] = ACTIONS(2632),
    [anon_sym_while] = ACTIONS(2632),
    [anon_sym_until] = ACTIONS(2632),
    [anon_sym_repeat] = ACTIONS(2632),
    [anon_sym_when] = ACTIONS(2632),
    [anon_sym_if] = ACTIONS(2632),
    [anon_sym_unless] = ACTIONS(2632),
    [anon_sym_always] = ACTIONS(2632),
    [anon_sym_thereis] = ACTIONS(2632),
    [anon_sym_never] = ACTIONS(2632),
    [anon_sym_else] = ACTIONS(2632),
    [anon_sym_finally] = ACTIONS(2632),
    [anon_sym_return] = ACTIONS(2632),
    [anon_sym_initially] = ACTIONS(2632),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2641),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [141] = {
    [sym__gap] = STATE(192),
    [sym_dis_expr] = STATE(192),
    [sym__form] = STATE(2062),
    [sym_num_lit] = STATE(2062),
    [sym_kwd_lit] = STATE(2062),
    [sym_str_lit] = STATE(2062),
    [sym_char_lit] = STATE(2062),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2062),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2062),
    [sym_set_lit] = STATE(2062),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2062),
    [sym_splicing_read_cond_lit] = STATE(2062),
    [sym_var_quoting_lit] = STATE(2062),
    [sym_quoting_lit] = STATE(2062),
    [sym_syn_quoting_lit] = STATE(2062),
    [sym_unquote_splicing_lit] = STATE(2062),
    [sym_unquoting_lit] = STATE(2062),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2062),
    [sym_package_lit] = STATE(2062),
    [sym_include_reader_macro] = STATE(2062),
    [sym_complex_num_lit] = STATE(2062),
    [aux_sym_dis_expr_repeat1] = STATE(192),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2643),
    [sym_comment] = ACTIONS(2643),
    [anon_sym_POUND_] = ACTIONS(2646),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2649),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2651),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2649),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2654),
    [anon_sym_POUND_CARET] = ACTIONS(2657),
    [anon_sym_LPAREN] = ACTIONS(2660),
    [anon_sym_RPAREN] = ACTIONS(2663),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2649),
    [anon_sym_cl] = ACTIONS(2665),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2668),
    [anon_sym_for] = ACTIONS(2668),
    [anon_sym_and] = ACTIONS(2668),
    [anon_sym_as] = ACTIONS(2668),
    [anon_sym_with] = ACTIONS(2668),
    [anon_sym_do] = ACTIONS(2668),
    [anon_sym_while] = ACTIONS(2668),
    [anon_sym_until] = ACTIONS(2668),
    [anon_sym_repeat] = ACTIONS(2668),
    [anon_sym_when] = ACTIONS(2668),
    [anon_sym_if] = ACTIONS(2668),
    [anon_sym_unless] = ACTIONS(2668),
    [anon_sym_always] = ACTIONS(2668),
    [anon_sym_thereis] = ACTIONS(2668),
    [anon_sym_never] = ACTIONS(2668),
    [anon_sym_else] = ACTIONS(2668),
    [anon_sym_finally] = ACTIONS(2668),
    [anon_sym_return] = ACTIONS(2668),
    [anon_sym_initially] = ACTIONS(2668),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2670),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [142] = {
    [sym__gap] = STATE(195),
    [sym_dis_expr] = STATE(195),
    [sym__form] = STATE(2066),
    [sym_num_lit] = STATE(2066),
    [sym_kwd_lit] = STATE(2066),
    [sym_str_lit] = STATE(2066),
    [sym_char_lit] = STATE(2066),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2066),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2066),
    [sym_set_lit] = STATE(2066),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2066),
    [sym_splicing_read_cond_lit] = STATE(2066),
    [sym_var_quoting_lit] = STATE(2066),
    [sym_quoting_lit] = STATE(2066),
    [sym_syn_quoting_lit] = STATE(2066),
    [sym_unquote_splicing_lit] = STATE(2066),
    [sym_unquoting_lit] = STATE(2066),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2066),
    [sym_package_lit] = STATE(2066),
    [sym_include_reader_macro] = STATE(2066),
    [sym_complex_num_lit] = STATE(2066),
    [aux_sym_dis_expr_repeat1] = STATE(195),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2672),
    [sym_comment] = ACTIONS(2672),
    [anon_sym_POUND_] = ACTIONS(2610),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2675),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2615),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2675),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2618),
    [anon_sym_POUND_CARET] = ACTIONS(2621),
    [anon_sym_LPAREN] = ACTIONS(2624),
    [anon_sym_RPAREN] = ACTIONS(2627),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2675),
    [anon_sym_cl] = ACTIONS(2629),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2632),
    [anon_sym_for] = ACTIONS(2632),
    [anon_sym_and] = ACTIONS(2632),
    [anon_sym_as] = ACTIONS(2632),
    [anon_sym_with] = ACTIONS(2632),
    [anon_sym_do] = ACTIONS(2632),
    [anon_sym_while] = ACTIONS(2632),
    [anon_sym_until] = ACTIONS(2632),
    [anon_sym_repeat] = ACTIONS(2632),
    [anon_sym_when] = ACTIONS(2632),
    [anon_sym_if] = ACTIONS(2632),
    [anon_sym_unless] = ACTIONS(2632),
    [anon_sym_always] = ACTIONS(2632),
    [anon_sym_thereis] = ACTIONS(2632),
    [anon_sym_never] = ACTIONS(2632),
    [anon_sym_else] = ACTIONS(2632),
    [anon_sym_finally] = ACTIONS(2632),
    [anon_sym_return] = ACTIONS(2632),
    [anon_sym_initially] = ACTIONS(2632),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2677),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [143] = {
    [sym__gap] = STATE(65),
    [sym_dis_expr] = STATE(65),
    [sym__form] = STATE(2541),
    [sym_num_lit] = STATE(2541),
    [sym_kwd_lit] = STATE(2541),
    [sym_str_lit] = STATE(2541),
    [sym_char_lit] = STATE(2541),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2541),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2541),
    [sym_set_lit] = STATE(2541),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2541),
    [sym_splicing_read_cond_lit] = STATE(2541),
    [sym_var_quoting_lit] = STATE(2541),
    [sym_quoting_lit] = STATE(2541),
    [sym_syn_quoting_lit] = STATE(2541),
    [sym_unquote_splicing_lit] = STATE(2541),
    [sym_unquoting_lit] = STATE(2541),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2541),
    [sym_package_lit] = STATE(2541),
    [sym_include_reader_macro] = STATE(2541),
    [sym_complex_num_lit] = STATE(2541),
    [aux_sym_dis_expr_repeat1] = STATE(65),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2679),
    [sym_comment] = ACTIONS(2679),
    [anon_sym_POUND_] = ACTIONS(1547),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2682),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(1552),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2682),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(430),
    [anon_sym_POUND_CARET] = ACTIONS(433),
    [anon_sym_LPAREN] = ACTIONS(1555),
    [anon_sym_RPAREN] = ACTIONS(439),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2682),
    [anon_sym_cl] = ACTIONS(1558),
    [aux_sym_accumulation_verb_token1] = ACTIONS(446),
    [anon_sym_for] = ACTIONS(446),
    [anon_sym_and] = ACTIONS(446),
    [anon_sym_as] = ACTIONS(446),
    [anon_sym_with] = ACTIONS(446),
    [anon_sym_do] = ACTIONS(446),
    [anon_sym_while] = ACTIONS(446),
    [anon_sym_until] = ACTIONS(446),
    [anon_sym_repeat] = ACTIONS(446),
    [anon_sym_when] = ACTIONS(446),
    [anon_sym_if] = ACTIONS(446),
    [anon_sym_unless] = ACTIONS(446),
    [anon_sym_always] = ACTIONS(446),
    [anon_sym_thereis] = ACTIONS(446),
    [anon_sym_never] = ACTIONS(446),
    [anon_sym_else] = ACTIONS(446),
    [anon_sym_finally] = ACTIONS(446),
    [anon_sym_return] = ACTIONS(446),
    [anon_sym_initially] = ACTIONS(446),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2684),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [144] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2072),
    [sym_num_lit] = STATE(2072),
    [sym_kwd_lit] = STATE(2072),
    [sym_str_lit] = STATE(2072),
    [sym_char_lit] = STATE(2072),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2072),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2072),
    [sym_set_lit] = STATE(2072),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2072),
    [sym_splicing_read_cond_lit] = STATE(2072),
    [sym_var_quoting_lit] = STATE(2072),
    [sym_quoting_lit] = STATE(2072),
    [sym_syn_quoting_lit] = STATE(2072),
    [sym_unquote_splicing_lit] = STATE(2072),
    [sym_unquoting_lit] = STATE(2072),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2072),
    [sym_package_lit] = STATE(2072),
    [sym_include_reader_macro] = STATE(2072),
    [sym_complex_num_lit] = STATE(2072),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2686),
    [sym_comment] = ACTIONS(2686),
    [anon_sym_POUND_] = ACTIONS(2689),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2692),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2694),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2692),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2697),
    [anon_sym_POUND_CARET] = ACTIONS(2700),
    [anon_sym_LPAREN] = ACTIONS(2703),
    [anon_sym_RPAREN] = ACTIONS(2706),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2692),
    [anon_sym_cl] = ACTIONS(2708),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2711),
    [anon_sym_for] = ACTIONS(2711),
    [anon_sym_and] = ACTIONS(2711),
    [anon_sym_as] = ACTIONS(2711),
    [anon_sym_with] = ACTIONS(2711),
    [anon_sym_do] = ACTIONS(2711),
    [anon_sym_while] = ACTIONS(2711),
    [anon_sym_until] = ACTIONS(2711),
    [anon_sym_repeat] = ACTIONS(2711),
    [anon_sym_when] = ACTIONS(2711),
    [anon_sym_if] = ACTIONS(2711),
    [anon_sym_unless] = ACTIONS(2711),
    [anon_sym_always] = ACTIONS(2711),
    [anon_sym_thereis] = ACTIONS(2711),
    [anon_sym_never] = ACTIONS(2711),
    [anon_sym_else] = ACTIONS(2711),
    [anon_sym_finally] = ACTIONS(2711),
    [anon_sym_return] = ACTIONS(2711),
    [anon_sym_initially] = ACTIONS(2711),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2713),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [145] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2074),
    [sym_num_lit] = STATE(2074),
    [sym_kwd_lit] = STATE(2074),
    [sym_str_lit] = STATE(2074),
    [sym_char_lit] = STATE(2074),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2074),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2074),
    [sym_set_lit] = STATE(2074),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2074),
    [sym_splicing_read_cond_lit] = STATE(2074),
    [sym_var_quoting_lit] = STATE(2074),
    [sym_quoting_lit] = STATE(2074),
    [sym_syn_quoting_lit] = STATE(2074),
    [sym_unquote_splicing_lit] = STATE(2074),
    [sym_unquoting_lit] = STATE(2074),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2074),
    [sym_package_lit] = STATE(2074),
    [sym_include_reader_macro] = STATE(2074),
    [sym_complex_num_lit] = STATE(2074),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2686),
    [sym_comment] = ACTIONS(2686),
    [anon_sym_POUND_] = ACTIONS(2689),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2715),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2694),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2715),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2697),
    [anon_sym_POUND_CARET] = ACTIONS(2700),
    [anon_sym_LPAREN] = ACTIONS(2703),
    [anon_sym_RPAREN] = ACTIONS(2706),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2715),
    [anon_sym_cl] = ACTIONS(2708),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2711),
    [anon_sym_for] = ACTIONS(2711),
    [anon_sym_and] = ACTIONS(2711),
    [anon_sym_as] = ACTIONS(2711),
    [anon_sym_with] = ACTIONS(2711),
    [anon_sym_do] = ACTIONS(2711),
    [anon_sym_while] = ACTIONS(2711),
    [anon_sym_until] = ACTIONS(2711),
    [anon_sym_repeat] = ACTIONS(2711),
    [anon_sym_when] = ACTIONS(2711),
    [anon_sym_if] = ACTIONS(2711),
    [anon_sym_unless] = ACTIONS(2711),
    [anon_sym_always] = ACTIONS(2711),
    [anon_sym_thereis] = ACTIONS(2711),
    [anon_sym_never] = ACTIONS(2711),
    [anon_sym_else] = ACTIONS(2711),
    [anon_sym_finally] = ACTIONS(2711),
    [anon_sym_return] = ACTIONS(2711),
    [anon_sym_initially] = ACTIONS(2711),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2717),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [146] = {
    [sym__gap] = STATE(198),
    [sym_dis_expr] = STATE(198),
    [sym__form] = STATE(2075),
    [sym_num_lit] = STATE(2075),
    [sym_kwd_lit] = STATE(2075),
    [sym_str_lit] = STATE(2075),
    [sym_char_lit] = STATE(2075),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2075),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2075),
    [sym_set_lit] = STATE(2075),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2075),
    [sym_splicing_read_cond_lit] = STATE(2075),
    [sym_var_quoting_lit] = STATE(2075),
    [sym_quoting_lit] = STATE(2075),
    [sym_syn_quoting_lit] = STATE(2075),
    [sym_unquote_splicing_lit] = STATE(2075),
    [sym_unquoting_lit] = STATE(2075),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2075),
    [sym_package_lit] = STATE(2075),
    [sym_include_reader_macro] = STATE(2075),
    [sym_complex_num_lit] = STATE(2075),
    [aux_sym_dis_expr_repeat1] = STATE(198),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2719),
    [sym_comment] = ACTIONS(2719),
    [anon_sym_POUND_] = ACTIONS(2689),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2722),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2694),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2722),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2697),
    [anon_sym_POUND_CARET] = ACTIONS(2700),
    [anon_sym_LPAREN] = ACTIONS(2703),
    [anon_sym_RPAREN] = ACTIONS(2706),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2722),
    [anon_sym_cl] = ACTIONS(2708),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2711),
    [anon_sym_for] = ACTIONS(2711),
    [anon_sym_and] = ACTIONS(2711),
    [anon_sym_as] = ACTIONS(2711),
    [anon_sym_with] = ACTIONS(2711),
    [anon_sym_do] = ACTIONS(2711),
    [anon_sym_while] = ACTIONS(2711),
    [anon_sym_until] = ACTIONS(2711),
    [anon_sym_repeat] = ACTIONS(2711),
    [anon_sym_when] = ACTIONS(2711),
    [anon_sym_if] = ACTIONS(2711),
    [anon_sym_unless] = ACTIONS(2711),
    [anon_sym_always] = ACTIONS(2711),
    [anon_sym_thereis] = ACTIONS(2711),
    [anon_sym_never] = ACTIONS(2711),
    [anon_sym_else] = ACTIONS(2711),
    [anon_sym_finally] = ACTIONS(2711),
    [anon_sym_return] = ACTIONS(2711),
    [anon_sym_initially] = ACTIONS(2711),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2724),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [147] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2080),
    [sym_num_lit] = STATE(2080),
    [sym_kwd_lit] = STATE(2080),
    [sym_str_lit] = STATE(2080),
    [sym_char_lit] = STATE(2080),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2080),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2080),
    [sym_set_lit] = STATE(2080),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2080),
    [sym_splicing_read_cond_lit] = STATE(2080),
    [sym_var_quoting_lit] = STATE(2080),
    [sym_quoting_lit] = STATE(2080),
    [sym_syn_quoting_lit] = STATE(2080),
    [sym_unquote_splicing_lit] = STATE(2080),
    [sym_unquoting_lit] = STATE(2080),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2080),
    [sym_package_lit] = STATE(2080),
    [sym_include_reader_macro] = STATE(2080),
    [sym_complex_num_lit] = STATE(2080),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2726),
    [sym_comment] = ACTIONS(2726),
    [anon_sym_POUND_] = ACTIONS(2729),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2732),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2734),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2732),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2737),
    [anon_sym_POUND_CARET] = ACTIONS(2740),
    [anon_sym_LPAREN] = ACTIONS(2743),
    [anon_sym_RPAREN] = ACTIONS(2746),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2732),
    [anon_sym_cl] = ACTIONS(2748),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2751),
    [anon_sym_for] = ACTIONS(2751),
    [anon_sym_and] = ACTIONS(2751),
    [anon_sym_as] = ACTIONS(2751),
    [anon_sym_with] = ACTIONS(2751),
    [anon_sym_do] = ACTIONS(2751),
    [anon_sym_while] = ACTIONS(2751),
    [anon_sym_until] = ACTIONS(2751),
    [anon_sym_repeat] = ACTIONS(2751),
    [anon_sym_when] = ACTIONS(2751),
    [anon_sym_if] = ACTIONS(2751),
    [anon_sym_unless] = ACTIONS(2751),
    [anon_sym_always] = ACTIONS(2751),
    [anon_sym_thereis] = ACTIONS(2751),
    [anon_sym_never] = ACTIONS(2751),
    [anon_sym_else] = ACTIONS(2751),
    [anon_sym_finally] = ACTIONS(2751),
    [anon_sym_return] = ACTIONS(2751),
    [anon_sym_initially] = ACTIONS(2751),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2753),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [148] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2082),
    [sym_num_lit] = STATE(2082),
    [sym_kwd_lit] = STATE(2082),
    [sym_str_lit] = STATE(2082),
    [sym_char_lit] = STATE(2082),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2082),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2082),
    [sym_set_lit] = STATE(2082),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2082),
    [sym_splicing_read_cond_lit] = STATE(2082),
    [sym_var_quoting_lit] = STATE(2082),
    [sym_quoting_lit] = STATE(2082),
    [sym_syn_quoting_lit] = STATE(2082),
    [sym_unquote_splicing_lit] = STATE(2082),
    [sym_unquoting_lit] = STATE(2082),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2082),
    [sym_package_lit] = STATE(2082),
    [sym_include_reader_macro] = STATE(2082),
    [sym_complex_num_lit] = STATE(2082),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2755),
    [sym_comment] = ACTIONS(2755),
    [anon_sym_POUND_] = ACTIONS(2758),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2761),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2763),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2761),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2766),
    [anon_sym_POUND_CARET] = ACTIONS(2769),
    [anon_sym_LPAREN] = ACTIONS(2772),
    [anon_sym_RPAREN] = ACTIONS(2775),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2761),
    [anon_sym_cl] = ACTIONS(2777),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2780),
    [anon_sym_for] = ACTIONS(2780),
    [anon_sym_and] = ACTIONS(2780),
    [anon_sym_as] = ACTIONS(2780),
    [anon_sym_with] = ACTIONS(2780),
    [anon_sym_do] = ACTIONS(2780),
    [anon_sym_while] = ACTIONS(2780),
    [anon_sym_until] = ACTIONS(2780),
    [anon_sym_repeat] = ACTIONS(2780),
    [anon_sym_when] = ACTIONS(2780),
    [anon_sym_if] = ACTIONS(2780),
    [anon_sym_unless] = ACTIONS(2780),
    [anon_sym_always] = ACTIONS(2780),
    [anon_sym_thereis] = ACTIONS(2780),
    [anon_sym_never] = ACTIONS(2780),
    [anon_sym_else] = ACTIONS(2780),
    [anon_sym_finally] = ACTIONS(2780),
    [anon_sym_return] = ACTIONS(2780),
    [anon_sym_initially] = ACTIONS(2780),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2782),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [149] = {
    [sym__gap] = STATE(199),
    [sym_dis_expr] = STATE(199),
    [sym__form] = STATE(2083),
    [sym_num_lit] = STATE(2083),
    [sym_kwd_lit] = STATE(2083),
    [sym_str_lit] = STATE(2083),
    [sym_char_lit] = STATE(2083),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2083),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2083),
    [sym_set_lit] = STATE(2083),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2083),
    [sym_splicing_read_cond_lit] = STATE(2083),
    [sym_var_quoting_lit] = STATE(2083),
    [sym_quoting_lit] = STATE(2083),
    [sym_syn_quoting_lit] = STATE(2083),
    [sym_unquote_splicing_lit] = STATE(2083),
    [sym_unquoting_lit] = STATE(2083),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2083),
    [sym_package_lit] = STATE(2083),
    [sym_include_reader_macro] = STATE(2083),
    [sym_complex_num_lit] = STATE(2083),
    [aux_sym_dis_expr_repeat1] = STATE(199),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2784),
    [sym_comment] = ACTIONS(2784),
    [anon_sym_POUND_] = ACTIONS(2758),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2787),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2763),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2787),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2766),
    [anon_sym_POUND_CARET] = ACTIONS(2769),
    [anon_sym_LPAREN] = ACTIONS(2772),
    [anon_sym_RPAREN] = ACTIONS(2775),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2787),
    [anon_sym_cl] = ACTIONS(2777),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2780),
    [anon_sym_for] = ACTIONS(2780),
    [anon_sym_and] = ACTIONS(2780),
    [anon_sym_as] = ACTIONS(2780),
    [anon_sym_with] = ACTIONS(2780),
    [anon_sym_do] = ACTIONS(2780),
    [anon_sym_while] = ACTIONS(2780),
    [anon_sym_until] = ACTIONS(2780),
    [anon_sym_repeat] = ACTIONS(2780),
    [anon_sym_when] = ACTIONS(2780),
    [anon_sym_if] = ACTIONS(2780),
    [anon_sym_unless] = ACTIONS(2780),
    [anon_sym_always] = ACTIONS(2780),
    [anon_sym_thereis] = ACTIONS(2780),
    [anon_sym_never] = ACTIONS(2780),
    [anon_sym_else] = ACTIONS(2780),
    [anon_sym_finally] = ACTIONS(2780),
    [anon_sym_return] = ACTIONS(2780),
    [anon_sym_initially] = ACTIONS(2780),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2789),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [150] = {
    [sym__gap] = STATE(200),
    [sym_dis_expr] = STATE(200),
    [sym__form] = STATE(2085),
    [sym_num_lit] = STATE(2085),
    [sym_kwd_lit] = STATE(2085),
    [sym_str_lit] = STATE(2085),
    [sym_char_lit] = STATE(2085),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2085),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2085),
    [sym_set_lit] = STATE(2085),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2085),
    [sym_splicing_read_cond_lit] = STATE(2085),
    [sym_var_quoting_lit] = STATE(2085),
    [sym_quoting_lit] = STATE(2085),
    [sym_syn_quoting_lit] = STATE(2085),
    [sym_unquote_splicing_lit] = STATE(2085),
    [sym_unquoting_lit] = STATE(2085),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2085),
    [sym_package_lit] = STATE(2085),
    [sym_include_reader_macro] = STATE(2085),
    [sym_complex_num_lit] = STATE(2085),
    [aux_sym_dis_expr_repeat1] = STATE(200),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2791),
    [sym_comment] = ACTIONS(2791),
    [anon_sym_POUND_] = ACTIONS(2758),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2794),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2763),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2794),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2766),
    [anon_sym_POUND_CARET] = ACTIONS(2769),
    [anon_sym_LPAREN] = ACTIONS(2772),
    [anon_sym_RPAREN] = ACTIONS(2775),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2794),
    [anon_sym_cl] = ACTIONS(2777),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2780),
    [anon_sym_for] = ACTIONS(2780),
    [anon_sym_and] = ACTIONS(2780),
    [anon_sym_as] = ACTIONS(2780),
    [anon_sym_with] = ACTIONS(2780),
    [anon_sym_do] = ACTIONS(2780),
    [anon_sym_while] = ACTIONS(2780),
    [anon_sym_until] = ACTIONS(2780),
    [anon_sym_repeat] = ACTIONS(2780),
    [anon_sym_when] = ACTIONS(2780),
    [anon_sym_if] = ACTIONS(2780),
    [anon_sym_unless] = ACTIONS(2780),
    [anon_sym_always] = ACTIONS(2780),
    [anon_sym_thereis] = ACTIONS(2780),
    [anon_sym_never] = ACTIONS(2780),
    [anon_sym_else] = ACTIONS(2780),
    [anon_sym_finally] = ACTIONS(2780),
    [anon_sym_return] = ACTIONS(2780),
    [anon_sym_initially] = ACTIONS(2780),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2796),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [151] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2088),
    [sym_num_lit] = STATE(2088),
    [sym_kwd_lit] = STATE(2088),
    [sym_str_lit] = STATE(2088),
    [sym_char_lit] = STATE(2088),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2088),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2088),
    [sym_set_lit] = STATE(2088),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2088),
    [sym_splicing_read_cond_lit] = STATE(2088),
    [sym_var_quoting_lit] = STATE(2088),
    [sym_quoting_lit] = STATE(2088),
    [sym_syn_quoting_lit] = STATE(2088),
    [sym_unquote_splicing_lit] = STATE(2088),
    [sym_unquoting_lit] = STATE(2088),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2088),
    [sym_package_lit] = STATE(2088),
    [sym_include_reader_macro] = STATE(2088),
    [sym_complex_num_lit] = STATE(2088),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2755),
    [sym_comment] = ACTIONS(2755),
    [anon_sym_POUND_] = ACTIONS(2758),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2798),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2763),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2798),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2766),
    [anon_sym_POUND_CARET] = ACTIONS(2769),
    [anon_sym_LPAREN] = ACTIONS(2772),
    [anon_sym_RPAREN] = ACTIONS(2775),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2798),
    [anon_sym_cl] = ACTIONS(2777),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2780),
    [anon_sym_for] = ACTIONS(2780),
    [anon_sym_and] = ACTIONS(2780),
    [anon_sym_as] = ACTIONS(2780),
    [anon_sym_with] = ACTIONS(2780),
    [anon_sym_do] = ACTIONS(2780),
    [anon_sym_while] = ACTIONS(2780),
    [anon_sym_until] = ACTIONS(2780),
    [anon_sym_repeat] = ACTIONS(2780),
    [anon_sym_when] = ACTIONS(2780),
    [anon_sym_if] = ACTIONS(2780),
    [anon_sym_unless] = ACTIONS(2780),
    [anon_sym_always] = ACTIONS(2780),
    [anon_sym_thereis] = ACTIONS(2780),
    [anon_sym_never] = ACTIONS(2780),
    [anon_sym_else] = ACTIONS(2780),
    [anon_sym_finally] = ACTIONS(2780),
    [anon_sym_return] = ACTIONS(2780),
    [anon_sym_initially] = ACTIONS(2780),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2800),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [152] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2091),
    [sym_num_lit] = STATE(2091),
    [sym_kwd_lit] = STATE(2091),
    [sym_str_lit] = STATE(2091),
    [sym_char_lit] = STATE(2091),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2091),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2091),
    [sym_set_lit] = STATE(2091),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2091),
    [sym_splicing_read_cond_lit] = STATE(2091),
    [sym_var_quoting_lit] = STATE(2091),
    [sym_quoting_lit] = STATE(2091),
    [sym_syn_quoting_lit] = STATE(2091),
    [sym_unquote_splicing_lit] = STATE(2091),
    [sym_unquoting_lit] = STATE(2091),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2091),
    [sym_package_lit] = STATE(2091),
    [sym_include_reader_macro] = STATE(2091),
    [sym_complex_num_lit] = STATE(2091),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2298),
    [sym_comment] = ACTIONS(2298),
    [anon_sym_POUND_] = ACTIONS(2301),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2802),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2306),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2802),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2309),
    [anon_sym_POUND_CARET] = ACTIONS(2312),
    [anon_sym_LPAREN] = ACTIONS(2315),
    [anon_sym_RPAREN] = ACTIONS(2318),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2802),
    [anon_sym_cl] = ACTIONS(2320),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2323),
    [anon_sym_for] = ACTIONS(2323),
    [anon_sym_and] = ACTIONS(2323),
    [anon_sym_as] = ACTIONS(2323),
    [anon_sym_with] = ACTIONS(2323),
    [anon_sym_do] = ACTIONS(2323),
    [anon_sym_while] = ACTIONS(2323),
    [anon_sym_until] = ACTIONS(2323),
    [anon_sym_repeat] = ACTIONS(2323),
    [anon_sym_when] = ACTIONS(2323),
    [anon_sym_if] = ACTIONS(2323),
    [anon_sym_unless] = ACTIONS(2323),
    [anon_sym_always] = ACTIONS(2323),
    [anon_sym_thereis] = ACTIONS(2323),
    [anon_sym_never] = ACTIONS(2323),
    [anon_sym_else] = ACTIONS(2323),
    [anon_sym_finally] = ACTIONS(2323),
    [anon_sym_return] = ACTIONS(2323),
    [anon_sym_initially] = ACTIONS(2323),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2804),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [153] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2093),
    [sym_num_lit] = STATE(2093),
    [sym_kwd_lit] = STATE(2093),
    [sym_str_lit] = STATE(2093),
    [sym_char_lit] = STATE(2093),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2093),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2093),
    [sym_set_lit] = STATE(2093),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2093),
    [sym_splicing_read_cond_lit] = STATE(2093),
    [sym_var_quoting_lit] = STATE(2093),
    [sym_quoting_lit] = STATE(2093),
    [sym_syn_quoting_lit] = STATE(2093),
    [sym_unquote_splicing_lit] = STATE(2093),
    [sym_unquoting_lit] = STATE(2093),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2093),
    [sym_package_lit] = STATE(2093),
    [sym_include_reader_macro] = STATE(2093),
    [sym_complex_num_lit] = STATE(2093),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2327),
    [sym_comment] = ACTIONS(2327),
    [anon_sym_POUND_] = ACTIONS(2330),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2806),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2335),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2806),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2338),
    [anon_sym_POUND_CARET] = ACTIONS(2341),
    [anon_sym_LPAREN] = ACTIONS(2344),
    [anon_sym_RPAREN] = ACTIONS(2347),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2806),
    [anon_sym_cl] = ACTIONS(2349),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2352),
    [anon_sym_for] = ACTIONS(2352),
    [anon_sym_and] = ACTIONS(2352),
    [anon_sym_as] = ACTIONS(2352),
    [anon_sym_with] = ACTIONS(2352),
    [anon_sym_do] = ACTIONS(2352),
    [anon_sym_while] = ACTIONS(2352),
    [anon_sym_until] = ACTIONS(2352),
    [anon_sym_repeat] = ACTIONS(2352),
    [anon_sym_when] = ACTIONS(2352),
    [anon_sym_if] = ACTIONS(2352),
    [anon_sym_unless] = ACTIONS(2352),
    [anon_sym_always] = ACTIONS(2352),
    [anon_sym_thereis] = ACTIONS(2352),
    [anon_sym_never] = ACTIONS(2352),
    [anon_sym_else] = ACTIONS(2352),
    [anon_sym_finally] = ACTIONS(2352),
    [anon_sym_return] = ACTIONS(2352),
    [anon_sym_initially] = ACTIONS(2352),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2808),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [154] = {
    [sym__gap] = STATE(202),
    [sym_dis_expr] = STATE(202),
    [sym__form] = STATE(2094),
    [sym_num_lit] = STATE(2094),
    [sym_kwd_lit] = STATE(2094),
    [sym_str_lit] = STATE(2094),
    [sym_char_lit] = STATE(2094),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2094),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2094),
    [sym_set_lit] = STATE(2094),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2094),
    [sym_splicing_read_cond_lit] = STATE(2094),
    [sym_var_quoting_lit] = STATE(2094),
    [sym_quoting_lit] = STATE(2094),
    [sym_syn_quoting_lit] = STATE(2094),
    [sym_unquote_splicing_lit] = STATE(2094),
    [sym_unquoting_lit] = STATE(2094),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2094),
    [sym_package_lit] = STATE(2094),
    [sym_include_reader_macro] = STATE(2094),
    [sym_complex_num_lit] = STATE(2094),
    [aux_sym_dis_expr_repeat1] = STATE(202),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2810),
    [sym_comment] = ACTIONS(2810),
    [anon_sym_POUND_] = ACTIONS(2330),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2813),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2335),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2813),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2338),
    [anon_sym_POUND_CARET] = ACTIONS(2341),
    [anon_sym_LPAREN] = ACTIONS(2344),
    [anon_sym_RPAREN] = ACTIONS(2347),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2813),
    [anon_sym_cl] = ACTIONS(2349),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2352),
    [anon_sym_for] = ACTIONS(2352),
    [anon_sym_and] = ACTIONS(2352),
    [anon_sym_as] = ACTIONS(2352),
    [anon_sym_with] = ACTIONS(2352),
    [anon_sym_do] = ACTIONS(2352),
    [anon_sym_while] = ACTIONS(2352),
    [anon_sym_until] = ACTIONS(2352),
    [anon_sym_repeat] = ACTIONS(2352),
    [anon_sym_when] = ACTIONS(2352),
    [anon_sym_if] = ACTIONS(2352),
    [anon_sym_unless] = ACTIONS(2352),
    [anon_sym_always] = ACTIONS(2352),
    [anon_sym_thereis] = ACTIONS(2352),
    [anon_sym_never] = ACTIONS(2352),
    [anon_sym_else] = ACTIONS(2352),
    [anon_sym_finally] = ACTIONS(2352),
    [anon_sym_return] = ACTIONS(2352),
    [anon_sym_initially] = ACTIONS(2352),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2815),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [155] = {
    [sym__gap] = STATE(203),
    [sym_dis_expr] = STATE(203),
    [sym__form] = STATE(2097),
    [sym_num_lit] = STATE(2097),
    [sym_kwd_lit] = STATE(2097),
    [sym_str_lit] = STATE(2097),
    [sym_char_lit] = STATE(2097),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2097),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2097),
    [sym_set_lit] = STATE(2097),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2097),
    [sym_splicing_read_cond_lit] = STATE(2097),
    [sym_var_quoting_lit] = STATE(2097),
    [sym_quoting_lit] = STATE(2097),
    [sym_syn_quoting_lit] = STATE(2097),
    [sym_unquote_splicing_lit] = STATE(2097),
    [sym_unquoting_lit] = STATE(2097),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2097),
    [sym_package_lit] = STATE(2097),
    [sym_include_reader_macro] = STATE(2097),
    [sym_complex_num_lit] = STATE(2097),
    [aux_sym_dis_expr_repeat1] = STATE(203),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2817),
    [sym_comment] = ACTIONS(2817),
    [anon_sym_POUND_] = ACTIONS(2330),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2820),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2335),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2820),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2338),
    [anon_sym_POUND_CARET] = ACTIONS(2341),
    [anon_sym_LPAREN] = ACTIONS(2344),
    [anon_sym_RPAREN] = ACTIONS(2347),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2820),
    [anon_sym_cl] = ACTIONS(2349),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2352),
    [anon_sym_for] = ACTIONS(2352),
    [anon_sym_and] = ACTIONS(2352),
    [anon_sym_as] = ACTIONS(2352),
    [anon_sym_with] = ACTIONS(2352),
    [anon_sym_do] = ACTIONS(2352),
    [anon_sym_while] = ACTIONS(2352),
    [anon_sym_until] = ACTIONS(2352),
    [anon_sym_repeat] = ACTIONS(2352),
    [anon_sym_when] = ACTIONS(2352),
    [anon_sym_if] = ACTIONS(2352),
    [anon_sym_unless] = ACTIONS(2352),
    [anon_sym_always] = ACTIONS(2352),
    [anon_sym_thereis] = ACTIONS(2352),
    [anon_sym_never] = ACTIONS(2352),
    [anon_sym_else] = ACTIONS(2352),
    [anon_sym_finally] = ACTIONS(2352),
    [anon_sym_return] = ACTIONS(2352),
    [anon_sym_initially] = ACTIONS(2352),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2822),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [156] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2109),
    [sym_num_lit] = STATE(2109),
    [sym_kwd_lit] = STATE(2109),
    [sym_str_lit] = STATE(2109),
    [sym_char_lit] = STATE(2109),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2109),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2109),
    [sym_set_lit] = STATE(2109),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2109),
    [sym_splicing_read_cond_lit] = STATE(2109),
    [sym_var_quoting_lit] = STATE(2109),
    [sym_quoting_lit] = STATE(2109),
    [sym_syn_quoting_lit] = STATE(2109),
    [sym_unquote_splicing_lit] = STATE(2109),
    [sym_unquoting_lit] = STATE(2109),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2109),
    [sym_package_lit] = STATE(2109),
    [sym_include_reader_macro] = STATE(2109),
    [sym_complex_num_lit] = STATE(2109),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2327),
    [sym_comment] = ACTIONS(2327),
    [anon_sym_POUND_] = ACTIONS(2330),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2824),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2335),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2824),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2338),
    [anon_sym_POUND_CARET] = ACTIONS(2341),
    [anon_sym_LPAREN] = ACTIONS(2344),
    [anon_sym_RPAREN] = ACTIONS(2347),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2824),
    [anon_sym_cl] = ACTIONS(2349),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2352),
    [anon_sym_for] = ACTIONS(2352),
    [anon_sym_and] = ACTIONS(2352),
    [anon_sym_as] = ACTIONS(2352),
    [anon_sym_with] = ACTIONS(2352),
    [anon_sym_do] = ACTIONS(2352),
    [anon_sym_while] = ACTIONS(2352),
    [anon_sym_until] = ACTIONS(2352),
    [anon_sym_repeat] = ACTIONS(2352),
    [anon_sym_when] = ACTIONS(2352),
    [anon_sym_if] = ACTIONS(2352),
    [anon_sym_unless] = ACTIONS(2352),
    [anon_sym_always] = ACTIONS(2352),
    [anon_sym_thereis] = ACTIONS(2352),
    [anon_sym_never] = ACTIONS(2352),
    [anon_sym_else] = ACTIONS(2352),
    [anon_sym_finally] = ACTIONS(2352),
    [anon_sym_return] = ACTIONS(2352),
    [anon_sym_initially] = ACTIONS(2352),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2826),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [157] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2113),
    [sym_num_lit] = STATE(2113),
    [sym_kwd_lit] = STATE(2113),
    [sym_str_lit] = STATE(2113),
    [sym_char_lit] = STATE(2113),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2113),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2113),
    [sym_set_lit] = STATE(2113),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2113),
    [sym_splicing_read_cond_lit] = STATE(2113),
    [sym_var_quoting_lit] = STATE(2113),
    [sym_quoting_lit] = STATE(2113),
    [sym_syn_quoting_lit] = STATE(2113),
    [sym_unquote_splicing_lit] = STATE(2113),
    [sym_unquoting_lit] = STATE(2113),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2113),
    [sym_package_lit] = STATE(2113),
    [sym_include_reader_macro] = STATE(2113),
    [sym_complex_num_lit] = STATE(2113),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2298),
    [sym_comment] = ACTIONS(2298),
    [anon_sym_POUND_] = ACTIONS(2301),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2828),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2306),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2828),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2309),
    [anon_sym_POUND_CARET] = ACTIONS(2312),
    [anon_sym_LPAREN] = ACTIONS(2315),
    [anon_sym_RPAREN] = ACTIONS(2318),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2828),
    [anon_sym_cl] = ACTIONS(2320),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2323),
    [anon_sym_for] = ACTIONS(2323),
    [anon_sym_and] = ACTIONS(2323),
    [anon_sym_as] = ACTIONS(2323),
    [anon_sym_with] = ACTIONS(2323),
    [anon_sym_do] = ACTIONS(2323),
    [anon_sym_while] = ACTIONS(2323),
    [anon_sym_until] = ACTIONS(2323),
    [anon_sym_repeat] = ACTIONS(2323),
    [anon_sym_when] = ACTIONS(2323),
    [anon_sym_if] = ACTIONS(2323),
    [anon_sym_unless] = ACTIONS(2323),
    [anon_sym_always] = ACTIONS(2323),
    [anon_sym_thereis] = ACTIONS(2323),
    [anon_sym_never] = ACTIONS(2323),
    [anon_sym_else] = ACTIONS(2323),
    [anon_sym_finally] = ACTIONS(2323),
    [anon_sym_return] = ACTIONS(2323),
    [anon_sym_initially] = ACTIONS(2323),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2830),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [158] = {
    [sym__gap] = STATE(205),
    [sym_dis_expr] = STATE(205),
    [sym__form] = STATE(2114),
    [sym_num_lit] = STATE(2114),
    [sym_kwd_lit] = STATE(2114),
    [sym_str_lit] = STATE(2114),
    [sym_char_lit] = STATE(2114),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2114),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2114),
    [sym_set_lit] = STATE(2114),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2114),
    [sym_splicing_read_cond_lit] = STATE(2114),
    [sym_var_quoting_lit] = STATE(2114),
    [sym_quoting_lit] = STATE(2114),
    [sym_syn_quoting_lit] = STATE(2114),
    [sym_unquote_splicing_lit] = STATE(2114),
    [sym_unquoting_lit] = STATE(2114),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2114),
    [sym_package_lit] = STATE(2114),
    [sym_include_reader_macro] = STATE(2114),
    [sym_complex_num_lit] = STATE(2114),
    [aux_sym_dis_expr_repeat1] = STATE(205),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2832),
    [sym_comment] = ACTIONS(2832),
    [anon_sym_POUND_] = ACTIONS(2301),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2835),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2306),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2835),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2309),
    [anon_sym_POUND_CARET] = ACTIONS(2312),
    [anon_sym_LPAREN] = ACTIONS(2315),
    [anon_sym_RPAREN] = ACTIONS(2318),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2835),
    [anon_sym_cl] = ACTIONS(2320),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2323),
    [anon_sym_for] = ACTIONS(2323),
    [anon_sym_and] = ACTIONS(2323),
    [anon_sym_as] = ACTIONS(2323),
    [anon_sym_with] = ACTIONS(2323),
    [anon_sym_do] = ACTIONS(2323),
    [anon_sym_while] = ACTIONS(2323),
    [anon_sym_until] = ACTIONS(2323),
    [anon_sym_repeat] = ACTIONS(2323),
    [anon_sym_when] = ACTIONS(2323),
    [anon_sym_if] = ACTIONS(2323),
    [anon_sym_unless] = ACTIONS(2323),
    [anon_sym_always] = ACTIONS(2323),
    [anon_sym_thereis] = ACTIONS(2323),
    [anon_sym_never] = ACTIONS(2323),
    [anon_sym_else] = ACTIONS(2323),
    [anon_sym_finally] = ACTIONS(2323),
    [anon_sym_return] = ACTIONS(2323),
    [anon_sym_initially] = ACTIONS(2323),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2837),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [159] = {
    [sym__gap] = STATE(206),
    [sym_dis_expr] = STATE(206),
    [sym__form] = STATE(2118),
    [sym_num_lit] = STATE(2118),
    [sym_kwd_lit] = STATE(2118),
    [sym_str_lit] = STATE(2118),
    [sym_char_lit] = STATE(2118),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2118),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2118),
    [sym_set_lit] = STATE(2118),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2118),
    [sym_splicing_read_cond_lit] = STATE(2118),
    [sym_var_quoting_lit] = STATE(2118),
    [sym_quoting_lit] = STATE(2118),
    [sym_syn_quoting_lit] = STATE(2118),
    [sym_unquote_splicing_lit] = STATE(2118),
    [sym_unquoting_lit] = STATE(2118),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2118),
    [sym_package_lit] = STATE(2118),
    [sym_include_reader_macro] = STATE(2118),
    [sym_complex_num_lit] = STATE(2118),
    [aux_sym_dis_expr_repeat1] = STATE(206),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2839),
    [sym_comment] = ACTIONS(2839),
    [anon_sym_POUND_] = ACTIONS(2388),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2842),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2393),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2842),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2396),
    [anon_sym_POUND_CARET] = ACTIONS(2399),
    [anon_sym_LPAREN] = ACTIONS(2402),
    [anon_sym_RPAREN] = ACTIONS(2405),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2842),
    [anon_sym_cl] = ACTIONS(2407),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2410),
    [anon_sym_for] = ACTIONS(2410),
    [anon_sym_and] = ACTIONS(2410),
    [anon_sym_as] = ACTIONS(2410),
    [anon_sym_with] = ACTIONS(2410),
    [anon_sym_do] = ACTIONS(2410),
    [anon_sym_while] = ACTIONS(2410),
    [anon_sym_until] = ACTIONS(2410),
    [anon_sym_repeat] = ACTIONS(2410),
    [anon_sym_when] = ACTIONS(2410),
    [anon_sym_if] = ACTIONS(2410),
    [anon_sym_unless] = ACTIONS(2410),
    [anon_sym_always] = ACTIONS(2410),
    [anon_sym_thereis] = ACTIONS(2410),
    [anon_sym_never] = ACTIONS(2410),
    [anon_sym_else] = ACTIONS(2410),
    [anon_sym_finally] = ACTIONS(2410),
    [anon_sym_return] = ACTIONS(2410),
    [anon_sym_initially] = ACTIONS(2410),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2844),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [160] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2133),
    [sym_num_lit] = STATE(2133),
    [sym_kwd_lit] = STATE(2133),
    [sym_str_lit] = STATE(2133),
    [sym_char_lit] = STATE(2133),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2133),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2133),
    [sym_set_lit] = STATE(2133),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2133),
    [sym_splicing_read_cond_lit] = STATE(2133),
    [sym_var_quoting_lit] = STATE(2133),
    [sym_quoting_lit] = STATE(2133),
    [sym_syn_quoting_lit] = STATE(2133),
    [sym_unquote_splicing_lit] = STATE(2133),
    [sym_unquoting_lit] = STATE(2133),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2133),
    [sym_package_lit] = STATE(2133),
    [sym_include_reader_macro] = STATE(2133),
    [sym_complex_num_lit] = STATE(2133),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2414),
    [sym_comment] = ACTIONS(2414),
    [anon_sym_POUND_] = ACTIONS(2388),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2846),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2393),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2846),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2396),
    [anon_sym_POUND_CARET] = ACTIONS(2399),
    [anon_sym_LPAREN] = ACTIONS(2402),
    [anon_sym_RPAREN] = ACTIONS(2405),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2846),
    [anon_sym_cl] = ACTIONS(2407),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2410),
    [anon_sym_for] = ACTIONS(2410),
    [anon_sym_and] = ACTIONS(2410),
    [anon_sym_as] = ACTIONS(2410),
    [anon_sym_with] = ACTIONS(2410),
    [anon_sym_do] = ACTIONS(2410),
    [anon_sym_while] = ACTIONS(2410),
    [anon_sym_until] = ACTIONS(2410),
    [anon_sym_repeat] = ACTIONS(2410),
    [anon_sym_when] = ACTIONS(2410),
    [anon_sym_if] = ACTIONS(2410),
    [anon_sym_unless] = ACTIONS(2410),
    [anon_sym_always] = ACTIONS(2410),
    [anon_sym_thereis] = ACTIONS(2410),
    [anon_sym_never] = ACTIONS(2410),
    [anon_sym_else] = ACTIONS(2410),
    [anon_sym_finally] = ACTIONS(2410),
    [anon_sym_return] = ACTIONS(2410),
    [anon_sym_initially] = ACTIONS(2410),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2848),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [161] = {
    [sym__gap] = STATE(209),
    [sym_dis_expr] = STATE(209),
    [sym__form] = STATE(2137),
    [sym_num_lit] = STATE(2137),
    [sym_kwd_lit] = STATE(2137),
    [sym_str_lit] = STATE(2137),
    [sym_char_lit] = STATE(2137),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2137),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2137),
    [sym_set_lit] = STATE(2137),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2137),
    [sym_splicing_read_cond_lit] = STATE(2137),
    [sym_var_quoting_lit] = STATE(2137),
    [sym_quoting_lit] = STATE(2137),
    [sym_syn_quoting_lit] = STATE(2137),
    [sym_unquote_splicing_lit] = STATE(2137),
    [sym_unquoting_lit] = STATE(2137),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2137),
    [sym_package_lit] = STATE(2137),
    [sym_include_reader_macro] = STATE(2137),
    [sym_complex_num_lit] = STATE(2137),
    [aux_sym_dis_expr_repeat1] = STATE(209),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2850),
    [sym_comment] = ACTIONS(2850),
    [anon_sym_POUND_] = ACTIONS(2388),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2853),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2393),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2853),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2396),
    [anon_sym_POUND_CARET] = ACTIONS(2399),
    [anon_sym_LPAREN] = ACTIONS(2402),
    [anon_sym_RPAREN] = ACTIONS(2405),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2853),
    [anon_sym_cl] = ACTIONS(2407),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2410),
    [anon_sym_for] = ACTIONS(2410),
    [anon_sym_and] = ACTIONS(2410),
    [anon_sym_as] = ACTIONS(2410),
    [anon_sym_with] = ACTIONS(2410),
    [anon_sym_do] = ACTIONS(2410),
    [anon_sym_while] = ACTIONS(2410),
    [anon_sym_until] = ACTIONS(2410),
    [anon_sym_repeat] = ACTIONS(2410),
    [anon_sym_when] = ACTIONS(2410),
    [anon_sym_if] = ACTIONS(2410),
    [anon_sym_unless] = ACTIONS(2410),
    [anon_sym_always] = ACTIONS(2410),
    [anon_sym_thereis] = ACTIONS(2410),
    [anon_sym_never] = ACTIONS(2410),
    [anon_sym_else] = ACTIONS(2410),
    [anon_sym_finally] = ACTIONS(2410),
    [anon_sym_return] = ACTIONS(2410),
    [anon_sym_initially] = ACTIONS(2410),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2855),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [162] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2204),
    [sym_num_lit] = STATE(2204),
    [sym_kwd_lit] = STATE(2204),
    [sym_str_lit] = STATE(2204),
    [sym_char_lit] = STATE(2204),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2204),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2204),
    [sym_set_lit] = STATE(2204),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2204),
    [sym_splicing_read_cond_lit] = STATE(2204),
    [sym_var_quoting_lit] = STATE(2204),
    [sym_quoting_lit] = STATE(2204),
    [sym_syn_quoting_lit] = STATE(2204),
    [sym_unquote_splicing_lit] = STATE(2204),
    [sym_unquoting_lit] = STATE(2204),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2204),
    [sym_package_lit] = STATE(2204),
    [sym_include_reader_macro] = STATE(2204),
    [sym_complex_num_lit] = STATE(2204),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2857),
    [sym_comment] = ACTIONS(2857),
    [anon_sym_POUND_] = ACTIONS(2860),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2863),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2865),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2863),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2868),
    [anon_sym_POUND_CARET] = ACTIONS(2871),
    [anon_sym_LPAREN] = ACTIONS(2874),
    [anon_sym_RPAREN] = ACTIONS(2877),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2863),
    [anon_sym_cl] = ACTIONS(2879),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2882),
    [anon_sym_for] = ACTIONS(2882),
    [anon_sym_and] = ACTIONS(2882),
    [anon_sym_as] = ACTIONS(2882),
    [anon_sym_with] = ACTIONS(2882),
    [anon_sym_do] = ACTIONS(2882),
    [anon_sym_while] = ACTIONS(2882),
    [anon_sym_until] = ACTIONS(2882),
    [anon_sym_repeat] = ACTIONS(2882),
    [anon_sym_when] = ACTIONS(2882),
    [anon_sym_if] = ACTIONS(2882),
    [anon_sym_unless] = ACTIONS(2882),
    [anon_sym_always] = ACTIONS(2882),
    [anon_sym_thereis] = ACTIONS(2882),
    [anon_sym_never] = ACTIONS(2882),
    [anon_sym_else] = ACTIONS(2882),
    [anon_sym_finally] = ACTIONS(2882),
    [anon_sym_return] = ACTIONS(2882),
    [anon_sym_initially] = ACTIONS(2882),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2884),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [163] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2206),
    [sym_num_lit] = STATE(2206),
    [sym_kwd_lit] = STATE(2206),
    [sym_str_lit] = STATE(2206),
    [sym_char_lit] = STATE(2206),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2206),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2206),
    [sym_set_lit] = STATE(2206),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2206),
    [sym_splicing_read_cond_lit] = STATE(2206),
    [sym_var_quoting_lit] = STATE(2206),
    [sym_quoting_lit] = STATE(2206),
    [sym_syn_quoting_lit] = STATE(2206),
    [sym_unquote_splicing_lit] = STATE(2206),
    [sym_unquoting_lit] = STATE(2206),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2206),
    [sym_package_lit] = STATE(2206),
    [sym_include_reader_macro] = STATE(2206),
    [sym_complex_num_lit] = STATE(2206),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2857),
    [sym_comment] = ACTIONS(2857),
    [anon_sym_POUND_] = ACTIONS(2860),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2886),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2865),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2886),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2868),
    [anon_sym_POUND_CARET] = ACTIONS(2871),
    [anon_sym_LPAREN] = ACTIONS(2874),
    [anon_sym_RPAREN] = ACTIONS(2877),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2886),
    [anon_sym_cl] = ACTIONS(2879),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2882),
    [anon_sym_for] = ACTIONS(2882),
    [anon_sym_and] = ACTIONS(2882),
    [anon_sym_as] = ACTIONS(2882),
    [anon_sym_with] = ACTIONS(2882),
    [anon_sym_do] = ACTIONS(2882),
    [anon_sym_while] = ACTIONS(2882),
    [anon_sym_until] = ACTIONS(2882),
    [anon_sym_repeat] = ACTIONS(2882),
    [anon_sym_when] = ACTIONS(2882),
    [anon_sym_if] = ACTIONS(2882),
    [anon_sym_unless] = ACTIONS(2882),
    [anon_sym_always] = ACTIONS(2882),
    [anon_sym_thereis] = ACTIONS(2882),
    [anon_sym_never] = ACTIONS(2882),
    [anon_sym_else] = ACTIONS(2882),
    [anon_sym_finally] = ACTIONS(2882),
    [anon_sym_return] = ACTIONS(2882),
    [anon_sym_initially] = ACTIONS(2882),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2888),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [164] = {
    [sym__gap] = STATE(210),
    [sym_dis_expr] = STATE(210),
    [sym__form] = STATE(2207),
    [sym_num_lit] = STATE(2207),
    [sym_kwd_lit] = STATE(2207),
    [sym_str_lit] = STATE(2207),
    [sym_char_lit] = STATE(2207),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2207),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2207),
    [sym_set_lit] = STATE(2207),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2207),
    [sym_splicing_read_cond_lit] = STATE(2207),
    [sym_var_quoting_lit] = STATE(2207),
    [sym_quoting_lit] = STATE(2207),
    [sym_syn_quoting_lit] = STATE(2207),
    [sym_unquote_splicing_lit] = STATE(2207),
    [sym_unquoting_lit] = STATE(2207),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2207),
    [sym_package_lit] = STATE(2207),
    [sym_include_reader_macro] = STATE(2207),
    [sym_complex_num_lit] = STATE(2207),
    [aux_sym_dis_expr_repeat1] = STATE(210),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2890),
    [sym_comment] = ACTIONS(2890),
    [anon_sym_POUND_] = ACTIONS(2860),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2893),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2865),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2893),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2868),
    [anon_sym_POUND_CARET] = ACTIONS(2871),
    [anon_sym_LPAREN] = ACTIONS(2874),
    [anon_sym_RPAREN] = ACTIONS(2877),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2893),
    [anon_sym_cl] = ACTIONS(2879),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2882),
    [anon_sym_for] = ACTIONS(2882),
    [anon_sym_and] = ACTIONS(2882),
    [anon_sym_as] = ACTIONS(2882),
    [anon_sym_with] = ACTIONS(2882),
    [anon_sym_do] = ACTIONS(2882),
    [anon_sym_while] = ACTIONS(2882),
    [anon_sym_until] = ACTIONS(2882),
    [anon_sym_repeat] = ACTIONS(2882),
    [anon_sym_when] = ACTIONS(2882),
    [anon_sym_if] = ACTIONS(2882),
    [anon_sym_unless] = ACTIONS(2882),
    [anon_sym_always] = ACTIONS(2882),
    [anon_sym_thereis] = ACTIONS(2882),
    [anon_sym_never] = ACTIONS(2882),
    [anon_sym_else] = ACTIONS(2882),
    [anon_sym_finally] = ACTIONS(2882),
    [anon_sym_return] = ACTIONS(2882),
    [anon_sym_initially] = ACTIONS(2882),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2895),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [165] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2213),
    [sym_num_lit] = STATE(2213),
    [sym_kwd_lit] = STATE(2213),
    [sym_str_lit] = STATE(2213),
    [sym_char_lit] = STATE(2213),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2213),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2213),
    [sym_set_lit] = STATE(2213),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2213),
    [sym_splicing_read_cond_lit] = STATE(2213),
    [sym_var_quoting_lit] = STATE(2213),
    [sym_quoting_lit] = STATE(2213),
    [sym_syn_quoting_lit] = STATE(2213),
    [sym_unquote_splicing_lit] = STATE(2213),
    [sym_unquoting_lit] = STATE(2213),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2213),
    [sym_package_lit] = STATE(2213),
    [sym_include_reader_macro] = STATE(2213),
    [sym_complex_num_lit] = STATE(2213),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2897),
    [sym_comment] = ACTIONS(2897),
    [anon_sym_POUND_] = ACTIONS(2900),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2903),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2905),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2903),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2908),
    [anon_sym_POUND_CARET] = ACTIONS(2911),
    [anon_sym_LPAREN] = ACTIONS(2914),
    [anon_sym_RPAREN] = ACTIONS(2917),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2903),
    [anon_sym_cl] = ACTIONS(2919),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2922),
    [anon_sym_for] = ACTIONS(2922),
    [anon_sym_and] = ACTIONS(2922),
    [anon_sym_as] = ACTIONS(2922),
    [anon_sym_with] = ACTIONS(2922),
    [anon_sym_do] = ACTIONS(2922),
    [anon_sym_while] = ACTIONS(2922),
    [anon_sym_until] = ACTIONS(2922),
    [anon_sym_repeat] = ACTIONS(2922),
    [anon_sym_when] = ACTIONS(2922),
    [anon_sym_if] = ACTIONS(2922),
    [anon_sym_unless] = ACTIONS(2922),
    [anon_sym_always] = ACTIONS(2922),
    [anon_sym_thereis] = ACTIONS(2922),
    [anon_sym_never] = ACTIONS(2922),
    [anon_sym_else] = ACTIONS(2922),
    [anon_sym_finally] = ACTIONS(2922),
    [anon_sym_return] = ACTIONS(2922),
    [anon_sym_initially] = ACTIONS(2922),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2924),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [166] = {
    [sym__gap] = STATE(211),
    [sym_dis_expr] = STATE(211),
    [sym__form] = STATE(2214),
    [sym_num_lit] = STATE(2214),
    [sym_kwd_lit] = STATE(2214),
    [sym_str_lit] = STATE(2214),
    [sym_char_lit] = STATE(2214),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2214),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2214),
    [sym_set_lit] = STATE(2214),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2214),
    [sym_splicing_read_cond_lit] = STATE(2214),
    [sym_var_quoting_lit] = STATE(2214),
    [sym_quoting_lit] = STATE(2214),
    [sym_syn_quoting_lit] = STATE(2214),
    [sym_unquote_splicing_lit] = STATE(2214),
    [sym_unquoting_lit] = STATE(2214),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2214),
    [sym_package_lit] = STATE(2214),
    [sym_include_reader_macro] = STATE(2214),
    [sym_complex_num_lit] = STATE(2214),
    [aux_sym_dis_expr_repeat1] = STATE(211),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2926),
    [sym_comment] = ACTIONS(2926),
    [anon_sym_POUND_] = ACTIONS(2900),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2929),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2905),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2929),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2908),
    [anon_sym_POUND_CARET] = ACTIONS(2911),
    [anon_sym_LPAREN] = ACTIONS(2914),
    [anon_sym_RPAREN] = ACTIONS(2917),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2929),
    [anon_sym_cl] = ACTIONS(2919),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2922),
    [anon_sym_for] = ACTIONS(2922),
    [anon_sym_and] = ACTIONS(2922),
    [anon_sym_as] = ACTIONS(2922),
    [anon_sym_with] = ACTIONS(2922),
    [anon_sym_do] = ACTIONS(2922),
    [anon_sym_while] = ACTIONS(2922),
    [anon_sym_until] = ACTIONS(2922),
    [anon_sym_repeat] = ACTIONS(2922),
    [anon_sym_when] = ACTIONS(2922),
    [anon_sym_if] = ACTIONS(2922),
    [anon_sym_unless] = ACTIONS(2922),
    [anon_sym_always] = ACTIONS(2922),
    [anon_sym_thereis] = ACTIONS(2922),
    [anon_sym_never] = ACTIONS(2922),
    [anon_sym_else] = ACTIONS(2922),
    [anon_sym_finally] = ACTIONS(2922),
    [anon_sym_return] = ACTIONS(2922),
    [anon_sym_initially] = ACTIONS(2922),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2931),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [167] = {
    [sym__gap] = STATE(212),
    [sym_dis_expr] = STATE(212),
    [sym__form] = STATE(2217),
    [sym_num_lit] = STATE(2217),
    [sym_kwd_lit] = STATE(2217),
    [sym_str_lit] = STATE(2217),
    [sym_char_lit] = STATE(2217),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2217),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2217),
    [sym_set_lit] = STATE(2217),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2217),
    [sym_splicing_read_cond_lit] = STATE(2217),
    [sym_var_quoting_lit] = STATE(2217),
    [sym_quoting_lit] = STATE(2217),
    [sym_syn_quoting_lit] = STATE(2217),
    [sym_unquote_splicing_lit] = STATE(2217),
    [sym_unquoting_lit] = STATE(2217),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2217),
    [sym_package_lit] = STATE(2217),
    [sym_include_reader_macro] = STATE(2217),
    [sym_complex_num_lit] = STATE(2217),
    [aux_sym_dis_expr_repeat1] = STATE(212),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2933),
    [sym_comment] = ACTIONS(2933),
    [anon_sym_POUND_] = ACTIONS(2900),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2936),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2905),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2936),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2908),
    [anon_sym_POUND_CARET] = ACTIONS(2911),
    [anon_sym_LPAREN] = ACTIONS(2914),
    [anon_sym_RPAREN] = ACTIONS(2917),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2936),
    [anon_sym_cl] = ACTIONS(2919),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2922),
    [anon_sym_for] = ACTIONS(2922),
    [anon_sym_and] = ACTIONS(2922),
    [anon_sym_as] = ACTIONS(2922),
    [anon_sym_with] = ACTIONS(2922),
    [anon_sym_do] = ACTIONS(2922),
    [anon_sym_while] = ACTIONS(2922),
    [anon_sym_until] = ACTIONS(2922),
    [anon_sym_repeat] = ACTIONS(2922),
    [anon_sym_when] = ACTIONS(2922),
    [anon_sym_if] = ACTIONS(2922),
    [anon_sym_unless] = ACTIONS(2922),
    [anon_sym_always] = ACTIONS(2922),
    [anon_sym_thereis] = ACTIONS(2922),
    [anon_sym_never] = ACTIONS(2922),
    [anon_sym_else] = ACTIONS(2922),
    [anon_sym_finally] = ACTIONS(2922),
    [anon_sym_return] = ACTIONS(2922),
    [anon_sym_initially] = ACTIONS(2922),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2938),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [168] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2220),
    [sym_num_lit] = STATE(2220),
    [sym_kwd_lit] = STATE(2220),
    [sym_str_lit] = STATE(2220),
    [sym_char_lit] = STATE(2220),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2220),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2220),
    [sym_set_lit] = STATE(2220),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2220),
    [sym_splicing_read_cond_lit] = STATE(2220),
    [sym_var_quoting_lit] = STATE(2220),
    [sym_quoting_lit] = STATE(2220),
    [sym_syn_quoting_lit] = STATE(2220),
    [sym_unquote_splicing_lit] = STATE(2220),
    [sym_unquoting_lit] = STATE(2220),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2220),
    [sym_package_lit] = STATE(2220),
    [sym_include_reader_macro] = STATE(2220),
    [sym_complex_num_lit] = STATE(2220),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2897),
    [sym_comment] = ACTIONS(2897),
    [anon_sym_POUND_] = ACTIONS(2900),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2940),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2905),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2940),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2908),
    [anon_sym_POUND_CARET] = ACTIONS(2911),
    [anon_sym_LPAREN] = ACTIONS(2914),
    [anon_sym_RPAREN] = ACTIONS(2917),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2940),
    [anon_sym_cl] = ACTIONS(2919),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2922),
    [anon_sym_for] = ACTIONS(2922),
    [anon_sym_and] = ACTIONS(2922),
    [anon_sym_as] = ACTIONS(2922),
    [anon_sym_with] = ACTIONS(2922),
    [anon_sym_do] = ACTIONS(2922),
    [anon_sym_while] = ACTIONS(2922),
    [anon_sym_until] = ACTIONS(2922),
    [anon_sym_repeat] = ACTIONS(2922),
    [anon_sym_when] = ACTIONS(2922),
    [anon_sym_if] = ACTIONS(2922),
    [anon_sym_unless] = ACTIONS(2922),
    [anon_sym_always] = ACTIONS(2922),
    [anon_sym_thereis] = ACTIONS(2922),
    [anon_sym_never] = ACTIONS(2922),
    [anon_sym_else] = ACTIONS(2922),
    [anon_sym_finally] = ACTIONS(2922),
    [anon_sym_return] = ACTIONS(2922),
    [anon_sym_initially] = ACTIONS(2922),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2942),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [169] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2223),
    [sym_num_lit] = STATE(2223),
    [sym_kwd_lit] = STATE(2223),
    [sym_str_lit] = STATE(2223),
    [sym_char_lit] = STATE(2223),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2223),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2223),
    [sym_set_lit] = STATE(2223),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2223),
    [sym_splicing_read_cond_lit] = STATE(2223),
    [sym_var_quoting_lit] = STATE(2223),
    [sym_quoting_lit] = STATE(2223),
    [sym_syn_quoting_lit] = STATE(2223),
    [sym_unquote_splicing_lit] = STATE(2223),
    [sym_unquoting_lit] = STATE(2223),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2223),
    [sym_package_lit] = STATE(2223),
    [sym_include_reader_macro] = STATE(2223),
    [sym_complex_num_lit] = STATE(2223),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2944),
    [sym_comment] = ACTIONS(2944),
    [anon_sym_POUND_] = ACTIONS(2947),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2950),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2952),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2950),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2955),
    [anon_sym_POUND_CARET] = ACTIONS(2958),
    [anon_sym_LPAREN] = ACTIONS(2961),
    [anon_sym_RPAREN] = ACTIONS(2964),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2950),
    [anon_sym_cl] = ACTIONS(2966),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2969),
    [anon_sym_for] = ACTIONS(2969),
    [anon_sym_and] = ACTIONS(2969),
    [anon_sym_as] = ACTIONS(2969),
    [anon_sym_with] = ACTIONS(2969),
    [anon_sym_do] = ACTIONS(2969),
    [anon_sym_while] = ACTIONS(2969),
    [anon_sym_until] = ACTIONS(2969),
    [anon_sym_repeat] = ACTIONS(2969),
    [anon_sym_when] = ACTIONS(2969),
    [anon_sym_if] = ACTIONS(2969),
    [anon_sym_unless] = ACTIONS(2969),
    [anon_sym_always] = ACTIONS(2969),
    [anon_sym_thereis] = ACTIONS(2969),
    [anon_sym_never] = ACTIONS(2969),
    [anon_sym_else] = ACTIONS(2969),
    [anon_sym_finally] = ACTIONS(2969),
    [anon_sym_return] = ACTIONS(2969),
    [anon_sym_initially] = ACTIONS(2969),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(2971),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [170] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2225),
    [sym_num_lit] = STATE(2225),
    [sym_kwd_lit] = STATE(2225),
    [sym_str_lit] = STATE(2225),
    [sym_char_lit] = STATE(2225),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2225),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2225),
    [sym_set_lit] = STATE(2225),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2225),
    [sym_splicing_read_cond_lit] = STATE(2225),
    [sym_var_quoting_lit] = STATE(2225),
    [sym_quoting_lit] = STATE(2225),
    [sym_syn_quoting_lit] = STATE(2225),
    [sym_unquote_splicing_lit] = STATE(2225),
    [sym_unquoting_lit] = STATE(2225),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2225),
    [sym_package_lit] = STATE(2225),
    [sym_include_reader_macro] = STATE(2225),
    [sym_complex_num_lit] = STATE(2225),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2973),
    [sym_comment] = ACTIONS(2973),
    [anon_sym_POUND_] = ACTIONS(2976),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(2979),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2981),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(2979),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2984),
    [anon_sym_POUND_CARET] = ACTIONS(2987),
    [anon_sym_LPAREN] = ACTIONS(2990),
    [anon_sym_RPAREN] = ACTIONS(2993),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(2979),
    [anon_sym_cl] = ACTIONS(2995),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2998),
    [anon_sym_for] = ACTIONS(2998),
    [anon_sym_and] = ACTIONS(2998),
    [anon_sym_as] = ACTIONS(2998),
    [anon_sym_with] = ACTIONS(2998),
    [anon_sym_do] = ACTIONS(2998),
    [anon_sym_while] = ACTIONS(2998),
    [anon_sym_until] = ACTIONS(2998),
    [anon_sym_repeat] = ACTIONS(2998),
    [anon_sym_when] = ACTIONS(2998),
    [anon_sym_if] = ACTIONS(2998),
    [anon_sym_unless] = ACTIONS(2998),
    [anon_sym_always] = ACTIONS(2998),
    [anon_sym_thereis] = ACTIONS(2998),
    [anon_sym_never] = ACTIONS(2998),
    [anon_sym_else] = ACTIONS(2998),
    [anon_sym_finally] = ACTIONS(2998),
    [anon_sym_return] = ACTIONS(2998),
    [anon_sym_initially] = ACTIONS(2998),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3000),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [171] = {
    [sym__gap] = STATE(214),
    [sym_dis_expr] = STATE(214),
    [sym__form] = STATE(2226),
    [sym_num_lit] = STATE(2226),
    [sym_kwd_lit] = STATE(2226),
    [sym_str_lit] = STATE(2226),
    [sym_char_lit] = STATE(2226),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2226),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2226),
    [sym_set_lit] = STATE(2226),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2226),
    [sym_splicing_read_cond_lit] = STATE(2226),
    [sym_var_quoting_lit] = STATE(2226),
    [sym_quoting_lit] = STATE(2226),
    [sym_syn_quoting_lit] = STATE(2226),
    [sym_unquote_splicing_lit] = STATE(2226),
    [sym_unquoting_lit] = STATE(2226),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2226),
    [sym_package_lit] = STATE(2226),
    [sym_include_reader_macro] = STATE(2226),
    [sym_complex_num_lit] = STATE(2226),
    [aux_sym_dis_expr_repeat1] = STATE(214),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(3002),
    [sym_comment] = ACTIONS(3002),
    [anon_sym_POUND_] = ACTIONS(2976),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3005),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2981),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3005),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2984),
    [anon_sym_POUND_CARET] = ACTIONS(2987),
    [anon_sym_LPAREN] = ACTIONS(2990),
    [anon_sym_RPAREN] = ACTIONS(2993),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3005),
    [anon_sym_cl] = ACTIONS(2995),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2998),
    [anon_sym_for] = ACTIONS(2998),
    [anon_sym_and] = ACTIONS(2998),
    [anon_sym_as] = ACTIONS(2998),
    [anon_sym_with] = ACTIONS(2998),
    [anon_sym_do] = ACTIONS(2998),
    [anon_sym_while] = ACTIONS(2998),
    [anon_sym_until] = ACTIONS(2998),
    [anon_sym_repeat] = ACTIONS(2998),
    [anon_sym_when] = ACTIONS(2998),
    [anon_sym_if] = ACTIONS(2998),
    [anon_sym_unless] = ACTIONS(2998),
    [anon_sym_always] = ACTIONS(2998),
    [anon_sym_thereis] = ACTIONS(2998),
    [anon_sym_never] = ACTIONS(2998),
    [anon_sym_else] = ACTIONS(2998),
    [anon_sym_finally] = ACTIONS(2998),
    [anon_sym_return] = ACTIONS(2998),
    [anon_sym_initially] = ACTIONS(2998),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3007),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [172] = {
    [sym__gap] = STATE(215),
    [sym_dis_expr] = STATE(215),
    [sym__form] = STATE(2229),
    [sym_num_lit] = STATE(2229),
    [sym_kwd_lit] = STATE(2229),
    [sym_str_lit] = STATE(2229),
    [sym_char_lit] = STATE(2229),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2229),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2229),
    [sym_set_lit] = STATE(2229),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2229),
    [sym_splicing_read_cond_lit] = STATE(2229),
    [sym_var_quoting_lit] = STATE(2229),
    [sym_quoting_lit] = STATE(2229),
    [sym_syn_quoting_lit] = STATE(2229),
    [sym_unquote_splicing_lit] = STATE(2229),
    [sym_unquoting_lit] = STATE(2229),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2229),
    [sym_package_lit] = STATE(2229),
    [sym_include_reader_macro] = STATE(2229),
    [sym_complex_num_lit] = STATE(2229),
    [aux_sym_dis_expr_repeat1] = STATE(215),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(3009),
    [sym_comment] = ACTIONS(3009),
    [anon_sym_POUND_] = ACTIONS(2976),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3012),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2981),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3012),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2984),
    [anon_sym_POUND_CARET] = ACTIONS(2987),
    [anon_sym_LPAREN] = ACTIONS(2990),
    [anon_sym_RPAREN] = ACTIONS(2993),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3012),
    [anon_sym_cl] = ACTIONS(2995),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2998),
    [anon_sym_for] = ACTIONS(2998),
    [anon_sym_and] = ACTIONS(2998),
    [anon_sym_as] = ACTIONS(2998),
    [anon_sym_with] = ACTIONS(2998),
    [anon_sym_do] = ACTIONS(2998),
    [anon_sym_while] = ACTIONS(2998),
    [anon_sym_until] = ACTIONS(2998),
    [anon_sym_repeat] = ACTIONS(2998),
    [anon_sym_when] = ACTIONS(2998),
    [anon_sym_if] = ACTIONS(2998),
    [anon_sym_unless] = ACTIONS(2998),
    [anon_sym_always] = ACTIONS(2998),
    [anon_sym_thereis] = ACTIONS(2998),
    [anon_sym_never] = ACTIONS(2998),
    [anon_sym_else] = ACTIONS(2998),
    [anon_sym_finally] = ACTIONS(2998),
    [anon_sym_return] = ACTIONS(2998),
    [anon_sym_initially] = ACTIONS(2998),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3014),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [173] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2232),
    [sym_num_lit] = STATE(2232),
    [sym_kwd_lit] = STATE(2232),
    [sym_str_lit] = STATE(2232),
    [sym_char_lit] = STATE(2232),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2232),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2232),
    [sym_set_lit] = STATE(2232),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2232),
    [sym_splicing_read_cond_lit] = STATE(2232),
    [sym_var_quoting_lit] = STATE(2232),
    [sym_quoting_lit] = STATE(2232),
    [sym_syn_quoting_lit] = STATE(2232),
    [sym_unquote_splicing_lit] = STATE(2232),
    [sym_unquoting_lit] = STATE(2232),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2232),
    [sym_package_lit] = STATE(2232),
    [sym_include_reader_macro] = STATE(2232),
    [sym_complex_num_lit] = STATE(2232),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2973),
    [sym_comment] = ACTIONS(2973),
    [anon_sym_POUND_] = ACTIONS(2976),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3016),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2981),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3016),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2984),
    [anon_sym_POUND_CARET] = ACTIONS(2987),
    [anon_sym_LPAREN] = ACTIONS(2990),
    [anon_sym_RPAREN] = ACTIONS(2993),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3016),
    [anon_sym_cl] = ACTIONS(2995),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2998),
    [anon_sym_for] = ACTIONS(2998),
    [anon_sym_and] = ACTIONS(2998),
    [anon_sym_as] = ACTIONS(2998),
    [anon_sym_with] = ACTIONS(2998),
    [anon_sym_do] = ACTIONS(2998),
    [anon_sym_while] = ACTIONS(2998),
    [anon_sym_until] = ACTIONS(2998),
    [anon_sym_repeat] = ACTIONS(2998),
    [anon_sym_when] = ACTIONS(2998),
    [anon_sym_if] = ACTIONS(2998),
    [anon_sym_unless] = ACTIONS(2998),
    [anon_sym_always] = ACTIONS(2998),
    [anon_sym_thereis] = ACTIONS(2998),
    [anon_sym_never] = ACTIONS(2998),
    [anon_sym_else] = ACTIONS(2998),
    [anon_sym_finally] = ACTIONS(2998),
    [anon_sym_return] = ACTIONS(2998),
    [anon_sym_initially] = ACTIONS(2998),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3018),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [174] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2234),
    [sym_num_lit] = STATE(2234),
    [sym_kwd_lit] = STATE(2234),
    [sym_str_lit] = STATE(2234),
    [sym_char_lit] = STATE(2234),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2234),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2234),
    [sym_set_lit] = STATE(2234),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2234),
    [sym_splicing_read_cond_lit] = STATE(2234),
    [sym_var_quoting_lit] = STATE(2234),
    [sym_quoting_lit] = STATE(2234),
    [sym_syn_quoting_lit] = STATE(2234),
    [sym_unquote_splicing_lit] = STATE(2234),
    [sym_unquoting_lit] = STATE(2234),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2234),
    [sym_package_lit] = STATE(2234),
    [sym_include_reader_macro] = STATE(2234),
    [sym_complex_num_lit] = STATE(2234),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2944),
    [sym_comment] = ACTIONS(2944),
    [anon_sym_POUND_] = ACTIONS(2947),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3020),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2952),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3020),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2955),
    [anon_sym_POUND_CARET] = ACTIONS(2958),
    [anon_sym_LPAREN] = ACTIONS(2961),
    [anon_sym_RPAREN] = ACTIONS(2964),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3020),
    [anon_sym_cl] = ACTIONS(2966),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2969),
    [anon_sym_for] = ACTIONS(2969),
    [anon_sym_and] = ACTIONS(2969),
    [anon_sym_as] = ACTIONS(2969),
    [anon_sym_with] = ACTIONS(2969),
    [anon_sym_do] = ACTIONS(2969),
    [anon_sym_while] = ACTIONS(2969),
    [anon_sym_until] = ACTIONS(2969),
    [anon_sym_repeat] = ACTIONS(2969),
    [anon_sym_when] = ACTIONS(2969),
    [anon_sym_if] = ACTIONS(2969),
    [anon_sym_unless] = ACTIONS(2969),
    [anon_sym_always] = ACTIONS(2969),
    [anon_sym_thereis] = ACTIONS(2969),
    [anon_sym_never] = ACTIONS(2969),
    [anon_sym_else] = ACTIONS(2969),
    [anon_sym_finally] = ACTIONS(2969),
    [anon_sym_return] = ACTIONS(2969),
    [anon_sym_initially] = ACTIONS(2969),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3022),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [175] = {
    [sym__gap] = STATE(217),
    [sym_dis_expr] = STATE(217),
    [sym__form] = STATE(2235),
    [sym_num_lit] = STATE(2235),
    [sym_kwd_lit] = STATE(2235),
    [sym_str_lit] = STATE(2235),
    [sym_char_lit] = STATE(2235),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2235),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2235),
    [sym_set_lit] = STATE(2235),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2235),
    [sym_splicing_read_cond_lit] = STATE(2235),
    [sym_var_quoting_lit] = STATE(2235),
    [sym_quoting_lit] = STATE(2235),
    [sym_syn_quoting_lit] = STATE(2235),
    [sym_unquote_splicing_lit] = STATE(2235),
    [sym_unquoting_lit] = STATE(2235),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2235),
    [sym_package_lit] = STATE(2235),
    [sym_include_reader_macro] = STATE(2235),
    [sym_complex_num_lit] = STATE(2235),
    [aux_sym_dis_expr_repeat1] = STATE(217),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(3024),
    [sym_comment] = ACTIONS(3024),
    [anon_sym_POUND_] = ACTIONS(2947),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3027),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2952),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3027),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2955),
    [anon_sym_POUND_CARET] = ACTIONS(2958),
    [anon_sym_LPAREN] = ACTIONS(2961),
    [anon_sym_RPAREN] = ACTIONS(2964),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3027),
    [anon_sym_cl] = ACTIONS(2966),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2969),
    [anon_sym_for] = ACTIONS(2969),
    [anon_sym_and] = ACTIONS(2969),
    [anon_sym_as] = ACTIONS(2969),
    [anon_sym_with] = ACTIONS(2969),
    [anon_sym_do] = ACTIONS(2969),
    [anon_sym_while] = ACTIONS(2969),
    [anon_sym_until] = ACTIONS(2969),
    [anon_sym_repeat] = ACTIONS(2969),
    [anon_sym_when] = ACTIONS(2969),
    [anon_sym_if] = ACTIONS(2969),
    [anon_sym_unless] = ACTIONS(2969),
    [anon_sym_always] = ACTIONS(2969),
    [anon_sym_thereis] = ACTIONS(2969),
    [anon_sym_never] = ACTIONS(2969),
    [anon_sym_else] = ACTIONS(2969),
    [anon_sym_finally] = ACTIONS(2969),
    [anon_sym_return] = ACTIONS(2969),
    [anon_sym_initially] = ACTIONS(2969),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3029),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [176] = {
    [sym__gap] = STATE(218),
    [sym_dis_expr] = STATE(218),
    [sym__form] = STATE(2237),
    [sym_num_lit] = STATE(2237),
    [sym_kwd_lit] = STATE(2237),
    [sym_str_lit] = STATE(2237),
    [sym_char_lit] = STATE(2237),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2237),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2237),
    [sym_set_lit] = STATE(2237),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2237),
    [sym_splicing_read_cond_lit] = STATE(2237),
    [sym_var_quoting_lit] = STATE(2237),
    [sym_quoting_lit] = STATE(2237),
    [sym_syn_quoting_lit] = STATE(2237),
    [sym_unquote_splicing_lit] = STATE(2237),
    [sym_unquoting_lit] = STATE(2237),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2237),
    [sym_package_lit] = STATE(2237),
    [sym_include_reader_macro] = STATE(2237),
    [sym_complex_num_lit] = STATE(2237),
    [aux_sym_dis_expr_repeat1] = STATE(218),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(3031),
    [sym_comment] = ACTIONS(3031),
    [anon_sym_POUND_] = ACTIONS(3034),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3037),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(3039),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3037),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(3042),
    [anon_sym_POUND_CARET] = ACTIONS(3045),
    [anon_sym_LPAREN] = ACTIONS(3048),
    [anon_sym_RPAREN] = ACTIONS(3051),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3037),
    [anon_sym_cl] = ACTIONS(3053),
    [aux_sym_accumulation_verb_token1] = ACTIONS(3056),
    [anon_sym_for] = ACTIONS(3056),
    [anon_sym_and] = ACTIONS(3056),
    [anon_sym_as] = ACTIONS(3056),
    [anon_sym_with] = ACTIONS(3056),
    [anon_sym_do] = ACTIONS(3056),
    [anon_sym_while] = ACTIONS(3056),
    [anon_sym_until] = ACTIONS(3056),
    [anon_sym_repeat] = ACTIONS(3056),
    [anon_sym_when] = ACTIONS(3056),
    [anon_sym_if] = ACTIONS(3056),
    [anon_sym_unless] = ACTIONS(3056),
    [anon_sym_always] = ACTIONS(3056),
    [anon_sym_thereis] = ACTIONS(3056),
    [anon_sym_never] = ACTIONS(3056),
    [anon_sym_else] = ACTIONS(3056),
    [anon_sym_finally] = ACTIONS(3056),
    [anon_sym_return] = ACTIONS(3056),
    [anon_sym_initially] = ACTIONS(3056),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3058),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [177] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2239),
    [sym_num_lit] = STATE(2239),
    [sym_kwd_lit] = STATE(2239),
    [sym_str_lit] = STATE(2239),
    [sym_char_lit] = STATE(2239),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2239),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2239),
    [sym_set_lit] = STATE(2239),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2239),
    [sym_splicing_read_cond_lit] = STATE(2239),
    [sym_var_quoting_lit] = STATE(2239),
    [sym_quoting_lit] = STATE(2239),
    [sym_syn_quoting_lit] = STATE(2239),
    [sym_unquote_splicing_lit] = STATE(2239),
    [sym_unquoting_lit] = STATE(2239),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2239),
    [sym_package_lit] = STATE(2239),
    [sym_include_reader_macro] = STATE(2239),
    [sym_complex_num_lit] = STATE(2239),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(3060),
    [sym_comment] = ACTIONS(3060),
    [anon_sym_POUND_] = ACTIONS(3034),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3063),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(3039),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3063),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(3042),
    [anon_sym_POUND_CARET] = ACTIONS(3045),
    [anon_sym_LPAREN] = ACTIONS(3048),
    [anon_sym_RPAREN] = ACTIONS(3051),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3063),
    [anon_sym_cl] = ACTIONS(3053),
    [aux_sym_accumulation_verb_token1] = ACTIONS(3056),
    [anon_sym_for] = ACTIONS(3056),
    [anon_sym_and] = ACTIONS(3056),
    [anon_sym_as] = ACTIONS(3056),
    [anon_sym_with] = ACTIONS(3056),
    [anon_sym_do] = ACTIONS(3056),
    [anon_sym_while] = ACTIONS(3056),
    [anon_sym_until] = ACTIONS(3056),
    [anon_sym_repeat] = ACTIONS(3056),
    [anon_sym_when] = ACTIONS(3056),
    [anon_sym_if] = ACTIONS(3056),
    [anon_sym_unless] = ACTIONS(3056),
    [anon_sym_always] = ACTIONS(3056),
    [anon_sym_thereis] = ACTIONS(3056),
    [anon_sym_never] = ACTIONS(3056),
    [anon_sym_else] = ACTIONS(3056),
    [anon_sym_finally] = ACTIONS(3056),
    [anon_sym_return] = ACTIONS(3056),
    [anon_sym_initially] = ACTIONS(3056),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3065),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [178] = {
    [sym__gap] = STATE(221),
    [sym_dis_expr] = STATE(221),
    [sym__form] = STATE(2240),
    [sym_num_lit] = STATE(2240),
    [sym_kwd_lit] = STATE(2240),
    [sym_str_lit] = STATE(2240),
    [sym_char_lit] = STATE(2240),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2240),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2240),
    [sym_set_lit] = STATE(2240),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2240),
    [sym_splicing_read_cond_lit] = STATE(2240),
    [sym_var_quoting_lit] = STATE(2240),
    [sym_quoting_lit] = STATE(2240),
    [sym_syn_quoting_lit] = STATE(2240),
    [sym_unquote_splicing_lit] = STATE(2240),
    [sym_unquoting_lit] = STATE(2240),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2240),
    [sym_package_lit] = STATE(2240),
    [sym_include_reader_macro] = STATE(2240),
    [sym_complex_num_lit] = STATE(2240),
    [aux_sym_dis_expr_repeat1] = STATE(221),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(3067),
    [sym_comment] = ACTIONS(3067),
    [anon_sym_POUND_] = ACTIONS(3034),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3070),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(3039),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3070),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(3042),
    [anon_sym_POUND_CARET] = ACTIONS(3045),
    [anon_sym_LPAREN] = ACTIONS(3048),
    [anon_sym_RPAREN] = ACTIONS(3051),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3070),
    [anon_sym_cl] = ACTIONS(3053),
    [aux_sym_accumulation_verb_token1] = ACTIONS(3056),
    [anon_sym_for] = ACTIONS(3056),
    [anon_sym_and] = ACTIONS(3056),
    [anon_sym_as] = ACTIONS(3056),
    [anon_sym_with] = ACTIONS(3056),
    [anon_sym_do] = ACTIONS(3056),
    [anon_sym_while] = ACTIONS(3056),
    [anon_sym_until] = ACTIONS(3056),
    [anon_sym_repeat] = ACTIONS(3056),
    [anon_sym_when] = ACTIONS(3056),
    [anon_sym_if] = ACTIONS(3056),
    [anon_sym_unless] = ACTIONS(3056),
    [anon_sym_always] = ACTIONS(3056),
    [anon_sym_thereis] = ACTIONS(3056),
    [anon_sym_never] = ACTIONS(3056),
    [anon_sym_else] = ACTIONS(3056),
    [anon_sym_finally] = ACTIONS(3056),
    [anon_sym_return] = ACTIONS(3056),
    [anon_sym_initially] = ACTIONS(3056),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3072),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [179] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2244),
    [sym_num_lit] = STATE(2244),
    [sym_kwd_lit] = STATE(2244),
    [sym_str_lit] = STATE(2244),
    [sym_char_lit] = STATE(2244),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2244),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2244),
    [sym_set_lit] = STATE(2244),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2244),
    [sym_splicing_read_cond_lit] = STATE(2244),
    [sym_var_quoting_lit] = STATE(2244),
    [sym_quoting_lit] = STATE(2244),
    [sym_syn_quoting_lit] = STATE(2244),
    [sym_unquote_splicing_lit] = STATE(2244),
    [sym_unquoting_lit] = STATE(2244),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2244),
    [sym_package_lit] = STATE(2244),
    [sym_include_reader_macro] = STATE(2244),
    [sym_complex_num_lit] = STATE(2244),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2944),
    [sym_comment] = ACTIONS(2944),
    [anon_sym_POUND_] = ACTIONS(2947),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3074),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2952),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3074),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2955),
    [anon_sym_POUND_CARET] = ACTIONS(2958),
    [anon_sym_LPAREN] = ACTIONS(2961),
    [anon_sym_RPAREN] = ACTIONS(2964),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3074),
    [anon_sym_cl] = ACTIONS(2966),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2969),
    [anon_sym_for] = ACTIONS(2969),
    [anon_sym_and] = ACTIONS(2969),
    [anon_sym_as] = ACTIONS(2969),
    [anon_sym_with] = ACTIONS(2969),
    [anon_sym_do] = ACTIONS(2969),
    [anon_sym_while] = ACTIONS(2969),
    [anon_sym_until] = ACTIONS(2969),
    [anon_sym_repeat] = ACTIONS(2969),
    [anon_sym_when] = ACTIONS(2969),
    [anon_sym_if] = ACTIONS(2969),
    [anon_sym_unless] = ACTIONS(2969),
    [anon_sym_always] = ACTIONS(2969),
    [anon_sym_thereis] = ACTIONS(2969),
    [anon_sym_never] = ACTIONS(2969),
    [anon_sym_else] = ACTIONS(2969),
    [anon_sym_finally] = ACTIONS(2969),
    [anon_sym_return] = ACTIONS(2969),
    [anon_sym_initially] = ACTIONS(2969),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3076),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [180] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2246),
    [sym_num_lit] = STATE(2246),
    [sym_kwd_lit] = STATE(2246),
    [sym_str_lit] = STATE(2246),
    [sym_char_lit] = STATE(2246),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2246),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2246),
    [sym_set_lit] = STATE(2246),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2246),
    [sym_splicing_read_cond_lit] = STATE(2246),
    [sym_var_quoting_lit] = STATE(2246),
    [sym_quoting_lit] = STATE(2246),
    [sym_syn_quoting_lit] = STATE(2246),
    [sym_unquote_splicing_lit] = STATE(2246),
    [sym_unquoting_lit] = STATE(2246),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2246),
    [sym_package_lit] = STATE(2246),
    [sym_include_reader_macro] = STATE(2246),
    [sym_complex_num_lit] = STATE(2246),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2973),
    [sym_comment] = ACTIONS(2973),
    [anon_sym_POUND_] = ACTIONS(2976),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3078),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2981),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3078),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2984),
    [anon_sym_POUND_CARET] = ACTIONS(2987),
    [anon_sym_LPAREN] = ACTIONS(2990),
    [anon_sym_RPAREN] = ACTIONS(2993),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3078),
    [anon_sym_cl] = ACTIONS(2995),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2998),
    [anon_sym_for] = ACTIONS(2998),
    [anon_sym_and] = ACTIONS(2998),
    [anon_sym_as] = ACTIONS(2998),
    [anon_sym_with] = ACTIONS(2998),
    [anon_sym_do] = ACTIONS(2998),
    [anon_sym_while] = ACTIONS(2998),
    [anon_sym_until] = ACTIONS(2998),
    [anon_sym_repeat] = ACTIONS(2998),
    [anon_sym_when] = ACTIONS(2998),
    [anon_sym_if] = ACTIONS(2998),
    [anon_sym_unless] = ACTIONS(2998),
    [anon_sym_always] = ACTIONS(2998),
    [anon_sym_thereis] = ACTIONS(2998),
    [anon_sym_never] = ACTIONS(2998),
    [anon_sym_else] = ACTIONS(2998),
    [anon_sym_finally] = ACTIONS(2998),
    [anon_sym_return] = ACTIONS(2998),
    [anon_sym_initially] = ACTIONS(2998),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3080),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [181] = {
    [sym__gap] = STATE(222),
    [sym_dis_expr] = STATE(222),
    [sym__form] = STATE(2045),
    [sym_num_lit] = STATE(2045),
    [sym_kwd_lit] = STATE(2045),
    [sym_str_lit] = STATE(2045),
    [sym_char_lit] = STATE(2045),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2045),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2045),
    [sym_set_lit] = STATE(2045),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2045),
    [sym_splicing_read_cond_lit] = STATE(2045),
    [sym_var_quoting_lit] = STATE(2045),
    [sym_quoting_lit] = STATE(2045),
    [sym_syn_quoting_lit] = STATE(2045),
    [sym_unquote_splicing_lit] = STATE(2045),
    [sym_unquoting_lit] = STATE(2045),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2045),
    [sym_package_lit] = STATE(2045),
    [sym_include_reader_macro] = STATE(2045),
    [sym_complex_num_lit] = STATE(2045),
    [aux_sym_dis_expr_repeat1] = STATE(222),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(3082),
    [sym_comment] = ACTIONS(3082),
    [anon_sym_POUND_] = ACTIONS(2976),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3085),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2981),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3085),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2984),
    [anon_sym_POUND_CARET] = ACTIONS(2987),
    [anon_sym_LPAREN] = ACTIONS(2990),
    [anon_sym_RPAREN] = ACTIONS(2993),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3085),
    [anon_sym_cl] = ACTIONS(2995),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2998),
    [anon_sym_for] = ACTIONS(2998),
    [anon_sym_and] = ACTIONS(2998),
    [anon_sym_as] = ACTIONS(2998),
    [anon_sym_with] = ACTIONS(2998),
    [anon_sym_do] = ACTIONS(2998),
    [anon_sym_while] = ACTIONS(2998),
    [anon_sym_until] = ACTIONS(2998),
    [anon_sym_repeat] = ACTIONS(2998),
    [anon_sym_when] = ACTIONS(2998),
    [anon_sym_if] = ACTIONS(2998),
    [anon_sym_unless] = ACTIONS(2998),
    [anon_sym_always] = ACTIONS(2998),
    [anon_sym_thereis] = ACTIONS(2998),
    [anon_sym_never] = ACTIONS(2998),
    [anon_sym_else] = ACTIONS(2998),
    [anon_sym_finally] = ACTIONS(2998),
    [anon_sym_return] = ACTIONS(2998),
    [anon_sym_initially] = ACTIONS(2998),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3087),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [182] = {
    [sym__gap] = STATE(223),
    [sym_dis_expr] = STATE(223),
    [sym__form] = STATE(2249),
    [sym_num_lit] = STATE(2249),
    [sym_kwd_lit] = STATE(2249),
    [sym_str_lit] = STATE(2249),
    [sym_char_lit] = STATE(2249),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2249),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2249),
    [sym_set_lit] = STATE(2249),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2249),
    [sym_splicing_read_cond_lit] = STATE(2249),
    [sym_var_quoting_lit] = STATE(2249),
    [sym_quoting_lit] = STATE(2249),
    [sym_syn_quoting_lit] = STATE(2249),
    [sym_unquote_splicing_lit] = STATE(2249),
    [sym_unquoting_lit] = STATE(2249),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2249),
    [sym_package_lit] = STATE(2249),
    [sym_include_reader_macro] = STATE(2249),
    [sym_complex_num_lit] = STATE(2249),
    [aux_sym_dis_expr_repeat1] = STATE(223),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(3089),
    [sym_comment] = ACTIONS(3089),
    [anon_sym_POUND_] = ACTIONS(2976),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3092),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2981),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3092),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2984),
    [anon_sym_POUND_CARET] = ACTIONS(2987),
    [anon_sym_LPAREN] = ACTIONS(2990),
    [anon_sym_RPAREN] = ACTIONS(2993),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3092),
    [anon_sym_cl] = ACTIONS(2995),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2998),
    [anon_sym_for] = ACTIONS(2998),
    [anon_sym_and] = ACTIONS(2998),
    [anon_sym_as] = ACTIONS(2998),
    [anon_sym_with] = ACTIONS(2998),
    [anon_sym_do] = ACTIONS(2998),
    [anon_sym_while] = ACTIONS(2998),
    [anon_sym_until] = ACTIONS(2998),
    [anon_sym_repeat] = ACTIONS(2998),
    [anon_sym_when] = ACTIONS(2998),
    [anon_sym_if] = ACTIONS(2998),
    [anon_sym_unless] = ACTIONS(2998),
    [anon_sym_always] = ACTIONS(2998),
    [anon_sym_thereis] = ACTIONS(2998),
    [anon_sym_never] = ACTIONS(2998),
    [anon_sym_else] = ACTIONS(2998),
    [anon_sym_finally] = ACTIONS(2998),
    [anon_sym_return] = ACTIONS(2998),
    [anon_sym_initially] = ACTIONS(2998),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3094),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [183] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2251),
    [sym_num_lit] = STATE(2251),
    [sym_kwd_lit] = STATE(2251),
    [sym_str_lit] = STATE(2251),
    [sym_char_lit] = STATE(2251),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2251),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2251),
    [sym_set_lit] = STATE(2251),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2251),
    [sym_splicing_read_cond_lit] = STATE(2251),
    [sym_var_quoting_lit] = STATE(2251),
    [sym_quoting_lit] = STATE(2251),
    [sym_syn_quoting_lit] = STATE(2251),
    [sym_unquote_splicing_lit] = STATE(2251),
    [sym_unquoting_lit] = STATE(2251),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2251),
    [sym_package_lit] = STATE(2251),
    [sym_include_reader_macro] = STATE(2251),
    [sym_complex_num_lit] = STATE(2251),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2973),
    [sym_comment] = ACTIONS(2973),
    [anon_sym_POUND_] = ACTIONS(2976),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3096),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2981),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3096),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2984),
    [anon_sym_POUND_CARET] = ACTIONS(2987),
    [anon_sym_LPAREN] = ACTIONS(2990),
    [anon_sym_RPAREN] = ACTIONS(2993),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3096),
    [anon_sym_cl] = ACTIONS(2995),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2998),
    [anon_sym_for] = ACTIONS(2998),
    [anon_sym_and] = ACTIONS(2998),
    [anon_sym_as] = ACTIONS(2998),
    [anon_sym_with] = ACTIONS(2998),
    [anon_sym_do] = ACTIONS(2998),
    [anon_sym_while] = ACTIONS(2998),
    [anon_sym_until] = ACTIONS(2998),
    [anon_sym_repeat] = ACTIONS(2998),
    [anon_sym_when] = ACTIONS(2998),
    [anon_sym_if] = ACTIONS(2998),
    [anon_sym_unless] = ACTIONS(2998),
    [anon_sym_always] = ACTIONS(2998),
    [anon_sym_thereis] = ACTIONS(2998),
    [anon_sym_never] = ACTIONS(2998),
    [anon_sym_else] = ACTIONS(2998),
    [anon_sym_finally] = ACTIONS(2998),
    [anon_sym_return] = ACTIONS(2998),
    [anon_sym_initially] = ACTIONS(2998),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3098),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [184] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2253),
    [sym_num_lit] = STATE(2253),
    [sym_kwd_lit] = STATE(2253),
    [sym_str_lit] = STATE(2253),
    [sym_char_lit] = STATE(2253),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2253),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2253),
    [sym_set_lit] = STATE(2253),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2253),
    [sym_splicing_read_cond_lit] = STATE(2253),
    [sym_var_quoting_lit] = STATE(2253),
    [sym_quoting_lit] = STATE(2253),
    [sym_syn_quoting_lit] = STATE(2253),
    [sym_unquote_splicing_lit] = STATE(2253),
    [sym_unquoting_lit] = STATE(2253),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2253),
    [sym_package_lit] = STATE(2253),
    [sym_include_reader_macro] = STATE(2253),
    [sym_complex_num_lit] = STATE(2253),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(2944),
    [sym_comment] = ACTIONS(2944),
    [anon_sym_POUND_] = ACTIONS(2947),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3100),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2952),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3100),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2955),
    [anon_sym_POUND_CARET] = ACTIONS(2958),
    [anon_sym_LPAREN] = ACTIONS(2961),
    [anon_sym_RPAREN] = ACTIONS(2964),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3100),
    [anon_sym_cl] = ACTIONS(2966),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2969),
    [anon_sym_for] = ACTIONS(2969),
    [anon_sym_and] = ACTIONS(2969),
    [anon_sym_as] = ACTIONS(2969),
    [anon_sym_with] = ACTIONS(2969),
    [anon_sym_do] = ACTIONS(2969),
    [anon_sym_while] = ACTIONS(2969),
    [anon_sym_until] = ACTIONS(2969),
    [anon_sym_repeat] = ACTIONS(2969),
    [anon_sym_when] = ACTIONS(2969),
    [anon_sym_if] = ACTIONS(2969),
    [anon_sym_unless] = ACTIONS(2969),
    [anon_sym_always] = ACTIONS(2969),
    [anon_sym_thereis] = ACTIONS(2969),
    [anon_sym_never] = ACTIONS(2969),
    [anon_sym_else] = ACTIONS(2969),
    [anon_sym_finally] = ACTIONS(2969),
    [anon_sym_return] = ACTIONS(2969),
    [anon_sym_initially] = ACTIONS(2969),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3102),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [185] = {
    [sym__gap] = STATE(225),
    [sym_dis_expr] = STATE(225),
    [sym__form] = STATE(2254),
    [sym_num_lit] = STATE(2254),
    [sym_kwd_lit] = STATE(2254),
    [sym_str_lit] = STATE(2254),
    [sym_char_lit] = STATE(2254),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2254),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2254),
    [sym_set_lit] = STATE(2254),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2254),
    [sym_splicing_read_cond_lit] = STATE(2254),
    [sym_var_quoting_lit] = STATE(2254),
    [sym_quoting_lit] = STATE(2254),
    [sym_syn_quoting_lit] = STATE(2254),
    [sym_unquote_splicing_lit] = STATE(2254),
    [sym_unquoting_lit] = STATE(2254),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2254),
    [sym_package_lit] = STATE(2254),
    [sym_include_reader_macro] = STATE(2254),
    [sym_complex_num_lit] = STATE(2254),
    [aux_sym_dis_expr_repeat1] = STATE(225),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(3104),
    [sym_comment] = ACTIONS(3104),
    [anon_sym_POUND_] = ACTIONS(2947),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3107),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(2952),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3107),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(2955),
    [anon_sym_POUND_CARET] = ACTIONS(2958),
    [anon_sym_LPAREN] = ACTIONS(2961),
    [anon_sym_RPAREN] = ACTIONS(2964),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3107),
    [anon_sym_cl] = ACTIONS(2966),
    [aux_sym_accumulation_verb_token1] = ACTIONS(2969),
    [anon_sym_for] = ACTIONS(2969),
    [anon_sym_and] = ACTIONS(2969),
    [anon_sym_as] = ACTIONS(2969),
    [anon_sym_with] = ACTIONS(2969),
    [anon_sym_do] = ACTIONS(2969),
    [anon_sym_while] = ACTIONS(2969),
    [anon_sym_until] = ACTIONS(2969),
    [anon_sym_repeat] = ACTIONS(2969),
    [anon_sym_when] = ACTIONS(2969),
    [anon_sym_if] = ACTIONS(2969),
    [anon_sym_unless] = ACTIONS(2969),
    [anon_sym_always] = ACTIONS(2969),
    [anon_sym_thereis] = ACTIONS(2969),
    [anon_sym_never] = ACTIONS(2969),
    [anon_sym_else] = ACTIONS(2969),
    [anon_sym_finally] = ACTIONS(2969),
    [anon_sym_return] = ACTIONS(2969),
    [anon_sym_initially] = ACTIONS(2969),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3109),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [186] = {
    [sym__gap] = STATE(226),
    [sym_dis_expr] = STATE(226),
    [sym__form] = STATE(2257),
    [sym_num_lit] = STATE(2257),
    [sym_kwd_lit] = STATE(2257),
    [sym_str_lit] = STATE(2257),
    [sym_char_lit] = STATE(2257),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2257),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2257),
    [sym_set_lit] = STATE(2257),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2257),
    [sym_splicing_read_cond_lit] = STATE(2257),
    [sym_var_quoting_lit] = STATE(2257),
    [sym_quoting_lit] = STATE(2257),
    [sym_syn_quoting_lit] = STATE(2257),
    [sym_unquote_splicing_lit] = STATE(2257),
    [sym_unquoting_lit] = STATE(2257),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2257),
    [sym_package_lit] = STATE(2257),
    [sym_include_reader_macro] = STATE(2257),
    [sym_complex_num_lit] = STATE(2257),
    [aux_sym_dis_expr_repeat1] = STATE(226),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(3111),
    [sym_comment] = ACTIONS(3111),
    [anon_sym_POUND_] = ACTIONS(3034),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3114),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(3039),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3114),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(3042),
    [anon_sym_POUND_CARET] = ACTIONS(3045),
    [anon_sym_LPAREN] = ACTIONS(3048),
    [anon_sym_RPAREN] = ACTIONS(3051),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3114),
    [anon_sym_cl] = ACTIONS(3053),
    [aux_sym_accumulation_verb_token1] = ACTIONS(3056),
    [anon_sym_for] = ACTIONS(3056),
    [anon_sym_and] = ACTIONS(3056),
    [anon_sym_as] = ACTIONS(3056),
    [anon_sym_with] = ACTIONS(3056),
    [anon_sym_do] = ACTIONS(3056),
    [anon_sym_while] = ACTIONS(3056),
    [anon_sym_until] = ACTIONS(3056),
    [anon_sym_repeat] = ACTIONS(3056),
    [anon_sym_when] = ACTIONS(3056),
    [anon_sym_if] = ACTIONS(3056),
    [anon_sym_unless] = ACTIONS(3056),
    [anon_sym_always] = ACTIONS(3056),
    [anon_sym_thereis] = ACTIONS(3056),
    [anon_sym_never] = ACTIONS(3056),
    [anon_sym_else] = ACTIONS(3056),
    [anon_sym_finally] = ACTIONS(3056),
    [anon_sym_return] = ACTIONS(3056),
    [anon_sym_initially] = ACTIONS(3056),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3116),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [187] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2259),
    [sym_num_lit] = STATE(2259),
    [sym_kwd_lit] = STATE(2259),
    [sym_str_lit] = STATE(2259),
    [sym_char_lit] = STATE(2259),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2259),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2259),
    [sym_set_lit] = STATE(2259),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2259),
    [sym_splicing_read_cond_lit] = STATE(2259),
    [sym_var_quoting_lit] = STATE(2259),
    [sym_quoting_lit] = STATE(2259),
    [sym_syn_quoting_lit] = STATE(2259),
    [sym_unquote_splicing_lit] = STATE(2259),
    [sym_unquoting_lit] = STATE(2259),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2259),
    [sym_package_lit] = STATE(2259),
    [sym_include_reader_macro] = STATE(2259),
    [sym_complex_num_lit] = STATE(2259),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(3060),
    [sym_comment] = ACTIONS(3060),
    [anon_sym_POUND_] = ACTIONS(3034),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3118),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(3039),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3118),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(3042),
    [anon_sym_POUND_CARET] = ACTIONS(3045),
    [anon_sym_LPAREN] = ACTIONS(3048),
    [anon_sym_RPAREN] = ACTIONS(3051),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3118),
    [anon_sym_cl] = ACTIONS(3053),
    [aux_sym_accumulation_verb_token1] = ACTIONS(3056),
    [anon_sym_for] = ACTIONS(3056),
    [anon_sym_and] = ACTIONS(3056),
    [anon_sym_as] = ACTIONS(3056),
    [anon_sym_with] = ACTIONS(3056),
    [anon_sym_do] = ACTIONS(3056),
    [anon_sym_while] = ACTIONS(3056),
    [anon_sym_until] = ACTIONS(3056),
    [anon_sym_repeat] = ACTIONS(3056),
    [anon_sym_when] = ACTIONS(3056),
    [anon_sym_if] = ACTIONS(3056),
    [anon_sym_unless] = ACTIONS(3056),
    [anon_sym_always] = ACTIONS(3056),
    [anon_sym_thereis] = ACTIONS(3056),
    [anon_sym_never] = ACTIONS(3056),
    [anon_sym_else] = ACTIONS(3056),
    [anon_sym_finally] = ACTIONS(3056),
    [anon_sym_return] = ACTIONS(3056),
    [anon_sym_initially] = ACTIONS(3056),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3120),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [188] = {
    [sym__gap] = STATE(229),
    [sym_dis_expr] = STATE(229),
    [sym__form] = STATE(2260),
    [sym_num_lit] = STATE(2260),
    [sym_kwd_lit] = STATE(2260),
    [sym_str_lit] = STATE(2260),
    [sym_char_lit] = STATE(2260),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2260),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2260),
    [sym_set_lit] = STATE(2260),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2260),
    [sym_splicing_read_cond_lit] = STATE(2260),
    [sym_var_quoting_lit] = STATE(2260),
    [sym_quoting_lit] = STATE(2260),
    [sym_syn_quoting_lit] = STATE(2260),
    [sym_unquote_splicing_lit] = STATE(2260),
    [sym_unquoting_lit] = STATE(2260),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2260),
    [sym_package_lit] = STATE(2260),
    [sym_include_reader_macro] = STATE(2260),
    [sym_complex_num_lit] = STATE(2260),
    [aux_sym_dis_expr_repeat1] = STATE(229),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(3122),
    [sym_comment] = ACTIONS(3122),
    [anon_sym_POUND_] = ACTIONS(3034),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3125),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(3039),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3125),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(3042),
    [anon_sym_POUND_CARET] = ACTIONS(3045),
    [anon_sym_LPAREN] = ACTIONS(3048),
    [anon_sym_RPAREN] = ACTIONS(3051),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3125),
    [anon_sym_cl] = ACTIONS(3053),
    [aux_sym_accumulation_verb_token1] = ACTIONS(3056),
    [anon_sym_for] = ACTIONS(3056),
    [anon_sym_and] = ACTIONS(3056),
    [anon_sym_as] = ACTIONS(3056),
    [anon_sym_with] = ACTIONS(3056),
    [anon_sym_do] = ACTIONS(3056),
    [anon_sym_while] = ACTIONS(3056),
    [anon_sym_until] = ACTIONS(3056),
    [anon_sym_repeat] = ACTIONS(3056),
    [anon_sym_when] = ACTIONS(3056),
    [anon_sym_if] = ACTIONS(3056),
    [anon_sym_unless] = ACTIONS(3056),
    [anon_sym_always] = ACTIONS(3056),
    [anon_sym_thereis] = ACTIONS(3056),
    [anon_sym_never] = ACTIONS(3056),
    [anon_sym_else] = ACTIONS(3056),
    [anon_sym_finally] = ACTIONS(3056),
    [anon_sym_return] = ACTIONS(3056),
    [anon_sym_initially] = ACTIONS(3056),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3127),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [189] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2263),
    [sym_num_lit] = STATE(2263),
    [sym_kwd_lit] = STATE(2263),
    [sym_str_lit] = STATE(2263),
    [sym_char_lit] = STATE(2263),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2263),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2263),
    [sym_set_lit] = STATE(2263),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2263),
    [sym_splicing_read_cond_lit] = STATE(2263),
    [sym_var_quoting_lit] = STATE(2263),
    [sym_quoting_lit] = STATE(2263),
    [sym_syn_quoting_lit] = STATE(2263),
    [sym_unquote_splicing_lit] = STATE(2263),
    [sym_unquoting_lit] = STATE(2263),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2263),
    [sym_package_lit] = STATE(2263),
    [sym_include_reader_macro] = STATE(2263),
    [sym_complex_num_lit] = STATE(2263),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(3129),
    [sym_comment] = ACTIONS(3129),
    [anon_sym_POUND_] = ACTIONS(3132),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3135),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(3137),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3135),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(3140),
    [anon_sym_POUND_CARET] = ACTIONS(3143),
    [anon_sym_LPAREN] = ACTIONS(3146),
    [anon_sym_RPAREN] = ACTIONS(3149),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3135),
    [anon_sym_cl] = ACTIONS(3151),
    [aux_sym_accumulation_verb_token1] = ACTIONS(3154),
    [anon_sym_for] = ACTIONS(3154),
    [anon_sym_and] = ACTIONS(3154),
    [anon_sym_as] = ACTIONS(3154),
    [anon_sym_with] = ACTIONS(3154),
    [anon_sym_do] = ACTIONS(3154),
    [anon_sym_while] = ACTIONS(3154),
    [anon_sym_until] = ACTIONS(3154),
    [anon_sym_repeat] = ACTIONS(3154),
    [anon_sym_when] = ACTIONS(3154),
    [anon_sym_if] = ACTIONS(3154),
    [anon_sym_unless] = ACTIONS(3154),
    [anon_sym_always] = ACTIONS(3154),
    [anon_sym_thereis] = ACTIONS(3154),
    [anon_sym_never] = ACTIONS(3154),
    [anon_sym_else] = ACTIONS(3154),
    [anon_sym_finally] = ACTIONS(3154),
    [anon_sym_return] = ACTIONS(3154),
    [anon_sym_initially] = ACTIONS(3154),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3156),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [190] = {
    [sym__gap] = STATE(230),
    [sym_dis_expr] = STATE(230),
    [sym__form] = STATE(2264),
    [sym_num_lit] = STATE(2264),
    [sym_kwd_lit] = STATE(2264),
    [sym_str_lit] = STATE(2264),
    [sym_char_lit] = STATE(2264),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2264),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2264),
    [sym_set_lit] = STATE(2264),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2264),
    [sym_splicing_read_cond_lit] = STATE(2264),
    [sym_var_quoting_lit] = STATE(2264),
    [sym_quoting_lit] = STATE(2264),
    [sym_syn_quoting_lit] = STATE(2264),
    [sym_unquote_splicing_lit] = STATE(2264),
    [sym_unquoting_lit] = STATE(2264),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2264),
    [sym_package_lit] = STATE(2264),
    [sym_include_reader_macro] = STATE(2264),
    [sym_complex_num_lit] = STATE(2264),
    [aux_sym_dis_expr_repeat1] = STATE(230),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(3158),
    [sym_comment] = ACTIONS(3158),
    [anon_sym_POUND_] = ACTIONS(3132),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3161),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(3137),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3161),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(3140),
    [anon_sym_POUND_CARET] = ACTIONS(3143),
    [anon_sym_LPAREN] = ACTIONS(3146),
    [anon_sym_RPAREN] = ACTIONS(3149),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3161),
    [anon_sym_cl] = ACTIONS(3151),
    [aux_sym_accumulation_verb_token1] = ACTIONS(3154),
    [anon_sym_for] = ACTIONS(3154),
    [anon_sym_and] = ACTIONS(3154),
    [anon_sym_as] = ACTIONS(3154),
    [anon_sym_with] = ACTIONS(3154),
    [anon_sym_do] = ACTIONS(3154),
    [anon_sym_while] = ACTIONS(3154),
    [anon_sym_until] = ACTIONS(3154),
    [anon_sym_repeat] = ACTIONS(3154),
    [anon_sym_when] = ACTIONS(3154),
    [anon_sym_if] = ACTIONS(3154),
    [anon_sym_unless] = ACTIONS(3154),
    [anon_sym_always] = ACTIONS(3154),
    [anon_sym_thereis] = ACTIONS(3154),
    [anon_sym_never] = ACTIONS(3154),
    [anon_sym_else] = ACTIONS(3154),
    [anon_sym_finally] = ACTIONS(3154),
    [anon_sym_return] = ACTIONS(3154),
    [anon_sym_initially] = ACTIONS(3154),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3163),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [191] = {
    [sym__gap] = STATE(231),
    [sym_dis_expr] = STATE(231),
    [sym__form] = STATE(2267),
    [sym_num_lit] = STATE(2267),
    [sym_kwd_lit] = STATE(2267),
    [sym_str_lit] = STATE(2267),
    [sym_char_lit] = STATE(2267),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2267),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2267),
    [sym_set_lit] = STATE(2267),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2267),
    [sym_splicing_read_cond_lit] = STATE(2267),
    [sym_var_quoting_lit] = STATE(2267),
    [sym_quoting_lit] = STATE(2267),
    [sym_syn_quoting_lit] = STATE(2267),
    [sym_unquote_splicing_lit] = STATE(2267),
    [sym_unquoting_lit] = STATE(2267),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2267),
    [sym_package_lit] = STATE(2267),
    [sym_include_reader_macro] = STATE(2267),
    [sym_complex_num_lit] = STATE(2267),
    [aux_sym_dis_expr_repeat1] = STATE(231),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(3165),
    [sym_comment] = ACTIONS(3165),
    [anon_sym_POUND_] = ACTIONS(3168),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3171),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(3173),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3171),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(3176),
    [anon_sym_POUND_CARET] = ACTIONS(3179),
    [anon_sym_LPAREN] = ACTIONS(3182),
    [anon_sym_RPAREN] = ACTIONS(3185),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] = ACTIONS(215),
    [anon_sym_COMMA_AT] = ACTIONS(217),
    [anon_sym_COMMA] = ACTIONS(219),
    [sym_block_comment] = ACTIONS(47),
    [sym_fancy_literal] = ACTIONS(3171),
    [anon_sym_cl] = ACTIONS(3187),
    [aux_sym_accumulation_verb_token1] = ACTIONS(3190),
    [anon_sym_for] = ACTIONS(3190),
    [anon_sym_and] = ACTIONS(3190),
    [anon_sym_as] = ACTIONS(3190),
    [anon_sym_with] = ACTIONS(3190),
    [anon_sym_do] = ACTIONS(3190),
    [anon_sym_while] = ACTIONS(3190),
    [anon_sym_until] = ACTIONS(3190),
    [anon_sym_repeat] = ACTIONS(3190),
    [anon_sym_when] = ACTIONS(3190),
    [anon_sym_if] = ACTIONS(3190),
    [anon_sym_unless] = ACTIONS(3190),
    [anon_sym_always] = ACTIONS(3190),
    [anon_sym_thereis] = ACTIONS(3190),
    [anon_sym_never] = ACTIONS(3190),
    [anon_sym_else] = ACTIONS(3190),
    [anon_sym_finally] = ACTIONS(3190),
    [anon_sym_return] = ACTIONS(3190),
    [anon_sym_initially] = ACTIONS(3190),
    [anon_sym_POUNDP] = ACTIONS(230),
    [anon_sym_POUNDp] = ACTIONS(230),
    [sym_self_referential_reader_macro] = ACTIONS(3192),
    [anon_sym_POUND_PLUS] = ACTIONS(234),
    [anon_sym_POUND_DASH] = ACTIONS(234),
    [anon_sym_POUNDC] = ACTIONS(236),
    [anon_sym_POUNDc] = ACTIONS(236),
  },
  [192] = {
    [sym__gap] = STATE(994),
    [sym_dis_expr] = STATE(994),
    [sym__form] = STATE(2270),
    [sym_num_lit] = STATE(2270),
    [sym_kwd_lit] = STATE(2270),
    [sym_str_lit] = STATE(2270),
    [sym_char_lit] = STATE(2270),
    [sym_sym_lit] = STATE(2112),
    [sym__metadata_lit] = STATE(2903),
    [sym_meta_lit] = STATE(2871),
    [sym_old_meta_lit] = STATE(2860),
    [sym_list_lit] = STATE(2270),
    [sym__bare_list_lit] = STATE(2584),
    [sym_vec_lit] = STATE(2270),
    [sym_set_lit] = STATE(2270),
    [sym__bare_set_lit] = STATE(2589),
    [sym_read_cond_lit] = STATE(2270),
    [sym_splicing_read_cond_lit] = STATE(2270),
    [sym_var_quoting_lit] = STATE(2270),
    [sym_quoting_lit] = STATE(2270),
    [sym_syn_quoting_lit] = STATE(2270),
    [sym_unquote_splicing_lit] = STATE(2270),
    [sym_unquoting_lit] = STATE(2270),
    [sym_defun] = STATE(2584),
    [sym_loop_macro] = STATE(2584),
    [sym_path_lit] = STATE(2270),
    [sym_package_lit] = STATE(2270),
    [sym_include_reader_macro] = STATE(2270),
    [sym_complex_num_lit] = STATE(2270),
    [aux_sym_dis_expr_repeat1] = STATE(994),
    [aux_sym_list_lit_repeat1] = STATE(2803),
    [sym__ws] = ACTIONS(3194),
    [sym_comment] = ACTIONS(3194),
    [anon_sym_POUND_] = ACTIONS(3168),
    [anon_sym_POUND] = ACTIONS(174),
    [anon_sym_DOT] = ACTIONS(3197),
    [aux_sym_num_lit_token1] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(3173),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [anon_sym_DQUOTE] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(3197),
    [aux_sym_sym_lit_token1] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(3176),
    [anon_sym_POUND_CARET] = ACTIONS(3179),
    [anon_sym_LPAREN] = ACTIONS(3182),
    [anon_sym_RPAREN] = ACTIONS(3185),
    [anon_sym_POUND0A] = ACTIONS(205),
    [anon_sym_POUND0a] = ACTIONS(205),
    [anon_sym_POUND_QMARK] = ACTIONS(207),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(209),
    [anon_sym_POUND_SQUOTE] = ACTIONS(211),
    [anon_sym_SQUOTE] = ACTIONS(213),
    [anon_sym_BQUOTE] 