import pytest

URL = "https://enjoy.point.auone.jp/"
SUPPORTED_CSS = "main.tmr-page"
UNSUPPORTED_TEXT = "Android：標準ブラウザ、Chrome"


@pytest.mark.only_platforms("android")
@pytest.mark.asyncio
@pytest.mark.with_interventions
async def test_enabled(client):
    await client.navigate(URL)
    assert client.await_css(SUPPORTED_CSS)


@pytest.mark.only_platforms("android")
@pytest.mark.asyncio
@pytest.mark.without_interventions
async def test_disabled(client):
    await client.navigate(URL)
    assert client.await_text(UNSUPPORTED_TEXT)
