/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.memento;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;

public class PropertiesMemento
implements Externalizable {
    static final long serialVersionUID = -3299575217906477613L;
    public static final int VERSION = 2;
    private String m_class_name;
    private HashMap m_props = new HashMap();

    public PropertiesMemento() {
    }

    public PropertiesMemento(String string) {
        this.m_class_name = string;
    }

    public String getBeanClassName() {
        return this.m_class_name;
    }

    public void addProperty(String string, Serializable serializable) {
        this.m_props.put(string, serializable);
    }

    public boolean containsProperty(String string) {
        return this.m_props.containsKey(string);
    }

    public String getComponentName() {
        Object object = this.getPropertyValue("name");
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public Object getPropertyValue(String string) {
        return this.m_props.get(string);
    }

    public void print() {
        System.out.println("................ properties memento: " + this.getBeanClassName() + "   ..............");
        Iterator iterator = this.m_props.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            System.out.println("          " + string + " = " + this.m_props.get(string));
        }
    }

    public void setBeanClassName(String string) {
        this.m_class_name = string;
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        int n = objectInput.readInt();
        this.m_class_name = (String)objectInput.readObject();
        if (n <= 1) {
            HashMap hashMap;
            this.m_props = (HashMap)objectInput.readObject();
            if (this.m_props == null) {
                this.m_props = new HashMap();
            }
            if ((hashMap = (HashMap)objectInput.readObject()) != null) {
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    this.m_props.put(k, hashMap.get(k));
                }
            }
        } else {
            this.m_props = (HashMap)objectInput.readObject();
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(2);
        objectOutput.writeObject(this.m_class_name);
        objectOutput.writeObject(this.m_props);
    }
}

