// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/UnstableParticles.hh"

namespace Rivet {


  /// @brief e+e- -> J/psi or psi(2S) + X
  class BESIII_2024_I2854046 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BESIII_2024_I2854046);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      declare(UnstableParticles(Cuts::pid==443 || Cuts::pid==100443), "UFS");
      // book hists
      book(_h[0], 1, 1, 1);
      book(_h[1], 1, 1, 2);
      book(_h[2], 1, 1, 3);
      book(_h[3], 1, 1, 4);
      // energies
      for (const string& en : _h[0].binning().edges<0>()) {
        string en2 = en.back()=='a' || en.back()=='b' ? en.substr(0,en.size()-1) : en;
        const double eval = stod(en2)*GeV;
        if (isCompatibleWithSqrtS(eval)) {
          _sqs.push_back(en); break;
        }
      }
      raiseBeamErrorIf(_sqs.empty());
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& ufs = apply<FinalState>(event, "UFS");
      for (const Particle& psi : ufs.particles() ) {
        bool dup = false;
        for (const Particle& child : psi.children()) {
          dup |= psi.pid()==child.pid();
        }
        if (dup) continue;
        unsigned int ipsi = psi.pid()/100000;
        for (const string& en : _sqs) {
          _h[2*ipsi]->fill(en);
          _h[2*ipsi+1]->fill(en);
        }
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_h, crossSection()/sumOfWeights()/picobarn);
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<string> _h[4];
    vector<string> _sqs;
    /// @}


  };


  RIVET_DECLARE_PLUGIN(BESIII_2024_I2854046);
}
