// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"

namespace Rivet {


  /// @brief Measurement of R
  class PLUTO_1979_I142517 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(PLUTO_1979_I142517);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      // Initialise and register projections
      declare(FinalState(), "FS");
      book(_c_hadrons, "sigma_hadrons", refData<YODA::BinnedEstimate<string>>(1,1,1));
      book(_c_muons,   "sigma_muons",   refData<YODA::BinnedEstimate<string>>(1,1,1));
      book(_mult, 1, 1, 1);
      for (const string& en : _c_hadrons.binning().edges<0>()) {
        const size_t idx = en.find("-");
        if (idx != string::npos)  continue;
        const double eval = stod(en)*GeV;
        if (isCompatibleWithSqrtS(eval)) {
          _sqs = en; break;
        }
      }
      raiseBeamErrorIf(_sqs.empty());
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");

      map<long,int> nCount;
      int ntotal(0);
      for (const Particle& p : fs.particles()) {
        nCount[p.pid()] += 1;
        ++ntotal;
      }
      if (nCount[-13]==1 && nCount[13]==1 && ntotal==2+nCount[22]) {
        _c_muons->fill(_sqs); // mu+mu- + photons
        if (_sqs != "22.0"s)  _c_muons->fill("-"s);
      }
      else {
        _c_hadrons->fill(_sqs); // everything else
        if (_sqs != "22.0"s)  _c_hadrons->fill("-"s);
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale({_c_hadrons, _c_muons}, crossSection()/sumOfWeights()/nanobarn);
      divide(_c_hadrons, _c_muons, _mult);
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<string> _c_hadrons, _c_muons;
    BinnedEstimatePtr<string> _mult;
    string _sqs = "";
    /// @}


  };


  RIVET_DECLARE_PLUGIN(PLUTO_1979_I142517);
}
