// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
// RUN: %clang_cc1 -triple x86_64-apple-darwin -O1 -no-struct-path-tbaa -disable-llvm-passes %s -emit-llvm -o - | FileCheck %s
// RUN: %clang_cc1 -triple x86_64-apple-darwin -O1 -disable-llvm-passes %s -emit-llvm -o - | FileCheck %s -check-prefixes=PATH,OLD-PATH
// RUN: %clang_cc1 -triple x86_64-apple-darwin -O1 -new-struct-path-tbaa -disable-llvm-passes %s -emit-llvm -o - | FileCheck %s -check-prefixes=PATH,NEW-PATH
// RUN: %clang_cc1 -triple x86_64-apple-darwin -O0 -disable-llvm-passes %s -emit-llvm -o - | FileCheck %s -check-prefix=NO-TBAA
// RUN: %clang_cc1 -triple x86_64-apple-darwin -O1 -relaxed-aliasing -disable-llvm-passes %s -emit-llvm -o - | FileCheck %s -check-prefix=NO-TBAA
// Test TBAA metadata generated by front-end.
//
// NO-TBAA-NOT: !tbaa

typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned int uint32_t;
typedef unsigned long long uint64_t;
typedef struct
{
   uint16_t f16;
   uint32_t f32;
   uint16_t f16_2;
   uint32_t f32_2;
} StructA;
typedef struct
{
   uint16_t f16;
   StructA a;
   uint32_t f32;
} StructB;
typedef struct
{
   uint16_t f16;
   StructB b;
   uint32_t f32;
} StructC;
typedef struct
{
   uint16_t f16;
   StructB b;
   uint32_t f32;
   uint8_t f8;
} StructD;

typedef struct
{
   uint16_t f16;
   uint32_t f32;
} StructS;
typedef struct
{
   uint16_t f16;
   uint32_t f32;
} StructS2;

uint32_t g(uint32_t *s, StructA *A, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z1g
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA2:![0-9]+]]
// CHECK: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// PATH-LABEL: define{{.*}} i32 @_Z1g
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA2:![0-9]+]]
// PATH: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TBAA12:![0-9]+]]
  *s = 1;
  A->f32 = 4;
  return *s;
}

uint32_t g2(uint32_t *s, StructA *A, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z2g2
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// CHECK: store i16 4, ptr %{{.*}}, align 4, !tbaa [[TBAA12:![0-9]+]]
// PATH-LABEL: define{{.*}} i32 @_Z2g2
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// PATH: store i16 4, ptr %{{.*}}, align 4, !tbaa [[TBAA15:![0-9]+]]
  *s = 1;
  A->f16 = 4;
  return *s;
}

uint32_t g3(StructA *A, StructB *B, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z2g3
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// CHECK: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// PATH-LABEL: define{{.*}} i32 @_Z2g3
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA12]]
// PATH: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TBAA16:![0-9]+]]
  A->f32 = 1;
  B->a.f32 = 4;
  return A->f32;
}

uint32_t g4(StructA *A, StructB *B, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z2g4
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// CHECK: store i16 4, ptr %{{.*}}, align 4, !tbaa [[TBAA12]]
// PATH-LABEL: define{{.*}} i32 @_Z2g4
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA12]]
// PATH: store i16 4, ptr %{{.*}}, align 4, !tbaa [[TBAA18:![0-9]+]]
  A->f32 = 1;
  B->a.f16 = 4;
  return A->f32;
}

uint32_t g5(StructA *A, StructB *B, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z2g5
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// CHECK: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// PATH-LABEL: define{{.*}} i32 @_Z2g5
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA12]]
// PATH: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TBAA19:![0-9]+]]
  A->f32 = 1;
  B->f32 = 4;
  return A->f32;
}

uint32_t g6(StructA *A, StructB *B, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z2g6
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// CHECK: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// PATH-LABEL: define{{.*}} i32 @_Z2g6
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA12]]
// PATH: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TBAA20:![0-9]+]]
  A->f32 = 1;
  B->a.f32_2 = 4;
  return A->f32;
}

uint32_t g7(StructA *A, StructS *S, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z2g7
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// CHECK: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// PATH-LABEL: define{{.*}} i32 @_Z2g7
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA12]]
// PATH: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TBAA21:![0-9]+]]
  A->f32 = 1;
  S->f32 = 4;
  return A->f32;
}

uint32_t g8(StructA *A, StructS *S, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z2g8
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// CHECK: store i16 4, ptr %{{.*}}, align 4, !tbaa [[TBAA12]]
// PATH-LABEL: define{{.*}} i32 @_Z2g8
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA12]]
// PATH: store i16 4, ptr %{{.*}}, align 4, !tbaa [[TBAA23:![0-9]+]]
  A->f32 = 1;
  S->f16 = 4;
  return A->f32;
}

uint32_t g9(StructS *S, StructS2 *S2, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z2g9
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// CHECK: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// PATH-LABEL: define{{.*}} i32 @_Z2g9
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA21]]
// PATH: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TBAA24:![0-9]+]]
  S->f32 = 1;
  S2->f32 = 4;
  return S->f32;
}

uint32_t g10(StructS *S, StructS2 *S2, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z3g10
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// CHECK: store i16 4, ptr %{{.*}}, align 4, !tbaa [[TBAA12]]
// PATH-LABEL: define{{.*}} i32 @_Z3g10
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA21]]
// PATH: store i16 4, ptr %{{.*}}, align 4, !tbaa [[TBAA26:![0-9]+]]
  S->f32 = 1;
  S2->f16 = 4;
  return S->f32;
}

uint32_t g11(StructC *C, StructD *D, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z3g11
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// CHECK: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// PATH-LABEL: define{{.*}} i32 @_Z3g11
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA27:![0-9]+]]
// PATH: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TBAA29:![0-9]+]]
  C->b.a.f32 = 1;
  D->b.a.f32 = 4;
  return C->b.a.f32;
}

uint32_t g12(StructC *C, StructD *D, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z3g12
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// CHECK: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// TODO: differentiate the two accesses.
// PATH-LABEL: define{{.*}} i32 @_Z3g12
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA16]]
// PATH: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TBAA16]]
  StructB *b1 = &(C->b);
  StructB *b2 = &(D->b);
  // b1, b2 have different context.
  b1->a.f32 = 1;
  b2->a.f32 = 4;
  return b1->a.f32;
}

// Make sure that zero-length bitfield works.
#define ATTR __attribute__ ((ms_struct))
struct five {
  char a;
  int :0;        /* ignored; prior field is not a bitfield. */
  char b;
  char c;
} ATTR;
char g13(struct five *a, struct five *b) {
  return a->b;
// CHECK-LABEL: define{{.*}} signext i8 @_Z3g13
// CHECK: load i8, ptr %{{.*}}, align 1, !tbaa [[TBAA16:![0-9]+]]
// PATH-LABEL: define{{.*}} signext i8 @_Z3g13
// PATH: load i8, ptr %{{.*}}, align 1, !tbaa [[TBAA33:![0-9]+]]
}

struct six {
  char a;
  int :0;
  char b;
  char c;
};
char g14(struct six *a, struct six *b) {
// CHECK-LABEL: define{{.*}} signext i8 @_Z3g14
// CHECK: load i8, ptr %{{.*}}, align 1, !tbaa [[TBAA16]]
// PATH-LABEL: define{{.*}} signext i8 @_Z3g14
// PATH: load i8, ptr %{{.*}}, align 1, !tbaa [[TBAA37:![0-9]+]]
  return a->b;
}

// Types that differ only by name may alias.
typedef StructS StructS3;
uint32_t g15(StructS *S, StructS3 *S3, uint64_t count) {
// CHECK-LABEL: define{{.*}} i32 @_Z3g15
// CHECK: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// CHECK: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TBAA2]]
// PATH-LABEL: define{{.*}} i32 @_Z3g15
// PATH: store i32 1, ptr %{{.*}}, align 4, !tbaa [[TBAA21]]
// PATH: store i32 4, ptr %{{.*}}, align 4, !tbaa [[TBAA21]]
  S->f32 = 1;
  S3->f32 = 4;
  return S->f32;
}

//.
// CHECK: [[TBAA2]] = !{[[META3:![0-9]+]], [[META3]], i64 0}
// CHECK: [[META3]] = !{!"int", [[META4:![0-9]+]], i64 0}
// CHECK: [[META4]] = !{!"omnipotent char", [[META5:![0-9]+]], i64 0}
// CHECK: [[META5]] = !{!"Simple C++ TBAA"}
// CHECK: [[TBAA12]] = !{[[META13:![0-9]+]], [[META13]], i64 0}
// CHECK: [[META13]] = !{!"short", [[META4]], i64 0}
// CHECK: [[TBAA16]] = !{[[META4]], [[META4]], i64 0}
//.
// OLD-PATH: [[TBAA2]] = !{[[META3:![0-9]+]], [[META3]], i64 0}
// OLD-PATH: [[META3]] = !{!"int", [[META4:![0-9]+]], i64 0}
// OLD-PATH: [[META4]] = !{!"omnipotent char", [[META5:![0-9]+]], i64 0}
// OLD-PATH: [[META5]] = !{!"Simple C++ TBAA"}
// OLD-PATH: [[TBAA12]] = !{[[META13:![0-9]+]], [[META3]], i64 4}
// OLD-PATH: [[META13]] = !{!"_ZTS7StructA", [[META14:![0-9]+]], i64 0, [[META3]], i64 4, [[META14]], i64 8, [[META3]], i64 12}
// OLD-PATH: [[META14]] = !{!"short", [[META4]], i64 0}
// OLD-PATH: [[TBAA15]] = !{[[META13]], [[META14]], i64 0}
// OLD-PATH: [[TBAA16]] = !{[[META17:![0-9]+]], [[META3]], i64 8}
// OLD-PATH: [[META17]] = !{!"_ZTS7StructB", [[META14]], i64 0, [[META13]], i64 4, [[META3]], i64 20}
// OLD-PATH: [[TBAA18]] = !{[[META17]], [[META14]], i64 4}
// OLD-PATH: [[TBAA19]] = !{[[META17]], [[META3]], i64 20}
// OLD-PATH: [[TBAA20]] = !{[[META17]], [[META3]], i64 16}
// OLD-PATH: [[TBAA21]] = !{[[META22:![0-9]+]], [[META3]], i64 4}
// OLD-PATH: [[META22]] = !{!"_ZTS7StructS", [[META14]], i64 0, [[META3]], i64 4}
// OLD-PATH: [[TBAA23]] = !{[[META22]], [[META14]], i64 0}
// OLD-PATH: [[TBAA24]] = !{[[META25:![0-9]+]], [[META3]], i64 4}
// OLD-PATH: [[META25]] = !{!"_ZTS8StructS2", [[META14]], i64 0, [[META3]], i64 4}
// OLD-PATH: [[TBAA26]] = !{[[META25]], [[META14]], i64 0}
// OLD-PATH: [[TBAA27]] = !{[[META28:![0-9]+]], [[META3]], i64 12}
// OLD-PATH: [[META28]] = !{!"_ZTS7StructC", [[META14]], i64 0, [[META17]], i64 4, [[META3]], i64 28}
// OLD-PATH: [[TBAA29]] = !{[[META30:![0-9]+]], [[META3]], i64 12}
// OLD-PATH: [[META30]] = !{!"_ZTS7StructD", [[META14]], i64 0, [[META17]], i64 4, [[META3]], i64 28, [[META4]], i64 32}
// OLD-PATH: [[TBAA33]] = !{[[META34:![0-9]+]], [[META4]], i64 1}
// OLD-PATH: [[META34]] = !{!"_ZTS4five", [[META4]], i64 0, [[META4]], i64 1, [[META4]], i64 2}
// OLD-PATH: [[TBAA37]] = !{[[META38:![0-9]+]], [[META4]], i64 4}
// OLD-PATH: [[META38]] = !{!"_ZTS3six", [[META4]], i64 0, [[META4]], i64 4, [[META4]], i64 5}
//.
// NEW-PATH: [[TBAA2]] = !{[[META3:![0-9]+]], [[META3]], i64 0, i64 4}
// NEW-PATH: [[META3]] = !{[[META4:![0-9]+]], i64 4, !"int"}
// NEW-PATH: [[META4]] = !{[[META5:![0-9]+]], i64 1, !"omnipotent char"}
// NEW-PATH: [[META5]] = !{!"Simple C++ TBAA"}
// NEW-PATH: [[TBAA12]] = !{[[META13:![0-9]+]], [[META3]], i64 4, i64 4}
// NEW-PATH: [[META13]] = !{[[META4]], i64 16, !"_ZTS7StructA", [[META14:![0-9]+]], i64 0, i64 2, [[META3]], i64 4, i64 4, [[META14]], i64 8, i64 2, [[META3]], i64 12, i64 4}
// NEW-PATH: [[META14]] = !{[[META4]], i64 2, !"short"}
// NEW-PATH: [[TBAA15]] = !{[[META13]], [[META14]], i64 0, i64 2}
// NEW-PATH: [[TBAA16]] = !{[[META17:![0-9]+]], [[META3]], i64 8, i64 4}
// NEW-PATH: [[META17]] = !{[[META4]], i64 24, !"_ZTS7StructB", [[META14]], i64 0, i64 2, [[META13]], i64 4, i64 16, [[META3]], i64 20, i64 4}
// NEW-PATH: [[TBAA18]] = !{[[META17]], [[META14]], i64 4, i64 2}
// NEW-PATH: [[TBAA19]] = !{[[META17]], [[META3]], i64 20, i64 4}
// NEW-PATH: [[TBAA20]] = !{[[META17]], [[META3]], i64 16, i64 4}
// NEW-PATH: [[TBAA21]] = !{[[META22:![0-9]+]], [[META3]], i64 4, i64 4}
// NEW-PATH: [[META22]] = !{[[META4]], i64 8, !"_ZTS7StructS", [[META14]], i64 0, i64 2, [[META3]], i64 4, i64 4}
// NEW-PATH: [[TBAA23]] = !{[[META22]], [[META14]], i64 0, i64 2}
// NEW-PATH: [[TBAA24]] = !{[[META25:![0-9]+]], [[META3]], i64 4, i64 4}
// NEW-PATH: [[META25]] = !{[[META4]], i64 8, !"_ZTS8StructS2", [[META14]], i64 0, i64 2, [[META3]], i64 4, i64 4}
// NEW-PATH: [[TBAA26]] = !{[[META25]], [[META14]], i64 0, i64 2}
// NEW-PATH: [[TBAA27]] = !{[[META28:![0-9]+]], [[META3]], i64 12, i64 4}
// NEW-PATH: [[META28]] = !{[[META4]], i64 32, !"_ZTS7StructC", [[META14]], i64 0, i64 2, [[META17]], i64 4, i64 24, [[META3]], i64 28, i64 4}
// NEW-PATH: [[TBAA29]] = !{[[META30:![0-9]+]], [[META3]], i64 12, i64 4}
// NEW-PATH: [[META30]] = !{[[META4]], i64 36, !"_ZTS7StructD", [[META14]], i64 0, i64 2, [[META17]], i64 4, i64 24, [[META3]], i64 28, i64 4, [[META4]], i64 32, i64 1}
// NEW-PATH: [[TBAA33]] = !{[[META34:![0-9]+]], [[META4]], i64 1, i64 1}
// NEW-PATH: [[META34]] = !{[[META4]], i64 3, !"_ZTS4five", [[META4]], i64 0, i64 1, [[META4]], i64 1, i64 1, [[META4]], i64 2, i64 1}
// NEW-PATH: [[TBAA37]] = !{[[META38:![0-9]+]], [[META4]], i64 4, i64 1}
// NEW-PATH: [[META38]] = !{[[META4]], i64 6, !"_ZTS3six", [[META4]], i64 0, i64 1, [[META4]], i64 4, i64 1, [[META4]], i64 5, i64 1}
//.
