/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mni extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bn = "বাংলা";
        final String metaValue_ko = "কোরিয়ন";
        final Object[][] data = new Object[][] {
            { "001", "মালেম" },
            { "002", "অফ্রিকা" },
            { "019", "অমেরিকাশিং" },
            { "150", "য়ুরোপ" },
            { "BR", "ব্রাজিল" },
            { "CN", "চিনা" },
            { "DE", "জর্মনি" },
            { "FR", "ফ্রান্স" },
            { "GB", "য়ুনাইটেদ কিংদম" },
            { "IN", "ইন্দিয়া" },
            { "IT", "ইটালি" },
            { "JP", "জাপান" },
            { "RU", "রুসিয়া" },
            { "US", "য়ুনাইটেদ ষ্টেটস" },
            { "ZZ", "মশকখংদবা লমদম" },
            { "ar", "আরাবিক" },
            { "bn", metaValue_bn },
            { "de", "জর্মন" },
            { "en", "ইংলিস" },
            { "es", "স্পেনিস" },
            { "fr", "ফ্রেঞ্চ" },
            { "hi", "হিন্দী" },
            { "id", "ইন্দোনেসিয়া" },
            { "it", "ইটালিয়ন" },
            { "ja", "জাপানিজ" },
            { "ko", metaValue_ko },
            { "nl", "দচ" },
            { "pl", "পোলিশ" },
            { "pt", "পোর্টুগিজ" },
            { "ru", "রুসিয়ান" },
            { "th", "থাই" },
            { "tr", "টর্কিশ" },
            { "zh", "চাইনিজ" },
            { "mni", "মৈতৈলোন্" },
            { "und", "মশকখংদবা লোল" },
            { "Arab", "আরবিক" },
            { "Beng", metaValue_bn },
            { "Cyrl", "সিরিলিক" },
            { "Hans", "লাইথোকহল্লবা" },
            { "Hant", "ত্রেদিস্নেল" },
            { "Jpan", "জপানিজ" },
            { "Kore", metaValue_ko },
            { "Latn", "লেটিন" },
            { "Mtei", "মীতৈ ময়েক" },
            { "Zxxx", "ইদবা" },
            { "Zzzz", "মশকখংদবা স্ক্রিপ্ট" },
            { "de_AT", "ওষ্ট্রিয়ান জর্মন" },
            { "de_CH", "স্বিজ হায় জর্মন" },
            { "en_AU", "ওষ্ট্রেলিয়ান ইংলিস" },
            { "en_CA", "কানাদিয়ান ইংলিস" },
            { "en_GB", "ব্রিটিশ ইংলিস" },
            { "en_US", "অমেরিকান ইংলিস" },
            { "es_ES", "য়ুরোপিয়ান স্পেনিস" },
            { "es_MX", "মেক্সিকান স্পেনিস" },
            { "fr_CA", "কানাদিয়ান ফ্রেঞ্চ" },
            { "fr_CH", "স্বিজ ফ্রেঞ্চ" },
            { "nl_BE", "ফ্লেমিশ" },
            { "pt_BR", "ব্রাজিলিয়ান পোর্টুগিজ" },
            { "pt_PT", "য়ুরোপিয়ান পোর্টুগিজ" },
            { "ar_001", "মোর্দর্ন স্তেন্দর্দ আরাবিক" },
            { "es_419", "লেটিন অমেরিকান স্পেনিস" },
            { "zh_Hans", "সিমপ্লিফাইদ চাইনিজ" },
            { "zh_Hant", "ত্রেদিস্নেল চাইনিজ" },
            { "type.nu.beng", "বাংলা দিজিট" },
            { "type.nu.latn", "ৱেস্তর্ন দিজিট" },
            { "type.co.standard", "ষ্টেন্দর্দ সোর্ট ওর্দর" },
            { "type.ca.gregorian", "গ্রিগোরিয়ান কেলেন্দর" },
        };
        return data;
    }
}
