PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE `migrations` (`id` text,PRIMARY KEY (`id`));
INSERT INTO migrations VALUES('202312101416');
INSERT INTO migrations VALUES('202312101430');
INSERT INTO migrations VALUES('202402151347');
INSERT INTO migrations VALUES('2024041121742');
INSERT INTO migrations VALUES('202406021630');
CREATE TABLE `users` (`id` integer PRIMARY KEY AUTOINCREMENT,`created_at` datetime,`updated_at` datetime,`deleted_at` datetime,`name` text,CONSTRAINT `uni_users_name` UNIQUE (`name`));
INSERT INTO users VALUES(1,'2024-09-27 14:26:08.573622915+00:00','2024-09-27 14:26:08.573622915+00:00',NULL,'user2');
INSERT INTO users VALUES(2,'2024-09-27 14:26:17.094350688+00:00','2024-09-27 14:26:17.094350688+00:00',NULL,'user1');
CREATE TABLE `pre_auth_keys` (`id` integer PRIMARY KEY AUTOINCREMENT,`key` text,`user_id` integer,`reusable` numeric,`ephemeral` numeric DEFAULT false,`used` numeric DEFAULT false,`created_at` datetime,`expiration` datetime,CONSTRAINT `fk_pre_auth_keys_user` FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE);
INSERT INTO pre_auth_keys VALUES(1,'3d133ec953e31fd41edbd935371234f762b4bae300cea618',1,1,0,1,'2024-09-27 14:26:14.737869796+00:00','2024-09-28 14:26:14.736601748+00:00');
INSERT INTO pre_auth_keys VALUES(2,'9813cc1df1832259fb6322dad788bb9bec89d8a01eef683a',2,1,0,1,'2024-09-27 14:26:23.181049239+00:00','2024-09-28 14:26:23.179903567+00:00');
CREATE TABLE `routes` (`id` integer PRIMARY KEY AUTOINCREMENT,`created_at` datetime,`updated_at` datetime,`deleted_at` datetime,`node_id` integer,`prefix` text,`advertised` numeric,`enabled` numeric,`is_primary` numeric,CONSTRAINT `fk_nodes_routes` FOREIGN KEY (`node_id`) REFERENCES `nodes`(`id`) ON DELETE CASCADE);
CREATE TABLE `pre_auth_key_acl_tags` (`id` integer PRIMARY KEY AUTOINCREMENT,`pre_auth_key_id` integer,`tag` text,CONSTRAINT `fk_pre_auth_keys_acl_tags` FOREIGN KEY (`pre_auth_key_id`) REFERENCES `pre_auth_keys`(`id`) ON DELETE CASCADE);
CREATE TABLE `api_keys` (`id` integer PRIMARY KEY AUTOINCREMENT,`prefix` text,`hash` blob,`created_at` datetime,`expiration` datetime,`last_seen` datetime);
CREATE TABLE IF NOT EXISTS "nodes"  (`id` integer PRIMARY KEY AUTOINCREMENT,`machine_key` text,`node_key` text,`disco_key` text,`endpoints` text,`host_info` text,`hostinfo` text,`ipv4` text,`ipv6` text,`hostname` text,`given_name` varchar(63),`user_id` integer,`register_method` text,`forced_tags` text,`auth_key_id` integer,`last_seen` datetime,`expiry` datetime,`created_at` datetime,`updated_at` datetime,`deleted_at` datetime,CONSTRAINT `fk_nodes_user` FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,CONSTRAINT `fk_nodes_auth_key` FOREIGN KEY (`auth_key_id`) REFERENCES `pre_auth_keys`(`id`) ON DELETE SET NULL);
INSERT INTO nodes VALUES(1,'mkey:1efe4388236c1c83fe0a19d3ce7c321ab81e138a4da57917c231ce4c01944409','nodekey:4091de8ee569b46a0cf322ae7350e80f3af4ccfd6d83a27ad4ce455982bd0f52','discokey:0ec0a701b7596a230fff993483c12019951899920fbc1eefa90f73f05147ea20','["172.19.0.5:50477"]','{"IPNVersion":"1.74.1-t0ca17be4a","BackendLogID":"ef6d8598273807218f7589f6c957f09d0caa2c146b71a22ab417bc2cd2c61e32","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.9","Desktop":false,"Package":"container","Hostname":"ts-1-74-9r0gv5","Machine":"aarch64","GoArch":"arm64","GoArchVar":"v8.0","GoVersion":"go1.23.1","Services":[{"Proto":"peerapi4","Port":48783},{"Proto":"peerapi6","Port":61271},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','{"IPNVersion":"1.74.1-t0ca17be4a","BackendLogID":"ef6d8598273807218f7589f6c957f09d0caa2c146b71a22ab417bc2cd2c61e32","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.9","Desktop":false,"Package":"container","Hostname":"ts-1-74-9r0gv5","Machine":"aarch64","GoArch":"arm64","GoArchVar":"v8.0","GoVersion":"go1.23.1","Services":[{"Proto":"peerapi4","Port":48783},{"Proto":"peerapi6","Port":61271},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','100.75.24.109','fd7a:115c:a1e0:6558:d71d:c420:6693:2137','ts-1-74-9r0gv5','ts-1-74-9r0gv5',1,'authkey','[]',1,'2024-09-27 14:26:16.86266134+00:00','0001-01-01 00:00:00+00:00','2024-09-27 14:26:14.818308317+00:00','2024-09-27 14:26:16.865671604+00:00',NULL);
INSERT INTO nodes VALUES(2,'mkey:779766343bd0311dd043e61f4e5ab13b43dbd9fef3c243aad406aac43146f566','nodekey:ae80297e118d23f00e029c89c82c53cf575803c40e0dfab5bf3f34213b265731','discokey:591540881c8a783dcfeeb1dbe049ce9a9b74347b6a96c0f17452735cb1de6c2f','["172.19.0.9:59415"]','{"IPNVersion":"1.73.0-dev20240911-t98f4dd985","BackendLogID":"98d5b64d1713a8048c260dc0a18d453bae0f144fdcccb31445356d30ef890a0b","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.9","Desktop":false,"Hostname":"ts-head-2rx0pf","Machine":"aarch64","GoArch":"arm64","GoArchVar":"v8.0","GoVersion":"go1.23.1","Services":[{"Proto":"peerapi4","Port":62304},{"Proto":"peerapi6","Port":58495},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','{"IPNVersion":"1.73.0-dev20240911-t98f4dd985","BackendLogID":"98d5b64d1713a8048c260dc0a18d453bae0f144fdcccb31445356d30ef890a0b","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.9","Desktop":false,"Hostname":"ts-head-2rx0pf","Machine":"aarch64","GoArch":"arm64","GoArchVar":"v8.0","GoVersion":"go1.23.1","Services":[{"Proto":"peerapi4","Port":62304},{"Proto":"peerapi6","Port":58495},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','100.66.134.61','fd7a:115c:a1e0:9f2a:7124:e520:c18e:1a70','ts-head-2rx0pf','ts-head-2rx0pf',1,'authkey','[]',1,'2024-09-27 14:26:16.872651222+00:00','0001-01-01 00:00:00+00:00','2024-09-27 14:26:14.824358847+00:00','2024-09-27 14:26:16.875317527+00:00',NULL);
INSERT INTO nodes VALUES(3,'mkey:233ecd117c36c1e5a635b1658fd54369fddf38b5312adf8aae38dfe6506fdf47','nodekey:2a53f1bbefae24a4724201379a05d32c84fc8c86fb2c856334a904ac53a3b827','discokey:acda4e99407eed3b807b81649998d69f93e9c28ce6e4dc1032686b45a70bca09','["172.19.0.6:38747"]','{"IPNVersion":"1.72.1-tf4a95663c","BackendLogID":"6d2ed9adf12339635cbe3098b0000898e1206217be28203e914c561b48d18d14","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.8","Desktop":false,"Package":"container","Hostname":"ts-1-72-tiaqxm","Machine":"aarch64","GoArch":"arm64","GoVersion":"go1.22.5","Services":[{"Proto":"peerapi4","Port":35537},{"Proto":"peerapi6","Port":52493},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','{"IPNVersion":"1.72.1-tf4a95663c","BackendLogID":"6d2ed9adf12339635cbe3098b0000898e1206217be28203e914c561b48d18d14","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.8","Desktop":false,"Package":"container","Hostname":"ts-1-72-tiaqxm","Machine":"aarch64","GoArch":"arm64","GoVersion":"go1.22.5","Services":[{"Proto":"peerapi4","Port":35537},{"Proto":"peerapi6","Port":52493},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','100.122.53.94','fd7a:115c:a1e0:7ff3:3849:312e:e0ce:b130','ts-1-72-tiaqxm','ts-1-72-tiaqxm',1,'authkey','[]',1,'2024-09-27 14:26:16.876448699+00:00','0001-01-01 00:00:00+00:00','2024-09-27 14:26:14.826628358+00:00','2024-09-27 14:26:16.877346245+00:00',NULL);
INSERT INTO nodes VALUES(4,'mkey:faa7947734ef7763fd18f23502b934d53d6f8120f6ff95dd3fd1efcda16b9b60','nodekey:2b463a60a90b18a43b64aab223e1f52887d67579b645eec44489c51ff0246e59','discokey:a4a8a7340733bc6fd01f9e3932e2c76311b06e63ed6d5f014e703bd02d664923','["172.19.0.4:40007"]','{"IPNVersion":"1.58.2-tb0e1bbb62","BackendLogID":"d136d72e6814dece6a96d1be183c76365a2998969a33b6dbcbcfa3fbc36c3441","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.5","Desktop":false,"Hostname":"ts-1-58-1nvqo9","Machine":"aarch64","GoArch":"arm64","GoVersion":"go1.21.5","Services":[{"Proto":"peerapi4","Port":39487},{"Proto":"peerapi6","Port":54215},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','{"IPNVersion":"1.58.2-tb0e1bbb62","BackendLogID":"d136d72e6814dece6a96d1be183c76365a2998969a33b6dbcbcfa3fbc36c3441","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.5","Desktop":false,"Hostname":"ts-1-58-1nvqo9","Machine":"aarch64","GoArch":"arm64","GoVersion":"go1.21.5","Services":[{"Proto":"peerapi4","Port":39487},{"Proto":"peerapi6","Port":54215},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','100.81.207.12','fd7a:115c:a1e0:6eab:4356:d2b2:3ec6:db5e','ts-1-58-1nvqo9','ts-1-58-1nvqo9',1,'authkey','[]',1,'2024-09-27 14:26:16.867951657+00:00','0001-01-01 00:00:00+00:00','2024-09-27 14:26:14.830098209+00:00','2024-09-27 14:26:16.872950015+00:00',NULL);
INSERT INTO nodes VALUES(5,'mkey:1dc2e7d2021e5e0ecfd5769e007088c570c24f92d72f8c81e9cbafaf651c321e','nodekey:ffde0f4d4b9a2365e2c62c47e86597565c7f95a47f0efe3468501d45e844cf31','discokey:aca5c0f12ea887b46ec89d4a2f5759587689a33757026760557bc9cf94979f4d','["172.19.0.7:46344"]','{"IPNVersion":"1.56.1-tf1ea3161a","BackendLogID":"c6ebd81c20af7b4aa066b458c48232d155b39b4cf2f51eb2247fdf75b7f133f6","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.5","Desktop":false,"Hostname":"ts-1-56-z9manh","Machine":"aarch64","GoArch":"arm64","GoVersion":"go1.21.5","Services":[{"Proto":"peerapi4","Port":58612},{"Proto":"peerapi6","Port":41402},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','{"IPNVersion":"1.56.1-tf1ea3161a","BackendLogID":"c6ebd81c20af7b4aa066b458c48232d155b39b4cf2f51eb2247fdf75b7f133f6","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.5","Desktop":false,"Hostname":"ts-1-56-z9manh","Machine":"aarch64","GoArch":"arm64","GoVersion":"go1.21.5","Services":[{"Proto":"peerapi4","Port":58612},{"Proto":"peerapi6","Port":41402},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','100.66.133.106','fd7a:115c:a1e0:fbd2:e73f:b9c7:6f65:b22f','ts-1-56-z9manh','ts-1-56-z9manh',1,'authkey','[]',1,'2024-09-27 14:26:16.878707293+00:00','0001-01-01 00:00:00+00:00','2024-09-27 14:26:14.830352877+00:00','2024-09-27 14:26:16.878994587+00:00',NULL);
INSERT INTO nodes VALUES(6,'mkey:a6b1a81c08622e5ba6ce0411be5d7a4a1cc9c56e1e2cb255a1411540a0353c5c','nodekey:951c0e942b007a32eada6c4de231537a49144ff36144ba09989142e48400aa72','discokey:a3addac173e10230313a823b88444fd082183dbd7a13b503c70eba1766ee5b5f','["172.19.0.8:40676"]','{"IPNVersion":"1.73.100-t7dcf65a10","BackendLogID":"352b9c938ef6fffd1e9d7b357370a9413abf57590c97f2176684b0572426c72c","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.8","Desktop":false,"Package":"container","Hostname":"ts-unstable-qxkobr","Machine":"aarch64","GoArch":"arm64","GoArchVar":"v8.0","GoVersion":"go1.23.0","Services":[{"Proto":"peerapi4","Port":56973},{"Proto":"peerapi6","Port":51259},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','{"IPNVersion":"1.73.100-t7dcf65a10","BackendLogID":"352b9c938ef6fffd1e9d7b357370a9413abf57590c97f2176684b0572426c72c","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.8","Desktop":false,"Package":"container","Hostname":"ts-unstable-qxkobr","Machine":"aarch64","GoArch":"arm64","GoArchVar":"v8.0","GoVersion":"go1.23.0","Services":[{"Proto":"peerapi4","Port":56973},{"Proto":"peerapi6","Port":51259},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','100.90.160.114','fd7a:115c:a1e0:8f5b:5b4c:2619:eb78:588d','ts-unstable-qxkobr','ts-unstable-qxkobr',1,'authkey','[]',1,'2024-09-27 14:26:16.872053136+00:00','0001-01-01 00:00:00+00:00','2024-09-27 14:26:14.846863625+00:00','2024-09-27 14:26:16.873881395+00:00',NULL);
INSERT INTO nodes VALUES(7,'mkey:49add8704a1d2ed2981cff46ca48eb8ebaf3c8c454b9b8ad23ad1f9e422aff48','nodekey:8fea100f6c7f4ad2d8104701611d1e071f3b7f97a74e447a668e8de15547e126','discokey:73ca6a00fbcd8d630566f9329c82c9a3d024430cdfec638347e87ad19add737d','["172.19.0.13:44781"]','{"IPNVersion":"1.58.2-tb0e1bbb62","BackendLogID":"40d54901b911fd583dfb54bbf328450fa1da24291a65c68a1b6799808e2c2952","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.5","Desktop":false,"Hostname":"ts-1-58-fvd14i","Machine":"aarch64","GoArch":"arm64","GoVersion":"go1.21.5","Services":[{"Proto":"peerapi4","Port":57976},{"Proto":"peerapi6","Port":55540},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','{"IPNVersion":"1.58.2-tb0e1bbb62","BackendLogID":"40d54901b911fd583dfb54bbf328450fa1da24291a65c68a1b6799808e2c2952","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.5","Desktop":false,"Hostname":"ts-1-58-fvd14i","Machine":"aarch64","GoArch":"arm64","GoVersion":"go1.21.5","Services":[{"Proto":"peerapi4","Port":57976},{"Proto":"peerapi6","Port":55540},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','100.104.229.213','fd7a:115c:a1e0:2652:4049:544d:31b3:7e65','ts-1-58-fvd14i','ts-1-58-fvd14i',2,'authkey','[]',2,'2024-09-27 14:26:25.289265425+00:00','0001-01-01 00:00:00+00:00','2024-09-27 14:26:23.255563272+00:00','2024-09-27 14:26:25.293329154+00:00',NULL);
INSERT INTO nodes VALUES(8,'mkey:232725e99c1aa8f275259e6a88e59f77d3e5a8644f987c3be56b9a9d8b0b6803','nodekey:9fff7b41b1e7739214078737b4d473518509916fd429f37dbcd21538cb420413','discokey:184f4a42db7e71f4c002befb59fe200aada0514b3290d4609258797f414c4246','["172.19.0.12:40625"]','{"IPNVersion":"1.74.1-t0ca17be4a","BackendLogID":"40d20ee5cc6374aecea21b6d996be3dddfde1a14a72f43b88abcf54ac4dc7393","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.9","Desktop":false,"Package":"container","Hostname":"ts-1-74-m8xzkz","Machine":"aarch64","GoArch":"arm64","GoArchVar":"v8.0","GoVersion":"go1.23.1","Services":[{"Proto":"peerapi4","Port":50864},{"Proto":"peerapi6","Port":57864},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','{"IPNVersion":"1.74.1-t0ca17be4a","BackendLogID":"40d20ee5cc6374aecea21b6d996be3dddfde1a14a72f43b88abcf54ac4dc7393","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.9","Desktop":false,"Package":"container","Hostname":"ts-1-74-m8xzkz","Machine":"aarch64","GoArch":"arm64","GoArchVar":"v8.0","GoVersion":"go1.23.1","Services":[{"Proto":"peerapi4","Port":50864},{"Proto":"peerapi6","Port":57864},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','100.103.73.167','fd7a:115c:a1e0:9094:220b:d07c:2ada:afa8','ts-1-74-m8xzkz','ts-1-74-m8xzkz',2,'authkey','[]',2,'2024-09-27 14:26:25.298808764+00:00','0001-01-01 00:00:00+00:00','2024-09-27 14:26:23.257602115+00:00','2024-09-27 14:26:25.299937061+00:00',NULL);
INSERT INTO nodes VALUES(9,'mkey:d86a2d3bf33f28068f41bcf28eaef65874e75645b8a209b8e8ff75b982fd3030','nodekey:b791922bf53ca56cf20eddab18f70819dd974e88f81e0899468bbdb5ce57a947','discokey:3053d621f5f6a66bed296ca47950c73c6baeac05f363e6b93f4de436e5480912','["172.19.0.11:35503"]','{"IPNVersion":"1.56.1-tf1ea3161a","BackendLogID":"0dcd9913179fdd831ed881b2c4bbdbd34f8c35cdc291b770af1de2bd6f65406f","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.5","Desktop":false,"Hostname":"ts-1-56-d68ebk","Machine":"aarch64","GoArch":"arm64","GoVersion":"go1.21.5","Services":[{"Proto":"peerapi4","Port":60691},{"Proto":"peerapi6","Port":52294},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','{"IPNVersion":"1.56.1-tf1ea3161a","BackendLogID":"0dcd9913179fdd831ed881b2c4bbdbd34f8c35cdc291b770af1de2bd6f65406f","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.5","Desktop":false,"Hostname":"ts-1-56-d68ebk","Machine":"aarch64","GoArch":"arm64","GoVersion":"go1.21.5","Services":[{"Proto":"peerapi4","Port":60691},{"Proto":"peerapi6","Port":52294},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','100.66.151.35','fd7a:115c:a1e0:3bb0:cb5d:ce50:aff7:e909','ts-1-56-d68ebk','ts-1-56-d68ebk',2,'authkey','[]',2,'2024-09-27 14:26:25.295234746+00:00','0001-01-01 00:00:00+00:00','2024-09-27 14:26:23.259854709+00:00','2024-09-27 14:26:25.299175891+00:00',NULL);
INSERT INTO nodes VALUES(10,'mkey:7c5d3c34416dcba5331cb4e982f2a39628e0f20af864f2dc3d374c78c3127f3f','nodekey:f9ce61c929baab74b66c15d06e1ed029b4a810b208cbcf09fc833579ef4c2d1d','discokey:6cf5becf49993e8346022e336d009aed97fc336b06bf5233f41fdd958125552e','["172.19.0.10:49139"]','{"IPNVersion":"1.73.100-t7dcf65a10","BackendLogID":"c8babece2de39ecf1fb604a6308ed4682bc80d57a20469f2a0a963839a3cf89a","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.8","Desktop":false,"Package":"container","Hostname":"ts-unstable-rww2w3","Machine":"aarch64","GoArch":"arm64","GoArchVar":"v8.0","GoVersion":"go1.23.0","Services":[{"Proto":"peerapi4","Port":34210},{"Proto":"peerapi6","Port":33839},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','{"IPNVersion":"1.73.100-t7dcf65a10","BackendLogID":"c8babece2de39ecf1fb604a6308ed4682bc80d57a20469f2a0a963839a3cf89a","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.8","Desktop":false,"Package":"container","Hostname":"ts-unstable-rww2w3","Machine":"aarch64","GoArch":"arm64","GoArchVar":"v8.0","GoVersion":"go1.23.0","Services":[{"Proto":"peerapi4","Port":34210},{"Proto":"peerapi6","Port":33839},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','100.80.216.124','fd7a:115c:a1e0:862b:7842:203c:b321:bc21','ts-unstable-rww2w3','ts-unstable-rww2w3',2,'authkey','[]',2,'2024-09-27 14:26:25.306378593+00:00','0001-01-01 00:00:00+00:00','2024-09-27 14:26:23.264221272+00:00','2024-09-27 14:26:25.307441765+00:00',NULL);
INSERT INTO nodes VALUES(11,'mkey:011d835011ce062b6d4599e12db61b40a0232841733bc562924e81f8fa27e918','nodekey:b0102b4105fee529bf2b639cda917764435532499bbe1e5b196912ade3fad74e','discokey:28b9ca33497f8e61af9a650ab7043c1c889c3dda3fc5502e57b26aa34320f92f','["172.19.0.14:33800"]','{"IPNVersion":"1.72.1-tf4a95663c","BackendLogID":"073c48058a504ed882178e356d461aa1ea43d2f0b18eb791dc776aafecb2916e","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.8","Desktop":false,"Package":"container","Hostname":"ts-1-72-au8tie","Machine":"aarch64","GoArch":"arm64","GoVersion":"go1.22.5","Services":[{"Proto":"peerapi4","Port":38962},{"Proto":"peerapi6","Port":42239},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','{"IPNVersion":"1.72.1-tf4a95663c","BackendLogID":"073c48058a504ed882178e356d461aa1ea43d2f0b18eb791dc776aafecb2916e","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.8","Desktop":false,"Package":"container","Hostname":"ts-1-72-au8tie","Machine":"aarch64","GoArch":"arm64","GoVersion":"go1.22.5","Services":[{"Proto":"peerapi4","Port":38962},{"Proto":"peerapi6","Port":42239},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','100.88.147.164','fd7a:115c:a1e0:82b7:17b5:cc3d:7714:4a61','ts-1-72-au8tie','ts-1-72-au8tie',2,'authkey','[]',2,'2024-09-27 14:26:25.305073961+00:00','0001-01-01 00:00:00+00:00','2024-09-27 14:26:23.266659201+00:00','2024-09-27 14:26:25.305586505+00:00',NULL);
INSERT INTO nodes VALUES(12,'mkey:7c2bcc073197a9e56d0eb13f0328e75768223569c2f4468d83d9ae05bfa50c5d','nodekey:d51788b3908c85e1d80ccc7f91e12d482e5da7dfb30d2f65f7161592d67a7f2e','discokey:a332f1553d1ad958abbe91dc0e3fc661e8f78864839f4bc7f8c8b0f12ef4e450','["172.19.0.15:47328"]','{"IPNVersion":"1.73.0-dev20240911-t98f4dd985","BackendLogID":"51a7c7677a3758f7a6c77fa555ab4834a0f5e7482bb64ddcde02c73ec9c2a138","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.9","Desktop":false,"Hostname":"ts-head-ujp4xa","Machine":"aarch64","GoArch":"arm64","GoArchVar":"v8.0","GoVersion":"go1.23.1","Services":[{"Proto":"peerapi4","Port":55532},{"Proto":"peerapi6","Port":55720},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','{"IPNVersion":"1.73.0-dev20240911-t98f4dd985","BackendLogID":"51a7c7677a3758f7a6c77fa555ab4834a0f5e7482bb64ddcde02c73ec9c2a138","OS":"linux","OSVersion":"6.8.0-36-generic","Container":true,"Distro":"alpine","DistroVersion":"3.18.9","Desktop":false,"Hostname":"ts-head-ujp4xa","Machine":"aarch64","GoArch":"arm64","GoArchVar":"v8.0","GoVersion":"go1.23.1","Services":[{"Proto":"peerapi4","Port":55532},{"Proto":"peerapi6","Port":55720},{"Proto":"peerapi-dns-proxy","Port":1}],"NetInfo":{"MappingVariesByDestIP":null,"HairPinning":null,"WorkingIPv6":false,"OSHasIPv6":true,"WorkingUDP":false,"WorkingICMPv4":false,"UPnP":false,"PMP":false,"PCP":false,"PreferredDERP":999,"FirewallMode":"ipt-default"},"Userspace":false,"UserspaceRouter":false,"AppConnector":false}','100.120.55.122','fd7a:115c:a1e0:b9b:d74c:e55a:c201:eb5','ts-head-ujp4xa','ts-head-ujp4xa',2,'authkey','[]',2,'2024-09-27 14:26:25.30691872+00:00','0001-01-01 00:00:00+00:00','2024-09-27 14:26:23.274483531+00:00','2024-09-27 14:26:25.30791685+00:00',NULL);
CREATE TABLE `policies` (`id` integer PRIMARY KEY AUTOINCREMENT,`created_at` datetime,`updated_at` datetime,`deleted_at` datetime,`data` text);
DELETE FROM sqlite_sequence;
INSERT INTO sqlite_sequence VALUES('nodes',12);
INSERT INTO sqlite_sequence VALUES('users',2);
INSERT INTO sqlite_sequence VALUES('pre_auth_keys',2);
CREATE INDEX `idx_users_deleted_at` ON `users`(`deleted_at`);
CREATE INDEX `idx_routes_deleted_at` ON `routes`(`deleted_at`);
CREATE UNIQUE INDEX `idx_api_keys_prefix` ON `api_keys`(`prefix`);
CREATE INDEX `idx_policies_deleted_at` ON `policies`(`deleted_at`);
COMMIT;
