// |jit-test| skip-if: !wasmSimdEnabled()

/* Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// ./test/core/simd/simd_f64x2_pmin_pmax.wast

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4
let $0 = instantiate(`(module
  (func (export "f64x2.pmin") (param v128 v128) (result v128) (f64x2.pmin (local.get 0) (local.get 1)))
  (func (export "f64x2.pmax") (param v128 v128) (result v128) (f64x2.pmax (local.get 0) (local.get 1)))
)`);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:9
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0, 0]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:12
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0, 0]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:15
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:18
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:21
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0, 0]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:24
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0, 0]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:27
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0, 0]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:30
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0, 0]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:33
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:36
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:39
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:42
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:45
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:48
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:51
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0, 0]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:54
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0, 0]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:57
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0, 0]), f64x2([123456789, 123456789])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:60
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:63
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:66
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:69
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0, 0]), f64x2([123456789, 123456789])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:72
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:75
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:78
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:81
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:84
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:87
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:90
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:93
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:96
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:99
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:102
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:105
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:108
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:111
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:114
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:117
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:120
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:123
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:126
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0, 0]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:129
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0, -0]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:132
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0, -0]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:135
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:138
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:141
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0, -0]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:144
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0, -0]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:147
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0, -0]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:150
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0, -0]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:153
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:156
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:159
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:162
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:165
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:168
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:171
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0, -0]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:174
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0, -0]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:177
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0, -0]), f64x2([123456789, 123456789])]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:180
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:183
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:186
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:189
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0, -0]), f64x2([123456789, 123456789])]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:192
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:195
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:198
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:201
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:204
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:207
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:210
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:213
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:216
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:219
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:222
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:225
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:228
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:231
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:234
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:237
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:240
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:243
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:246
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0, -0]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:249
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:252
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:255
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:258
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:261
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([0.5, 0.5]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:264
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:267
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1, 1]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:270
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:273
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:276
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:279
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:282
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:285
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:288
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:291
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:294
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:297
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:300
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:303
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:306
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:309
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:312
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:315
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:318
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:321
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:324
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:327
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:330
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:333
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:336
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:339
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:342
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:345
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:348
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:351
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:354
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:357
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:360
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:363
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:366
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:369
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([0, 0]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:372
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([-0, -0]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:375
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:378
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:381
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([0.5, 0.5]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:384
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:387
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1, 1]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:390
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:393
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:396
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:399
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:402
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:405
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:408
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:411
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:414
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:417
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:420
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:423
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:426
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:429
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:432
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:435
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:438
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:441
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:444
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:447
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:450
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:453
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:456
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:459
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:462
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:465
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:468
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:471
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:474
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:477
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:480
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:483
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:486
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:489
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0.5, 0.5]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:492
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0.5, 0.5]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:495
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:498
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:501
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0.5, 0.5]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:504
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0.5, 0.5]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:507
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0.5, 0.5]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:510
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0.5, 0.5]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:513
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:516
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:519
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:522
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:525
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:528
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:531
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0.5, 0.5]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:534
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0.5, 0.5]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:537
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0.5, 0.5]), f64x2([123456789, 123456789])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:540
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:543
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:546
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:549
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([0.5, 0.5]), f64x2([123456789, 123456789])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:552
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:555
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:558
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:561
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:564
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:567
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:570
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:573
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:576
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:579
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:582
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:585
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:588
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:591
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:594
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:597
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:600
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:603
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:606
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.5, 0.5]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:609
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0.5, -0.5]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:612
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0.5, -0.5]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:615
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:618
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:621
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0.5, -0.5]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:624
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0.5, -0.5]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:627
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0.5, -0.5]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:630
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0.5, -0.5]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:633
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:636
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:639
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:642
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:645
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:648
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:651
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0.5, -0.5]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:654
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0.5, -0.5]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:657
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0.5, -0.5]), f64x2([123456789, 123456789])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:660
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:663
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:666
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:669
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-0.5, -0.5]), f64x2([123456789, 123456789])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:672
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:675
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:678
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:681
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:684
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:687
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:690
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:693
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:696
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:699
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:702
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:705
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:708
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:711
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:714
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:717
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:720
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:723
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:726
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-0.5, -0.5]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:729
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([1, 1]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:732
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([1, 1]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:735
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:738
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:741
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([1, 1]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:744
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([1, 1]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:747
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([1, 1]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:750
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([1, 1]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:753
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:756
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:759
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:762
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:765
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:768
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:771
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([1, 1]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:774
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([1, 1]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:777
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([1, 1]), f64x2([123456789, 123456789])]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:780
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:783
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:786
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:789
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([1, 1]), f64x2([123456789, 123456789])]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:792
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:795
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:798
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:801
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:804
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:807
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:810
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:813
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:816
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:819
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:822
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:825
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:828
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:831
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:834
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:837
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:840
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:843
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:846
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1, 1]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:849
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-1, -1]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:852
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-1, -1]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:855
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:858
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:861
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-1, -1]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:864
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-1, -1]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:867
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-1, -1]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:870
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-1, -1]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:873
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:876
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:879
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:882
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:885
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:888
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:891
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-1, -1]), f64x2([Infinity, Infinity])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:894
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-1, -1]), f64x2([-Infinity, -Infinity])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:897
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-1, -1]), f64x2([123456789, 123456789])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:900
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:903
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:906
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:909
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-1, -1]), f64x2([123456789, 123456789])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:912
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:915
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:918
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:921
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:924
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:927
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:930
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:933
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:936
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:939
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:942
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:945
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:948
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:951
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:954
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:957
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:960
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:963
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:966
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-1, -1]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:969
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:972
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:975
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:978
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:981
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:984
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:987
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:990
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:993
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:996
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:999
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1002
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1005
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1008
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1011
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1014
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1017
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1020
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1023
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1026
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1029
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1032
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1035
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1038
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1041
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1044
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1047
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1050
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1053
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1056
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1059
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1062
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1065
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1068
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1071
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1074
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1077
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1080
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1083
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1086
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([6.283185307179586, 6.283185307179586]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1089
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([0, 0]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1092
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([-0, -0]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1095
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1098
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1101
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([0.5, 0.5]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1104
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([-0.5, -0.5]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1107
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([1, 1]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1110
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([-1, -1]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1113
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1116
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1119
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1122
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1125
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1128
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1131
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1134
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1137
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1140
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1143
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1146
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1149
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1152
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1155
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1158
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1161
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1164
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1167
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1170
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1173
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1176
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1179
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1182
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1185
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1188
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1191
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1194
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1197
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1200
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1203
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1206
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-6.283185307179586, -6.283185307179586]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1209
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1212
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1215
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1218
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1221
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1224
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1227
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1230
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1233
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1236
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1239
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", 179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1242
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1245
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1248
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1251
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", 179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1254
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1257
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1260
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1263
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1266
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1269
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1272
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1275
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1278
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1281
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1284
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1287
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1290
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1293
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1296
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1299
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1302
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1305
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1308
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1311
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1314
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1317
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1320
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1323
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1326
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1329
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([0, 0]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1332
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([-0, -0]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1335
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1338
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1341
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([0.5, 0.5]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1344
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([-0.5, -0.5]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1347
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1, 1]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1350
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([-1, -1]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1353
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1356
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1359
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1362
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1365
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1368
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1371
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1374
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1377
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1380
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1383
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1386
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1389
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1392
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1395
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1398
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1401
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1404
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1407
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1410
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1413
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1416
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1419
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1422
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1425
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1428
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1431
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1434
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1437
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1440
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1443
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1446
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1449
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1452
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1455
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1458
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1461
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([0.5, 0.5]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1464
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1467
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1, 1]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1470
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1473
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1476
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1479
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1482
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1485
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1488
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1491
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1494
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1497
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1500
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1503
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1506
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1509
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1512
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1515
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1518
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1521
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1524
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1527
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1530
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1533
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1536
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1539
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1542
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1545
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1548
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1551
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1554
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1557
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1560
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1563
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1566
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1569
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1572
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1575
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1578
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1581
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([0.5, 0.5]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1584
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1587
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1, 1]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1590
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1593
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1596
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1599
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1602
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1605
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1608
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1611
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1614
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1617
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1620
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1623
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1626
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1629
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1632
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1635
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1638
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1641
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1644
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1647
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1650
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1653
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1656
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1659
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1662
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1665
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1668
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1671
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1674
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1677
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1680
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1683
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1686
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1689
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([Infinity, Infinity]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1692
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([Infinity, Infinity]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1695
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1698
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1701
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([Infinity, Infinity]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1704
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([Infinity, Infinity]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1707
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([Infinity, Infinity]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1710
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([Infinity, Infinity]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1713
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1716
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1719
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", 179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1722
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1725
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1728
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1731
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([Infinity, Infinity]),
  ]),
  [new F64x2Pattern(value("f64", Infinity), value("f64", Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1734
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1737
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1740
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1743
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1746
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1749
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1752
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1755
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1758
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1761
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1764
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1767
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1770
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1773
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1776
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1779
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1782
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1785
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1788
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1791
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1794
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1797
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1800
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1803
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1806
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([Infinity, Infinity]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1809
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-Infinity, -Infinity]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1812
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-Infinity, -Infinity]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1815
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1818
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1821
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-Infinity, -Infinity]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1824
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-Infinity, -Infinity]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1827
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-Infinity, -Infinity]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1830
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([-Infinity, -Infinity]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1833
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1836
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1839
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1842
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1845
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1848
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1851
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([Infinity, Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1854
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1857
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1860
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1863
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1866
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1869
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1872
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1875
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1878
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1881
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1884
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1887
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1890
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1893
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1896
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1899
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1902
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1905
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1908
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1911
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1914
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1917
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1920
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1923
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1926
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([-Infinity, -Infinity]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1929
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([123456789, 123456789]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1932
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([123456789, 123456789]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1935
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1938
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1941
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([123456789, 123456789]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1944
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([123456789, 123456789]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1947
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([123456789, 123456789]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1950
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([123456789, 123456789]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1953
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1956
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1959
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1962
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1965
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1968
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1971
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([Infinity, Infinity]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1974
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1977
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1980
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1983
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1986
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1989
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1992
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1995
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:1998
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2001
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2004
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2007
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2010
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2013
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2016
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2019
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2022
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2025
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2028
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2031
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2034
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2037
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2040
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2043
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2046
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2049
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2052
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2055
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2058
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2061
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2064
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2067
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2070
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2073
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2076
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2079
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2082
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2085
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2088
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2091
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2094
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2097
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2100
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2103
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2106
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2109
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2112
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2115
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2118
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2121
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2124
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2127
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2130
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2133
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2136
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2139
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2142
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2145
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2148
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2151
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2154
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2157
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2160
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2163
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2166
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2169
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2172
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2175
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2178
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2181
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2184
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2187
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2190
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2193
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2196
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2199
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2202
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2205
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2208
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2211
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2214
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2217
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2220
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2223
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2226
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2229
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2232
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2235
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2238
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2241
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2244
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2247
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2250
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2253
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2256
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2259
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2262
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2265
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2268
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2271
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2274
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2277
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2280
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2283
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2286
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2289
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2292
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2295
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2298
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2301
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([0.5, 0.5]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2304
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2307
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1, 1]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2310
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2313
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2316
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2319
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2322
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2325
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2328
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2331
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2334
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2337
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2340
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2343
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2346
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2349
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2352
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2355
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2358
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2361
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2364
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2367
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2370
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2373
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2376
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2379
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2382
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2385
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2388
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2391
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2394
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2397
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2400
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2403
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2406
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2409
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([123456789, 123456789]), f64x2([0, 0])]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2412
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([123456789, 123456789]), f64x2([-0, -0])]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2415
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2418
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2421
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([123456789, 123456789]), f64x2([0.5, 0.5])]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2424
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([123456789, 123456789]), f64x2([-0.5, -0.5])]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2427
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([123456789, 123456789]), f64x2([1, 1])]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2430
assert_return(
  () => invoke($0, `f64x2.pmin`, [f64x2([123456789, 123456789]), f64x2([-1, -1])]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2433
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2436
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2439
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2442
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2445
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2448
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2451
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([Infinity, Infinity]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2454
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2457
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2460
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2463
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2466
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2469
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2472
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2475
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2478
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2481
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2484
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2487
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2490
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2493
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2496
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2499
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2502
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2505
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2508
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2511
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2514
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2517
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2520
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2523
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2526
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789, 123456789]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2529
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2532
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2535
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2538
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2541
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2544
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2547
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2550
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2553
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2556
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2559
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2562
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2565
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2568
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2571
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2574
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2577
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2580
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2583
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2586
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2589
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2592
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2595
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2598
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2601
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2604
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2607
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2610
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2613
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2616
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2619
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2622
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2625
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2628
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2631
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2634
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2637
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2640
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2643
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2646
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2649
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2652
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2655
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2658
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2661
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2664
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2667
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2670
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2673
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2676
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2679
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2682
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2685
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2688
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2691
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2694
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2697
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2700
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2703
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2706
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2709
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2712
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2715
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2718
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2721
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2724
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2727
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2730
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2733
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2736
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2739
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2742
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2745
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2748
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2751
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2754
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2757
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2760
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2763
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2766
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2769
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2772
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2775
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2778
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2781
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([0.5, 0.5]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2784
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2787
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1, 1]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2790
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2793
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2796
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2799
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2802
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2805
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2808
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2811
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2814
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2817
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2820
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2823
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2826
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2829
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2832
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2835
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2838
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2841
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2844
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2847
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2850
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2853
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2856
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2859
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2862
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2865
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2868
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2871
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2874
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2877
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2880
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2883
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2886
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2889
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2892
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2895
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2898
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2901
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2904
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2907
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2910
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2913
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2916
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2919
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2922
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2925
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2928
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2931
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2934
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2937
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2940
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2943
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2946
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2949
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2952
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2955
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2958
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2961
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2964
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2967
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2970
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2973
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2976
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2979
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2982
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2985
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2988
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2991
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2994
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:2997
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3000
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3003
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3006
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([123456789.01234567, 123456789.01234567]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3009
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3012
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3015
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3018
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3021
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3024
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3027
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3030
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3033
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3036
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3039
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3042
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3045
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3048
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3051
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3054
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3057
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3060
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3063
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3066
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3069
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3072
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3075
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3078
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3081
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3084
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3087
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3090
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3093
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3096
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3099
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3102
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3105
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3108
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3111
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3114
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3117
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3120
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3123
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3126
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3129
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3132
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3135
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3138
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3141
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3144
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3147
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3150
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3153
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3156
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3159
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3162
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3165
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3168
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3171
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3174
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3177
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3180
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3183
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3186
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3189
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3192
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3195
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3198
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3201
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3204
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3207
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3210
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3213
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3216
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3219
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3222
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3225
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3228
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3231
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3234
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3237
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3240
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3243
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3246
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3249
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3252
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3255
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3258
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3261
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([0.5, 0.5]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3264
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3267
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([1, 1]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3270
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3273
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3276
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3279
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3282
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3285
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3288
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3291
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3294
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3297
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3300
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3303
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3306
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3309
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([123456789, 123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3312
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3315
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3318
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3321
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3324
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3327
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3330
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3333
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3336
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3339
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3342
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3345
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3348
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3351
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3354
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3357
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3360
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3363
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3366
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3369
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3372
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3375
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3378
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3381
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3384
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3387
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3390
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3393
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3396
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3399
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3402
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3405
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3408
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3411
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3414
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3417
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3420
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3423
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3426
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3429
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3432
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3435
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3438
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3441
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3444
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3447
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3450
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3453
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3456
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3459
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3462
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3465
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3468
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3471
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3474
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3477
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3480
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3483
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3486
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3489
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3492
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3495
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3498
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3501
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3504
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3507
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3510
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3513
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3516
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3519
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3522
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3525
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3528
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3531
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3534
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3537
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3540
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3543
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3546
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3549
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3552
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3555
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3558
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3561
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3564
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3567
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3570
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3573
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3576
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3579
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3582
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3585
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3588
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3591
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3594
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3597
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3600
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3603
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3606
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3609
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3612
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3615
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3618
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3621
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3624
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3627
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3630
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3633
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3636
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3639
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3642
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3645
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3648
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3651
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3654
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3657
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3660
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3663
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3666
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3669
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3672
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3675
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3678
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3681
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3684
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3687
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3690
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3693
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3696
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3699
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3702
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3705
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3708
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3711
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3714
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3717
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3720
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3723
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3726
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3729
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3732
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3735
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3738
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3741
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3744
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3747
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3750
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3753
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3756
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3759
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3762
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3765
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3768
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3771
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3774
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3777
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3780
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3783
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3786
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3789
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3792
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3795
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3798
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3801
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3804
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3807
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3810
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3813
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3816
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3819
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3822
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3825
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3828
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3831
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3834
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3837
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3840
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3843
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3846
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3849
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3852
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3855
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3858
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3861
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3864
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3867
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3870
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3873
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3876
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3879
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3882
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3885
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3888
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3891
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3894
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3897
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3900
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3903
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3906
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3909
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3912
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3915
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3918
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3921
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3924
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3927
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3930
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3933
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3936
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3939
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3942
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3945
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3948
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3951
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3954
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3957
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3960
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3963
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3966
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3969
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3972
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3975
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3978
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3981
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3984
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3987
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3990
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3993
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3996
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:3999
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4002
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4005
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4008
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4011
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4014
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4017
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4020
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4023
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4026
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4029
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4032
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4035
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4038
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4041
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4044
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4047
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4050
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4053
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4056
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4059
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4062
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4065
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4068
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4071
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4074
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4077
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4080
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4083
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4086
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4089
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4092
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4095
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4098
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4101
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4104
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4107
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4110
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4113
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4116
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4119
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4122
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4125
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4128
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4131
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4134
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4137
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4140
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4143
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4146
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4149
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4152
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4155
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4158
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4161
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4164
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4167
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4170
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4173
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4176
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4179
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4182
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4185
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4188
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4191
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4194
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4197
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4200
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4203
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4206
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4209
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4212
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4215
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4218
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4221
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4224
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4227
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4230
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4233
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4236
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4239
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4242
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4245
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4248
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4251
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4254
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4257
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4260
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4263
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4266
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4269
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4272
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4275
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4278
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4281
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4284
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4287
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4290
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4293
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4296
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4299
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4302
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4305
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4308
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4311
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4314
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4317
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4320
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4323
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4326
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([2623536934927580700, 2623536934927580700]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4329
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4332
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4335
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4338
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4341
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4344
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4347
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4350
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4353
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4356
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4359
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4362
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4365
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4368
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4371
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4374
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4377
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4380
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4383
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4386
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4389
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4392
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4395
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4398
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4401
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4404
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4407
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4410
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4413
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4416
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4419
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4422
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4425
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4428
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4431
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4434
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4437
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4440
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4443
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4446
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4449
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4452
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4455
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4458
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4461
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4464
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4467
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4470
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4473
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4476
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4479
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4482
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4485
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4488
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4491
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4494
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4497
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4500
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4503
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4506
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4509
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4512
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4515
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4518
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4521
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4524
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4527
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4530
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4533
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4536
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4539
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4542
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4545
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4548
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4551
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4554
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4557
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4560
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4563
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4566
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4569
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0, 0]),
  ]),
  [new F64x2Pattern(value("f64", 0), value("f64", 0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4572
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-0, -0]),
  ]),
  [new F64x2Pattern(value("f64", -0), value("f64", -0))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4575
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4578
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
      -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
      value("f64", -0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022250738585072014),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4581
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.5, 0.5]),
  ]),
  [new F64x2Pattern(value("f64", 0.5), value("f64", 0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4584
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-0.5, -0.5]),
  ]),
  [new F64x2Pattern(value("f64", -0.5), value("f64", -0.5))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4587
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1, 1]),
  ]),
  [new F64x2Pattern(value("f64", 1), value("f64", 1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4590
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-1, -1]),
  ]),
  [new F64x2Pattern(value("f64", -1), value("f64", -1))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4593
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([6.283185307179586, 6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 6.283185307179586),
      value("f64", 6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4596
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-6.283185307179586, -6.283185307179586]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -6.283185307179586),
      value("f64", -6.283185307179586),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4599
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4602
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
      -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
      value("f64", -179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4605
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4608
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
      0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005,
    ]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
      value("f64", 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4611
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([Infinity, Infinity]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4614
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([-Infinity, -Infinity]),
  ]),
  [new F64x2Pattern(value("f64", -Infinity), value("f64", -Infinity))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4617
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4620
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4623
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4626
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4629
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([123456789, 123456789]),
  ]),
  [new F64x2Pattern(value("f64", 123456789), value("f64", 123456789))],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4632
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4635
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890000000000000000000, 1234567890000000000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890000000000000000000),
      value("f64", 1234567890000000000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4638
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.0000000000123456789, 0.0000000000123456789]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.0000000000123456789),
      value("f64", 0.0000000000123456789),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4641
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([123456789.01234567, 123456789.01234567]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 123456789.01234567),
      value("f64", 123456789.01234567),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4644
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4647
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1234567890123456900000000000, 1234567890123456900000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1234567890123456900000000000),
      value("f64", 1234567890123456900000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4650
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([0.000000000012345678901234568, 0.000000000012345678901234568]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 0.000000000012345678901234568),
      value("f64", 0.000000000012345678901234568),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4653
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4656
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4659
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4662
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4665
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4668
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4671
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 721152341463170500000000000000),
      value("f64", 721152341463170500000000000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4674
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([2623536934927580700, 2623536934927580700]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 2623536934927580700),
      value("f64", 2623536934927580700),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4677
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([1375488932539311400000000, 1375488932539311400000000]),
  ]),
  [
    new F64x2Pattern(
      value("f64", 1375488932539311400000000),
      value("f64", 1375488932539311400000000),
    ),
  ],
);

// ./test/core/simd/simd_f64x2_pmin_pmax.wast:4680
assert_return(
  () => invoke($0, `f64x2.pmin`, [
    f64x2([721152341463170500000000000000, 721152341463170500000000000000]),
    f64x2([721152341463170