/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;

public class MarkerType {
    private MarkerTypesModel model;
    private String id;
    private String label;
    private String[] supertypeIds;

    public MarkerType(MarkerTypesModel model, String id, String label, String[] supertypeIds) {
        this.model = model;
        this.id = id;
        this.label = label;
        this.supertypeIds = supertypeIds;
    }

    public MarkerType[] getAllSupertypes() {
        ArrayList<MarkerType> result = new ArrayList<MarkerType>();
        this.getAllSupertypes(result);
        return result.toArray(new MarkerType[result.size()]);
    }

    private void getAllSupertypes(ArrayList<MarkerType> result) {
        MarkerType[] markerTypeArray = this.getSupertypes();
        int n = markerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerType sup = markerTypeArray[n2];
            if (!result.contains(sup)) {
                result.add(sup);
                sup.getAllSupertypes(result);
            }
            ++n2;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public MarkerType[] getSubtypes() {
        MarkerType[] types = this.model.getTypes();
        ArrayList<MarkerType> result = new ArrayList<MarkerType>();
        MarkerType[] markerTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerType type = markerTypeArray[n2];
            String[] stringArray = type.getSupertypeIds();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String supertypeId = stringArray[n4];
                if (supertypeId.equals(this.id)) {
                    result.add(type);
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new MarkerType[result.size()]);
    }

    public MarkerType[] getAllSubTypes() {
        ArrayList<MarkerType> subTypes = new ArrayList<MarkerType>();
        this.addSubTypes(subTypes, this);
        MarkerType[] subs = new MarkerType[subTypes.size()];
        subTypes.toArray(subs);
        return subs;
    }

    private void addSubTypes(List<MarkerType> list, MarkerType superType) {
        MarkerType[] markerTypeArray = superType.getSubtypes();
        int n = markerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerType subType = markerTypeArray[n2];
            if (!list.contains(subType)) {
                list.add(subType);
            }
            this.addSubTypes(list, subType);
            ++n2;
        }
    }

    public String[] getSupertypeIds() {
        return this.supertypeIds;
    }

    public MarkerType[] getSupertypes() {
        ArrayList<MarkerType> result = new ArrayList<MarkerType>();
        String[] stringArray = this.supertypeIds;
        int n = this.supertypeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String supertypeId = stringArray[n2];
            MarkerType sup = this.model.getType(supertypeId);
            if (sup != null) {
                result.add(sup);
            }
            ++n2;
        }
        return result.toArray(new MarkerType[result.size()]);
    }

    public boolean isSubtypeOf(MarkerType superType) {
        if (this.id.equals(superType.getId())) {
            return true;
        }
        String[] stringArray = this.supertypeIds;
        int n = this.supertypeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String supertypeId = stringArray[n2];
            MarkerType sup = this.model.getType(supertypeId);
            if (sup != null && sup.isSubtypeOf(superType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (!(other instanceof MarkerType)) {
            return false;
        }
        return ((MarkerType)other).getId().equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

