/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.ExpressionListDeParser;

public class GroupByDeParser
extends AbstractDeParser<GroupByElement> {
    private final ExpressionListDeParser<?> expressionListDeParser;

    public GroupByDeParser(ExpressionVisitor<StringBuilder> expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionListDeParser = new ExpressionListDeParser(expressionVisitor, buffer);
        this.builder = buffer;
    }

    @Override
    public void deParse(GroupByElement groupBy) {
        this.builder.append("GROUP BY ");
        this.expressionListDeParser.deParse(groupBy.getGroupByExpressionList());
        int i = 0;
        if (!groupBy.getGroupingSets().isEmpty()) {
            if (this.builder.charAt(this.builder.length() - 1) != ' ') {
                this.builder.append(' ');
            }
            this.builder.append("GROUPING SETS (");
            for (ExpressionList<Expression> expressionList : groupBy.getGroupingSets()) {
                this.builder.append(i++ > 0 ? ", " : "");
                this.expressionListDeParser.deParse(expressionList);
            }
            this.builder.append(")");
        }
        if (groupBy.isMysqlWithRollup()) {
            this.builder.append(" WITH ROLLUP");
        }
    }
}

