/*
 * Decompiled with CFR 0.152.
 */
package mso.generator.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParserGeneratorUtils {
    static Collection<String> getDependencies(Element element) {
        TreeSet<String> treeSet = new TreeSet<String>();
        NodeList nodeList = element.getElementsByTagName("type");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (element2.hasAttribute("count") || element2.hasAttribute("array")) continue;
            treeSet.add(element2.getAttribute("type"));
        }
        return treeSet;
    }

    static List<Element> getOrderedStructureList(Document document) throws IOException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Node node = document.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !"struct".equals(node.getNodeName())) continue;
            arrayList.add((Element)node);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Element> arrayList3 = new ArrayList<Element>();
        while (arrayList.size() > 0) {
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                Element element = (Element)arrayList.get(n2);
                Collection<String> object2 = ParserGeneratorUtils.getDependencies(element);
                object2.removeAll(arrayList2);
                if (object2.size() == 0) {
                    arrayList3.add(element);
                    arrayList2.add(element.getAttribute("name"));
                    arrayList.remove(element);
                    continue;
                }
                ++n2;
            }
            if (n != arrayList.size()) continue;
            Object object = "";
            for (Element element : arrayList) {
                Collection<String> collection = ParserGeneratorUtils.getDependencies(element);
                collection.removeAll(arrayList2);
                object = (String)object + element.getAttribute("name") + ": " + collection + "\n";
            }
            throw new IOException((String)object + n);
        }
        return arrayList3;
    }

    public static Map<Integer, String> getRecordTypeNames(Document document) throws XPathExpressionException {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        XPath xPath = XPathFactory.newInstance().newXPath();
        String string = "/mso/struct/type[@name='rh']/limitation[@name='recType']";
        NodeList nodeList = (NodeList)xPath.evaluate(string, document, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            Object object = ((Element)element.getParentNode().getParentNode()).getAttribute("name");
            String string2 = element.getAttribute("value").replace("0x", "");
            for (String string3 : string2.split("\\|")) {
                int n = Integer.parseInt(string3, 16);
                if (hashMap.containsKey(n)) {
                    object = (String)hashMap.get(n) + "/" + (String)object;
                }
                hashMap.put(n, (String)object);
            }
        }
        return hashMap;
    }
}

