/*========================== begin_copyright_notice ============================

Copyright (C) 2023-2025 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/

//     File Name:  md_metric_sets_PVC_GT1.cpp
//
//     Abstract:   C++ automated generated file that defines Metric Sets
//                 for each Concurrent Group

#include "md_concurrent_group.h"
#include "md_metric_set.h"
#include "md_metric_sets_PVC_GT1.h"
#include "md_information.h"
#include "md_metric.h"
#include "md_utils.h"
#include <algorithm>

#if MD_INCLUDE_PVC_GT1_METRICS

namespace MetricsDiscoveryInternal::MetricSets_PVC_GT1_OA
{
    TCompletionCode AddInformationSet( CConcurrentGroup* concurrentGroup )
    {
        CInformation* information = nullptr;

        information = concurrentGroup->AddInformation( "QueryBeginTime", "Query Begin Time", "The measurement begin time.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM, INFORMATION_TYPE_TIMESTAMP, "ns", nullptr, 0 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "qw@0x1c0" ) );
        MD_CHECK_CC( information->SetOverflowFunction( "NS_TIME" ) );

        information = concurrentGroup->AddInformation( "CoreFrequencyMHz", "GPU Core Frequency", "The last GPU core (unslice) frequency in the measurement.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM, INFORMATION_TYPE_VALUE, "MHz", nullptr, 1 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 0x1ff AND 16666 UMUL 1000 UDIV" ) );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "qw@0x218 1000000 UDIV" ) );

        information = concurrentGroup->AddInformation( "XveSliceFrequencyMHz", "XVE Slice Frequency", "The last GPU Execution Unit slice frequency in the measurement.", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_VALUE, "MHz", nullptr, 2 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 25 >> dw@0x0 9 >> 0x3 AND OR 16666 UMUL 1000 UDIV" ) );

        information = concurrentGroup->AddInformation( "ReportReason", "Report Reason", "The reason of the report.", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_REPORT_REASON, nullptr, nullptr, 3 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 19 >> 0x7f AND" ) );

        information = concurrentGroup->AddInformation( "ContextIdValid", "Context ID Valid", "When set indicates render context is valid", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_FLAG, nullptr, nullptr, 4 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 16 >> 0x1 AND" ) );

        information = concurrentGroup->AddInformation( "ContextId", "Context ID", "The context tag in which report has been taken.", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_CONTEXT_ID_TAG, nullptr, nullptr, 5 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x08 0xffbfffff AND dw@0x0 16 >> 0x1 AND UMUL" ) );

        information = concurrentGroup->AddInformation( "SourceId", "SourceId", "SourceId", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_VALUE, nullptr, nullptr, 6 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 26 >> 0x3f AND" ) );

        information = concurrentGroup->AddInformation( "CoreFrequencyChanged", "GPU Core Frequency Changed", "The flag indicating that GPU core frequency has changed.", "Exception", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 7 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x214" ) );

        information = concurrentGroup->AddInformation( "QuerySplitOccurred", "Query Split Occurred", "The flag indicating that query has been split during execution on the GPU.", "Exception", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 8 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x210" ) );

        information = concurrentGroup->AddInformation( "ReportId", "Query report id", "Query report identification number.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_VALUE, nullptr, nullptr, 9 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x220" ) );

        information = concurrentGroup->AddInformation( "ReportsCount", "Query reports count", "The number of available query reports.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_VALUE, nullptr, nullptr, 10 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x224" ) );

        information = concurrentGroup->AddInformation( "OverrunOccured", "Query Overrun Occurred", "The flag indicating that Oa buffer has been overran.", "Exception", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 11 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1dc" ) );

        information = concurrentGroup->AddInformation( "MidQueryTimer", "Mid Query Timer", "The flag indicating that timer report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 12 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x01 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryProgramming", "Mid Query Programming", "The flag indicating that counter programming report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 13 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x02 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryMarker", "Mid Query Marker", "The flag indicating that query marker report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 14 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x04 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryCtxSwitch", "Mid Query Context Switch", "The flag indicating that context switch report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 15 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x08 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryC6", "Mid Query C6", "The flag indicating that C6 report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 16 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x10 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryFreqChange", "Mid Query Freq Change", "The flag indicating that frequency change report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 17 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x20 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryMmioTrigger", "Mid Query Mmio Trigger", "The flag indicating that mmio trigger report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 18 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x40 AND" ) );

        information = concurrentGroup->AddInformation( "StreamMarker", "Stream marker", "Stream marker value.", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_VALUE, nullptr, nullptr, 19 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x08 dw@0x0 19 >> 0x8 AND 0x0 == UMUL" ) );

        information = concurrentGroup->AddInformation( "ReportError", "Query report error", "An error in the query execution, the received report should be ignored.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 20 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x33 AND" ) );

        information = concurrentGroup->AddInformation( "ReportLost", "Query report lost", "Begin or end query report has not been triggered due to hw limitations.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 21 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x01 AND" ) );

        information = concurrentGroup->AddInformation( "ReportInconsistent", "Query report inconsistent", "The contextId inconsistency in the Oa buffer within the query window.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 22 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x02 AND" ) );

        information = concurrentGroup->AddInformation( "ReportCtxSwitchLost", "Query report context switch lost", "Other contexts activity is not filter out from the query report.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 23 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x08 AND" ) );

        information = concurrentGroup->AddInformation( "ReportWithoutWorkload", "Query report missing workload", "Missing workload between query begin and query end.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 24 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x10 AND" ) );

        information = concurrentGroup->AddInformation( "ReportContextMismatch", "Query report context mismatch", "Contexts on query begin and query end are different.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 25 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x20 AND" ) );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CComputeBasicMetricSet::CComputeBasicMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CComputeBasicMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_BYTE_READ", "L3 Byte Read",
            "Number of bytes read from L3",
            "L3Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 dw@0xfc dw@0xf8 UADD dw@0xf4 UADD dw@0xf0 UADD dw@0xec UADD dw@0xe8 UADD dw@0xe4 UADD dw@0xe0 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x1b8 qw@0x1b0 UADD qw@0x1a8 UADD qw@0x1a0 UADD qw@0x198 UADD qw@0x190 UADD qw@0x188 UADD qw@0x180 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "4096 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "L3_BYTE_WRITE", "L3 Byte Write",
            "Number of bytes written to L3",
            "L3Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 dw@0xdc dw@0xd8 UADD dw@0xd4 UADD dw@0xd0 UADD dw@0xcc UADD dw@0xc8 UADD dw@0xc4 UADD dw@0xc0 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x178 qw@0x170 UADD qw@0x168 UADD qw@0x160 UADD qw@0x158 UADD qw@0x150 UADD qw@0x148 UADD qw@0x140 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "4096 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "XVE_ATOMIC_ACCESS_COUNT", "XVE Atomic Access Count",
            "Number of shader atomic memory accesses",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x98" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x120" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_BARRIER_MESSAGE_COUNT", "XVE Barrier Message Count",
            "Number of shader barrier messages",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x9c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x128" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU0_ALL", "XVE Inst Executed ALU0 All",
            "Number of execution slots taken by instructions executed on ALU0 pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x38:0xaa" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x60" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU1_ALL", "XVE Inst Executed ALU1 All",
            "Number of execution slots taken by instructions executed on ALU1 pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x3c:0xab" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x68" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_XMX_ALL", "XVE Inst Executed XMX All",
            "Number of execution slots taken by instructions executed on XMX pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x40:0xac" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x70" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_SEND_ALL", "XVE Inst Executed Send All",
            "Number of instructions executed on SEND pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x50:0xb0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x90" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_CONTROL_ALL", "XVE Inst Executed Control All",
            "Number of instructions executed on Jump Pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x4c:0xaf" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x88" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_PIPE_ALU0_AND_ALU1_ACTIVE", "XVE Pipe ALU0 And ALU1 Active",
            "Percentage of time in which ALU0 and ALU1 pipes are both actively executing a Gen ISA instruction",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x44:0xad" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x78" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_PIPE_ALU0_AND_XMX_ACTIVE", "XVE_PIPE_ALU0_AND_XMX_ACTIVE",
            "Percentage of time in which ALU0 and XMX pipes are both actively executing a Gen ISA instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 20 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x48:0xae" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x80" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU0_ALL_UTILIZATION", "XVE Inst Executed ALU0 All Utilization",
            "Percentage of execution slots taken by instructions executed on ALU0 pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 21 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x38:0xaa" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x60" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU1_ALL_UTILIZATION", "XVE Inst Executed ALU1 All Utilization",
            "Percentage of execution slots taken by instructions executed on ALU1 pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 22 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x3c:0xab" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x68" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_SEND_ALL_UTILIZATION", "XVE Inst Executed Send All Utilization",
            "Percentage of time taken by instructions executed on SEND pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 23 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x50:0xb0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x90" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_CONTROL_ALL_UTILIZATION", "XVE Inst Executed Control All Utilization",
            "Percentage of time taken by instructions executed on Jump pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 24 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x4c:0xaf" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x88" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_XMX_ALL_UTILIZATION", "XVE Inst Executed XMX All Utilization",
            "Percentage of execution slots taken by instructions executed on XMX pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 25 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x40:0xac" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x70" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x044c2000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x064c7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04612000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06617000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06002000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08007005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06082005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08087000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x004c0010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a4c0140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x124c0340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00610010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a610005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1261000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00200010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02200010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02000010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1000000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00280002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02280002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e08000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04482000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06487000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04822000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06827000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00480010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08480140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10480340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00820010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08820005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1082000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x046d2000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x066d7140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x006d0010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e6d0340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04692140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06697000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00690010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c690340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0140a5e5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x3340a5e5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410a0f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4f410a0f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0104aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0304aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d504444, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e74000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e74000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ea8000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ea8000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e88000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e88000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f0c4c4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f19010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f19010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f24444, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f30080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f30090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f32002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28f30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f42020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f42020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c70010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c70010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ca0020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ca0020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c80010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c80010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cb0404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d00404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d10020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d10020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d30080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d30008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26d31002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cc4040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cd2000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02cd2000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cf4040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c11000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c11000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c43000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c43000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0050ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28500090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a501601, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c500030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e500808, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x305000a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x32501200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2250060b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24500080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26501404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d501010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f01010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f10100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f10100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f21010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f32000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f30280, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ec2020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ed0800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ed0800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ef2020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f40200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f40200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e10400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e10400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e20800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e20800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d31000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26d30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cc1010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cd0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02cd0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cf1010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c10200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c01010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e70040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e70040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ea00c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ea00c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f00808, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f10080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f10080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f30010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d500101, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f00101, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f10001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f10001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f20101, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f3000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f31400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ec0202, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ed0008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ed0008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ef0202, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f40002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f40002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e4000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e4000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c70001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c70001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ca0002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ca0002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c80001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c80001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cb0101, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d00101, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d10002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d10002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe658, 0x00009001, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe758, 0x0000a003, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe45c, 0x01002001, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CGpuOffloadMetricSet::CGpuOffloadMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CGpuOffloadMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "HOST_TO_GPUMEM_BYTE_READ", "Host To GpuMem Byte Read",
            "Number of bytes read by host from GPU local (HBM) memory (downstream)",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "64 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "HOST_TO_GPUMEM_BYTE_WRITE", "Host To GpuMem Byte Write",
            "Number of bytes written by host to GPU local (HBM) memory (downstream)",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "64 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "SYSMEM_BYTE_READ", "SysMem Byte Read",
            "Number of system memory bytes read (upstream)",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "64 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "SYSMEM_BYTE_WRITE", "SysMem Byte Write",
            "Number of system memory bytes written (upstream)",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "64 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "STACK_TO_STACK_DATA_BYTE_RECEIVE", "Stack To Stack Data Byte Receive",
            "Number of data bytes received (incoming write read return)",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "64 dw@0xd4 dw@0xd0 UADD dw@0xcc UADD dw@0xc8 UADD dw@0xc4 UADD dw@0xc0 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "64 qw@0x168 qw@0x160 UADD qw@0x158 UADD qw@0x150 UADD qw@0x148 UADD qw@0x140 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_DATA_BYTE_TRANSMIT", "Stack To Stack Data Byte Transmit",
            "Number of data bytes sent (outgoing write read return)",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "64 dw@0xec dw@0xe8 UADD dw@0xe4 UADD dw@0xe0 UADD dw@0xdc UADD dw@0xd8 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "64 qw@0x198 qw@0x190 UADD qw@0x188 UADD qw@0x180 UADD qw@0x178 UADD qw@0x170 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14307be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04306000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0050ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00300240, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e300752, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10300920, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02300000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a500200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e500001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x30500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x32500200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22501401, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x245000a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2650140a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16d45014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01405a95, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x334000a9, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0141a02a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4f410002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03075500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0308aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03030055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0104aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x030455aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03055500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0106f000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d500e38, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f00e38, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f10540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f10054, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f20e38, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f32400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f32002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f30012, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f40a80, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f400a8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d00e38, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d10540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d10054, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d20e38, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d32400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d32002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26d30012, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04d40010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08d40140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ad400c4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ed40380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10d4030d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16d45014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d5001c7, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f001c7, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f15015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f10001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f201c7, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f30092, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f30490, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f4a02a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f40002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d001c7, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d15015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d10001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d201c7, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d30092, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d30490, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04d40010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06d40414, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08d40003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cd4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ed4000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CMemProfileMetricSet::CMemProfileMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CMemProfileMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "SCALEUP_DATA_BYTE_RECEIVE", "Scaleup Data Byte Receive",
            "Number of data bytes received (incoming write read return to GPU)",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "64 dw@0xf4 dw@0xf8 UADD dw@0xfc UADD UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "64 qw@0x1a8 qw@0x1b0 UADD qw@0x1b8 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SCALEUP_DATA_BYTE_TRANSMIT", "Scaleup Data Byte Transmit",
            "Number of data bytes sent (outgoing write read return from GPU)",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "64 dw@0xe8 dw@0xec UADD dw@0xf0 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "64 qw@0x190 qw@0x198 UADD qw@0x1a0 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16d45014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d50fc00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f0fc00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f15550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f2fc00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f32492, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28f30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f4aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d0fc00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d15550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d2fc00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26d32492, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28d30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04d40002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10d40144, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12d402c6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14d4034c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x33405550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4f41fff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03035550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0304aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0050fc00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CDataportProfileMetricSet::CDataportProfileMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CDataportProfileMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ", "Dataport Byte Read",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "2 64 dw@0xfc UMUL 128 dw@0xf8 UMUL UADD 256 dw@0xf4 UMUL UADD 512 dw@0xf0 UMUL UADD UMUL 2 64 dw@0xec UMUL 128 dw@0xe8 UMUL UADD 256 dw@0xe4 UMUL UADD 512 dw@0xe0 UMUL UADD UMUL UADD $XeCoreTotalCount UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "2 64 qw@0x1b8 UMUL 128 qw@0x1b0 UMUL UADD 256 qw@0x1a8 UMUL UADD 512 qw@0x1a0 UMUL UADD UMUL 2 64 qw@0x198 UMUL 128 qw@0x190 UMUL UADD 256 qw@0x188 UMUL UADD 512 qw@0x180 UMUL UADD UMUL UADD $XeCoreTotalCount UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE", "DATAPORT BYTE WRITE ",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "32 dw@0xdc dw@0xd8 UADD dw@0xd4 UADD dw@0xd0 UADD dw@0xcc UADD dw@0xc8 UADD dw@0xc4 UADD dw@0xc0 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "32 qw@0x178 qw@0x170 UADD qw@0x168 UADD qw@0x160 UADD qw@0x158 UADD qw@0x150 UADD qw@0x148 UADD qw@0x140 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "32 $XeCoreTotalCount $GpuCoreClocks UMUL UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e030560, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e130160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e230560, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e330160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04033200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e030500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1403079f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1603071d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c130500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x041b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c1b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x081b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04233200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a230500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1023079f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1223071d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x042b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a2b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x082b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08330500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x043b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x083b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x003b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ff55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f030560, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f0b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f130160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f1b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f230560, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f2b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f330160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f3b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05033200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f030500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1503079f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1703071d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x050b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f0b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x090b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d130500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x051b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d1b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x091b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x011b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05233200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b230500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1123079f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1323071d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x052b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b2b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x092b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x012b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09330500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x053b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x093b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x013b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2ff55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e030560, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e130160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e230560, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e330160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04033200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e030500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1403079f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1603071d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c130500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x041b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c1b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x081b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04233200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a230500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1023079f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1223071d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x042b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a2b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x082b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08330500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x043b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x083b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x003b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ff55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f030560, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f0b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f130160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f1b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f230560, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f2b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f330160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f3b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05033200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f030500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1503079f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1703071d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x050b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f0b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x090b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d130500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x051b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d1b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x091b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x011b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05233200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b230500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1123079f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1323071d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x052b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b2b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x092b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x012b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09330500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x053b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x093b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x013b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2ff55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e030560, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e130160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e230560, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e330160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04033200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e030500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1403079f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1603071d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c130500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x041b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c1b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x081b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04233200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a230500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1023079f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1223071d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x042b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a2b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x082b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08330500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x043b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x083b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x003b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ff55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f030560, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f0b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f130160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f1b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f230560, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f2b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f330160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f3b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05033200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f030500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1503079f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1703071d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x050b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f0b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x090b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d130500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x051b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d1b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x091b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x011b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05233200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b230500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1123079f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1323071d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x052b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b2b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x092b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x012b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09330500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x053b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x093b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x013b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2ff55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e030560, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e130160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e230560, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e330160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04033200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e030500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1403079f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1603071d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c130500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x041b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c1b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x081b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04233200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a230500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1023079f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1223071d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x042b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a2b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x082b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08330500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x043b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x083b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x003b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ff55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f030560, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f0b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f130160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f1b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f230560, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f2b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f330160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f3b0160, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05033200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f030500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1503079f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1703071d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x050b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f0b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x090b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d130500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x051b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d1b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x091b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x011b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05233200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b230500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1123079f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1323071d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x052b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b2b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x092b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x012b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09330500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x053b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x093b0014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x013b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2ff55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30408, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CL1ProfileReadsMetricSet_XeCore0::CL1ProfileReadsMetricSet_XeCore0( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CL1ProfileReadsMetricSet_XeCore0::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_BYTE_READ", "Load Store Cache Byte Read",
            "Number of bytes read out of the Load Store Cache, excluding SLM accesses.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 $XeCoreTotalCount UMUL dw@0xc0 2 dw@0xc4 UMUL UADD 4 dw@0xc8 UMUL UADD 8 dw@0xcc UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xd4 UMUL UADD 64 dw@0xd8 UMUL UADD UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 $XeCoreTotalCount UMUL qw@0x140 2 qw@0x148 UMUL UADD 4 qw@0x150 UMUL UADD 8 qw@0x158 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x168 UMUL UADD 64 qw@0x170 UMUL UADD UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "512 $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "SLM_BYTE_READ", "SLM Byte Read",
            "Number of bytes read from SLM",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 $XeCoreTotalCount UMUL dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD 16 dw@0xec UMUL UADD 32 dw@0xe8 UMUL UADD 64 dw@0xe4 UMUL UADD dw@0xc0 2 dw@0xc4 UMUL UADD 4 dw@0xc8 UMUL UADD 8 dw@0xcc UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xd4 UMUL UADD 64 dw@0xd8 UMUL UADD USUB UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 $XeCoreTotalCount UMUL qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD 16 qw@0x198 UMUL UADD 32 qw@0x190 UMUL UADD 64 qw@0x188 UMUL UADD qw@0x140 2 qw@0x148 UMUL UADD 4 qw@0x150 UMUL UADD 8 qw@0x158 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x168 UMUL UADD 64 qw@0x170 UMUL UADD USUB UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "512 $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x007f0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000fe7f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc00, 0x0004000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc04, 0x00007ffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc08, 0x0002000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc0c, 0x0000bffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc10, 0x0001000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc14, 0x0000dffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc18, 0x0000800a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc1c, 0x0000effe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc20, 0x0000400a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc24, 0x0000f7fe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc28, 0x0000200a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc2c, 0x0000fbfe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc30, 0x0000100a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc34, 0x0000fdfe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CL1ProfileReadsMetricSet_XeCore4::CL1ProfileReadsMetricSet_XeCore4( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CL1ProfileReadsMetricSet_XeCore4::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_BYTE_READ", "Load Store Cache Byte Read",
            "Number of bytes read out of the Load Store Cache, excluding SLM accesses.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 $XeCoreTotalCount UMUL dw@0xc0 2 dw@0xc4 UMUL UADD 4 dw@0xc8 UMUL UADD 8 dw@0xcc UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xd4 UMUL UADD 64 dw@0xd8 UMUL UADD UMUL $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 $XeCoreTotalCount UMUL qw@0x140 2 qw@0x148 UMUL UADD 4 qw@0x150 UMUL UADD 8 qw@0x158 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x168 UMUL UADD 64 qw@0x170 UMUL UADD UMUL $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "512 $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "SLM_BYTE_READ", "SLM Byte Read",
            "Number of bytes read from SLM",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 $XeCoreTotalCount UMUL dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD 16 dw@0xec UMUL UADD 32 dw@0xe8 UMUL UADD 64 dw@0xe4 UMUL UADD dw@0xc0 2 dw@0xc4 UMUL UADD 4 dw@0xc8 UMUL UADD 8 dw@0xcc UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xd4 UMUL UADD 64 dw@0xd8 UMUL UADD USUB UMUL $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 $XeCoreTotalCount UMUL qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD 16 qw@0x198 UMUL UADD 32 qw@0x190 UMUL UADD 64 qw@0x188 UMUL UADD qw@0x140 2 qw@0x148 UMUL UADD 4 qw@0x150 UMUL UADD 8 qw@0x158 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x168 UMUL UADD 64 qw@0x170 UMUL UADD USUB UMUL $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "512 $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x007f0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000fe7f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc00, 0x0004000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc04, 0x00007ffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc08, 0x0002000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc0c, 0x0000bffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc10, 0x0001000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc14, 0x0000dffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc18, 0x0000800a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc1c, 0x0000effe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc20, 0x0000400a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc24, 0x0000f7fe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc28, 0x0000200a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc2c, 0x0000fbfe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc30, 0x0000100a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc34, 0x0000fdfe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CL1ProfileSlmBankConflictsMetricSet_XeCore0::CL1ProfileSlmBankConflictsMetricSet_XeCore0( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CL1ProfileSlmBankConflictsMetricSet_XeCore0::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "SLM_BANK_CONFLICT_COUNT", "SLM Bank Conflict Count",
            "Number of SLM accesses resulting in a bank conflict.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "2 dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD dw@0xec 2 dw@0xe8 UMUL UADD 4 dw@0xe4 UMUL UADD 8 dw@0xe0 UMUL UADD UADD dw@0xdc 2 dw@0xd8 UMUL UADD 4 dw@0xd4 UMUL UADD 8 dw@0xd0 UMUL UADD UADD dw@0xcc 2 dw@0xc8 UMUL UADD 4 dw@0xc4 UMUL UADD 8 dw@0xc0 UMUL UADD UADD UMUL $XeCoreTotalCount UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "2 qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD qw@0x198 2 qw@0x190 UMUL UADD 4 qw@0x188 UMUL UADD 8 qw@0x180 UMUL UADD UADD qw@0x178 2 qw@0x170 UMUL UADD 4 qw@0x168 UMUL UADD 8 qw@0x160 UMUL UADD UADD qw@0x158 2 qw@0x150 UMUL UADD 4 qw@0x148 UMUL UADD 8 qw@0x140 UMUL UADD UADD UMUL $XeCoreTotalCount UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc500a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c50200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac5046e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc507d0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec5001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc500a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0103ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c50200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc5046e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc507d0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc5001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc500a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c50200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac5046e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc507d0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec5001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc500a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0103ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c50200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc5046e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc507d0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc5001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc500a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c50200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac5046e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc507d0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec5001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc500a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0103ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c50200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc5046e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc507d0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc5001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc500a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0003ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c50200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac5046e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc507d0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec5001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc500a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0103ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c50200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc5046e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc507d0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc5001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CL1ProfileSlmBankConflictsMetricSet_XeCore4::CL1ProfileSlmBankConflictsMetricSet_XeCore4( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CL1ProfileSlmBankConflictsMetricSet_XeCore4::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "SLM_BANK_CONFLICT_COUNT", "SLM Bank Conflict Count",
            "Number of SLM accesses resulting in a bank conflict.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "2 dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD dw@0xec 2 dw@0xe8 UMUL UADD 4 dw@0xe4 UMUL UADD 8 dw@0xe0 UMUL UADD UADD dw@0xdc 2 dw@0xd8 UMUL UADD 4 dw@0xd4 UMUL UADD 8 dw@0xd0 UMUL UADD UADD dw@0xcc 2 dw@0xc8 UMUL UADD 4 dw@0xc4 UMUL UADD 8 dw@0xc0 UMUL UADD UADD UMUL $XeCoreTotalCount UMUL $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "2 qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD qw@0x198 2 qw@0x190 UMUL UADD 4 qw@0x188 UMUL UADD 8 qw@0x180 UMUL UADD UADD qw@0x178 2 qw@0x170 UMUL UADD 4 qw@0x168 UMUL UADD 8 qw@0x160 UMUL UADD UADD qw@0x158 2 qw@0x150 UMUL UADD 4 qw@0x148 UMUL UADD 8 qw@0x140 UMUL UADD UADD UMUL $XeCoreTotalCount UMUL $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24e414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ce500a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20e51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22e50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0023ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ce40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e50200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06e54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08e50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ae5046e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ce507d0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee5001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25e414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1de500a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21e51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23e50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0123ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e50200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07e54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09e50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0be5046e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de507d0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe5001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24e414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ce500a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20e51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22e50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0023ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ce40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e50200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06e54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08e50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ae5046e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ce507d0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee5001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25e414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1de500a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21e51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23e50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0123ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e50200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07e54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09e50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0be5046e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de507d0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe5001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24e414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ce500a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20e51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22e50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0023ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ce40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e50200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06e54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08e50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ae5046e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ce507d0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee5001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25e414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1de500a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21e51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23e50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0123ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e50200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07e54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09e50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0be5046e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de507d0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe5001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24e414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ce500a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20e51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22e50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0023ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ce40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e50200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06e54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08e50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ae5046e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ce507d0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee5001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25e414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1de500a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21e51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23e50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0123ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e50200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07e54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09e50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0be5046e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de507d0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe5001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc30102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30842, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CL1ProfileWritesMetricSet_XeCore0::CL1ProfileWritesMetricSet_XeCore0( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CL1ProfileWritesMetricSet_XeCore0::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_BYTE_WRITE", "Load Store Cache Byte Write",
            "Number of bytes written to the Load Store Cache, excluding SLM accesses.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 $XeCoreTotalCount UMUL dw@0xc0 2 dw@0xc4 UMUL UADD 4 dw@0xc8 UMUL UADD 8 dw@0xcc UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xd4 UMUL UADD 64 dw@0xd8 UMUL UADD UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 $XeCoreTotalCount UMUL qw@0x140 2 qw@0x148 UMUL UADD 4 qw@0x150 UMUL UADD 8 qw@0x158 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x168 UMUL UADD 64 qw@0x170 UMUL UADD UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "256 $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "SLM_BYTE_WRITE", "SLM Byte Write",
            "Number of bytes written to SLM",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 $XeCoreTotalCount UMUL dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD 16 dw@0xec UMUL UADD 32 dw@0xe8 UMUL UADD 64 dw@0xe4 UMUL UADD dw@0xc0 2 dw@0xc4 UMUL UADD 4 dw@0xc8 UMUL UADD 8 dw@0xcc UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xd4 UMUL UADD 64 dw@0xd8 UMUL UADD USUB UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 $XeCoreTotalCount UMUL qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD 16 qw@0x198 UMUL UADD 32 qw@0x190 UMUL UADD 64 qw@0x188 UMUL UADD qw@0x140 2 qw@0x148 UMUL UADD 4 qw@0x150 UMUL UADD 8 qw@0x158 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x168 UMUL UADD 64 qw@0x170 UMUL UADD USUB UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "256 $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x007f0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000fe7f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc00, 0x0004000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc04, 0x00007ffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc08, 0x0002000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc0c, 0x0000bffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc10, 0x0001000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc14, 0x0000dffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc18, 0x0000800a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc1c, 0x0000effe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc20, 0x0000400a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc24, 0x0000f7fe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc28, 0x0000200a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc2c, 0x0000fbfe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc30, 0x0000100a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc34, 0x0000fdfe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CL1ProfileWritesMetricSet_XeCore4::CL1ProfileWritesMetricSet_XeCore4( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CL1ProfileWritesMetricSet_XeCore4::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_BYTE_WRITE", "Load Store Cache Byte Write",
            "Number of bytes written to the Load Store Cache, excluding SLM accesses.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 $XeCoreTotalCount UMUL dw@0xc0 2 dw@0xc4 UMUL UADD 4 dw@0xc8 UMUL UADD 8 dw@0xcc UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xd4 UMUL UADD 64 dw@0xd8 UMUL UADD UMUL $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 $XeCoreTotalCount UMUL qw@0x140 2 qw@0x148 UMUL UADD 4 qw@0x150 UMUL UADD 8 qw@0x158 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x168 UMUL UADD 64 qw@0x170 UMUL UADD UMUL $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "256 $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "SLM_BYTE_WRITE", "SLM Byte Write",
            "Number of bytes written to SLM",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 $XeCoreTotalCount UMUL dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD 16 dw@0xec UMUL UADD 32 dw@0xe8 UMUL UADD 64 dw@0xe4 UMUL UADD dw@0xc0 2 dw@0xc4 UMUL UADD 4 dw@0xc8 UMUL UADD 8 dw@0xcc UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xd4 UMUL UADD 64 dw@0xd8 UMUL UADD USUB UMUL $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 $XeCoreTotalCount UMUL qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD 16 qw@0x198 UMUL UADD 32 qw@0x190 UMUL UADD 64 qw@0x188 UMUL UADD qw@0x140 2 qw@0x148 UMUL UADD 4 qw@0x150 UMUL UADD 8 qw@0x158 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x168 UMUL UADD 64 qw@0x170 UMUL UADD USUB UMUL $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "256 $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x007f0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000fe7f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc00, 0x0004000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc04, 0x00007ffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc08, 0x0002000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc0c, 0x0000bffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc10, 0x0001000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc14, 0x0000dffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc18, 0x0000800a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc1c, 0x0000effe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc20, 0x0000400a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc24, 0x0000f7fe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc28, 0x0000200a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc2c, 0x0000fbfe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc30, 0x0000100a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc34, 0x0000fdfe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CTestOaMetricSet::CTestOaMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CTestOaMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "Counter0", "TestCounter0",
            "HW test counter 0. Factor: 0.0",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter1", "TestCounter1",
            "HW test counter 1. Factor: 1.0",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter2", "TestCounter2",
            "HW test counter 2. Factor: 1.0",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter3", "TestCounter3",
            "HW test counter 3. Factor: 0.5",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter4", "TestCounter4",
            "HW test counter 4. Factor: 0.3333",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter5", "TestCounter5",
            "HW test counter 5. Factor: 0.3333",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter6", "TestCounter6",
            "HW test counter 6. Factor: 0.16666",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter7", "TestCounter7",
            "HW test counter 7. Factor: 0.6666",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter8", "TestCounter8",
            "HW test counter 8. Should be equal to 1 in IOStream or in OAG query mode",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x3b410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x33400001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07410006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f410cc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4f410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03030001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03040002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00500100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x30500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x32500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000004, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000003, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000007, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00100002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000fff7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00100002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00100082, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000ffef, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd970, 0x001000c2, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd974, 0x0000ffe7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd978, 0x00100001, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd97c, 0x0000ffe7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt1MetricSet::CExt1MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt1MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "HOST_TO_GPUMEM_TRANSACTION_READ", "Host To GpuMem Transaction Read",
            "Number of host reads to GPU local (HBM) memory (downstream)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "HOST_TO_GPUMEM_TRANSACTION_WRITE", "Host To GpuMem Transaction Write",
            "Number of host writes to GPU local (HBM) memory (downstream)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SYSMEM_TRANSACTION_READ", "SysMem Transaction Read",
            "Number of system memory reads (upstream)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SYSMEM_TRANSACTION_WRITE", "SysMem Transaction Write",
            "Number of system memory writes (upstream)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SCALEUP_DATA_BYTE_RECEIVE", "Scaleup Data Byte Receive",
            "Number of data bytes received (incoming write read return)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec dw@0xe8 UADD dw@0xe4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198 qw@0x190 UADD qw@0x188 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SCALEUP_INCOMING_ATOMIC_REQUEST", "Scaleup Incoming Atomic Request",
            "Number of incoming atomics requests over scaleup fabric",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0 dw@0xdc UADD dw@0xd8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180 qw@0x178 UADD qw@0x170 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SCALEUP_INCOMING_READ_REQUEST", "Scaleup Incoming Read Request",
            "Number of incoming read requests over scaleup fabric",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4 dw@0xd0 UADD dw@0xcc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168 qw@0x160 UADD qw@0x158 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SCALEUP_INCOMING_WRITE_REQUEST", "Scaleup Incoming Write Request",
            "Number of incoming write requests over scaleup fabric",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8 dw@0xc4 UADD dw@0xc0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150 qw@0x148 UADD qw@0x140 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14307fc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04306000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0050ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00300240, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e300824, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10300695, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02300000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x30500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x32500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22501400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x245000a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2650140a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16d40293, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d500fff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f00fff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f15555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f10055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f20fff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f32492, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f32492, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f30012, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f4aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f400aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d00fff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d15555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d10055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d20fff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d32492, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d32492, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26d30012, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04d40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06d4061c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08d40285, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ad40209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cd400c4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ed40342, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10d402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01405555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x33400055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0141ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4f4100ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03075500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0308aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03030055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0104aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x030455aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03055500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0106f000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt2MetricSet::CExt2MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt2MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "STACK_TO_STACK_DATA_BYTE_RECEIVE", "Stack To Stack Data Byte Receive",
            "Number of data bytes received (incoming write read return)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc dw@0xf8 UADD dw@0xf4 UADD dw@0xf0 UADD dw@0xec UADD dw@0xe8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8 qw@0x1b0 UADD qw@0x1a8 UADD qw@0x1a0 UADD qw@0x198 UADD qw@0x190 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_DATA_BYTE_TRANSMIT", "Stack To Stack Data Byte Transmit",
            "Number of data bytes sent (outgoing write read return)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4 dw@0xe0 UADD dw@0xdc UADD dw@0xd8 UADD dw@0xd4 UADD dw@0xd0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188 qw@0x180 UADD qw@0x178 UADD qw@0x170 UADD qw@0x168 UADD qw@0x160 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SCALEUP_DATA_BYTE_TRANSMIT", "Scaleup Data Byte Transmit",
            "Number of data bytes sent (outgoing write read return)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc dw@0xc8 UADD dw@0xc4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158 qw@0x150 UADD qw@0x148 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_DATA_BYTE_RECEIVE_L3NODE0", "Stack To Stack Data Byte Receive L3node0",
            "Number of data bytes received (incoming write read return)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc dw@0xf8 UADD dw@0xf4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8 qw@0x1b0 UADD qw@0x1a8 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_DATA_BYTE_RECEIVE_L3NODE2", "Stack To Stack Data Byte Receive L3node2",
            "Number of data bytes received (incoming write read return)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0 dw@0xec UADD dw@0xe8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0 qw@0x198 UADD qw@0x190 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_DATA_BYTE_TRANSMIT_L3NODE0", "Stack To Stack Data Byte Transmit L3node0",
            "Number of data bytes sent (outgoing write read return)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4 dw@0xe0 UADD dw@0xdc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188 qw@0x180 UADD qw@0x178 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_DATA_BYTE_TRANSMIT_L3NODE2", "Stack To Stack Data Byte Transmit L3node2",
            "Number of data bytes sent (outgoing write read return)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8 dw@0xd4 UADD dw@0xd0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170 qw@0x168 UADD qw@0x160 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16d45014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01409554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x3340a95a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01412afc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4f4102a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01035554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0104aaa8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0304aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d50e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f0e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f14000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f15405, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f2e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f32480, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f32400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28f30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f48000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f4a80a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d0e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d14000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d15405, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d2e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d32480, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26d32400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28d30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04d40002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cd40180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ed40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12d40340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14d402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16d45014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d501c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f01c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f11500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f10150, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f21c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f32000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f30012, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f30092, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f42a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f402a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d01c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d11500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d10150, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d21c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d32000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d30012, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26d30092, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04d40002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ad40146, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cd40004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10d4030d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12d4000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16d45000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d50000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f0000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f10054, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f2000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f30490, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f400a8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d0000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d10054, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d2000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d30490, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04d40002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06d40600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08d40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0050fffe, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x30500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x32500201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26500201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt3MetricSet::CExt3MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt3MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "STACK_TO_STACK_INCOMING_ATOMIC_REQUEST", "Stack To Stack Incoming Atomic Request",
            "Number of incoming atomics requests over stack to stack interface",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc dw@0xf8 UADD dw@0xf4 UADD dw@0xf0 UADD dw@0xec UADD dw@0xe8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8 qw@0x1b0 UADD qw@0x1a8 UADD qw@0x1a0 UADD qw@0x198 UADD qw@0x190 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_OUTGOING_ATOMIC_REQUEST", "Stack To Stack Outgoing Atomic Request",
            "Number of outgoing atomics requests over stack to stack interface",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4 dw@0xe0 UADD dw@0xdc UADD dw@0xd8 UADD dw@0xd4 UADD dw@0xd0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188 qw@0x180 UADD qw@0x178 UADD qw@0x170 UADD qw@0x168 UADD qw@0x160 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SCALEUP_OUTGOING_ATOMIC_REQUEST", "Scaleup Outgoing Atomic Request",
            "Number of outgoing atomics requests over scaleup fabric",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc dw@0xc8 UADD dw@0xc4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158 qw@0x150 UADD qw@0x148 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_INCOMING_ATOMIC_REQUEST_L3NODE0", "Stack To Stack Incoming Atomic Request L3node0",
            "Number of incoming atomics requests over stack to stack interface",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc dw@0xf8 UADD dw@0xf4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8 qw@0x1b0 UADD qw@0x1a8 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_INCOMING_ATOMIC_REQUEST_L3NODE2", "Stack To Stack Incoming Atomic Request L3node2",
            "Number of incoming atomics requests over stack to stack interface",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0 dw@0xec UADD dw@0xe8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0 qw@0x198 UADD qw@0x190 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_OUTGOING_ATOMIC_REQUEST_L3NODE0", "Stack To Stack Outgoing Atomic Request L3node0",
            "Number of outgoing atomics requests over stack to stack interface",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4 dw@0xe0 UADD dw@0xdc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188 qw@0x180 UADD qw@0x178 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_OUTGOING_ATOMIC_REQUEST_L3NODE2", "Stack To Stack Outgoing Atomic Request L3node2",
            "Number of outgoing atomics requests over stack to stack interface",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8 dw@0xd4 UADD dw@0xd0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170 qw@0x168 UADD qw@0x160 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16d44c13, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01409554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x3340a95a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01412afc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4f4102a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01035554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0104aaa8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0304aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d50e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f0e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f14000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f15405, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f2e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f32480, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f32400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28f30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f48000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f4a80a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d0e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d14000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d15405, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d2e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d32480, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26d32400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28d30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04d40002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cd40140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ed400c4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12d40300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14d4028b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16d44c13, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d501c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f01c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f11500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f10150, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f21c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f32000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f30012, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f30092, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f42a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f402a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d01c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d11500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d10150, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d21c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d32000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d30012, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26d30092, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04d40002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ad40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cd40003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10d402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12d4000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16d44c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d50000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f0000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f10054, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f2000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f30490, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f400a8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d0000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d10054, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d2000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d30490, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04d40002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06d40500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08d400c4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0050fffe, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x30500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x32500201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26500201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt4MetricSet::CExt4MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt4MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "STACK_TO_STACK_INCOMING_READ_REQUEST", "Stack To Stack Incoming Read Request",
            "Number of incoming read requests over stack to stack interface",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc dw@0xf8 UADD dw@0xf4 UADD dw@0xf0 UADD dw@0xec UADD dw@0xe8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8 qw@0x1b0 UADD qw@0x1a8 UADD qw@0x1a0 UADD qw@0x198 UADD qw@0x190 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_INCOMING_WRITE_REQUEST", "Stack To Stack Incoming Write Request",
            "Number of incoming write requests over stack to stack interface",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4 dw@0xe0 UADD dw@0xdc UADD dw@0xd8 UADD dw@0xd4 UADD dw@0xd0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188 qw@0x180 UADD qw@0x178 UADD qw@0x170 UADD qw@0x168 UADD qw@0x160 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SCALEUP_OUTGOING_READ_REQUEST", "Scaleup Outgoing Read Request",
            "Number of outgoing read requests over scaleup fabric",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc dw@0xc8 UADD dw@0xc4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158 qw@0x150 UADD qw@0x148 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_INCOMING_READ_REQUEST_L3NODE0", "Stack To Stack Incoming Read Request L3node0",
            "Number of incoming read requests over stack to stack interface",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc dw@0xf8 UADD dw@0xf4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8 qw@0x1b0 UADD qw@0x1a8 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_INCOMING_READ_REQUEST_L3NODE2", "Stack To Stack Incoming Read Request L3node2",
            "Number of incoming read requests over stack to stack interface",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0 dw@0xec UADD dw@0xe8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0 qw@0x198 UADD qw@0x190 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_INCOMING_WRITE_REQUEST_L3NODE0", "Stack To Stack Incoming Write Request L3node0",
            "Number of incoming write requests over stack to stack interface",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4 dw@0xe0 UADD dw@0xdc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188 qw@0x180 UADD qw@0x178 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_INCOMING_WRITE_REQUEST_L3NODE2", "Stack To Stack Incoming Write Request L3node2",
            "Number of incoming write requests over stack to stack interface",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8 dw@0xd4 UADD dw@0xd0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170 qw@0x168 UADD qw@0x160 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16d40293, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01409554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x3340a95a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01412afc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4f4102a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01035554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0104aaa8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0304aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d50e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f0e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f14000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f15405, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f2e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f32480, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f32400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28f30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f48000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f4a80a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d0e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d14000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d15405, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d2e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d32480, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26d32400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28d30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04d40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cd401c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ed40146, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12d40280, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14d40209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16d40293, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d501c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f01c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f11500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f10150, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f21c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f32000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f30012, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f30092, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f42a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f402a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d01c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d11500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d10150, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d21c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d32000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d30012, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26d30092, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04d40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ad40187, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cd40005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10d4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12d40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16d45000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d50000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f0000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f10054, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f2000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f30490, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f400a8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d0000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d10054, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d2000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d30490, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04d40002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06d40300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08d40042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0050fffe, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x30500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x32500201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26500201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt5MetricSet::CExt5MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt5MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "STACK_TO_STACK_OUTGOING_READ_REQUEST", "Stack To Stack Outgoing Read Request",
            "Number of outgoing read requests over stack to stack interface",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc dw@0xf8 UADD dw@0xf4 UADD dw@0xf0 UADD dw@0xec UADD dw@0xe8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8 qw@0x1b0 UADD qw@0x1a8 UADD qw@0x1a0 UADD qw@0x198 UADD qw@0x190 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_OUTGOING_WRITE_REQUEST", "Stack To Stack Outgoing Write Request",
            "Number of outgoing write requests over stack to stack interface",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4 dw@0xe0 UADD dw@0xdc UADD dw@0xd8 UADD dw@0xd4 UADD dw@0xd0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188 qw@0x180 UADD qw@0x178 UADD qw@0x170 UADD qw@0x168 UADD qw@0x160 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SCALEUP_OUTGOING_WRITE_REQUEST", "Scaleup Outgoing Write Request",
            "Number of outgoing write requests over scaleup fabric",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc dw@0xc8 UADD dw@0xc4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158 qw@0x150 UADD qw@0x148 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_OUTGOING_READ_REQUEST_L3NODE0", "Stack To Stack Outgoing Read Request L3node0",
            "Number of outgoing read requests over stack to stack interface",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc dw@0xf8 UADD dw@0xf4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8 qw@0x1b0 UADD qw@0x1a8 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_OUTGOING_READ_REQUEST_L3NODE2", "Stack To Stack Outgoing Read Request L3node2",
            "Number of outgoing read requests over stack to stack interface",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0 dw@0xec UADD dw@0xe8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0 qw@0x198 UADD qw@0x190 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_OUTGOING_WRITE_REQUEST_L3NODE0", "Stack To Stack Outgoing Write Request L3node0",
            "Number of outgoing write requests over stack to stack interface",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4 dw@0xe0 UADD dw@0xdc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188 qw@0x180 UADD qw@0x178 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_OUTGOING_WRITE_REQUEST_L3NODE2", "Stack To Stack Outgoing Write Request L3node2",
            "Number of outgoing write requests over stack to stack interface",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8 dw@0xd4 UADD dw@0xd0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170 qw@0x168 UADD qw@0x160 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16d45000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18d40013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01409554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x3340a95a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01412afc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4f4102a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01035554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0104aaa8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0304aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d50e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f0e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f14000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f15405, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f2e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f32480, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f32400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28f30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f48000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f4a80a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d0e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d14000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d15405, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d2e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d32480, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26d32400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28d30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04d4001a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cd40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ed4038f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12d400c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14d40042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16d45000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18d40013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d501c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f01c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f11500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f10150, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f21c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f32000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f30012, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f30092, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f42a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f402a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d01c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d11500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d10150, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d21c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d32000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d30012, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26d30092, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04d4001a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ad403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cd4000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10d40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12d40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16d45000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18d40013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d50000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f0000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f10054, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f2000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f30490, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f400a8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d0000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d10054, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d2000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d30490, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04d4001a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08d4038f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0050fffe, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x30500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x32500201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26500201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt6MetricSet::CExt6MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt6MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI0", "GPU Memory Byte Read Sqidi0",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI1", "GPU Memory Byte Read Sqidi1",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI2", "GPU Memory Byte Read Sqidi2",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI3", "GPU Memory Byte Read Sqidi3",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI4", "GPU Memory Byte Read Sqidi4",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI5", "GPU Memory Byte Read Sqidi5",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI6", "GPU Memory Byte Read Sqidi6",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI7", "GPU Memory Byte Read Sqidi7",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI8", "GPU Memory Byte Read Sqidi8",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI9", "GPU Memory Byte Read Sqidi9",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI10", "GPU Memory Byte Read Sqidi10",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI11", "GPU Memory Byte Read Sqidi11",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI12", "GPU Memory Byte Read Sqidi12",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI13", "GPU Memory Byte Read Sqidi13",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI14", "GPU Memory Byte Read Sqidi14",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI15", "GPU Memory Byte Read Sqidi15",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c000010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c0a0010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c0b0010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c020010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c030010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c080010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c090010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c0c0010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c0d0010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c0e0010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c0f0010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c040010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c050010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c060010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c070010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a109000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a110900, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00149000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00150900, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0050ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12000580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12010016, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000a0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080a0580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040a0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080b0016, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10030016, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00090200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a090016, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04090000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a120090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a130009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00160090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00170009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000c0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x060c0580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040c0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000d0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x060d0016, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040d0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000e0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040e0580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000f0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040f0016, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e040580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04040000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00050200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e050016, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04050000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00060200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c060580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04060000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00070200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c070016, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e500400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c500040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e500404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x30500020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x32500201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22500a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24500050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26500603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01400055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x33400055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4f410055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0307a000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010000c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010100c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01025a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0103aa55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03030055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0104aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x030455aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03055a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0106c000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01190050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x011b005a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x011c00aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x031c0055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x031e005a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x031000a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt7MetricSet::CExt7MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt7MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI0", "GPU Memory Byte Write Sqidi0",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI1", "GPU Memory Byte Write Sqidi1",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI2", "GPU Memory Byte Write Sqidi2",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI3", "GPU Memory Byte Write Sqidi3",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI4", "GPU Memory Byte Write Sqidi4",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI5", "GPU Memory Byte Write Sqidi5",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI6", "GPU Memory Byte Write Sqidi6",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI7", "GPU Memory Byte Write Sqidi7",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI8", "GPU Memory Byte Write Sqidi8",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI9", "GPU Memory Byte Write Sqidi9",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI10", "GPU Memory Byte Write Sqidi10",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI11", "GPU Memory Byte Write Sqidi11",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI12", "GPU Memory Byte Write Sqidi12",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI13", "GPU Memory Byte Write Sqidi13",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI14", "GPU Memory Byte Write Sqidi14",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI15", "GPU Memory Byte Write Sqidi15",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c000010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c0a0010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c0b0010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c020010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c030010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c080010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c090010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c0c0010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c0d0010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c0e0010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c0f0010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c040010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c050010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c060010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c070010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a109000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a110900, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00149000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00150900, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0050ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12000540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12010015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000a0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080a0540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040a0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10030015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00090200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a090015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04090000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a120090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a130009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00160090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00170009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000c0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x060c0540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040c0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000d0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x060d0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040d0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000e0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040e0540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000f0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040f0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e040540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04040000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00050200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e050015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04050000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00060200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c060540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04060000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00070200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c070015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e500400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c500040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e500404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x30500020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x32500201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22500a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24500050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26500603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01400055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x33400055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4f410055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0307a000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010000c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010100c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01025a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0103aa55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03030055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0104aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x030455aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03055a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0106c000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01190050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x011b005a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x011c00aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x031c0055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x031e005a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x031000a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt8MetricSet::CExt8MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt8MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI0", "GPU Memory Request Queue Full Sqidi0",
            "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI1", "GPU Memory Request Queue Full Sqidi1",
            "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI2", "GPU Memory Request Queue Full Sqidi2",
            "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI3", "GPU Memory Request Queue Full Sqidi3",
            "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI4", "GPU Memory Request Queue Full Sqidi4",
            "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI5", "GPU Memory Request Queue Full Sqidi5",
            "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI6", "GPU Memory Request Queue Full Sqidi6",
            "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI7", "GPU Memory Request Queue Full Sqidi7",
            "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI8", "GPU Memory Request Queue Full Sqidi8",
            "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI9", "GPU Memory Request Queue Full Sqidi9",
            "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI10", "GPU Memory Request Queue Full Sqidi10",
            "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI11", "GPU Memory Request Queue Full Sqidi11",
            "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI12", "GPU Memory Request Queue Full Sqidi12",
            "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI13", "GPU Memory Request Queue Full Sqidi13",
            "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI14", "GPU Memory Request Queue Full Sqidi14",
            "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI15", "GPU Memory Request Queue Full Sqidi15",
            "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14003400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14013400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x140a3400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x140b3400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14023400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14033400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14083400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14093400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x140c3400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x140d3400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x140e3400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x140f3400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14043400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14053400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14063400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14073400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a109000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a110900, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00149000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00150900, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0050ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12000080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000a0002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080a0080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040a0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080b0002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10030002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00090002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a090002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04090000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a120090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a130009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00160090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00170009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000c0002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x060c0080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040c0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000d0002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x060d0002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040d0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000e0002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040e0080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000f0002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040f0002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e040080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04040000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00050002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e050002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04050000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00060002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c060080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04060000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00070002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c070002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e500400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c500040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e500404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x30500020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x32500201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22500a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24500050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26500603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01400055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x33400055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4f410055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0307a000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010000c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010100c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01025a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0103aa55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03030055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0104aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x030455aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03055a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0106c000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01190050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x011b005a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x011c00aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x031c0055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x031e005a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x031000a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt9MetricSet::CExt9MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt9MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "COMMAND_PARSER_COPY_ENGINE_BUSY", "Command Parser Copy Engine Busy",
            "Percentage of time in which there is a context loaded and active on the copy queue.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "EU Array", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "EU Array", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_PIPE_ALU0_AND_ALU1_ACTIVE", "XVE Pipe ALU0 And ALU1 Active",
            "Percentage of time in which ALU0 and ALU1 pipes are both actively executing a Gen ISA instruction",
            "EU Array/Pipes", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_EU_PIPES * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x4c:0xaf" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x88" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_PIPE_ALU0_AND_ALU2_ACTIVE", "XVE Pipe ALU0 And ALU2 Active",
            "Percentage of time in which ALU0 and ALU2 pipes are both actively executing a Gen ISA instruction",
            "EU Array/Pipes", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_EU_PIPES * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x50:0xb0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x90" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "EU Array", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU0_ALL", "XVE Inst Executed ALU0 All",
            "Number of execution slots taken by instructions executed on ALU0 pipe",
            "EU Array/Pipes", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_EU_PIPES * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x48:0xae" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x80" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU1_ALL", "XVE Inst Executed ALU1 All",
            "Number of execution slots taken by instructions executed on ALU1 pipe",
            "EU Array/Pipes", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_EU_PIPES * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x44:0xad" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x78" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU2_ALL", "XVE Inst Executed ALU2 All",
            "Number of execution slots taken by instructions executed on ALU2 pipe",
            "EU Array/Pipes", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_EU_PIPES * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x38:0xaa" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x60" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_CONTROL_ALL", "XVE Inst Executed Control All",
            "Number of instructions executed on Jump Pipe",
            "EU Array", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x40:0xac" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x70" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_SEND_ALL", "XVE Inst Executed Send All",
            "Number of instructions executed on SEND pipe",
            "EU Array/Pipes", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_EU_PIPES * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x3c:0xab" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x68" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE_CYCLES", "XVE Active Cycles",
            "Number of cycles at least one pipe is active in XVE",
            "EU Array", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_ACTIVE" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_STALL_CYCLES", "XVE Stall Cycles",
            "Number of cycles any threads are loaded but not even a single pipe is active in XVE",
            "EU Array", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_STALL" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_CYCLES_ALL", "XVE Threads Occupancy Cycles All",
            "Number of thread slots occupied",
            "EU Array", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "8 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount $VectorEngineThreadsCount UMUL UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU0_ALL_UTILIZATION", "XVE Inst Executed ALU0 All Utilization",
            "Percentage of execution slots taken by instructions executed on ALU0 pipe",
            "EU Array/Pipes", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_EU_PIPES * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_INST_EXECUTED_ALU0_ALL $VectorEngineTotalCount FDIV $GpuCoreClocks FDIV" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU1_ALL_UTILIZATION", "XVE Inst Executed ALU1 All Utilization",
            "Percentage of execution slots taken by instructions executed on ALU1 pipe",
            "EU Array/Pipes", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_EU_PIPES * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_INST_EXECUTED_ALU1_ALL $VectorEngineTotalCount FDIV $GpuCoreClocks FDIV" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU2_ALL_UTILIZATION", "XVE Inst Executed ALU2 All Utilization",
            "Percentage of execution slots taken by instructions executed on ALU2 pipe",
            "EU Array/Pipes", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_EU_PIPES * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_INST_EXECUTED_ALU2_ALL $VectorEngineTotalCount FDIV $GpuCoreClocks FDIV" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_CONTROL_ALL_UTILIZATION", "XVE Inst Executed Control All Utilization",
            "Percentage of time taken by instructions executed on Jump pipe",
            "EU Array", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 20 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_INST_EXECUTED_CONTROL_ALL $VectorEngineTotalCount FDIV $GpuCoreClocks FDIV" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_SEND_ALL_UTILIZATION", "XVE Inst Executed Send All Utilization",
            "Percentage of time taken by instructions executed on SEND pipe",
            "EU Array/Pipes", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_EU_PIPES * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 21 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_INST_EXECUTED_SEND_ALL $VectorEngineTotalCount FDIV $GpuCoreClocks FDIV" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_PIPE_ALU0_AND_ALU2_ACTIVE_CYCLES", "XVE Pipe ALU0 And ALU2 Active Cycles",
            "Number of cycles in ALU0 and ALU2 pipes are both actively executing a Gen ISA instruction",
            "EU Array/Pipes", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_EU_PIPES * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 22 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_PIPE_ALU0_AND_ALU2_ACTIVE" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_PIPE_ALU0_AND_ALU1_ACTIVE_CYCLES", "XVE Pipe ALU0 And ALU1 Active Cycles",
            "Number of cycles in ALU0 and ALU1 pipes are both actively executing a Gen ISA instruction",
            "EU Array/Pipes", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_EU_PIPES * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 23 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_PIPE_ALU0_AND_ALU1_ACTIVE" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17400010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03400000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07400040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09400002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01400000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0104002a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00500007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x10800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000038, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fff8, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00009008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe658, 0x02001002, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe758, 0x00000001, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe45c, 0x0000a003, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt10MetricSet::CExt10MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt10MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "COMMAND_PARSER_COMPUTE_ENGINE_BUSY_CCS0", "Command Parser Compute Engine Busy Ccs0",
            "Percentage of time in which there is a context loaded and active on the compute queue",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "COMMAND_PARSER_COMPUTE_ENGINE_BUSY_CCS1", "Command Parser Compute Engine Busy Ccs1",
            "Percentage of time in which there is a context loaded and active on the compute queue",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "COMMAND_PARSER_COMPUTE_ENGINE_BUSY_CCS2", "Command Parser Compute Engine Busy Ccs2",
            "Percentage of time in which there is a context loaded and active on the compute queue",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "COMMAND_PARSER_COMPUTE_ENGINE_BUSY_CCS3", "Command Parser Compute Engine Busy Ccs3",
            "Percentage of time in which there is a context loaded and active on the compute queue",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "EU Array", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x54:0xb1" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x98" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_ACTIVE_CCS", "XVE Active CCS",
            "Percentage of time in which at least one pipe is active in XVE and there are Compute Shader (from Compute Engine) threads loaded",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x50:0xb0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x90" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_ACTIVE_CCCS", "XVE Active Cccs",
            "Percentage of time in which at least one pipe is active in XVE and there are Compute Shader (from Concurrent Compute Engine) threads loaded",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "EU Array", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x58:0xb2" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xa0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL_CCS", "XVE Stall CCS",
            "Percentage of time in which there are Compute Shader (from Compute Engine) threads loaded but not even a single pipe is active in XVE",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x40:0xac" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x70" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL_CCCS", "XVE Stall Cccs",
            "Percentage of time in which there are Compute Shader (from Concurrent Compute Engine) threads loaded but not even a single pipe is active in XVE",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU0_ALL", "XVE Inst Executed ALU0 All",
            "Number of execution slots taken by instructions executed on ALU0 pipe",
            "EU Array/Pipes", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_EU_PIPES * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x5c:0xb3" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xa8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU0_CCS", "XVE Inst Executed ALU0 CCS",
            "Number of execution slots taken by instructions executed by Compute Shader (from Compute Engine) on ALU0 pipe",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x4c:0xaf" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x88" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU0_CCCS", "XVE Inst Executed ALU0 Cccs",
            "Number of execution slots taken by instructions executed by Compute Shader (from Concurrent Compute Engine) on ALU0 pipe",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x3c:0xab" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x68" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU1_ALL", "XVE Inst Executed ALU1 All",
            "Number of execution slots taken by instructions executed on ALU1 pipe",
            "EU Array/Pipes", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_EU_PIPES * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x60:0xb4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xb0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU1_CCS", "XVE Inst Executed ALU1 CCS",
            "Number of execution slots taken by instructions executed by Compute Shader (from Compute Engine) on ALU1 pipe",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x48:0xae" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x80" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU1_CCCS", "XVE Inst Executed ALU1 Cccs",
            "Number of execution slots taken by instructions executed by Compute Shader (from Concurrent Compute Engine) on ALU1 pipe",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x38:0xaa" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x60" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_SEND_CCS", "XVE Inst Executed Send CCS",
            "Number of instructions executed by Compute Shader (from Compute Engine) threads on SEND pipe",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x44:0xad" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x78" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_SEND_CCCS", "XVE Inst Executed Send Cccs",
            "Number of instructions executed by Compute Shader (from Concurrent Compute Engine) threads on SEND pipe",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 20 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE_CYCLES", "XVE Active Cycles",
            "Number of cycles at least one pipe is active in XVE",
            "EU Array", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 21 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_ACTIVE" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_STALL_CYCLES", "XVE Stall Cycles",
            "Number of cycles any threads are loaded but not even a single pipe is active in XVE",
            "EU Array", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 22 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_STALL" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_STALL_CYCLES_CCCS", "XVE Stall Cycles Cccs",
            "Number of cycles there are Compute Shader (from Concurrent Compute Engine) threads loaded but not even a single pipe is active in XVE",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 23 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_STALL_CCCS" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE_CYCLES_CCCS", "XVE Active Cycles Cccs",
            "Number of cycles at least one pipe is active in XVE and there are Compute Shader (from Concurrent Compute Engine) threads loaded",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 24 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_ACTIVE_CCCS" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_STALL_CYCLES_CCS", "XVE Stall Cycles CCS",
            "Number of cycles there are Compute Shader (from Compute Engine) threads loaded but not even a single pipe is active in XVE",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 25 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_STALL_CCS" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE_CYCLES_CCS", "XVE Active Cycles CCS",
            "Number of cycles at least one pipe is active in XVE and there are Compute Shader (from Compute Engine) threads loaded",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 26 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_ACTIVE_CCS" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU0_CCCS_UTILIZATION", "XVE Inst Executed ALU0 Cccs Utilization",
            "Percentage of execution slots taken by instructions executed by Compute Shader (from Concurrent Compute Engine) on ALU0 pipe",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 27 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_INST_EXECUTED_ALU0_CCCS $VectorEngineTotalCount FDIV $GpuCoreClocks FDIV" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU1_CCCS_UTILIZATION", "XVE Inst Executed ALU1 Cccs Utilization",
            "Percentage of execution slots taken by instructions executed by Compute Shader (from Concurrent Compute Engine) on ALU1 pipe",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 28 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_INST_EXECUTED_ALU1_CCCS $VectorEngineTotalCount FDIV $GpuCoreClocks FDIV" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_SEND_CCCS_UTILIZATION", "XVE Inst Executed Send Cccs Utilization",
            "Percentage of time taken by instructions executed by Compute Shader (from Concurrent Compute Engine) threads on SEND pipe",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 29 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_INST_EXECUTED_SEND_CCCS $VectorEngineTotalCount FDIV $GpuCoreClocks FDIV" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU0_CCS_UTILIZATION", "XVE Inst Executed ALU0 CCS Utilization",
            "Percentage of execution slots taken by instructions executed by Compute Shader (from Compute Engine) on ALU0 pipe",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 30 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_INST_EXECUTED_ALU0_CCS $VectorEngineTotalCount FDIV $GpuCoreClocks FDIV" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU1_CCS_UTILIZATION", "XVE Inst Executed ALU1 CCS Utilization",
            "Percentage of execution slots taken by instructions executed by Compute Shader (from Compute Engine) on ALU1 pipe",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 31 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_INST_EXECUTED_ALU1_CCS $VectorEngineTotalCount FDIV $GpuCoreClocks FDIV" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_SEND_CCS_UTILIZATION", "XVE Inst Executed Send CCS Utilization",
            "Percentage of time taken by instructions executed by Compute Shader (from Compute Engine) threads on SEND pipe",
            "EU Array/Compute Shader", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 32 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_INST_EXECUTED_SEND_CCS $VectorEngineTotalCount FDIV $GpuCoreClocks FDIV" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU0_ALL_UTILIZATION", "XVE Inst Executed ALU0 All Utilization",
            "Percentage of execution slots taken by instructions executed on ALU0 pipe",
            "EU Array/Pipes", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_EU_PIPES * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 33 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_INST_EXECUTED_ALU0_ALL $VectorEngineTotalCount FDIV $GpuCoreClocks FDIV" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU1_ALL_UTILIZATION", "XVE Inst Executed ALU1 All Utilization",
            "Percentage of execution slots taken by instructions executed on ALU1 pipe",
            "EU Array/Pipes", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_EU_PIPES * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 34 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XVE_INST_EXECUTED_ALU1_ALL $VectorEngineTotalCount FDIV $GpuCoreClocks FDIV" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d400200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25400200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17410400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f410200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x27410200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03400a0c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07400040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09400002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13400450, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15400012, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01405540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x33400055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x034129c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b410040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d410202, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f410289, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11410450, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13410012, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4f410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03031555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0104aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03042aaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00507fff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e500400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a500001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x30500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x32500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22500200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26500001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x10800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000038, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fff8, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x000001c0, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000ffc7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000e00, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000fe3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00007000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000f1ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00038000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x00008fff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00065064, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00061062, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe658, 0x00095060, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe758, 0x00091092, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe45c, 0x00094090, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe55c, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe65c, 0x00001000, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt11MetricSet::CExt11MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt11MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_READ_L3BANK0", "L3 Read L3bank0",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK1", "L3 Read L3bank1",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK2", "L3 Read L3bank2",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK3", "L3 Read L3bank3",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK4", "L3 Read L3bank4",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK5", "L3 Read L3bank5",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK6", "L3 Read L3bank6",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK7", "L3 Read L3bank7",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK8", "L3 Read L3bank8",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK9", "L3 Read L3bank9",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK10", "L3 Read L3bank10",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK11", "L3 Read L3bank11",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK48", "L3 Read L3bank48",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK49", "L3 Read L3bank49",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK50", "L3 Read L3bank50",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK51", "L3 Read L3bank51",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x204c01c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x204801c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x206d01c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x206901c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x208a01c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x208e01c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x204001c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x204401c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x206101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x206501c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x208201c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x208601c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20040000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20050000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x024c0100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x124c0dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x044c0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02480100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12480037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04480000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x026d0100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x106d0dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x046d0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02690100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10690037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04690000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x028a0100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e8a0dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x048a0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x028e0100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e8e0037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x048e0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02400100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c400dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04400000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02440100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c440037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04440000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02610100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a610dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02650100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a650037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04650000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02820100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08820dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02860100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08860037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04860000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0020005a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08000dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08010037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04040000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06040dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04050000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06050037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00050000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0140aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x3340aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0104aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0304aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d5003ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e74420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ea8c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e60400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e88000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f0a7ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f15555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f18825, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f203ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f32492, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f32492, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f3144a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28f30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ec5800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ed2280, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ef5800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f4aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f4000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e11180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e42300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e00800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e22000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c71255, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c70001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ca30aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ca0002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c60010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c80055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c80002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cb000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d0015f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d122aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d10002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d32492, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d31451, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cc02a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cd8800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02cd0008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cf02a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c14800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c4c000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c20008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0050ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a500200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c500050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e500a04, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x30500040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x32500604, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x205000b0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2250140a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x245000b0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26501409, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt12MetricSet::CExt12MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt12MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_READ_L3BANK12", "L3 Read L3bank12",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK13", "L3 Read L3bank13",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK14", "L3 Read L3bank14",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK15", "L3 Read L3bank15",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK16", "L3 Read L3bank16",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK17", "L3 Read L3bank17",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK18", "L3 Read L3bank18",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK19", "L3 Read L3bank19",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK20", "L3 Read L3bank20",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK21", "L3 Read L3bank21",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK22", "L3 Read L3bank22",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK23", "L3 Read L3bank23",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK52", "L3 Read L3bank52",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK53", "L3 Read L3bank53",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK54", "L3 Read L3bank54",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK55", "L3 Read L3bank55",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x204c01c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x204801c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x206d01c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x206901c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x208a01c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x208e01c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x204001c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x204401c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x206101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x206501c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x208201c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x208601c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x024c0100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x124c0dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x044c0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02480100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12480037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04480000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x026d0100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x106d0dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x046d0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02690100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10690037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04690000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x028a0100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e8a0dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x048a0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x028e0100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e8e0037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x048e0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02400100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c400dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04400000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02440100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c440037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04440000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02610100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a610dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02650100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a650037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04650000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02820100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08820dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02860100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08860037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04860000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20060000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0021005a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08020dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08030037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04060000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06060dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00060001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06070037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x014055aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x33405555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0141aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4f41aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0104aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0304aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e70055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ea00aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e80055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00eb000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f0000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f100aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f30492, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0050ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e501000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28500050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a500a04, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c500020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e500401, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x30500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x32500001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20500080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22500e07, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24500080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26500e06, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d5003f0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e74420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ea8c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e60400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e88000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f0a7f0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f15500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f18825, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f203f0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f32000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f32492, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f3144a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28f30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ec5800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ed2280, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ef5800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f4aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f4000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e11180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e42300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e00800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e22000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c71200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c70001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ca3000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ca0002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c60010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c80002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d00150, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d12200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d10002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d32000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d31451, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cc02a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cd8800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02cd0008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cf02a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c14800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c4c000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c20008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt13MetricSet::CExt13MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt13MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_READ_L3BANK24", "L3 Read L3bank24",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK25", "L3 Read L3bank25",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK26", "L3 Read L3bank26",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK27", "L3 Read L3bank27",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK28", "L3 Read L3bank28",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK29", "L3 Read L3bank29",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK30", "L3 Read L3bank30",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK31", "L3 Read L3bank31",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK32", "L3 Read L3bank32",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK33", "L3 Read L3bank33",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK34", "L3 Read L3bank34",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK35", "L3 Read L3bank35",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK56", "L3 Read L3bank56",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK57", "L3 Read L3bank57",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK58", "L3 Read L3bank58",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK59", "L3 Read L3bank59",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x204c01c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x204801c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x206d01c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x206901c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x208a01c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x208e01c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x204001c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x204401c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x206101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x206501c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x208201c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x208601c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x024c0100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x124c0dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x044c0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02480100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12480037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04480000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x026d0100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x106d0dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x046d0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02690100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10690037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04690000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x028a0100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e8a0dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x048a0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x028e0100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e8e0037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x048e0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02400100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c400dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04400000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02440100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c440037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04440000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02610100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a610dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02650100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a650037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04650000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02820100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08820dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02860100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08860037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04860000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x200c0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x200d0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20090000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0028005a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040c0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080c0dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x060c0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000c0004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040d0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080d0037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x060d0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000d0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04090000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06090037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00090000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0140ff55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x3340ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x014100ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0104aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0304aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0050ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a500200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c500060, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e500c05, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x30500050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x32500805, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x205000c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2250160b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x245000c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2650160a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d5003f0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e74420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ea8c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e60400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e88000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f0a7f0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f15500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f18825, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f203f0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f32000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f32492, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f3144a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28f30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ec5800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ed2280, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ef5800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f4aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f4000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e11180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e42300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e00800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e22000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c71200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c70001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ca3000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ca0002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c60010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c80002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d00150, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d12200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d10002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d32000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d31451, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cc02a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cd8800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02cd0008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cf02a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c14800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c4c000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c20008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d50000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f0000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f10055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f2000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f30492, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f400aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c70055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ca00aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c80055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cb000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d0000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d100aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d30492, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt14MetricSet::CExt14MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt14MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_READ_L3BANK36", "L3 Read L3bank36",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK37", "L3 Read L3bank37",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK38", "L3 Read L3bank38",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK39", "L3 Read L3bank39",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK40", "L3 Read L3bank40",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK41", "L3 Read L3bank41",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK42", "L3 Read L3bank42",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK43", "L3 Read L3bank43",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK44", "L3 Read L3bank44",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK45", "L3 Read L3bank45",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK46", "L3 Read L3bank46",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK47", "L3 Read L3bank47",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK60", "L3 Read L3bank60",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK61", "L3 Read L3bank61",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK62", "L3 Read L3bank62",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK63", "L3 Read L3bank63",
            "Number of L3 read requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x204c01c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x204801c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x206d01c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x206901c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x208a01c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x208e01c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x204001c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x204401c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x206101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x206501c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x208201c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x208601c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x024c0100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x124c0dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x044c0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02480100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12480037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04480000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x026d0100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x106d0dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x046d0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02690100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10690037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04690000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x028a0100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e8a0dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x048a0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x028e0100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e8e0037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x048e0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02400100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c400dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04400000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02440100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c440037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04440000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02610100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a610dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02650100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a650037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04650000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02820100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08820dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04820000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02860100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08860037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04860000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x200e0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x200f0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x200a0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x200b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0029005a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040e0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080e0dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x060e0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000e0004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040f0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080f0037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x060f0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000f0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040a0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x060a0dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000a0001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x060b0037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01405555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x33405555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0141ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4f41ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0104aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0304aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0050ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e500c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28500040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a500803, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c500020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e500401, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x30500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x32500001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20500080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22500e07, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24500080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26500e06, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1d5003f0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e70055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e74420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ea00aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ea8c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e60400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e80055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e88000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00eb000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f0a7ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f155aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f18825, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f203f0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f32492, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f32492, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f3144a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28f30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ec5800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ed2280, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ef5800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f4aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f4000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e11180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e42300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e00800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e22000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c71200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c70001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ca3000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ca0002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c60010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c80002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d00150, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d12200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d10002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d32000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d31451, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cc02a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cd8800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02cd0008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cf02a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c14800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c4c000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c20008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt15MetricSet::CExt15MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt15MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_WRITE_L3BANK0", "L3 Write L3bank0",
            "Number of L3 write requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_WRITE_L3BANK1", "L3_WRITE _L3BANK1",
            "The number of L3 Bank 1 write requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_WRITE_L3BANK2", "L3_WRITE _L3BANK2",
            "The number of L3 Bank 2 write requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "1", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshot