# -*- coding: utf-8 -*-

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.

from gallery_dl.extractor import koofr


__tests__ = (
{
    "#url"     : "https://k00.fr/cltf71jr",
    "#class"   : koofr.KoofrSharedExtractor,
    "#results" : "https://app.koofr.net/content/links/923b4f56-3aaf-49ee-95e3-d85c52b687b0/files/get/wsf-form-job-application-form.json?path=/&force=",
    "#sha1_content": "f65ccc63a99165ecb9ff2ab92302c25b245a904f",

    "contentType": "application/json",
    "extension"  : "json",
    "filename"   : "wsf-form-job-application-form",
    "hash"       : "99271125b819ee7907dc47ab723f6dc7",
    "modified"   : 1728623530078,
    "name"       : "wsf-form-job-application-form.json",
    "size"       : 18023,
    "tags"       : {},
    "type"       : "file",
},

{
    "#url"     : "https://app.koofr.net/links/923b4f56-3aaf-49ee-95e3-d85c52b687b0",
    "#class"   : koofr.KoofrSharedExtractor,
    "#results" : "https://app.koofr.net/content/links/923b4f56-3aaf-49ee-95e3-d85c52b687b0/files/get/wsf-form-job-application-form.json?path=/&force=",
    "#sha1_content": "f65ccc63a99165ecb9ff2ab92302c25b245a904f",

    "contentType": "application/json",
    "extension"  : "json",
    "filename"   : "wsf-form-job-application-form",
    "hash"       : "99271125b819ee7907dc47ab723f6dc7",
    "modified"   : 1728623530078,
    "name"       : "wsf-form-job-application-form.json",
    "size"       : 18023,
    "tags"       : {},
    "type"       : "file",
},

{
    "#url"     : "https://app.koofr.eu/links/923b4f56-3aaf-49ee-95e3-d85c52b687b0",
    "#class"   : koofr.KoofrSharedExtractor,
},

)
