/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.resumption;

import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.ResumptionSupportingConnectionStore;
import org.eclipse.californium.scandium.dtls.ResumptionVerificationResult;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.resumption.ResumptionVerifier;
import org.eclipse.californium.scandium.util.ServerNames;

public class ConnectionStoreResumptionVerifier
implements ResumptionVerifier {
    private volatile ResumptionSupportingConnectionStore connectionStore;

    public ConnectionStoreResumptionVerifier() {
    }

    public ConnectionStoreResumptionVerifier(ResumptionSupportingConnectionStore connectionStore) {
        this.setConnectionStore(connectionStore);
    }

    public boolean hasConnectionStore() {
        return this.connectionStore != null;
    }

    public void setConnectionStore(ResumptionSupportingConnectionStore connectionStore) {
        if (connectionStore == null) {
            throw new NullPointerException("Connection store must not be null!");
        }
        this.connectionStore = connectionStore;
    }

    @Override
    public ResumptionVerificationResult verifyResumptionRequest(ConnectionId cid, ServerNames serverName, SessionId sessionId) {
        DTLSSession session = this.connectionStore.find(sessionId);
        return new ResumptionVerificationResult(cid, session, null);
    }

    @Override
    public void setResultHandler(HandshakeResultHandler resultHandler) {
    }
}

