/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.model;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.model.JBBPAbstractArrayField;
import com.igormaznitsa.jbbp.model.JBBPFieldDouble;
import com.igormaznitsa.jbbp.model.JBBPFieldLong;
import com.igormaznitsa.jbbp.model.JBBPNumericArray;
import com.igormaznitsa.jbbp.utils.JBBPUtils;

public final class JBBPFieldArrayDouble
extends JBBPAbstractArrayField<JBBPFieldDouble>
implements JBBPNumericArray {
    private static final long serialVersionUID = -2146959311724853264L;
    private final double[] array;

    public JBBPFieldArrayDouble(JBBPNamedFieldInfo name, double[] array) {
        super(name);
        JBBPUtils.assertNotNull(array, "Array must not be null");
        this.array = array;
    }

    public double[] getArray() {
        return (double[])this.array.clone();
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public JBBPFieldDouble getElementAt(int index) {
        JBBPFieldDouble result = new JBBPFieldDouble(this.fieldNameInfo, this.array[index]);
        result.payload = this.payload;
        return result;
    }

    @Override
    public int getAsInt(int index) {
        return (int)Math.round(this.array[index]);
    }

    @Override
    public long getAsLong(int index) {
        return Math.round(this.array[index]);
    }

    public double getAsDouble(int index) {
        return this.array[index];
    }

    @Override
    public boolean getAsBool(int index) {
        return Double.compare(this.array[index], 0.0) != 0;
    }

    @Override
    public Object getValueArrayAsObject(boolean reverseBits) {
        double[] result;
        if (reverseBits) {
            result = (double[])this.array.clone();
            for (int i = 0; i < result.length; ++i) {
                result[i] = Double.longBitsToDouble(JBBPFieldLong.reverseBits(Double.doubleToLongBits(result[i])));
            }
        } else {
            result = (double[])this.array.clone();
        }
        return result;
    }

    @Override
    public String getTypeAsString() {
        return "doublej [" + this.array.length + "]";
    }
}

