/*
 * Decompiled with CFR 0.152.
 */
package si.uom;

import java.util.Set;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Speed;
import si.uom.quantity.Absement;
import si.uom.quantity.Action;
import si.uom.quantity.AngularAcceleration;
import si.uom.quantity.AngularSpeed;
import si.uom.quantity.AreaDensity;
import si.uom.quantity.Density;
import si.uom.quantity.DynamicViscosity;
import si.uom.quantity.ElectricPermittivity;
import si.uom.quantity.ElectricalConductivity;
import si.uom.quantity.ElectricalResistivity;
import si.uom.quantity.Impulse;
import si.uom.quantity.Intensity;
import si.uom.quantity.IonizingRadiation;
import si.uom.quantity.KinematicViscosity;
import si.uom.quantity.Luminance;
import si.uom.quantity.LuminousEfficacy;
import si.uom.quantity.MagneticFieldStrength;
import si.uom.quantity.MagneticPermeability;
import si.uom.quantity.MagnetomotiveForce;
import si.uom.quantity.MassFlowRate;
import si.uom.quantity.Momentum;
import si.uom.quantity.Radiance;
import si.uom.quantity.RadiantIntensity;
import si.uom.quantity.RadiationDoseAbsorbedRate;
import si.uom.quantity.WaveNumber;
import tech.units.indriya.AbstractSystemOfUnits;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.EBNFUnitFormat;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.unit.AlternateUnit;
import tech.units.indriya.unit.ProductUnit;
import tech.units.indriya.unit.Units;

public final class SI
extends Units {
    private static final SI INSTANCE = new SI();
    public static final AlternateUnit<MagnetomotiveForce> AMPERE_TURN = SI.addUnit(new AlternateUnit(AMPERE, "At"), MagnetomotiveForce.class);
    public static final Unit<Acceleration> METRE_PER_SQUARE_SECOND = SI.addUnit(new ProductUnit(METRE_PER_SECOND.divide(SECOND)), Acceleration.class);
    public static final Unit<Absement> METRE_SECOND = SI.addUnit(new ProductUnit(METRE.multiply(SECOND)), Absement.class);
    public static final Unit<Action> JOULE_SECOND = SI.addUnit(new ProductUnit(JOULE.multiply(SECOND)), Action.class);
    public static final Unit<ElectricPermittivity> FARAD_PER_METRE = SI.addUnit(new ProductUnit(FARAD.divide(METRE)), ElectricPermittivity.class);
    public static final Unit<ElectricalConductivity> SIEMENS_PER_METRE = SI.addUnit(new ProductUnit(SIEMENS.divide(METRE)), ElectricalConductivity.class);
    public static final Unit<ElectricalResistivity> OHM_METRE = SI.addUnit(new ProductUnit(OHM.multiply(METRE)), ElectricalResistivity.class);
    public static final Unit<MagneticPermeability> NEWTON_PER_SQUARE_AMPERE = SI.addUnit(new ProductUnit(NEWTON.divide(AMPERE.pow(2))), MagneticPermeability.class);
    public static final Unit<WaveNumber> RECIPROCAL_METRE = SI.addUnit(new ProductUnit(METRE.pow(-1)), WaveNumber.class);
    public static final Unit<DynamicViscosity> PASCAL_SECOND = SI.addUnit(new ProductUnit(PASCAL.multiply(SECOND)), DynamicViscosity.class);
    public static final Unit<Luminance> CANDELA_PER_SQUARE_METRE = SI.addUnit(new ProductUnit(CANDELA.divide(SQUARE_METRE)), Luminance.class);
    public static final Unit<KinematicViscosity> SQUARE_METRE_PER_SECOND = SI.addUnit(new ProductUnit(SQUARE_METRE.divide(SECOND)), KinematicViscosity.class);
    public static final Unit<MagneticFieldStrength> AMPERE_PER_METRE = SI.addUnit(new ProductUnit(AMPERE.divide(METRE)), MagneticFieldStrength.class);
    public static final Unit<IonizingRadiation> COULOMB_PER_KILOGRAM = SI.addUnit(new ProductUnit(COULOMB.divide(KILOGRAM)), IonizingRadiation.class);
    public static final Unit<RadiantIntensity> WATT_PER_STERADIAN = SI.addUnit(WATT.divide(STERADIAN).asType(RadiantIntensity.class));
    public static final Unit<Radiance> WATT_PER_STERADIAN_PER_SQUARE_METRE = SI.addUnit(WATT_PER_STERADIAN.divide(SQUARE_METRE).asType(Radiance.class));
    public static final Unit<Intensity> WATT_PER_SQUARE_METRE = SI.addUnit(WATT.divide(SQUARE_METRE).asType(Intensity.class));
    public static final Unit<AngularSpeed> RADIAN_PER_SECOND = SI.addUnit(new ProductUnit(RADIAN.divide(SECOND)), "Radian per second", AngularSpeed.class);
    public static final Unit<AngularAcceleration> RADIAN_PER_SQUARE_SECOND = SI.addUnit(new ProductUnit(RADIAN_PER_SECOND.divide(SECOND)), "Radian per square second", AngularAcceleration.class);
    public static final Unit<MassFlowRate> KILOGRAM_PER_SECOND = SI.addUnit(new ProductUnit(KILOGRAM.divide(SECOND)), MassFlowRate.class);
    public static final Unit<Impulse> NEWTON_SECOND = SI.addUnit(new ProductUnit(NEWTON.multiply(SECOND)), Impulse.class);
    public static final Unit<Momentum> KILOGRAM_METRE_PER_SECOND = SI.addUnit(new ProductUnit(KILOGRAM.multiply(METRE_PER_SECOND)), Momentum.class);
    public static final Unit<AreaDensity> KILOGRAM_PER_SQUARE_METRE = SI.addUnit(new ProductUnit(KILOGRAM.divide(SQUARE_METRE)), AreaDensity.class);
    public static final Unit<Density> KILOGRAM_PER_CUBIC_METRE = SI.addUnit(new ProductUnit(KILOGRAM.divide(CUBIC_METRE)), Density.class);
    public static final Unit<RadiationDoseAbsorbedRate> GRAY_PER_SECOND = SI.addUnit(new ProductUnit(GRAY.divide(SECOND)), RadiationDoseAbsorbedRate.class);
    static final double AVOGADRO_CONSTANT_VALUE = 6.02214199E23;
    static final double BOLTZMANN_CONSTANT_VALUE = 1.3806485279E-23;
    static final double ELEMENTARY_CHARGE_VALUE = 1.602176462E-19;
    static final double PLANCK_CONSTANT_VALUE = 6.62607015E-34;
    public static final Unit<Dimensionless> AVOGADRO_CONSTANT = SI.addUnit(new AlternateUnit(AbstractUnit.ONE.divide(MOLE), "m-1").multiply(6.02214199E23), "NA", true);
    public static final Unit<Dimensionless> BOLTZMANN_CONSTANT = SI.addUnit(new AlternateUnit(JOULE.divide(KELVIN), "J/K").multiply(1.3806485279E-23), "kB", true);
    public static final Unit<Speed> C = SI.addUnit(METRE_PER_SECOND.multiply(2.99792458E8), "C", true);
    public static final Unit<Frequency> DELTA_V_CS = SI.addUnit(HERTZ.multiply(9.19263177E9), "\u0394\u03bd", true);
    public static final Unit<ElectricCharge> ELEMENTARY_CHARGE = SI.addUnit(COULOMB.multiply(1.602176462E-19), "e", true);
    public static final Unit<LuminousEfficacy> KCD = SI.addUnit(LUMEN.divide(WATT).multiply(683.0).asType(LuminousEfficacy.class), "KCD", true);
    public static final Unit<Action> PLANCK_CONSTANT = SI.addUnit(JOULE_SECOND.multiply(6.62607015E-34), "\u210e", true);

    private SI() {
    }

    public static SI getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return "SI";
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text, boolean isLabel) {
        if (isLabel) {
            SimpleUnitFormat.getInstance().label(unit, text);
            EBNFUnitFormat.getInstance().label(unit, text);
        }
        if (name != null && unit instanceof AbstractUnit) {
            return (U)AbstractSystemOfUnits.Helper.addUnit((Set)SI.INSTANCE.units, unit, (String)name);
        }
        SI.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String text, boolean isLabel) {
        return SI.addUnit(unit, null, text, isLabel);
    }

    private static <U extends AbstractUnit<?>> U addUnit(U unit, String name, String label, Class<? extends Quantity<?>> type) {
        SI.INSTANCE.quantityToUnit.put(type, unit);
        return SI.addUnit(unit, name, label);
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        SI.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends AbstractUnit<?>> U addUnit(U unit, String name, Class<? extends Quantity<?>> type) {
        AbstractSystemOfUnits.Helper.addUnit((Set)SI.INSTANCE.units, unit, (String)name);
        SI.INSTANCE.quantityToUnit.put(type, unit);
        return unit;
    }

    private static <U extends AbstractUnit<?>> U addUnit(U unit, Class<? extends Quantity<?>> type) {
        SI.INSTANCE.units.add(unit);
        SI.INSTANCE.quantityToUnit.put(type, unit);
        return unit;
    }

    private static <U extends AbstractUnit<?>> U addUnit(U unit, String name, String symbol) {
        return (U)((AbstractUnit)AbstractSystemOfUnits.Helper.addUnit((Set)SI.INSTANCE.units, unit, (String)name, (String)symbol));
    }

    static {
        SimpleUnitFormat.getInstance().alias(FARAD_PER_METRE, "\u03b5");
        EBNFUnitFormat.getInstance().alias(FARAD_PER_METRE, "\u03b5");
        EBNFUnitFormat.getInstance().label(AMPERE_TURN, "At");
    }
}

