.\" Automatically generated by Pandoc 3.6.3
.\"
.TH "SUDO" "8" "" "sudo\-rs 0.2.12" "sudo\-rs"
.SH NAME
\f[CR]sudo\f[R], \f[CR]sudoedit\f[R] \- execute a command as another
user
.SH SYNOPSIS
\f[CR]sudo\f[R] \f[CR]\-h\f[R] | \f[CR]\-K\f[R] | \f[CR]\-k\f[R] |
\f[CR]\-V\f[R]
.PD 0
.P
.PD
\f[CR]sudo\f[R] [\f[CR]\-u\f[R] \f[I]user\f[R]] [\f[CR]\-g\f[R]
\f[I]group\f[R]] [\f[CR]\-D\f[R] \f[I]directory\f[R]]
[\f[CR]\-BbknS\f[R]] [\f[CR]\-i\f[R] | \f[CR]\-s\f[R]]
[\f[CR]VAR=value\f[R]] [<\f[I]command\f[R]>]
.PD 0
.P
.PD
\f[CR]sudo\f[R] \f[CR]\-v\f[R] [\f[CR]\-BknS\f[R]] [\f[CR]\-u\f[R]
\f[I]user\f[R]] [\f[CR]\-g\f[R] \f[I]group\f[R]]
.PD 0
.P
.PD
\f[CR]sudo\f[R] \f[CR]\-l\f[R] [\f[CR]\-BknS\f[R]] [\f[CR]\-U\f[R]
\f[I]user\f[R]] [\f[CR]\-u\f[R] \f[I]user\f[R]] [\f[CR]\-g\f[R]
\f[I]group\f[R]] [command [arg \&...]]
.PD 0
.P
.PD
\f[CR]sudo\f[R] \f[CR]\-e\f[R] [\f[CR]\-BknS\f[R]] [\f[CR]\-u\f[R]
\f[I]user\f[R]] [\f[CR]\-g\f[R] \f[I]group\f[R]] file \&...
.PD 0
.P
.PD
\f[CR]sudoedit\f[R] [\f[CR]\-BknS\f[R]] [\f[CR]\-u\f[R] \f[I]user\f[R]]
[\f[CR]\-g\f[R] \f[I]group\f[R]] file \&...
.SH DESCRIPTION
\f[CR]sudo\f[R] allows a user that is permitted to do so to execute a
\f[I]command\f[R] as another user (for example \f[I]root\f[R]).
Permissions are specified by a security policy specified in
\f[CR]/etc/sudoers\f[R] (see sudoers(5)).
.PP
Sudo\-rs is a safety oriented and memory safe re\-implementation of the
original sudo implementation by Todd Miller.
.PP
When a command is run, a session record is stored for that specific
session allowing users to run additional commands without having to
re\-authenticate.
The timeout for session records can be specified in the policy.
.PP
Some care is taken to pass signals received by sudo\-rs to the child
process, even if that process runs in its own pseudo terminal.
.PP
On systems where sudo is the primary method of gaining superuser
privileges, it is imperative to avoid syntax errors in the
\f[CR]/etc/sudoers\f[R] file.
Changes to this file should be made using the visudo(8) utility which
will ensure that no syntax errors are introduced.
.SH OPTIONS
.TP
\f[CR]\-A\f[R], \f[CR]\-\-askpass\f[R]
Normally, if sudo requires a password, it will read it from the
user\[cq]s terminal.
If the \-A (askpass) option is specified, a (possibly graphical) helper
program is executed to read the user\[cq]s password and output the
password to the standard output.
If the SUDO_ASKPASS environment variable is set, it specifies the path
to the helper program.
If no askpass program is available, sudo will exit with an error.
.TP
\f[CR]\-B\f[R], \f[CR]\-\-bell\f[R]
Ring the bell as part of the password prompt when a terminal is present.
.TP
\f[CR]\-b\f[R], \f[CR]\-\-background\f[R]
Run the given \f[I]command\f[R] in the background.
It is not possible to use shell job control to manipulate background
processes started by sudo\-rs.
Most interactive \f[I]command\f[R]s will fail to work properly in
background mode.
.TP
\f[CR]\-D\f[R] \f[I]directory\f[R], \f[CR]\-\-chdir\f[R]=\f[I]directory\f[R]
Run the \f[I]command\f[R] in the specified \f[I]directory\f[R] instead
of the current working directory.
The security policy may return an error if the user does not have the
permission to specify the working directory.
.TP
\f[CR]\-g\f[R] \f[I]group\f[R], \f[CR]\-\-group\f[R]=\f[I]group\f[R]
Use this \f[I]group\f[R] as the primary group instead of using the
primary group specified in the password database for the target user.
.TP
\f[CR]\-h\f[R], \f[CR]\-\-help\f[R]
Show a help message.
.TP
\f[CR]\-i\f[R], \f[CR]\-\-login\f[R]
Run the shell specified by the target user\[cq]s password database entry
as a login shell.
This means that login\-specific resource files such as
\f[I].profile\f[R], \f[I].bash_profile\f[R] or \f[I].login\f[R] will be
read by the shell.
If a \f[I]command\f[R] is specified, it is passed to the shell using the
\f[CR]\-c\f[R] option.
.TP
\f[CR]\-K\f[R], \f[CR]\-\-remove\-timestamp\f[R]
Removes every cached session record for the user, regardless of where
the command is executed.
The next time sudo\-rs is run, authentication will take place if the
policy requires it.
No password is required to run this command.
.TP
\f[CR]\-k\f[R], \f[CR]\-\-reset\-timestamp\f[R]
When used without a command, invalidates the user\[cq]s session record
for the current session.
The next time sudo\-rs is run, authentication will take place if the
policy requires it.
.RS
.PP
When used in conjunction with a \f[I]command\f[R] or an option that may
require a password, this option will cause sudo\-rs to ignore the
user\[cq]s session record.
As a result, authentication will take place if the policy requires it.
When used in conjunction with a \f[I]command\f[R] no invalidation of
existing session records will take place.
.RE
.TP
\f[CR]\-n\f[R], \f[CR]\-\-non\-interactive\f[R]
Avoid prompting the user for input of any kind.
If any input is required for the \f[I]command\f[R] to run, sudo\-rs will
display an error message and exit.
.TP
\f[CR]p\f[R], \f[CR]\-\-prompt\f[R]=\f[I]prompt\f[R]
Use a custom authentication prompt with optional escape sequences.
The following percent (`%') escape sequences are supported:
.RS
.IP
.EX
 %H  expanded to the local host name

 %h  expanded to the local host name without the domain name

 %p  expanded to the name of the user whose password is being requested
     (this respects the rootpw, targetpw flags)

 %U  expanded to the login name of the user the command will be run as
     (defaults to root unless the \-u option is also specified)

 %u  expanded to the invoking user\[aq]s login name

 %%  two consecutive \[oq]%\[cq] characters are collapsed into a single \[oq]%\[cq] character
.EE
.PP
The custom prompt will override the default prompt or the one specified
by the SUDO_PROMPT environment variable.
No \f[I]prompt\f[R] will suppress the prompt provided by PAM, unless the
requested \f[I]prompt\f[R] is empty (\f[CR]\[dq]\[dq]\f[R])
.RE
.TP
\f[CR]\-S\f[R], \f[CR]\-\-stdin\f[R]
Read from standard input instead of using the terminal device.
.TP
\f[CR]\-s\f[R], \f[CR]\-\-shell\f[R]
Run the shell specified by the \f[CR]SHELL\f[R] environment variable.
If no shell was specified, the shell from the user\[cq]s password
database entry will be used instead.
If a \f[I]command\f[R] is specified, it is passed to the shell using the
\f[CR]\-c\f[R] option.
.TP
\f[CR]\-\-preserve\-env=list\f[R]
Indicates to the security policy that the user wishes to add the
comma\-separated list of environment variables to those preserved from
the user\[cq]s environment.
The security policy may return an error if the user does not have
permission to preserve the environment.
This option may be specified multiple times.
.TP
\f[CR]\-e\f[R], \f[CR]\-\-edit\f[R], \f[CR]sudoedit\f[R]
Edit one or more files instead of running a command.
In lieu of a path name, the string \[lq]sudoedit\[rq] is used when
consulting the security policy.
If the user is authorized by the policy, the following steps are taken:
.RS
.IP "1." 3
Temporary copies are made of the files to be edited with the owner set
to the invoking user.
.IP "2." 3
The editor specified by the policy is run to edit the temporary files.
The sudoers policy uses the SUDO_EDITOR, VISUAL and EDITOR environment
variables (in that order).
If none of SUDO_EDITOR, VISUAL or EDITOR are set, the first program
listed in the editor sudoers(5) option is used.
.IP "3." 3
If they have been modified, the content of the temporary files is copied
back to the originals and the temporary versions are removed.
.PP
To help prevent the editing of unauthorized files, the following
restrictions are enforced (unless the user is root):
.IP \[bu] 2
Symbolic links may not be edited.
.IP \[bu] 2
If any component of the path leading to the file is writable by the
invoking user, the file may not be edited.
.IP \[bu] 2
Users are never allowed to edit device special files.
.PP
If the specified file does not exist, it will be created.
Unlike most commands run by sudo, the editor is run with the invoking
user\[cq]s environment unmodified.
If the temporary file becomes empty after editing, the user will be
prompted before it is installed.
.RE
.TP
\f[CR]\-u\f[R] \f[I]user\f[R], \f[CR]\-\-user\f[R]=\f[I]user\f[R]
Run the \f[I]command\f[R] as another user than the default
(\f[B]root\f[R]).
.TP
\f[CR]\-V\f[R], \f[CR]\-\-version\f[R]
Display the current version of sudo\-rs.
.TP
\f[CR]\-v\f[R], \f[CR]\-\-validate\f[R]
Update the session record for the current session, authenticating the
user if necessary.
.TP
\f[CR]\-l\f[R], \f[CR]\-\-list\f[R]
List user\[cq]s privileges or check a specific command; use twice for
longer format
.TP
\f[CR]\-U\f[R], \f[CR]\-\-other\-user\f[R]=\f[I]user\f[R]
Used in list mode, display privileges for another user
.TP
\f[CR]\-\-\f[R]
Indicates the end of the sudo\-rs options and start of the
\f[I]command\f[R].
.PP
Environment variables to be set for the command may be passed on the
command line in the form of VAR=value.
Variables passed on the command line are subject to restrictions imposed
by the security policy.
Variables passed on the command line are subject to the same
restrictions as normal environment variables with one important
exception: If the command to be run has the SETENV tag set or the
command matched is ALL, the user may set variables that would otherwise
be forbidden.
See sudoers(5) for more information.
.SH SEE ALSO
su(1), sudoers(5), visudo(8)
