// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"math"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// SummaryDataPoint is a single data point in a timeseries that describes the time-varying values of a Summary of double values.
type SummaryDataPoint struct {
	Attributes        []KeyValue
	QuantileValues    []*SummaryDataPointValueAtQuantile
	StartTimeUnixNano uint64
	TimeUnixNano      uint64
	Count             uint64
	Sum               float64
	Flags             uint32
}

var (
	protoPoolSummaryDataPoint = sync.Pool{
		New: func() any {
			return &SummaryDataPoint{}
		},
	}
)

func NewSummaryDataPoint() *SummaryDataPoint {
	if !UseProtoPooling.IsEnabled() {
		return &SummaryDataPoint{}
	}
	return protoPoolSummaryDataPoint.Get().(*SummaryDataPoint)
}

func DeleteSummaryDataPoint(orig *SummaryDataPoint, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	for i := range orig.Attributes {
		DeleteKeyValue(&orig.Attributes[i], false)
	}

	for i := range orig.QuantileValues {
		DeleteSummaryDataPointValueAtQuantile(orig.QuantileValues[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolSummaryDataPoint.Put(orig)
	}
}

func CopySummaryDataPoint(dest, src *SummaryDataPoint) *SummaryDataPoint {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewSummaryDataPoint()
	}
	dest.Attributes = CopyKeyValueSlice(dest.Attributes, src.Attributes)

	dest.StartTimeUnixNano = src.StartTimeUnixNano
	dest.TimeUnixNano = src.TimeUnixNano
	dest.Count = src.Count
	dest.Sum = src.Sum
	dest.QuantileValues = CopySummaryDataPointValueAtQuantilePtrSlice(dest.QuantileValues, src.QuantileValues)

	dest.Flags = src.Flags

	return dest
}

func CopySummaryDataPointSlice(dest, src []SummaryDataPoint) []SummaryDataPoint {
	var newDest []SummaryDataPoint
	if cap(dest) < len(src) {
		newDest = make([]SummaryDataPoint, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteSummaryDataPoint(&dest[i], false)
		}
	}
	for i := range src {
		CopySummaryDataPoint(&newDest[i], &src[i])
	}
	return newDest
}

func CopySummaryDataPointPtrSlice(dest, src []*SummaryDataPoint) []*SummaryDataPoint {
	var newDest []*SummaryDataPoint
	if cap(dest) < len(src) {
		newDest = make([]*SummaryDataPoint, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewSummaryDataPoint()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteSummaryDataPoint(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewSummaryDataPoint()
		}
	}
	for i := range src {
		CopySummaryDataPoint(newDest[i], src[i])
	}
	return newDest
}

func (orig *SummaryDataPoint) Reset() {
	*orig = SummaryDataPoint{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *SummaryDataPoint) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		orig.Attributes[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			orig.Attributes[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.StartTimeUnixNano != uint64(0) {
		dest.WriteObjectField("startTimeUnixNano")
		dest.WriteUint64(orig.StartTimeUnixNano)
	}
	if orig.TimeUnixNano != uint64(0) {
		dest.WriteObjectField("timeUnixNano")
		dest.WriteUint64(orig.TimeUnixNano)
	}
	if orig.Count != uint64(0) {
		dest.WriteObjectField("count")
		dest.WriteUint64(orig.Count)
	}
	if orig.Sum != float64(0) {
		dest.WriteObjectField("sum")
		dest.WriteFloat64(orig.Sum)
	}
	if len(orig.QuantileValues) > 0 {
		dest.WriteObjectField("quantileValues")
		dest.WriteArrayStart()
		orig.QuantileValues[0].MarshalJSON(dest)
		for i := 1; i < len(orig.QuantileValues); i++ {
			dest.WriteMore()
			orig.QuantileValues[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.Flags != uint32(0) {
		dest.WriteObjectField("flags")
		dest.WriteUint32(orig.Flags)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *SummaryDataPoint) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "attributes":
			for iter.ReadArray() {
				orig.Attributes = append(orig.Attributes, KeyValue{})
				orig.Attributes[len(orig.Attributes)-1].UnmarshalJSON(iter)
			}

		case "startTimeUnixNano", "start_time_unix_nano":
			orig.StartTimeUnixNano = iter.ReadUint64()
		case "timeUnixNano", "time_unix_nano":
			orig.TimeUnixNano = iter.ReadUint64()
		case "count":
			orig.Count = iter.ReadUint64()
		case "sum":
			orig.Sum = iter.ReadFloat64()
		case "quantileValues", "quantile_values":
			for iter.ReadArray() {
				orig.QuantileValues = append(orig.QuantileValues, NewSummaryDataPointValueAtQuantile())
				orig.QuantileValues[len(orig.QuantileValues)-1].UnmarshalJSON(iter)
			}

		case "flags":
			orig.Flags = iter.ReadUint32()
		default:
			iter.Skip()
		}
	}
}

func (orig *SummaryDataPoint) SizeProto() int {
	var n int
	var l int
	_ = l
	for i := range orig.Attributes {
		l = orig.Attributes[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.StartTimeUnixNano != uint64(0) {
		n += 9
	}
	if orig.TimeUnixNano != uint64(0) {
		n += 9
	}
	if orig.Count != uint64(0) {
		n += 9
	}
	if orig.Sum != float64(0) {
		n += 9
	}
	for i := range orig.QuantileValues {
		l = orig.QuantileValues[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.Flags != uint32(0) {
		n += 1 + proto.Sov(uint64(orig.Flags))
	}
	return n
}

func (orig *SummaryDataPoint) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.Attributes) - 1; i >= 0; i-- {
		l = orig.Attributes[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x3a
	}
	if orig.StartTimeUnixNano != uint64(0) {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.StartTimeUnixNano))
		pos--
		buf[pos] = 0x11
	}
	if orig.TimeUnixNano != uint64(0) {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.TimeUnixNano))
		pos--
		buf[pos] = 0x19
	}
	if orig.Count != uint64(0) {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.Count))
		pos--
		buf[pos] = 0x21
	}
	if orig.Sum != float64(0) {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Sum))
		pos--
		buf[pos] = 0x29
	}
	for i := len(orig.QuantileValues) - 1; i >= 0; i-- {
		l = orig.QuantileValues[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x32
	}
	if orig.Flags != uint32(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Flags))
		pos--
		buf[pos] = 0x40
	}
	return len(buf) - pos
}

func (orig *SummaryDataPoint) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 7:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Attributes = append(orig.Attributes, KeyValue{})
			err = orig.Attributes[len(orig.Attributes)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.StartTimeUnixNano = uint64(num)

		case 3:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.TimeUnixNano = uint64(num)

		case 4:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.Count = uint64(num)

		case 5:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			orig.Sum = math.Float64frombits(num)

		case 6:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field QuantileValues", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.QuantileValues = append(orig.QuantileValues, NewSummaryDataPointValueAtQuantile())
			err = orig.QuantileValues[len(orig.QuantileValues)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 8:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.Flags = uint32(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestSummaryDataPoint() *SummaryDataPoint {
	orig := NewSummaryDataPoint()
	orig.Attributes = []KeyValue{{}, *GenTestKeyValue()}
	orig.StartTimeUnixNano = uint64(13)
	orig.TimeUnixNano = uint64(13)
	orig.Count = uint64(13)
	orig.Sum = float64(3.1415926)
	orig.QuantileValues = []*SummaryDataPointValueAtQuantile{{}, GenTestSummaryDataPointValueAtQuantile()}
	orig.Flags = uint32(13)
	return orig
}

func GenTestSummaryDataPointPtrSlice() []*SummaryDataPoint {
	orig := make([]*SummaryDataPoint, 5)
	orig[0] = NewSummaryDataPoint()
	orig[1] = GenTestSummaryDataPoint()
	orig[2] = NewSummaryDataPoint()
	orig[3] = GenTestSummaryDataPoint()
	orig[4] = NewSummaryDataPoint()
	return orig
}

func GenTestSummaryDataPointSlice() []SummaryDataPoint {
	orig := make([]SummaryDataPoint, 5)
	orig[1] = *GenTestSummaryDataPoint()
	orig[3] = *GenTestSummaryDataPoint()
	return orig
}
