// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ValueType describes the type and units of a value.
type ValueType struct {
	TypeStrindex int32
	UnitStrindex int32
}

var (
	protoPoolValueType = sync.Pool{
		New: func() any {
			return &ValueType{}
		},
	}
)

func NewValueType() *ValueType {
	if !UseProtoPooling.IsEnabled() {
		return &ValueType{}
	}
	return protoPoolValueType.Get().(*ValueType)
}

func DeleteValueType(orig *ValueType, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolValueType.Put(orig)
	}
}

func CopyValueType(dest, src *ValueType) *ValueType {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewValueType()
	}
	dest.TypeStrindex = src.TypeStrindex
	dest.UnitStrindex = src.UnitStrindex

	return dest
}

func CopyValueTypeSlice(dest, src []ValueType) []ValueType {
	var newDest []ValueType
	if cap(dest) < len(src) {
		newDest = make([]ValueType, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteValueType(&dest[i], false)
		}
	}
	for i := range src {
		CopyValueType(&newDest[i], &src[i])
	}
	return newDest
}

func CopyValueTypePtrSlice(dest, src []*ValueType) []*ValueType {
	var newDest []*ValueType
	if cap(dest) < len(src) {
		newDest = make([]*ValueType, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewValueType()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteValueType(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewValueType()
		}
	}
	for i := range src {
		CopyValueType(newDest[i], src[i])
	}
	return newDest
}

func (orig *ValueType) Reset() {
	*orig = ValueType{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ValueType) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.TypeStrindex != int32(0) {
		dest.WriteObjectField("typeStrindex")
		dest.WriteInt32(orig.TypeStrindex)
	}
	if orig.UnitStrindex != int32(0) {
		dest.WriteObjectField("unitStrindex")
		dest.WriteInt32(orig.UnitStrindex)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ValueType) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "typeStrindex", "type_strindex":
			orig.TypeStrindex = iter.ReadInt32()
		case "unitStrindex", "unit_strindex":
			orig.UnitStrindex = iter.ReadInt32()
		default:
			iter.Skip()
		}
	}
}

func (orig *ValueType) SizeProto() int {
	var n int
	var l int
	_ = l
	if orig.TypeStrindex != int32(0) {
		n += 1 + proto.Sov(uint64(orig.TypeStrindex))
	}
	if orig.UnitStrindex != int32(0) {
		n += 1 + proto.Sov(uint64(orig.UnitStrindex))
	}
	return n
}

func (orig *ValueType) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.TypeStrindex != int32(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.TypeStrindex))
		pos--
		buf[pos] = 0x8
	}
	if orig.UnitStrindex != int32(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.UnitStrindex))
		pos--
		buf[pos] = 0x10
	}
	return len(buf) - pos
}

func (orig *ValueType) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field TypeStrindex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.TypeStrindex = int32(num)

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field UnitStrindex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.UnitStrindex = int32(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestValueType() *ValueType {
	orig := NewValueType()
	orig.TypeStrindex = int32(13)
	orig.UnitStrindex = int32(13)
	return orig
}

func GenTestValueTypePtrSlice() []*ValueType {
	orig := make([]*ValueType, 5)
	orig[0] = NewValueType()
	orig[1] = GenTestValueType()
	orig[2] = NewValueType()
	orig[3] = GenTestValueType()
	orig[4] = NewValueType()
	return orig
}

func GenTestValueTypeSlice() []ValueType {
	orig := make([]ValueType, 5)
	orig[1] = *GenTestValueType()
	orig[3] = *GenTestValueType()
	return orig
}
