//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

#[cfg(all(
    feature = "UIResponder",
    feature = "UIView",
    feature = "objc2-core-foundation"
))]
#[inline]
pub extern "C-unwind" fn UIAccessibilityConvertFrameToScreenCoordinates(
    rect: CGRect,
    view: &UIView,
) -> CGRect {
    extern "C-unwind" {
        fn UIAccessibilityConvertFrameToScreenCoordinates(rect: CGRect, view: &UIView) -> CGRect;
    }
    unsafe { UIAccessibilityConvertFrameToScreenCoordinates(rect, view) }
}

#[cfg(all(feature = "UIBezierPath", feature = "UIResponder", feature = "UIView"))]
#[inline]
pub extern "C-unwind" fn UIAccessibilityConvertPathToScreenCoordinates(
    path: &UIBezierPath,
    view: &UIView,
) -> Retained<UIBezierPath> {
    extern "C-unwind" {
        fn UIAccessibilityConvertPathToScreenCoordinates(
            path: &UIBezierPath,
            view: &UIView,
        ) -> *mut UIBezierPath;
    }
    let ret = unsafe { UIAccessibilityConvertPathToScreenCoordinates(path, view) };
    unsafe { Retained::retain_autoreleased(ret) }
        .expect("function was marked as returning non-null, but actually returned NULL")
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/axboolreturnblock?language=objc)
#[cfg(feature = "block2")]
pub type AXBoolReturnBlock = *mut block2::DynBlock<dyn Fn() -> Bool>;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/axstringreturnblock?language=objc)
#[cfg(feature = "block2")]
pub type AXStringReturnBlock = *mut block2::DynBlock<dyn Fn() -> *mut NSString>;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/axstringarrayreturnblock?language=objc)
#[cfg(feature = "block2")]
pub type AXStringArrayReturnBlock = *mut block2::DynBlock<dyn Fn() -> *mut NSArray<NSString>>;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/axattributedstringreturnblock?language=objc)
#[cfg(feature = "block2")]
pub type AXAttributedStringReturnBlock = *mut block2::DynBlock<dyn Fn() -> *mut NSAttributedString>;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/axattributedstringarrayreturnblock?language=objc)
#[cfg(feature = "block2")]
pub type AXAttributedStringArrayReturnBlock =
    *mut block2::DynBlock<dyn Fn() -> *mut NSArray<NSAttributedString>>;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/axrectreturnblock?language=objc)
#[cfg(all(feature = "block2", feature = "objc2-core-foundation"))]
pub type AXRectReturnBlock = *mut block2::DynBlock<dyn Fn() -> CGRect>;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/axpathreturnblock?language=objc)
#[cfg(all(feature = "UIBezierPath", feature = "block2"))]
pub type AXPathReturnBlock = *mut block2::DynBlock<dyn Fn() -> *mut UIBezierPath>;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/axpointreturnblock?language=objc)
#[cfg(all(feature = "block2", feature = "objc2-core-foundation"))]
pub type AXPointReturnBlock = *mut block2::DynBlock<dyn Fn() -> CGPoint>;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/axobjectreturnblock?language=objc)
#[cfg(feature = "block2")]
pub type AXObjectReturnBlock = *mut block2::DynBlock<dyn Fn() -> *mut AnyObject>;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/axarrayreturnblock?language=objc)
#[cfg(feature = "block2")]
pub type AXArrayReturnBlock = *mut block2::DynBlock<dyn Fn() -> *mut NSArray>;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/axvoidreturnblock?language=objc)
#[cfg(feature = "block2")]
pub type AXVoidReturnBlock = *mut block2::DynBlock<dyn Fn()>;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/axtraitsreturnblock?language=objc)
#[cfg(all(feature = "UIAccessibilityConstants", feature = "block2"))]
pub type AXTraitsReturnBlock = *mut block2::DynBlock<dyn Fn() -> UIAccessibilityTraits>;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/axnavigationstylereturnblock?language=objc)
#[cfg(all(feature = "UIAccessibilityConstants", feature = "block2"))]
pub type AXNavigationStyleReturnBlock =
    *mut block2::DynBlock<dyn Fn() -> UIAccessibilityNavigationStyle>;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/axcontainertypereturnblock?language=objc)
#[cfg(all(feature = "UIAccessibilityConstants", feature = "block2"))]
pub type AXContainerTypeReturnBlock =
    *mut block2::DynBlock<dyn Fn() -> UIAccessibilityContainerType>;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/axtextualcontextreturnblock?language=objc)
#[cfg(all(feature = "UIAccessibilityConstants", feature = "block2"))]
pub type AXTextualContextReturnBlock =
    *mut block2::DynBlock<dyn Fn() -> *mut UIAccessibilityTextualContext>;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/axcustomactionsreturnblock?language=objc)
#[cfg(all(feature = "UIAccessibilityCustomAction", feature = "block2"))]
pub type AXCustomActionsReturnBlock =
    *mut block2::DynBlock<dyn Fn() -> *mut NSArray<UIAccessibilityCustomAction>>;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/axuitextinputreturnblock?language=objc)
#[cfg(all(
    feature = "UITextInput",
    feature = "UITextInputTraits",
    feature = "block2"
))]
pub type AXUITextInputReturnBlock =
    *mut block2::DynBlock<dyn Fn() -> *mut ProtocolObject<dyn UITextInput>>;

mod private_NSObjectUIAccessibility {
    pub trait Sealed {}
}

/// Category "UIAccessibility" on [`NSObject`].
#[doc(alias = "UIAccessibility")]
pub unsafe trait NSObjectUIAccessibility:
    ClassType + Sized + private_NSObjectUIAccessibility::Sealed
{
    extern_methods!(
        #[unsafe(method(isAccessibilityElement))]
        #[unsafe(method_family = none)]
        fn isAccessibilityElement(&self, mtm: MainThreadMarker) -> bool;

        /// Setter for [`isAccessibilityElement`][Self::isAccessibilityElement].
        #[unsafe(method(setIsAccessibilityElement:))]
        #[unsafe(method_family = none)]
        fn setIsAccessibilityElement(&self, is_accessibility_element: bool, mtm: MainThreadMarker);

        #[unsafe(method(accessibilityLabel))]
        #[unsafe(method_family = none)]
        fn accessibilityLabel(&self, mtm: MainThreadMarker) -> Option<Retained<NSString>>;

        /// Setter for [`accessibilityLabel`][Self::accessibilityLabel].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityLabel:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityLabel(
            &self,
            accessibility_label: Option<&NSString>,
            mtm: MainThreadMarker,
        );

        #[unsafe(method(accessibilityAttributedLabel))]
        #[unsafe(method_family = none)]
        fn accessibilityAttributedLabel(
            &self,
            mtm: MainThreadMarker,
        ) -> Option<Retained<NSAttributedString>>;

        /// Setter for [`accessibilityAttributedLabel`][Self::accessibilityAttributedLabel].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityAttributedLabel:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityAttributedLabel(
            &self,
            accessibility_attributed_label: Option<&NSAttributedString>,
            mtm: MainThreadMarker,
        );

        #[unsafe(method(accessibilityHint))]
        #[unsafe(method_family = none)]
        fn accessibilityHint(&self, mtm: MainThreadMarker) -> Option<Retained<NSString>>;

        /// Setter for [`accessibilityHint`][Self::accessibilityHint].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityHint:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityHint(
            &self,
            accessibility_hint: Option<&NSString>,
            mtm: MainThreadMarker,
        );

        #[unsafe(method(accessibilityAttributedHint))]
        #[unsafe(method_family = none)]
        fn accessibilityAttributedHint(
            &self,
            mtm: MainThreadMarker,
        ) -> Option<Retained<NSAttributedString>>;

        /// Setter for [`accessibilityAttributedHint`][Self::accessibilityAttributedHint].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityAttributedHint:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityAttributedHint(
            &self,
            accessibility_attributed_hint: Option<&NSAttributedString>,
            mtm: MainThreadMarker,
        );

        #[unsafe(method(accessibilityValue))]
        #[unsafe(method_family = none)]
        fn accessibilityValue(&self, mtm: MainThreadMarker) -> Option<Retained<NSString>>;

        /// Setter for [`accessibilityValue`][Self::accessibilityValue].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityValue:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityValue(
            &self,
            accessibility_value: Option<&NSString>,
            mtm: MainThreadMarker,
        );

        #[unsafe(method(accessibilityAttributedValue))]
        #[unsafe(method_family = none)]
        fn accessibilityAttributedValue(
            &self,
            mtm: MainThreadMarker,
        ) -> Option<Retained<NSAttributedString>>;

        /// Setter for [`accessibilityAttributedValue`][Self::accessibilityAttributedValue].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityAttributedValue:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityAttributedValue(
            &self,
            accessibility_attributed_value: Option<&NSAttributedString>,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "UIAccessibilityConstants")]
        #[unsafe(method(accessibilityTraits))]
        #[unsafe(method_family = none)]
        fn accessibilityTraits(&self, mtm: MainThreadMarker) -> UIAccessibilityTraits;

        #[cfg(feature = "UIAccessibilityConstants")]
        /// Setter for [`accessibilityTraits`][Self::accessibilityTraits].
        #[unsafe(method(setAccessibilityTraits:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityTraits(
            &self,
            accessibility_traits: UIAccessibilityTraits,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(accessibilityFrame))]
        #[unsafe(method_family = none)]
        fn accessibilityFrame(&self, mtm: MainThreadMarker) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`accessibilityFrame`][Self::accessibilityFrame].
        #[unsafe(method(setAccessibilityFrame:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityFrame(&self, accessibility_frame: CGRect, mtm: MainThreadMarker);

        #[cfg(feature = "UIBezierPath")]
        #[unsafe(method(accessibilityPath))]
        #[unsafe(method_family = none)]
        fn accessibilityPath(&self, mtm: MainThreadMarker) -> Option<Retained<UIBezierPath>>;

        #[cfg(feature = "UIBezierPath")]
        /// Setter for [`accessibilityPath`][Self::accessibilityPath].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityPath:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityPath(
            &self,
            accessibility_path: Option<&UIBezierPath>,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(accessibilityActivationPoint))]
        #[unsafe(method_family = none)]
        fn accessibilityActivationPoint(&self, mtm: MainThreadMarker) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`accessibilityActivationPoint`][Self::accessibilityActivationPoint].
        #[unsafe(method(setAccessibilityActivationPoint:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityActivationPoint(
            &self,
            accessibility_activation_point: CGPoint,
            mtm: MainThreadMarker,
        );

        #[unsafe(method(accessibilityLanguage))]
        #[unsafe(method_family = none)]
        fn accessibilityLanguage(&self, mtm: MainThreadMarker) -> Option<Retained<NSString>>;

        /// Setter for [`accessibilityLanguage`][Self::accessibilityLanguage].
        #[unsafe(method(setAccessibilityLanguage:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityLanguage(
            &self,
            accessibility_language: Option<&NSString>,
            mtm: MainThreadMarker,
        );

        #[unsafe(method(accessibilityElementsHidden))]
        #[unsafe(method_family = none)]
        fn accessibilityElementsHidden(&self, mtm: MainThreadMarker) -> bool;

        /// Setter for [`accessibilityElementsHidden`][Self::accessibilityElementsHidden].
        #[unsafe(method(setAccessibilityElementsHidden:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityElementsHidden(
            &self,
            accessibility_elements_hidden: bool,
            mtm: MainThreadMarker,
        );

        #[unsafe(method(accessibilityViewIsModal))]
        #[unsafe(method_family = none)]
        fn accessibilityViewIsModal(&self, mtm: MainThreadMarker) -> bool;

        /// Setter for [`accessibilityViewIsModal`][Self::accessibilityViewIsModal].
        #[unsafe(method(setAccessibilityViewIsModal:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityViewIsModal(
            &self,
            accessibility_view_is_modal: bool,
            mtm: MainThreadMarker,
        );

        #[unsafe(method(shouldGroupAccessibilityChildren))]
        #[unsafe(method_family = none)]
        fn shouldGroupAccessibilityChildren(&self, mtm: MainThreadMarker) -> bool;

        /// Setter for [`shouldGroupAccessibilityChildren`][Self::shouldGroupAccessibilityChildren].
        #[unsafe(method(setShouldGroupAccessibilityChildren:))]
        #[unsafe(method_family = none)]
        fn setShouldGroupAccessibilityChildren(
            &self,
            should_group_accessibility_children: bool,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "UIAccessibilityConstants")]
        #[unsafe(method(accessibilityNavigationStyle))]
        #[unsafe(method_family = none)]
        fn accessibilityNavigationStyle(
            &self,
            mtm: MainThreadMarker,
        ) -> UIAccessibilityNavigationStyle;

        #[cfg(feature = "UIAccessibilityConstants")]
        /// Setter for [`accessibilityNavigationStyle`][Self::accessibilityNavigationStyle].
        #[unsafe(method(setAccessibilityNavigationStyle:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityNavigationStyle(
            &self,
            accessibility_navigation_style: UIAccessibilityNavigationStyle,
            mtm: MainThreadMarker,
        );

        #[unsafe(method(accessibilityRespondsToUserInteraction))]
        #[unsafe(method_family = none)]
        fn accessibilityRespondsToUserInteraction(&self, mtm: MainThreadMarker) -> bool;

        /// Setter for [`accessibilityRespondsToUserInteraction`][Self::accessibilityRespondsToUserInteraction].
        #[unsafe(method(setAccessibilityRespondsToUserInteraction:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityRespondsToUserInteraction(
            &self,
            accessibility_responds_to_user_interaction: bool,
            mtm: MainThreadMarker,
        );

        #[unsafe(method(accessibilityUserInputLabels))]
        #[unsafe(method_family = none)]
        fn accessibilityUserInputLabels(
            &self,
            mtm: MainThreadMarker,
        ) -> Option<Retained<NSArray<NSString>>>;

        /// Setter for [`accessibilityUserInputLabels`][Self::accessibilityUserInputLabels].
        ///
        /// # Safety
        ///
        /// `accessibility_user_input_labels` might not allow `None`.
        #[unsafe(method(setAccessibilityUserInputLabels:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityUserInputLabels(
            &self,
            accessibility_user_input_labels: Option<&NSArray<NSString>>,
            mtm: MainThreadMarker,
        );

        #[unsafe(method(accessibilityAttributedUserInputLabels))]
        #[unsafe(method_family = none)]
        fn accessibilityAttributedUserInputLabels(
            &self,
            mtm: MainThreadMarker,
        ) -> Retained<NSArray<NSAttributedString>>;

        /// Setter for [`accessibilityAttributedUserInputLabels`][Self::accessibilityAttributedUserInputLabels].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityAttributedUserInputLabels:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityAttributedUserInputLabels(
            &self,
            accessibility_attributed_user_input_labels: Option<&NSArray<NSAttributedString>>,
            mtm: MainThreadMarker,
        );

        #[unsafe(method(accessibilityHeaderElements))]
        #[unsafe(method_family = none)]
        fn accessibilityHeaderElements(&self, mtm: MainThreadMarker) -> Option<Retained<NSArray>>;

        /// Setter for [`accessibilityHeaderElements`][Self::accessibilityHeaderElements].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_header_elements` generic should be of the correct type.
        #[unsafe(method(setAccessibilityHeaderElements:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityHeaderElements(
            &self,
            accessibility_header_elements: Option<&NSArray>,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "UIAccessibilityConstants")]
        #[unsafe(method(accessibilityTextualContext))]
        #[unsafe(method_family = none)]
        fn accessibilityTextualContext(
            &self,
            mtm: MainThreadMarker,
        ) -> Option<Retained<UIAccessibilityTextualContext>>;

        #[cfg(feature = "UIAccessibilityConstants")]
        /// Setter for [`accessibilityTextualContext`][Self::accessibilityTextualContext].
        #[unsafe(method(setAccessibilityTextualContext:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityTextualContext(
            &self,
            accessibility_textual_context: Option<&UIAccessibilityTextualContext>,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "UIAccessibilityConstants")]
        #[unsafe(method(accessibilityDirectTouchOptions))]
        #[unsafe(method_family = none)]
        fn accessibilityDirectTouchOptions(
            &self,
            mtm: MainThreadMarker,
        ) -> UIAccessibilityDirectTouchOptions;

        #[cfg(feature = "UIAccessibilityConstants")]
        /// Setter for [`accessibilityDirectTouchOptions`][Self::accessibilityDirectTouchOptions].
        #[unsafe(method(setAccessibilityDirectTouchOptions:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityDirectTouchOptions(
            &self,
            accessibility_direct_touch_options: UIAccessibilityDirectTouchOptions,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "UIAccessibilityConstants")]
        #[unsafe(method(accessibilityExpandedStatus))]
        #[unsafe(method_family = none)]
        fn accessibilityExpandedStatus(
            &self,
            mtm: MainThreadMarker,
        ) -> UIAccessibilityExpandedStatus;

        #[cfg(feature = "UIAccessibilityConstants")]
        /// Setter for [`accessibilityExpandedStatus`][Self::accessibilityExpandedStatus].
        #[unsafe(method(setAccessibilityExpandedStatus:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityExpandedStatus(
            &self,
            accessibility_expanded_status: UIAccessibilityExpandedStatus,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(isAccessibilityElementBlock))]
        #[unsafe(method_family = none)]
        fn isAccessibilityElementBlock(&self, mtm: MainThreadMarker) -> AXBoolReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`isAccessibilityElementBlock`][Self::isAccessibilityElementBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `is_accessibility_element_block` must be a valid pointer or null.
        #[unsafe(method(setIsAccessibilityElementBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setIsAccessibilityElementBlock(
            &self,
            is_accessibility_element_block: AXBoolReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityLabelBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityLabelBlock(&self, mtm: MainThreadMarker) -> AXStringReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityLabelBlock`][Self::accessibilityLabelBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_label_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityLabelBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityLabelBlock(
            &self,
            accessibility_label_block: AXStringReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityValueBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityValueBlock(&self, mtm: MainThreadMarker) -> AXStringReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityValueBlock`][Self::accessibilityValueBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_value_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityValueBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityValueBlock(
            &self,
            accessibility_value_block: AXStringReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityHintBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityHintBlock(&self, mtm: MainThreadMarker) -> AXStringReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityHintBlock`][Self::accessibilityHintBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_hint_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityHintBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityHintBlock(
            &self,
            accessibility_hint_block: AXStringReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(all(feature = "UIAccessibilityConstants", feature = "block2"))]
        #[unsafe(method(accessibilityTraitsBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityTraitsBlock(&self, mtm: MainThreadMarker) -> AXTraitsReturnBlock;

        #[cfg(all(feature = "UIAccessibilityConstants", feature = "block2"))]
        /// Setter for [`accessibilityTraitsBlock`][Self::accessibilityTraitsBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_traits_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityTraitsBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityTraitsBlock(
            &self,
            accessibility_traits_block: AXTraitsReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityIdentifierBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityIdentifierBlock(&self, mtm: MainThreadMarker) -> AXStringReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityIdentifierBlock`][Self::accessibilityIdentifierBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_identifier_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityIdentifierBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityIdentifierBlock(
            &self,
            accessibility_identifier_block: AXStringReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityHeaderElementsBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityHeaderElementsBlock(&self, mtm: MainThreadMarker) -> AXArrayReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityHeaderElementsBlock`][Self::accessibilityHeaderElementsBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_header_elements_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityHeaderElementsBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityHeaderElementsBlock(
            &self,
            accessibility_header_elements_block: AXArrayReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityAttributedLabelBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityAttributedLabelBlock(
            &self,
            mtm: MainThreadMarker,
        ) -> AXAttributedStringReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityAttributedLabelBlock`][Self::accessibilityAttributedLabelBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_attributed_label_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityAttributedLabelBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityAttributedLabelBlock(
            &self,
            accessibility_attributed_label_block: AXAttributedStringReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityAttributedHintBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityAttributedHintBlock(
            &self,
            mtm: MainThreadMarker,
        ) -> AXAttributedStringReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityAttributedHintBlock`][Self::accessibilityAttributedHintBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_attributed_hint_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityAttributedHintBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityAttributedHintBlock(
            &self,
            accessibility_attributed_hint_block: AXAttributedStringReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityLanguageBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityLanguageBlock(&self, mtm: MainThreadMarker) -> AXStringReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityLanguageBlock`][Self::accessibilityLanguageBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_language_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityLanguageBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityLanguageBlock(
            &self,
            accessibility_language_block: AXStringReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(all(feature = "UIAccessibilityConstants", feature = "block2"))]
        #[unsafe(method(accessibilityTextualContextBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityTextualContextBlock(
            &self,
            mtm: MainThreadMarker,
        ) -> AXTextualContextReturnBlock;

        #[cfg(all(feature = "UIAccessibilityConstants", feature = "block2"))]
        /// Setter for [`accessibilityTextualContextBlock`][Self::accessibilityTextualContextBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_textual_context_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityTextualContextBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityTextualContextBlock(
            &self,
            accessibility_textual_context_block: AXTextualContextReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityUserInputLabelsBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityUserInputLabelsBlock(
            &self,
            mtm: MainThreadMarker,
        ) -> AXStringArrayReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityUserInputLabelsBlock`][Self::accessibilityUserInputLabelsBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_user_input_labels_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityUserInputLabelsBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityUserInputLabelsBlock(
            &self,
            accessibility_user_input_labels_block: AXStringArrayReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityAttributedUserInputLabelsBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityAttributedUserInputLabelsBlock(
            &self,
            mtm: MainThreadMarker,
        ) -> AXAttributedStringArrayReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityAttributedUserInputLabelsBlock`][Self::accessibilityAttributedUserInputLabelsBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_attributed_user_input_labels_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityAttributedUserInputLabelsBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityAttributedUserInputLabelsBlock(
            &self,
            accessibility_attributed_user_input_labels_block: AXAttributedStringArrayReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityAttributedValueBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityAttributedValueBlock(
            &self,
            mtm: MainThreadMarker,
        ) -> AXAttributedStringReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityAttributedValueBlock`][Self::accessibilityAttributedValueBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_attributed_value_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityAttributedValueBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityAttributedValueBlock(
            &self,
            accessibility_attributed_value_block: AXAttributedStringReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityElementsHiddenBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityElementsHiddenBlock(&self, mtm: MainThreadMarker) -> AXBoolReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityElementsHiddenBlock`][Self::accessibilityElementsHiddenBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_elements_hidden_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityElementsHiddenBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityElementsHiddenBlock(
            &self,
            accessibility_elements_hidden_block: AXBoolReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityRespondsToUserInteractionBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityRespondsToUserInteractionBlock(
            &self,
            mtm: MainThreadMarker,
        ) -> AXBoolReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityRespondsToUserInteractionBlock`][Self::accessibilityRespondsToUserInteractionBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_responds_to_user_interaction_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityRespondsToUserInteractionBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityRespondsToUserInteractionBlock(
            &self,
            accessibility_responds_to_user_interaction_block: AXBoolReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityViewIsModalBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityViewIsModalBlock(&self, mtm: MainThreadMarker) -> AXBoolReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityViewIsModalBlock`][Self::accessibilityViewIsModalBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_view_is_modal_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityViewIsModalBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityViewIsModalBlock(
            &self,
            accessibility_view_is_modal_block: AXBoolReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityShouldGroupAccessibilityChildrenBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityShouldGroupAccessibilityChildrenBlock(
            &self,
            mtm: MainThreadMarker,
        ) -> AXBoolReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityShouldGroupAccessibilityChildrenBlock`][Self::accessibilityShouldGroupAccessibilityChildrenBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_should_group_accessibility_children_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityShouldGroupAccessibilityChildrenBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityShouldGroupAccessibilityChildrenBlock(
            &self,
            accessibility_should_group_accessibility_children_block: AXBoolReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(all(feature = "UIAccessibilityConstants", feature = "block2"))]
        #[unsafe(method(accessibilityExpandedStatusBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityExpandedStatusBlock(
            &self,
            mtm: MainThreadMarker,
        ) -> *mut block2::DynBlock<dyn Fn() -> UIAccessibilityExpandedStatus>;

        #[cfg(all(feature = "UIAccessibilityConstants", feature = "block2"))]
        /// Setter for [`accessibilityExpandedStatusBlock`][Self::accessibilityExpandedStatusBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityExpandedStatusBlock:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityExpandedStatusBlock(
            &self,
            accessibility_expanded_status_block: Option<
                &block2::DynBlock<dyn Fn() -> UIAccessibilityExpandedStatus>,
            >,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityElementsBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityElementsBlock(&self, mtm: MainThreadMarker) -> AXArrayReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityElementsBlock`][Self::accessibilityElementsBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_elements_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityElementsBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityElementsBlock(
            &self,
            accessibility_elements_block: AXArrayReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(automationElementsBlock))]
        #[unsafe(method_family = none)]
        fn automationElementsBlock(&self, mtm: MainThreadMarker) -> AXArrayReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`automationElementsBlock`][Self::automationElementsBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `automation_elements_block` must be a valid pointer or null.
        #[unsafe(method(setAutomationElementsBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAutomationElementsBlock(
            &self,
            automation_elements_block: AXArrayReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(all(feature = "UIAccessibilityConstants", feature = "block2"))]
        #[unsafe(method(accessibilityContainerTypeBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityContainerTypeBlock(
            &self,
            mtm: MainThreadMarker,
        ) -> AXContainerTypeReturnBlock;

        #[cfg(all(feature = "UIAccessibilityConstants", feature = "block2"))]
        /// Setter for [`accessibilityContainerTypeBlock`][Self::accessibilityContainerTypeBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_container_type_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityContainerTypeBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityContainerTypeBlock(
            &self,
            accessibility_container_type_block: AXContainerTypeReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(all(feature = "block2", feature = "objc2-core-foundation"))]
        #[unsafe(method(accessibilityActivationPointBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityActivationPointBlock(&self, mtm: MainThreadMarker) -> AXPointReturnBlock;

        #[cfg(all(feature = "block2", feature = "objc2-core-foundation"))]
        /// Setter for [`accessibilityActivationPointBlock`][Self::accessibilityActivationPointBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_activation_point_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityActivationPointBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityActivationPointBlock(
            &self,
            accessibility_activation_point_block: AXPointReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(all(feature = "block2", feature = "objc2-core-foundation"))]
        #[unsafe(method(accessibilityFrameBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityFrameBlock(&self, mtm: MainThreadMarker) -> AXRectReturnBlock;

        #[cfg(all(feature = "block2", feature = "objc2-core-foundation"))]
        /// Setter for [`accessibilityFrameBlock`][Self::accessibilityFrameBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_frame_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityFrameBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityFrameBlock(
            &self,
            accessibility_frame_block: AXRectReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(all(feature = "UIAccessibilityConstants", feature = "block2"))]
        #[unsafe(method(accessibilityNavigationStyleBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityNavigationStyleBlock(
            &self,
            mtm: MainThreadMarker,
        ) -> AXNavigationStyleReturnBlock;

        #[cfg(all(feature = "UIAccessibilityConstants", feature = "block2"))]
        /// Setter for [`accessibilityNavigationStyleBlock`][Self::accessibilityNavigationStyleBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_navigation_style_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityNavigationStyleBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityNavigationStyleBlock(
            &self,
            accessibility_navigation_style_block: AXNavigationStyleReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(all(feature = "UIBezierPath", feature = "block2"))]
        #[unsafe(method(accessibilityPathBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityPathBlock(&self, mtm: MainThreadMarker) -> AXPathReturnBlock;

        #[cfg(all(feature = "UIBezierPath", feature = "block2"))]
        /// Setter for [`accessibilityPathBlock`][Self::accessibilityPathBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_path_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityPathBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityPathBlock(
            &self,
            accessibility_path_block: AXPathReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityActivateBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityActivateBlock(&self, mtm: MainThreadMarker) -> AXBoolReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityActivateBlock`][Self::accessibilityActivateBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_activate_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityActivateBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityActivateBlock(
            &self,
            accessibility_activate_block: AXBoolReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityIncrementBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityIncrementBlock(&self, mtm: MainThreadMarker) -> AXVoidReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityIncrementBlock`][Self::accessibilityIncrementBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_increment_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityIncrementBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityIncrementBlock(
            &self,
            accessibility_increment_block: AXVoidReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityDecrementBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityDecrementBlock(&self, mtm: MainThreadMarker) -> AXVoidReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityDecrementBlock`][Self::accessibilityDecrementBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_decrement_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityDecrementBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityDecrementBlock(
            &self,
            accessibility_decrement_block: AXVoidReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityPerformEscapeBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformEscapeBlock(&self, mtm: MainThreadMarker) -> AXBoolReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityPerformEscapeBlock`][Self::accessibilityPerformEscapeBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_perform_escape_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityPerformEscapeBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityPerformEscapeBlock(
            &self,
            accessibility_perform_escape_block: AXBoolReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityMagicTapBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityMagicTapBlock(&self, mtm: MainThreadMarker) -> AXBoolReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityMagicTapBlock`][Self::accessibilityMagicTapBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_magic_tap_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityMagicTapBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityMagicTapBlock(
            &self,
            accessibility_magic_tap_block: AXBoolReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(all(feature = "UIAccessibilityCustomAction", feature = "block2"))]
        #[unsafe(method(accessibilityCustomActionsBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityCustomActionsBlock(
            &self,
            mtm: MainThreadMarker,
        ) -> AXCustomActionsReturnBlock;

        #[cfg(all(feature = "UIAccessibilityCustomAction", feature = "block2"))]
        /// Setter for [`accessibilityCustomActionsBlock`][Self::accessibilityCustomActionsBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_custom_actions_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityCustomActionsBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityCustomActionsBlock(
            &self,
            accessibility_custom_actions_block: AXCustomActionsReturnBlock,
            mtm: MainThreadMarker,
        );
    );
}

impl private_NSObjectUIAccessibility::Sealed for NSObject {}
unsafe impl NSObjectUIAccessibility for NSObject {}

#[cfg(feature = "UIAccessibilityConstants")]
#[inline]
pub extern "C-unwind" fn UIAccessibilityFocusedElement(
    assistive_technology_identifier: Option<&UIAccessibilityAssistiveTechnologyIdentifier>,
) -> Option<Retained<AnyObject>> {
    extern "C-unwind" {
        fn UIAccessibilityFocusedElement(
            assistive_technology_identifier: Option<&UIAccessibilityAssistiveTechnologyIdentifier>,
        ) -> *mut AnyObject;
    }
    let ret = unsafe { UIAccessibilityFocusedElement(assistive_technology_identifier) };
    unsafe { Retained::retain_autoreleased(ret) }
}

mod private_NSObjectUIAccessibilityFocus {
    pub trait Sealed {}
}

/// Category "UIAccessibilityFocus" on [`NSObject`].
#[doc(alias = "UIAccessibilityFocus")]
pub unsafe trait NSObjectUIAccessibilityFocus:
    ClassType + Sized + private_NSObjectUIAccessibilityFocus::Sealed
{
    extern_methods!(
        #[unsafe(method(accessibilityElementDidBecomeFocused))]
        #[unsafe(method_family = none)]
        fn accessibilityElementDidBecomeFocused(&self, mtm: MainThreadMarker);

        #[unsafe(method(accessibilityElementDidLoseFocus))]
        #[unsafe(method_family = none)]
        fn accessibilityElementDidLoseFocus(&self, mtm: MainThreadMarker);

        #[unsafe(method(accessibilityElementIsFocused))]
        #[unsafe(method_family = none)]
        fn accessibilityElementIsFocused(&self, mtm: MainThreadMarker) -> bool;

        #[cfg(feature = "UIAccessibilityConstants")]
        #[unsafe(method(accessibilityAssistiveTechnologyFocusedIdentifiers))]
        #[unsafe(method_family = none)]
        fn accessibilityAssistiveTechnologyFocusedIdentifiers(
            &self,
            mtm: MainThreadMarker,
        ) -> Option<Retained<NSSet<UIAccessibilityAssistiveTechnologyIdentifier>>>;
    );
}

impl private_NSObjectUIAccessibilityFocus::Sealed for NSObject {}
unsafe impl NSObjectUIAccessibilityFocus for NSObject {}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityscrolldirection?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIAccessibilityScrollDirection(pub NSInteger);
impl UIAccessibilityScrollDirection {
    #[doc(alias = "UIAccessibilityScrollDirectionRight")]
    pub const Right: Self = Self(1);
    #[doc(alias = "UIAccessibilityScrollDirectionLeft")]
    pub const Left: Self = Self(2);
    #[doc(alias = "UIAccessibilityScrollDirectionUp")]
    pub const Up: Self = Self(3);
    #[doc(alias = "UIAccessibilityScrollDirectionDown")]
    pub const Down: Self = Self(4);
    #[doc(alias = "UIAccessibilityScrollDirectionNext")]
    pub const Next: Self = Self(5);
    #[doc(alias = "UIAccessibilityScrollDirectionPrevious")]
    pub const Previous: Self = Self(6);
}

unsafe impl Encode for UIAccessibilityScrollDirection {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIAccessibilityScrollDirection {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

mod private_NSObjectUIAccessibilityAction {
    pub trait Sealed {}
}

/// Category "UIAccessibilityAction" on [`NSObject`].
#[doc(alias = "UIAccessibilityAction")]
pub unsafe trait NSObjectUIAccessibilityAction:
    ClassType + Sized + private_NSObjectUIAccessibilityAction::Sealed
{
    extern_methods!(
        #[unsafe(method(accessibilityActivate))]
        #[unsafe(method_family = none)]
        fn accessibilityActivate(&self, mtm: MainThreadMarker) -> bool;

        #[unsafe(method(accessibilityIncrement))]
        #[unsafe(method_family = none)]
        fn accessibilityIncrement(&self, mtm: MainThreadMarker);

        #[unsafe(method(accessibilityDecrement))]
        #[unsafe(method_family = none)]
        fn accessibilityDecrement(&self, mtm: MainThreadMarker);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(accessibilityZoomInAtPoint:))]
        #[unsafe(method_family = none)]
        fn accessibilityZoomInAtPoint(&self, point: CGPoint, mtm: MainThreadMarker) -> bool;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(accessibilityZoomOutAtPoint:))]
        #[unsafe(method_family = none)]
        fn accessibilityZoomOutAtPoint(&self, point: CGPoint, mtm: MainThreadMarker) -> bool;

        #[unsafe(method(accessibilityScroll:))]
        #[unsafe(method_family = none)]
        fn accessibilityScroll(
            &self,
            direction: UIAccessibilityScrollDirection,
            mtm: MainThreadMarker,
        ) -> bool;

        #[unsafe(method(accessibilityPerformEscape))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformEscape(&self, mtm: MainThreadMarker) -> bool;

        #[unsafe(method(accessibilityPerformMagicTap))]
        #[unsafe(method_family = none)]
        fn accessibilityPerformMagicTap(&self, mtm: MainThreadMarker) -> bool;

        #[cfg(feature = "UIAccessibilityCustomAction")]
        #[unsafe(method(accessibilityCustomActions))]
        #[unsafe(method_family = none)]
        fn accessibilityCustomActions(
            &self,
            mtm: MainThreadMarker,
        ) -> Option<Retained<NSArray<UIAccessibilityCustomAction>>>;

        #[cfg(feature = "UIAccessibilityCustomAction")]
        /// Setter for [`accessibilityCustomActions`][Self::accessibilityCustomActions].
        #[unsafe(method(setAccessibilityCustomActions:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityCustomActions(
            &self,
            accessibility_custom_actions: Option<&NSArray<UIAccessibilityCustomAction>>,
            mtm: MainThreadMarker,
        );
    );
}

impl private_NSObjectUIAccessibilityAction::Sealed for NSObject {}
unsafe impl NSObjectUIAccessibilityAction for NSObject {}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityreadingcontent?language=objc)
    pub unsafe trait UIAccessibilityReadingContent: MainThreadOnly {
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(accessibilityLineNumberForPoint:))]
        #[unsafe(method_family = none)]
        fn accessibilityLineNumberForPoint(&self, point: CGPoint) -> NSInteger;

        #[unsafe(method(accessibilityContentForLineNumber:))]
        #[unsafe(method_family = none)]
        fn accessibilityContentForLineNumber(
            &self,
            line_number: NSInteger,
        ) -> Option<Retained<NSString>>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(accessibilityFrameForLineNumber:))]
        #[unsafe(method_family = none)]
        fn accessibilityFrameForLineNumber(&self, line_number: NSInteger) -> CGRect;

        #[unsafe(method(accessibilityPageContent))]
        #[unsafe(method_family = none)]
        fn accessibilityPageContent(&self) -> Option<Retained<NSString>>;

        #[optional]
        #[unsafe(method(accessibilityAttributedContentForLineNumber:))]
        #[unsafe(method_family = none)]
        fn accessibilityAttributedContentForLineNumber(
            &self,
            line_number: NSInteger,
        ) -> Option<Retained<NSAttributedString>>;

        #[optional]
        #[unsafe(method(accessibilityAttributedPageContent))]
        #[unsafe(method_family = none)]
        fn accessibilityAttributedPageContent(&self) -> Option<Retained<NSAttributedString>>;
    }
);

mod private_NSObjectUIAccessibilityDragging {
    pub trait Sealed {}
}

/// Category "UIAccessibilityDragging" on [`NSObject`].
#[doc(alias = "UIAccessibilityDragging")]
pub unsafe trait NSObjectUIAccessibilityDragging:
    ClassType + Sized + private_NSObjectUIAccessibilityDragging::Sealed
{
    extern_methods!(
        #[cfg(feature = "UIAccessibilityLocationDescriptor")]
        #[unsafe(method(accessibilityDragSourceDescriptors))]
        #[unsafe(method_family = none)]
        fn accessibilityDragSourceDescriptors(
            &self,
            mtm: MainThreadMarker,
        ) -> Option<Retained<NSArray<UIAccessibilityLocationDescriptor>>>;

        #[cfg(feature = "UIAccessibilityLocationDescriptor")]
        /// Setter for [`accessibilityDragSourceDescriptors`][Self::accessibilityDragSourceDescriptors].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityDragSourceDescriptors:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityDragSourceDescriptors(
            &self,
            accessibility_drag_source_descriptors: Option<
                &NSArray<UIAccessibilityLocationDescriptor>,
            >,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "UIAccessibilityLocationDescriptor")]
        #[unsafe(method(accessibilityDropPointDescriptors))]
        #[unsafe(method_family = none)]
        fn accessibilityDropPointDescriptors(
            &self,
            mtm: MainThreadMarker,
        ) -> Option<Retained<NSArray<UIAccessibilityLocationDescriptor>>>;

        #[cfg(feature = "UIAccessibilityLocationDescriptor")]
        /// Setter for [`accessibilityDropPointDescriptors`][Self::accessibilityDropPointDescriptors].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAccessibilityDropPointDescriptors:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityDropPointDescriptors(
            &self,
            accessibility_drop_point_descriptors: Option<
                &NSArray<UIAccessibilityLocationDescriptor>,
            >,
            mtm: MainThreadMarker,
        );
    );
}

impl private_NSObjectUIAccessibilityDragging::Sealed for NSObject {}
unsafe impl NSObjectUIAccessibilityDragging for NSObject {}

mod private_NSObjectUIAccessibilityHitTest {
    pub trait Sealed {}
}

/// Category "UIAccessibilityHitTest" on [`NSObject`].
#[doc(alias = "UIAccessibilityHitTest")]
pub unsafe trait NSObjectUIAccessibilityHitTest:
    ClassType + Sized + private_NSObjectUIAccessibilityHitTest::Sealed
{
    extern_methods!(
        #[cfg(all(feature = "UIEvent", feature = "objc2-core-foundation"))]
        #[unsafe(method(accessibilityHitTest:withEvent:))]
        #[unsafe(method_family = none)]
        fn accessibilityHitTest_withEvent(
            &self,
            point: CGPoint,
            event: Option<&UIEvent>,
            mtm: MainThreadMarker,
        ) -> Option<Retained<AnyObject>>;
    );
}

impl private_NSObjectUIAccessibilityHitTest::Sealed for NSObject {}
unsafe impl NSObjectUIAccessibilityHitTest for NSObject {}

mod private_NSObjectUIAccessibilityTextNavigation {
    pub trait Sealed {}
}

/// Category "UIAccessibilityTextNavigation" on [`NSObject`].
#[doc(alias = "UIAccessibilityTextNavigation")]
pub unsafe trait NSObjectUIAccessibilityTextNavigation:
    ClassType + Sized + private_NSObjectUIAccessibilityTextNavigation::Sealed
{
    extern_methods!(
        #[unsafe(method(accessibilityPreviousTextNavigationElement))]
        #[unsafe(method_family = none)]
        fn accessibilityPreviousTextNavigationElement(
            &self,
            mtm: MainThreadMarker,
        ) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityPreviousTextNavigationElement`][Self::accessibilityPreviousTextNavigationElement].
        ///
        /// # Safety
        ///
        /// `accessibility_previous_text_navigation_element` should be of the correct type.
        #[unsafe(method(setAccessibilityPreviousTextNavigationElement:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityPreviousTextNavigationElement(
            &self,
            accessibility_previous_text_navigation_element: Option<&AnyObject>,
            mtm: MainThreadMarker,
        );

        #[unsafe(method(accessibilityNextTextNavigationElement))]
        #[unsafe(method_family = none)]
        fn accessibilityNextTextNavigationElement(
            &self,
            mtm: MainThreadMarker,
        ) -> Option<Retained<AnyObject>>;

        /// Setter for [`accessibilityNextTextNavigationElement`][Self::accessibilityNextTextNavigationElement].
        ///
        /// # Safety
        ///
        /// `accessibility_next_text_navigation_element` should be of the correct type.
        #[unsafe(method(setAccessibilityNextTextNavigationElement:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityNextTextNavigationElement(
            &self,
            accessibility_next_text_navigation_element: Option<&AnyObject>,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityPreviousTextNavigationElementBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityPreviousTextNavigationElementBlock(
            &self,
            mtm: MainThreadMarker,
        ) -> AXObjectReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityPreviousTextNavigationElementBlock`][Self::accessibilityPreviousTextNavigationElementBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_previous_text_navigation_element_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityPreviousTextNavigationElementBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityPreviousTextNavigationElementBlock(
            &self,
            accessibility_previous_text_navigation_element_block: AXObjectReturnBlock,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(accessibilityNextTextNavigationElementBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityNextTextNavigationElementBlock(
            &self,
            mtm: MainThreadMarker,
        ) -> AXObjectReturnBlock;

        #[cfg(feature = "block2")]
        /// Setter for [`accessibilityNextTextNavigationElementBlock`][Self::accessibilityNextTextNavigationElementBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_next_text_navigation_element_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityNextTextNavigationElementBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityNextTextNavigationElementBlock(
            &self,
            accessibility_next_text_navigation_element_block: AXObjectReturnBlock,
            mtm: MainThreadMarker,
        );
    );
}

impl private_NSObjectUIAccessibilityTextNavigation::Sealed for NSObject {}
unsafe impl NSObjectUIAccessibilityTextNavigation for NSObject {}

mod private_NSObjectUIAccessibilityTextOperations {
    pub trait Sealed {}
}

/// Category "UIAccessibilityTextOperations" on [`NSObject`].
#[doc(alias = "UIAccessibilityTextOperations")]
pub unsafe trait NSObjectUIAccessibilityTextOperations:
    ClassType + Sized + private_NSObjectUIAccessibilityTextOperations::Sealed
{
    extern_methods!(
        #[cfg(all(feature = "UITextInput", feature = "UITextInputTraits"))]
        #[unsafe(method(accessibilityTextInputResponder))]
        #[unsafe(method_family = none)]
        fn accessibilityTextInputResponder(
            &self,
            mtm: MainThreadMarker,
        ) -> Option<Retained<ProtocolObject<dyn UITextInput>>>;

        #[cfg(all(feature = "UITextInput", feature = "UITextInputTraits"))]
        /// Setter for [`accessibilityTextInputResponder`][Self::accessibilityTextInputResponder].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setAccessibilityTextInputResponder:))]
        #[unsafe(method_family = none)]
        fn setAccessibilityTextInputResponder(
            &self,
            accessibility_text_input_responder: Option<&ProtocolObject<dyn UITextInput>>,
            mtm: MainThreadMarker,
        );

        #[cfg(all(
            feature = "UITextInput",
            feature = "UITextInputTraits",
            feature = "block2"
        ))]
        #[unsafe(method(accessibilityTextInputResponderBlock))]
        #[unsafe(method_family = none)]
        fn accessibilityTextInputResponderBlock(
            &self,
            mtm: MainThreadMarker,
        ) -> AXUITextInputReturnBlock;

        #[cfg(all(
            feature = "UITextInput",
            feature = "UITextInputTraits",
            feature = "block2"
        ))]
        /// Setter for [`accessibilityTextInputResponderBlock`][Self::accessibilityTextInputResponderBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `accessibility_text_input_responder_block` must be a valid pointer or null.
        #[unsafe(method(setAccessibilityTextInputResponderBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn setAccessibilityTextInputResponderBlock(
            &self,
            accessibility_text_input_responder_block: AXUITextInputReturnBlock,
            mtm: MainThreadMarker,
        );
    );
}

impl private_NSObjectUIAccessibilityTextOperations::Sealed for NSObject {}
unsafe impl NSObjectUIAccessibilityTextOperations for NSObject {}

extern "C-unwind" {
    /// # Safety
    ///
    /// `argument` should be of the correct type.
    #[cfg(feature = "UIAccessibilityConstants")]
    pub fn UIAccessibilityPostNotification(
        notification: UIAccessibilityNotifications,
        argument: Option<&AnyObject>,
    );
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityIsVoiceOverRunning() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityIsVoiceOverRunning() -> Bool;
    }
    unsafe { UIAccessibilityIsVoiceOverRunning() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityvoiceoverstatuschanged?language=objc)
    #[deprecated]
    pub static UIAccessibilityVoiceOverStatusChanged: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityvoiceoverstatusdidchangenotification?language=objc)
    pub static UIAccessibilityVoiceOverStatusDidChangeNotification: &'static NSNotificationName;
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityIsMonoAudioEnabled() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityIsMonoAudioEnabled() -> Bool;
    }
    unsafe { UIAccessibilityIsMonoAudioEnabled() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilitymonoaudiostatusdidchangenotification?language=objc)
    pub static UIAccessibilityMonoAudioStatusDidChangeNotification: &'static NSNotificationName;
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityIsClosedCaptioningEnabled() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityIsClosedCaptioningEnabled() -> Bool;
    }
    unsafe { UIAccessibilityIsClosedCaptioningEnabled() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityclosedcaptioningstatusdidchangenotification?language=objc)
    pub static UIAccessibilityClosedCaptioningStatusDidChangeNotification:
        &'static NSNotificationName;
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityIsInvertColorsEnabled() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityIsInvertColorsEnabled() -> Bool;
    }
    unsafe { UIAccessibilityIsInvertColorsEnabled() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityinvertcolorsstatusdidchangenotification?language=objc)
    pub static UIAccessibilityInvertColorsStatusDidChangeNotification: &'static NSNotificationName;
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityIsGuidedAccessEnabled() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityIsGuidedAccessEnabled() -> Bool;
    }
    unsafe { UIAccessibilityIsGuidedAccessEnabled() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityguidedaccessstatusdidchangenotification?language=objc)
    pub static UIAccessibilityGuidedAccessStatusDidChangeNotification: &'static NSNotificationName;
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityIsBoldTextEnabled() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityIsBoldTextEnabled() -> Bool;
    }
    unsafe { UIAccessibilityIsBoldTextEnabled() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityboldtextstatusdidchangenotification?language=objc)
    pub static UIAccessibilityBoldTextStatusDidChangeNotification: &'static NSNotificationName;
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityButtonShapesEnabled() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityButtonShapesEnabled() -> Bool;
    }
    unsafe { UIAccessibilityButtonShapesEnabled() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilitybuttonshapesenabledstatusdidchangenotification?language=objc)
    pub static UIAccessibilityButtonShapesEnabledStatusDidChangeNotification:
        &'static NSNotificationName;
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityIsGrayscaleEnabled() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityIsGrayscaleEnabled() -> Bool;
    }
    unsafe { UIAccessibilityIsGrayscaleEnabled() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilitygrayscalestatusdidchangenotification?language=objc)
    pub static UIAccessibilityGrayscaleStatusDidChangeNotification: &'static NSNotificationName;
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityIsReduceTransparencyEnabled() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityIsReduceTransparencyEnabled() -> Bool;
    }
    unsafe { UIAccessibilityIsReduceTransparencyEnabled() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityreducetransparencystatusdidchangenotification?language=objc)
    pub static UIAccessibilityReduceTransparencyStatusDidChangeNotification:
        &'static NSNotificationName;
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityIsReduceMotionEnabled() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityIsReduceMotionEnabled() -> Bool;
    }
    unsafe { UIAccessibilityIsReduceMotionEnabled() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityreducemotionstatusdidchangenotification?language=objc)
    pub static UIAccessibilityReduceMotionStatusDidChangeNotification: &'static NSNotificationName;
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityPrefersCrossFadeTransitions() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityPrefersCrossFadeTransitions() -> Bool;
    }
    unsafe { UIAccessibilityPrefersCrossFadeTransitions() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilitypreferscrossfadetransitionsstatusdidchangenotification?language=objc)
    pub static UIAccessibilityPrefersCrossFadeTransitionsStatusDidChangeNotification:
        &'static NSNotificationName;
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityIsVideoAutoplayEnabled() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityIsVideoAutoplayEnabled() -> Bool;
    }
    unsafe { UIAccessibilityIsVideoAutoplayEnabled() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityvideoautoplaystatusdidchangenotification?language=objc)
    pub static UIAccessibilityVideoAutoplayStatusDidChangeNotification: &'static NSNotificationName;
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityDarkerSystemColorsEnabled() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityDarkerSystemColorsEnabled() -> Bool;
    }
    unsafe { UIAccessibilityDarkerSystemColorsEnabled() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilitydarkersystemcolorsstatusdidchangenotification?language=objc)
    pub static UIAccessibilityDarkerSystemColorsStatusDidChangeNotification:
        &'static NSNotificationName;
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityIsSwitchControlRunning() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityIsSwitchControlRunning() -> Bool;
    }
    unsafe { UIAccessibilityIsSwitchControlRunning() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityswitchcontrolstatusdidchangenotification?language=objc)
    pub static UIAccessibilitySwitchControlStatusDidChangeNotification: &'static NSNotificationName;
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityIsSpeakSelectionEnabled() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityIsSpeakSelectionEnabled() -> Bool;
    }
    unsafe { UIAccessibilityIsSpeakSelectionEnabled() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityspeakselectionstatusdidchangenotification?language=objc)
    pub static UIAccessibilitySpeakSelectionStatusDidChangeNotification:
        &'static NSNotificationName;
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityIsSpeakScreenEnabled() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityIsSpeakScreenEnabled() -> Bool;
    }
    unsafe { UIAccessibilityIsSpeakScreenEnabled() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityspeakscreenstatusdidchangenotification?language=objc)
    pub static UIAccessibilitySpeakScreenStatusDidChangeNotification: &'static NSNotificationName;
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityIsShakeToUndoEnabled() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityIsShakeToUndoEnabled() -> Bool;
    }
    unsafe { UIAccessibilityIsShakeToUndoEnabled() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityshaketoundodidchangenotification?language=objc)
    pub static UIAccessibilityShakeToUndoDidChangeNotification: &'static NSNotificationName;
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityIsAssistiveTouchRunning() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityIsAssistiveTouchRunning() -> Bool;
    }
    unsafe { UIAccessibilityIsAssistiveTouchRunning() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityassistivetouchstatusdidchangenotification?language=objc)
    pub static UIAccessibilityAssistiveTouchStatusDidChangeNotification:
        &'static NSNotificationName;
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityShouldDifferentiateWithoutColor() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityShouldDifferentiateWithoutColor() -> Bool;
    }
    unsafe { UIAccessibilityShouldDifferentiateWithoutColor() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityshoulddifferentiatewithoutcolordidchangenotification?language=objc)
    pub static UIAccessibilityShouldDifferentiateWithoutColorDidChangeNotification:
        &'static NSNotificationName;
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityIsOnOffSwitchLabelsEnabled() -> bool {
    extern "C-unwind" {
        fn UIAccessibilityIsOnOffSwitchLabelsEnabled() -> Bool;
    }
    unsafe { UIAccessibilityIsOnOffSwitchLabelsEnabled() }.as_bool()
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityonoffswitchlabelsdidchangenotification?language=objc)
    pub static UIAccessibilityOnOffSwitchLabelsDidChangeNotification: &'static NSNotificationName;
}

#[cfg(feature = "block2")]
#[inline]
pub extern "C-unwind" fn UIAccessibilityRequestGuidedAccessSession(
    enable: bool,
    completion_handler: &block2::DynBlock<dyn Fn(Bool)>,
) {
    extern "C-unwind" {
        fn UIAccessibilityRequestGuidedAccessSession(
            enable: Bool,
            completion_handler: &block2::DynBlock<dyn Fn(Bool)>,
        );
    }
    unsafe { UIAccessibilityRequestGuidedAccessSession(Bool::new(enable), completion_handler) }
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityhearingdeviceear?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIAccessibilityHearingDeviceEar(pub NSUInteger);
bitflags::bitflags! {
    impl UIAccessibilityHearingDeviceEar: NSUInteger {
        #[doc(alias = "UIAccessibilityHearingDeviceEarNone")]
        const None = 0;
        #[doc(alias = "UIAccessibilityHearingDeviceEarLeft")]
        const Left = 1<<1;
        #[doc(alias = "UIAccessibilityHearingDeviceEarRight")]
        const Right = 1<<2;
        #[doc(alias = "UIAccessibilityHearingDeviceEarBoth")]
        const Both = UIAccessibilityHearingDeviceEar::Left.0|UIAccessibilityHearingDeviceEar::Right.0;
    }
}

unsafe impl Encode for UIAccessibilityHearingDeviceEar {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for UIAccessibilityHearingDeviceEar {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[inline]
pub extern "C-unwind" fn UIAccessibilityHearingDevicePairedEar() -> UIAccessibilityHearingDeviceEar
{
    extern "C-unwind" {
        fn UIAccessibilityHearingDevicePairedEar() -> UIAccessibilityHearingDeviceEar;
    }
    unsafe { UIAccessibilityHearingDevicePairedEar() }
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaccessibilityhearingdevicepairedeardidchangenotification?language=objc)
    pub static UIAccessibilityHearingDevicePairedEarDidChangeNotification:
        &'static NSNotificationName;
}
