//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

extern_class!(
    /// UIFocusSystem instances manage focus state within a part of the user interface. They are in charge of tracking the current focused item, as well as processing focus updates.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uifocussystem?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIFocusSystem;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIFocusSystem {}
);

impl UIFocusSystem {
    extern_methods!(
        #[cfg(feature = "UIFocus")]
        /// The currently focused item in this focus system.
        #[unsafe(method(focusedItem))]
        #[unsafe(method_family = none)]
        pub fn focusedItem(&self) -> Option<Retained<ProtocolObject<dyn UIFocusItem>>>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "UIFocus")]
        #[unsafe(method(focusSystemForEnvironment:))]
        #[unsafe(method_family = none)]
        pub fn focusSystemForEnvironment(
            environment: &ProtocolObject<dyn UIFocusEnvironment>,
        ) -> Option<Retained<UIFocusSystem>>;

        #[cfg(feature = "UIFocus")]
        /// Requests a focus update to the specified environment. If accepted, the focus update will happen
        /// in the next run loop cycle.
        #[unsafe(method(requestFocusUpdateToEnvironment:))]
        #[unsafe(method_family = none)]
        pub fn requestFocusUpdateToEnvironment(
            &self,
            environment: &ProtocolObject<dyn UIFocusEnvironment>,
        );

        /// Forces any pending focus update to be committed immediately.
        #[unsafe(method(updateFocusIfNeeded))]
        #[unsafe(method_family = none)]
        pub fn updateFocusIfNeeded(&self);

        #[cfg(feature = "UIFocus")]
        /// Returns true if `environment` is an ancestor of `otherEnvironment`, or false if otherwise.
        #[unsafe(method(environment:containsEnvironment:))]
        #[unsafe(method_family = none)]
        pub fn environment_containsEnvironment(
            environment: &ProtocolObject<dyn UIFocusEnvironment>,
            other_environment: &ProtocolObject<dyn UIFocusEnvironment>,
        ) -> bool;
    );
}
