# Reference

This section contains reference documentation for Pykka's public API.

- [Actors](actors.md) - the `Actor` base class and references to running actors.
- [Proxies](proxies.md) - an `ActorProxy` is a convenient abstraction on top of an `Actor`.
- [Futures](futures.md) - a `Future` is a handle to a result that may not be available yet.
- [Registry](registry.md) - the `ActorRegistry` lets you get references to running actors.
- [Exceptions](exceptions.md) - exceptions defined by Pykka.
- [Message objects](messages.md) - message objects used by Pykka.
- [Debug helpers](debug.md) - helpers for debugging Pykka applications.
- [Typing helpers](typing.md) - type annotations and helpers for Pykka.
- [Runtimes](runtimes.md) - the different runtimes Pykka supports.
