from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

HEBREW_LANG_MODEL = {
    8: {  # 'א'
        8: SequenceLikelihood.LIKELY,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.POSITIVE,  # 'ז'
        16: SequenceLikelihood.POSITIVE,  # 'ח'
        21: SequenceLikelihood.POSITIVE,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.POSITIVE,  # 'ך'
        15: SequenceLikelihood.POSITIVE,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.POSITIVE,  # 'ס'
        13: SequenceLikelihood.LIKELY,  # 'ע'
        26: SequenceLikelihood.POSITIVE,  # 'ף'
        18: SequenceLikelihood.POSITIVE,  # 'פ'
        27: SequenceLikelihood.LIKELY,  # 'ץ'
        23: SequenceLikelihood.POSITIVE,  # 'צ'
        17: SequenceLikelihood.POSITIVE,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.POSITIVE,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.LIKELY,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.LIKELY,  # 'ײ'
    },
    9: {  # 'ב'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.POSITIVE,  # 'ז'
        16: SequenceLikelihood.POSITIVE,  # 'ח'
        21: SequenceLikelihood.POSITIVE,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.POSITIVE,  # 'ך'
        15: SequenceLikelihood.POSITIVE,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.POSITIVE,  # 'ס'
        13: SequenceLikelihood.POSITIVE,  # 'ע'
        26: SequenceLikelihood.LIKELY,  # 'ף'
        18: SequenceLikelihood.POSITIVE,  # 'פ'
        27: SequenceLikelihood.POSITIVE,  # 'ץ'
        23: SequenceLikelihood.POSITIVE,  # 'צ'
        17: SequenceLikelihood.POSITIVE,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.POSITIVE,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.NEGATIVE,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.NEGATIVE,  # 'ײ'
    },
    20: {  # 'ג'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.POSITIVE,  # 'ז'
        16: SequenceLikelihood.LIKELY,  # 'ח'
        21: SequenceLikelihood.POSITIVE,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.LIKELY,  # 'ך'
        15: SequenceLikelihood.LIKELY,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.LIKELY,  # 'ס'
        13: SequenceLikelihood.POSITIVE,  # 'ע'
        26: SequenceLikelihood.LIKELY,  # 'ף'
        18: SequenceLikelihood.LIKELY,  # 'פ'
        27: SequenceLikelihood.LIKELY,  # 'ץ'
        23: SequenceLikelihood.LIKELY,  # 'צ'
        17: SequenceLikelihood.LIKELY,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.POSITIVE,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.LIKELY,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.LIKELY,  # 'ײ'
    },
    14: {  # 'ד'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.LIKELY,  # 'ז'
        16: SequenceLikelihood.POSITIVE,  # 'ח'
        21: SequenceLikelihood.LIKELY,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.LIKELY,  # 'ך'
        15: SequenceLikelihood.POSITIVE,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.POSITIVE,  # 'ס'
        13: SequenceLikelihood.POSITIVE,  # 'ע'
        26: SequenceLikelihood.POSITIVE,  # 'ף'
        18: SequenceLikelihood.POSITIVE,  # 'פ'
        27: SequenceLikelihood.LIKELY,  # 'ץ'
        23: SequenceLikelihood.POSITIVE,  # 'צ'
        17: SequenceLikelihood.POSITIVE,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.POSITIVE,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.LIKELY,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.LIKELY,  # 'ײ'
    },
    3: {  # 'ה'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.POSITIVE,  # 'ז'
        16: SequenceLikelihood.POSITIVE,  # 'ח'
        21: SequenceLikelihood.POSITIVE,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.LIKELY,  # 'ך'
        15: SequenceLikelihood.POSITIVE,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.POSITIVE,  # 'ס'
        13: SequenceLikelihood.POSITIVE,  # 'ע'
        26: SequenceLikelihood.LIKELY,  # 'ף'
        18: SequenceLikelihood.POSITIVE,  # 'פ'
        27: SequenceLikelihood.LIKELY,  # 'ץ'
        23: SequenceLikelihood.POSITIVE,  # 'צ'
        17: SequenceLikelihood.POSITIVE,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.POSITIVE,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.NEGATIVE,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.LIKELY,  # 'ײ'
    },
    2: {  # 'ו'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.POSITIVE,  # 'ז'
        16: SequenceLikelihood.POSITIVE,  # 'ח'
        21: SequenceLikelihood.POSITIVE,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.POSITIVE,  # 'ך'
        15: SequenceLikelihood.POSITIVE,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.POSITIVE,  # 'ס'
        13: SequenceLikelihood.POSITIVE,  # 'ע'
        26: SequenceLikelihood.POSITIVE,  # 'ף'
        18: SequenceLikelihood.POSITIVE,  # 'פ'
        27: SequenceLikelihood.POSITIVE,  # 'ץ'
        23: SequenceLikelihood.POSITIVE,  # 'צ'
        17: SequenceLikelihood.POSITIVE,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.POSITIVE,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.NEGATIVE,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.LIKELY,  # 'ײ'
    },
    24: {  # 'ז'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.LIKELY,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.LIKELY,  # 'ז'
        16: SequenceLikelihood.LIKELY,  # 'ח'
        21: SequenceLikelihood.LIKELY,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.LIKELY,  # 'ך'
        15: SequenceLikelihood.POSITIVE,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.LIKELY,  # 'ס'
        13: SequenceLikelihood.POSITIVE,  # 'ע'
        26: SequenceLikelihood.LIKELY,  # 'ף'
        18: SequenceLikelihood.LIKELY,  # 'פ'
        27: SequenceLikelihood.LIKELY,  # 'ץ'
        23: SequenceLikelihood.POSITIVE,  # 'צ'
        17: SequenceLikelihood.POSITIVE,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.LIKELY,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.NEGATIVE,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.LIKELY,  # 'ײ'
    },
    16: {  # 'ח'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.POSITIVE,  # 'ז'
        16: SequenceLikelihood.LIKELY,  # 'ח'
        21: SequenceLikelihood.POSITIVE,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.LIKELY,  # 'ך'
        15: SequenceLikelihood.POSITIVE,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.POSITIVE,  # 'ס'
        13: SequenceLikelihood.LIKELY,  # 'ע'
        26: SequenceLikelihood.LIKELY,  # 'ף'
        18: SequenceLikelihood.POSITIVE,  # 'פ'
        27: SequenceLikelihood.POSITIVE,  # 'ץ'
        23: SequenceLikelihood.POSITIVE,  # 'צ'
        17: SequenceLikelihood.POSITIVE,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.POSITIVE,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.NEGATIVE,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.LIKELY,  # 'ײ'
    },
    21: {  # 'ט'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.LIKELY,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.LIKELY,  # 'ז'
        16: SequenceLikelihood.POSITIVE,  # 'ח'
        21: SequenceLikelihood.POSITIVE,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.LIKELY,  # 'ך'
        15: SequenceLikelihood.POSITIVE,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.LIKELY,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.POSITIVE,  # 'ס'
        13: SequenceLikelihood.POSITIVE,  # 'ע'
        26: SequenceLikelihood.LIKELY,  # 'ף'
        18: SequenceLikelihood.POSITIVE,  # 'פ'
        27: SequenceLikelihood.LIKELY,  # 'ץ'
        23: SequenceLikelihood.LIKELY,  # 'צ'
        17: SequenceLikelihood.POSITIVE,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.POSITIVE,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.LIKELY,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.LIKELY,  # 'ײ'
    },
    1: {  # 'י'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.POSITIVE,  # 'ז'
        16: SequenceLikelihood.POSITIVE,  # 'ח'
        21: SequenceLikelihood.POSITIVE,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.POSITIVE,  # 'ך'
        15: SequenceLikelihood.POSITIVE,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.POSITIVE,  # 'ס'
        13: SequenceLikelihood.POSITIVE,  # 'ע'
        26: SequenceLikelihood.POSITIVE,  # 'ף'
        18: SequenceLikelihood.POSITIVE,  # 'פ'
        27: SequenceLikelihood.POSITIVE,  # 'ץ'
        23: SequenceLikelihood.POSITIVE,  # 'צ'
        17: SequenceLikelihood.POSITIVE,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.POSITIVE,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.LIKELY,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.NEGATIVE,  # 'ײ'
    },
    25: {  # 'ך'
        8: SequenceLikelihood.LIKELY,  # 'א'
        9: SequenceLikelihood.LIKELY,  # 'ב'
        20: SequenceLikelihood.LIKELY,  # 'ג'
        14: SequenceLikelihood.LIKELY,  # 'ד'
        3: SequenceLikelihood.LIKELY,  # 'ה'
        2: SequenceLikelihood.LIKELY,  # 'ו'
        24: SequenceLikelihood.LIKELY,  # 'ז'
        16: SequenceLikelihood.LIKELY,  # 'ח'
        21: SequenceLikelihood.LIKELY,  # 'ט'
        1: SequenceLikelihood.LIKELY,  # 'י'
        25: SequenceLikelihood.LIKELY,  # 'ך'
        15: SequenceLikelihood.LIKELY,  # 'כ'
        4: SequenceLikelihood.LIKELY,  # 'ל'
        12: SequenceLikelihood.LIKELY,  # 'ם'
        7: SequenceLikelihood.LIKELY,  # 'מ'
        22: SequenceLikelihood.LIKELY,  # 'ן'
        11: SequenceLikelihood.LIKELY,  # 'נ'
        19: SequenceLikelihood.LIKELY,  # 'ס'
        13: SequenceLikelihood.LIKELY,  # 'ע'
        26: SequenceLikelihood.LIKELY,  # 'ף'
        18: SequenceLikelihood.LIKELY,  # 'פ'
        27: SequenceLikelihood.LIKELY,  # 'ץ'
        23: SequenceLikelihood.LIKELY,  # 'צ'
        17: SequenceLikelihood.LIKELY,  # 'ק'
        6: SequenceLikelihood.LIKELY,  # 'ר'
        10: SequenceLikelihood.LIKELY,  # 'ש'
        5: SequenceLikelihood.LIKELY,  # 'ת'
        29: SequenceLikelihood.NEGATIVE,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.NEGATIVE,  # 'ײ'
    },
    15: {  # 'כ'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.POSITIVE,  # 'ז'
        16: SequenceLikelihood.POSITIVE,  # 'ח'
        21: SequenceLikelihood.LIKELY,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.POSITIVE,  # 'ך'
        15: SequenceLikelihood.POSITIVE,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.POSITIVE,  # 'ס'
        13: SequenceLikelihood.POSITIVE,  # 'ע'
        26: SequenceLikelihood.LIKELY,  # 'ף'
        18: SequenceLikelihood.POSITIVE,  # 'פ'
        27: SequenceLikelihood.LIKELY,  # 'ץ'
        23: SequenceLikelihood.LIKELY,  # 'צ'
        17: SequenceLikelihood.LIKELY,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.POSITIVE,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.LIKELY,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.NEGATIVE,  # 'ײ'
    },
    4: {  # 'ל'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.POSITIVE,  # 'ז'
        16: SequenceLikelihood.POSITIVE,  # 'ח'
        21: SequenceLikelihood.POSITIVE,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.POSITIVE,  # 'ך'
        15: SequenceLikelihood.POSITIVE,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.POSITIVE,  # 'ס'
        13: SequenceLikelihood.POSITIVE,  # 'ע'
        26: SequenceLikelihood.POSITIVE,  # 'ף'
        18: SequenceLikelihood.POSITIVE,  # 'פ'
        27: SequenceLikelihood.POSITIVE,  # 'ץ'
        23: SequenceLikelihood.POSITIVE,  # 'צ'
        17: SequenceLikelihood.POSITIVE,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.POSITIVE,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.LIKELY,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.LIKELY,  # 'ײ'
    },
    12: {  # 'ם'
        8: SequenceLikelihood.LIKELY,  # 'א'
        9: SequenceLikelihood.LIKELY,  # 'ב'
        20: SequenceLikelihood.LIKELY,  # 'ג'
        14: SequenceLikelihood.LIKELY,  # 'ד'
        3: SequenceLikelihood.LIKELY,  # 'ה'
        2: SequenceLikelihood.LIKELY,  # 'ו'
        24: SequenceLikelihood.LIKELY,  # 'ז'
        16: SequenceLikelihood.LIKELY,  # 'ח'
        21: SequenceLikelihood.LIKELY,  # 'ט'
        1: SequenceLikelihood.LIKELY,  # 'י'
        25: SequenceLikelihood.LIKELY,  # 'ך'
        15: SequenceLikelihood.LIKELY,  # 'כ'
        4: SequenceLikelihood.LIKELY,  # 'ל'
        12: SequenceLikelihood.LIKELY,  # 'ם'
        7: SequenceLikelihood.LIKELY,  # 'מ'
        22: SequenceLikelihood.LIKELY,  # 'ן'
        11: SequenceLikelihood.LIKELY,  # 'נ'
        19: SequenceLikelihood.LIKELY,  # 'ס'
        13: SequenceLikelihood.LIKELY,  # 'ע'
        26: SequenceLikelihood.LIKELY,  # 'ף'
        18: SequenceLikelihood.LIKELY,  # 'פ'
        27: SequenceLikelihood.LIKELY,  # 'ץ'
        23: SequenceLikelihood.LIKELY,  # 'צ'
        17: SequenceLikelihood.LIKELY,  # 'ק'
        6: SequenceLikelihood.LIKELY,  # 'ר'
        10: SequenceLikelihood.LIKELY,  # 'ש'
        5: SequenceLikelihood.LIKELY,  # 'ת'
        29: SequenceLikelihood.NEGATIVE,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.NEGATIVE,  # 'ײ'
    },
    7: {  # 'מ'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.POSITIVE,  # 'ז'
        16: SequenceLikelihood.POSITIVE,  # 'ח'
        21: SequenceLikelihood.POSITIVE,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.POSITIVE,  # 'ך'
        15: SequenceLikelihood.POSITIVE,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.POSITIVE,  # 'ס'
        13: SequenceLikelihood.POSITIVE,  # 'ע'
        26: SequenceLikelihood.LIKELY,  # 'ף'
        18: SequenceLikelihood.POSITIVE,  # 'פ'
        27: SequenceLikelihood.POSITIVE,  # 'ץ'
        23: SequenceLikelihood.POSITIVE,  # 'צ'
        17: SequenceLikelihood.POSITIVE,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.POSITIVE,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.NEGATIVE,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.LIKELY,  # 'ײ'
    },
    22: {  # 'ן'
        8: SequenceLikelihood.LIKELY,  # 'א'
        9: SequenceLikelihood.LIKELY,  # 'ב'
        20: SequenceLikelihood.LIKELY,  # 'ג'
        14: SequenceLikelihood.LIKELY,  # 'ד'
        3: SequenceLikelihood.LIKELY,  # 'ה'
        2: SequenceLikelihood.LIKELY,  # 'ו'
        24: SequenceLikelihood.LIKELY,  # 'ז'
        16: SequenceLikelihood.LIKELY,  # 'ח'
        21: SequenceLikelihood.LIKELY,  # 'ט'
        1: SequenceLikelihood.LIKELY,  # 'י'
        25: SequenceLikelihood.LIKELY,  # 'ך'
        15: SequenceLikelihood.LIKELY,  # 'כ'
        4: SequenceLikelihood.LIKELY,  # 'ל'
        12: SequenceLikelihood.LIKELY,  # 'ם'
        7: SequenceLikelihood.LIKELY,  # 'מ'
        22: SequenceLikelihood.LIKELY,  # 'ן'
        11: SequenceLikelihood.LIKELY,  # 'נ'
        19: SequenceLikelihood.LIKELY,  # 'ס'
        13: SequenceLikelihood.LIKELY,  # 'ע'
        26: SequenceLikelihood.LIKELY,  # 'ף'
        18: SequenceLikelihood.LIKELY,  # 'פ'
        27: SequenceLikelihood.LIKELY,  # 'ץ'
        23: SequenceLikelihood.LIKELY,  # 'צ'
        17: SequenceLikelihood.LIKELY,  # 'ק'
        6: SequenceLikelihood.LIKELY,  # 'ר'
        10: SequenceLikelihood.LIKELY,  # 'ש'
        5: SequenceLikelihood.LIKELY,  # 'ת'
        29: SequenceLikelihood.NEGATIVE,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.NEGATIVE,  # 'ײ'
    },
    11: {  # 'נ'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.POSITIVE,  # 'ז'
        16: SequenceLikelihood.POSITIVE,  # 'ח'
        21: SequenceLikelihood.POSITIVE,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.POSITIVE,  # 'ך'
        15: SequenceLikelihood.POSITIVE,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.POSITIVE,  # 'ס'
        13: SequenceLikelihood.POSITIVE,  # 'ע'
        26: SequenceLikelihood.LIKELY,  # 'ף'
        18: SequenceLikelihood.POSITIVE,  # 'פ'
        27: SequenceLikelihood.LIKELY,  # 'ץ'
        23: SequenceLikelihood.POSITIVE,  # 'צ'
        17: SequenceLikelihood.POSITIVE,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.POSITIVE,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.NEGATIVE,  # 'װ'
        30: SequenceLikelihood.LIKELY,  # 'ױ'
        28: SequenceLikelihood.LIKELY,  # 'ײ'
    },
    19: {  # 'ס'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.LIKELY,  # 'ז'
        16: SequenceLikelihood.POSITIVE,  # 'ח'
        21: SequenceLikelihood.POSITIVE,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.POSITIVE,  # 'ך'
        15: SequenceLikelihood.POSITIVE,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.POSITIVE,  # 'ס'
        13: SequenceLikelihood.POSITIVE,  # 'ע'
        26: SequenceLikelihood.POSITIVE,  # 'ף'
        18: SequenceLikelihood.POSITIVE,  # 'פ'
        27: SequenceLikelihood.LIKELY,  # 'ץ'
        23: SequenceLikelihood.LIKELY,  # 'צ'
        17: SequenceLikelihood.POSITIVE,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.LIKELY,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.NEGATIVE,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.LIKELY,  # 'ײ'
    },
    13: {  # 'ע'
        8: SequenceLikelihood.LIKELY,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.POSITIVE,  # 'ז'
        16: SequenceLikelihood.LIKELY,  # 'ח'
        21: SequenceLikelihood.POSITIVE,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.LIKELY,  # 'ך'
        15: SequenceLikelihood.POSITIVE,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.POSITIVE,  # 'ס'
        13: SequenceLikelihood.LIKELY,  # 'ע'
        26: SequenceLikelihood.LIKELY,  # 'ף'
        18: SequenceLikelihood.POSITIVE,  # 'פ'
        27: SequenceLikelihood.POSITIVE,  # 'ץ'
        23: SequenceLikelihood.POSITIVE,  # 'צ'
        17: SequenceLikelihood.POSITIVE,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.POSITIVE,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.LIKELY,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.LIKELY,  # 'ײ'
    },
    26: {  # 'ף'
        8: SequenceLikelihood.LIKELY,  # 'א'
        9: SequenceLikelihood.LIKELY,  # 'ב'
        20: SequenceLikelihood.LIKELY,  # 'ג'
        14: SequenceLikelihood.LIKELY,  # 'ד'
        3: SequenceLikelihood.LIKELY,  # 'ה'
        2: SequenceLikelihood.LIKELY,  # 'ו'
        24: SequenceLikelihood.LIKELY,  # 'ז'
        16: SequenceLikelihood.LIKELY,  # 'ח'
        21: SequenceLikelihood.LIKELY,  # 'ט'
        1: SequenceLikelihood.LIKELY,  # 'י'
        25: SequenceLikelihood.LIKELY,  # 'ך'
        15: SequenceLikelihood.LIKELY,  # 'כ'
        4: SequenceLikelihood.LIKELY,  # 'ל'
        12: SequenceLikelihood.LIKELY,  # 'ם'
        7: SequenceLikelihood.LIKELY,  # 'מ'
        22: SequenceLikelihood.LIKELY,  # 'ן'
        11: SequenceLikelihood.LIKELY,  # 'נ'
        19: SequenceLikelihood.LIKELY,  # 'ס'
        13: SequenceLikelihood.LIKELY,  # 'ע'
        26: SequenceLikelihood.LIKELY,  # 'ף'
        18: SequenceLikelihood.LIKELY,  # 'פ'
        27: SequenceLikelihood.NEGATIVE,  # 'ץ'
        23: SequenceLikelihood.LIKELY,  # 'צ'
        17: SequenceLikelihood.LIKELY,  # 'ק'
        6: SequenceLikelihood.LIKELY,  # 'ר'
        10: SequenceLikelihood.LIKELY,  # 'ש'
        5: SequenceLikelihood.LIKELY,  # 'ת'
        29: SequenceLikelihood.NEGATIVE,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.NEGATIVE,  # 'ײ'
    },
    18: {  # 'פ'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.POSITIVE,  # 'ז'
        16: SequenceLikelihood.POSITIVE,  # 'ח'
        21: SequenceLikelihood.POSITIVE,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.POSITIVE,  # 'ך'
        15: SequenceLikelihood.POSITIVE,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.LIKELY,  # 'ם'
        7: SequenceLikelihood.LIKELY,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.POSITIVE,  # 'ס'
        13: SequenceLikelihood.POSITIVE,  # 'ע'
        26: SequenceLikelihood.LIKELY,  # 'ף'
        18: SequenceLikelihood.LIKELY,  # 'פ'
        27: SequenceLikelihood.LIKELY,  # 'ץ'
        23: SequenceLikelihood.POSITIVE,  # 'צ'
        17: SequenceLikelihood.POSITIVE,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.POSITIVE,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.NEGATIVE,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.NEGATIVE,  # 'ײ'
    },
    27: {  # 'ץ'
        8: SequenceLikelihood.LIKELY,  # 'א'
        9: SequenceLikelihood.LIKELY,  # 'ב'
        20: SequenceLikelihood.LIKELY,  # 'ג'
        14: SequenceLikelihood.LIKELY,  # 'ד'
        3: SequenceLikelihood.LIKELY,  # 'ה'
        2: SequenceLikelihood.LIKELY,  # 'ו'
        24: SequenceLikelihood.LIKELY,  # 'ז'
        16: SequenceLikelihood.LIKELY,  # 'ח'
        21: SequenceLikelihood.LIKELY,  # 'ט'
        1: SequenceLikelihood.LIKELY,  # 'י'
        25: SequenceLikelihood.LIKELY,  # 'ך'
        15: SequenceLikelihood.LIKELY,  # 'כ'
        4: SequenceLikelihood.LIKELY,  # 'ל'
        12: SequenceLikelihood.LIKELY,  # 'ם'
        7: SequenceLikelihood.LIKELY,  # 'מ'
        22: SequenceLikelihood.LIKELY,  # 'ן'
        11: SequenceLikelihood.LIKELY,  # 'נ'
        19: SequenceLikelihood.LIKELY,  # 'ס'
        13: SequenceLikelihood.LIKELY,  # 'ע'
        26: SequenceLikelihood.LIKELY,  # 'ף'
        18: SequenceLikelihood.LIKELY,  # 'פ'
        27: SequenceLikelihood.LIKELY,  # 'ץ'
        23: SequenceLikelihood.LIKELY,  # 'צ'
        17: SequenceLikelihood.LIKELY,  # 'ק'
        6: SequenceLikelihood.LIKELY,  # 'ר'
        10: SequenceLikelihood.LIKELY,  # 'ש'
        5: SequenceLikelihood.LIKELY,  # 'ת'
        29: SequenceLikelihood.NEGATIVE,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.NEGATIVE,  # 'ײ'
    },
    23: {  # 'צ'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.LIKELY,  # 'ז'
        16: SequenceLikelihood.POSITIVE,  # 'ח'
        21: SequenceLikelihood.POSITIVE,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.LIKELY,  # 'ך'
        15: SequenceLikelihood.LIKELY,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.LIKELY,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.LIKELY,  # 'ס'
        13: SequenceLikelihood.POSITIVE,  # 'ע'
        26: SequenceLikelihood.LIKELY,  # 'ף'
        18: SequenceLikelihood.POSITIVE,  # 'פ'
        27: SequenceLikelihood.LIKELY,  # 'ץ'
        23: SequenceLikelihood.LIKELY,  # 'צ'
        17: SequenceLikelihood.LIKELY,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.LIKELY,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.LIKELY,  # 'װ'
        30: SequenceLikelihood.LIKELY,  # 'ױ'
        28: SequenceLikelihood.LIKELY,  # 'ײ'
    },
    17: {  # 'ק'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.LIKELY,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.LIKELY,  # 'ז'
        16: SequenceLikelihood.POSITIVE,  # 'ח'
        21: SequenceLikelihood.POSITIVE,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.LIKELY,  # 'ך'
        15: SequenceLikelihood.LIKELY,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.POSITIVE,  # 'ס'
        13: SequenceLikelihood.POSITIVE,  # 'ע'
        26: SequenceLikelihood.POSITIVE,  # 'ף'
        18: SequenceLikelihood.POSITIVE,  # 'פ'
        27: SequenceLikelihood.LIKELY,  # 'ץ'
        23: SequenceLikelihood.POSITIVE,  # 'צ'
        17: SequenceLikelihood.POSITIVE,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.POSITIVE,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.LIKELY,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.LIKELY,  # 'ײ'
    },
    6: {  # 'ר'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.POSITIVE,  # 'ז'
        16: SequenceLikelihood.POSITIVE,  # 'ח'
        21: SequenceLikelihood.POSITIVE,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.POSITIVE,  # 'ך'
        15: SequenceLikelihood.POSITIVE,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.POSITIVE,  # 'ס'
        13: SequenceLikelihood.POSITIVE,  # 'ע'
        26: SequenceLikelihood.POSITIVE,  # 'ף'
        18: SequenceLikelihood.POSITIVE,  # 'פ'
        27: SequenceLikelihood.POSITIVE,  # 'ץ'
        23: SequenceLikelihood.POSITIVE,  # 'צ'
        17: SequenceLikelihood.POSITIVE,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.POSITIVE,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.LIKELY,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.LIKELY,  # 'ײ'
    },
    10: {  # 'ש'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.POSITIVE,  # 'ז'
        16: SequenceLikelihood.POSITIVE,  # 'ח'
        21: SequenceLikelihood.POSITIVE,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.POSITIVE,  # 'ך'
        15: SequenceLikelihood.POSITIVE,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.POSITIVE,  # 'ס'
        13: SequenceLikelihood.POSITIVE,  # 'ע'
        26: SequenceLikelihood.LIKELY,  # 'ף'
        18: SequenceLikelihood.POSITIVE,  # 'פ'
        27: SequenceLikelihood.LIKELY,  # 'ץ'
        23: SequenceLikelihood.POSITIVE,  # 'צ'
        17: SequenceLikelihood.POSITIVE,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.POSITIVE,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.LIKELY,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.LIKELY,  # 'ײ'
    },
    5: {  # 'ת'
        8: SequenceLikelihood.POSITIVE,  # 'א'
        9: SequenceLikelihood.POSITIVE,  # 'ב'
        20: SequenceLikelihood.POSITIVE,  # 'ג'
        14: SequenceLikelihood.POSITIVE,  # 'ד'
        3: SequenceLikelihood.POSITIVE,  # 'ה'
        2: SequenceLikelihood.POSITIVE,  # 'ו'
        24: SequenceLikelihood.POSITIVE,  # 'ז'
        16: SequenceLikelihood.POSITIVE,  # 'ח'
        21: SequenceLikelihood.LIKELY,  # 'ט'
        1: SequenceLikelihood.POSITIVE,  # 'י'
        25: SequenceLikelihood.POSITIVE,  # 'ך'
        15: SequenceLikelihood.POSITIVE,  # 'כ'
        4: SequenceLikelihood.POSITIVE,  # 'ל'
        12: SequenceLikelihood.POSITIVE,  # 'ם'
        7: SequenceLikelihood.POSITIVE,  # 'מ'
        22: SequenceLikelihood.POSITIVE,  # 'ן'
        11: SequenceLikelihood.POSITIVE,  # 'נ'
        19: SequenceLikelihood.POSITIVE,  # 'ס'
        13: SequenceLikelihood.POSITIVE,  # 'ע'
        26: SequenceLikelihood.POSITIVE,  # 'ף'
        18: SequenceLikelihood.POSITIVE,  # 'פ'
        27: SequenceLikelihood.LIKELY,  # 'ץ'
        23: SequenceLikelihood.POSITIVE,  # 'צ'
        17: SequenceLikelihood.POSITIVE,  # 'ק'
        6: SequenceLikelihood.POSITIVE,  # 'ר'
        10: SequenceLikelihood.POSITIVE,  # 'ש'
        5: SequenceLikelihood.POSITIVE,  # 'ת'
        29: SequenceLikelihood.NEGATIVE,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.LIKELY,  # 'ײ'
    },
    29: {  # 'װ'
        8: SequenceLikelihood.NEGATIVE,  # 'א'
        9: SequenceLikelihood.NEGATIVE,  # 'ב'
        20: SequenceLikelihood.NEGATIVE,  # 'ג'
        14: SequenceLikelihood.LIKELY,  # 'ד'
        3: SequenceLikelihood.LIKELY,  # 'ה'
        2: SequenceLikelihood.NEGATIVE,  # 'ו'
        24: SequenceLikelihood.NEGATIVE,  # 'ז'
        16: SequenceLikelihood.LIKELY,  # 'ח'
        21: SequenceLikelihood.NEGATIVE,  # 'ט'
        1: SequenceLikelihood.LIKELY,  # 'י'
        25: SequenceLikelihood.NEGATIVE,  # 'ך'
        15: SequenceLikelihood.NEGATIVE,  # 'כ'
        4: SequenceLikelihood.NEGATIVE,  # 'ל'
        12: SequenceLikelihood.NEGATIVE,  # 'ם'
        7: SequenceLikelihood.NEGATIVE,  # 'מ'
        22: SequenceLikelihood.NEGATIVE,  # 'ן'
        11: SequenceLikelihood.LIKELY,  # 'נ'
        19: SequenceLikelihood.NEGATIVE,  # 'ס'
        13: SequenceLikelihood.LIKELY,  # 'ע'
        26: SequenceLikelihood.NEGATIVE,  # 'ף'
        18: SequenceLikelihood.NEGATIVE,  # 'פ'
        27: SequenceLikelihood.NEGATIVE,  # 'ץ'
        23: SequenceLikelihood.NEGATIVE,  # 'צ'
        17: SequenceLikelihood.LIKELY,  # 'ק'
        6: SequenceLikelihood.LIKELY,  # 'ר'
        10: SequenceLikelihood.NEGATIVE,  # 'ש'
        5: SequenceLikelihood.LIKELY,  # 'ת'
        29: SequenceLikelihood.NEGATIVE,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.NEGATIVE,  # 'ײ'
    },
    30: {  # 'ױ'
        8: SequenceLikelihood.NEGATIVE,  # 'א'
        9: SequenceLikelihood.NEGATIVE,  # 'ב'
        20: SequenceLikelihood.NEGATIVE,  # 'ג'
        14: SequenceLikelihood.NEGATIVE,  # 'ד'
        3: SequenceLikelihood.NEGATIVE,  # 'ה'
        2: SequenceLikelihood.NEGATIVE,  # 'ו'
        24: SequenceLikelihood.NEGATIVE,  # 'ז'
        16: SequenceLikelihood.NEGATIVE,  # 'ח'
        21: SequenceLikelihood.NEGATIVE,  # 'ט'
        1: SequenceLikelihood.LIKELY,  # 'י'
        25: SequenceLikelihood.NEGATIVE,  # 'ך'
        15: SequenceLikelihood.NEGATIVE,  # 'כ'
        4: SequenceLikelihood.NEGATIVE,  # 'ל'
        12: SequenceLikelihood.NEGATIVE,  # 'ם'
        7: SequenceLikelihood.NEGATIVE,  # 'מ'
        22: SequenceLikelihood.NEGATIVE,  # 'ן'
        11: SequenceLikelihood.NEGATIVE,  # 'נ'
        19: SequenceLikelihood.NEGATIVE,  # 'ס'
        13: SequenceLikelihood.NEGATIVE,  # 'ע'
        26: SequenceLikelihood.NEGATIVE,  # 'ף'
        18: SequenceLikelihood.NEGATIVE,  # 'פ'
        27: SequenceLikelihood.NEGATIVE,  # 'ץ'
        23: SequenceLikelihood.NEGATIVE,  # 'צ'
        17: SequenceLikelihood.NEGATIVE,  # 'ק'
        6: SequenceLikelihood.NEGATIVE,  # 'ר'
        10: SequenceLikelihood.LIKELY,  # 'ש'
        5: SequenceLikelihood.NEGATIVE,  # 'ת'
        29: SequenceLikelihood.NEGATIVE,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.NEGATIVE,  # 'ײ'
    },
    28: {  # 'ײ'
        8: SequenceLikelihood.NEGATIVE,  # 'א'
        9: SequenceLikelihood.LIKELY,  # 'ב'
        20: SequenceLikelihood.NEGATIVE,  # 'ג'
        14: SequenceLikelihood.NEGATIVE,  # 'ד'
        3: SequenceLikelihood.LIKELY,  # 'ה'
        2: SequenceLikelihood.LIKELY,  # 'ו'
        24: SequenceLikelihood.LIKELY,  # 'ז'
        16: SequenceLikelihood.NEGATIVE,  # 'ח'
        21: SequenceLikelihood.LIKELY,  # 'ט'
        1: SequenceLikelihood.LIKELY,  # 'י'
        25: SequenceLikelihood.LIKELY,  # 'ך'
        15: SequenceLikelihood.LIKELY,  # 'כ'
        4: SequenceLikelihood.NEGATIVE,  # 'ל'
        12: SequenceLikelihood.LIKELY,  # 'ם'
        7: SequenceLikelihood.LIKELY,  # 'מ'
        22: SequenceLikelihood.LIKELY,  # 'ן'
        11: SequenceLikelihood.LIKELY,  # 'נ'
        19: SequenceLikelihood.LIKELY,  # 'ס'
        13: SequenceLikelihood.NEGATIVE,  # 'ע'
        26: SequenceLikelihood.NEGATIVE,  # 'ף'
        18: SequenceLikelihood.LIKELY,  # 'פ'
        27: SequenceLikelihood.NEGATIVE,  # 'ץ'
        23: SequenceLikelihood.NEGATIVE,  # 'צ'
        17: SequenceLikelihood.NEGATIVE,  # 'ק'
        6: SequenceLikelihood.LIKELY,  # 'ר'
        10: SequenceLikelihood.LIKELY,  # 'ש'
        5: SequenceLikelihood.LIKELY,  # 'ת'
        29: SequenceLikelihood.NEGATIVE,  # 'װ'
        30: SequenceLikelihood.NEGATIVE,  # 'ױ'
        28: SequenceLikelihood.NEGATIVE,  # 'ײ'
    },
}

# Character Mapping Table(s):
CP424_HEBREW_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: 8,  # 'א'
    66: 9,  # 'ב'
    67: 20,  # 'ג'
    68: 14,  # 'ד'
    69: 3,  # 'ה'
    70: 2,  # 'ו'
    71: 24,  # 'ז'
    72: 16,  # 'ח'
    73: 21,  # 'ט'
    74: CharacterCategory.SYMBOL,  # '¢'
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '|'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 1,  # 'י'
    82: 25,  # 'ך'
    83: 15,  # 'כ'
    84: 4,  # 'ל'
    85: 12,  # 'ם'
    86: 7,  # 'מ'
    87: 22,  # 'ן'
    88: 11,  # 'נ'
    89: 19,  # 'ס'
    90: CharacterCategory.SYMBOL,  # '!'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '¬'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 13,  # 'ע'
    99: 26,  # 'ף'
    100: 18,  # 'פ'
    101: 27,  # 'ץ'
    102: 23,  # 'צ'
    103: 17,  # 'ק'
    104: 6,  # 'ר'
    105: 10,  # 'ש'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: CharacterCategory.UNDEFINED,  # None
    113: 5,  # 'ת'
    114: CharacterCategory.UNDEFINED,  # None
    115: CharacterCategory.UNDEFINED,  # None
    116: CharacterCategory.CONTROL,  # '\xa0'
    117: CharacterCategory.UNDEFINED,  # None
    118: CharacterCategory.UNDEFINED,  # None
    119: CharacterCategory.UNDEFINED,  # None
    120: CharacterCategory.SYMBOL,  # '‗'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: CharacterCategory.UNDEFINED,  # None
    129: 0,  # 'a'
    130: 0,  # 'b'
    131: 0,  # 'c'
    132: 0,  # 'd'
    133: 0,  # 'e'
    134: 0,  # 'f'
    135: 0,  # 'g'
    136: 0,  # 'h'
    137: 0,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: CharacterCategory.UNDEFINED,  # None
    141: CharacterCategory.UNDEFINED,  # None
    142: CharacterCategory.UNDEFINED,  # None
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 0,  # 'j'
    146: 0,  # 'k'
    147: 0,  # 'l'
    148: 0,  # 'm'
    149: 0,  # 'n'
    150: 0,  # 'o'
    151: 0,  # 'p'
    152: 0,  # 'q'
    153: 0,  # 'r'
    154: CharacterCategory.UNDEFINED,  # None
    155: CharacterCategory.UNDEFINED,  # None
    156: CharacterCategory.UNDEFINED,  # None
    157: CharacterCategory.SYMBOL,  # '¸'
    158: CharacterCategory.UNDEFINED,  # None
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 0,  # 's'
    163: 0,  # 't'
    164: 0,  # 'u'
    165: 0,  # 'v'
    166: 0,  # 'w'
    167: 0,  # 'x'
    168: 0,  # 'y'
    169: 0,  # 'z'
    170: CharacterCategory.UNDEFINED,  # None
    171: CharacterCategory.UNDEFINED,  # None
    172: CharacterCategory.UNDEFINED,  # None
    173: CharacterCategory.UNDEFINED,  # None
    174: CharacterCategory.UNDEFINED,  # None
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '^'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '['
    187: CharacterCategory.SYMBOL,  # ']'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 0,  # 'A'
    194: 0,  # 'B'
    195: 0,  # 'C'
    196: 0,  # 'D'
    197: 0,  # 'E'
    198: 0,  # 'F'
    199: 0,  # 'G'
    200: 0,  # 'H'
    201: 0,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: CharacterCategory.UNDEFINED,  # None
    204: CharacterCategory.UNDEFINED,  # None
    205: CharacterCategory.UNDEFINED,  # None
    206: CharacterCategory.UNDEFINED,  # None
    207: CharacterCategory.UNDEFINED,  # None
    208: CharacterCategory.SYMBOL,  # '}'
    209: 0,  # 'J'
    210: 0,  # 'K'
    211: 0,  # 'L'
    212: 0,  # 'M'
    213: 0,  # 'N'
    214: 0,  # 'O'
    215: 0,  # 'P'
    216: 0,  # 'Q'
    217: 0,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: CharacterCategory.UNDEFINED,  # None
    220: CharacterCategory.UNDEFINED,  # None
    221: CharacterCategory.UNDEFINED,  # None
    222: CharacterCategory.UNDEFINED,  # None
    223: CharacterCategory.UNDEFINED,  # None
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 0,  # 'S'
    227: 0,  # 'T'
    228: 0,  # 'U'
    229: 0,  # 'V'
    230: 0,  # 'W'
    231: 0,  # 'X'
    232: 0,  # 'Y'
    233: 0,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: CharacterCategory.UNDEFINED,  # None
    236: CharacterCategory.UNDEFINED,  # None
    237: CharacterCategory.UNDEFINED,  # None
    238: CharacterCategory.UNDEFINED,  # None
    239: CharacterCategory.UNDEFINED,  # None
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: CharacterCategory.UNDEFINED,  # None
    252: CharacterCategory.UNDEFINED,  # None
    253: CharacterCategory.UNDEFINED,  # None
    254: CharacterCategory.UNDEFINED,  # None
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP424_HEBREW_MODEL = SingleByteCharSetModel(
    charset_name="CP424",
    language="Hebrew",
    char_to_order_map=CP424_HEBREW_CHAR_TO_ORDER,
    language_model=HEBREW_LANG_MODEL,
    typical_positive_ratio=0.998630029821627,
    keep_ascii_letters=False,
    alphabet="אבגדהוזחטיךכלםמןנסעףפץצקרשתװױײ",
)

CP856_HEBREW_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 8,  # 'א'
    129: 9,  # 'ב'
    130: 20,  # 'ג'
    131: 14,  # 'ד'
    132: 3,  # 'ה'
    133: 2,  # 'ו'
    134: 24,  # 'ז'
    135: 16,  # 'ח'
    136: 21,  # 'ט'
    137: 1,  # 'י'
    138: 25,  # 'ך'
    139: 15,  # 'כ'
    140: 4,  # 'ל'
    141: 12,  # 'ם'
    142: 7,  # 'מ'
    143: 22,  # 'ן'
    144: 11,  # 'נ'
    145: 19,  # 'ס'
    146: 13,  # 'ע'
    147: 26,  # 'ף'
    148: 18,  # 'פ'
    149: 27,  # 'ץ'
    150: 23,  # 'צ'
    151: 17,  # 'ק'
    152: 6,  # 'ר'
    153: 10,  # 'ש'
    154: 5,  # 'ת'
    155: CharacterCategory.UNDEFINED,  # None
    156: CharacterCategory.SYMBOL,  # '£'
    157: CharacterCategory.UNDEFINED,  # None
    158: CharacterCategory.SYMBOL,  # '×'
    159: CharacterCategory.UNDEFINED,  # None
    160: CharacterCategory.UNDEFINED,  # None
    161: CharacterCategory.UNDEFINED,  # None
    162: CharacterCategory.UNDEFINED,  # None
    163: CharacterCategory.UNDEFINED,  # None
    164: CharacterCategory.UNDEFINED,  # None
    165: CharacterCategory.UNDEFINED,  # None
    166: CharacterCategory.UNDEFINED,  # None
    167: CharacterCategory.UNDEFINED,  # None
    168: CharacterCategory.UNDEFINED,  # None
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.UNDEFINED,  # None
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.UNDEFINED,  # None
    182: CharacterCategory.UNDEFINED,  # None
    183: CharacterCategory.UNDEFINED,  # None
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.UNDEFINED,  # None
    199: CharacterCategory.UNDEFINED,  # None
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: CharacterCategory.UNDEFINED,  # None
    209: CharacterCategory.UNDEFINED,  # None
    210: CharacterCategory.UNDEFINED,  # None
    211: CharacterCategory.UNDEFINED,  # None
    212: CharacterCategory.UNDEFINED,  # None
    213: CharacterCategory.UNDEFINED,  # None
    214: CharacterCategory.UNDEFINED,  # None
    215: CharacterCategory.UNDEFINED,  # None
    216: CharacterCategory.UNDEFINED,  # None
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: CharacterCategory.UNDEFINED,  # None
    223: CharacterCategory.SYMBOL,  # '▀'
    224: CharacterCategory.UNDEFINED,  # None
    225: CharacterCategory.UNDEFINED,  # None
    226: CharacterCategory.UNDEFINED,  # None
    227: CharacterCategory.UNDEFINED,  # None
    228: CharacterCategory.UNDEFINED,  # None
    229: CharacterCategory.UNDEFINED,  # None
    230: 0,  # 'µ'
    231: CharacterCategory.UNDEFINED,  # None
    232: CharacterCategory.UNDEFINED,  # None
    233: CharacterCategory.UNDEFINED,  # None
    234: CharacterCategory.UNDEFINED,  # None
    235: CharacterCategory.UNDEFINED,  # None
    236: CharacterCategory.UNDEFINED,  # None
    237: CharacterCategory.UNDEFINED,  # None
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP856_HEBREW_MODEL = SingleByteCharSetModel(
    charset_name="CP856",
    language="Hebrew",
    char_to_order_map=CP856_HEBREW_CHAR_TO_ORDER,
    language_model=HEBREW_LANG_MODEL,
    typical_positive_ratio=0.998630029821627,
    keep_ascii_letters=False,
    alphabet="אבגדהוזחטיךכלםמןנסעףפץצקרשתװױײ",
)

CP862_HEBREW_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 8,  # 'א'
    129: 9,  # 'ב'
    130: 20,  # 'ג'
    131: 14,  # 'ד'
    132: 3,  # 'ה'
    133: 2,  # 'ו'
    134: 24,  # 'ז'
    135: 16,  # 'ח'
    136: 21,  # 'ט'
    137: 1,  # 'י'
    138: 25,  # 'ך'
    139: 15,  # 'כ'
    140: 4,  # 'ל'
    141: 12,  # 'ם'
    142: 7,  # 'מ'
    143: 22,  # 'ן'
    144: 11,  # 'נ'
    145: 19,  # 'ס'
    146: 13,  # 'ע'
    147: 26,  # 'ף'
    148: 18,  # 'פ'
    149: 27,  # 'ץ'
    150: 23,  # 'צ'
    151: 17,  # 'ק'
    152: 6,  # 'ר'
    153: 10,  # 'ש'
    154: 5,  # 'ת'
    155: CharacterCategory.SYMBOL,  # '¢'
    156: CharacterCategory.SYMBOL,  # '£'
    157: CharacterCategory.SYMBOL,  # '¥'
    158: CharacterCategory.SYMBOL,  # '₧'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '⌐'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'α'
    225: 0,  # 'ß'
    226: 0,  # 'Γ'
    227: 0,  # 'π'
    228: 0,  # 'Σ'
    229: 0,  # 'σ'
    230: 0,  # 'µ'
    231: 0,  # 'τ'
    232: 0,  # 'Φ'
    233: 0,  # 'Θ'
    234: 0,  # 'Ω'
    235: 0,  # 'δ'
    236: CharacterCategory.SYMBOL,  # '∞'
    237: 0,  # 'φ'
    238: 0,  # 'ε'
    239: CharacterCategory.SYMBOL,  # '∩'
    240: CharacterCategory.SYMBOL,  # '≡'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '≥'
    243: CharacterCategory.SYMBOL,  # '≤'
    244: CharacterCategory.SYMBOL,  # '⌠'
    245: CharacterCategory.SYMBOL,  # '⌡'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '≈'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: 0,  # 'ⁿ'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP862_HEBREW_MODEL = SingleByteCharSetModel(
    charset_name="CP862",
    language="Hebrew",
    char_to_order_map=CP862_HEBREW_CHAR_TO_ORDER,
    language_model=HEBREW_LANG_MODEL,
    typical_positive_ratio=0.998630029821627,
    keep_ascii_letters=False,
    alphabet="אבגדהוזחטיךכלםמןנסעףפץצקרשתװױײ",
)

ISO_8859_8_HEBREW_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.UNDEFINED,  # None
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '×'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: CharacterCategory.SYMBOL,  # '÷'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.UNDEFINED,  # None
    192: CharacterCategory.UNDEFINED,  # None
    193: CharacterCategory.UNDEFINED,  # None
    194: CharacterCategory.UNDEFINED,  # None
    195: CharacterCategory.UNDEFINED,  # None
    196: CharacterCategory.UNDEFINED,  # None
    197: CharacterCategory.UNDEFINED,  # None
    198: CharacterCategory.UNDEFINED,  # None
    199: CharacterCategory.UNDEFINED,  # None
    200: CharacterCategory.UNDEFINED,  # None
    201: CharacterCategory.UNDEFINED,  # None
    202: CharacterCategory.UNDEFINED,  # None
    203: CharacterCategory.UNDEFINED,  # None
    204: CharacterCategory.UNDEFINED,  # None
    205: CharacterCategory.UNDEFINED,  # None
    206: CharacterCategory.UNDEFINED,  # None
    207: CharacterCategory.UNDEFINED,  # None
    208: CharacterCategory.UNDEFINED,  # None
    209: CharacterCategory.UNDEFINED,  # None
    210: CharacterCategory.UNDEFINED,  # None
    211: CharacterCategory.UNDEFINED,  # None
    212: CharacterCategory.UNDEFINED,  # None
    213: CharacterCategory.UNDEFINED,  # None
    214: CharacterCategory.UNDEFINED,  # None
    215: CharacterCategory.UNDEFINED,  # None
    216: CharacterCategory.UNDEFINED,  # None
    217: CharacterCategory.UNDEFINED,  # None
    218: CharacterCategory.UNDEFINED,  # None
    219: CharacterCategory.UNDEFINED,  # None
    220: CharacterCategory.UNDEFINED,  # None
    221: CharacterCategory.UNDEFINED,  # None
    222: CharacterCategory.UNDEFINED,  # None
    223: CharacterCategory.SYMBOL,  # '‗'
    224: 8,  # 'א'
    225: 9,  # 'ב'
    226: 20,  # 'ג'
    227: 14,  # 'ד'
    228: 3,  # 'ה'
    229: 2,  # 'ו'
    230: 24,  # 'ז'
    231: 16,  # 'ח'
    232: 21,  # 'ט'
    233: 1,  # 'י'
    234: 25,  # 'ך'
    235: 15,  # 'כ'
    236: 4,  # 'ל'
    237: 12,  # 'ם'
    238: 7,  # 'מ'
    239: 22,  # 'ן'
    240: 11,  # 'נ'
    241: 19,  # 'ס'
    242: 13,  # 'ע'
    243: 26,  # 'ף'
    244: 18,  # 'פ'
    245: 27,  # 'ץ'
    246: 23,  # 'צ'
    247: 17,  # 'ק'
    248: 6,  # 'ר'
    249: 10,  # 'ש'
    250: 5,  # 'ת'
    251: CharacterCategory.UNDEFINED,  # None
    252: CharacterCategory.UNDEFINED,  # None
    253: CharacterCategory.CONTROL,  # '\u200e'
    254: CharacterCategory.CONTROL,  # '\u200f'
    255: CharacterCategory.UNDEFINED,  # None
}

ISO_8859_8_HEBREW_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-8",
    language="Hebrew",
    char_to_order_map=ISO_8859_8_HEBREW_CHAR_TO_ORDER,
    language_model=HEBREW_LANG_MODEL,
    typical_positive_ratio=0.998630029821627,
    keep_ascii_letters=False,
    alphabet="אבגדהוזחטיךכלםמןנסעףפץצקרשתװױײ",
)

WINDOWS_1255_HEBREW_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ƒ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: 0,  # 'ˆ'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: CharacterCategory.UNDEFINED,  # None
    139: CharacterCategory.SYMBOL,  # '‹'
    140: CharacterCategory.UNDEFINED,  # None
    141: CharacterCategory.UNDEFINED,  # None
    142: CharacterCategory.UNDEFINED,  # None
    143: CharacterCategory.UNDEFINED,  # None
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.SYMBOL,  # '˜'
    153: CharacterCategory.SYMBOL,  # '™'
    154: CharacterCategory.UNDEFINED,  # None
    155: CharacterCategory.SYMBOL,  # '›'
    156: CharacterCategory.UNDEFINED,  # None
    157: CharacterCategory.UNDEFINED,  # None
    158: CharacterCategory.UNDEFINED,  # None
    159: CharacterCategory.UNDEFINED,  # None
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '₪'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '×'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: CharacterCategory.SYMBOL,  # '÷'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: CharacterCategory.SYMBOL,  # 'ְ'
    193: CharacterCategory.SYMBOL,  # 'ֱ'
    194: CharacterCategory.SYMBOL,  # 'ֲ'
    195: CharacterCategory.SYMBOL,  # 'ֳ'
    196: CharacterCategory.SYMBOL,  # 'ִ'
    197: CharacterCategory.SYMBOL,  # 'ֵ'
    198: CharacterCategory.SYMBOL,  # 'ֶ'
    199: CharacterCategory.SYMBOL,  # 'ַ'
    200: CharacterCategory.SYMBOL,  # 'ָ'
    201: CharacterCategory.SYMBOL,  # 'ֹ'
    202: CharacterCategory.UNDEFINED,  # None
    203: CharacterCategory.SYMBOL,  # 'ֻ'
    204: CharacterCategory.SYMBOL,  # 'ּ'
    205: CharacterCategory.SYMBOL,  # 'ֽ'
    206: CharacterCategory.SYMBOL,  # '־'
    207: CharacterCategory.SYMBOL,  # 'ֿ'
    208: CharacterCategory.SYMBOL,  # '׀'
    209: CharacterCategory.SYMBOL,  # 'ׁ'
    210: CharacterCategory.SYMBOL,  # 'ׂ'
    211: CharacterCategory.SYMBOL,  # '׃'
    212: 29,  # 'װ'
    213: 30,  # 'ױ'
    214: 28,  # 'ײ'
    215: CharacterCategory.SYMBOL,  # '׳'
    216: CharacterCategory.SYMBOL,  # '״'
    217: CharacterCategory.UNDEFINED,  # None
    218: CharacterCategory.UNDEFINED,  # None
    219: CharacterCategory.UNDEFINED,  # None
    220: CharacterCategory.UNDEFINED,  # None
    221: CharacterCategory.UNDEFINED,  # None
    222: CharacterCategory.UNDEFINED,  # None
    223: CharacterCategory.UNDEFINED,  # None
    224: 8,  # 'א'
    225: 9,  # 'ב'
    226: 20,  # 'ג'
    227: 14,  # 'ד'
    228: 3,  # 'ה'
    229: 2,  # 'ו'
    230: 24,  # 'ז'
    231: 16,  # 'ח'
    232: 21,  # 'ט'
    233: 1,  # 'י'
    234: 25,  # 'ך'
    235: 15,  # 'כ'
    236: 4,  # 'ל'
    237: 12,  # 'ם'
    238: 7,  # 'מ'
    239: 22,  # 'ן'
    240: 11,  # 'נ'
    241: 19,  # 'ס'
    242: 13,  # 'ע'
    243: 26,  # 'ף'
    244: 18,  # 'פ'
    245: 27,  # 'ץ'
    246: 23,  # 'צ'
    247: 17,  # 'ק'
    248: 6,  # 'ר'
    249: 10,  # 'ש'
    250: 5,  # 'ת'
    251: CharacterCategory.UNDEFINED,  # None
    252: CharacterCategory.UNDEFINED,  # None
    253: CharacterCategory.CONTROL,  # '\u200e'
    254: CharacterCategory.CONTROL,  # '\u200f'
    255: CharacterCategory.UNDEFINED,  # None
}

WINDOWS_1255_HEBREW_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1255",
    language="Hebrew",
    char_to_order_map=WINDOWS_1255_HEBREW_CHAR_TO_ORDER,
    language_model=HEBREW_LANG_MODEL,
    typical_positive_ratio=0.9986288176505997,
    keep_ascii_letters=False,
    alphabet="אבגדהוזחטיךכלםמןנסעףפץצקרשתװױײ",
)
