/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.RecurrenceType;
import net.sf.mpxj.RecurringData;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;

public final class ProjectCalendarException
extends ProjectCalendarHours
implements Comparable<ProjectCalendarException> {
    private final Date m_fromDate;
    private final Date m_toDate;
    private final RecurringData m_recurring;
    private String m_name;

    ProjectCalendarException(Date fromDate, Date toDate) {
        this(fromDate, toDate, null);
    }

    ProjectCalendarException(RecurringData recurringData) {
        this(null, null, recurringData);
    }

    ProjectCalendarException(Date fromDate, Date toDate, RecurringData recurringData) {
        this.m_fromDate = DateHelper.getDayStartDate(fromDate);
        this.m_toDate = DateHelper.getDayEndDate(toDate);
        this.m_recurring = recurringData;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public Date getFromDate() {
        return this.m_recurring == null ? this.m_fromDate : this.m_recurring.getCalculatedFirstDate();
    }

    public Date getToDate() {
        return this.m_recurring == null ? this.m_toDate : DateHelper.getDayEndDate(this.m_recurring.getCalculatedLastDate());
    }

    public RecurringData getRecurring() {
        return this.m_recurring;
    }

    public boolean getWorking() {
        return this.size() != 0;
    }

    public List<ProjectCalendarException> getExpandedExceptions() {
        ArrayList<ProjectCalendarException> result = new ArrayList<ProjectCalendarException>();
        if (this.m_recurring == null || this.m_recurring.getRecurrenceType() == RecurrenceType.DAILY && NumberHelper.getInt(this.m_recurring.getFrequency()) == 1) {
            result.add(this);
        } else {
            for (Date date : this.m_recurring.getDates()) {
                Date startDate = DateHelper.getDayStartDate(date);
                Date endDate = DateHelper.getDayEndDate(date);
                ProjectCalendarException newException = new ProjectCalendarException(startDate, endDate);
                int rangeCount = this.size();
                for (int rangeIndex = 0; rangeIndex < rangeCount; ++rangeIndex) {
                    newException.add(this.get(rangeIndex));
                }
                result.add(newException);
            }
        }
        return result;
    }

    public boolean contains(Date date) {
        boolean result = false;
        if (date != null) {
            result = DateHelper.compare(this.getFromDate(), this.getToDate(), date) == 0;
        }
        return result;
    }

    public boolean contains(ProjectCalendarException exception) {
        return DateHelper.compare(this.getToDate(), exception.getFromDate()) >= 0 && DateHelper.compare(exception.getToDate(), this.getFromDate()) >= 0;
    }

    public boolean isWorking() {
        return !this.isEmpty();
    }

    @Override
    public int compareTo(ProjectCalendarException o) {
        long fromTime1 = this.getFromDate().getTime();
        long fromTime2 = o.getFromDate().getTime();
        return Long.compare(fromTime1, fromTime2);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ProjectCalendarException");
        if (this.m_name != null && !this.m_name.isEmpty()) {
            sb.append(" name=").append(this.m_name);
        }
        sb.append(" working=").append(this.getWorking());
        if (this.m_recurring == null) {
            sb.append(" fromDate=").append(this.m_fromDate);
            sb.append(" toDate=").append(this.m_toDate);
        } else {
            sb.append(" recurring=").append(this.m_recurring);
        }
        for (DateRange range : this) {
            sb.append(range.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

