/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import java.awt.GridLayout;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.tree.TreePath;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.explorer.MpxjTreeNode;
import net.sf.mpxj.explorer.ObjectPropertiesPanel;
import net.sf.mpxj.explorer.ProjectTreeController;
import net.sf.mpxj.explorer.ProjectTreeModel;
import net.sf.mpxj.explorer.ProjectTreeView;

public class ProjectFilePanel
extends JPanel {
    private final ProjectTreeController m_treeController;
    final Map<MpxjTreeNode, ObjectPropertiesPanel> m_openTabs;

    public ProjectFilePanel(File file, ProjectFile projectFile) {
        ProjectTreeModel treeModel = new ProjectTreeModel();
        this.m_treeController = new ProjectTreeController(treeModel);
        this.setLayout(new GridLayout(0, 1, 0, 0));
        ProjectTreeView treeView = new ProjectTreeView(treeModel);
        treeView.setShowsRootHandles(true);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setDividerLocation(0.3);
        this.add(splitPane);
        JScrollPane scrollPane = new JScrollPane(treeView);
        splitPane.setLeftComponent(scrollPane);
        JTabbedPane tabbedPane = new JTabbedPane(1);
        splitPane.setRightComponent(tabbedPane);
        this.m_openTabs = new HashMap<MpxjTreeNode, ObjectPropertiesPanel>();
        treeView.addTreeSelectionListener(e -> {
            TreePath path = e.getPath();
            MpxjTreeNode component = (MpxjTreeNode)path.getLastPathComponent();
            if (!(component.getUserObject() instanceof String)) {
                ObjectPropertiesPanel panel = this.m_openTabs.get(component);
                if (panel == null) {
                    panel = new ObjectPropertiesPanel(component.getUserObject(), component.getExcludedMethods());
                    tabbedPane.add(component.toString(), panel);
                    this.m_openTabs.put(component, panel);
                }
                tabbedPane.setSelectedComponent(panel);
            }
        });
        this.m_treeController.loadFile(file, projectFile);
    }

    public void saveFile(File file, String type) {
        if (file != null) {
            this.m_treeController.saveFile(file, type);
        }
    }

    public void cleanFile(File file) {
        if (file != null) {
            this.m_treeController.cleanFile(file);
        }
    }
}

