/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.awt.Color;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ActivityCode;
import net.sf.mpxj.ActivityCodeContainer;
import net.sf.mpxj.ActivityCodeScope;
import net.sf.mpxj.ActivityCodeValue;
import net.sf.mpxj.ActivityStatus;
import net.sf.mpxj.ActivityType;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.Availability;
import net.sf.mpxj.CalendarType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CostAccount;
import net.sf.mpxj.CostAccountContainer;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.CriticalActivityType;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.DataType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.ExpenseCategory;
import net.sf.mpxj.ExpenseCategoryContainer;
import net.sf.mpxj.ExpenseItem;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.HtmlNotes;
import net.sf.mpxj.Notes;
import net.sf.mpxj.ParentNotes;
import net.sf.mpxj.PercentCompleteType;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.RateSource;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.StructuredNotes;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.SlackHelper;
import net.sf.mpxj.primavera.ActivitySorter;
import net.sf.mpxj.primavera.ClashMap;
import net.sf.mpxj.primavera.ExternalRelation;
import net.sf.mpxj.primavera.PrimaveraBaselineStrategy;
import net.sf.mpxj.primavera.Row;
import net.sf.mpxj.primavera.StructuredTextParser;
import net.sf.mpxj.primavera.StructuredTextRecord;
import net.sf.mpxj.primavera.UserFieldCounters;
import net.sf.mpxj.primavera.UserFieldDataType;

final class PrimaveraReader {
    private final ProjectFile m_project;
    private final EventManager m_eventManager;
    private final ClashMap m_activityClashMap = new ClashMap();
    private final ClashMap m_roleClashMap = new ClashMap();
    private final DateFormat m_calendarTimeFormat = new SimpleDateFormat("HH:mm");
    private Integer m_defaultCalendarID;
    private final UserFieldCounters m_taskUdfCounters;
    private final UserFieldCounters m_resourceUdfCounters;
    private final UserFieldCounters m_assignmentUdfCounters;
    private final Map<FieldType, String> m_resourceFields;
    private final Map<FieldType, String> m_roleFields;
    private final Map<FieldType, String> m_wbsFields;
    private final Map<FieldType, String> m_taskFields;
    private final Map<FieldType, String> m_assignmentFields;
    private final List<ExternalRelation> m_externalRelations = new ArrayList<ExternalRelation>();
    private final boolean m_matchPrimaveraWBS;
    private final boolean m_wbsIsFullPath;
    private final Map<Integer, FieldType> m_udfFields = new HashMap<Integer, FieldType>();
    private final Map<String, Map<Integer, List<Row>>> m_udfValues = new HashMap<String, Map<Integer, List<Row>>>();
    private final Map<Integer, ActivityCodeValue> m_activityCodeMap = new HashMap<Integer, ActivityCodeValue>();
    private final Map<Integer, List<Integer>> m_activityCodeAssignments = new HashMap<Integer, List<Integer>>();
    private static final Map<String, ResourceType> RESOURCE_TYPE_MAP = new HashMap<String, ResourceType>();
    private static final Map<String, ConstraintType> CONSTRAINT_TYPE_MAP;
    private static final Map<String, Priority> PRIORITY_MAP;
    private static final Map<String, RelationType> RELATION_TYPE_MAP;
    private static final Map<String, TaskType> TASK_TYPE_MAP;
    private static final Map<String, Boolean> MILESTONE_MAP;
    private static final Map<String, ActivityType> ACTIVITY_TYPE_MAP;
    private static final Map<String, CurrencySymbolPosition> CURRENCY_SYMBOL_POSITION_MAP;
    private static final Map<String, Boolean> STATICTYPE_UDF_MAP;
    private static final Map<String, FieldTypeClass> FIELD_TYPE_MAP;
    private static final Map<String, AccrueType> ACCRUE_TYPE_MAP;
    private static final Map<String, PercentCompleteType> PERCENT_COMPLETE_TYPE;
    private static final Map<String, ActivityStatus> STATUS_MAP;
    private static final Map<String, CriticalActivityType> CRITICAL_ACTIVITY_MAP;
    private static final Map<String, CalendarType> CALENDAR_TYPE_MAP;
    private static final Map<String, ActivityCodeScope> ACTIVITY_CODE_SCOPE_MAP;
    private static final Map<String, Integer> RATE_TYPE_MAP;
    private static final Map<String, RateSource> RATE_SOURCE_MAP;
    private static final long EXCEPTION_EPOCH = -2209161599935L;
    static final String DEFAULT_WBS_SEPARATOR = ".";

    public PrimaveraReader(UserFieldCounters taskUdfCounters, UserFieldCounters resourceUdfCounters, UserFieldCounters assignmentUdfCounters, Map<FieldType, String> resourceFields, Map<FieldType, String> roleFields, Map<FieldType, String> wbsFields, Map<FieldType, String> taskFields, Map<FieldType, String> assignmentFields, boolean matchPrimaveraWBS, boolean wbsIsFullPath) {
        this.m_project = new ProjectFile();
        this.m_eventManager = this.m_project.getEventManager();
        ProjectConfig config = this.m_project.getProjectConfig();
        config.setAutoTaskUniqueID(false);
        config.setAutoResourceUniqueID(false);
        config.setAutoAssignmentUniqueID(false);
        config.setAutoWBS(false);
        config.setBaselineStrategy(new PrimaveraBaselineStrategy());
        this.m_resourceFields = resourceFields;
        this.m_roleFields = roleFields;
        this.m_wbsFields = wbsFields;
        this.m_taskFields = taskFields;
        this.m_assignmentFields = assignmentFields;
        this.m_taskUdfCounters = taskUdfCounters;
        this.m_taskUdfCounters.reset();
        this.m_resourceUdfCounters = resourceUdfCounters;
        this.m_resourceUdfCounters.reset();
        this.m_assignmentUdfCounters = assignmentUdfCounters;
        this.m_assignmentUdfCounters.reset();
        this.m_matchPrimaveraWBS = matchPrimaveraWBS;
        this.m_wbsIsFullPath = wbsIsFullPath;
    }

    public ProjectFile getProject() {
        return this.m_project;
    }

    public List<ExternalRelation> getExternalRelations() {
        return this.m_externalRelations;
    }

    public void processProjectProperties(List<Row> rows) {
        if (!rows.isEmpty()) {
            Row row = rows.get(0);
            ProjectProperties properties = this.m_project.getProjectProperties();
            properties.setBaselineProjectUniqueID(row.getInteger("sum_base_proj_id"));
            properties.setCreationDate(row.getDate("create_date"));
            properties.setCriticalActivityType(CRITICAL_ACTIVITY_MAP.getOrDefault(row.getString("critical_path_type"), CriticalActivityType.TOTAL_FLOAT));
            properties.setGUID(row.getUUID("guid"));
            properties.setProjectID(row.getString("proj_short_name"));
            properties.setName(row.getString("proj_short_name"));
            properties.setDefaultTaskType(TASK_TYPE_MAP.get(row.getString("def_duration_type")));
            properties.setStatusDate(row.getDate("last_recalc_date"));
            properties.setFiscalYearStartMonth(row.getInteger("fy_start_month_num"));
            properties.setUniqueID(row.getInteger("proj_id"));
            properties.setExportFlag(row.getBoolean("export_flag"));
            properties.setPlannedStart(row.getDate("plan_start_date"));
            properties.setScheduledFinish(row.getDate("scd_end_date"));
            properties.setMustFinishBy(row.getDate("plan_end_date"));
            this.m_defaultCalendarID = row.getInteger("clndr_id");
        }
    }

    public void processExpenseCategories(List<Row> categories) {
        ExpenseCategoryContainer container = this.m_project.getExpenseCategories();
        categories.forEach(row -> container.add(new ExpenseCategory(row.getInteger("cost_type_id"), row.getString("cost_type"), row.getInteger("seq_num"))));
    }

    public void processCostAccounts(List<Row> accounts) {
        CostAccountContainer container = this.m_project.getCostAccounts();
        accounts.forEach(row -> container.add(new CostAccount(row.getInteger("acct_id"), row.getString("acct_short_name"), row.getString("acct_name"), row.getString("acct_descr"), row.getInteger("acct_seq_num"))));
        accounts.forEach(row -> ((CostAccount)container.getByUniqueID(row.getInteger("acct_id"))).setParent((CostAccount)container.getByUniqueID(row.getInteger("parent_acct_id"))));
    }

    public void processActivityCodes(List<Row> types, List<Row> typeValues, List<Row> assignments) {
        ActivityCode code;
        ActivityCodeContainer container = this.m_project.getActivityCodes();
        HashMap<Integer, ActivityCode> map = new HashMap<Integer, ActivityCode>();
        for (Row row : types) {
            code = new ActivityCode(row.getInteger("actv_code_type_id"), ACTIVITY_CODE_SCOPE_MAP.get(row.getString("actv_code_type_scope")), row.getInteger("proj_id"), row.getInteger("seq_num"), row.getString("actv_code_type"));
            container.add(code);
            map.put(code.getUniqueID(), code);
        }
        for (Row row : typeValues) {
            code = (ActivityCode)map.get(row.getInteger("actv_code_type_id"));
            if (code == null) continue;
            ActivityCodeValue value = code.addValue(row.getInteger("actv_code_id"), row.getInteger("seq_num"), row.getString("short_name"), row.getString("actv_code_name"), this.getColor(row.getString("color")));
            this.m_activityCodeMap.put(value.getUniqueID(), value);
        }
        for (Row row : typeValues) {
            ActivityCodeValue child = this.m_activityCodeMap.get(row.getInteger("actv_code_id"));
            ActivityCodeValue parent = this.m_activityCodeMap.get(row.getInteger("parent_actv_code_id"));
            if (parent == null || child == null) continue;
            child.setParent(parent);
        }
        for (Row row : assignments) {
            Integer taskID = row.getInteger("task_id");
            List list = this.m_activityCodeAssignments.computeIfAbsent(taskID, k -> new ArrayList());
            list.add(row.getInteger("actv_code_id"));
        }
    }

    private Color getColor(String value) {
        Color result = null;
        if (value != null && value.length() > 0) {
            result = new Color(Integer.parseInt(value, 16));
        }
        return result;
    }

    public void processUserDefinedFields(List<Row> fields, List<Row> values) {
        String tableName;
        HashMap<Integer, String> tableNameMap = new HashMap<Integer, String>();
        for (Row row : fields) {
            String fieldDataType;
            FieldType fieldType;
            Integer fieldId = row.getInteger("udf_type_id");
            tableName = row.getString("table_name");
            tableNameMap.put(fieldId, tableName);
            FieldTypeClass fieldTypeClass = FIELD_TYPE_MAP.get(tableName);
            if (fieldTypeClass == null || (fieldType = this.allocateUserDefinedField(fieldTypeClass, UserFieldDataType.valueOf(fieldDataType = row.getString("logical_data_type")))) == null) continue;
            String fieldName = row.getString("udf_type_label");
            this.m_udfFields.put(fieldId, fieldType);
            this.m_project.getCustomFields().add(fieldType).setAlias(fieldName).setUniqueID(fieldId);
        }
        for (Row row : values) {
            Integer typeID = row.getInteger("udf_type_id");
            tableName = (String)tableNameMap.get(typeID);
            Map tableData = this.m_udfValues.computeIfAbsent(tableName, k -> new HashMap());
            Integer id = row.getInteger("fk_id");
            List list = tableData.computeIfAbsent(id, k -> new ArrayList());
            list.add(row);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void processCalendars(List<Row> rows) {
        void var4_9;
        HashMap<ProjectCalendar, Integer> baseCalendarMap = new HashMap<ProjectCalendar, Integer>();
        for (Row row : rows) {
            ProjectCalendar calendar = this.processCalendar(row);
            Integer baseCalendarID = row.getInteger("base_clndr_id");
            if (baseCalendarID == null) continue;
            baseCalendarMap.put(calendar, baseCalendarID);
        }
        for (Map.Entry entry : baseCalendarMap.entrySet()) {
            ProjectCalendar baseCalendar = this.m_project.getCalendarByUniqueID((Integer)entry.getValue());
            if (baseCalendar == null) continue;
            ((ProjectCalendar)entry.getKey()).setParent(baseCalendar);
        }
        ProjectConfig config = this.m_project.getProjectConfig();
        config.setAutoCalendarUniqueID(true);
        config.updateCalendarUniqueCounter();
        ProjectCalendar projectCalendar = this.m_project.getCalendarByUniqueID(this.m_defaultCalendarID);
        if (projectCalendar == null) {
            ProjectCalendar projectCalendar2 = this.m_project.getCalendars().findOrCreateDefaultCalendar();
        }
        this.m_project.setDefaultCalendar((ProjectCalendar)var4_9);
    }

    public ProjectCalendar processCalendar(Row row) {
        String calendarData;
        ProjectCalendar calendar = this.m_project.addCalendar();
        Integer id = row.getInteger("clndr_id");
        calendar.setUniqueID(id);
        calendar.setName(row.getString("clndr_name"));
        calendar.setType(CALENDAR_TYPE_MAP.get(row.getString("clndr_type")));
        calendar.setPersonal(row.getBoolean("rsrc_private"));
        if (row.getBoolean("default_flag") && this.m_defaultCalendarID == null) {
            this.m_defaultCalendarID = id;
        }
        if ((calendarData = row.getString("clndr_data")) != null && !calendarData.isEmpty()) {
            StructuredTextParser parser = new StructuredTextParser();
            parser.setRaiseExceptionOnParseError(false);
            StructuredTextRecord root = parser.parse(calendarData);
            StructuredTextRecord daysOfWeek = root.getChild("DaysOfWeek");
            StructuredTextRecord exceptions = root.getChild("Exceptions");
            if (daysOfWeek == null) {
                if (row.getInteger("base_clndr_id") == null) {
                    calendar.addDefaultCalendarDays();
                    calendar.addDefaultCalendarHours();
                }
            } else {
                this.processCalendarDays(calendar, daysOfWeek);
            }
            if (exceptions != null) {
                this.processCalendarExceptions(calendar, exceptions);
            }
        } else {
            DateRange defaultHourRange = new DateRange(DateHelper.getTime(8, 0), DateHelper.getTime(16, 0));
            for (Day day : Day.values()) {
                ProjectCalendarHours hours = calendar.addCalendarHours(day);
                if (day != Day.SATURDAY && day != Day.SUNDAY) {
                    calendar.setWorkingDay(day, true);
                    hours.add(defaultHourRange);
                    continue;
                }
                calendar.setWorkingDay(day, false);
            }
        }
        Double rowHoursPerDay = this.getHoursPerPeriod(row, "day_hr_cnt");
        Double rowHoursPerWeek = this.getHoursPerPeriod(row, "week_hr_cnt");
        Double rowHoursPerMonth = this.getHoursPerPeriod(row, "month_hr_cnt");
        Double rowHoursPerYear = this.getHoursPerPeriod(row, "year_hr_cnt");
        calendar.setCalendarMinutesPerDay((int)(NumberHelper.getDouble(rowHoursPerDay) * 60.0));
        calendar.setCalendarMinutesPerWeek((int)(NumberHelper.getDouble(rowHoursPerWeek) * 60.0));
        calendar.setCalendarMinutesPerMonth((int)(NumberHelper.getDouble(rowHoursPerMonth) * 60.0));
        calendar.setCalendarMinutesPerYear((int)(NumberHelper.getDouble(rowHoursPerYear) * 60.0));
        if (rowHoursPerDay == null || rowHoursPerWeek == null || rowHoursPerMonth == null || rowHoursPerYear == null) {
            int minutesPerWeek = 0;
            int workingDays = 0;
            for (Day day : Day.values()) {
                ProjectCalendarHours hours = calendar.getCalendarHours(day);
                if (hours == null || hours.size() <= 0) continue;
                ++workingDays;
                for (DateRange range : hours) {
                    long milliseconds = range.getEnd().getTime() - range.getStart().getTime();
                    minutesPerWeek = (int)((long)minutesPerWeek + milliseconds / 60000L);
                }
            }
            int minutesPerDay = minutesPerWeek / workingDays;
            int minutesPerMonth = minutesPerWeek * 4;
            int minutesPerYear = minutesPerMonth * 12;
            if (rowHoursPerDay == null) {
                calendar.setCalendarMinutesPerDay(minutesPerDay);
            }
            if (rowHoursPerWeek == null) {
                calendar.setCalendarMinutesPerWeek(minutesPerWeek);
            }
            if (rowHoursPerMonth == null) {
                calendar.setCalendarMinutesPerMonth(minutesPerMonth);
            }
            if (rowHoursPerYear == null) {
                calendar.setCalendarMinutesPerYear(minutesPerYear);
            }
        }
        this.m_eventManager.fireCalendarReadEvent(calendar);
        return calendar;
    }

    private Double getHoursPerPeriod(Row row, String name) {
        try {
            return row.getDouble(name);
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    private void processCalendarDays(ProjectCalendar calendar, StructuredTextRecord daysOfWeek) {
        Map<Day, StructuredTextRecord> days = daysOfWeek.getChildren().stream().filter(d -> Day.getInstance(Integer.parseInt(d.getRecordName())) != null).collect(Collectors.toMap(d -> Day.getInstance(Integer.parseInt(d.getRecordName())), d -> d));
        Day[] dayArray = Day.values();
        int n = dayArray.length;
        for (int i = 0; i < n; ++i) {
            Day day;
            StructuredTextRecord dayRecord = days.get(day = dayArray[i]);
            this.processCalendarHours(day, calendar, dayRecord == null ? StructuredTextRecord.EMPTY : dayRecord);
        }
    }

    private void processCalendarHours(Day day, ProjectCalendar calendar, StructuredTextRecord dayRecord) {
        ProjectCalendarHours hours = calendar.addCalendarHours(day);
        List<StructuredTextRecord> recHours = dayRecord.getChildren();
        if (recHours.size() == 0) {
            calendar.setWorkingDay(day, false);
        } else {
            calendar.setWorkingDay(day, true);
            for (StructuredTextRecord recWorkingHours : recHours) {
                this.addHours(hours, recWorkingHours);
            }
        }
    }

    private void addHours(ProjectCalendarHours ranges, StructuredTextRecord hoursRecord) {
        String startText = hoursRecord.getAttribute("s");
        String endText = hoursRecord.getAttribute("f");
        if (startText == null || endText == null || startText.isEmpty() || endText.isEmpty()) {
            return;
        }
        if (endText.equals("00:00")) {
            endText = "24:00";
        }
        try {
            Date start = this.m_calendarTimeFormat.parse(startText);
            Date end = this.m_calendarTimeFormat.parse(endText);
            ranges.add(new DateRange(start, end));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void processCalendarExceptions(ProjectCalendar calendar, StructuredTextRecord exceptions) {
        for (StructuredTextRecord exception : exceptions.getChildren()) {
            long daysFromEpoch = Integer.parseInt(exception.getAttribute("d"));
            Date startEx = DateHelper.getDateFromLong(-2209161599935L + daysFromEpoch * 86400000L);
            ProjectCalendarException pce = calendar.addCalendarException(startEx, startEx);
            for (StructuredTextRecord exceptionHours : exception.getChildren()) {
                this.addHours(pce, exceptionHours);
            }
        }
    }

    public void processResources(List<Row> rows) {
        for (Row row : rows) {
            Resource resource = this.m_project.addResource();
            this.processFields(this.m_resourceFields, row, resource);
            resource.setCalendar((ProjectCalendar)this.m_project.getCalendars().getByUniqueID(row.getInteger("clndr_id")));
            this.populateUserDefinedFieldValues("RSRC", FieldTypeClass.RESOURCE, resource, resource.getUniqueID());
            resource.setNotesObject(this.getNotes(resource.getNotes()));
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    public void processRoles(List<Row> rows) {
        for (Row row : rows) {
            Resource resource = this.m_project.addResource();
            this.processFields(this.m_roleFields, row, resource);
            resource.setRole(Boolean.TRUE);
            resource.setUniqueID(this.m_roleClashMap.addID(resource.getUniqueID()));
            resource.setNotesObject(this.getNotes(resource.getNotes()));
        }
    }

    private Notes getNotes(String text) {
        HtmlNotes notes = this.getHtmlNote(text);
        return notes == null || notes.isEmpty() ? null : notes;
    }

    public void processResourceRates(List<Row> rows) {
        rows.sort((r1, r2) -> {
            Integer id2;
            Integer id1 = r1.getInteger("rsrc_id");
            int cmp = NumberHelper.compare(id1, id2 = r2.getInteger("rsrc_id"));
            if (cmp != 0) {
                return cmp;
            }
            Date d1 = r1.getDate("start_date");
            Date d2 = r2.getDate("start_date");
            return DateHelper.compare(d1, d2);
        });
        Resource resource = null;
        for (int i = 0; i < rows.size(); ++i) {
            Row row = rows.get(i);
            Integer resourceID = row.getInteger("rsrc_id");
            if (resource == null || !resource.getUniqueID().equals(resourceID)) {
                resource = this.m_project.getResourceByUniqueID(resourceID);
                if (resource == null) continue;
                resource.getCostRateTable(0).clear();
            }
            Rate[] values = new Rate[]{this.readRate(row.getDouble("cost_per_qty")), this.readRate(row.getDouble("cost_per_qty2")), this.readRate(row.getDouble("cost_per_qty3")), this.readRate(row.getDouble("cost_per_qty4")), this.readRate(row.getDouble("cost_per_qty5"))};
            Double costPerUse = NumberHelper.getDouble(0.0);
            Double maxUnits = NumberHelper.getDouble(NumberHelper.getDouble(row.getDouble("max_qty_per_hr")) * 100.0);
            Date startDate = row.getDate("start_date");
            Date endDate = DateHelper.END_DATE_NA;
            if (i + 1 < rows.size()) {
                Row nextRow = rows.get(i + 1);
                int nextResourceID = nextRow.getInt("rsrc_id");
                if (resourceID == nextResourceID) {
                    Calendar cal = DateHelper.popCalendar(nextRow.getDate("start_date"));
                    cal.add(12, -1);
                    endDate = cal.getTime();
                    DateHelper.pushCalendar(cal);
                }
            }
            if (startDate == null || startDate.getTime() < DateHelper.START_DATE_NA.getTime()) {
                startDate = DateHelper.START_DATE_NA;
            }
            if (endDate == null || endDate.getTime() > DateHelper.END_DATE_NA.getTime()) {
                endDate = DateHelper.END_DATE_NA;
            }
            resource.getCostRateTable(0).add(new CostRateTableEntry(startDate, endDate, costPerUse, values));
            resource.getAvailability().add(new Availability(startDate, endDate, maxUnits));
        }
    }

    private Rate readRate(Double value) {
        if (value == null) {
            return null;
        }
        return new Rate(value, TimeUnit.HOURS);
    }

    public void processRoleRates(List<Row> rows) {
        rows.sort((r1, r2) -> {
            Integer id2;
            Integer id1 = r1.getInteger("role_id");
            int cmp = NumberHelper.compare(id1, id2 = r2.getInteger("role_id"));
            if (cmp != 0) {
                return cmp;
            }
            Date d1 = r1.getDate("start_date");
            Date d2 = r2.getDate("start_date");
            return DateHelper.compare(d1, d2);
        });
        Resource resource = null;
        for (int i = 0; i < rows.size(); ++i) {
            Row row = rows.get(i);
            Integer resourceID = this.m_roleClashMap.getID(row.getInteger("role_id"));
            if (resource == null || !resource.getUniqueID().equals(resourceID)) {
                resource = this.m_project.getResourceByUniqueID(resourceID);
                if (resource == null) continue;
                resource.getCostRateTable(0).clear();
            }
            Rate[] values = new Rate[]{this.readRate(row.getDouble("cost_per_qty")), this.readRate(row.getDouble("cost_per_qty2")), this.readRate(row.getDouble("cost_per_qty3")), this.readRate(row.getDouble("cost_per_qty4")), this.readRate(row.getDouble("cost_per_qty5"))};
            Double costPerUse = NumberHelper.getDouble(0.0);
            Double maxUnits = NumberHelper.getDouble(NumberHelper.getDouble(row.getDouble("max_qty_per_hr")) * 100.0);
            Date startDate = row.getDate("start_date");
            Date endDate = DateHelper.END_DATE_NA;
            if (i + 1 < rows.size()) {
                Row nextRow = rows.get(i + 1);
                if (NumberHelper.equals(row.getInteger("role_id"), nextRow.getInteger("role_id"))) {
                    Calendar cal = DateHelper.popCalendar(nextRow.getDate("start_date"));
                    cal.add(12, -1);
                    endDate = cal.getTime();
                    DateHelper.pushCalendar(cal);
                }
            }
            if (startDate == null || startDate.getTime() < DateHelper.START_DATE_NA.getTime()) {
                startDate = DateHelper.START_DATE_NA;
            }
            if (endDate == null || endDate.getTime() > DateHelper.END_DATE_NA.getTime()) {
                endDate = DateHelper.END_DATE_NA;
            }
            resource.getCostRateTable(0).add(new CostRateTableEntry(startDate, endDate, costPerUse, values));
            resource.getAvailability().add(new Availability(startDate, endDate, maxUnits));
        }
    }

    public void processTasks(List<Row> wbs, List<Row> tasks, Map<Integer, Notes> wbsNotes, Map<Integer, Notes> taskNotes) {
        Task task;
        boolean baselineFromCurrentProject;
        ProjectProperties projectProperties = this.m_project.getProjectProperties();
        String projectName = projectProperties.getName();
        HashSet<Task> wbsTasks = new HashSet<Task>();
        boolean bl = baselineFromCurrentProject = this.m_project.getProjectProperties().getBaselineProjectUniqueID() == null;
        if (!wbs.isEmpty()) {
            projectProperties.setName(wbs.get(0).getString("wbs_name"));
        }
        for (Row row : wbs) {
            task = this.m_project.addTask();
            task.setProject(projectName);
            task.setSummary(true);
            this.processFields(this.m_wbsFields, row, task);
            this.populateUserDefinedFieldValues("PROJWBS", FieldTypeClass.TASK, task, task.getUniqueID());
            task.setNotesObject(wbsNotes.get(task.getUniqueID()));
            this.m_activityClashMap.addID(task.getUniqueID());
            wbsTasks.add(task);
            this.m_eventManager.fireTaskReadEvent(task);
        }
        this.m_project.getChildTasks().clear();
        for (Row row : wbs) {
            task = this.m_project.getTaskByUniqueID(row.getInteger("wbs_id"));
            Task parentTask = this.m_project.getTaskByUniqueID(row.getInteger("parent_wbs_id"));
            if (parentTask == null) {
                this.m_project.getChildTasks().add(task);
            } else {
                this.m_project.getChildTasks().remove(task);
                parentTask.getChildTasks().add(task);
                if (this.m_wbsIsFullPath) {
                    task.setWBS(parentTask.getWBS() + DEFAULT_WBS_SEPARATOR + task.getWBS());
                }
            }
            task.setActivityID(task.getWBS());
        }
        boolean forceCriticalToFalse = projectProperties.getCriticalActivityType() == CriticalActivityType.LONGEST_PATH;
        for (Row row : tasks) {
            Integer parentTaskID = row.getInteger("wbs_id");
            Task parentTask = this.m_project.getTaskByUniqueID(parentTaskID);
            Task task2 = parentTask == null ? this.m_project.addTask() : parentTask.addTask();
            task2.setProject(projectName);
            this.processFields(this.m_taskFields, row, task2);
            task2.setMilestone(BooleanHelper.getBoolean(MILESTONE_MAP.get(row.getString("task_type"))));
            task2.setActivityStatus(STATUS_MAP.get(row.getString("status_code")));
            task2.setActivityType(ACTIVITY_TYPE_MAP.get(row.getString("task_type")));
            task2.setIgnoreResourceCalendar(!"TT_Rsrc".equals(row.getString("task_type")));
            task2.setPercentCompleteType(PERCENT_COMPLETE_TYPE.get(row.getString("complete_pct_type")));
            task2.setPercentageWorkComplete(this.calculateUnitsPercentComplete(row));
            task2.setPercentageComplete(this.calculateDurationPercentComplete(row));
            task2.setPhysicalPercentComplete(this.calculatePhysicalPercentComplete(row));
            if (this.m_matchPrimaveraWBS && parentTask != null) {
                task2.setWBS(parentTask.getWBS());
            }
            Integer uniqueID = task2.getUniqueID();
            this.populateUserDefinedFieldValues("TASK", FieldTypeClass.TASK, task2, uniqueID);
            this.populateActivityCodes(task2);
            task2.setNotesObject(taskNotes.get(uniqueID));
            task2.setUniqueID(this.m_activityClashMap.addID(uniqueID));
            Integer calId = row.getInteger("clndr_id");
            ProjectCalendar cal = this.m_project.getCalendarByUniqueID(calId);
            task2.setCalendar(cal);
            this.populateField(task2, TaskField.START, TaskField.ACTUAL_START, TaskField.REMAINING_EARLY_START, TaskField.PLANNED_START);
            this.populateField(task2, TaskField.FINISH, TaskField.ACTUAL_FINISH, TaskField.REMAINING_EARLY_FINISH, TaskField.PLANNED_FINISH);
            Duration work = Duration.add(task2.getActualWork(), task2.getRemainingWork(), task2.getEffectiveCalendar());
            task2.setWork(work);
            Date actualStart = task2.getActualStart();
            if (actualStart != null) {
                Date finish = task2.getActualFinish();
                if (finish == null && (finish = this.m_project.getProjectProperties().getStatusDate()) != null && finish.getTime() < actualStart.getTime()) {
                    finish = actualStart;
                }
                if (finish != null) {
                    cal = task2.getEffectiveCalendar();
                    task2.setActualDuration(cal.getWork(actualStart, finish, TimeUnit.HOURS));
                }
            }
            Duration durationAtCompletion = Duration.add(task2.getActualDuration(), task2.getRemainingDuration(), task2.getEffectiveCalendar());
            task2.setDuration(durationAtCompletion);
            if (forceCriticalToFalse) {
                task2.setCritical(false);
            } else {
                task2.getCritical();
            }
            if (baselineFromCurrentProject) {
                this.populateBaselineFromCurrentProject(task2);
            }
            SlackHelper.inferSlack(task2);
            this.m_eventManager.fireTaskReadEvent(task2);
        }
        new ActivitySorter(wbsTasks).sort(this.m_project);
        this.updateStructure();
    }

    private void populateBaselineFromCurrentProject(Task task) {
        task.setBaselineCost(task.getPlannedCost());
        task.setBaselineDuration(task.getPlannedDuration());
        task.setBaselineFinish(task.getPlannedFinish());
        task.setBaselineStart(task.getPlannedStart());
        task.setBaselineWork(task.getPlannedWork());
    }

    private void populateActivityCodes(Task task) {
        List<Integer> list = this.m_activityCodeAssignments.get(task.getUniqueID());
        if (list != null) {
            for (Integer id : list) {
                ActivityCodeValue value = this.m_activityCodeMap.get(id);
                if (value == null) continue;
                task.addActivityCode(value);
            }
        }
    }

    private FieldType allocateUserDefinedField(FieldTypeClass fieldTypeClass, UserFieldDataType dataType) {
        FieldType fieldType = null;
        try {
            switch (fieldTypeClass) {
                case TASK: {
                    while (this.m_taskFields.containsKey(fieldType = (FieldType)this.m_taskUdfCounters.nextField(TaskField.class, dataType)) || this.m_wbsFields.containsKey(fieldType)) {
                    }
                    break;
                }
                case RESOURCE: {
                    while (this.m_resourceFields.containsKey(fieldType = (FieldType)this.m_resourceUdfCounters.nextField(ResourceField.class, dataType))) {
                    }
                    break;
                }
                case ASSIGNMENT: {
                    while (this.m_assignmentFields.containsKey(fieldType = (FieldType)this.m_assignmentUdfCounters.nextField(AssignmentField.class, dataType))) {
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fieldType;
    }

    private void addUDFValue(FieldTypeClass fieldType, FieldContainer container, Row row) {
        Integer fieldId = row.getInteger("udf_type_id");
        FieldType field = this.m_udfFields.get(fieldId);
        if (field != null) {
            Object value;
            DataType fieldDataType = field.getDataType();
            switch (fieldDataType) {
                case DATE: {
                    value = row.getDate("udf_date");
                    break;
                }
                case CURRENCY: 
                case NUMERIC: {
                    value = row.getDouble("udf_number");
                    break;
                }
                case GUID: 
                case INTEGER: {
                    value = row.getInteger("udf_code_id");
                    break;
                }
                case BOOLEAN: {
                    String text = row.getString("udf_text");
                    if (text != null) {
                        value = STATICTYPE_UDF_MAP.get(text);
                        if (value != null) break;
                        value = row.getBoolean("udf_text");
                        break;
                    }
                    value = row.getBoolean("udf_number");
                    break;
                }
                default: {
                    value = row.getString("udf_text");
                }
            }
            container.set(field, value);
        }
    }

    private void populateUserDefinedFieldValues(String tableName, FieldTypeClass type, FieldContainer container, Integer uniqueID) {
        List<Row> udf;
        Map<Integer, List<Row>> tableData = this.m_udfValues.get(tableName);
        if (tableData != null && (udf = tableData.get(uniqueID)) != null) {
            for (Row r : udf) {
                this.addUDFValue(type, container, r);
            }
        }
    }

    public Map<Integer, String> getNotebookTopics(List<Row> rows) {
        HashMap<Integer, String> topics = new HashMap<Integer, String>();
        rows.forEach(row -> topics.put(row.getInteger("memo_type_id"), row.getString("memo_type")));
        return topics;
    }

    public Map<Integer, Notes> getNotes(Map<Integer, String> topics, List<Row> rows, String idColumn, String textColumn) {
        Map map = rows.stream().collect(Collectors.groupingBy(r -> r.getInteger(idColumn), Collectors.groupingBy(r -> r.getInteger("memo_type_id"), Collectors.mapping(r -> r.getString(textColumn), Collectors.toList()))));
        HashMap<Integer, Notes> result = new HashMap<Integer, Notes>();
        for (Map.Entry entry : map.entrySet()) {
            ArrayList<Notes> list = new ArrayList<Notes>();
            for (Map.Entry topicEntry : entry.getValue().entrySet()) {
                topicEntry.getValue().stream().map(this::getHtmlNote).filter(n -> n != null && !n.isEmpty()).forEach(n -> list.add(new StructuredNotes((Integer)topicEntry.getKey(), (String)topics.get(topicEntry.getKey()), (Notes)n)));
            }
            result.put(entry.getKey(), new ParentNotes(list));
        }
        return result;
    }

    private HtmlNotes getHtmlNote(String text) {
        if (text == null) {
            return null;
        }
        String html = text.replaceAll("[\\uFEFF\\uFFFE\\x00]", "");
        HtmlNotes result = new HtmlNotes(html = html.replaceAll("\\x7F\\x7F", "\n"));
        return result.isEmpty() ? null : result;
    }

    private void populateField(FieldContainer container, FieldType target, FieldType ... types) {
        for (FieldType type : types) {
            Object value = container.getCachedValue(type);
            if (value == null) continue;
            container.set(target, value);
            break;
        }
    }

    private void updateStructure() {
        int id = 1;
        Integer outlineLevel = 1;
        for (Task task : this.m_project.getChildTasks()) {
            id = this.updateStructure(id, task, outlineLevel);
        }
    }

    private int updateStructure(int id, Task task, Integer outlineLevel) {
        task.setID(id++);
        task.setOutlineLevel(outlineLevel);
        outlineLevel = outlineLevel + 1;
        for (Task childTask : task.getChildTasks()) {
            id = this.updateStructure(id, childTask, outlineLevel);
        }
        return id;
    }

    private ProjectCalendar rollupCalendars(Task task) {
        ProjectCalendar result = null;
        if (task.hasChildTasks()) {
            ProjectCalendar firstCalendar;
            List calendars = task.getChildTasks().stream().map(this::rollupCalendars).distinct().collect(Collectors.toList());
            if (calendars.size() == 1 && (firstCalendar = (ProjectCalendar)calendars.get(0)) != null && firstCalendar != this.m_project.getDefaultCalendar()) {
                result = firstCalendar;
                task.setCalendar(result);
            }
        } else {
            result = task.getCalendar();
        }
        return result;
    }

    private void rollupDates(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            int finished = 0;
            Date startDate = parentTask.getStart();
            Date finishDate = parentTask.getFinish();
            Date plannedStartDate = parentTask.getPlannedStart();
            Date plannedFinishDate = parentTask.getPlannedFinish();
            Date actualStartDate = parentTask.getActualStart();
            Date actualFinishDate = parentTask.getActualFinish();
            Date earlyStartDate = parentTask.getEarlyStart();
            Date earlyFinishDate = parentTask.getEarlyFinish();
            Date lateStartDate = parentTask.getLateStart();
            Date lateFinishDate = parentTask.getLateFinish();
            Date baselineStartDate = parentTask.getBaselineStart();
            Date baselineFinishDate = parentTask.getBaselineFinish();
            Date remainingEarlyStartDate = parentTask.getRemainingEarlyStart();
            Date remainingEarlyFinishDate = parentTask.getRemainingEarlyFinish();
            Date remainingLateStartDate = parentTask.getRemainingLateStart();
            Date remainingLateFinishDate = parentTask.getRemainingLateFinish();
            boolean critical = false;
            for (Task task : parentTask.getChildTasks()) {
                this.rollupDates(task);
                startDate = DateHelper.min(startDate, task.getStart());
                finishDate = DateHelper.max(finishDate, task.getFinish());
                plannedStartDate = DateHelper.min(plannedStartDate, task.getPlannedStart());
                plannedFinishDate = DateHelper.max(plannedFinishDate, task.getPlannedFinish());
                actualStartDate = DateHelper.min(actualStartDate, task.getActualStart());
                actualFinishDate = DateHelper.max(actualFinishDate, task.getActualFinish());
                earlyStartDate = DateHelper.min(earlyStartDate, task.getEarlyStart());
                earlyFinishDate = DateHelper.max(earlyFinishDate, task.getEarlyFinish());
                remainingEarlyStartDate = DateHelper.min(remainingEarlyStartDate, task.getRemainingEarlyStart());
                remainingEarlyFinishDate = DateHelper.max(remainingEarlyFinishDate, task.getRemainingEarlyFinish());
                lateStartDate = DateHelper.min(lateStartDate, task.getLateStart());
                lateFinishDate = DateHelper.max(lateFinishDate, task.getLateFinish());
                remainingLateStartDate = DateHelper.min(remainingLateStartDate, task.getRemainingLateStart());
                remainingLateFinishDate = DateHelper.max(remainingLateFinishDate, task.getRemainingLateFinish());
                baselineStartDate = DateHelper.min(baselineStartDate, task.getBaselineStart());
                baselineFinishDate = DateHelper.max(baselineFinishDate, task.getBaselineFinish());
                if (task.getActualFinish() != null) {
                    ++finished;
                }
                critical = critical || task.getCritical();
            }
            parentTask.setStart(startDate);
            parentTask.setFinish(finishDate);
            parentTask.setPlannedStart(plannedStartDate);
            parentTask.setPlannedFinish(plannedFinishDate);
            parentTask.setActualStart(actualStartDate);
            parentTask.setEarlyStart(earlyStartDate);
            parentTask.setEarlyFinish(earlyFinishDate);
            parentTask.setRemainingEarlyStart(remainingEarlyStartDate);
            parentTask.setRemainingEarlyFinish(remainingEarlyFinishDate);
            parentTask.setLateStart(lateStartDate);
            parentTask.setLateFinish(lateFinishDate);
            parentTask.setRemainingLateStart(remainingLateStartDate);
            parentTask.setRemainingLateFinish(remainingLateFinishDate);
            parentTask.setBaselineStart(baselineStartDate);
            parentTask.setBaselineFinish(baselineFinishDate);
            if (finished == parentTask.getChildTasks().size()) {
                parentTask.setActualFinish(actualFinishDate);
            }
            Duration plannedDuration = null;
            if (plannedStartDate != null && plannedFinishDate != null) {
                plannedDuration = parentTask.getEffectiveCalendar().getWork(plannedStartDate, plannedFinishDate, TimeUnit.HOURS);
                parentTask.setPlannedDuration(plannedDuration);
            }
            Duration actualDuration = null;
            Duration remainingDuration = null;
            if (parentTask.getActualFinish() == null) {
                Date taskFinishDate;
                Date taskStartDate = parentTask.getRemainingEarlyStart();
                if (taskStartDate == null && (taskStartDate = parentTask.getEarlyStart()) == null) {
                    taskStartDate = plannedStartDate;
                }
                if ((taskFinishDate = parentTask.getRemainingEarlyFinish()) == null && (taskFinishDate = parentTask.getEarlyFinish()) == null) {
                    taskFinishDate = plannedFinishDate;
                }
                if (taskStartDate != null) {
                    if (parentTask.getActualStart() != null) {
                        actualDuration = parentTask.getEffectiveCalendar().getWork(parentTask.getActualStart(), taskStartDate, TimeUnit.HOURS);
                    }
                    if (taskFinishDate != null) {
                        remainingDuration = parentTask.getEffectiveCalendar().getWork(taskStartDate, taskFinishDate, TimeUnit.HOURS);
                    }
                }
            } else {
                actualDuration = parentTask.getEffectiveCalendar().getWork(parentTask.getActualStart(), parentTask.getActualFinish(), TimeUnit.HOURS);
                remainingDuration = Duration.getInstance(0, TimeUnit.HOURS);
            }
            if (actualDuration != null && actualDuration.getDuration() < 0.0) {
                actualDuration = null;
            }
            if (remainingDuration != null && remainingDuration.getDuration() < 0.0) {
                remainingDuration = null;
            }
            parentTask.setActualDuration(actualDuration);
            parentTask.setRemainingDuration(remainingDuration);
            parentTask.setDuration(Duration.add(actualDuration, remainingDuration, parentTask.getEffectiveCalendar()));
            if (plannedDuration != null && remainingDuration != null && plannedDuration.getDuration() != 0.0) {
                double durationPercentComplete = (plannedDuration.getDuration() - remainingDuration.getDuration()) / plannedDuration.getDuration() * 100.0;
                if (durationPercentComplete < 0.0) {
                    durationPercentComplete = 0.0;
                } else if (durationPercentComplete > 100.0) {
                    durationPercentComplete = 100.0;
                }
                parentTask.setPercentageComplete(durationPercentComplete);
                parentTask.setPercentCompleteType(PercentCompleteType.DURATION);
            }
            parentTask.getTotalSlack();
            parentTask.setCritical(critical);
        }
    }

    private void rollupWork(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            ProjectCalendar calendar = parentTask.getEffectiveCalendar();
            Duration actualWork = null;
            Duration plannedWork = null;
            Duration remainingWork = null;
            Duration work = null;
            for (Task task : parentTask.getChildTasks()) {
                this.rollupWork(task);
                actualWork = Duration.add(actualWork, task.getActualWork(), calendar);
                plannedWork = Duration.add(plannedWork, task.getPlannedWork(), calendar);
                remainingWork = Duration.add(remainingWork, task.getRemainingWork(), calendar);
                work = Duration.add(work, task.getWork(), calendar);
            }
            parentTask.setActualWork(actualWork);
            parentTask.setPlannedWork(plannedWork);
            parentTask.setRemainingWork(remainingWork);
            parentTask.setWork(work);
        }
    }

    public void processPredecessors(List<Row> rows) {
        for (Row row : rows) {
            Object relation;
            Integer successorID = this.m_activityClashMap.getID(row.getInteger("task_id"));
            Integer predecessorID = this.m_activityClashMap.getID(row.getInteger("pred_task_id"));
            Task successorTask = this.m_project.getTaskByUniqueID(successorID);
            Task predecessorTask = this.m_project.getTaskByUniqueID(predecessorID);
            RelationType type = this.getRelationType(row.getString("pred_type"));
            Duration lag = row.getDuration("lag_hr_cnt");
            if (successorTask != null && predecessorTask != null) {
                relation = successorTask.addPredecessor(predecessorTask, type, lag);
                ((Relation)relation).setUniqueID(row.getInteger("task_pred_id"));
                this.m_eventManager.fireRelationReadEvent((Relation)relation);
                continue;
            }
            if (successorTask != null && predecessorTask == null) {
                relation = new ExternalRelation(predecessorID, successorTask, type, lag, true);
                this.m_externalRelations.add((ExternalRelation)relation);
                ((ExternalRelation)relation).setUniqueID(row.getInteger("task_pred_id"));
                continue;
            }
            if (successorTask != null || predecessorTask == null) continue;
            relation = new ExternalRelation(successorID, predecessorTask, type, lag, false);
            this.m_externalRelations.add((ExternalRelation)relation);
            ((ExternalRelation)relation).setUniqueID(row.getInteger("task_pred_id"));
        }
    }

    private RelationType getRelationType(String value) {
        RelationType result = null;
        if (value != null) {
            if (value.length() > 5) {
                value = value.substring(0, 5);
            }
            result = RELATION_TYPE_MAP.get(value);
        }
        return result == null ? RelationType.FINISH_START : result;
    }

    public void processAssignments(List<Row> rows, Map<Integer, WorkContour> workContours) {
        for (Row row : rows) {
            Task task = this.m_project.getTaskByUniqueID(this.m_activityClashMap.getID(row.getInteger("task_id")));
            Integer roleID = this.m_roleClashMap.getID(row.getInteger("role_id"));
            Integer resourceID = row.getInteger("rsrc_id");
            if (resourceID == null && roleID != null) {
                resourceID = roleID;
                roleID = null;
            }
            Resource resource = this.m_project.getResourceByUniqueID(resourceID);
            if (task == null || resource == null) continue;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            this.processFields(this.m_assignmentFields, row, assignment);
            this.populateField(assignment, AssignmentField.START, AssignmentField.ACTUAL_START, AssignmentField.PLANNED_START);
            this.populateField(assignment, AssignmentField.FINISH, AssignmentField.ACTUAL_FINISH, AssignmentField.PLANNED_FINISH);
            Duration remainingWork = row.getDuration("remain_qty");
            Duration actualOvertimeWork = row.getDuration("act_ot_qty");
            Duration actualRegularWork = row.getDuration("act_reg_qty");
            Duration actualWork = Duration.add(actualOvertimeWork, actualRegularWork, task.getEffectiveCalendar());
            Duration totalWork = Duration.add(actualWork, remainingWork, task.getEffectiveCalendar());
            assignment.setActualWork(actualWork);
            assignment.setWork(totalWork);
            assignment.setWorkContour(workContours.get(row.getInteger("curv_id")));
            assignment.setRateIndex(RATE_TYPE_MAP.getOrDefault(row.getString("rate_type"), 0));
            assignment.setRole(this.m_project.getResourceByUniqueID(roleID));
            assignment.setOverrideRate(this.readRate(row.getDouble("cost_per_qty")));
            assignment.setRateSource(RATE_SOURCE_MAP.getOrDefault(row.getString("cost_per_qty_source_type"), RateSource.RESOURCE));
            assignment.setActualCost(NumberHelper.sumAsDouble(row.getDouble("act_reg_cost"), row.getDouble("act_ot_cost")));
            assignment.setCost(NumberHelper.sumAsDouble(assignment.getActualCost(), assignment.getRemainingCost()));
            task.setPlannedCost(NumberHelper.sumAsDouble(task.getPlannedCost(), assignment.getPlannedCost()));
            task.setActualCost(NumberHelper.sumAsDouble(task.getActualCost(), assignment.getActualCost()));
            task.setRemainingCost(NumberHelper.sumAsDouble(task.getRemainingCost(), assignment.getRemainingCost()));
            task.setCost(NumberHelper.sumAsDouble(task.getCost(), assignment.getCost()));
            double units = resource.getType() == ResourceType.MATERIAL ? (totalWork == null ? 0.0 : totalWork.getDuration() * 100.0) : NumberHelper.getDouble(row.getDouble("target_qty_per_hr")) * 100.0;
            assignment.setUnits(NumberHelper.getDouble(units));
            this.populateUserDefinedFieldValues("TASKRSRC", FieldTypeClass.ASSIGNMENT, assignment, assignment.getUniqueID());
            this.m_eventManager.fireAssignmentReadEvent(assignment);
        }
    }

    public void rollupValues() {
        this.m_project.getChildTasks().forEach(this::rollupCalendars);
        this.m_project.getChildTasks().forEach(this::rollupDates);
        this.m_project.getChildTasks().forEach(this::rollupWork);
        this.m_project.getChildTasks().forEach(this::rollupCosts);
        if (this.m_project.getProjectProperties().getBaselineProjectUniqueID() == null) {
            this.m_project.getTasks().stream().filter(Task::getSummary).forEach(this::populateBaselineFromCurrentProject);
        }
    }

    private void rollupCosts(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            double plannedCost = 0.0;
            double actualCost = 0.0;
            double remainingCost = 0.0;
            double cost = 0.0;
            for (Task child : parentTask.getChildTasks()) {
                this.rollupCosts(child);
                plannedCost += NumberHelper.getDouble(child.getPlannedCost());
                actualCost += NumberHelper.getDouble(child.getActualCost());
                remainingCost += NumberHelper.getDouble(child.getRemainingCost());
                cost += NumberHelper.getDouble(child.getCost());
            }
            parentTask.setPlannedCost(NumberHelper.getDouble(plannedCost));
            parentTask.setActualCost(NumberHelper.getDouble(actualCost));
            parentTask.setRemainingCost(NumberHelper.getDouble(remainingCost));
            parentTask.setCost(NumberHelper.getDouble(cost));
        }
    }

    public void processDefaultCurrency(Row row) {
        ProjectProperties properties = this.m_project.getProjectProperties();
        properties.setCurrencySymbol(row.getString("curr_symbol"));
        properties.setSymbolPosition(CURRENCY_SYMBOL_POSITION_MAP.get(row.getString("pos_curr_fmt_type")));
        properties.setCurrencyDigits(row.getInteger("decimal_digit_cnt"));
        properties.setThousandsSeparator(row.getString("digit_group_symbol").charAt(0));
        properties.setDecimalSeparator(row.getString("decimal_symbol").charAt(0));
    }

    public void processExpenseItems(List<Row> rows) {
        for (Row row : rows) {
            Task task = this.m_project.getTaskByUniqueID(row.getInteger("task_id"));
            if (task == null) continue;
            List<ExpenseItem> items = task.getExpenseItems();
            if (items == null) {
                items = new ArrayList<ExpenseItem>();
                task.setExpenseItems(items);
            }
            ExpenseItem ei = new ExpenseItem(task);
            items.add(ei);
            ei.setAccount((CostAccount)this.m_project.getCostAccounts().getByUniqueID(row.getInteger("acct_id")));
            ei.setAccrueType(ACCRUE_TYPE_MAP.get(row.getString("cost_load_type")));
            ei.setActualCost(row.getDouble("act_cost"));
            ei.setAutoComputeActuals(row.getBoolean("auto_compute_act_flag"));
            ei.setCategory((ExpenseCategory)this.m_project.getExpenseCategories().getByUniqueID(row.getInteger("cost_type_id")));
            ei.setDescription(row.getString("cost_descr"));
            ei.setDocumentNumber(row.getString("po_number"));
            ei.setName(row.getString("cost_name"));
            ei.setPlannedCost(row.getDouble("target_cost"));
            ei.setPlannedUnits(row.getDouble("target_qty"));
            ei.setPricePerUnit(row.getDouble("cost_per_qty"));
            ei.setRemainingCost(row.getDouble("remain_cost"));
            ei.setUniqueID(row.getInteger("cost_item_id"));
            ei.setUnitOfMeasure(row.getString("qty_name"));
            ei.setVendor(row.getString("vendor_name"));
            ei.setAtCompletionCost(NumberHelper.sumAsDouble(ei.getActualCost(), ei.getRemainingCost()));
            double pricePerUnit = NumberHelper.getDouble(ei.getPricePerUnit());
            if (pricePerUnit != 0.0) {
                ei.setActualUnits(NumberHelper.getDouble(ei.getActualCost()) / pricePerUnit);
                ei.setRemainingUnits(NumberHelper.getDouble(ei.getRemainingCost()) / pricePerUnit);
                ei.setAtCompletionUnits(NumberHelper.sumAsDouble(ei.getActualUnits(), ei.getRemainingUnits()));
            }
            task.setPlannedCost(NumberHelper.sumAsDouble(task.getPlannedCost(), ei.getPlannedCost()));
            task.setActualCost(NumberHelper.sumAsDouble(task.getActualCost(), ei.getActualCost()));
            task.setRemainingCost(NumberHelper.sumAsDouble(task.getRemainingCost(), ei.getRemainingCost()));
            task.setCost(NumberHelper.sumAsDouble(task.getCost(), ei.getAtCompletionCost()));
        }
    }

    public void processScheduleOptions(Row row) {
        TreeMap<String, Object> customProperties = new TreeMap<String, Object>();
        customProperties.put("ConsiderAssignmentsInOtherProjects", row.getBoolean("level_outer_assign_flag"));
        customProperties.put("ConsiderAssignmentsInOtherProjectsWithPriorityEqualHigherThan", row.getString("level_outer_assign_priority"));
        customProperties.put("PreserveScheduledEarlyAndLateDates", row.getBoolean("level_keep_sched_date_flag"));
        customProperties.put("LevelAllResources", row.getBoolean("level_all_rsrc_flag"));
        customProperties.put("LevelResourcesOnlyWithinActivityTotalFloat", row.getBoolean("level_within_float_flag"));
        customProperties.put("PreserveMinimumFloatWhenLeveling", row.getString("level_float_thrs_cnt"));
        customProperties.put("MaxPercentToOverallocateResources", row.getString("level_over_alloc_pct"));
        customProperties.put("LevelingPriorities", row.getString("levelprioritylist"));
        customProperties.put("SetDataDateAndPlannedStartToProjectForecastStart", row.getBoolean("sched_setplantoforecast"));
        customProperties.put("IgnoreRelationshipsToAndFromOtherProjects", row.getString("sched_outer_depend_type"));
        customProperties.put("MakeOpenEndedActivitiesCritical", row.getBoolean("sched_open_critical_flag"));
        customProperties.put("UseExpectedFinishDates", row.getBoolean("sched_use_expect_end_flag"));
        customProperties.put("WhenSchedulingProgressedActivitiesUseRetainedLogic", row.getBoolean("sched_retained_logic"));
        customProperties.put("WhenSchedulingProgressedActivitiesUseProgressOverride", row.getBoolean("sched_progress_override"));
        customProperties.put("ComputeStartToStartLagFromEarlyStart", row.getBoolean("sched_lag_early_start_flag"));
        customProperties.put("CalculateFloatBasedOnFishDateOfEachProject", row.getBoolean("sched_use_project_end_date_for_float"));
        customProperties.put("ComputeTotalFloatAs", row.getString("sched_float_type"));
        customProperties.put("CalendarForSchedulingRelationshipLag", row.getString("sched_calendar_on_relationship_lag"));
        customProperties.put("CalculateMultipleFloatPaths", row.getBoolean("enable_multiple_longest_path_calc"));
        customProperties.put("CalculateMultiplePathsUsingTotalFloat", row.getBoolean("use_total_float_multiple_longest_paths"));
        customProperties.put("DisplayMultipleFloatPathsEndingWithActivity", row.getString("key_activity_for_multiple_longest_paths"));
        customProperties.put("LimitNumberOfPathsToCalculate", row.getBoolean("limit_multiple_longest_path_calc"));
        customProperties.put("NumberofPathsToCalculate", row.getString("max_multiple_longest_path"));
        this.m_project.getProjectProperties().setCustomProperties(customProperties);
    }

    private void processFields(Map<FieldType, String> map, Row row, FieldContainer container) {
        for (Map.Entry<FieldType, String> entry : map.entrySet()) {
            Object value;
            FieldType field = entry.getKey();
            String name = entry.getValue();
            switch (field.getDataType()) {
                case INTEGER: {
                    value = row.getInteger(name);
                    break;
                }
                case BOOLEAN: {
                    value = row.getBoolean(name);
                    break;
                }
                case DATE: {
                    value = row.getDate(name);
                    break;
                }
                case CURRENCY: 
                case NUMERIC: 
                case PERCENTAGE: {
                    value = row.getDouble(name);
                    break;
                }
                case DELAY: 
                case WORK: 
                case DURATION: {
                    value = row.getDuration(name);
                    break;
                }
                case RESOURCE_TYPE: {
                    value = RESOURCE_TYPE_MAP.get(row.getString(name));
                    break;
                }
                case TASK_TYPE: {
                    value = TASK_TYPE_MAP.get(row.getString(name));
                    break;
                }
                case CONSTRAINT: {
                    value = CONSTRAINT_TYPE_MAP.get(row.getString(name));
                    break;
                }
                case PRIORITY: {
                    value = PRIORITY_MAP.get(row.getString(name));
                    break;
                }
                case GUID: {
                    value = row.getUUID(name);
                    break;
                }
                default: {
                    value = row.getString(name);
                }
            }
            container.set(field, value);
        }
    }

    private Number calculatePhysicalPercentComplete(Row row) {
        return row.getDouble("phys_complete_pct");
    }

    private Number calculateUnitsPercentComplete(Row row) {
        double actualEquipmentQuantity;
        double result = 0.0;
        double actualWorkQuantity = NumberHelper.getDouble(row.getDouble("act_work_qty"));
        double numerator = actualWorkQuantity + (actualEquipmentQuantity = NumberHelper.getDouble(row.getDouble("act_equip_qty")));
        if (numerator != 0.0) {
            double remainingEquipmentQuantity;
            double remainingWorkQuantity = NumberHelper.getDouble(row.getDouble("remain_work_qty"));
            double denominator = remainingWorkQuantity + actualWorkQuantity + (remainingEquipmentQuantity = NumberHelper.getDouble(row.getDouble("remain_equip_qty"))) + actualEquipmentQuantity;
            result = denominator == 0.0 ? 0.0 : numerator * 100.0 / denominator;
        }
        return NumberHelper.getDouble(result);
    }

    private Number calculateDurationPercentComplete(Row row) {
        double result = 0.0;
        double targetDuration = row.getDuration("target_drtn_hr_cnt").getDuration();
        double remainingDuration = row.getDuration("remain_drtn_hr_cnt").getDuration();
        if (targetDuration == 0.0) {
            if (remainingDuration == 0.0 && "TK_Complete".equals(row.getString("status_code"))) {
                result = 100.0;
            }
        } else if (remainingDuration < targetDuration) {
            result = (targetDuration - remainingDuration) * 100.0 / targetDuration;
        }
        return NumberHelper.getDouble(result);
    }

    public static Map<FieldType, String> getDefaultResourceFieldMap() {
        LinkedHashMap<FieldType, String> map = new LinkedHashMap<FieldType, String>();
        map.put(ResourceField.UNIQUE_ID, "rsrc_id");
        map.put(ResourceField.GUID, "guid");
        map.put(ResourceField.NAME, "rsrc_name");
        map.put(ResourceField.CODE, "employee_code");
        map.put(ResourceField.EMAIL_ADDRESS, "email_addr");
        map.put(ResourceField.NOTES, "rsrc_notes");
        map.put(ResourceField.CREATED, "create_date");
        map.put(ResourceField.TYPE, "rsrc_type");
        map.put(ResourceField.PARENT_ID, "parent_rsrc_id");
        map.put(ResourceField.RESOURCE_ID, "rsrc_short_name");
        map.put(ResourceField.CALCULATE_COSTS_FROM_UNITS, "def_cost_qty_link_flag");
        map.put(ResourceField.SEQUENCE_NUMBER, "rsrc_seq_num");
        return map;
    }

    public static Map<FieldType, String> getDefaultRoleFieldMap() {
        LinkedHashMap<FieldType, String> map = new LinkedHashMap<FieldType, String>();
        map.put(ResourceField.UNIQUE_ID, "role_id");
        map.put(ResourceField.NAME, "role_name");
        map.put(ResourceField.RESOURCE_ID, "role_short_name");
        map.put(ResourceField.NOTES, "role_descr");
        map.put(ResourceField.PARENT_ID, "parent_role_id");
        map.put(ResourceField.CALCULATE_COSTS_FROM_UNITS, "def_cost_qty_link_flag");
        map.put(ResourceField.SEQUENCE_NUMBER, "seq_num");
        return map;
    }

    public static Map<FieldType, String> getDefaultWbsFieldMap() {
        LinkedHashMap<FieldType, String> map = new LinkedHashMap<FieldType, String>();
        map.put(TaskField.UNIQUE_ID, "wbs_id");
        map.put(TaskField.GUID, "guid");
        map.put(TaskField.NAME, "wbs_name");
        map.put(TaskField.REMAINING_COST, "indep_remain_total_cost");
        map.put(TaskField.REMAINING_WORK, "indep_remain_work_qty");
        map.put(TaskField.DEADLINE, "anticip_end_date");
        map.put(TaskField.WBS, "wbs_short_name");
        map.put(TaskField.SEQUENCE_NUMBER, "seq_num");
        return map;
    }

    public static Map<FieldType, String> getDefaultTaskFieldMap() {
        LinkedHashMap<FieldType, String> map = new LinkedHashMap<FieldType, String>();
        map.put(TaskField.UNIQUE_ID, "task_id");
        map.put(TaskField.GUID, "guid");
        map.put(TaskField.NAME, "task_name");
        map.put(TaskField.REMAINING_DURATION, "remain_drtn_hr_cnt");
        map.put(TaskField.ACTUAL_WORK, "act_work_qty");
        map.put(TaskField.REMAINING_WORK, "remain_work_qty");
        map.put(TaskField.PLANNED_WORK, "target_work_qty");
        map.put(TaskField.PLANNED_DURATION, "target_drtn_hr_cnt");
        map.put(TaskField.CONSTRAINT_DATE, "cstr_date");
        map.put(TaskField.ACTUAL_START, "act_start_date");
        map.put(TaskField.ACTUAL_FINISH, "act_end_date");
        map.put(TaskField.LATE_START, "late_start_date");
        map.put(TaskField.LATE_FINISH, "late_end_date");
        map.put(TaskField.EARLY_START, "early_start_date");
        map.put(TaskField.EARLY_FINISH, "early_end_date");
        map.put(TaskField.REMAINING_EARLY_START, "restart_date");
        map.put(TaskField.REMAINING_EARLY_FINISH, "reend_date");
        map.put(TaskField.REMAINING_LATE_START, "rem_late_start_date");
        map.put(TaskField.REMAINING_LATE_FINISH, "rem_late_end_date");
        map.put(TaskField.PLANNED_START, "target_start_date");
        map.put(TaskField.PLANNED_FINISH, "target_end_date");
        map.put(TaskField.CONSTRAINT_TYPE, "cstr_type");
        map.put(TaskField.SECONDARY_CONSTRAINT_DATE, "cstr_date2");
        map.put(TaskField.SECONDARY_CONSTRAINT_TYPE, "cstr_type2");
        map.put(TaskField.PRIORITY, "priority_type");
        map.put(TaskField.CREATED, "create_date");
        map.put(TaskField.TYPE, "duration_type");
        map.put(TaskField.FREE_SLACK, "free_float_hr_cnt");
        map.put(TaskField.TOTAL_SLACK, "total_float_hr_cnt");
        map.put(TaskField.ACTIVITY_ID, "task_code");
        map.put(TaskField.PRIMARY_RESOURCE_ID, "rsrc_id");
        map.put(TaskField.SUSPEND_DATE, "suspend_date");
        map.put(TaskField.RESUME, "resume_date");
        map.put(TaskField.EXTERNAL_EARLY_START, "external_early_start_date");
        map.put(TaskField.EXTERNAL_LATE_FINISH, "external_late_end_date");
        map.put(TaskField.LONGEST_PATH, "driving_path_flag");
        return map;
    }

    public static Map<FieldType, String> getDefaultAssignmentFieldMap() {
        LinkedHashMap<FieldType, String> map = new LinkedHashMap<FieldType, String>();
        map.put(AssignmentField.UNIQUE_ID, "taskrsrc_id");
        map.put(AssignmentField.GUID, "guid");
        map.put(AssignmentField.REMAINING_WORK, "remain_qty");
        map.put(AssignmentField.PLANNED_WORK, "target_qty");
        map.put(AssignmentField.ACTUAL_OVERTIME_WORK, "act_ot_qty");
        map.put(AssignmentField.PLANNED_COST, "target_cost");
        map.put(AssignmentField.ACTUAL_OVERTIME_COST, "act_ot_cost");
        map.put(AssignmentField.REMAINING_COST, "remain_cost");
        map.put(AssignmentField.ACTUAL_START, "act_start_date");
        map.put(AssignmentField.ACTUAL_FINISH, "act_end_date");
        map.put(AssignmentField.PLANNED_START, "target_start_date");
        map.put(AssignmentField.PLANNED_FINISH, "target_end_date");
        map.put(AssignmentField.ASSIGNMENT_DELAY, "target_lag_drtn_hr_cnt");
        map.put(AssignmentField.CALCULATE_COSTS_FROM_UNITS, "cost_qty_link_flag");
        map.put(AssignmentField.COST_ACCOUNT_UNIQUE_ID, "acct_id");
        return map;
    }

    static {
        RESOURCE_TYPE_MAP.put(null, ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("RT_Labor", ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("RT_Mat", ResourceType.MATERIAL);
        RESOURCE_TYPE_MAP.put("RT_Equip", ResourceType.COST);
        CONSTRAINT_TYPE_MAP = new HashMap<String, ConstraintType>();
        CONSTRAINT_TYPE_MAP.put("CS_MSO", ConstraintType.START_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MSOB", ConstraintType.START_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MSOA", ConstraintType.START_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MEO", ConstraintType.FINISH_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MEOB", ConstraintType.FINISH_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MEOA", ConstraintType.FINISH_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_ALAP", ConstraintType.AS_LATE_AS_POSSIBLE);
        CONSTRAINT_TYPE_MAP.put("CS_MANDSTART", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MANDFIN", ConstraintType.MUST_FINISH_ON);
        PRIORITY_MAP = new HashMap<String, Priority>();
        PRIORITY_MAP.put("PT_Top", Priority.getInstance(900));
        PRIORITY_MAP.put("PT_High", Priority.getInstance(600));
        PRIORITY_MAP.put("PT_Normal", Priority.getInstance(500));
        PRIORITY_MAP.put("PT_Low", Priority.getInstance(400));
        PRIORITY_MAP.put("PT_Lowest", Priority.getInstance(100));
        RELATION_TYPE_MAP = new HashMap<String, RelationType>();
        RELATION_TYPE_MAP.put("PR_FS", RelationType.FINISH_START);
        RELATION_TYPE_MAP.put("PR_FF", RelationType.FINISH_FINISH);
        RELATION_TYPE_MAP.put("PR_SS", RelationType.START_START);
        RELATION_TYPE_MAP.put("PR_SF", RelationType.START_FINISH);
        TASK_TYPE_MAP = new HashMap<String, TaskType>();
        TASK_TYPE_MAP.put("DT_FixedDrtn", TaskType.FIXED_DURATION);
        TASK_TYPE_MAP.put("DT_FixedQty", TaskType.FIXED_UNITS);
        TASK_TYPE_MAP.put("DT_FixedDUR2", TaskType.FIXED_WORK);
        TASK_TYPE_MAP.put("DT_FixedRate", TaskType.FIXED_WORK);
        MILESTONE_MAP = new HashMap<String, Boolean>();
        MILESTONE_MAP.put("TT_Task", Boolean.FALSE);
        MILESTONE_MAP.put("TT_Rsrc", Boolean.FALSE);
        MILESTONE_MAP.put("TT_LOE", Boolean.FALSE);
        MILESTONE_MAP.put("TT_Mile", Boolean.TRUE);
        MILESTONE_MAP.put("TT_FinMile", Boolean.TRUE);
        MILESTONE_MAP.put("TT_WBS", Boolean.FALSE);
        ACTIVITY_TYPE_MAP = new HashMap<String, ActivityType>();
        ACTIVITY_TYPE_MAP.put("TT_Task", ActivityType.TASK_DEPENDENT);
        ACTIVITY_TYPE_MAP.put("TT_Rsrc", ActivityType.RESOURCE_DEPENDENT);
        ACTIVITY_TYPE_MAP.put("TT_LOE", ActivityType.LEVEL_OF_EFFORT);
        ACTIVITY_TYPE_MAP.put("TT_Mile", ActivityType.START_MILESTONE);
        ACTIVITY_TYPE_MAP.put("TT_FinMile", ActivityType.FINISH_MILESTONE);
        ACTIVITY_TYPE_MAP.put("TT_WBS", ActivityType.WBS_SUMMARY);
        CURRENCY_SYMBOL_POSITION_MAP = new HashMap<String, CurrencySymbolPosition>();
        CURRENCY_SYMBOL_POSITION_MAP.put("#1.1", CurrencySymbolPosition.BEFORE);
        CURRENCY_SYMBOL_POSITION_MAP.put("1.1#", CurrencySymbolPosition.AFTER);
        CURRENCY_SYMBOL_POSITION_MAP.put("# 1.1", CurrencySymbolPosition.BEFORE_WITH_SPACE);
        CURRENCY_SYMBOL_POSITION_MAP.put("1.1 #", CurrencySymbolPosition.AFTER_WITH_SPACE);
        STATICTYPE_UDF_MAP = new HashMap<String, Boolean>();
        STATICTYPE_UDF_MAP.put("UDF_G0", Boolean.FALSE);
        STATICTYPE_UDF_MAP.put("UDF_G1", Boolean.FALSE);
        STATICTYPE_UDF_MAP.put("UDF_G2", Boolean.FALSE);
        STATICTYPE_UDF_MAP.put("UDF_G3", Boolean.TRUE);
        STATICTYPE_UDF_MAP.put("UDF_G4", Boolean.TRUE);
        FIELD_TYPE_MAP = new HashMap<String, FieldTypeClass>();
        FIELD_TYPE_MAP.put("PROJWBS", FieldTypeClass.TASK);
        FIELD_TYPE_MAP.put("TASK", FieldTypeClass.TASK);
        FIELD_TYPE_MAP.put("RSRC", FieldTypeClass.RESOURCE);
        FIELD_TYPE_MAP.put("TASKRSRC", FieldTypeClass.ASSIGNMENT);
        ACCRUE_TYPE_MAP = new HashMap<String, AccrueType>();
        ACCRUE_TYPE_MAP.put("CL_Uniform", AccrueType.PRORATED);
        ACCRUE_TYPE_MAP.put("CL_End", AccrueType.END);
        ACCRUE_TYPE_MAP.put("CL_Start", AccrueType.START);
        PERCENT_COMPLETE_TYPE = new HashMap<String, PercentCompleteType>();
        PERCENT_COMPLETE_TYPE.put("CP_Phys", PercentCompleteType.PHYSICAL);
        PERCENT_COMPLETE_TYPE.put("CP_Drtn", PercentCompleteType.DURATION);
        PERCENT_COMPLETE_TYPE.put("CP_Units", PercentCompleteType.UNITS);
        STATUS_MAP = new HashMap<String, ActivityStatus>();
        STATUS_MAP.put("TK_NotStart", ActivityStatus.NOT_STARTED);
        STATUS_MAP.put("TK_Active", ActivityStatus.IN_PROGRESS);
        STATUS_MAP.put("TK_Complete", ActivityStatus.COMPLETED);
        CRITICAL_ACTIVITY_MAP = new HashMap<String, CriticalActivityType>();
        CRITICAL_ACTIVITY_MAP.put("CT_TotFloat", CriticalActivityType.TOTAL_FLOAT);
        CRITICAL_ACTIVITY_MAP.put("CT_DrivPath", CriticalActivityType.LONGEST_PATH);
        CALENDAR_TYPE_MAP = new HashMap<String, CalendarType>();
        CALENDAR_TYPE_MAP.put("CA_Base", CalendarType.GLOBAL);
        CALENDAR_TYPE_MAP.put("CA_Project", CalendarType.PROJECT);
        CALENDAR_TYPE_MAP.put("CA_Rsrc", CalendarType.RESOURCE);
        ACTIVITY_CODE_SCOPE_MAP = new HashMap<String, ActivityCodeScope>();
        ACTIVITY_CODE_SCOPE_MAP.put("AS_Global", ActivityCodeScope.GLOBAL);
        ACTIVITY_CODE_SCOPE_MAP.put("AS_EPS", ActivityCodeScope.EPS);
        ACTIVITY_CODE_SCOPE_MAP.put("AS_Project", ActivityCodeScope.PROJECT);
        RATE_TYPE_MAP = new HashMap<String, Integer>();
        RATE_TYPE_MAP.put("COST_PER_QTY", 0);
        RATE_TYPE_MAP.put("COST_PER_QTY2", 1);
        RATE_TYPE_MAP.put("COST_PER_QTY3", 2);
        RATE_TYPE_MAP.put("COST_PER_QTY4", 3);
        RATE_TYPE_MAP.put("COST_PER_QTY5", 4);
        RATE_SOURCE_MAP = new HashMap<String, RateSource>();
        RATE_SOURCE_MAP.put("ST_Rsrc", RateSource.RESOURCE);
        RATE_SOURCE_MAP.put("ST_Role", RateSource.ROLE);
        RATE_SOURCE_MAP.put("ST_Custom", RateSource.OVERRIDE);
    }
}

