/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Notes;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Relation;
import net.sf.mpxj.Task;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.common.MultiDateFormat;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.ReaderTokenizer;
import net.sf.mpxj.common.Tokenizer;
import net.sf.mpxj.primavera.ExternalRelation;
import net.sf.mpxj.primavera.MapRow;
import net.sf.mpxj.primavera.PrimaveraReader;
import net.sf.mpxj.primavera.Row;
import net.sf.mpxj.primavera.UserFieldCounters;
import net.sf.mpxj.primavera.UserFieldDataType;
import net.sf.mpxj.primavera.WbsRowComparatorXER;
import net.sf.mpxj.primavera.XerFieldType;
import net.sf.mpxj.reader.AbstractProjectStreamReader;

public final class PrimaveraXERFileReader
extends AbstractProjectStreamReader {
    private String m_encoding;
    private Charset m_charset;
    private PrimaveraReader m_reader;
    private Integer m_projectID;
    boolean m_skipTable;
    private Map<String, List<Row>> m_tables;
    private String m_currentTableName;
    private List<Row> m_currentTable;
    private String[] m_currentFieldNames;
    private String m_defaultCurrencyName;
    private DecimalFormat m_numberFormat;
    private Row m_defaultCurrencyData;
    private final DateFormat m_df = new MultiDateFormat("yyyy-MM-dd HH:mm", "yyyy-MM-dd");
    private final UserFieldCounters m_taskUdfCounters = new UserFieldCounters();
    private final UserFieldCounters m_resourceUdfCounters = new UserFieldCounters();
    private final UserFieldCounters m_assignmentUdfCounters = new UserFieldCounters();
    private final Map<FieldType, String> m_resourceFields = PrimaveraReader.getDefaultResourceFieldMap();
    private final Map<FieldType, String> m_roleFields = PrimaveraReader.getDefaultRoleFieldMap();
    private final Map<FieldType, String> m_wbsFields = PrimaveraReader.getDefaultWbsFieldMap();
    private final Map<FieldType, String> m_taskFields = PrimaveraReader.getDefaultTaskFieldMap();
    private final Map<FieldType, String> m_assignmentFields = PrimaveraReader.getDefaultAssignmentFieldMap();
    private final Map<String, XerFieldType> m_fieldTypes = this.getDefaultFieldTypes();
    private boolean m_matchPrimaveraWBS = true;
    private boolean m_wbsIsFullPath = true;
    private boolean m_linkCrossProjectRelations;
    private static final Map<String, XerRecordType> RECORD_TYPE_MAP = new HashMap<String, XerRecordType>();
    private static final Map<String, XerFieldType> FIELD_TYPE_MAP;
    private static final Set<String> REQUIRED_TABLES;
    private static final WbsRowComparatorXER WBS_ROW_COMPARATOR;

    public void setProjectID(int projectID) {
        this.m_projectID = projectID;
    }

    public void setEncoding(String encoding) {
        this.m_encoding = encoding;
    }

    @Override
    public void setCharset(Charset charset) {
        this.m_charset = charset;
    }

    public boolean getLinkCrossProjectRelations() {
        return this.m_linkCrossProjectRelations;
    }

    public void setLinkCrossProjectRelations(boolean linkCrossProjectRelations) {
        this.m_linkCrossProjectRelations = linkCrossProjectRelations;
    }

    @Override
    public ProjectFile read(InputStream is) throws MPXJException {
        ProjectFile project = null;
        Integer targetProjectID = this.m_projectID;
        List<ProjectFile> projects = this.readAll(is);
        if (!projects.isEmpty()) {
            project = targetProjectID == null ? projects.get(0) : (ProjectFile)projects.stream().filter(p -> targetProjectID.equals(p.getProjectProperties().getUniqueID())).findFirst().orElse(null);
        }
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProjectFile> readAll(InputStream is) throws MPXJException {
        try {
            this.m_tables = new HashMap<String, List<Row>>();
            this.m_numberFormat = new DecimalFormat();
            this.processFile(is);
            List<Row> rows = this.getRows("project", null, null);
            ArrayList<ProjectFile> result = new ArrayList<ProjectFile>(rows.size());
            ArrayList<ExternalRelation> externalRelations = new ArrayList<ExternalRelation>();
            for (Row row : rows) {
                this.setProjectID(row.getInt("proj_id"));
                this.m_reader = new PrimaveraReader(this.m_taskUdfCounters, this.m_resourceUdfCounters, this.m_assignmentUdfCounters, this.m_resourceFields, this.m_roleFields, this.m_wbsFields, this.m_taskFields, this.m_assignmentFields, this.m_matchPrimaveraWBS, this.m_wbsIsFullPath);
                ProjectFile project = this.readProject();
                externalRelations.addAll(this.m_reader.getExternalRelations());
                result.add(project);
            }
            result.sort((o1, o2) -> Boolean.compare(o2.getProjectProperties().getExportFlag(), o1.getProjectProperties().getExportFlag()));
            if (this.m_linkCrossProjectRelations) {
                block4: for (ExternalRelation externalRelation : externalRelations) {
                    for (ProjectFile proj : result) {
                        Task predecessorTask = proj.getTaskByUniqueID(externalRelation.externalTaskUniqueID());
                        if (predecessorTask == null) continue;
                        Relation relation = externalRelation.getTargetTask().addPredecessor(predecessorTask, externalRelation.getType(), externalRelation.getLag());
                        relation.setUniqueID(externalRelation.getUniqueID());
                        continue block4;
                    }
                }
            }
            Iterator iterator = result;
            return iterator;
        }
        finally {
            this.m_tables = null;
            this.m_numberFormat = null;
            this.m_reader = null;
        }
    }

    private ProjectFile readProject() {
        try {
            ProjectFile project = this.m_reader.getProject();
            project.getProjectProperties().setFileApplication("Primavera");
            project.getProjectProperties().setFileType("XER");
            this.addListenersToProject(project);
            this.processProjectID();
            this.processProjectProperties();
            this.processActivityCodes();
            this.processUserDefinedFields();
            this.processExpenseCategories();
            this.processCostAccounts();
            this.processCalendars();
            this.processResources();
            this.processRoles();
            this.processResourceRates();
            this.processRoleRates();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            this.processExpenseItems();
            this.m_reader.rollupValues();
            project.updateStructure();
            ProjectFile projectFile = project;
            return projectFile;
        }
        finally {
            this.m_currentTableName = null;
            this.m_currentTable = null;
            this.m_currentFieldNames = null;
            this.m_defaultCurrencyName = null;
            this.m_numberFormat = null;
            this.m_defaultCurrencyData = null;
        }
    }

    private void processFile(InputStream is) throws MPXJException {
        int line = 1;
        try {
            InputStreamReader reader = new InputStreamReader(is, this.getCharset());
            ReaderTokenizer tk = new ReaderTokenizer(reader);
            tk.setDelimiter('\t');
            ArrayList<String> record = new ArrayList<String>();
            if (tk.getType() == -1) {
                throw new MPXJException("Invalid file format");
            }
            this.readRecord(tk, record);
            if (record.isEmpty() || !"ERMHDR".equals(record.get(0))) {
                throw new MPXJException("Invalid file format");
            }
            this.processRecord(record);
            while (tk.getType() != -1) {
                this.readRecord(tk, record);
                if (record.isEmpty() || !this.processRecord(record)) {
                    ++line;
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            throw new MPXJException("Error reading file (failed at line " + line + ")", ex);
        }
    }

    private Charset getCharset() {
        Charset result = this.m_charset;
        if (result == null) {
            result = this.m_encoding == null ? CharsetHelper.CP1252 : Charset.forName(this.m_encoding);
        }
        return result;
    }

    private void processProjectID() {
        List<Row> rows;
        if (this.m_projectID == null && !(rows = this.getRows("project", null, null)).isEmpty()) {
            Row row = rows.get(0);
            this.m_projectID = row.getInteger("proj_id");
        }
    }

    private void processCurrency(Row row) {
        String currencyName = row.getString("curr_short_name");
        if (currencyName.equalsIgnoreCase(this.m_defaultCurrencyName)) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator(row.getString("decimal_symbol").charAt(0));
            symbols.setGroupingSeparator(row.getString("digit_group_symbol").charAt(0));
            DecimalFormat nf = new DecimalFormat();
            nf.setDecimalFormatSymbols(symbols);
            nf.applyPattern("#.#");
            this.m_numberFormat = nf;
            this.m_defaultCurrencyData = row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, String> listProjects(InputStream is) throws MPXJException {
        try {
            this.m_tables = new HashMap<String, List<Row>>();
            this.processFile(is);
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            List<Row> rows = this.getRows("project", null, null);
            for (Row row : rows) {
                Integer id = row.getInteger("proj_id");
                String name = row.getString("proj_short_name");
                result.put(id, name);
            }
            HashMap<Integer, String> hashMap = result;
            return hashMap;
        }
        finally {
            this.m_tables = null;
            this.m_currentTable = null;
            this.m_currentFieldNames = null;
        }
    }

    private void processProjectProperties() {
        List<Row> rows = this.getRows("project", "proj_id", this.m_projectID);
        this.m_reader.processProjectProperties(rows);
        if (this.m_defaultCurrencyData != null) {
            this.m_reader.processDefaultCurrency(this.m_defaultCurrencyData);
        }
        this.processScheduleOptions();
    }

    private void processExpenseCategories() {
        this.m_reader.processExpenseCategories(this.getRows("costtype", null, null));
    }

    private void processExpenseItems() {
        this.m_reader.processExpenseItems(this.getRows("projcost", "proj_id", this.m_projectID));
    }

    private void processCostAccounts() {
        this.m_reader.processCostAccounts(this.getRows("account", null, null));
    }

    private void processActivityCodes() {
        List<Row> types = this.getRows("actvtype", null, null);
        List<Row> typeValues = this.getRows("actvcode", null, null);
        List<Row> assignments = this.getRows("taskactv", null, null);
        this.m_reader.processActivityCodes(types, typeValues, assignments);
    }

    private void processScheduleOptions() {
        List<Row> rows = this.getRows("schedoptions", "proj_id", this.m_projectID);
        if (!rows.isEmpty()) {
            this.m_reader.processScheduleOptions(rows.get(0));
        }
    }

    private void processUserDefinedFields() {
        List<Row> fields = this.getRows("udftype", null, null);
        List<Row> values = this.getRows("udfvalue", null, null);
        this.m_reader.processUserDefinedFields(fields, values);
    }

    private void processCalendars() {
        List<Row> rows = this.getRows("calendar", null, null);
        this.m_reader.processCalendars(rows);
    }

    private void processResources() {
        List<Row> rows = this.getRows("rsrc", null, null);
        this.m_reader.processResources(rows);
    }

    private void processRoles() {
        List<Row> rows = this.getRows("roles", null, null);
        this.m_reader.processRoles(rows);
    }

    private void processResourceRates() {
        List<Row> rows = this.getRows("rsrcrate", null, null);
        this.m_reader.processResourceRates(rows);
    }

    private void processRoleRates() {
        List<Row> rows = this.getRows("rolerate", null, null);
        this.m_reader.processRoleRates(rows);
    }

    private void processTasks() {
        List<Row> wbs = this.getRows("projwbs", "proj_id", this.m_projectID);
        List<Row> tasks = this.getRows("task", "proj_id", this.m_projectID);
        Map<Integer, String> topics = this.m_reader.getNotebookTopics(this.getRows("memotype", null, null));
        Map<Integer, Notes> wbsNotes = this.m_reader.getNotes(topics, this.getRows("wbsmemo", "proj_id", this.m_projectID), "wbs_id", "wbs_memo");
        Map<Integer, Notes> taskNotes = this.m_reader.getNotes(topics, this.getRows("taskmemo", "proj_id", this.m_projectID), "task_id", "task_memo");
        wbs.sort(WBS_ROW_COMPARATOR);
        this.m_reader.processTasks(wbs, tasks, wbsNotes, taskNotes);
    }

    private void processPredecessors() {
        List<Row> rows = this.getRows("taskpred", "proj_id", this.m_projectID);
        this.m_reader.processPredecessors(rows);
    }

    private void processAssignments() {
        List<Row> rows = this.getRows("taskrsrc", "proj_id", this.m_projectID);
        this.m_reader.processAssignments(rows, this.processWorkContours());
    }

    private Map<Integer, WorkContour> processWorkContours() {
        HashMap<Integer, WorkContour> result = new HashMap<Integer, WorkContour>();
        List<Row> rows = this.getRows("rsrccurvdata", null, null);
        for (Row row : rows) {
            String name = row.getString("curv_name");
            double[] values = new double[]{NumberHelper.getDouble(row.getDouble("pct_usage_0")), NumberHelper.getDouble(row.getDouble("pct_usage_1")), NumberHelper.getDouble(row.getDouble("pct_usage_2")), NumberHelper.getDouble(row.getDouble("pct_usage_3")), NumberHelper.getDouble(row.getDouble("pct_usage_4")), NumberHelper.getDouble(row.getDouble("pct_usage_5")), NumberHelper.getDouble(row.getDouble("pct_usage_6")), NumberHelper.getDouble(row.getDouble("pct_usage_7")), NumberHelper.getDouble(row.getDouble("pct_usage_8")), NumberHelper.getDouble(row.getDouble("pct_usage_9")), NumberHelper.getDouble(row.getDouble("pct_usage_10")), NumberHelper.getDouble(row.getDouble("pct_usage_11")), NumberHelper.getDouble(row.getDouble("pct_usage_12")), NumberHelper.getDouble(row.getDouble("pct_usage_13")), NumberHelper.getDouble(row.getDouble("pct_usage_14")), NumberHelper.getDouble(row.getDouble("pct_usage_15")), NumberHelper.getDouble(row.getDouble("pct_usage_16")), NumberHelper.getDouble(row.getDouble("pct_usage_17")), NumberHelper.getDouble(row.getDouble("pct_usage_18")), NumberHelper.getDouble(row.getDouble("pct_usage_19")), NumberHelper.getDouble(row.getDouble("pct_usage_20"))};
            result.put(row.getInteger("curv_id"), new WorkContour(name, values));
        }
        return result;
    }

    private void readRecord(Tokenizer tk, List<String> record) throws IOException {
        record.clear();
        while (tk.nextToken() == -3) {
            record.add(tk.getToken());
        }
    }

    private boolean processRecord(List<String> record) {
        XerRecordType type = RECORD_TYPE_MAP.get(record.get(0));
        return type != null && this.processRecord(type, record);
    }

    private boolean processRecord(XerRecordType type, List<String> record) {
        boolean done = false;
        switch (type) {
            case HEADER: {
                this.processHeader(record);
                break;
            }
            case TABLE: {
                this.m_currentTableName = record.size() > 1 ? record.get(1).toLowerCase() : null;
                boolean bl = this.m_skipTable = !REQUIRED_TABLES.contains(this.m_currentTableName);
                if (this.m_skipTable) {
                    this.m_currentTable = null;
                    break;
                }
                this.m_currentTable = new ArrayList<Row>();
                this.m_tables.put(this.m_currentTableName, this.m_currentTable);
                break;
            }
            case FIELDS: {
                if (this.m_skipTable) {
                    this.m_currentFieldNames = null;
                    break;
                }
                this.m_currentFieldNames = record.toArray(new String[0]);
                for (int loop = 0; loop < this.m_currentFieldNames.length; ++loop) {
                    this.m_currentFieldNames[loop] = this.m_currentFieldNames[loop].toLowerCase();
                }
                break;
            }
            case DATA: {
                if (this.m_skipTable) break;
                this.processData(record);
                break;
            }
            case END: {
                done = true;
                break;
            }
        }
        return done;
    }

    private void processData(List<String> record) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int loop = 1; loop < record.size() && loop != this.m_currentFieldNames.length; ++loop) {
            Object objectValue;
            String fieldName = this.m_currentFieldNames[loop];
            String fieldValue = record.get(loop);
            XerFieldType fieldType = this.getFieldType(fieldName);
            if (fieldValue.length() == 0) {
                objectValue = null;
            } else {
                switch (fieldType) {
                    case DATE: {
                        try {
                            objectValue = this.m_df.parseObject(fieldValue);
                        }
                        catch (ParseException ex) {
                            objectValue = fieldValue;
                        }
                        break;
                    }
                    case CURRENCY: 
                    case DOUBLE: 
                    case DURATION: {
                        try {
                            objectValue = this.m_numberFormat.parse(fieldValue.trim()).doubleValue();
                        }
                        catch (ParseException ex) {
                            objectValue = fieldValue;
                        }
                        break;
                    }
                    case INTEGER: {
                        try {
                            objectValue = Integer.valueOf(fieldValue.trim());
                        }
                        catch (NumberFormatException ex) {
                            objectValue = fieldValue;
                        }
                        break;
                    }
                    default: {
                        objectValue = fieldValue;
                    }
                }
            }
            map.put(fieldName, objectValue);
        }
        MapRow currentRow = new MapRow(map);
        this.m_currentTable.add(currentRow);
        if (this.m_currentTableName.equals("currtype")) {
            this.processCurrency(currentRow);
        }
    }

    private XerFieldType getFieldType(String fieldName) {
        XerFieldType fieldType = this.m_currentTableName.equals("projcost") && fieldName.equals("target_qty") ? XerFieldType.CURRENCY : this.m_fieldTypes.getOrDefault(fieldName, XerFieldType.STRING);
        return fieldType;
    }

    private void processHeader(List<String> record) {
        this.m_defaultCurrencyName = record.size() > 8 ? record.get(8) : "USD";
    }

    public Map<String, XerFieldType> getFieldTypeMap() {
        return this.m_fieldTypes;
    }

    public void setFieldNamesForTaskUdfType(UserFieldDataType type, String ... fieldNames) {
        this.m_taskUdfCounters.setFieldNamesForType(type, fieldNames);
    }

    public void setFieldNamesForResourceUdfType(UserFieldDataType type, String ... fieldNames) {
        this.m_resourceUdfCounters.setFieldNamesForType(type, fieldNames);
    }

    public void setFieldNamesForAssignmentUdfType(UserFieldDataType type, String ... fieldNames) {
        this.m_assignmentUdfCounters.setFieldNamesForType(type, fieldNames);
    }

    public Map<FieldType, String> getResourceFieldMap() {
        return this.m_resourceFields;
    }

    public Map<FieldType, String> getRoleFieldMap() {
        return this.m_roleFields;
    }

    public Map<FieldType, String> getWbsFieldMap() {
        return this.m_wbsFields;
    }

    public Map<FieldType, String> getActivityFieldMap() {
        return this.m_taskFields;
    }

    public Map<FieldType, String> getAssignmentFieldMap() {
        return this.m_assignmentFields;
    }

    private List<Row> getRows(String tableName, String columnName, Integer id) {
        List<Row> result;
        List<Row> table = this.m_tables.get(tableName);
        if (table == null) {
            result = Collections.emptyList();
        } else if (columnName == null) {
            result = table;
        } else {
            result = new ArrayList<Row>();
            for (Row row : table) {
                if (!NumberHelper.equals(id, row.getInteger(columnName))) continue;
                result.add(row);
            }
        }
        return result;
    }

    public boolean getMatchPrimaveraWBS() {
        return this.m_matchPrimaveraWBS;
    }

    public void setMatchPrimaveraWBS(boolean matchPrimaveraWBS) {
        this.m_matchPrimaveraWBS = matchPrimaveraWBS;
    }

    public boolean getWbsIsFullPath() {
        return this.m_wbsIsFullPath;
    }

    public void setWbsIsFullPath(boolean wbsIsFullPath) {
        this.m_wbsIsFullPath = wbsIsFullPath;
    }

    private Map<String, XerFieldType> getDefaultFieldTypes() {
        return new HashMap<String, XerFieldType>(FIELD_TYPE_MAP);
    }

    static {
        RECORD_TYPE_MAP.put("ERMHDR", XerRecordType.HEADER);
        RECORD_TYPE_MAP.put("%T", XerRecordType.TABLE);
        RECORD_TYPE_MAP.put("%F", XerRecordType.FIELDS);
        RECORD_TYPE_MAP.put("%R", XerRecordType.DATA);
        RECORD_TYPE_MAP.put("", XerRecordType.DATA);
        RECORD_TYPE_MAP.put("%E", XerRecordType.END);
        FIELD_TYPE_MAP = new HashMap<String, XerFieldType>();
        FIELD_TYPE_MAP.put("acct_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("acct_seq_num", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("act_cost", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("act_end_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("act_equip_qty", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("act_ot_cost", XerFieldType.CURRENCY);
        FIELD_TYPE_MAP.put("act_ot_qty", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("act_reg_cost", XerFieldType.CURRENCY);
        FIELD_TYPE_MAP.put("act_reg_qty", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("act_start_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("act_work_qty", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("actv_code_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("actv_code_type_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("anticip_end_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("anticip_start_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("base_clndr_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("clndr_data", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("clndr_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("clndr_name", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("clndr_type", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("cost_item_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("cost_per_qty", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("cost_per_qty2", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("cost_per_qty3", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("cost_per_qty4", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("cost_per_qty5", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("cost_type_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("create_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("cstr_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("cstr_date2", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("curv_id", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("day_hr_cnt", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("decimal_digit_cnt", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("default_flag", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("driving_path_flag", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("early_end_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("early_start_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("expect_end_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("external_early_start_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("external_late_end_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("fk_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("free_float_hr_cnt", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("fy_start_month_num", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("indep_remain_total_cost", XerFieldType.CURRENCY);
        FIELD_TYPE_MAP.put("indep_remain_work_qty", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("lag_hr_cnt", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("last_chng_date", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("last_recalc_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("late_end_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("late_start_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("loginal_data_type", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("max_qty_per_hr", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("memo_type_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("month_hr_cnt", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("orig_cost", XerFieldType.CURRENCY);
        FIELD_TYPE_MAP.put("parent_acct_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("parent_actv_code_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("parent_role_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("parent_rsrc_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("parent_wbs_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("pct_usage_0", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_1", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_2", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_3", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_4", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_5", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_6", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_7", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_8", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_9", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_10", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_11", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_12", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_13", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_14", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_15", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_16", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_17", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_18", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_19", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("pct_usage_20", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("phys_complete_pct", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("plan_end_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("plan_start_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("pred_task_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("proj_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("reend_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("rem_late_start_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("rem_late_end_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("remain_cost", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("remain_drtn_hr_cnt", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("remain_equip_qty", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("remain_qty", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("remain_work_qty", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("restart_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("resume_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("role_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("rsrc_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("rsrc_seq_num", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("scd_end_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("sched_calendar_on_relationship_lag", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("seq_num", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("start_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("sum_base_proj_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("super_flag", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("suspend_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("table_name", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("target_cost", XerFieldType.CURRENCY);
        FIELD_TYPE_MAP.put("target_drtn_hr_cnt", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("target_end_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("target_lag_drtn_hr_cnt", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("target_qty", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("target_qty_per_hr", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("target_start_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("target_work_qty", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("task_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("task_pred_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("taskrsrc_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("total_float_hr_cnt", XerFieldType.DURATION);
        FIELD_TYPE_MAP.put("udf_code_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("udf_date", XerFieldType.DATE);
        FIELD_TYPE_MAP.put("udf_number", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("udf_text", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("udf_type", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("udf_type_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("udf_type_label", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("udf_type_name", XerFieldType.STRING);
        FIELD_TYPE_MAP.put("wbs_id", XerFieldType.INTEGER);
        FIELD_TYPE_MAP.put("week_hr_cnt", XerFieldType.DOUBLE);
        FIELD_TYPE_MAP.put("year_hr_cnt", XerFieldType.DOUBLE);
        REQUIRED_TABLES = new HashSet<String>();
        REQUIRED_TABLES.add("project");
        REQUIRED_TABLES.add("calendar");
        REQUIRED_TABLES.add("rsrc");
        REQUIRED_TABLES.add("rsrcrate");
        REQUIRED_TABLES.add("projwbs");
        REQUIRED_TABLES.add("task");
        REQUIRED_TABLES.add("taskpred");
        REQUIRED_TABLES.add("taskrsrc");
        REQUIRED_TABLES.add("currtype");
        REQUIRED_TABLES.add("udftype");
        REQUIRED_TABLES.add("udfvalue");
        REQUIRED_TABLES.add("schedoptions");
        REQUIRED_TABLES.add("actvtype");
        REQUIRED_TABLES.add("actvcode");
        REQUIRED_TABLES.add("taskactv");
        REQUIRED_TABLES.add("costtype");
        REQUIRED_TABLES.add("account");
        REQUIRED_TABLES.add("projcost");
        REQUIRED_TABLES.add("memotype");
        REQUIRED_TABLES.add("wbsmemo");
        REQUIRED_TABLES.add("taskmemo");
        REQUIRED_TABLES.add("roles");
        REQUIRED_TABLES.add("rolerate");
        REQUIRED_TABLES.add("rsrccurvdata");
        WBS_ROW_COMPARATOR = new WbsRowComparatorXER();
    }

    private static enum XerRecordType {
        HEADER,
        TABLE,
        FIELDS,
        DATA,
        END;

    }
}

