/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.projectcommander;

import java.util.Date;
import net.sf.mpxj.Duration;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.DateHelper;

class DatatypeConverter {
    DatatypeConverter() {
    }

    public static final int getByte(byte[] data, int offset) {
        return data[offset] & 0xFF;
    }

    public static final int getShort(byte[] data, int offset) {
        int result = 0;
        int i = offset;
        for (int shiftBy = 0; shiftBy < 16; shiftBy += 8) {
            result |= (data[i] & 0xFF) << shiftBy;
            ++i;
        }
        return result;
    }

    public static final void setShort(byte[] data, int offset, int value) {
        data[offset] = (byte)(value & 0xFF);
        data[offset + 1] = (byte)((value & 0xFF00) >> 8);
    }

    public static final int getInt(byte[] data, int offset) {
        int result = 0;
        int i = offset;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            result |= (data[i] & 0xFF) << shiftBy;
            ++i;
        }
        return result;
    }

    public static final int getShort(byte[] data, int offset, int defaultValue) {
        return offset + 2 > data.length ? defaultValue : DatatypeConverter.getShort(data, offset);
    }

    public static final int getInt(byte[] data, int offset, int defaultValue) {
        return offset + 4 > data.length ? defaultValue : DatatypeConverter.getInt(data, offset);
    }

    public static final String getTwoByteLengthString(byte[] data, int offset) {
        int length = DatatypeConverter.getShort(data, offset);
        String result = length == 0 ? null : new String(data, offset + 2, length);
        return result;
    }

    public static final String getString(byte[] data, int offset) {
        int length = DatatypeConverter.getByte(data, offset);
        String result = length == 0 || length + offset + 1 > data.length ? null : new String(data, offset + 1, length);
        return result;
    }

    public static final String getString(byte[] data, int offset, String defaultValue) {
        return offset >= data.length ? defaultValue : DatatypeConverter.getString(data, offset);
    }

    public static final Duration getDuration(byte[] data, int offset) {
        int durationInMinutes = DatatypeConverter.getInt(data, offset, 0);
        return Duration.getInstance(durationInMinutes / 60, TimeUnit.HOURS);
    }

    public static final Date getTimestamp(byte[] data, int offset) {
        long timestampInSeconds = DatatypeConverter.getInt(data, offset, 0);
        long timestampInMilliseconds = timestampInSeconds * 1000L;
        return DateHelper.getTimestampFromLong(timestampInMilliseconds);
    }

    public static final RelationType getRelationType(byte[] data, int offset) {
        RelationType result;
        int value = DatatypeConverter.getByte(data, offset);
        switch (value) {
            case 5: {
                result = RelationType.START_FINISH;
                break;
            }
            case 6: {
                result = RelationType.START_START;
                break;
            }
            case 7: {
                result = RelationType.FINISH_FINISH;
                break;
            }
            default: {
                result = RelationType.FINISH_START;
            }
        }
        return result;
    }
}

