/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.ruby;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.json.JsonWriter;
import net.sf.mpxj.reader.UniversalProjectReader;

public final class GenerateJson {
    private static final Map<String, TimeUnit> TIME_UNIT_MAP = Arrays.stream(TimeUnit.values()).collect(Collectors.toMap(Enum::name, t -> t));

    public static void main(String[] args) {
        try {
            if (args.length != 3) {
                System.out.println("Usage: GenerateJson <input file name> <output file name> <time units>");
            } else {
                GenerateJson convert = new GenerateJson();
                convert.process(args[0], args[1], args[2]);
            }
            System.exit(0);
        }
        catch (Exception ex) {
            System.out.println();
            System.out.print("Conversion Error: ");
            ex.printStackTrace(System.out);
            System.out.println();
            System.exit(1);
        }
    }

    public void process(String inputFile, String outputFile, String timeUnits) throws Exception {
        System.out.println("Reading input file started.");
        long start = System.currentTimeMillis();
        ProjectFile projectFile = this.readFile(inputFile);
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("Reading input file completed in " + elapsed + "ms.");
        System.out.println("Writing output file started.");
        start = System.currentTimeMillis();
        JsonWriter writer = new JsonWriter();
        writer.setTimeUnits(TIME_UNIT_MAP.get(timeUnits.toUpperCase()));
        writer.write(projectFile, outputFile);
        elapsed = System.currentTimeMillis() - start;
        System.out.println("Writing output completed in " + elapsed + "ms.");
    }

    private ProjectFile readFile(String inputFile) throws MPXJException {
        UniversalProjectReader reader = new UniversalProjectReader();
        ProjectFile projectFile = reader.read(inputFile);
        if (projectFile == null) {
            throw new IllegalArgumentException("Unsupported file type");
        }
        return projectFile;
    }
}

