// RUN: %clang_cc1 -verify=expected,omp-lt60 -fopenmp -std=c++98 -ferror-limit 150 -o - %s
// RUN: %clang_cc1 -verify=expected,omp-lt60 -fopenmp -std=c++11 -ferror-limit 150 -o - %s
// RUN: %clang_cc1 -verify=expected,omp52,omp-lt60 -fopenmp -fopenmp-version=52 -ferror-limit 150 -o - %s
// RUN: %clang_cc1 -verify=expected,omp52,omp-lt60 -fopenmp -fopenmp-version=52 -std=c++98 -ferror-limit 150 -o - %s
// RUN: %clang_cc1 -verify=expected,omp52,omp-lt60 -fopenmp -fopenmp-version=52 -std=c++11 -ferror-limit 150 -o - %s
// RUN: %clang_cc1 -verify=expected,omp-ge60 -fopenmp -fopenmp-version=60 -ferror-limit 150 -o - %s

// RUN: %clang_cc1 -verify=expected,omp-lt60 -fopenmp-simd -ferror-limit 150 -o - %s
// RUN: %clang_cc1 -verify=expected,omp-lt60 -fopenmp-simd -std=c++98 -ferror-limit 150 -o - %s
// RUN: %clang_cc1 -verify=expected,omp-lt60 -fopenmp-simd -std=c++11 -ferror-limit 150 -o - %s
// RUN: %clang_cc1 -verify=expected,omp52,omp-lt60 -fopenmp-simd -fopenmp-version=52 -ferror-limit 150 -o - %s
// RUN: %clang_cc1 -verify=expected,omp52,omp-lt60 -fopenmp-simd -fopenmp-version=52 -std=c++98 -ferror-limit 150 -o - %s
// RUN: %clang_cc1 -verify=expected,omp52,omp-lt60 -fopenmp-simd -fopenmp-version=52 -std=c++11 -ferror-limit 150 -o - %s
// RUN: %clang_cc1 -verify=expected,omp-ge60 -fopenmp-simd -fopenmp-version=60 -std=c++11 -ferror-limit 150 -o - %s
// SIMD-ONLY0-NOT: {{__kmpc|__tgt}}

typedef void **omp_allocator_handle_t;
extern const omp_allocator_handle_t omp_null_allocator;
extern const omp_allocator_handle_t omp_default_mem_alloc;
extern const omp_allocator_handle_t omp_large_cap_mem_alloc;
extern const omp_allocator_handle_t omp_const_mem_alloc;
extern const omp_allocator_handle_t omp_high_bw_mem_alloc;
extern const omp_allocator_handle_t omp_low_lat_mem_alloc;
extern const omp_allocator_handle_t omp_cgroup_mem_alloc;
extern const omp_allocator_handle_t omp_pteam_mem_alloc;
extern const omp_allocator_handle_t omp_thread_mem_alloc;

void foo() {
}

bool foobool(int argc) {
  return argc;
}

void foobar(int &ref) {
#pragma omp taskgroup task_reduction(+:ref)
#pragma omp task in_reduction(+:ref) allocate(omp_thread_mem_alloc: ref) // expected-warning {{allocator with the 'thread' trait access has unspecified behavior on 'task' directive}}
  foo();
}

void foobar1(int &ref) {
#pragma omp taskgroup task_reduction(+:ref)
#pragma omp task in_reduction(-:ref) // omp52-warning {{minus(-) operator for reductions is deprecated; use + or user defined reduction instead}} omp-ge60-error {{incorrect reduction identifier, expected one of '+', '*', '&', '|', '^', '&&', '||', 'min' or 'max' or declare reduction for type 'int}}
  foo();
}

#pragma omp declare reduction (red:int:omp_out += omp_in)

void foobar2(int &ref) {
#pragma omp taskgroup task_reduction(+:ref) // expected-note {{previously marked as task_reduction with different reduction operation}}
#pragma omp task in_reduction(red:ref) // expected-error{{in_reduction variable must have the same reduction operation as in a task_reduction clause}}
  foo();
}

void foobar3(int &ref) {
#pragma omp taskgroup task_reduction(red:ref) // expected-note {{previously marked as task_reduction with different reduction operation}}
#pragma omp task in_reduction(min:ref)  // expected-error{{in_reduction variable must have the same reduction operation as in a task_reduction clause}}
  foo();
}

void foobar4(int &ref) {
#pragma omp task in_reduction(min:ref)
  foo();
}

struct S1; // expected-note {{declared here}} expected-note 4 {{forward declaration of 'S1'}}
extern S1 a;
class S2 {
  mutable int a;
  S2 &operator+(const S2 &arg) { return (*this); } // expected-note 3 {{implicitly declared private here}}

public:
  S2() : a(0) {}
  S2(S2 &s2) : a(s2.a) {}
  static float S2s; // expected-note 2 {{static data member is predetermined as shared}}
  static const float S2sc; // expected-note 2 {{'S2sc' declared here}}
};
const float S2::S2sc = 0;
S2 b;                     // expected-note 3 {{'b' defined here}}
const S2 ba[5];           // expected-note 2 {{'ba' defined here}}
class S3 {
  int a;

public:
  int b;
  S3() : a(0) {}
  S3(const S3 &s3) : a(s3.a) {}
  S3 operator+(const S3 &arg1) { return arg1; }
};
int operator+(const S3 &arg1, const S3 &arg2) { return 5; }
S3 c;               // expected-note 3 {{'c' defined here}}
const S3 ca[5];     // expected-note 2 {{'ca' defined here}}
extern const int f; // expected-note 4 {{'f' declared here}}
class S4 {
  int a;
  S4(); // expected-note {{implicitly declared private here}}
  S4(const S4 &s4);
  S4 &operator+(const S4 &arg) { return (*this); }

public:
  S4(int v) : a(v) {}
};
S4 &operator&=(S4 &arg1, S4 &arg2) { return arg1; }
class S5 {
  int a;
  S5() : a(0) {} // expected-note {{implicitly declared private here}}
  S5(const S5 &s5) : a(s5.a) {}
  S5 &operator+(const S5 &arg);

public:
  S5(int v) : a(v) {}
};
class S6 { // expected-note 3 {{candidate function (the implicit copy assignment operator) not viable: no known conversion from 'int' to 'const S6' for 1st argument}}
#if __cplusplus >= 201103L // C++11 or later
// expected-note@-2 3 {{candidate function (the implicit move assignment operator) not viable}}
#endif
  int a;

public:
  S6() : a(6) {}
  operator int() { return 6; }
} o;

S3 h, k;
#pragma omp threadprivate(h) // expected-note 2 {{defined as threadprivate or thread local}}

template <class T, class S>       // expected-note {{declared here}}
T tfoobar5(T argc, S ub[]) {
  const T d = T();       // expected-note 4 {{'d' defined here}}
  const T da[5] = {T()}; // expected-note 2 {{'da' defined here}}
  T qa[5] = {T()};
  T i;
  T &j = i;                    // expected-note 2 {{'j' defined here}}
  S3 &p = k;                   // expected-note 2 {{'p' defined here}}
  const T &r = da[(int)i];     // expected-note 2 {{'r' defined here}}
  T &q = qa[(int)i];
  T fl;
  T *ptr;
#pragma omp taskgroup task_reduction(+:argc)
#pragma omp task in_reduction // expected-error {{expected '(' after 'in_reduction'}}
  foo();
#pragma omp taskgroup task_reduction(+:argc)
#pragma omp task in_reduction + // expected-error {{expected '(' after 'in_reduction'}} expected-warning {{extra tokens at the end of '#pragma omp task' are ignored}}
  foo();
#pragma omp taskgroup task_reduction(+:argc)
#pragma omp task in_reduction( // expected-error {{expected unqualified-id}} expected-warning {{missing ':' after reduction identifier - ignoring}} expected-error {{expected ')'}} expected-note {{to match this '('}}
  foo();
#pragma omp taskgroup task_reduction(+:argc)
#pragma omp task in_reduction(- // expected-warning {{missing ':' after reduction identifier - ignoring}} expected-error {{expected ')'}} expected-note {{to match this '('}}
  foo();
#pragma omp taskgroup task_reduction(+:argc)
#pragma omp task in_reduction() // expected-error {{expected unqualified-id}} expected-warning {{missing ':' after reduction identifier - ignoring}}
  foo();
#pragma omp taskgroup task_reduction(+:argc)
#pragma omp task in_reduction(*) // expected-warning {{missing ':' after reduction identifier - ignoring}}
  foo();
#pragma omp taskgroup task_reduction(+:argc)
#pragma omp task in_reduction(\) // expected-error {{expected unqualified-id}} expected-warning {{missing ':' after reduction identifier - ignoring}}
  foo();
#pragma omp taskgroup task_reduction(&:argc) // expected-error {{invalid operands to binary expression ('float' and 'float')}}
#pragma omp task in_reduction(& : argc // expected-error {{expected ')'}} expected-note {{to match this '('}} expected-error {{invalid operands to binary expression ('float' and 'float')}}
  foo();
#pragma omp taskgroup task_reduction(|:argc) // expected-error {{invalid operands to binary expression ('float' and 'float')}}
#pragma omp task in_reduction(| : argc, // expected-error {{expected expression}} expected-error {{expected ')'}} expected-note {{to match this '('}} expected-error {{invalid operands to binary expression ('float' and 'float')}}
  foo();
#pragma omp task in_reduction(|| : argc ? i : argc) // expected-error 2 {{expected variable name, array element or array section}}
  foo();
#pragma omp task in_reduction(foo : argc) //omp-lt60-error {{incorrect reduction identifier, expected one of '+', '-', '*', '&', '|', '^', '&&', '||', 'min' or 'max' or declare reduction for type 'float'}} omp-lt60-error {{incorrect reduction identifier, expected one of '+', '-', '*', '&', '|', '^', '&&', '||', 'min' or 'max' or declare reduction for type 'int'}} omp-ge60-error {{incorrect reduction identifier, expected one of '+', '*', '&', '|', '^', '&&', '||', 'min' or 'max' or declare reduction for type 'int'}} omp-ge60-error {{incorrect reduction identifier, expected one of '+', '*', '&', '|', '^', '&&', '||', 'min' or 'max' or declare reduction for type 'float'}}
  foo();
#pragma omp taskgroup task_reduction(&&:argc)
#pragma omp task in_reduction(&& : argc)
  foo();
#pragma omp task in_reduction(^ : T) // expected-error {{'T' does not refer to a value}}
  foo();
#pragma omp taskgroup task_reduction(+:c)
#pragma omp task in_reduction(+ : a, b, c, d, f) // expected-error {{a reduction list item with incomplete type 'S1'}} expected-error 3 {{const-qualified variable cannot be in_reduction}} expected-error 2 {{'operator+' is a private member of 'S2'}}
  foo();
#pragma omp task in_reduction(min : a, b, c, d, f) // expected-error {{a reduction list item with incomplete type 'S1'}} expected-error 4 {{arguments of OpenMP clause 'in_reduction' for 'min' or 'max' must be of arithmetic type}} expected-error 3 {{const-qualified variable cannot be in_reduction}}
  foo();
#pragma omp task in_reduction(max : h.b) // expected-error {{expected variable name, array element or array section}}
  foo();
#pragma omp task in_reduction(+ : ba) // expected-error {{const-qualified variable cannot be in_reduction}}
  foo();
#pragma omp task in_reduction(* : ca) // expected-error {{const-qualified variable cannot be in_reduction}}
  foo();
#pragma omp task in_reduction(- : da) // expected-error 2 {{const-qualified variable cannot be in_reduction}} omp52-warning 3 {{minus(-) operator for reductions is deprecated; use + or user defined reduction instead}}
  foo();
#pragma omp task in_reduction(^ : fl) // expected-error {{invalid operands to binary expression ('float' and 'float')}}
  foo();
#pragma omp task in_reduction(&& : S2::S2s) // expected-error {{shared variable cannot be reduction}}
  foo();
#pragma omp task in_reduction(&& : S2::S2sc) // expected-error {{const-qualified variable cannot be in_reduction}}
  foo();
#pragma omp taskgroup task_reduction(+:k)
#pragma omp task in_reduction(+ : h, k) // expected-error {{threadprivate or thread local variable cannot be reduction}}
  foo();
#pragma omp task in_reduction(+ : o) // expected-error 2 {{no viable overloaded '='}}
  foo();
#pragma omp parallel private(k)
#pragma omp task in_reduction(+ : p), in_reduction(+ : p) // expected-error 2 {{argument of OpenMP clause 'in_reduction' must reference the same object in all threads}}
  foo();
#pragma omp taskgroup task_reduction(+:p)
#pragma omp task in_reduction(+ : p), in_reduction(+ : p) // expected-error 2 {{variable can appear only once in OpenMP 'in_reduction' clause}} expected-note 2 {{previously referenced here}}
  foo();
#pragma omp task in_reduction(+ : r) // expected-error 2 {{const-qualified variable cannot be in_reduction}}
  foo();
#pragma omp parallel shared(i)
#pragma omp parallel reduction(min : i)
#pragma omp task in_reduction(max : j) // expected-error 2 {{argument of OpenMP clause 'in_reduction' must reference the same object in all threads}}
  foo();
#pragma omp taskgroup task_reduction(+:fl)
#pragma omp task in_reduction(+ : fl)
    foo();
#pragma omp parallel
#pragma omp for reduction(- : fl) // omp52-warning 3 {{minus(-) operator for reductions is deprecated; use + or user defined reduction instead}} omp-ge60-error {{incorrect reduction identifier, expected one of '+', '*', '&', '|', '^', '&&', '||', 'min' or 'max' or declare reduction for type 'int'}} omp-ge60-error {{incorrect reduction identifier, expected one of '+', '*', '&', '|', '^', '&&', '||', 'min' or 'max' or declare reduction for type 'float'}}
  for (int i = 0; i < 10; ++i)
#pragma omp taskgroup task_reduction(+:fl)
#pragma omp task in_reduction(+ : fl)
    foo();
#pragma omp task in_reduction(min:ub[:]) // expected-error 2 {{section length is unspecified and cannot be inferred because subscripted value is an array of unknown bound}}
  foo();
#pragma omp task in_reduction(min:ptr[:]) // expected-error 2 {{section length is unspecified and cannot be inferred because subscripted value is not an array}}
  foo();

  return T();
}

namespace A {
double x;
#pragma omp threadprivate(x) // expected-note {{defined as threadprivate or thread local}}
}
namespace B {
using A::x;
}

int foobar5(int argc, float ub[]) {
  const int d = 5;       // expected-note 2 {{'d' defined here}}
  const int da[5] = {0}; // expected-note {{'da' defined here}}
  int qa[5] = {0};
  S4 e(4);
  S5 g(5);
  int i;
  int &j = i;                  // expected-note {{'j' defined here}}
  S3 &p = k;                   // expected-note 2 {{'p' defined here}}
  const int &r = da[i];        // expected-note {{'r' defined here}}
  int &q = qa[i];
  float fl;
  float *ptr;
#pragma omp task in_reduction // expected-error {{expected '(' after 'in_reduction'}}
  foo();
#pragma omp task in_reduction + // expected-error {{expected '(' after 'in_reduction'}} expected-warning {{extra tokens at the end of '#pragma omp task' are ignored}}
  foo();
#pragma omp task in_reduction( // expected-error {{expected unqualified-id}} expected-warning {{missing ':' after reduction identifier - ignoring}} expected-error {{expected ')'}} expected-note {{to match this '('}}
  foo();
#pragma omp task in_reduction(- // expected-warning {{missing ':' after reduction identifier - ignoring}} expected-error {{expected ')'}} expected-note {{to match this '('}}
  foo();
#pragma omp task in_reduction() // expected-error {{expected unqualified-id}} expected-warning {{missing ':' after reduction identifier - ignoring}}
  foo();
#pragma omp task in_reduction(*) // expected-warning {{missing ':' after reduction identifier - ignoring}}
  foo();
#pragma omp task in_reduction(\) // expected-error {{expected unqualified-id}} expected-warning {{missing ':' after reduction identifier - ignoring}}
  foo();
#pragma omp task in_reduction(foo : argc // expected-error {{expected ')'}} expected-note {{to match this '('}} omp-lt60-error {{incorrect reduction identifier, expected one of '+', '-', '*', '&', '|', '^', '&&', '||', 'min' or 'max'}} omp-ge60-error {{incorrect reduction identifier, expected one of '+', '*', '&', '|', '^', '&&', '||', 'min' or 'max'}}
  foo();
#pragma omp taskgroup task_reduction(|:argc)
{
#pragma omp taskgroup task_reduction(+:argc) // expected-note {{previously marked as task_reduction with different reduction operation}}
{
#pragma omp task in_reduction(| : argc, // expected-error {{expected expression}} expected-error {{expected ')'}} expected-note {{to match this '('}} expected-error {{in_reduction variable must have the same reduction operation as in a task_reduction clause}}
  foo();
}
#pragma omp task in_reduction(| : argc) allocate , allocate(, allocate(omp_default , allocate(omp_default_mem_alloc, allocate(omp_default_mem_alloc:, allocate(omp_default_mem_alloc: argc, allocate(omp_default_mem_alloc: ub), allocate(ub) // expected-error {{expected '(' after 'allocate'}} expected-error 2 {{expected expression}} expected-error 2 {{expected ')'}} expected-error {{use of undeclared identifier 'omp_default'}} expected-note 2 {{to match this '('}}
  foo();
}
#pragma omp task in_reduction(|| : argc > 0 ? ub[1] : ub[2]) // expected-error {{expected variable name, array element or array section}}
  foo();
#pragma omp task in_reduction(~ : argc) // expected-error {{expected unqualified-id}}
  foo();
#pragma omp taskgroup task_reduction(&&:argc)
#pragma omp task in_reduction(&& : argc)
  foo();
#pragma omp task in_reduction(^ : S1) // expected-error {{'S1' does not refer to a value}}
  foo();
#pragma omp taskgroup task_reduction(+:c)
#pragma omp task in_reduction(+ : a, b, c, d, f) // expected-error {{a reduction list item with incomplete type 'S1'}} expected-error 2 {{const-qualified variable cannot be in_reduction}} expected-error {{'operator+' is a private member of 'S2'}}
  foo();
#pragma omp task in_reduction(min : a, b, c, d, f) // expected-error {{a reduction list item with incomplete type 'S1'}} expected-error 2 {{arguments of OpenMP clause 'in_reduction' for 'min' or 'max' must be of arithmetic type}} expected-error 2 {{const-qualified variable cannot be in_reduction}}
  foo();
#pragma omp task in_reduction(max : h.b) // expected-error {{expected variable name, array element or array section}}
  foo();
#pragma omp task in_reduction(+ : ba) // expected-error {{const-qualified variable cannot be in_reduction}}
  foo();
#pragma omp task in_reduction(* : ca) // expected-error {{const-qualified variable cannot be in_reduction}}
  foo();
#pragma omp task in_reduction(- : da) // expected-error {{const-qualified variable cannot be in_reduction}} omp52-warning {{minus(-) operator for reductions is deprecated; use + or user defined reduction instead}} 
  foo();
#pragma omp task in_reduction(^ : fl) // expected-error {{invalid operands to binary expression ('float' and 'float')}}
  foo();
#pragma omp task in_reduction(&& : S2::S2s) // expected-error {{shared variable cannot be reduction}}
  foo();
#pragma omp task in_reduction(&& : S2::S2sc) // expected-error {{const-qualified variable cannot be in_reduction}}
  foo();
#pragma omp task in_reduction(& : e, g) // expected-error {{calling a private constructor of class 'S4'}} expected-error {{calling a private constructor of class 'S5'}} expected-error {{invalid operands to binary expression ('S5' and 'S5')}}
  foo();
#pragma omp taskgroup task_reduction(+:k)
#pragma omp task in_reduction(+ : h, k, B::x) // expected-error 2 {{threadprivate or thread local variable cannot be reduction}}
  foo();
#pragma omp task in_reduction(+ : o) // expected-error {{no viable overloaded '='}}
  foo();
#pragma omp parallel private(k)
#pragma omp task in_reduction(+ : p), in_reduction(+ : p) // expected-error 2 {{argument of OpenMP clause 'in_reduction' must reference the same object in all threads}}
  foo();
#pragma omp taskgroup task_reduction(+:p)
#pragma omp task in_reduction(+ : p), in_reduction(+ : p) // expected-error {{variable can appear only once in OpenMP 'in_reduction' clause}} expected-note {{previously referenced here}}
  foo();
#pragma omp task in_reduction(+ : r) // expected-error {{const-qualified variable cannot be in_reduction}}
  foo();
#pragma omp parallel shared(i)
#pragma omp parallel reduction(min : i)
#pragma omp task in_reduction(max : j) // expected-error {{argument of OpenMP clause 'in_reduction' must reference the same object in all threads}}
  foo();
#pragma omp parallel
#pragma omp for private(fl)
  for (int i = 0; i < 10; ++i)
#pragma omp taskgroup task_reduction(+:fl)
#pragma omp task in_reduction(+ : fl)
    foo();
#pragma omp taskgroup task_reduction(+:fl)
#pragma omp task in_reduction(+ : fl)
    foo();
  static int m;
#pragma omp taskgroup task_reduction(+:m)
#pragma omp task in_reduction(+ : m) // OK
  m++;
#pragma omp task in_reduction(min:ub[:]) // expected-error {{section length is unspecified and cannot be inferred because subscripted value is an array of unknown bound}}
  foo();
#pragma omp task in_reduction(min:ptr[:]) // expected-error {{section length is unspecified and cannot be inferred because subscripted value is not an array}}
  foo();

  return tfoobar5(argc, ub) + tfoobar5(fl, ub); // expected-note {{in instantiation of function template specialization 'tfoobar5<int, float>' requested here}} expected-note {{in instantiation of function template specialization 'tfoobar5<float, float>' requested here}}
}
