/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.provider;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.internal.provider.AbstractResourceBundleProvider;
import org.openhab.core.automation.internal.provider.HostFragmentMappingUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class AutomationResourceBundlesEventQueue<@NonNull E>
implements Runnable {
    protected final Logger logger = LoggerFactory.getLogger(AutomationResourceBundlesEventQueue.class);
    private List<BundleEvent> queue = new ArrayList<BundleEvent>();
    private boolean running = false;
    private @Nullable Thread runningThread;
    private boolean closed = false;
    private boolean shared = false;
    private final AbstractResourceBundleProvider<E> provider;

    public AutomationResourceBundlesEventQueue(AbstractResourceBundleProvider<E> provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean waitForEvents = true;
        while (true) {
            List<BundleEvent> lQueue;
            AutomationResourceBundlesEventQueue automationResourceBundlesEventQueue = this;
            synchronized (automationResourceBundlesEventQueue) {
                if (this.closed) {
                    this.notifyAll();
                    return;
                }
                if (this.queue.isEmpty()) {
                    if (waitForEvents) {
                        try {
                            this.wait(180000L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        waitForEvents = false;
                        continue;
                    }
                    this.running = false;
                    this.runningThread = null;
                    this.notifyAll();
                    return;
                }
                lQueue = this.queue;
                this.shared = true;
            }
            for (BundleEvent event : lQueue) {
                try {
                    this.processBundleChanged(event);
                    AutomationResourceBundlesEventQueue automationResourceBundlesEventQueue2 = this;
                    synchronized (automationResourceBundlesEventQueue2) {
                        if (this.closed) {
                            this.notifyAll();
                            return;
                        }
                    }
                }
                catch (IllegalStateException e) {
                }
                catch (Throwable t) {
                    if (this.closed) continue;
                    this.logger.warn("Processing bundle event {}, for automation resource bundle '{}' failed", new Object[]{event.getType(), event.getBundle().getSymbolicName(), t});
                }
            }
            automationResourceBundlesEventQueue = this;
            synchronized (automationResourceBundlesEventQueue) {
                if (this.shared) {
                    this.queue.clear();
                }
                this.shared = false;
                waitForEvents = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        AutomationResourceBundlesEventQueue automationResourceBundlesEventQueue = this;
        synchronized (automationResourceBundlesEventQueue) {
            this.closed = true;
            this.notifyAll();
        }
        Thread runningThread = this.runningThread;
        if (runningThread != null) {
            try {
                runningThread.join(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected synchronized void addEvent(Bundle bundle, BundleEvent event) {
        if (this.closed) {
            return;
        }
        if (this.shared) {
            this.queue = new LinkedList<BundleEvent>();
            this.shared = false;
        }
        if (this.queue.add(event)) {
            this.logger.debug("Process bundle event {}, for automation bundle '{}' ", (Object)event.getType(), (Object)event.getBundle().getSymbolicName());
            if (this.running) {
                this.notifyAll();
            } else {
                this.runningThread = new Thread((Runnable)this, "Automation Provider Processing Queue");
                this.runningThread.start();
                this.running = true;
            }
        }
    }

    protected void processBundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        if (HostFragmentMappingUtil.isFragmentBundle(bundle)) {
            for (Bundle host : HostFragmentMappingUtil.returnHostBundles(bundle)) {
                this.provider.processAutomationProvider(host);
            }
        } else {
            switch (event.getType()) {
                case 16: {
                    this.provider.processAutomationProviderUninstalled(bundle);
                    break;
                }
                default: {
                    this.provider.processAutomationProvider(bundle);
                }
            }
        }
    }

    protected synchronized void addAll(List<BundleEvent> queue) {
        if (this.closed) {
            return;
        }
        if (this.shared) {
            this.queue = new LinkedList<BundleEvent>();
            this.shared = false;
        }
        if (this.queue.addAll(queue)) {
            if (this.running) {
                this.notifyAll();
            } else {
                this.runningThread = new Thread((Runnable)this, "Automation Provider Processing Queue");
                this.runningThread.start();
                this.running = true;
            }
        }
    }
}

