/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.xsd.XSDatatypeImpl;
import java.io.InvalidObjectException;
import java.io.Serializable;
import org.relaxng.datatype.DatatypeException;

public abstract class WhiteSpaceProcessor
implements Serializable {
    public static final WhiteSpaceProcessor thePreserve = new WhiteSpaceProcessor(){

        public String process(String string) {
            return string;
        }

        int tightness() {
            return 0;
        }

        public String getName() {
            return "preserve";
        }
    };
    public static final WhiteSpaceProcessor theReplace = new WhiteSpaceProcessor(){

        public String process(String string) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (WhiteSpaceProcessor.isWhiteSpace(c)) {
                    stringBuffer.append(' ');
                } else {
                    stringBuffer.append(c);
                }
                ++n2;
            }
            return stringBuffer.toString();
        }

        int tightness() {
            return 1;
        }

        public String getName() {
            return "replace";
        }
    };
    public static final WhiteSpaceProcessor theCollapse = new WhiteSpaceProcessor(){

        public String process(String string) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            boolean bl = true;
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                boolean bl2 = WhiteSpaceProcessor.isWhiteSpace(c);
                if (!bl || !bl2) {
                    bl = bl2;
                    if (bl) {
                        stringBuffer.append(' ');
                    } else {
                        stringBuffer.append(c);
                    }
                }
                ++n2;
            }
            n = stringBuffer.length();
            if (n > 0 && stringBuffer.charAt(n - 1) == ' ') {
                stringBuffer.setLength(n - 1);
            }
            return stringBuffer.toString();
        }

        int tightness() {
            return 2;
        }

        public String getName() {
            return "collapse";
        }
    };

    public abstract String process(String var1);

    abstract int tightness();

    public abstract String getName();

    protected static WhiteSpaceProcessor get(String string) throws DatatypeException {
        if ((string = theCollapse.process(string)).equals("preserve")) {
            return thePreserve;
        }
        if (string.equals("collapse")) {
            return theCollapse;
        }
        if (string.equals("replace")) {
            return theReplace;
        }
        throw new DatatypeException(XSDatatypeImpl.localize("WhiteSpaceProcessor.InvalidWhiteSpaceValue", string));
    }

    protected static final boolean isWhiteSpace(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c == ' ';
    }

    protected Object readResolve() throws InvalidObjectException {
        try {
            return WhiteSpaceProcessor.get(this.getName());
        }
        catch (DatatypeException datatypeException) {
            throw new InvalidObjectException("Unknown Processing Mode");
        }
    }

    public static String replace(String string) {
        return theReplace.process(string);
    }

    public static String collapse(String string) {
        return theCollapse.process(string);
    }
}

