/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.project;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.dita.dost.project.Project;
import org.dita.dost.project.ProjectBuilder;
import org.dita.dost.project.XmlReader;
import org.dita.dost.util.FileUtils;
import org.slf4j.Logger;
import org.xml.sax.SAXParseException;

public class ProjectFactory {
    private static final ObjectReader jsonReader = new ObjectMapper().reader().forType(ProjectBuilder.class).with(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    private static final ObjectReader yamlReader = new YAMLMapper().reader().forType(ProjectBuilder.class).with(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    private final XmlReader xmlReader = new XmlReader();
    private Logger logger;
    private boolean lax;

    public static ProjectFactory getInstance() {
        return new ProjectFactory();
    }

    public Project load(URI file) throws IOException {
        try {
            return ProjectFactory.resolveReferences(this.load(file, Collections.emptySet()));
        }
        catch (SAXParseException e) {
            if (e.getLineNumber() != -1) {
                throw new IOException(String.format("Failed to read project file %s:%s:%s: %s", file, e.getLineNumber(), e.getColumnNumber(), e.getLocalizedMessage()), e);
            }
            throw new IOException(String.format("Failed to read project file %s: %s", file, e.getLocalizedMessage()), e);
        }
        catch (IOException e) {
            throw new IOException("Failed to read project file: " + e.getMessage(), e);
        }
    }

    @VisibleForTesting
    static Project resolveReferences(Project src) {
        return new Project(src.deliverables() == null ? Collections.emptyList() : src.deliverables().stream().map(deliverable -> {
            Project.Context context = Optional.ofNullable(deliverable.context()).flatMap(cntx -> Optional.ofNullable(cntx.idref())).map(idref -> {
                Project.Context pub = src.contexts().stream().filter(cntx -> Objects.equals(cntx.id(), deliverable.context().idref())).findAny().orElseThrow(() -> new RuntimeException(String.format("Context not found: %s", deliverable.context().idref())));
                return pub;
            }).orElse(deliverable.context());
            Project.Publication publication = Optional.ofNullable(deliverable.publication()).flatMap(publ -> Optional.ofNullable(publ.idref())).map(idref -> {
                Project.Publication pub = src.publications().stream().filter(publ -> Objects.equals(publ.id(), deliverable.publication().idref())).findAny().orElseThrow(() -> new RuntimeException(String.format("Publication not found: %s", deliverable.publication().idref())));
                return ProjectFactory.merge(pub, deliverable.publication());
            }).orElse(deliverable.publication());
            return new Project.Deliverable(deliverable.name(), deliverable.id(), context, deliverable.output(), publication);
        }).collect(Collectors.toList()), src.includes(), src.publications(), src.contexts());
    }

    private static Project.Publication merge(Project.Publication base, Project.Publication extend) {
        HashMap<String, Project.Publication.Param> params = new HashMap<String, Project.Publication.Param>();
        if (base.params() != null) {
            for (Project.Publication.Param param : base.params()) {
                params.put(param.name(), param);
            }
        }
        if (extend.params() != null) {
            for (Project.Publication.Param param : extend.params()) {
                params.put(param.name(), param);
            }
        }
        return new Project.Publication(base.name(), base.id(), base.idref(), base.transtype(), new ArrayList<Project.Publication.Param>(params.values()), base.profiles());
    }

    private Project load(URI file, Set<URI> processed) throws IOException, SAXParseException {
        if (processed.contains(file)) {
            throw new RuntimeException("Recursive project file import: " + String.valueOf(file));
        }
        Project project = Project.build(switch (FileUtils.getExtension(file.getPath()).toLowerCase()) {
            case "xml" -> {
                this.xmlReader.setLogger(this.logger);
                this.xmlReader.setLax(this.lax);
                yield this.xmlReader.read(file);
            }
            case "json" -> (ProjectBuilder)jsonReader.readValue(file.toURL());
            case "yaml" -> (ProjectBuilder)yamlReader.readValue(file.toURL());
            default -> throw new RuntimeException("Unrecognized project file format: " + String.valueOf(file));
        }, file);
        HashSet<URI> res = new HashSet<URI>(processed);
        res.add(file);
        return this.resolveIncludes(project, file, Collections.unmodifiableSet(res));
    }

    private Project resolveIncludes(Project project, URI base, Set<URI> processed) throws IOException, SAXParseException {
        ArrayList<Project.Context> contexts;
        if (project.includes() == null || project.includes().isEmpty()) {
            return project;
        }
        ArrayList<Project.Deliverable> deliverables = project.deliverables() != null ? new ArrayList<Project.Deliverable>(project.deliverables()) : new ArrayList();
        ArrayList<Project.Publication> publications = project.publications() != null ? new ArrayList<Project.Publication>(project.publications()) : new ArrayList();
        ArrayList<Project.Context> arrayList = contexts = project.contexts() != null ? new ArrayList<Project.Context>(project.contexts()) : new ArrayList();
        if (project.includes() != null) {
            for (Project.ProjectRef projectRef : project.includes()) {
                URI href = projectRef.href().isAbsolute() ? projectRef.href() : base.resolve(projectRef.href());
                Project ref = this.load(href, processed);
                if (ref.deliverables() != null) {
                    deliverables.addAll(ref.deliverables());
                }
                if (ref.publications() != null) {
                    publications.addAll(ref.publications());
                }
                if (ref.contexts() == null) continue;
                contexts.addAll(ref.contexts());
            }
        }
        return new Project(deliverables, project.includes(), publications, contexts);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLax(boolean lax) {
        this.lax = lax;
    }
}

