//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstimezone?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSTimeZone;
);

unsafe impl Send for NSTimeZone {}

unsafe impl Sync for NSTimeZone {}

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCoding for NSTimeZone {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCopying for NSTimeZone {}
);

#[cfg(feature = "NSObject")]
unsafe impl CopyingHelper for NSTimeZone {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSTimeZone {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSSecureCoding for NSTimeZone {}
);

impl NSTimeZone {
    extern_methods!(
        #[cfg(feature = "NSString")]
        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        pub unsafe fn name(&self) -> Retained<NSString>;

        #[cfg(feature = "NSData")]
        #[unsafe(method(data))]
        #[unsafe(method_family = none)]
        pub unsafe fn data(&self) -> Retained<NSData>;

        #[cfg(feature = "NSDate")]
        #[unsafe(method(secondsFromGMTForDate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn secondsFromGMTForDate(&self, a_date: &NSDate) -> NSInteger;

        #[cfg(all(feature = "NSDate", feature = "NSString"))]
        #[unsafe(method(abbreviationForDate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn abbreviationForDate(&self, a_date: &NSDate) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSDate")]
        #[unsafe(method(isDaylightSavingTimeForDate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn isDaylightSavingTimeForDate(&self, a_date: &NSDate) -> bool;

        #[cfg(feature = "NSDate")]
        #[unsafe(method(daylightSavingTimeOffsetForDate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn daylightSavingTimeOffsetForDate(&self, a_date: &NSDate) -> NSTimeInterval;

        #[cfg(feature = "NSDate")]
        #[unsafe(method(nextDaylightSavingTimeTransitionAfterDate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn nextDaylightSavingTimeTransitionAfterDate(
            &self,
            a_date: &NSDate,
        ) -> Option<Retained<NSDate>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSTimeZone {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstimezonenamestyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTimeZoneNameStyle(pub NSInteger);
impl NSTimeZoneNameStyle {
    #[doc(alias = "NSTimeZoneNameStyleStandard")]
    pub const Standard: Self = Self(0);
    #[doc(alias = "NSTimeZoneNameStyleShortStandard")]
    pub const ShortStandard: Self = Self(1);
    #[doc(alias = "NSTimeZoneNameStyleDaylightSaving")]
    pub const DaylightSaving: Self = Self(2);
    #[doc(alias = "NSTimeZoneNameStyleShortDaylightSaving")]
    pub const ShortDaylightSaving: Self = Self(3);
    #[doc(alias = "NSTimeZoneNameStyleGeneric")]
    pub const Generic: Self = Self(4);
    #[doc(alias = "NSTimeZoneNameStyleShortGeneric")]
    pub const ShortGeneric: Self = Self(5);
}

unsafe impl Encode for NSTimeZoneNameStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSTimeZoneNameStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// NSExtendedTimeZone.
impl NSTimeZone {
    extern_methods!(
        #[unsafe(method(systemTimeZone))]
        #[unsafe(method_family = none)]
        pub unsafe fn systemTimeZone() -> Retained<NSTimeZone>;

        #[unsafe(method(resetSystemTimeZone))]
        #[unsafe(method_family = none)]
        pub unsafe fn resetSystemTimeZone();

        #[unsafe(method(defaultTimeZone))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultTimeZone() -> Retained<NSTimeZone>;

        /// Setter for [`defaultTimeZone`][Self::defaultTimeZone].
        #[unsafe(method(setDefaultTimeZone:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDefaultTimeZone(default_time_zone: &NSTimeZone);

        #[unsafe(method(localTimeZone))]
        #[unsafe(method_family = none)]
        pub unsafe fn localTimeZone() -> Retained<NSTimeZone>;

        #[cfg(all(feature = "NSArray", feature = "NSString"))]
        #[unsafe(method(knownTimeZoneNames))]
        #[unsafe(method_family = none)]
        pub unsafe fn knownTimeZoneNames() -> Retained<NSArray<NSString>>;

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        #[unsafe(method(abbreviationDictionary))]
        #[unsafe(method_family = none)]
        pub unsafe fn abbreviationDictionary() -> Retained<NSDictionary<NSString, NSString>>;

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        /// Setter for [`abbreviationDictionary`][Self::abbreviationDictionary].
        #[unsafe(method(setAbbreviationDictionary:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAbbreviationDictionary(
            abbreviation_dictionary: &NSDictionary<NSString, NSString>,
        );

        #[cfg(feature = "NSString")]
        #[unsafe(method(timeZoneDataVersion))]
        #[unsafe(method_family = none)]
        pub unsafe fn timeZoneDataVersion() -> Retained<NSString>;

        #[unsafe(method(secondsFromGMT))]
        #[unsafe(method_family = none)]
        pub unsafe fn secondsFromGMT(&self) -> NSInteger;

        #[cfg(feature = "NSString")]
        #[unsafe(method(abbreviation))]
        #[unsafe(method_family = none)]
        pub unsafe fn abbreviation(&self) -> Option<Retained<NSString>>;

        #[unsafe(method(isDaylightSavingTime))]
        #[unsafe(method_family = none)]
        pub unsafe fn isDaylightSavingTime(&self) -> bool;

        #[cfg(feature = "NSDate")]
        #[unsafe(method(daylightSavingTimeOffset))]
        #[unsafe(method_family = none)]
        pub unsafe fn daylightSavingTimeOffset(&self) -> NSTimeInterval;

        #[cfg(feature = "NSDate")]
        #[unsafe(method(nextDaylightSavingTimeTransition))]
        #[unsafe(method_family = none)]
        pub unsafe fn nextDaylightSavingTimeTransition(&self) -> Option<Retained<NSDate>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(description))]
        #[unsafe(method_family = none)]
        pub unsafe fn description(&self) -> Retained<NSString>;

        #[unsafe(method(isEqualToTimeZone:))]
        #[unsafe(method_family = none)]
        pub unsafe fn isEqualToTimeZone(&self, a_time_zone: &NSTimeZone) -> bool;

        #[cfg(all(feature = "NSLocale", feature = "NSString"))]
        #[unsafe(method(localizedName:locale:))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedName_locale(
            &self,
            style: NSTimeZoneNameStyle,
            locale: Option<&NSLocale>,
        ) -> Option<Retained<NSString>>;
    );
}

/// NSTimeZoneCreation.
impl NSTimeZone {
    extern_methods!(
        #[cfg(feature = "NSString")]
        #[unsafe(method(timeZoneWithName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn timeZoneWithName(tz_name: &NSString) -> Option<Retained<Self>>;

        #[cfg(all(feature = "NSData", feature = "NSString"))]
        #[unsafe(method(timeZoneWithName:data:))]
        #[unsafe(method_family = none)]
        pub unsafe fn timeZoneWithName_data(
            tz_name: &NSString,
            a_data: Option<&NSData>,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(initWithName:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithName(
            this: Allocated<Self>,
            tz_name: &NSString,
        ) -> Option<Retained<Self>>;

        #[cfg(all(feature = "NSData", feature = "NSString"))]
        #[unsafe(method(initWithName:data:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithName_data(
            this: Allocated<Self>,
            tz_name: &NSString,
            a_data: Option<&NSData>,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(timeZoneForSecondsFromGMT:))]
        #[unsafe(method_family = none)]
        pub unsafe fn timeZoneForSecondsFromGMT(seconds: NSInteger) -> Retained<Self>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(timeZoneWithAbbreviation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn timeZoneWithAbbreviation(abbreviation: &NSString) -> Option<Retained<Self>>;
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nssystemtimezonedidchangenotification?language=objc)
    #[cfg(all(feature = "NSNotification", feature = "NSString"))]
    pub static NSSystemTimeZoneDidChangeNotification: &'static NSNotificationName;
}
