//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2_core_foundation::*;

use crate::*;

#[cfg(feature = "SCDynamicStore")]
impl SCDynamicStore {
    /// Gets the current computer name.
    ///
    /// Parameter `store`: An SCDynamicStoreRef representing the dynamic store
    /// session that should be used for communication with the server.
    /// If NULL, a temporary session will be used.
    ///
    /// Parameter `nameEncoding`: A pointer to memory that, if non-NULL, will be
    /// filled with the encoding associated with the computer or
    /// host name.
    ///
    /// Returns: Returns the current computer name;
    /// NULL if the name has not been set or if an error was encountered.
    /// You must release the returned value.
    ///
    /// # Safety
    ///
    /// `name_encoding` must be a valid pointer or null.
    #[doc(alias = "SCDynamicStoreCopyComputerName")]
    #[cfg(feature = "SCDynamicStore")]
    #[inline]
    pub unsafe fn computer_name(
        store: Option<&SCDynamicStore>,
        name_encoding: *mut CFStringEncoding,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn SCDynamicStoreCopyComputerName(
                store: Option<&SCDynamicStore>,
                name_encoding: *mut CFStringEncoding,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { SCDynamicStoreCopyComputerName(store, name_encoding) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Gets the name, user ID, and group ID of the currently
    /// logged-in user.
    ///
    /// Note: this function only provides information about the
    /// primary console.  It does not provide any details
    /// about console sessions that have fast user switched
    /// out or about other consoles.
    ///
    /// Parameter `store`: An SCDynamicStoreRef representing the dynamic store
    /// session that should be used for communication with the server.
    /// If NULL, a temporary session will be used.
    ///
    /// Parameter `uid`: A pointer to memory that will be filled with the user ID
    /// of the current console user. If NULL, this value will not
    /// be returned.
    ///
    /// Parameter `gid`: A pointer to memory that will be filled with the group ID
    /// of the current console user. If NULL, this value will not be
    /// returned.
    ///
    /// Returns: Returns the user currently logged into the system;
    /// NULL if no user is logged in or if an error was encountered.
    /// You must release the returned value.
    ///
    /// # Safety
    ///
    /// - `uid` must be a valid pointer or null.
    /// - `gid` must be a valid pointer or null.
    #[doc(alias = "SCDynamicStoreCopyConsoleUser")]
    #[cfg(all(feature = "SCDynamicStore", feature = "libc"))]
    #[inline]
    pub unsafe fn console_user(
        store: Option<&SCDynamicStore>,
        uid: *mut libc::uid_t,
        gid: *mut libc::gid_t,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn SCDynamicStoreCopyConsoleUser(
                store: Option<&SCDynamicStore>,
                uid: *mut libc::uid_t,
                gid: *mut libc::gid_t,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { SCDynamicStoreCopyConsoleUser(store, uid, gid) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Gets the current local host name.
    ///
    /// Parameter `store`: An SCDynamicStoreRef representing the dynamic store
    /// session that should be used for communication with the server.
    /// If NULL, a temporary session will be used.
    ///
    /// Returns: Returns the current local host name;
    /// NULL if the name has not been set or if an error was encountered.
    /// You must release the returned value.
    #[doc(alias = "SCDynamicStoreCopyLocalHostName")]
    #[cfg(feature = "SCDynamicStore")]
    #[inline]
    pub fn local_host_name(store: Option<&SCDynamicStore>) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn SCDynamicStoreCopyLocalHostName(
                store: Option<&SCDynamicStore>,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { SCDynamicStoreCopyLocalHostName(store) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Gets the current location identifier.
    ///
    /// Parameter `store`: An SCDynamicStoreRef representing the dynamic store
    /// session that should be used for communication with the server.
    /// If NULL, a temporary session will be used.
    ///
    /// Returns: Returns a string representing the current location identifier;
    /// NULL if no location identifier has been defined or if an error
    /// was encountered.
    /// You must release the returned value.
    #[doc(alias = "SCDynamicStoreCopyLocation")]
    #[cfg(feature = "SCDynamicStore")]
    #[inline]
    pub fn location(store: Option<&SCDynamicStore>) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn SCDynamicStoreCopyLocation(
                store: Option<&SCDynamicStore>,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { SCDynamicStoreCopyLocation(store) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Gets the current internet proxy settings.
    /// The returned proxy settings dictionary includes:
    ///
    /// <TABLE
    /// BORDER>
    /// <TR
    /// >
    /// <TH
    /// >key
    /// </TD
    /// >
    /// <TH
    /// >type
    /// </TD
    /// >
    /// <TH
    /// >description
    /// </TD
    /// >
    /// </TR
    /// >
    /// <TR
    /// >
    /// <TD
    /// >kSCPropNetProxiesExceptionsList
    /// </TD
    /// >
    /// <TD
    /// >CFArray[CFString]
    /// </TD
    /// >
    /// <TD
    /// >Host name patterns which should bypass the proxy
    /// </TD
    /// >
    /// </TR
    /// >
    /// <TR
    /// >
    /// <TD
    /// >kSCPropNetProxiesHTTPEnable
    /// </TD
    /// >
    /// <TD
    /// >CFNumber (0 or 1)
    /// </TD
    /// >
    /// <TD
    /// >Enables/disables the use of an HTTP proxy
    /// </TD
    /// >
    /// </TR
    /// >
    /// <TR
    /// >
    /// <TD
    /// >kSCPropNetProxiesHTTPProxy
    /// </TD
    /// >
    /// <TD
    /// >CFString
    /// </TD
    /// >
    /// <TD
    /// >The proxy host
    /// </TD
    /// >
    /// </TR
    /// >
    /// <TR
    /// >
    /// <TD
    /// >kSCPropNetProxiesHTTPPort
    /// </TD
    /// >
    /// <TD
    /// >CFNumber
    /// </TD
    /// >
    /// <TD
    /// >The proxy port number
    /// </TD
    /// >
    /// </TR
    /// >
    /// <TR
    /// >
    /// <TD
    /// >kSCPropNetProxiesHTTPSEnable
    /// </TD
    /// >
    /// <TD
    /// >CFNumber (0 or 1)
    /// </TD
    /// >
    /// <TD
    /// >Enables/disables the use of an HTTPS proxy
    /// </TD
    /// >
    /// </TR
    /// >
    /// <TR
    /// >
    /// <TD
    /// >kSCPropNetProxiesHTTPSProxy
    /// </TD
    /// >
    /// <TD
    /// >CFString
    /// </TD
    /// >
    /// <TD
    /// >The proxy host
    /// </TD
    /// >
    /// </TR
    /// >
    /// <TR
    /// >
    /// <TD
    /// >kSCPropNetProxiesHTTPSPort
    /// </TD
    /// >
    /// <TD
    /// >CFNumber
    /// </TD
    /// >
    /// <TD
    /// >The proxy port number
    /// </TD
    /// >
    /// </TR
    /// >
    /// <TR
    /// >
    /// <TD
    /// >kSCPropNetProxiesFTPEnable
    /// </TD
    /// >
    /// <TD
    /// >CFNumber (0 or 1)
    /// </TD
    /// >
    /// <TD
    /// >Enables/disables the use of an FTP proxy
    /// </TD
    /// >
    /// </TR
    /// >
    /// <TR
    /// >
    /// <TD
    /// >kSCPropNetProxiesFTPProxy
    /// </TD
    /// >
    /// <TD
    /// >CFString
    /// </TD
    /// >
    /// <TD
    /// >The proxy host
    /// </TD
    /// >
    /// </TR
    /// >
    /// <TR
    /// >
    /// <TD
    /// >kSCPropNetProxiesFTPPort
    /// </TD
    /// >
    /// <TD
    /// >CFNumber
    /// </TD
    /// >
    /// <TD
    /// >The proxy port number
    /// </TD
    /// >
    /// </TR
    /// >
    /// <TR
    /// >
    /// <TD
    /// >kSCPropNetProxiesFTPPassive
    /// </TD
    /// >
    /// <TD
    /// >CFNumber (0 or 1)
    /// </TD
    /// >
    /// <TD
    /// >Enable passive mode operation for use behind connection
    /// filter-ing firewalls.
    /// </TD
    /// >
    /// </TR
    /// >
    /// </TABLE
    /// >
    ///
    /// Other key-value pairs are defined in the SCSchemaDefinitions.h
    /// header file.
    ///
    /// Parameter `store`: An SCDynamicStoreRef representing the dynamic store
    /// session that should be used for communication with the server.
    /// If NULL, a temporary session will be used.
    ///
    /// Returns: Returns a dictionary containing key-value pairs that represent
    /// the current internet proxy settings;
    /// NULL if no proxy settings have been defined or if an error
    /// was encountered.
    /// You must release the returned value.
    #[doc(alias = "SCDynamicStoreCopyProxies")]
    #[cfg(feature = "SCDynamicStore")]
    #[inline]
    pub fn proxies(store: Option<&SCDynamicStore>) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn SCDynamicStoreCopyProxies(
                store: Option<&SCDynamicStore>,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { SCDynamicStoreCopyProxies(store) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

#[cfg(feature = "SCDynamicStore")]
#[deprecated = "renamed to `SCDynamicStore::computer_name`"]
#[inline]
pub unsafe extern "C-unwind" fn SCDynamicStoreCopyComputerName(
    store: Option<&SCDynamicStore>,
    name_encoding: *mut CFStringEncoding,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn SCDynamicStoreCopyComputerName(
            store: Option<&SCDynamicStore>,
            name_encoding: *mut CFStringEncoding,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { SCDynamicStoreCopyComputerName(store, name_encoding) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "SCDynamicStore", feature = "libc"))]
#[deprecated = "renamed to `SCDynamicStore::console_user`"]
#[inline]
pub unsafe extern "C-unwind" fn SCDynamicStoreCopyConsoleUser(
    store: Option<&SCDynamicStore>,
    uid: *mut libc::uid_t,
    gid: *mut libc::gid_t,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn SCDynamicStoreCopyConsoleUser(
            store: Option<&SCDynamicStore>,
            uid: *mut libc::uid_t,
            gid: *mut libc::gid_t,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { SCDynamicStoreCopyConsoleUser(store, uid, gid) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "SCDynamicStore")]
#[deprecated = "renamed to `SCDynamicStore::local_host_name`"]
#[inline]
pub extern "C-unwind" fn SCDynamicStoreCopyLocalHostName(
    store: Option<&SCDynamicStore>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn SCDynamicStoreCopyLocalHostName(
            store: Option<&SCDynamicStore>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { SCDynamicStoreCopyLocalHostName(store) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "SCDynamicStore")]
#[deprecated = "renamed to `SCDynamicStore::location`"]
#[inline]
pub extern "C-unwind" fn SCDynamicStoreCopyLocation(
    store: Option<&SCDynamicStore>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn SCDynamicStoreCopyLocation(store: Option<&SCDynamicStore>) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { SCDynamicStoreCopyLocation(store) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "SCDynamicStore")]
#[deprecated = "renamed to `SCDynamicStore::proxies`"]
#[inline]
pub extern "C-unwind" fn SCDynamicStoreCopyProxies(
    store: Option<&SCDynamicStore>,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn SCDynamicStoreCopyProxies(
            store: Option<&SCDynamicStore>,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { SCDynamicStoreCopyProxies(store) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}
