/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.DefaultDocletTagFactory;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.DocletTagFactory;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassParent;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import com.thoughtworks.qdox.parser.Builder;
import com.thoughtworks.qdox.parser.structs.ClassDef;
import com.thoughtworks.qdox.parser.structs.FieldDef;
import com.thoughtworks.qdox.parser.structs.MethodDef;
import com.thoughtworks.qdox.parser.structs.TagDef;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ModelBuilder
implements Builder {
    private final ClassLibrary classLibrary;
    private final JavaSource source;
    private JavaClassParent currentParent;
    private JavaClass currentClass;
    private String lastComment;
    private List lastTagSet;
    private DocletTagFactory docletTagFactory;

    public ModelBuilder() {
        this(new ClassLibrary(null), new DefaultDocletTagFactory());
    }

    public ModelBuilder(ClassLibrary classLibrary, DocletTagFactory docletTagFactory) {
        this.classLibrary = classLibrary;
        this.docletTagFactory = docletTagFactory;
        this.source = new JavaSource();
        this.source.setClassLibrary(classLibrary);
        this.currentParent = this.source;
    }

    public void addPackage(String packageName) {
        this.source.setPackage(packageName);
    }

    public void addImport(String importName) {
        this.source.addImport(importName);
    }

    public void addJavaDoc(String text) {
        this.lastComment = text;
        this.lastTagSet = new LinkedList();
    }

    public void addJavaDocTag(TagDef tagDef) {
        this.lastTagSet.add(tagDef);
    }

    public void beginClass(ClassDef def) {
        this.currentClass = new JavaClass(this.currentParent, def.lineNumber);
        this.currentClass.setName(def.name);
        this.currentClass.setInterface(def.isInterface);
        if (def.isInterface) {
            this.currentClass.setSuperClass(null);
        } else {
            this.currentClass.setSuperClass(def.extendz.size() > 0 ? this.createType((String)def.extendz.toArray()[0], 0) : null);
        }
        Set implementSet = def.isInterface ? def.extendz : def.implementz;
        Iterator implementIt = implementSet.iterator();
        Type[] implementz = new Type[implementSet.size()];
        for (int i = 0; i < implementz.length && implementIt.hasNext(); ++i) {
            implementz[i] = this.createType((String)implementIt.next(), 0);
        }
        this.currentClass.setImplementz(implementz);
        String[] modifiers = new String[def.modifiers.size()];
        def.modifiers.toArray(modifiers);
        this.currentClass.setModifiers(modifiers);
        this.addJavaDoc(this.currentClass);
        this.currentParent.addClass(this.currentClass);
        this.currentParent = this.currentClass;
        this.classLibrary.add(this.currentClass.getFullyQualifiedName());
    }

    public void endClass() {
        this.currentParent = this.currentClass.getParent();
        this.currentClass = this.currentParent instanceof JavaClass ? (JavaClass)this.currentParent : null;
    }

    private Type createType(String typeName, int dimensions) {
        if (typeName == null || typeName.equals("")) {
            return null;
        }
        return Type.createUnresolved(typeName, dimensions, this.currentClass);
    }

    private void addJavaDoc(AbstractJavaEntity entity) {
        if (this.lastComment == null) {
            return;
        }
        entity.setComment(this.lastComment);
        Iterator tagDefIterator = this.lastTagSet.iterator();
        ArrayList<DocletTag> tagList = new ArrayList<DocletTag>();
        while (tagDefIterator.hasNext()) {
            TagDef tagDef = (TagDef)tagDefIterator.next();
            tagList.add(this.docletTagFactory.createDocletTag(tagDef.name, tagDef.text, entity, tagDef.lineNumber));
        }
        entity.setTags(tagList);
        this.lastComment = null;
    }

    public void addMethod(MethodDef def) {
        JavaMethod currentMethod = new JavaMethod(this.currentClass, def.lineNumber);
        currentMethod.setName(def.name);
        currentMethod.setReturns(this.createType(def.returns, def.dimensions));
        currentMethod.setConstructor(def.constructor);
        JavaParameter[] params = new JavaParameter[def.params.size()];
        int i = 0;
        Iterator iterator = def.params.iterator();
        while (iterator.hasNext()) {
            FieldDef fieldDef = (FieldDef)iterator.next();
            params[i++] = new JavaParameter(this.createType(fieldDef.type, fieldDef.dimensions), fieldDef.name);
        }
        currentMethod.setParameters(params);
        Type[] exceptions = new Type[def.exceptions.size()];
        int index = 0;
        Iterator iter = def.exceptions.iterator();
        while (iter.hasNext()) {
            exceptions[index++] = this.createType((String)iter.next(), 0);
        }
        currentMethod.setExceptions(exceptions);
        String[] modifiers = new String[def.modifiers.size()];
        def.modifiers.toArray(modifiers);
        currentMethod.setModifiers(modifiers);
        this.addJavaDoc(currentMethod);
        this.currentClass.addMethod(currentMethod);
    }

    public void addField(FieldDef def) {
        JavaField currentField = new JavaField(this.currentClass, def.lineNumber);
        currentField.setName(def.name);
        currentField.setType(this.createType(def.type, def.dimensions));
        String[] modifiers = new String[def.modifiers.size()];
        def.modifiers.toArray(modifiers);
        currentField.setModifiers(modifiers);
        this.addJavaDoc(currentField);
        this.currentClass.addField(currentField);
    }

    public JavaSource getSource() {
        return this.source;
    }
}

