﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/application-signals/model/Node.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace ApplicationSignals {
namespace Model {

Node::Node(JsonView jsonValue) { *this = jsonValue; }

Node& Node::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("KeyAttributes")) {
    Aws::Map<Aws::String, JsonView> keyAttributesJsonMap = jsonValue.GetObject("KeyAttributes").GetAllObjects();
    for (auto& keyAttributesItem : keyAttributesJsonMap) {
      m_keyAttributes[keyAttributesItem.first] = keyAttributesItem.second.AsString();
    }
    m_keyAttributesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Name")) {
    m_name = jsonValue.GetString("Name");
    m_nameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NodeId")) {
    m_nodeId = jsonValue.GetString("NodeId");
    m_nodeIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Operation")) {
    m_operation = jsonValue.GetString("Operation");
    m_operationHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Type")) {
    m_type = jsonValue.GetString("Type");
    m_typeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Duration")) {
    m_duration = jsonValue.GetDouble("Duration");
    m_durationHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Status")) {
    m_status = jsonValue.GetString("Status");
    m_statusHasBeenSet = true;
  }
  return *this;
}

JsonValue Node::Jsonize() const {
  JsonValue payload;

  if (m_keyAttributesHasBeenSet) {
    JsonValue keyAttributesJsonMap;
    for (auto& keyAttributesItem : m_keyAttributes) {
      keyAttributesJsonMap.WithString(keyAttributesItem.first, keyAttributesItem.second);
    }
    payload.WithObject("KeyAttributes", std::move(keyAttributesJsonMap));
  }

  if (m_nameHasBeenSet) {
    payload.WithString("Name", m_name);
  }

  if (m_nodeIdHasBeenSet) {
    payload.WithString("NodeId", m_nodeId);
  }

  if (m_operationHasBeenSet) {
    payload.WithString("Operation", m_operation);
  }

  if (m_typeHasBeenSet) {
    payload.WithString("Type", m_type);
  }

  if (m_durationHasBeenSet) {
    payload.WithDouble("Duration", m_duration);
  }

  if (m_statusHasBeenSet) {
    payload.WithString("Status", m_status);
  }

  return payload;
}

}  // namespace Model
}  // namespace ApplicationSignals
}  // namespace Aws
