﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/chime-sdk-meetings/model/CreateAttendeeError.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace ChimeSDKMeetings {
namespace Model {

CreateAttendeeError::CreateAttendeeError(JsonView jsonValue) { *this = jsonValue; }

CreateAttendeeError& CreateAttendeeError::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("ExternalUserId")) {
    m_externalUserId = jsonValue.GetString("ExternalUserId");
    m_externalUserIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ErrorCode")) {
    m_errorCode = jsonValue.GetString("ErrorCode");
    m_errorCodeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ErrorMessage")) {
    m_errorMessage = jsonValue.GetString("ErrorMessage");
    m_errorMessageHasBeenSet = true;
  }
  return *this;
}

JsonValue CreateAttendeeError::Jsonize() const {
  JsonValue payload;

  if (m_externalUserIdHasBeenSet) {
    payload.WithString("ExternalUserId", m_externalUserId);
  }

  if (m_errorCodeHasBeenSet) {
    payload.WithString("ErrorCode", m_errorCode);
  }

  if (m_errorMessageHasBeenSet) {
    payload.WithString("ErrorMessage", m_errorMessage);
  }

  return payload;
}

}  // namespace Model
}  // namespace ChimeSDKMeetings
}  // namespace Aws
