//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1beta2

import (
	unsafe "unsafe"

	corev1 "k8s.io/api/core/v1"
	v1 "k8s.io/api/resource/v1"
	resourcev1beta2 "k8s.io/api/resource/v1beta2"
	resource "k8s.io/apimachinery/pkg/api/resource"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	types "k8s.io/apimachinery/pkg/types"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*v1.AllocatedDeviceStatus)(nil), (*resourcev1beta2.AllocatedDeviceStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_AllocatedDeviceStatus_To_v1beta2_AllocatedDeviceStatus(a.(*v1.AllocatedDeviceStatus), b.(*resourcev1beta2.AllocatedDeviceStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.AllocatedDeviceStatus)(nil), (*v1.AllocatedDeviceStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_AllocatedDeviceStatus_To_v1_AllocatedDeviceStatus(a.(*resourcev1beta2.AllocatedDeviceStatus), b.(*v1.AllocatedDeviceStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.AllocationResult)(nil), (*resourcev1beta2.AllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_AllocationResult_To_v1beta2_AllocationResult(a.(*v1.AllocationResult), b.(*resourcev1beta2.AllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.AllocationResult)(nil), (*v1.AllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_AllocationResult_To_v1_AllocationResult(a.(*resourcev1beta2.AllocationResult), b.(*v1.AllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.CELDeviceSelector)(nil), (*resourcev1beta2.CELDeviceSelector)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CELDeviceSelector_To_v1beta2_CELDeviceSelector(a.(*v1.CELDeviceSelector), b.(*resourcev1beta2.CELDeviceSelector), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.CELDeviceSelector)(nil), (*v1.CELDeviceSelector)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_CELDeviceSelector_To_v1_CELDeviceSelector(a.(*resourcev1beta2.CELDeviceSelector), b.(*v1.CELDeviceSelector), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.CapacityRequestPolicy)(nil), (*resourcev1beta2.CapacityRequestPolicy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CapacityRequestPolicy_To_v1beta2_CapacityRequestPolicy(a.(*v1.CapacityRequestPolicy), b.(*resourcev1beta2.CapacityRequestPolicy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.CapacityRequestPolicy)(nil), (*v1.CapacityRequestPolicy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_CapacityRequestPolicy_To_v1_CapacityRequestPolicy(a.(*resourcev1beta2.CapacityRequestPolicy), b.(*v1.CapacityRequestPolicy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.CapacityRequestPolicyRange)(nil), (*resourcev1beta2.CapacityRequestPolicyRange)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CapacityRequestPolicyRange_To_v1beta2_CapacityRequestPolicyRange(a.(*v1.CapacityRequestPolicyRange), b.(*resourcev1beta2.CapacityRequestPolicyRange), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.CapacityRequestPolicyRange)(nil), (*v1.CapacityRequestPolicyRange)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_CapacityRequestPolicyRange_To_v1_CapacityRequestPolicyRange(a.(*resourcev1beta2.CapacityRequestPolicyRange), b.(*v1.CapacityRequestPolicyRange), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.CapacityRequirements)(nil), (*resourcev1beta2.CapacityRequirements)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CapacityRequirements_To_v1beta2_CapacityRequirements(a.(*v1.CapacityRequirements), b.(*resourcev1beta2.CapacityRequirements), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.CapacityRequirements)(nil), (*v1.CapacityRequirements)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_CapacityRequirements_To_v1_CapacityRequirements(a.(*resourcev1beta2.CapacityRequirements), b.(*v1.CapacityRequirements), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.Counter)(nil), (*resourcev1beta2.Counter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_Counter_To_v1beta2_Counter(a.(*v1.Counter), b.(*resourcev1beta2.Counter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.Counter)(nil), (*v1.Counter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_Counter_To_v1_Counter(a.(*resourcev1beta2.Counter), b.(*v1.Counter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.CounterSet)(nil), (*resourcev1beta2.CounterSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CounterSet_To_v1beta2_CounterSet(a.(*v1.CounterSet), b.(*resourcev1beta2.CounterSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.CounterSet)(nil), (*v1.CounterSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_CounterSet_To_v1_CounterSet(a.(*resourcev1beta2.CounterSet), b.(*v1.CounterSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.Device)(nil), (*resourcev1beta2.Device)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_Device_To_v1beta2_Device(a.(*v1.Device), b.(*resourcev1beta2.Device), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.Device)(nil), (*v1.Device)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_Device_To_v1_Device(a.(*resourcev1beta2.Device), b.(*v1.Device), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceAllocationConfiguration)(nil), (*resourcev1beta2.DeviceAllocationConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceAllocationConfiguration_To_v1beta2_DeviceAllocationConfiguration(a.(*v1.DeviceAllocationConfiguration), b.(*resourcev1beta2.DeviceAllocationConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.DeviceAllocationConfiguration)(nil), (*v1.DeviceAllocationConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DeviceAllocationConfiguration_To_v1_DeviceAllocationConfiguration(a.(*resourcev1beta2.DeviceAllocationConfiguration), b.(*v1.DeviceAllocationConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceAllocationResult)(nil), (*resourcev1beta2.DeviceAllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceAllocationResult_To_v1beta2_DeviceAllocationResult(a.(*v1.DeviceAllocationResult), b.(*resourcev1beta2.DeviceAllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.DeviceAllocationResult)(nil), (*v1.DeviceAllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DeviceAllocationResult_To_v1_DeviceAllocationResult(a.(*resourcev1beta2.DeviceAllocationResult), b.(*v1.DeviceAllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceAttribute)(nil), (*resourcev1beta2.DeviceAttribute)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceAttribute_To_v1beta2_DeviceAttribute(a.(*v1.DeviceAttribute), b.(*resourcev1beta2.DeviceAttribute), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.DeviceAttribute)(nil), (*v1.DeviceAttribute)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DeviceAttribute_To_v1_DeviceAttribute(a.(*resourcev1beta2.DeviceAttribute), b.(*v1.DeviceAttribute), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceCapacity)(nil), (*resourcev1beta2.DeviceCapacity)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceCapacity_To_v1beta2_DeviceCapacity(a.(*v1.DeviceCapacity), b.(*resourcev1beta2.DeviceCapacity), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.DeviceCapacity)(nil), (*v1.DeviceCapacity)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DeviceCapacity_To_v1_DeviceCapacity(a.(*resourcev1beta2.DeviceCapacity), b.(*v1.DeviceCapacity), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceClaim)(nil), (*resourcev1beta2.DeviceClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceClaim_To_v1beta2_DeviceClaim(a.(*v1.DeviceClaim), b.(*resourcev1beta2.DeviceClaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.DeviceClaim)(nil), (*v1.DeviceClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DeviceClaim_To_v1_DeviceClaim(a.(*resourcev1beta2.DeviceClaim), b.(*v1.DeviceClaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceClaimConfiguration)(nil), (*resourcev1beta2.DeviceClaimConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceClaimConfiguration_To_v1beta2_DeviceClaimConfiguration(a.(*v1.DeviceClaimConfiguration), b.(*resourcev1beta2.DeviceClaimConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.DeviceClaimConfiguration)(nil), (*v1.DeviceClaimConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DeviceClaimConfiguration_To_v1_DeviceClaimConfiguration(a.(*resourcev1beta2.DeviceClaimConfiguration), b.(*v1.DeviceClaimConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceClass)(nil), (*resourcev1beta2.DeviceClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceClass_To_v1beta2_DeviceClass(a.(*v1.DeviceClass), b.(*resourcev1beta2.DeviceClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.DeviceClass)(nil), (*v1.DeviceClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DeviceClass_To_v1_DeviceClass(a.(*resourcev1beta2.DeviceClass), b.(*v1.DeviceClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceClassConfiguration)(nil), (*resourcev1beta2.DeviceClassConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceClassConfiguration_To_v1beta2_DeviceClassConfiguration(a.(*v1.DeviceClassConfiguration), b.(*resourcev1beta2.DeviceClassConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.DeviceClassConfiguration)(nil), (*v1.DeviceClassConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DeviceClassConfiguration_To_v1_DeviceClassConfiguration(a.(*resourcev1beta2.DeviceClassConfiguration), b.(*v1.DeviceClassConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceClassList)(nil), (*resourcev1beta2.DeviceClassList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceClassList_To_v1beta2_DeviceClassList(a.(*v1.DeviceClassList), b.(*resourcev1beta2.DeviceClassList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.DeviceClassList)(nil), (*v1.DeviceClassList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DeviceClassList_To_v1_DeviceClassList(a.(*resourcev1beta2.DeviceClassList), b.(*v1.DeviceClassList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceClassSpec)(nil), (*resourcev1beta2.DeviceClassSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceClassSpec_To_v1beta2_DeviceClassSpec(a.(*v1.DeviceClassSpec), b.(*resourcev1beta2.DeviceClassSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.DeviceClassSpec)(nil), (*v1.DeviceClassSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DeviceClassSpec_To_v1_DeviceClassSpec(a.(*resourcev1beta2.DeviceClassSpec), b.(*v1.DeviceClassSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceConfiguration)(nil), (*resourcev1beta2.DeviceConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceConfiguration_To_v1beta2_DeviceConfiguration(a.(*v1.DeviceConfiguration), b.(*resourcev1beta2.DeviceConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.DeviceConfiguration)(nil), (*v1.DeviceConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DeviceConfiguration_To_v1_DeviceConfiguration(a.(*resourcev1beta2.DeviceConfiguration), b.(*v1.DeviceConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceConstraint)(nil), (*resourcev1beta2.DeviceConstraint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceConstraint_To_v1beta2_DeviceConstraint(a.(*v1.DeviceConstraint), b.(*resourcev1beta2.DeviceConstraint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.DeviceConstraint)(nil), (*v1.DeviceConstraint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DeviceConstraint_To_v1_DeviceConstraint(a.(*resourcev1beta2.DeviceConstraint), b.(*v1.DeviceConstraint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceCounterConsumption)(nil), (*resourcev1beta2.DeviceCounterConsumption)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceCounterConsumption_To_v1beta2_DeviceCounterConsumption(a.(*v1.DeviceCounterConsumption), b.(*resourcev1beta2.DeviceCounterConsumption), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.DeviceCounterConsumption)(nil), (*v1.DeviceCounterConsumption)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DeviceCounterConsumption_To_v1_DeviceCounterConsumption(a.(*resourcev1beta2.DeviceCounterConsumption), b.(*v1.DeviceCounterConsumption), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceRequest)(nil), (*resourcev1beta2.DeviceRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceRequest_To_v1beta2_DeviceRequest(a.(*v1.DeviceRequest), b.(*resourcev1beta2.DeviceRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.DeviceRequest)(nil), (*v1.DeviceRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DeviceRequest_To_v1_DeviceRequest(a.(*resourcev1beta2.DeviceRequest), b.(*v1.DeviceRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceRequestAllocationResult)(nil), (*resourcev1beta2.DeviceRequestAllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceRequestAllocationResult_To_v1beta2_DeviceRequestAllocationResult(a.(*v1.DeviceRequestAllocationResult), b.(*resourcev1beta2.DeviceRequestAllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.DeviceRequestAllocationResult)(nil), (*v1.DeviceRequestAllocationResult)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DeviceRequestAllocationResult_To_v1_DeviceRequestAllocationResult(a.(*resourcev1beta2.DeviceRequestAllocationResult), b.(*v1.DeviceRequestAllocationResult), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceSelector)(nil), (*resourcev1beta2.DeviceSelector)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceSelector_To_v1beta2_DeviceSelector(a.(*v1.DeviceSelector), b.(*resourcev1beta2.DeviceSelector), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.DeviceSelector)(nil), (*v1.DeviceSelector)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DeviceSelector_To_v1_DeviceSelector(a.(*resourcev1beta2.DeviceSelector), b.(*v1.DeviceSelector), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceSubRequest)(nil), (*resourcev1beta2.DeviceSubRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceSubRequest_To_v1beta2_DeviceSubRequest(a.(*v1.DeviceSubRequest), b.(*resourcev1beta2.DeviceSubRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.DeviceSubRequest)(nil), (*v1.DeviceSubRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DeviceSubRequest_To_v1_DeviceSubRequest(a.(*resourcev1beta2.DeviceSubRequest), b.(*v1.DeviceSubRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceTaint)(nil), (*resourcev1beta2.DeviceTaint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceTaint_To_v1beta2_DeviceTaint(a.(*v1.DeviceTaint), b.(*resourcev1beta2.DeviceTaint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.DeviceTaint)(nil), (*v1.DeviceTaint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DeviceTaint_To_v1_DeviceTaint(a.(*resourcev1beta2.DeviceTaint), b.(*v1.DeviceTaint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeviceToleration)(nil), (*resourcev1beta2.DeviceToleration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeviceToleration_To_v1beta2_DeviceToleration(a.(*v1.DeviceToleration), b.(*resourcev1beta2.DeviceToleration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.DeviceToleration)(nil), (*v1.DeviceToleration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_DeviceToleration_To_v1_DeviceToleration(a.(*resourcev1beta2.DeviceToleration), b.(*v1.DeviceToleration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ExactDeviceRequest)(nil), (*resourcev1beta2.ExactDeviceRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ExactDeviceRequest_To_v1beta2_ExactDeviceRequest(a.(*v1.ExactDeviceRequest), b.(*resourcev1beta2.ExactDeviceRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.ExactDeviceRequest)(nil), (*v1.ExactDeviceRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_ExactDeviceRequest_To_v1_ExactDeviceRequest(a.(*resourcev1beta2.ExactDeviceRequest), b.(*v1.ExactDeviceRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.NetworkDeviceData)(nil), (*resourcev1beta2.NetworkDeviceData)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_NetworkDeviceData_To_v1beta2_NetworkDeviceData(a.(*v1.NetworkDeviceData), b.(*resourcev1beta2.NetworkDeviceData), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.NetworkDeviceData)(nil), (*v1.NetworkDeviceData)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_NetworkDeviceData_To_v1_NetworkDeviceData(a.(*resourcev1beta2.NetworkDeviceData), b.(*v1.NetworkDeviceData), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.OpaqueDeviceConfiguration)(nil), (*resourcev1beta2.OpaqueDeviceConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_OpaqueDeviceConfiguration_To_v1beta2_OpaqueDeviceConfiguration(a.(*v1.OpaqueDeviceConfiguration), b.(*resourcev1beta2.OpaqueDeviceConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.OpaqueDeviceConfiguration)(nil), (*v1.OpaqueDeviceConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_OpaqueDeviceConfiguration_To_v1_OpaqueDeviceConfiguration(a.(*resourcev1beta2.OpaqueDeviceConfiguration), b.(*v1.OpaqueDeviceConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ResourceClaim)(nil), (*resourcev1beta2.ResourceClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ResourceClaim_To_v1beta2_ResourceClaim(a.(*v1.ResourceClaim), b.(*resourcev1beta2.ResourceClaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.ResourceClaim)(nil), (*v1.ResourceClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_ResourceClaim_To_v1_ResourceClaim(a.(*resourcev1beta2.ResourceClaim), b.(*v1.ResourceClaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ResourceClaimConsumerReference)(nil), (*resourcev1beta2.ResourceClaimConsumerReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ResourceClaimConsumerReference_To_v1beta2_ResourceClaimConsumerReference(a.(*v1.ResourceClaimConsumerReference), b.(*resourcev1beta2.ResourceClaimConsumerReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.ResourceClaimConsumerReference)(nil), (*v1.ResourceClaimConsumerReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_ResourceClaimConsumerReference_To_v1_ResourceClaimConsumerReference(a.(*resourcev1beta2.ResourceClaimConsumerReference), b.(*v1.ResourceClaimConsumerReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ResourceClaimList)(nil), (*resourcev1beta2.ResourceClaimList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ResourceClaimList_To_v1beta2_ResourceClaimList(a.(*v1.ResourceClaimList), b.(*resourcev1beta2.ResourceClaimList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.ResourceClaimList)(nil), (*v1.ResourceClaimList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_ResourceClaimList_To_v1_ResourceClaimList(a.(*resourcev1beta2.ResourceClaimList), b.(*v1.ResourceClaimList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ResourceClaimSpec)(nil), (*resourcev1beta2.ResourceClaimSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ResourceClaimSpec_To_v1beta2_ResourceClaimSpec(a.(*v1.ResourceClaimSpec), b.(*resourcev1beta2.ResourceClaimSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.ResourceClaimSpec)(nil), (*v1.ResourceClaimSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_ResourceClaimSpec_To_v1_ResourceClaimSpec(a.(*resourcev1beta2.ResourceClaimSpec), b.(*v1.ResourceClaimSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ResourceClaimStatus)(nil), (*resourcev1beta2.ResourceClaimStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ResourceClaimStatus_To_v1beta2_ResourceClaimStatus(a.(*v1.ResourceClaimStatus), b.(*resourcev1beta2.ResourceClaimStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.ResourceClaimStatus)(nil), (*v1.ResourceClaimStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_ResourceClaimStatus_To_v1_ResourceClaimStatus(a.(*resourcev1beta2.ResourceClaimStatus), b.(*v1.ResourceClaimStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ResourceClaimTemplate)(nil), (*resourcev1beta2.ResourceClaimTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ResourceClaimTemplate_To_v1beta2_ResourceClaimTemplate(a.(*v1.ResourceClaimTemplate), b.(*resourcev1beta2.ResourceClaimTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.ResourceClaimTemplate)(nil), (*v1.ResourceClaimTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_ResourceClaimTemplate_To_v1_ResourceClaimTemplate(a.(*resourcev1beta2.ResourceClaimTemplate), b.(*v1.ResourceClaimTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ResourceClaimTemplateList)(nil), (*resourcev1beta2.ResourceClaimTemplateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ResourceClaimTemplateList_To_v1beta2_ResourceClaimTemplateList(a.(*v1.ResourceClaimTemplateList), b.(*resourcev1beta2.ResourceClaimTemplateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.ResourceClaimTemplateList)(nil), (*v1.ResourceClaimTemplateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_ResourceClaimTemplateList_To_v1_ResourceClaimTemplateList(a.(*resourcev1beta2.ResourceClaimTemplateList), b.(*v1.ResourceClaimTemplateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ResourceClaimTemplateSpec)(nil), (*resourcev1beta2.ResourceClaimTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ResourceClaimTemplateSpec_To_v1beta2_ResourceClaimTemplateSpec(a.(*v1.ResourceClaimTemplateSpec), b.(*resourcev1beta2.ResourceClaimTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.ResourceClaimTemplateSpec)(nil), (*v1.ResourceClaimTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_ResourceClaimTemplateSpec_To_v1_ResourceClaimTemplateSpec(a.(*resourcev1beta2.ResourceClaimTemplateSpec), b.(*v1.ResourceClaimTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ResourcePool)(nil), (*resourcev1beta2.ResourcePool)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ResourcePool_To_v1beta2_ResourcePool(a.(*v1.ResourcePool), b.(*resourcev1beta2.ResourcePool), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.ResourcePool)(nil), (*v1.ResourcePool)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_ResourcePool_To_v1_ResourcePool(a.(*resourcev1beta2.ResourcePool), b.(*v1.ResourcePool), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ResourceSlice)(nil), (*resourcev1beta2.ResourceSlice)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ResourceSlice_To_v1beta2_ResourceSlice(a.(*v1.ResourceSlice), b.(*resourcev1beta2.ResourceSlice), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.ResourceSlice)(nil), (*v1.ResourceSlice)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_ResourceSlice_To_v1_ResourceSlice(a.(*resourcev1beta2.ResourceSlice), b.(*v1.ResourceSlice), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ResourceSliceList)(nil), (*resourcev1beta2.ResourceSliceList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ResourceSliceList_To_v1beta2_ResourceSliceList(a.(*v1.ResourceSliceList), b.(*resourcev1beta2.ResourceSliceList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.ResourceSliceList)(nil), (*v1.ResourceSliceList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_ResourceSliceList_To_v1_ResourceSliceList(a.(*resourcev1beta2.ResourceSliceList), b.(*v1.ResourceSliceList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ResourceSliceSpec)(nil), (*resourcev1beta2.ResourceSliceSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ResourceSliceSpec_To_v1beta2_ResourceSliceSpec(a.(*v1.ResourceSliceSpec), b.(*resourcev1beta2.ResourceSliceSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*resourcev1beta2.ResourceSliceSpec)(nil), (*v1.ResourceSliceSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta2_ResourceSliceSpec_To_v1_ResourceSliceSpec(a.(*resourcev1beta2.ResourceSliceSpec), b.(*v1.ResourceSliceSpec), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1_AllocatedDeviceStatus_To_v1beta2_AllocatedDeviceStatus(in *v1.AllocatedDeviceStatus, out *resourcev1beta2.AllocatedDeviceStatus, s conversion.Scope) error {
	out.Driver = in.Driver
	out.Pool = in.Pool
	out.Device = in.Device
	out.ShareID = (*string)(unsafe.Pointer(in.ShareID))
	out.Conditions = *(*[]metav1.Condition)(unsafe.Pointer(&in.Conditions))
	out.Data = (*runtime.RawExtension)(unsafe.Pointer(in.Data))
	out.NetworkData = (*resourcev1beta2.NetworkDeviceData)(unsafe.Pointer(in.NetworkData))
	return nil
}

// Convert_v1_AllocatedDeviceStatus_To_v1beta2_AllocatedDeviceStatus is an autogenerated conversion function.
func Convert_v1_AllocatedDeviceStatus_To_v1beta2_AllocatedDeviceStatus(in *v1.AllocatedDeviceStatus, out *resourcev1beta2.AllocatedDeviceStatus, s conversion.Scope) error {
	return autoConvert_v1_AllocatedDeviceStatus_To_v1beta2_AllocatedDeviceStatus(in, out, s)
}

func autoConvert_v1beta2_AllocatedDeviceStatus_To_v1_AllocatedDeviceStatus(in *resourcev1beta2.AllocatedDeviceStatus, out *v1.AllocatedDeviceStatus, s conversion.Scope) error {
	out.Driver = in.Driver
	out.Pool = in.Pool
	out.Device = in.Device
	out.ShareID = (*string)(unsafe.Pointer(in.ShareID))
	out.Conditions = *(*[]metav1.Condition)(unsafe.Pointer(&in.Conditions))
	out.Data = (*runtime.RawExtension)(unsafe.Pointer(in.Data))
	out.NetworkData = (*v1.NetworkDeviceData)(unsafe.Pointer(in.NetworkData))
	return nil
}

// Convert_v1beta2_AllocatedDeviceStatus_To_v1_AllocatedDeviceStatus is an autogenerated conversion function.
func Convert_v1beta2_AllocatedDeviceStatus_To_v1_AllocatedDeviceStatus(in *resourcev1beta2.AllocatedDeviceStatus, out *v1.AllocatedDeviceStatus, s conversion.Scope) error {
	return autoConvert_v1beta2_AllocatedDeviceStatus_To_v1_AllocatedDeviceStatus(in, out, s)
}

func autoConvert_v1_AllocationResult_To_v1beta2_AllocationResult(in *v1.AllocationResult, out *resourcev1beta2.AllocationResult, s conversion.Scope) error {
	if err := Convert_v1_DeviceAllocationResult_To_v1beta2_DeviceAllocationResult(&in.Devices, &out.Devices, s); err != nil {
		return err
	}
	out.NodeSelector = (*corev1.NodeSelector)(unsafe.Pointer(in.NodeSelector))
	out.AllocationTimestamp = (*metav1.Time)(unsafe.Pointer(in.AllocationTimestamp))
	return nil
}

// Convert_v1_AllocationResult_To_v1beta2_AllocationResult is an autogenerated conversion function.
func Convert_v1_AllocationResult_To_v1beta2_AllocationResult(in *v1.AllocationResult, out *resourcev1beta2.AllocationResult, s conversion.Scope) error {
	return autoConvert_v1_AllocationResult_To_v1beta2_AllocationResult(in, out, s)
}

func autoConvert_v1beta2_AllocationResult_To_v1_AllocationResult(in *resourcev1beta2.AllocationResult, out *v1.AllocationResult, s conversion.Scope) error {
	if err := Convert_v1beta2_DeviceAllocationResult_To_v1_DeviceAllocationResult(&in.Devices, &out.Devices, s); err != nil {
		return err
	}
	out.NodeSelector = (*corev1.NodeSelector)(unsafe.Pointer(in.NodeSelector))
	out.AllocationTimestamp = (*metav1.Time)(unsafe.Pointer(in.AllocationTimestamp))
	return nil
}

// Convert_v1beta2_AllocationResult_To_v1_AllocationResult is an autogenerated conversion function.
func Convert_v1beta2_AllocationResult_To_v1_AllocationResult(in *resourcev1beta2.AllocationResult, out *v1.AllocationResult, s conversion.Scope) error {
	return autoConvert_v1beta2_AllocationResult_To_v1_AllocationResult(in, out, s)
}

func autoConvert_v1_CELDeviceSelector_To_v1beta2_CELDeviceSelector(in *v1.CELDeviceSelector, out *resourcev1beta2.CELDeviceSelector, s conversion.Scope) error {
	out.Expression = in.Expression
	return nil
}

// Convert_v1_CELDeviceSelector_To_v1beta2_CELDeviceSelector is an autogenerated conversion function.
func Convert_v1_CELDeviceSelector_To_v1beta2_CELDeviceSelector(in *v1.CELDeviceSelector, out *resourcev1beta2.CELDeviceSelector, s conversion.Scope) error {
	return autoConvert_v1_CELDeviceSelector_To_v1beta2_CELDeviceSelector(in, out, s)
}

func autoConvert_v1beta2_CELDeviceSelector_To_v1_CELDeviceSelector(in *resourcev1beta2.CELDeviceSelector, out *v1.CELDeviceSelector, s conversion.Scope) error {
	out.Expression = in.Expression
	return nil
}

// Convert_v1beta2_CELDeviceSelector_To_v1_CELDeviceSelector is an autogenerated conversion function.
func Convert_v1beta2_CELDeviceSelector_To_v1_CELDeviceSelector(in *resourcev1beta2.CELDeviceSelector, out *v1.CELDeviceSelector, s conversion.Scope) error {
	return autoConvert_v1beta2_CELDeviceSelector_To_v1_CELDeviceSelector(in, out, s)
}

func autoConvert_v1_CapacityRequestPolicy_To_v1beta2_CapacityRequestPolicy(in *v1.CapacityRequestPolicy, out *resourcev1beta2.CapacityRequestPolicy, s conversion.Scope) error {
	out.Default = (*resource.Quantity)(unsafe.Pointer(in.Default))
	out.ValidValues = *(*[]resource.Quantity)(unsafe.Pointer(&in.ValidValues))
	out.ValidRange = (*resourcev1beta2.CapacityRequestPolicyRange)(unsafe.Pointer(in.ValidRange))
	return nil
}

// Convert_v1_CapacityRequestPolicy_To_v1beta2_CapacityRequestPolicy is an autogenerated conversion function.
func Convert_v1_CapacityRequestPolicy_To_v1beta2_CapacityRequestPolicy(in *v1.CapacityRequestPolicy, out *resourcev1beta2.CapacityRequestPolicy, s conversion.Scope) error {
	return autoConvert_v1_CapacityRequestPolicy_To_v1beta2_CapacityRequestPolicy(in, out, s)
}

func autoConvert_v1beta2_CapacityRequestPolicy_To_v1_CapacityRequestPolicy(in *resourcev1beta2.CapacityRequestPolicy, out *v1.CapacityRequestPolicy, s conversion.Scope) error {
	out.Default = (*resource.Quantity)(unsafe.Pointer(in.Default))
	out.ValidValues = *(*[]resource.Quantity)(unsafe.Pointer(&in.ValidValues))
	out.ValidRange = (*v1.CapacityRequestPolicyRange)(unsafe.Pointer(in.ValidRange))
	return nil
}

// Convert_v1beta2_CapacityRequestPolicy_To_v1_CapacityRequestPolicy is an autogenerated conversion function.
func Convert_v1beta2_CapacityRequestPolicy_To_v1_CapacityRequestPolicy(in *resourcev1beta2.CapacityRequestPolicy, out *v1.CapacityRequestPolicy, s conversion.Scope) error {
	return autoConvert_v1beta2_CapacityRequestPolicy_To_v1_CapacityRequestPolicy(in, out, s)
}

func autoConvert_v1_CapacityRequestPolicyRange_To_v1beta2_CapacityRequestPolicyRange(in *v1.CapacityRequestPolicyRange, out *resourcev1beta2.CapacityRequestPolicyRange, s conversion.Scope) error {
	out.Min = (*resource.Quantity)(unsafe.Pointer(in.Min))
	out.Max = (*resource.Quantity)(unsafe.Pointer(in.Max))
	out.Step = (*resource.Quantity)(unsafe.Pointer(in.Step))
	return nil
}

// Convert_v1_CapacityRequestPolicyRange_To_v1beta2_CapacityRequestPolicyRange is an autogenerated conversion function.
func Convert_v1_CapacityRequestPolicyRange_To_v1beta2_CapacityRequestPolicyRange(in *v1.CapacityRequestPolicyRange, out *resourcev1beta2.CapacityRequestPolicyRange, s conversion.Scope) error {
	return autoConvert_v1_CapacityRequestPolicyRange_To_v1beta2_CapacityRequestPolicyRange(in, out, s)
}

func autoConvert_v1beta2_CapacityRequestPolicyRange_To_v1_CapacityRequestPolicyRange(in *resourcev1beta2.CapacityRequestPolicyRange, out *v1.CapacityRequestPolicyRange, s conversion.Scope) error {
	out.Min = (*resource.Quantity)(unsafe.Pointer(in.Min))
	out.Max = (*resource.Quantity)(unsafe.Pointer(in.Max))
	out.Step = (*resource.Quantity)(unsafe.Pointer(in.Step))
	return nil
}

// Convert_v1beta2_CapacityRequestPolicyRange_To_v1_CapacityRequestPolicyRange is an autogenerated conversion function.
func Convert_v1beta2_CapacityRequestPolicyRange_To_v1_CapacityRequestPolicyRange(in *resourcev1beta2.CapacityRequestPolicyRange, out *v1.CapacityRequestPolicyRange, s conversion.Scope) error {
	return autoConvert_v1beta2_CapacityRequestPolicyRange_To_v1_CapacityRequestPolicyRange(in, out, s)
}

func autoConvert_v1_CapacityRequirements_To_v1beta2_CapacityRequirements(in *v1.CapacityRequirements, out *resourcev1beta2.CapacityRequirements, s conversion.Scope) error {
	out.Requests = *(*map[resourcev1beta2.QualifiedName]resource.Quantity)(unsafe.Pointer(&in.Requests))
	return nil
}

// Convert_v1_CapacityRequirements_To_v1beta2_CapacityRequirements is an autogenerated conversion function.
func Convert_v1_CapacityRequirements_To_v1beta2_CapacityRequirements(in *v1.CapacityRequirements, out *resourcev1beta2.CapacityRequirements, s conversion.Scope) error {
	return autoConvert_v1_CapacityRequirements_To_v1beta2_CapacityRequirements(in, out, s)
}

func autoConvert_v1beta2_CapacityRequirements_To_v1_CapacityRequirements(in *resourcev1beta2.CapacityRequirements, out *v1.CapacityRequirements, s conversion.Scope) error {
	out.Requests = *(*map[v1.QualifiedName]resource.Quantity)(unsafe.Pointer(&in.Requests))
	return nil
}

// Convert_v1beta2_CapacityRequirements_To_v1_CapacityRequirements is an autogenerated conversion function.
func Convert_v1beta2_CapacityRequirements_To_v1_CapacityRequirements(in *resourcev1beta2.CapacityRequirements, out *v1.CapacityRequirements, s conversion.Scope) error {
	return autoConvert_v1beta2_CapacityRequirements_To_v1_CapacityRequirements(in, out, s)
}

func autoConvert_v1_Counter_To_v1beta2_Counter(in *v1.Counter, out *resourcev1beta2.Counter, s conversion.Scope) error {
	out.Value = in.Value
	return nil
}

// Convert_v1_Counter_To_v1beta2_Counter is an autogenerated conversion function.
func Convert_v1_Counter_To_v1beta2_Counter(in *v1.Counter, out *resourcev1beta2.Counter, s conversion.Scope) error {
	return autoConvert_v1_Counter_To_v1beta2_Counter(in, out, s)
}

func autoConvert_v1beta2_Counter_To_v1_Counter(in *resourcev1beta2.Counter, out *v1.Counter, s conversion.Scope) error {
	out.Value = in.Value
	return nil
}

// Convert_v1beta2_Counter_To_v1_Counter is an autogenerated conversion function.
func Convert_v1beta2_Counter_To_v1_Counter(in *resourcev1beta2.Counter, out *v1.Counter, s conversion.Scope) error {
	return autoConvert_v1beta2_Counter_To_v1_Counter(in, out, s)
}

func autoConvert_v1_CounterSet_To_v1beta2_CounterSet(in *v1.CounterSet, out *resourcev1beta2.CounterSet, s conversion.Scope) error {
	out.Name = in.Name
	out.Counters = *(*map[string]resourcev1beta2.Counter)(unsafe.Pointer(&in.Counters))
	return nil
}

// Convert_v1_CounterSet_To_v1beta2_CounterSet is an autogenerated conversion function.
func Convert_v1_CounterSet_To_v1beta2_CounterSet(in *v1.CounterSet, out *resourcev1beta2.CounterSet, s conversion.Scope) error {
	return autoConvert_v1_CounterSet_To_v1beta2_CounterSet(in, out, s)
}

func autoConvert_v1beta2_CounterSet_To_v1_CounterSet(in *resourcev1beta2.CounterSet, out *v1.CounterSet, s conversion.Scope) error {
	out.Name = in.Name
	out.Counters = *(*map[string]v1.Counter)(unsafe.Pointer(&in.Counters))
	return nil
}

// Convert_v1beta2_CounterSet_To_v1_CounterSet is an autogenerated conversion function.
func Convert_v1beta2_CounterSet_To_v1_CounterSet(in *resourcev1beta2.CounterSet, out *v1.CounterSet, s conversion.Scope) error {
	return autoConvert_v1beta2_CounterSet_To_v1_CounterSet(in, out, s)
}

func autoConvert_v1_Device_To_v1beta2_Device(in *v1.Device, out *resourcev1beta2.Device, s conversion.Scope) error {
	out.Name = in.Name
	out.Attributes = *(*map[resourcev1beta2.QualifiedName]resourcev1beta2.DeviceAttribute)(unsafe.Pointer(&in.Attributes))
	out.Capacity = *(*map[resourcev1beta2.QualifiedName]resourcev1beta2.DeviceCapacity)(unsafe.Pointer(&in.Capacity))
	out.ConsumesCounters = *(*[]resourcev1beta2.DeviceCounterConsumption)(unsafe.Pointer(&in.ConsumesCounters))
	out.NodeName = (*string)(unsafe.Pointer(in.NodeName))
	out.NodeSelector = (*corev1.NodeSelector)(unsafe.Pointer(in.NodeSelector))
	out.AllNodes = (*bool)(unsafe.Pointer(in.AllNodes))
	out.Taints = *(*[]resourcev1beta2.DeviceTaint)(unsafe.Pointer(&in.Taints))
	out.BindsToNode = (*bool)(unsafe.Pointer(in.BindsToNode))
	out.BindingConditions = *(*[]string)(unsafe.Pointer(&in.BindingConditions))
	out.BindingFailureConditions = *(*[]string)(unsafe.Pointer(&in.BindingFailureConditions))
	out.AllowMultipleAllocations = (*bool)(unsafe.Pointer(in.AllowMultipleAllocations))
	return nil
}

// Convert_v1_Device_To_v1beta2_Device is an autogenerated conversion function.
func Convert_v1_Device_To_v1beta2_Device(in *v1.Device, out *resourcev1beta2.Device, s conversion.Scope) error {
	return autoConvert_v1_Device_To_v1beta2_Device(in, out, s)
}

func autoConvert_v1beta2_Device_To_v1_Device(in *resourcev1beta2.Device, out *v1.Device, s conversion.Scope) error {
	out.Name = in.Name
	out.Attributes = *(*map[v1.QualifiedName]v1.DeviceAttribute)(unsafe.Pointer(&in.Attributes))
	out.Capacity = *(*map[v1.QualifiedName]v1.DeviceCapacity)(unsafe.Pointer(&in.Capacity))
	out.ConsumesCounters = *(*[]v1.DeviceCounterConsumption)(unsafe.Pointer(&in.ConsumesCounters))
	out.NodeName = (*string)(unsafe.Pointer(in.NodeName))
	out.NodeSelector = (*corev1.NodeSelector)(unsafe.Pointer(in.NodeSelector))
	out.AllNodes = (*bool)(unsafe.Pointer(in.AllNodes))
	out.Taints = *(*[]v1.DeviceTaint)(unsafe.Pointer(&in.Taints))
	out.BindsToNode = (*bool)(unsafe.Pointer(in.BindsToNode))
	out.BindingConditions = *(*[]string)(unsafe.Pointer(&in.BindingConditions))
	out.BindingFailureConditions = *(*[]string)(unsafe.Pointer(&in.BindingFailureConditions))
	out.AllowMultipleAllocations = (*bool)(unsafe.Pointer(in.AllowMultipleAllocations))
	return nil
}

// Convert_v1beta2_Device_To_v1_Device is an autogenerated conversion function.
func Convert_v1beta2_Device_To_v1_Device(in *resourcev1beta2.Device, out *v1.Device, s conversion.Scope) error {
	return autoConvert_v1beta2_Device_To_v1_Device(in, out, s)
}

func autoConvert_v1_DeviceAllocationConfiguration_To_v1beta2_DeviceAllocationConfiguration(in *v1.DeviceAllocationConfiguration, out *resourcev1beta2.DeviceAllocationConfiguration, s conversion.Scope) error {
	out.Source = resourcev1beta2.AllocationConfigSource(in.Source)
	out.Requests = *(*[]string)(unsafe.Pointer(&in.Requests))
	if err := Convert_v1_DeviceConfiguration_To_v1beta2_DeviceConfiguration(&in.DeviceConfiguration, &out.DeviceConfiguration, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_DeviceAllocationConfiguration_To_v1beta2_DeviceAllocationConfiguration is an autogenerated conversion function.
func Convert_v1_DeviceAllocationConfiguration_To_v1beta2_DeviceAllocationConfiguration(in *v1.DeviceAllocationConfiguration, out *resourcev1beta2.DeviceAllocationConfiguration, s conversion.Scope) error {
	return autoConvert_v1_DeviceAllocationConfiguration_To_v1beta2_DeviceAllocationConfiguration(in, out, s)
}

func autoConvert_v1beta2_DeviceAllocationConfiguration_To_v1_DeviceAllocationConfiguration(in *resourcev1beta2.DeviceAllocationConfiguration, out *v1.DeviceAllocationConfiguration, s conversion.Scope) error {
	out.Source = v1.AllocationConfigSource(in.Source)
	out.Requests = *(*[]string)(unsafe.Pointer(&in.Requests))
	if err := Convert_v1beta2_DeviceConfiguration_To_v1_DeviceConfiguration(&in.DeviceConfiguration, &out.DeviceConfiguration, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta2_DeviceAllocationConfiguration_To_v1_DeviceAllocationConfiguration is an autogenerated conversion function.
func Convert_v1beta2_DeviceAllocationConfiguration_To_v1_DeviceAllocationConfiguration(in *resourcev1beta2.DeviceAllocationConfiguration, out *v1.DeviceAllocationConfiguration, s conversion.Scope) error {
	return autoConvert_v1beta2_DeviceAllocationConfiguration_To_v1_DeviceAllocationConfiguration(in, out, s)
}

func autoConvert_v1_DeviceAllocationResult_To_v1beta2_DeviceAllocationResult(in *v1.DeviceAllocationResult, out *resourcev1beta2.DeviceAllocationResult, s conversion.Scope) error {
	out.Results = *(*[]resourcev1beta2.DeviceRequestAllocationResult)(unsafe.Pointer(&in.Results))
	out.Config = *(*[]resourcev1beta2.DeviceAllocationConfiguration)(unsafe.Pointer(&in.Config))
	return nil
}

// Convert_v1_DeviceAllocationResult_To_v1beta2_DeviceAllocationResult is an autogenerated conversion function.
func Convert_v1_DeviceAllocationResult_To_v1beta2_DeviceAllocationResult(in *v1.DeviceAllocationResult, out *resourcev1beta2.DeviceAllocationResult, s conversion.Scope) error {
	return autoConvert_v1_DeviceAllocationResult_To_v1beta2_DeviceAllocationResult(in, out, s)
}

func autoConvert_v1beta2_DeviceAllocationResult_To_v1_DeviceAllocationResult(in *resourcev1beta2.DeviceAllocationResult, out *v1.DeviceAllocationResult, s conversion.Scope) error {
	out.Results = *(*[]v1.DeviceRequestAllocationResult)(unsafe.Pointer(&in.Results))
	out.Config = *(*[]v1.DeviceAllocationConfiguration)(unsafe.Pointer(&in.Config))
	return nil
}

// Convert_v1beta2_DeviceAllocationResult_To_v1_DeviceAllocationResult is an autogenerated conversion function.
func Convert_v1beta2_DeviceAllocationResult_To_v1_DeviceAllocationResult(in *resourcev1beta2.DeviceAllocationResult, out *v1.DeviceAllocationResult, s conversion.Scope) error {
	return autoConvert_v1beta2_DeviceAllocationResult_To_v1_DeviceAllocationResult(in, out, s)
}

func autoConvert_v1_DeviceAttribute_To_v1beta2_DeviceAttribute(in *v1.DeviceAttribute, out *resourcev1beta2.DeviceAttribute, s conversion.Scope) error {
	out.IntValue = (*int64)(unsafe.Pointer(in.IntValue))
	out.BoolValue = (*bool)(unsafe.Pointer(in.BoolValue))
	out.StringValue = (*string)(unsafe.Pointer(in.StringValue))
	out.VersionValue = (*string)(unsafe.Pointer(in.VersionValue))
	return nil
}

// Convert_v1_DeviceAttribute_To_v1beta2_DeviceAttribute is an autogenerated conversion function.
func Convert_v1_DeviceAttribute_To_v1beta2_DeviceAttribute(in *v1.DeviceAttribute, out *resourcev1beta2.DeviceAttribute, s conversion.Scope) error {
	return autoConvert_v1_DeviceAttribute_To_v1beta2_DeviceAttribute(in, out, s)
}

func autoConvert_v1beta2_DeviceAttribute_To_v1_DeviceAttribute(in *resourcev1beta2.DeviceAttribute, out *v1.DeviceAttribute, s conversion.Scope) error {
	out.IntValue = (*int64)(unsafe.Pointer(in.IntValue))
	out.BoolValue = (*bool)(unsafe.Pointer(in.BoolValue))
	out.StringValue = (*string)(unsafe.Pointer(in.StringValue))
	out.VersionValue = (*string)(unsafe.Pointer(in.VersionValue))
	return nil
}

// Convert_v1beta2_DeviceAttribute_To_v1_DeviceAttribute is an autogenerated conversion function.
func Convert_v1beta2_DeviceAttribute_To_v1_DeviceAttribute(in *resourcev1beta2.DeviceAttribute, out *v1.DeviceAttribute, s conversion.Scope) error {
	return autoConvert_v1beta2_DeviceAttribute_To_v1_DeviceAttribute(in, out, s)
}

func autoConvert_v1_DeviceCapacity_To_v1beta2_DeviceCapacity(in *v1.DeviceCapacity, out *resourcev1beta2.DeviceCapacity, s conversion.Scope) error {
	out.Value = in.Value
	out.RequestPolicy = (*resourcev1beta2.CapacityRequestPolicy)(unsafe.Pointer(in.RequestPolicy))
	return nil
}

// Convert_v1_DeviceCapacity_To_v1beta2_DeviceCapacity is an autogenerated conversion function.
func Convert_v1_DeviceCapacity_To_v1beta2_DeviceCapacity(in *v1.DeviceCapacity, out *resourcev1beta2.DeviceCapacity, s conversion.Scope) error {
	return autoConvert_v1_DeviceCapacity_To_v1beta2_DeviceCapacity(in, out, s)
}

func autoConvert_v1beta2_DeviceCapacity_To_v1_DeviceCapacity(in *resourcev1beta2.DeviceCapacity, out *v1.DeviceCapacity, s conversion.Scope) error {
	out.Value = in.Value
	out.RequestPolicy = (*v1.CapacityRequestPolicy)(unsafe.Pointer(in.RequestPolicy))
	return nil
}

// Convert_v1beta2_DeviceCapacity_To_v1_DeviceCapacity is an autogenerated conversion function.
func Convert_v1beta2_DeviceCapacity_To_v1_DeviceCapacity(in *resourcev1beta2.DeviceCapacity, out *v1.DeviceCapacity, s conversion.Scope) error {
	return autoConvert_v1beta2_DeviceCapacity_To_v1_DeviceCapacity(in, out, s)
}

func autoConvert_v1_DeviceClaim_To_v1beta2_DeviceClaim(in *v1.DeviceClaim, out *resourcev1beta2.DeviceClaim, s conversion.Scope) error {
	out.Requests = *(*[]resourcev1beta2.DeviceRequest)(unsafe.Pointer(&in.Requests))
	out.Constraints = *(*[]resourcev1beta2.DeviceConstraint)(unsafe.Pointer(&in.Constraints))
	out.Config = *(*[]resourcev1beta2.DeviceClaimConfiguration)(unsafe.Pointer(&in.Config))
	return nil
}

// Convert_v1_DeviceClaim_To_v1beta2_DeviceClaim is an autogenerated conversion function.
func Convert_v1_DeviceClaim_To_v1beta2_DeviceClaim(in *v1.DeviceClaim, out *resourcev1beta2.DeviceClaim, s conversion.Scope) error {
	return autoConvert_v1_DeviceClaim_To_v1beta2_DeviceClaim(in, out, s)
}

func autoConvert_v1beta2_DeviceClaim_To_v1_DeviceClaim(in *resourcev1beta2.DeviceClaim, out *v1.DeviceClaim, s conversion.Scope) error {
	out.Requests = *(*[]v1.DeviceRequest)(unsafe.Pointer(&in.Requests))
	out.Constraints = *(*[]v1.DeviceConstraint)(unsafe.Pointer(&in.Constraints))
	out.Config = *(*[]v1.DeviceClaimConfiguration)(unsafe.Pointer(&in.Config))
	return nil
}

// Convert_v1beta2_DeviceClaim_To_v1_DeviceClaim is an autogenerated conversion function.
func Convert_v1beta2_DeviceClaim_To_v1_DeviceClaim(in *resourcev1beta2.DeviceClaim, out *v1.DeviceClaim, s conversion.Scope) error {
	return autoConvert_v1beta2_DeviceClaim_To_v1_DeviceClaim(in, out, s)
}

func autoConvert_v1_DeviceClaimConfiguration_To_v1beta2_DeviceClaimConfiguration(in *v1.DeviceClaimConfiguration, out *resourcev1beta2.DeviceClaimConfiguration, s conversion.Scope) error {
	out.Requests = *(*[]string)(unsafe.Pointer(&in.Requests))
	if err := Convert_v1_DeviceConfiguration_To_v1beta2_DeviceConfiguration(&in.DeviceConfiguration, &out.DeviceConfiguration, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_DeviceClaimConfiguration_To_v1beta2_DeviceClaimConfiguration is an autogenerated conversion function.
func Convert_v1_DeviceClaimConfiguration_To_v1beta2_DeviceClaimConfiguration(in *v1.DeviceClaimConfiguration, out *resourcev1beta2.DeviceClaimConfiguration, s conversion.Scope) error {
	return autoConvert_v1_DeviceClaimConfiguration_To_v1beta2_DeviceClaimConfiguration(in, out, s)
}

func autoConvert_v1beta2_DeviceClaimConfiguration_To_v1_DeviceClaimConfiguration(in *resourcev1beta2.DeviceClaimConfiguration, out *v1.DeviceClaimConfiguration, s conversion.Scope) error {
	out.Requests = *(*[]string)(unsafe.Pointer(&in.Requests))
	if err := Convert_v1beta2_DeviceConfiguration_To_v1_DeviceConfiguration(&in.DeviceConfiguration, &out.DeviceConfiguration, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta2_DeviceClaimConfiguration_To_v1_DeviceClaimConfiguration is an autogenerated conversion function.
func Convert_v1beta2_DeviceClaimConfiguration_To_v1_DeviceClaimConfiguration(in *resourcev1beta2.DeviceClaimConfiguration, out *v1.DeviceClaimConfiguration, s conversion.Scope) error {
	return autoConvert_v1beta2_DeviceClaimConfiguration_To_v1_DeviceClaimConfiguration(in, out, s)
}

func autoConvert_v1_DeviceClass_To_v1beta2_DeviceClass(in *v1.DeviceClass, out *resourcev1beta2.DeviceClass, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_DeviceClassSpec_To_v1beta2_DeviceClassSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_DeviceClass_To_v1beta2_DeviceClass is an autogenerated conversion function.
func Convert_v1_DeviceClass_To_v1beta2_DeviceClass(in *v1.DeviceClass, out *resourcev1beta2.DeviceClass, s conversion.Scope) error {
	return autoConvert_v1_DeviceClass_To_v1beta2_DeviceClass(in, out, s)
}

func autoConvert_v1beta2_DeviceClass_To_v1_DeviceClass(in *resourcev1beta2.DeviceClass, out *v1.DeviceClass, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta2_DeviceClassSpec_To_v1_DeviceClassSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta2_DeviceClass_To_v1_DeviceClass is an autogenerated conversion function.
func Convert_v1beta2_DeviceClass_To_v1_DeviceClass(in *resourcev1beta2.DeviceClass, out *v1.DeviceClass, s conversion.Scope) error {
	return autoConvert_v1beta2_DeviceClass_To_v1_DeviceClass(in, out, s)
}

func autoConvert_v1_DeviceClassConfiguration_To_v1beta2_DeviceClassConfiguration(in *v1.DeviceClassConfiguration, out *resourcev1beta2.DeviceClassConfiguration, s conversion.Scope) error {
	if err := Convert_v1_DeviceConfiguration_To_v1beta2_DeviceConfiguration(&in.DeviceConfiguration, &out.DeviceConfiguration, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_DeviceClassConfiguration_To_v1beta2_DeviceClassConfiguration is an autogenerated conversion function.
func Convert_v1_DeviceClassConfiguration_To_v1beta2_DeviceClassConfiguration(in *v1.DeviceClassConfiguration, out *resourcev1beta2.DeviceClassConfiguration, s conversion.Scope) error {
	return autoConvert_v1_DeviceClassConfiguration_To_v1beta2_DeviceClassConfiguration(in, out, s)
}

func autoConvert_v1beta2_DeviceClassConfiguration_To_v1_DeviceClassConfiguration(in *resourcev1beta2.DeviceClassConfiguration, out *v1.DeviceClassConfiguration, s conversion.Scope) error {
	if err := Convert_v1beta2_DeviceConfiguration_To_v1_DeviceConfiguration(&in.DeviceConfiguration, &out.DeviceConfiguration, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta2_DeviceClassConfiguration_To_v1_DeviceClassConfiguration is an autogenerated conversion function.
func Convert_v1beta2_DeviceClassConfiguration_To_v1_DeviceClassConfiguration(in *resourcev1beta2.DeviceClassConfiguration, out *v1.DeviceClassConfiguration, s conversion.Scope) error {
	return autoConvert_v1beta2_DeviceClassConfiguration_To_v1_DeviceClassConfiguration(in, out, s)
}

func autoConvert_v1_DeviceClassList_To_v1beta2_DeviceClassList(in *v1.DeviceClassList, out *resourcev1beta2.DeviceClassList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resourcev1beta2.DeviceClass)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_DeviceClassList_To_v1beta2_DeviceClassList is an autogenerated conversion function.
func Convert_v1_DeviceClassList_To_v1beta2_DeviceClassList(in *v1.DeviceClassList, out *resourcev1beta2.DeviceClassList, s conversion.Scope) error {
	return autoConvert_v1_DeviceClassList_To_v1beta2_DeviceClassList(in, out, s)
}

func autoConvert_v1beta2_DeviceClassList_To_v1_DeviceClassList(in *resourcev1beta2.DeviceClassList, out *v1.DeviceClassList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1.DeviceClass)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1beta2_DeviceClassList_To_v1_DeviceClassList is an autogenerated conversion function.
func Convert_v1beta2_DeviceClassList_To_v1_DeviceClassList(in *resourcev1beta2.DeviceClassList, out *v1.DeviceClassList, s conversion.Scope) error {
	return autoConvert_v1beta2_DeviceClassList_To_v1_DeviceClassList(in, out, s)
}

func autoConvert_v1_DeviceClassSpec_To_v1beta2_DeviceClassSpec(in *v1.DeviceClassSpec, out *resourcev1beta2.DeviceClassSpec, s conversion.Scope) error {
	out.Selectors = *(*[]resourcev1beta2.DeviceSelector)(unsafe.Pointer(&in.Selectors))
	out.Config = *(*[]resourcev1beta2.DeviceClassConfiguration)(unsafe.Pointer(&in.Config))
	out.ExtendedResourceName = (*string)(unsafe.Pointer(in.ExtendedResourceName))
	return nil
}

// Convert_v1_DeviceClassSpec_To_v1beta2_DeviceClassSpec is an autogenerated conversion function.
func Convert_v1_DeviceClassSpec_To_v1beta2_DeviceClassSpec(in *v1.DeviceClassSpec, out *resourcev1beta2.DeviceClassSpec, s conversion.Scope) error {
	return autoConvert_v1_DeviceClassSpec_To_v1beta2_DeviceClassSpec(in, out, s)
}

func autoConvert_v1beta2_DeviceClassSpec_To_v1_DeviceClassSpec(in *resourcev1beta2.DeviceClassSpec, out *v1.DeviceClassSpec, s conversion.Scope) error {
	out.Selectors = *(*[]v1.DeviceSelector)(unsafe.Pointer(&in.Selectors))
	out.Config = *(*[]v1.DeviceClassConfiguration)(unsafe.Pointer(&in.Config))
	out.ExtendedResourceName = (*string)(unsafe.Pointer(in.ExtendedResourceName))
	return nil
}

// Convert_v1beta2_DeviceClassSpec_To_v1_DeviceClassSpec is an autogenerated conversion function.
func Convert_v1beta2_DeviceClassSpec_To_v1_DeviceClassSpec(in *resourcev1beta2.DeviceClassSpec, out *v1.DeviceClassSpec, s conversion.Scope) error {
	return autoConvert_v1beta2_DeviceClassSpec_To_v1_DeviceClassSpec(in, out, s)
}

func autoConvert_v1_DeviceConfiguration_To_v1beta2_DeviceConfiguration(in *v1.DeviceConfiguration, out *resourcev1beta2.DeviceConfiguration, s conversion.Scope) error {
	out.Opaque = (*resourcev1beta2.OpaqueDeviceConfiguration)(unsafe.Pointer(in.Opaque))
	return nil
}

// Convert_v1_DeviceConfiguration_To_v1beta2_DeviceConfiguration is an autogenerated conversion function.
func Convert_v1_DeviceConfiguration_To_v1beta2_DeviceConfiguration(in *v1.DeviceConfiguration, out *resourcev1beta2.DeviceConfiguration, s conversion.Scope) error {
	return autoConvert_v1_DeviceConfiguration_To_v1beta2_DeviceConfiguration(in, out, s)
}

func autoConvert_v1beta2_DeviceConfiguration_To_v1_DeviceConfiguration(in *resourcev1beta2.DeviceConfiguration, out *v1.DeviceConfiguration, s conversion.Scope) error {
	out.Opaque = (*v1.OpaqueDeviceConfiguration)(unsafe.Pointer(in.Opaque))
	return nil
}

// Convert_v1beta2_DeviceConfiguration_To_v1_DeviceConfiguration is an autogenerated conversion function.
func Convert_v1beta2_DeviceConfiguration_To_v1_DeviceConfiguration(in *resourcev1beta2.DeviceConfiguration, out *v1.DeviceConfiguration, s conversion.Scope) error {
	return autoConvert_v1beta2_DeviceConfiguration_To_v1_DeviceConfiguration(in, out, s)
}

func autoConvert_v1_DeviceConstraint_To_v1beta2_DeviceConstraint(in *v1.DeviceConstraint, out *resourcev1beta2.DeviceConstraint, s conversion.Scope) error {
	out.Requests = *(*[]string)(unsafe.Pointer(&in.Requests))
	out.MatchAttribute = (*resourcev1beta2.FullyQualifiedName)(unsafe.Pointer(in.MatchAttribute))
	out.DistinctAttribute = (*resourcev1beta2.FullyQualifiedName)(unsafe.Pointer(in.DistinctAttribute))
	return nil
}

// Convert_v1_DeviceConstraint_To_v1beta2_DeviceConstraint is an autogenerated conversion function.
func Convert_v1_DeviceConstraint_To_v1beta2_DeviceConstraint(in *v1.DeviceConstraint, out *resourcev1beta2.DeviceConstraint, s conversion.Scope) error {
	return autoConvert_v1_DeviceConstraint_To_v1beta2_DeviceConstraint(in, out, s)
}

func autoConvert_v1beta2_DeviceConstraint_To_v1_DeviceConstraint(in *resourcev1beta2.DeviceConstraint, out *v1.DeviceConstraint, s conversion.Scope) error {
	out.Requests = *(*[]string)(unsafe.Pointer(&in.Requests))
	out.MatchAttribute = (*v1.FullyQualifiedName)(unsafe.Pointer(in.MatchAttribute))
	out.DistinctAttribute = (*v1.FullyQualifiedName)(unsafe.Pointer(in.DistinctAttribute))
	return nil
}

// Convert_v1beta2_DeviceConstraint_To_v1_DeviceConstraint is an autogenerated conversion function.
func Convert_v1beta2_DeviceConstraint_To_v1_DeviceConstraint(in *resourcev1beta2.DeviceConstraint, out *v1.DeviceConstraint, s conversion.Scope) error {
	return autoConvert_v1beta2_DeviceConstraint_To_v1_DeviceConstraint(in, out, s)
}

func autoConvert_v1_DeviceCounterConsumption_To_v1beta2_DeviceCounterConsumption(in *v1.DeviceCounterConsumption, out *resourcev1beta2.DeviceCounterConsumption, s conversion.Scope) error {
	out.CounterSet = in.CounterSet
	out.Counters = *(*map[string]resourcev1beta2.Counter)(unsafe.Pointer(&in.Counters))
	return nil
}

// Convert_v1_DeviceCounterConsumption_To_v1beta2_DeviceCounterConsumption is an autogenerated conversion function.
func Convert_v1_DeviceCounterConsumption_To_v1beta2_DeviceCounterConsumption(in *v1.DeviceCounterConsumption, out *resourcev1beta2.DeviceCounterConsumption, s conversion.Scope) error {
	return autoConvert_v1_DeviceCounterConsumption_To_v1beta2_DeviceCounterConsumption(in, out, s)
}

func autoConvert_v1beta2_DeviceCounterConsumption_To_v1_DeviceCounterConsumption(in *resourcev1beta2.DeviceCounterConsumption, out *v1.DeviceCounterConsumption, s conversion.Scope) error {
	out.CounterSet = in.CounterSet
	out.Counters = *(*map[string]v1.Counter)(unsafe.Pointer(&in.Counters))
	return nil
}

// Convert_v1beta2_DeviceCounterConsumption_To_v1_DeviceCounterConsumption is an autogenerated conversion function.
func Convert_v1beta2_DeviceCounterConsumption_To_v1_DeviceCounterConsumption(in *resourcev1beta2.DeviceCounterConsumption, out *v1.DeviceCounterConsumption, s conversion.Scope) error {
	return autoConvert_v1beta2_DeviceCounterConsumption_To_v1_DeviceCounterConsumption(in, out, s)
}

func autoConvert_v1_DeviceRequest_To_v1beta2_DeviceRequest(in *v1.DeviceRequest, out *resourcev1beta2.DeviceRequest, s conversion.Scope) error {
	out.Name = in.Name
	out.Exactly = (*resourcev1beta2.ExactDeviceRequest)(unsafe.Pointer(in.Exactly))
	out.FirstAvailable = *(*[]resourcev1beta2.DeviceSubRequest)(unsafe.Pointer(&in.FirstAvailable))
	return nil
}

// Convert_v1_DeviceRequest_To_v1beta2_DeviceRequest is an autogenerated conversion function.
func Convert_v1_DeviceRequest_To_v1beta2_DeviceRequest(in *v1.DeviceRequest, out *resourcev1beta2.DeviceRequest, s conversion.Scope) error {
	return autoConvert_v1_DeviceRequest_To_v1beta2_DeviceRequest(in, out, s)
}

func autoConvert_v1beta2_DeviceRequest_To_v1_DeviceRequest(in *resourcev1beta2.DeviceRequest, out *v1.DeviceRequest, s conversion.Scope) error {
	out.Name = in.Name
	out.Exactly = (*v1.ExactDeviceRequest)(unsafe.Pointer(in.Exactly))
	out.FirstAvailable = *(*[]v1.DeviceSubRequest)(unsafe.Pointer(&in.FirstAvailable))
	return nil
}

// Convert_v1beta2_DeviceRequest_To_v1_DeviceRequest is an autogenerated conversion function.
func Convert_v1beta2_DeviceRequest_To_v1_DeviceRequest(in *resourcev1beta2.DeviceRequest, out *v1.DeviceRequest, s conversion.Scope) error {
	return autoConvert_v1beta2_DeviceRequest_To_v1_DeviceRequest(in, out, s)
}

func autoConvert_v1_DeviceRequestAllocationResult_To_v1beta2_DeviceRequestAllocationResult(in *v1.DeviceRequestAllocationResult, out *resourcev1beta2.DeviceRequestAllocationResult, s conversion.Scope) error {
	out.Request = in.Request
	out.Driver = in.Driver
	out.Pool = in.Pool
	out.Device = in.Device
	out.AdminAccess = (*bool)(unsafe.Pointer(in.AdminAccess))
	out.Tolerations = *(*[]resourcev1beta2.DeviceToleration)(unsafe.Pointer(&in.Tolerations))
	out.BindingConditions = *(*[]string)(unsafe.Pointer(&in.BindingConditions))
	out.BindingFailureConditions = *(*[]string)(unsafe.Pointer(&in.BindingFailureConditions))
	out.ShareID = (*types.UID)(unsafe.Pointer(in.ShareID))
	out.ConsumedCapacity = *(*map[resourcev1beta2.QualifiedName]resource.Quantity)(unsafe.Pointer(&in.ConsumedCapacity))
	return nil
}

// Convert_v1_DeviceRequestAllocationResult_To_v1beta2_DeviceRequestAllocationResult is an autogenerated conversion function.
func Convert_v1_DeviceRequestAllocationResult_To_v1beta2_DeviceRequestAllocationResult(in *v1.DeviceRequestAllocationResult, out *resourcev1beta2.DeviceRequestAllocationResult, s conversion.Scope) error {
	return autoConvert_v1_DeviceRequestAllocationResult_To_v1beta2_DeviceRequestAllocationResult(in, out, s)
}

func autoConvert_v1beta2_DeviceRequestAllocationResult_To_v1_DeviceRequestAllocationResult(in *resourcev1beta2.DeviceRequestAllocationResult, out *v1.DeviceRequestAllocationResult, s conversion.Scope) error {
	out.Request = in.Request
	out.Driver = in.Driver
	out.Pool = in.Pool
	out.Device = in.Device
	out.AdminAccess = (*bool)(unsafe.Pointer(in.AdminAccess))
	out.Tolerations = *(*[]v1.DeviceToleration)(unsafe.Pointer(&in.Tolerations))
	out.BindingConditions = *(*[]string)(unsafe.Pointer(&in.BindingConditions))
	out.BindingFailureConditions = *(*[]string)(unsafe.Pointer(&in.BindingFailureConditions))
	out.ShareID = (*types.UID)(unsafe.Pointer(in.ShareID))
	out.ConsumedCapacity = *(*map[v1.QualifiedName]resource.Quantity)(unsafe.Pointer(&in.ConsumedCapacity))
	return nil
}

// Convert_v1beta2_DeviceRequestAllocationResult_To_v1_DeviceRequestAllocationResult is an autogenerated conversion function.
func Convert_v1beta2_DeviceRequestAllocationResult_To_v1_DeviceRequestAllocationResult(in *resourcev1beta2.DeviceRequestAllocationResult, out *v1.DeviceRequestAllocationResult, s conversion.Scope) error {
	return autoConvert_v1beta2_DeviceRequestAllocationResult_To_v1_DeviceRequestAllocationResult(in, out, s)
}

func autoConvert_v1_DeviceSelector_To_v1beta2_DeviceSelector(in *v1.DeviceSelector, out *resourcev1beta2.DeviceSelector, s conversion.Scope) error {
	out.CEL = (*resourcev1beta2.CELDeviceSelector)(unsafe.Pointer(in.CEL))
	return nil
}

// Convert_v1_DeviceSelector_To_v1beta2_DeviceSelector is an autogenerated conversion function.
func Convert_v1_DeviceSelector_To_v1beta2_DeviceSelector(in *v1.DeviceSelector, out *resourcev1beta2.DeviceSelector, s conversion.Scope) error {
	return autoConvert_v1_DeviceSelector_To_v1beta2_DeviceSelector(in, out, s)
}

func autoConvert_v1beta2_DeviceSelector_To_v1_DeviceSelector(in *resourcev1beta2.DeviceSelector, out *v1.DeviceSelector, s conversion.Scope) error {
	out.CEL = (*v1.CELDeviceSelector)(unsafe.Pointer(in.CEL))
	return nil
}

// Convert_v1beta2_DeviceSelector_To_v1_DeviceSelector is an autogenerated conversion function.
func Convert_v1beta2_DeviceSelector_To_v1_DeviceSelector(in *resourcev1beta2.DeviceSelector, out *v1.DeviceSelector, s conversion.Scope) error {
	return autoConvert_v1beta2_DeviceSelector_To_v1_DeviceSelector(in, out, s)
}

func autoConvert_v1_DeviceSubRequest_To_v1beta2_DeviceSubRequest(in *v1.DeviceSubRequest, out *resourcev1beta2.DeviceSubRequest, s conversion.Scope) error {
	out.Name = in.Name
	out.DeviceClassName = in.DeviceClassName
	out.Selectors = *(*[]resourcev1beta2.DeviceSelector)(unsafe.Pointer(&in.Selectors))
	out.AllocationMode = resourcev1beta2.DeviceAllocationMode(in.AllocationMode)
	out.Count = in.Count
	out.Tolerations = *(*[]resourcev1beta2.DeviceToleration)(unsafe.Pointer(&in.Tolerations))
	out.Capacity = (*resourcev1beta2.CapacityRequirements)(unsafe.Pointer(in.Capacity))
	return nil
}

// Convert_v1_DeviceSubRequest_To_v1beta2_DeviceSubRequest is an autogenerated conversion function.
func Convert_v1_DeviceSubRequest_To_v1beta2_DeviceSubRequest(in *v1.DeviceSubRequest, out *resourcev1beta2.DeviceSubRequest, s conversion.Scope) error {
	return autoConvert_v1_DeviceSubRequest_To_v1beta2_DeviceSubRequest(in, out, s)
}

func autoConvert_v1beta2_DeviceSubRequest_To_v1_DeviceSubRequest(in *resourcev1beta2.DeviceSubRequest, out *v1.DeviceSubRequest, s conversion.Scope) error {
	out.Name = in.Name
	out.DeviceClassName = in.DeviceClassName
	out.Selectors = *(*[]v1.DeviceSelector)(unsafe.Pointer(&in.Selectors))
	out.AllocationMode = v1.DeviceAllocationMode(in.AllocationMode)
	out.Count = in.Count
	out.Tolerations = *(*[]v1.DeviceToleration)(unsafe.Pointer(&in.Tolerations))
	out.Capacity = (*v1.CapacityRequirements)(unsafe.Pointer(in.Capacity))
	return nil
}

// Convert_v1beta2_DeviceSubRequest_To_v1_DeviceSubRequest is an autogenerated conversion function.
func Convert_v1beta2_DeviceSubRequest_To_v1_DeviceSubRequest(in *resourcev1beta2.DeviceSubRequest, out *v1.DeviceSubRequest, s conversion.Scope) error {
	return autoConvert_v1beta2_DeviceSubRequest_To_v1_DeviceSubRequest(in, out, s)
}

func autoConvert_v1_DeviceTaint_To_v1beta2_DeviceTaint(in *v1.DeviceTaint, out *resourcev1beta2.DeviceTaint, s conversion.Scope) error {
	out.Key = in.Key
	out.Value = in.Value
	out.Effect = resourcev1beta2.DeviceTaintEffect(in.Effect)
	out.TimeAdded = (*metav1.Time)(unsafe.Pointer(in.TimeAdded))
	return nil
}

// Convert_v1_DeviceTaint_To_v1beta2_DeviceTaint is an autogenerated conversion function.
func Convert_v1_DeviceTaint_To_v1beta2_DeviceTaint(in *v1.DeviceTaint, out *resourcev1beta2.DeviceTaint, s conversion.Scope) error {
	return autoConvert_v1_DeviceTaint_To_v1beta2_DeviceTaint(in, out, s)
}

func autoConvert_v1beta2_DeviceTaint_To_v1_DeviceTaint(in *resourcev1beta2.DeviceTaint, out *v1.DeviceTaint, s conversion.Scope) error {
	out.Key = in.Key
	out.Value = in.Value
	out.Effect = v1.DeviceTaintEffect(in.Effect)
	out.TimeAdded = (*metav1.Time)(unsafe.Pointer(in.TimeAdded))
	return nil
}

// Convert_v1beta2_DeviceTaint_To_v1_DeviceTaint is an autogenerated conversion function.
func Convert_v1beta2_DeviceTaint_To_v1_DeviceTaint(in *resourcev1beta2.DeviceTaint, out *v1.DeviceTaint, s conversion.Scope) error {
	return autoConvert_v1beta2_DeviceTaint_To_v1_DeviceTaint(in, out, s)
}

func autoConvert_v1_DeviceToleration_To_v1beta2_DeviceToleration(in *v1.DeviceToleration, out *resourcev1beta2.DeviceToleration, s conversion.Scope) error {
	out.Key = in.Key
	out.Operator = resourcev1beta2.DeviceTolerationOperator(in.Operator)
	out.Value = in.Value
	out.Effect = resourcev1beta2.DeviceTaintEffect(in.Effect)
	out.TolerationSeconds = (*int64)(unsafe.Pointer(in.TolerationSeconds))
	return nil
}

// Convert_v1_DeviceToleration_To_v1beta2_DeviceToleration is an autogenerated conversion function.
func Convert_v1_DeviceToleration_To_v1beta2_DeviceToleration(in *v1.DeviceToleration, out *resourcev1beta2.DeviceToleration, s conversion.Scope) error {
	return autoConvert_v1_DeviceToleration_To_v1beta2_DeviceToleration(in, out, s)
}

func autoConvert_v1beta2_DeviceToleration_To_v1_DeviceToleration(in *resourcev1beta2.DeviceToleration, out *v1.DeviceToleration, s conversion.Scope) error {
	out.Key = in.Key
	out.Operator = v1.DeviceTolerationOperator(in.Operator)
	out.Value = in.Value
	out.Effect = v1.DeviceTaintEffect(in.Effect)
	out.TolerationSeconds = (*int64)(unsafe.Pointer(in.TolerationSeconds))
	return nil
}

// Convert_v1beta2_DeviceToleration_To_v1_DeviceToleration is an autogenerated conversion function.
func Convert_v1beta2_DeviceToleration_To_v1_DeviceToleration(in *resourcev1beta2.DeviceToleration, out *v1.DeviceToleration, s conversion.Scope) error {
	return autoConvert_v1beta2_DeviceToleration_To_v1_DeviceToleration(in, out, s)
}

func autoConvert_v1_ExactDeviceRequest_To_v1beta2_ExactDeviceRequest(in *v1.ExactDeviceRequest, out *resourcev1beta2.ExactDeviceRequest, s conversion.Scope) error {
	out.DeviceClassName = in.DeviceClassName
	out.Selectors = *(*[]resourcev1beta2.DeviceSelector)(unsafe.Pointer(&in.Selectors))
	out.AllocationMode = resourcev1beta2.DeviceAllocationMode(in.AllocationMode)
	out.Count = in.Count
	out.AdminAccess = (*bool)(unsafe.Pointer(in.AdminAccess))
	out.Tolerations = *(*[]resourcev1beta2.DeviceToleration)(unsafe.Pointer(&in.Tolerations))
	out.Capacity = (*resourcev1beta2.CapacityRequirements)(unsafe.Pointer(in.Capacity))
	return nil
}

// Convert_v1_ExactDeviceRequest_To_v1beta2_ExactDeviceRequest is an autogenerated conversion function.
func Convert_v1_ExactDeviceRequest_To_v1beta2_ExactDeviceRequest(in *v1.ExactDeviceRequest, out *resourcev1beta2.ExactDeviceRequest, s conversion.Scope) error {
	return autoConvert_v1_ExactDeviceRequest_To_v1beta2_ExactDeviceRequest(in, out, s)
}

func autoConvert_v1beta2_ExactDeviceRequest_To_v1_ExactDeviceRequest(in *resourcev1beta2.ExactDeviceRequest, out *v1.ExactDeviceRequest, s conversion.Scope) error {
	out.DeviceClassName = in.DeviceClassName
	out.Selectors = *(*[]v1.DeviceSelector)(unsafe.Pointer(&in.Selectors))
	out.AllocationMode = v1.DeviceAllocationMode(in.AllocationMode)
	out.Count = in.Count
	out.AdminAccess = (*bool)(unsafe.Pointer(in.AdminAccess))
	out.Tolerations = *(*[]v1.DeviceToleration)(unsafe.Pointer(&in.Tolerations))
	out.Capacity = (*v1.CapacityRequirements)(unsafe.Pointer(in.Capacity))
	return nil
}

// Convert_v1beta2_ExactDeviceRequest_To_v1_ExactDeviceRequest is an autogenerated conversion function.
func Convert_v1beta2_ExactDeviceRequest_To_v1_ExactDeviceRequest(in *resourcev1beta2.ExactDeviceRequest, out *v1.ExactDeviceRequest, s conversion.Scope) error {
	return autoConvert_v1beta2_ExactDeviceRequest_To_v1_ExactDeviceRequest(in, out, s)
}

func autoConvert_v1_NetworkDeviceData_To_v1beta2_NetworkDeviceData(in *v1.NetworkDeviceData, out *resourcev1beta2.NetworkDeviceData, s conversion.Scope) error {
	out.InterfaceName = in.InterfaceName
	out.IPs = *(*[]string)(unsafe.Pointer(&in.IPs))
	out.HardwareAddress = in.HardwareAddress
	return nil
}

// Convert_v1_NetworkDeviceData_To_v1beta2_NetworkDeviceData is an autogenerated conversion function.
func Convert_v1_NetworkDeviceData_To_v1beta2_NetworkDeviceData(in *v1.NetworkDeviceData, out *resourcev1beta2.NetworkDeviceData, s conversion.Scope) error {
	return autoConvert_v1_NetworkDeviceData_To_v1beta2_NetworkDeviceData(in, out, s)
}

func autoConvert_v1beta2_NetworkDeviceData_To_v1_NetworkDeviceData(in *resourcev1beta2.NetworkDeviceData, out *v1.NetworkDeviceData, s conversion.Scope) error {
	out.InterfaceName = in.InterfaceName
	out.IPs = *(*[]string)(unsafe.Pointer(&in.IPs))
	out.HardwareAddress = in.HardwareAddress
	return nil
}

// Convert_v1beta2_NetworkDeviceData_To_v1_NetworkDeviceData is an autogenerated conversion function.
func Convert_v1beta2_NetworkDeviceData_To_v1_NetworkDeviceData(in *resourcev1beta2.NetworkDeviceData, out *v1.NetworkDeviceData, s conversion.Scope) error {
	return autoConvert_v1beta2_NetworkDeviceData_To_v1_NetworkDeviceData(in, out, s)
}

func autoConvert_v1_OpaqueDeviceConfiguration_To_v1beta2_OpaqueDeviceConfiguration(in *v1.OpaqueDeviceConfiguration, out *resourcev1beta2.OpaqueDeviceConfiguration, s conversion.Scope) error {
	out.Driver = in.Driver
	out.Parameters = in.Parameters
	return nil
}

// Convert_v1_OpaqueDeviceConfiguration_To_v1beta2_OpaqueDeviceConfiguration is an autogenerated conversion function.
func Convert_v1_OpaqueDeviceConfiguration_To_v1beta2_OpaqueDeviceConfiguration(in *v1.OpaqueDeviceConfiguration, out *resourcev1beta2.OpaqueDeviceConfiguration, s conversion.Scope) error {
	return autoConvert_v1_OpaqueDeviceConfiguration_To_v1beta2_OpaqueDeviceConfiguration(in, out, s)
}

func autoConvert_v1beta2_OpaqueDeviceConfiguration_To_v1_OpaqueDeviceConfiguration(in *resourcev1beta2.OpaqueDeviceConfiguration, out *v1.OpaqueDeviceConfiguration, s conversion.Scope) error {
	out.Driver = in.Driver
	out.Parameters = in.Parameters
	return nil
}

// Convert_v1beta2_OpaqueDeviceConfiguration_To_v1_OpaqueDeviceConfiguration is an autogenerated conversion function.
func Convert_v1beta2_OpaqueDeviceConfiguration_To_v1_OpaqueDeviceConfiguration(in *resourcev1beta2.OpaqueDeviceConfiguration, out *v1.OpaqueDeviceConfiguration, s conversion.Scope) error {
	return autoConvert_v1beta2_OpaqueDeviceConfiguration_To_v1_OpaqueDeviceConfiguration(in, out, s)
}

func autoConvert_v1_ResourceClaim_To_v1beta2_ResourceClaim(in *v1.ResourceClaim, out *resourcev1beta2.ResourceClaim, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_ResourceClaimSpec_To_v1beta2_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_ResourceClaimStatus_To_v1beta2_ResourceClaimStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ResourceClaim_To_v1beta2_ResourceClaim is an autogenerated conversion function.
func Convert_v1_ResourceClaim_To_v1beta2_ResourceClaim(in *v1.ResourceClaim, out *resourcev1beta2.ResourceClaim, s conversion.Scope) error {
	return autoConvert_v1_ResourceClaim_To_v1beta2_ResourceClaim(in, out, s)
}

func autoConvert_v1beta2_ResourceClaim_To_v1_ResourceClaim(in *resourcev1beta2.ResourceClaim, out *v1.ResourceClaim, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta2_ResourceClaimSpec_To_v1_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta2_ResourceClaimStatus_To_v1_ResourceClaimStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta2_ResourceClaim_To_v1_ResourceClaim is an autogenerated conversion function.
func Convert_v1beta2_ResourceClaim_To_v1_ResourceClaim(in *resourcev1beta2.ResourceClaim, out *v1.ResourceClaim, s conversion.Scope) error {
	return autoConvert_v1beta2_ResourceClaim_To_v1_ResourceClaim(in, out, s)
}

func autoConvert_v1_ResourceClaimConsumerReference_To_v1beta2_ResourceClaimConsumerReference(in *v1.ResourceClaimConsumerReference, out *resourcev1beta2.ResourceClaimConsumerReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Resource = in.Resource
	out.Name = in.Name
	out.UID = types.UID(in.UID)
	return nil
}

// Convert_v1_ResourceClaimConsumerReference_To_v1beta2_ResourceClaimConsumerReference is an autogenerated conversion function.
func Convert_v1_ResourceClaimConsumerReference_To_v1beta2_ResourceClaimConsumerReference(in *v1.ResourceClaimConsumerReference, out *resourcev1beta2.ResourceClaimConsumerReference, s conversion.Scope) error {
	return autoConvert_v1_ResourceClaimConsumerReference_To_v1beta2_ResourceClaimConsumerReference(in, out, s)
}

func autoConvert_v1beta2_ResourceClaimConsumerReference_To_v1_ResourceClaimConsumerReference(in *resourcev1beta2.ResourceClaimConsumerReference, out *v1.ResourceClaimConsumerReference, s conversion.Scope) error {
	out.APIGroup = in.APIGroup
	out.Resource = in.Resource
	out.Name = in.Name
	out.UID = types.UID(in.UID)
	return nil
}

// Convert_v1beta2_ResourceClaimConsumerReference_To_v1_ResourceClaimConsumerReference is an autogenerated conversion function.
func Convert_v1beta2_ResourceClaimConsumerReference_To_v1_ResourceClaimConsumerReference(in *resourcev1beta2.ResourceClaimConsumerReference, out *v1.ResourceClaimConsumerReference, s conversion.Scope) error {
	return autoConvert_v1beta2_ResourceClaimConsumerReference_To_v1_ResourceClaimConsumerReference(in, out, s)
}

func autoConvert_v1_ResourceClaimList_To_v1beta2_ResourceClaimList(in *v1.ResourceClaimList, out *resourcev1beta2.ResourceClaimList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resourcev1beta2.ResourceClaim)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_ResourceClaimList_To_v1beta2_ResourceClaimList is an autogenerated conversion function.
func Convert_v1_ResourceClaimList_To_v1beta2_ResourceClaimList(in *v1.ResourceClaimList, out *resourcev1beta2.ResourceClaimList, s conversion.Scope) error {
	return autoConvert_v1_ResourceClaimList_To_v1beta2_ResourceClaimList(in, out, s)
}

func autoConvert_v1beta2_ResourceClaimList_To_v1_ResourceClaimList(in *resourcev1beta2.ResourceClaimList, out *v1.ResourceClaimList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1.ResourceClaim)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1beta2_ResourceClaimList_To_v1_ResourceClaimList is an autogenerated conversion function.
func Convert_v1beta2_ResourceClaimList_To_v1_ResourceClaimList(in *resourcev1beta2.ResourceClaimList, out *v1.ResourceClaimList, s conversion.Scope) error {
	return autoConvert_v1beta2_ResourceClaimList_To_v1_ResourceClaimList(in, out, s)
}

func autoConvert_v1_ResourceClaimSpec_To_v1beta2_ResourceClaimSpec(in *v1.ResourceClaimSpec, out *resourcev1beta2.ResourceClaimSpec, s conversion.Scope) error {
	if err := Convert_v1_DeviceClaim_To_v1beta2_DeviceClaim(&in.Devices, &out.Devices, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ResourceClaimSpec_To_v1beta2_ResourceClaimSpec is an autogenerated conversion function.
func Convert_v1_ResourceClaimSpec_To_v1beta2_ResourceClaimSpec(in *v1.ResourceClaimSpec, out *resourcev1beta2.ResourceClaimSpec, s conversion.Scope) error {
	return autoConvert_v1_ResourceClaimSpec_To_v1beta2_ResourceClaimSpec(in, out, s)
}

func autoConvert_v1beta2_ResourceClaimSpec_To_v1_ResourceClaimSpec(in *resourcev1beta2.ResourceClaimSpec, out *v1.ResourceClaimSpec, s conversion.Scope) error {
	if err := Convert_v1beta2_DeviceClaim_To_v1_DeviceClaim(&in.Devices, &out.Devices, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta2_ResourceClaimSpec_To_v1_ResourceClaimSpec is an autogenerated conversion function.
func Convert_v1beta2_ResourceClaimSpec_To_v1_ResourceClaimSpec(in *resourcev1beta2.ResourceClaimSpec, out *v1.ResourceClaimSpec, s conversion.Scope) error {
	return autoConvert_v1beta2_ResourceClaimSpec_To_v1_ResourceClaimSpec(in, out, s)
}

func autoConvert_v1_ResourceClaimStatus_To_v1beta2_ResourceClaimStatus(in *v1.ResourceClaimStatus, out *resourcev1beta2.ResourceClaimStatus, s conversion.Scope) error {
	out.Allocation = (*resourcev1beta2.AllocationResult)(unsafe.Pointer(in.Allocation))
	out.ReservedFor = *(*[]resourcev1beta2.ResourceClaimConsumerReference)(unsafe.Pointer(&in.ReservedFor))
	out.Devices = *(*[]resourcev1beta2.AllocatedDeviceStatus)(unsafe.Pointer(&in.Devices))
	return nil
}

// Convert_v1_ResourceClaimStatus_To_v1beta2_ResourceClaimStatus is an autogenerated conversion function.
func Convert_v1_ResourceClaimStatus_To_v1beta2_ResourceClaimStatus(in *v1.ResourceClaimStatus, out *resourcev1beta2.ResourceClaimStatus, s conversion.Scope) error {
	return autoConvert_v1_ResourceClaimStatus_To_v1beta2_ResourceClaimStatus(in, out, s)
}

func autoConvert_v1beta2_ResourceClaimStatus_To_v1_ResourceClaimStatus(in *resourcev1beta2.ResourceClaimStatus, out *v1.ResourceClaimStatus, s conversion.Scope) error {
	out.Allocation = (*v1.AllocationResult)(unsafe.Pointer(in.Allocation))
	out.ReservedFor = *(*[]v1.ResourceClaimConsumerReference)(unsafe.Pointer(&in.ReservedFor))
	out.Devices = *(*[]v1.AllocatedDeviceStatus)(unsafe.Pointer(&in.Devices))
	return nil
}

// Convert_v1beta2_ResourceClaimStatus_To_v1_ResourceClaimStatus is an autogenerated conversion function.
func Convert_v1beta2_ResourceClaimStatus_To_v1_ResourceClaimStatus(in *resourcev1beta2.ResourceClaimStatus, out *v1.ResourceClaimStatus, s conversion.Scope) error {
	return autoConvert_v1beta2_ResourceClaimStatus_To_v1_ResourceClaimStatus(in, out, s)
}

func autoConvert_v1_ResourceClaimTemplate_To_v1beta2_ResourceClaimTemplate(in *v1.ResourceClaimTemplate, out *resourcev1beta2.ResourceClaimTemplate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_ResourceClaimTemplateSpec_To_v1beta2_ResourceClaimTemplateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ResourceClaimTemplate_To_v1beta2_ResourceClaimTemplate is an autogenerated conversion function.
func Convert_v1_ResourceClaimTemplate_To_v1beta2_ResourceClaimTemplate(in *v1.ResourceClaimTemplate, out *resourcev1beta2.ResourceClaimTemplate, s conversion.Scope) error {
	return autoConvert_v1_ResourceClaimTemplate_To_v1beta2_ResourceClaimTemplate(in, out, s)
}

func autoConvert_v1beta2_ResourceClaimTemplate_To_v1_ResourceClaimTemplate(in *resourcev1beta2.ResourceClaimTemplate, out *v1.ResourceClaimTemplate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta2_ResourceClaimTemplateSpec_To_v1_ResourceClaimTemplateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta2_ResourceClaimTemplate_To_v1_ResourceClaimTemplate is an autogenerated conversion function.
func Convert_v1beta2_ResourceClaimTemplate_To_v1_ResourceClaimTemplate(in *resourcev1beta2.ResourceClaimTemplate, out *v1.ResourceClaimTemplate, s conversion.Scope) error {
	return autoConvert_v1beta2_ResourceClaimTemplate_To_v1_ResourceClaimTemplate(in, out, s)
}

func autoConvert_v1_ResourceClaimTemplateList_To_v1beta2_ResourceClaimTemplateList(in *v1.ResourceClaimTemplateList, out *resourcev1beta2.ResourceClaimTemplateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resourcev1beta2.ResourceClaimTemplate)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_ResourceClaimTemplateList_To_v1beta2_ResourceClaimTemplateList is an autogenerated conversion function.
func Convert_v1_ResourceClaimTemplateList_To_v1beta2_ResourceClaimTemplateList(in *v1.ResourceClaimTemplateList, out *resourcev1beta2.ResourceClaimTemplateList, s conversion.Scope) error {
	return autoConvert_v1_ResourceClaimTemplateList_To_v1beta2_ResourceClaimTemplateList(in, out, s)
}

func autoConvert_v1beta2_ResourceClaimTemplateList_To_v1_ResourceClaimTemplateList(in *resourcev1beta2.ResourceClaimTemplateList, out *v1.ResourceClaimTemplateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1.ResourceClaimTemplate)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1beta2_ResourceClaimTemplateList_To_v1_ResourceClaimTemplateList is an autogenerated conversion function.
func Convert_v1beta2_ResourceClaimTemplateList_To_v1_ResourceClaimTemplateList(in *resourcev1beta2.ResourceClaimTemplateList, out *v1.ResourceClaimTemplateList, s conversion.Scope) error {
	return autoConvert_v1beta2_ResourceClaimTemplateList_To_v1_ResourceClaimTemplateList(in, out, s)
}

func autoConvert_v1_ResourceClaimTemplateSpec_To_v1beta2_ResourceClaimTemplateSpec(in *v1.ResourceClaimTemplateSpec, out *resourcev1beta2.ResourceClaimTemplateSpec, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_ResourceClaimSpec_To_v1beta2_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ResourceClaimTemplateSpec_To_v1beta2_ResourceClaimTemplateSpec is an autogenerated conversion function.
func Convert_v1_ResourceClaimTemplateSpec_To_v1beta2_ResourceClaimTemplateSpec(in *v1.ResourceClaimTemplateSpec, out *resourcev1beta2.ResourceClaimTemplateSpec, s conversion.Scope) error {
	return autoConvert_v1_ResourceClaimTemplateSpec_To_v1beta2_ResourceClaimTemplateSpec(in, out, s)
}

func autoConvert_v1beta2_ResourceClaimTemplateSpec_To_v1_ResourceClaimTemplateSpec(in *resourcev1beta2.ResourceClaimTemplateSpec, out *v1.ResourceClaimTemplateSpec, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta2_ResourceClaimSpec_To_v1_ResourceClaimSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta2_ResourceClaimTemplateSpec_To_v1_ResourceClaimTemplateSpec is an autogenerated conversion function.
func Convert_v1beta2_ResourceClaimTemplateSpec_To_v1_ResourceClaimTemplateSpec(in *resourcev1beta2.ResourceClaimTemplateSpec, out *v1.ResourceClaimTemplateSpec, s conversion.Scope) error {
	return autoConvert_v1beta2_ResourceClaimTemplateSpec_To_v1_ResourceClaimTemplateSpec(in, out, s)
}

func autoConvert_v1_ResourcePool_To_v1beta2_ResourcePool(in *v1.ResourcePool, out *resourcev1beta2.ResourcePool, s conversion.Scope) error {
	out.Name = in.Name
	out.Generation = in.Generation
	out.ResourceSliceCount = in.ResourceSliceCount
	return nil
}

// Convert_v1_ResourcePool_To_v1beta2_ResourcePool is an autogenerated conversion function.
func Convert_v1_ResourcePool_To_v1beta2_ResourcePool(in *v1.ResourcePool, out *resourcev1beta2.ResourcePool, s conversion.Scope) error {
	return autoConvert_v1_ResourcePool_To_v1beta2_ResourcePool(in, out, s)
}

func autoConvert_v1beta2_ResourcePool_To_v1_ResourcePool(in *resourcev1beta2.ResourcePool, out *v1.ResourcePool, s conversion.Scope) error {
	out.Name = in.Name
	out.Generation = in.Generation
	out.ResourceSliceCount = in.ResourceSliceCount
	return nil
}

// Convert_v1beta2_ResourcePool_To_v1_ResourcePool is an autogenerated conversion function.
func Convert_v1beta2_ResourcePool_To_v1_ResourcePool(in *resourcev1beta2.ResourcePool, out *v1.ResourcePool, s conversion.Scope) error {
	return autoConvert_v1beta2_ResourcePool_To_v1_ResourcePool(in, out, s)
}

func autoConvert_v1_ResourceSlice_To_v1beta2_ResourceSlice(in *v1.ResourceSlice, out *resourcev1beta2.ResourceSlice, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_ResourceSliceSpec_To_v1beta2_ResourceSliceSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ResourceSlice_To_v1beta2_ResourceSlice is an autogenerated conversion function.
func Convert_v1_ResourceSlice_To_v1beta2_ResourceSlice(in *v1.ResourceSlice, out *resourcev1beta2.ResourceSlice, s conversion.Scope) error {
	return autoConvert_v1_ResourceSlice_To_v1beta2_ResourceSlice(in, out, s)
}

func autoConvert_v1beta2_ResourceSlice_To_v1_ResourceSlice(in *resourcev1beta2.ResourceSlice, out *v1.ResourceSlice, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta2_ResourceSliceSpec_To_v1_ResourceSliceSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta2_ResourceSlice_To_v1_ResourceSlice is an autogenerated conversion function.
func Convert_v1beta2_ResourceSlice_To_v1_ResourceSlice(in *resourcev1beta2.ResourceSlice, out *v1.ResourceSlice, s conversion.Scope) error {
	return autoConvert_v1beta2_ResourceSlice_To_v1_ResourceSlice(in, out, s)
}

func autoConvert_v1_ResourceSliceList_To_v1beta2_ResourceSliceList(in *v1.ResourceSliceList, out *resourcev1beta2.ResourceSliceList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]resourcev1beta2.ResourceSlice)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_ResourceSliceList_To_v1beta2_ResourceSliceList is an autogenerated conversion function.
func Convert_v1_ResourceSliceList_To_v1beta2_ResourceSliceList(in *v1.ResourceSliceList, out *resourcev1beta2.ResourceSliceList, s conversion.Scope) error {
	return autoConvert_v1_ResourceSliceList_To_v1beta2_ResourceSliceList(in, out, s)
}

func autoConvert_v1beta2_ResourceSliceList_To_v1_ResourceSliceList(in *resourcev1beta2.ResourceSliceList, out *v1.ResourceSliceList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1.ResourceSlice)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1beta2_ResourceSliceList_To_v1_ResourceSliceList is an autogenerated conversion function.
func Convert_v1beta2_ResourceSliceList_To_v1_ResourceSliceList(in *resourcev1beta2.ResourceSliceList, out *v1.ResourceSliceList, s conversion.Scope) error {
	return autoConvert_v1beta2_ResourceSliceList_To_v1_ResourceSliceList(in, out, s)
}

func autoConvert_v1_ResourceSliceSpec_To_v1beta2_ResourceSliceSpec(in *v1.ResourceSliceSpec, out *resourcev1beta2.ResourceSliceSpec, s conversion.Scope) error {
	out.Driver = in.Driver
	if err := Convert_v1_ResourcePool_To_v1beta2_ResourcePool(&in.Pool, &out.Pool, s); err != nil {
		return err
	}
	out.NodeName = (*string)(unsafe.Pointer(in.NodeName))
	out.NodeSelector = (*corev1.NodeSelector)(unsafe.Pointer(in.NodeSelector))
	out.AllNodes = (*bool)(unsafe.Pointer(in.AllNodes))
	out.Devices = *(*[]resourcev1beta2.Device)(unsafe.Pointer(&in.Devices))
	out.PerDeviceNodeSelection = (*bool)(unsafe.Pointer(in.PerDeviceNodeSelection))
	out.SharedCounters = *(*[]resourcev1beta2.CounterSet)(unsafe.Pointer(&in.SharedCounters))
	return nil
}

// Convert_v1_ResourceSliceSpec_To_v1beta2_ResourceSliceSpec is an autogenerated conversion function.
func Convert_v1_ResourceSliceSpec_To_v1beta2_ResourceSliceSpec(in *v1.ResourceSliceSpec, out *resourcev1beta2.ResourceSliceSpec, s conversion.Scope) error {
	return autoConvert_v1_ResourceSliceSpec_To_v1beta2_ResourceSliceSpec(in, out, s)
}

func autoConvert_v1beta2_ResourceSliceSpec_To_v1_ResourceSliceSpec(in *resourcev1beta2.ResourceSliceSpec, out *v1.ResourceSliceSpec, s conversion.Scope) error {
	out.Driver = in.Driver
	if err := Convert_v1beta2_ResourcePool_To_v1_ResourcePool(&in.Pool, &out.Pool, s); err != nil {
		return err
	}
	out.NodeName = (*string)(unsafe.Pointer(in.NodeName))
	out.NodeSelector = (*corev1.NodeSelector)(unsafe.Pointer(in.NodeSelector))
	out.AllNodes = (*bool)(unsafe.Pointer(in.AllNodes))
	out.Devices = *(*[]v1.Device)(unsafe.Pointer(&in.Devices))
	out.PerDeviceNodeSelection = (*bool)(unsafe.Pointer(in.PerDeviceNodeSelection))
	out.SharedCounters = *(*[]v1.CounterSet)(unsafe.Pointer(&in.SharedCounters))
	return nil
}

// Convert_v1beta2_ResourceSliceSpec_To_v1_ResourceSliceSpec is an autogenerated conversion function.
func Convert_v1beta2_ResourceSliceSpec_To_v1_ResourceSliceSpec(in *resourcev1beta2.ResourceSliceSpec, out *v1.ResourceSliceSpec, s conversion.Scope) error {
	return autoConvert_v1beta2_ResourceSliceSpec_To_v1_ResourceSliceSpec(in, out, s)
}
