//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package labservices

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/labservices/mgmt/2021-11-15-preview/labservices"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ActionType = original.ActionType

const (
	ActionTypeInternal ActionType = original.ActionTypeInternal
)

type ConnectionType = original.ConnectionType

const (
	ConnectionTypeNone    ConnectionType = original.ConnectionTypeNone
	ConnectionTypePrivate ConnectionType = original.ConnectionTypePrivate
	ConnectionTypePublic  ConnectionType = original.ConnectionTypePublic
)

type CreateOption = original.CreateOption

const (
	CreateOptionImage      CreateOption = original.CreateOptionImage
	CreateOptionTemplateVM CreateOption = original.CreateOptionTemplateVM
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type EnableState = original.EnableState

const (
	EnableStateDisabled EnableState = original.EnableStateDisabled
	EnableStateEnabled  EnableState = original.EnableStateEnabled
)

type InvitationState = original.InvitationState

const (
	InvitationStateFailed  InvitationState = original.InvitationStateFailed
	InvitationStateNotSent InvitationState = original.InvitationStateNotSent
	InvitationStateSending InvitationState = original.InvitationStateSending
	InvitationStateSent    InvitationState = original.InvitationStateSent
)

type LabState = original.LabState

const (
	LabStateDraft      LabState = original.LabStateDraft
	LabStatePublished  LabState = original.LabStatePublished
	LabStatePublishing LabState = original.LabStatePublishing
	LabStateScaling    LabState = original.LabStateScaling
	LabStateSyncing    LabState = original.LabStateSyncing
)

type OperationStatus = original.OperationStatus

const (
	OperationStatusCanceled   OperationStatus = original.OperationStatusCanceled
	OperationStatusFailed     OperationStatus = original.OperationStatusFailed
	OperationStatusInProgress OperationStatus = original.OperationStatusInProgress
	OperationStatusNotStarted OperationStatus = original.OperationStatusNotStarted
	OperationStatusSucceeded  OperationStatus = original.OperationStatusSucceeded
)

type Origin = original.Origin

const (
	OriginSystem     Origin = original.OriginSystem
	OriginUser       Origin = original.OriginUser
	OriginUsersystem Origin = original.OriginUsersystem
)

type OsState = original.OsState

const (
	OsStateGeneralized OsState = original.OsStateGeneralized
	OsStateSpecialized OsState = original.OsStateSpecialized
)

type OsType = original.OsType

const (
	OsTypeLinux   OsType = original.OsTypeLinux
	OsTypeWindows OsType = original.OsTypeWindows
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateCreating  ProvisioningState = original.ProvisioningStateCreating
	ProvisioningStateDeleting  ProvisioningState = original.ProvisioningStateDeleting
	ProvisioningStateFailed    ProvisioningState = original.ProvisioningStateFailed
	ProvisioningStateLocked    ProvisioningState = original.ProvisioningStateLocked
	ProvisioningStateSucceeded ProvisioningState = original.ProvisioningStateSucceeded
	ProvisioningStateUpdating  ProvisioningState = original.ProvisioningStateUpdating
)

type RecurrenceFrequency = original.RecurrenceFrequency

const (
	RecurrenceFrequencyDaily  RecurrenceFrequency = original.RecurrenceFrequencyDaily
	RecurrenceFrequencyWeekly RecurrenceFrequency = original.RecurrenceFrequencyWeekly
)

type RegistrationState = original.RegistrationState

const (
	RegistrationStateNotRegistered RegistrationState = original.RegistrationStateNotRegistered
	RegistrationStateRegistered    RegistrationState = original.RegistrationStateRegistered
)

type ResourceIdentityType = original.ResourceIdentityType

const (
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = original.ResourceIdentityTypeSystemAssigned
)

type RestrictionReasonCode = original.RestrictionReasonCode

const (
	RestrictionReasonCodeNotAvailableForSubscription RestrictionReasonCode = original.RestrictionReasonCodeNotAvailableForSubscription
	RestrictionReasonCodeQuotaID                     RestrictionReasonCode = original.RestrictionReasonCodeQuotaID
)

type RestrictionType = original.RestrictionType

const (
	RestrictionTypeLocation RestrictionType = original.RestrictionTypeLocation
)

type ScaleType = original.ScaleType

const (
	ScaleTypeAutomatic ScaleType = original.ScaleTypeAutomatic
	ScaleTypeManual    ScaleType = original.ScaleTypeManual
	ScaleTypeNone      ScaleType = original.ScaleTypeNone
)

type ShutdownOnIdleMode = original.ShutdownOnIdleMode

const (
	ShutdownOnIdleModeLowUsage    ShutdownOnIdleMode = original.ShutdownOnIdleModeLowUsage
	ShutdownOnIdleModeNone        ShutdownOnIdleMode = original.ShutdownOnIdleModeNone
	ShutdownOnIdleModeUserAbsence ShutdownOnIdleMode = original.ShutdownOnIdleModeUserAbsence
)

type SkuTier = original.SkuTier

const (
	SkuTierBasic    SkuTier = original.SkuTierBasic
	SkuTierFree     SkuTier = original.SkuTierFree
	SkuTierPremium  SkuTier = original.SkuTierPremium
	SkuTierStandard SkuTier = original.SkuTierStandard
)

type SkuTierEnum = original.SkuTierEnum

const (
	SkuTierEnumPremium  SkuTierEnum = original.SkuTierEnumPremium
	SkuTierEnumStandard SkuTierEnum = original.SkuTierEnumStandard
)

type UsageUnit = original.UsageUnit

const (
	UsageUnitCount UsageUnit = original.UsageUnitCount
)

type VirtualMachineState = original.VirtualMachineState

const (
	VirtualMachineStateRedeploying       VirtualMachineState = original.VirtualMachineStateRedeploying
	VirtualMachineStateReimaging         VirtualMachineState = original.VirtualMachineStateReimaging
	VirtualMachineStateResettingPassword VirtualMachineState = original.VirtualMachineStateResettingPassword
	VirtualMachineStateRunning           VirtualMachineState = original.VirtualMachineStateRunning
	VirtualMachineStateStarting          VirtualMachineState = original.VirtualMachineStateStarting
	VirtualMachineStateStopped           VirtualMachineState = original.VirtualMachineStateStopped
	VirtualMachineStateStopping          VirtualMachineState = original.VirtualMachineStateStopping
)

type VirtualMachineType = original.VirtualMachineType

const (
	VirtualMachineTypeTemplate VirtualMachineType = original.VirtualMachineTypeTemplate
	VirtualMachineTypeUser     VirtualMachineType = original.VirtualMachineTypeUser
)

type WeekDay = original.WeekDay

const (
	WeekDayFriday    WeekDay = original.WeekDayFriday
	WeekDayMonday    WeekDay = original.WeekDayMonday
	WeekDaySaturday  WeekDay = original.WeekDaySaturday
	WeekDaySunday    WeekDay = original.WeekDaySunday
	WeekDayThursday  WeekDay = original.WeekDayThursday
	WeekDayTuesday   WeekDay = original.WeekDayTuesday
	WeekDayWednesday WeekDay = original.WeekDayWednesday
)

type AutoShutdownProfile = original.AutoShutdownProfile
type AzureEntityResource = original.AzureEntityResource
type BaseClient = original.BaseClient
type ConnectionProfile = original.ConnectionProfile
type Credentials = original.Credentials
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorDetail = original.ErrorDetail
type ErrorResponse = original.ErrorResponse
type Identity = original.Identity
type Image = original.Image
type ImageProperties = original.ImageProperties
type ImageReference = original.ImageReference
type ImageUpdate = original.ImageUpdate
type ImageUpdateProperties = original.ImageUpdateProperties
type ImagesClient = original.ImagesClient
type InviteBody = original.InviteBody
type Lab = original.Lab
type LabNetworkProfile = original.LabNetworkProfile
type LabPlan = original.LabPlan
type LabPlanNetworkProfile = original.LabPlanNetworkProfile
type LabPlanProperties = original.LabPlanProperties
type LabPlanUpdate = original.LabPlanUpdate
type LabPlanUpdateProperties = original.LabPlanUpdateProperties
type LabPlansClient = original.LabPlansClient
type LabPlansCreateOrUpdateFuture = original.LabPlansCreateOrUpdateFuture
type LabPlansDeleteFuture = original.LabPlansDeleteFuture
type LabPlansSaveImageFuture = original.LabPlansSaveImageFuture
type LabPlansUpdateFuture = original.LabPlansUpdateFuture
type LabProperties = original.LabProperties
type LabUpdate = original.LabUpdate
type LabUpdateProperties = original.LabUpdateProperties
type LabsClient = original.LabsClient
type LabsCreateOrUpdateFuture = original.LabsCreateOrUpdateFuture
type LabsDeleteFuture = original.LabsDeleteFuture
type LabsPublishFuture = original.LabsPublishFuture
type LabsSyncGroupFuture = original.LabsSyncGroupFuture
type LabsUpdateFuture = original.LabsUpdateFuture
type ListUsagesResult = original.ListUsagesResult
type ListUsagesResultIterator = original.ListUsagesResultIterator
type ListUsagesResultPage = original.ListUsagesResultPage
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationResult = original.OperationResult
type OperationResultsClient = original.OperationResultsClient
type OperationsClient = original.OperationsClient
type PagedImages = original.PagedImages
type PagedImagesIterator = original.PagedImagesIterator
type PagedImagesPage = original.PagedImagesPage
type PagedLabPlans = original.PagedLabPlans
type PagedLabPlansIterator = original.PagedLabPlansIterator
type PagedLabPlansPage = original.PagedLabPlansPage
type PagedLabServicesSkus = original.PagedLabServicesSkus
type PagedLabServicesSkusIterator = original.PagedLabServicesSkusIterator
type PagedLabServicesSkusPage = original.PagedLabServicesSkusPage
type PagedLabs = original.PagedLabs
type PagedLabsIterator = original.PagedLabsIterator
type PagedLabsPage = original.PagedLabsPage
type PagedSchedules = original.PagedSchedules
type PagedSchedulesIterator = original.PagedSchedulesIterator
type PagedSchedulesPage = original.PagedSchedulesPage
type PagedUsers = original.PagedUsers
type PagedUsersIterator = original.PagedUsersIterator
type PagedUsersPage = original.PagedUsersPage
type PagedVirtualMachines = original.PagedVirtualMachines
type PagedVirtualMachinesIterator = original.PagedVirtualMachinesIterator
type PagedVirtualMachinesPage = original.PagedVirtualMachinesPage
type Plan = original.Plan
type ProxyResource = original.ProxyResource
type RecurrencePattern = original.RecurrencePattern
type ResetPasswordBody = original.ResetPasswordBody
type Resource = original.Resource
type ResourceModelWithAllowedPropertySet = original.ResourceModelWithAllowedPropertySet
type ResourceModelWithAllowedPropertySetIdentity = original.ResourceModelWithAllowedPropertySetIdentity
type ResourceModelWithAllowedPropertySetPlan = original.ResourceModelWithAllowedPropertySetPlan
type ResourceModelWithAllowedPropertySetSku = original.ResourceModelWithAllowedPropertySetSku
type RosterProfile = original.RosterProfile
type SaveImageBody = original.SaveImageBody
type Schedule = original.Schedule
type ScheduleProperties = original.ScheduleProperties
type ScheduleUpdate = original.ScheduleUpdate
type ScheduleUpdateProperties = original.ScheduleUpdateProperties
type SchedulesClient = original.SchedulesClient
type SchedulesDeleteFuture = original.SchedulesDeleteFuture
type SecurityProfile = original.SecurityProfile
type Sku = original.Sku
type SkuCapabilities = original.SkuCapabilities
type SkuCapacity = original.SkuCapacity
type SkuCost = original.SkuCost
type SkuRestrictions = original.SkuRestrictions
type SkuType = original.SkuType
type SkusClient = original.SkusClient
type SupportInfo = original.SupportInfo
type SystemData = original.SystemData
type TrackedResource = original.TrackedResource
type TrackedResourceUpdate = original.TrackedResourceUpdate
type Usage = original.Usage
type UsageName = original.UsageName
type UsagesClient = original.UsagesClient
type User = original.User
type UserProperties = original.UserProperties
type UserUpdate = original.UserUpdate
type UserUpdateProperties = original.UserUpdateProperties
type UsersClient = original.UsersClient
type UsersCreateOrUpdateFuture = original.UsersCreateOrUpdateFuture
type UsersDeleteFuture = original.UsersDeleteFuture
type UsersInviteFuture = original.UsersInviteFuture
type UsersUpdateFuture = original.UsersUpdateFuture
type VirtualMachine = original.VirtualMachine
type VirtualMachineAdditionalCapabilities = original.VirtualMachineAdditionalCapabilities
type VirtualMachineConnectionProfile = original.VirtualMachineConnectionProfile
type VirtualMachineProfile = original.VirtualMachineProfile
type VirtualMachineProperties = original.VirtualMachineProperties
type VirtualMachinesClient = original.VirtualMachinesClient
type VirtualMachinesRedeployFuture = original.VirtualMachinesRedeployFuture
type VirtualMachinesReimageFuture = original.VirtualMachinesReimageFuture
type VirtualMachinesResetPasswordFuture = original.VirtualMachinesResetPasswordFuture
type VirtualMachinesStartFuture = original.VirtualMachinesStartFuture
type VirtualMachinesStopFuture = original.VirtualMachinesStopFuture

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewImagesClient(subscriptionID string) ImagesClient {
	return original.NewImagesClient(subscriptionID)
}
func NewImagesClientWithBaseURI(baseURI string, subscriptionID string) ImagesClient {
	return original.NewImagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewLabPlansClient(subscriptionID string) LabPlansClient {
	return original.NewLabPlansClient(subscriptionID)
}
func NewLabPlansClientWithBaseURI(baseURI string, subscriptionID string) LabPlansClient {
	return original.NewLabPlansClientWithBaseURI(baseURI, subscriptionID)
}
func NewLabsClient(subscriptionID string) LabsClient {
	return original.NewLabsClient(subscriptionID)
}
func NewLabsClientWithBaseURI(baseURI string, subscriptionID string) LabsClient {
	return original.NewLabsClientWithBaseURI(baseURI, subscriptionID)
}
func NewListUsagesResultIterator(page ListUsagesResultPage) ListUsagesResultIterator {
	return original.NewListUsagesResultIterator(page)
}
func NewListUsagesResultPage(cur ListUsagesResult, getNextPage func(context.Context, ListUsagesResult) (ListUsagesResult, error)) ListUsagesResultPage {
	return original.NewListUsagesResultPage(cur, getNextPage)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(cur, getNextPage)
}
func NewOperationResultsClient(subscriptionID string) OperationResultsClient {
	return original.NewOperationResultsClient(subscriptionID)
}
func NewOperationResultsClientWithBaseURI(baseURI string, subscriptionID string) OperationResultsClient {
	return original.NewOperationResultsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPagedImagesIterator(page PagedImagesPage) PagedImagesIterator {
	return original.NewPagedImagesIterator(page)
}
func NewPagedImagesPage(cur PagedImages, getNextPage func(context.Context, PagedImages) (PagedImages, error)) PagedImagesPage {
	return original.NewPagedImagesPage(cur, getNextPage)
}
func NewPagedLabPlansIterator(page PagedLabPlansPage) PagedLabPlansIterator {
	return original.NewPagedLabPlansIterator(page)
}
func NewPagedLabPlansPage(cur PagedLabPlans, getNextPage func(context.Context, PagedLabPlans) (PagedLabPlans, error)) PagedLabPlansPage {
	return original.NewPagedLabPlansPage(cur, getNextPage)
}
func NewPagedLabServicesSkusIterator(page PagedLabServicesSkusPage) PagedLabServicesSkusIterator {
	return original.NewPagedLabServicesSkusIterator(page)
}
func NewPagedLabServicesSkusPage(cur PagedLabServicesSkus, getNextPage func(context.Context, PagedLabServicesSkus) (PagedLabServicesSkus, error)) PagedLabServicesSkusPage {
	return original.NewPagedLabServicesSkusPage(cur, getNextPage)
}
func NewPagedLabsIterator(page PagedLabsPage) PagedLabsIterator {
	return original.NewPagedLabsIterator(page)
}
func NewPagedLabsPage(cur PagedLabs, getNextPage func(context.Context, PagedLabs) (PagedLabs, error)) PagedLabsPage {
	return original.NewPagedLabsPage(cur, getNextPage)
}
func NewPagedSchedulesIterator(page PagedSchedulesPage) PagedSchedulesIterator {
	return original.NewPagedSchedulesIterator(page)
}
func NewPagedSchedulesPage(cur PagedSchedules, getNextPage func(context.Context, PagedSchedules) (PagedSchedules, error)) PagedSchedulesPage {
	return original.NewPagedSchedulesPage(cur, getNextPage)
}
func NewPagedUsersIterator(page PagedUsersPage) PagedUsersIterator {
	return original.NewPagedUsersIterator(page)
}
func NewPagedUsersPage(cur PagedUsers, getNextPage func(context.Context, PagedUsers) (PagedUsers, error)) PagedUsersPage {
	return original.NewPagedUsersPage(cur, getNextPage)
}
func NewPagedVirtualMachinesIterator(page PagedVirtualMachinesPage) PagedVirtualMachinesIterator {
	return original.NewPagedVirtualMachinesIterator(page)
}
func NewPagedVirtualMachinesPage(cur PagedVirtualMachines, getNextPage func(context.Context, PagedVirtualMachines) (PagedVirtualMachines, error)) PagedVirtualMachinesPage {
	return original.NewPagedVirtualMachinesPage(cur, getNextPage)
}
func NewSchedulesClient(subscriptionID string) SchedulesClient {
	return original.NewSchedulesClient(subscriptionID)
}
func NewSchedulesClientWithBaseURI(baseURI string, subscriptionID string) SchedulesClient {
	return original.NewSchedulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSkusClient(subscriptionID string) SkusClient {
	return original.NewSkusClient(subscriptionID)
}
func NewSkusClientWithBaseURI(baseURI string, subscriptionID string) SkusClient {
	return original.NewSkusClientWithBaseURI(baseURI, subscriptionID)
}
func NewUsagesClient(subscriptionID string) UsagesClient {
	return original.NewUsagesClient(subscriptionID)
}
func NewUsagesClientWithBaseURI(baseURI string, subscriptionID string) UsagesClient {
	return original.NewUsagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewUsersClient(subscriptionID string) UsersClient {
	return original.NewUsersClient(subscriptionID)
}
func NewUsersClientWithBaseURI(baseURI string, subscriptionID string) UsersClient {
	return original.NewUsersClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachinesClient(subscriptionID string) VirtualMachinesClient {
	return original.NewVirtualMachinesClient(subscriptionID)
}
func NewVirtualMachinesClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachinesClient {
	return original.NewVirtualMachinesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleActionTypeValues() []ActionType {
	return original.PossibleActionTypeValues()
}
func PossibleConnectionTypeValues() []ConnectionType {
	return original.PossibleConnectionTypeValues()
}
func PossibleCreateOptionValues() []CreateOption {
	return original.PossibleCreateOptionValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleEnableStateValues() []EnableState {
	return original.PossibleEnableStateValues()
}
func PossibleInvitationStateValues() []InvitationState {
	return original.PossibleInvitationStateValues()
}
func PossibleLabStateValues() []LabState {
	return original.PossibleLabStateValues()
}
func PossibleOperationStatusValues() []OperationStatus {
	return original.PossibleOperationStatusValues()
}
func PossibleOriginValues() []Origin {
	return original.PossibleOriginValues()
}
func PossibleOsStateValues() []OsState {
	return original.PossibleOsStateValues()
}
func PossibleOsTypeValues() []OsType {
	return original.PossibleOsTypeValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return original.PossibleRecurrenceFrequencyValues()
}
func PossibleRegistrationStateValues() []RegistrationState {
	return original.PossibleRegistrationStateValues()
}
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return original.PossibleResourceIdentityTypeValues()
}
func PossibleRestrictionReasonCodeValues() []RestrictionReasonCode {
	return original.PossibleRestrictionReasonCodeValues()
}
func PossibleRestrictionTypeValues() []RestrictionType {
	return original.PossibleRestrictionTypeValues()
}
func PossibleScaleTypeValues() []ScaleType {
	return original.PossibleScaleTypeValues()
}
func PossibleShutdownOnIdleModeValues() []ShutdownOnIdleMode {
	return original.PossibleShutdownOnIdleModeValues()
}
func PossibleSkuTierEnumValues() []SkuTierEnum {
	return original.PossibleSkuTierEnumValues()
}
func PossibleSkuTierValues() []SkuTier {
	return original.PossibleSkuTierValues()
}
func PossibleUsageUnitValues() []UsageUnit {
	return original.PossibleUsageUnitValues()
}
func PossibleVirtualMachineStateValues() []VirtualMachineState {
	return original.PossibleVirtualMachineStateValues()
}
func PossibleVirtualMachineTypeValues() []VirtualMachineType {
	return original.PossibleVirtualMachineTypeValues()
}
func PossibleWeekDayValues() []WeekDay {
	return original.PossibleWeekDayValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
