package hardwaresecuritymodules

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/hardwaresecuritymodules/mgmt/2021-11-30/hardwaresecuritymodules"

// APIEntityReference the API entity reference.
type APIEntityReference struct {
	// ID - The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
	ID *string `json:"id,omitempty"`
}

// DedicatedHsm resource information with extended details.
type DedicatedHsm struct {
	autorest.Response `json:"-"`
	// SystemData - Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData `json:"systemData,omitempty"`
	// DedicatedHsmProperties - Properties of the dedicated HSM
	*DedicatedHsmProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The Azure Resource Manager resource ID for the dedicated HSM.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the dedicated HSM.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type of the dedicated HSM.
	Type *string `json:"type,omitempty"`
	// Location - The supported Azure location where the dedicated HSM should be created.
	Location *string `json:"location,omitempty"`
	// Sku - SKU details
	Sku *Sku `json:"sku,omitempty"`
	// Zones - The Dedicated Hsm zones.
	Zones *[]string `json:"zones,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DedicatedHsm.
func (dh DedicatedHsm) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dh.SystemData != nil {
		objectMap["systemData"] = dh.SystemData
	}
	if dh.DedicatedHsmProperties != nil {
		objectMap["properties"] = dh.DedicatedHsmProperties
	}
	if dh.Location != nil {
		objectMap["location"] = dh.Location
	}
	if dh.Sku != nil {
		objectMap["sku"] = dh.Sku
	}
	if dh.Zones != nil {
		objectMap["zones"] = dh.Zones
	}
	if dh.Tags != nil {
		objectMap["tags"] = dh.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DedicatedHsm struct.
func (dh *DedicatedHsm) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				dh.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var dedicatedHsmProperties DedicatedHsmProperties
				err = json.Unmarshal(*v, &dedicatedHsmProperties)
				if err != nil {
					return err
				}
				dh.DedicatedHsmProperties = &dedicatedHsmProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dh.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dh.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dh.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dh.Location = &location
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				dh.Sku = &sku
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				dh.Zones = &zones
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dh.Tags = tags
			}
		}
	}

	return nil
}

// DedicatedHsmCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DedicatedHsmCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DedicatedHsmClient) (DedicatedHsm, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DedicatedHsmCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DedicatedHsmCreateOrUpdateFuture.Result.
func (future *DedicatedHsmCreateOrUpdateFuture) result(client DedicatedHsmClient) (dh DedicatedHsm, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hardwaresecuritymodules.DedicatedHsmCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dh.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("hardwaresecuritymodules.DedicatedHsmCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dh.Response.Response, err = future.GetResult(sender); err == nil && dh.Response.Response.StatusCode != http.StatusNoContent {
		dh, err = client.CreateOrUpdateResponder(dh.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hardwaresecuritymodules.DedicatedHsmCreateOrUpdateFuture", "Result", dh.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DedicatedHsmDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DedicatedHsmDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DedicatedHsmClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DedicatedHsmDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DedicatedHsmDeleteFuture.Result.
func (future *DedicatedHsmDeleteFuture) result(client DedicatedHsmClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hardwaresecuritymodules.DedicatedHsmDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("hardwaresecuritymodules.DedicatedHsmDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DedicatedHsmError the error exception.
type DedicatedHsmError struct {
	// Error - READ-ONLY; The error detail of the operation if any.
	Error *Error `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for DedicatedHsmError.
func (dhe DedicatedHsmError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DedicatedHsmListResult list of dedicated HSMs
type DedicatedHsmListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of dedicated HSMs.
	Value *[]DedicatedHsm `json:"value,omitempty"`
	// NextLink - The URL to get the next set of dedicated hsms.
	NextLink *string `json:"nextLink,omitempty"`
}

// DedicatedHsmListResultIterator provides access to a complete listing of DedicatedHsm values.
type DedicatedHsmListResultIterator struct {
	i    int
	page DedicatedHsmListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DedicatedHsmListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DedicatedHsmListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DedicatedHsmListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DedicatedHsmListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DedicatedHsmListResultIterator) Response() DedicatedHsmListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DedicatedHsmListResultIterator) Value() DedicatedHsm {
	if !iter.page.NotDone() {
		return DedicatedHsm{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DedicatedHsmListResultIterator type.
func NewDedicatedHsmListResultIterator(page DedicatedHsmListResultPage) DedicatedHsmListResultIterator {
	return DedicatedHsmListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dhlr DedicatedHsmListResult) IsEmpty() bool {
	return dhlr.Value == nil || len(*dhlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dhlr DedicatedHsmListResult) hasNextLink() bool {
	return dhlr.NextLink != nil && len(*dhlr.NextLink) != 0
}

// dedicatedHsmListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dhlr DedicatedHsmListResult) dedicatedHsmListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dhlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dhlr.NextLink)))
}

// DedicatedHsmListResultPage contains a page of DedicatedHsm values.
type DedicatedHsmListResultPage struct {
	fn   func(context.Context, DedicatedHsmListResult) (DedicatedHsmListResult, error)
	dhlr DedicatedHsmListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DedicatedHsmListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DedicatedHsmListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dhlr)
		if err != nil {
			return err
		}
		page.dhlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DedicatedHsmListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DedicatedHsmListResultPage) NotDone() bool {
	return !page.dhlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DedicatedHsmListResultPage) Response() DedicatedHsmListResult {
	return page.dhlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DedicatedHsmListResultPage) Values() []DedicatedHsm {
	if page.dhlr.IsEmpty() {
		return nil
	}
	return *page.dhlr.Value
}

// Creates a new instance of the DedicatedHsmListResultPage type.
func NewDedicatedHsmListResultPage(cur DedicatedHsmListResult, getNextPage func(context.Context, DedicatedHsmListResult) (DedicatedHsmListResult, error)) DedicatedHsmListResultPage {
	return DedicatedHsmListResultPage{
		fn:   getNextPage,
		dhlr: cur,
	}
}

// DedicatedHsmOperation REST API operation
type DedicatedHsmOperation struct {
	// Name - The name of the Dedicated HSM Resource Provider Operation.
	Name *string `json:"name,omitempty"`
	// IsDataAction - READ-ONLY; Gets or sets a value indicating whether it is a data plane action
	IsDataAction *string `json:"isDataAction,omitempty"`
	// Display - The display string.
	Display *DedicatedHsmOperationDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for DedicatedHsmOperation.
func (dho DedicatedHsmOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dho.Name != nil {
		objectMap["name"] = dho.Name
	}
	if dho.Display != nil {
		objectMap["display"] = dho.Display
	}
	return json.Marshal(objectMap)
}

// DedicatedHsmOperationDisplay the display string.
type DedicatedHsmOperationDisplay struct {
	// Provider - The Resource Provider of the operation
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - The object that represents the operation.
	Description *string `json:"description,omitempty"`
}

// DedicatedHsmOperationListResult result of the request to list Dedicated HSM Provider operations. It
// contains a list of operations.
type DedicatedHsmOperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Dedicated HSM Resource Provider operations.
	Value *[]DedicatedHsmOperation `json:"value,omitempty"`
}

// DedicatedHsmPatchParameters patchable properties of the dedicated HSM
type DedicatedHsmPatchParameters struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DedicatedHsmPatchParameters.
func (dhpp DedicatedHsmPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dhpp.Tags != nil {
		objectMap["tags"] = dhpp.Tags
	}
	return json.Marshal(objectMap)
}

// DedicatedHsmProperties properties of the dedicated hsm
type DedicatedHsmProperties struct {
	// NetworkProfile - Specifies the network interfaces of the dedicated hsm.
	NetworkProfile *NetworkProfile `json:"networkProfile,omitempty"`
	// ManagementNetworkProfile - Specifies the management network interfaces of the dedicated hsm.
	ManagementNetworkProfile *NetworkProfile `json:"managementNetworkProfile,omitempty"`
	// StampID - This field will be used when RP does not support Availability zones.
	StampID *string `json:"stampId,omitempty"`
	// StatusMessage - READ-ONLY; Resource Status Message.
	StatusMessage *string `json:"statusMessage,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state. Possible values include: 'JSONWebKeyTypeSucceeded', 'JSONWebKeyTypeProvisioning', 'JSONWebKeyTypeAllocating', 'JSONWebKeyTypeConnecting', 'JSONWebKeyTypeFailed', 'JSONWebKeyTypeCheckingQuota', 'JSONWebKeyTypeDeleting'
	ProvisioningState JSONWebKeyType `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for DedicatedHsmProperties.
func (dhp DedicatedHsmProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dhp.NetworkProfile != nil {
		objectMap["networkProfile"] = dhp.NetworkProfile
	}
	if dhp.ManagementNetworkProfile != nil {
		objectMap["managementNetworkProfile"] = dhp.ManagementNetworkProfile
	}
	if dhp.StampID != nil {
		objectMap["stampId"] = dhp.StampID
	}
	return json.Marshal(objectMap)
}

// DedicatedHsmUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DedicatedHsmUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DedicatedHsmClient) (DedicatedHsm, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DedicatedHsmUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DedicatedHsmUpdateFuture.Result.
func (future *DedicatedHsmUpdateFuture) result(client DedicatedHsmClient) (dh DedicatedHsm, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hardwaresecuritymodules.DedicatedHsmUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dh.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("hardwaresecuritymodules.DedicatedHsmUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dh.Response.Response, err = future.GetResult(sender); err == nil && dh.Response.Response.StatusCode != http.StatusNoContent {
		dh, err = client.UpdateResponder(dh.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hardwaresecuritymodules.DedicatedHsmUpdateFuture", "Result", dh.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EndpointDependency a domain name that dedicated hsm services are reaching at.
type EndpointDependency struct {
	// DomainName - The domain name of the dependency.
	DomainName *string `json:"domainName,omitempty"`
	// EndpointDetails - The Ports and Protocols used when connecting to domainName.
	EndpointDetails *[]EndpointDetail `json:"endpointDetails,omitempty"`
}

// EndpointDetail connect information from the dedicated hsm service to a single endpoint.
type EndpointDetail struct {
	// IPAddress - An IP Address that Domain Name currently resolves to.
	IPAddress *string `json:"ipAddress,omitempty"`
	// Port - The port an endpoint is connected to.
	Port *int32 `json:"port,omitempty"`
	// Protocol - The protocol used for connection
	Protocol *string `json:"protocol,omitempty"`
	// Description - Description of the detail
	Description *string `json:"description,omitempty"`
}

// Error the key vault server error.
type Error struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// InnerError - READ-ONLY; Contains more specific error that narrows down the cause. May be null.
	InnerError *Error `json:"innererror,omitempty"`
}

// MarshalJSON is the custom marshaler for Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// NetworkInterface the network interface definition.
type NetworkInterface struct {
	// ID - READ-ONLY; The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
	ID *string `json:"id,omitempty"`
	// PrivateIPAddress - Private Ip address of the interface
	PrivateIPAddress *string `json:"privateIpAddress,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkInterface.
func (ni NetworkInterface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ni.PrivateIPAddress != nil {
		objectMap["privateIpAddress"] = ni.PrivateIPAddress
	}
	return json.Marshal(objectMap)
}

// NetworkProfile the network profile definition.
type NetworkProfile struct {
	// Subnet - Specifies the identifier of the subnet.
	Subnet *APIEntityReference `json:"subnet,omitempty"`
	// NetworkInterfaces - Specifies the list of resource Ids for the network interfaces associated with the dedicated HSM.
	NetworkInterfaces *[]NetworkInterface `json:"networkInterfaces,omitempty"`
}

// OutboundEnvironmentEndpoint egress endpoints which dedicated hsm service connects to for common purpose.
type OutboundEnvironmentEndpoint struct {
	// Category - The category of endpoints accessed by the dedicated hsm service, e.g. azure-resource-management, apiserver, etc.
	Category *string `json:"category,omitempty"`
	// Endpoints - The endpoints that dedicated hsm service connects to
	Endpoints *[]EndpointDependency `json:"endpoints,omitempty"`
}

// OutboundEnvironmentEndpointCollection collection of OutboundEnvironmentEndpoint
type OutboundEnvironmentEndpointCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]OutboundEnvironmentEndpoint `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OutboundEnvironmentEndpointCollection.
func (oeec OutboundEnvironmentEndpointCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oeec.Value != nil {
		objectMap["value"] = oeec.Value
	}
	return json.Marshal(objectMap)
}

// OutboundEnvironmentEndpointCollectionIterator provides access to a complete listing of
// OutboundEnvironmentEndpoint values.
type OutboundEnvironmentEndpointCollectionIterator struct {
	i    int
	page OutboundEnvironmentEndpointCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OutboundEnvironmentEndpointCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OutboundEnvironmentEndpointCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OutboundEnvironmentEndpointCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OutboundEnvironmentEndpointCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OutboundEnvironmentEndpointCollectionIterator) Response() OutboundEnvironmentEndpointCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OutboundEnvironmentEndpointCollectionIterator) Value() OutboundEnvironmentEndpoint {
	if !iter.page.NotDone() {
		return OutboundEnvironmentEndpoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OutboundEnvironmentEndpointCollectionIterator type.
func NewOutboundEnvironmentEndpointCollectionIterator(page OutboundEnvironmentEndpointCollectionPage) OutboundEnvironmentEndpointCollectionIterator {
	return OutboundEnvironmentEndpointCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (oeec OutboundEnvironmentEndpointCollection) IsEmpty() bool {
	return oeec.Value == nil || len(*oeec.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (oeec OutboundEnvironmentEndpointCollection) hasNextLink() bool {
	return oeec.NextLink != nil && len(*oeec.NextLink) != 0
}

// outboundEnvironmentEndpointCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oeec OutboundEnvironmentEndpointCollection) outboundEnvironmentEndpointCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !oeec.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oeec.NextLink)))
}

// OutboundEnvironmentEndpointCollectionPage contains a page of OutboundEnvironmentEndpoint values.
type OutboundEnvironmentEndpointCollectionPage struct {
	fn   func(context.Context, OutboundEnvironmentEndpointCollection) (OutboundEnvironmentEndpointCollection, error)
	oeec OutboundEnvironmentEndpointCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OutboundEnvironmentEndpointCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OutboundEnvironmentEndpointCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.oeec)
		if err != nil {
			return err
		}
		page.oeec = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OutboundEnvironmentEndpointCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OutboundEnvironmentEndpointCollectionPage) NotDone() bool {
	return !page.oeec.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OutboundEnvironmentEndpointCollectionPage) Response() OutboundEnvironmentEndpointCollection {
	return page.oeec
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OutboundEnvironmentEndpointCollectionPage) Values() []OutboundEnvironmentEndpoint {
	if page.oeec.IsEmpty() {
		return nil
	}
	return *page.oeec.Value
}

// Creates a new instance of the OutboundEnvironmentEndpointCollectionPage type.
func NewOutboundEnvironmentEndpointCollectionPage(cur OutboundEnvironmentEndpointCollection, getNextPage func(context.Context, OutboundEnvironmentEndpointCollection) (OutboundEnvironmentEndpointCollection, error)) OutboundEnvironmentEndpointCollectionPage {
	return OutboundEnvironmentEndpointCollectionPage{
		fn:   getNextPage,
		oeec: cur,
	}
}

// Resource dedicated HSM resource
type Resource struct {
	// ID - READ-ONLY; The Azure Resource Manager resource ID for the dedicated HSM.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the dedicated HSM.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type of the dedicated HSM.
	Type *string `json:"type,omitempty"`
	// Location - The supported Azure location where the dedicated HSM should be created.
	Location *string `json:"location,omitempty"`
	// Sku - SKU details
	Sku *Sku `json:"sku,omitempty"`
	// Zones - The Dedicated Hsm zones.
	Zones *[]string `json:"zones,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Sku != nil {
		objectMap["sku"] = r.Sku
	}
	if r.Zones != nil {
		objectMap["zones"] = r.Zones
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceListResult list of dedicated HSM resources.
type ResourceListResult struct {
	// Value - The list of dedicated HSM resources.
	Value *[]Resource `json:"value,omitempty"`
	// NextLink - The URL to get the next set of dedicated HSM resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// Sku SKU of the dedicated HSM
type Sku struct {
	// Name - SKU of the dedicated HSM. Possible values include: 'SkuNameSafeNetLunaNetworkHSMA790', 'SkuNamePayShield10KLMK1CPS60', 'SkuNamePayShield10KLMK1CPS250', 'SkuNamePayShield10KLMK1CPS2500', 'SkuNamePayShield10KLMK2CPS60', 'SkuNamePayShield10KLMK2CPS250', 'SkuNamePayShield10KLMK2CPS2500'
	Name SkuName `json:"name,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of dedicated hsm resource.
type SystemData struct {
	// CreatedBy - The identity that created dedicated hsm resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created dedicated hsm resource. Possible values include: 'IdentityTypeUser', 'IdentityTypeApplication', 'IdentityTypeManagedIdentity', 'IdentityTypeKey'
	CreatedByType IdentityType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of dedicated hsm resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified dedicated hsm resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified dedicated hsm resource. Possible values include: 'IdentityTypeUser', 'IdentityTypeApplication', 'IdentityTypeManagedIdentity', 'IdentityTypeKey'
	LastModifiedByType IdentityType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of dedicated hsm resource last modification (UTC).
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}
