// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pcaconnectorscep

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateChallenge = "CreateChallenge"

// CreateChallengeRequest generates a "aws/request.Request" representing the
// client's request for the CreateChallenge operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChallenge for more information on using the CreateChallenge
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateChallengeRequest method.
//	req, resp := client.CreateChallengeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/CreateChallenge
func (c *PcaConnectorScep) CreateChallengeRequest(input *CreateChallengeInput) (req *request.Request, output *CreateChallengeOutput) {
	op := &request.Operation{
		Name:       opCreateChallenge,
		HTTPMethod: "POST",
		HTTPPath:   "/challenges",
	}

	if input == nil {
		input = &CreateChallengeInput{}
	}

	output = &CreateChallengeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChallenge API operation for Private CA Connector for SCEP.
//
// For general-purpose connectors. Creates a challenge password for the specified
// connector. The SCEP protocol uses a challenge password to authenticate a
// request before issuing a certificate from a certificate authority (CA). Your
// SCEP clients include the challenge password as part of their certificate
// request to Connector for SCEP. To retrieve the connector Amazon Resource
// Names (ARNs) for the connectors in your account, call ListConnectors (https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_ListConnectors.html).
//
// To create additional challenge passwords for the connector, call CreateChallenge
// again. We recommend frequently rotating your challenge passwords.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Private CA Connector for SCEP's
// API operation CreateChallenge for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     be incorrectly specified, or it might have a status other than ACTIVE.
//
//   - BadRequestException
//     The request is malformed or contains an error such as an invalid parameter
//     value or a missing required parameter.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     name tag, or an invalid pagination token.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - AccessDeniedException
//     You can receive this error if you attempt to perform an operation and you
//     don't have the required permissions. This can be caused by insufficient permissions
//     in policies attached to your Amazon Web Services Identity and Access Management
//     (IAM) principal. It can also happen because of restrictions in place from
//     an Amazon Web Services Organizations service control policy (SCP) that affects
//     your Amazon Web Services account.
//
//   - ConflictException
//     This request can't be completed for one of the following reasons because
//     the requested resource was being concurrently modified by another request.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/CreateChallenge
func (c *PcaConnectorScep) CreateChallenge(input *CreateChallengeInput) (*CreateChallengeOutput, error) {
	req, out := c.CreateChallengeRequest(input)
	return out, req.Send()
}

// CreateChallengeWithContext is the same as CreateChallenge with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChallenge for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorScep) CreateChallengeWithContext(ctx aws.Context, input *CreateChallengeInput, opts ...request.Option) (*CreateChallengeOutput, error) {
	req, out := c.CreateChallengeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConnector = "CreateConnector"

// CreateConnectorRequest generates a "aws/request.Request" representing the
// client's request for the CreateConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConnector for more information on using the CreateConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateConnectorRequest method.
//	req, resp := client.CreateConnectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/CreateConnector
func (c *PcaConnectorScep) CreateConnectorRequest(input *CreateConnectorInput) (req *request.Request, output *CreateConnectorOutput) {
	op := &request.Operation{
		Name:       opCreateConnector,
		HTTPMethod: "POST",
		HTTPPath:   "/connectors",
	}

	if input == nil {
		input = &CreateConnectorInput{}
	}

	output = &CreateConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConnector API operation for Private CA Connector for SCEP.
//
// Creates a SCEP connector. A SCEP connector links Amazon Web Services Private
// Certificate Authority to your SCEP-compatible devices and mobile device management
// (MDM) systems. Before you create a connector, you must complete a set of
// prerequisites, including creation of a private certificate authority (CA)
// to use with this connector. For more information, see Connector for SCEP
// prerequisites (https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-prerequisites.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Private CA Connector for SCEP's
// API operation CreateConnector for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     be incorrectly specified, or it might have a status other than ACTIVE.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     name tag, or an invalid pagination token.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - AccessDeniedException
//     You can receive this error if you attempt to perform an operation and you
//     don't have the required permissions. This can be caused by insufficient permissions
//     in policies attached to your Amazon Web Services Identity and Access Management
//     (IAM) principal. It can also happen because of restrictions in place from
//     an Amazon Web Services Organizations service control policy (SCP) that affects
//     your Amazon Web Services account.
//
//   - ConflictException
//     This request can't be completed for one of the following reasons because
//     the requested resource was being concurrently modified by another request.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/CreateConnector
func (c *PcaConnectorScep) CreateConnector(input *CreateConnectorInput) (*CreateConnectorOutput, error) {
	req, out := c.CreateConnectorRequest(input)
	return out, req.Send()
}

// CreateConnectorWithContext is the same as CreateConnector with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorScep) CreateConnectorWithContext(ctx aws.Context, input *CreateConnectorInput, opts ...request.Option) (*CreateConnectorOutput, error) {
	req, out := c.CreateConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChallenge = "DeleteChallenge"

// DeleteChallengeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChallenge operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChallenge for more information on using the DeleteChallenge
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChallengeRequest method.
//	req, resp := client.DeleteChallengeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/DeleteChallenge
func (c *PcaConnectorScep) DeleteChallengeRequest(input *DeleteChallengeInput) (req *request.Request, output *DeleteChallengeOutput) {
	op := &request.Operation{
		Name:       opDeleteChallenge,
		HTTPMethod: "DELETE",
		HTTPPath:   "/challenges/{ChallengeArn}",
	}

	if input == nil {
		input = &DeleteChallengeInput{}
	}

	output = &DeleteChallengeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChallenge API operation for Private CA Connector for SCEP.
//
// Deletes the specified Challenge (https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Challenge.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Private CA Connector for SCEP's
// API operation DeleteChallenge for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     be incorrectly specified, or it might have a status other than ACTIVE.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     name tag, or an invalid pagination token.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - AccessDeniedException
//     You can receive this error if you attempt to perform an operation and you
//     don't have the required permissions. This can be caused by insufficient permissions
//     in policies attached to your Amazon Web Services Identity and Access Management
//     (IAM) principal. It can also happen because of restrictions in place from
//     an Amazon Web Services Organizations service control policy (SCP) that affects
//     your Amazon Web Services account.
//
//   - ConflictException
//     This request can't be completed for one of the following reasons because
//     the requested resource was being concurrently modified by another request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/DeleteChallenge
func (c *PcaConnectorScep) DeleteChallenge(input *DeleteChallengeInput) (*DeleteChallengeOutput, error) {
	req, out := c.DeleteChallengeRequest(input)
	return out, req.Send()
}

// DeleteChallengeWithContext is the same as DeleteChallenge with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChallenge for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorScep) DeleteChallengeWithContext(ctx aws.Context, input *DeleteChallengeInput, opts ...request.Option) (*DeleteChallengeOutput, error) {
	req, out := c.DeleteChallengeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConnector = "DeleteConnector"

// DeleteConnectorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConnector for more information on using the DeleteConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConnectorRequest method.
//	req, resp := client.DeleteConnectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/DeleteConnector
func (c *PcaConnectorScep) DeleteConnectorRequest(input *DeleteConnectorInput) (req *request.Request, output *DeleteConnectorOutput) {
	op := &request.Operation{
		Name:       opDeleteConnector,
		HTTPMethod: "DELETE",
		HTTPPath:   "/connectors/{ConnectorArn}",
	}

	if input == nil {
		input = &DeleteConnectorInput{}
	}

	output = &DeleteConnectorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConnector API operation for Private CA Connector for SCEP.
//
// Deletes the specified Connector (https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Connector.html).
// This operation also deletes any challenges associated with the connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Private CA Connector for SCEP's
// API operation DeleteConnector for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     be incorrectly specified, or it might have a status other than ACTIVE.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     name tag, or an invalid pagination token.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - AccessDeniedException
//     You can receive this error if you attempt to perform an operation and you
//     don't have the required permissions. This can be caused by insufficient permissions
//     in policies attached to your Amazon Web Services Identity and Access Management
//     (IAM) principal. It can also happen because of restrictions in place from
//     an Amazon Web Services Organizations service control policy (SCP) that affects
//     your Amazon Web Services account.
//
//   - ConflictException
//     This request can't be completed for one of the following reasons because
//     the requested resource was being concurrently modified by another request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/DeleteConnector
func (c *PcaConnectorScep) DeleteConnector(input *DeleteConnectorInput) (*DeleteConnectorOutput, error) {
	req, out := c.DeleteConnectorRequest(input)
	return out, req.Send()
}

// DeleteConnectorWithContext is the same as DeleteConnector with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorScep) DeleteConnectorWithContext(ctx aws.Context, input *DeleteConnectorInput, opts ...request.Option) (*DeleteConnectorOutput, error) {
	req, out := c.DeleteConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChallengeMetadata = "GetChallengeMetadata"

// GetChallengeMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetChallengeMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChallengeMetadata for more information on using the GetChallengeMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetChallengeMetadataRequest method.
//	req, resp := client.GetChallengeMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/GetChallengeMetadata
func (c *PcaConnectorScep) GetChallengeMetadataRequest(input *GetChallengeMetadataInput) (req *request.Request, output *GetChallengeMetadataOutput) {
	op := &request.Operation{
		Name:       opGetChallengeMetadata,
		HTTPMethod: "GET",
		HTTPPath:   "/challengeMetadata/{ChallengeArn}",
	}

	if input == nil {
		input = &GetChallengeMetadataInput{}
	}

	output = &GetChallengeMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChallengeMetadata API operation for Private CA Connector for SCEP.
//
// Retrieves the metadata for the specified Challenge (https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Challenge.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Private CA Connector for SCEP's
// API operation GetChallengeMetadata for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     be incorrectly specified, or it might have a status other than ACTIVE.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     name tag, or an invalid pagination token.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - AccessDeniedException
//     You can receive this error if you attempt to perform an operation and you
//     don't have the required permissions. This can be caused by insufficient permissions
//     in policies attached to your Amazon Web Services Identity and Access Management
//     (IAM) principal. It can also happen because of restrictions in place from
//     an Amazon Web Services Organizations service control policy (SCP) that affects
//     your Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/GetChallengeMetadata
func (c *PcaConnectorScep) GetChallengeMetadata(input *GetChallengeMetadataInput) (*GetChallengeMetadataOutput, error) {
	req, out := c.GetChallengeMetadataRequest(input)
	return out, req.Send()
}

// GetChallengeMetadataWithContext is the same as GetChallengeMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetChallengeMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorScep) GetChallengeMetadataWithContext(ctx aws.Context, input *GetChallengeMetadataInput, opts ...request.Option) (*GetChallengeMetadataOutput, error) {
	req, out := c.GetChallengeMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChallengePassword = "GetChallengePassword"

// GetChallengePasswordRequest generates a "aws/request.Request" representing the
// client's request for the GetChallengePassword operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChallengePassword for more information on using the GetChallengePassword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetChallengePasswordRequest method.
//	req, resp := client.GetChallengePasswordRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/GetChallengePassword
func (c *PcaConnectorScep) GetChallengePasswordRequest(input *GetChallengePasswordInput) (req *request.Request, output *GetChallengePasswordOutput) {
	op := &request.Operation{
		Name:       opGetChallengePassword,
		HTTPMethod: "GET",
		HTTPPath:   "/challengePasswords/{ChallengeArn}",
	}

	if input == nil {
		input = &GetChallengePasswordInput{}
	}

	output = &GetChallengePasswordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChallengePassword API operation for Private CA Connector for SCEP.
//
// Retrieves the challenge password for the specified Challenge (https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Challenge.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Private CA Connector for SCEP's
// API operation GetChallengePassword for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     be incorrectly specified, or it might have a status other than ACTIVE.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     name tag, or an invalid pagination token.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - AccessDeniedException
//     You can receive this error if you attempt to perform an operation and you
//     don't have the required permissions. This can be caused by insufficient permissions
//     in policies attached to your Amazon Web Services Identity and Access Management
//     (IAM) principal. It can also happen because of restrictions in place from
//     an Amazon Web Services Organizations service control policy (SCP) that affects
//     your Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/GetChallengePassword
func (c *PcaConnectorScep) GetChallengePassword(input *GetChallengePasswordInput) (*GetChallengePasswordOutput, error) {
	req, out := c.GetChallengePasswordRequest(input)
	return out, req.Send()
}

// GetChallengePasswordWithContext is the same as GetChallengePassword with the addition of
// the ability to pass a context and additional request options.
//
// See GetChallengePassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorScep) GetChallengePasswordWithContext(ctx aws.Context, input *GetChallengePasswordInput, opts ...request.Option) (*GetChallengePasswordOutput, error) {
	req, out := c.GetChallengePasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConnector = "GetConnector"

// GetConnectorRequest generates a "aws/request.Request" representing the
// client's request for the GetConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConnector for more information on using the GetConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetConnectorRequest method.
//	req, resp := client.GetConnectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/GetConnector
func (c *PcaConnectorScep) GetConnectorRequest(input *GetConnectorInput) (req *request.Request, output *GetConnectorOutput) {
	op := &request.Operation{
		Name:       opGetConnector,
		HTTPMethod: "GET",
		HTTPPath:   "/connectors/{ConnectorArn}",
	}

	if input == nil {
		input = &GetConnectorInput{}
	}

	output = &GetConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConnector API operation for Private CA Connector for SCEP.
//
// Retrieves details about the specified Connector (https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_Connector.html).
// Calling this action returns important details about the connector, such as
// the public SCEP URL where your clients can request certificates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Private CA Connector for SCEP's
// API operation GetConnector for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     be incorrectly specified, or it might have a status other than ACTIVE.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     name tag, or an invalid pagination token.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - AccessDeniedException
//     You can receive this error if you attempt to perform an operation and you
//     don't have the required permissions. This can be caused by insufficient permissions
//     in policies attached to your Amazon Web Services Identity and Access Management
//     (IAM) principal. It can also happen because of restrictions in place from
//     an Amazon Web Services Organizations service control policy (SCP) that affects
//     your Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/GetConnector
func (c *PcaConnectorScep) GetConnector(input *GetConnectorInput) (*GetConnectorOutput, error) {
	req, out := c.GetConnectorRequest(input)
	return out, req.Send()
}

// GetConnectorWithContext is the same as GetConnector with the addition of
// the ability to pass a context and additional request options.
//
// See GetConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorScep) GetConnectorWithContext(ctx aws.Context, input *GetConnectorInput, opts ...request.Option) (*GetConnectorOutput, error) {
	req, out := c.GetConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListChallengeMetadata = "ListChallengeMetadata"

// ListChallengeMetadataRequest generates a "aws/request.Request" representing the
// client's request for the ListChallengeMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChallengeMetadata for more information on using the ListChallengeMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChallengeMetadataRequest method.
//	req, resp := client.ListChallengeMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/ListChallengeMetadata
func (c *PcaConnectorScep) ListChallengeMetadataRequest(input *ListChallengeMetadataInput) (req *request.Request, output *ListChallengeMetadataOutput) {
	op := &request.Operation{
		Name:       opListChallengeMetadata,
		HTTPMethod: "GET",
		HTTPPath:   "/challengeMetadata",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChallengeMetadataInput{}
	}

	output = &ListChallengeMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChallengeMetadata API operation for Private CA Connector for SCEP.
//
// Retrieves the challenge metadata for the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Private CA Connector for SCEP's
// API operation ListChallengeMetadata for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     be incorrectly specified, or it might have a status other than ACTIVE.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     name tag, or an invalid pagination token.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - AccessDeniedException
//     You can receive this error if you attempt to perform an operation and you
//     don't have the required permissions. This can be caused by insufficient permissions
//     in policies attached to your Amazon Web Services Identity and Access Management
//     (IAM) principal. It can also happen because of restrictions in place from
//     an Amazon Web Services Organizations service control policy (SCP) that affects
//     your Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/ListChallengeMetadata
func (c *PcaConnectorScep) ListChallengeMetadata(input *ListChallengeMetadataInput) (*ListChallengeMetadataOutput, error) {
	req, out := c.ListChallengeMetadataRequest(input)
	return out, req.Send()
}

// ListChallengeMetadataWithContext is the same as ListChallengeMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See ListChallengeMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorScep) ListChallengeMetadataWithContext(ctx aws.Context, input *ListChallengeMetadataInput, opts ...request.Option) (*ListChallengeMetadataOutput, error) {
	req, out := c.ListChallengeMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChallengeMetadataPages iterates over the pages of a ListChallengeMetadata operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChallengeMetadata method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChallengeMetadata operation.
//	pageNum := 0
//	err := client.ListChallengeMetadataPages(params,
//	    func(page *pcaconnectorscep.ListChallengeMetadataOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PcaConnectorScep) ListChallengeMetadataPages(input *ListChallengeMetadataInput, fn func(*ListChallengeMetadataOutput, bool) bool) error {
	return c.ListChallengeMetadataPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChallengeMetadataPagesWithContext same as ListChallengeMetadataPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorScep) ListChallengeMetadataPagesWithContext(ctx aws.Context, input *ListChallengeMetadataInput, fn func(*ListChallengeMetadataOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChallengeMetadataInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChallengeMetadataRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChallengeMetadataOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListConnectors = "ListConnectors"

// ListConnectorsRequest generates a "aws/request.Request" representing the
// client's request for the ListConnectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConnectors for more information on using the ListConnectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListConnectorsRequest method.
//	req, resp := client.ListConnectorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/ListConnectors
func (c *PcaConnectorScep) ListConnectorsRequest(input *ListConnectorsInput) (req *request.Request, output *ListConnectorsOutput) {
	op := &request.Operation{
		Name:       opListConnectors,
		HTTPMethod: "GET",
		HTTPPath:   "/connectors",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConnectorsInput{}
	}

	output = &ListConnectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConnectors API operation for Private CA Connector for SCEP.
//
// Lists the connectors belonging to your Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Private CA Connector for SCEP's
// API operation ListConnectors for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     name tag, or an invalid pagination token.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - AccessDeniedException
//     You can receive this error if you attempt to perform an operation and you
//     don't have the required permissions. This can be caused by insufficient permissions
//     in policies attached to your Amazon Web Services Identity and Access Management
//     (IAM) principal. It can also happen because of restrictions in place from
//     an Amazon Web Services Organizations service control policy (SCP) that affects
//     your Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/ListConnectors
func (c *PcaConnectorScep) ListConnectors(input *ListConnectorsInput) (*ListConnectorsOutput, error) {
	req, out := c.ListConnectorsRequest(input)
	return out, req.Send()
}

// ListConnectorsWithContext is the same as ListConnectors with the addition of
// the ability to pass a context and additional request options.
//
// See ListConnectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorScep) ListConnectorsWithContext(ctx aws.Context, input *ListConnectorsInput, opts ...request.Option) (*ListConnectorsOutput, error) {
	req, out := c.ListConnectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConnectorsPages iterates over the pages of a ListConnectors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConnectors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListConnectors operation.
//	pageNum := 0
//	err := client.ListConnectorsPages(params,
//	    func(page *pcaconnectorscep.ListConnectorsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PcaConnectorScep) ListConnectorsPages(input *ListConnectorsInput, fn func(*ListConnectorsOutput, bool) bool) error {
	return c.ListConnectorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConnectorsPagesWithContext same as ListConnectorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorScep) ListConnectorsPagesWithContext(ctx aws.Context, input *ListConnectorsInput, fn func(*ListConnectorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConnectorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConnectorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConnectorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/ListTagsForResource
func (c *PcaConnectorScep) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Private CA Connector for SCEP.
//
// Retrieves the tags associated with the specified resource. Tags are key-value
// pairs that you can use to categorize and manage your resources, for purposes
// like billing. For example, you might set the tag key to "customer" and the
// value to the customer name or ID. You can specify one or more tags to add
// to each Amazon Web Services resource, up to 50 tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Private CA Connector for SCEP's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     be incorrectly specified, or it might have a status other than ACTIVE.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     name tag, or an invalid pagination token.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - AccessDeniedException
//     You can receive this error if you attempt to perform an operation and you
//     don't have the required permissions. This can be caused by insufficient permissions
//     in policies attached to your Amazon Web Services Identity and Access Management
//     (IAM) principal. It can also happen because of restrictions in place from
//     an Amazon Web Services Organizations service control policy (SCP) that affects
//     your Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/ListTagsForResource
func (c *PcaConnectorScep) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorScep) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/TagResource
func (c *PcaConnectorScep) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Private CA Connector for SCEP.
//
// Adds one or more tags to your resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Private CA Connector for SCEP's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     be incorrectly specified, or it might have a status other than ACTIVE.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     name tag, or an invalid pagination token.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - AccessDeniedException
//     You can receive this error if you attempt to perform an operation and you
//     don't have the required permissions. This can be caused by insufficient permissions
//     in policies attached to your Amazon Web Services Identity and Access Management
//     (IAM) principal. It can also happen because of restrictions in place from
//     an Amazon Web Services Organizations service control policy (SCP) that affects
//     your Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/TagResource
func (c *PcaConnectorScep) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorScep) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/UntagResource
func (c *PcaConnectorScep) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Private CA Connector for SCEP.
//
// Removes one or more tags from your resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Private CA Connector for SCEP's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access a nonexistent resource. The resource might
//     be incorrectly specified, or it might have a status other than ACTIVE.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure with an internal server.
//
//   - ValidationException
//     An input validation error occurred. For example, invalid characters in a
//     name tag, or an invalid pagination token.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - AccessDeniedException
//     You can receive this error if you attempt to perform an operation and you
//     don't have the required permissions. This can be caused by insufficient permissions
//     in policies attached to your Amazon Web Services Identity and Access Management
//     (IAM) principal. It can also happen because of restrictions in place from
//     an Amazon Web Services Organizations service control policy (SCP) that affects
//     your Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pca-connector-scep-2018-05-10/UntagResource
func (c *PcaConnectorScep) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PcaConnectorScep) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You can receive this error if you attempt to perform an operation and you
// don't have the required permissions. This can be caused by insufficient permissions
// in policies attached to your Amazon Web Services Identity and Access Management
// (IAM) principal. It can also happen because of restrictions in place from
// an Amazon Web Services Organizations service control policy (SCP) that affects
// your Amazon Web Services account.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request is malformed or contains an error such as an invalid parameter
// value or a missing required parameter.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// For Connector for SCEP for general-purpose. An object containing information
// about the specified connector's SCEP challenge passwords.
type Challenge struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the challenge.
	Arn *string `min:"5" type:"string"`

	// The Amazon Resource Name (ARN) of the connector.
	ConnectorArn *string `min:"5" type:"string"`

	// The date and time that the challenge was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The SCEP challenge password, in UUID format.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Challenge's
	// String and GoString methods.
	Password *string `type:"string" sensitive:"true"`

	// The date and time that the challenge was updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Challenge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Challenge) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Challenge) SetArn(v string) *Challenge {
	s.Arn = &v
	return s
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *Challenge) SetConnectorArn(v string) *Challenge {
	s.ConnectorArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Challenge) SetCreatedAt(v time.Time) *Challenge {
	s.CreatedAt = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *Challenge) SetPassword(v string) *Challenge {
	s.Password = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Challenge) SetUpdatedAt(v time.Time) *Challenge {
	s.UpdatedAt = &v
	return s
}

// Contains details about the connector's challenge.
type ChallengeMetadata struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the challenge.
	Arn *string `min:"5" type:"string"`

	// The Amazon Resource Name (ARN) of the connector.
	ConnectorArn *string `min:"5" type:"string"`

	// The date and time that the connector was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The date and time that the connector was updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChallengeMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChallengeMetadata) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ChallengeMetadata) SetArn(v string) *ChallengeMetadata {
	s.Arn = &v
	return s
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *ChallengeMetadata) SetConnectorArn(v string) *ChallengeMetadata {
	s.ConnectorArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ChallengeMetadata) SetCreatedAt(v time.Time) *ChallengeMetadata {
	s.CreatedAt = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ChallengeMetadata) SetUpdatedAt(v time.Time) *ChallengeMetadata {
	s.UpdatedAt = &v
	return s
}

// Details about the specified challenge, returned by the GetChallengeMetadata
// (https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_GetChallengeMetadata.html)
// action.
type ChallengeMetadataSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the challenge.
	Arn *string `min:"5" type:"string"`

	// The Amazon Resource Name (ARN) of the connector.
	ConnectorArn *string `min:"5" type:"string"`

	// The date and time that the challenge was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The date and time that the challenge was updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChallengeMetadataSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChallengeMetadataSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ChallengeMetadataSummary) SetArn(v string) *ChallengeMetadataSummary {
	s.Arn = &v
	return s
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *ChallengeMetadataSummary) SetConnectorArn(v string) *ChallengeMetadataSummary {
	s.ConnectorArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ChallengeMetadataSummary) SetCreatedAt(v time.Time) *ChallengeMetadataSummary {
	s.CreatedAt = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ChallengeMetadataSummary) SetUpdatedAt(v time.Time) *ChallengeMetadataSummary {
	s.UpdatedAt = &v
	return s
}

// This request can't be completed for one of the following reasons because
// the requested resource was being concurrently modified by another request.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The identifier of the Amazon Web Services resource.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The resource type, which can be either Connector or Challenge.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Connector for SCEP is a service that links Amazon Web Services Private Certificate
// Authority to your SCEP-enabled devices. The connector brokers the exchange
// of certificates from Amazon Web Services Private CA to your SCEP-enabled
// devices and mobile device management systems. The connector is a complex
// type that contains the connector's configuration settings.
type Connector struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the connector.
	Arn *string `min:"5" type:"string"`

	// The Amazon Resource Name (ARN) of the certificate authority associated with
	// the connector.
	CertificateAuthorityArn *string `min:"5" type:"string"`

	// The date and time that the connector was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The connector's HTTPS public SCEP URL.
	Endpoint *string `type:"string"`

	// Contains settings relevant to the mobile device management system that you
	// chose for the connector. If you didn't configure MobileDeviceManagement,
	// then the connector is for general-purpose use and this object is empty.
	MobileDeviceManagement *MobileDeviceManagement `type:"structure"`

	// Contains OpenID Connect (OIDC) parameters for use with Connector for SCEP
	// for Microsoft Intune. For more information about using Connector for SCEP
	// for Microsoft Intune, see Using Connector for SCEP for Microsoft Intune (https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html).
	OpenIdConfiguration *OpenIdConfiguration `type:"structure"`

	// The connector's status.
	Status *string `type:"string" enum:"ConnectorStatus"`

	// Information about why connector creation failed, if status is FAILED.
	StatusReason *string `type:"string" enum:"ConnectorStatusReason"`

	// The connector type.
	Type *string `type:"string" enum:"ConnectorType"`

	// The date and time that the connector was updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Connector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Connector) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Connector) SetArn(v string) *Connector {
	s.Arn = &v
	return s
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *Connector) SetCertificateAuthorityArn(v string) *Connector {
	s.CertificateAuthorityArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Connector) SetCreatedAt(v time.Time) *Connector {
	s.CreatedAt = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *Connector) SetEndpoint(v string) *Connector {
	s.Endpoint = &v
	return s
}

// SetMobileDeviceManagement sets the MobileDeviceManagement field's value.
func (s *Connector) SetMobileDeviceManagement(v *MobileDeviceManagement) *Connector {
	s.MobileDeviceManagement = v
	return s
}

// SetOpenIdConfiguration sets the OpenIdConfiguration field's value.
func (s *Connector) SetOpenIdConfiguration(v *OpenIdConfiguration) *Connector {
	s.OpenIdConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Connector) SetStatus(v string) *Connector {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *Connector) SetStatusReason(v string) *Connector {
	s.StatusReason = &v
	return s
}

// SetType sets the Type field's value.
func (s *Connector) SetType(v string) *Connector {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Connector) SetUpdatedAt(v time.Time) *Connector {
	s.UpdatedAt = &v
	return s
}

// Lists the Amazon Web Services Private CA SCEP connectors belonging to your
// Amazon Web Services account.
type ConnectorSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the connector.
	Arn *string `min:"5" type:"string"`

	// The Amazon Resource Name (ARN) of the connector's associated certificate
	// authority.
	CertificateAuthorityArn *string `min:"5" type:"string"`

	// The date and time that the challenge was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The connector's HTTPS public SCEP URL.
	Endpoint *string `type:"string"`

	// Contains settings relevant to the mobile device management system that you
	// chose for the connector. If you didn't configure MobileDeviceManagement,
	// then the connector is for general-purpose use and this object is empty.
	MobileDeviceManagement *MobileDeviceManagement `type:"structure"`

	// Contains OpenID Connect (OIDC) parameters for use with Microsoft Intune.
	OpenIdConfiguration *OpenIdConfiguration `type:"structure"`

	// The connector's status. Status can be creating, active, deleting, or failed.
	Status *string `type:"string" enum:"ConnectorStatus"`

	// Information about why connector creation failed, if status is FAILED.
	StatusReason *string `type:"string" enum:"ConnectorStatusReason"`

	// The connector type.
	Type *string `type:"string" enum:"ConnectorType"`

	// The date and time that the challenge was updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ConnectorSummary) SetArn(v string) *ConnectorSummary {
	s.Arn = &v
	return s
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *ConnectorSummary) SetCertificateAuthorityArn(v string) *ConnectorSummary {
	s.CertificateAuthorityArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ConnectorSummary) SetCreatedAt(v time.Time) *ConnectorSummary {
	s.CreatedAt = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *ConnectorSummary) SetEndpoint(v string) *ConnectorSummary {
	s.Endpoint = &v
	return s
}

// SetMobileDeviceManagement sets the MobileDeviceManagement field's value.
func (s *ConnectorSummary) SetMobileDeviceManagement(v *MobileDeviceManagement) *ConnectorSummary {
	s.MobileDeviceManagement = v
	return s
}

// SetOpenIdConfiguration sets the OpenIdConfiguration field's value.
func (s *ConnectorSummary) SetOpenIdConfiguration(v *OpenIdConfiguration) *ConnectorSummary {
	s.OpenIdConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ConnectorSummary) SetStatus(v string) *ConnectorSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *ConnectorSummary) SetStatusReason(v string) *ConnectorSummary {
	s.StatusReason = &v
	return s
}

// SetType sets the Type field's value.
func (s *ConnectorSummary) SetType(v string) *ConnectorSummary {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ConnectorSummary) SetUpdatedAt(v time.Time) *ConnectorSummary {
	s.UpdatedAt = &v
	return s
}

type CreateChallengeInput struct {
	_ struct{} `type:"structure"`

	// Custom string that can be used to distinguish between calls to the CreateChallenge
	// (https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_CreateChallenge.html)
	// action. Client tokens for CreateChallenge time out after five minutes. Therefore,
	// if you call CreateChallenge multiple times with the same client token within
	// five minutes, Connector for SCEP recognizes that you are requesting only
	// one challenge and will only respond with one. If you change the client token
	// for each call, Connector for SCEP recognizes that you are requesting multiple
	// challenge passwords.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the connector that you want to create a
	// challenge for.
	//
	// ConnectorArn is a required field
	ConnectorArn *string `min:"5" type:"string" required:"true"`

	// The key-value pairs to associate with the resource.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChallengeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChallengeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChallengeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChallengeInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ConnectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorArn"))
	}
	if s.ConnectorArn != nil && len(*s.ConnectorArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateChallengeInput) SetClientToken(v string) *CreateChallengeInput {
	s.ClientToken = &v
	return s
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *CreateChallengeInput) SetConnectorArn(v string) *CreateChallengeInput {
	s.ConnectorArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChallengeInput) SetTags(v map[string]*string) *CreateChallengeInput {
	s.Tags = v
	return s
}

type CreateChallengeOutput struct {
	_ struct{} `type:"structure"`

	// Returns the challenge details for the specified connector.
	Challenge *Challenge `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChallengeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChallengeOutput) GoString() string {
	return s.String()
}

// SetChallenge sets the Challenge field's value.
func (s *CreateChallengeOutput) SetChallenge(v *Challenge) *CreateChallengeOutput {
	s.Challenge = v
	return s
}

type CreateConnectorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services Private Certificate
	// Authority certificate authority to use with this connector. Due to security
	// vulnerabilities present in the SCEP protocol, we recommend using a private
	// CA that's dedicated for use with the connector.
	//
	// To retrieve the private CAs associated with your account, you can call ListCertificateAuthorities
	// (https://docs.aws.amazon.com/privateca/latest/APIReference/API_ListCertificateAuthorities.html)
	// using the Amazon Web Services Private CA API.
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// Custom string that can be used to distinguish between calls to the CreateChallenge
	// (https://docs.aws.amazon.com/C4SCEP_API/pca-connector-scep/latest/APIReference/API_CreateChallenge.html)
	// action. Client tokens for CreateChallenge time out after five minutes. Therefore,
	// if you call CreateChallenge multiple times with the same client token within
	// five minutes, Connector for SCEP recognizes that you are requesting only
	// one challenge and will only respond with one. If you change the client token
	// for each call, Connector for SCEP recognizes that you are requesting multiple
	// challenge passwords.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// If you don't supply a value, by default Connector for SCEP creates a connector
	// for general-purpose use. A general-purpose connector is designed to work
	// with clients or endpoints that support the SCEP protocol, except Connector
	// for SCEP for Microsoft Intune. With connectors for general-purpose use, you
	// manage SCEP challenge passwords using Connector for SCEP. For information
	// about considerations and limitations with using Connector for SCEP, see Considerations
	// and Limitations (https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlc4scep-considerations-limitations.html).
	//
	// If you provide an IntuneConfiguration, Connector for SCEP creates a connector
	// for use with Microsoft Intune, and you manage the challenge passwords using
	// Microsoft Intune. For more information, see Using Connector for SCEP for
	// Microsoft Intune (https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html).
	MobileDeviceManagement *MobileDeviceManagement `type:"structure"`

	// The key-value pairs to associate with the resource.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectorInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.MobileDeviceManagement != nil {
		if err := s.MobileDeviceManagement.Validate(); err != nil {
			invalidParams.AddNested("MobileDeviceManagement", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *CreateConnectorInput) SetCertificateAuthorityArn(v string) *CreateConnectorInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateConnectorInput) SetClientToken(v string) *CreateConnectorInput {
	s.ClientToken = &v
	return s
}

// SetMobileDeviceManagement sets the MobileDeviceManagement field's value.
func (s *CreateConnectorInput) SetMobileDeviceManagement(v *MobileDeviceManagement) *CreateConnectorInput {
	s.MobileDeviceManagement = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConnectorInput) SetTags(v map[string]*string) *CreateConnectorInput {
	s.Tags = v
	return s
}

type CreateConnectorOutput struct {
	_ struct{} `type:"structure"`

	// Returns the Amazon Resource Name (ARN) of the connector.
	ConnectorArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectorOutput) GoString() string {
	return s.String()
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *CreateConnectorOutput) SetConnectorArn(v string) *CreateConnectorOutput {
	s.ConnectorArn = &v
	return s
}

type DeleteChallengeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the challenge password to delete.
	//
	// ChallengeArn is a required field
	ChallengeArn *string `location:"uri" locationName:"ChallengeArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChallengeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChallengeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChallengeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChallengeInput"}
	if s.ChallengeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChallengeArn"))
	}
	if s.ChallengeArn != nil && len(*s.ChallengeArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChallengeArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChallengeArn sets the ChallengeArn field's value.
func (s *DeleteChallengeInput) SetChallengeArn(v string) *DeleteChallengeInput {
	s.ChallengeArn = &v
	return s
}

type DeleteChallengeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChallengeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChallengeOutput) GoString() string {
	return s.String()
}

type DeleteConnectorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the connector to delete.
	//
	// ConnectorArn is a required field
	ConnectorArn *string `location:"uri" locationName:"ConnectorArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConnectorInput"}
	if s.ConnectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorArn"))
	}
	if s.ConnectorArn != nil && len(*s.ConnectorArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *DeleteConnectorInput) SetConnectorArn(v string) *DeleteConnectorInput {
	s.ConnectorArn = &v
	return s
}

type DeleteConnectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectorOutput) GoString() string {
	return s.String()
}

type GetChallengeMetadataInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the challenge.
	//
	// ChallengeArn is a required field
	ChallengeArn *string `location:"uri" locationName:"ChallengeArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChallengeMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChallengeMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChallengeMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChallengeMetadataInput"}
	if s.ChallengeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChallengeArn"))
	}
	if s.ChallengeArn != nil && len(*s.ChallengeArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChallengeArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChallengeArn sets the ChallengeArn field's value.
func (s *GetChallengeMetadataInput) SetChallengeArn(v string) *GetChallengeMetadataInput {
	s.ChallengeArn = &v
	return s
}

type GetChallengeMetadataOutput struct {
	_ struct{} `type:"structure"`

	// The metadata for the challenge.
	ChallengeMetadata *ChallengeMetadata `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChallengeMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChallengeMetadataOutput) GoString() string {
	return s.String()
}

// SetChallengeMetadata sets the ChallengeMetadata field's value.
func (s *GetChallengeMetadataOutput) SetChallengeMetadata(v *ChallengeMetadata) *GetChallengeMetadataOutput {
	s.ChallengeMetadata = v
	return s
}

type GetChallengePasswordInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the challenge.
	//
	// ChallengeArn is a required field
	ChallengeArn *string `location:"uri" locationName:"ChallengeArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChallengePasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChallengePasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChallengePasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChallengePasswordInput"}
	if s.ChallengeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChallengeArn"))
	}
	if s.ChallengeArn != nil && len(*s.ChallengeArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ChallengeArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChallengeArn sets the ChallengeArn field's value.
func (s *GetChallengePasswordInput) SetChallengeArn(v string) *GetChallengePasswordInput {
	s.ChallengeArn = &v
	return s
}

type GetChallengePasswordOutput struct {
	_ struct{} `type:"structure"`

	// The SCEP challenge password.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetChallengePasswordOutput's
	// String and GoString methods.
	Password *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChallengePasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChallengePasswordOutput) GoString() string {
	return s.String()
}

// SetPassword sets the Password field's value.
func (s *GetChallengePasswordOutput) SetPassword(v string) *GetChallengePasswordOutput {
	s.Password = &v
	return s
}

type GetConnectorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the connector.
	//
	// ConnectorArn is a required field
	ConnectorArn *string `location:"uri" locationName:"ConnectorArn" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConnectorInput"}
	if s.ConnectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorArn"))
	}
	if s.ConnectorArn != nil && len(*s.ConnectorArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *GetConnectorInput) SetConnectorArn(v string) *GetConnectorInput {
	s.ConnectorArn = &v
	return s
}

type GetConnectorOutput struct {
	_ struct{} `type:"structure"`

	// The properties of the connector.
	Connector *Connector `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConnectorOutput) GoString() string {
	return s.String()
}

// SetConnector sets the Connector field's value.
func (s *GetConnectorOutput) SetConnector(v *Connector) *GetConnectorOutput {
	s.Connector = v
	return s
}

// The request processing has failed because of an unknown error, exception
// or failure with an internal server.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains configuration details for use with Microsoft Intune. For information
// about using Connector for SCEP for Microsoft Intune, see Using Connector
// for SCEP for Microsoft Intune (https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html).
//
// When you use Connector for SCEP for Microsoft Intune, certain functionalities
// are enabled by accessing Microsoft Intune through the Microsoft API. Your
// use of the Connector for SCEP and accompanying Amazon Web Services services
// doesn't remove your need to have a valid license for your use of the Microsoft
// Intune service. You should also review the Microsoft Intune® App Protection
// Policies (https://learn.microsoft.com/en-us/mem/intune/apps/app-protection-policy).
type IntuneConfiguration struct {
	_ struct{} `type:"structure"`

	// The directory (tenant) ID from your Microsoft Entra ID app registration.
	//
	// AzureApplicationId is a required field
	AzureApplicationId *string `min:"15" type:"string" required:"true"`

	// The primary domain from your Microsoft Entra ID app registration.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntuneConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntuneConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntuneConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IntuneConfiguration"}
	if s.AzureApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("AzureApplicationId"))
	}
	if s.AzureApplicationId != nil && len(*s.AzureApplicationId) < 15 {
		invalidParams.Add(request.NewErrParamMinLen("AzureApplicationId", 15))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAzureApplicationId sets the AzureApplicationId field's value.
func (s *IntuneConfiguration) SetAzureApplicationId(v string) *IntuneConfiguration {
	s.AzureApplicationId = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *IntuneConfiguration) SetDomain(v string) *IntuneConfiguration {
	s.Domain = &v
	return s
}

type ListChallengeMetadataInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the connector.
	//
	// ConnectorArn is a required field
	ConnectorArn *string `location:"querystring" locationName:"ConnectorArn" min:"5" type:"string" required:"true"`

	// The maximum number of objects that you want Connector for SCEP to return
	// for this request. If more objects are available, in the response, Connector
	// for SCEP provides a NextToken value that you can use in a subsequent call
	// to get the next batch of objects.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Connector for SCEP returns a NextToken value in the response.
	// To retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChallengeMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChallengeMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChallengeMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChallengeMetadataInput"}
	if s.ConnectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorArn"))
	}
	if s.ConnectorArn != nil && len(*s.ConnectorArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorArn", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *ListChallengeMetadataInput) SetConnectorArn(v string) *ListChallengeMetadataInput {
	s.ConnectorArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChallengeMetadataInput) SetMaxResults(v int64) *ListChallengeMetadataInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChallengeMetadataInput) SetNextToken(v string) *ListChallengeMetadataInput {
	s.NextToken = &v
	return s
}

type ListChallengeMetadataOutput struct {
	_ struct{} `type:"structure"`

	// The challenge metadata for the challenges belonging to your Amazon Web Services
	// account.
	Challenges []*ChallengeMetadataSummary `type:"list"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Connector for SCEP returns a NextToken value in the response.
	// To retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChallengeMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChallengeMetadataOutput) GoString() string {
	return s.String()
}

// SetChallenges sets the Challenges field's value.
func (s *ListChallengeMetadataOutput) SetChallenges(v []*ChallengeMetadataSummary) *ListChallengeMetadataOutput {
	s.Challenges = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChallengeMetadataOutput) SetNextToken(v string) *ListChallengeMetadataOutput {
	s.NextToken = &v
	return s
}

type ListConnectorsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of objects that you want Connector for SCEP to return
	// for this request. If more objects are available, in the response, Connector
	// for SCEP provides a NextToken value that you can use in a subsequent call
	// to get the next batch of objects.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Connector for SCEP returns a NextToken value in the response.
	// To retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConnectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConnectorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConnectorsInput) SetMaxResults(v int64) *ListConnectorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConnectorsInput) SetNextToken(v string) *ListConnectorsInput {
	s.NextToken = &v
	return s
}

type ListConnectorsOutput struct {
	_ struct{} `type:"structure"`

	// The connectors belonging to your Amazon Web Services account.
	Connectors []*ConnectorSummary `type:"list"`

	// When you request a list of objects with a MaxResults setting, if the number
	// of objects that are still available for retrieval exceeds the maximum you
	// requested, Connector for SCEP returns a NextToken value in the response.
	// To retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectorsOutput) GoString() string {
	return s.String()
}

// SetConnectors sets the Connectors field's value.
func (s *ListConnectorsOutput) SetConnectors(v []*ConnectorSummary) *ListConnectorsOutput {
	s.Connectors = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConnectorsOutput) SetNextToken(v string) *ListConnectorsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The key-value pairs to associate with the resource.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// If you don't supply a value, by default Connector for SCEP creates a connector
// for general-purpose use. A general-purpose connector is designed to work
// with clients or endpoints that support the SCEP protocol, except Connector
// for SCEP for Microsoft Intune. For information about considerations and limitations
// with using Connector for SCEP, see Considerations and Limitations (https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlc4scep-considerations-limitations.html).
//
// If you provide an IntuneConfiguration, Connector for SCEP creates a connector
// for use with Microsoft Intune, and you manage the challenge passwords using
// Microsoft Intune. For more information, see Using Connector for SCEP for
// Microsoft Intune (https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html).
type MobileDeviceManagement struct {
	_ struct{} `type:"structure"`

	// Configuration settings for use with Microsoft Intune. For information about
	// using Connector for SCEP for Microsoft Intune, see Using Connector for SCEP
	// for Microsoft Intune (https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html).
	Intune *IntuneConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MobileDeviceManagement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MobileDeviceManagement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MobileDeviceManagement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MobileDeviceManagement"}
	if s.Intune != nil {
		if err := s.Intune.Validate(); err != nil {
			invalidParams.AddNested("Intune", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIntune sets the Intune field's value.
func (s *MobileDeviceManagement) SetIntune(v *IntuneConfiguration) *MobileDeviceManagement {
	s.Intune = v
	return s
}

// Contains OpenID Connect (OIDC) parameters for use with Microsoft Intune.
// For more information about using Connector for SCEP for Microsoft Intune,
// see Using Connector for SCEP for Microsoft Intune (https://docs.aws.amazon.com/privateca/latest/userguide/scep-connector.htmlconnector-for-scep-intune.html).
type OpenIdConfiguration struct {
	_ struct{} `type:"structure"`

	// The audience value to copy into your Microsoft Entra app registration's OIDC.
	Audience *string `type:"string"`

	// The issuer value to copy into your Microsoft Entra app registration's OIDC.
	Issuer *string `type:"string"`

	// The subject value to copy into your Microsoft Entra app registration's OIDC.
	Subject *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenIdConfiguration) GoString() string {
	return s.String()
}

// SetAudience sets the Audience field's value.
func (s *OpenIdConfiguration) SetAudience(v string) *OpenIdConfiguration {
	s.Audience = &v
	return s
}

// SetIssuer sets the Issuer field's value.
func (s *OpenIdConfiguration) SetIssuer(v string) *OpenIdConfiguration {
	s.Issuer = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *OpenIdConfiguration) SetSubject(v string) *OpenIdConfiguration {
	s.Subject = &v
	return s
}

// The operation tried to access a nonexistent resource. The resource might
// be incorrectly specified, or it might have a status other than ACTIVE.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The identifier of the Amazon Web Services resource.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The resource type, which can be either Connector or Challenge.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The quota identifier.
	//
	// QuotaCode is a required field
	QuotaCode *string `type:"string" required:"true"`

	// The resource type, which can be either Connector or Challenge.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`

	// Identifies the originating service.
	//
	// ServiceCode is a required field
	ServiceCode *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The key-value pairs to associate with the resource.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The limit on the number of requests per second was exceeded.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// Specifies a list of tag keys that you want to remove from the specified resources.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// An input validation error occurred. For example, invalid characters in a
// name tag, or an invalid pagination token.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason for the validation error, if available. The service doesn't return
	// a reason for every validation exception.
	Reason *string `type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ConnectorStatusCreating is a ConnectorStatus enum value
	ConnectorStatusCreating = "CREATING"

	// ConnectorStatusActive is a ConnectorStatus enum value
	ConnectorStatusActive = "ACTIVE"

	// ConnectorStatusDeleting is a ConnectorStatus enum value
	ConnectorStatusDeleting = "DELETING"

	// ConnectorStatusFailed is a ConnectorStatus enum value
	ConnectorStatusFailed = "FAILED"
)

// ConnectorStatus_Values returns all elements of the ConnectorStatus enum
func ConnectorStatus_Values() []string {
	return []string{
		ConnectorStatusCreating,
		ConnectorStatusActive,
		ConnectorStatusDeleting,
		ConnectorStatusFailed,
	}
}

const (
	// ConnectorStatusReasonInternalFailure is a ConnectorStatusReason enum value
	ConnectorStatusReasonInternalFailure = "INTERNAL_FAILURE"

	// ConnectorStatusReasonPrivatecaAccessDenied is a ConnectorStatusReason enum value
	ConnectorStatusReasonPrivatecaAccessDenied = "PRIVATECA_ACCESS_DENIED"

	// ConnectorStatusReasonPrivatecaInvalidState is a ConnectorStatusReason enum value
	ConnectorStatusReasonPrivatecaInvalidState = "PRIVATECA_INVALID_STATE"

	// ConnectorStatusReasonPrivatecaResourceNotFound is a ConnectorStatusReason enum value
	ConnectorStatusReasonPrivatecaResourceNotFound = "PRIVATECA_RESOURCE_NOT_FOUND"
)

// ConnectorStatusReason_Values returns all elements of the ConnectorStatusReason enum
func ConnectorStatusReason_Values() []string {
	return []string{
		ConnectorStatusReasonInternalFailure,
		ConnectorStatusReasonPrivatecaAccessDenied,
		ConnectorStatusReasonPrivatecaInvalidState,
		ConnectorStatusReasonPrivatecaResourceNotFound,
	}
}

const (
	// ConnectorTypeGeneralPurpose is a ConnectorType enum value
	ConnectorTypeGeneralPurpose = "GENERAL_PURPOSE"

	// ConnectorTypeIntune is a ConnectorType enum value
	ConnectorTypeIntune = "INTUNE"
)

// ConnectorType_Values returns all elements of the ConnectorType enum
func ConnectorType_Values() []string {
	return []string{
		ConnectorTypeGeneralPurpose,
		ConnectorTypeIntune,
	}
}

const (
	// ValidationExceptionReasonCaCertValidityTooShort is a ValidationExceptionReason enum value
	ValidationExceptionReasonCaCertValidityTooShort = "CA_CERT_VALIDITY_TOO_SHORT"

	// ValidationExceptionReasonInvalidCaUsageMode is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidCaUsageMode = "INVALID_CA_USAGE_MODE"

	// ValidationExceptionReasonInvalidConnectorType is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidConnectorType = "INVALID_CONNECTOR_TYPE"

	// ValidationExceptionReasonInvalidState is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidState = "INVALID_STATE"

	// ValidationExceptionReasonNoClientToken is a ValidationExceptionReason enum value
	ValidationExceptionReasonNoClientToken = "NO_CLIENT_TOKEN"

	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonCaCertValidityTooShort,
		ValidationExceptionReasonInvalidCaUsageMode,
		ValidationExceptionReasonInvalidConnectorType,
		ValidationExceptionReasonInvalidState,
		ValidationExceptionReasonNoClientToken,
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonOther,
	}
}
