// Copyright 2016 The Snappy-Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package snappy

// extendMatchGoldenTestCases is the i and j arguments, and the returned value,
// for every extendMatch call issued when encoding the
// testdata/Isaac.Newton-Opticks.txt file. It is used to benchmark the
// extendMatch implementation.
//
// It was generated manually by adding some print statements to the (pure Go)
// encodeBlock implementation (in encode_other.go) to replace the inlined
// version of extendMatch.
//
//      s += 4
//      s0 := s
//      for i := candidate + 4; s < len(src) && src[i] == src[s]; i, s = i+1, s+1 {
//      }
//      println("{", candidate + 4, ",", s0, ",", s, "},")
//
// and running "go test -test.run=EncodeGoldenInput -tags=noasm".
var extendMatchGoldenTestCases = []struct {
	i, j, want int
}{
	{571, 627, 627},
	{220, 644, 645},
	{99, 649, 649},
	{536, 653, 656},
	{643, 671, 673},
	{676, 732, 733},
	{732, 751, 752},
	{67, 768, 772},
	{93, 780, 780},
	{199, 788, 788},
	{487, 792, 796},
	{699, 826, 826},
	{698, 838, 838},
	{697, 899, 901},
	{847, 911, 912},
	{37, 923, 923},
	{833, 928, 928},
	{69, 941, 943},
	{323, 948, 948},
	{671, 955, 957},
	{920, 973, 974},
	{935, 979, 983},
	{750, 997, 999},
	{841, 1014, 1014},
	{928, 1053, 1053},
	{854, 1057, 1060},
	{755, 1072, 1072},
	{838, 1094, 1097},
	{1022, 1106, 1106},
	{1085, 1114, 1114},
	{955, 1128, 1130},
	{814, 1134, 1135},
	{1063, 1145, 1147},
	{918, 1161, 1162},
	{815, 1195, 1196},
	{1128, 1207, 1209},
	{1170, 1225, 1225},
	{897, 1236, 1242},
	{193, 1255, 1262},
	{644, 1266, 1267},
	{784, 1274, 1282},
	{227, 1287, 1289},
	{1161, 1294, 1295},
	{923, 1299, 1299},
	{1195, 1303, 1303},
	{718, 1334, 1339},
	{805, 1350, 1350},
	{874, 1357, 1357},
	{1318, 1362, 1362},
	{994, 1372, 1373},
	{90, 1387, 1387},
	{1053, 1399, 1400},
	{1094, 1417, 1417},
	{1250, 1445, 1445},
	{1285, 1449, 1453},
	{806, 1457, 1461},
	{895, 1472, 1472},
	{1236, 1481, 1488},
	{1266, 1495, 1496},
	{921, 1508, 1509},
	{940, 1522, 1522},
	{1541, 1558, 1559},
	{788, 1582, 1582},
	{1298, 1590, 1590},
	{1361, 1594, 1595},
	{910, 1599, 1601},
	{720, 1605, 1605},
	{1399, 1615, 1616},
	{736, 1629, 1629},
	{1078, 1634, 1638},
	{677, 1645, 1645},
	{757, 1650, 1655},
	{1294, 1659, 1663},
	{1119, 1677, 1684},
	{995, 1688, 1688},
	{1357, 1695, 1696},
	{1169, 1700, 1721},
	{808, 1725, 1727},
	{1390, 1732, 1732},
	{1513, 1736, 1736},
	{1315, 1740, 1740},
	{685, 1748, 1750},
	{899, 1754, 1760},
	{1598, 1764, 1767},
	{1386, 1782, 1783},
	{1465, 1787, 1787},
	{1014, 1791, 1791},
	{1724, 1800, 1805},
	{1166, 1811, 1811},
	{1659, 1823, 1824},
	{1218, 1829, 1843},
	{695, 1847, 1850},
	{1175, 1855, 1857},
	{860, 1876, 1878},
	{1799, 1892, 1892},
	{1319, 1896, 1896},
	{1691, 1900, 1900},
	{1378, 1904, 1904},
	{1495, 1912, 1912},
	{1588, 1917, 1921},
	{679, 1925, 1928},
	{1398, 1935, 1936},
	{1551, 1941, 1942},
	{1612, 1946, 1950},
	{1814, 1959, 1959},
	{1853, 1965, 1966},
	{1307, 1983, 1986},
	{1695, 1990, 1991},
	{905, 1995, 1995},
	{1057, 1999, 2002},
	{1431, 2006, 2007},
	{848, 2018, 2018},
	{1064, 2022, 2023},
	{1151, 2027, 2027},
	{1071, 2050, 2050},
	{1478, 2057, 2057},
	{1911, 2065, 2066},
	{1306, 2070, 2074},
	{2035, 2085, 2085},
	{1188, 2100, 2100},
	{11, 2117, 2118},
	{1725, 2122, 2126},
	{991, 2130, 2130},
	{1786, 2139, 2141},
	{737, 2153, 2154},
	{1481, 2161, 2164},
	{1990, 2173, 2173},
	{2057, 2185, 2185},
	{1881, 2200, 2200},
	{2171, 2205, 2207},
	{1412, 2215, 2216},
	{2210, 2220, 2220},
	{799, 2230, 2230},
	{2103, 2234, 2234},
	{2195, 2238, 2240},
	{1935, 2244, 2245},
	{2220, 2249, 2249},
	{726, 2256, 2256},
	{2188, 2262, 2266},
	{2215, 2270, 2272},
	{2122, 2276, 2278},
	{1110, 2282, 2283},
	{1369, 2287, 2287},
	{724, 2294, 2294},
	{1626, 2300, 2300},
	{2138, 2306, 2309},
	{709, 2313, 2316},
	{1558, 2327, 2327},
	{2109, 2333, 2333},
	{2173, 2354, 2354},
	{2152, 2362, 2367},
	{2065, 2371, 2373},
	{1692, 2377, 2380},
	{819, 2384, 2386},
	{2270, 2393, 2395},
	{1787, 2399, 2400},
	{1989, 2405, 2405},
	{1225, 2414, 2414},
	{2330, 2418, 2418},
	{986, 2424, 2425},
	{1899, 2429, 2431},
	{1070, 2436, 2440},
	{1038, 2450, 2450},
	{1365, 2457, 2457},
	{1983, 2461, 2462},
	{1025, 2469, 2469},
	{2354, 2476, 2476},
	{2457, 2482, 2482},
	{5, 2493, 2494},
	{2234, 2498, 2498},
	{2352, 2514, 2516},
	{2353, 2539, 2540},
	{1594, 2544, 2546},
	{2113, 2550, 2551},
	{2303, 2556, 2557},
	{2429, 2561, 2563},
	{2512, 2568, 2568},
	{1739, 2572, 2572},
	{1396, 2583, 2587},
	{1854, 2593, 2593},
	{2345, 2601, 2602},
	{2536, 2606, 2612},
	{2176, 2617, 2633},
	{2421, 2637, 2637},
	{1645, 2641, 2641},
	{800, 2645, 2647},
	{804, 2654, 2661},
	{687, 2665, 2665},
	{1668, 2669, 2669},
	{1065, 2673, 2673},
	{2027, 2677, 2677},
	{2312, 2685, 2691},
	{2371, 2695, 2697},
	{2453, 2701, 2702},
	{2479, 2711, 2711},
	{2399, 2715, 2715},
	{1018, 2720, 2723},
	{1457, 2727, 2727},
	{2376, 2732, 2732},
	{1387, 2744, 2744},
	{2641, 2748, 2748},
	{2476, 2755, 2755},
	{2460, 2761, 2765},
	{2006, 2769, 2769},
	{2773, 2774, 2809},
	{2769, 2818, 2818},
	{134, 2835, 2835},
	{472, 2847, 2850},
	{206, 2856, 2856},
	{1072, 2860, 2863},
	{801, 2867, 2868},
	{787, 2875, 2883},
	{2560, 2897, 2901},
	{2744, 2909, 2913},
	{2211, 2919, 2919},
	{2150, 2927, 2927},
	{2598, 2931, 2931},
	{2761, 2936, 2938},
	{1312, 2942, 2943},
	{997, 2948, 2950},
	{2637, 2957, 2961},
	{2872, 2971, 2975},
	{1687, 2983, 2984},
	{2755, 2994, 2994},
	{1644, 3000, 3001},
	{1634, 3005, 3008},
	{2555, 3012, 3014},
	{2947, 3018, 3032},
	{1649, 3036, 3051},
	{691, 3055, 3055},
	{2714, 3059, 3061},
	{2498, 3069, 3069},
	{3012, 3074, 3076},
	{2543, 3087, 3089},
	{2983, 3097, 3098},
	{1011, 3111, 3111},
	{1552, 3115, 3115},
	{1427, 3124, 3124},
	{1331, 3133, 3134},
	{1012, 3138, 3140},
	{2194, 3148, 3148},
	{2561, 3152, 3155},
	{3054, 3159, 3161},
	{3065, 3169, 3173},
	{2346, 3177, 3177},
	{2606, 3181, 3185},
	{2994, 3204, 3206},
	{1329, 3210, 3211},
	{1797, 3215, 3215},
	{12, 3221, 3221},
	{1013, 3227, 3228},
	{3168, 3233, 3238},
	{3194, 3247, 3247},
	{3097, 3256, 3257},
	{1219, 3265, 3271},
	{1753, 3275, 3277},
	{1550, 3282, 3292},
	{1182, 3296, 3303},
	{2818, 3307, 3307},
	{2774, 3311, 3346},
	{2812, 3350, 3356},
	{2829, 3367, 3367},
	{2835, 3373, 3387},
	{2860, 3393, 3395},
	{2971, 3405, 3409},
	{1433, 3413, 3414},
	{3405, 3424, 3428},
	{2957, 3432, 3432},
	{2889, 3455, 3460},
	{1213, 3472, 3474},
	{947, 3478, 3479},
	{2747, 3490, 3491},
	{3036, 3495, 3497},
	{2873, 3501, 3504},
	{2979, 3508, 3509},
	{684, 3514, 3516},
	{275, 3524, 3525},
	{3221, 3529, 3529},
	{2748, 3533, 3533},
	{2708, 3546, 3546},
	{1104, 3550, 3550},
	{766, 3554, 3556},
	{1672, 3560, 3561},
	{1155, 3565, 3568},
	{3417, 3572, 3572},
	{2393, 3581, 3583},
	{3533, 3587, 3587},
	{762, 3591, 3591},
	{820, 3604, 3605},
	{3436, 3609, 3615},
	{2497, 3624, 3625},
	{3454, 3630, 3633},
	{2276, 3642, 3644},
	{823, 3649, 3649},
	{648, 3660, 3662},
	{2049, 3666, 3669},
	{3111, 3680, 3680},
	{2048, 3698, 3702},
	{2313, 3706, 3708},
	{2060, 3717, 3717},
	{2695, 3722, 3724},
	{1114, 3733, 3733},
	{1385, 3738, 3738},
	{3477, 3744, 3748},
	{3512, 3753, 3753},
	{2859, 3764, 3764},
	{3210, 3773, 3774},
	{1334, 3778, 3780},
	{3103, 3785, 3785},
	{3018, 3789, 3792},
	{3432, 3802, 3802},
	{3587, 3806, 3806},
	{2148, 3819, 3819},
	{1581, 3827, 3829},
	{3485, 3833, 3838},
	{2727, 3845, 3845},
	{1303, 3849, 3849},
	{2287, 3853, 3855},
	{2133, 3859, 3862},
	{3806, 3866, 3866},
	{3827, 3878, 3880},
	{3845, 3884, 3884},
	{810, 3888, 3888},
	{3866, 3892, 3892},
	{3537, 3896, 3898},
	{2905, 3903, 3907},
	{3666, 3911, 3913},
	{3455, 3920, 3924},
	{3310, 3930, 3934},
	{3311, 3939, 3942},
	{3938, 3946, 3967},
	{2340, 3977, 3977},
	{3542, 3983, 3983},
	{1629, 3992, 3992},
	{3733, 3998, 3999},
	{3816, 4003, 4007},
	{2017, 4018, 4019},
	{883, 4027, 4029},
	{1178, 4033, 4033},
	{3977, 4039, 4039},
	{3069, 4044, 4045},
	{3802, 4049, 4053},
	{3875, 4061, 4066},
	{1628, 4070, 4071},
	{1113, 4075, 4076},
	{1975, 4081, 4081},
	{2414, 4087, 4087},
	{4012, 4096, 4096},
	{4017, 4102, 4104},
	{2169, 4112, 4112},
	{3998, 4123, 4124},
	{2909, 4130, 4130},
	{4032, 4136, 4136},
	{4016, 4140, 4145},
	{3565, 4154, 4157},
	{3892, 4161, 4161},
	{3878, 4168, 4169},
	{3928, 4173, 4215},
	{144, 4238, 4239},
	{4243, 4244, 4244},
	{3307, 4255, 4255},
	{1971, 4261, 4268},
	{3393, 4272, 4274},
	{3591, 4278, 4278},
	{1962, 4282, 4282},
	{1688, 4286, 4286},
	{3911, 4298, 4300},
	{780, 4304, 4305},
	{2842, 4309, 4309},
	{4048, 4314, 4315},
	{3770, 4321, 4321},
	{2244, 4331, 4331},
	{3148, 4336, 4336},
	{1548, 4340, 4340},
	{3209, 4345, 4351},
	{768, 4355, 4355},
	{1903, 4362, 4362},
	{2212, 4366, 4366},
	{1494, 4378, 4380},
	{1183, 4385, 4391},
	{3778, 4403, 4405},
	{3642, 4409, 4411},
	{2593, 4419, 4419},
	{4160, 4430, 4431},
	{3204, 4441, 4441},
	{2875, 4450, 4451},
	{1265, 4455, 4457},
	{3927, 4466, 4466},
	{416, 4479, 4480},
	{4474, 4489, 4490},
	{4135, 4502, 4504},
	{4314, 4511, 4518},
	{1870, 4529, 4529},
	{3188, 4534, 4535},
	{777, 4541, 4542},
	{2370, 4549, 4552},
	{1795, 4556, 4558},
	{1529, 4577, 4577},
	{4298, 4581, 4584},
	{4336, 4596, 4596},
	{1423, 4602, 4602},
	{1004, 4608, 4608},
	{4580, 4615, 4615},
	{4003, 4619, 4623},
	{4593, 4627, 4628},
	{2680, 4644, 4644},
	{2259, 4650, 4650},
	{2544, 4654, 4655},
	{4320, 4660, 4661},
	{4511, 4672, 4673},
	{4545, 4677, 4680},
	{4570, 4689, 4696},
	{2505, 4700, 4700},
	{4605, 4706, 4712},
	{3243, 4717, 4722},
	{4581, 4726, 4734},
	{3852, 4747, 4748},
	{4653, 4756, 4758},
	{4409, 4762, 4764},
	{3165, 4774, 4774},
	{2100, 4780, 4780},
	{3722, 4784, 4786},
	{4756, 4798, 4811},
	{4422, 4815, 4815},
	{3124, 4819, 4819},
	{714, 4825, 4827},
	{4699, 4832, 4832},
	{4725, 4836, 4839},
	{4588, 4844, 4845},
	{1469, 4849, 4849},
	{4743, 4853, 4863},
	{4836, 4869, 4869},
	{2682, 4873, 4873},
	{4774, 4877, 4877},
	{4738, 4881, 4882},
	{4784, 4886, 4892},
	{2759, 4896, 4896},
	{4795, 4900, 4900},
	{4378, 4905, 4905},
	{1050, 4909, 4912},
	{4634, 4917, 4918},
	{4654, 4922, 4923},
	{1542, 4930, 4930},
	{4658, 4934, 4937},
	{4762, 4941, 4943},
	{4751, 4949, 4950},
	{4286, 4961, 4961},
	{1377, 4965, 4965},
	{4587, 4971, 4973},
	{2575, 4977, 4978},
	{4922, 4982, 4983},
	{4941, 4987, 4992},
	{4790, 4996, 5000},
	{4070, 5004, 5005},
	{4538, 5009, 5012},
	{4659, 5016, 5018},
	{4926, 5024, 5034},
	{3884, 5038, 5042},
	{3853, 5046, 5048},
	{4752, 5053, 5053},
	{4954, 5057, 5057},
	{4877, 5063, 5063},
	{4977, 5067, 5067},
	{2418, 5071, 5071},
	{4968, 5075, 5075},
	{681, 5079, 5080},
	{5074, 5086, 5087},
	{5016, 5091, 5092},
	{2196, 5096, 5097},
	{1782, 5107, 5108},
	{5061, 5112, 5113},
	{5096, 5117, 5118},
	{1563, 5127, 5128},
	{4872, 5134, 5135},
	{1324, 5139, 5139},
	{5111, 5144, 5148},
	{4987, 5152, 5154},
	{5075, 5158, 5175},
	{4685, 5181, 5181},
	{4961, 5185, 5185},
	{1564, 5192, 5192},
	{2982, 5198, 5199},
	{917, 5203, 5203},
	{4419, 5208, 5208},
	{4507, 5213, 5213},
	{5083, 5217, 5217},
	{5091, 5221, 5222},
	{3373, 5226, 5226},
	{4475, 5231, 5231},
	{4496, 5238, 5239},
	{1255, 5243, 5244},
	{3680, 5254, 5256},
	{5157, 5260, 5261},
	{4508, 5265, 5274},
	{4946, 5279, 5279},
	{1860, 5285, 5285},
	{889, 5289, 5289},
	{785, 5293, 5297},
	{2290, 5303, 5303},
	{2931, 5310, 5310},
	{5021, 5316, 5316},
	{2571, 5323, 5323},
	{5071, 5327, 5327},
	{5084, 5331, 5333},
	{4614, 5342, 5343},
	{4899, 5347, 5347},
	{4441, 5351, 5351},
	{5327, 5355, 5358},
	{5063, 5362, 5362},
	{3974, 5367, 5367},
	{5316, 5382, 5382},
	{2528, 5389, 5389},
	{1391, 5393, 5393},
	{2582, 5397, 5401},
	{3074, 5405, 5407},
	{4010, 5412, 5412},
	{5382, 5420, 5420},
	{5243, 5429, 5442},
	{5265, 5447, 5447},
	{5278, 5451, 5475},
	{5319, 5479, 5483},
	{1158, 5488, 5488},
	{5423, 5494, 5496},
	{5355, 5500, 5503},
	{5283, 5507, 5509},
	{5340, 5513, 5515},
	{3841, 5530, 5530},
	{1069, 5535, 5537},
	{4970, 5541, 5544},
	{5386, 5548, 5550},
	{2916, 5556, 5563},
	{4023, 5570, 5570},
	{1215, 5576, 5576},
	{4665, 5580, 5581},
	{4402, 5585, 5586},
	{5446, 5592, 5593},
	{5330, 5597, 5597},
	{5221, 5601, 5602},
	{5300, 5606, 5608},
	{4626, 5612, 5614},
	{3660, 5618, 5618},
	{2405, 5623, 5623},
	{3486, 5628, 5633},
	{3143, 5645, 5645},
	{5606, 5650, 5650},
	{5158, 5654, 5654},
	{5378, 5658, 5658},
	{4057, 5663, 5663},
	{5107, 5670, 5670},
	{4886, 5674, 5676},
	{5654, 5680, 5680},
	{5307, 5684, 5687},
	{2449, 5691, 5691},
	{5331, 5695, 5696},
	{3215, 5700, 5700},
	{5447, 5704, 5704},
	{5650, 5708, 5708},
	{4965, 5712, 5715},
	{102, 5722, 5723},
	{2753, 5733, 5735},
	{5695, 5739, 5744},
	{2182, 5748, 5748},
	{4903, 5753, 5753},
	{5507, 5757, 5759},
	{5347, 5763, 5778},
	{5548, 5782, 5784},
	{5392, 5788, 5798},
	{2304, 5803, 5803},
	{4643, 5810, 5810},
	{5703, 5815, 5817},
	{4355, 5821, 5821},
	{5429, 5825, 5826},
	{3624, 5830, 5831},
	{5711, 5836, 5836},
	{5580, 5840, 5844},
	{1909, 5848, 5848},
	{4933, 5853, 5857},
	{5100, 5863, 5870},
	{4904, 5875, 5876},
	{4529, 5883, 5883},
	{3220, 5892, 5893},
	{1533, 5897, 5897},
	{4780, 5904, 5904},
	{3101, 5908, 5909},
	{5627, 5914, 5920},
	{4166, 5926, 5929},
	{5596, 5933, 5934},
	{5680, 5938, 5938},
	{4849, 5942, 5942},
	{5739, 5948, 5949},
	{5533, 5961, 5961},
	{849, 5972, 5972},
	{3752, 5989, 5990},
	{2158, 5996, 5996},
	{4982, 6000, 6001},
	{5601, 6005, 6007},
	{5101, 6014, 6021},
	{4726, 6025, 6025},
	{5720, 6036, 6039},
	{4534, 6045, 6046},
	{5763, 6050, 6050},
	{5914, 6057, 6063},
	{1492, 6067, 6067},
	{2160, 6075, 6078},
	{4619, 6083, 6083},
	{893, 6092, 6093},
	{5948, 6097, 6097},
	{2556, 6105, 6106},
	{1615, 6110, 6110},
	{1156, 6114, 6120},
	{5699, 6128, 6128},
	{2710, 6132, 6133},
	{4446, 6138, 6138},
	{5815, 6143, 6148},
	{1254, 6152, 6161},
	{2357, 6167, 6168},
	{2144, 6172, 6176},
	{2159, 6184, 6184},
	{5810, 6188, 6190},
	{4011, 6195, 6195},
	{6070, 6199, 6199},
	{6005, 6203, 6206},
	{4683, 6211, 6213},
	{4466, 6221, 6222},
	{5230, 6226, 6231},
	{5238, 6235, 6239},
	{5250, 6246, 6253},
	{5704, 6257, 6257},
	{5451, 6261, 6286},
	{181, 6293, 6293},
	{5314, 6297, 6305},
	{5788, 6314, 6316},
	{5938, 6320, 6320},
	{4844, 6324, 6325},
	{5782, 6329, 6332},
	{5628, 6336, 6337},
	{4873, 6341, 6342},
	{6110, 6346, 6346},
	{6328, 6350, 6354},
	{1036, 6358, 6359},
	{6128, 6364, 6364},
	{4740, 6373, 6373},
	{2282, 6377, 6377},
	{5405, 6386, 6388},
	{6257, 6392, 6392},
	{4123, 6396, 6397},
	{5487, 6401, 6410},
	{6290, 6414, 6415},
	{3844, 6423, 6424},
	{3888, 6428, 6428},
	{1086, 6432, 6432},
	{5320, 6436, 6439},
	{6310, 6443, 6444},
	{6401, 6448, 6448},
	{5124, 6452, 6452},
	{5424, 6456, 6457},
	{5851, 6472, 6478},
	{6050, 6482, 6482},
	{5499, 6486, 6490},
	{4900, 6498, 6500},
	{5674, 6510, 6512},
	{871, 6518, 6520},
	{5748, 6528, 6528},
	{6447, 6533, 6534},
	{5820, 6538, 6539},
	{6448, 6543, 6543},
	{6199, 6547, 6547},
	{6320, 6551, 6551},
	{1882, 6555, 6555},
	{6368, 6561, 6566},
	{6097, 6570, 6570},
	{6495, 6576, 6579},
	{5821, 6583, 6583},
	{6507, 6587, 6587},
	{4454, 6596, 6596},
	{2324, 6601, 6601},
	{6547, 6608, 6608},
	{5712, 6612, 6612},
	{5575, 6618, 6619},
	{6414, 6623, 6624},
	{6296, 6629, 6629},
	{4134, 6633, 6634},
	{6561, 6640, 6644},
	{4555, 6649, 6652},
	{4671, 6659, 6660},
	{5592, 6664, 6666},
	{5152, 6670, 6672},
	{6599, 6676, 6676},
	{5521, 6680, 6691},
	{6432, 6695, 6695},
	{6623, 6699, 6705},
	{2601, 6712, 6712},
	{5117, 6723, 6724},
	{6524, 6730, 6733},
	{5351, 6737, 6737},
	{6573, 6741, 6741},
	{6392, 6745, 6746},
	{6592, 6750, 6751},
	{4650, 6760, 6761},
	{5302, 6765, 6765},
	{6615, 6770, 6783},
	{3732, 6787, 6789},
	{6709, 6793, 6793},
	{5306, 6797, 6797},
	{6243, 6801, 6802},
	{5226, 6808, 6816},
	{4497, 6821, 6821},
	{1436, 6825, 6825},
	{1790, 6833, 6834},
	{5525, 6838, 6843},
	{5279, 6847, 6849},
	{6828, 6855, 6857},
	{5038, 6861, 6865},
	{6741, 6869, 6869},
	{4627, 6873, 6873},
	{4037, 6878, 6880},
	{10, 6885, 6887},
	{6730, 6894, 6894},
	{5528, 6898, 6898},
	{6744, 6903, 6903},
	{5839, 6907, 6907},
	{2350, 6911, 6911},
	{2269, 6915, 6918},
	{6869, 6922, 6922},
	{6035, 6929, 6930},
	{1604, 6938, 6939},
	{6922, 6943, 6943},
	{6699, 6947, 6950},
	{6737, 6954, 6954},
	{1775, 6958, 6959},
	{5309, 6963, 6964},
	{6954, 6968, 6968},
	{6369, 6972, 6976},
	{3789, 6980, 6983},
	{2327, 6990, 6990},
	{6837, 6995, 7001},
	{4485, 7006, 7013},
	{6820, 7017, 7031},
	{6291, 7036, 7036},
	{5691, 7041, 7042},
	{7034, 7047, 7047},
	{5310, 7051, 7051},
	{1502, 7056, 7056},
	{4797, 7061, 7061},
	{6855, 7066, 7068},
	{6669, 7072, 7075},
	{6943, 7079, 7079},
	{6528, 7083, 7083},
	{4036, 7087, 7090},
	{6884, 7094, 7100},
	{6946, 7104, 7108},
	{6297, 7112, 7114},
	{5684, 7118, 7121},
	{6903, 7127, 7135},
	{3580, 7141, 7147},
	{6926, 7152, 7182},
	{7117, 7186, 7190},
	{6968, 7194, 7217},
	{6838, 7222, 7227},
	{7005, 7231, 7240},
	{6235, 7244, 7245},
	{6825, 7249, 7249},
	{4594, 7254, 7254},
	{6569, 7258, 7258},
	{7222, 7262, 7267},
	{7047, 7272, 7272},
	{6801, 7276, 7276},
	{7056, 7280, 7280},
	{6583, 7284, 7284},
	{5825, 7288, 7294},
	{6787, 7298, 7300},
	{7079, 7304, 7304},
	{7253, 7308, 7313},
	{6891, 7317, 7317},
	{6829, 7321, 7322},
	{7257, 7326, 7363},
	{7231, 7367, 7377},
	{2854, 7381, 7381},
	{7249, 7385, 7385},
	{6203, 7389, 7391},
	{6363, 7395, 7397},
	{6745, 7401, 7402},
	{6695, 7406, 7406},
	{5208, 7410, 7411},
	{6679, 7415, 7416},
	{7288, 7420, 7421},
	{5248, 7425, 7425},
	{6422, 7429, 7429},
	{5206, 7434, 7436},
	{2255, 7441, 7442},
	{2145, 7452, 7452},
	{7283, 7458, 7459},
	{4830, 7469, 7472},
	{6000, 7476, 7477},
	{7395, 7481, 7492},
	{2715, 7496, 7496},
	{6542, 7500, 7502},
	{7420, 7506, 7513},
	{4981, 7517, 7517},
	{2243, 7522, 7524},
	{916, 7528, 7529},
	{5207, 7533, 7534},
	{1271, 7538, 7539},
	{2654, 7544, 7544},
	{7451, 7553, 7561},
	{7464, 7569, 7571},
	{3992, 7577, 7577},
	{3114, 7581, 7581},
	{7389, 7589, 7591},
	{7433, 7595, 7598},
	{7448, 7602, 7608},
	{1772, 7612, 7612},
	{4152, 7616, 7616},
	{3247, 7621, 7624},
	{963, 7629, 7630},
	{4895, 7640, 7640},
	{6164, 7646, 7646},
	{4339, 7663, 7664},
	{3244, 7668, 7672},
	{7304, 7676, 7676},
	{7401, 7680, 7681},
	{6670, 7685, 7688},
	{6195, 7692, 7693},
	{7505, 7699, 7705},
	{5252, 7709, 7710},
	{6193, 7715, 7718},
	{1916, 7724, 7724},
	{4868, 7729, 7731},
	{1176, 7736, 7736},
	{5700, 7740, 7740},
	{5757, 7744, 7746},
	{6345, 7750, 7752},
	{3132, 7756, 7759},
	{4312, 7763, 7763},
	{7685, 7767, 7769},
	{6907, 7774, 7774},
	{5584, 7779, 7780},
	{6025, 7784, 7784},
	{4435, 7791, 7798},
	{6807, 7809, 7817},
	{6234, 7823, 7825},
	{7385, 7829, 7829},
	{1286, 7833, 7836},
	{7258, 7840, 7840},
	{7602, 7844, 7850},
	{7388, 7854, 7856},
	{7528, 7860, 7866},
	{640, 7874, 7875},
	{7844, 7879, 7886},
	{4700, 7890, 7890},
	{7440, 7894, 7896},
	{4831, 7900, 7902},
	{4556, 7906, 7908},
	{7547, 7914, 7924},
	{7589, 7928, 7929},
	{7914, 7935, 7945},
	{7284, 7949, 7949},
	{7538, 7953, 7957},
	{4635, 7964, 7964},
	{1994, 7968, 7970},
	{7406, 7974, 7976},
	{2409, 7983, 7983},
	{7542, 7989, 7989},
	{7112, 7993, 7993},
	{5259, 7997, 7999},
	{1287, 8004, 8006},
	{7911, 8010, 8011},
	{7449, 8015, 8021},
	{7928, 8025, 8027},
	{1476, 8042, 8044},
	{7784, 8048, 8050},
	{4434, 8054, 8062},
	{7802, 8066, 8074},
	{7367, 8087, 8088},
	{4494, 8094, 8097},
	{7829, 8101, 8101},
	{7321, 8105, 8111},
	{7035, 8115, 8121},
	{7949, 8125, 8125},
	{7506, 8129, 8130},
	{5830, 8134, 8135},
	{8047, 8144, 8144},
	{5362, 8148, 8148},
	{8125, 8152, 8152},
	{7676, 8156, 8156},
	{6324, 8160, 8161},
	{6606, 8173, 8173},
	{7064, 8177, 8182},
	{6993, 8186, 8199},
	{8092, 8203, 8204},
	{7244, 8208, 8213},
	{8105, 8217, 8218},
	{8185, 8222, 8222},
	{8115, 8226, 8232},
	{4164, 8238, 8239},
	{6608, 8244, 8244},
	{8176, 8248, 8277},
	{8208, 8281, 8282},
	{7997, 8287, 8289},
	{7118, 8293, 8303},
	{7103, 8308, 8308},
	{6436, 8312, 8315},
	{3523, 8321, 8321},
	{6442, 8327, 8329},
	{3391, 8333, 8334},
	{6986, 8339, 8344},
	{7221, 8348, 8354},
	{5989, 8358, 8360},
	{4418, 8364, 8365},
	{8307, 8369, 8370},
	{7051, 8375, 8375},
	{4027, 8379, 8380},
	{8333, 8384, 8387},
	{6873, 8391, 8392},
	{4154, 8396, 8399},
	{6878, 8403, 8428},
	{8087, 8432, 8438},
	{7017, 8442, 8443},
	{8129, 8447, 8453},
	{6486, 8457, 8461},
	{8248, 8465, 8465},
	{6349, 8473, 8478},
	{5393, 8482, 8483},
	{8465, 8487, 8487},
	{30, 8495, 8495},
	{4642, 8499, 8500},
	{6768, 8505, 8505},
	{7061, 8513, 8514},
	{7151, 8518, 8528},
	{6648, 8532, 8532},
	{2093, 8539, 8539},
	{3392, 8544, 8544},
	{6980, 8548, 8551},
	{8217, 8555, 8563},
	{8375, 8567, 8567},
	{7041, 8571, 8571},
	{5008, 8576, 8576},
	{4796, 8580, 8582},
	{4271, 8586, 8586},
	{7320, 8591, 8593},
	{8222, 8597, 8597},
	{7262, 8601, 8606},
	{8432, 8610, 8615},
	{8442, 8619, 8620},
	{8101, 8624, 8624},
	{7308, 8628, 8628},
	{8597, 8632, 8641},
	{8498, 8645, 8645},
	{927, 8650, 8651},
	{5979, 8661, 8661},
	{5381, 8665, 8666},
	{2184, 8675, 8675},
	{5342, 8680, 8681},
	{1527, 8686, 8687},
	{4168, 8694, 8694},
	{8332, 8698, 8702},
	{8628, 8706, 8710},
	{8447, 8714, 8720},
	{8610, 8724, 8724},
	{5530, 8730, 8730},
	{6472, 8734, 8734},
	{7476, 8738, 8739},
	{7756, 8743, 8743},
	{8570, 8749, 8753},
	{2706, 8757, 8759},
	{5875, 8763, 8764},
	{8147, 8769, 8770},
	{6526, 8775, 8776},
	{8694, 8780, 8780},
	{3431, 8784, 8785},
	{7787, 8789, 8789},
	{5526, 8794, 8796},
	{6902, 8800, 8801},
	{8756, 8811, 8818},
	{7735, 8822, 8823},
	{5523, 8827, 8828},
	{5668, 8833, 8833},
	{2237, 8839, 8839},
	{8152, 8843, 8846},
	{6633, 8852, 8853},
	{6152, 8858, 8865},
	{8762, 8869, 8870},
	{6216, 8876, 8878},
	{8632, 8882, 8892},
	{2436, 8896, 8897},
	{5541, 8901, 8904},
	{8293, 8908, 8911},
	{7194, 8915, 8915},
	{5658, 8919, 8919},
	{5045, 8923, 8927},
	{7549, 8932, 8932},
	{1623, 8936, 8941},
	{6471, 8946, 8947},
	{8487, 8951, 8951},
	{8714, 8955, 8961},
	{8574, 8965, 8965},
	{2701, 8969, 8970},
	{5500, 8974, 8977},
	{8481, 8984, 8986},
	{5416, 8991, 8991},
	{8950, 8996, 8996},
	{8706, 9001, 9005},
	{8601, 9009, 9014},
	{8882, 9018, 9018},
	{8951, 9022, 9022},
	{1521, 9026, 9026},
	{8025, 9030, 9031},
	{8645, 9035, 9035},
	{8384, 9039, 9042},
	{9001, 9046, 9050},
	{3189, 9054, 9054},
	{8955, 9058, 9065},
	{1043, 9078, 9079},
	{8974, 9083, 9095},
	{6496, 9099, 9100},
	{8995, 9104, 9105},
	{9045, 9109, 9110},
	{6395, 9114, 9116},
	{9038, 9125, 9125},
	{9029, 9135, 9138},
	{1051, 9144, 9147},
	{7833, 9151, 9155},
	{9022, 9159, 9159},
	{9046, 9163, 9163},
	{2732, 9168, 9170},
	{7750, 9174, 9180},
	{8747, 9184, 9186},
	{7663, 9192, 9193},
	{9159, 9197, 9197},
	{8730, 9207, 9209},
	{4429, 9223, 9223},
	{8536, 9227, 9227},
	{1231, 9237, 9237},
	{8965, 9244, 9244},
	{5840, 9248, 9254},
	{4058, 9263, 9270},
	{3214, 9288, 9289},
	{6346, 9293, 9293},
	{6114, 9297, 9298},
	{9104, 9302, 9302},
	{4818, 9331, 9332},
	{8513, 9336, 9337},
	{6971, 9341, 9346},
	{8779, 9357, 9357},
	{8989, 9363, 9367},
	{8843, 9371, 9373},
	{9035, 9381, 9382},
	{3648, 9386, 9386},
	{6988, 9390, 9403},
	{8869, 9407, 9407},
	{7767, 9411, 9413},
	{6341, 9417, 9417},
	{2293, 9424, 9424},
	{9360, 9428, 9428},
	{8048, 9432, 9435},
	{8981, 9439, 9439},
	{6336, 9443, 9444},
	{9431, 9449, 9453},
	{8391, 9457, 9458},
	{9380, 9463, 9464},
	{6947, 9468, 9471},
	{7993, 9475, 9475},
	{7185, 9479, 9484},
	{5848, 9488, 9488},
	{9371, 9492, 9492},
	{7628, 9498, 9500},
	{8757, 9504, 9504},
	{9410, 9508, 9508},
	{9293, 9512, 9512},
	{5138, 9516, 9516},
	{9420, 9521, 9521},
	{4416, 9525, 9528},
	{4825, 9534, 9536},
	{9057, 9540, 9540},
	{7276, 9544, 9546},
	{5491, 9550, 9550},
	{9058, 9554, 9560},
	{8321, 9569, 9569},
	{6357, 9573, 9575},
	{9385, 9579, 9579},
	{6972, 9583, 9587},
	{7996, 9591, 9594},
	{8990, 9598, 9599},
	{9442, 9603, 9605},
	{9579, 9609, 9609},
	{9389, 9613, 9628},
	{8789, 9632, 9632},
	{7152, 9636, 9646},
	{9491, 9652, 9653},
	{2493, 9658, 9659},
	{2456, 9663, 9664},
	{8509, 9672, 9675},
	{6510, 9682, 9684},
	{2533, 9688, 9688},
	{6632, 9696, 9698},
	{4460, 9709, 9711},
	{9302, 9715, 9718},
	{9609, 9722, 9722},
	{4824, 9728, 9731},
	{9553, 9735, 9735},
	{9544, 9739, 9742},
	{9492, 9746, 9746},
	{9554, 9750, 9756},
	{9525, 9761, 9764},
	{7789, 9769, 9769},
	{2136, 9773, 9777},
	{3848, 9782, 9783},
	{9432, 9787, 9790},
	{8165, 9794, 9795},
	{9590, 9799, 9803},
	{8555, 9807, 9812},
	{9009, 9816, 9822},
	{9656, 9829, 9833},
	{4101, 9841, 9841},
	{6382, 9846, 9846},
	{9721, 9850, 9850},
	{9296, 9854, 9856},
	{9573, 9860, 9866},
	{9636, 9870, 9883},
	{9722, 9887, 9887},
	{9163, 9891, 9891},
	{9799, 9895, 9895},
	{9816, 9899, 9906},
	{767, 9912, 9913},
	{8287, 9918, 9923},
	{6293, 9927, 9930},
	{9726, 9934, 9934},
	{6876, 9939, 9940},
	{5847, 9945, 9946},
	{9829, 9951, 9955},
	{9125, 9962, 9962},
	{8542, 9967, 9972},
	{9767, 9978, 9978},
	{4165, 9982, 9982},
	{8243, 9986, 9987},
	{9682, 9993, 9995},
	{4916, 10006, 10010},
	{9456, 10016, 10018},
	{9761, 10024, 10029},
	{9886, 10033, 10034},
	{9468, 10038, 10044},
	{3000, 10052, 10053},
	{9807, 10057, 10062},
	{8226, 10066, 10072},
	{9650, 10077, 10080},
	{9054, 10084, 10084},
	{9891, 10088, 10089},
	{6518, 10095, 10097},
	{8238, 10101, 10117},
	{7890, 10121, 10123},
	{9894, 10128, 10138},
	{3508, 10142, 10143},
	{6377, 10147, 10147},
	{3768, 10152, 10154},
	{6764, 10158, 10160},
	{8852, 10164, 10166},
	{2867, 10172, 10174},
	{4461, 10178, 10179},
	{5889, 10184, 10185},
	{9917, 10189, 10191},
	{6797, 10195, 10195},
	{8567, 10199, 10199},
	{7125, 10203, 10206},
	{9938, 10210, 10234},
	{9967, 10240, 10246},
	{8923, 10251, 10254},
	{10157, 10258, 10258},
	{8032, 10264, 10264},
	{9887, 10268, 10276},
	{9750, 10280, 10286},
	{10258, 10290, 10290},
	{10268, 10294, 10302},
	{9899, 10306, 10311},
	{9715, 10315, 10318},
	{8539, 10322, 10322},
	{10189, 10327, 10329},
	{9135, 10333, 10335},
	{8369, 10340, 10341},
	{9119, 10347, 10347},
	{10290, 10352, 10352},
	{7900, 10357, 10359},
	{3275, 10363, 10365},
	{10294, 10369, 10369},
	{5417, 10376, 10376},
	{10120, 10381, 10381},
	{9786, 10385, 10395},
	{9826, 10399, 10399},
	{8171, 10403, 10407},
	{8402, 10421, 10425},
	{9428, 10429, 10429},
	{1863, 10434, 10435},
	{3092, 10446, 10446},
	{10000, 10450, 10450},
	{9986, 10463, 10464},
	{9632, 10468, 10484},
	{10315, 10489, 10489},
	{10332, 10493, 10493},
	{8914, 10506, 10507},
	{10369, 10511, 10512},
	{1865, 10516, 10517},
	{9204, 10521, 10526},
	{9993, 10533, 10534},
	{2568, 10539, 10539},
	{10429, 10543, 10543},
	{10489, 10549, 10549},
	{10014, 10553, 10558},
	{10024, 10563, 10573},
	{9457, 10577, 10578},
	{9591, 10582, 10585},
	{8908, 10589, 10592},
	{10203, 10596, 10598},
	{10006, 10602, 10604},
	{10209, 10613, 10613},
	{4996, 10617, 10617},
	{9846, 10621, 10622},
	{6927, 10627, 10635},
	{8664, 10639, 10639},
	{8586, 10643, 10644},
	{10576, 10648, 10650},
	{10487, 10654, 10656},
	{10553, 10660, 10664},
	{10563, 10670, 10679},
	{9000, 10683, 10688},
	{10280, 10692, 10699},
	{10582, 10703, 10706},
	{9934, 10710, 10710},
	{10547, 10714, 10716},
	{7065, 10720, 10724},
	{10691, 10730, 10738},
	{872, 10742, 10744},
	{10357, 10751, 10752},
	{1323, 10756, 10756},
	{10087, 10761, 10763},
	{9381, 10769, 10769},
	{9982, 10773, 10778},
	{10533, 10784, 10785},
	{9687, 10789, 10789},
	{8324, 10799, 10799},
	{8742, 10805, 10813},
	{9039, 10817, 10824},
	{5947, 10828, 10828},
	{10306, 10832, 10837},
	{10261, 10841, 10843},
	{10350, 10847, 10850},
	{7415, 10860, 10861},
	{19, 10866, 10866},
	{10188, 10872, 10875},
	{10613, 10881, 10881},
	{7869, 10886, 10886},
	{3801, 10891, 10892},
	{9099, 10896, 10897},
	{8738, 10903, 10904},
	{10322, 10908, 10908},
	{6494, 10912, 10916},
	{9772, 10921, 10921},
	{8170, 10927, 10930},
	{7456, 10940, 10943},
	{10457, 10948, 10952},
	{1405, 10959, 10959},
	{6936, 10963, 10963},
	{4549, 10970, 10975},
	{4880, 10982, 10982},
	{8763, 10986, 10987},
	{4565, 10993, 10994},
	{1310, 11000, 11000},
	{4596, 11010, 11010},
	{6427, 11015, 11016},
	{7729, 11023, 11024},
	{10978, 11029, 11030},
	{10947, 11034, 11039},
	{10577, 11043, 11043},
	{10542, 11052, 11053},
	{9443, 11057, 11058},
	{10468, 11062, 11062},
	{11028, 11066, 11068},
	{10057, 11072, 11073},
	{8881, 11077, 11078},
	{8148, 11082, 11082},
	{10816, 11089, 11093},
	{11066, 11097, 11109},
	{10511, 11113, 11113},
	{9174, 11117, 11119},
	{10345, 11125, 11125},
	{4532, 11129, 11129},
	{9918, 11133, 11134},
	{8858, 11138, 11146},
	{10703, 11150, 11153},
	{9030, 11157, 11160},
	{6481, 11165, 11166},
	{10543, 11170, 11170},
	{8580, 11177, 11178},
	{10886, 11184, 11187},
	{10210, 11191, 11197},
	{2015, 11202, 11202},
	{9312, 11211, 11218},
	{9324, 11223, 11231},
	{10884, 11235, 11235},
	{8166, 11239, 11239},
	{10502, 11243, 11250},
	{11182, 11254, 11259},
	{5366, 11263, 11264},
	{3676, 11268, 11268},
	{5649, 11273, 11274},
	{11065, 11281, 11284},
	{11034, 11288, 11293},
	{7083, 11297, 11297},
	{9550, 11302, 11302},
	{9336, 11310, 11311},
	{7071, 11316, 11316},
	{11314, 11320, 11320},
	{11113, 11324, 11324},
	{11157, 11328, 11330},
	{6482, 11334, 11334},
	{7139, 11338, 11338},
	{10152, 11345, 11345},
	{3554, 11352, 11356},
	{11190, 11364, 11364},
	{11324, 11368, 11368},
	{10710, 11372, 11372},
	{8793, 11376, 11381},
	{6358, 11385, 11386},
	{11368, 11390, 11390},
	{9704, 11394, 11396},
	{7778, 11400, 11400},
	{11149, 11404, 11408},
	{10889, 11414, 11414},
	{9781, 11421, 11422},
	{10267, 11426, 11427},
	{11328, 11431, 11433},
	{5751, 11439, 11440},
	{10817, 11444, 11447},
	{10896, 11451, 11452},
	{10751, 11456, 11457},
	{10163, 11461, 11461},
	{10504, 11466, 11473},
	{8743, 11477, 11484},
	{11150, 11488, 11491},
	{10088, 11495, 11495},
	{10828, 11499, 11509},
	{11444, 11513, 11516},
	{11495, 11520, 11520},
	{11487, 11524, 11524},
	{10692, 11528, 11535},
	{9121, 11540, 11546},
	{11389, 11558, 11564},
	{10195, 11568, 11578},
	{5004, 11582, 11583},
	{5908, 11588, 11588},
	{11170, 11592, 11592},
	{11253, 11597, 11597},
	{11372, 11601, 11601},
	{3115, 11605, 11605},
	{11390, 11609, 11609},
	{10832, 11613, 11616},
	{8800, 11620, 11621},
	{11384, 11625, 11631},
	{10171, 11635, 11637},
	{11400, 11642, 11650},
	{11451, 11654, 11655},
	{11419, 11661, 11664},
	{11608, 11668, 11669},
	{11431, 11673, 11680},
	{11550, 11688, 11690},
	{11609, 11694, 11694},
	{10588, 11702, 11708},
	{6664, 11712, 11712},
	{11461, 11719, 11753},
	{11524, 11757, 11757},
	{11613, 11761, 11764},
	{10257, 11769, 11770},
	{11694, 11774, 11774},
	{11520, 11778, 11781},
	{11138, 11785, 11793},
	{11539, 11797, 11797},
	{11512, 11802, 11802},
	{10602, 11808, 11812},
	{11773, 11816, 11824},
	{11760, 11828, 11835},
	{9083, 11839, 11850},
	{11654, 11855, 11857},
	{6612, 11861, 11862},
	{11816, 11866, 11875},
	{11528, 11879, 11897},
	{10549, 11901, 11901},
	{9108, 11905, 11907},
	{11757, 11911, 11920},
	{837, 11924, 11928},
	{11855, 11932, 11934},
	{8482, 11938, 11939},
	{9439, 11943, 11943},
	{1068, 11950, 11953},
	{10789, 11958, 11958},
	{4611, 11963, 11964},
	{11861, 11968, 11992},
	{11797, 11997, 12004},
	{11719, 12009, 12009},
	{11774, 12013, 12013},
	{756, 12017, 12019},
	{10178, 12023, 12024},
	{9258, 12028, 12047},
	{9534, 12060, 12063},
	{12013, 12067, 12067},
	{8160, 12071, 12072},
	{10865, 12076, 12083},
	{9311, 12091, 12099},
	{11223, 12104, 12115},
	{11932, 12119, 12120},
	{2925, 12130, 12130},
	{6906, 12135, 12136},
	{8895, 12143, 12143},
	{4684, 12147, 12148},
	{11642, 12152, 12152},
	{5573, 12160, 12164},
	{10459, 12168, 12168},
	{2108, 12172, 12172},
	{187, 12179, 12180},
	{2358, 12184, 12184},
	{11796, 12188, 12188},
	{1963, 12192, 12192},
	{2538, 12199, 12200},
	{6497, 12206, 12206},
	{6723, 12210, 12211},
	{7657, 12216, 12216},
	{12204, 12224, 12231},
	{1080, 12239, 12240},
	{12224, 12244, 12246},
	{11911, 12250, 12250},
	{9912, 12266, 12268},
	{7616, 12272, 12272},
	{1956, 12279, 12279},
	{1522, 12283, 12285},
	{9504, 12289, 12290},
	{11672, 12297, 12300},
	{10621, 12304, 12304},
	{11592, 12308, 12308},
	{11385, 12312, 12313},
	{3281, 12317, 12317},
	{3487, 12321, 12321},
	{9417, 12325, 12325},
	{9613, 12335, 12337},
	{10670, 12342, 12348},
	{10589, 12352, 12357},
	{10616, 12362, 12363},
	{9326, 12369, 12375},
	{5211, 12379, 12382},
	{12304, 12386, 12395},
	{1048, 12399, 12399},
	{12335, 12403, 12405},
	{12250, 12410, 12410},
	{10084, 12414, 12414},
	{11394, 12418, 12421},
	{12126, 12425, 12429},
	{9582, 12433, 12438},
	{10784, 12445, 12447},
	{9568, 12454, 12455},
	{12308, 12459, 12459},
	{9635, 12464, 12475},
	{11513, 12479, 12482},
	{12119, 12486, 12487},
	{12066, 12494, 12495},
	{12403, 12499, 12502},
	{11687, 12506, 12513},
	{12418, 12517, 12519},
	{12352, 12523, 12528},
	{11600, 12532, 12532},
	{12450, 12539, 12539},
	{12067, 12543, 12543},
	{11477, 12547, 12565},
	{11540, 12569, 12575},
	{11202, 12580, 12581},
	{10903, 12585, 12586},
	{11601, 12590, 12590},
	{12459, 12599, 12599},
	{11839, 12603, 12605},
	{11426, 12609, 12610},
	{12486, 12614, 12616},
	{9406, 12621, 12621},
	{6897, 12625, 12628},
	{12312, 12632, 12633},
	{12445, 12638, 12640},
	{1743, 12645, 12645},
	{11551, 12649, 12650},
	{12543, 12654, 12654},
	{11635, 12658, 12660},
	{12522, 12664, 12675},
	{12539, 12683, 12712},
	{11801, 12716, 12721},
	{5803, 12725, 12725},
	{716, 12730, 12732},
	{8900, 12736, 12740},
	{12076, 12744, 12746},
	{5046, 12751, 12751},
	{12735, 12755, 12755},
	{11879, 12759, 12766},
	{1609, 12770, 12770},
	{10921, 12774, 12774},
	{11420, 12778, 12778},
	{12754, 12783, 12784},
	{12177, 12788, 12788},
	{12191, 12792, 12792},
	{12139, 12798, 12802},
	{11082, 12806, 12806},
	{12152, 12810, 12810},
	{10381, 12814, 12814},
	{11239, 12820, 12821},
	{2198, 12825, 12826},
	{6123, 12832, 12832},
	{10642, 12836, 12839},
	{11117, 12843, 12844},
	{12210, 12848, 12849},
	{9688, 12853, 12853},
	{12832, 12857, 12860},
	{12147, 12864, 12870},
	{12028, 12874, 12893},
	{12052, 12898, 12898},
	{8202, 12902, 12903},
	{7243, 12907, 12909},
	{8014, 12913, 12920},
	{7680, 12924, 12931},
	{11056, 12939, 12941},
	{3817, 12946, 12949},
	{9390, 12954, 12954},
	{12249, 12958, 12960},
	{12237, 12966, 12969},
	{12638, 12973, 12975},
	{12386, 12979, 12979},
	{10626, 12984, 12997},
	{6793, 13005, 13005},
	{10625, 13009, 13025},
	{12963, 13029, 13029},
	{10038, 13033, 13036},
	{12599, 13040, 13041},
	{11568, 13046, 13050},
	{13040, 13054, 13054},
	{11238, 13058, 13060},
	{5125, 13064, 13064},
	{12425, 13068, 13080},
	{9760, 13084, 13088},
	{12729, 13092, 13093},
	{9672, 13097, 13099},
	{3675, 13104, 13104},
	{6055, 13108, 13112},
	{2681, 13119, 13120},
	{12843, 13124, 13125},
	{12952, 13129, 13132},
	{13063, 13137, 13137},
	{5861, 13141, 13141},
	{10948, 13145, 13149},
	{3080, 13153, 13153},
	{12743, 13158, 13158},
	{13123, 13163, 13166},
	{11043, 13170, 13171},
	{13136, 13175, 13176},
	{12796, 13180, 13181},
	{13107, 13185, 13185},
	{13156, 13192, 13202},
	{12954, 13207, 13208},
	{8648, 13213, 13231},
	{10403, 13235, 13235},
	{12603, 13239, 13239},
	{13029, 13243, 13243},
	{6420, 13251, 13251},
	{5801, 13261, 13265},
	{8901, 13269, 13272},
	{5139, 13276, 13278},
	{8036, 13282, 13283},
	{8041, 13288, 13288},
	{10871, 13293, 13297},
	{12923, 13301, 13303},
	{10340, 13307, 13308},
	{9926, 13312, 13316},
	{9478, 13320, 13328},
	{4571, 13334, 13339},
	{8325, 13343, 13343},
	{10933, 13349, 13349},
	{9515, 13354, 13354},
	{10979, 13358, 13358},
	{7500, 13364, 13366},
	{12820, 13371, 13375},
	{13068, 13380, 13392},
	{8724, 13397, 13397},
	{8624, 13401, 13401},
	{13206, 13405, 13406},
	{12939, 13410, 13412},
	{11015, 13417, 13418},
	{12924, 13422, 13423},
	{13103, 13427, 13431},
	{13353, 13435, 13435},
	{13415, 13440, 13443},
	{10147, 13447, 13448},
	{13180, 13452, 13457},
	{12751, 13461, 13461},
	{2291, 13465, 13465},
	{12168, 13469, 13471},
	{7744, 13475, 13477},
	{6386, 13488, 13490},
	{12755, 13494, 13494},
	{13482, 13498, 13499},
	{12410, 13503, 13503},
	{13494, 13507, 13507},
	{11376, 13511, 13516},
	{13422, 13520, 13521},
	{10742, 13525, 13527},
	{1528, 13531, 13531},
	{7517, 13537, 13537},
	{4930, 13541, 13542},
	{13507, 13546, 13546},
	{13033, 13550, 13553},
	{9475, 13557, 13568},
	{12805, 13572, 13572},
	{6188, 13576, 13578},
	{12770, 13582, 13587},
	{12648, 13593, 13594},
	{13054, 13598, 13598},
	{8856, 13603, 13613},
	{1046, 13618, 13619},
	{13348, 13623, 13624},
	{13520, 13628, 13628},
	{10142, 13632, 13633},
	{13434, 13643, 13643},
	{5488, 13648, 13648},
	{649, 13652, 13652},
	{11272, 13657, 13657},
	{12873, 13663, 13663},
	{4631, 13670, 13670},
	{12578, 13674, 13677},
	{12091, 13684, 13692},
	{13581, 13699, 13699},
	{13549, 13704, 13708},
	{13598, 13712, 13712},
	{13320, 13716, 13722},
	{13712, 13726, 13726},
	{13370, 13730, 13731},
	{11352, 13735, 13737},
	{13601, 13742, 13742},
	{13497, 13746, 13769},
	{12973, 13773, 13775},
	{11235, 13784, 13784},
	{10627, 13788, 13796},
	{13152, 13800, 13800},
	{12585, 13804, 13804},
	{13730, 13809, 13810},
	{13488, 13814, 13816},
	{11815, 13821, 13821},
	{11254, 13825, 13825},
	{13788, 13829, 13838},
	{13141, 13842, 13842},
	{9658, 13846, 13848},
	{11088, 13852, 13853},
	{10239, 13860, 13866},
	{13780, 13870, 13871},
	{9981, 13877, 13883},
	{11901, 13889, 13891},
	{13405, 13895, 13897},
	{12680, 13901, 13901},
	{8363, 13905, 13910},
	{13546, 13914, 13914},
	{13498, 13918, 13927},
	{13550, 13931, 13937},
	{13628, 13941, 13941},
	{13900, 13952, 13952},
	{13841, 13957, 13957},
	{3102, 13961, 13961},
	{12835, 13966, 13970},
	{12071, 13974, 13975},
	{12810, 13979, 13980},
	{11488, 13984, 13987},
	{13809, 13991, 13992},
	{13234, 13996, 13997},
	{13886, 14001, 14002},
	{11128, 14006, 14007},
	{6013, 14012, 14013},
	{8748, 14018, 14020},
	{9678, 14024, 14024},
	{12188, 14029, 14029},
	{13914, 14033, 14033},
	{11778, 14037, 14040},
	{11828, 14044, 14051},
	{12479, 14055, 14058},
	{14037, 14062, 14066},
	{12759, 14070, 14076},
	{13889, 14080, 14081},
	{13895, 14086, 14121},
	{10199, 14125, 14131},
	{13663, 14135, 14135},
	{9261, 14139, 14155},
	{12898, 14160, 14160},
	{13667, 14164, 14167},
	{12579, 14172, 14174},
	{13681, 14178, 14189},
	{13697, 14194, 14196},
	{14033, 14200, 14200},
	{13931, 14204, 14207},
	{13726, 14211, 14211},
	{9583, 14215, 14222},
	{13243, 14226, 14226},
	{13379, 14230, 14231},
	{7481, 14237, 14239},
	{10373, 14243, 14243},
	{8644, 14248, 14249},
	{1082, 14259, 14260},
	{5814, 14265, 14265},
	{10414, 14269, 14270},
	{9512, 14274, 14274},
	{9286, 14285, 14288},
	{12593, 14295, 14295},
	{13773, 14300, 14302},
	{5874, 14308, 14308},
	{13804, 14312, 14312},
	{10412, 14317, 14320},
	{12836, 14324, 14327},
	{13974, 14331, 14337},
	{14200, 14341, 14341},
	{14086, 14345, 14347},
	{4853, 14352, 14353},
	{13961, 14357, 14357},
	{14340, 14361, 14367},
	{14005, 14374, 14374},
	{13857, 14379, 14388},
	{10532, 14397, 14399},
	{14379, 14405, 14406},
	{11957, 14411, 14413},
	{10939, 14419, 14419},
	{12547, 14423, 14429},
	{13772, 14435, 14438},
	{14341, 14442, 14447},
	{14409, 14453, 14453},
	{14442, 14457, 14457},
	{13918, 14461, 14470},
	{13511, 14474, 14483},
	{14080, 14487, 14488},
	{14344, 14492, 14495},
	{13901, 14499, 14520},
	{12609, 14524, 14525},
	{14204, 14529, 14532},
	{13557, 14536, 14536},
	{6220, 14541, 14542},
	{14139, 14546, 14562},
	{14160, 14567, 14574},
	{14172, 14579, 14596},
	{14194, 14601, 14610},
	{14125, 14614, 14614},
	{14211, 14618, 14659},
	{2011, 14663, 14663},
	{14264, 14667, 14680},
	{9951, 14687, 14691},
	{12863, 14696, 14698},
	{7980, 14702, 14703},
	{14357, 14707, 14708},
	{12266, 14714, 14715},
	{10772, 14723, 14729},
	{12806, 14733, 14733},
	{2583, 14737, 14741},
	{14006, 14745, 14745},
	{12945, 14749, 14752},
	{8679, 14756, 14758},
	{12184, 14762, 14763},
	{14423, 14767, 14773},
	{14054, 14777, 14779},
	{10411, 14785, 14789},
	{11310, 14794, 14795},
	{6455, 14799, 14800},
	{5418, 14804, 14804},
	{13821, 14808, 14808},
	{11905, 14812, 14814},
	{13502, 14818, 14819},
	{11761, 14823, 14829},
	{14745, 14833, 14833},
	{14070, 14837, 14843},
	{8173, 14850, 14850},
	{2999, 14854, 14856},
	{9201, 14860, 14867},
	{14807, 14871, 14872},
	{14812, 14878, 14881},
	{13814, 14885, 14887},
	{12644, 14891, 14892},
	{14295, 14898, 14898},
	{14457, 14902, 14902},
	{14331, 14906, 14907},
	{13170, 14911, 14911},
	{14352, 14915, 14916},
	{12649, 14920, 14921},
	{12399, 14925, 14925},
	{13349, 14929, 14929},
	{13207, 14934, 14935},
	{14372, 14939, 14941},
	{14498, 14945, 14945},
	{13860, 14949, 14955},
	{14452, 14960, 14962},
	{14792, 14970, 14970},
	{14720, 14975, 14975},
	{13858, 14984, 14984},
	{5733, 14989, 14991},
	{14982, 14995, 14995},
	{14524, 14999, 15000},
	{2347, 15004, 15004},
	{4612, 15009, 15009},
	{3225, 15013, 15013},
	{12320, 15017, 15018},
	{14975, 15022, 15022},
	{13416, 15026, 15028},
	{8140, 15034, 15034},
	{15016, 15040, 15042},
	{14299, 15046, 15051},
	{14901, 15055, 15056},
	{14933, 15060, 15061},
	{14960, 15066, 15066},
	{14999, 15070, 15071},
	{14461, 15075, 15080},
	{14666, 15084, 15084},
	{14474, 15088, 15134},
	{15055, 15138, 15138},
	{13046, 15142, 15146},
	{14536, 15150, 15176},
	{14567, 15181, 15181},
	{12725, 15185, 15185},
	{13346, 15189, 15189},
	{13268, 15193, 15197},
	{5568, 15203, 15203},
	{15192, 15207, 15207},
	{15075, 15211, 15216},
	{15207, 15220, 15220},
	{13941, 15224, 15224},
	{13091, 15228, 15230},
	{13623, 15234, 15235},
	{13362, 15239, 15243},
	{10066, 15247, 15252},
	{6452, 15257, 15257},
	{14837, 15261, 15267},
	{13576, 15271, 15281},
	{12874, 15285, 15304},
	{15181, 15309, 15309},
	{14164, 15313, 15316},
	{14579, 15321, 15326},
	{12090, 15330, 15339},
	{14601, 15344, 15346},
	{15084, 15350, 15350},
	{12523, 15354, 15357},
	{14618, 15361, 15361},
	{12788, 15365, 15365},
	{6032, 15369, 15369},
	{12127, 15373, 15378},
	{4703, 15382, 15382},
	{12140, 15386, 15387},
	{4602, 15392, 15392},
	{12856, 15396, 15398},
	{13990, 15403, 15406},
	{13213, 15412, 15416},
	{13979, 15420, 15420},
	{14300, 15424, 15426},
	{10617, 15430, 15430},
	{10094, 15435, 15435},
	{12413, 15439, 15440},
	{10900, 15447, 15450},
	{10908, 15455, 15455},
	{15220, 15459, 15459},
	{14911, 15463, 15464},
	{15026, 15468, 15470},
	{14696, 15478, 15480},
	{12414, 15484, 15484},
	{14215, 15488, 15491},
	{13009, 15496, 15508},
	{15424, 15512, 15514},
	{11334, 15518, 15519},
	{11280, 15523, 15524},
	{11345, 15528, 15529},
	{15459, 15533, 15533},
	{14243, 15537, 15539},
	{14818, 15543, 15544},
	{15533, 15548, 15548},
	{14230, 15552, 15554},
	{14832, 15561, 15562},
	{9787, 15566, 15567},
	{15443, 15573, 15575},
	{13845, 15579, 15584},
	{15430, 15588, 15588},
	{15561, 15593, 15593},
	{14453, 15601, 15608},
	{14870, 15613, 15615},
	{12275, 15619, 15619},
	{14613, 15623, 15624},
	{10596, 15628, 15630},
	{1940, 15634, 15634},
	{9773, 15638, 15638},
	{2665, 15642, 15642},
	{13638, 15646, 15646},
	{6861, 15650, 15650},
	{12781, 15654, 15657},
	{15088, 15661, 15665},
	{11712, 15669, 15669},
	{5534, 15673, 15674},
	{12864, 15678, 15684},
	{15547, 15688, 15689},
	{15365, 15693, 15693},
	{7973, 15697, 15698},
	{13144, 15702, 15710},
	{15548, 15714, 15714},
	{14906, 15718, 15719},
	{15444, 15723, 15723},
	{11456, 15727, 15729},
	{12632, 15733, 15734},
	{13602, 15738, 15738},
	{8932, 15746, 15746},
	{15598, 15752, 15753},
	{14257, 15757, 15758},
	{8379, 15762, 15763},
	{10531, 15767, 15767},
	{8403, 15771, 15775},
	{10432, 15779, 15784},
	{14285, 15791, 15794},
	{3086, 15800, 15803},
	{14925, 15807, 15807},
	{14934, 15812, 15812},
	{15065, 15816, 15817},
	{15737, 15821, 15821},
	{15210, 15825, 15831},
	{15350, 15835, 15835},
	{15661, 15839, 15843},
	{15223, 15847, 15848},
	{10450, 15855, 15855},
	{10501, 15860, 15870},
	{10515, 15879, 15879},
	{12621, 15884, 15884},
	{15593, 15890, 15890},
	{15021, 15894, 15894},
	{15512, 15898, 15900},
	{14274, 15904, 15905},
	{15566, 15909, 15909},
	{3785, 15913, 15913},
	{14995, 15917, 15917},
	{15565, 15921, 15921},
	{14762, 15925, 15926},
	{14016, 15933, 15940},
	{10264, 15948, 15948},
	{15944, 15952, 15953},
	{14847, 15962, 15966},
	{15321, 15973, 15975},
	{15917, 15979, 15980},
	{8141, 15984, 15984},
	{15714, 15988, 15988},
	{15004, 15992, 16018},
	{5180, 16023, 16024},
	{15017, 16028, 16029},
	{15046, 16033, 16036},
	{14499, 16040, 16061},
	{15987, 16065, 16066},
	{15354, 16070, 16073},
	{15628, 16077, 16081},
	{13235, 16085, 16088},
	{15835, 16093, 16093},
	{13247, 16097, 16107},
	{15929, 16112, 16112},
	{7992, 16118, 16118},
	{15988, 16122, 16122},
	{15811, 16126, 16133},
	{5185, 16137, 16137},
	{6056, 16149, 16156},
	{15723, 16160, 16160},
	{13435, 16167, 16167},
	{15692, 16173, 16175},
	{1346, 16182, 16183},
	{15641, 16187, 16187},
	{13157, 16192, 16192},
	{12813, 16197, 16197},
	{5216, 16201, 16202},
	{16170, 16206, 16206},
	{15224, 16210, 16211},
	{12979, 16215, 16215},
	{13342, 16230, 16230},
	{15070, 16236, 16237},
	{16070, 16241, 16244},
	{15361, 16248, 16248},
	{15488, 16252, 16256},
	{15184, 16265, 16273},
	{10860, 16277, 16278},
	{8780, 16286, 16287},
	{15271, 16291, 16293},
	{16206, 16297, 16297},
	{14529, 16301, 16304},
	{16248, 16308, 16308},
	{13716, 16312, 16322},
	{16252, 16326, 16330},
	{13874, 16334, 16334},
	{12773, 16338, 16349},
	{14929, 16353, 16353},
	{15697, 16361, 16362},
	{13531, 16366, 16368},
	{14833, 16373, 16373},
	{15904, 16377, 16378},
	{16173, 16386, 16388},
	{13582, 16392, 16393},
	{9488, 16399, 16399},
	{15468, 16403, 16404},
	{13905, 16409, 16411},
	{3784, 16415, 16416},
	{16297, 16420, 16420},
	{16210, 16424, 16426},
	{12936, 16430, 16430},
	{8508, 16435, 16438},
	{9602, 16443, 16446},
	{1317, 16450, 16451},
	{4739, 16456, 16461},
}
