/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPObjectSettingsProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.security.SMObjectType;
import org.jkiss.dbeaver.registry.DataSourceNavigatorSettings;

public class DataSourceNavigatorSettingsUtils {
    private static final Log log = Log.getLog(DataSourceNavigatorSettingsUtils.class);

    public static void loadSettingsFromMap(@NotNull DataSourceNavigatorSettings navSettings, @NotNull Map<String, ?> objectMap) {
        navSettings.setShowSystemObjects(JSONUtils.getBoolean(objectMap, (String)"show-system-objects"));
        navSettings.setShowUtilityObjects(JSONUtils.getBoolean(objectMap, (String)"show-util-objects"));
        navSettings.setShowOnlyEntities(JSONUtils.getBoolean(objectMap, (String)"navigator-show-only-entities"));
        navSettings.setHideFolders(JSONUtils.getBoolean(objectMap, (String)"navigator-hide-folders"));
        navSettings.setHideSchemas(JSONUtils.getBoolean(objectMap, (String)"navigator-hide-schemas"));
        navSettings.setHideVirtualModel(JSONUtils.getBoolean(objectMap, (String)"navigator-hide-virtual"));
        navSettings.setMergeEntities(JSONUtils.getBoolean(objectMap, (String)"navigator-merge-entities"));
    }

    public static void updateCustomNavigatorSettings(@NotNull DBPDataSourceContainer dataSource, @NotNull DataSourceNavigatorSettings settings) throws DBException {
        DBPObjectSettingsProvider settingsProvider = (DBPObjectSettingsProvider)DBUtils.getAdapter(DBPObjectSettingsProvider.class, (Object)dataSource.getProject());
        if (settingsProvider == null) {
            return;
        }
        Map<String, String> settingsMap = DataSourceNavigatorSettings.saveSettingsToMap(settings);
        settingsProvider.setObjectSettings(SMObjectType.datasource, dataSource.getId(), settingsMap);
    }

    public static void clearCustomNavigatorSettings(@NotNull DBPDataSourceContainer dataSource) throws DBException {
        DBPObjectSettingsProvider settingsProvider = (DBPObjectSettingsProvider)DBUtils.getAdapter(DBPObjectSettingsProvider.class, (Object)dataSource.getProject());
        if (settingsProvider == null) {
            return;
        }
        settingsProvider.clearObjectSettings(SMObjectType.datasource, dataSource.getId(), DataSourceNavigatorSettings.NAVIGATOR_SETTINGS);
    }

    public static void objectSettingUpdated(@NotNull DBPProject project, @NotNull String objectId, @NotNull Collection<String> settingIds) {
        DBPDataSourceContainer dataSourceContainer = project.getDataSourceRegistry().getDataSource(objectId);
        if (dataSourceContainer == null) {
            log.warn((Object)("Data source container '" + objectId + "' not found in registry"));
            return;
        }
        if (settingIds.stream().noneMatch(DataSourceNavigatorSettings.NAVIGATOR_SETTINGS::contains)) {
            return;
        }
        dataSourceContainer.getRegistry().refreshConfig(List.of(dataSourceContainer.getId()));
    }
}

