/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.text.CharacterIterator;

public class Segment
implements Cloneable,
CharacterIterator,
CharSequence {
    public char[] array;
    public int offset;
    public int count;
    private boolean partialReturn;
    private int pos;

    public Segment() {
        this(null, 0, 0);
    }

    public Segment(char[] cArray, int n, int n2) {
        this.array = cArray;
        this.offset = n;
        this.count = n2;
        this.partialReturn = false;
    }

    public void setPartialReturn(boolean bl) {
        this.partialReturn = bl;
    }

    public boolean isPartialReturn() {
        return this.partialReturn;
    }

    @Override
    public String toString() {
        if (this.array != null) {
            return new String(this.array, this.offset, this.count);
        }
        return "";
    }

    @Override
    public char first() {
        this.pos = this.offset;
        if (this.count != 0) {
            return this.array[this.pos];
        }
        return '\uffff';
    }

    @Override
    public char last() {
        this.pos = this.offset + this.count;
        if (this.count != 0) {
            --this.pos;
            return this.array[this.pos];
        }
        return '\uffff';
    }

    @Override
    public char current() {
        if (this.count != 0 && this.pos < this.offset + this.count) {
            return this.array[this.pos];
        }
        return '\uffff';
    }

    @Override
    public char next() {
        ++this.pos;
        int n = this.offset + this.count;
        if (this.pos >= n) {
            this.pos = n;
            return '\uffff';
        }
        return this.current();
    }

    @Override
    public char previous() {
        if (this.pos == this.offset) {
            return '\uffff';
        }
        --this.pos;
        return this.current();
    }

    @Override
    public char setIndex(int n) {
        int n2 = this.offset + this.count;
        if (n < this.offset || n > n2) {
            throw new IllegalArgumentException("bad position: " + n);
        }
        this.pos = n;
        if (this.pos != n2 && this.count != 0) {
            return this.array[this.pos];
        }
        return '\uffff';
    }

    @Override
    public int getBeginIndex() {
        return this.offset;
    }

    @Override
    public int getEndIndex() {
        return this.offset + this.count;
    }

    @Override
    public int getIndex() {
        return this.pos;
    }

    @Override
    public char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.array[this.offset + n];
    }

    @Override
    public int length() {
        return this.count;
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        Segment segment = new Segment();
        segment.array = this.array;
        segment.offset = this.offset + n;
        segment.count = n2 - n;
        return segment;
    }

    @Override
    public Object clone() {
        Object object;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            object = null;
        }
        return object;
    }
}

