#!/bin/bash

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3 or later of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see
# https://www.gnu.org/licenses/licenses/gpl-3.0.en.html.

if [ "$1" = "-h" ] || [ "$1" = "--help" ] ; then cat << EOF
usage  $(basename "$0") <file> ..
  Creates (if needed) a subdirectory "u_codespell" and downloads u_codespell there.
  If the project is already there, just updates it.
EOF
exit
fi

cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null || exit 1
WHERE="https://codeberg.org/api/v1/repos/johann1764/u_codespell/raw/"
mkdir u_codespell
wget -nv -P "u_codespell" "${WHERE}update.sh"
chmod +x u_codespell/update.sh
./u_codespell/update.sh
