# vim:ft=perl
# Copyright (c) 2008-2012 Zmanda, Inc.  All Rights Reserved.
# Copyright (c) 2013-2016 Carbonite, Inc.  All Rights Reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# Contact information: Carbonite Inc., 756 N Pastoria Ave
# Sunnyvale, CA 94086, USA, or: http://www.zmanda.com

package Amanda::Constants;

=head1 NAME

Amanda::Constants - perl access to build-time configuration values

=head1 SYNOPSIS

  use Amanda::Constants;

  my $default_config = $Amanda::Constants::DEFAULT_CONFIG;

This package is a means of getting all of the necessary variables
provided by configure into Perl scripts, without a bunch of
boilerplate, and without requiring config.status substitution for
every .pm file.  

This module does not automatically export any of its values.

See the source for the list of constants available.

=cut

# the 'warnings' pragma doesn't recognized exported variables as "used", and generates warnings
# for variables only used once.  We turn it off for this module.
no warnings;

# (keep this list sorted in alphabetical order, for ease of updates)

$AIX_BACKUP = "";
$AMANDA_COMPONENTS = " server restore client amrecover rest-server";
$AMANDA_DEBUG_DAYS = "4";
$ASSERTIONS = "";
$BSDTAR = "/usr/bin/bsdtar";
$BSDTCP_SECURITY = "yes";
$BSDUDP_SECURITY = "yes";
$BSD_SECURITY = "yes";
$BUILT_BRANCH = "";
$BUILT_DATE = "";
$BUILT_REV = "";
$CC = "x86_64-pc-linux-gnu-gcc";
$CHECK_USERID = "1";
$CLIENT_LOGIN = "amanda";
$COMPRESS_BEST_OPT = "--best";
$COMPRESS_FAST_OPT = "--fast";
$COMPRESS_PATH = "/usr/bin/gzip";
$COMPRESS_SUFFIX = ".gz";
$DD = "/usr/bin/dd";
$DEFAULT_AMANDATES_FILE = "/var/spool/amanda/amanda/amandates";
$DEFAULT_CONFIG = "DailySet1";
$DEFAULT_SERVER = "binhost-amd64-x86-64-v3-openrc-23";
$DEFAULT_TAPE_DEVICE = "/dev/nst0";
$DEFAULT_TAPE_SERVER = "binhost-amd64-x86-64-v3-openrc-23";
$DUMP = "/bin/dump";
$DUMP_RETURNS_1 = "";
$FAILURE_CODE = "0";
$GNUTAR = "/usr/bin/gtar";
$HAVE_GZIP = "1";
$KRB5_SECURITY = "no";
$LOCKING = "LNLOCK";
$MAILER = "/usr/bin/mail";
$MT = "/bin/mt";
$MTX = "/usr/bin/mtx";
$MOUNT = "/usr/bin/mount";
$UMOUNT = "/usr/bin/umount";
$LPR = "/usr/bin/lpr";
$LPRFLAG = "-P";
$PS = "/usr/bin/ps";
$PS_ARGUMENT = "-eo pid,ppid,command";
$PS_ARGUMENT_ARGS = "-eo pid,ppid,command";
$REST_EXTENSIONS_DIR = "/usr/lib64/perl5/vendor_perl/5.40/Amanda/Rest/Amanda/bin/extensions";
$RESTORE = "/bin/restore";
$RSH_SECURITY = "no";
$SAMBA_CLIENT = "no";
$SSH_SECURITY = "yes";
$STAR = "/usr/bin/star";
$SUNTAR = "/usr/bin/gtar";
$UNCOMPRESS_OPT = "-dc";
$UNCOMPRESS_PATH = "/usr/bin/gzip";
$SORT_PATH = "/usr/bin/sort";
$USE_AMANDAHOSTS = "yes";
$USE_RUNDUMP = "";
$VDUMP = "";
$VERSION = "3.5.4";
$VERSION_MAJOR = "3";
$VERSION_MINOR = "5";
$VERSION_PATCH = "4";
$VERSION_COMMENT = "";
$VRESTORE = "";
$VXDUMP = "";
$VXRESTORE = "";
$XFSDUMP = "";
$XFSRESTORE = "";
$NC = "";
$NC6 = "";
$NETCAT = "";
$AMANDA_DEVICES = " file null rait tape dvdrw";
$SINGLE_USERID = "0";

# non-AC_SUBST'd constants

$DATA_FD_OFFSET = 150;
$DATA_FD_COUNT = 4;

1;
